/**
  ******************************************************************************
  * ļ  SCSI.c
  *     ChipON_AE/FAE_Group
  *     V3.0.0
  *     2021-08-23
  *     ļṩSCSIЭջز
  *
  *********************************************************************
  */
#include "usb.h"
#include"system_init.h"
uint8_t CBW[31];
uint8_t  CSW[13];
uint8_t * pEp2SendData;  //ϴָ
uint8_t * pEp2SendData_read10;
uint32_t Ep2DataLength;  //dataʱҪϴ´ֽ
uint8_t TransportStage;  //ǰ״̬
//˵2ݵĻ
uint8_t Ep2Buffer[EP2_BUFF_SIZE];
volatile uint32_t ByteAddr;  //ֽڵַ

/*INQUIRYҪص*/
const uint8_t DiskInf[36]=
{
 0x00, //豸
 0x00, //λD7ΪRMBRMB=0ʾƳ豸RMB=1ΪƳ豸
 0x00, //ְ汾0
 0x01, //Ӧʽ
 0x1F, //ݳȣΪ31ֽ
 0x00, //
 0x00, //
 0x00, //
 0x0,0x0,0X0,0x0,0x0,0x0,0x00,0x0, //̱ʶ

 //ƷʶΪַ
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00 //Ʒ汾ţΪ1.01
};


/*READ_FORMAT_CAPACITIESҪص*/
const uint8_t MaximumCapacity[12]=
{
 0x00, 0x00, 0x00, 			//
 0x08,  					//б
 0x00, 0x80, 0x00, 0x00,    //(֧8GB)
 0x03, 						//Ϊ3ʾֵ֧ĸʽ
 0x00, 0x04, 0x00 			//ÿСΪ1024ֽ
};

/*READ_CAPACITYҪص*/
const uint8_t DiskCapacity[8]=
{
	0x00,0x00,0x01,0x2b, //ܹʵ߼ַ  300k
	0x00,0x00,0x04,0x00  //ĳ
						 //Ըô̵Ϊ
						 //(0x012b+1)*0x400 = 0x4b000 =  300k.
};

//REQUEST SENSEҪصݣ̶ΪЧ
const uint8_t  SenseData[18]=
{
	0x70, //룬̶Ϊ0x70
	0x00, //
	0x05, //Sense KeyΪ0x05ʾЧILLEGAL REQUEST
	0x00, 0x00, 0x00, 0x00, //InformationΪ0
	0x0A, //ݳΪ10ֽ
	0x00, 0x00, 0x00, 0x00, //
	0x20, //Additional Sense Code(ASC)Ϊ0x20ʾЧ루INVALID COMMAND OPERATION CODE
	0x00, //Additional Sense Code Qualifier(ASCQ)Ϊ0
    0x00, 0x00, 0x00, 0x00 //
};

/********************************************************************
ܣCBWлȡݵֽ
ڲޡ
    أҪֽ
    עޡ
********************************************************************/
uint32_t GetDataTransferLength(void)
{
	uint32_t Len;
	//CBW[8]~CBW[11]Ϊ䳤ȣС˽ṹ
	Len=CBW[11];
	Len=Len*256+CBW[10];
	Len=Len*256+CBW[9];
	Len=Len*256+CBW[8];

	return Len;
}
////////////////////////End of function//////////////////////////////

/********************************************************************
ܣCBWлȡ߼ַLBAֽ
ڲޡ
    أ߼ַLBA
    עޡ
********************************************************************/
uint32_t GetLba(void)
{
 uint32_t Lba;

 //дʱCBW[17]~CBW[20]Ϊ߼ַ˽ṹ

 Lba=CBW[17];
 Lba=Lba*256+CBW[18];
 Lba=Lba*256+CBW[19];
 Lba=Lba*256+CBW[20];

 return Lba;
}
////////////////////////End of function//////////////////////////////

void usb_endp2_directly(void)
{
    uint8_t i,len0=0,len1=0;
    EP20_IN_table->STAT.UOWN     = 0;
    EP21_IN_table->STAT.UOWN     = 0;
	if(in_last==1)// дż
    {
		in_last=0;
		len0 = sizeof(CSW);
		// ݸƵ˵뻺
		for (i = 0; i < len0; i++)
		{
			ep20_in_buff->shuzu[i] = CSW[i];
		}

		// ɳ
		Ep2DataLength = 0;

		EP20_IN_table->ADR        = (uint16_t)(ep20_in_buff);
		EP20_IN_table->STAT.val  = 0;
		EP20_IN_table->STAT.DTS  = 0;
		EP20_IN_table->_data[1]           = len0;
		EP20_IN_table->STAT.DTSEN    = 1;
		EP20_IN_table->STAT.UOWN     = 1;

    }

	else if(in_last==0)//
    {
		// д˵ 
		in_last=1;
		len1 = sizeof(CSW);
		// ݸƵ˵뻺

		for (i = 0; i < len1; i++)
		{
			ep21_in_buff->shuzu[i] = CSW[i];
		}

		// ɳ
		Ep2DataLength = 0;

		EP21_IN_table->ADR        = (uint16_t)(ep21_in_buff);
		EP21_IN_table->STAT.val  = 0;
		EP21_IN_table->STAT.DTS  = 1;
		EP21_IN_table->_data[1]           = len1;
		EP21_IN_table->STAT.DTSEN    = 1;
		EP21_IN_table->STAT.UOWN     = 1;

    }

}

/********************************************************************
ܣCSW
ڲResidueʣֽStatusִе״̬
    أޡ
    עޡ
********************************************************************/
void SetCsw(uint32_t Residue, uint8_t Status)
{
 //CSWǩʵԲÿζõģ
 //ʼʼһξˣÿζ
 CSW[0]=0x55;
 CSW[1]=0x53;
 CSW[2]=0x42;
 CSW[3]=0x53;

 //dCBWTagCSWdCSWTagȥ
 CSW[4]=CBW[4];
 CSW[5]=CBW[5];
 CSW[6]=CBW[6];
 CSW[7]=CBW[7];

 //ʣֽ
 CSW[8]=Residue&0xFF;
 CSW[9]=(Residue>>8)&0xFF;
 CSW[10]=(Residue>>16)&0xFF;
 CSW[11]=(Residue>>24)&0xFF;

 //ִе״̬0ʾɹ1ʾʧܡ
 CSW[12]=Status;
}
////////////////////////End of function//////////////////////////////


uint8_t usb_endp2_send_read10(void)
{

    uint8_t i, len=0;


    // ݳȲܴڶ˵ 
    // ֻܷһλ
	if(usbStateStruct.m_BDPointer==1)
	{
		in_last=0;
		if (Ep2DataLength > EP2_BUFF_SIZE)
		{
			// ݷ
			len = EP2_BUFF_SIZE;
			for (i = 0; i < len; i++)
			{

				ep20_in_buff->shuzu[i]=FLASH_ReadByte((uint32_t *)pEp2SendData_read10++);
			}
			Ep2DataLength = Ep2DataLength - EP2_BUFF_SIZE;

		}
		else
		{
			len = (uint8_t)(Ep2DataLength & 0xff);
			for (i = 0; i < len; i++)
			{
				ep20_in_buff->shuzu[i]=FLASH_ReadByte((uint32_t *)pEp2SendData_read10++);
			}
			Ep2DataLength = 0;
		}

		EP20_IN_table->ADR        = (uint16_t)(ep20_in_buff);
		EP20_IN_table->STAT.val  = 0;
		EP20_IN_table->STAT.DTS  = 0;
		EP20_IN_table->_data[1]           = len;
		EP20_IN_table->STAT.DTSEN    = 1;
		EP20_IN_table->STAT.UOWN     = 1;

	}

	else if(usbStateStruct.m_BDPointer==0)
	{
		in_last=1;
		if (Ep2DataLength > EP2_BUFF_SIZE)
		 {
			 // ݷ
			 len = EP2_BUFF_SIZE;
			for (i = 0; i < len; i++)
			{
				ep21_in_buff->shuzu[i]=FLASH_ReadByte((uint32_t *)pEp2SendData_read10++);
			}
			 Ep2DataLength = Ep2DataLength - EP2_BUFF_SIZE;

		 }
		 else
		 {
			 len = (uint8_t)(Ep2DataLength & 0xff);
			for (i = 0; i < len; i++)
			{
				ep21_in_buff->shuzu[i]=FLASH_ReadByte((uint32_t *)pEp2SendData_read10++);
			}
			 Ep2DataLength = 0;
		 }

		EP21_IN_table->ADR        = (uint16_t)(ep21_in_buff);
		EP21_IN_table->STAT.val  = 0;
		EP21_IN_table->STAT.DTS  = 1;
		EP21_IN_table->_data[1]           = len;
		EP21_IN_table->STAT.DTSEN    = 1;
		EP21_IN_table->STAT.UOWN     = 1;

	}

	return len;



}
uint8_t usb_endp2_send(void)
{
    uint8_t i, len=0;

    // ݳȲܴڶ˵ 
    // ֻܷһλ
	if(usbStateStruct.m_BDPointer==1)
	{
		in_last=0;
		if (Ep2DataLength > EP2_BUFF_SIZE)
		{
			// ݷ
			len = EP2_BUFF_SIZE;
			for (i = 0; i < len; i++)
			{
				ep20_in_buff->shuzu[i] = *pEp2SendData++;
			}
			Ep2DataLength = Ep2DataLength - EP2_BUFF_SIZE;

		}
		else
		{
			len = (uint8_t)(Ep2DataLength & 0xff);
			for (i = 0; i < len; i++)
			{
				ep20_in_buff->shuzu[i] = *pEp2SendData++;
			}
			Ep2DataLength = 0;
		}

		EP20_IN_table->ADR        = (uint16_t)(ep20_in_buff);
		EP20_IN_table->STAT.val  = 0;
		EP20_IN_table->STAT.DTS  = 0;
		EP20_IN_table->_data[1]           = len;
		EP20_IN_table->STAT.DTSEN    = 1;
		EP20_IN_table->STAT.UOWN     = 1;
	}

	else if(usbStateStruct.m_BDPointer==0)
	{
		in_last=1;
		if (Ep2DataLength > EP2_BUFF_SIZE)
		 {
			 // ݷ
			 len = EP2_BUFF_SIZE;
			for (i = 0; i < len; i++)
			{
				ep21_in_buff->shuzu[i] = *pEp2SendData++;
			}
			 Ep2DataLength = Ep2DataLength - EP2_BUFF_SIZE;

		 }
		 else
		 {
			 len = (uint8_t)(Ep2DataLength & 0xff);
			for (i = 0; i < len; i++)
			{
				ep21_in_buff->shuzu[i] = *pEp2SendData++;
			}
			 Ep2DataLength = 0;
		 }

		EP21_IN_table->ADR        = (uint16_t)(ep21_in_buff);
		EP21_IN_table->STAT.val  = 0;
		EP21_IN_table->STAT.DTS  = 1;
		EP21_IN_table->_data[1]           = len;
		EP21_IN_table->STAT.DTSEN    = 1;
		EP21_IN_table->STAT.UOWN     = 1;
	}

	return len;
}



void usb_endp2_input(void)
{
    uint8_t len;
if(CBW[15]==READ_10)
{

    if(Ep2DataLength==0)
    {
		if(TransportStage==DATA_STAGE)
		{
			 Ep2DataLength=sizeof(CSW); //ݳΪCSWĴС
			 pEp2SendData=CSW; //صΪCSW
			 TransportStage=COMMAND_STAGE;
			 len  = usb_endp2_send();
		}
		else if(TransportStage==STATUS_STAGE)
		{
			 TransportStage=COMMAND_STAGE;

		}
    }
    // д˵ 

    else   len  = usb_endp2_send_read10();
}
else
{
    if(Ep2DataLength==0)
    {
		if(TransportStage==DATA_STAGE)
		{
			 Ep2DataLength=sizeof(CSW); //ݳΪCSWĴС
			 pEp2SendData=CSW; //صΪCSW
			 TransportStage=COMMAND_STAGE;
			 len  = usb_endp2_send();
		}
		else if(TransportStage==STATUS_STAGE)
		{
			 TransportStage=COMMAND_STAGE;
		}
    }
    // д˵ 
    else len  = usb_endp2_send();
}

}


void usb_endp2_inputfrist_read10(void)
{

    uint8_t len0=0;
    uint8_t len1=0;
    uint8_t i;
    EP20_IN_table->STAT.UOWN     = 0;
    EP21_IN_table->STAT.UOWN     = 0;
    if(in_last==1)// дżд棻
    {
		// д˵ 
		if (Ep2DataLength > EP2_BUFF_SIZE)
		{
			// ݷ
			len0 = EP2_BUFF_SIZE;

			// ݸƵ˵0 뻺

			for (i = 0; i < len0; i++)
			{
				ep20_in_buff->shuzu[i]=FLASH_ReadByte((uint32_t *)pEp2SendData_read10++);
			}
			// ʣݳ
			Ep2DataLength = Ep2DataLength - EP2_BUFF_SIZE;

		}

		// ݳСڻ
		// ͵ݳȵʣ೤
		else
		{
			len0 = (uint8_t)(Ep2DataLength & 0xff);
			// ݸƵ˵뻺

				for (i = 0; i < len0; i++)
				{
					ep20_in_buff->shuzu[i]=FLASH_ReadByte((uint32_t *)pEp2SendData_read10++);
				}

			// ɳ
			Ep2DataLength = 0;

		}
	    EP20_IN_table->ADR        = (uint16_t)(ep20_in_buff);
		EP20_IN_table->STAT.val  = 0;
		EP20_IN_table->STAT.DTS  = 0;
		EP20_IN_table->_data[1]           = len0;
		EP20_IN_table->STAT.DTSEN    = 1;
		EP20_IN_table->STAT.UOWN     = 1;
    }

    else if(in_last==0)//
    {
		// д˵ 
		if (Ep2DataLength > EP2_BUFF_SIZE)
		{
			// ݷ
			len1 = EP2_BUFF_SIZE;

			// ݸƵ˵0 뻺

			for (i = 0; i < len1; i++)
			{
				ep21_in_buff->shuzu[i]=FLASH_ReadByte((uint32_t *)pEp2SendData_read10++);
			}
			// ʣݳ
			Ep2DataLength = Ep2DataLength - EP2_BUFF_SIZE;

		}

		// ݳСڻ
		// ͵ݳȵʣ೤
		else
		{
			len1 = (uint8_t)(Ep2DataLength & 0xff);
			// ݸƵ˵뻺

				for (i = 0; i < len1; i++)
				{
					ep21_in_buff->shuzu[i]=FLASH_ReadByte((uint32_t *)pEp2SendData_read10++);
				}

			// ɳ
			Ep2DataLength = 0;

		}
			EP21_IN_table->ADR        = (uint16_t)(ep21_in_buff);
			EP21_IN_table->STAT.val  = 0;
			EP21_IN_table->STAT.DTS  = 1;
			EP21_IN_table->_data[1]           = len1;
			EP21_IN_table->STAT.DTSEN    = 1;
			EP21_IN_table->STAT.UOWN     = 1;
    }
}

void usb_endp2_inputfrist(void)
{
    uint8_t len0=0;
    uint8_t len1=0;
    uint8_t i;
    EP20_IN_table->STAT.UOWN     = 0;
    EP21_IN_table->STAT.UOWN     = 0;
    if(in_last==1)// дżд棻
    {
		// д˵ 
		if (Ep2DataLength > EP2_BUFF_SIZE)
		{
			// ݷ
			len0 = EP2_BUFF_SIZE;

			// ݸƵ˵0 뻺

			for (i = 0; i < len0; i++)
			{
				ep20_in_buff->shuzu[i] = *pEp2SendData++;
			}
			// ʣݳ
			Ep2DataLength = Ep2DataLength - EP2_BUFF_SIZE;

		}

		// ݳСڻ
		// ͵ݳȵʣ೤
		else
		{
			len0 = (uint8_t)(Ep2DataLength & 0xff);
			// ݸƵ˵뻺

				for (i = 0; i < len0; i++)
				{
					ep20_in_buff->shuzu[i] = *pEp2SendData++;
				}

			// ɳ
			Ep2DataLength = 0;

		}
	    EP20_IN_table->ADR        = (uint16_t)(ep20_in_buff);
		EP20_IN_table->STAT.val  = 0;
		EP20_IN_table->STAT.DTS  = 0;
		EP20_IN_table->_data[1]           = len0;
		EP20_IN_table->STAT.DTSEN    = 1;
		EP20_IN_table->STAT.UOWN     = 1;

    }

    else if(in_last==0)//
    {
		// д˵ 
		if (Ep2DataLength > EP2_BUFF_SIZE)
		{
			// ݷ
			len1 = EP2_BUFF_SIZE;

			// ݸƵ˵0 뻺

			for (i = 0; i < len1; i++)
			{
				ep21_in_buff->shuzu[i] = *pEp2SendData++;
			}
			// ʣݳ
			Ep2DataLength = Ep2DataLength - EP2_BUFF_SIZE;

		}

		// ݳСڻ
		// ͵ݳȵʣ೤
		else
		{
			len1 = (uint8_t)(Ep2DataLength & 0xff);
			// ݸƵ˵뻺

				for (i = 0; i < len1; i++)
				{
					ep21_in_buff->shuzu[i] = *pEp2SendData++;
				}

				len0=sizeof(CSW); //ݳΪCSWĴС

			// ɳ
			Ep2DataLength = 0;


		}
		EP21_IN_table->ADR        = (uint16_t)(ep21_in_buff);
		EP21_IN_table->STAT.val  = 0;
		EP21_IN_table->STAT.DTS  = 1;
		EP21_IN_table->_data[1]           = len1;
		EP21_IN_table->STAT.DTSEN    = 1;
		EP21_IN_table->STAT.UOWN     = 1;

    }

}

/********************************************************************
ܣSCSIĺ
ڲޡ
    أޡ
    עȻSCSIʵʹõUFI
********************************************************************/
void ProcScsiCommand(void)
{
	 TransportStage=DATA_STAGE; //뵽ݽ׶

	 //CBWƫΪ15ֶΪ
	 switch(CBW[15])
	 {
	  case INQUIRY:  //INQUIRY
	   pEp2SendData=(uint8_t *)DiskInf; //شϢ
	   Ep2DataLength=GetDataTransferLength(); //ȡҪصĳ
	   SetCsw(Ep2DataLength-sizeof(DiskInf),0); //ʣֽԼ״̬ɹ
	   if(Ep2DataLength>sizeof(DiskInf)) //ݱʵʵҪ
	   {
		Ep2DataLength=sizeof(DiskInf); //ֻʵʵĳ
	   }
	   usb_endp2_inputfrist();
	  break;

	  case READ_FORMAT_CAPACITIES: //ʽ
	   pEp2SendData=(uint8_t *)MaximumCapacity; //ʽϢ
	   Ep2DataLength=GetDataTransferLength(); //ȡҪصĳ
	   SetCsw(Ep2DataLength-sizeof(MaximumCapacity),0); //ʣֽԼ״̬ɹ
	   if(Ep2DataLength>sizeof(MaximumCapacity)) //ݱʵʵҪ
	   {
		Ep2DataLength=sizeof(MaximumCapacity); //ֻʵʵĳ
	   }
	   usb_endp2_inputfrist();
	  break;

	  case READ_CAPACITY: //
	   pEp2SendData=(uint8_t *)DiskCapacity; //ش
	   Ep2DataLength=GetDataTransferLength(); //ȡҪصĳ
	   SetCsw(Ep2DataLength-sizeof(DiskCapacity),0); //ʣֽԼ״̬ɹ
	   if(Ep2DataLength>sizeof(DiskCapacity)) //ݱʵʵҪ
	   {
		Ep2DataLength=sizeof(DiskCapacity); //ֻʵʵĳ
	   }
	   usb_endp2_inputfrist();
	  break;

	  case READ_10: //READ(10)

	   Ep2DataLength=GetDataTransferLength(); //ȡҪصĳ
	   ByteAddr=GetLba()*FLASH_SECTOR_SIZE; //ȡֽڵַֽڵַΪ߼ַÿС
	   pEp2SendData_read10=(uint8_t *)ByteAddr;
	   SetCsw(0,0); //ʣֽΪ0״̬ɹ
	   usb_endp2_inputfrist_read10();
	  break;

	  case WRITE_10: //WRITE(10)
	   Ep2DataLength=GetDataTransferLength(); //ȡҪصĳ
	   ByteAddr=GetLba()*FLASH_SECTOR_SIZE;
	   SetCsw(0,0); //ʣֽΪ0״̬ɹ
	  break;

	  case REQUEST_SENSE: //ѯǰһִʧܵԭ
	   pEp2SendData=(uint8_t *)SenseData; //̽
	   Ep2DataLength=GetDataTransferLength(); //ȡҪصĳ
	   SetCsw(Ep2DataLength-sizeof(SenseData),0); //ʣֽԼ״̬ɹ
	   if(Ep2DataLength>sizeof(SenseData)) //ݱʵʵҪ
	   {
		Ep2DataLength=sizeof(SenseData); //ֻʵʵĳ
	   }
	   usb_endp2_inputfrist();
	  break;

	  case TEST_UNIT_READY: //ԴǷ׼
	   SetCsw(0,0); //CSWΪɹ
	   TransportStage=COMMAND_STAGE;
	   usb_endp2_directly();
	  break;

	  default: //ϣִʧ

	   if(CBW[12]&0x80)
		   {
		   	   Ep2DataLength=1; //Ϊ㷵1ֽ
		   	   SetCsw(GetDataTransferLength()-Ep2DataLength,1); //CSWΪʧ
		   	   usb_endp2_inputfrist();
		   }
	   else  //ΪóΪ0ֱӷCSW
		   {
		   	   SetCsw(GetDataTransferLength()-Ep2DataLength,1); //CSWΪʧ
		   	   TransportStage=COMMAND_STAGE;

		   	   usb_endp2_directly();
		   }

	  break;
	 }

}


////////////////////////End of function//////////////////////////////


