/**
  ******************************************************************************
  * ļ  USB_user.h
  *     ChipON_AE/FAE_Group
  *     V3.0.0
  *     2021-08-23
  *     ļṩUSBЭеض
  *
  *********************************************************************
  */
#ifndef _USB_H_
#define _USB_H_

//#include <stdint.h>

// ׼
#define GET_STATUS                0x00      // ȡ״̬
#define CLR_FEATURE               0x01      // 
#define SET_FEATURE               0x03      // 
#define SET_ADDRESS               0x05      // õַ
#define GET_DESCRIPTOR            0x06      // ȡ
#define SET_DESCRIPTOR            0x07      // 
#define GET_CONFIG                0x08      // ȡ
#define SET_CONFIG                0x09      // 
#define GET_INTERFACE             0x0a      // ȡýӿ
#define SET_INTERFACE             0x0b      // ýӿ
#define SYNCH_FRAME               0x0c      //   ͬ֡

// 
#define DEVICE_DESCRIPTOR         0x01      // 豸
#define CONFIG_DESCRIPTOR         0x02      // 
#define STRING_DESCRIPTOR         0x03      // ַ
#define INTERFACE_DESCRIPTOR      0x04      // ӿ
#define ENDPOINT_DESCRIPTOR       0x05      // ˵
#define REPORT_DESCRIPTOR         0x22      // 

// 
#define EP0_BUFF_SIZE             16
#define EP2_BUFF_SIZE             16

// SETUP ưṹ
typedef union
{
    struct
    {
        unsigned :8;
        unsigned :8;
        uint16_t w_value;
        uint16_t w_index;
        uint16_t w_length;
    };

    struct
    {
        uint8_t bm_request_type;
        uint8_t b_request;
        uint8_t w_value_l;
        uint8_t w_value_h;
        uint8_t w_index_l;
        uint8_t w_index_h;
        uint8_t w_length_l;
        uint8_t w_length_h;
    };

    uint8_t buff[8];

}SETUP_PKT;

// BDT ״̬ṹ
typedef union
{
    struct
    {
        unsigned        :2;
        unsigned BSTALL :1;
        unsigned DTSEN  :1;
        unsigned        :1;
        unsigned        :1;
        unsigned DTS    :1;  //   ͬ
        unsigned        :1;
    };

    struct
    {
        unsigned BC8    :1;
        unsigned BC9    :1;
        unsigned PID    :4;
        unsigned        :1;
        unsigned UOWN   :1;  // BDT Ȩ
    };

    uint8_t val;

}BD_STAT;

// BDT Ŀṹ
typedef union
{
    struct
    {
        BD_STAT STAT;        // BDT ״̬
        uint8_t       CNT;        // ֽڼ
        uint8_t      ADRL;
        uint8_t      ADRH;
    };

    struct
    {
        unsigned :8;
        unsigned :8;
        uint16_t     ADR;         // ַָ
    };

    uint8_t _data[4];

}BDT_ENTRY;

typedef struct
{
//	unsigned char		DATA0;
//	unsigned char       DATA1;
//	unsigned char       DATA2;
//	unsigned char       DATA3;
//	unsigned char		DATA4;
//	unsigned char       DATA5;
//	unsigned char       DATA6;
//	unsigned char       DATA7;
	unsigned char shuzu[8];
}num;

/* ƣusb_endp2_input()
 * 
 * 
 * ˵1 ݸ
 */
extern void usb_endp2_input(void);

/* ƣusb_endp2_output()
 * 
 * 
 * ˵1 
 */
extern void usb_endp2_output(void);

/* ƣusb_endp2_enable()
 * 
 * 
 * ʹܶ˵2 ʼ
 */
extern void usb_endp2_enable(void);

/* ƣusb_endp0_send()
 * 
 * ݳ
 * ݵ˵0 
 */
extern uint8_t usb_endp0_send(void);

/* ƣusb_endp0_input()
 * 
 * 
 * ˵0 ݸ
 */
extern void usb_endp0_input(void);

/* ƣusb_endp0_output()
 * 
 * 
 * ˵0 
 */
extern void usb_endp0_output(void);

/* ƣusb_endp0_setup()
 * 
 * 
 * SETUP ư
 */
extern void usb_endp0_setup(void);

/* ƣusb_endp_table_int()
 * 
 * 
 * USB ˵ʼ
 */
extern void usb_endp_table_int(void);

/* ƣusb_module_init()
 * 
 * 
 * USB ģϵʹ
 */
extern void usb_module_init(void);

/* ƣusb_endp1_resolve()
 * 
 * 
 * USB ˵ݴ
 */
extern void usb_endp2_resolve(void);

/* ƣusb_event_poll()
 * 
 * 
 * USB ¼ѯ
 */
extern void usb_event_poll(void);


#endif  // _USB_H_
