/**
  ******************************************************************************
  * ļ  USB_user.c
  *     ChipON_AE/FAE_Group
  *     V3.0.0
  *     2021-08-23
  *     ļṩUSBӦô
  *
  *********************************************************************
  */
#include "system_init.h"
#include "USB_conf.h"
#include "USB_user.h"
// ˵㻺
// Զλ

#define EP0_OUT_table                       ((BDT_ENTRY *) 0x1FFEFC00)
#define EP0_IN_table                        ((BDT_ENTRY *) 0x1FFEFC04)
#define EP2_OUT_table                       ((BDT_ENTRY *) 0x1FFEFC10)
#define EP2_IN_table                        ((BDT_ENTRY *) 0x1FFEFC14)
// ˵㻺
// Զλ
#define setup_ADD                      ((uint32_t)0x1FFEFC20)
#define setup                       ((SETUP_PKT *) setup_ADD)
#define ep0_out_buff    ((num *) 0x1FFEFC20)
#define ep0_in_buff    ((num *) 0x1FFEFC30)
#define ep2_out_buff    ((num *) 0x1FFEFC40)
#define ep2_in_buff    ((num *) 0x1FFEFC50)



const  uint8_t *send_dat    = 0;            // ָ
static uint16_t send_len    = 0;            // ݷͳ
static uint8_t usb_addr     = 0;            // USB 豸ַ
static int8_t config_val = FALSE;        // USB 豸
uint8_t j;
void usb_endp2_input(void)
{
	EP2_IN_table->ADR        = (uint16_t)(ep2_in_buff->shuzu);//?
    // ö˵1 
    if (EP2_IN_table->STAT.DTS)
    {
        EP2_IN_table->STAT.val = 0;
        EP2_IN_table->STAT.DTS = 0;
    }

    else
    {
        EP2_IN_table->STAT.val = 0;
        EP2_IN_table->STAT.DTS = 1;
    }

    // HID ̵ı泤Ϊ8 ֽ
    EP2_IN_table->_data[1]          = 8;
    EP2_IN_table->STAT.DTSEN   = 1;
    EP2_IN_table->STAT.UOWN    = 1;

}

void usb_endp2_output(void)
{
	EP2_OUT_table->ADR        = (uint16_t)(ep2_out_buff->shuzu);//?
    // ö˵1 
    if (EP2_OUT_table->STAT.DTS)
    {
        EP2_OUT_table->STAT.val = 0;
        EP2_OUT_table->STAT.DTS = 0;
    }

    else
    {
        EP2_OUT_table->STAT.val = 0;
        EP2_OUT_table->STAT.DTS = 1;
    }

    EP2_OUT_table->_data[1]          = EP2_BUFF_SIZE;
    EP2_OUT_table->STAT.DTSEN   = 1;
    EP2_OUT_table->STAT.UOWN    = 1;
}

void usb_endp2_enable(void)
{
    EP2_OUT_table->ADR        = (uint16_t)(ep2_out_buff->shuzu);//?
    EP2_OUT_table->_data[1]       = EP2_BUFF_SIZE;
    EP2_OUT_table->STAT.val   = 0;
    EP2_OUT_table->STAT.DTSEN = 1;
    EP2_OUT_table->STAT.UOWN  = 1;           // SIE ӵпȨ

    EP2_IN_table->ADR         = (uint16_t)(ep2_in_buff->shuzu);//?
    EP2_IN_table->STAT.val    = 0;           // CPU ӵпȨ

    USB_UEP2   = 0x00000000;
    // ʹܶ˵
    USB_Endpoint_Handshake_Enable(USB_ENDPOINT_2,TRUE);
//    EPCONDIS1  = 1;                 // IN/OUT
    USB_Bidirectional_Endpoint_Enable(USB_ENDPOINT_2,FALSE);
//    EPOUTEN1   = 1;                 // ʹܶ˵2 
    USB_Endpoint_Output_Enable(USB_ENDPOINT_2,TRUE);
//    EPINEN1    = 1;                 // ʹܶ˵2 
    USB_Endpoint_Input_Enable(USB_ENDPOINT_2,TRUE);

    ep2_in_buff->shuzu[0] = 0x00;
    ep2_in_buff->shuzu[1] = 0x00;
    ep2_in_buff->shuzu[2] = 0x00;
    ep2_in_buff->shuzu[3] = 0x00;

    ep2_in_buff->shuzu[4] = 0x08;
    ep2_in_buff->shuzu[5] = 0x00;
    ep2_in_buff->shuzu[6] = 0x00;
    ep2_in_buff->shuzu[7] = 0x00;

    if (EP2_IN_table->STAT.DTS)
    {
        EP2_IN_table->STAT.val = 0;
        EP2_IN_table->STAT.DTS = 0;
    }

    else
    {
        EP2_IN_table->STAT.val = 0;
        EP2_IN_table->STAT.DTS = 1;
    }

    EP2_IN_table->_data[1]          = 8;
    EP2_IN_table->STAT.DTSEN   = 1;
    EP2_IN_table->STAT.UOWN    = 1;
}

uint8_t usb_endp0_send(void)
{
    uint8_t i, len;
    EP0_IN_table->STAT.UOWN     = 0;
    // ݳȲܴڶ˵0 
    // ֻܷһλ
    if (send_len > EP0_BUFF_SIZE)
    {
        // ݷ
        len = EP0_BUFF_SIZE;

        // ʣݳ
        send_len = send_len - EP0_BUFF_SIZE;
    }

    // ݳСڻ
    // ͵ݳȵʣ೤
    else
    {
        len = (uint8_t)(send_len & 0xff);

        // ɳ
        send_len = 0;
    }

    // ݸƵ˵0 뻺
    EP0_OUT_table->ADR        = (uint16_t)(ep0_out_buff->shuzu);//?
    EP0_IN_table->ADR         = (uint16_t)(ep0_in_buff->shuzu);//?
    EP0_IN_table->_data[1]      = len;
    EP0_IN_table->STAT.DTSEN    = 1;
    if (EP0_IN_table->STAT.DTS)
     {
         EP0_IN_table->STAT.val  = 0;
         EP0_IN_table->STAT.DTS  = 0;
     }

     else
     {
         EP0_IN_table->STAT.val  = 0;
         EP0_IN_table->STAT.DTS  = 1;
     }
//    EP0_IN_table->STAT.UOWN     = 1;
    for (i = 0; i < len; i++)
    {
//        ep0_in_buff[i] = *send_dat++;
    	ep0_in_buff->shuzu[i] =*send_dat++;
    }

    return len;
}

void usb_endp0_input(void)
{
    uint8_t len;


    // д˵0 
    len   = usb_endp0_send();

    // USB 豸Эַ
    USB_UADDR = usb_addr;

    // ö˵0 
//    if (EP0_IN_table->STAT.DTS)
//    {
//        EP0_IN_table->STAT.val  = 0;
//        EP0_IN_table->STAT.DTS  = 0;
//    }
//
//    else
//    {
//        EP0_IN_table->STAT.val  = 0;
//        EP0_IN_table->STAT.DTS  = 1;
//    }
//
    EP0_IN_table->_data[1]      = len;
    EP0_IN_table->STAT.DTSEN    = 1;
    EP0_IN_table->STAT.UOWN     = 1;

}

void usb_endp0_output(void)
{
	EP0_OUT_table->STAT.UOWN = 0;
	EP0_OUT_table->ADR        = (uint16_t)(ep0_out_buff->shuzu);//?
    // ö˵0 
    if (EP0_OUT_table->STAT.DTS)
    {
        EP0_OUT_table->STAT.val = 0;
        EP0_OUT_table->STAT.DTS = 0;
    }

    else
    {
        EP0_OUT_table->STAT.val = 0;
        EP0_OUT_table->STAT.DTS = 1;
    }

    EP0_OUT_table->_data[1]          = EP0_BUFF_SIZE;
    EP0_OUT_table->STAT.DTSEN   = 1;
    EP0_OUT_table->STAT.UOWN    = 1;
}

void usb_endp0_setup(void)
{
    uint8_t len;
    switch (setup->b_request)
    {
        // ȡ
        case GET_DESCRIPTOR:

            // w_value ָֽ
            switch (setup->w_value_h)
            {
                // ȡ豸
                case DEVICE_DESCRIPTOR:

                    // ݳȴ豸
                    // ֻ豸ȵЧ
                    if (setup->w_length > sizeof(device_descriptor))
                    {
                        send_len = sizeof(device_descriptor);
                    }

                    // ֻݳȵЧ
                    else
                    {
                        send_len = setup->w_length;
                    }

                    // ָ豸ڻַ
                    send_dat = device_descriptor;

                    break;

                // ȡ
                case CONFIG_DESCRIPTOR:
//                  	while(1)
//                  	{
//                  		GPIO_Toggle_Output_Data_Config(GPIOA_SFR,GPIO_PIN_MASK_8);
//                  	}
                    // ݳȴ
                    // ֻȵЧ
                    if (setup->w_length > sizeof(configuration_descriptor))
                    {
                        send_len = sizeof(configuration_descriptor);
                    }

                    // ֻݳȵЧ
                    else
                    {
                        send_len = setup->w_length;
                    }

                    // ָڻַ
                    send_dat = configuration_descriptor;

                    break;

                // ȡ
                case REPORT_DESCRIPTOR:

                    // ݳȴ豸
                    // ֻ豸ȵЧ
                    if (setup->w_length > sizeof(report_descriptor))
                    {
                        send_len = sizeof(report_descriptor);
                    }

                    // ֻݳȵЧ
                    else
                    {
                        send_len = setup->w_length;
                    }

                    // ָرڻַ
                    send_dat = report_descriptor;

                    break;

                // ȡַ
                case STRING_DESCRIPTOR:

                    // w_value ֵַָֽ
                    switch (setup->w_value_l)
                    {
                        // ȡID
                        case 0:

                            // ID ݳ ָ
                            send_len = sizeof(language_id);
                            send_dat = language_id;

                            break;

                        // ȡƷַ
                        case 2:

                            // زƷַ ݳ ָ
                            send_len = sizeof(product_string_descriptor);
                            send_dat = product_string_descriptor;

                            break;

                        // δֵ֪
                        default:

                            // һ㳤ȵݰ
                            send_len = 0;

                            break;
                    }

                    // ݳС
                    // ֻݳȵЧ
                    if (setup->w_length < send_len)
                    {
                        send_len = setup->w_length;
                    }

                    break;

                // ûж
                default:

                    // ˵0 һ㳤ȵݰ
                    send_len = 0;

                    break;
            }

            break;

        // ַ豸
        case SET_ADDRESS:
            // w_value ĵֵַָֽ
            if (setup->w_value_l)
            {
                usb_addr = setup->w_value_l;
            }

            // ˵0 һ㳤ȵݰ
            send_len = 0;

            break;

        // ø豸
        case SET_CONFIG:

            // w_value ĵָֽõֵ
            // ֵʹܷ˵
            if (setup->w_value_l)
            {
            	config_val = TRUE;
            	usb_endp2_enable();
            }

            // ˵0 һ㳤ȵݰ
            send_len = 0;

            break;
        // δ
        default:

            // ˵0 һ㳤ȵݰ
            send_len = 0;

            break;
    }

    // д˵0 
    len = usb_endp0_send();

    // ö˵0 
    EP0_IN_table->_data[1]         = len;
    EP0_IN_table->STAT.val    = 0;
    EP0_IN_table->STAT.DTS    = 1;
    EP0_IN_table->STAT.DTSEN  = 1;
    EP0_IN_table->STAT.UOWN   = 1;

    // ö˵0 
    EP0_OUT_table->_data[1]        = EP0_BUFF_SIZE;
    EP0_OUT_table->STAT.val   = 0;
    EP0_OUT_table->STAT.DTS   = 1;
    EP0_OUT_table->STAT.DTSEN = 1;
    EP0_OUT_table->STAT.UOWN  = 1;
}

void usb_endp_table_int(void)
{
//	asm(
//		"	MOV R1,#0X1FFEFC00	"	"\n"//ַ
//		"	MOV R2,#0X00000000	"	"\n"
//		"	ST.W [R1],R2		"	"\n"
//		"	ST.W [R1+#1],R2"
//	);

	EP0_OUT_table->ADR        = (uint16_t)(ep0_out_buff->shuzu);//?
    EP0_OUT_table->STAT.val   = 0;
    EP0_OUT_table->STAT.DTSEN = 1;
    EP0_OUT_table->STAT.UOWN  = 1;           // SIE ӵпȨ
    EP0_OUT_table->_data[1]        = 8;

    EP0_IN_table->ADR         = (uint16_t)(ep0_in_buff->shuzu);//?
    EP0_IN_table->STAT.val    = 0;           // CPU ӵпȨ
    EP0_IN_table->STAT.DTSEN = 1;
	EP0_IN_table->STAT.UOWN  = 0;           // SIE ӵпȨ
	EP0_IN_table->_data[1]        = 8;

//    EP1_OUT_table->STAT.val   = 0;
//    EP1_IN_table->STAT.val    = 0;
}

void usb_module_init(void)
{
    // ˵ʼ
    usb_endp_table_int();
    USB_UCON = 0x00000000;
    // ģʽ
    USB_Speed_Config(USB_FULL_SPEED);
    // ʹ
    USB_On_Chip_Pull_Up_Enable(TRUE);
    // USB ģʹ
    USB_Cmd(TRUE);
    USB_UDB = 0X00000010;

//    USB_UEP0 = 0x00000000;
   	// ʹܶ˵
   	USB_Endpoint_Handshake_Enable(USB_ENDPOINT_0,TRUE);
   	// ʹSETUP ư
   	USB_Bidirectional_Endpoint_Enable(USB_ENDPOINT_0,TRUE);
   	// ʹܶ˵0 
   	USB_Endpoint_Output_Enable(USB_ENDPOINT_0,TRUE);
   	// ʹܶ˵0 
   	USB_Endpoint_Input_Enable(USB_ENDPOINT_0,TRUE);
    // USBжϱ־
    USB_UIR = 0X00000000;
    // λUSBж
    USB_UIE = 0X00000000;
    // λж
    USB_Set_INT_Enable(USB_INT_RESET,TRUE);
}


void usb_event_poll(void)
{
    static uint16_t led_time = 0;
    USB_StateTypeDef usbStateStruct;

    if (USB_Get_INT_Flag(USB_INT_RESET))                     //   USB ߸λ
       {

//			while (USB_Get_INT_Flag(USB_INT_TRANSACTION_COMPLETED))               // δ
//           {
				USB_Clear_INT_Flag(USB_INT_TRANSACTION_COMPLETED);
//           }
			USB_Clear_INT_Flag(USB_INT_RESET);

			// еĴжϱ־ , USBжϱ־
			USB_UIR  = 0X00000000;
			// USBж,жUSBж
			USB_UIE = 0X00003F77;

            // SETUP 
		    USB_Clear_Package_Transmit_Flag();
		    // USB Ĭϵַ
		    USB_Address_Config(0);
           config_val = FALSE;
           usb_endp_table_int();     // ˵
       }

    if (USB_Get_INT_Flag(USB_INT_TRANSACTION_COMPLETED))
    {
    	USB_Get_Arrangement_State(&usbStateStruct);
        switch ( usbStateStruct.m_EndPoint)
        {

            case 0:
                if (usbStateStruct.m_BDDirection)
                {
                    usb_endp0_input();      // ˵0 

                }

                else if (USB_Get_Package_Transmit_Flag())
                {
                	USB_Clear_Package_Transmit_Flag();    // SETUP 
                    usb_endp0_setup();      //   SETUP ư

                }

                else
                {
                    usb_endp0_output();     // ˵0 
                }

                break;

            case 2:
                if (usbStateStruct.m_BDDirection)
                {
                	usb_endp2_input();      // ˵2 
                }

                else
                {
                    usb_endp2_output();     // ˵2 
                }

                break;
        }

        USB_Clear_INT_Flag(USB_INT_TRANSACTION_COMPLETED);

    }
    if(USB_Get_INT_Flag(USB_INT_IDLE) && USB_Get_INT_Enable(USB_INT_IDLE))  // ߿жϣUSBҪ
     {
         // ʹ߻ж
    	USB_Get_INT_Enable(USB_INT_BUS_ACTIVE);
         // ߿жϱ־
    	USB_Clear_INT_Flag(USB_INT_IDLE);
         // USB
        USB_Suspend_Enable(TRUE);

     }//end if

	if(USB_Get_INT_Flag(USB_INT_BUS_ACTIVE) && USB_Get_INT_Enable(USB_INT_BUS_ACTIVE)) //USBӹл,߻ж
	 {
	    //USBģ˳״̬״̬
	    USB_Suspend_Enable(FALSE);
	    //־ֹ߻ж
	    USB_Set_INT_Enable(USB_INT_BUS_ACTIVE,FALSE);
	    USB_Clear_INT_Flag(USB_INT_BUS_ACTIVE);
	 }//end if
}
