/****************************************************************************************
  *
  * ļ  main.c
  *     ChipON_AE/FAE_Group
  *    V3.0.0
  *     2021-08-23
  *     ļṩ˴첽շӦ̲ο
  *
 ****************************************************************************************/
#include "system_init.h"
#include "./inc/kf32f_basic_dma.h"
#include "./inc/kf32f_basic_pm.h"
#include "Usart.h"
//ChipON_KF32F350 ASCII
uint8_t USART_Array_Tansmit[]="ChipON_KF32F350\n";
uint8_t USART_Array_rec[24]={0};
volatile uint8_t Receive_flag; //ձ־λ

void GPIO_USART2();//USART2ӳ
void Usart_line_feed(USART_SFRmap *USARTx);//
#define USART2_TXDMA_CHAN DMA_CHANNEL_5
#define USART2_RXDMA_CHAN DMA_CHANNEL_6
void Delay(volatile uint32_t cnt)
{
	while(cnt--);
}
void DMA_USART2Tx_Init(DMA_SFRmap *DMAx,uint32_t tx_addr,uint32_t tx_bytes)
{
	DMA_InitTypeDef dmaNewStruct;
	/* DMAλ */
	DMA_Reset (DMAx);
	/* DMA */
	DMA_Struct_Init( &dmaNewStruct );
	/*  ݸ: 24 */
	dmaNewStruct.m_Number = tx_addr;
	/*  DMA䷽ڴ */
	dmaNewStruct.m_Direction = DMA_MEMORY_TO_PERIPHERAL;//DMA_MEMORY_TO_PERIPHERAL;//
	/*  DMAͨȼȼ */
	dmaNewStruct.m_Priority = DMA_CHANNEL_MEDIUM;
	/*  λ8λ */
	dmaNewStruct.m_PeripheralDataSize = DMA_DATA_WIDTH_8_BITS;
	/*  洢λ:8λ */
	dmaNewStruct.m_MemoryDataSize = DMA_DATA_WIDTH_8_BITS;
	/*  ַģʽʹ: ֹ */
	dmaNewStruct.m_PeripheralInc = 0;
	/*  洢ַģʽʹ: ʹ */
	dmaNewStruct.m_MemoryInc = 1;
	/*  DMAͨѡ:DMA0-ͨ5*/
	dmaNewStruct.m_Channel = USART2_TXDMA_CHAN;
	/*  ݿ鴫ģʽ */
	dmaNewStruct.m_BlockMode = DMA_TRANSFER_BYTE;//DMA_TRANSFER_BYTE; //DMA_TRANSFER_BLOCK;//
	/*  ѭģʽʹ: ֹ */
	dmaNewStruct.m_LoopMode = 0;
	/*  ʼַȴյݵʼַ */
	dmaNewStruct.m_PeriphAddr = (uint32_t)&USART2_SFR->TBUFR ; //T1
	/*  ڴʼַݵڴռʼַ */
	dmaNewStruct.m_MemoryAddr = tx_addr;
	/* DMAܺ */
	DMA_Configuration (DMAx, &dmaNewStruct); //дDMAxĴ
	DMA_Memory_To_Memory_Enable (DMAx, USART2_TXDMA_CHAN, FALSE);// ֹM2MĴΪźţʼDMA䣬󽫳DMA
}
void DMA_USART2Rx_Init(DMA_SFRmap *DMAx,uint32_t rx_addr,uint32_t rx_bytes)
{
	DMA_InitTypeDef dmaNewStruct;
	/* DMAλ */
	//DMA_Reset (DMAx);
	/* DMA */
	DMA_Struct_Init( &dmaNewStruct );
	/*  ݸ: 24 */
	dmaNewStruct.m_Number = rx_bytes;
	/*  DMA䷽ڴ */
	dmaNewStruct.m_Direction = DMA_PERIPHERAL_TO_MEMORY;//DMA_MEMORY_TO_PERIPHERAL;//
	/*  DMAͨȼȼ */
	dmaNewStruct.m_Priority = DMA_CHANNEL_LOWER;
	/*  λ8λ */
	dmaNewStruct.m_PeripheralDataSize = DMA_DATA_WIDTH_8_BITS;
	/*  洢λ:8λ */
	dmaNewStruct.m_MemoryDataSize = DMA_DATA_WIDTH_8_BITS;
	/*  ַģʽʹ: ֹ */
	dmaNewStruct.m_PeripheralInc = 0;
	/*  洢ַģʽʹ: ʹ */
	dmaNewStruct.m_MemoryInc = 1;
	/*  DMAͨѡ:DMA0-ͨ6*/
	dmaNewStruct.m_Channel = USART2_RXDMA_CHAN;
	/*  ݿ鴫ģʽ */
	dmaNewStruct.m_BlockMode = DMA_TRANSFER_BYTE;//DMA_TRANSFER_BYTE; //DMA_TRANSFER_BLOCK;//
	/*  ѭģʽʹ: ʹ */
	dmaNewStruct.m_LoopMode = 1;
	/*  ʼַȴյݵʼַ */
	dmaNewStruct.m_PeriphAddr = (uint32_t)&USART2_SFR->RBUFR ; //T1
	/*  ڴʼַݵڴռʼַ */
	dmaNewStruct.m_MemoryAddr = (uint32_t)USART_Array_rec;

	/* DMAܺ */
	DMA_Configuration (DMAx, &dmaNewStruct); //дDMAxĴ
	DMA_Memory_To_Memory_Enable (DMAx, USART2_RXDMA_CHAN, FALSE);
	DMA_Half_Transfer_INT_Enable(DMAx,USART2_RXDMA_CHAN,TRUE);
	DMA_Finish_Transfer_INT_Enable(DMAx,USART2_RXDMA_CHAN,TRUE);
}


/**
  *  ⲿƵ\Ƶʱӳʼá
  *  : 
  *
  *   ޡ
  */
void OSC_EXTHLF_Config(void)
{
	OSC_Backup_Write_Read_Enable(TRUE);  //ʹܱд
	SFR_SET_BIT_ASM(PM_CTL0, PM_CTL0_BKPREGCLR_POS); //˳λ״̬

	/*ڱþܽ*/
	PM_EXTLF_PIN_Selection_Config(PM_EXTLF_PIN2_IO_PORT); //ⲿƵ PH8PH9о
	OSC_EXTLF_Software_Enable(TRUE);//ⲿƵʹ

	PM_EXTHF_PIN_Selection_Config(PM_EXTHF_PIN2_IO_PORT); //ⲿƵPD9PD10о
	OSC_EXTHF_Software_Enable(TRUE); //ⲿƵʹ


	OSC_EXTHF_Start_Delay_Config(EXT_START_DELAY_256);
	while(OSC_Get_EXTHF_INT_Flag() != SET);
    OSC_PLL_Input_Source_Config(PLL_INPUT_EXTHF);        //PLLʱԴѡⲿʱԴ16M

	/* PLLƵʱѡ */
    OSC_PLL_Multiple_Value_Select(30,2,2);               //Ƶ Ϊ7.5,PLLΪ  120MHZ

	OSC_PLL_Start_Delay_Config(PLL_START_DELAY_1024);
	OSC_PLL_Software_Enable(ENABLE);
	OSC_PLL_RST();
	/* ʱ */
	OSC_SCK_Division_Config(SCLK_DIVISION_1);   //ʱӷƵѡ
	OSC_SCK_Source_Config(SCLK_SOURCE_PLL);     //ѡPLLΪϵͳʱ

	OSC_Clock_Failure_Check_Enable(TRUE);       //ʹⲿʱӹϼ

	/* ʱ */
	OSC_HFCK_Division_Config(HFCK_DIVISION_1);
	OSC_HFCK_Source_Config(HFCK_SOURCE_EXTHF);    //ѡEXTHFʱΪHFCLKʱ
	OSC_HFCK_Enable(ENABLE);                      //HFCLKʱź

	OSC_LFCK_Division_Config(LFCK_DIVISION_1);	//ƵʱӷƵѡ
	OSC_LFCK_Source_Config (LFCK_INPUT_EXTLF);  //ѡEXTLFΪLFCLKʱ
	OSC_LFCK_Enable (TRUE);					    //LFCLKʱź
	OSC_INTLF_Software_Enable(TRUE);
}

/**
  *    
  *    
  *    
  */
void main()
{

	unsigned int num;
	//ϵͳʱ72M,Ƶʱ16M
	SystemInit();
	//OSC_EXTHLF_Config( );
	GPIO_Write_Mode_Bits(GPIOB_SFR,GPIO_PIN_MASK_10,GPIO_MODE_OUT); //
	//USART2ӳ䣬PB14-TX0PB15-RX
	GPIO_USART2();
	//ȫ˫첽8bit 115200
	USART_Async_config(USART2_SFR);
    DMA_USART2Tx_Init( DMA0_SFR, (uint32_t)USART_Array_Tansmit, sizeof(USART_Array_Tansmit) - 1 );
    DMA_USART2Rx_Init( DMA0_SFR, (uint32_t)USART_Array_rec, sizeof(USART_Array_rec) );
    USART_Transmit_DMA_INT_Enable(USART2_SFR, TRUE );//ʹܴDMAݼĴ
    USART_Transmit_Data_Enable(USART2_SFR,TRUE);	//ʹܷ͹
    USART_Receive_Data_Enable(USART2_SFR,TRUE);
    USART_ReceiveInt_config(USART2_SFR,INT_USART2);
    USART_Receive_DMA_INT_Enable(USART2_SFR, TRUE );
    DMA_Channel_Enable (DMA0_SFR, USART2_RXDMA_CHAN, TRUE);
    INT_Interrupt_Enable(INT_USART2, TRUE);
    INT_Interrupt_Enable(INT_DMA0, TRUE);
    INT_All_Enable(TRUE);
	USART_SendData(USART2_SFR,0);//DMAǰͨڷһbyte
    while(1)
    {
    	/*ϵУλڷݣĿǰDMA泤ΪUSART_Array_recĳȣݵһǴӡUSART_Array_Tansmit
    	 * ջԺӡջе******************************************************************************/
    	if(rec_filish_flag==1)
    	{
    		DMA_Memory_Start_Address_Config(DMA0_SFR, USART2_TXDMA_CHAN,(uint32_t)USART_Array_rec);
    		DMA_Transfer_Number_Config(DMA0_SFR, USART2_TXDMA_CHAN,24);
    		USART_Transmit_Data_Enable(USART2_SFR,TRUE);
    		DMA_Channel_Enable (DMA0_SFR, DMA_CHANNEL_5, TRUE);
    		rec_filish_flag=0;
    	}
    	else if(rec_filish_flag==2)
    	{
    		DMA_Memory_Start_Address_Config(DMA0_SFR, USART2_TXDMA_CHAN,(uint32_t)USART_Array_Tansmit);
			DMA_Transfer_Number_Config(DMA0_SFR, USART2_TXDMA_CHAN,sizeof(USART_Array_Tansmit) - 1);
			USART_Transmit_Data_Enable(USART2_SFR,TRUE);
			DMA_Channel_Enable (DMA0_SFR, DMA_CHANNEL_5, TRUE);
			rec_filish_flag=0;
    	}
		GPIO_Toggle_Output_Data_Config(GPIOB_SFR, GPIO_PIN_MASK_10);
		Delay(1000000);
    }

}

/**
  *    USART2ӳ
  *    
  *    
  */
void GPIO_USART2()
{
	/* ˿ӳAF5 */
	//USART2_RX		PB15
	//USART2_TX0	PB14
	GPIO_Write_Mode_Bits(GPIOB_SFR ,GPIO_PIN_MASK_15, GPIO_MODE_RMP);           //ӳIOڹģʽ
	GPIO_Write_Mode_Bits(GPIOB_SFR ,GPIO_PIN_MASK_14, GPIO_MODE_RMP);           //ӳIOڹģʽ
	GPIO_Pin_RMP_Config (GPIOB_SFR, GPIO_Pin_Num_15, GPIO_RMP_AF5_USART2);	    //ӳΪUSART2
	GPIO_Pin_RMP_Config (GPIOB_SFR,GPIO_Pin_Num_14, GPIO_RMP_AF5_USART2);       //ӳΪUSART2
	GPIO_Pin_Lock_Config (GPIOB_SFR ,GPIO_PIN_MASK_15, TRUE);                   //
	GPIO_Pin_Lock_Config (GPIOB_SFR ,GPIO_PIN_MASK_14, TRUE);                   //
}
/**
  *    ڷͻз
  *    ָUSARTڴṹָ룬ȡֵΪUSART0_SFR~USART8_SFR
  *    
  */
void Usart_line_feed(USART_SFRmap *USARTx)
{
	USART_SendData(USARTx,0x0D);
	while(!USART_Get_Transmitter_Empty_Flag(USARTx));
	USART_SendData(USARTx,0x0A);
	while(!USART_Get_Transmitter_Empty_Flag(USARTx));
}

/**
  *    У鷢ļ
  *    file: ָļƵָ
  *      line У
  *   ޡ
  */
void check_failed(uint8_t* file, uint32_t line)
{
	  /* ûԼĴʵֱļк,
	             : printf("Wrong parameters value: file %s on line %d\r\n", file, line) */

	  while(1)
	  {
		  ;
	  }
}



