/****************************************************************************************
 *
 * ļ: main.c
 * Ŀ: BASIC_Time
  *     V3.0.0
  *     2021-08-23
 *  :  ChipON_AE/FAE_Group
 *
 ****************************************************************************************/
#include "system_init.h"

/*/*ʱʼ
*   BTIMx:ȡֵΪT14_SFR/T15_SFR
*    PeripheralȡֵΪINT_T14/INT_T15
*/
void BASIC_TIMER_Config(BTIM_SFRmap* BTIMx, InterruptIndex Peripheral)
{
	//ʱʱԴѡSCLK  Ϊ50000 ԤƵ23+1=24Ƶ 120MƵ ʱ10msһж

	TIM_Reset(BTIMx);												//ʱ踴λʹʱ
	BTIM_Updata_Immediately_Config(BTIMx,TRUE);						//¿
	BTIM_Updata_Enable(BTIMx,TRUE);									//øʹ
	BTIM_Work_Mode_Config(BTIMx,BTIM_TIMER_MODE);					//ʱģʽѡ
	BTIM_Set_Counter(BTIMx,0);										//ʱֵ
	BTIM_Set_Period(BTIMx,50000);									//ʱֵ50000
	BTIM_Set_Prescaler(BTIMx,23);								    //ʱԤƵֵ23+1=24
	BTIM_Counter_Mode_Config(BTIMx,BTIM_COUNT_UP_OF);				//ϼ,жϱ־
	BTIM_Clock_Config(BTIMx,BTIM_SCLK);								//ѡSCLKʱ
	INT_Interrupt_Priority_Config(Peripheral,4,0);					//ռȼ4,ȼ0
	BTIM_Overflow_INT_Enable(BTIMx,TRUE);							//жʹ
	INT_Interrupt_Enable(Peripheral,TRUE);						    //жʹ
	INT_Clear_Interrupt_Flag(Peripheral);							//жϱ־
	BTIM_Cmd(BTIMx,TRUE);											//ʱʹ
	INT_Stack_Align_Config(INT_STACK_SINGLE_ALIGN);					//жԶջʹõֶ
	INT_All_Enable (TRUE);											//ȫֿжʹ,жʹܿƲλ/NMI/Ӳж

}

/*GPIOx ʼ
/* : GPIOx: ָGPIOڴṹָ룬ȡֵΪGPIOA_SFR~GPIOH_SFR
*       GpioPin: ˿룬ȡֵΪGPIO_PIN_MASK_0~GPIO_PIN_MASK_15еһϡ
* أ
*/
void GPIOInit_Output_Config(GPIO_SFRmap* GPIOx,uint16_t GpioPin)
{
	/*ʼλGPIOx裬ʹGPIOxʱ*/
	GPIO_Reset(GPIOx);

	/*  PxyΪģʽ */
	GPIO_InitTypeDef GPIO_InitStructure;
	GPIO_Struct_Init(&GPIO_InitStructure);
	GPIO_InitStructure.m_Pin = GpioPin;
	GPIO_InitStructure.m_Speed = GPIO_HIGH_SPEED;          //ʼ GPIOٶ
	GPIO_InitStructure.m_Mode = GPIO_MODE_OUT;            //ʼ GPIOΪ
	GPIO_InitStructure.m_PullUp = GPIO_NOPULL;            //ʼ GPIOǷ
	GPIO_InitStructure.m_PullDown = GPIO_NOPULL;          //ʼ GPIOǷ
	GPIO_Configuration(GPIOx,&GPIO_InitStructure);

	GPIO_Set_Output_Data_Bits(GPIOx,GpioPin,Bit_SET);	  //Ϊߵƽ

}



//
void main()
{
	/*ûɲοKF32F350_demoʵֻʱ14 ʱ15
	 * пƶʱĶʱʱΪ10msһжϣPB8\PB9PB10ֱT14T15жϺ﷭ת
	 * ӦPB8LED0˸.ӦPB9LED1˸.ӦPB10LED2˸.
                    ʱʱSCLK Ϊ50000 ԤƵֵ23+1=24Ƶ 120MƵ ʱ10msһж
     */

	//ϵͳʱ120M,Ƶʱ16M
	SystemInit();//ϵͳʱӳʼ

	//ʼPB8/PB9/PB10
	GPIOInit_Output_Config(GPIOB_SFR,GPIO_PIN_MASK_8|GPIO_PIN_MASK_9|GPIO_PIN_MASK_10);

	//ʹܶʱT14
	BASIC_TIMER_Config(T14_SFR,INT_T14); //ʱ10msһж
	//ʹܶʱT15
	BASIC_TIMER_Config(T15_SFR,INT_T15); //ʱ10msһж
	while(1)
	{
	}
}



void check_failed(uint8_t* file, uint32_t line)
{
	  /* ûԼĴʵֱļк,
	             : printf("Wrong parameters value: file %s on line %d\r\n", file, line) */

	  while(1)
	  {
		  ;
	  }
}

