/****************************************************************************************
 *
 * ļ: main.c
 * Ŀ: SysTick
 *     V3.0.0
 *     2021-08-23
 *  :  ChipON_AE/FAE_Group
 *
 ****************************************************************************************/
#include "system_init.h"



/**
  *   GPIOx ʼá
  *  : GPIOx: ָGPIOڴṹָ룬ȡֵΪGPIOA_SFR~GPIOH_SFR
  *       GpioPin: ˿룬ȡֵΪGPIO_PIN_MASK_0~GPIO_PIN_MASK_15еһϡ
  *   ޡ
  */
void GPIOInit_Output_Config(GPIO_SFRmap* GPIOx,uint16_t GpioPin)
{
	/*ʼλGPIOx裬ʹGPIOxʱ*/
		GPIO_Reset(GPIOx);

	/*  PxyΪģʽ */
	GPIO_InitTypeDef GPIO_InitStructure;
	GPIO_Struct_Init(&GPIO_InitStructure);
	GPIO_InitStructure.m_Pin = GpioPin;
	GPIO_InitStructure.m_Speed = GPIO_LOW_SPEED;          //ʼ GPIOٶ
	GPIO_InitStructure.m_Mode = GPIO_MODE_OUT;            //ʼ GPIOΪ
	GPIO_InitStructure.m_PullUp = GPIO_NOPULL;            //ʼ GPIOǷ
	GPIO_InitStructure.m_PullDown = GPIO_NOPULL;          //ʼ GPIOǷ
	GPIO_Configuration(GPIOx,&GPIO_InitStructure);

	GPIO_Set_Output_Data_Bits(GPIOx,GpioPin,Bit_SET);	 //Ϊߵƽ

}


/**
  *   ϵͳĶʱ ʼؼֵá
  *  : Reload: ȡֵ24λֵϵͳĶʱؼֵĶʱֵΪؼֵ1
  *
  *   ޡ
  */
void SysTick_Configuration(uint32_t Reload)
{
	SYSTICK_Cmd (FALSE);
	SYSTICK_Reload_Config(Reload);
	SYSTICK_Counter_Updata();                           //ST_CVĴдֵ㵱ǰֵĴ
	SYSTICK_Clock_Config(SYSTICK_SYS_CLOCK_DIV_2);      //ϵͳĶʱʱԴѡSCLK/2ΪʱԴ
	SYSTICK_Systick_INT_Enable(TRUE);
	SYSTICK_Cmd(TRUE);
    INT_Interrupt_Enable(INT_SysTick,TRUE);								//ʹжSYSTICK
	INT_All_Enable (TRUE);
}




//
void main()
{
	/*ûɲοKF32F350_demoʵʹýĶʱܡ
	 * нĶʱʱԴΪƵ SCLK/2 164Ƶ16.7nsҼһΣ3000000һжϣ50msһжϣ
	 * PB8/PB9/PB10жϺзתLED0 LED1 LED2˸ж־
	 * ϵͳĶʱؼֵΪ24λ
     */

	//ϵͳʱ120M,Ƶʱ16M
	SystemInit(); //ϵͳʱӳʼ
	//PB8\PB9\PB10ΪΪߵƽ
	GPIOInit_Output_Config(GPIOB_SFR,GPIO_PIN_MASK_8|GPIO_PIN_MASK_9|GPIO_PIN_MASK_10);
	/*Ķʱװֵ,ʱԴΪ120M/216.7nsҼһ */
	SysTick_Configuration(3000000);     //3000000һжϣ16.7ns X 3000000 =50mSһж
    while(1)
    {
    }

}



/**
  *    У鷢ļ
  *    file: ָļƵָ
  *      line У
  *   ޡ
  */
void check_failed(uint8_t* file, uint32_t line)
{
	  /* ûԼĴʵֱļк,
	             : printf("Wrong parameters value: file %s on line %d\r\n", file, line) */

	  while(1)
	  {
		  ;
	  }
}

