/****************************************************************************************
  *
  * ļ  main.c
  *     ChipON_AE/FAE_Group
  *     V3.0.0
  *     2021-08-20
  *     ļṩMCUͨSPIFLASHӦ
  *
 ****************************************************************************************/
#include "system_init.h"
#include "SPI_Flash.h"
#include "Usart.h"
#define LED1_ON()     GPIO_Set_Output_Data_Bits(GPIOB_SFR,GPIO_PIN_MASK_9,Bit_SET)  //Ϊߵƽ
#define LED1_OFF()    GPIO_Set_Output_Data_Bits(GPIOB_SFR,GPIO_PIN_MASK_9,Bit_RESET)//Ϊ͵ƽ
#define LED0_ON()     GPIO_Set_Output_Data_Bits(GPIOB_SFR,GPIO_PIN_MASK_8,Bit_SET)  //Ϊߵƽ
#define LED0_OFF()    GPIO_Set_Output_Data_Bits(GPIOB_SFR,GPIO_PIN_MASK_8,Bit_RESET)//Ϊ͵ƽ

#define  sFLASH_ADDRESS            0x300000         //FLASHַ
#define  sFLASH_READ_ADDRESS       sFLASH_ADDRESS   //FLASHַ
#define  sFLASH_SECTOR_ERASE       sFLASH_ADDRESS   //FLASHַ

#define  BufferSize (sizeof(Write_data) / sizeof(*(Write_data))-1)  //ȡWrite_data
uint8_t Write_data[] = "KF32F350-KungFu32 SPI Example: communication with an W25Q SPI FLASH";  //дflash
uint8_t Read_data[BufferSize]; //flash
uint32_t sFlashID;//Flash ID

void GPIO_SPI2();//SPI2 IOӳ
void GPIO_USART2();//USART2ӳ
void Usart_line_feed(USART_SFRmap *USARTx);//ͻз

/**
  *     ʱ
  *    aʱ
  *      bʱ
  *    
  */
void MYDelay(volatile uint32_t a, volatile uint32_t b)
{
	volatile uint32_t i;
	volatile uint32_t j;
	for(i=a;i>1;i--)
	{
		j=b;
        while(j--);
	}

}
/**
  *    
  *    
  *    
  */
void main()
{
   /* ûɲοKF32F350_demoʵͨSPI2W25QжȡIDд
	* ȡȲFLASHдSPIͨ2۲дݣȳ
	* SPIݣͨ2۲Ƿ*/

	//ϵͳʱ72M,Ƶʱ16MʹSPISPIοʱ벻Ҫ80M
	SystemInit();
	MYDelay(3000,3000);//ͨϵʱȴ
	/*ʼλGPIOB裬ʹGPIOBʱ,LED0,LED1*/
	GPIO_Reset(GPIOB_SFR);
    GPIO_Write_Mode_Bits(GPIOB_SFR,GPIO_PIN_MASK_8|GPIO_PIN_MASK_9,GPIO_MODE_OUT);

    //USART2ӳ䣬PB15-RXPB14-TX0
	GPIO_USART2();
	//ȫ˫첽8bit 9600
	USART_Async_config(USART2_SFR);

	 /*SPI2_IO*/
	GPIO_SPI2(); //PC8=SDI,PG6=SDO,PC9=SS,PC7=SCK
	/*SPI2ʱӲοƵ4Ƶ18M*/
	SPI_Init_Configuration(SPI2_SFR);

    //豸ID
	sFlashID=sFLASH_ReadID();
	//IDƥ䣬LED1
	if(sFlashID==sFLASH_W25Q128_ID){LED1_ON();}

    //
	sFLASH_EraseSector(sFLASH_SECTOR_ERASE);
	//дWrite_dataݵW25Q18
	sFLASH_WriteData(Write_data, sFLASH_ADDRESS, BufferSize);
	//дݵRead_data
	sFLASH_ReadBuffer(Read_data, sFLASH_READ_ADDRESS, BufferSize);
	//2Read_data
	USART_Send(USART2_SFR,Read_data,BufferSize);
	//2
	Usart_line_feed(USART2_SFR);

	//
	sFLASH_EraseSector(sFLASH_SECTOR_ERASE);
    //ַݵ Read_data
	sFLASH_ReadBuffer(Read_data, sFLASH_SECTOR_ERASE, BufferSize);
	//2Read_data
	USART_Send(USART2_SFR,Read_data,BufferSize);
	//2
	Usart_line_feed(USART2_SFR);

    while(1)
	{
       //ʱ
	   LED0_ON();
	   MYDelay(1000,1000);
	   LED0_OFF();
	   MYDelay(1000,1000);
	}
}

/**
  *     USART2ӳ
  *    
  *    
  */
void GPIO_USART2()
{
	 /* ˿ӳAF5 */
	//USART2_RX		PB15
	//USART2_TX0	PB14
	GPIO_Write_Mode_Bits(GPIOB_SFR ,GPIO_PIN_MASK_15, GPIO_MODE_RMP);           //ӳIOڹģʽ
	GPIO_Write_Mode_Bits(GPIOB_SFR ,GPIO_PIN_MASK_14, GPIO_MODE_RMP);           //ӳIOڹģʽ
	GPIO_Pin_RMP_Config (GPIOB_SFR, GPIO_Pin_Num_15, GPIO_RMP_AF5_USART2);	    //ӳΪUSART2
	GPIO_Pin_RMP_Config (GPIOB_SFR, GPIO_Pin_Num_14, GPIO_RMP_AF5_USART2);       //ӳΪUSART2
	GPIO_Pin_Lock_Config (GPIOB_SFR ,GPIO_PIN_MASK_15, TRUE);                   //
	GPIO_Pin_Lock_Config (GPIOB_SFR ,GPIO_PIN_MASK_14, TRUE);                   //
}
/**
  *    GPIO_SPI2()ӳ
  *    
  *    
  */
void GPIO_SPI2()
{
	/*SPI2_IO*/
	//PC8=SDI,PG6=SDO,PC9=SS,PC7=SCK
	GPIO_Reset(GPIOC_SFR);
	GPIO_Write_Mode_Bits(GPIOC_SFR,GPIO_PIN_MASK_9,GPIO_MODE_OUT);
	GPIO_Set_Output_Data_Bits(GPIOC_SFR,GPIO_PIN_MASK_9,Bit_SET);  //Ϊߵƽ

	GPIO_Write_Mode_Bits(GPIOC_SFR,GPIO_PIN_MASK_7|GPIO_PIN_MASK_8,GPIO_MODE_RMP);//ӳIOڹģʽ
	GPIO_Write_Mode_Bits(GPIOG_SFR,GPIO_PIN_MASK_6,GPIO_MODE_RMP);//ӳIOڹģʽ

	GPIO_Pin_RMP_Config(GPIOC_SFR,GPIO_Pin_Num_7,GPIO_RMP_AF7_SPI2);//ӳΪSPI2
	GPIO_Pin_RMP_Config(GPIOC_SFR,GPIO_Pin_Num_8,GPIO_RMP_AF7_SPI2);//ӳΪSPI2
	GPIO_Pin_RMP_Config(GPIOG_SFR,GPIO_Pin_Num_6,GPIO_RMP_AF7_SPI2);//ӳΪSPI2
}
/**
  *    ڷͻз
  *    ָUSARTڴṹָ룬ȡֵΪUSART0_SFR~USART8_SFR
  *    
  */
void Usart_line_feed(USART_SFRmap *USARTx)
{
	USART_SendData(USARTx,0x0D);
	while(!USART_Get_Transmitter_Empty_Flag(USARTx));
	USART_SendData(USARTx,0x0A);
	while(!USART_Get_Transmitter_Empty_Flag(USARTx));
}
/**
  *    У鷢ļ
  *    file: ָļƵָ
  *      line У
  *   ޡ
  */
void check_failed(uint8_t* file, uint32_t line)
{
	  /* ûԼĴʵֱļк,
	             : printf("Wrong parameters value: file %s on line %d\r\n", file, line) */
	  while(1)
	  {
		  ;
	  }
}
