/**
  ******************************************************************************
  * ļ lin_master.c
  *     ChipON_AE/FAE_Group
  *   	V3.0.0
  *   	2021-08-23
  *     ļṩ첽ú
  *          + ڷͺ
  *          + ׼У
  *          + LIN
  *          + ãʹLIN
  *          + ڽжʹ
  *          + ʱ
  ******************************************************************************/
#include "system_init.h"

volatile uint8_t Rev_Temp;		 //ݣжϱ־
uint8_t l_Tx_data[10];           //
uint8_t xxx;             		 //

void USART_Send(USART_SFRmap* USARTx, uint8_t* Databuf, uint32_t length);//ڷͺ
uint8_t Check_Sum(uint8_t* Databuf,uint32_t point,uint32_t length);  //׼У
void LIN_Send(USART_SFRmap* USARTx, uint8_t* Databuf, uint32_t length);//LIN
void USART_LIN_config(USART_SFRmap *USARTx);//ãʹLIN
void USART_LIN_INT_config(USART_SFRmap *USARTx,InterruptIndex Peripheral);//ڽжʹ
void BASIC_TIMER_Config(BTIM_SFRmap* BTIMx, InterruptIndex Peripheral);//ʱ
/**
  *    ڷ
  *    USARTx:   ָUSARTڴṹָ룬ȡֵΪUSART0_SFR~USART8_SFR
  *      Databuf   ָݵָ
  *      length      ͵ĳ
  *    
  */
void USART_Send(USART_SFRmap* USARTx, uint8_t* Databuf, uint32_t length)
{
	uint32_t i;
	for(i=0;i<length;i++)
	{
		//ڷ
		USART_SendData(USARTx,Databuf[i]);
		//ɱ־
		while(!USART_Get_Transmitter_Empty_Flag(USARTx));
	}
}

/**
  *    ׼У
  *    Databuf:  ָУݵָ
  *      point        Уʼλ
  *      length      У鳤=length-point
  *    У
  */
uint8_t Check_Sum(uint8_t* Databuf,uint32_t point,uint32_t length)
{
	 uint8_t i;
	 uint8_t check_sum;
	 check_sum=0;
	 for(i=point;i<length;i++)   //Уͣ׼У飩
	 {
		 check_sum+=Databuf[i];
	 }
	 check_sum=0xFF-check_sum;

	 return check_sum;
}

/**
  *    LIN
  *    USARTx:   ָUSARTڴṹָ룬ȡֵΪUSART0_SFR~USART8_SFR
  *      Databuf   ָݵָ
  *      length      ͵ĳ
  *    
  */
void LIN_Send(USART_SFRmap* USARTx, uint8_t* Databuf, uint32_t length)
{
	uint32_t i;

	USART_SendData(USARTx,0x55);							    //ͬ
	USART_Send_Blank_Enable(USARTx,TRUE);						//ʹܷͼ
	BTIM_Clear_Overflow_INT_Flag (T15_SFR);						//T15жϱ־λ
	BTIM_Set_Counter(T15_SFR,0);								//ʱֵ0
	BTIM_Cmd(T15_SFR,TRUE);										//ʱʹ
	while(!BTIM_Get_Overflow_INT_Flag(T15_SFR));				//ȴʱ
	USART_Send_Blank_Enable(USARTx,FALSE);						//巢ͼ
	BTIM_Cmd(T15_SFR,FALSE);									//ʱر
	while(!USART_Get_Transmitter_Empty_Flag(USARTx));           //ȴͬ뷢Ϸ

	//ID & 
	for(i=0;i<length;i++)
	{
		//ڷ
		USART_SendData(USARTx,Databuf[i]);
		//ɱ־
		while(!USART_Get_Transmitter_Empty_Flag(USARTx));
	}
}



/**
  *    첽ȫ˫(Ĭ8bitշʹ  ȫ˫ 9600)ʹLIN
  *    ָUSARTڴṹָ룬ȡֵΪUSART0_SFR~USART8_SFR
  *    
  */
void USART_LIN_config(USART_SFRmap *USARTx)
{
	USART_InitTypeDef USART_InitStructure;

	USART_Struct_Init(&USART_InitStructure);
    USART_InitStructure.m_Mode=USART_MODE_FULLDUPLEXASY;                        //ȫ˫
    USART_InitStructure.m_TransferDir=USART_DIRECTION_FULL_DUPLEX;              //䷽
    USART_InitStructure.m_WordLength=USART_WORDLENGTH_8B;                       //8λ
    USART_InitStructure.m_StopBits=USART_STOPBITS_1;                            //1λֹͣλ
    USART_InitStructure.m_BaudRateBRCKS=USART_CLK_HFCLK;                        //ڲƵʱΪ USARTʷʱ
    USART_InitStructure.m_BRAutoDetect=USART_ABRDEN_OFF;                        //ԶⲨʹر
    /*  =Fck/(16*z1+x/y)) ʱڲƵ16M*/
    //4800    z:208    x:0    y:0
    //9600    z:104    x:0    y:0
    //19200   z:52     x:0    y:0
    //115200  z:8      x:1    y:13
    //9600
    USART_InitStructure.m_BaudRateInteger=104;         //USARTzȡֵΪ0~65535
    USART_InitStructure.m_BaudRateNumerator=0;         //USARTСӲxȡֵΪ0~0xF
    USART_InitStructure.m_BaudRateDenominator=0;       //USARTСĸyȡֵΪ0~0xF

	USART_Reset(USARTx);                                       //USARTxλ
	USART_Configuration(USARTx,&USART_InitStructure);          //USARTx
	USART_WeakUP_Enable(USARTx,TRUE);                          //Զʹܣȴ½
	USART_Clear_Transmit_BUFR_INT_Flag(USARTx);                //USARTxBUF
	USART_Transmit_Data_Enable(USARTx,TRUE);				   //ʹܷ
	USART_RESHD_Enable (USARTx, TRUE);						   //ʹRESHDλ
	USART_Cmd(USARTx,TRUE);                                    //USARTxʹ
}

/**
  *    ڽж
  *    USARTx:ָUSARTڴṹָ룬ȡֵΪUSART0_SFR~USART8_SFR
  *      Peripheral:ںжţȡֵΧΪ
  *                 öInterruptIndexеж
  *    
  */
void USART_LIN_INT_config(USART_SFRmap *USARTx,InterruptIndex Peripheral)
{
	USART_RDR_INT_Enable(USARTx,TRUE);//жʹ
	INT_Interrupt_Enable(Peripheral,TRUE);
	INT_All_Enable(TRUE);
}


/*/*ʱʼ
*   BTIMx:ȡֵΪT14_SFR/T15_SFR
*    PeripheralȡֵΪINT_T14/INT_T15
*/
void BASIC_TIMER_Config(BTIM_SFRmap* BTIMx, InterruptIndex Peripheral)
{
	//ʱʱԴѡSCLK  Ϊ16000 ԤƵ2Ƶ 16M ʱ20msһж

	TIM_Reset(BTIMx);												//ʱ踴λʹʱ
	BTIM_Updata_Immediately_Config(BTIMx,TRUE);						//¿
	BTIM_Updata_Enable(BTIMx,TRUE);									//øʹ
	BTIM_Work_Mode_Config(BTIMx,BTIM_TIMER_MODE);					//ʱģʽѡ
	BTIM_Set_Counter(BTIMx,0);										//ʱֵ
	BTIM_Set_Period(BTIMx,40000);									//ʱֵ80000
	BTIM_Set_Prescaler(BTIMx,7);								    //ʱԤƵֵ1+1=2
	BTIM_Counter_Mode_Config(BTIMx,BTIM_COUNT_UP_OF);				//ϼ,жϱ־
	BTIM_Clock_Config(BTIMx,BTIM_HFCLK);							//ѡHFCLKʱ
	INT_Interrupt_Priority_Config(Peripheral,4,0);					//ռȼ4,ȼ0
	BTIM_Overflow_INT_Enable(BTIMx,TRUE);							//жʹ
	INT_Interrupt_Enable(Peripheral,TRUE);						    //жʹ
	INT_Clear_Interrupt_Flag(Peripheral);							//жϱ־
	BTIM_Cmd(BTIMx,TRUE);											//ʱʹ
	INT_Stack_Align_Config(INT_STACK_SINGLE_ALIGN);					//жԶջʹõֶ
	INT_All_Enable (TRUE);											//ȫֿжʹ,жʹܿƲλ/NMI/Ӳж
}
