/****************************************************************************************
 *
 * ļ: main.c
 * Ŀ: EEPROM_DMA
 *  :  V3.0.0
 *  :  2021-08-20
 *  :  ChipON_AE/FAE_Group
 *
 ****************************************************************************************/
#include "system_init.h"
#include "EEPROM_AT24C16.h"
#include "Usart.h"




/**
  *   GPIOx ʼá
  *  : GPIOx: ָGPIOڴṹָ룬ȡֵΪGPIOA_SFR~GPIOH_SFR
  *       GpioPin: ˿룬ȡֵΪGPIO_PIN_MASK_0~GPIO_PIN_MASK_15еһϡ
  *   ޡ
  */
void GPIOInit_Output_Config(GPIO_SFRmap* GPIOx,uint16_t GpioPin)
{
	/*ʼλGPIOx裬ʹGPIOxʱ*/
		GPIO_Reset(GPIOx);

	/*  PxyΪģʽ */
	GPIO_InitTypeDef GPIO_InitStructure;
	GPIO_Struct_Init(&GPIO_InitStructure);
	GPIO_InitStructure.m_Pin = GpioPin;
	GPIO_InitStructure.m_Speed = GPIO_LOW_SPEED;          //ʼ GPIOٶ
	GPIO_InitStructure.m_Mode = GPIO_MODE_OUT;            //ʼ GPIOΪ
	GPIO_InitStructure.m_PullUp = GPIO_NOPULL;            //ʼ GPIOǷ
	GPIO_InitStructure.m_PullDown = GPIO_NOPULL;          //ʼ GPIOǷ
	GPIO_Configuration(GPIOx,&GPIO_InitStructure);

	GPIO_Set_Output_Data_Bits(GPIOx,GpioPin,Bit_SET);	  //Ϊߵƽ

}

/**
  *   I2Cxʼӳá
  *   
  *
  *   ޡ
  */
void I2C_GPIO_init(void)
{
	/*I2Cxʼӳ*/
	GPIO_InitTypeDef I2C_GPIO_Init;

	I2C_GPIO_Init.m_Mode = GPIO_MODE_RMP;                   //GPIOΪӳ
	I2C_GPIO_Init.m_OpenDrain = GPIO_POD_OD;                //GPIOΪ©
	I2C_GPIO_Init.m_Pin = GPIO_PIN_MASK_0|GPIO_PIN_MASK_1;  //ѡõGPIO˿
	I2C_GPIO_Init.m_PullUp = GPIO_PULLUP;                   //GPIOΪ
	I2C_GPIO_Init.m_PullDown = GPIO_NOPULL;                 //GPIO
	I2C_GPIO_Init.m_Speed = GPIO_HIGH_SPEED;                //GPIOٶΪ
	GPIO_Pin_RMP_Config(GPIOA_SFR,GPIO_Pin_Num_0,GPIO_RMP_AF8_I2C0);  //PA0ΪI2C0SDA
	GPIO_Pin_RMP_Config(GPIOA_SFR,GPIO_Pin_Num_1,GPIO_RMP_AF8_I2C0);  //PA1ΪI2C0SCK

	GPIO_Configuration(GPIOA_SFR,&I2C_GPIO_Init);

}

/**
  *   ʼI2Cxòá
  *   I2CxָI2Cڴṹָ룬ȡֵΪI2C0_SFR~I2C3_SFR
  *
  *   ޡ
  */
void I2C_init(I2C_SFRmap* I2Cx)
{
	/*I2Cx*/
	I2C_Reset(I2Cx);
	I2C_InitTypeDef newStruct_I2C;
	newStruct_I2C.m_Mode = I2C_MODE_I2C;              //I2Cģʽ
	newStruct_I2C.m_ClockSource = I2C_CLK_SCLK;      //Ƶ120MһʱΪ0.00833us
	newStruct_I2C.m_BADR10 = I2C_BUFRADDRESS_7BIT;    //7λĵַģʽ
	newStruct_I2C.m_MasterSlave = I2C_MODE_SMBUSHOST; //SMBusѡHOST
	newStruct_I2C.m_BaudRateL = 150;                   //ʵ͵ƽʱ䣺150X0.00833us=1.25us
	newStruct_I2C.m_BaudRateH = 150;                   //ʸߵƽʱ䣺150X0.00833us=1.25us õ400KHZ
	newStruct_I2C.m_AckEn = TRUE;                     //ACKӦʹ
	newStruct_I2C.m_AckData = I2C_ACKDATA_ACK;        //ӦACK
	I2C_Configuration(I2Cx, &newStruct_I2C);

	/*ʹI2Cģ*/
	I2C_Cmd(I2Cx,TRUE);
	I2C_Clear_INTERRUPT_Flag(I2Cx);  //I2Cжϱ־λ

}



//
void main()
{
	/*ûɲοKF32F350_demoʵI2CģʽDMAдⲿEERPOMܣддԱȡ
	* ʹI2C0 PA0 PA1I2CͨţDMAI2C0EEPROM AT24C16֧400KHZ
	* ܼ:	KF32F350ͨI2CDMAķʽEERPOM0x00ַд16ֽݣȻCPUʽ0x00ַٶ16ֽݽжԱȣ
	*           ƥPB8תLED0˸PB9תLED1˸
	* Ӳ˵    PA0ΪI2C0SDA  PA1ΪI2C0SCK
	*            PB8ӦLED0\PB9ӦLED1\PB10ӦLED2
	*           ҪôڽUSART0_RX PB6 	USART0_TX0	PB7  Usart.h ں궨Usart_Print  1
	*EERPOMͺΪAT24C16
	*
    */

	//ϵͳʱ120M,Ƶʱ16M
	SystemInit();//ϵͳʱӳʼ
	/*PB8 PB9 PB10ʼΪߵƽ*/
	GPIOInit_Output_Config(GPIOB_SFR,GPIO_PIN_MASK_8|GPIO_PIN_MASK_9|GPIO_PIN_MASK_10);

	//I2C GPIOѡüӳ
	I2C_GPIO_init();      //PA0ΪI2C0SDA  PA1ΪI2C0SCK
	//ʼI2C0ģ
	I2C_init(I2C0_SFR);   //Ϊ400KHZ

#if Usart_Print
	GPIO_USART();//USART0ӳ䣬	//USART2_RX		PB15 	USART2_TX0	PB14
	USART_Async_config(USART2_SFR);//ȫ˫첽8bit 115200
#endif
	while(1)
    {
		if(I2C_OK == AT24C16_TEST_DMA())//жDMAдǷƥ
		{
			GPIO_Toggle_Output_Data_Config(GPIOB_SFR,GPIO_PIN_MASK_8);//ƥPB8תLED0˸
			delay_ms(1000);
		}else
		{
			GPIO_Toggle_Output_Data_Config(GPIOB_SFR,GPIO_PIN_MASK_9);//PB9ת
			delay_ms(1000);
		}
#if Usart_Print
		//ڴӡ
		USART_Send(USART2_SFR,i2c_buffer_read,sizeof(i2c_buffer_read));
		delay_ms(1000);
#endif


    }

}



/**
  *    У鷢ļ
  *    file: ָļƵָ
  *      line У
  *   ޡ
  */
void check_failed(uint8_t* file, uint32_t line)
{
	  /* ûԼĴʵֱļк,
	             : printf("Wrong parameters value: file %s on line %d\r\n", file, line) */

	  while(1)
	  {
		  ;
	  }
}

