/**
  ********************************************************************
  * ļ  EEPROM_AT24C16.c
  *      ChipON_AE/FAE_Group
  *     V3.0.0
  *     2021-08-20
  *     ļṩEERPOMдܺغ
  *
  *********************************************************************
*/
#include "system_init.h"
#include "EEPROM_AT24C16.h"


#define I2C_Buffer_Addr   0x40000D08   //I2C0  Buffer ַ

I2C_SFRmap* I2C_Choose;    //I2Cȡֵ ΪI2C0_SFR~I2C3_SFR



//ʱ ֲvolatileܻᱻŻ
void Delay(volatile uint32_t cnt)
{
	while(cnt--);
}

void delay_ms(volatile uint32_t nms)
{
	volatile uint32_t i,j;
	for(i=0;i<nms;i++)
	{
		j=800;
		while(j--);
	}
}



/**
  *   eeprom ֽݡ
  *   write_addresseeprom 8λĴַ
  *           p_buffer: ָ
  *      number_of_byteݳ
  *   ޡ
  */
void eeprom_buffer_read(uint16_t Write_address,uint8_t *p_buffer,uint8_t number_of_byte)
{

	I2C_Choose=I2C0_SFR;//ѡI2C0_SFR I2C1_SFR I2C2_SFR I2C3_SFR

	I2C_Cmd(I2C_Choose,TRUE);                            //ʹI2Cģ

	/*ʼλ*/
	I2C_Clear_INTERRUPT_Flag(I2C_Choose);                //I2Cжϱ־λISIFλ
	I2C_Generate_START(I2C_Choose,TRUE);                 //ʹʼź
	while(!I2C_Get_INTERRUPT_Flag(I2C_Choose));          //ȴʼλȶ



	/*I2Cӻַ*/
	I2C_SendData8(I2C_Choose,EEPROM_I2C_ADDRESS|((Write_address>>7)&0X0E));     //ʹӻI2Cַ
	I2C_Clear_INTERRUPT_Flag(I2C_Choose);                 //I2Cжϱ־λISIFλ
	while(!I2C_Get_INTERRUPT_Flag(I2C_Choose));           //ȴ
	while(I2C_Get_Ack_Fail_Flag(I2C_Choose));    //жǷACKӦûֹͣ


	/*ҪĴַ*/
	I2C_SendData8(I2C_Choose,Write_address);            //ʹӻλĴַ
	I2C_Clear_INTERRUPT_Flag(I2C_Choose);                //I2Cжϱ־λISIFλ
	while(!I2C_Get_INTERRUPT_Flag(I2C_Choose));          //ȴ


	I2C_Cmd(I2C_Choose,FALSE);                       //I2Cģ

	I2C_Clear_Start_Flag(I2C_Choose);               //I2Cʼ־λSIFλ
	I2C_Clear_INTERRUPT_Flag(I2C_Choose);           //־λISIFλ
	I2C_Cmd(I2C_Choose,TRUE);                       //I2Cģ
	/*ʼλ*/
	I2C_Clear_INTERRUPT_Flag(I2C_Choose);           //жϱ־λISIFλ
	I2C_Generate_START(I2C_Choose,TRUE);             //ʼź
	while(!I2C_Get_INTERRUPT_Flag(I2C_Choose));     //ȴʼλȶ


	/*Ͷָ*/
	I2C_SendData8(I2C_Choose,EEPROM_I2C_ADDRESS|0x01);//ʹӻַ
	I2C_Clear_INTERRUPT_Flag(I2C_Choose);           //־λISIFλ
	while(!I2C_Get_INTERRUPT_Flag(I2C_Choose));     //ȴISIF1
	while(I2C_Get_Ack_Fail_Flag(I2C_Choose));    //жǷACKӦûֹͣ
	I2C_Clear_INTERRUPT_Flag(I2C_Choose);           //Ȼ־λISIFλ


	while(number_of_byte)
	{
		 if(1 == number_of_byte)
		 {
			 I2C_Ack_DATA_Config(I2C_Choose,I2C_ACKDATA_NO_ACK);//ظNOACK
		 }else
		 {
			 I2C_Ack_DATA_Config(I2C_Choose,I2C_ACKDATA_ACK);//ظACK
		 }
		if(I2C_Get_Receive_Buff_Flag(I2C_Choose))     //жBuffǷΪ
		{
			while(!I2C_Get_INTERRUPT_Flag(I2C_Choose));
			*p_buffer = I2C_ReceiveData(I2C_Choose);
			if(1!= number_of_byte)
			{
				I2C_Clear_INTERRUPT_Flag(I2C_Choose);        //Ȼ־λISIFλ
			}

			p_buffer++;/* ָһȡֽڽλ */
			 /* ݼȡֽڼ */
			number_of_byte--;

		}
	}

	/*ֹͣλ*/
	I2C_Generate_STOP(I2C_Choose,TRUE);         //ʹֹͣź

	I2C_Clear_INTERRUPT_Flag(I2C_Choose);       //I2Cжϱ־λISIFλ
	while(!I2C_Get_INTERRUPT_Flag(I2C_Choose)); //ȴֹͣ

	I2C_Clear_INTERRUPT_Flag(I2C_Choose);       //I2Cжϱ־λISIFλ
	I2C_Clear_Stop_Flag(I2C_Choose);            //I2Cֹͣ־λPIFλ
	I2C_Cmd(I2C_Choose,FALSE);                  //رI2Cģ


}




/**
  *   I2C_DMA ʼ
  *   
  *
  *   ޡ
  */
void I2C_DMA_Init(void)
{

	DMA_InitTypeDef I2C_DMAStruct;
	//ע⣺DMAɱ־ڴɵһʱͻλ
	I2C_DMAStruct.m_Number = WRITE_BUFFER_SIZE+1;/*  ݸ: WRITE_BUFFER_SIZE+1 */

	I2C_DMAStruct.m_Direction = DMA_MEMORY_TO_PERIPHERAL;/*  DMA䷽ ڴ浽*/
	I2C_DMAStruct.m_Priority = DMA_CHANNEL_LOWER;/*  DMAͨȼȼ */
	I2C_DMAStruct.m_PeripheralDataSize = DMA_DATA_WIDTH_8_BITS;/*  λ8λ */
	I2C_DMAStruct.m_MemoryDataSize = DMA_DATA_WIDTH_8_BITS;/*  洢λ:8λ */
	I2C_DMAStruct.m_PeripheralInc = FALSE;/*  ַģʽʹ: ʹ */
	I2C_DMAStruct.m_MemoryInc = TRUE;/*  洢ַģʽʹ: ʹ */
	I2C_DMAStruct.m_Channel = DMA_CHANNEL_4;/*  DMAͨѡ:ͨ4 */
	I2C_DMAStruct.m_BlockMode = DMA_TRANSFER_BYTE; /*  ݿ鴫ģʽ */
	I2C_DMAStruct.m_LoopMode = TRUE;/*  ѭģʽʹ: ֹ */
	I2C_DMAStruct.m_PeriphAddr = I2C_Buffer_Addr;/*  ʼַȴ͵ݵʼַ */
	I2C_DMAStruct.m_MemoryAddr = (uint32_t )&i2c_buffer_write;/*  ڴʼַݵڴռʼַ */
	DMA_Reset(DMA0_SFR);
	DMA_Configuration(DMA0_SFR, &I2C_DMAStruct);

}

void DMA_I2C_Enable(FunctionalState NewState)
{
	I2C_Choose=I2C0_SFR;//ѡI2C0_SFR I2C1_SFR I2C2_SFR I2C3_SFR

	I2C_Transmit_DMA_INT_Enable(I2C_Choose,NewState);    //ʹ I2C0DMAж
	DMA_Channel_Enable(DMA0_SFR,DMA_CHANNEL_4,NewState); //ʹDMA0 ͨ4
	/**/
	I2C_Cmd(I2C_Choose,TRUE);                            //ʹI2Cģ
	I2C_Clear_INTERRUPT_Flag(I2C_Choose);                 //жϱ־ISIF
	I2C_Generate_START(I2C_Choose,TRUE);                  //ʼź
	I2C_Clear_INTERRUPT_Flag(I2C_Choose);       ////жϱ־ISIF

	while(!DMA_Get_Finish_Transfer_INT_Flag(DMA0_SFR,DMA_CHANNEL_4));  //ȴDMA
	if(!I2C_Get_Transmit_Buff_Flag(I2C_Choose))    //ȡBuff״̬Ϊͷ
	{
		/*ֹͣλ*/
		I2C_Generate_STOP(I2C_Choose,TRUE);         //ʹֹͣź
		I2C_Clear_INTERRUPT_Flag(I2C_Choose);       ////жϱ־ISIF
	}

	I2C_Clear_INTERRUPT_Flag(I2C_Choose);       //I2Cжϱ־λISIFλ
	while(!I2C_Get_INTERRUPT_Flag(I2C_Choose)); //ȴֹͣ

	I2C_Clear_INTERRUPT_Flag(I2C_Choose);       //I2Cжϱ־λISIFλ
	I2C_Clear_Stop_Flag(I2C_Choose);            //I2Cֹͣ־λPIFλ
	I2C_Cmd(I2C_Choose,FALSE);                            //I2Cģ


}


/**
  *   д16ֽݲ16ֽݽбȽϡ
  *   
  *  1 ݶԱƥ䡣
  *     0 ݶԱȲƥ䡣
  */
uint8_t AT24C16_TEST_DMA(void)
{
	volatile   uint16_t i;
	i2c_buffer_write[0]=EEPROM_I2C_ADDRESS|((EEPROM_ADD>>7)&0X0E); // EEPROM I2C ַ
	i2c_buffer_write[1]=EEPROM_ADD &0x0F;        // EEPROM I2C Ĵַ


	/* ʼi2cд */
    for(i = 2;i < WRITE_BUFFER_SIZE;i++)
    {
        i2c_buffer_write[i]=i-2;   //0~0X3F
    }
    Delay(0XFFFF);
    Delay(0XFFFF);
    /* ʹDMA дEERPOM */
    I2C_DMA_Init();   //ʼI2C DMA
	DMA_I2C_Enable(TRUE);   //ʹDMA ͨI2CDMA
    Delay(0XFFFF);
    Delay(0XFFFF);
    Delay(0XFFFF);
	I2C_Transmit_DMA_INT_Enable(I2C0_SFR,FALSE);      // I2C0DMAж
	DMA_Channel_Enable(DMA0_SFR,DMA_CHANNEL_4,FALSE); //DMA0 ͨ4
    Delay(0XFFFF);
    Delay(0XFFFF);
    Delay(0XFFFF);
    Delay(0XFFFF);
    Delay(0XFFFF);
    /* ȡEEPROM  */
    eeprom_buffer_read(EEP_FIRST_PAGE,i2c_buffer_read,sizeof(i2c_buffer_read));
    Delay(0XFFFF);
    Delay(0XFFFF);
    Delay(0XFFFF);
    Delay(0XFFFF);
    Delay(0XFFFF);
    ///дEEPROMݺͶEERPOMݶԱ
    for(i = 0;i < READ_BUFFER_SIZE;i++)
    {
        if(i2c_buffer_read[i] != i2c_buffer_write[i+2])
        {
           return I2C_FAIL;
        }
    }
    return I2C_OK;
}








