/**
  ********************************************************************
  * ļ  EEPROM_AT24C16.c
  *      ChipON_AE/FAE_Group
  *     V3.0.0
  *     2021-08-20
  *     ļṩEERPOMдܺغ
  *
  *********************************************************************
*/
#include "system_init.h"
#include "EEPROM_AT24C16.h"
#include "Usart.h"
uint8_t i2c_buffer_write[BUFFER_SIZE];
uint8_t i2c_buffer_read[BUFFER_SIZE];


I2C_SFRmap* I2C_Choose;



//ʱ ֲvolatileܻᱻŻ
void Delay(volatile uint32_t cnt)
{
	while(cnt--);
}


/**
  *   eeprom дֽݡ
  *   write_addresseeprom 11λַ
  *           p_buffer: дָ
  *      number_of_byte дݳ   󳤶=16-(write_address %16),󳤶Ȼ ʼ ַʼ
  *   ޡ
  */
void eeprom_buffer_write(uint16_t Write_address,uint8_t *p_buffer,uint8_t number_of_byte)
{
	I2C_Choose=I2C0_SFR;//ѡI2C0_SFR I2C1_SFR I2C2_SFR I2C3_SFR

	I2C_Clear_INTERRUPT_Flag(I2C_Choose);                //I2Cжϱ־λISIFλ
	I2C_Cmd(I2C_Choose,TRUE);                            //ʹI2Cģ
	/*ʼλ*/
	I2C_Generate_START(I2C_Choose,TRUE);                 //ʹʼź
	while(!I2C_Get_INTERRUPT_Flag(I2C_Choose));

	/*I2Cӻַ*/
	I2C_SendData8(I2C_Choose,EEPROM_I2C_ADDRESS|((Write_address>>7)&0X0E));        //ʹӻI2Cַ
	I2C_Clear_INTERRUPT_Flag(I2C_Choose);                    //I2Cжϱ־λISIFλ
	while(!I2C_Get_INTERRUPT_Flag(I2C_Choose));              //ȴ
	while(I2C_Get_Ack_Fail_Flag(I2C_Choose));    //жǷACKӦûֹͣ


	/*͵λַ*/
	I2C_SendData8(I2C_Choose,Write_address);            //ʹӻλĴַ
	I2C_Clear_INTERRUPT_Flag(I2C_Choose);                //I2Cжϱ־λISIFλ
	while(!I2C_Get_INTERRUPT_Flag(I2C_Choose));          //ȴ

    /* ѭдݲ */
    while(number_of_byte--){
    	I2C_SendData8(I2C_Choose, *p_buffer);        //8λ
    	I2C_Clear_INTERRUPT_Flag(I2C_Choose);           //I2Cжϱ־λISIFλ
        /* ָһҪдֽ */
        p_buffer++;
        while(!I2C_Get_INTERRUPT_Flag(I2C_Choose));     //ȴ

    }

	/*ֹͣλ*/
	I2C_Generate_STOP(I2C_Choose,TRUE);         //ʹֹͣź

	I2C_Clear_INTERRUPT_Flag(I2C_Choose);       //I2Cжϱ־λISIFλ
	while(!I2C_Get_INTERRUPT_Flag(I2C_Choose)); //ȴֹͣ

	I2C_Clear_INTERRUPT_Flag(I2C_Choose);       //I2Cжϱ־λISIFλ
	I2C_Clear_Stop_Flag(I2C_Choose);            //I2Cֹͣ־λPIFλ
	I2C_Cmd(I2C_Choose,FALSE);                  //رI2Cģ

}



/**
  *   eeprom ֽݡ
  *   write_addresseeprom 8λĴַ
  *           p_buffer: ָ
  *      number_of_byteݳ
  *   ޡ
  */
void eeprom_buffer_read(uint16_t Write_address,uint8_t *p_buffer,uint8_t number_of_byte)
{

	I2C_Choose=I2C0_SFR;//ѡI2C0_SFR I2C1_SFR I2C2_SFR I2C3_SFR

	I2C_Cmd(I2C_Choose,TRUE);                            //ʹI2Cģ

	/*ʼλ*/
	I2C_Clear_INTERRUPT_Flag(I2C_Choose);                //I2Cжϱ־λISIFλ
	I2C_Generate_START(I2C_Choose,TRUE);                 //ʹʼź
	while(!I2C_Get_INTERRUPT_Flag(I2C_Choose));          //ȴʼλȶ



	/*I2Cӻַ*/
	I2C_SendData8(I2C_Choose,EEPROM_I2C_ADDRESS|((Write_address>>7)&0X0E));     //ʹӻI2Cַ
	I2C_Clear_INTERRUPT_Flag(I2C_Choose);                 //I2Cжϱ־λISIFλ
	while(!I2C_Get_INTERRUPT_Flag(I2C_Choose));           //ȴ
	while(I2C_Get_Ack_Fail_Flag(I2C_Choose));    //жǷACKӦûֹͣ


	/*ҪĴַ*/
	I2C_SendData8(I2C_Choose,Write_address);            //ʹӻλĴַ
	I2C_Clear_INTERRUPT_Flag(I2C_Choose);                //I2Cжϱ־λISIFλ
	while(!I2C_Get_INTERRUPT_Flag(I2C_Choose));          //ȴ


	I2C_Cmd(I2C_Choose,FALSE);                       //I2Cģ

	I2C_Clear_Start_Flag(I2C_Choose);               //I2Cʼ־λSIFλ
	I2C_Clear_INTERRUPT_Flag(I2C_Choose);           //־λISIFλ
	I2C_Cmd(I2C_Choose,TRUE);                       //I2Cģ
	/*ʼλ*/
	I2C_Clear_INTERRUPT_Flag(I2C_Choose);           //жϱ־λISIFλ
	I2C_Generate_START(I2C_Choose,TRUE);             //ʼź
	while(!I2C_Get_INTERRUPT_Flag(I2C_Choose));     //ȴʼλȶ


	/*Ͷָ*/
	I2C_SendData8(I2C_Choose,EEPROM_I2C_ADDRESS|0x01);//ʹӻַ
	I2C_Clear_INTERRUPT_Flag(I2C_Choose);           //־λISIFλ
	while(!I2C_Get_INTERRUPT_Flag(I2C_Choose));     //ȴISIF1
	while(I2C_Get_Ack_Fail_Flag(I2C_Choose));    //жǷACKӦûֹͣ
	I2C_Clear_INTERRUPT_Flag(I2C_Choose);           //Ȼ־λISIFλ


	while(number_of_byte)
	{
		 if(1 == number_of_byte)
		 {
			 I2C_Ack_DATA_Config(I2C_Choose,I2C_ACKDATA_NO_ACK);//ظNOACK
		 }else
		 {
			 I2C_Ack_DATA_Config(I2C_Choose,I2C_ACKDATA_ACK);//ظACK
		 }
		if(I2C_Get_Receive_Buff_Flag(I2C_Choose))     //жBuffǷΪ
		{
			while(!I2C_Get_INTERRUPT_Flag(I2C_Choose));
			*p_buffer = I2C_ReceiveData(I2C_Choose);
			if(1!= number_of_byte)
			{
				I2C_Clear_INTERRUPT_Flag(I2C_Choose);        //Ȼ־λISIFλ
			}

			p_buffer++;/* ָһȡֽڽλ */
			 /* ݼȡֽڼ */
			number_of_byte--;

		}
	}

	/*ֹͣλ*/
	I2C_Generate_STOP(I2C_Choose,TRUE);         //ʹֹͣź

	I2C_Clear_INTERRUPT_Flag(I2C_Choose);       //I2Cжϱ־λISIFλ
	while(!I2C_Get_INTERRUPT_Flag(I2C_Choose)); //ȴֹͣ

	I2C_Clear_INTERRUPT_Flag(I2C_Choose);       //I2Cжϱ־λISIFλ
	I2C_Clear_Stop_Flag(I2C_Choose);            //I2Cֹͣ־λPIFλ
	I2C_Cmd(I2C_Choose,FALSE);                  //رI2Cģ


}




/**
  *   д16ֽݲ16ֽݽбȽϡ
  *   
  *  1 ݶԱƥ䡣
  *     0 ݶԱȲƥ䡣
  */
uint8_t AT24C16_TEST(void)
{

	static volatile	uint16_t i;
	static volatile uint16_t j;

	uint8_t i2c_buffer_test;
	i=0;
	j=0;
    /* ʼi2cд */
    for(i = 0;i < BUFFER_SIZE;i++)
    {
    	i2c_buffer_write[i]=i;
    }

    Delay(0XFFFF);
    Delay(0XFFFF);
    Delay(0XFFFF);
    /* EEPROM д */
   eeprom_buffer_write(EEP_FIRST_PAGE,i2c_buffer_write,sizeof(i2c_buffer_write));

    Delay(0XFFFF);
    Delay(0XFFFF);
    Delay(0XFFFF);
    Delay(0XFFFF);
    Delay(0XFFFF);
    /* EEPROM ݶȡ */
    eeprom_buffer_read(EEP_FIRST_PAGE,i2c_buffer_read,sizeof(i2c_buffer_read));

    Delay(0XFFFF);
    Delay(0XFFFF);
    Delay(0XFFFF);
    Delay(0XFFFF);
    Delay(0XFFFF);

    for(j = 0;j < BUFFER_SIZE;j++)
    {
        if(i2c_buffer_read[j] != i2c_buffer_write[j])
        {
           return I2C_FAIL;
        }
    }
    return I2C_OK;
}







