/****************************************************************************************
 *
 * ļ: main.c
 * Ŀ: GPIO_Output
 *  :  V3.0.0
 *  :  2021-08-23
 *  :  ChipON_AE/FAE_Group
 *
 ****************************************************************************************/
#include "system_init.h"




typedef enum
{
  LED0 = 0,
  LED1 = 1,
  LED2 = 2,

} Led_TypeDef;

//LED1 IO  PB8
#define LEDn                             3
#define LED0_PIN                         GPIO_PIN_MASK_8
#define LED0_GPIO_PORT                   GPIOB_SFR

//LED2 IO  PB9
#define LED1_PIN                         GPIO_PIN_MASK_9
#define LED1_GPIO_PORT                   GPIOB_SFR

//LED0 IO  PB10
#define LED2_PIN                         GPIO_PIN_MASK_10
#define LED2_GPIO_PORT                   GPIOB_SFR



GPIO_SFRmap* GPIO_PORT[LEDn] = {LED0_GPIO_PORT, LED1_GPIO_PORT, LED2_GPIO_PORT};
const uint16_t GPIO_PIN[LEDn] = {LED0_PIN, LED1_PIN, LED2_PIN};



/**
  *   LEDƹܺ
  *  : Led: LED0 LED1 LED2
  *
  *   ޡ
  */
void Demo_LEDOn(Led_TypeDef Led)
{
  GPIO_Set_Output_Data_Bits(GPIO_PORT[Led],GPIO_PIN[Led],Bit_SET);					//Ϊߵƽ
}

/**
  *   ϨLEDƹܺ
  *  : Led:  LED0 LED1 LED2  *
  *   ޡ
  */
void Demo_LEDOff(Led_TypeDef Led)
{
	GPIO_Set_Output_Data_Bits(GPIO_PORT[Led],GPIO_PIN[Led],Bit_RESET);				//Ϊ͵ƽ
}

/**
  *   DEMOLEDƳʼá
  *  : Led:  LED0 LED1 LED2
  *
  *   ޡ
  */
void Demo_LEDInit(Led_TypeDef Led)
{
    GPIO_InitTypeDef  GPIO_InitStructure;
    GPIO_Struct_Init(&GPIO_InitStructure);
  /* GPIO_LED  */
    GPIO_InitStructure.m_Pin = GPIO_PIN[Led];

	GPIO_InitStructure.m_Speed = GPIO_LOW_SPEED;          //ʼ GPIOٶ
	GPIO_InitStructure.m_Mode = GPIO_MODE_OUT;            //ʼ GPIOΪ
	GPIO_InitStructure.m_PullUp = GPIO_NOPULL;            //ʼ GPIOǷ
	GPIO_InitStructure.m_PullDown = GPIO_NOPULL;          //ʼ GPIOǷ
    GPIO_Configuration(GPIO_PORT[Led], &GPIO_InitStructure);
}


//Ƶʱ120M 1msʱ
void delay_ms(volatile uint32_t nms)
{
	volatile uint32_t i,j;
	for(i=0;i<nms;i++)
	{
		j=5000;
		while(j--);
	}

}





//
void main()
{
	/*ûɲοKF32F350_demoʵGPIOùܡ
	 * ʹGPIO  PB8 PB9 PB10LED0 LED1 LED2,PB8 PB9 PB10Ϊ
	 * LED0 LED1 LED2Ƽ500ms ˸
	 */

	    //ϵͳʱ120M,Ƶʱ16M
		SystemInit();//ϵͳʱӳʼ
		GPIO_Reset(GPIOB_SFR);//λGPIOBʹGPIOBʱ
		Demo_LEDInit(LED0);
		Demo_LEDInit(LED1);
		Demo_LEDInit(LED2);
		while(1)
		{
			Demo_LEDOn(LED0);  //LED0
			Demo_LEDOn(LED1);  //LED1
			Demo_LEDOn(LED2);  //LED2
			delay_ms(500);

			Demo_LEDOff(LED0);  //LED0
			Demo_LEDOff(LED1);  //LED1
			Demo_LEDOff(LED2);  //LED2
			delay_ms(500);
		}
}


/**
  *    У鷢ļ
  *    file: ָļƵָ
  *      line У
  *   ޡ
  */
void check_failed(uint8_t* file, uint32_t line)
{
	  /* ûԼĴʵֱļк,
	             : printf("Wrong parameters value: file %s on line %d\r\n", file, line) */

	  while(1)
	  {
		  ;
	  }
}
