/****************************************************************************************
 *
 * ļ: main.c
 * Ŀ: GPIO_Input
 *  :  V3.0.0
 *  :  2021-08-23
 *  :  ChipON_AE/FAE_Group
 *
 ****************************************************************************************/
#include "system_init.h"

#define    KEY2    GPIO_Read_Input_Data_Bit(GPIOD_SFR,GPIO_PIN_MASK_6)  //ȡPD6ƽ
//ʱ ֲvolatileܻᱻŻ
//Ƶʱ120M 1msʱ
void delay_ms(volatile uint32_t nms)
{
	volatile uint32_t i,j;
	for(i=0;i<nms;i++)
	{
		j=700;
		while(j--);
	}

}


/**
  *   GPIOx ʼá
  *  : GPIOx: ָGPIOڴṹָ룬ȡֵΪGPIOA_SFR~GPIOH_SFR
  *       GpioPin: ˿룬ȡֵΪGPIO_PIN_MASK_0~GPIO_PIN_MASK_15еһϡ
  *   ޡ
  */
void GPIOInit_Output_Config(GPIO_SFRmap* GPIOx,uint16_t GpioPin)
{
	/*ʼλGPIOx裬ʹGPIOxʱ*/
		GPIO_Reset(GPIOx);

	/*  PxyΪģʽ */
	GPIO_InitTypeDef GPIO_InitStructure;
	GPIO_Struct_Init(&GPIO_InitStructure);
	GPIO_InitStructure.m_Pin = GpioPin;
	GPIO_InitStructure.m_Speed = GPIO_LOW_SPEED;          //ʼ GPIOٶ
	GPIO_InitStructure.m_Mode = GPIO_MODE_OUT;            //ʼ GPIOΪ
	GPIO_InitStructure.m_PullUp = GPIO_NOPULL;            //ʼ GPIOǷ
	GPIO_InitStructure.m_PullDown = GPIO_NOPULL;          //ʼ GPIOǷ
	GPIO_Configuration(GPIOx,&GPIO_InitStructure);

	GPIO_Set_Output_Data_Bits(GPIOx,GpioPin,Bit_SET);					//Ϊߵƽ

}

/**
  *   GPIOx ʼá
  *  : GPIOx: ָGPIOڴṹָ룬ȡֵΪGPIOA_SFR~GPIOH_SFR
  *       GpioPin: ˿룬ȡֵΪGPIO_PIN_MASK_0~GPIO_PIN_MASK_15еһϡ
  *   ޡ
  */
void GPIOInit_Input_Config(GPIO_SFRmap* GPIOx,uint16_t GpioPin)
{
	/*ʼλGPIOx裬ʹGPIOxʱ*/
		GPIO_Reset(GPIOx);

	/*  PxyΪģʽ */
	GPIO_InitTypeDef GPIO_InitStructure;
	GPIO_Struct_Init(&GPIO_InitStructure);
	GPIO_InitStructure.m_Pin = GpioPin;
	GPIO_InitStructure.m_Speed = GPIO_LOW_SPEED;                   //ʼ GPIOٶ
	GPIO_InitStructure.m_Mode = GPIO_MODE_IN;                      //ʼ GPIOΪ
	GPIO_InitStructure.m_PullUp = GPIO_NOPULL;                     //ʼ GPIOǷ 
	GPIO_InitStructure.m_PullDown = GPIO_NOPULL;                   //ʼ GPIOǷ 
	GPIO_Configuration(GPIOx,&GPIO_InitStructure);
}


/**
  *   GPIOx ʼá
  *  : 
  *   ޡ
  */
void GPIO_Init(void)
{
	GPIOInit_Input_Config(GPIOD_SFR,GPIO_PIN_MASK_6);//PD6Ϊģʽ
	GPIOInit_Output_Config(GPIOB_SFR,GPIO_PIN_MASK_8|GPIO_PIN_MASK_9|GPIO_PIN_MASK_10);  //PB8 PB9 PB10ʼߵƽ
}

//
void main()
{
	/*ûɲοKF32F350_demoʵGPIOùܡ
	 * ʹGPIO PD6ΪIO PB8 PB9 PB10Ϊ
	 * KEY2£LED0 LED1ϨٴΰLED0 LED1Ƶ
	 */

	//ϵͳʱ120M,Ƶʱ16M
	SystemInit();//ϵͳʱӳʼ

	//GPIOʼ
	GPIO_Init();   //PD6Ϊģʽ PB8 PB9 PB10ʼߵƽ

	while(1)
	{
		static uint8_t stalock=0;
        if(KEY2)
        {
        	delay_ms(50);   //ʱ50ms
        	if(KEY2 &&(stalock==0))         //а
        	{
        		stalock=1;
        		GPIO_Toggle_Output_Data_Config (GPIOB_SFR,GPIO_PIN_MASK_8);//PB8ת,LED0Ϩ
        		GPIO_Toggle_Output_Data_Config (GPIOB_SFR,GPIO_PIN_MASK_9);//PB9ת,LED1Ϩ
        	}

        }
        else
        {
        	stalock=0;
        }

	}		
}


/**
  *    У鷢ļ
  *    file: ָļƵָ
  *      line У
  *   ޡ
  */
void check_failed(uint8_t* file, uint32_t line)
{
	  /* ûԼĴʵֱļк,
	             : printf("Wrong parameters value: file %s on line %d\r\n", file, line) */

	  while(1)
	  {
		  ;
	  }
}
