/****************************************************************************************
  *
  * ļ  main.c
  *     ChipON_AE/FAE_Group
  *     V3.0.0
  *     2021-08-23
  *     ļṩflashдӦ̲ο
  *
 ****************************************************************************************/
#include "system_init.h"
#include "flash.h"



#define			FLASH_BUFFER_MAX	    256         //ҳݸ
#define			FLASH_BUFFER_Halfpage	128         //ҳݸ
uint32_t     	FLASH_BUFFER[FLASH_BUFFER_MAX];     //ҳдʱõ
uint32_t     	FLASH_BUFFER_CFG[FLASH_BUFFER_MAX];  //Ϣҳдʱõ
uint32_t     	FLASH_BUFFER_HALFPAGE[FLASH_BUFFER_Halfpage];   //ҳдõ
uint32_t     	FLASH_BUFFER_Read[FLASH_BUFFER_MAX];            //ҳʱõ




//Ƶʱ120M 1msʱ
void delay_ms(volatile uint32_t nms)
{
	volatile uint32_t i,j;
	for(i=0;i<nms;i++)
	{
		j=5000;
		while(j--);
	}

}


/**
  *   GPIOx ʼá
  *  : GPIOx: ָGPIOڴṹָ룬ȡֵΪGPIOA_SFR~GPIOH_SFR
  *       GpioPin: ˿룬ȡֵΪGPIO_PIN_MASK_0~GPIO_PIN_MASK_15еһϡ
  *   ޡ
  */
void GPIOInit_Output_Config(GPIO_SFRmap* GPIOx,uint16_t GpioPin)
{
	/*ʼλGPIOx裬ʹGPIOxʱ*/
		GPIO_Reset(GPIOx);

	/*  PxyΪģʽ */
	GPIO_InitTypeDef GPIO_InitStructure;
	GPIO_Struct_Init(&GPIO_InitStructure);
	GPIO_InitStructure.m_Pin = GpioPin;
	GPIO_InitStructure.m_Speed = GPIO_LOW_SPEED;          //ʼ GPIOٶ
	GPIO_InitStructure.m_Mode = GPIO_MODE_OUT;            //ʼ GPIOΪ
	GPIO_InitStructure.m_PullUp = GPIO_NOPULL;            //ʼ GPIOǷ
	GPIO_InitStructure.m_PullDown = GPIO_NOPULL;          //ʼ GPIOǷ
	GPIO_Configuration(GPIOx,&GPIO_InitStructure);

	GPIO_Set_Output_Data_Bits(GPIOx,GpioPin,Bit_RESET);	  //Ϊ͵ƽ

}


/**
  *   дݶԱ
  *  : 
  *
  *   Flash_OKƥ
  *   Flash_FAILݲƥ
  */
uint8_t flash_test (void)
{
	volatile uint16_t j;
    for(j = 0;j < FLASH_BUFFER_MAX;j++)
    {
        if(FLASH_BUFFER_Read[j]!= FLASH_BUFFER[j])
        {
           return Flash_FAIL;
        }
    }
    return Flash_OK;
}


//
void main()
{
	/*ûɲοKF32F350_demoʵflashдùܡ
	 * дܣڳ0x32000ַдֽ0XAA,0x32400ַڵҳд0x0100~0x7F00,
	 *              0x32800ַҳд0x1000~0x90000,0x32C00ַڵҳдab
	 *              0x7000ַдҳݣ0x8000ַдҳ
	 *              Ϣû0x1C00дҳ
	 *      ܣ ָ  0x32000ַһԭдݶԱƥPB8תLED0˸
	 *              ָûϢ 0x1C04ַһԭдݶԱƥPB9תLED1˸
	 *              ָ 0x8000ַһҳԭдԱƥPB10תLED2˸
	 *     ͨȡжϵķʽȷдǷȷҲͨKF32 PRO߲ҳflash
	 *     Ƿȷ(ǰflashܼܣKF32 PROȫΪ)
	 *
	 *עָflashַ ͨPROȷǷдв
	 *
	 */
	uint8_t INTstate=0;
	uint32_t i=0;
    uint32_t temp=0;
    uint32_t temp1=0;
    uint32_t temp2=0;

    //ϵͳʱ120M,Ƶʱ16M
	SystemInit();//ϵͳʱӳʼ
	FLASH_CFG=0xC3;//flashȡ4
	//ʼPB8 PB9 PB10͵ƽ
	GPIOInit_Output_Config(GPIOB_SFR,GPIO_PIN_MASK_8|GPIO_PIN_MASK_9|GPIO_PIN_MASK_10);


	//дֽByte
	uint32_t addrtest=0x00032000;

    if(INT_CTL0 & 0xfffe)			//жʹܣرжʹܣ
    {
    	INTstate=1;
    	INT_All_Enable(FALSE);   	//ֹж
    }
	FLASH_Wipe_Configuration_RAM(FLASH_WIPE_CODE_PAGE,addrtest);//ҳ1K ռ  page200=200*1024=0x0003 2000;
	if(INTstate==1)
	{
		INTstate=0;
		INT_All_Enable(TRUE);    //ж
	}

	uint8_t num8=0;
	uint8_t read_byte=0;

    if(INT_CTL0 & 0xfffe)			//жʹܣرжʹܣ
    {
    	INTstate=1;
    	INT_All_Enable(FALSE);   	//ֹж
    }
	FLASH_WriteByte(addrtest,0xAA);
	if(INTstate==1)
	{
		INTstate=0;
		INT_All_Enable(TRUE);    //ж
	}

	delay_ms(10);
	addrtest=0x00032000;
	FLASH_ReadByte(addrtest,&read_byte);


	//дhalword
	addrtest=0x00032400;

    if(INT_CTL0 & 0xfffe)			//жʹܣرжʹܣ
    {
    	INTstate=1;
    	INT_All_Enable(FALSE);   	//ֹж
    }
	FLASH_Wipe_Configuration_RAM(FLASH_WIPE_CODE_PAGE,addrtest);//ҳ1K ռ  page201=201*1024=0x0003 2400;
	if(INTstate==1)
	{
		INTstate=0;
		INT_All_Enable(TRUE);    //ж
	}

	uint16_t num16=0;
	uint16_t read_halword=0;
	for(i=0;i<128;i++)//һҳ1024byteһд64bit=8byte128
	{
	    if(INT_CTL0 & 0xfffe)			//жʹܣرжʹܣ
	    {
	    	INTstate=1;
	    	INT_All_Enable(FALSE);   	//ֹж
	    }
		FLASH_WriteHalfWord(addrtest,num16);//
		if(INTstate==1)
		{
			INTstate=0;
			INT_All_Enable(TRUE);    //ж
		}
		FLASH_ReadHalWord(addrtest,&read_halword);
		num16+=256;
		addrtest+=8;
	}


	//дһword
	addrtest=0x00032800;

    if(INT_CTL0 & 0xfffe)			//жʹܣرжʹܣ
    {
    	INTstate=1;
    	INT_All_Enable(FALSE);   	//ֹж
    }
	FLASH_Wipe_Configuration_RAM(FLASH_WIPE_CODE_PAGE,addrtest);//ҳ1K ռ  page202=202*1024=0x0003 2800;
	if(INTstate==1)
	{
		INTstate=0;
		INT_All_Enable(TRUE);    //ж
	}

	uint32_t num32=0;
	uint32_t read_word=0;
	for(i=0;i<128;i++)//һҳ1024byteһд64bit=8byte128
	{
	    if(INT_CTL0 & 0xfffe)			//жʹܣرжʹܣ
	    {
	    	INTstate=1;
	    	INT_All_Enable(FALSE);   	//ֹж
	    }
		FLASH_WriteWord(addrtest,num32);//
		if(INTstate==1)
		{
			INTstate=0;
			INT_All_Enable(TRUE);    //ж
		}

		FLASH_ReadWord(addrtest,&read_word);
		num32+=65536;
		addrtest+=8;


	}


	//ֽڶд
    addrtest=0x00032C00;   //ָflashַ

    if(INT_CTL0 & 0xfffe)			//жʹܣرжʹܣ
    {
    	INTstate=1;
    	INT_All_Enable(FALSE);   	//ֹж
    }
	FLASH_Wipe_Configuration_RAM(FLASH_WIPE_CODE_PAGE,addrtest);//ҳ1K ռ  page203=203*1024=0x0003 2C00;
	if(INTstate==1)
	{
		INTstate=0;
		INT_All_Enable(TRUE);    //ж
	}

	uint8_t a[10]={0,1,2,3,4,5,6,7,8,9};
	uint8_t b[10]={0,0,0,0,0,0,0,0,0,0};

    if(INT_CTL0 & 0xfffe)			//жʹܣرжʹܣ
    {
    	INTstate=1;
    	INT_All_Enable(FALSE);   	//ֹж
    }
	FLASH_WriteNByte(addrtest,a,10);
	if(INTstate==1)
	{
		INTstate=0;
		INT_All_Enable(TRUE);    //ж
	}

	FLASH_ReadNByte(addrtest,b,10);




//--- ׼д1280x0000 0x1111 0x2222...0xFFFF  0x1110  0x2221  0x3332 ...0xFFFE 0x110F
	for (i = 0; i < FLASH_BUFFER_Halfpage; i++)
	{
		FLASH_BUFFER_HALFPAGE[i] = temp;
		temp += 0x1111;
	}

    if(INT_CTL0 & 0xfffe)			//жʹܣرжʹܣ
    {
    	INTstate=1;
    	INT_All_Enable(FALSE);   	//ֹж
    }
	//ҳд
	FLASH_HALFPAGE_WRITECODE_fun(0x7000,FLASH_BUFFER_HALFPAGE,63); //Ѱҳд0x7000 ڳflash
	if(INTstate==1)
	{
		INTstate=0;
		INT_All_Enable(TRUE);    //ж
	}

//--- ׼д2560x0000 0x1111 0x2222...0xFFFF  0x1110  0x2221  0x3332 ...0xFFFE 0x110F
	for (i = 0; i < FLASH_BUFFER_MAX; i++)
	{
		FLASH_BUFFER[i] = temp1;
		temp1 += 0x1111;
	}

    if(INT_CTL0 & 0xfffe)			//жʹܣرжʹܣ
    {
    	INTstate=1;
    	INT_All_Enable(FALSE);   	//ֹж
    }
	//ҳд
	FLASH_PageWrite_fun(0x8000,FLASH_BUFFER,128);     //һҳд0x8000 ڳflash PAGE

//********************û*******************///
//--- ׼д2560x0000 0x1111 0x2222...0xFFFF  0x1110  0x2221  0x3332 ...0xFFFE 0x110F
	for (i = 0; i < FLASH_BUFFER_MAX; i++)
	{
		FLASH_BUFFER_CFG[i] = temp2;
		temp2 += 0x1111;
	}
	//Ϣûҳд
	FLASH_PageWrite_CFG_fun(0x1C00,FLASH_BUFFER_CFG,128); //һҳд0x1C00 ûflash PAGE
	if(INTstate==1)
	{
		INTstate=0;
		INT_All_Enable(TRUE);    //ж
	}

	delay_ms(200);   //ʱ200ms
	//ҳ
	FLASH_READCODE_fun(0x8000,FLASH_BUFFER_Read,256); //0x8000һҳ


	while(1)
    {
       /*ַΪ0x32000ݲȽ*/
		if(Read_Flash_or_CFR_RAM(0x32000,FLASH_PROGRAM_CODE)==0xAA)
		{
			GPIO_Toggle_Output_Data_Config (GPIOB_SFR,GPIO_PIN_MASK_8);//PB8ת,LED0Ϩ
			delay_ms(100);   //ʱ100ms
		}

		 /*ϢûַΪ0x1C04ݲȽ*/
		if(Read_Flash_or_CFR_RAM(0x1C04,FLASH_PROGRAM_CFG)==0x00001111)
		{
			GPIO_Toggle_Output_Data_Config (GPIOB_SFR,GPIO_PIN_MASK_9);//PB9ת,LED1Ϩ
			delay_ms(100);   //ʱ100ms
		}

		/*ѶַΪ0x8000ҳݲȽ*/
		if(Flash_OK == flash_test())//дflashǷƥ
		{
			GPIO_Toggle_Output_Data_Config(GPIOB_SFR,GPIO_PIN_MASK_10); //PB10ת,LED2Ϩ
			delay_ms(200);   //ʱ200ms
		}

    }

}



/**
  *    У鷢ļ
  *    file: ָļƵָ
  *      line У
  *   ޡ
  */
void check_failed(uint8_t* file, uint32_t line)
{
	  /* ûԼĴʵֱļк,
	             : printf("Wrong parameters value: file %s on line %d\r\n", file, line) */

	  while(1)
	  {
		  ;
	  }
}

