/**
  ********************************************************************
  * ļ  flash.c
  *      ChipON_AE/FAE_Group
  *     V3.0.0
  *     2021-08-23
  *     ļṩflashӦöд
  *
  *********************************************************************
*/
#include"flash.h"
#include "system_init.h"
FLASH_ProgramTypeDef flash_write;


/**
  *   flash д˫ֽݣд32λݣ
  *   address ָflash  ַ
  *  p_FlashBuffer: дݵָ
  *
  *   ޡ
  * дflashע˵ҳַָڵһҳ128˫ֵַݶ
  */
void FLASH_WriteCODE_ONE(uint32_t address,uint32_t *p_FlashBuffer)
{

	//	//--------------------------------------------------------------------------------------------
		FLASH_Wipe_Configuration_RAM(FLASH_WIPE_CODE_PAGE,address);//ҳ

		flash_write.m_Mode=FLASH_PROGRAM_WORD;//FLASH_PROGRAM_HALF_PAGE //FLASH_PROGRAM_WORD
		flash_write.m_Zone=FLASH_PROGRAM_CODE;//FLASH_PROGRAM_CFG  FLASH_PROGRAM_CODE
		flash_write.m_Addr=address;
		flash_write.m_WriteSize=1;//ҳ̲Ϊ0д1+1ʵд2˫ ֱӰ
		flash_write.m_Data=p_FlashBuffer;
		FLASH_Program_Configuration_RAM(&flash_write);
}

/*
*
* ҳ̣ҳСڰҳдݵFLASH1~63ַΪҳ׵ַ ʮ½β000 400 800 C00
* 			ַҳ׵ַȷҳΪ0xFFFFǰҳдʹֵ0xFFFFд쳣
* address дַ
*          p_FlashBuffer дַָ
*          length        дݳȡֵ1~63
*  һд64λ˫ֽڣ63ʱʵд루63+1*2=12832λݣûвݣϵͳһдflash
*           
* дflashע˵ҳַָڵһҳ128˫ֵַݶ
*/
void FLASH_HALFPAGE_WRITECODE_fun(uint32_t address,uint32_t *p_FlashBuffer,uint32_t length)
{

		FLASH_Wipe_Configuration_RAM(FLASH_WIPE_CODE_PAGE,address);//ҳ

		flash_write.m_Mode=FLASH_PROGRAM_HALF_PAGE;//FLASH_PROGRAM_HALF_PAGE //FLASH_PROGRAM_WORD
		flash_write.m_Zone=FLASH_PROGRAM_CODE;//FLASH_PROGRAM_CFG  FLASH_PROGRAM_CODE
		flash_write.m_Addr=address;
		flash_write.m_WriteSize=length;//ҳ̲Ϊ0д1+1ʵд2˫ ֱӰ
		flash_write.m_Data=p_FlashBuffer;
		FLASH_Program_Configuration_RAM(&flash_write);
}

/*
*
* ҳдݵFLASHֻΪ128 ַΪҳ׵ַ ʮ½β000 400 800 C00
* 			ַҳ׵ַȷΪ0xFFFFǰдʹҳֵ0xFFFFд쳣
* address дַ
*          p_FlashBuffer дַָ
*          length        дݳ(ֻΪ128)
*           
* дflashע˵ҳַָڵһҳ128˫ֵַݶҳֻ64˫ֽдҳдҪΰҳд
*/
void FLASH_PageWrite_fun(uint32_t address,uint32_t *p_FlashBuffer,uint8_t length)
{
	volatile uint8_t i;
	static uint32_t Flash_Buff1[128];
	static uint32_t Flash_Buff2[128];

	//	//--------------------------------------------------------------------------------------------
		FLASH_Wipe_Configuration_RAM(FLASH_WIPE_CODE_PAGE,address);//ҳ

		//--------------------------------------------------------------------------------------------
		for (i = 0; i < length; i++)
		{
			Flash_Buff1[i] =*p_FlashBuffer;
			p_FlashBuffer ++;
		}

		flash_write.m_Mode=FLASH_PROGRAM_HALF_PAGE;//FLASH_PROGRAM_HALF_PAGE //FLASH_PROGRAM_WORD
		flash_write.m_Zone=FLASH_PROGRAM_CODE;//FLASH_PROGRAM_CFG  FLASH_PROGRAM_CODE
		flash_write.m_Addr=address;
		flash_write.m_WriteSize=63;//ҳ̲Ϊ0д1+1ʵд2˫ ֱӰ
		flash_write.m_Data=Flash_Buff1;
		FLASH_Program_Configuration_RAM(&flash_write);


		for (i = 0; i < length; i++)
		{
			Flash_Buff2[i] = *p_FlashBuffer;
			p_FlashBuffer ++;
		}

		flash_write.m_Mode=FLASH_PROGRAM_HALF_PAGE;//FLASH_PROGRAM_HALF_PAGE //FLASH_PROGRAM_WORD
		flash_write.m_Zone=FLASH_PROGRAM_CODE;//FLASH_PROGRAM_CFG  FLASH_PROGRAM_CODE
		flash_write.m_Addr=address+0x200;
		flash_write.m_WriteSize=63;//ҳ̲Ϊ0д1+1ʵд2˫ ֱӰ
		flash_write.m_Data=Flash_Buff2;
		FLASH_Program_Configuration_RAM(&flash_write);


}


/**
  *   flash ֽ
  *   address ָflashַ
  *  p_FlashBuffer: дݵָ
  *  length:дݵĳ
  *   ޡ
  */
void FLASH_READCODE_fun(uint32_t address,uint32_t *p_FlashBuffer,uint32_t length)
{

	volatile uint32_t read_num;

	for(read_num=0;read_num<length;read_num++)
	{
		*p_FlashBuffer=Read_Flash_or_CFR_RAM(address,FLASH_PROGRAM_CODE);
		p_FlashBuffer++;
		address=address+0x0004;
	}
}






/*******************************************Ϣûд*********************************************/
/**
  *   flash Ϣûд˫ֽݣд32λݣ
  *   address ָflashûַ0x1C00~0X1FF8ַʮ½β0x1C00 0x1C08  0x1E00 0x1E08
  * p_FlashBuffer: дݵָ
  *
  *   ޡ
  * дflashע˵ҳַָڵһҳ128˫ֵַݶ
  */
void FLASH_WriteCFG_ONE(uint32_t address,uint32_t *p_FlashBuffer)
{

	//	//--------------------------------------------------------------------------------------------
		FLASH_Wipe_Configuration_RAM(FLASH_WIPE_CFG_PAGE,address);//ҳ

		flash_write.m_Mode=FLASH_PROGRAM_WORD;//FLASH_PROGRAM_HALF_PAGE //FLASH_PROGRAM_WORD
		flash_write.m_Zone=FLASH_PROGRAM_CFG;//FLASH_PROGRAM_CFG  FLASH_PROGRAM_CODE
		flash_write.m_Addr=address;
		flash_write.m_WriteSize=1;//ҳ̲Ϊ0д1+1ʵд2˫ ֱӰ
		flash_write.m_Data=p_FlashBuffer;
		FLASH_Program_Configuration_RAM(&flash_write);
}

/*
* ûҳ̣ҳСڰҳдݵFLASH1~63ַΪҳ׵ַ ʮ½β000 400 800 C00
* 			ַҳ׵ַȷҳΪ0xFFFFǰҳдʹֵ0xFFFFд쳣
* address ָûַ0x1C00~0X1FF8
*          p_FlashBuffer дַָ
*          length        дݳȡֵ1~63
*  һд64λ˫ֽڣ63ʱʵд루63+1*2=12832λݣûвݣϵͳһдflash
*           
* дflashע˵ҳַָڵһҳ128˫ֵַݶ
*/
void FLASH_HALFPAGE_WRITECFG_fun(uint32_t address,uint32_t *p_FlashBuffer,uint32_t length)
{

		FLASH_Wipe_Configuration_RAM(FLASH_WIPE_CFG_PAGE,address);//ҳ

		flash_write.m_Mode=FLASH_PROGRAM_HALF_PAGE;//FLASH_PROGRAM_HALF_PAGE //FLASH_PROGRAM_WORD
		flash_write.m_Zone=FLASH_PROGRAM_CFG;//FLASH_PROGRAM_CFG  FLASH_PROGRAM_CODE
		flash_write.m_Addr=address;
		flash_write.m_WriteSize=length;//ҳ̲Ϊ0д1+1ʵд2˫ ֱӰ
		flash_write.m_Data=p_FlashBuffer;
		FLASH_Program_Configuration_RAM(&flash_write);
}


/*
*
* ûҳдݵFLASHֻΪ128 ַΪҳ׵ַ ʮ½β000 400 800 C00
* 			ַҳ׵ַȷΪ0xFFFFǰдʹҳֵ0xFFFFд쳣
* address дַĿǰŵֻһPAGE ׵ַֻܴ0x1C00ʼ
*          p_FlashBuffer дַָ
*          length        дݳ(ֻΪ128)
*           
* дflashע˵ҳַָڵһҳ128˫ֵַݶҳֻ64˫ֽдҳдҪΰҳд
*/
void FLASH_PageWrite_CFG_fun(uint32_t address,uint32_t *p_FlashBuffer,uint8_t length)
{
	volatile uint8_t i;
	static uint32_t Flash_Buff1[128];
	static uint32_t Flash_Buff2[128];

	//	//--------------------------------------------------------------------------------------------
		FLASH_Wipe_Configuration_RAM(FLASH_WIPE_CFG_PAGE,address);//Ϣûҳ

		//--------------------------------------------------------------------------------------------
		for (i = 0; i < length; i++)
		{
			Flash_Buff1[i] =*p_FlashBuffer;
			p_FlashBuffer ++;
		}

		flash_write.m_Mode=FLASH_PROGRAM_HALF_PAGE;//FLASH_PROGRAM_HALF_PAGE //FLASH_PROGRAM_WORD
		flash_write.m_Zone=FLASH_PROGRAM_CFG;//FLASH_PROGRAM_CFG  FLASH_PROGRAM_CODE
		flash_write.m_Addr=address;
		flash_write.m_WriteSize=63;//ҳ̲Ϊ0д1+1ʵд2˫ ֱӰ
		flash_write.m_Data=Flash_Buff1;
		FLASH_Program_Configuration_RAM(&flash_write);


		for (i = 0; i < length; i++)
		{
			Flash_Buff2[i] = *p_FlashBuffer;
			p_FlashBuffer ++;
		}

		flash_write.m_Mode=FLASH_PROGRAM_HALF_PAGE;//FLASH_PROGRAM_HALF_PAGE //FLASH_PROGRAM_WORD
		flash_write.m_Zone=FLASH_PROGRAM_CFG;//FLASH_PROGRAM_CFG  FLASH_PROGRAM_CODE
		flash_write.m_Addr=address+0x200;
		flash_write.m_WriteSize=63;//ҳ̲Ϊ0д1+1ʵд2˫ ֱӰ
		flash_write.m_Data=Flash_Buff2;
		FLASH_Program_Configuration_RAM(&flash_write);


}


/**
  *   flash дֽ
  *   address ָflashַ
  *  p_FlashBuffer: дݵָ
  *
  *   ޡ
  * עдǰҪȲַڵҳ
  */
void FLASH_WriteByte(uint32_t address,uint8_t p_FlashBuffer)
{
	    uint32_t num32[2];
	    uint32_t *flash_write_num;
	    num32[0]=p_FlashBuffer;
	    num32[1]=0;
		flash_write_num=num32;
		//--------------------------------------------------------------------------------------------

	    flash_write.m_Mode=FLASH_PROGRAM_WORD;//FLASH_PROGRAM_HALF_PAGE //FLASH_PROGRAM_WORD
		flash_write.m_Zone=FLASH_PROGRAM_CODE;//FLASH_PROGRAM_CFG  FLASH_PROGRAM_CODE
		flash_write.m_Addr=address;
		flash_write.m_WriteSize=1;//ҳ̲Ϊ0д1+1ʵд2˫ ֱӰ
		flash_write.m_Data=flash_write_num;
		FLASH_Program_Configuration_RAM(&flash_write);
}

/**
  *   flash д
  *   address ָflashַ
  *  p_FlashBuffer: дݵָ
  *
  *   ޡ
  * עдǰҪȲַڵҳ
  */
void FLASH_WriteHalfWord(uint32_t address,uint16_t p_FlashBuffer)
{
	    uint32_t num32[2];
	    uint32_t *flash_write_num;
	    num32[0]=p_FlashBuffer;
	    num32[1]=0;
		flash_write_num=num32;
		//--------------------------------------------------------------------------------------------

	    flash_write.m_Mode=FLASH_PROGRAM_WORD;//FLASH_PROGRAM_HALF_PAGE //FLASH_PROGRAM_WORD
		flash_write.m_Zone=FLASH_PROGRAM_CODE;//FLASH_PROGRAM_CFG  FLASH_PROGRAM_CODE
		flash_write.m_Addr=address;
		flash_write.m_WriteSize=1;//ҳ̲Ϊ0д1+1ʵд2˫ ֱӰ
		flash_write.m_Data=flash_write_num;
		FLASH_Program_Configuration_RAM(&flash_write);
}

/**
  *   flash д
  *   address ָflashַ
  *  p_FlashBuffer: дݵָ
  *
  *   ޡ
  * עдǰҪȲַڵҳ
  */
void FLASH_WriteWord(uint32_t address,uint32_t p_FlashBuffer)
{
	    uint32_t num32[2];
	    uint32_t *flash_write_num;
	    num32[0]=p_FlashBuffer;
	    num32[1]=0;
		flash_write_num=num32;
		//--------------------------------------------------------------------------------------------

	    flash_write.m_Mode=FLASH_PROGRAM_WORD;//FLASH_PROGRAM_HALF_PAGE //FLASH_PROGRAM_WORD
		flash_write.m_Zone=FLASH_PROGRAM_CODE;//FLASH_PROGRAM_CFG  FLASH_PROGRAM_CODE
		flash_write.m_Addr=address;
		flash_write.m_WriteSize=1;//ҳ̲Ϊ0д1+1ʵд2˫ ֱӰ
		flash_write.m_Data=flash_write_num;
		FLASH_Program_Configuration_RAM(&flash_write);
}





/**
  *   flash дֽ
  *   address ָflashַ
  *  p_FlashBuffer: дݵָ
  *    lengݵĳ
  *   ޡ
  * עдǰҪȲַڵҳ
  */
void FLASH_WriteNByte(uint32_t address,uint8_t *p_FlashBuffer,uint32_t leng)//ַΪ8
{
	uint32_t i;
	for(i=0;i<leng;i++)//һҳ1024byteһд64bit=8byte128
	{
		FLASH_WriteByte(address,*p_FlashBuffer);//
		p_FlashBuffer++;
		address+=8;
	}
}

/**
  *   flash ֽ
  *   address ָflashַ
  *  p_FlashBuffer: ݵָ
  *
  *   read_buf:ֽ
  *
  */
uint32_t FLASH_ReadByte(uint32_t address,uint8_t *p_FlashBuffer) //
{
	uint32_t read_buf;
	read_buf=Read_Flash_or_CFR_RAM(address,FLASH_PROGRAM_CODE);
	*p_FlashBuffer=read_buf;

	return read_buf;
}

/**
  *   flash 
  *   address ָflashַ
  *  p_FlashBuffer: ݵָ
  *
  *   read_buf:
  *
  */
uint32_t FLASH_ReadHalWord(uint32_t address,uint16_t *p_FlashBuffer)
{
	uint32_t read_buf;
	read_buf=Read_Flash_or_CFR_RAM(address,FLASH_PROGRAM_CODE);
	*p_FlashBuffer=read_buf;

	return read_buf;
}

/**
  *   flash 
  *   address ָflashַ
  *  p_FlashBuffer: ݵָ
  *
  *   read_buf:
  *
  */
uint32_t FLASH_ReadWord(uint32_t address,uint32_t *p_FlashBuffer)
{
	uint32_t read_buf;
	read_buf=Read_Flash_or_CFR_RAM(address,FLASH_PROGRAM_CODE);
	*p_FlashBuffer=read_buf;

	return read_buf;
}

/**
  *   flash ζֽ
  *   address ָflashַ
  *  p_FlashBuffer: ݵָ
  *   lengָݳ
  *   
  *
  */
void FlashReadNByte(unsigned int Address, unsigned int Length, unsigned char *Buffers)//ַΪ8
{
	for (int i = 0; i < Length; i++)
	{
		Buffers[i] = *(unsigned char *)Address++;
	}
}

