/****************************************************************************************
 *
 * ļ: main.c
 * Ŀ: DAC_SineWave_DMA
 *  :  V2.1
 *  :  20191116
 *  :  ChipON_AE/FAE_Group
 *
 ****************************************************************************************/
#include "system_init.h"

#define DAC0_DAHD_Address      0x40000704      //DAC0_DAHDļĴַ
#define DAC1_DAHD_Address      0x40000784      //DAC1_DAHDļĴַ
#define TriggerEINT9_ENABLE     0             //ԴжEINT9  1 0
//DMAʹñ
DMA_SFRmap * DMA_CHOOSE;


// DAC
const uint16_t Sine12bit[32] = {
                      2047, 2447, 2831, 3185, 3498, 3750, 3939, 4056, 4094, 4056,
                      3939, 3750, 3495, 3185, 2831, 2447, 2047, 1647, 1263, 909,
                      599, 344, 155, 38, 0, 38, 155, 344, 599, 909, 1263, 1647};


uint32_t DualSine12bit[32];//Ҳ

uint32_t Idx = 0;




/**
  *   GPIOx ʼá
  *  : GPIOx: ָGPIOڴṹָ룬ȡֵΪGPIOA_SFR~GPIOH_SFR
  *       GpioPin: ˿룬ȡֵΪGPIO_PIN_MASK_0~GPIO_PIN_MASK_15еһϡ
  *   ޡ
  */
void GPIOInit_Output_Config(GPIO_SFRmap* GPIOx,uint16_t GpioPin)
{
	/*ʼλGPIOx裬ʹGPIOxʱ*/
		GPIO_Reset(GPIOx);

	/*  PxyΪģʽ */
	GPIO_InitTypeDef GPIO_InitStructure;
	GPIO_Struct_Init(&GPIO_InitStructure);
	GPIO_InitStructure.m_Pin = GpioPin;
	GPIO_InitStructure.m_Speed = GPIO_LOW_SPEED;          //ʼ GPIOٶ
	GPIO_InitStructure.m_Mode = GPIO_MODE_OUT;            //ʼ GPIOΪ
	GPIO_InitStructure.m_PullUp = GPIO_NOPULL;            //ʼ GPIOǷ
	GPIO_InitStructure.m_PullDown = GPIO_NOPULL;          //ʼ GPIOǷ
	GPIO_Configuration(GPIOx,&GPIO_InitStructure);

	GPIO_Set_Output_Data_Bits(GPIOx,GpioPin,Bit_SET);	 //Ϊߵƽ

}

#if TriggerEINT9_ENABLE
/**
  *   GPIOx ʼá
  *  : GPIOx: ָGPIOڴṹָ룬ȡֵΪGPIOA_SFR~GPIOH_SFR
  *       GpioPin: ˿룬ȡֵΪGPIO_PIN_MASK_0~GPIO_PIN_MASK_15еһϡ
  *   ޡ
  */
void GPIOInit_Input_Config(GPIO_SFRmap* GPIOx,uint16_t GpioPin)
{
	/*ʼλGPIOx裬ʹGPIOxʱ*/
		GPIO_Reset(GPIOx);

	/*  PxyΪģʽ */
	GPIO_InitTypeDef GPIO_InitStructure;
	GPIO_Struct_Init(&GPIO_InitStructure);
	GPIO_InitStructure.m_Pin = GpioPin;
	GPIO_InitStructure.m_Mode = GPIO_MODE_IN;                      //ʼ GPIOΪ
	GPIO_InitStructure.m_PullUp = GPIO_PULLUP;                     //ʼ GPIO
	GPIO_InitStructure.m_PullDown = GPIO_NOPULL;                   //ʼ GPIO
	GPIO_Configuration(GPIOx,&GPIO_InitStructure);
}

/**
  *   ⲿж(EINT)жԴ
  *  :  EintNum: ⲿжϱţ
  *              ȡֵΪINT_EXTERNAL_INTERRUPT_0
  *             INT_EXTERNAL_INTERRUPT_31еһ 0~15
  *      PeripheralSource: жߵжԴ INT_EXTERNAL_SOURCE_PA~INT_EXTERNAL_SOURCE_PF
  *   ޡ
  */
void EXIT_INTx_Config(uint32_t EintNum,uint32_t PeripheralSource)
{
	EINT_InitTypeDef EXIT_InitStructure;
	INT_External_Struct_Init(&EXIT_InitStructure);
	EXIT_InitStructure.m_Line = EintNum;                   //ⲿжϱ
	EXIT_InitStructure.m_Mask = TRUE;                      //ⲿжʹܿ
	EXIT_InitStructure.m_Rise = FALSE;                     //ⲿжжϲʹ
	EXIT_InitStructure.m_Fall = TRUE;                      //ⲿж½жʹ
	EXIT_InitStructure.m_Source = PeripheralSource;        //ⲿжϵжԴѡ
	INT_External_Configuration(&EXIT_InitStructure);
	INT_External_Source_Enable(EintNum,PeripheralSource);


    if(EintNum==INT_EXTERNAL_INTERRUPT_0)
    {
    	INT_Interrupt_Enable(INT_EINT0,TRUE);								//ʹжEINT0
    }else if(EintNum==INT_EXTERNAL_INTERRUPT_1)
    {
    	INT_Interrupt_Enable(INT_EINT1,TRUE);								//ʹжEINT1
    }else if(EintNum==INT_EXTERNAL_INTERRUPT_2)
    {
    	INT_Interrupt_Enable(INT_EINT2,TRUE);								//ʹжEINT2
    }else if(EintNum==INT_EXTERNAL_INTERRUPT_3)
    {
    	INT_Interrupt_Enable(INT_EINT3,TRUE);								//ʹжEINT3
    }else if(EintNum==INT_EXTERNAL_INTERRUPT_4)
    {
    	INT_Interrupt_Enable(INT_EINT4,TRUE);								//ʹжEINT4
    }else if((EintNum>=INT_EXTERNAL_INTERRUPT_5)&&(EintNum<=INT_EXTERNAL_INTERRUPT_9))
    {
    	INT_Interrupt_Enable(INT_EINT9TO5,TRUE);								//ʹжEINT5~EINT9
    }else if((EintNum>=INT_EXTERNAL_INTERRUPT_10)&&(EintNum<=INT_EXTERNAL_INTERRUPT_15))
    {
    	INT_Interrupt_Enable(INT_EINT15TO10,TRUE);								//ʹжEINT10~EINT15
    }

	INT_All_Enable (TRUE);      //ʹж
}
#endif


/**
  *   DACx ʼòѡ񴥷Դ
  *  :  DACx: ָDACڴṹָ룬ȡֵΪDAC0_SFRDAC1_SFR
   TriggerEvent: ¼ѡ     DAC_TRIGGER_T1_TRGO
	*					        DAC_TRIGGER_T3_TRGO
	*							DAC_TRIGGER_T5_TRGO
	*							DAC_TRIGGER_T9_TRGO
	*							DAC_TRIGGER_T14_TRGO
	*							DAC_TRIGGER_T15_TRGO
	*							DAC_TRIGGER_EINT9_TRGO
	*							DAC_TRIGGER_SOFTWARE_TRGO
	*							DAC_TRIGGER_T0_TRGO
	*							DAC_TRIGGER_T2_TRGO
	*							DAC_TRIGGER_T4_TRGO
	*							DAC_TRIGGER_T18_TRGO
	*							DAC_TRIGGER_T19_TRGO
	*							DAC_TRIGGER_T20_TRGO
	*							DAC_TRIGGER_T21_TRGO
  *   ޡ
  */
void DAC_Init_Config(DAC_SFRmap* DACx, uint32_t TriggerEvent)
{
//DACѡڲοѹѡʱԴ
	static uint32_t ReferenceVoltage=0;

	DAC_Reset(DACx);    //λDACʹDACʱ

	DAC_InitTypeDef DAC_InitStructure;
	DAC_Struct_Init(&DAC_InitStructure);
	DAC_InitStructure.m_TriggerEnable=TRUE;               //DACͨʹ
	DAC_InitStructure.m_TriggerEvent = TriggerEvent;      //DACͨ¼
	DAC_InitStructure.m_TriggerDMAEnable = FALSE;         //ȹDACDMA
	DAC_InitStructure.m_Wave = DAC_WAVE_NOISE;            //رղη
	DAC_InitStructure.m_Mas = DAC_LFSR_UNMASK_BITS0_0;    //ֵѡ
	DAC_InitStructure.m_Clock = DAC_CLK_SCLK;             //DACʱԴSCLK
	DAC_InitStructure.m_ReferenceVoltage = DAC_RFS_2V;    //DACοѹ
	DAC_InitStructure.m_OutputBuffer = FALSE;             //ֹ
	DAC_InitStructure.m_OutputPin = DAC_OUTPUT_PIN_0;     //DAC0 DAC1 ŶΪ DAC_OUTPUT_PIN_0
	DAC_InitStructure.m_Output = 4094;                    //ʼ
    DAC_Configuration(DACx,&DAC_InitStructure);

    ReferenceVoltage =DAC_InitStructure.m_ReferenceVoltage;

	if((ReferenceVoltage == DAC_RFS_2V)||(ReferenceVoltage == DAC_RFS_1P2V))   //жǷʹڲοѹ
	{
		OSC_Backup_Write_Read_Enable (TRUE);               //ñĴд
		PM_Reference_Voltage_Enable (TRUE);                //ʹܲοѹģ
	}

}

/**
  *   DMAͨʼ
  *  : DMAx: ָDMAڴṹָ룬ȡֵΪDMA0_SFRDMA1_SFR
  *       Channel: DMAͨȡֵΪDMA_CHANNEL_1~DMA_CHANNEL_7
  *   ޡ
  */
void DAC_DMA_Config(DMA_SFRmap * DMA_CHOOSE,uint8_t Channel)
{

	DMA_Reset(DMA_CHOOSE);// DMAλ ,DMAʱ
	DMA_InitTypeDef dmaNewStruct;

	    /* DMAܲ */

		/*  ݸ: 32 */
		dmaNewStruct.m_Number = 32;
		/*  DMA䷽赽ڴ */
		dmaNewStruct.m_Direction = DMA_MEMORY_TO_PERIPHERAL;
		/*  DMAͨȼȼ */
		dmaNewStruct.m_Priority = DMA_CHANNEL_HIGHER;
		/*  λ32λ */
		dmaNewStruct.m_PeripheralDataSize = DMA_DATA_WIDTH_32_BITS;
		/*  洢λ:32λ */
		dmaNewStruct.m_MemoryDataSize = DMA_DATA_WIDTH_32_BITS;
		/*  ַģʽʹ: ֹ */
		dmaNewStruct.m_PeripheralInc = FALSE;
		/*  洢ַģʽʹ:  */
		dmaNewStruct.m_MemoryInc = TRUE;
		/*  DMAͨѡ:ͨ */
		dmaNewStruct.m_Channel = Channel;   //ͨ
		/*  ݿ鴫ģʽ */
		dmaNewStruct.m_BlockMode = DMA_TRANSFER_BYTE;//ֽڴ
		/*  ѭģʽʹ:  */
		dmaNewStruct.m_LoopMode = TRUE;
		/*  ʼַȴ͵ݵʼַ */
		dmaNewStruct.m_PeriphAddr = DAC0_DAHD_Address ;         //ַΪDAC0ַ
		/*  ڴʼַݵڴռʼַ */
		dmaNewStruct.m_MemoryAddr = (uint32_t)&DualSine12bit;

		DMA_Configuration (DMA_CHOOSE,&dmaNewStruct);

		/* ʹͨ  DMA */
		DMA_Channel_Enable (DMA_CHOOSE, Channel, TRUE);
}



/**
  *   ͨöʱʼ
  *  : GPTIMx: ָʱڴṹָ룬
  *               ȡֵT0_SFR/T1_SFR/T2_SFR/T3_SFR/T4_SFR/T18_SFR/
  *               T19_SFR/T20_SFR/T21_SFR
  *       PeriodµֵT20 T21ȡֵ32λݡʱȡֵ Ϊ16λ
  *   ޡ
  */
void GENERAL_TIMER_Tx_Config(GPTIM_SFRmap* GPTIMx,uint32_t Period)
{
    //ʱʱԴѡSCLK,ƵTXIFΪź

	TIM_Reset(GPTIMx);												//ʱ踴λʹʱ
	GPTIM_Updata_Immediately_Config(GPTIMx,TRUE);					//¿
	GPTIM_Updata_Enable(GPTIMx,TRUE);								//øʹ
	GPTIM_Work_Mode_Config(GPTIMx,GPTIM_TIMER_MODE);				//ʱģʽѡ

	GPTIM_Master_Mode_Config(GPTIMx,GPTIM_MASTER_TXIF_SIGNAL);      //ģʽѡTXIFΪ

	GPTIM_Set_Counter(GPTIMx,0);									//ʱֵ
	GPTIM_Set_Period(GPTIMx,Period);								//ʱֵ
	GPTIM_Set_Prescaler(GPTIMx,0);				    				//ʱԤƵֵ11
	GPTIM_Counter_Mode_Config(GPTIMx,GPTIM_COUNT_UP_DOWN_OUF);		//-¼,жϱ־
	GPTIM_Clock_Config(GPTIMx,GPTIM_SCLK);							//ѡSCLKʱ
	GPTIM_Cmd(GPTIMx,TRUE);											//ʱʹ

}

//
void main()
{
	/*ûɲοKF32F350_demoʵDAC1 Ҳùܡ
	    DAC0ҲԴѡʱT20Ӧ,
	 *жEINT9ҪTriggerEINT9_ENABLEжʹ,PB9½شж
     *ʾԲPE15ΪҲ
     *עѡPE15ΪDACӳܣڲοѹʱҪ򿪱д
	 */

	//ϵͳʱ120M,Ƶʱ16M
	SystemInit();//ϵͳʱӳʼ
	GPIO_Reset(GPIOE_SFR);//λGPIOEGPIOEʱDAC IOʱ
	GPIOInit_Output_Config(GPIOB_SFR,GPIO_PIN_MASK_8);//PB8ʼߵƽ

#if TriggerEINT9_ENABLE
	GPIOInit_Input_Config(GPIOB_SFR,GPIO_PIN_MASK_9);                 //PB9ʼΪ
	//ⲿжEINT9 жԴPB9
	EXIT_INTx_Config(INT_EXTERNAL_INTERRUPT_9,INT_EXTERNAL_SOURCE_PB);  //½źŴжEINT9
	DAC_Init_Config(DAC0_SFR,DAC_TRIGGER_EINT9_TRGO);//ʼDAC0ѡ񴥷ԴEINT9
#else
	GENERAL_TIMER_Tx_Config(T20_SFR,100);    //öʱT20ֵ100
	DAC_Init_Config(DAC0_SFR,DAC_TRIGGER_T20_TRGO);//ʼDAC0ѡ񴥷ԴT20
#endif
	/* װ Ҳ32 */
	for (Idx = 0; Idx < 32; Idx++)
	{
	  DualSine12bit[Idx] = (Sine12bit[Idx] << 16) + (Sine12bit[Idx]);
	}
	DAC_Cmd(DAC0_SFR,TRUE);//DAC0ʹ
	DAC_DMA_Config(DMA0_SFR,DMA_CHANNEL_5);  //DAC0 DMA
	DAC_DMA_Cmd(DAC0_SFR,TRUE);//DMAʹ

    while(1)
    {
    }

}



/**
  *    У鷢ļ
  *    file: ָļƵָ
  *      line У
  *   ޡ
  */
void check_failed(uint8_t* file, uint32_t line)
{
	  /* ûԼĴʵֱļк,
	             : printf("Wrong parameters value: file %s on line %d\r\n", file, line) */

	  while(1)
	  {
		  ;
	  }
}

