/**
  ******************************************************************************
  * ļ  kf32f_basic_osc.c
  *     ChipON_AE/FAE_Group
  *     V3.0.0
  *     2021-08-20
  *     ļṩ(OSC)蹦ܺ
  *          + (OSC)ʼ
  *          + (OSC)ú
  *          + (OSC)жϿƺ
  *
  *********************************************************************
  */

#include "kf32f_basic_osc.h"


/* (OSC)˽ж ----------------------------------------------------*/
/* OSC_CTL0ĴSCKʼ */
#define OSC_CTL0_SCLK_MASK               (OSC_CTL0_SCKS \
                                       | OSC_CTL0_SCKDIV)

/* OSC_CTL0ĴHFCKʼ */
#define OSC_CTL0_HFCK_MASK             (OSC_CTL0_HFCKS \
                                       | OSC_CTL0_HFCKDIV)

/* OSC_CTL0ĴLFCKʼ */
#define OSC_CTL0_LFCK_MASK             (OSC_CTL0_LFCKS \
                                       | OSC_CTL0_LFCKDIV)

/* OSC_CTL1ĴCK48Mʼ */
#define OSC_CTL1_CK48M_MASK             (OSC_CTL1_CK48MS \
                                       | OSC_CTL1_CK48DIV)


/**
  *   ##### (OSC)ʼ #####
  */
/**
  *   (OSC)ϵͳʱSCLK
  *   oscInitStruct: (OSC)Ϣṹָ롣
  *   ޡ
  */
void
OSC_SCLK_Configuration (OSC_InitTypeDef* oscInitStruct)
{
    uint32_t tmpreg = 0;
    uint32_t tmpreg1 = 0;
    uint32_t tmpmask = 0;
    uint32_t tmpmask1 = 0;
    uint32_t sfraddr = 0;

    /* У */
    CHECK_RESTRICTION(CHECK_SCLK_SOURCE(oscInitStruct->m_InputSource));
    CHECK_RESTRICTION(CHECK_SCLK_DIVISION(oscInitStruct->m_CLKDivision));

    /*------------------ OSC_CTL0Ĵ -----------------*/
    /* ݲm_InputSourceSCKSλ */
    /* ݲm_CLKDivisionSCKDIVλ */
    tmpreg = oscInitStruct->m_InputSource << OSC_CTL0_SCKS0_POS \
           | oscInitStruct->m_CLKDivision << OSC_CTL0_SCKDIV0_POS;
    tmpmask = OSC_CTL0_SCLK_MASK;

    switch (oscInitStruct->m_InputSource)
    {
        case SCLK_SOURCE_PLL:
        {
            /* ݲm_PLLInputSourcePLLxCKSλ */
            tmpreg |= (oscInitStruct->m_PLLInputSource \
                                << OSC_CTL0_PLL0CKS_POS);
            tmpmask |= OSC_CTL0_PLL0CKS;
            /* PLLƵDIVSELλĴַ */
            sfraddr = (uint32_t)&PLL_CTL;
            /* PLLʱʱλƫ */
            tmpreg1 = OSC_CTL2_PLLDLY0_POS;
        }
            break;
        case SCLK_SOURCE_EXTHF:
        {
            tmpreg1 = OSC_CTL2_EHFDLY0_POS;
            tmpmask1 = OSC_CTL2_EHFDLY;
        }
            break;
        case SCLK_SOURCE_EXTLF:
        {
            tmpreg1 = OSC_CTL2_ELFDLY0_POS;
            tmpmask1 = OSC_CTL2_ELFDLY;
        }
            break;
        default:
            break;
    }
    /* PLLʱԴѡλ */
    OSC_CTL0 = SFR_Config (OSC_CTL0, ~tmpmask, tmpreg);

    if (oscInitStruct->m_InputSource >= SCLK_SOURCE_PLL)
    {
        CHECK_RESTRICTION(CHECK_PLL_INPUT(oscInitStruct->m_PLLInputSource));
        CHECK_RESTRICTION(CHECK_PLL_START_DELAY(oscInitStruct->m_StartDelay));

        /* PLLʱʱ */
        /*------------------ OSC_CTL2Ĵ -----------------*/
        /* ݲm_StartDelayPLLxDLYλ */
        OSC_CTL2 = SFR_Config (OSC_CTL2,
                            ~(0xF << tmpreg1),
                            oscInitStruct->m_StartDelay << tmpreg1);
    }
    else if ((oscInitStruct->m_InputSource == SCLK_SOURCE_EXTHF)
         || (oscInitStruct->m_InputSource == SCLK_SOURCE_EXTLF))
    {
        /* ⲿʱʱ */
        CHECK_RESTRICTION(CHECK_EXT_START_DELAY(oscInitStruct->m_StartDelay));

        /*------------------ OSC_CTL2Ĵ -----------------*/
        /* ݲm_StartDelayEHFDLY/ELFDLYλ */
        OSC_CTL2 = SFR_Config (OSC_CTL2,
                            ~tmpmask1,
                            oscInitStruct->m_StartDelay << tmpreg1);
    }
    else
    {
        ;
    }
}

/**
  *   (OSC)ƵʱHFCLK
  *   oscInitStruct: (OSC)Ϣṹָ롣
  *   ޡ
  */
void
OSC_HFCK_Configuration (OSC_InitTypeDef* oscInitStruct)
{
    uint32_t tmpreg = 0;
    uint32_t tmpreg1 = 0;
    uint32_t tmpmask = 0;
    uint32_t tmpmask1 = 0;
    uint32_t sfraddr = 0;

    /* У */
    CHECK_RESTRICTION(CHECK_HFCK_SOURCE(oscInitStruct->m_InputSource));
    CHECK_RESTRICTION(CHECK_HFCK_DIVISION(oscInitStruct->m_CLKDivision));

    switch (oscInitStruct->m_InputSource)
    {
        case HFCK_SOURCE_PLL:
        {
            /* ݲm_PLLInputSourcePLLxCKSλ */
            tmpreg = (oscInitStruct->m_PLLInputSource \
                                << OSC_CTL0_PLL0CKS_POS);
            tmpmask = OSC_CTL0_PLL0CKS;
            /* PLLƵDIVSELλĴַ */
            sfraddr = (uint32_t)&PLL_CTL;
            /* PLLʱʱλƫ */
            tmpreg1 = OSC_CTL2_PLLDLY0_POS;
        }
            break;
        case HFCK_SOURCE_INTHF:
            break;
        case HFCK_SOURCE_EXTHF:
        {
            tmpreg1 = OSC_CTL2_ELFDLY0_POS;
            tmpmask1 = OSC_CTL2_ELFDLY;
        }
            break;
        default:
            break;
    }
    /* PLLʱԴѡλ */
    /*------------------ OSC_CTL0Ĵ -----------------*/
    /* ݲm_InputSourceHFCKSλ */
    /* ݲm_CLKDivisionHFCKDIVλ */
    tmpreg |= oscInitStruct->m_InputSource << OSC_CTL0_HFCKS0_POS \
           | oscInitStruct->m_CLKDivision << OSC_CTL0_HFCKDIV0_POS;
    tmpmask |= OSC_CTL0_HFCK_MASK;

    OSC_CTL0 = SFR_Config (OSC_CTL0, ~tmpmask, tmpreg);

    if (oscInitStruct->m_InputSource >= HFCK_SOURCE_PLL)
    {
        CHECK_RESTRICTION(CHECK_PLL_INPUT(oscInitStruct->m_PLLInputSource));
        CHECK_RESTRICTION(CHECK_PLL_START_DELAY(oscInitStruct->m_StartDelay));
        /* PLLʱʱ */
        /*------------------ OSC_CTL2Ĵ -----------------*/
        /* ݲm_StartDelayPLLxDLYλ */
        OSC_CTL2 = SFR_Config (OSC_CTL2,
                            ~(0xF << tmpreg1),
                            oscInitStruct->m_StartDelay << tmpreg1);
    }
    else if (oscInitStruct->m_InputSource == HFCK_SOURCE_EXTHF)
    {
        /* ⲿʱʱ */
        CHECK_RESTRICTION(CHECK_EXT_START_DELAY(oscInitStruct->m_StartDelay));

        /*------------------ OSC_CTL2Ĵ -----------------*/
        /* ݲm_StartDelayEHFDLY/ELFDLYλ */
        OSC_CTL2 = SFR_Config (OSC_CTL2,
                            ~tmpmask1,
                            oscInitStruct->m_StartDelay << tmpreg1);
    }
    else
    {
        ;
    }
}

/**
  *   (OSC)ƵʱLFCLK
  *   oscInitStruct: (OSC)Ϣṹָ롣
  *   ޡ
  */
void
OSC_LFCK_Configuration (OSC_InitTypeDef* oscInitStruct)
{
    uint32_t tmpreg = 0;

    /* У */
    CHECK_RESTRICTION(CHECK_LFCK_INPUT(oscInitStruct->m_InputSource));
    CHECK_RESTRICTION(CHECK_LFCK_DIVISION(oscInitStruct->m_CLKDivision));

    /*------------------ OSC_CTL0Ĵ -----------------*/
    /* ݲm_InputSourceLFCKSλ */
    /* ݲm_CLKDivisionLFCKDIVλ */
    tmpreg = oscInitStruct->m_InputSource << OSC_CTL0_LFCKS_POS \
           | oscInitStruct->m_CLKDivision << OSC_CTL0_LFCKDIV0_POS;
    OSC_CTL0 = SFR_Config (OSC_CTL0, ~OSC_CTL0_LFCK_MASK, tmpreg);

    if (oscInitStruct->m_InputSource == LFCK_INPUT_EXTLF)
    {
        /* ⲿʱʱ */
        CHECK_RESTRICTION(CHECK_EXT_START_DELAY(oscInitStruct->m_StartDelay));

        /*------------------ OSC_CTL2Ĵ -----------------*/
        /* ݲm_StartDelayELFDLYλ */
        tmpreg = oscInitStruct->m_StartDelay << OSC_CTL2_ELFDLY0_POS;
        OSC_CTL2 = SFR_Config (OSC_CTL2, ~OSC_CTL2_ELFDLY, tmpreg);
    }
    else
    {
        ;
    }
}

/**
  *   (OSC)48MHzʱCK48M
  *   oscInitStruct: (OSC)Ϣṹָ롣
  *   ޡ
  */
void
OSC_CK48M_Configuration (OSC_InitTypeDef* oscInitStruct)
{
    uint32_t tmpreg = 0;
    uint32_t tmpreg1 = 0;
    uint32_t tmpmask = 0;
    uint32_t tmpmask1 = 0;
    uint32_t sfraddr = 0;

    /* У */
    CHECK_RESTRICTION(CHECK_CK48M_SOURCE(oscInitStruct->m_InputSource));
    CHECK_RESTRICTION(CHECK_CK48M_DIVISION(oscInitStruct->m_CLKDivision));

    switch (oscInitStruct->m_InputSource)
    {
        case CK48M_SOURCE_PLL:
        {
            /* ݲm_PLLInputSourcePLLxCKSλ */
            tmpreg = (oscInitStruct->m_PLLInputSource \
                                << OSC_CTL0_PLL0CKS_POS);
            tmpmask = OSC_CTL0_PLL0CKS;
            /* PLLƵDIVSELλĴַ */
            sfraddr = (uint32_t)&PLL_CTL;
            /* PLLʱʱλƫ */
            tmpreg1 = OSC_CTL2_PLLDLY0_POS;
        }
            break;
        case CK48M_SOURCE_INTHF:
            break;
        case CK48M_SOURCE_EXTHF:
        {
            tmpreg1 = OSC_CTL2_ELFDLY0_POS;
            tmpmask1 = OSC_CTL2_ELFDLY;
        }
            break;
        default:
            break;
    }

    if (oscInitStruct->m_InputSource >= CK48M_SOURCE_PLL)
    {
        CHECK_RESTRICTION(CHECK_PLL_INPUT(oscInitStruct->m_PLLInputSource));
        CHECK_RESTRICTION(CHECK_PLL_START_DELAY(oscInitStruct->m_StartDelay));

        /* PLLʱԴѡλ */
        /*------------------ OSC_CTL0Ĵ -----------------*/
        /* ݲm_PLLInputSourcePLLxCKSλ */
        OSC_CTL0 = SFR_Config (OSC_CTL0, ~tmpmask, tmpreg);

        /* PLLʱʱ */
        /*------------------ OSC_CTL2Ĵ -----------------*/
        /* ݲm_StartDelayPLLxDLYλ */
        OSC_CTL2 = SFR_Config (OSC_CTL2,
                            ~(0xF << tmpreg1),
                            oscInitStruct->m_StartDelay << tmpreg1);
    }
    else if (oscInitStruct->m_InputSource == HFCK_SOURCE_EXTHF)
    {
        /* ⲿʱʱ */
        CHECK_RESTRICTION(CHECK_EXT_START_DELAY(oscInitStruct->m_StartDelay));

        /*------------------ OSC_CTL2Ĵ -----------------*/
        /* ݲm_StartDelayEHFDLY/ELFDLYλ */
        OSC_CTL2 = SFR_Config (OSC_CTL2,
                            ~tmpmask1,
                            oscInitStruct->m_StartDelay << tmpreg1);
    }
    else
    {
        ;
    }

    /* ԴѡͷƵϵ */
    /*------------------ OSC_CTL1Ĵ -----------------*/
    /* ݲm_InputSourceCK48MSλ */
    /* ݲm_CLKDivisionCK48DIVλ */
    tmpreg = oscInitStruct->m_InputSource << OSC_CTL1_CK48MS0_POS \
           | oscInitStruct->m_CLKDivision << OSC_CTL1_CK48DIV0_POS;
    OSC_CTL1 = SFR_Config (OSC_CTL1, ~OSC_CTL1_CK48M_MASK, tmpreg);
}

/**
  *   ʼ(OSC)Ϣṹ塣
  *   oscInitStruct: ָʼĽṹָ롣
  *   ޡ
  */
void
OSC_Struct_Init (OSC_InitTypeDef* oscInitStruct)
{
    /* Դѡ */
    oscInitStruct->m_InputSource = SCLK_SOURCE_INTHF;
    /* ʱӷƵϵ */
    oscInitStruct->m_CLKDivision = SCLK_DIVISION_128;
    /* PLLʱԴѡ */
    oscInitStruct->m_PLLInputSource = PLL_INPUT_INTHF;
    /* PLL  ⲿʱʱ */
    oscInitStruct->m_StartDelay = PLL_START_DELAY_64;
}
/**
  *   ##### (OSC)ʼ #####
  */


/**
  *   ##### (OSC)ú #####
  */
/**
  *   õƵʱӷƵѡ
  *   LFDivision: ƵʱӷƵѡȡֵΧΪ
  *                         LFCK_DIVISION_1: 1/1Ƶ,
  *                         LFCK_DIVISION_2: 1/2Ƶ,
  *                         LFCK_DIVISION_4: 1/4Ƶ,
  *                         LFCK_DIVISION_8: 1/8Ƶ,
  *                         LFCK_DIVISION_16: 1/16Ƶ,
  *                         LFCK_DIVISION_32: 1/32Ƶ,
  *                         LFCK_DIVISION_64: 1/64Ƶ,
  *                         LFCK_DIVISION_128: 1/128Ƶ,
  *   ޡ
  */
void
OSC_LFCK_Division_Config (uint32_t LFDivision)
{
    uint32_t tmpreg = 0;

    /* У */
    CHECK_RESTRICTION(CHECK_LFCK_DIVISION(LFDivision));

    /*---------------- OSC_CTL0ĴLFCKDIVλ ----------------*/
    tmpreg = LFDivision << OSC_CTL0_LFCKDIV0_POS;
    OSC_CTL0 = SFR_Config (OSC_CTL0, ~OSC_CTL0_LFCKDIV, tmpreg);
}

/**
  *   øƵʱӷƵѡ
  *   HFDivision: ƵʱӷƵѡȡֵΧΪ
  *                         HFCK_DIVISION_1: 1/1Ƶ,
  *                         HFCK_DIVISION_2: 1/2Ƶ,
  *                         HFCK_DIVISION_4: 1/4Ƶ,
  *                         HFCK_DIVISION_8: 1/8Ƶ,
  *                         HFCK_DIVISION_16: 1/16Ƶ,
  *                         HFCK_DIVISION_32: 1/32Ƶ,
  *                         HFCK_DIVISION_64: 1/64Ƶ,
  *                         HFCK_DIVISION_128: 1/128Ƶ,
  *                         HFCK_DIVISION_256: 1/256Ƶ,
  *                         HFCK_DIVISION_512: 1/512Ƶ,
  *   ޡ
  */
void
OSC_HFCK_Division_Config (uint32_t HFDivision)
{
    uint32_t tmpreg = 0;

    /* У */
    CHECK_RESTRICTION(CHECK_HFCK_DIVISION(HFDivision));

    /*---------------- OSC_CTL0ĴHFCKDIVλ ----------------*/
    tmpreg = HFDivision << OSC_CTL0_HFCKDIV0_POS;
    OSC_CTL0 = SFR_Config (OSC_CTL0, ~OSC_CTL0_HFCKDIV, tmpreg);
}

/**
  *   ʱSCLKƵѡ
  *   SclkDivision: ʱSCLKƵѡȡֵΧΪ
  *                         SCLK_DIVISION_1: 1/1Ƶ,
  *                         SCLK_DIVISION_2: 1/2Ƶ,
  *                         SCLK_DIVISION_4: 1/4Ƶ,
  *                         SCLK_DIVISION_8: 1/8Ƶ,
  *                         SCLK_DIVISION_16: 1/16Ƶ,
  *                         SCLK_DIVISION_32: 1/32Ƶ,
  *                         SCLK_DIVISION_64: 1/64Ƶ,
  *                         SCLK_DIVISION_128: 1/128Ƶ,
  *   ޡ
  */
void
OSC_SCK_Division_Config (uint32_t SclkDivision)
{
    uint32_t tmpreg = 0;

    /* У */
    CHECK_RESTRICTION(CHECK_SCLK_DIVISION(SclkDivision));

    /*---------------- OSC_CTL0ĴSCKDIVλ ----------------*/
    tmpreg = SclkDivision << OSC_CTL0_SCKDIV0_POS;
    OSC_CTL0 = SFR_Config (OSC_CTL0, ~OSC_CTL0_SCKDIV, tmpreg);
}


/**
  *   PLLʱԴѡ
  *   NewState: PLLʱԴѡȡֵΧΪ
  *                   PLL_INPUT_INTHF: ѡINTHFΪPLLʱӣ
  *                   PLL_INPUT_EXTHF: ѡEXTHFΪPLLʱӡ
  *   ޡ
  */
void
OSC_PLL_Input_Source_Config (uint32_t NewState)
{
    /* У */
    CHECK_RESTRICTION(CHECK_PLL_INPUT(NewState));

    /*---------------- OSC_CTL0ĴPLL0CKSλ ----------------*/
    if (NewState != PLL_INPUT_INTHF)
    {
        /* ѡEXTHFΪPLLʱ */
        SFR_SET_BIT_ASM(OSC_CTL0, OSC_CTL0_PLL0CKS_POS);
    }
    else
    {
        /* ѡINTHFΪPLLʱ */
        SFR_CLR_BIT_ASM(OSC_CTL0, OSC_CTL0_PLL0CKS_POS);
    }
}

/**
  *   øƵʱԴѡ
  *   HFSource: ƵʱԴѡȡֵΧΪ
  *                   HFCK_SOURCE_INTHF: ѡINTHFΪHFCLKʱ,
  *                   HFCK_SOURCE_EXTHF: ѡEXTHFΪHFCLKʱ,
  *                   HFCK_SOURCE_PLL: ѡPLLΪHFCLKʱ,
  *                   HFCK_SOURCE_PLL2: ѡPLL2ΪHFCLKʱ,
  *                   HFCK_SOURCE_PLL1: ѡPLL1ΪHFCLKʱ,
  *   ޡ
  */
void
OSC_HFCK_Source_Config (uint32_t HFSource)
{
    uint32_t tmpreg = 0;

    /* У */
    CHECK_RESTRICTION(CHECK_HFCK_SOURCE(HFSource));

    /*---------------- OSC_CTL0ĴHFCKSλ ----------------*/
    tmpreg = HFSource << OSC_CTL0_HFCKS0_POS;
    OSC_CTL0 = SFR_Config (OSC_CTL0, ~OSC_CTL0_HFCKS, tmpreg);
}

/**
  *   øƵʱʹܡ
  *   NewState: Ƶʱʹ״̬
  *                 ȡֵΧΪTRUE  FALSE
  *   ޡ
  */
void
OSC_HFCK_Enable (FunctionalState NewState)
{
    /* У */
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

    /*---------------- OSC_CTL0ĴHFCKENλ ----------------*/
    if (NewState != FALSE)
    {
        /* HFCLKʱź */
        SFR_SET_BIT_ASM(OSC_CTL0, OSC_CTL0_HFCKEN_POS);
    }
    else
    {
        /* HFCLKʱźŽֹ */
        SFR_CLR_BIT_ASM(OSC_CTL0, OSC_CTL0_HFCKEN_POS);
    }
}

/**
  *   õƵʱԴѡ
  *   NewState: ƵʱԴѡȡֵΧΪ
  *                   LFCK_INPUT_INTLF: ѡINTLFΪLFCLKʱӣ
  *                   LFCK_INPUT_EXTLF: ѡEXTLFΪLFCLKʱӡ
  *   ޡ
  */
void
OSC_LFCK_Source_Config (uint32_t NewState)
{
    /* У */
    CHECK_RESTRICTION(CHECK_LFCK_INPUT(NewState));

    /*---------------- OSC_CTL0ĴLFCKSλ ----------------*/
    if (NewState != LFCK_INPUT_INTLF)
    {
        /* ѡEXTLFΪLFCLKʱ */
        SFR_SET_BIT_ASM(OSC_CTL0, OSC_CTL0_LFCKS_POS);
    }
    else
    {
        /* ѡINTLFΪLFCLKʱ */
        SFR_CLR_BIT_ASM(OSC_CTL0, OSC_CTL0_LFCKS_POS);
    }
}

/**
  *   õƵʱʹܡ
  *   NewState: Ƶʱʹ״̬
  *                 ȡֵΧΪTRUE  FALSE
  *   ޡ
  */
void
OSC_LFCK_Enable (FunctionalState NewState)
{
    /* У */
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

    /*---------------- OSC_CTL0ĴLFCKENλ ----------------*/
    if (NewState != FALSE)
    {
        /* LFCLKʱź */
        SFR_SET_BIT_ASM(OSC_CTL0, OSC_CTL0_LFCKEN_POS);
    }
    else
    {
        /* LFCLKʱźŽֹ */
        SFR_CLR_BIT_ASM(OSC_CTL0, OSC_CTL0_LFCKEN_POS);
    }
}

/**
  *   SCLKʱѡ
  *   SclkSource: SCLKʱѡȡֵΧΪ
  *                     SCLK_SOURCE_INTHF: ѡINTHFΪϵͳʱ,
  *                     SCLK_SOURCE_INTLF: ѡINTLFΪϵͳʱ,
  *                     SCLK_SOURCE_EXTHF: ѡEXTHFΪϵͳʱ,
  *                     SCLK_SOURCE_EXTLF: ѡEXTLFΪϵͳʱ,
  *                     SCLK_SOURCE_PLL: ѡPLLΪϵͳʱ,
  *                     SCLK_SOURCE_LP4M:  ѡ LP4M Ϊϵͳʱ
  *   ޡ
  */
void
OSC_SCK_Source_Config (uint32_t SclkSource)
{
    uint32_t tmpreg = 0;

    /* У */
    CHECK_RESTRICTION(CHECK_SCLK_SOURCE(SclkSource));

    /*---------------- OSC_CTL0ĴSCKSλ ----------------*/
    tmpreg = SclkSource << OSC_CTL0_SCKS0_POS;
    OSC_CTL0 = SFR_Config (OSC_CTL0, ~OSC_CTL0_SCKS, tmpreg);
}

/**
  *   ñĴд
  *   NewState: Ĵд״̬ȡֵΧΪTRUE  FALSE
  *   ޡ
  */
void
OSC_Backup_Write_Read_Enable (FunctionalState NewState)
{
    /* У */
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

    /*---------------- OSC_CTL0ĴPMWRENλ ----------------*/
    if (NewState != FALSE)
    {
        /* ɶд */
        SFR_SET_BIT_ASM(OSC_CTL0, OSC_CTL0_PMWREN_POS);
    }
    else
    {
        /* ɶд */
        SFR_CLR_BIT_ASM(OSC_CTL0, OSC_CTL0_PMWREN_POS);
    }
}

/**
  *   ϵͳʱʹܡ
  *   NewState: ϵͳʱʹ״̬
  *                 ȡֵΧΪTRUE  FALSE
  *   ޡ
  */
void
OSC_SCLK_Output_Enable (FunctionalState NewState)
{
    /* У */
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

    /*---------------- OSC_CTL1ĴSCLKOEλ ----------------*/
    if (NewState != FALSE)
    {
        /* SCLKʱӴIOCLKOUT */
        SFR_SET_BIT_ASM(OSC_CTL1, OSC_CTL1_SCLKOE_POS);
    }
    else
    {
        /* ֹSCLKʱӴIOCLKOUT */
        SFR_CLR_BIT_ASM(OSC_CTL1, OSC_CTL1_SCLKOE_POS);
    }
}
/**
  *   ô CLKOUT ʱѡ
  *   SclkSource: ʱѡ
  *                     CLKOUT_SCLK:  ѡ SCLK Ϊʱ
  *                     CLKOUT_EXTLF: ѡ EXTLF Ϊʱ
  *                     CLKOUT_EXTHF: ѡ EXTHF Ϊʱ
  *                     CLKOUT_INTLF: ѡ INTLF Ϊʱ
  *                     CLKOUT_INTHF: ѡ INTHF Ϊʱ
  *                     CLKOUT_PLL:   ѡ PLL Ϊʱ
  *                     CLKOUT_LP4M:  ѡ LP4M Ϊʱ
  *   ޡ
  */
void
OSC_SCLK_Output_Select (uint32_t SclkSource)
{
    uint32_t tmpreg = 0;
    /* У */
    CHECK_RESTRICTION(CHECK_CLKOUT_SEL(SclkSource));

    /*---------------- OSC_CTL0ĴCLKOUTSλ ----------------*/
    tmpreg = SclkSource << OSC_CTL1_CLKOUTS0_POS;
    OSC_CTL1 = SFR_Config (OSC_CTL1, ~OSC_CTL1_CLKOUTS, tmpreg);
}
/**
  *   SCLKʱӷƵѡ
  *   OutputDivision: SCLKʱӷƵѡλȡֵΧΪ
  *                         SCLK_DIVISION_1: 1/1Ƶ,
  *                         SCLK_DIVISION_2: 1/2Ƶ,
  *                         SCLK_DIVISION_4: 1/4Ƶ,
  *                         SCLK_DIVISION_8: 1/8Ƶ,
  *                         SCLK_DIVISION_16: 1/16Ƶ,
  *                         SCLK_DIVISION_32: 1/32Ƶ,
  *                         SCLK_DIVISION_64: 1/64Ƶ,
  *                         SCLK_DIVISION_128: 1/128Ƶ,
  *   ޡ
  */
void
OSC_SCLK_Output_Division_Config (uint32_t OutputDivision)
{
    uint32_t tmpreg = 0;

    /* У */
    CHECK_RESTRICTION(CHECK_SCLK_DIVISION(OutputDivision));

    /*---------------- OSC_CTL1ĴSCLKOUTDIVλ ----------------*/
    tmpreg = OutputDivision << OSC_CTL1_SCLKOUTDIV0_POS;
    OSC_CTL1 = SFR_Config (OSC_CTL1, ~OSC_CTL1_SCLKOUTDIV, tmpreg);
}

/**
  *   ʱӹϼʹܡ
  *   NewState: ʱӹϼʹ״̬ȡֵΧΪTRUE  FALSE
  *   ޡ
  */
void
OSC_Clock_Failure_Check_Enable (FunctionalState NewState)
{
    /* У */
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

    /*---------------- OSC_CTL1ĴFSCMλ ----------------*/
    if (NewState != FALSE)
    {
        /* ʱӹϼʹ */
        SFR_SET_BIT_ASM(OSC_CTL1, OSC_CTL1_FSCM_POS);
    }
    else
    {
        /* ʱӹϼֹ */
        SFR_CLR_BIT_ASM(OSC_CTL1, OSC_CTL1_FSCM_POS);
    }
}

/**
  *   CK48MʱӷƵѡ
  *   CK48MDivision: CK48MʱӷƵѡȡֵΧΪ
  *                        CK48M_DIVISION_1: 1/1Ƶ,
  *                        CK48M_DIVISION_2: 1/2Ƶ,
  *                        CK48M_DIVISION_4: 1/4Ƶ,
  *   ޡ
  */
void
OSC_CK48M_Division_Config (uint32_t CK48MDivision)
{
    uint32_t tmpreg = 0;

    /* У */
    CHECK_RESTRICTION(CHECK_CK48M_DIVISION(CK48MDivision));

    /*---------------- OSC_CTL1ĴCK48DIVλ ----------------*/
    tmpreg = CK48MDivision << OSC_CTL1_CK48DIV0_POS;
    OSC_CTL1 = SFR_Config (OSC_CTL1, ~OSC_CTL1_CK48DIV, tmpreg);
}

/**
  *   48MʱʱԴѡ
  *   CK48MSource: 48MʱʱԴѡȡֵΧΪ
  *                      CK48M_SOURCE_INTHF: ѡINTHFΪCK48Mʱ,
  *                      CK48M_SOURCE_EXTHF: ѡEXTHFΪCK48Mʱ,
  *                      CK48M_SOURCE_PLL: ѡPLLΪCK48Mʱ,
  *   ޡ
  */
void
OSC_CK48M_Source_Config (uint32_t CK48MSource)
{
    uint32_t tmpreg = 0;

    /* У */
    CHECK_RESTRICTION(CHECK_CK48M_SOURCE(CK48MSource));

    /*---------------- OSC_CTL1ĴCK48MSλ ----------------*/
    tmpreg = CK48MSource << OSC_CTL1_CK48MS0_POS;
    OSC_CTL1 = SFR_Config (OSC_CTL1, ~OSC_CTL1_CK48MS, tmpreg);
}

/**
  *   48Mʱʱʹܡ
  *   NewState: 48Mʱʱʹ״̬
  *                 ȡֵΧΪTRUE  FALSE
  *   ޡ
  */
void
OSC_CK48M_Enable (FunctionalState NewState)
{
    /* У */
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

    /*---------------- OSC_CTL1ĴCK48MENλ ----------------*/
    if (NewState != FALSE)
    {
        /* CK48Mʱźʹ */
        SFR_SET_BIT_ASM(OSC_CTL1, OSC_CTL1_CK48MEN_POS);
    }
    else
    {
        /* CK48MʱźŽֹ */
        SFR_CLR_BIT_ASM(OSC_CTL1, OSC_CTL1_CK48MEN_POS);
    }
}
/**
  *   PLLƵѡ
  *   PLLmultiple: PLLƵȡֵΧΪ
  *                PLLmultiple_M 0X04-0X3FFFΧ(MҪڵ4, 200MHZ<M*οƵ/N<400MHZ)
  *                PLLmultiple_N 0X01-0XFΧ,1MHZ<οƵ/N<50MHZ
  *                PLLmultiple_NO ȡֵ1/2/4/8ѡ1
  *
  *					Ŵ=PLLmultiple_M/PLLmultiple_N*PLLmultiple_NO
  *   ޡ
  */
void
OSC_PLL_Multiple_Value_Select (uint32_t PLLmultiple_M,uint32_t PLLmultiple_N,uint32_t PLLmultiple_NO)
{
    uint32_t tmpreg = 0;

    /* У */
    CHECK_RESTRICTION(CHECK_PLL_MULTIPLE_MValue(PLLmultiple_M));
    CHECK_RESTRICTION(CHECK_PLL_MULTIPLE_NValue(PLLmultiple_N));
    CHECK_RESTRICTION(CHECK_PLL_MULTIPLE_NOValue(PLLmultiple_NO));



    /*---------------- PLL_CTLĴODλNλMλ ----------------*/
    tmpreg = PLLmultiple_M << PLL_CTL_M0_POS;
    PLL_CTL = SFR_Config (PLL_CTL, ~PLL_CTL_M, tmpreg);

    tmpreg = PLLmultiple_N << PLL_CTL_N0_POS;
    PLL_CTL = SFR_Config (PLL_CTL, ~PLL_CTL_N, tmpreg);

    if(PLLmultiple_NO==8){PLLmultiple_NO=3;}
    else if(PLLmultiple_NO==4){PLLmultiple_NO=2;}
    else if(PLLmultiple_NO==2){PLLmultiple_NO=1;}
    else if(PLLmultiple_NO==1){PLLmultiple_NO=0;}
    tmpreg = PLLmultiple_NO << PLL_CTL_OD0_POS;
    PLL_CTL = SFR_Config (PLL_CTL, ~PLL_CTL_OD, tmpreg);


}
/**
  *   PLLλơ
  *  :
  *  
  */
void OSC_PLL_RST(void)
{
    /*---------------- PLL_CTLĴPDRSTλ ----------------*/
    SFR_SET_BIT_ASM(PLL_CTL, PLL_CTL_PDRST_POS);
}
/**
  *   PLLӳٿơ
  *   PLLDelay: PLLӳٿƣȡֵΧΪ
  *                   PLL_START_DELAY_64: ӳ64ʱ
  *                   PLL_START_DELAY_128: ӳ128ʱ
  *                   PLL_START_DELAY_256: ӳ256ʱ
  *                   PLL_START_DELAY_512: ӳ512ʱ
  *                   PLL_START_DELAY_1024: ӳ1024ʱ
  *                   PLL_START_DELAY_2048: ӳ2048ʱ
  *                   PLL_START_DELAY_4096: ӳ4096ʱ
  *                   PLL_START_DELAY_8192: ӳ8192ʱ
  *                   PLL_START_DELAY_16384: ӳ16384ʱ
  *                   PLL_START_DELAY_32768: ӳ32768ʱ
  *   ޡ
  */
void
OSC_PLL_Start_Delay_Config (uint32_t PLLDelay)
{
    uint32_t tmpreg = 0;

    /* У */
    CHECK_RESTRICTION(CHECK_PLL_START_DELAY(PLLDelay));

    /*---------------- OSC_CTL2ĴPLLDLYλ ----------------*/
    tmpreg = PLLDelay << OSC_CTL2_PLLDLY0_POS;
    OSC_CTL2 = SFR_Config (OSC_CTL2, ~OSC_CTL2_PLLDLY, tmpreg);
}


/**
  *   ⲿƵӳٿơ
  *   ExternalDelay: ⲿƵӳٿƣȡֵΧΪ
  *                        EXT_START_DELAY_256: ӳ256ʱ
  *                        EXT_START_DELAY_512: ӳ512ʱ
  *                        EXT_START_DELAY_1024: ӳ1024ʱ
  *                        EXT_START_DELAY_2048: ӳ2048ʱ
  *                        EXT_START_DELAY_4096: ӳ4096ʱ
  *                        EXT_START_DELAY_8192: ӳ8192ʱ
  *                        EXT_START_DELAY_16384: ӳ16384ʱ
  *                        EXT_START_DELAY_32768: ӳ32768ʱ
  *                        EXT_START_DELAY_65536: ӳ65536ʱ
  *   ޡ
  */
void
OSC_EXTHF_Start_Delay_Config (uint32_t ExternalDelay)
{
    uint32_t tmpreg = 0;

    /* У */
    CHECK_RESTRICTION(CHECK_EXT_START_DELAY(ExternalDelay));

    /*---------------- OSC_CTL2ĴEHFDLYλ ----------------*/
    tmpreg = ExternalDelay << OSC_CTL2_EHFDLY0_POS;
    OSC_CTL2 = SFR_Config (OSC_CTL2, ~OSC_CTL2_EHFDLY, tmpreg);
}

/**
  *   ⲿƵӳٿơ
  *   ExternalDelay: ⲿƵӳٿƣȡֵΧΪ
  *                        EXT_START_DELAY_256: ӳ256ʱ
  *                        EXT_START_DELAY_512: ӳ512ʱ
  *                        EXT_START_DELAY_1024: ӳ1024ʱ
  *                        EXT_START_DELAY_2048: ӳ2048ʱ
  *                        EXT_START_DELAY_4096: ӳ4096ʱ
  *                        EXT_START_DELAY_8192: ӳ8192ʱ
  *                        EXT_START_DELAY_16384: ӳ16384ʱ
  *                        EXT_START_DELAY_32768: ӳ32768ʱ
  *                        EXT_START_DELAY_65536: ӳ65536ʱ

  *   ޡ
  */
void
OSC_EXTLF_Start_Delay_Config (uint32_t ExternalDelay)
{
    uint32_t tmpreg = 0;

    /* У */
    CHECK_RESTRICTION(CHECK_EXT_START_DELAY(ExternalDelay));

    /*---------------- OSC_CTL2ĴELFDLYλ ----------------*/
    tmpreg = ExternalDelay << OSC_CTL2_ELFDLY0_POS;
    OSC_CTL2 = SFR_Config (OSC_CTL2, ~OSC_CTL2_ELFDLY, tmpreg);
}

/**
  *   PLLʹܡ
  *   NewState: PLLʹ״̬ȡֵΧΪTRUE  FALSE
  *   ޡ
  */
void
OSC_PLL_Software_Enable (FunctionalState NewState)
{
    /* У */
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

    /*---------------- OSC_CTL2ĴPLLSWENλ ----------------*/
    if (NewState != FALSE)
    {
        /* ʹPLL */
        SFR_SET_BIT_ASM(OSC_CTL2, OSC_CTL2_PLLSWEN_POS);
    }
    else
    {
        /* Ч */
        SFR_CLR_BIT_ASM(OSC_CTL2, OSC_CTL2_PLLSWEN_POS);
    }
}

/**
  *   ⲿƵʹܡ
  *   NewState: ⲿƵʹ״̬ȡֵΧΪTRUE  FALSE
  *   ޡ
  */
void
OSC_EXTHF_Software_Enable (FunctionalState NewState)
{
    /* У */
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

    /*---------------- OSC_CTL2ĴEXTHFSWENλ ----------------*/
    if (NewState != FALSE)
    {
        /* ʹⲿƵ */
        SFR_SET_BIT_ASM(OSC_CTL2, OSC_CTL2_EXTHFSWEN_POS);
    }
    else
    {
        /* Ч */
        SFR_CLR_BIT_ASM(OSC_CTL2, OSC_CTL2_EXTHFSWEN_POS);
    }
}

/**
  *   ⲿƵʹܡ
  *   NewState: ⲿƵʹ״̬ȡֵΧΪTRUE  FALSE
  *   ޡ
  */
void
OSC_EXTLF_Software_Enable (FunctionalState NewState)
{
    /* У */
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

    /*---------------- OSC_CTL2ĴEXTLFSWENλ ----------------*/
    if (NewState != FALSE)
    {
        /* ʹⲿƵ */
        SFR_SET_BIT_ASM(OSC_CTL2, OSC_CTL2_EXTLFSWEN_POS);
    }
    else
    {
        /* Ч */
        SFR_CLR_BIT_ASM(OSC_CTL2, OSC_CTL2_EXTLFSWEN_POS);
    }
}

/**
  *   ڲƵʹܡ
  *   NewState: ڲƵʹ״̬ȡֵΧΪTRUE  FALSE
  *   ޡ
  */
void
OSC_INTHF_Software_Enable (FunctionalState NewState)
{
    /* У */
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

    /*---------------- OSC_CTL2ĴINTHFSWENλ ----------------*/
    if (NewState != FALSE)
    {
        /* ʹڲƵ */
        SFR_SET_BIT_ASM(OSC_CTL2, OSC_CTL2_INTHFSWEN_POS);
    }
    else
    {
        /* Ч */
        SFR_CLR_BIT_ASM(OSC_CTL2, OSC_CTL2_INTHFSWEN_POS);
    }
}

/**
  *   ڲƵʹܡ
  *   NewState: ڲƵʹ״̬ȡֵΧΪTRUE  FALSE
  *   ޡ
  */
void
OSC_INTLF_Software_Enable (FunctionalState NewState)
{
    /* У */
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

    /*---------------- OSC_CTL2ĴINTLFSWENλ ----------------*/
    if (NewState != FALSE)
    {
        /* ʹڲƵ */
        SFR_SET_BIT_ASM(OSC_CTL2, OSC_CTL2_INTLFSWEN_POS);
    }
    else
    {
        /* Ч */
        SFR_CLR_BIT_ASM(OSC_CTL2, OSC_CTL2_INTLFSWEN_POS);
    }
}

/**
  *   ƯľֵУ׼Ȩλ
  *   Scale: ƯѡȡֵΪкһϣ
  *                ZERO_DRIFT_SCALEDIV32: 1/32uA
  *                ZERO_DRIFT_SCALEDIV16: 1/16uA
  *                ZERO_DRIFT_SCALEDIV8: 1/8uA
  *                ZERO_DRIFT_SCALEDIV4: 1/4uA
  *                ZERO_DRIFT_SCALEDIV2: 1/2uA
  *                ZERO_DRIFT_SCALE1X: 1uA
  *                ZERO_DRIFT_SCALE2X: 2uA
  *                ZERO_DRIFT_SCALE4X: 4uA
  *                ZERO_DRIFT_SCALE8X: 8uA
  *                ZERO_DRIFT_SCALE16X0: 16uA
  *                ZERO_DRIFT_SCALE16X1: 16uA
  *                ZERO_DRIFT_SCALE16X2: 16uA
  *                ZERO_DRIFT_SCALE16X3: 16uA
  *                ZERO_DRIFT_SCALE16X4: 16uA
  *                ZERO_DRIFT_SCALE32X: 32uA
  *       NewState: Ư״̬ȡֵΧΪTRUE  FALSE
  *   ޡ
  */
void
OSC_Zero_Drift_Config (uint32_t Scale, FunctionalState NewState)
{
    /* У */
    CHECK_RESTRICTION(CHECK_ZERO_DRIFT(Scale));
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

    /*---------------- OSC_HFOSCCAL0Ĵ ----------------*/
    if (NewState != FALSE)
    {
        /* ָ */
        OSC_HFOSCCAL0 |= Scale;
    }
    else
    {
        /* ָر */
        OSC_HFOSCCAL0 &= ~Scale;
    }
}

/**
  *   ڲƵµڡ
  *   PositiveDrift: ڲƵµڣȡֵΧΪ0~31
  *   ޡ
  */
void
OSC_Positive_Drift_Config (uint32_t PositiveDrift)
{
    uint32_t tmpreg = 0;

    /* У */
    CHECK_RESTRICTION(CHECK_POSITIVE_DRIFT(PositiveDrift));

    /*---------------- OSC_HFOSCCAL0ĴPTATλ ----------------*/
    tmpreg = PositiveDrift << OSC_HFOSCCAL0_PTAT0_POS;
    OSC_HFOSCCAL0 = SFR_Config (OSC_HFOSCCAL0, ~OSC_HFOSCCAL0_PTAT, tmpreg);
}

/**
  *   ڲƵĸµڡ
  *   NegativeDrift: ڲƵĸµڣȡֵΧΪ0~31
  *   ޡ
  */
void
OSC_Negative_Drift_Config (uint32_t PositiveDrift)
{
    uint32_t tmpreg = 0;

    /* У */
    CHECK_RESTRICTION(CHECK_NEGATIVE_DRIFT(PositiveDrift));

    /*---------------- OSC_HFOSCCAL0ĴCTATλ ----------------*/
    tmpreg = PositiveDrift << OSC_HFOSCCAL0_CTAT0_POS;
    OSC_HFOSCCAL0 = SFR_Config (OSC_HFOSCCAL0, ~OSC_HFOSCCAL0_CTAT, tmpreg);
}

/**
  *   õѡ
  *   CurrentGain: ѡȡֵΧΪ0~3
  *   ޡ
  */
void
OSC_Current_Gain_Config (uint32_t PositiveDrift)
{
    uint32_t tmpreg = 0;

    /* У */
    CHECK_RESTRICTION(CHECK_CURRENT_GAIN(PositiveDrift));

    /*---------------- OSC_HFOSCCAL1ĴSELGAINλ ----------------*/
    tmpreg = PositiveDrift << OSC_HFOSCCAL1_SELGAIN0_POS;
    OSC_HFOSCCAL1 = SFR_Config (OSC_HFOSCCAL1, ~OSC_HFOSCCAL1_SELGAIN, tmpreg);
}

/**
  *   øѡ
  *   NewState: ѡ״̬ȡֵΧΪTRUE  FALSE
  *   ޡ
  */
void
OSC_High_Speed_Enable (FunctionalState NewState)
{
    /* У */
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

    /*---------------- OSC_HFOSCCAL1ĴHSFSENλ ----------------*/
    if (NewState != FALSE)
    {
        /* жʹ */
        SFR_SET_BIT_ASM(OSC_HFOSCCAL1, OSC_HFOSCCAL1_HSFSEN_POS);
    }
    else
    {
        /* жϽֹ */
        SFR_CLR_BIT_ASM(OSC_HFOSCCAL1, OSC_HFOSCCAL1_HSFSEN_POS);
    }
}

/**
  *   ⲿƵʹܡ
  *   NewState: ⲿƵʹ״̬ȡֵΧΪTRUE  FALSE
  *   ޡ
  */
void
OSC_External_Input_Enable (FunctionalState NewState)
{
    /* У */
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

    /*---------------- OSC_HFOSCCAL1ĴHSXTALEXENλ ----------------*/
    if (NewState != FALSE)
    {
        /* жʹ */
        SFR_SET_BIT_ASM(OSC_HFOSCCAL1, OSC_HFOSCCAL1_HSXTALEXEN_POS);
    }
    else
    {
        /* жϽֹ */
        SFR_CLR_BIT_ASM(OSC_HFOSCCAL1, OSC_HFOSCCAL1_HSXTALEXEN_POS);
    }
}

/**
  *   ÷ڡ
  *   NewState: ڣȡֵΧΪ
  *                   FREQUENCY_MORE_THAN_10M: Ƶʴ10MHz
  *                   FREQUENCY_LESS_THAN_10M: ƵС10MHz
  *   ޡ
  */
void
OSC_Feedback_Resistance_Config (uint32_t NewState)
{
    /* У */
    CHECK_RESTRICTION(CHECK_FEEDBACK_RESISTANCE(NewState));

    /*---------------- OSC_HFOSCCAL1ĴHLSWλ ----------------*/
    if (NewState != FREQUENCY_MORE_THAN_10M)
    {
        /* ƵС10MHz */
        SFR_SET_BIT_ASM(OSC_HFOSCCAL1, OSC_HFOSCCAL1_HLSW_POS);
    }
    else
    {
        /* Ƶʴ10MHz */
        SFR_CLR_BIT_ASM(OSC_HFOSCCAL1, OSC_HFOSCCAL1_HLSW_POS);
    }
}
/**
  *   PLLƯԴIOʹܡ
  *   NewState: PLLƯԴIOʹ״̬
  *                 ȡֵΧΪTRUE  FALSE
  *   ޡ
  */
void
OSC_PLL_Zero_Source_Enable (FunctionalState NewState)
{
    /* У */
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

    /*---------------- PLL_CTL0ĴTSZEROISλ ----------------*/
    if (NewState != FALSE)
    {
        /* ƯԴIOͨ */
        SFR_SET_BIT_ASM(PLL_CTL, PLL_CTL_TSZEROIS_POS);
    }
    else
    {
        /* رƯԴIOͨ */
        SFR_CLR_BIT_ASM(PLL_CTL, PLL_CTL_TSZEROIS_POS);
    }
}

/**
  *   PLLڲοѹ2VIOڵʹܡ
  *   NewState: PLLڲοѹ2VIOڵʹ״̬
  *                 ȡֵΧΪTRUE  FALSE
  *   ޡ
  */
void
OSC_PLL_Vref2_Enable (FunctionalState NewState)
{
    /* У */
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

    /*---------------- PLL_CTL0ĴTSVREF2Vλ ----------------*/
    if (NewState != FALSE)
    {
        /* ڲοѹ2VIOͨ */
        SFR_SET_BIT_ASM(PLL_CTL, PLL_CTL_TSVREF2V_POS);
    }
    else
    {
        /* رڲοѹ2VIOͨ */
        SFR_CLR_BIT_ASM(PLL_CTL, PLL_CTL_TSVREF2V_POS);
    }
}

/**
  *   PLLڲ͹BGο0.5Vڲbufferʹܡ
  *   NewState: PLLڲ͹BGο0.5Vڲbufferʹ״̬
  *                 ȡֵΧΪTRUE  FALSE
  *   ޡ
  */
void
OSC_PLL_Vref0p5_Enable (FunctionalState NewState)
{
    /* У */
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

    /*---------------- PLL_CTL0ĴTSVREF0P5λ ----------------*/
    if (NewState != FALSE)
    {
        /* ڲ͹BGο0.5Vڲbufferͨ */
        SFR_SET_BIT_ASM(PLL_CTL, PLL_CTL_TSVREF0P5_POS);
    }
    else
    {
        /* رڲ͹BGο0.5Vڲbufferͨ */
        SFR_CLR_BIT_ASM(PLL_CTL, PLL_CTL_TSVREF0P5_POS);
    }
}

/**
  *   PLLBGڲbufferͨʹܡ
  *   NewState: PLLBGڲbufferͨʹ״̬
  *                 ȡֵΧΪTRUE  FALSE
  *   ޡ
  */
void
OSC_PLL_Vref1p2_Enable (FunctionalState NewState)
{
    /* У */
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

    /*---------------- PLL_CTL0ĴTSMRBGλ ----------------*/
    if (NewState != FALSE)
    {
        /* BGο1.2Vڲbufferͨ */
        SFR_SET_BIT_ASM(PLL_CTL, PLL_CTL_TSMRBG_POS);
    }
    else
    {
        /* رBGο1.2Vڲbufferͨ */
        SFR_CLR_BIT_ASM(PLL_CTL, PLL_CTL_TSMRBG_POS);
    }
}

/**
  *   PLLڲ͹BGĵԴ20nAIOڵѡͨʹܡ
  *   NewState: PLLڲ͹BGĵԴ20nAIOڵѡͨʹ״̬
  *                 ȡֵΧΪTRUE  FALSE
  *   ޡ
  */
void
OSC_PLL_Low_Power_20nA_Enable (FunctionalState NewState)
{
    /* У */
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

    /*---------------- PLL_CTL0ĴTSLSRCISλ ----------------*/
    if (NewState != FALSE)
    {
        /* ڲ͹BGĵԴ20nAIOڵͨ */
        SFR_SET_BIT_ASM(PLL_CTL, PLL_CTL_TSLSRCIS_POS);
    }
    else
    {
        /* رڲ͹BGĵԴ20nAIOڵͨ */
        SFR_CLR_BIT_ASM(PLL_CTL, PLL_CTL_TSLSRCIS_POS);
    }
}

/**
  *   PLLڲ͹Ĳοѹ1.14Vڲbufferѡͨʹܡ
  *   NewState: PLLڲ͹Ĳοѹ1.14Vڲbufferѡͨʹ״̬
  *                 ȡֵΧΪTRUE  FALSE
  *   ޡ
  */
void
OSC_PLL_Vref1p14_Enable (FunctionalState NewState)
{
    /* У */
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

    /*---------------- PLL_CTL0ĴTSLPBGλ ----------------*/
    if (NewState != FALSE)
    {
        /* ڲ͹Ĳοѹ1.14Vڲbufferͨ */
        SFR_SET_BIT_ASM(PLL_CTL, PLL_CTL_TSLPBG_POS);
    }
    else
    {
        /* رڲ͹Ĳοѹ1.14Vڲbufferͨ */
        SFR_CLR_BIT_ASM(PLL_CTL, PLL_CTL_TSLPBG_POS);
    }
}

/**
  *   PLLڲ͹ƫõ·ĵԴ100nAIOڵѡͨʹܡ
  *   NewState: PLLڲ͹ƫõ·ĵԴ100nAIOڵѡͨʹ״̬
  *                 ȡֵΧΪTRUE  FALSE
  *   ޡ
  */
void
OSC_PLL_Low_Power_100nA_Enable (FunctionalState NewState)
{
    /* У */
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

    /*---------------- PLL_CTL0ĴTSLCDISλ ----------------*/
    if (NewState != FALSE)
    {
        /* ڲ͹ƫõ·ĵԴ100nAIOڵͨ */
        SFR_SET_BIT_ASM(PLL_CTL, PLL_CTL_TSLCDIS_POS);
    }
    else
    {
        /* رڲ͹ƫõ·ĵԴ100nAIOڵͨ */
        SFR_CLR_BIT_ASM(PLL_CTL, PLL_CTL_TSLCDIS_POS);
    }
}

/**
  *   PLLڲƵLDOڲbufferѡͨʹܡ
  *   NewState: PLLڲƵLDOڲbufferѡͨʹ״̬
  *                 ȡֵΧΪTRUE  FALSE
  *   ޡ
  */
void
OSC_PLL_LDO_Enable (FunctionalState NewState)
{
    /* У */
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

    /*---------------- PLL_CTL0ĴTSHSILDO12λ ----------------*/
    if (NewState != FALSE)
    {
        /* ڲƵLDOڲbufferͨ */
        SFR_SET_BIT_ASM(PLL_CTL, PLL_CTL_TSHSILDO12_POS);
    }
    else
    {
        /* رڲƵLDOڲbufferͨ */
        SFR_CLR_BIT_ASM(PLL_CTL, PLL_CTL_TSHSILDO12_POS);
    }
}

/**
  *   PLLжʹܡ
  *   NewState: PLLжʹ״̬ȡֵΧΪTRUE  FALSE
  *   ޡ
  */
void
OSC_PLL_INT_Enable (FunctionalState NewState)
{
    /* У */
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

    /*---------------- OSC_INTĴPLLIEλ ----------------*/
    if (NewState != FALSE)
    {
        /* жʹ */
        SFR_SET_BIT_ASM(OSC_INT, OSC_INT_PLLIE_POS);
    }
    else
    {
        /* жϽֹ */
        SFR_CLR_BIT_ASM(OSC_INT, OSC_INT_PLLIE_POS);
    }
}

/**
  *   ⲿƵжʹܡ
  *   NewState: ⲿƵжʹ״̬ȡֵΧΪTRUE  FALSE
  *   ޡ
  */
void
OSC_EXTHF_INT_Enable (FunctionalState NewState)
{
    /* У */
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

    /*---------------- OSC_INTĴEHFIEλ ----------------*/
    if (NewState != FALSE)
    {
        /* жʹ */
        SFR_SET_BIT_ASM(OSC_INT, OSC_INT_EHFIE_POS);
    }
    else
    {
        /* жϽֹ */
        SFR_CLR_BIT_ASM(OSC_INT, OSC_INT_EHFIE_POS);
    }
}

/**
  *   ⲿƵжʹܡ
  *   NewState: ⲿƵжʹ״̬ȡֵΧΪTRUE  FALSE
  *   ޡ
  */
void
OSC_EXTLF_INT_Enable (FunctionalState NewState)
{
    /* У */
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

    /*---------------- OSC_INTĴELFIEλ ----------------*/
    if (NewState != FALSE)
    {
        /* жʹ */
        SFR_SET_BIT_ASM(OSC_INT, OSC_INT_ELFIE_POS);
    }
    else
    {
        /* жϽֹ */
        SFR_CLR_BIT_ASM(OSC_INT, OSC_INT_ELFIE_POS);
    }
}

/**
  *   ڲƵжʹܡ
  *   NewState: ڲƵжʹ״̬ȡֵΧΪTRUE  FALSE
  *   ޡ
  */
void
OSC_INTHF_INT_Enable (FunctionalState NewState)
{
    /* У */
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

    /*---------------- OSC_INTĴIHFIEλ ----------------*/
    if (NewState != FALSE)
    {
        /* жʹ */
        SFR_SET_BIT_ASM(OSC_INT, OSC_INT_IHFIE_POS);
    }
    else
    {
        /* жϽֹ */
        SFR_CLR_BIT_ASM(OSC_INT, OSC_INT_IHFIE_POS);
    }
}

/**
  *   LP4Mжʹܡ
  *   NewState: LP4Mжʹ״̬ȡֵΧΪTRUE  FALSE
  *   ޡ
  */
void
OSC_LP4M_INT_Enable (FunctionalState NewState)
{
    /* У */
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

    /*---------------- OSC_INTĴLP4MIEλ ----------------*/
    if (NewState != FALSE)
    {
        /* жʹ */
        SFR_SET_BIT_ASM(OSC_INT, OSC_INT_LP4MIE_POS);
    }
    else
    {
        /* жϽֹ */
        SFR_CLR_BIT_ASM(OSC_INT, OSC_INT_LP4MIE_POS);
    }
}


/**
  *   ڲƵжʹܡ
  *   NewState: ڲƵжʹ״̬ȡֵΧΪTRUE  FALSE
  *   ޡ
  */
void
OSC_INTLF_INT_Enable (FunctionalState NewState)
{
    /* У */
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

    /*---------------- OSC_INTĴILFIEλ ----------------*/
    if (NewState != FALSE)
    {
        /* жʹ */
        SFR_SET_BIT_ASM(OSC_INT, OSC_INT_ILFIE_POS);
    }
    else
    {
        /* жϽֹ */
        SFR_CLR_BIT_ASM(OSC_INT, OSC_INT_ILFIE_POS);
    }
}

/**
  *   ȡʱӹϱ־
  *   ޡ
  *   ʱӹ״̬0ûʱӹϣ1⵽ʱӹϡ
  */
FlagStatus
OSC_Get_Clock_Failure_INT_Flag (void)
{
    /*---------------- OSC_INTĴCKFIFλ ----------------*/
    if (OSC_INT & OSC_INT_CKFIF)
    {
        /* ⵽ʱӹ */
        return SET;
    }
    else
    {
        /* ûʱӹ */
        return RESET;
    }
}

/**
  *   ȡPLLжϱ־
  *   ޡ
  *   ж״̬0δжϣ1жϡ
  */
FlagStatus
OSC_Get_PLL_INT_Flag (void)
{
    /*---------------- OSC_INTĴPLLIFλ ----------------*/
    if (OSC_INT & OSC_INT_PLLIF)
    {
        /* PLL */
        return SET;
    }
    else
    {
        /* PLLδ */
        return RESET;
    }
}

/**
  *   ȡⲿƵжϱ־
  *   ޡ
  *   ж״̬0δжϣ1жϡ
  */
FlagStatus
OSC_Get_EXTHF_INT_Flag (void)
{
    /*---------------- OSC_INTĴEHFIFλ ----------------*/
    if (OSC_INT & OSC_INT_EHFIF)
    {
        /* PLL */
        return SET;
    }
    else
    {
        /* PLLδ */
        return RESET;
    }
}

/**
  *   ȡⲿƵжϱ־
  *   ޡ
  *   ж״̬0δжϣ1жϡ
  */
FlagStatus
OSC_Get_EXTLF_INT_Flag (void)
{
    /*---------------- OSC_INTĴELFIFλ ----------------*/
    if (OSC_INT & OSC_INT_ELFIF)
    {
        /* PLL */
        return SET;
    }
    else
    {
        /* PLLδ */
        return RESET;
    }
}

/**
  *   ȡڲƵжϱ־
  *   ޡ
  *   ж״̬0δжϣ1жϡ
  */
FlagStatus
OSC_Get_INTHF_INT_Flag (void)
{
    /*---------------- OSC_INTĴIHFIFλ ----------------*/
    if (OSC_INT & OSC_INT_IHFIF)
    {
        /* PLL */
        return SET;
    }
    else
    {
        /* PLLδ */
        return RESET;
    }
}

/**
  *   ȡڲƵжϱ־
  *   ޡ
  *   ж״̬0δжϣ1жϡ
  */
FlagStatus
OSC_Get_INTLF_INT_Flag (void)
{
    /*---------------- OSC_INTĴILFIFλ ----------------*/
    if (OSC_INT & OSC_INT_ILFIF)
    {
        /* PLL */
        return SET;
    }
    else
    {
        /* PLLδ */
        return RESET;
    }
}
/**
  *   ȡLP4Mжϱ־
  *   ޡ
  *   ж״̬0δжϣ1жϡ
  */
FlagStatus
OSC_Get_LP4MIF_INT_Flag (void)
{
    /*---------------- OSC_INTĴILFIFλ ----------------*/
    if (OSC_INT & OSC_INT_LP4MIF)
    {
        /* PLL */
        return SET;
    }
    else
    {
        /* PLLδ */
        return RESET;
    }
}
/**
  *   ##### (OSC)жϿƺ #####
  */

