/**
  ******************************************************************************
  * ļ  kf32f_basic_adc.c
  *     ChipON_AE/FAE_Group
  *     V3.0.0
  *     2021-08-20
  *     ļṩģתģ(ADC)蹦ܺ
  *          + ģתģ(ADC)ʼ
  *          + ģתģ(ADC)ģ⿴Źʼ
  *          + ģתģ(ADC)ƹú
  *          + ģתģ(ADC)ͨú
  *          + ģתģ(ADC)ȼͨú
  *          + ģתģ(ADC)жϹ
  *
  *********************************************************************
  */

#include "kf32f_basic_adc.h"
#include "kf32f_basic_rst.h"
#include "kf32f_basic_pclk.h"


/* ģתģ(ADC)˽ж -------------------------------------------------*/

/* ADCx_CTL0Ĵʼ */
#define ADC_CTL0_INIT_MASK             (ADC_CTL0_CLKS \
                                       | ADC_CTL0_ADCCLKS \
                                       | ADC_CTL0_SCANEN \
                                       | ADC_CTL0_CONT \
                                       | ADC_CTL0_LR)

/* ADCx_CTL0Ĵģ⿴Ź */
#define ADC_CTL0_AWDMODE_MASK           (ADC_CTL0_WDSCH \
                                       | ADC_CTL0_HPWDEN \
                                       | ADC_CTL0_WDEN)

/* ADCx_CTL1Ĵʼ */
#define ADC_CTL1_INIT_MASK              (ADC_CTL1_EXTEN \
                                       | ADC_CTL1_HPEXTEN \
                                       | ADC_CTL1_NCH \
                                       | ADC_CTL1_HCH \
                                       | ADC_CTL1_REF)

/* ADC0_DELAYĴʼ */
#define ADC0_DELAY_INIT_MASK            (ADC0_DELAY_FDELAY \
                                       | ADC0_DELAY_SDELAY)


/**
  *   ##### ģתģ(ADC)ʼ #####
  */
/**
  *   λADC裬ʹʱӡ
  *   ADCx: ָADCڴṹָ룬ȡֵΪADC0_SFR~ADC2_SFR
  *   ޡ
  */
void
ADC_Reset (ADC_SFRmap* ADCx)
{
    /* У */
    CHECK_RESTRICTION(CHECK_ADC_ALL_PERIPH(ADCx));

#ifdef KF32F_Periph_adc0
    if (ADCx == ADC0_SFR)
    {
        RST_CTL1_Peripheral_Reset_Enable(RST_CTL1_ADC0RST, TRUE);
        RST_CTL1_Peripheral_Reset_Enable(RST_CTL1_ADC0RST, FALSE);
        PCLK_CTL1_Peripheral_Clock_Enable(PCLK_CTL1_ADC0CLKEN, TRUE);
    }
#endif
#ifdef KF32F_Periph_adc1
    if (ADCx == ADC1_SFR)
    {
        RST_CTL1_Peripheral_Reset_Enable(RST_CTL1_ADC1RST, TRUE);
        RST_CTL1_Peripheral_Reset_Enable(RST_CTL1_ADC1RST, FALSE);
        PCLK_CTL1_Peripheral_Clock_Enable(PCLK_CTL1_ADC1CLKEN, TRUE);
    }
#endif
#ifdef KF32F_Periph_adc2
    if (ADCx == ADC2_SFR)
    {
        RST_CTL1_Peripheral_Reset_Enable(RST_CTL1_ADC2RST, TRUE);
        RST_CTL1_Peripheral_Reset_Enable(RST_CTL1_ADC2RST, FALSE);
        PCLK_CTL1_Peripheral_Clock_Enable(PCLK_CTL1_ADC2CLKEN, TRUE);
    }
#endif
}

/**
  *   ģתģ(ADC)ʼá
  *   ADCx: ָADCڴṹָ룬ȡֵΪADC0_SFR~ADC2_SFR
  *       adcInitStruct: ADCģϢṹָ롣
  *   ޡ
  */
void
ADC_Configuration (ADC_SFRmap* ADCx, ADC_InitTypeDef* adcInitStruct)
{
    uint32_t tmpreg = 0;

    /* У */
    CHECK_RESTRICTION(CHECK_ADC_ALL_PERIPH(ADCx));
    CHECK_RESTRICTION(CHECK_ADC_CLK(adcInitStruct->m_Clock));
    CHECK_RESTRICTION(CHECK_ADC_CLK_DIV(adcInitStruct->m_ClockDiv));
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(adcInitStruct->m_ScanMode));
    CHECK_RESTRICTION(CHECK_ADC_CONV_MODE(adcInitStruct->m_ContinuousMode));
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(adcInitStruct->m_ExternalTrig_EN));
    CHECK_RESTRICTION(CHECK_ADC_EXT_TRIG(adcInitStruct->m_ExternalTrig));
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(adcInitStruct->m_HPExternalTrig_EN));
    CHECK_RESTRICTION(CHECK_ADC_HPEXT_TRIG(adcInitStruct->m_HPExternalTrig));
    CHECK_RESTRICTION(CHECK_ADC_DATA_ALIGN(adcInitStruct->m_DataAlign));
    CHECK_RESTRICTION(CHECK_ADC_REF(adcInitStruct->m_VoltageRef));
    CHECK_RESTRICTION(CHECK_ADC_REGULAR_LENGTH(adcInitStruct->m_NumOfConv));
    CHECK_RESTRICTION(CHECK_ADC_HIGH_PRIORITY_LENGTH(adcInitStruct->m_NumOfHPConv));

    /*---------------- ADC_CTL0Ĵ ----------------*/
    /* ݽṹԱm_ClockCLKSλ */
    /* ݽṹԱm_ClockDivADCCLKSλ */
    /* ݽṹԱm_ScanModeSCANENλ */
    /* ݽṹԱm_ContinuousModeCONTλ */
    /* ݽṹԱm_DataAlignLRλ */
    tmpreg = (uint32_t)(adcInitStruct->m_Clock | \
                        adcInitStruct->m_ClockDiv | \
                        ((uint32_t)adcInitStruct->m_ScanMode << 17) | \
                        adcInitStruct->m_ContinuousMode | \
                        adcInitStruct->m_DataAlign
                        );
    ADCx->CTL0 = SFR_Config (ADCx->CTL0, ~ADC_CTL0_INIT_MASK, tmpreg);

    /*---------------- ADC_CTL1Ĵ ----------------*/
    /* ݽṹԱm_ExternalTrig_ENEXTENλ */
    /* ݽṹԱm_HPExternalTrig_ENHPEXTENλ */
    /* ݽṹԱm_ExternalTrigNCHλ */
    /* ݽṹԱm_HPExternalTrigHCHλ */
    /* ݽṹԱm_VoltageRefREFλ */
    tmpreg = (uint32_t)(((uint32_t)adcInitStruct->m_ExternalTrig_EN << 11) | \
                         ((uint32_t)adcInitStruct->m_HPExternalTrig_EN << 27) | \
                         adcInitStruct->m_ExternalTrig | \
                         adcInitStruct->m_HPExternalTrig | \
                         adcInitStruct->m_VoltageRef);
    ADCx->CTL1 = SFR_Config (ADCx->CTL1, ~ADC_CTL1_INIT_MASK, tmpreg);

    /*---------------- ADC_SCANSQ3Ĵ ----------------*/
    /* ݽṹԱm_NumOfConvSLENλ */
    tmpreg = (adcInitStruct->m_NumOfConv - 1) << 28;
    ADCx->SCANSQ3 = SFR_Config (ADCx->SCANSQ3,
                                  ~ADC_SCANSQ3_SLEN,
                                  tmpreg);

    /*---------------- ADC_HSCANSQĴ ----------------*/
    /* ݽṹԱm_NumOfHPConvHSLENλ */
    tmpreg = (adcInitStruct->m_NumOfHPConv - 1) << 28;
    ADCx->HSCANSQ = SFR_Config (ADCx->HSCANSQ,
                                  ~ADC_HSCANSQ_HSLEN,
                                  tmpreg);
}

/**
  *   ʼADCϢṹ塣
  *   adcInitStruct: ָʼĽṹָ롣
  *   ޡ
  */
void
ADC_Struct_Init (ADC_InitTypeDef* adcInitStruct)
{
    /* ʼ ADCʱԴѡ */
    adcInitStruct->m_Clock = ADC_SCLK;

    /* ʼ ADCʱӷƵ */
    adcInitStruct->m_ClockDiv = ADC_CLK_DIV_2;

    /* ʼ ADCɨģʽʹ */
    adcInitStruct->m_ScanMode = FALSE;

    /* ʼ ADCתģʽ */
    adcInitStruct->m_ContinuousMode = ADC_SINGLE_MODE;

    /* ʼ ADCתʽ */
    adcInitStruct->m_DataAlign = ADC_DATAALIGN_LEFT;

    /* ʼ ADCͨⲿתģʽʹ */
    adcInitStruct->m_ExternalTrig_EN = FALSE;

    /* ʼ ADCͨⲿ¼ */
    adcInitStruct->m_ExternalTrig = ADC_EXTERNALTRIG_CCP1_CH1;

    /* ʼ ADCȼͨⲿתģʽʹ */
    adcInitStruct->m_HPExternalTrig_EN = FALSE;

    /* ʼ ȼͨⲿ¼ */
    adcInitStruct->m_HPExternalTrig = ADC_HPEXTERNALTRIG_CCP1_CH1;

    /* ʼ ADCοѹѡ */
    adcInitStruct->m_VoltageRef = ADC_REF_AVDD;

    /* ʼ ADCͨɨ賤 */
    adcInitStruct->m_NumOfConv = 1;

    /* ʼ ADCȼͨɨ賤 */
    adcInitStruct->m_NumOfHPConv = 1;
}

/**
  *   ADC0_DELAYʼá
  *   adc0Delay: ADC0ģʽϢṹ塣
  *   ޡ
  */
void
ADC_Delay_Configuration (ADC0_DELAY_InitTypeDef* adc0Delay)
{
    uint32_t tmpreg = 0;

    /* У */
    CHECK_RESTRICTION(CHECK_ADC_FDELAY_MODE(adc0Delay->m_FastDelay));
    CHECK_RESTRICTION(CHECK_ADC_SDELAY_MODE(adc0Delay->m_SlowDelay));

    /*---------------- ADC0_DELAYĴ ----------------*/
    /* ݽṹԱm_SlowDelaySDELAYλ */
    /* ݽṹԱm_FastDelayFDELAYλ */
    tmpreg = (((uint32_t)(adc0Delay->m_SlowDelay - 1) << 16) | \
              ((uint32_t)(adc0Delay->m_FastDelay - 1)));
#ifdef KF32F_Periph_adc0
    ADC0_DELAY = SFR_Config (ADC0_DELAY,
                               ~ADC0_DELAY_INIT_MASK,
                               tmpreg);
#endif
}

/**
  *   ʼADC0ģʽϢṹ塣
  *   adc0Delay: ָʼĽṹָ롣
  *   ޡ
  */
void
ADC_Delay_Struct_Init (ADC0_DELAY_InitTypeDef* adc0Delay)
{
    /* ʼ ADCٽģʽʱʱ */
    adc0Delay->m_FastDelay = 0x06;

    /* ʼ ADCٽģʽʱʱ */
    adc0Delay->m_SlowDelay = 0x0D;
}

/**
  *   ADCʹܡ
  *   ADCx: ָADCڴṹָ룬ȡֵΪADC0_SFR~ADC2_SFR
  *       NewState: ADCʹ״̬ȡֵΪTRUE  FALSE
  *   ޡ
  */
void
ADC_Cmd (ADC_SFRmap* ADCx, FunctionalState NewState)
{
    /* У */
    CHECK_RESTRICTION(CHECK_ADC_ALL_PERIPH(ADCx));
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

    if (NewState != FALSE)
    {
        /* ʹA/Dתģ */
        SFR_SET_BIT_ASM(ADCx->CTL0, ADC_CTL0_EN_POS);
    }
    else
    {
        /* A/DתرҲĹ */
        SFR_CLR_BIT_ASM(ADCx->CTL0, ADC_CTL0_EN_POS);
    }
}
/**
  *   ##### ģתģ(ADC)ʼ #####
  */


/**
  *   ##### ģתģ(ADC)ģ⿴Źʼ #####
  */
/**
  *   ADCģ⿴Źʼá
  *   ADCx: ָADCڴṹָ룬ȡֵΪADC0_SFR~ADC2_SFR
  *       adcAnalogWatchdog: ADCģ⿴ŹϢṹָ롣
  *   ޡ
  */
void
ADC_Analog_Watchdog_Configuration (ADC_SFRmap* ADCx,
                    ADC_WD_InitTypeDef * adcAnalogWatchdog)
{
    uint32_t tmpreg = 0;

    /* У */
    CHECK_RESTRICTION(CHECK_ADC_ALL_PERIPH(ADCx));
    CHECK_RESTRICTION(CHECK_ADC_WDSCH(adcAnalogWatchdog->m_WDSingleCH));
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(adcAnalogWatchdog->m_HPChannelWDEN));
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(adcAnalogWatchdog->m_ChannelWDEN));
    CHECK_RESTRICTION(CHECK_ADC_WDCHANNEL(adcAnalogWatchdog->m_WDChannel));
    CHECK_RESTRICTION(CHECK_ADC_THRESHOLD(adcAnalogWatchdog->m_Threshold_H));
    CHECK_RESTRICTION(CHECK_ADC_THRESHOLD(adcAnalogWatchdog->m_Threshold_L));

    /*---------------- ADC_CTL0Ĵ ----------------*/
    /* ݽṹԱm_WDSingleCHWDSCHλ */
    /* ݽṹԱm_HPChannelWDENHPWDENλ */
    /* ݽṹԱm_ChannelWDENWDENλ */
    tmpreg = (uint32_t)(adcAnalogWatchdog->m_WDSingleCH | \
                  ((uint32_t)adcAnalogWatchdog->m_HPChannelWDEN << 30) | \
                  ((uint32_t)adcAnalogWatchdog->m_ChannelWDEN << 29));
    ADCx->CTL0 = SFR_Config (ADCx->CTL0,
                               ~ADC_CTL0_AWDMODE_MASK,
                               tmpreg);

    /*---------------- ADC_SCANSQ3Ĵ ----------------*/
    /* ݽṹԱm_WDChannelWDCHλ */
    tmpreg = adcAnalogWatchdog->m_WDChannel;
    ADCx->SCANSQ3 = SFR_Config (ADCx->SCANSQ3,
                               ~ADC_SCANSQ3_WDCH,
                               tmpreg);

    /*---------------- ADC_WDHĴ ----------------*/
    /* ݽṹԱm_Threshold_HWDHλ */
    tmpreg = adcAnalogWatchdog->m_Threshold_H;
    ADCx->WDH = SFR_Config (ADCx->WDH,
                              ~ADC_WDH_WDH,
                              tmpreg);

    /*---------------- ADC_WDLĴ ----------------*/
    /* ݽṹԱm_Threshold_LWDLλ */
    tmpreg = adcAnalogWatchdog->m_Threshold_L;
    ADCx->WDL = SFR_Config (ADCx->WDL,
                              ~ADC_WDL_WDL,
                              tmpreg);
}

/**
  *   ʼADCģ⿴ŹϢṹ塣
  *   adcAnalogWatchdog: ָʼĽṹָ롣
  *   ޡ
  */
void
ADC_Analog_Watchdog_Struct_Init (ADC_WD_InitTypeDef* adcAnalogWatchdog)
{
    /* ʼ ADCģ⿴Źͨʹ */
    adcAnalogWatchdog->m_WDSingleCH = ADC_WD_ALL_CH;

    /* ʼ ADCȼͨϿŹʹ */
    adcAnalogWatchdog->m_HPChannelWDEN = FALSE;

    /* ʼ ADCͨϿŹʹ */
    adcAnalogWatchdog->m_ChannelWDEN = FALSE;

    /* ʼ ADCģ⿴Źͨѡ */
    adcAnalogWatchdog->m_WDChannel = ADC_WDCH_0;

    /* ʼ ADCģ⿴Źֵ */
    adcAnalogWatchdog->m_Threshold_H = 0x0;

    /* ʼ ADCģ⿴Źֵ */
    adcAnalogWatchdog->m_Threshold_L = 0x0;
}
/**
  *   ##### ģתģ(ADC)ģ⿴Źʼ #####
  */


/**
  *   ##### ģתģ(ADC)ƹú #####
  */
/**
  *   ɨģʽģ⿴Źһͨʹܡ
  *   ADCx: ָADCڴṹָ룬ȡֵΪADC0_SFR~ADC2_SFR
  *       NewState: ģ⿴Źһͨʹ״̬ȡֵΧΪTRUE  FALSE
  *   ޡ
  */
void
ADC_Watchdog_Single_Channel_Enable (ADC_SFRmap* ADCx, FunctionalState NewState)
{
    /* У */
    CHECK_RESTRICTION(CHECK_ADC_ALL_PERIPH(ADCx));
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

    /*---------------- ADC_CTL0ĴWDSCHλ ----------------*/
    if (NewState != FALSE)
    {
        /* ʹܵһͨ */
        SFR_SET_BIT_ASM(ADCx->CTL0, ADC_CTL0_WDSCH_POS);
    }
    else
    {
        /* ʹͨ */
        SFR_CLR_BIT_ASM(ADCx->CTL0, ADC_CTL0_WDSCH_POS);
    }
}

/**
  *   ɨģʽʹܡ
  *   ADCx: ָADCڴṹָ룬ȡֵΪADC0_SFR~ADC2_SFR
  *       NewState: ɨģʽʹ״̬ȡֵΧΪTRUE  FALSE
  *   ޡ
  */
void
ADC_Scan_Mode_Enable (ADC_SFRmap* ADCx, FunctionalState NewState)
{
    /* У */
    CHECK_RESTRICTION(CHECK_ADC_ALL_PERIPH(ADCx));
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

    /*---------------- ADC_CTL0ĴSCANENλ ----------------*/
    if (NewState != FALSE)
    {
        /* ʹɨģʽ */
        SFR_SET_BIT_ASM(ADCx->CTL0, ADC_CTL0_SCANEN_POS);
    }
    else
    {
        /* ֹɨģʽ */
        SFR_CLR_BIT_ASM(ADCx->CTL0, ADC_CTL0_SCANEN_POS);
    }
}

/**
  *   ñȽ˷οѹ֮һУ׼
  *   ADCx: ָADCڴṹָ룬ȡֵΪADC0_SFR~ADC2_SFR
  *       NewState: У׼״̬ȡֵΧΪTRUE  FALSE
  *   ޡ
  */
void
ADC_Bosssel_Comparator_Calibration (ADC_SFRmap* ADCx, FunctionalState NewState)
{
    /* У */
    CHECK_RESTRICTION(CHECK_ADC_ALL_PERIPH(ADCx));
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

    /*---------------- ADC_CTL0ĴBOSSSELCOMPλ ----------------*/
    if (NewState != FALSE)
    {
        /* У׼Ƚ˵ѹ׼ȷ */
        SFR_SET_BIT_ASM(ADCx->CTL0, ADC_CTL0_BOSSSELCOMP_POS);
    }
    else
    {
        /* У׼ */
        SFR_CLR_BIT_ASM(ADCx->CTL0, ADC_CTL0_BOSSSELCOMP_POS);
    }
}

/**
  *   òοѹ֮һ˷ŵѹУ׼
  *   ADCx: ָADCڴṹָ룬ȡֵΪADC0_SFR~ADC2_SFR
  *       NewState: У׼״̬ȡֵΧΪTRUE  FALSE
  *   ޡ
  */
void
ADC_Bosssel_Calibration (ADC_SFRmap* ADCx, FunctionalState NewState)
{
    /* У */
    CHECK_RESTRICTION(CHECK_ADC_ALL_PERIPH(ADCx));
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

    /*---------------- ADC_CTL0ĴBOSSSELλ ----------------*/
    if (NewState != FALSE)
    {
        /* У׼˷ѹ׼ȷ */
        SFR_SET_BIT_ASM(ADCx->CTL0, ADC_CTL0_BOSSSEL_POS);
    }
    else
    {
        /* У׼ */
        SFR_CLR_BIT_ASM(ADCx->CTL0, ADC_CTL0_BOSSSEL_POS);
    }
}

/**
  *   ƫõУ׼
  *   ADCx: ָADCڴṹָ룬ȡֵΪADC0_SFR~ADC2_SFR
  *       NewState: У׼״̬ȡֵΧΪTRUE  FALSE
  *   ޡ
  */
void
ADC_Trim_Current_Intensity_Bias (ADC_SFRmap* ADCx, FunctionalState NewState)
{
    /* У */
    CHECK_RESTRICTION(CHECK_ADC_ALL_PERIPH(ADCx));
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

    /*---------------- ADC_CTL0ĴTRIMIBIASλ ----------------*/
    if (NewState != FALSE)
    {
        /* У׼ƫõ */
        SFR_SET_BIT_ASM(ADCx->CTL0, ADC_CTL0_TRIMIBIAS_POS);
    }
    else
    {
        /* У׼ */
        SFR_CLR_BIT_ASM(ADCx->CTL0, ADC_CTL0_TRIMIBIAS_POS);
    }
}

/**
  *   ADCģⲿʱӷƵѡ
  *   ADCx: ָADCڴṹָ룬ȡֵΪADC0_SFR~ADC2_SFR
  *       ClockSelect: ADCģⲿʱӷƵȣȡֵΧΪ:
  *                      ADC_CLK_DIV_1: T
  *                      ADC_CLK_DIV_2: 1/2T
  *                      ADC_CLK_DIV_4: 1/4T
  *                      ADC_CLK_DIV_8: 1/8T
  *                      ADC_CLK_DIV_16: 1/16T
  *                      ADC_CLK_DIV_32: 1/32T
  *   ޡ
  */
void
ADC_Analog_Clock_Config (ADC_SFRmap* ADCx, uint32_t ClockSelect)
{
    /* У */
    CHECK_RESTRICTION(CHECK_ADC_ALL_PERIPH(ADCx));
    CHECK_RESTRICTION(CHECK_ADC_CLK_DIV(ClockSelect));

    /*------------- ADCx_CTL0ĴADCCLKSλ -------------*/
    ADCx->CTL0 = SFR_Config (ADCx->CTL0,
                               ~ADC_CTL0_ADCCLKS,
                               ClockSelect);
}

/**
  *   A/Dתʽ
  *   ADCx: ָADCڴṹָ룬ȡֵΪADC0_SFR~ADC2_SFR
  *       DataAlign: ADCתʽȡֵΧΪ
  *                    ADC_DATAALIGN_LEFT: ת洢ʱ
  *                    ADC_DATAALIGN_RIGHT: ת洢ʱҶ
  *   ޡ
  */
void
ADC_Data_Align_Config (ADC_SFRmap* ADCx, uint32_t DataAlign)
{
    /* У */
    CHECK_RESTRICTION(CHECK_ADC_ALL_PERIPH(ADCx));
    CHECK_RESTRICTION(CHECK_ADC_DATA_ALIGN(DataAlign));

    /*------------- ADCx_CTL0ĴLRλ -------------*/
    ADCx->CTL0 = SFR_Config (ADCx->CTL0,
                               ~ADC_CTL0_LR,
                               DataAlign);
}

/**
  *   A/DʱԴ
  *   ADCx: ָADCڴṹָ룬ȡֵΪADC0_SFR~ADC2_SFR
  *       ClockSource: ADCʱԴȡֵΧΪ
  *                      ADC_SCLK: ѡSCLKΪA/Dģ鹤ʱ
  *                      ADC_HFCLK: ѡHFCLKΪA/Dģ鹤ʱ
  *                      ADC_LFCLK: ѡLFCLKΪA/Dģ鹤ʱ
  *   ޡ
  */
void
ADC_Clock_Source_Config (ADC_SFRmap* ADCx, uint32_t ClockSource)
{
    /* У */
    CHECK_RESTRICTION(CHECK_ADC_ALL_PERIPH(ADCx));
    CHECK_RESTRICTION(CHECK_ADC_CLK(ClockSource));

    /*------------- ADCx_CTL0ĴCLKSλ -------------*/
    ADCx->CTL0 = SFR_Config (ADCx->CTL0,
                               ~ADC_CTL0_CLKS,
                               ClockSource);
}

/**
  *   ֱӴ洢ģʽʹܡ
  *   ADCx: ָADCڴṹָ룬ȡֵΪADC0_SFR~ADC2_SFR
  *       NewState: ֱӴ洢ģʽʹ״̬ȡֵΧΪTRUE  FALSE
  *   ޡ
  */
void
ADC_Regular_Channel_DMA_Cmd (ADC_SFRmap* ADCx, FunctionalState NewState)
{
    /* У */
    CHECK_RESTRICTION(CHECK_ADC_ALL_PERIPH(ADCx));
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

    if (NewState != FALSE)
    {
        /* ʹDMAģʽ */
        SFR_SET_BIT_ASM(ADCx->CTL0, ADC_CTL0_NDMAEN_POS);
    }
    else
    {
        /* ʹDMAģʽ */
        SFR_CLR_BIT_ASM(ADCx->CTL0, ADC_CTL0_NDMAEN_POS);
    }
}

/**
  *   ֱӴ洢ģʽʹܡ
  *   ADCx: ָADCڴṹָ룬ȡֵΪADC0_SFR~ADC2_SFR
  *          HPChannel: ȼͨѡȡֵΪ
  *                        ADC_HPCH0: ȼͨ0
  *                        ADC_HPCH1: ȼͨ1
  *                        ADC_HPCH2: ȼͨ2
  *                        ADC_HPCH3: ȼͨ3
  *       NewState: ֱӴ洢ģʽʹ״̬ȡֵΧΪTRUE  FALSE
  *   ޡ
  */
void
ADC_High_Priority_Channel_DMA_Cmd (ADC_SFRmap* ADCx,
					uint32_t HPChannel,FunctionalState NewState)
{
    /* У */
    CHECK_RESTRICTION(CHECK_ADC_ALL_PERIPH(ADCx));
    CHECK_RESTRICTION(CHECK_ADC_HPCH(HPChannel));
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));


    if (NewState != FALSE)
    {
    	ADCx->CTL0 |= HPChannel;
    }
    else
    {
    	ADCx->CTL0 &= ~HPChannel;
    }
}
/**
  *   ˫ADCģʽѡ
  *   WorkMode: ˫ADCģʽȡֵΧΪ
  *                   ADC_SINGLE: ģʽ
  *                   ADC_REGULAR_HPRIORITY: ϳͨͬ+ȼͨͬģʽ
  *                   ADC_REGULAR_ALTERNATELY: ϳͨͬ+津ģʽ
  *                   ADC_HPRIORITY_FAST_ALTERNATELY: ϸȼͨͬ+ٽģʽ
  *                   ADC_HPRIORITY_SYNC: ȼͬģʽ
  *                   ADC_REGULAR_SYNC: ͨͬģʽ
  *                   ADC_FAST_ALTERNATELY_SYNC: ٽͬ
  *                   ADC_SLOW_ALTERNATELY_SYNC: ٽͬ
  *                   ADC_ALTERNATELY_TRIGGER: 津ģʽ
  *   ޡ
  */
void
ADC_Double_Mode_Config (uint32_t WorkMode)
{
    /* У */
    CHECK_RESTRICTION(CHECK_ADC_DOUBLE_MODE(WorkMode));

#ifdef KF32F_Periph_adc0
    /*------------- ADC0_CTL1ĴDOUMODλ -------------*/
    ADC0_CTL1 = SFR_Config (ADC0_CTL1,
                               ~ADC_CTL1_DOUMOD,
                               WorkMode);
#endif
}

/**
  *   ADCοѹѡ
  *   ADCx: ָADCڴṹָ룬ȡֵΪADC0_SFR~ADC2_SFR
  *       RefVoltage: ˫ADCģʽȡֵΧΪ
  *                     ADC_REF_INTERNAL: ڲοѹΪADתѹ
  *                     ADC_REF_VREF: Vref+ΪADתѹ
  *                     ADC_REF_AVDD: AVDDΪADתѹ
  *   ޡ
  */
void
ADC_Reference_Voltage_Config (ADC_SFRmap* ADCx, uint32_t RefVoltage)
{
    /* У */
    CHECK_RESTRICTION(CHECK_ADC_ALL_PERIPH(ADCx));
    CHECK_RESTRICTION(CHECK_ADC_REF(RefVoltage));

    /*------------- ADCx_CTL1ĴREFλ -------------*/
    ADCx->CTL1 = SFR_Config (ADCx->CTL1,
                               ~ADC_CTL1_REF,
                               RefVoltage);
}

/**
  *   ADCģ⿴Źͨѡ
  *   ADCx: ָADCڴṹָ룬ȡֵΪADC0_SFR~ADC2_SFR
  *       Channel: ADCģ⿴ŹͨȡֵΧΪADC_WDCH_0~ADC_WDCH_25
  *   ޡ
  */
void
ADC_Analog_Watchdog_Channel_Config (ADC_SFRmap* ADCx, uint32_t Channel)
{
    /* У */
    CHECK_RESTRICTION(CHECK_ADC_ALL_PERIPH(ADCx));
    CHECK_RESTRICTION(CHECK_ADC_WDCHANNEL(Channel));

    /*------------- ADCx_CTL1ĴWDCHλ -------------*/
    ADCx->SCANSQ3 = SFR_Config (ADCx->SCANSQ3,
                               ~ADC_SCANSQ3_WDCH,
                               Channel);
}
/**
  *   ##### ģתģ(ADC)ƹú #####
  */


/**
  *   ##### ģתģ(ADC)ͨú #####
  */
/**
  *   óͨϿŹʹܡ
  *   ADCx: ָADCڴṹָ룬ȡֵΪADC0_SFR~ADC2_SFR
  *       NewState: ͨϿŹʹ״̬ȡֵΧΪTRUE  FALSE
  *   ޡ
  */
void
ADC_Regular_Channel_Watchdog_Enable (ADC_SFRmap* ADCx, FunctionalState NewState)
{
    /* У */
    CHECK_RESTRICTION(CHECK_ADC_ALL_PERIPH(ADCx));
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

    /*---------------- ADC_CTL0ĴWDENλ ----------------*/
    if (NewState != FALSE)
    {
        /* ʹܳͨģ⿴Ź */
        SFR_SET_BIT_ASM(ADCx->CTL0, ADC_CTL0_WDEN_POS);
    }
    else
    {
        /* ֹͨģ⿴Ź */
        SFR_CLR_BIT_ASM(ADCx->CTL0, ADC_CTL0_WDEN_POS);
    }
}

/**
  *   óͨⲿתģʽʹܡ
  *   ADCx: ָADCڴṹָ룬ȡֵΪADC0_SFR~ADC2_SFR
  *       NewState: ͨⲿתģʽʹ״̬ȡֵΧΪTRUE  FALSE
  *   ޡ
  */
void
ADC_External_Trig_Conv_Enable (ADC_SFRmap* ADCx, FunctionalState NewState)
{
    /* У */
    CHECK_RESTRICTION(CHECK_ADC_ALL_PERIPH(ADCx));
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

    /*---------------- ADC_CTL1ĴEXTENλ ----------------*/
    if (NewState != FALSE)
    {
        /* ʹⲿ¼ת */
        SFR_SET_BIT_ASM(ADCx->CTL1, ADC_CTL1_EXTEN_POS);
    }
    else
    {
        /* ֹⲿ¼ת */
        SFR_CLR_BIT_ASM(ADCx->CTL1, ADC_CTL1_EXTEN_POS);
    }
}

/**
  *   óͨⲿ¼
  *   ADCx: ָADCڴṹָ룬ȡֵΪADC0_SFR~ADC2_SFR
  *       ExternalTrigEvent: ͨⲿ¼ѡȡֵΪ
  *                            ADC_EXTERNALTRIG_CCP1_CH1: CCP1 ͨ 1
  *                            ADC_EXTERNALTRIG_CCP1_CH2: CCP1 ͨ 2
  *                            ADC_EXTERNALTRIG_CCP1_CH3: CCP1 ͨ 3
  *                            ADC_EXTERNALTRIG_CCP1_CH4: CCP1 ͨ 4
  *                            ADC_EXTERNALTRIG_CCP2_CH1: CCP2 ͨ 1
  *                            ADC_EXTERNALTRIG_CCP2_CH2: CCP2 ͨ 2
  *                            ADC_EXTERNALTRIG_CCP2_CH3: CCP2 ͨ 3
  *                            ADC_EXTERNALTRIG_CCP2_CH4: CCP2 ͨ 4
  *                            ADC_EXTERNALTRIG_CCP3_CH1: CCP3 ͨ 1
  *                            ADC_EXTERNALTRIG_CCP3_CH2: CCP3 ͨ 2
  *                            ADC_EXTERNALTRIG_CCP3_CH3: CCP3 ͨ 3
  *                            ADC_EXTERNALTRIG_CCP3_CH4: CCP3 ͨ 4
  *                            ADC_EXTERNALTRIG_CCP4_CH1: CCP4 ͨ 1
  *                            ADC_EXTERNALTRIG_CCP4_CH2: CCP4 ͨ 2
  *                            ADC_EXTERNALTRIG_CCP4_CH3: CCP4 ͨ 3
  *                            ADC_EXTERNALTRIG_CCP4_CH4: CCP4 ͨ 4
  *                            ADC_EXTERNALTRIG_CCP18_CH1: CCP18 ͨ 1
  *                            ADC_EXTERNALTRIG_CCP18_CH2: CCP18 ͨ 2
  *                            ADC_EXTERNALTRIG_CCP18_CH3: CCP18 ͨ 3
  *                            ADC_EXTERNALTRIG_CCP18_CH4: CCP18 ͨ 4
  *                            ADC_EXTERNALTRIG_CCP19_CH1: CCP19 ͨ 1
  *                            ADC_EXTERNALTRIG_CCP19_CH2: CCP19 ͨ 2
  *                            ADC_EXTERNALTRIG_CCP19_CH3: CCP19 ͨ 3
  *                            ADC_EXTERNALTRIG_CCP19_CH4: CCP19 ͨ 4
  *                            ADC_EXTERNALTRIG_CCP20_CH1: CCP20 ͨ 1
  *                            ADC_EXTERNALTRIG_CCP20_CH2: CCP20 ͨ 2
  *                            ADC_EXTERNALTRIG_CCP20_CH3: CCP20 ͨ 3
  *                            ADC_EXTERNALTRIG_CCP20_CH4: CCP20 ͨ 4
  *                            ADC_EXTERNALTRIG_CCP21_CH1: CCP21 ͨ 1
  *                            ADC_EXTERNALTRIG_CCP21_CH2: CCP21 ͨ 2
  *                            ADC_EXTERNALTRIG_CCP21_CH3: CCP21 ͨ 3
  *                            ADC_EXTERNALTRIG_CCP21_CH4: CCP21 ͨ 4
  *                            ADC_EXTERNALTRIG_CCP5_CH1: CCP5 ͨ 1
  *                            ADC_EXTERNALTRIG_CCP5_CH2: CCP5 ͨ 2
  *                            ADC_EXTERNALTRIG_CCP5_CH3: CCP5 ͨ 3
  *                            ADC_EXTERNALTRIG_CCP5_CH4: CCP5 ͨ 4
  *                            ADC_EXTERNALTRIG_CCP22_CH1: CCP22 ͨ 1
  *                            ADC_EXTERNALTRIG_CCP22_CH2: CCP22 ͨ 2
  *                            ADC_EXTERNALTRIG_CCP22_CH3: CCP22 ͨ 3
  *                            ADC_EXTERNALTRIG_CCP22_CH4: CCP22 ͨ 4
  *                            ADC_EXTERNALTRIG_T1TRGO: T1TRGO
  *                            ADC_EXTERNALTRIG_T2TRGO: T2TRGO
  *                            ADC_EXTERNALTRIG_T3TRGO: T3TRGO
  *                            ADC_EXTERNALTRIG_T4TRGO: T4TRGO
  *                            ADC_EXTERNALTRIG_T18TRGO: T18TRGO
  *                            ADC_EXTERNALTRIG_T19TRGO: T19TRGO
  *                            ADC_EXTERNALTRIG_T20TRGO: T20TRGO
  *                            ADC_EXTERNALTRIG_T21TRGO: T21TRGO
  *                            ADC_EXTERNALTRIG_T5TRGO: T5TRGO
  *                            ADC_EXTERNALTRIG_T9TRGO: T9TRGO
  *                            ADC_EXTERNALTRIG_T14TRGO: T14TRGO
  *                            ADC_EXTERNALTRIG_T15TRGO: T15TRGO
  *                            ADC_EXTERNALTRIG_T5_OVERFLOW
  *                            ADC_EXTERNALTRIG_T6_OVERFLOW
  *                            ADC_EXTERNALTRIG_T9_OVERFLOW
  *                            ADC_EXTERNALTRIG_T10_OVERFLOW
  *                            ADC_EXTERNALTRIG_CCP9_CH1
  *                            ADC_EXTERNALTRIG_CCP9_CH2
  *                            ADC_EXTERNALTRIG_CCP9_CH3
  *                            ADC_EXTERNALTRIG_CCP9_CH4
  *                            ADC_EXTERNALTRIG_EINT7: EINT7
  *                            ADC_EXTERNALTRIG_EINT15: EINT15
  *                            ADC_EXTERNALTRIG_CCP0_CH1
  *                            ADC_EXTERNALTRIG_CCP0_CH2
  *                            ADC_EXTERNALTRIG_CCP0_CH3
  *                            ADC_EXTERNALTRIG_CCP0_CH4
  *                            ADC_EXTERNALTRIG_CCP23_CH1
  *                            ADC_EXTERNALTRIG_CCP23_CH2
  *                            ADC_EXTERNALTRIG_CCP23_CH3
  *                            ADC_EXTERNALTRIG_CCP23_CH4
  *   ޡ
  */
void
ADC_External_Trig_Conv_Config (ADC_SFRmap* ADCx,
                    uint32_t ExternalTrigEvent)
{
    /* У */
    CHECK_RESTRICTION(CHECK_ADC_ALL_PERIPH(ADCx));
    CHECK_RESTRICTION(CHECK_ADC_EXT_TRIG(ExternalTrigEvent));

    /*------------- ADCx_CTL1ĴNCHλ -------------*/
    ADCx->CTL1 = SFR_Config (ADCx->CTL1,
                               ~ADC_CTL1_NCH,
                               ExternalTrigEvent);
}

/**
  *   óͨɨС
  *   ADCx: ָADCڴṹָ룬ȡֵΪADC0_SFR~ADC2_SFR
  *       Channel: ADCͨѡȡֵΧΪ:
  *                  ADC_CHANNEL_0: ͨ0---- ADC_CHANNEL_63: ͨ63
  *       Rank: ͨɨADתλãȡֵΪ1~16
  *   ޡ
  */
void
ADC_Regular_Channel_Config (ADC_SFRmap* ADCx, uint32_t Channel, uint32_t Rank)
{
    uint32_t tmpreg = 0;
    uint32_t tmpmask = 0;

    /* У */
    CHECK_RESTRICTION(CHECK_ADC_ALL_PERIPH(ADCx));
    CHECK_RESTRICTION(CHECK_ADC_CHANNEL(Channel));
    CHECK_RESTRICTION(CHECK_ADC_REGULAR_RANK(Rank));

    /* õ1ת~5ת */
    if (Rank < 6)
    {
        /*------------- ADCx_SCANSQ0ĴSSQxλ -------------*/
        tmpreg = (uint32_t)Channel << (6 * (Rank - 1));
        tmpmask = ADC_SCANSQ0_SSQ0 << (6 * (Rank - 1));
        ADCx->SCANSQ0 = SFR_Config (ADCx->SCANSQ0,
                              ~tmpmask,
                              tmpreg);
    }
    /* õ6ת~10ת */
    else if (Rank < 11)
    {
        /*------------- ADCx_SCANSQ1ĴSSQxλ -------------*/
        tmpreg = (uint32_t)Channel << (6 * (Rank - 6));
        tmpmask = ADC_SCANSQ1_SSQ5 << (6 * (Rank - 6));
        ADCx->SCANSQ1 = SFR_Config (ADCx->SCANSQ1,
                              ~tmpmask,
                              tmpreg);
    }
    /* õ11ת~15ת */
    else if (Rank < 16)
    {
        /*------------- ADCx_SCANSQ2ĴSSQxλ -------------*/
        tmpreg = (uint32_t)Channel << (6 * (Rank - 11));
        tmpmask = ADC_SCANSQ2_SSQ10 << (6 * (Rank - 11));
        ADCx->SCANSQ2 = SFR_Config (ADCx->SCANSQ2,
                              ~tmpmask,
                              tmpreg);
    }
    /* õ16ת */
    else
    {
        /*------------- ADCx_SCANSQ3ĴSSQxλ -------------*/
        tmpreg = (uint32_t)Channel << (6 * (Rank - 16));
        tmpmask = ADC_SCANSQ3_SSQ15 << (6 * (Rank - 16));
        ADCx->SCANSQ3 = SFR_Config (ADCx->SCANSQ3,
                              ~tmpmask,
                              tmpreg);
    }
}

/**
  *   óͨɨ賤ȡ
  *   ADCx: ָADCڴṹָ룬ȡֵΪADC0_SFR~ADC2_SFR
  *       Length: ͨɨ賤ȣȡֵΪ1~16
  *   ޡ
  */
void
ADC_Regular_Sequencer_Length_Config (ADC_SFRmap* ADCx, uint32_t Length)
{
    uint32_t tmpreg = 0;

    /* У */
    CHECK_RESTRICTION(CHECK_ADC_ALL_PERIPH(ADCx));
    CHECK_RESTRICTION(CHECK_ADC_REGULAR_LENGTH(Length));

    /*---------------- ADC_SCANSQ3Ĵ ----------------*/
    /* ݽṹԱm_NumOfConvSLENλ */
    tmpreg = (Length - 1) << ADC_SCANSQ3_SLEN_0_POS;
    ADCx->SCANSQ3 = SFR_Config (ADCx->SCANSQ3,
                          ~ADC_SCANSQ3_SLEN,
                          tmpreg);
}

/**
  *   óȼͨ Tx_CCRy ʹܡ
  *   ADCx: ָADCڴṹָ룬ȡֵΪADC0_SFR~ADC2_SFR
  *       HPExternalTrigEvent: ȼͨⲿ¼ѡȡֵΪ
  *                              ADC_EXTERNALTRIG_T10_CCR0: ȼͨ T10_CCR0 ʹ
  *                              ADC_EXTERNALTRIG_T9_CCR1:  ȼͨ T9_CCR1 ʹ
  *                              ADC_EXTERNALTRIG_T9_CCR0:  ȼͨ T9_CCR0 ʹ
  *                              ADC_EXTERNALTRIG_T6_CCR0:  ȼͨ T6_CCR0 ʹ
  *                              ADC_EXTERNALTRIG_T5_CCR1:  ȼͨ T5_CCR1 ʹ
  *                              ADC_EXTERNALTRIG_T5_CCR0:  ȼͨ T5_CCR0 ʹ
  *       NewState: ADCжʹ״̬ȡֵΧΪTRUE  FALSE
  *   ޡ
  */
void
ADC_Regular_Channel_TxCCRy_Trig_Enable (ADC_SFRmap* ADCx,
							 uint32_t ExternalTrigEvent, FunctionalState NewState)
{
    uint32_t tmpreg = 0;
    /* У */
    CHECK_RESTRICTION(CHECK_ADC_ALL_PERIPH(ADCx));
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));
    CHECK_RESTRICTION(CHECK_RegularChannel_TxCCRy_Trig(ExternalTrigEvent));

    /* ȡ */
    tmpreg = ExternalTrigEvent;
    tmpreg = (uint32_t)0x01 << tmpreg;

    if (NewState != FALSE)
    {
        /* ʹܴ */
        ADCx->STATE |= tmpreg;
    }
    else
    {
        /* ֹ */
        ADCx->STATE &= (~tmpreg);
    }
}

/**
  *   A/Dͨת
  *   ADCx: ָADCڴṹָ룬ȡֵΪADC0_SFR~ADC2_SFR
  *   ޡ
  */
void
ADC_Software_Start_Conv(ADC_SFRmap* ADCx)
{
    /* У */
    CHECK_RESTRICTION(CHECK_ADC_ALL_PERIPH(ADCx));

    /*---------------- ADC_CTL1ĴSTARTλ ----------------*/
    SFR_SET_BIT_ASM(ADCx->CTL1, ADC_CTL1_START_POS);
}

/**
  *   תʹܡ
  *   ADCx: ָADCڴṹָ룬ȡֵΪADC0_SFR~ADC2_SFR
  *       NewState: תʹ״̬ȡֵΧΪTRUE  FALSE
  *   ޡ
  */
void
ADC_Continuous_Mode_Cmd (ADC_SFRmap* ADCx, FunctionalState NewState)
{
    /* У */
    CHECK_RESTRICTION(CHECK_ADC_ALL_PERIPH(ADCx));
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

    if (NewState != FALSE)
    {
        /* תģʽ */
        SFR_SET_BIT_ASM(ADCx->CTL0, ADC_CTL0_CONT_POS);
    }
    else
    {
        /* תģʽ */
        SFR_CLR_BIT_ASM(ADCx->CTL0, ADC_CTL0_CONT_POS);
    }
}

/**
  *   üģʽͨ
  *   ADCx: ָADCڴṹָ룬ȡֵΪADC0_SFR~ADC2_SFR
  *       Number: ģʽͨȡֵΧΪ1~8
  *   ޡ
  */
void
ADC_Disc_Mode_Channel_Count_Config (ADC_SFRmap* ADCx, uint8_t Number)
{
    uint32_t tmpreg = 0;

    /* У */
    CHECK_RESTRICTION(CHECK_ADC_ALL_PERIPH(ADCx));
    CHECK_RESTRICTION(CHECK_ADC_REGULAR_DISC_NUMBER(Number));

    /*---------------- ADC_CTL0ĴDSNUMλ ----------------*/
    tmpreg = (uint32_t)(Number - 1) << ADC_CTL0_DSNUM0_POS;
    ADCx->CTL0 = SFR_Config (ADCx->CTL0,
                               ~ADC_CTL0_DSNUM,
                               tmpreg);
}

/**
  *   óͨϵļģʽʹܡ
  *   ADCx: ָADCڴṹָ룬ȡֵΪADC0_SFR~ADC2_SFR
  *       NewState: ͨϵļģʽʹ״̬ȡֵΧΪTRUE  FALSE
  *   ޡ
  */
void
ADC_Disc_Mode_Cmd (ADC_SFRmap* ADCx, FunctionalState NewState)
{
    /* У */
    CHECK_RESTRICTION(CHECK_ADC_ALL_PERIPH(ADCx));
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

    if (NewState != FALSE)
    {
        /* ʹܳͨϵļģʽ */
        SFR_SET_BIT_ASM(ADCx->CTL0, ADC_CTL0_DSEN_POS);
    }
    else
    {
        /* ֹͨϵļģʽ */
        SFR_CLR_BIT_ASM(ADCx->CTL0, ADC_CTL0_DSEN_POS);
    }
}

/**
  *   ȡͨתݡ
  *   ADCx: ָADCڴṹָ룬ȡֵΪADC0_SFR~ADC2_SFR
  *   ͨתݣ16λЧݡ
  */
uint16_t
ADC_Get_Conversion_Value (ADC_SFRmap* ADCx)
{
    uint32_t tmpreg = 0;

    /* У */
    CHECK_RESTRICTION(CHECK_ADC_ALL_PERIPH(ADCx));

    /*---------------- ADC_DATAĴDATAλ ----------------*/
    tmpreg = ADCx->DATA;

    return (uint16_t) tmpreg;
}
/**
  *   ##### ģתģ(ADC)ͨú #####
  */


/**
  *   ##### ģתģ(ADC)ȼͨú #####
  */
/**
  *   øȼͨϿŹʹܡ
  *   ADCx: ָADCڴṹָ룬ȡֵΪADC0_SFR~ADC2_SFR
  *       NewState: ȼͨϿŹʹ״̬ȡֵΧΪTRUE  FALSE
  *   ޡ
  */
void
ADC_High_Priority_Watchdog_Enable (ADC_SFRmap* ADCx, FunctionalState NewState)
{
    /* У */
    CHECK_RESTRICTION(CHECK_ADC_ALL_PERIPH(ADCx));
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

    /*---------------- ADC_CTL0ĴHPWDENλ ----------------*/
    if (NewState != FALSE)
    {
        /* ʹܸȼͨģ⿴Ź */
        SFR_SET_BIT_ASM(ADCx->CTL0, ADC_CTL0_HPWDEN_POS);
    }
    else
    {
        /* ֹȼͨģ⿴Ź */
        SFR_CLR_BIT_ASM(ADCx->CTL0, ADC_CTL0_HPWDEN_POS);
    }
}

/**
  *   øȼͨⲿתģʽʹܡ
  *   ADCx: ָADCڴṹָ룬ȡֵΪADC0_SFR~ADC2_SFR
  *       NewState: ȼͨⲿתģʽʹ״̬ȡֵΧΪTRUE  FALSE
  *   ޡ
  */
void
ADC_HPExternal_Trig_Conv_Enable (ADC_SFRmap* ADCx, FunctionalState NewState)
{
    /* У */
    CHECK_RESTRICTION(CHECK_ADC_ALL_PERIPH(ADCx));
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

    /*---------------- ADC_CTL1ĴHPEXTENλ ----------------*/
    if (NewState != FALSE)
    {
        /* ʹⲿ¼ת */
        SFR_SET_BIT_ASM(ADCx->CTL1, ADC_CTL1_HPEXTEN_POS);
    }
    else
    {
        /* ֹⲿ¼ת */
        SFR_CLR_BIT_ASM(ADCx->CTL1, ADC_CTL1_HPEXTEN_POS);
    }
}

/**
  *   øȼͨɨС
  *   ADCx: ָADCڴṹָ룬ȡֵΪADC0_SFR~ADC2_SFR
  *       Channel: ADCͨѡȡֵΧΪ:
  *                  ADC_CHANNEL_0: ͨ0--- ADC_CHANNEL_63: ͨ63
  *       Rank: ȼͨɨADתλãȡֵΪ1~4
  *   ޡ
  */
void
ADC_High_Priority_Channel_Config (ADC_SFRmap* ADCx,
                    uint32_t Channel, uint32_t Rank)
{
    uint32_t tmpreg = 0;
    uint32_t tmpmask = 0;

    /* У */
    CHECK_RESTRICTION(CHECK_ADC_ALL_PERIPH(ADCx));
    CHECK_RESTRICTION(CHECK_ADC_HP_CHANNEL(Channel));
    CHECK_RESTRICTION(CHECK_ADC_HP_RANK(Rank));

    /* õ1ת~4ת */

    /*------------- ADCx_HSCANSQĴHSSQxλ -------------*/
    tmpreg = (uint32_t)Channel << (6 * (Rank - 1));
    tmpmask = ADC_HSCANSQ_SSQ1 << (6 * (Rank - 1));
    ADCx->HSCANSQ = SFR_Config (ADCx->HSCANSQ,
                          ~tmpmask,
                          tmpreg);
}

/**
  *   øȼͨɨ賤ȡ
  *   ADCx: ָADCڴṹָ룬ȡֵΪADC0_SFR~ADC2_SFR
  *       Length: ȼͨɨ賤ȣȡֵΧΪ1~4
  *   ޡ
  */
void
ADC_High_Priority_Sequencer_Length_Config (ADC_SFRmap* ADCx, uint32_t Length)
{
    uint32_t tmpreg = 0;

    /* У */
    CHECK_RESTRICTION(CHECK_ADC_ALL_PERIPH(ADCx));
    CHECK_RESTRICTION(CHECK_ADC_HIGH_PRIORITY_LENGTH(Length));

    /*------------- ADCx_HSCANSQĴHSLENλ -------------*/
    tmpreg = (Length - 1) << ADC_HSCANSQ_HSLEN_0_POS;
    ADCx->HSCANSQ = SFR_Config (ADCx->HSCANSQ,
                               ~ADC_HSCANSQ_HSLEN,
                               tmpreg);
}

/**
  *   øȼͨתƫơ
  *   ADCx: ָADCڴṹָ룬ȡֵΪADC0_SFR~ADC2_SFR
  *       HPDoffChannel: ȼͨѡȡֵΪ
  *                        ADC_HPDOFF_0: ȼͨ0
  *                        ADC_HPDOFF_1: ȼͨ1
  *                        ADC_HPDOFF_2: ȼͨ2
  *                        ADC_HPDOFF_3: ȼͨ3
  *       Offset: תƫƣȡֵΪ12λЧݡ
  *   ޡ
  */
void
ADC_Set_HPChannel_Conv_Value_Offset (ADC_SFRmap* ADCx,
                    uint32_t HPDoffChannel, uint32_t Offset)
{
    uint32_t tmpreg = 0;

    /* У */
    CHECK_RESTRICTION(CHECK_ADC_ALL_PERIPH(ADCx));
    CHECK_RESTRICTION(CHECK_ADC_HPDOFF_OFFSET(HPDoffChannel));
    CHECK_RESTRICTION(CHECK_ADC_OFFSET(Offset));

    /*------------- ADCx_HPDOFFyĴHPDOFFλ -------------*/
    /* ȡADCx_HPDOFFyַ */
    tmpreg = (uint32_t)ADCx;
    tmpreg += HPDoffChannel;

    /* ADCx_HPDOFFy */
    *(volatile uint32_t *) tmpreg = Offset;
}

/**
  *   øȼͨⲿ¼
  *   ADCx: ָADCڴṹָ룬ȡֵΪADC0_SFR~ADC2_SFR
  *       HPExternalTrigEvent: ȼͨⲿ¼ѡȡֵΪ
  *                              ADC_HPEXTERNALTRIG_CCP1_CH1: CCP1 ͨ 1
  *                              ADC_HPEXTERNALTRIG_CCP1_CH2: CCP1 ͨ 2
  *                              ADC_HPEXTERNALTRIG_CCP1_CH3: CCP1 ͨ 3
  *                              ADC_HPEXTERNALTRIG_CCP1_CH4: CCP1 ͨ 4
  *                              ADC_HPEXTERNALTRIG_CCP2_CH1: CCP2 ͨ 1
  *                              ADC_HPEXTERNALTRIG_CCP2_CH2: CCP2 ͨ 2
  *                              ADC_HPEXTERNALTRIG_CCP2_CH3: CCP2 ͨ 3
  *                              ADC_HPEXTERNALTRIG_CCP2_CH4: CCP2 ͨ 4
  *                              ADC_HPEXTERNALTRIG_CCP3_CH1: CCP3 ͨ 1
  *                              ADC_HPEXTERNALTRIG_CCP3_CH2: CCP3 ͨ 2
  *                              ADC_HPEXTERNALTRIG_CCP3_CH3: CCP3 ͨ 3
  *                              ADC_HPEXTERNALTRIG_CCP3_CH4: CCP3 ͨ 4
  *                              ADC_HPEXTERNALTRIG_CCP4_CH1: CCP4 ͨ 1
  *                              ADC_HPEXTERNALTRIG_CCP4_CH2: CCP4 ͨ 2
  *                              ADC_HPEXTERNALTRIG_CCP4_CH3: CCP4 ͨ 3
  *                              ADC_HPEXTERNALTRIG_CCP4_CH4: CCP4 ͨ 4
  *                              ADC_HPEXTERNALTRIG_CCP18_CH1: CCP18 ͨ 1
  *                              ADC_HPEXTERNALTRIG_CCP18_CH2: CCP18 ͨ 2
  *                              ADC_HPEXTERNALTRIG_CCP18_CH3: CCP18 ͨ 3
  *                              ADC_HPEXTERNALTRIG_CCP18_CH4: CCP18 ͨ 4
  *                              ADC_HPEXTERNALTRIG_CCP19_CH1: CCP19 ͨ 1
  *                              ADC_HPEXTERNALTRIG_CCP19_CH2: CCP19 ͨ 2
  *                              ADC_HPEXTERNALTRIG_CCP19_CH3: CCP19 ͨ 3
  *                              ADC_HPEXTERNALTRIG_CCP19_CH4: CCP19 ͨ 4
  *                              ADC_HPEXTERNALTRIG_CCP20_CH1: CCP20 ͨ 1
  *                              ADC_HPEXTERNALTRIG_CCP20_CH2: CCP20 ͨ 2
  *                              ADC_HPEXTERNALTRIG_CCP20_CH3: CCP20 ͨ 3
  *                              ADC_HPEXTERNALTRIG_CCP20_CH4: CCP20 ͨ 4
  *                              ADC_HPEXTERNALTRIG_CCP21_CH1: CCP21 ͨ 1
  *                              ADC_HPEXTERNALTRIG_CCP21_CH2: CCP21 ͨ 2
  *                              ADC_HPEXTERNALTRIG_CCP21_CH3: CCP21 ͨ 3
  *                              ADC_HPEXTERNALTRIG_CCP21_CH4: CCP21 ͨ 4
  *                              ADC_HPEXTERNALTRIG_CCP5_CH1: CCP5 ͨ 1
  *                              ADC_HPEXTERNALTRIG_CCP5_CH2: CCP5 ͨ 2
  *                              ADC_HPEXTERNALTRIG_CCP5_CH3: CCP5 ͨ 3
  *                              ADC_HPEXTERNALTRIG_CCP5_CH4: CCP5 ͨ 4
  *                              ADC_HPEXTERNALTRIG_CCP22_CH1: CCP22 ͨ 1
  *                              ADC_HPEXTERNALTRIG_CCP22_CH2: CCP22 ͨ 2
  *                              ADC_HPEXTERNALTRIG_CCP22_CH3: CCP22 ͨ 3
  *                              ADC_HPEXTERNALTRIG_CCP22_CH4: CCP22 ͨ 4
  *                              ADC_HPEXTERNALTRIG_T1TRGO: T1TRGO
  *                              ADC_HPEXTERNALTRIG_T2TRGO: T2TRGO
  *                              ADC_HPEXTERNALTRIG_T3TRGO: T3TRGO
  *                              ADC_HPEXTERNALTRIG_T4TRGO: T4TRGO
  *                              ADC_HPEXTERNALTRIG_T18TRGO: T18TRGO
  *                              ADC_HPEXTERNALTRIG_T19TRGO: T19TRGO
  *                              ADC_HPEXTERNALTRIG_T20TRGO: T20TRGO
  *                              ADC_HPEXTERNALTRIG_T21TRGO: T21TRGO
  *                              ADC_HPEXTERNALTRIG_T5TRGO: T5TRGO
  *                              ADC_HPEXTERNALTRIG_T9TRGO: T9TRGO
  *                              ADC_HPEXTERNALTRIG_T14TRGO: T14TRGO
  *                              ADC_HPEXTERNALTRIG_T15TRGO: T15TRGO
  *                              ADC_HPEXTERNALTRIG_T5_OVERFLOW: T5
  *                              ADC_HPEXTERNALTRIG_T6_OVERFLOW: T6
  *                              ADC_HPEXTERNALTRIG_T9_OVERFLOW: T9
  *                              ADC_HPEXTERNALTRIG_T10_OVERFLOW: T10
  *                              ADC_HPEXTERNALTRIG_CCP9_CH1: CCP9ͨ1
  *                              ADC_HPEXTERNALTRIG_CCP9_CH2: CCP9ͨ2
  *                              ADC_HPEXTERNALTRIG_CCP9_CH3: CCP9ͨ3
  *                              ADC_HPEXTERNALTRIG_CCP9_CH4: CCP9ͨ4
  *                              ADC_HPEXTERNALTRIG_EINT7: EINT7
  *                              ADC_HPEXTERNALTRIG_EINT15: EINT15
  *                              ADC_HPEXTERNALTRIG_CCP0_CH1_CMP: CCP0_CH1
  *                              ADC_HPEXTERNALTRIG_CCP0_CH2_CMP: CCP0_CH2
  *                              ADC_HPEXTERNALTRIG_CCP0_CH3: CCP0_CH3
  *                              ADC_HPEXTERNALTRIG_CCP0_CH4: CCP0_CH4
  *                              ADC_HPEXTERNALTRIG_CCP23_CH1: CCP23ͨ1
  *                              ADC_HPEXTERNALTRIG_CCP23_CH2: CCP23ͨ2
  *                              ADC_HPEXTERNALTRIG_CCP23_CH3: CCP23ͨ3
  *                              ADC_HPEXTERNALTRIG_CCP23_CH4: CCP23ͨ4
  *   ޡ
  */
void
ADC_HPExternal_Trig_Conv_Config (ADC_SFRmap* ADCx,
                    uint32_t HPExternalTrigEvent)
{
    /* У */
    CHECK_RESTRICTION(CHECK_ADC_ALL_PERIPH(ADCx));
    CHECK_RESTRICTION(CHECK_ADC_HPEXT_TRIG(HPExternalTrigEvent));

    /*------------- ADCx_CTL1ĴHCHλ -------------*/
    ADCx->CTL1 = SFR_Config (ADCx->CTL1,
                               ~ADC_CTL1_HCH,
                               HPExternalTrigEvent);
}

/**
  *   A/Dȼͨת
  *   ADCx: ָADCڴṹָ룬ȡֵΪADC0_SFR~ADC2_SFR
  *   ޡ
  */
void
ADC_Software_HPStart_Conv (ADC_SFRmap* ADCx)
{
    /* У */
    CHECK_RESTRICTION(CHECK_ADC_ALL_PERIPH(ADCx));

    /*---------------- ADC_CTL1ĴHPSTARTλ ----------------*/
    SFR_SET_BIT_ASM(ADCx->CTL1, ADC_CTL1_HPSTART_POS);
}

/**
  *   Զȼͨתʹܡ
  *   ADCx: ָADCڴṹָ룬ȡֵΪADC0_SFR~ADC2_SFR
  *       NewState: Զȼͨתʹ״̬ȡֵΧΪTRUE  FALSE
  *   ޡ
  */
void
ADC_HPAuto_Conv_Cmd (ADC_SFRmap* ADCx, FunctionalState NewState)
{
    /* У */
    CHECK_RESTRICTION(CHECK_ADC_ALL_PERIPH(ADCx));
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

    if (NewState != FALSE)
    {
        /* ʹԶĸȼͨת */
        SFR_SET_BIT_ASM(ADCx->CTL0, ADC_CTL0_HPAUTO_POS);
    }
    else
    {
        /* ֹԶĸȼͨת */
        SFR_CLR_BIT_ASM(ADCx->CTL0, ADC_CTL0_HPAUTO_POS);
    }
}

/**
  *   øȼͨϵļģʽʹܡ
  *   ADCx: ָADCڴṹָ룬ȡֵΪADC0_SFR~ADC2_SFR
  *       NewState: ȼͨϵļģʽʹ״̬ȡֵΧΪTRUE  FALSE
  *   ޡ
  */
void
ADC_HPDisc_Mode_Cmd (ADC_SFRmap* ADCx, FunctionalState NewState)
{
    /* У */
    CHECK_RESTRICTION(CHECK_ADC_ALL_PERIPH(ADCx));
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

    if (NewState != FALSE)
    {
        /* ʹܸȼͨϵļģʽ */
        SFR_SET_BIT_ASM(ADCx->CTL0, ADC_CTL0_HPDSEN_POS);
    }
    else
    {
        /* ֹȼͨϵļģʽ */
        SFR_CLR_BIT_ASM(ADCx->CTL0, ADC_CTL0_HPDSEN_POS);
    }
}

/**
  *   ȡȼͨתݡ
  *   ADCx: ָADCڴṹָ룬ȡֵΪADC0_SFR~ADC2_SFR
  *       HPDataChannel: ȼͨѡȡֵΪ
  *                        ADC_HPDATA_0: ȼͨ0
  *                        ADC_HPDATA_1: ȼͨ1
  *                        ADC_HPDATA_2: ȼͨ2
  *                        ADC_HPDATA_3: ȼͨ3
  *   ȼͨתݣ16λЧݡ
  */
uint16_t
ADC_Get_HPConversion_Data (ADC_SFRmap* ADCx, uint8_t HPDataChannel)
{
    uint32_t tmpreg = 0;

    /* У */
    CHECK_RESTRICTION(CHECK_ADC_ALL_PERIPH(ADCx));
    CHECK_RESTRICTION(CHECK_ADC_HPDATA_OFFSET(HPDataChannel));

    /*------------- ȡADCx_HPDATAyĴHPDATAλ -------------*/
    /* ȡADCx_HPDATAyַ */
    tmpreg = (uint32_t)ADCx;
    tmpreg += HPDataChannel;

    /* ȡADCx_HPDATAyֵ */
    tmpreg = *(volatile uint32_t *)  tmpreg;
    return (uint16_t) tmpreg;
}
/**
  *   ##### ģתģ(ADC)ȼͨú #####
  */


/**
  *   ##### ģתģ(ADC)жϹ #####
  */
/**
  *   ADCжʹܡ
  *   ADCx: ָADCڴṹָ룬ȡֵΪADC0_SFR~ADC2_SFR
  *       InterruptType: ADCжͣȡֵΪ
  *                        ADC_INT_EOC: ADCһתж
  *                        ADC_INT_AWD: ADCģ⿴Źж
  *                        ADC_INT_HPEND: ADCȼͨתж
  *                        ADC_INT_END: ADCͨתж
  *       NewState: ADCжʹ״̬ȡֵΧΪTRUE  FALSE
  *   ޡ
  */
void
ADC_Set_INT_Enable (ADC_SFRmap* ADCx,
                    uint32_t InterruptType, FunctionalState NewState)
{
    uint32_t tmpreg = 0;

    /* У */
    CHECK_RESTRICTION(CHECK_ADC_ALL_PERIPH(ADCx));
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));
    CHECK_RESTRICTION(CHECK_ADC_INT(InterruptType));

    /* ȡж */
    tmpreg = (InterruptType & 0x0F);
    tmpreg = (uint32_t)0x01 << tmpreg;

    if (NewState != FALSE)
    {
        /* ʹж */
        ADCx->STATE |= tmpreg;
    }
    else
    {
        /* ֹж */
        ADCx->STATE &= (~tmpreg);
    }
}

/**
  *   ȡADCжϱ־
  *   ADCx: ָADCڴṹָ룬ȡֵΪADC0_SFR~ADC2_SFR
  *       InterruptType: ADCжͣȡֵΪ
  *                        ADC_INT_EOC: ADCһתж
  *                        ADC_INT_AWD: ADCģ⿴Źж
  *                        ADC_INT_HPEND: ADCȼͨתж
  *                        ADC_INT_END: ADCͨתж
  *   жϱ־1жϣ0δжϡ
  */
FlagStatus
ADC_Get_INT_Flag (ADC_SFRmap* ADCx, uint32_t InterruptType)
{
    uint32_t tmpreg = 0;

    /* У */
    CHECK_RESTRICTION(CHECK_ADC_ALL_PERIPH(ADCx));
    CHECK_RESTRICTION(CHECK_ADC_INT(InterruptType));

    /*------------- ȡADCx_STATEĴӦжϱ־λ -------------*/
    tmpreg = ((InterruptType >> 8)&0x0F);
    tmpreg = (uint32_t)0x01 << tmpreg;
    if ((ADCx->STATE & tmpreg) != RESET)
    {
        /* ADCж */
        return SET;
    }
    else
    {
        /* ADCδж */
        return RESET;
    }
}

/**
  *   ADCжϱ־
  *   ADCx: ָADCڴṹָ룬ȡֵΪADC0_SFR~ADC2_SFR
  *       InterruptType: ADCжͣȡֵΪ
  *                        ADC_INT_EOC: ADCһתж
  *                        ADC_INT_AWD: ADCģ⿴Źж
  *                        ADC_INT_HPEND: ADCȼͨתж
  *                        ADC_INT_END: ADCͨתж
  *   ޡ
  */
void
ADC_Clear_INT_Flag (ADC_SFRmap* ADCx, uint32_t InterruptType)
{
    uint32_t tmpreg = 0;
    uint32_t tmpreg1 = 0;
    uint32_t tmpreg2 = 0;
    /* У */
    CHECK_RESTRICTION(CHECK_ADC_ALL_PERIPH(ADCx));
    CHECK_RESTRICTION(CHECK_ADC_INT(InterruptType));

    /*------------- ADCx_STATEĴӦжϱ־λ -------------*/
    tmpreg = InterruptType >> 16;
    tmpreg = (uint32_t)0x01 << tmpreg;

    /* жϱ־λ */
    ADCx->STATE |= tmpreg;

    tmpreg1 = (InterruptType >> 8)&0x0f;
    tmpreg2 = (ADCx->STATE) & ((uint32_t)(0x01 << tmpreg1));
    while(tmpreg2>>tmpreg1);
    /* жϱ־λ */
    ADCx->STATE &= ~tmpreg;
}

/**
  *   ȡADCжӦ״̬
  *   ADCx: ָADCڴṹָ룬ȡֵΪADC0_SFR~ADC2_SFR
  *       InterruptType: ADCжͣȡֵΪ
  *                        ADC_INT_EOC: ADCһתж
  *                        ADC_INT_AWD: ADCģ⿴Źж
  *                        ADC_INT_HPEND: ADCȼͨתж
  *                        ADC_INT_END: ADCͨתж
  *   жӦ״̬1Ӧжϣ0δжϻδʹܡ
  */
INTStatus
ADC_Get_INT_Status (ADC_SFRmap* ADCx, uint32_t InterruptType)
{
    uint32_t tmpmask = 0;
    uint32_t enablestatus = 0;
    uint32_t tmpreg = 0;

    /* У */
    CHECK_RESTRICTION(CHECK_ADC_ALL_PERIPH(ADCx));
    CHECK_RESTRICTION(CHECK_ADC_INT(InterruptType));

    /*------------- ȡADCx_STATEĴ -------------*/
    tmpreg = ADCx->STATE;

    /* ȡжʹ״̬ */
    enablestatus = (tmpreg & ((uint32_t)0x01 << InterruptType)) ;

    /* ȡжϱ־״̬ */
    tmpmask = tmpreg & ((uint32_t)0x01 << ((InterruptType >> 8)));

    /* жʹܺͱ־ */
    if ((tmpmask != (uint32_t)RESET) && enablestatus)
    {
        /* Ӧж */
        return SET;
    }
    else
    {
        /* δжϻδʹ */
        return RESET;
    }
}
/**
  *   ##### ģתģ(ADC)жϹ #####
  */
