/**
  ******************************************************************************
  * ļ  kf32f_basic_aes.h
  *     ChipON_AE/FAE_Group
  *     V3.0.0
  *     2021-08-20
  *     ļṩ˼(AES)عܺغ궨塣
  *********************************************************************
  */

#ifndef _KF32F_BASIC_AES_H_
#define _KF32F_BASIC_AES_H_

#include "KF32F_BASIC.h"


/**
  * AESģ飨AESָ붨
  */
#define CHECK_AES_PERIPH(PERIPH)     ((PERIPH) == AES_SFR)

/**
 * AES Ϣṹ
 */
typedef struct
{
 uint32_t m_OFB;                 /*AES OFBģʽ
                                 ȡֵΪꡰAES OFBģʽơеһ*/
 uint32_t m_ClockSelect;         /*AES ʱԴѡ
                                 ȡֵΪꡰAES ʱԴѡеһ*/
 uint32_t m_ClockDiv;            /*AES ʱӷƵ
                                 ȡֵΪꡰAES ʱӷƵơеһ*/
 uint32_t m_Run;                 /*AES ʹܿ
                                 ȡֵΪꡰAES ʹܿơеһ*/
 uint32_t m_FinishIntEn;         /*AES жʹλ
                                 ȡֵΪꡰAES жʹλеһ*/
 uint32_t m_FinishIntClr;        /*AES
                                 ȡֵΪꡰAESơеһ*/

} AES_InitTypeDef;



/**
 * AES OFBģʽ
 */
#define AES_OFB_ENABLE              ((uint32_t) 0x1 << AES_CTL_OFBEN_POS)
#define AES_OFB_DISABLE             ((uint32_t) 0x0 << AES_CTL_OFBEN_POS)
#define CHECK_AES_OFB(SEL)          (((SEL) == AES_OFB_ENABLE) \
                                    || ((SEL) == AES_OFB_DISABLE) )

/**
 * AES ʱԴѡ
 */
#define AES_CLK_SEL_SCLK            ((uint32_t) 0x0 << AES_CTL_AESCS0_POS)
#define AES_CLK_SEL_HFCLK           ((uint32_t) 0x1 << AES_CTL_AESCS0_POS)
#define AES_CLK_SEL_LFCLK           ((uint32_t)0x2 << AES_CTL_AESCS0_POS)
#define CHECK_AES_CLKSOURCE(SEL)    (((SEL) == AES_CLK_SEL_SCLK) \
                                    || ((SEL) == AES_CLK_SEL_HFCLK) \
                                    || ((SEL) == AES_CLK_SEL_LFCLK))

/**
 * AES ʱӷƵ
 */
#define AES_CLK_DIV_1               ((uint32_t) 0x0 << AES_CTL_AESDIV0_POS)
#define AES_CLK_DIV_2               ((uint32_t) 0x1 << AES_CTL_AESDIV0_POS)
#define AES_CLK_DIV_4               ((uint32_t) 0x2 << AES_CTL_AESDIV0_POS)
#define AES_CLK_DIV_8               ((uint32_t) 0x3 << AES_CTL_AESDIV0_POS)
#define AES_CLK_DIV_16              ((uint32_t) 0x4 << AES_CTL_AESDIV0_POS)
#define AES_CLK_DIV_32              ((uint32_t) 0x5 << AES_CTL_AESDIV0_POS)
#define AES_CLK_DIV_64              ((uint32_t) 0x6 << AES_CTL_AESDIV0_POS)
#define AES_CLK_DIV_128             ((uint32_t) 0x7 << AES_CTL_AESDIV0_POS)
#define CHECK_AES_CLK_DIV(SEL)      (((SEL) == AES_CLK_DIV_1) \
                                    || ((SEL) == AES_CLK_DIV_2) \
                                    || ((SEL) == AES_CLK_DIV_4) \
                                    || ((SEL) == AES_CLK_DIV_8) \
                                    || ((SEL) == AES_CLK_DIV_16) \
                                    || ((SEL) == AES_CLK_DIV_32) \
                                    || ((SEL) == AES_CLK_DIV_64) \
                                    || ((SEL) == AES_CLK_DIV_128) )

/**
 * AES ʹܿ
 */
#define AES_RUN_ENABLE              ((uint32_t) 0x1 << AES_CTL_AESRUN_POS)
#define AES_RUN_DISABLE             ((uint32_t) 0x0 << AES_CTL_AESRUN_POS)
#define CHECK_AES_RUN(SEL)          (((SEL) == AES_RUN_ENABLE) \
                                    || ((SEL) == AES_RUN_DISABLE) )

/**
 * AES жʹλ
 */
#define AES_FINISH_INT_ENABLE       ((uint32_t) 0x1 << AES_CTL_AESFIE_POS)
#define AES_FINISH_INT_DISABLE      ((uint32_t) 0x0 << AES_CTL_AESFIE_POS)
#define CHECK_AES_FINISH_INT(SEL)   (((SEL) == AES_FINISH_INT_ENABLE) \
                                    || ((SEL) == AES_FINISH_INT_DISABLE) )

/**
 * AES
 */
#define AES_FINISH_INT_CLEAR_ENABLE      ((uint32_t) 0x1 << AES_CTL_AESFIC_POS)
#define AES_FINISH_INT_CLEAR_DISABLE     ((uint32_t) 0x0 << AES_CTL_AESFIC_POS)
#define CHECK_AES_FINISH_INT_CLEAR(SEL)  (((SEL) == AES_FINISH_INT_CLEAR_ENABLE) \
                                        || ((SEL) == AES_FINISH_INT_CLEAR_DISABLE) )
#ifdef KF32F_Periph_aes
uint32_t GET_AES_OUTPUT0_DATA (void);
uint32_t GET_AES_OUTPUT1_DATA (void);
uint32_t GET_AES_OUTPUT2_DATA (void);
uint32_t GET_AES_OUTPUT3_DATA (void);
void AES_INPUT0_DATA (uint32_t DATA);
void AES_INPUT1_DATA (uint32_t DATA);
void AES_INPUT2_DATA (uint32_t DATA);
void AES_INPUT3_DATA (uint32_t DATA);
void AES_KEY0_DATA (uint32_t DATA);
void AES_KEY1_DATA (uint32_t DATA);
void AES_KEY2_DATA (uint32_t DATA);
void AES_KEY3_DATA (uint32_t DATA);
void AES_Struct_Init (AES_InitTypeDef* AESInitStruct);
void AES_Configuration (AES_InitTypeDef* AESInitStruct);
void AES_Reset ();
void AES_Start ();
void AES_CLR_Flag_Status ();
FlagStatus AES_Get_Flag_Status (void);
#endif //KF32F_Periph_aes
#endif /* _KF32F_BASIC_AES_H */
