/**
  ******************************************************************************
  * ļ  ADC_user.c
  *     ChipON_AE/FAE_Group
  *     V2.1
  *     2019-11-16
  *     ļṩADC
  *
  *********************************************************************
  */
#include "system_init.h"
#include "ADC_user.h"
#ifndef ADC_C_
#define ADC_C_

void Init_adc()
{
	ADC_InitTypeDef adcStruct;

	ADC_Reset (ADC0_SFR); //λADC貢ADCʱ

	/* ʼ ADCʱԴѡ */
	adcStruct.m_Clock = ADC_HFCLK;
	/* ʼ ADCʱӷƵ */
	adcStruct.m_ClockDiv = ADC_CLK_DIV_32; //ѡ32Ƶ
	/* ʼ ADCɨģʽʹ */
	adcStruct.m_ScanMode = FALSE;  //ʹɨģʽһδֻתһͨ
	/* ʼ ADCתģʽ */
	adcStruct.m_ContinuousMode = ADC_CONTINUOUS_MODE; //ʹתܣֻõͨһ
	/* ʼ ADCתʽ */
	adcStruct.m_DataAlign = ADC_DATAALIGN_RIGHT; //תĽҶ
	/* ʼ ADCͨⲿתģʽʹ */
	adcStruct.m_ExternalTrig_EN = FALSE; //ͨʧⲿADCת
	/* ʼ ADCͨⲿ¼ */
	adcStruct.m_ExternalTrig = ADC_EXTERNALTRIG_T1TRGO; //ͨⲿźԴΪT1TRGO
	/* ʼ ADCȼͨⲿתģʽʹ */
	adcStruct.m_HPExternalTrig_EN = FALSE; //ȼͨʧⲿADCת
	/* ʼ ȼͨⲿ¼ */
	adcStruct.m_HPExternalTrig = ADC_HPEXTERNALTRIG_CCP1_CH1; //ȼͨźԴΪCCP1ͨ1
	/* οѹѡȡֵΪꡰADCοѹѡеһ */
	adcStruct.m_VoltageRef=ADC_REF_AVDD; //תĲοѹԴΪVDDA
	/* ʼ ADCͨɨ賤 */
	adcStruct.m_NumOfConv = 1; //ɨĳΪ1ͨ
	/* ʼ ADCȼͨɨ賤 */
	adcStruct.m_NumOfHPConv = 1; //ȼͨɨ賤
	ADC_Configuration (ADC0_SFR, &adcStruct);

	ADC_Cmd (ADC0_SFR, TRUE); //ADCʹ

	ADC_Regular_Channel_Config (ADC0_SFR, ADC_CHANNEL_1, 0x01); //ADC0ͨ1ĲԴΪADC_CHANNEL_1

	Delay(0xFF);  //ADCʹܺҪһζݵʱ䣬ȴ·Ϻ󣬲ȥ߿ܴڽϴĲ
}

void Init_ADC_Analog_Wd()
{
	ADC_WD_InitTypeDef M;

    /* ʼ ADCģ⿴Źͨʹ */
    M.m_WDSingleCH = ADC_WD_SINGLE_CH;

    /* ʼ ADCȼͨϿŹʹ */
    M.m_HPChannelWDEN = FALSE;

    /* ʼ ADCͨϿŹʹ */
    M.m_ChannelWDEN = TRUE;

    /* ʼ ADCģ⿴Źͨѡ */
    M.m_WDChannel = ADC_WDCH_43;

    /* ʼ ADCģ⿴Źֵ */
    M.m_Threshold_H = 0xA00;

    /* ʼ ADCģ⿴Źֵ */
    M.m_Threshold_L = 0x500;

	ADC_Analog_Watchdog_Configuration (ADC0_SFR,&M);
}

#endif /* ADC_C_ */
