/**
  ******************************************************************************
  * ļ  kf32a_basic_usart.c
  *     ChipON_AE/FAE_Group
  *     V3.0.1
  *     2021-11-25
  *     ļṩUSARTģ(USART)صĹܺ
  *          + USARTģ(USART)ʼ
  *          + USARTģ(USART)ú
  *          + USARTģ(USART)7816ʼú
  *          + USARTģ(USART)жϹ
  *
  *********************************************************************
  */

#include "kf32a_basic_usart.h"
#include "kf32a_basic_rst.h"
#include "kf32a_basic_pclk.h"

/* USART˽ж ----------------------------------------------------*/
/* USARTx_CTLRĴ */
#define USART_CTLR_INIT_MASK            (USART_CTLR_SYNC \
                                       | USART_CTLR_CSRS \
                                       | USART_CTLR_TXEN \
                                       | USART_CTLR_RXEN \
                                       | USART_CTLR_DT9EN \
                                       | USART_CTLR_STPW \
                                       | USART_CTLR_PARM \
                                       | USART_CTLR_RTSEN \
                                       | USART_CTLR_CTSEN)

/* USARTx_U7816R_Ĵ */
#define USART_U7816R_INIT_MASK          (USART_U7816R_ERSW \
                                       | USART_U7816R_PSEL \
                                       | USART_U7816R_TXRE \
                                       | USART_U7816R_RXRE \
                                       | USART_U7816R_CLKOUT \
                                       | USART_U7816R_CLKDIV \
                                       | USART_U7816R_EGT)

/* USARTx_BRGR_Ĵ */
#define USART_BRGR_INIT_MASK            (USART_BRGR_BRGM \
                                       | USART_BRGR_BRGF1 \
                                       | USART_BRGR_BRGF2)


/**
  *   ##### USARTģ(USART)ʼ #####
  */
/**
  *   USART踴λ
  *   USARTx: ָUSARTڴṹָ룬ȡֵΪUSART0_SFR~USART8_SFR
  *   ޡ
  */
void
USART_Reset (USART_SFRmap* USARTx)
{
    /* У */
    CHECK_RESTRICTION(CHECK_USART_ALL_PERIPH(USARTx));
#ifdef  KF32A_Periph_usart0
    if (USARTx == USART0_SFR)
    {
        RST_CTL1_Peripheral_Reset_Enable(RST_CTL1_USART0RST, TRUE);
        RST_CTL1_Peripheral_Reset_Enable(RST_CTL1_USART0RST, FALSE);
        PCLK_CTL1_Peripheral_Clock_Enable(PCLK_CTL1_USART0CLKEN, TRUE);
    }
#endif
#ifdef  KF32A_Periph_usart1
    if (USARTx == USART1_SFR)
    {
        RST_CTL1_Peripheral_Reset_Enable(RST_CTL1_USART1RST, TRUE);
        RST_CTL1_Peripheral_Reset_Enable(RST_CTL1_USART1RST, FALSE);
        PCLK_CTL1_Peripheral_Clock_Enable(PCLK_CTL1_USART1CLKEN, TRUE);
    }
#endif
#ifdef  KF32A_Periph_usart2
    if (USARTx == USART2_SFR)
    {
        RST_CTL1_Peripheral_Reset_Enable(RST_CTL1_USART2RST, TRUE);
        RST_CTL1_Peripheral_Reset_Enable(RST_CTL1_USART2RST, FALSE);
        PCLK_CTL1_Peripheral_Clock_Enable(PCLK_CTL1_USART2CLKEN, TRUE);
    }
#endif
#ifdef  KF32A_Periph_usart3
    if (USARTx == USART3_SFR)
    {
        RST_CTL1_Peripheral_Reset_Enable(RST_CTL1_USART3RST, TRUE);
        RST_CTL1_Peripheral_Reset_Enable(RST_CTL1_USART3RST, FALSE);
        PCLK_CTL1_Peripheral_Clock_Enable(PCLK_CTL1_USART3CLKEN, TRUE);
    }
#endif
#ifdef  KF32A_Periph_usart4
    if (USARTx == USART4_SFR)
    {
        RST_CTL1_Peripheral_Reset_Enable(RST_CTL1_USART4RST, TRUE);
        RST_CTL1_Peripheral_Reset_Enable(RST_CTL1_USART4RST, FALSE);
        PCLK_CTL1_Peripheral_Clock_Enable(PCLK_CTL1_USART4CLKEN, TRUE);
    }
#endif
#ifdef  KF32A_Periph_usart5
   if (USARTx == USART5_SFR)
    {
        RST_CTL2_Peripheral_Reset_Enable(RST_CTL2_USART5RST, TRUE);
        RST_CTL2_Peripheral_Reset_Enable(RST_CTL2_USART5RST, FALSE);
        PCLK_CTL2_Peripheral_Clock_Enable(PCLK_CTL2_USART5CLKEN, TRUE);
    }
#endif
#ifdef  KF32A_Periph_usart6
   if (USARTx == USART6_SFR)
    {
        RST_CTL2_Peripheral_Reset_Enable(RST_CTL2_USART6RST, TRUE);
        RST_CTL2_Peripheral_Reset_Enable(RST_CTL2_USART6RST, FALSE);
        PCLK_CTL2_Peripheral_Clock_Enable(PCLK_CTL2_USART6CLKEN, TRUE);
    }
#endif
#ifdef  KF32A_Periph_usart7
    if (USARTx == USART7_SFR)
    {
        RST_CTL2_Peripheral_Reset_Enable(RST_CTL2_USART7RST, TRUE);
        RST_CTL2_Peripheral_Reset_Enable(RST_CTL2_USART7RST, FALSE);
        PCLK_CTL2_Peripheral_Clock_Enable(PCLK_CTL2_USART7CLKEN, TRUE);
    }
#endif
}

/**
  *   USARTʼ
  *   USARTx: ָUSARTڴṹָ룬ȡֵΪUSART0_SFR~USART8_SFR
  *       USARTInitStruct: USARTϢṹָ롣
  *   
  */
void
USART_Configuration (USART_SFRmap* USARTx, USART_InitTypeDef* usartInitStruct)
{
    uint32_t tmpreg = 0;

    /* У */
    CHECK_RESTRICTION(CHECK_USART_ALL_PERIPH(USARTx));
    CHECK_RESTRICTION(CHECK_USART_MODE(usartInitStruct->m_Mode));
    CHECK_RESTRICTION(CHECK_USART_CLOCKSOURCE(usartInitStruct->m_HalfDuplexClkSource));
    CHECK_RESTRICTION(CHECK_USART_DIRECTION(usartInitStruct->m_TransferDir));
    CHECK_RESTRICTION(CHECK_USART_WORD_LENGTH(usartInitStruct->m_WordLength));
    CHECK_RESTRICTION(CHECK_USART_STOPBITS(usartInitStruct->m_StopBits));//
    CHECK_RESTRICTION(CHECK_USART_Bit9_MODE(usartInitStruct->m_Bit9SEL));
    CHECK_RESTRICTION(CHECK_USART_PARITY(usartInitStruct->m_Parity));
    CHECK_RESTRICTION(CHECK_USART_ABRDEN(usartInitStruct->m_BRAutoDetect));
    CHECK_RESTRICTION(CHECK_USART_HARDWARE_FLOW_CONTROL(usartInitStruct->m_HardwareFlowControl));
    CHECK_RESTRICTION(CHECK_USART_RECEIVE_DIR(usartInitStruct->m_ReceiveOrder));
    CHECK_RESTRICTION(CHECK_USART_TRANSMIT_DIR(usartInitStruct->m_TransmitOrder));
    CHECK_RESTRICTION(CHECK_USART_CLK(usartInitStruct->m_BaudRateBRCKS));
    CHECK_RESTRICTION(CHECK_USART_BAUDRATE_DECIMAL(usartInitStruct->m_BaudRateNumerator));
    CHECK_RESTRICTION(CHECK_USART_BAUDRATE_DECIMAL(usartInitStruct->m_BaudRateDenominator));

    /*------------------- USART_CTLRĴ  -----------------*/
    /* ݽṹԱm_ModeSYNCλ */
    /* ݽṹԱm_HalfDuplexClkSourceCSRSλ */
    /* ݽṹԱm_TransferDirTXEN/RXENλ */
    /* ݽṹԱm_WordLengthDT9ENλ */
    /* ݽṹԱm_StopBitsSTPWλ */
    /* ݽṹԱm_Bit9SELTX9SELλ */
    /* ݽṹԱm_ParityPARMλ */
    /* ݽṹԱm_HardwareFlowControlRTSEN/CTSENλ */
    tmpreg = ((usartInitStruct->m_Mode)     \
            | (usartInitStruct->m_HalfDuplexClkSource)  \
            | (usartInitStruct->m_TransferDir)  \
            | (usartInitStruct->m_WordLength)  \
            | (usartInitStruct->m_Bit9SEL)   \
            | (usartInitStruct->m_StopBits)   \
            | (usartInitStruct->m_ReceiveOrder)   \
            | (usartInitStruct->m_TransmitOrder)   \
            | (usartInitStruct->m_Parity)     \
            | (usartInitStruct->m_BRAutoDetect)     \
            | (usartInitStruct->m_HardwareFlowControl)     \
            | (usartInitStruct->m_BaudRateBRCKS));

    USARTx->CTLR = SFR_Config (USARTx->CTLR, ~USART_CTLR_INIT_MASK, tmpreg);

    /*------------------- USART_BRGRĴ  -----------------*/
    /* ݽṹԱm_BaudRateIntegerBRGMλ */
    /* ݽṹԱm_BaudRateNumeratorBRGF1λ */
    /* ݽṹԱm_BaudRateDenominatorBRGF2λ */
    tmpreg = ((uint32_t)usartInitStruct->m_BaudRateInteger << USART_BRGR_BRGM0_POS)  \
            | ((uint32_t)usartInitStruct->m_BaudRateNumerator << USART_BRGR_BRGF1_0_POS)   \
            | ((uint32_t)usartInitStruct->m_BaudRateDenominator << USART_BRGR_BRGF2_0_POS);
    USARTx->BRGR = SFR_Config (USARTx->BRGR, ~USART_BRGR_INIT_MASK, tmpreg);
}

/**
  *   7816á
  *   USARTx: ָUSARTڴṹָ룬ȡֵΪUSART0_SFR~USART8_SFR
  *       USARTInitStruct: USART_U7816Ϣ
  *   
  */
void
USART_U7816R_Configuration (USART_SFRmap* USARTx, U7816R_InitTypeDef* usartInitStruct)
{
    uint32_t tmpreg = 0;

    /* У */
    CHECK_RESTRICTION(CHECK_USART_ALL_PERIPH(USARTx));
    CHECK_RESTRICTION(CHECK_U7816R_ERRORSIGNAL(usartInitStruct->m_ErrorSignal));
    CHECK_RESTRICTION(CHECK_U7816R_PASSAGEWAY_SELECT(usartInitStruct->m_PassagewaySelect));
    CHECK_RESTRICTION(CHECK_U7816R_TRANSMIT_REPEAT(usartInitStruct->m_TransmitRepeat));
    CHECK_RESTRICTION(CHECK_U7816R_RECEIVE_REPEAT(usartInitStruct->m_ReceiveRepeat));
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(usartInitStruct->m_Clkout));

    /*---------------------------- USARTx_U7816RĴ  -----------------*/
    /* ݽṹԱm_ErrorSignalERSWλ */
    /* ݽṹԱm_PassagewaySelectPSELλ */
    /* ݽṹԱm_TransmitRepeatTXREλ */
    /* ݽṹԱm_ReceiveRepeatRXREλ */
    /* ݽṹԱm_ClkoutCLKOUTλ */
    /* ݽṹԱm_ClkDivCLKDIVλ */
    /* ݽṹԱm_EgtEGTλ */

    tmpreg = ((usartInitStruct->m_ErrorSignal)      \
            | (usartInitStruct->m_PassagewaySelect) \
            | (usartInitStruct->m_TransmitRepeat)   \
            | (usartInitStruct->m_ReceiveRepeat)    \
            | ((uint32_t)usartInitStruct->m_Clkout << USART_U7816R_CLKOUT_POS) \
            | ((uint32_t)usartInitStruct->m_Egt << USART_U7816R_EGT0_POS)      \
            | ((uint32_t)usartInitStruct->m_ClkDiv << USART_U7816R_CLKDIV0_POS));
    USARTx->U7816R = SFR_Config (USARTx->U7816R, ~USART_U7816R_INIT_MASK, tmpreg);
}

/**
  *   ʼUSARTϢṹ塣
  *   usartInitStruct: ָʼĽṹָ롣
  *   ޡ
  */
void
USART_Struct_Init(USART_InitTypeDef* usartInitStruct)
{
    /* ʼ USARTģʽ */
    usartInitStruct->m_Mode = USART_MODE_FULLDUPLEXASY;

    /* ʼ USARTʱԴѡ */
    usartInitStruct->m_HalfDuplexClkSource = USART_SLAVE_CLOCKSOURCE_EXTER;

    /* ʼ USART䷽ */
    usartInitStruct->m_TransferDir = USART_DIRECTION_TRANSMIT;

    /* ʼ USARTֳ */
    usartInitStruct->m_WordLength = USART_WORDLENGTH_8B;

    /* ʼ USARTֹͣλ */
    usartInitStruct->m_StopBits = USART_STOPBITS_1;

    /* ʼ USARTݵ9λ */
    usartInitStruct->m_Bit9SEL = USART_BIT9_PAR;

    /* ʼ USARTżУλ */
    usartInitStruct->m_Parity = USART_PARITY_ODD;

    /* ʼ USARTմ */
    usartInitStruct->m_ReceiveOrder = USART_RECEIVE_LSB;

    /* ʼUSARTʹ */
    usartInitStruct->m_TransmitOrder = USART_TRANSMIT_LSB;

    /* ʼ USARTԶʼʹλ */
    usartInitStruct->m_BRAutoDetect = USART_ABRDEN_OFF;

    /* ʼ USARTӲ */
    usartInitStruct->m_HardwareFlowControl = USART_HARDWAREFLOWCONTROL_NONE;

    /* ʼ USARTʷʱѡ */
    usartInitStruct->m_BaudRateBRCKS = USART_CLK_SCLK;

    /* ʼ USART */
    usartInitStruct->m_BaudRateInteger = 1;

    /* ʼ USARTСӲ */
    usartInitStruct->m_BaudRateNumerator = 0;

    /* ʼ USARTСĸ */
    usartInitStruct->m_BaudRateDenominator = 1;
}

/**
  *   ʼUSART_7816Ϣṹ塣
  *   usartInitStruct: ָʼĽṹָ롣
  *   ޡ
  */
void
USART_U7816R_Struct_Init(U7816R_InitTypeDef* usartInitStruct)
{
    /* ʼ USART */
    usartInitStruct->m_ErrorSignal = USART_U7816R_ERRORSIGNAL_2ETU;

    /* ʼ USARTͨ */
    usartInitStruct->m_PassagewaySelect = USART_U7816R_PASSAGEWAY_TX0;

    /* ʼ USARTżУʱط͵ */
    usartInitStruct->m_TransmitRepeat = USART_U7816R_TRANSMIT_REPEAT_0S;

    /* ʼ USARTżУʱؽյ */
    usartInitStruct->m_ReceiveRepeat = USART_U7816R_RECEIVE_REPEAT_0S;

    /* ʼ USB˵ʹ */
    usartInitStruct->m_Clkout = FALSE;

    /* ʼ 7816ʱӺʱӿ */
    usartInitStruct->m_ClkDiv = 0;

    /* ʼ ʱEGT */
    usartInitStruct->m_Egt = 0;
}
/**
  *   ##### USARTģ(USART)ʼ #####
  */


/**
  *   ##### USARTģ(USART)ú #####
  */
/**
  *   USARTʹܡ
  *   USARTx: ָUSARTڴṹָ룬ȡֵΪUSART0_SFR~USART8_SFR
  *       NewState: USARTʹʹ״̬ȡֵΪTRUE  FALSE
  *   ޡ
  */
void
USART_Cmd (USART_SFRmap* USARTx, FunctionalState NewState)
{
    /* У */
    CHECK_RESTRICTION(CHECK_USART_ALL_PERIPH(USARTx));
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

    /*---------------- USART_CTLRĴUSARTENλ ----------------*/
    if (NewState != FALSE)
    {
        /* ʹUSART */
        SFR_SET_BIT_ASM(USARTx->CTLR, USART_CTLR_USARTEN_POS);
    }
    else
    {
        /* ֹUSART */
        SFR_CLR_BIT_ASM(USARTx->CTLR, USART_CTLR_USARTEN_POS);
    }
}

/**
  *   USARTʷʱѡ
  *   USARTx: ָUSARTڴṹָ룬ȡֵΪUSART0_SFR~USART8_SFR
  *       CLK: ʱѡȡֵΧΪ
  *              USART_CLK_SCLK  :ʱ
  *              USART_CLK_HFCLK :Ƶʱ
  *              USART_CLK_LFCLK :Ƶʱ
  *   ޡ
  */
void
USART_BaudRate_Clock_Config(USART_SFRmap* USARTx, uint32_t CLK)
{
    /* У */
    CHECK_RESTRICTION(CHECK_USART_ALL_PERIPH(USARTx));
    CHECK_RESTRICTION(CHECK_USART_CLK(CLK));

    /*---------------- USART_CTLRĴBRCKSλ ----------------*/
    USARTx->CTLR = SFR_Config (USARTx->CTLR, ~USART_CTLR_BRCKS, CLK);
}

/**
  *   USART˫ͬʱӼѡ
  *   USARTx: ָUSARTڴṹָ룬ȡֵΪUSART0_SFR~USART8_SFR
  *       NewState: USART˫ͬʱӼԣȡֵΪ
  *                   USART_CPOL_HIGH:ʱ½ͬ
  *                   USART_CPOL_LOW :ʱͬ
  *   ޡ
  */
void
USART_HalfDuplex_ClockPolarity_Config(USART_SFRmap* USARTx, uint32_t NewState)
{
    /* У */
    CHECK_RESTRICTION(CHECK_USART_ALL_PERIPH(USARTx));
    CHECK_RESTRICTION(CHECK_USART_CPOL(NewState));

    /*---------------- USART_CTLRĴSCKPSλ ----------------*/
    if (NewState != USART_CPOL_LOW)
    {
        /* ʱ½ͬ */
        SFR_SET_BIT_ASM(USARTx->CTLR, USART_CTLR_SCKPS_POS);
    }
    else
    {
        /* ʱͬ*/
        SFR_CLR_BIT_ASM(USARTx->CTLR, USART_CTLR_SCKPS_POS);
    }
}

/**
  *   USARTʹѡ
  *   USARTx: ָUSARTڴṹָ룬ȡֵΪUSART0_SFR~USART8_SFR
  *       NewState: USARTʹȡֵΪ
  *                   USART_TRANSMIT_MSB:ȷMSB
  *                   USART_TRANSMIT_LSB:ȷLSB
  *   ޡ
  */
void
USART_Transmit_Order_Config (USART_SFRmap* USARTx, uint32_t NewState)
{
    /* У */
    CHECK_RESTRICTION(CHECK_USART_ALL_PERIPH(USARTx));
    CHECK_RESTRICTION(CHECK_USART_TRANSMIT_DIR(NewState));

    /*---------------- USART_CTLRĴTCONVλ ----------------*/
    if (NewState != USART_TRANSMIT_LSB)
    {
        /* ȷMSB */
        SFR_SET_BIT_ASM(USARTx->CTLR, USART_CTLR_TCONV_POS);
    }
    else
    {
        /* ȷLSB */
        SFR_CLR_BIT_ASM(USARTx->CTLR, USART_CTLR_TCONV_POS);
    }
}

/**
  *   USARTմѡ
  *   USARTx: ָUSARTڴṹָ룬ȡֵΪUSART0_SFR~USART8_SFR
  *       NewState: USARTմȡֵΪ
  *                   USART_RECEIVE_MSB:ȽMSB
  *                   USART_RECEIVE_LSB:ȽLSB
  *   ޡ
  */
void
USART_Receive_Order_Config (USART_SFRmap* USARTx, uint32_t NewState)
{
    /* У */
    CHECK_RESTRICTION(CHECK_USART_ALL_PERIPH(USARTx));
    CHECK_RESTRICTION(CHECK_USART_RECEIVE_DIR(NewState));

    /*---------------- USART_CTLRĴRCONVλ ----------------*/
    if (NewState != USART_RECEIVE_LSB)
    {
        /* ȽMSB */
        SFR_SET_BIT_ASM(USARTx->CTLR, USART_CTLR_RCONV_POS);
    }
    else
    {
        /* ȽLSB */
        SFR_CLR_BIT_ASM(USARTx->CTLR, USART_CTLR_RCONV_POS);
    }
}

/**
  *   úƸߵƽԡ
  *   USARTx: ָUSARTڴṹָ룬ȡֵΪUSART0_SFR~USART8_SFR
  *       NewState: ƸߵƽԣȡֵΪ
  *                   TRUE: ͺͽշƽ
  *                   FALSE: ͺͽƽ
  *   ޡ
  */
void
USART_Infrare_Detector_Voltage_Config(USART_SFRmap* USARTx,
                    FunctionalState NewState)
{
    /* У */
    CHECK_RESTRICTION(CHECK_USART_ALL_PERIPH(USARTx));
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

    /*---------------- USART_CTLRĴDINVλ ----------------*/
    if (NewState != FALSE)
    {
        /* ͺͽշƽ*/
        SFR_SET_BIT_ASM(USARTx->CTLR, USART_CTLR_DINV_POS);
    }
    else
    {
        /* ͺͽƽ*/
        SFR_CLR_BIT_ASM(USARTx->CTLR, USART_CTLR_DINV_POS);
    }
}

/**
  *   USARTʹܡ
  *   USARTx: ָUSARTڴṹָ룬ȡֵΪUSART0_SFR~USART8_SFR
  *       NewState: USARTʹ״̬ȡֵΪTRUE  FALSE
  *   ޡ
  */
void
USART_WeakUP_Enable(USART_SFRmap* USARTx, FunctionalState NewState)
{
    /* У */
    CHECK_RESTRICTION(CHECK_USART_ALL_PERIPH(USARTx));
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

    /*---------------- USART_CTLRĴWUENλ ----------------*/
    if (NewState != FALSE)
    {
        /* ʹUSART */
        SFR_SET_BIT_ASM(USARTx->CTLR, USART_CTLR_WUEN_POS);
    }
    else
    {
        /* ֹUSART */
        SFR_CLR_BIT_ASM(USARTx->CTLR, USART_CTLR_WUEN_POS);
    }
}

/**
  *   USARTʱԴѡ
  *   USARTx: ָUSARTڴṹָ룬ȡֵΪUSART0_SFR~USART8_SFR
  *       ClockSource: USARTʱԴѡȡֵΪTRUE  FALSE
  *                      USART_MASTER_CLOCKSOURCE_INTER: ģʽ(BRGڲʱ)
  *                      USART_SLAVE_CLOCKSOURCE_EXTER: ģʽ(ʱԴⲿ)
  *   ޡ
  */
void
USART_Clock_Source_Config(USART_SFRmap* USARTx, uint32_t ClockSource)
{
    /* У */
    CHECK_RESTRICTION(CHECK_USART_ALL_PERIPH(USARTx));
    CHECK_RESTRICTION(CHECK_USART_CLOCKSOURCE(ClockSource));

    /*---------------- USART_CTLRĴCSRSλ ----------------*/
    if (ClockSource != USART_SLAVE_CLOCKSOURCE_EXTER)
    {
        /* ģʽ(BRGڲʱ*/
        SFR_SET_BIT_ASM(USARTx->CTLR, USART_CTLR_CSRS_POS);
    }
    else
    {
        /* ģʽ(ʱԴⲿ*/
        SFR_CLR_BIT_ASM(USARTx->CTLR, USART_CTLR_CSRS_POS);
    }
}

/**
  *   USARTַʹλ
  *   USARTx: ָUSARTڴṹָ룬ȡֵΪUSART0_SFR~USART8_SFR
  *       NewState: USARTַʹ״̬ȡֵΪTRUE  FALSE
  *   ޡ
  */
void
USART_Address_Detection_Enable(USART_SFRmap* USARTx, FunctionalState NewState)
{
    /* У */
    CHECK_RESTRICTION(CHECK_USART_ALL_PERIPH(USARTx));
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

    /*---------------- USART_CTLRĴADRENλ ----------------*/
    if (NewState != FALSE)
    {
        /* ʹַܵ⣬ַλΪ1ʱװBUF*/
        SFR_SET_BIT_ASM(USARTx->CTLR, USART_CTLR_ADREN_POS);
    }
    else
    {
        /* ַֹ⣬ֽڲҵ9λΪżУλ*/
        SFR_CLR_BIT_ASM(USARTx->CTLR, USART_CTLR_ADREN_POS);
    }
}

/**
  *   USARTԶʼʹλ
  *   USARTx: ָUSARTڴṹָ룬ȡֵΪUSART0_SFR~USART8_SFR
  *       NewState: USARTԶʼʹ״̬ȡֵΪTRUE  FALSE
  *   ޡ
  */
void
USART_Auto_BaudRate_Detection_Enable(USART_SFRmap* USARTx,
                    FunctionalState NewState)
{
    /* У */
    CHECK_RESTRICTION(CHECK_USART_ALL_PERIPH(USARTx));
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

    /*---------------- USART_CTLRĴABRDENλ ----------------*/
    if (NewState != FALSE)
    {
        /* ʹԶģʽ(Զʺ0)*/
        SFR_SET_BIT_ASM(USARTx->CTLR, USART_CTLR_ABRDEN_POS);
    }
    else
    {
        /* ֹԶģʽ*/
        SFR_CLR_BIT_ASM(USARTx->CTLR, USART_CTLR_ABRDEN_POS);
    }
}
/**
  *   ȡUSARTԶʼʹλ
  *   USARTx: ָUSARTڴṹָ룬ȡֵΪUSART0_SFR~USART8_SFR
  *       NewState: USARTԶʼʹ״̬ȡֵΪTRUE  FALSE
  *   1: ʹԶģʽ(Զʺ)
  *       0: ֹԶģʽ
  */
FlagStatus USART_Get_Auto_BaudRate_Detection_Flag(USART_SFRmap* USARTx)
{
    /* У */
    CHECK_RESTRICTION(CHECK_USART_ALL_PERIPH(USARTx));

    /*---------------- ȡUSART_CTLRĴABRDENλ ----------------*/
    if (USARTx->CTLR & USART_CTLR_ABRDEN)
    {
        return SET;
    }
    else
    {
    	/* ԶԶ */
    	return RESET;
    }
}
/**
  *   USARTͼַʹܡ
  *   USARTx: ָUSARTڴṹָ룬ȡֵΪUSART0_SFR~USART8_SFR
  *       NewState: USARTͼַʹ״̬ȡֵΪTRUE  FALSE
  *   ޡ
  */
void
USART_Send_Blank_Enable(USART_SFRmap* USARTx, FunctionalState NewState)
{
    /* У */
    CHECK_RESTRICTION(CHECK_USART_ALL_PERIPH(USARTx));
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

    /*---------------- USART_CTLRĴSENDBλ ----------------*/
    if (NewState != FALSE)
    {
        /* ͼַʹ(ɺ0)*/
        SFR_SET_BIT_ASM(USARTx->CTLR, USART_CTLR_SENDB_POS);
    }
    else
    {
        /* δʹܷͼַ*/
        SFR_CLR_BIT_ASM(USARTx->CTLR, USART_CTLR_SENDB_POS);
    }
}

/**
  *   USARTͨģʽѡλ
  *   USARTx: ָUSARTڴṹָ룬ȡֵΪUSART0_SFR~USART8_SFR
  *       NewMode: USARTģʽѡȡֵΪ
  *                  USART_MODE_HALFDUPLEXSYN:˫ͬģʽ
  *                  USART_MODE_FULLDUPLEXASY:ȫ˫첽ģʽ
  *   ޡ
  */
void
USART_SYN_Choice_Config(USART_SFRmap* USARTx, uint32_t NewMode)
{
    /* У */
    CHECK_RESTRICTION(CHECK_USART_ALL_PERIPH(USARTx));
    CHECK_RESTRICTION(CHECK_USART_MODE(NewMode));

    /*---------------- USART_CTLRĴSYNCλ ----------------*/
    if (NewMode != USART_MODE_FULLDUPLEXASY)
    {
        /* ˫ͬģʽ*/
        SFR_SET_BIT_ASM(USARTx->CTLR, USART_CTLR_SYNC_POS);
    }
    else
    {
        /*ȫ˫첽ģʽ*/
        SFR_CLR_BIT_ASM(USARTx->CTLR, USART_CTLR_SYNC_POS);
    }
}

/**
  *   USARTʹλ
  *   USARTx: ָUSARTڴṹָ룬ȡֵΪUSART0_SFR~USART8_SFR
  *       NewState: USARTʹ״̬ȡֵΪTRUE  FALSE
  *   ޡ
  */
void
USART_Transmit_Data_Enable (USART_SFRmap* USARTx, FunctionalState NewState)
{
    /* У */
    CHECK_RESTRICTION(CHECK_USART_ALL_PERIPH(USARTx));
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

    /*---------------- USART_CTLRĴTXENλ ----------------*/
    if (NewState != FALSE)
    {
        /* ʹܷ*/
        SFR_SET_BIT_ASM(USARTx->CTLR, USART_CTLR_TXEN_POS);
    }
    else
    {
        /* ֹ*/
        SFR_CLR_BIT_ASM(USARTx->CTLR, USART_CTLR_TXEN_POS);
    }
}

/**
  *   USARTʹλ
  *   USARTx: ָUSARTڴṹָ룬ȡֵΪUSART0_SFR~USART8_SFR
  *       NewState: USARTʹ״̬ȡֵΪTRUE  FALSE
  *   ޡ
  */
void
USART_Receive_Data_Enable (USART_SFRmap* USARTx, FunctionalState NewState)
{
    /* У */
    CHECK_RESTRICTION(CHECK_USART_ALL_PERIPH(USARTx));
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

    /*---------------- USART_CTLRĴRXENλ ----------------*/
    if (NewState != FALSE)
    {
        /* ʹܽ*/
        SFR_SET_BIT_ASM(USARTx->CTLR, USART_CTLR_RXEN_POS);
    }
    else
    {
        /* ֹ*/
        SFR_CLR_BIT_ASM(USARTx->CTLR, USART_CTLR_RXEN_POS);
    }
}

/**
  *   USARTֹͣλѡλ
  *   USARTx: ָUSARTڴṹָ룬ȡֵΪUSART0_SFR~USART8_SFR
  *       NewLength: ȡֵΪUSART_STOPBITS_2  USART_STOPBITS_1
  *                    USART_STOPBITS_2 :ֹͣλΪ2bits
  *                    USART_STOPBITS_1 :ֹͣλΪ1bit
  *   ޡ
  */
void
USART_STOP_Word_Config(USART_SFRmap* USARTx, uint32_t NewLength)
{
    /* У */
    CHECK_RESTRICTION(CHECK_USART_ALL_PERIPH(USARTx));
    CHECK_RESTRICTION(CHECK_USART_STOPBITS(NewLength));

    /*---------------- USART_CTLRĴSTPWλ ----------------*/
    if (NewLength != USART_STOPBITS_1)
    {
        /* ֹͣλΪ2bits*/
        SFR_SET_BIT_ASM(USARTx->CTLR, USART_CTLR_STPW_POS);
    }
    else
    {
        /* ֹͣλΪ1bit*/
        SFR_CLR_BIT_ASM(USARTx->CTLR, USART_CTLR_STPW_POS);
    }
}

/**
  *   USARTݵ9λѡ
  *   USARTx: ָUSARTڴṹָ룬ȡֵΪUSART0_SFR~USART8_SFR
  *       NewState: ȡֵΪUSART_BIT9_RS485  USART_BIT9_PAR
  *                   USART_BIT9_RS485 :RS-485ģʽ
  *                   USART_BIT9_PAR   :ѡżУ顣
  *   ޡ
  */
void
USART_Transmit_9Word_Select_Config (USART_SFRmap* USARTx, uint32_t NewState)
{
    /* У */
    CHECK_RESTRICTION(CHECK_USART_ALL_PERIPH(USARTx));
    CHECK_RESTRICTION(CHECK_USART_Bit9_MODE(NewState));

    /*---------------- USART_CTLRĴTX9SELλ ----------------*/
    if (NewState != USART_BIT9_PAR)
    {
        /* RS-485ģʽ*/
        SFR_SET_BIT_ASM(USARTx->CTLR, USART_CTLR_TX9SEL_POS);
    }
    else
    {
        /* ѡżУ*/
        SFR_CLR_BIT_ASM(USARTx->CTLR, USART_CTLR_TX9SEL_POS);
    }
}

/**
  *   USARTżУѡ
  *   USARTx: ָUSARTڴṹָ룬ȡֵΪUSART0_SFR~USART8_SFR
  *       NewState: ȡֵΪUSART_PARITY_EVEN USART_PARITY_ODD
  *                   USART_PARITY_EVEN :żУ飬
  *                   USART_PARITY_ODD  :У顣
  *   ޡ
  */
void
USART_Parity_Select_Config(USART_SFRmap* USARTx, uint32_t NewState)
{
    /* У */
    CHECK_RESTRICTION(CHECK_USART_ALL_PERIPH(USARTx));
    CHECK_RESTRICTION(CHECK_USART_PARITY(NewState));

    /*---------------- USART_CTLRĴPARMλ ----------------*/
    if (NewState != USART_PARITY_ODD)
    {
        /* żУ*/
        SFR_SET_BIT_ASM(USARTx->CTLR, USART_CTLR_PARM_POS);
    }
    else
    {
        /* У*/
        SFR_CLR_BIT_ASM(USARTx->CTLR, USART_CTLR_PARM_POS);
    }
}

/**
  *   USART9λʹλ
  *   USARTx: ָUSARTڴṹָ룬ȡֵΪUSART0_SFR~USART8_SFR
  *       NewState: USART9λʹ״̬ȡֵΪTRUE  FALSE
  *   ޡ
  */
void
USART_9Data_Enable (USART_SFRmap* USARTx, FunctionalState NewState)
{
    /* У */
    CHECK_RESTRICTION(CHECK_USART_ALL_PERIPH(USARTx));
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

    /*---------------- USART_CTLRĴDT9ENλ ----------------*/
    if (NewState != FALSE)
    {
        /* ʹܵ9λݷͺͽ*/
        SFR_SET_BIT_ASM(USARTx->CTLR, USART_CTLR_DT9EN_POS);
    }
    else
    {
        /* δʹܵ9λݷͺͽ*/
        SFR_CLR_BIT_ASM(USARTx->CTLR, USART_CTLR_DT9EN_POS);
    }
}

/**
  *   USART CTSʹλ
  *   USARTx: ָUSARTڴṹָ룬ȡֵΪUSART0_SFR~USART8_SFR
  *       NewState: USART CTSʹ״̬ȡֵΪTRUE  FALSE
  *   ޡ
  */
void
USART_CTS_Enable (USART_SFRmap* USARTx, FunctionalState NewState)
{
    /* У */
    CHECK_RESTRICTION(CHECK_USART_ALL_PERIPH(USARTx));
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

    /*---------------- USART_CTLRĴCTSENλ ----------------*/
    if (NewState != FALSE)
    {
        /* ʹCTS*/
        SFR_SET_BIT_ASM(USARTx->CTLR, USART_CTLR_CTSEN_POS);
    }
    else
    {
        /* CTS*/
        SFR_CLR_BIT_ASM(USARTx->CTLR, USART_CTLR_CTSEN_POS);
    }
}

/**
  *   USART RTSʹλ
  *   USARTx: ָUSARTڴṹָ룬ȡֵΪUSART0_SFR~USART8_SFR
  *       NewState: USART RTSʹ״̬ȡֵΪTRUE  FALSE
  *   ޡ
  */
void
USART_RTS_Enable(USART_SFRmap* USARTx, FunctionalState NewState)
{
    /* У */
    CHECK_RESTRICTION(CHECK_USART_ALL_PERIPH(USARTx));
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

    /*---------------- USART_CTLRĴRTSENλ ----------------*/
    if (NewState != FALSE)
    {
        /* ʹRTS*/
        SFR_SET_BIT_ASM(USARTx->CTLR, USART_CTLR_RTSEN_POS);
    }
    else
    {
        /* RTS*/
        SFR_CLR_BIT_ASM(USARTx->CTLR, USART_CTLR_RTSEN_POS);
    }
}

/**
  *   USART ʹλ
  *   USARTx: ָUSARTڴṹָ룬ȡֵΪUSART0_SFR~USART8_SFR
  *       NewState: USART ʹ״̬ȡֵΪTRUE  FALSE
  *   ޡ
  */
void
USART_Infrare_Detector_Enable(USART_SFRmap* USARTx, FunctionalState NewState)
{
    /* У */
    CHECK_RESTRICTION(CHECK_USART_ALL_PERIPH(USARTx));
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

    /*---------------- USART_CTLRĴIRDAENλ ----------------*/
    if (NewState != FALSE)
    {
        /* ʹIrDA*/
        SFR_SET_BIT_ASM(USARTx->CTLR, USART_CTLR_IRDAEN_POS);
    }
    else
    {
        /* IrDA*/
        SFR_CLR_BIT_ASM(USARTx->CTLR, USART_CTLR_IRDAEN_POS);
    }
}
/**
  *   USART RESHDλ
  *   USARTx: ָUSARTڴṹָ룬ȡֵΪUSART0_SFR~USART8_SFR
  *       NewState: USART ģʽʹ״̬ȡֵΪTRUE  FALSE
  *   ޡ
  */
void
USART_RESHD_Enable (USART_SFRmap* USARTx, FunctionalState NewState)
{
    /* У */
    CHECK_RESTRICTION(CHECK_USART_ALL_PERIPH(USARTx));
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

    /*---------------- USART_CTLRĴRESHDλ ----------------*/
    if (NewState != FALSE)
    {
        /* ʹܵģʽ*/
        SFR_SET_BIT_ASM(USARTx->CTLR, USART_CTLR_RESHD_POS);
    }
    else
    {
        /* ֹģʽ*/
        SFR_CLR_BIT_ASM(USARTx->CTLR, USART_CTLR_RESHD_POS);
    }
}
/**
  *   USART ģʽʹλ
  *   USARTx: ָUSARTڴṹָ룬ȡֵΪUSART0_SFR~USART8_SFR
  *       NewState: USART ģʽʹ״̬ȡֵΪTRUE  FALSE
  *   ޡ
  */
void
USART_Singlet_Line_Mode_Enable (USART_SFRmap* USARTx, FunctionalState NewState)
{
    /* У */
    CHECK_RESTRICTION(CHECK_USART_ALL_PERIPH(USARTx));
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

    /*---------------- USART_CTLRĴSLMENλ ----------------*/
    if (NewState != FALSE)
    {
        /* ʹܵģʽ*/
        SFR_SET_BIT_ASM(USARTx->CTLR, USART_CTLR_SLMEN_POS);
    }
    else
    {
        /* ֹģʽ*/
        SFR_CLR_BIT_ASM(USARTx->CTLR, USART_CTLR_SLMEN_POS);
    }
}

/**
  *   USART USARTDIV֡
  *   USARTx: ָUSARTڴṹָ룬ȡֵΪUSART0_SFR~USART8_SFR
  *       DIV: ȡֵΧΪ0~65535
  *   ޡ
  */
void
USART_BaudRate_Integer_Config(USART_SFRmap* USARTx, uint16_t DIV)
{
    uint32_t tmpreg = 0;

    /* У */
    CHECK_RESTRICTION(CHECK_USART_ALL_PERIPH(USARTx));

    /*---------------- USART_BRGRĴBRGMλ ----------------*/
    tmpreg = DIV << USART_BRGR_BRGM0_POS;
    USARTx->BRGR = SFR_Config (USARTx->BRGR, ~USART_BRGR_BRGM, tmpreg);
}

/**
  *   USART Сʷӡ
  *   USARTx: ָUSARTڴṹָ룬ȡֵΪUSART0_SFR~USART8_SFR
  *       DIV: ȡֵΧΪ0~15
  *   ޡ
  */
void
USART_BaudRate_Decimal1_Config(USART_SFRmap* USARTx, uint32_t DIV)
{
    uint32_t tmpreg = 0;

    /* У */
    CHECK_RESTRICTION(CHECK_USART_ALL_PERIPH(USARTx));
    CHECK_RESTRICTION(CHECK_USART_BAUDRATE_DECIMAL(DIV));

    /*---------------- USART_BRGRĴBRGF1λ ----------------*/
    tmpreg = DIV << USART_BRGR_BRGF1_0_POS ;
    USARTx->BRGR = SFR_Config (USARTx->BRGR, ~USART_BRGR_BRGF1, tmpreg);
}

/**
  *   USART Сʷĸ
  *   USARTx: ָUSARTڴṹָ룬ȡֵΪUSART0_SFR~USART8_SFR
  *       DIV: ȡֵΧΪ0~15
  *   ޡ
  */
void
USART_BaudRate_Decimal2_Config(USART_SFRmap* USARTx, uint32_t DIV)
{
    uint32_t tmpreg = 0;

    /* У */
    CHECK_RESTRICTION(CHECK_USART_ALL_PERIPH(USARTx));
    CHECK_RESTRICTION(CHECK_USART_BAUDRATE_DECIMAL(DIV));

    /*---------------- USART_BRGRĴBRGF2λ ----------------*/
    tmpreg = DIV << USART_BRGR_BRGF2_0_POS ;
    USARTx->BRGR = SFR_Config (USARTx->BRGR, ~USART_BRGR_BRGF2, tmpreg);
}

/**
  *   USARTݡ
  *   USARTx: ָUSARTڴṹָ룬ȡֵΪUSART0_SFR~USART8_SFR
  *       Data: дݼĴֵȡֵΪ0~255
  */
void
USART_SendData(USART_SFRmap* USARTx, uint8_t Data)
{
    /* У */
    CHECK_RESTRICTION(CHECK_USART_ALL_PERIPH(USARTx));

    /*---------------- USART_TBUFRĴ ----------------*/
    USARTx->TBUFR = Data;
}

/**
  *   USARTֽ,ȴͻա
  *   USARTx: ָUSARTڴṹָ룬ȡֵΪUSART0_SFR~USART8_SFR
  *       Data: дݼĴֵȡֵΪ0~255
  */
void
USART_TransmitData(USART_SFRmap* USARTx, uint8_t Data)
{
    /* У */
    CHECK_RESTRICTION(CHECK_USART_ALL_PERIPH(USARTx));
    /*---------------- 	ȴΪ	----------------*/
     while(!(USARTx->STR & USART_STR_TXEIF));
    /*---------------- USART_TBUFRĴ ----------------*/
    USARTx->TBUFR = Data;
}

/**
  *   USARTݡ
  *   USARTx: ָUSARTڴṹָ룬ȡֵΪUSART0_SFR~USART8_SFR
  *   32λݵ8λݡ
  */
uint32_t
USART_ReceiveData(USART_SFRmap* USARTx)
{
    /* У */
    CHECK_RESTRICTION(CHECK_USART_ALL_PERIPH(USARTx));

    /*---------------- USART_RBUFRĴ ----------------*/
    return USARTx->RBUFR;
}

/**
  *    USARTxַƥ书λ
  *   USARTx: ָUSARTڴṹָ룬ȡֵΪUSART0_SFR~USART8_SFR
  *       address: USARTxַƥ书ܣȡֵΧΪ0~255
  *   ޡ
  */
void
USART_Address_Match_Config(USART_SFRmap* USARTx, uint8_t DIV)
{
    uint32_t tmpreg = 0;

    /* У */
    CHECK_RESTRICTION(CHECK_USART_ALL_PERIPH(USARTx));

    /*---------------- USART_ADMĴADMλ ----------------*/
    tmpreg = DIV << USART_ADM_ADM0_POS;
    USARTx->ADM = SFR_Config (USARTx->ADM, ~USART_ADM_ADM, tmpreg);
}

/**
  *   USARTȫ˫ģʽʱͿ֡ʹܡ
  *   USARTx: ָUSARTڴṹָ룬ȡֵΪUSART0_SFR~USART8_SFR
  *      NewState:  TRUE: ʹܷͿ֡
  *      			FALSE: ֹͿ֡
  *   ޡ
  */
void
USART_Send_Idle_Frame_Enable(USART_SFRmap* USARTx, FunctionalState NewState)
{
	uint32_t tmpreg = 0;

    /* У */
    CHECK_RESTRICTION(CHECK_USART_ALL_PERIPH(USARTx));
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

    tmpreg = NewState << USART_CTLR_TIDLEEN_POS;
    USARTx->CTLR = SFR_Config(USARTx->CTLR, ~USART_CTLR_TIDLEEN, tmpreg);
}

/**
  *   USARTտ֡жϱ־ģʽ
  *   USARTx: ָUSARTڴṹָ룬ȡֵΪUSART0_SFR~USART8_SFR
  *      NewState:  TRUE: ֡жϱ־ RDRIF ޹
  *      			FALSE: ֡жϱ־ RDRIF йء
  *   ޡ
  */
void
USART_Receive_Idle_Frame_Config(USART_SFRmap* USARTx, FunctionalState NewState)
{
	uint32_t tmpreg = 0;

    /* У */
    CHECK_RESTRICTION(CHECK_USART_ALL_PERIPH(USARTx));
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

    tmpreg = NewState << USART_CTLR_RIDLES_POS;
    USARTx->CTLR = SFR_Config(USARTx->CTLR, ~USART_CTLR_RIDLES, tmpreg);
}

/**
  *   ##### USARTģ(USART)ú #####
  */


/**
  *   ##### USARTģ(USART)7816ʼú #####
  */
/**
  *   USART 7816ģʽʹܿơ
  *   USARTx: ָUSARTڴṹָ룬ȡֵΪUSART0_SFR~USART8_SFR
  *       NewState: USART 7816ģʽʹ״̬ȡֵΪTRUE  FALSE
  *   ޡ
  */
void
USART_7816_Cmd(USART_SFRmap* USARTx, FunctionalState NewState)
{
    /* У */
    CHECK_RESTRICTION(CHECK_USART_ALL_PERIPH(USARTx));
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

    /*---------------- USART_U7816RĴ7816ENλ ----------------*/
    if (NewState != FALSE)
    {
        /* ʹ7816ģʽ*/
        SFR_SET_BIT_ASM(USARTx->U7816R, USART_U7816R_7816EN_POS);
    }
    else
    {
        /* 7816ģʽ*/
        SFR_CLR_BIT_ASM(USARTx->U7816R, USART_U7816R_7816EN_POS);
    }
}

/**
  *   USART 7816ʱʹܡ
  *   USARTx: ָUSARTڴṹָ룬ȡֵΪUSART0_SFR~USART8_SFR
  *       NewState: USART 7816ʱʹ״̬ȡֵΪTRUE  FALSE
  *   ޡ
  */
void
USART_7816_CLKOUT_Enable (USART_SFRmap* USARTx, FunctionalState NewState)
{
    /* У */
    CHECK_RESTRICTION(CHECK_USART_ALL_PERIPH(USARTx));
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

    /*---------------- USART_U7816RĴCLKOUTλ ----------------*/
    if (NewState != FALSE)
    {
        /* ʹʱ*/
        SFR_SET_BIT_ASM(USARTx->U7816R, USART_U7816R_CLKOUT_POS);
    }
    else
    {
        /* ֹʱ*/
        SFR_CLR_BIT_ASM(USARTx->U7816R, USART_U7816R_CLKOUT_POS);
    }
}

/**
  *   USART 7816 error signalѡ
  *   USARTx: ָUSARTڴṹָ룬ȡֵΪUSART0_SFR~USART8_SFR
  *       signal: ѡȡֵΧΪ
  *                 USART_U7816R_ERRORSIGNAL_2ETU   : 2etu
  *                 USART_U7816R_ERRORSIGNAL_1P5ETU : 1.5etu
  *                 USART_U7816R_ERRORSIGNAL_1ETU   : 1etu
  *   ޡ
  */
void
USART_7816_Error_Signal_Config (USART_SFRmap* USARTx, uint32_t ERRORSIGNAL)
{
    /* У */
    CHECK_RESTRICTION(CHECK_USART_ALL_PERIPH(USARTx));
    CHECK_RESTRICTION(CHECK_U7816R_ERRORSIGNAL(ERRORSIGNAL));

    /*---------------- USART_U7816RĴERSWλ ----------------*/
    USARTx->U7816R = SFR_Config (USARTx->U7816R, ~USART_U7816R_ERSW, ERRORSIGNAL);
}

/**
  *   USART ͨѡ
  *   USARTx: ָUSARTڴṹָ룬ȡֵΪUSART0_SFR~USART8_SFR
  *       NewState: ȡֵΪUSART_U7816R_PASSAGEWAY_TX1   USART_U7816R_PASSAGEWAY_TX0
  *                   USART_U7816R_PASSAGEWAY_TX1 :ѡͨ1(TX1)
  *                   USART_U7816R_PASSAGEWAY_TX0 :ѡͨ0(TX0)
  *   ޡ
  */
void
USART_Passageway_Select_Config(USART_SFRmap* USARTx, uint32_t NewState)
{
    /* У */
    CHECK_RESTRICTION(CHECK_USART_ALL_PERIPH(USARTx));
    CHECK_RESTRICTION(CHECK_U7816R_PASSAGEWAY_SELECT(NewState));

    /*---------------- USART_U7816RĴPSELλ ----------------*/
    if (NewState != USART_U7816R_PASSAGEWAY_TX0)
    {
        /* ѡͨ1(TX1)*/
        SFR_SET_BIT_ASM(USARTx->U7816R, USART_U7816R_PSEL_POS);
    }
    else
        {
        /* ѡͨ0(TX0)*/
        SFR_CLR_BIT_ASM(USARTx->U7816R, USART_U7816R_PSEL_POS);
    }
}

/**
  *   USART ƽյ֮ǷBGT
  *   USARTx: ָUSARTڴṹָ룬ȡֵΪUSART0_SFR~USART8_SFR
  *       NewState: ȡֵΪTRUE  FALSE
  *                   TRUE:BGTΪ22etu
  *                   FALSE:BGT
  *   ޡ
  */
void
USART_BGT_Config(USART_SFRmap* USARTx, FunctionalState NewState)
{
    /* У */
    CHECK_RESTRICTION(CHECK_USART_ALL_PERIPH(USARTx));
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

    /*---------------- USART_U7816RĴBGTλ ----------------*/
    if (NewState != FALSE)
    {
        /* BGTΪ22etu*/
        SFR_SET_BIT_ASM(USARTx->U7816R, USART_U7816R_BGTEN_POS);
    }
    else
    {
        /* BGT*/
        SFR_CLR_BIT_ASM(USARTx->U7816R, USART_U7816R_BGTEN_POS);
    }
}
/**
  *   USART طʹܿơ
  *   USARTx: ָUSARTڴṹָ룬ȡֵΪUSART0_SFR~USART8_SFR
  *       NewState: ȡֵΪTRUE  FALSE
  *                   TRUE:յУźźطﵽжϣ
  *                   FALSE:յУźźֱӽж
  *   ޡ
  */
void
USART_Transmit_Repeat_Enable(USART_SFRmap* USARTx, FunctionalState NewState)
{
    /* У */
    CHECK_RESTRICTION(CHECK_USART_ALL_PERIPH(USARTx));
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

    /*---------------- USART_U7816RĴTREPENλ ----------------*/
    if (NewState != FALSE)
    {
        /* յУźźطﵽж*/
        SFR_SET_BIT_ASM(USARTx->U7816R, USART_U7816R_TREPEN_POS);
    }
    else
    {
        /* յУźźֱӽж*/
        SFR_CLR_BIT_ASM(USARTx->U7816R, USART_U7816R_TREPEN_POS);
    }
}

/**
  *   USART ʹܿơ
  *   USARTx: ָUSARTڴṹָ룬ȡֵΪUSART0_SFR~USART8_SFR
  *       NewState: ȡֵΪTRUE  FALSE
  *               TRUE:żУݣﵽжϣ
  *               FALSE:żУֱӽж
  *   ޡ
  */
void
USART_Receive_Repeat_Enable(USART_SFRmap* USARTx, FunctionalState NewState)
{
    /* У */
    CHECK_RESTRICTION(CHECK_USART_ALL_PERIPH(USARTx));
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

    /*---------------- USART_U7816RĴRREPENλ ----------------*/
    if (NewState != FALSE)
    {
        /* żУݣﵽж*/
        SFR_SET_BIT_ASM(USARTx->U7816R, USART_U7816R_RREPEN_POS);
    }
    else
    {
        /* żУֱӽж*/
        SFR_CLR_BIT_ASM(USARTx->U7816R, USART_U7816R_RREPEN_POS);
    }
}

/**
  *   USART żУʱط͵
  *   USARTx: ָUSARTڴṹָ룬ȡֵΪUSART0_SFR~USART8_SFR
  *       SELECT: ѡȡֵΧΪ
  *                 USART_U7816R_TRANSMIT_REPEAT_0S: մΪ0
  *                 USART_U7816R_TRANSMIT_REPEAT_1S: մΪ1
  *                 USART_U7816R_TRANSMIT_REPEAT_2S: մΪ2
  *                 USART_U7816R_TRANSMIT_REPEAT_3S: մΪ3
  *   ޡ
  */
void
USART_Transmit_Repeat_Times_Config(USART_SFRmap* USARTx, uint32_t SELECT)
{
    /* У */
    CHECK_RESTRICTION(CHECK_USART_ALL_PERIPH(USARTx));
    CHECK_RESTRICTION(CHECK_U7816R_TRANSMIT_REPEAT(SELECT));

    /*---------------- USART_U7816RĴTXREλ ----------------*/
    USARTx->U7816R = SFR_Config (USARTx->U7816R, ~USART_U7816R_TXRE, SELECT);
}

/**
  *   USART żУʱؽյ
  *   USARTx: ָUSARTڴṹָ룬ȡֵΪUSART0_SFR~USART8_SFR
  *       SELECT: ѡȡֵΧΪ
  *                 USART_U7816R_RECEIVE_REPEAT_0S: մΪ0
  *                 USART_U7816R_RECEIVE_REPEAT_1S: մΪ1
  *                 USART_U7816R_RECEIVE_REPEAT_2S: մΪ2
  *                 USART_U7816R_RECEIVE_REPEAT_3S: մΪ3
  *   ޡ
  */
void
USART_Receive_Repeat_Times_Config(USART_SFRmap* USARTx, uint32_t SELECT)
{
    /* У */
    CHECK_RESTRICTION(CHECK_USART_ALL_PERIPH(USARTx));
    CHECK_RESTRICTION(CHECK_U7816R_RECEIVE_REPEAT(SELECT));

    /*---------------- USART_U7816RĴRXREλ ----------------*/
    USARTx->U7816R = SFR_Config (USARTx->U7816R, ~USART_U7816R_RXRE, SELECT);
}

/**
  *   USART 7816ʱӺʱӿơ
  *   USARTx: ָUSARTڴṹָ룬ȡֵΪUSART0_SFR~USART8_SFR
  *       CLKDIV: ȡֵΧΪ0~255
  *   ޡ
  */
void
USART_7816_CLKDIV_Config (USART_SFRmap* USARTx, uint8_t DIV)
{
    uint32_t tmpreg = 0;

    /* У */
    CHECK_RESTRICTION(CHECK_USART_ALL_PERIPH(USARTx));

    /*---------------- USART_U7816RĴλCLKDIV ----------------*/
    tmpreg = DIV << USART_U7816R_CLKDIV0_POS;
    USARTx->U7816R = SFR_Config (USARTx->U7816R, ~USART_U7816R_CLKDIV, tmpreg);
}

/**
  *   USART 7816ʱEGT(extra guard time)λetu
  *   USARTx: ָUSARTڴṹָ룬ȡֵΪUSART0_SFR~USART8_SFR
  *       EGT: ȡֵΧΪ0~255
  *   ޡ
  */
void
USART_7816_EGT_Config(USART_SFRmap* USARTx, uint8_t EGT)
{
    uint32_t tmpreg = 0;

    /* У */
    CHECK_RESTRICTION(CHECK_USART_ALL_PERIPH(USARTx));

    /*---------------- USART_U7816RĴλEGT ----------------*/
    tmpreg = EGT << USART_U7816R_EGT0_POS;
    USARTx->U7816R = SFR_Config (USARTx->U7816R, ~USART_U7816R_EGT, tmpreg);
}

/**
  *   USART 7816طģʽѡ
  *   USARTx: ָUSARTڴṹָ룬ȡֵΪUSART0_SFR~USART8_SFR
  *       NewState: FALSE:ֻҪյ֡ط
  *       			TRUE: طôֹͣط
  *   ޡ
  */
void
USART_7816_Resend_Mode_Select(USART_SFRmap* USARTx, FunctionalState NewState)
{
    uint32_t tmpreg = 0;

    /* У */
    CHECK_RESTRICTION(CHECK_USART_ALL_PERIPH(USARTx));

    /*---------------- USART_U7816RĴλTREPMS ----------------*/
    tmpreg = NewState << USART_U7816R_TREPMS_POS;
    USARTx->U7816R = SFR_Config (USARTx->U7816R, ~USART_U7816R_TREPMS, tmpreg);
}

/**
  *   ##### USARTģ(USART)7816ʼú #####
  */


/**
  *   ##### USARTģ(USART)жϹ #####
  */
/**
  *   USARTжʹܡ
  *   USARTx: ָUSARTڴṹָ룬ȡֵΪUSART0_SFR~USART8_SFR
  *       NewState: USARTжʹ״̬ȡֵΪTRUE  FALSE
  *   ޡ
  */
void
USART_Receive_Overflow_INT_Enable (USART_SFRmap* USARTx,
                    FunctionalState NewState)
{
    /* У */
    CHECK_RESTRICTION(CHECK_USART_ALL_PERIPH(USARTx));
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

    /*---------------- USART_IERĴOVFEIEλ ----------------*/
    if (NewState != FALSE)
    {
        /* ʹUSARTж */
        SFR_SET_BIT_ASM(USARTx->IER, USART_IER_OVFEIE_POS);
    }
    else
    {
        /* ֹUSARTж */
        SFR_CLR_BIT_ASM(USARTx->IER, USART_IER_OVFEIE_POS);
    }
}

/**
  *   USARTżУжʹܡ
  *   USARTx: ָUSARTڴṹָ룬ȡֵΪUSART0_SFR~USART8_SFR
  *       NewState: USARTżУжʹ״̬ȡֵΪTRUE  FALSE
  *   ޡ
  */
void
USART_Parity_ERROR_INT_Enable (USART_SFRmap* USARTx, FunctionalState NewState)
{
    /* У */
    CHECK_RESTRICTION(CHECK_USART_ALL_PERIPH(USARTx));
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

    /*---------------- USART_IERĴPAREIEλ ----------------*/
    if (NewState != FALSE)
    {
        /* ʹUSARTżУжλ */
        SFR_SET_BIT_ASM(USARTx->IER, USART_IER_PAREIE_POS);
    }
    else
    {
        /* ֹUSARTżУж */
        SFR_CLR_BIT_ASM(USARTx->IER, USART_IER_PAREIE_POS);
    }
}

/**
  *   USART֡жʹܡ
  *   USARTx: ָUSARTڴṹָ룬ȡֵΪUSART0_SFR~USART8_SFR
  *       NewState: USART֡жʹ״̬ȡֵΪTRUE  FALSE
  *   ޡ
  */
void
USART_Frame_ERROE_INT_Enable (USART_SFRmap* USARTx, FunctionalState NewState)
{
    /* У */
    CHECK_RESTRICTION(CHECK_USART_ALL_PERIPH(USARTx));
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

    /*---------------- USART_IERĴFREIEλ ----------------*/
    if (NewState != FALSE)
    {
        /* ʹUSART֡жλ */
        SFR_SET_BIT_ASM(USARTx->IER, USART_IER_FREIE_POS);
    }
    else
    {
        /* ֹUSART֡ж */
        SFR_CLR_BIT_ASM(USARTx->IER, USART_IER_FREIE_POS);
    }
}

/**
  *   USARTλжʹܡ
  *   USARTx: ָUSARTڴṹָ룬ȡֵΪUSART0_SFR~USART8_SFR
  *       NewState: USARTλжʹ״̬ȡֵΪTRUE  FALSE
  *   ޡ
  */
void
USART_Blank_INT_Enable (USART_SFRmap* USARTx, FunctionalState NewState)
{
    /* У */
    CHECK_RESTRICTION(CHECK_USART_ALL_PERIPH(USARTx));
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

    /*---------------- USART_IERĴBRIEλ ----------------*/
    if (NewState != FALSE)
    {
        /* ʹUSARTλжλ */
        SFR_SET_BIT_ASM(USARTx->IER, USART_IER_BRIE_POS);
    }
    else
    {
        /* ֹUSARTλж */
        SFR_CLR_BIT_ASM(USARTx->IER, USART_IER_BRIE_POS);
    }
}

/**
  *   USARTԶʳʱжʹܡ
  *   USARTx: ָUSARTڴṹָ룬ȡֵΪUSART0_SFR~USART8_SFR
  *       NewState: USARTԶʳʱжʹ״̬ȡֵΪTRUE  FALSE
  *   ޡ
  */
void
USART_Auto_BaudRate_TimeOver_INT_Enable (USART_SFRmap* USARTx,
                    FunctionalState NewState)
{
    /* У */
    CHECK_RESTRICTION(CHECK_USART_ALL_PERIPH(USARTx));
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

    /*---------------- USART_IERĴBRIEλ ----------------*/
    if (NewState != FALSE)
    {
        /* ʹUSARTԶʳʱжλ */
        SFR_SET_BIT_ASM(USARTx->IER, USART_IER_ABTOIE_POS);
    }
    else
    {
        /* ֹUSARTԶʳʱж */
        SFR_CLR_BIT_ASM(USARTx->IER, USART_IER_ABTOIE_POS);
    }
}

/**
  *   USARTԶжʹܡ
  *   USARTx: ָUSARTڴṹָ룬ȡֵΪUSART0_SFR~USART8_SFR
  *       NewState: USARTԶжʹ״̬ȡֵΪTRUE  FALSE
  *   ޡ
  */
void
USART_WeakUP_INT_Enable (USART_SFRmap* USARTx, FunctionalState NewState)
{
    /* У */
    CHECK_RESTRICTION(CHECK_USART_ALL_PERIPH(USARTx));
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

    /*---------------- USART_IERĴWUIEλ ----------------*/
    if (NewState != FALSE)
    {
        /* ʹUSARTԶжλ */
        SFR_SET_BIT_ASM(USARTx->IER, USART_IER_WUIE_POS);
    }
    else
    {
        /* ֹUSARTԶж */
        SFR_CLR_BIT_ASM(USARTx->IER, USART_IER_WUIE_POS);
    }
}

/**
  *   USART7816ʹжʹܡ
  *   USARTx: ָUSARTڴṹָ룬ȡֵΪUSART0_SFR~USART8_SFR
  *       NewState: USART7816ʹжʹ״̬ȡֵΪTRUE  FALSE
  *   ޡ
  */
void
USART_Transmit_ERROR_INT_Enable (USART_SFRmap* USARTx, FunctionalState NewState)
{
    /* У */
    CHECK_RESTRICTION(CHECK_USART_ALL_PERIPH(USARTx));
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

    /*---------------- USART_IERĴTEIEλ ----------------*/
    if (NewState != FALSE)
    {
        /* ʹUSART7816ʹжλ */
        SFR_SET_BIT_ASM(USARTx->IER, USART_IER_TEIE_POS);
    }
    else
    {
        /* ֹUSART7816ʹж */
        SFR_CLR_BIT_ASM(USARTx->IER, USART_IER_TEIE_POS);
    }
}

/**
  *   USART7816մжʹܡ
  *   USARTx: ָUSARTڴṹָ룬ȡֵΪUSART0_SFR~USART8_SFR
  *       NewState: USART7816մжʹ״̬ȡֵΪTRUE  FALSE
  *   ޡ
  */
void
USART_Receive_ERROR_INT_Enable (USART_SFRmap* USARTx, FunctionalState NewState)
{
    /* У */
    CHECK_RESTRICTION(CHECK_USART_ALL_PERIPH(USARTx));
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

    /*---------------- USART_IERĴREIEλ ----------------*/
    if (NewState != FALSE)
    {
        /* ʹUSART7816մжλ */
        SFR_SET_BIT_ASM(USARTx->IER, USART_IER_REIE_POS);
    }
    else
    {
        /* ֹUSART7816մж */
        SFR_CLR_BIT_ASM(USARTx->IER, USART_IER_REIE_POS);
    }
}

/**
  *   USART CTSжʹܡ
  *   USARTx: ָUSARTڴṹָ룬ȡֵΪUSART0_SFR~USART8_SFR
  *       NewState: USART CTSжʹ״̬ȡֵΪTRUE  FALSE
  *   ޡ
  */
void
USART_CTS_INT_Enable (USART_SFRmap* USARTx, FunctionalState NewState)
{
    /* У */
    CHECK_RESTRICTION(CHECK_USART_ALL_PERIPH(USARTx));
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

    /*---------------- USART_IERĴCTSIEλ ----------------*/
    if (NewState != FALSE)
    {
        /* ʹUSART CTSжλ */
        SFR_SET_BIT_ASM(USARTx->IER, USART_IER_CTSIE_POS);
    }
    else
    {
        /* ֹUSART CTSж */
        SFR_CLR_BIT_ASM(USARTx->IER, USART_IER_CTSIE_POS);
    }
}

/**
  *   USART RDRжʹܡ
  *   USARTx: ָUSARTڴṹָ룬ȡֵΪUSART0_SFR~USART8_SFR
  *       NewState: USART RDRжʹ״̬ȡֵΪTRUE  FALSE
  *   ޡ
  */
void
USART_RDR_INT_Enable (USART_SFRmap* USARTx, FunctionalState NewState)
{
    /* У */
    CHECK_RESTRICTION(CHECK_USART_ALL_PERIPH(USARTx));
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

    /*---------------- USART_IERĴRDRIEλ ----------------*/
    if (NewState != FALSE)
    {
        /* ʹUSART RDRжλ */
        SFR_SET_BIT_ASM(USARTx->IER, USART_IER_RDRIE_POS);
    }
    else
    {
        /* ֹUSART RDRж */
        SFR_CLR_BIT_ASM(USARTx->IER, USART_IER_RDRIE_POS);
    }
}

/**
  *   USART TFEжʹܡ
  *   USARTx: ָUSARTڴṹָ룬ȡֵΪUSART0_SFR~USART8_SFR
  *       NewState: USART TFEжʹ״̬ȡֵΪTRUE  FALSE
  *   ޡ
  */
void
USART_TFE_INT_Enable (USART_SFRmap* USARTx, FunctionalState NewState)
{
    /* У */
    CHECK_RESTRICTION(CHECK_USART_ALL_PERIPH(USARTx));
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

    /*---------------- USART_IERĴTFEIEλ ----------------*/
    if (NewState != FALSE)
    {
        /* ʹUSART TFEжλ */
        SFR_SET_BIT_ASM(USARTx->IER, USART_IER_TFEIE_POS);
    }
    else
    {
        /* ֹUSART TFEж */
        SFR_CLR_BIT_ASM(USARTx->IER, USART_IER_TFEIE_POS);
    }
}

/**
  *   USART TXEжʹܡ
  *   USARTx: ָUSARTڴṹָ룬ȡֵΪUSART0_SFR~USART8_SFR
  *       NewState: USART TXEжʹ״̬ȡֵΪTRUE  FALSE
  *   ޡ
  */
void
USART_TXE_INT_Enable (USART_SFRmap* USARTx, FunctionalState NewState)
{
    /* У */
    CHECK_RESTRICTION(CHECK_USART_ALL_PERIPH(USARTx));
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

    /*---------------- USART_IERĴTXEIEλ ----------------*/
    if (NewState != FALSE)
    {
        /* ʹUSART TXEжλ */
        SFR_SET_BIT_ASM(USARTx->IER, USART_IER_TXEIE_POS);
    }
    else
    {
        /* ֹUSART TXEж */
        SFR_CLR_BIT_ASM(USARTx->IER, USART_IER_TXEIE_POS);
    }
}

/**
  *   USART DMAжʹܡ
  *   USARTx: ָUSARTڴṹָ룬ȡֵΪUSART0_SFR~USART8_SFR
  *       NewState: USART DMAжʹ״̬ȡֵΪTRUE  FALSE
  *   ޡ
  */
void
USART_Receive_DMA_INT_Enable (USART_SFRmap* USARTx, FunctionalState NewState)
{
    /* У */
    CHECK_RESTRICTION(CHECK_USART_ALL_PERIPH(USARTx));
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

    /*---------------- USART_IERĴURCDEλ ----------------*/
    if (NewState != FALSE)
    {
        /* ʹUSART DMAжλ */
        SFR_SET_BIT_ASM(USARTx->IER, USART_IER_URCDE_POS);
    }
    else
    {
        /* ֹUSART DMAж */
        SFR_CLR_BIT_ASM(USARTx->IER, USART_IER_URCDE_POS);
    }
}

/**
  *   USART DMAжʹܡ
  *   USARTx: ָUSARTڴṹָ룬ȡֵΪUSART0_SFR~USART8_SFR
  *       NewState: USART DMAжʹ״̬ȡֵΪTRUE  FALSE
  *   ޡ
  */
void
USART_Transmit_DMA_INT_Enable (USART_SFRmap* USARTx, FunctionalState NewState)
{
    /* У */
    CHECK_RESTRICTION(CHECK_USART_ALL_PERIPH(USARTx));
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

    /*---------------- USART_IERĴUTXDEλ ----------------*/
    if (NewState != FALSE)
    {
        /* ʹUSART DMAжλ */
        SFR_SET_BIT_ASM(USARTx->IER, USART_IER_UTXDE_POS);
    }
    else
    {
        /* ֹUSART DMAж */
        SFR_CLR_BIT_ASM(USARTx->IER, USART_IER_UTXDE_POS);
    }
}

/**
  *   USART IDLEIF жʹܡ
  *   USARTx: ָUSARTڴṹָ룬ȡֵΪUSART0_SFR~USART8_SFR
  *       NewState: USART жʹ״̬ȡֵΪTRUE  FALSE
  *   ޡ
  */
void
USART_IDLE_INT_Enable(USART_SFRmap* USARTx, FunctionalState NewState)
{
    /* У */
    CHECK_RESTRICTION(CHECK_USART_ALL_PERIPH(USARTx));
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

    /*---------------- USART_IERĴIDLEIEλ ----------------*/
    if (NewState != FALSE)
    {
        /* ʹUSART IDLEIEжλ */
        SFR_SET_BIT_ASM(USARTx->IER, USART_IER_IDLEIE_POS);
    }
    else
    {
        /* ֹUSART IDLEIEж */
        SFR_CLR_BIT_ASM(USARTx->IER, USART_IER_IDLEIE_POS);
    }
}

/**
  *   USART UADMIF жʹܡ
  *   USARTx: ָUSARTڴṹָ룬ȡֵΪUSART0_SFR~USART8_SFR
  *       NewState: USART жʹ״̬ȡֵΪTRUE  FALSE
  *   ޡ
  */
void
USART_UADM_INT_Enable(USART_SFRmap* USARTx, FunctionalState NewState)
{
    /* У */
    CHECK_RESTRICTION(CHECK_USART_ALL_PERIPH(USARTx));
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

    /*---------------- USART_IERĴUADMIEλ ----------------*/
    if (NewState != FALSE)
    {
        /* ʹUSART UADMIEжλ */
        SFR_SET_BIT_ASM(USARTx->IER, USART_IER_UADMIE_POS);
    }
    else
    {
        /* ֹUSART UADMIEж */
        SFR_CLR_BIT_ASM(USARTx->IER, USART_IER_UADMIE_POS);
    }
}

/**
  *   ȡUSARTжϱ־״̬ 
  *   USARTx: ָUSARTڴṹָ룬ȡֵΪUSART0_SFR~USART8_SFR
  *   1: USART
  *       0: USARTûн
  */
FlagStatus
USART_Get_Receive_Overflow_Flag (USART_SFRmap* USARTx)
{
    /* У */
    CHECK_RESTRICTION(CHECK_USART_ALL_PERIPH(USARTx));

    /*---------------- ȡUSART_STRĴOVFEIFλ ----------------*/
    if (USARTx->STR & USART_STR_OVFEIF)
    {
        /* USART */
        return SET;
    }
    else
    {
        /* USARTûн */
        return RESET;
    }
}

/**
  *   ȡUSARTżУжϱ־״̬ 
  *   USARTx: ָUSARTڴṹָ룬ȡֵΪUSART0_SFR~USART8_SFR
  *   1: USARTżУ
  *       0: USARTûн
  */
FlagStatus
USART_Get_Parity_ERROR_Flag (USART_SFRmap* USARTx)
{
    /* У */
    CHECK_RESTRICTION(CHECK_USART_ALL_PERIPH(USARTx));

    /*---------------- ȡUSART_STRĴPAREIFλ ----------------*/
    if (USARTx->STR & USART_STR_PAREIF)
    {
        /* USARTżУ */
        return SET;
    }
    else
    {
        /* USARTżУδ */
        return RESET;
    }
}

/**
  *   ȡUSART֡жϱ־״̬ 
  *   USARTx: ָUSARTڴṹָ룬ȡֵΪUSART0_SFR~USART8_SFR
  *   1: USARTʱ֡
  *       0: USARTʱδ֡
  */
FlagStatus
USART_Get_Frame_ERROR_Flag (USART_SFRmap* USARTx)
{
    /* У */
    CHECK_RESTRICTION(CHECK_USART_ALL_PERIPH(USARTx));

    /*---------------- ȡUSART_STRĴFREIFλ ----------------*/
    if (USARTx->STR & USART_STR_FREIF)
    {
        /* USARTʱ֡ */
        return SET;
    }
    else
    {
        /* USARTʱδ֡ */
        return RESET;
    }
}

/**
  *   ȡUSARTжϱ־״̬ 
  *   USARTx: ָUSARTڴṹָ룬ȡֵΪUSART0_SFR~USART8_SFR
  *   1: USARTյַ
  *       0: USARTδַܵ
  */
FlagStatus
USART_Get_Blank_Flag (USART_SFRmap* USARTx)
{
    /* У */
    CHECK_RESTRICTION(CHECK_USART_ALL_PERIPH(USARTx));

    /*---------------- ȡUSART_STRĴBRIFλ ----------------*/
    if (USARTx->STR & USART_STR_BRIF)
    {
        /* USARTյַ */
        return SET;
    }
    else
    {
        /* USARTδַܵ */
        return RESET;
    }
}

/**
  *   ȡUSARTԶʳʱжϱ־״̬ 
  *   USARTx: ָUSARTڴṹָ룬ȡֵΪUSART0_SFR~USART8_SFR
  *   1: USARTԶʳʱ
  *       0: USARTԶδʱ
  */
FlagStatus
USART_Get_Auto_Baudrate_TimeOver_Flag (USART_SFRmap* USARTx)
{
    /* У */
    CHECK_RESTRICTION(CHECK_USART_ALL_PERIPH(USARTx));

    /*---------------- ȡUSART_STRĴABTOIFλ ----------------*/
    if (USARTx->STR & USART_STR_ABTOIF)
    {
        /* USARTԶʳʱ */
        return SET;
    }
    else
    {
        /* USARTԶδʱ */
        return RESET;
    }
}

/**
  *   ȡUSARTԶжϱ־״̬ 
  *   USARTx: ָUSARTڴṹָ룬ȡֵΪUSART0_SFR~USART8_SFR
  *   1: USARTԶ¼
  *       0: USARTδԶ¼
  */
FlagStatus
USART_Get_WeakUP_Flag (USART_SFRmap* USARTx)
{
    /* У */
    CHECK_RESTRICTION(CHECK_USART_ALL_PERIPH(USARTx));

    /*---------------- ȡUSART_STRĴWUIFλ ----------------*/
    if (USARTx->STR & USART_STR_WUIF)
    {
        /* USARTԶ¼*/
        return SET;
    }
    else
    {
        /* USARTδԶ¼ */
        return RESET;
    }
}

/**
  *   ȡUSART 7816ʹжϱ־״̬ 
  *   USARTx: ָUSARTڴṹָ룬ȡֵΪUSART0_SFR~USART8_SFR
  *   1: USART7816ʹжϣ
  *       0: USARTδ7816ʹжϡ
  */
FlagStatus
USART_Get_7816Transmit_ERROR_Flag (USART_SFRmap* USARTx)
{
    /* У */
    CHECK_RESTRICTION(CHECK_USART_ALL_PERIPH(USARTx));

    /*---------------- ȡUSART_STRĴTEIFλ ----------------*/
    if (USARTx->STR & USART_STR_TEIF)
    {
        /* USART 7816ʹж*/
        return SET;
    }
    else
    {
        /* USART δ7816ʹж */
        return RESET;
    }
}

/**
  *   ȡUSART 7816մжϱ־״̬ 
  *   USARTx: ָUSARTڴṹָ룬ȡֵΪUSART0_SFR~USART8_SFR
  *   1: USART7816մжϣ
  *       0: USARTδ7816մжϡ
  */
FlagStatus
USART_Get_7816Receive_ERROR_Flag (USART_SFRmap* USARTx)
{
    /* У */
    CHECK_RESTRICTION(CHECK_USART_ALL_PERIPH(USARTx));

    /*---------------- ȡUSART_STRĴREIF λ ----------------*/
    if (USARTx->STR & USART_STR_REIF)
    {
        /* USART 7816մж*/
        return SET;
    }
    else
    {
        /* USART δ7816մж */
        return RESET;
    }
}

/**
  *   ȡUSART CTSжϱ־״̬ 
  *   USARTx: ָUSARTڴṹָ룬ȡֵΪUSART0_SFR~USART8_SFR
  *   1: USARTյЧCTSźţ
  *       0: USARTδյЧCTSźš
  */
FlagStatus
USART_Get_CTS_Flag (USART_SFRmap* USARTx)
{
    /* У */
    CHECK_RESTRICTION(CHECK_USART_ALL_PERIPH(USARTx));

    /*---------------- ȡUSART_STRĴCTSIFλ ----------------*/
    if (USARTx->STR & USART_STR_CTSIF)
    {
        /* USART յЧCTSź*/
        return SET;
    }
    else
    {
        /* USART δյЧCTSź */
        return RESET;
    }
}

/**
  *   ȡUSART ݾжϱ־״̬ 
  *   USARTx: ָUSARTڴṹָ룬ȡֵΪUSART0_SFR~USART8_SFR
  *   1: USARTBUFݿɶ
  *       0: USARTBUFݿɶ
  */
FlagStatus
USART_Get_Receive_BUFR_Ready_Flag (USART_SFRmap* USARTx)
{
    /* У */
    CHECK_RESTRICTION(CHECK_USART_ALL_PERIPH(USARTx));

    /*---------------- ȡUSART_STRĴRDRIFλ ----------------*/
    if (USARTx->STR & USART_STR_RDRIF)
    {
        /* USART BUFݿɶ*/
        return SET;
    }
    else
    {
        /* USART BUFݿɶ */
        return RESET;
    }
}

/**
  *   ȡUSART ʹλ״̬ 
  *   USARTx: ָUSARTڴṹָ룬ȡֵΪUSART0_SFR~USART8_SFR
  *       1: USARTڵȴ½أ
  *       0: USART
  */
FlagStatus
USART_Get_WUEN_Flag (USART_SFRmap* USARTx)
{
    /* У */
    CHECK_RESTRICTION(CHECK_USART_ALL_PERIPH(USARTx));

    /*---------------- ȡUSART_CTLRĴWUENλ ----------------*/
    if (USARTx->CTLR & USART_CTLR_WUEN)
    {
        /* ȴ½*/
        return SET;
    }
    else
    {
    	/**/
        return RESET;
    }
}
/**
  *   ȡUSART BUFΪжϱ־״̬ 
  *   USARTx: ָUSARTڴṹָ룬ȡֵΪUSART0_SFR~USART8_SFR
  *   1: USARTBUFΪգ
  *       0: USARTBUFΪա
  */
FlagStatus
USART_Get_Transmit_BUFR_Empty_Flag (USART_SFRmap* USARTx)
{
    /* У */
    CHECK_RESTRICTION(CHECK_USART_ALL_PERIPH(USARTx));

    /*---------------- ȡUSART_STRĴTFEIFλ ----------------*/
    if (USARTx->STR & USART_STR_TFEIF)
    {
        /* USART BUFΪ*/
        return SET;
    }
    else
    {
        /* USART BUFΪ */
        return RESET;
    }
}

/**
  *   ȡUSART Ϊжϱ־״̬ 
  *   USARTx: ָUSARTڴṹָ룬ȡֵΪUSART0_SFR~USART8_SFR
  *   1: USARTΪգ
  *       0: USARTΪա
  */
FlagStatus
USART_Get_Transmitter_Empty_Flag (USART_SFRmap* USARTx)
{
    /* У */
    CHECK_RESTRICTION(CHECK_USART_ALL_PERIPH(USARTx));

    /*---------------- ȡUSART_STRĴTXEIFλ ----------------*/
    if (USARTx->STR & USART_STR_TXEIF)
    {
        /* USART Ϊ*/
        return SET;
    }
    else
    {
        /* USART Ϊ */
        return RESET;
    }
}

/**
  *   ȡUSARTտ֡жϱ־ 
  *   USARTx: ָUSARTڴṹָ룬ȡֵΪUSART0_SFR~USART8_SFR
  *     1: յ֡
  *       0: ûнյ֡
  */
FlagStatus
USART_Get_Receive_Frame_Idel_Flag(USART_SFRmap* USARTx)
{
    /* У */
    CHECK_RESTRICTION(CHECK_USART_ALL_PERIPH(USARTx));

    /*---------------- ȡUSART_STRĴTXEIFλ ----------------*/
    if (USARTx->STR & USART_STR_IDLFIF)
    {
        /* USART Ϊ*/
        return SET;
    }
    else
    {
        /* USART Ϊ */
        return RESET;
    }
}

/**
  *   USARTжϱ־
  *   USARTx: ָUSARTڴṹָ룬ȡֵΪUSART0_SFR~USART8_SFR
  *   ޡ
  */
void
USART_Clear_Receive_Overflow_INT_Flag (USART_SFRmap* USARTx)
{
    /* У */
    CHECK_RESTRICTION(CHECK_USART_ALL_PERIPH(USARTx));

    /*---------------- USART_STRĴOVFEICλ ----------------*/
    SFR_SET_BIT_ASM(USARTx->STR, USART_STR_OVFEIC_POS);
    while(USARTx->STR & USART_STR_OVFEIF);
    SFR_CLR_BIT_ASM(USARTx->STR, USART_STR_OVFEIC_POS);
}

/**
  *   USARTżУλ
  *   USARTx: ָUSARTڴṹָ룬ȡֵΪUSART0_SFR~USART8_SFR
  *   ޡ
  */
void
USART_Clear_Parity_ERROR_INT_Flag (USART_SFRmap* USARTx)
{
    /* У */
    CHECK_RESTRICTION(CHECK_USART_ALL_PERIPH(USARTx));

    /*---------------- USART_STRĴPAREICλ ----------------*/
    SFR_SET_BIT_ASM(USARTx->STR, USART_STR_PAREIC_POS);
    while(USARTx->STR & USART_STR_PAREIF);
    SFR_CLR_BIT_ASM(USARTx->STR, USART_STR_PAREIC_POS);
}

/**
  *   USART֡λ
  *   USARTx: ָUSARTڴṹָ룬ȡֵΪUSART0_SFR~USART8_SFR
  *   ޡ
  */
void
USART_Clear_Frame_ERROR_INT_Flag (USART_SFRmap* USARTx)
{
    /* У */
    CHECK_RESTRICTION(CHECK_USART_ALL_PERIPH(USARTx));

    /*---------------- USART_STRĴFREICλ ----------------*/
    SFR_SET_BIT_ASM(USARTx->STR, USART_STR_FREIC_POS);
    while(USARTx->STR & USART_STR_FREIF);
    SFR_CLR_BIT_ASM(USARTx->STR, USART_STR_FREIC_POS);
}

/**
  *   USARTλ
  *   USARTx: ָUSARTڴṹָ룬ȡֵΪUSART0_SFR~USART8_SFR
  *   ޡ
  */
void
USART_Clear_Blank_INT_Flag (USART_SFRmap* USARTx)
{
    /* У */
    CHECK_RESTRICTION(CHECK_USART_ALL_PERIPH(USARTx));

    /*---------------- USART_STRĴBRICλ ----------------*/
    SFR_SET_BIT_ASM(USARTx->STR, USART_STR_BRIC_POS);
    while(USARTx->STR & USART_STR_BRIF);
    SFR_CLR_BIT_ASM(USARTx->STR, USART_STR_BRIC_POS);
}

/**
  *   USARTԶʳʱλ
  *   USARTx: ָUSARTڴṹָ룬ȡֵΪUSART0_SFR~USART8_SFR
  *   ޡ
  */
void
USART_Clear_Auto_BaudRate_TimeOver_INT_Flag (USART_SFRmap* USARTx)
{
    /* У */
    CHECK_RESTRICTION(CHECK_USART_ALL_PERIPH(USARTx));

    /*---------------- USART_STRĴABTOICλ ----------------*/
    SFR_SET_BIT_ASM(USARTx->STR, USART_STR_ABTOIC_POS);
    while(USARTx->STR & USART_STR_ABTOIF);
    SFR_CLR_BIT_ASM(USARTx->STR, USART_STR_ABTOIC_POS);
}

/**
  *   USARTԶжλ
  *   USARTx: ָUSARTڴṹָ룬ȡֵΪUSART0_SFR~USART8_SFR
  *   ޡ
  */
void
USART_Clear_WeakUP_INT_Flag (USART_SFRmap* USARTx)
{
    /* У */
    CHECK_RESTRICTION(CHECK_USART_ALL_PERIPH(USARTx));

    /*---------------- USART_STRĴWUICλ ----------------*/
    SFR_SET_BIT_ASM(USARTx->STR, USART_STR_WUIC_POS);
    while(USARTx->STR & USART_STR_WUIF);
    SFR_CLR_BIT_ASM(USARTx->STR, USART_STR_WUIC_POS);
}

/**
  *   USARTʹжλ
  *   USARTx: ָUSARTڴṹָ룬ȡֵΪUSART0_SFR~USART8_SFR
  *   ޡ
  */
void
USART_Clear_Transmit_ERROR_INT_Flag (USART_SFRmap* USARTx)
{
    /* У */
    CHECK_RESTRICTION(CHECK_USART_ALL_PERIPH(USARTx));

    /*---------------- USART_STRĴTEICλ ----------------*/
    SFR_SET_BIT_ASM(USARTx->STR, USART_STR_TEIC_POS);
    while(USARTx->STR & USART_STR_TEIF);
    SFR_CLR_BIT_ASM(USARTx->STR, USART_STR_TEIC_POS);
}

/**
  *   USARTմжλ
  *   USARTx: ָUSARTڴṹָ룬ȡֵΪUSART0_SFR~USART8_SFR
  *   ޡ
  */
void
USART_Clear_Receive_ERROR_INT_Flag (USART_SFRmap* USARTx)
{
    /* У */
    CHECK_RESTRICTION(CHECK_USART_ALL_PERIPH(USARTx));

    /*---------------- USART_STRĴREICλ ----------------*/
    SFR_SET_BIT_ASM(USARTx->STR, USART_STR_REIC_POS);
    while(USARTx->STR & USART_STR_REIF);
    SFR_CLR_BIT_ASM(USARTx->STR, USART_STR_REIC_POS);
}

/**
  *   USART CTSжλ
  *   USARTx: ָUSARTڴṹָ룬ȡֵΪUSART0_SFR~USART8_SFR
  *   ޡ
  */
void
USART_Clear_CTS_INT_Flag (USART_SFRmap* USARTx)
{
    /* У */
    CHECK_RESTRICTION(CHECK_USART_ALL_PERIPH(USARTx));

    /*---------------- USART_STRĴREICλ ----------------*/
    SFR_SET_BIT_ASM(USARTx->STR, USART_STR_CTSIC_POS);
    while(USARTx->STR & USART_STR_CTSIF);
    SFR_CLR_BIT_ASM(USARTx->STR, USART_STR_CTSIC_POS);
}

/**
  *   USART UADMжλ
  *   USARTx: ָUSARTڴṹָ룬ȡֵΪUSART0_SFR~USART8_SFR
  *   ޡ
  */
void
USART_Clear_UADM_INT_Flag (USART_SFRmap* USARTx)
{
    /* У */
    CHECK_RESTRICTION(CHECK_USART_ALL_PERIPH(USARTx));

    /*---------------- USART_STRĴUADMλ ----------------*/
    SFR_SET_BIT_ASM(USARTx->STR, USART_STR_UADMIC_POS);
    while(USARTx->STR & USART_STR_UADMIF);
    SFR_CLR_BIT_ASM(USARTx->STR, USART_STR_UADMIC_POS);
}

/**
  *   USART IDLEжλ
  *   USARTx: ָUSARTڴṹָ룬ȡֵΪUSART0_SFR~USART8_SFR
  *   ޡ
  */
void
USART_Clear_IDLE_INT_Flag (USART_SFRmap* USARTx)
{
    /* У */
    CHECK_RESTRICTION(CHECK_USART_ALL_PERIPH(USARTx));

    /*---------------- USART_STRĴIDLEλ ----------------*/
    SFR_SET_BIT_ASM(USARTx->STR, USART_STR_IDLEIC_POS);
    while(USARTx->STR & USART_STR_IDLFIF);
    SFR_CLR_BIT_ASM(USARTx->STR, USART_STR_IDLEIC_POS);
}

/**
  *   USART BUFжλ
  *   USARTx: ָUSARTڴṹָ룬ȡֵΪUSART0_SFR~USART8_SFR
  *   ޡ
  */
void
USART_Clear_Receive_BUFR_INT_Flag (USART_SFRmap* USARTx)
{
    /* У */
    CHECK_RESTRICTION(CHECK_USART_ALL_PERIPH(USARTx));

    /*---------------- USART_STRĴRCFRλ ----------------*/
    SFR_SET_BIT_ASM(USARTx->STR, USART_STR_RCFR_POS);
    while(USARTx->STR & USART_STR_RDRIF);
    SFR_CLR_BIT_ASM(USARTx->STR, USART_STR_RCFR_POS);
}

/**
  *   USART BUFжλ
  *   USARTx: ָUSARTڴṹָ룬ȡֵΪUSART0_SFR~USART8_SFR
  *   ޡ
  */
void
USART_Clear_Transmit_BUFR_INT_Flag (USART_SFRmap* USARTx)
{
    /* У */
    CHECK_RESTRICTION(CHECK_USART_ALL_PERIPH(USARTx));

    /*---------------- USART_STRĴTXFRλ ----------------*/
    SFR_SET_BIT_ASM(USARTx->STR, USART_STR_TXFR_POS);
    while(!((USARTx->STR & USART_STR_TFEIF)>>USART_STR_TFEIF_POS));
    SFR_CLR_BIT_ASM(USARTx->STR, USART_STR_TXFR_POS);
}
/**
  *   ##### USARTģ(USART)жϹ #####
  */

