/**
  ******************************************************************************
  * ļ  kf32a_basic_systick.c
  *     ChipON_AE/FAE_Group
  *     V3.0.1
  *     2021-11-25
  *     ļṩ˽Ķʱ蹦ܺ
  *          + Ķʱ(SYSTICK)ʼ
  *          + Ķʱ(SYSTICK)ú
  *
  *********************************************************************
  */

#include "kf32a_basic_systick.h"

/*
 * ˵   ļδSTCALIBУĴϢSTCALIBУĴ䶯
 *        ᵼ½Ķʱʱ쳣KungFuû޸ĸüĴ
 */


/* Ķʱ˽ж ----------------------------------------------------*/
/* ST_CTLĴ */
#define SYSTICK_CTL_INIT_MASK           (ST_CTL_TICKINTEN \
                                       | ST_CTL_STCLKS)

/**
  *   ##### Ķʱ(SYSTICK)ʼ #####
  */
/**
  *   Ķʱ(SYSTICK)á
  *   Clock: ϵͳĶʱʱԴѡ
  *              ȡֵΧΪ
  *                SYSTICK_SYS_CLOCK_DIV_1: SCLKΪʱ
  *                SYSTICK_SYS_CLOCK_DIV_2:  SCLK/2Ϊʱ
  *       SysTickINT: SysTickжʹܿƣ
  *                   ȡֵΧΪTRUE  FALSE
  *       Reload: ϵͳĶʱؼֵĶʱֵΪؼֵ1
  *               ȡֵΪ24λݡ
  *   
  */
void
SYSTICK_Configuration (uint32_t Clock, uint32_t SysTickINT,
                    uint32_t Reload)
{
    uint32_t tmpreg = 0;

    /* У */
    CHECK_RESTRICTION(CHECK_SYSTICK_CLOCK(Clock));
    CHECK_RESTRICTION(CHECK_SYSTICK_RELOAD(Reload));
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(SysTickINT));

    /*------------ ֹĶʱֹж -------------*/
    SFR_CLR_BIT_ASM(ST_CTL, ST_CTL_STEN_POS);

    /*--------------- ST_RELOADĴ ---------------*/
    ST_RELOAD = Reload;

    /*-- ST_CVĴ㵱ǰֵĴCOUNTZERO־λ
         ȷֵܼصǰֵĴ -------------------*/
    ST_CV = 0;

    /*------------------ ST_CTLĴ -----------------*/
    /* ݲClockSTCLKSλ */
    /* ݲSysTickINTTICKINTENλ */
    tmpreg = Clock | (SysTickINT << ST_CTL_TICKINTEN_POS);
    ST_CTL = SFR_Config (ST_CTL,
                          ~SYSTICK_CTL_INIT_MASK,
                          tmpreg);
}

/**
  *   ##### Ķʱ(SYSTICK)ʼ #####
  */


/**
  *   ##### Ķʱ(SYSTICK)ú #####
  */
/**
  *   Ķʱ(SYSTICK)ʹܡ
  *   NewState: Ķʱʹܿƣ
  *                 ȡֵΧΪTRUE  FALSE
  *   
  */
void
SYSTICK_Cmd (FunctionalState NewState)
{
    /* У */
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

    /*---------------- ST_CTLĴSTENλ ----------------*/
    if (NewState != FALSE)
    {
        /* ʹϵͳĶʱ */
        SFR_SET_BIT_ASM(ST_CTL, ST_CTL_STEN_POS);
    }
    else
    {
        /* ֹϵͳĶʱ */
        SFR_CLR_BIT_ASM(ST_CTL, ST_CTL_STEN_POS);
    }
}

/**
  *   Ķʱ(SYSTICK)ʱԴá
  *   SysClock: ϵͳĶʱʱԴѡ
  *                 ȡֵΧΪ
  *                   SYSTICK_SYS_CLOCK_DIV_1: SCLKΪʱ
  *                   SYSTICK_SYS_CLOCK_DIV_2:  SCLK/2Ϊʱ
  *   
  */
void
SYSTICK_Clock_Config (uint32_t SysClock)
{
    /* У */
    CHECK_RESTRICTION(CHECK_SYSTICK_CLOCK(SysClock));

    /*---------------- ST_CTLĴSTCLKSλ ----------------*/
    if (SysClock != SYSTICK_SYS_CLOCK_DIV_2)
    {
        /*  ѡSCLKΪʱ */
        SFR_SET_BIT_ASM(ST_CTL, ST_CTL_STCLKS_POS);
    }
    else
    {
        /*  ѡSCLK/2Ϊʱ */
        SFR_CLR_BIT_ASM(ST_CTL, ST_CTL_STCLKS_POS);
    }
}

/**
  *   Ķʱ(SYSTICK)SysTickжʹá
  *   SysClock: ϵͳĶʱSysTickжʹ״̬
  *                 ȡֵΧΪTRUE  FALSE
  *   
  */
void
SYSTICK_Systick_INT_Enable (uint32_t SysClock)
{
    /* У */
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(SysClock));

    /*---------------- ST_CTLĴTICKINTENλ ----------------*/
    if (SysClock != FALSE)
    {
        /*  0SysTickж */
        SFR_SET_BIT_ASM(ST_CTL, ST_CTL_TICKINTEN_POS);
    }
    else
    {
        /*  0SysTickж */
        SFR_CLR_BIT_ASM(ST_CTL, ST_CTL_TICKINTEN_POS);
    }
}

/**
  *   ȡĶʱ־
  *   ޡ
  *   Ķʱı־0δ㣬1㡣
  */
FlagStatus
SYSTICK_Get_Count_Zero_Flag (void)
{
    /*-------------------- ST_CTLĴCOUNTZEROλ --------------------*/
    if (ST_CTL & ST_CTL_COUNTZERO)
    {
        /*  */
        return SET;
    }
    else
    {
        /* δ */
        return RESET;
    }
}

/**
  *   Ķʱ(SYSTICK)ؼؼĴá
  *   Reload: ϵͳĶʱؼֵĶʱֵΪؼֵ1
  *               ȡֵΪ24λݡ
  *   
  */
void
SYSTICK_Reload_Config (uint32_t Reload)
{
    /* У */
    CHECK_RESTRICTION(CHECK_SYSTICK_RELOAD(Reload));

    /*--------------- ST_RELOADĴ ---------------*/
    ST_RELOAD = Reload;
}

/**
  *   Ķʱ(SYSTICK)ãúCOUNTZEROλ
  *       STRELOADֵܼصĴС
  *   ޡ
  *   ޡ
  */
void
SYSTICK_Counter_Updata (void)
{
    /*-- ST_CVĴдֵ㵱ǰֵĴ
         COUNTZERO־λȷֵܼصǰֵĴ --*/
    ST_CV = 0;
}

/**
  *   ȡϵͳĶʱؼؼĴ
  *   ޡ
  *   ؼؼĴֵ24λЧݡ
  */
uint32_t
SYSTICK_Get_Reload (void)
{
    uint32_t tmpreg = 0;

    /* ȡST_RELOADĴ */
    tmpreg = ST_RELOAD & ST_RELOAD_STRELOAD;

    return tmpreg;
}

/**
  *   ȡϵͳĶʱ
  *   ޡ
  *   ǰֵ24λЧݡ
  */
uint32_t
SYSTICK_Get_Counter (void)
{
    uint32_t tmpreg = 0;

    /* ȡST_CVĴ */
    tmpreg = ST_CV & ST_CV_STCV;

    return tmpreg;
}
/**
  *   ##### Ķʱ(SYSTICK)ú #####
  */
