/**
  ******************************************************************************
  * ļ  kf32a_basic_flash.c
  *     ChipON_AE/FAE_Group
  *     V3.0.1
  *     2021-11-25
  *     ļṩFLASH洢(FLASH)صĹܺ
  *          + FLASH洢(FLASH)ú
  *          + FLASH洢(FLASH)̹ܺ
  *
  *ע⣺ʹƬܺFLASHգԭгʧ޷FLASH
  *ע⣺ʹҳܺȷǷ˺ڵúFLASHѲ޷FLASH
  *********************************************************************
  */

#include "kf32a_basic_flash.h"


/* ʱ˽ж ----------------------------------------------------*/
/* FLASH_ISPCON0ƼĴд16λֵ */
#define FLASH_ISPCON0_HIGH              ((uint32_t)0x50AF0000)
#define FLASH_ISPCON0_HIGH_MSK          ((uint32_t)0xFFFF0000)

/* FLASH_ISPCON1ƼĴд16λֵ */
#define FLASH_ISPCON1_HIGH              ((uint32_t)0xA05F0000)
#define FLASH_ISPCON1_HIGH_MSK          ((uint32_t)0xFFFF0000)

/* FLASH_ISPTRGƼĴд16λֵ */
#define FLASH_ISPTRG_HIGH               ((uint32_t)0x50AF0000)
#define FLASH_ISPTRG_HIGH_MSK           ((uint32_t)0xFFFF0000)

/* FLASH_NVMUNLOCKĴ */
#define FLASH_NVMUNLOCK_KEY1            ((uint32_t)0x87654321)
#define FLASH_NVMUNLOCK_KEY2            ((uint32_t)0x05040302)

/* FLASH_PROUNLOCKĴ */
#define FLASH_PROUNLOCK_KEY1            ((uint32_t)0x789ABCDE)
#define FLASH_PROUNLOCK_KEY2            ((uint32_t)0x16151413)

/* FLASH_CFGUNLOCKĴ */
#define FLASH_CFGUNLOCK_KEY1            ((uint32_t)0x879A43DE)
#define FLASH_CFGUNLOCK_KEY2            ((uint32_t)0x27262524)


/**
  *   ##### FLASH洢(FLASH)ú #####
  */

void __attribute__((section(".indata")))
CHECK_RESTRICTION_RAM(int expr)
{
	while(!expr)
		;
}

/* д⹦ܼĴRAM */
static inline uint32_t   __attribute__((section(".indata")))
SFR_Config_RAM (uint32_t SfrMem, uint32_t SfrMask, uint32_t WriteVal)
{
    return ((SfrMem & SfrMask) | (WriteVal));
}

/**
  *   FLASH״̬
  *   ޡ
  *   ״̬1״̬0״̬
  */
LockStatus __attribute__((section(".indata")))
FLASH_Get_NonVolatile_Memory_Unlock_Status_RAM (void)
{
    if (FLASH_ISPCON0 & FLASH_ISPCON0_NVMLOCK)
    {
        /* ״̬ */
        return UNLOCK;
    }
    else
    {
        /* ״̬ */
        return LOCK;
    }
}

/**
  *   FLASH״̬λ
  *   ޡ
  *   ޡ
  */
void __attribute__((section(".indata")))
FLASH_Clear_NonVolatile_Memory_Unlock_Status_RAM (void)
{
    uint32_t tmpreg = 0;

    /*---------------- FLASH_ISPCON0ĴNVMLOCKλ ----------------*/
    tmpreg = FLASH_ISPCON0_HIGH | FLASH_ISPCON0_NVMLOCK;
    FLASH_ISPCON0 = SFR_Config_RAM (FLASH_ISPCON0,
                        ~(FLASH_ISPCON0_HIGH_MSK | FLASH_ISPCON0_NVMLOCK),
                        tmpreg);
}
/**
  *   FLASH״̬λ
  *   ޡ
  *   ޡ
  */
void
FLASH_Clear_NonVolatile_Memory_Unlock_Status (void)
{
    uint32_t tmpreg = 0;

    /*---------------- FLASH_ISPCON0ĴNVMLOCKλ ----------------*/
    tmpreg = FLASH_ISPCON0_HIGH | FLASH_ISPCON0_NVMLOCK;
    FLASH_ISPCON0 = SFR_Config (FLASH_ISPCON0,
                        ~(FLASH_ISPCON0_HIGH_MSK | FLASH_ISPCON0_NVMLOCK),
                        tmpreg);
}
/**
  *   λFLASH״̬λISPĴ
  *   ޡ
  *   ޡ
  */
void  __attribute__((section(".indata")))
FLASH_Unlock_ISP_RAM   (void)
{
    /* дKEY1  KEY2 */
    FLASH_NVMUNLOCK = FLASH_NVMUNLOCK_KEY1;
    FLASH_NVMUNLOCK = FLASH_NVMUNLOCK_KEY2;
}

/**
  *   λFLASH״̬λISPĴ
  *   ޡ
  *   ޡ
  */
void
FLASH_Unlock_ISP   (void)
{
    /* дKEY1  KEY2 */
    FLASH_NVMUNLOCK = FLASH_NVMUNLOCK_KEY1;
    FLASH_NVMUNLOCK = FLASH_NVMUNLOCK_KEY2;
}
/**
  *   FLASH״̬
  *   ޡ
  *   ״̬1״̬0״̬
  */
LockStatus __attribute__((section(".indata")))
FLASH_Get_Flash_Unlock_Status_RAM (void)
{
    if (FLASH_ISPCON0 & FLASH_ISPCON0_FLASHLOCK)
    {
        /* ״̬ */
        return UNLOCK;
    }
    else
    {
        /* ״̬ */
        return LOCK;
    }
}

/**
  *   FLASH״̬λ
  *   ޡ
  *   ޡ
  */
void __attribute__((section(".indata")))
FLASH_Clear_Flash_Unlock_Status_RAM (void)
{
    uint32_t tmpreg = 0;

    /*---------------- FLASH_ISPCON0ĴFLASHLOCKλ ----------------*/
    tmpreg = FLASH_ISPCON0_HIGH | FLASH_ISPCON0_FLASHLOCK;
    FLASH_ISPCON0 = SFR_Config_RAM (FLASH_ISPCON0,
                        ~(FLASH_ISPCON0_HIGH_MSK | FLASH_ISPCON0_FLASHLOCK),
                        tmpreg);
}
/**
  *   FLASH״̬λ
  *   ޡ
  *   ޡ
  */
void
FLASH_Clear_Flash_Unlock_Status (void)
{
    uint32_t tmpreg = 0;

    /*---------------- FLASH_ISPCON0ĴFLASHLOCKλ ----------------*/
    tmpreg = FLASH_ISPCON0_HIGH | FLASH_ISPCON0_FLASHLOCK;
    FLASH_ISPCON0 = SFR_Config (FLASH_ISPCON0,
                        ~(FLASH_ISPCON0_HIGH_MSK | FLASH_ISPCON0_FLASHLOCK),
                        tmpreg);
}
/**
  *   λFLASH״̬λFLASH
  *   ޡ
  *   ޡ
  */
void  __attribute__((section(".indata")))
FLASH_Unlock_Code_RAM (void)
{
    /* дKEY1  KEY2 */
    FLASH_PROUNLOCK = FLASH_PROUNLOCK_KEY1;
    FLASH_PROUNLOCK = FLASH_PROUNLOCK_KEY2;
}

/**
  *   λFLASH״̬λFLASH
  *   ޡ
  *   ޡ
  */
void
FLASH_Unlock_Code (void)
{
    /* дKEY1  KEY2 */
    FLASH_PROUNLOCK = FLASH_PROUNLOCK_KEY1;
    FLASH_PROUNLOCK = FLASH_PROUNLOCK_KEY2;
}
/**
  *   FLASH״̬
  *   ޡ
  *   ״̬1״̬0״̬
  */
LockStatus __attribute__((section(".indata")))
FLASH_Get_Config_Unlock_Status_RAM (void)
{
    if (FLASH_ISPCON0 & FLASH_ISPCON0_CFGLOCK)
    {
        /* ״̬ */
        return UNLOCK;
    }
    else
    {
        /* ״̬ */
        return LOCK;
    }
}

/**
  *   FLASH״̬λ
  *   ޡ
  *   ޡ
  */
void __attribute__((section(".indata")))
FLASH_Clear_Config_Unlock_Status_RAM (void)
{
    uint32_t tmpreg = 0;

    /*---------------- FLASH_ISPCON0ĴCFGLOCKλ ----------------*/
    tmpreg = FLASH_ISPCON0_HIGH | FLASH_ISPCON0_CFGLOCK;
    FLASH_ISPCON0 = SFR_Config_RAM (FLASH_ISPCON0,
                        ~(FLASH_ISPCON0_HIGH_MSK | FLASH_ISPCON0_CFGLOCK),
                        tmpreg);
}
/**
  *   FLASH״̬λ
  *   ޡ
  *   ޡ
  */
void
FLASH_Clear_Config_Unlock_Status (void)
{
    uint32_t tmpreg = 0;

    /*---------------- FLASH_ISPCON0ĴCFGLOCKλ ----------------*/
    tmpreg = FLASH_ISPCON0_HIGH | FLASH_ISPCON0_CFGLOCK;
    FLASH_ISPCON0 = SFR_Config (FLASH_ISPCON0,
                        ~(FLASH_ISPCON0_HIGH_MSK | FLASH_ISPCON0_CFGLOCK),
                        tmpreg);
}
/**
  *   λFLASH״̬λû
  *   ޡ
  *   ޡ
  */
void  __attribute__((section(".indata")))
FLASH_Unlock_User_Config_RAM (void)
{
    /* дKEY1  KEY2 */
    FLASH_CFGUNLOCK = FLASH_CFGUNLOCK_KEY1;
    FLASH_CFGUNLOCK = FLASH_CFGUNLOCK_KEY2;
}

/**
  *   λFLASH״̬λû
  *   ޡ
  *   ޡ
  */
void
FLASH_Unlock_User_Config(void)
{
    /* дKEY1  KEY2 */
    FLASH_CFGUNLOCK = FLASH_CFGUNLOCK_KEY1;
    FLASH_CFGUNLOCK = FLASH_CFGUNLOCK_KEY2;
}
/**
  *   FLASHдʹܡ
  *   NewState: FLASHдʹ״̬ȡֵΪTRUE  FALSE
  *   ޡ
  */
void  __attribute__((section(".indata")))
FLASH_Data_Write_Enable_RAM (FunctionalState NewState)
{
    /* У */
    CHECK_RESTRICTION_RAM(CHECK_FUNCTIONAL_STATE(NewState));

    /*---------------- FLASH_ISPCON0ĴDWENλ ----------------*/
    if (NewState != FALSE)
    {
        /* FLASHдԱд */
        __asm volatile("SET [%0], #%1"::"r"(&(FLASH_ISPCON0)),"i"(FLASH_ISPCON0_DWEN_POS));
    }
    else
    {
        /* FLASHдֹд */
        __asm volatile("CLR [%0], #%1"::"r"(&(FLASH_ISPCON0)),"i"(FLASH_ISPCON0_DWEN_POS));
    }
}

/**
  *   FLASHϢѡ
  *   ZoneSelect: FLASHϢѡȡֵΪ
  *                     FLASH_NVM_CODE_ZONE: FLASH
  *                     FLASH_NVM_INFORMATION_ZONE: FLASH_NVM_CODE_ZONE
  *   ޡ
  */
void __attribute__((section(".indata")))
FLASH_Zone_Config_RAM (uint32_t ZoneSelect)
{
    /* У */
    CHECK_RESTRICTION_RAM(CHECK_FLASH_NVM_ZONE(ZoneSelect));

    /*---------------- FLASH_ISPCON0ĴIFENλ ----------------*/
    if (ZoneSelect != FLASH_NVM_CODE_ZONE)
    {
        /* NVM洢ѡFLASHϢ */
        __asm volatile("SET [%0], #%1"::"r"(&(FLASH_ISPCON0)),"i"(FLASH_ISPCON0_IFEN_POS));
    }
    else
    {
        /* NVM洢ѡFLASH */
        __asm volatile("CLR [%0], #%1"::"r"(&(FLASH_ISPCON0)),"i"(FLASH_ISPCON0_IFEN_POS));
    }
}
/**
  *   FLASHϢѡ
  *   ZoneSelect: FLASHϢѡȡֵΪ
  *                     FLASH_NVM_CODE_ZONE: FLASH
  *                     FLASH_NVM_INFORMATION_ZONE: FLASH_NVM_CODE_ZONE
  *   ޡ
  */
void
FLASH_Zone_Config(uint32_t ZoneSelect)
{
    /* У */
    CHECK_RESTRICTION(CHECK_FLASH_NVM_ZONE(ZoneSelect));

    /*---------------- FLASH_ISPCON0ĴIFENλ ----------------*/
    if (ZoneSelect != FLASH_NVM_CODE_ZONE)
    {
        /* NVM洢ѡFLASHϢ */
        SFR_SET_BIT_ASM(FLASH_ISPCON0, FLASH_ISPCON0_IFEN_POS);
    }
    else
    {
        /* NVM洢ѡFLASH */
        SFR_CLR_BIT_ASM(FLASH_ISPCON0, FLASH_ISPCON0_IFEN_POS);
    }
}
/**
  *   FLASHģʽ
  *   ModeSelect: FLASHϢѡȡֵΪ
  *                     FLASH_MODE_NORMAL: Ϊģʽ
  *                     FLASH_MODE_STANDBY1: STANDBY1 Stanbyģʽ
  *                     FLASH_MODE_STANDBY2: STANDBY2 ģʽ
  *                     FLASH_MODE_STANDBY1_STANDBY2: Stanbyģʽ
  *   ޡ
  */
void __attribute__((section(".indata")))
FLASH_Standby_Mode_Config_RAM (uint32_t ModeSelect)
{
    uint32_t tmpreg = 0;

    /* У */
    CHECK_RESTRICTION_RAM(CHECK_FLASH_MODE(ModeSelect));

    /*---------------- FLASH_ISPCON0ĴCFGLOCKλ ----------------*/
    tmpreg = FLASH_ISPCON0_HIGH | ModeSelect;
    FLASH_ISPCON0 = SFR_Config_RAM (FLASH_ISPCON0,
                        ~(FLASH_ISPCON0_HIGH_MSK | FLASH_ISPCON0_STANDBY1),
                        tmpreg);
}



/**
  *   FLASHģʽ
  *   ReadMode: FLASHģʽѡȡֵΪ
  *                   FLASH_READ_MODE_NORMAL: ģʽ
  *                   FLASH_READ_MODE_RECALL: RECALLģʽ
  *   ޡ
  */
void __attribute__((section(".indata")))
FLASH_Read_Mode_Config_RAM (uint32_t ReadMode)
{
    /* У */
    CHECK_RESTRICTION_RAM(CHECK_FLASH_READ_MODE(ReadMode));

    /*---------------- FLASH_ISPCON1ĴRECALLENλ ----------------*/
    if (ReadMode != FLASH_IP1)
    {
        /* FLASHΪģʽ */
        __asm volatile("SET [%0], #%1"::"r"(&(FLASH_ISPCON1)),"i"(FLASH_ISPCON1_RECALLEN_POS));
    }
    else
    {
        /* FLASHΪRECALLģʽ */
        __asm volatile("CLR [%0], #%1"::"r"(&(FLASH_ISPCON1)),"i"(FLASH_ISPCON1_RECALLEN_POS));
    }
}

/**
  *   FLASHУ׼Ϣʹܡ
  *   NewState: FLASHУ׼Ϣʹ״̬ȡֵΪTRUE  FALSE
  *   ޡ
  */
void __attribute__((section(".indata")))
FLASH_Calibration_Updata_Enable_RAM (FunctionalState NewState)
{
    uint32_t tmpreg = 0;

    /* У */
    CHECK_RESTRICTION_RAM(CHECK_FUNCTIONAL_STATE(NewState));

    /*---------------- FLASH_ISPCON1ĴCONFENλ ----------------*/
    tmpreg = FLASH_ISPCON1_HIGH \
           | (NewState << FLASH_ISPCON1_CONFEN_POS);
    FLASH_ISPCON1 = SFR_Config_RAM (FLASH_ISPCON1,
                        ~(FLASH_ISPCON1_HIGH_MSK | FLASH_ISPCON1_CONFEN),
                        tmpreg);
}

/**
  *   FLASHоƬϢд״̬
  *   NewState: FLASHоƬϢд״̬ȡֵΪ
  *                   LOCK: ״̬
  *                   UNLOCK: ״̬
  *   ޡ
  */
void __attribute__((section(".indata")))
FLASH_Information_Zone_Wipe_Unlock_Config_RAM (LockStatus NewState)
{
    uint32_t tmpreg = 0;

    /* У */
    CHECK_RESTRICTION_RAM(CHECK_LOCK_STATUS(NewState));

    /*---------------- FLASH_ISPCON1ĴCONFENλ ----------------*/
    tmpreg = FLASH_ISPCON1_HIGH \
           | (NewState << FLASH_ISPCON1_CHIPONEN_POS);
    FLASH_ISPCON1 = SFR_Config_RAM (FLASH_ISPCON1,
                        ~(FLASH_ISPCON1_HIGH_MSK | FLASH_ISPCON1_CHIPONEN),
                        tmpreg);
}

/**
  *   FLASHҳģʽҪд
  *   WriteSize: Ҫдȡֵ6λֵ
  *   ޡ
  */
void __attribute__((section(".indata")))
FLASH_Half_Page_Write_Size_Config_RAM (uint32_t WriteSize)
{
    uint32_t tmpreg = 0;

    /* У */
    CHECK_RESTRICTION_RAM(CHECK_FLASH_WRITE_SIZE(WriteSize));

    /*---------------- FLASH_ISPCMDĴWSIZEλ ----------------*/
    tmpreg = WriteSize << FLASH_ISPCMD_WSIZE0_POS;
    FLASH_ISPCMD = SFR_Config_RAM (FLASH_ISPCMD,
                        ~FLASH_ISPCMD_WSIZE,
                        tmpreg);
}

/**
  *   FLASHѡ
  *   CmdSelect: FLASHѡȡֵΪ
  *                    FLASH_PROGRAM_CMD_WORD: ֱ
  *                    FLASH_PROGRAM_CMD_ALL_CODE: Ƭ
  *                    FLASH_PROGRAM_CMD_PAGE: ҳ
  *                    FLASH_PROGRAM_CMD_HALF_PAGE: ҳ
  *   ޡ
  */
void __attribute__((section(".indata")))
FLASH_Program_Cmd_Config_RAM (uint32_t CmdSelect)
{
    /* У */
    CHECK_RESTRICTION_RAM(CHECK_FLASH_PROGRAM_CMD(CmdSelect));

    /*---------------- FLASH_ISPCMDĴCMDλ ----------------*/
    FLASH_ISPCMD = SFR_Config_RAM (FLASH_ISPCMD,
                        ~FLASH_ISPCMD_CMD,
                        CmdSelect);
}

/**
  *   ִеǰFLASH_ISPCMDĴ趨FLASH_Program_Cmd_Config
  *       õ
  *   ޡ
  *   ޡ
  */
void __attribute__((section(".indata")))
FLASH_Executive_Cmd_RAM(void)
{
    uint32_t tmpreg = 0;

    /*---------------- FLASH_ISPTRGĴISPGOλ ----------------*/
    tmpreg = FLASH_ISPTRG_HIGH | FLASH_ISPTRG_ISPGO;
    FLASH_ISPTRG = SFR_Config_RAM (FLASH_ISPTRG,
                        ~(FLASH_ISPTRG_HIGH_MSK | FLASH_ISPTRG_ISPGO),
                        tmpreg);
}
/**
  *   ִеǰFLASH_ISPCMDĴ趨FLASH_Program_Cmd_Config
  *       õ
  *   ޡ
  *   ޡ
  */
void
FLASH_Executive_Cmd(void)
{
    uint32_t tmpreg = 0;

    /*---------------- FLASH_ISPTRGĴISPGOλ ----------------*/
    tmpreg = FLASH_ISPTRG_HIGH | FLASH_ISPTRG_ISPGO;
    FLASH_ISPTRG = SFR_Config_RAM (FLASH_ISPTRG,
                        ~(FLASH_ISPTRG_HIGH_MSK | FLASH_ISPTRG_ISPGO),
                        tmpreg);
}
/**
  *   FLASHʧԴ洢ECCʹܡ
  *   NewState: FLASHʧԴ洢ECCʹ״̬ȡֵΪTRUE  FALSE
  *   ޡ
  */
void __attribute__((section(".indata")))
FLASH_NonVolatile_Memory_ECC_Enable_RAM (FunctionalState NewState)
{
    /* У */
    CHECK_RESTRICTION_RAM(CHECK_FUNCTIONAL_STATE(NewState));

    /*---------------- FLASH_CFGĴECCREADENλ ----------------*/
    if (NewState != FALSE)
    {
        /* ʹECCУ */
        __asm volatile("SET [%0], #%1"::"r"(&(FLASH_CFG)),"i"(FLASH_CFG_ECCREADEN_POS));
    }
    else
    {
        /* ʹECCУ */
        __asm volatile("CLR [%0], #%1"::"r"(&(FLASH_CFG)),"i"(FLASH_CFG_ECCREADEN_POS));
    }
}

/**
  *   FLASHԤȡʹܡ
  *   NewState: FLASHԤȡʹ״̬ȡֵΪTRUE  FALSE
  *   ޡ
  */
void __attribute__((section(".indata")))
FLASH_Linear_Prefetch_Enable_RAM (FunctionalState NewState)
{
    /* У */
    CHECK_RESTRICTION_RAM(CHECK_FUNCTIONAL_STATE(NewState));

    /*---------------- FLASH_CFGĴPREFETCHENλ ----------------*/
    if (NewState != FALSE)
    {
        /* ʹԤȡ */
        __asm volatile("SET [%0], #%1"::"r"(&(FLASH_CFG)),"i"(FLASH_CFG_PREFETCHEN_POS));
    }
    else
    {
        /* ʹԤȡ */
    	__asm volatile("CLR [%0], #%1"::"r"(&(FLASH_CFG)),"i"(FLASH_CFG_PREFETCHEN_POS));
    }
}

/**
  *   FLASHڡ
  *   PeriodNum: FLASHϵͳڸȡֵΪ1~16
  *   ޡ
  */
void __attribute__((section(".indata")))
FLASH_Period_Number_Config_RAM (uint32_t PeriodNum)
{
    uint32_t tmpreg = 0;

    /* У */
    CHECK_RESTRICTION_RAM(CHECK_FLASH_PERIOD(PeriodNum));

    /*---------------- FLASH_CFGĴTCFGλ ----------------*/
    tmpreg = (PeriodNum - 1) << FLASH_CFG_TCFG0_POS;
    FLASH_CFG = SFR_Config_RAM (FLASH_CFG,
                        ~FLASH_CFG_TCFG,
                        tmpreg);
}

/**
  *   FLASH̺вڼĵַ
  *   ProgramAddr: FLASH̵ַȡֵΪ0x0~0xFFFFFӲԵ2λ
  *   ޡ
  */
void __attribute__((section(".indata")))
FLASH_Program_Addr_Config_RAM (uint32_t ProgramAddr)
{
    uint32_t tmpreg = 0;

    /* У */
    CHECK_RESTRICTION_RAM(CHECK_FLASH_ADDR_20BITS(ProgramAddr));

    /*---------------- FLASH_ISPADDRĴSADDRλ ----------------*/
    tmpreg = ProgramAddr << FLASH_ISPADDR_SADDR0_POS;
    FLASH_ISPADDR = SFR_Config_RAM (FLASH_ISPADDR,
                        ~FLASH_ISPADDR_SADDR,
                        tmpreg);
}

/**
  *   FLASH״̬   RAM
  *   ޡ
  *   ״̬1FLASHڱ״̬0FLASHڱ״̬
  */
FlagStatus  __attribute__((section(".indata")))
FLASH_Get_Program_Status_RAM (void)
{
    if (FLASH_STATE & FLASH_STATE_TBUSY)
    {
        /* ״̬ */
        return SET;
    }
    else
    {
        /* ڱ״̬ */
        return RESET;
    }
}
/**
  *   FLASH״̬   RAM
  *   ޡ
  *   ״̬1FLASHڱ״̬0FLASHڱ״̬
  */
FlagStatus
FLASH_Get_Program_Status (void)
{
    if (FLASH_STATE & FLASH_STATE_TBUSY)
    {
        /* ״̬ */
        return SET;
    }
    else
    {
        /* ڱ״̬ */
        return RESET;
    }
}



/**
  *   FLASHд״̬
  *   ޡ
  *   ״̬1ISPִвд0ISPڿ״̬
  */
FlagStatus   __attribute__((section(".indata")))
FLASH_Get_Wipe_Status_RAM (void)
{
    if (FLASH_STATE & FLASH_STATE_TBIT)
    {
        /* ִвд */
        return SET;
    }
    else
    {
        /* ڿ״̬ */
        return RESET;
    }
}

/**
  *   FLASHд״̬
  *   ޡ
  *   ״̬1ISPִвд0ISPڿ״̬
  */
FlagStatus
FLASH_Get_Wipe_Status (void)
{
    if (FLASH_STATE & FLASH_STATE_TBIT)
    {
        /* ִвд */
        return SET;
    }
    else
    {
        /* ڿ״̬ */
        return RESET;
    }
}
/**
  *   FLASH״̬
  *   ޡ
  *   ״̬1ɣ0δ߼С
  */
FlagStatus __attribute__((section(".indata")))
FLASH_Get_Compute_Complete_Status_RAM (void)
{
    if (FLASH_STATE & FLASH_STATE_SIGDONE)
    {
        /*  */
        return SET;
    }
    else
    {
        /* δ߼ */
        return RESET;
    }
}

/**
  *   FLASH״̬
  *   ޡ
  *   ޡ
  */
void __attribute__((section(".indata")))
FLASH_Clear_Compute_Complete_Status_RAM (void)
{
    /* д 1  */
    while((FLASH_STATE & FLASH_STATE_SIGDONE)>>FLASH_STATE_SIGDONE_POS)
    {
    	__asm volatile("SET [%0], #%1"::"r"(&(FLASH_STATE)),"i"(FLASH_STATE_SIGDONE_POS));
    }
}

#if _CLOSE_SERVICE_

/**
  *   FLASH CFG̴־
  *   ޡ
  *   ̴־1CFG̴0
  */
FlagStatus  __attribute__((section(".indata")))
FLASH_Get_CFG_Error_Flag_RAM (void)
{
    if (FLASH_STATE & FLASH_STATE_CFGERROR)
    {
        /* CFG̴ */
        return SET;
    }
    else
    {
        /*  */
        return RESET;
    }
}

/**
  *   FLASH CFG̴־
  *   ޡ
  *   ޡ
  */
void  __attribute__((section(".indata")))
FLASH_Clear_CFG_Error_Flag_RAM (void)
{
    /* д 1  */

    while((FLASH_STATE & FLASH_STATE_CFGERROR)>>FLASH_STATE_CFGERROR_POS)
    {
    	__asm volatile("SET [%0], #%1"::"r"(&(FLASH_STATE)),"i"(FLASH_STATE_CFGERROR_POS));
    }
}
#endif /* _CLOSE_SERVICE_ */

/**
  *   FLASH CheckSumβַ
  *   StartAddr: FLASH CheckSum׵ַַΪ0x0~0xFFFFFӲԵ4λ
  *       StopAddr: FLASH CheckSumβַַΪ0x0~0xFFFFFӲԵ4λ
  *   ޡ
  */
void  __attribute__((section(".indata")))
FLASH_CheckSum_Addr_Config_RAM(uint32_t StartAddr, uint32_t StopAddr)
{
    /* У */
    CHECK_RESTRICTION_RAM(CHECK_FLASH_ADDR_20BITS(StartAddr));
    CHECK_RESTRICTION_RAM(CHECK_FLASH_ADDR_20BITS(StopAddr));

    FLASH_CSSTART = StartAddr;
    FLASH_CSSTOP = StopAddr;
}

/**
  *   FLASHSIGʹܡ
  *   NewState: FLASHSIGʹ״̬ȡֵΪTRUE  FALSE
  *   ޡ
  */
void  __attribute__((section(".indata")))
FLASH_Start_SIG_Compute_Enable_RAM (FunctionalState NewState)
{
    /* У */
    CHECK_RESTRICTION_RAM(CHECK_FUNCTIONAL_STATE(NewState));

    /*---------------- FLASH_CSSTOPĴSIGGOλ ----------------*/
    if (NewState != FALSE)
    {
        /* SIG */
        __asm volatile("SET [%0], #%1"::"r"(&(FLASH_CSSTOP)),"i"(FLASH_CSSTOP_SIGGO_POS));
    }
    else
    {
        /* SIG */
        __asm volatile("CLR [%0], #%1"::"r"(&(FLASH_CSSTOP)),"i"(FLASH_CSSTOP_SIGGO_POS));
    }
}

/**
  *   ȡFLASH CheckSumĽ
  *   CheckSumStruct: FLASH CheckSumϢṹָ룬
  *                       ָָдĵַռ䡣
  *   ޡ
  */
void __attribute__((section(".indata")))
FLASH_Get_CheckSum_Result_RAM (FLASH_CheckSumResult* CheckSumStruct)
{
    uint32_t tmpreg = 0;

    /*---------------- FLASH_CSRESxĴCKSPRESλ ----------------*/
    tmpreg = FLASH_CSRES0;
    CheckSumStruct->m_ResultWord[0] = tmpreg;

    tmpreg = FLASH_CSRES1;
    CheckSumStruct->m_ResultWord[1] = tmpreg;

    tmpreg = FLASH_CSRES2;
    CheckSumStruct->m_ResultWord[2] = tmpreg;

    tmpreg = FLASH_CSRES3;
    CheckSumStruct->m_ResultWord[3] = tmpreg;
}
/**
  *   ##### FLASH洢(FLASH)ú #####
  */


/**
  *   ##### FLASH洢(FLASH)̹ܺ #####
  */
/**
  *   FLASHãûҪȷFLASHд״̬
  *   WipeMode: FLASH ģʽȡֵΪ
  *                   FLASH_WIPE_CODE_PAGE: ҳ
  *                   FLASH_WIPE_CFG_PAGE: ûҳ
  *                   FLASH_WIPE_CODE_ALL: Ƭ
  *       WipeAddr: ַȡֵΪ0x0~0xFFFFFӲԵ10λ
  *   ޡ
  */
void __attribute__((section(".indata")))
FLASH_Wipe_Configuration_RAM (uint32_t WipeMode,uint32_t WipeAddr)
{
    uint32_t tmpreg = 0;

    /* У */
    CHECK_RESTRICTION_RAM(CHECK_FLASH_WIPE_MODE(WipeMode));
    CHECK_RESTRICTION_RAM(CHECK_FLASH_ADDR_20BITS(WipeAddr));



    /* ISPܼĴ */
    FLASH_Unlock_ISP_RAM();

	/* FLASH */
	FLASH_Unlock_Code_RAM();

	/* FLASHû */
	FLASH_Unlock_User_Config_RAM();


    /* ôPAGE */
    if (WipeMode != FLASH_WIPE_CODE_ALL)
    {
        /* ҳ */
        FLASH_ISPADDR = WipeAddr;


        if (FLASH_WIPE_CFG_PAGE == WipeMode)
        {

            /* ʹϢӳ */
            /*---------------- FLASH_ISPCON0ĴIFENλ ----------------*/
            __asm volatile("SET [%0], #%1"::"r"(&(FLASH_ISPCON0)),"i"(FLASH_ISPCON0_IFEN_POS));
        }
        else
        {
            ;
        }
    }
    else
    {
        /* Ƭ */
    }
    /* òģʽ */
    if (WipeMode != FLASH_WIPE_CODE_ALL)
    {
        /* ҳ */
        tmpreg = FLASH_PROGRAM_CMD_PAGE;
    }
    else
    {
        /* Ƭ */
        tmpreg = FLASH_PROGRAM_CMD_ALL_CODE;
    }
    /*---------------- FLASH_ISPCMDĴCMDλ ----------------*/
    FLASH_ISPCMD = SFR_Config_RAM (FLASH_ISPCMD,
                        ~FLASH_ISPCMD_CMD,
                        tmpreg);



    /*  */
    FLASH_Executive_Cmd_RAM();

    while(FLASH_Get_Wipe_Status_RAM());//ȴд

   	FLASH_Zone_Config_RAM (FLASH_NVM_CODE_ZONE);//ص

    //
	FLASH_Clear_NonVolatile_Memory_Unlock_Status_RAM ();//FLASH״̬λ
	FLASH_Clear_Flash_Unlock_Status_RAM ();//FLASH״̬λ
	FLASH_Clear_Config_Unlock_Status_RAM ();//FLASH״̬λ


}

/**
  *   FLASHãûҪȷFLASHд״̬
  *   WipeMode: FLASH ģʽȡֵΪ
  *                   FLASH_WIPE_CODE_PAGE: ҳ
  *                   FLASH_WIPE_CFG_PAGE: ûҳ
  *                   FLASH_WIPE_CODE_ALL: Ƭ
  *       WipeAddr: ַȡֵΪ0x0~0xFFFFFӲԵ10λ
  *   ޡ
  */
void
FLASH_Wipe_Configuration (uint32_t WipeMode,uint32_t WipeAddr)
{
    uint32_t tmpreg = 0;

    /* У */
    CHECK_RESTRICTION(CHECK_FLASH_WIPE_MODE(WipeMode));
    CHECK_RESTRICTION(CHECK_FLASH_ADDR_20BITS(WipeAddr));



    /* ISPܼĴ */
    FLASH_Unlock_ISP();

	/* FLASH */
	FLASH_Unlock_Code();

	/* FLASHû */
	FLASH_Unlock_User_Config();


    /* ôPAGE */
    if (WipeMode != FLASH_WIPE_CODE_ALL)
    {
        /* ҳ */
        FLASH_ISPADDR = WipeAddr;


        if (FLASH_WIPE_CFG_PAGE == WipeMode)
        {

            /* ʹϢӳ */
            /*---------------- FLASH_ISPCON0ĴIFENλ ----------------*/
            SFR_SET_BIT_ASM(FLASH_ISPCON0, FLASH_ISPCON0_IFEN_POS);
        }
        else
        {
            ;
        }
    }
    else
    {
        /* Ƭ */
    }
    /* òģʽ */
    if (WipeMode != FLASH_WIPE_CODE_ALL)
    {
        /* ҳ */
        tmpreg = FLASH_PROGRAM_CMD_PAGE;
    }
    else
    {
        /* Ƭ */
        tmpreg = FLASH_PROGRAM_CMD_ALL_CODE;
    }
    /*---------------- FLASH_ISPCMDĴCMDλ ----------------*/
    FLASH_ISPCMD = SFR_Config (FLASH_ISPCMD,
                        ~FLASH_ISPCMD_CMD,
                        tmpreg);



    /*  */
    FLASH_Executive_Cmd();

    while(FLASH_Get_Wipe_Status());//ȴд

   	FLASH_Zone_Config_RAM (FLASH_NVM_CODE_ZONE);//ص

    //
	FLASH_Clear_NonVolatile_Memory_Unlock_Status ();//FLASH״̬λ
	FLASH_Clear_Flash_Unlock_Status ();//FLASH״̬λ
	FLASH_Clear_Config_Unlock_Status ();//FLASH״̬λ


}


/**
  *   FLASH̲ãûҪȷFLASHд״̬   RAM
  *   flashProgramStruct: FLASHϢṹָ롣
  *   ޡ
  */
void __attribute__((section(".indata")))
FLASH_Program_Configuration_RAM (FLASH_ProgramTypeDef * flashProgramStruct)
{
	uint32_t tmpreg = 0;
	uint32_t tmpaddr = 0;
	uint32_t * tmpptr = NULL;

    /* У */

	CHECK_RESTRICTION_RAM(CHECK_FLASH_PROGRAM_MODE(flashProgramStruct->m_Mode));
	CHECK_RESTRICTION_RAM(CHECK_FLASH_PROGRAM_ZONE(flashProgramStruct->m_Zone));
	CHECK_RESTRICTION_RAM(CHECK_FLASH_ADDR_20BITS(flashProgramStruct->m_Addr));
	CHECK_RESTRICTION_RAM(CHECK_FLASH_WRITE_SIZE(flashProgramStruct->m_WriteSize));

    /* Ĵ */




    FLASH_Unlock_ISP_RAM();
    FLASH_Unlock_User_Config_RAM();
    FLASH_Unlock_Code_RAM();




    /*---------------- FLASH_ISPCON0ĴDWENλ ----------------*/
    __asm volatile("SET [%0], #%1"::"r"(&(FLASH_ISPCON0)),"i"(FLASH_ISPCON0_DWEN_POS));

    if (flashProgramStruct->m_Zone != FLASH_PROGRAM_CODE)
    {
        /*---------------- FLASH_ISPCON0ĴIFENλ ----------------*/
        __asm volatile("SET [%0], #%1"::"r"(&(FLASH_ISPCON0)),"i"(FLASH_ISPCON0_IFEN_POS));

    }
    else
    {
    }

    /* ʹʱ޸Ľṹ */
	  tmpaddr = flashProgramStruct->m_Addr;
	  tmpptr =  flashProgramStruct->m_Data;

    /* ñģʽ */
    if (flashProgramStruct->m_Mode != FLASH_PROGRAM_WORD)
    {
        /* ҳ */
        /*----------- FLASH_ISPCMDĴCMD/WSIZEλ -----------*/
        tmpreg = flashProgramStruct->m_Mode \
               | (flashProgramStruct->m_WriteSize << FLASH_ISPCMD_WSIZE0_POS);
        FLASH_ISPCMD = SFR_Config_RAM(FLASH_ISPCMD,
                            ~(FLASH_ISPCMD_CMD | FLASH_ISPCMD_WSIZE),
                            tmpreg);
        FLASH_Executive_Cmd_RAM();
		unsigned char j;
		for(j=0;j<=0x3f;j++)//0x3fֵ
		{
			__asm volatile("ST.w [%0], %1"::"r"(tmpaddr),"r"(*tmpptr));
			tmpaddr=tmpaddr+4;
			tmpptr++;
			__asm volatile("ST.w [%0], %1"::"r"(tmpaddr),"r"(*tmpptr));
			tmpaddr=tmpaddr+4;
			tmpptr++;
			while(FLASH_Get_Program_Status_RAM());
		}
    }
    else
    {
        /* ֱ */
        /*------------- FLASH_ISPCMDĴCMDλ --------------*/
        FLASH_ISPCMD = SFR_Config_RAM (FLASH_ISPCMD,
                            ~FLASH_ISPCMD_CMD,
                            flashProgramStruct->m_Mode);
        /* ֱ̣ȼݣ󴥷 */
        /* 64λ */

    	__asm volatile("ST.w [%0], %1"::"r"(tmpaddr),"r"(*tmpptr));
    	tmpaddr=tmpaddr+4;
    	tmpptr++;
    	__asm volatile("ST.w [%0], %1"::"r"(tmpaddr),"r"(*tmpptr));

        /*  */

        FLASH_Executive_Cmd_RAM();

    }

    while(FLASH_Get_Wipe_Status_RAM());//ȴд

    /*---------------- FLASH_ISPCON0ĴDWENλ ----------------*/


   	FLASH_Zone_Config_RAM (FLASH_NVM_CODE_ZONE);//ص

   	FLASH_Data_Write_Enable_RAM (FALSE);
    //
	FLASH_Clear_NonVolatile_Memory_Unlock_Status_RAM ();//FLASH״̬λ
	FLASH_Clear_Flash_Unlock_Status_RAM ();//FLASH״̬λ
	FLASH_Clear_Config_Unlock_Status_RAM ();//FLASH״̬λ

}
/**
  *   FLASH̲ãûҪȷFLASHд״̬   RAM
  *   flashProgramStruct: FLASHϢṹָ롣
  *   ޡ
  */
void
FLASH_Program_Configuration (FLASH_ProgramTypeDef * flashProgramStruct)
{
	uint32_t tmpreg = 0;
	uint32_t tmpaddr = 0;
	uint32_t * tmpptr = NULL;

    /* У */

	CHECK_RESTRICTION(CHECK_FLASH_PROGRAM_MODE(flashProgramStruct->m_Mode));
	CHECK_RESTRICTION(CHECK_FLASH_PROGRAM_ZONE(flashProgramStruct->m_Zone));
	CHECK_RESTRICTION(CHECK_FLASH_ADDR_20BITS(flashProgramStruct->m_Addr));
	CHECK_RESTRICTION(CHECK_FLASH_WRITE_SIZE(flashProgramStruct->m_WriteSize));

    /* Ĵ */




    FLASH_Unlock_ISP();
    FLASH_Unlock_User_Config();
    FLASH_Unlock_Code();




    /*---------------- FLASH_ISPCON0ĴDWENλ ----------------*/
    SFR_SET_BIT_ASM(FLASH_ISPCON0, FLASH_ISPCON0_DWEN_POS);

    if (flashProgramStruct->m_Zone != FLASH_PROGRAM_CODE)
    {
        /*---------------- FLASH_ISPCON0ĴIFENλ ----------------*/
        SFR_SET_BIT_ASM(FLASH_ISPCON0, FLASH_ISPCON0_IFEN_POS);

    }
    else
    {
    }

    /* ʹʱ޸Ľṹ */
	  tmpaddr = flashProgramStruct->m_Addr;
	  tmpptr =  flashProgramStruct->m_Data;

    /* ñģʽ */
    if (flashProgramStruct->m_Mode != FLASH_PROGRAM_WORD)
    {
        /* ҳ */
        /*----------- FLASH_ISPCMDĴCMD/WSIZEλ -----------*/
        tmpreg = flashProgramStruct->m_Mode \
               | (flashProgramStruct->m_WriteSize << FLASH_ISPCMD_WSIZE0_POS);
        FLASH_ISPCMD = SFR_Config(FLASH_ISPCMD,
                            ~(FLASH_ISPCMD_CMD | FLASH_ISPCMD_WSIZE),
                            tmpreg);
        FLASH_Executive_Cmd();
		unsigned char j;
		for(j=0;j<=0x3f;j++)//0x3fֵ
		{
			__asm volatile("ST.w [%0], %1"::"r"(tmpaddr),"r"(*tmpptr));
			tmpaddr=tmpaddr+4;
			tmpptr++;
			__asm volatile("ST.w [%0], %1"::"r"(tmpaddr),"r"(*tmpptr));
			tmpaddr=tmpaddr+4;
			tmpptr++;
			while(FLASH_Get_Program_Status());
		}
    }
    else
    {
        /* ֱ */
        /*------------- FLASH_ISPCMDĴCMDλ --------------*/
        FLASH_ISPCMD = SFR_Config (FLASH_ISPCMD,
                            ~FLASH_ISPCMD_CMD,
                            flashProgramStruct->m_Mode);
        /* ֱ̣ȼݣ󴥷 */
        /* 64λ */

    	__asm volatile("ST.w [%0], %1"::"r"(tmpaddr),"r"(*tmpptr));
    	tmpaddr=tmpaddr+4;
    	tmpptr++;
    	__asm volatile("ST.w [%0], %1"::"r"(tmpaddr),"r"(*tmpptr));

        /*  */

        FLASH_Executive_Cmd();

    }

    while(FLASH_Get_Wipe_Status());//ȴд

    /*---------------- FLASH_ISPCON0ĴDWENλ ----------------*/


   	FLASH_Zone_Config (FLASH_NVM_CODE_ZONE);//ص

   	FLASH_Data_Write_Enable_RAM (FALSE);
    //
	FLASH_Clear_NonVolatile_Memory_Unlock_Status ();//FLASH״̬λ
	FLASH_Clear_Flash_Unlock_Status ();//FLASH״̬λ
	FLASH_Clear_Config_Unlock_Status ();//FLASH״̬λ

}
/**
  *   ##### FLASH洢(FLASH)̹ܺ #####
  */

/**
  *   ȡflashĳϢ(RAM)
  * :address(ȡַ,ZoneSelectȡѡ
  *   ַָ32λ
  */
uint32_t read_data;
uint32_t __attribute__((section(".indata")))
Read_Flash_or_CFR_RAM (uint32_t address,uint32_t ZoneSelect)
{
	uint32_t *read_adr;
	CHECK_RESTRICTION_RAM(CHECK_FLASH_PROGRAM_ZONE(ZoneSelect));
	//
	FLASH_Unlock_ISP_RAM();
	FLASH_Unlock_User_Config_RAM();
	FLASH_Unlock_Code_RAM();
	if(ZoneSelect!=FLASH_PROGRAM_CFG)
	{
		read_adr = (uint32_t *)address;
		read_data = *read_adr;
	}
	else
	{
		FLASH_Zone_Config_RAM (FLASH_NVM_INFORMATION_ZONE);//еϢ
		read_adr = (uint32_t *)address;
		read_data = *read_adr;
		FLASH_Zone_Config_RAM (FLASH_NVM_CODE_ZONE);//ص
	}
	 //
	FLASH_Clear_NonVolatile_Memory_Unlock_Status ();//FLASH״̬λ
	FLASH_Clear_Flash_Unlock_Status ();//FLASH״̬λ
	FLASH_Clear_Config_Unlock_Status ();//FLASH״̬λ
	return read_data;

}

/**
  *   ȡflashĳϢ
  * :address(ȡַ,ZoneSelectȡѡ
  *   ַָ32λ
  */
uint32_t Read_Flash_or_CFR (uint32_t address,uint32_t ZoneSelect)
{
	uint32_t *read_adr;
	CHECK_RESTRICTION(CHECK_FLASH_PROGRAM_ZONE(ZoneSelect));
	//
	FLASH_Unlock_ISP_RAM();
	FLASH_Unlock_User_Config_RAM();
	FLASH_Unlock_Code_RAM();
	if(ZoneSelect!=FLASH_PROGRAM_CFG)
	{
		read_adr = (uint32_t *)address;
		read_data = *read_adr;
	}
	else
	{
		FLASH_Zone_Config_RAM (FLASH_NVM_INFORMATION_ZONE);//еϢ
		read_adr = (uint32_t *)address;
		read_data = *read_adr;
		FLASH_Zone_Config_RAM (FLASH_NVM_CODE_ZONE);//ص
	}
	 //
	FLASH_Clear_NonVolatile_Memory_Unlock_Status ();//FLASH״̬λ
	FLASH_Clear_Flash_Unlock_Status ();//FLASH״̬λ
	FLASH_Clear_Config_Unlock_Status ();//FLASH״̬λ
	return read_data;

}

/**
  *   ȡоƬΨһID
  * :
  *   ӦΨһID
  */
uint32_t  Read_Soft_Device_ID1(void)
{
	uint32_t Soft_Device_ID1;
	Soft_Device_ID1 = Read_Flash_or_CFR(0x444,FLASH_PROGRAM_CFG);
	return Soft_Device_ID1;
}
uint32_t  Read_Soft_Device_ID2(void)
{
	uint32_t Soft_Device_ID2;
	Soft_Device_ID2 = Read_Flash_or_CFR(0x448,FLASH_PROGRAM_CFG);
	return Soft_Device_ID2;
}
uint32_t  Read_Soft_Device_ID3(void)
{
	uint32_t Soft_Device_ID3;
	Soft_Device_ID3 = Read_Flash_or_CFR(0x44C,FLASH_PROGRAM_CFG);
	return Soft_Device_ID3;
}
uint32_t  Read_Soft_Device_ID4(void)
{
	uint32_t Soft_Device_ID4;
	Soft_Device_ID4 = Read_Flash_or_CFR(0x450,FLASH_PROGRAM_CFG);
	return Soft_Device_ID4;
}
