/**
  ******************************************************************************
  * ļ  kf32a_basic_dma.c
  *     ChipON_AE/FAE_Group
  *     V3.0.1
  *     2021-11-25
  *     ļṩDMAģ(DMA)صĹܺ
  *          + DMAģ(DMA)ʼ
  *          + DMAģ(DMA)ú
  *          + DMAģ(DMA)жϹ
  *
  *********************************************************************
  */

#include "kf32a_basic_dma.h"
#include "kf32a_basic_rst.h"
#include "kf32a_basic_pclk.h"


/* ʱ˽ж ----------------------------------------------------*/
/* DMA_CTLRyĴʼ */
#define DMA_CTLR_INIT_MASK              (DMA_CTLR_NUMODT \
                                       | DMA_CTLR_CPL \
                                       | DMA_CTLR_PDS \
                                       | DMA_CTLR_MDS \
                                       | DMA_CTLR_PINC \
                                       | DMA_CTLR_MINC \
                                       | DMA_CTLR_LPM \
                                       | DMA_CTLR_DDIR \
                                       | DMA_CTLR_BLKM)

/**
  *   ##### DMAģ(DMA)ʼ #####
  */
/**
  *   λDMA裬ʹʱӡ
  *   DMAx: ָDMAڴṹָ룬ȡֵΪDMA0_SFRDMA1_SFR
  *   ޡ
  */
void
DMA_Reset (DMA_SFRmap* DMAx)
{
    /* У */
    CHECK_RESTRICTION(CHECK_DMA_ALL_PERIPH(DMAx));
#ifdef KF32A_Periph_dma0
    if (DMAx == DMA0_SFR)
    {
        RST_CTL2_Peripheral_Reset_Enable(RST_CTL2_DMA0RST, TRUE);
        RST_CTL2_Peripheral_Reset_Enable(RST_CTL2_DMA0RST, FALSE);
        PCLK_CTL2_Peripheral_Clock_Enable(PCLK_CTL2_DMA0CLKEN, TRUE);
    }
#endif
#ifdef KF32A_Periph_dma1
    if (DMAx == DMA1_SFR)
    {
        RST_CTL2_Peripheral_Reset_Enable(RST_CTL2_DMA1RST, TRUE);
        RST_CTL2_Peripheral_Reset_Enable(RST_CTL2_DMA1RST, FALSE);
        PCLK_CTL2_Peripheral_Clock_Enable(PCLK_CTL2_DMA1CLKEN, TRUE);
    }
#endif
}

/**
  *   DMAģ(DMA)ʼá
  *   DMAx: ָDMAڴṹָ룬ȡֵΪDMA0_SFRDMA1_SFR
  *       dmaInitStruct: DMAģϢṹָ롣
  *   ޡ
  */
void
DMA_Configuration (DMA_SFRmap* DMAx,
                    DMA_InitTypeDef* dmaInitStruct)
{
    uint32_t tmpreg = 0;
    uint32_t tmpchannel = 0;

    /* У */
    CHECK_RESTRICTION(CHECK_DMA_ALL_PERIPH(DMAx));
    CHECK_RESTRICTION(CHECK_DMA_CHANNEL(dmaInitStruct->m_Channel));
    CHECK_RESTRICTION(CHECK_DMA_CHANNEL_PRIORITY(dmaInitStruct->m_Priority));
    CHECK_RESTRICTION(CHECK_DMA_DIRECTION(dmaInitStruct->m_Direction));
    CHECK_RESTRICTION(CHECK_DMA_DATA_WIDTH(dmaInitStruct->m_PeripheralDataSize));
    CHECK_RESTRICTION(CHECK_DMA_DATA_WIDTH(dmaInitStruct->m_MemoryDataSize));
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(dmaInitStruct->m_PeripheralInc));
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(dmaInitStruct->m_MemoryInc));
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(dmaInitStruct->m_LoopMode));
    CHECK_RESTRICTION(CHECK_DMA_TRANSFER_MODE(dmaInitStruct->m_BlockMode));

    tmpchannel = dmaInitStruct->m_Channel;

    /*---------------- DMAx_CTLRyĴ ----------------*/
    /* ݽṹԱm_NumberNUMODTλ */
    /* ݽṹԱm_PriorityCPLλ */
    /* ݽṹԱm_PeripheralDataSizePDSλ */
    /* ݽṹԱm_MemoryDataSizeMDSλ */
    /* ݽṹԱm_PeripheralIncPINCλ */
    /* ݽṹԱm_MemoryIncMINCλ */
    /* ݽṹԱm_LoopModeLPMλ */
    /* ݽṹԱm_DirectionDDIRλ */
    /* ݽṹԱm_BlockModeBLKMλ */
    tmpreg = ((uint32_t)dmaInitStruct->m_Number << DMA_CTLR_NUMODT0_POS) \
           | ((uint32_t)dmaInitStruct->m_Priority) \
           | ((uint32_t)dmaInitStruct->m_PeripheralDataSize << DMA_CTLR_PDS0_POS) \
           | ((uint32_t)dmaInitStruct->m_MemoryDataSize << DMA_CTLR_MDS0_POS) \
           | (dmaInitStruct->m_PeripheralInc << DMA_CTLR_PINC_POS) \
           | (dmaInitStruct->m_MemoryInc << DMA_CTLR_MINC_POS) \
           | (dmaInitStruct->m_LoopMode << DMA_CTLR_LPM_POS) \
           | ((uint32_t)dmaInitStruct->m_Direction) \
           | (dmaInitStruct->m_BlockMode);
    DMAx->CTLR[tmpchannel] = SFR_Config (DMAx->CTLR[tmpchannel],
                          ~DMA_CTLR_INIT_MASK,
                          tmpreg);

    /*--------- DMAx_PADDRyַĴ ---------*/
    DMAx->PADDR[tmpchannel] = dmaInitStruct->m_PeriphAddr;

    /*--------- DMAx_MADDRyַĴ ---------*/
    DMAx->MADDR[tmpchannel] = dmaInitStruct->m_MemoryAddr;
}

/**
  *   ʼDMAϢṹ塣
  *   dmaInitStruct: ָʼĽṹָ롣
  *   ޡ
  */
void
DMA_Struct_Init (DMA_InitTypeDef* dmaInitStruct)
{
    /* ʼ DMAͨѡ */
    dmaInitStruct->m_Channel = DMA_CHANNEL_1;
    /* ʼ DMAͨȼ */
    dmaInitStruct->m_Priority = DMA_CHANNEL_LOWER;
    /* ʼ DMA䷽ */
    dmaInitStruct->m_Direction = DMA_PERIPHERAL_TO_MEMORY;
    /* ʼ λ */
    dmaInitStruct->m_PeripheralDataSize = DMA_DATA_WIDTH_8_BITS;
    /* ʼ 洢λ */
    dmaInitStruct->m_MemoryDataSize = DMA_DATA_WIDTH_8_BITS;
    /* ʼ ݸ */
    dmaInitStruct->m_Number = 0;
    /* ʼ ַģʽʹ */
    dmaInitStruct->m_PeripheralInc = FALSE;
    /* ʼ 洢ַģʽʹ */
    dmaInitStruct->m_MemoryInc = FALSE;
    /* ʼ ѭģʽʹ */
    dmaInitStruct->m_LoopMode = FALSE;
    /* ʼ ݿ鴫ģʽ */
    dmaInitStruct->m_BlockMode = DMA_TRANSFER_BYTE;
    /* ʼ ʼַ */
    dmaInitStruct->m_PeriphAddr = 0;
    /* ʼ ڴʼַ */
    dmaInitStruct->m_MemoryAddr = 0;
}
/**
  *   ##### DMAģ(DMA)ʼ #####
  */


/**
  *   ##### DMAģ(DMA)ú #####
  */
/**
  *   DMA
  *   DMAx: ָDMAڴṹָ룬ȡֵΪDMA0_SFRDMA1_SFR
  *       Channel: DMAͨѡȡֵΧΪ:
  *                  DMA_CHANNEL_1: ͨ1
  *                  DMA_CHANNEL_2: ͨ2
  *                  DMA_CHANNEL_3: ͨ3
  *                  DMA_CHANNEL_4: ͨ4
  *                  DMA_CHANNEL_5: ͨ5
  *                  DMA_CHANNEL_6: ͨ6
  *                  DMA_CHANNEL_7: ͨ7
  *       Number: ҪݸȡֵΧΪ0~65535
  *   ޡ
  */
void
DMA_Transfer_Number_Config (DMA_SFRmap* DMAx,
                    uint32_t Channel, uint16_t Number)
{
    uint32_t tmpreg = 0;

    /* У */
    CHECK_RESTRICTION(CHECK_DMA_ALL_PERIPH(DMAx));
    CHECK_RESTRICTION(CHECK_DMA_CHANNEL(Channel));

    /*---------------- DMA_CTLRĴNUMODTλ ----------------*/
    tmpreg = (uint32_t)Number << DMA_CTLR_NUMODT0_POS;
    DMAx->CTLR[Channel] = SFR_Config (DMAx->CTLR[Channel],
                                ~DMA_CTLR_NUMODT,
                                tmpreg);
}

/**
  *   ô洢洢ʹܡ
  *   DMAx: ָDMAڴṹָ룬ȡֵΪDMA0_SFRDMA1_SFR
  *       Channel: DMAͨѡȡֵΧΪ:
  *                  DMA_CHANNEL_1: ͨ1
  *                  DMA_CHANNEL_2: ͨ2
  *                  DMA_CHANNEL_3: ͨ3
  *                  DMA_CHANNEL_4: ͨ4
  *                  DMA_CHANNEL_5: ͨ5
  *                  DMA_CHANNEL_6: ͨ6
  *                  DMA_CHANNEL_7: ͨ7
  *       NewState: 洢洢ʹ״̬ȡֵΪTRUE  FALSE
  *   ޡ
  */
void
DMA_Memory_To_Memory_Enable (DMA_SFRmap* DMAx,
                    uint32_t Channel, FunctionalState NewState)
{
    /* У */
    CHECK_RESTRICTION(CHECK_DMA_ALL_PERIPH(DMAx));
    CHECK_RESTRICTION(CHECK_DMA_CHANNEL(Channel));
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

    /*---------------- DMA_CTLRĴM2Mλ ----------------*/
    if (NewState != FALSE)
    {
        /* ʹܴ洢洢 */
        SFR_SET_BIT_ASM(DMAx->CTLR[Channel], DMA_CTLR_M2M_POS);
    }
    else
    {
        /* δʹܴ洢洢 */
        SFR_CLR_BIT_ASM(DMAx->CTLR[Channel], DMA_CTLR_M2M_POS);
    }
}

/**
  *   DMAͨȼ
  *   DMAx: ָDMAڴṹָ룬ȡֵΪDMA0_SFRDMA1_SFR
  *       Channel: DMAͨѡȡֵΧΪ:
  *                  DMA_CHANNEL_1: ͨ1
  *                  DMA_CHANNEL_2: ͨ2
  *                  DMA_CHANNEL_3: ͨ3
  *                  DMA_CHANNEL_4: ͨ4
  *                  DMA_CHANNEL_5: ͨ5
  *                  DMA_CHANNEL_6: ͨ6
  *                  DMA_CHANNEL_7: ͨ7
  *       Priority: ͨȼȡֵΪ
  *                   DMA_CHANNEL_LOWER: ȼ
  *                   DMA_CHANNEL_MEDIUM: ȼ
  *                   DMA_CHANNEL_HIGHER: ȼ
  *                   DMA_CHANNEL_TOP: ȼ
  *   ޡ
  */
void
DMA_Channel_Priority_Config (DMA_SFRmap* DMAx,
                    uint32_t Channel, uint32_t Priority)
{
    uint32_t tmpreg = 0;

    /* У */
    CHECK_RESTRICTION(CHECK_DMA_ALL_PERIPH(DMAx));
    CHECK_RESTRICTION(CHECK_DMA_CHANNEL(Channel));
    CHECK_RESTRICTION(CHECK_DMA_CHANNEL_PRIORITY(Priority));

    /*---------------- DMA_CTLRĴCPLλ ----------------*/
    tmpreg = (uint32_t)Priority << DMA_CTLR_CPL0_POS;
    DMAx->CTLR[Channel] = SFR_Config (DMAx->CTLR[Channel],
                                ~DMA_CTLR_CPL,
                                tmpreg);
}

/**
  *   DMAλ
  *   DMAx: ָDMAڴṹָ룬ȡֵΪDMA0_SFRDMA1_SFR
  *       Channel: DMAͨѡȡֵΧΪ:
  *                  DMA_CHANNEL_1: ͨ1
  *                  DMA_CHANNEL_2: ͨ2
  *                  DMA_CHANNEL_3: ͨ3
  *                  DMA_CHANNEL_4: ͨ4
  *                  DMA_CHANNEL_5: ͨ5
  *                  DMA_CHANNEL_6: ͨ6
  *                  DMA_CHANNEL_7: ͨ7
  *       Width: λȡֵΪ
  *                DMA_DATA_WIDTH_8_BITS: Ϊ8λ
  *                DMA_DATA_WIDTH_16_BITS: Ϊ16λ
  *                DMA_DATA_WIDTH_32_BITS: Ϊ32λ
  *   ޡ
  */
void
DMA_Peripheral_Data_Width_Config (DMA_SFRmap* DMAx,
                    uint32_t Channel, uint32_t Width)
{
    uint32_t tmpreg = 0;

    /* У */
    CHECK_RESTRICTION(CHECK_DMA_ALL_PERIPH(DMAx));
    CHECK_RESTRICTION(CHECK_DMA_CHANNEL(Channel));
    CHECK_RESTRICTION(CHECK_DMA_DATA_WIDTH(Width));

    /*---------------- DMA_CTLRĴPDSλ ----------------*/
    tmpreg = Width << DMA_CTLR_PDS0_POS;
    DMAx->CTLR[Channel] = SFR_Config (DMAx->CTLR[Channel],
                                ~DMA_CTLR_PDS,
                                tmpreg);
}

/**
  *   DMA洢λ
  *   DMAx: ָDMAڴṹָ룬ȡֵΪDMA0_SFRDMA1_SFR
  *       Channel: DMAͨѡȡֵΧΪ:
  *                  DMA_CHANNEL_1: ͨ1
  *                  DMA_CHANNEL_2: ͨ2
  *                  DMA_CHANNEL_3: ͨ3
  *                  DMA_CHANNEL_4: ͨ4
  *                  DMA_CHANNEL_5: ͨ5
  *                  DMA_CHANNEL_6: ͨ6
  *                  DMA_CHANNEL_7: ͨ7
  *       Width: 洢λȡֵΪ
  *                DMA_DATA_WIDTH_8_BITS: Ϊ8λ
  *                DMA_DATA_WIDTH_16_BITS: Ϊ16λ
  *                DMA_DATA_WIDTH_32_BITS: Ϊ32λ
  *   ޡ
  */
void
DMA_Memory_Data_Width_Config (DMA_SFRmap* DMAx,
                    uint32_t Channel, uint32_t Width)
{
    uint32_t tmpreg = 0;

    /* У */
    CHECK_RESTRICTION(CHECK_DMA_ALL_PERIPH(DMAx));
    CHECK_RESTRICTION(CHECK_DMA_CHANNEL(Channel));
    CHECK_RESTRICTION(CHECK_DMA_DATA_WIDTH(Width));

    /*---------------- DMA_CTLRĴMDSλ ----------------*/
    tmpreg = Width << DMA_CTLR_MDS0_POS;
    DMAx->CTLR[Channel] = SFR_Config (DMAx->CTLR[Channel],
                                ~DMA_CTLR_MDS,
                                tmpreg);
}

/**
  *   ַģʽʹܡ
  *   DMAx: ָDMAڴṹָ룬ȡֵΪDMA0_SFRDMA1_SFR
  *       Channel: DMAͨѡȡֵΧΪ:
  *                  DMA_CHANNEL_1: ͨ1
  *                  DMA_CHANNEL_2: ͨ2
  *                  DMA_CHANNEL_3: ͨ3
  *                  DMA_CHANNEL_4: ͨ4
  *                  DMA_CHANNEL_5: ͨ5
  *                  DMA_CHANNEL_6: ͨ6
  *                  DMA_CHANNEL_7: ͨ7
  *       NewState: ַģʽʹ״̬ȡֵΪTRUE  FALSE
  *   ޡ
  */
void
DMA_Peripheral_addr_increase_Enable (DMA_SFRmap* DMAx,
                    uint32_t Channel, FunctionalState NewState)
{
    /* У */
    CHECK_RESTRICTION(CHECK_DMA_ALL_PERIPH(DMAx));
    CHECK_RESTRICTION(CHECK_DMA_CHANNEL(Channel));
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

    /*---------------- DMA_CTLRĴPINCλ ----------------*/
    if (NewState != FALSE)
    {
        /* ʹַģʽ */
        SFR_SET_BIT_ASM(DMAx->CTLR[Channel], DMA_CTLR_PINC_POS);
    }
    else
    {
        /* δʹַģʽ */
        SFR_CLR_BIT_ASM(DMAx->CTLR[Channel], DMA_CTLR_PINC_POS);
    }
}

/**
  *   ô洢ַģʽʹܡ
  *   DMAx: ָDMAڴṹָ룬ȡֵΪDMA0_SFRDMA1_SFR
  *       Channel: DMAͨѡȡֵΧΪ:
  *                  DMA_CHANNEL_1: ͨ1
  *                  DMA_CHANNEL_2: ͨ2
  *                  DMA_CHANNEL_3: ͨ3
  *                  DMA_CHANNEL_4: ͨ4
  *                  DMA_CHANNEL_5: ͨ5
  *                  DMA_CHANNEL_6: ͨ6
  *                  DMA_CHANNEL_7: ͨ7
  *       NewState: 洢ַģʽʹ״̬ȡֵΪTRUE  FALSE
  *   ޡ
  */
void
DMA_Memory_addr_increase_Enable (DMA_SFRmap* DMAx,
                    uint32_t Channel, FunctionalState NewState)
{
    /* У */
    CHECK_RESTRICTION(CHECK_DMA_ALL_PERIPH(DMAx));
    CHECK_RESTRICTION(CHECK_DMA_CHANNEL(Channel));
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

    /*---------------- DMA_CTLRĴMINCλ ----------------*/
    if (NewState != FALSE)
    {
        /* ʹܴ洢ַģʽ */
        SFR_SET_BIT_ASM(DMAx->CTLR[Channel], DMA_CTLR_MINC_POS);
    }
    else
    {
        /* δʹܴ洢ַģʽ */
        SFR_CLR_BIT_ASM(DMAx->CTLR[Channel], DMA_CTLR_MINC_POS);
    }
}

/**
  *   ѭģʽʹܡ
  *   DMAx: ָDMAڴṹָ룬ȡֵΪDMA0_SFRDMA1_SFR
  *       Channel: DMAͨѡȡֵΧΪ:
  *                  DMA_CHANNEL_1: ͨ1
  *                  DMA_CHANNEL_2: ͨ2
  *                  DMA_CHANNEL_3: ͨ3
  *                  DMA_CHANNEL_4: ͨ4
  *                  DMA_CHANNEL_5: ͨ5
  *                  DMA_CHANNEL_6: ͨ6
  *                  DMA_CHANNEL_7: ͨ7
  *       NewState: ѭģʽʹ״̬ȡֵΪTRUE  FALSE
  *   ޡ
  */
void
DMA_Loop_Mode_Enable (DMA_SFRmap* DMAx,
                    uint32_t Channel, FunctionalState NewState)
{
    /* У */
    CHECK_RESTRICTION(CHECK_DMA_ALL_PERIPH(DMAx));
    CHECK_RESTRICTION(CHECK_DMA_CHANNEL(Channel));
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

    /*---------------- DMA_CTLRĴLPMλ ----------------*/
    if (NewState != FALSE)
    {
        /* ʹѭģʽ */
        SFR_SET_BIT_ASM(DMAx->CTLR[Channel], DMA_CTLR_LPM_POS);
    }
    else
    {
        /* δʹѭģʽ */
        SFR_CLR_BIT_ASM(DMAx->CTLR[Channel], DMA_CTLR_LPM_POS);
    }
}

/**
  *   ݷơ
  *   DMAx: ָDMAڴṹָ룬ȡֵΪDMA0_SFRDMA1_SFR
  *       Channel: DMAͨѡȡֵΧΪ:
  *                  DMA_CHANNEL_1: ͨ1
  *                  DMA_CHANNEL_2: ͨ2
  *                  DMA_CHANNEL_3: ͨ3
  *                  DMA_CHANNEL_4: ͨ4
  *                  DMA_CHANNEL_5: ͨ5
  *                  DMA_CHANNEL_6: ͨ6
  *                  DMA_CHANNEL_7: ͨ7
  *       Direction: ݷ״̬ȡֵΪ
  *                    DMA_PERIPHERAL_TO_MEMORY: ݴַȡ洢ַ
  *                    DMA_MEMORY_TO_PERIPHERAL: ݴӴ洢ַȡַ
  *   ޡ
  */
void
DMA_Transfer_Direction_Config (DMA_SFRmap* DMAx,
                    uint32_t Channel, uint32_t Direction)
{
    /* У */
    CHECK_RESTRICTION(CHECK_DMA_ALL_PERIPH(DMAx));
    CHECK_RESTRICTION(CHECK_DMA_CHANNEL(Channel));
    CHECK_RESTRICTION(CHECK_DMA_DIRECTION(Direction));

    /*---------------- DMA_CTLRĴDDIRλ ----------------*/
    if (Direction != DMA_PERIPHERAL_TO_MEMORY)
    {
        /* ݴӴ洢ַȡַ */
        SFR_SET_BIT_ASM(DMAx->CTLR[Channel], DMA_CTLR_DDIR_POS);
    }
    else
    {
        /* ݴַȡ洢ַ */
        SFR_CLR_BIT_ASM(DMAx->CTLR[Channel], DMA_CTLR_DDIR_POS);
    }
}

/**
  *   ݿ鴫ģʽ
  *   DMAx: ָDMAڴṹָ룬ȡֵΪDMA0_SFRDMA1_SFR
  *       Channel: DMAͨѡȡֵΧΪ:
  *                  DMA_CHANNEL_1: ͨ1
  *                  DMA_CHANNEL_2: ͨ2
  *                  DMA_CHANNEL_3: ͨ3
  *                  DMA_CHANNEL_4: ͨ4
  *                  DMA_CHANNEL_5: ͨ5
  *                  DMA_CHANNEL_6: ͨ6
  *                  DMA_CHANNEL_7: ͨ7
  *       BlockMode: ݿ鴫ģʽȡֵΪ
  *                    DMA_TRANSFER_BYTE: ݰֽڴ
  *                    DMA_TRANSFER_BLOCK: ݰտ鴫
  *   ޡ
  */
void
DMA_Transfer_Mode_Config (DMA_SFRmap* DMAx,
                    uint32_t Channel, uint32_t BlockMode)
{
    /* У */
    CHECK_RESTRICTION(CHECK_DMA_ALL_PERIPH(DMAx));
    CHECK_RESTRICTION(CHECK_DMA_CHANNEL(Channel));
    CHECK_RESTRICTION(CHECK_DMA_TRANSFER_MODE(BlockMode));

    /*---------------- DMA_CTLRĴBLKMλ ----------------*/
    if (BlockMode != DMA_TRANSFER_BYTE)
    {
        /* ݰտ鴫 */
        SFR_SET_BIT_ASM(DMAx->CTLR[Channel], DMA_CTLR_BLKM_POS);
    }
    else
    {
        /* ݰֽڴ */
        SFR_CLR_BIT_ASM(DMAx->CTLR[Channel], DMA_CTLR_BLKM_POS);
    }
}

/**
  *   DMAͨδģʽʹܡ
  *   DMAx: ָDMAڴṹָ룬ȡֵΪDMA0_SFRDMA1_SFR
  *       Channel: DMAͨѡȡֵΧΪ:
  *                  DMA_CHANNEL_1: ͨ1
  *                  DMA_CHANNEL_2: ͨ2
  *                  DMA_CHANNEL_3: ͨ3
  *                  DMA_CHANNEL_4: ͨ4
  *                  DMA_CHANNEL_5: ͨ5
  *                  DMA_CHANNEL_6: ͨ6
  *                  DMA_CHANNEL_7: ͨ7
  *       NewState: DMAͨChannelʹ״̬ȡֵΪTRUE  FALSE
  *   ޡ
  */
void
DMA_Oneshot_Enable (DMA_SFRmap* DMAx,
                    uint32_t Channel, FunctionalState NewState)
{
    /* У */
    CHECK_RESTRICTION(CHECK_DMA_ALL_PERIPH(DMAx));
    CHECK_RESTRICTION(CHECK_DMA_CHANNEL(Channel));
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

    /*---------------- DMA_CTLRĴDMAENλ ----------------*/
    if (NewState != FALSE)
    {
        /* ʹDMAδ */
        SFR_SET_BIT_ASM(DMAx->CTLR[Channel], DMA_CTLR_ONESHOT_POS);
    }
    else
    {
        /* δʹDMAδ */
        SFR_CLR_BIT_ASM(DMAx->CTLR[Channel], DMA_CTLR_ONESHOT_POS);
    }
}
/**
  *   DMAͨChannelʹܡ
  *   DMAx: ָDMAڴṹָ룬ȡֵΪDMA0_SFRDMA1_SFR
  *       Channel: DMAͨѡȡֵΧΪ:
  *                  DMA_CHANNEL_1: ͨ1
  *                  DMA_CHANNEL_2: ͨ2
  *                  DMA_CHANNEL_3: ͨ3
  *                  DMA_CHANNEL_4: ͨ4
  *                  DMA_CHANNEL_5: ͨ5
  *                  DMA_CHANNEL_6: ͨ6
  *                  DMA_CHANNEL_7: ͨ7
  *       NewState: DMAͨChannelʹ״̬ȡֵΪTRUE  FALSE
  *   ޡ
  */
void
DMA_Channel_Enable (DMA_SFRmap* DMAx,
                    uint32_t Channel, FunctionalState NewState)
{
    /* У */
    CHECK_RESTRICTION(CHECK_DMA_ALL_PERIPH(DMAx));
    CHECK_RESTRICTION(CHECK_DMA_CHANNEL(Channel));
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

    /*---------------- DMA_CTLRĴDMAENλ ----------------*/
    if (NewState != FALSE)
    {
        /* ʹDMAͨChannel */
        SFR_SET_BIT_ASM(DMAx->CTLR[Channel], DMA_CTLR_DMAEN_POS);
    }
    else
    {
        /* δʹDMAͨChannel */
        SFR_CLR_BIT_ASM(DMAx->CTLR[Channel], DMA_CTLR_DMAEN_POS);
    }
}

/**
  *   DMAͨʼַ
  *   DMAx: ָDMAڴṹָ룬ȡֵΪDMA0_SFRDMA1_SFR
  *       Channel: DMAͨѡȡֵΧΪ:
  *                  DMA_CHANNEL_1: ͨ1
  *                  DMA_CHANNEL_2: ͨ2
  *                  DMA_CHANNEL_3: ͨ3
  *                  DMA_CHANNEL_4: ͨ4
  *                  DMA_CHANNEL_5: ͨ5
  *                  DMA_CHANNEL_6: ͨ6
  *                  DMA_CHANNEL_7: ͨ7
  *       Address: DMAͨʼַȡֵΪ32λЧֵ
  *   ޡ
  */
void
DMA_Peripheral_Start_Address_Config (DMA_SFRmap* DMAx,
                    uint32_t Channel, uint32_t Address)
{
    /* У */
    CHECK_RESTRICTION(CHECK_DMA_ALL_PERIPH(DMAx));
    CHECK_RESTRICTION(CHECK_DMA_CHANNEL(Channel));

    /*---------------- DMA_PADDRĴPADDRλ ----------------*/
    DMAx->PADDR[Channel] = Address;
}

/**
  *   DMAͨʼ洢ַ
  *   DMAx: ָDMAڴṹָ룬ȡֵΪDMA0_SFRDMA1_SFR
  *       Channel: DMAͨѡȡֵΧΪ:
  *                  DMA_CHANNEL_1: ͨ1
  *                  DMA_CHANNEL_2: ͨ2
  *                  DMA_CHANNEL_3: ͨ3
  *                  DMA_CHANNEL_4: ͨ4
  *                  DMA_CHANNEL_5: ͨ5
  *                  DMA_CHANNEL_6: ͨ6
  *                  DMA_CHANNEL_7: ͨ7
  *       Address: DMAͨʼ洢ַȡֵΪ32λЧֵ
  *   ޡ
  */
void
DMA_Memory_Start_Address_Config (DMA_SFRmap* DMAx,
                    uint32_t Channel, uint32_t Address)
{
    /* У */
    CHECK_RESTRICTION(CHECK_DMA_ALL_PERIPH(DMAx));
    CHECK_RESTRICTION(CHECK_DMA_CHANNEL(Channel));

    /*---------------- DMA_MADDRĴMADDRλ ----------------*/
    DMAx->MADDR[Channel] = Address;
}

/**
  *   ȡDMAͨĵǰַ
  *   DMAx: ָDMAڴṹָ룬ȡֵΪDMA0_SFRDMA1_SFR
  *       Channel: DMAͨѡȡֵΧΪ:
  *                  DMA_CHANNEL_1: ͨ1
  *                  DMA_CHANNEL_2: ͨ2
  *                  DMA_CHANNEL_3: ͨ3
  *                  DMA_CHANNEL_4: ͨ4
  *                  DMA_CHANNEL_5: ͨ5
  *                  DMA_CHANNEL_6: ͨ6
  *                  DMA_CHANNEL_7: ͨ7
  *   DMAͨĵǰַȡֵΪ32λЧֵ
  */
uint32_t
DMA_Get_Peripheral_Current_Address (DMA_SFRmap* DMAx, uint32_t Channel)
{
    uint32_t tmpreg = 0;

    /* У */
    CHECK_RESTRICTION(CHECK_DMA_ALL_PERIPH(DMAx));
    CHECK_RESTRICTION(CHECK_DMA_CHANNEL(Channel));

    /*---------------- ȡDMA_CPARĴCPARλ ----------------*/
    tmpreg = DMAx->CPAR[Channel];
    return tmpreg;
}

/**
  *   ȡDMAͨĵǰ洢ַ
  *   DMAx: ָDMAڴṹָ룬ȡֵΪDMA0_SFRDMA1_SFR
  *       Channel: DMAͨѡȡֵΧΪ:
  *                  DMA_CHANNEL_1: ͨ1
  *                  DMA_CHANNEL_2: ͨ2
  *                  DMA_CHANNEL_3: ͨ3
  *                  DMA_CHANNEL_4: ͨ4
  *                  DMA_CHANNEL_5: ͨ5
  *                  DMA_CHANNEL_6: ͨ6
  *                  DMA_CHANNEL_7: ͨ7
  *   DMAͨĵǰ洢ַȡֵΪ32λЧֵ
  */
uint32_t
DMA_Get_Memory_Current_Address (DMA_SFRmap* DMAx, uint32_t Channel)
{
    uint32_t tmpreg = 0;

    /* У */
    CHECK_RESTRICTION(CHECK_DMA_ALL_PERIPH(DMAx));
    CHECK_RESTRICTION(CHECK_DMA_CHANNEL(Channel));

    /*---------------- ȡDMA_CMARĴCMARλ ----------------*/
    tmpreg = DMAx->CMAR[Channel];
    return tmpreg;
}

/**
  *   ȡDMAͨĵǰʣ
  *   DMAx: ָDMAڴṹָ룬ȡֵΪDMA0_SFRDMA1_SFR
  *       Channel: DMAͨѡȡֵΧΪ:
  *                  DMA_CHANNEL_1: ͨ1
  *                  DMA_CHANNEL_2: ͨ2
  *                  DMA_CHANNEL_3: ͨ3
  *                  DMA_CHANNEL_4: ͨ4
  *                  DMA_CHANNEL_5: ͨ5
  *                  DMA_CHANNEL_6: ͨ6
  *                  DMA_CHANNEL_7: ͨ7
  *   DMAͨĵǰʣȡֵΪ16λЧֵ
  */
uint16_t
DMA_Get_Transfer_Number_Remain (DMA_SFRmap* DMAx, uint32_t Channel)
{
    uint32_t tmpreg = 0;

    /* У */
    CHECK_RESTRICTION(CHECK_DMA_ALL_PERIPH(DMAx));
    CHECK_RESTRICTION(CHECK_DMA_CHANNEL(Channel));

    /*---------------- ȡDMA_NCTĴNCTλ ----------------*/
    tmpreg = DMAx->NCT[Channel] & DMA_NCT_NCT;
    tmpreg >>= DMA_NCT_NCT16_POS;

    return (uint16_t)tmpreg;
}
/**
  *   ##### DMAģ(DMA)ú #####
  */


/**
  *   ##### DMAģ(DMA)жϹ #####
  */
/**
  *   ȡDMAͨжϱ־
  *   DMAx: ָDMAڴṹָ룬ȡֵΪDMA0_SFRDMA1_SFR
  *       Channel: DMAͨѡȡֵΧΪ:
  *                  DMA_CHANNEL_1: ͨ1
  *                  DMA_CHANNEL_2: ͨ2
  *                  DMA_CHANNEL_3: ͨ3
  *                  DMA_CHANNEL_4: ͨ4
  *                  DMA_CHANNEL_5: ͨ5
  *                  DMA_CHANNEL_6: ͨ6
  *                  DMA_CHANNEL_7: ͨ7
  *       InterruptType: DMAͨжͣȡֵΧΪ:
  *                        DMA_INT_FINISH_TRANSFER: ɴж
  *                        DMA_INT_HALF_TRANSFER: 봫ж
  *                        DMA_INT_ERROR_TRANSFER: ж
  *   1:䷢0:޴
  */
FlagStatus
DMA_Get_INT_Flag (DMA_SFRmap* DMAx, uint32_t Channel, uint32_t InterruptType)
{
    uint32_t tmpreg = 0;

    /* У */
    CHECK_RESTRICTION(CHECK_DMA_ALL_PERIPH(DMAx));
    CHECK_RESTRICTION(CHECK_DMA_CHANNEL(Channel));
    CHECK_RESTRICTION(CHECK_DMA_INT_ONE_TYPE(InterruptType));

    /* жϱ־ */
    tmpreg = InterruptType << (Channel * 3);
    /*---------------- ȡDMA_LIFRĴжϱ־λ ----------------*/
    if (DMAx->LIFR & tmpreg)
    {
        /* ䷢ */
        return SET;
    }
    else
    {
        /* ޴ */
        return RESET;
    }
}

/**
  *   DMAͨжϱ־
  *   DMAx: ָDMAڴṹָ룬ȡֵΪDMA0_SFRDMA1_SFR
  *       Channel: DMAͨѡȡֵΧΪ:
  *                  DMA_CHANNEL_1: ͨ1
  *                  DMA_CHANNEL_2: ͨ2
  *                  DMA_CHANNEL_3: ͨ3
  *                  DMA_CHANNEL_4: ͨ4
  *                  DMA_CHANNEL_5: ͨ5
  *                  DMA_CHANNEL_6: ͨ6
  *                  DMA_CHANNEL_7: ͨ7
  *       InterruptType: DMAͨжͣȡֵΧΪṩһ:
  *                        DMA_INT_FINISH_TRANSFER: ɴж
  *                        DMA_INT_HALF_TRANSFER: 봫ж
  *                        DMA_INT_ERROR_TRANSFER: ж
  *   ޡ
  */
void
DMA_Clear_INT_Flag (DMA_SFRmap* DMAx,
                    uint32_t Channel, uint32_t InterruptType)
{
    uint32_t tmpmask = 0;

    /* У */
    CHECK_RESTRICTION(CHECK_DMA_ALL_PERIPH(DMAx));
    CHECK_RESTRICTION(CHECK_DMA_CHANNEL(Channel));
    CHECK_RESTRICTION(CHECK_DMA_INT_TYPE(InterruptType));

    /*---------------- DMA_LIFRĴжϱ־λ ----------------*/
    tmpmask = InterruptType << (Channel * 3);
    DMAx->LIFR &= ~tmpmask;
}

/**
  *   DMAͨжʹܡ
  *   DMAx: ָDMAڴṹָ룬ȡֵΪDMA0_SFRDMA1_SFR
  *       Channel: DMAͨѡȡֵΧΪ:
  *                  DMA_CHANNEL_1: ͨ1
  *                  DMA_CHANNEL_2: ͨ2
  *                  DMA_CHANNEL_3: ͨ3
  *                  DMA_CHANNEL_4: ͨ4
  *                  DMA_CHANNEL_5: ͨ5
  *                  DMA_CHANNEL_6: ͨ6
  *                  DMA_CHANNEL_7: ͨ7
  *       InterruptType: DMAͨжͣȡֵΧΪṩһ:
  *                        DMA_INT_FINISH_TRANSFER: ɴж
  *                        DMA_INT_HALF_TRANSFER: 봫ж
  *                        DMA_INT_ERROR_TRANSFER: ж
  *       NewState: DMAͨжʹ״̬ȡֵΪTRUE  FALSE
  *   ޡ
  */
void
DMA_Set_INT_Enable (DMA_SFRmap* DMAx, uint32_t Channel,
                    uint32_t InterruptType, FunctionalState NewState)
{
    uint32_t tmpmask = 0;

    /* У */
    CHECK_RESTRICTION(CHECK_DMA_ALL_PERIPH(DMAx));
    CHECK_RESTRICTION(CHECK_DMA_CHANNEL(Channel));
    CHECK_RESTRICTION(CHECK_DMA_INT_TYPE(InterruptType));
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

    /*---------------- DMA_LIERĴжʹλ ----------------*/
    tmpmask = InterruptType << (Channel * 3);
    if (NewState != FALSE)
    {
        DMAx->LIER |= tmpmask;
    }
    else
    {
        DMAx->LIER &= ~tmpmask;
    }
}

/**
  *   ȡDMAͨжϱ־
  *   DMAx: ָDMAڴṹָ룬ȡֵΪDMA0_SFRDMA1_SFR
  *       Channel: DMAͨѡȡֵΧΪ:
  *                  DMA_CHANNEL_1: ͨ1
  *                  DMA_CHANNEL_2: ͨ2
  *                  DMA_CHANNEL_3: ͨ3
  *                  DMA_CHANNEL_4: ͨ4
  *                  DMA_CHANNEL_5: ͨ5
  *                  DMA_CHANNEL_6: ͨ6
  *                  DMA_CHANNEL_7: ͨ7
  *   1:䷢0:޴
  */
FlagStatus
DMA_Get_Error_Transfer_INT_Flag (DMA_SFRmap* DMAx, uint32_t Channel)
{
    uint32_t tmpreg = 0;

    /* У */
    CHECK_RESTRICTION(CHECK_DMA_ALL_PERIPH(DMAx));
    CHECK_RESTRICTION(CHECK_DMA_CHANNEL(Channel));

    tmpreg = DMA_LIFR_ETIF1 << (Channel * 3);
    /*---------------- ȡDMA_LIFRĴETIFyλ ----------------*/
    if (DMAx->LIFR & tmpreg)
    {
        /* ䷢ */
        return SET;
    }
    else
    {
        /* ޴ */
        return RESET;
    }
}

/**
  *   ȡDMAͨ봫жϱ־
  *   DMAx: ָDMAڴṹָ룬ȡֵΪDMA0_SFRDMA1_SFR
  *       Channel: DMAͨѡȡֵΧΪ:
  *                  DMA_CHANNEL_1: ͨ1
  *                  DMA_CHANNEL_2: ͨ2
  *                  DMA_CHANNEL_3: ͨ3
  *                  DMA_CHANNEL_4: ͨ4
  *                  DMA_CHANNEL_5: ͨ5
  *                  DMA_CHANNEL_6: ͨ6
  *                  DMA_CHANNEL_7: ͨ7
  *   1:һ룬0:δһ롣
  */
FlagStatus
DMA_Get_Half_Transfer_INT_Flag (DMA_SFRmap* DMAx, uint32_t Channel)
{
    uint32_t tmpreg = 0;

    /* У */
    CHECK_RESTRICTION(CHECK_DMA_ALL_PERIPH(DMAx));
    CHECK_RESTRICTION(CHECK_DMA_CHANNEL(Channel));

    tmpreg = DMA_LIFR_HTIF1 << (Channel * 3);
    /*---------------- ȡDMA_LIFRĴHTIFyλ ----------------*/
    if (DMAx->LIFR & tmpreg)
    {
        /* һ */
        return SET;
    }
    else
    {
        /* δһ */
        return RESET;
    }
}

/**
  *   ȡDMAͨɴжϱ־
  *   DMAx: ָDMAڴṹָ룬ȡֵΪDMA0_SFRDMA1_SFR
  *       Channel: DMAͨѡȡֵΧΪ:
  *                  DMA_CHANNEL_1: ͨ1
  *                  DMA_CHANNEL_2: ͨ2
  *                  DMA_CHANNEL_3: ͨ3
  *                  DMA_CHANNEL_4: ͨ4
  *                  DMA_CHANNEL_5: ͨ5
  *                  DMA_CHANNEL_6: ͨ6
  *                  DMA_CHANNEL_7: ͨ7
  *   1:ɣ0:δɡ
  */
FlagStatus
DMA_Get_Finish_Transfer_INT_Flag (DMA_SFRmap* DMAx, uint32_t Channel)
{
    uint32_t tmpreg = 0;

    /* У */
    CHECK_RESTRICTION(CHECK_DMA_ALL_PERIPH(DMAx));
    CHECK_RESTRICTION(CHECK_DMA_CHANNEL(Channel));

    tmpreg = DMA_LIFR_FTIF1 << (Channel * 3);
    /*---------------- ȡDMA_LIFRĴFTIFyλ ----------------*/
    if (DMAx->LIFR & tmpreg)
    {
        /*  */
        return SET;
    }
    else
    {
        /* δ */
        return RESET;
    }
}

/**
  *   DMAͨжʹܡ
  *   DMAx: ָDMAڴṹָ룬ȡֵΪDMA0_SFRDMA1_SFR
  *       Channel: DMAͨѡȡֵΧΪ:
  *                  DMA_CHANNEL_1: ͨ1
  *                  DMA_CHANNEL_2: ͨ2
  *                  DMA_CHANNEL_3: ͨ3
  *                  DMA_CHANNEL_4: ͨ4
  *                  DMA_CHANNEL_5: ͨ5
  *                  DMA_CHANNEL_6: ͨ6
  *                  DMA_CHANNEL_7: ͨ7
  *       NewState: DMAͨжʹ״̬ȡֵΪTRUE  FALSE
  *   ޡ
  */
void
DMA_Error_Transfer_INT_Enable (DMA_SFRmap* DMAx,
                    uint32_t Channel, FunctionalState NewState)
{
    uint32_t tmpmask = 0;

    /* У */
    CHECK_RESTRICTION(CHECK_DMA_ALL_PERIPH(DMAx));
    CHECK_RESTRICTION(CHECK_DMA_CHANNEL(Channel));
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

    /*---------------- DMA_LIERĴETIEyλ ----------------*/
    tmpmask = DMA_LIER_ETIE1 << (Channel * 3);
    if (NewState != FALSE)
    {
        DMAx->LIER |= tmpmask;
    }
    else
    {
        DMAx->LIER &= ~tmpmask;
    }
}

/**
  *   DMAͨ봫жʹܡ
  *   DMAx: ָDMAڴṹָ룬ȡֵΪDMA0_SFRDMA1_SFR
  *       Channel: DMAͨѡȡֵΧΪ:
  *                  DMA_CHANNEL_1: ͨ1
  *                  DMA_CHANNEL_2: ͨ2
  *                  DMA_CHANNEL_3: ͨ3
  *                  DMA_CHANNEL_4: ͨ4
  *                  DMA_CHANNEL_5: ͨ5
  *                  DMA_CHANNEL_6: ͨ6
  *                  DMA_CHANNEL_7: ͨ7
  *       NewState: DMAͨ봫жʹ״̬ȡֵΪTRUE  FALSE
  *   ޡ
  */
void
DMA_Half_Transfer_INT_Enable (DMA_SFRmap* DMAx,
                    uint32_t Channel, FunctionalState NewState)
{
    uint32_t tmpmask = 0;

    /* У */
    CHECK_RESTRICTION(CHECK_DMA_ALL_PERIPH(DMAx));
    CHECK_RESTRICTION(CHECK_DMA_CHANNEL(Channel));
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

    /*---------------- DMA_LIERĴHTIEyλ ----------------*/
    tmpmask = DMA_LIER_HTIE1 << (Channel * 3);
    if (NewState != FALSE)
    {
        DMAx->LIER |= tmpmask;
    }
    else
    {
        DMAx->LIER &= ~tmpmask;
    }
}

/**
  *   DMAͨɴжʹܡ
  *   DMAx: ָDMAڴṹָ룬ȡֵΪDMA0_SFRDMA1_SFR
  *       Channel: DMAͨѡȡֵΧΪ:
  *                  DMA_CHANNEL_1: ͨ1
  *                  DMA_CHANNEL_2: ͨ2
  *                  DMA_CHANNEL_3: ͨ3
  *                  DMA_CHANNEL_4: ͨ4
  *                  DMA_CHANNEL_5: ͨ5
  *                  DMA_CHANNEL_6: ͨ6
  *                  DMA_CHANNEL_7: ͨ7
  *       NewState: DMAͨɴжʹ״̬ȡֵΪTRUE  FALSE
  *   ޡ
  */
void
DMA_Finish_Transfer_INT_Enable (DMA_SFRmap* DMAx,
                    uint32_t Channel, FunctionalState NewState)
{
    uint32_t tmpmask = 0;

    /* У */
    CHECK_RESTRICTION(CHECK_DMA_ALL_PERIPH(DMAx));
    CHECK_RESTRICTION(CHECK_DMA_CHANNEL(Channel));
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

    /*---------------- DMA_LIERĴFTIEyλ ----------------*/
    tmpmask = DMA_LIER_FTIE1 << (Channel * 3);
    if (NewState != FALSE)
    {
        DMAx->LIER |= tmpmask;
    }
    else
    {
        DMAx->LIER &= ~tmpmask;
    }
}
/**
  *   ##### DMAģ(DMA)жϹ #####
  */
