/**
  ******************************************************************************
  * ļ  kf32f_basic_rtc.c
  *     ChipON_AE/FAE_Group
  *     V3.0.1
  *     2021-11-25
  *     ļṩʵʱʱ(RTC)صĹܺ
  *          + ʵʱʱ(RTC)ܳʼ
  *          + ʵʱʱ(RTC)ƹܺ
  *          + ʵʱʱ(RTC)ú
  *          + ʵʱʱ(RTC)ʱú
  *          + ʵʱʱ(RTC)ʱú
  *          + ʵʱʱ(RTC)жϹ
  *          + ʵʱʱ(RTC)˽к
  *
  *********************************************************************
  */

#include "kf32f_basic_osc.h"
#include "kf32f_basic_bkp.h"
#include "kf32f_basic_rtc.h"

/* ʵʱʱ(RTC)˽к궨 --------------------------------------------------*/
/* RTC_TMRĴʼ */
#define RTC_TMR_INIT_MASK               (RTC_TMR_WEK \
                                       | RTC_TMR_AMPM \
                                       | RTC_TMR_HOUR \
                                       | RTC_TMR_MIN \
                                       | RTC_TMR_SEC)
/* RTC_DTRĴʼ */
#define RTC_DTR_INIT_MASK               (RTC_DTR_DAY \
                                       | RTC_DTR_MTH \
                                       | RTC_DTR_YEAR)
/* RTC_ALRA/BĴʼ */
#define RTC_ALR_INIT_MASK               (RTC_ALRA_ALRSA \
                                       | RTC_ALRA_ASENA \
                                       | RTC_ALRA_ALRMA \
                                       | RTC_ALRA_AMENA \
                                       | RTC_ALRA_ALRHA \
                                       | RTC_ALRA_AMPMA \
                                       | RTC_ALRA_AHENA \
                                       | RTC_ALRA_ALRWA \
                                       | RTC_ALRA_AWENA)


/* ʵʱʱ(RTC)˽к ----------------------------------------------------*/
static uint8_t RTC_Byte_To_Bcd (uint8_t Value);
static uint8_t RTC_Bcd_To_Byte (uint8_t Value);


/**
  *   ##### ʵʱʱ(RTC)ܳʼ #####
  */
/**
  *   λRTCģ顣
  *   ޡ
  *   ޡ
  */
void
RTC_Reset (void)
{
    /* RTCģǰؼĴ */
    SFR_SET_BIT_ASM(OSC_CTL0, OSC_CTL0_PMWREN_POS);
    SFR_SET_BIT_ASM(PM_CTL0, PM_CTL0_BKPREGCLR_POS);
    SFR_SET_BIT_ASM(PM_CTL0, PM_CTL0_BKPWR_POS);

    /* λRTCģ */
    SFR_SET_BIT_ASM(RTC_CR, RTC_CR_RESET_POS);
    /* ˳λRTCģ */
    SFR_CLR_BIT_ASM(RTC_CR, RTC_CR_RESET_POS);
}

/**
  *   ʱʼãúʱ˳ģʽ
  *   TimeFormat: ʱֵʽѡǷΪBCD룬ȡֵΧΪ
  *                     RTC_TIME_FORMAT_BCD: BCD뷽ʽ
  *                     RTC_TIME_FORMAT_BIN: ʹBCD롣
  *       rtcInitStruct: ʼϢṹָ롣
  *   ޡ
  */
void
RTC_Configuration (uint32_t TimeFormat, RTC_InitTypeDef * rtcInitStruct)
{
    uint32_t tmpreg = 0;

    /* У */
    CHECK_RESTRICTION(CHECK_RTC_TIME_FORMAT(TimeFormat));
    CHECK_RESTRICTION(CHECK_RTC_SOURCE(rtcInitStruct->m_ClockSource));
    CHECK_RESTRICTION(CHECK_RTC_HOURFORMAT(rtcInitStruct->m_HourFormat));
    if (TimeFormat != RTC_TIME_FORMAT_BCD)
    {
        if ((RTC_CR & RTC_CR_HT) != RTC_HOUR_FORMAT_24)
        {
            CHECK_RESTRICTION(CHECK_RTC_HOUR12(rtcInitStruct->m_TimeStruct.m_Hours));
            CHECK_RESTRICTION(CHECK_RTC_TIME_AMPM(rtcInitStruct->m_TimeStruct.m_AMPM));
        }
        else
        {
            CHECK_RESTRICTION(CHECK_RTC_HOUR24(rtcInitStruct->m_TimeStruct.m_Hours));
            if(rtcInitStruct->m_TimeStruct.m_Hours>=12)
            {
                rtcInitStruct->m_TimeStruct.m_AMPM = RTC_TIME_PM;
            }
            else
            {
                rtcInitStruct->m_TimeStruct.m_AMPM = RTC_TIME_AM;
            }
        }
        CHECK_RESTRICTION(CHECK_RTC_MINUTES(rtcInitStruct->m_TimeStruct.m_Minutes));
        CHECK_RESTRICTION(CHECK_RTC_SECONDS(rtcInitStruct->m_TimeStruct.m_Seconds));
        CHECK_RESTRICTION(CHECK_RTC_WEEKDAY(rtcInitStruct->m_DateStruct.m_WeekDay));
        CHECK_RESTRICTION(CHECK_RTC_DATE(rtcInitStruct->m_DateStruct.m_Day));
        CHECK_RESTRICTION(CHECK_RTC_MONTH_DEC(rtcInitStruct->m_DateStruct.m_Month));
        CHECK_RESTRICTION(CHECK_RTC_YEAR(rtcInitStruct->m_DateStruct.m_Year));
    }
    else
    {
        if ((RTC_CR & RTC_CR_HT) != RTC_HOUR_FORMAT_24)
        {
            CHECK_RESTRICTION(CHECK_RTC_HOUR12( \
                        RTC_Bcd_To_Byte(rtcInitStruct->m_TimeStruct.m_Hours)));
            CHECK_RESTRICTION(CHECK_RTC_TIME_AMPM(rtcInitStruct->m_TimeStruct.m_AMPM));
        }
        else
        {
            CHECK_RESTRICTION(CHECK_RTC_HOUR24( \
                        RTC_Bcd_To_Byte(rtcInitStruct->m_TimeStruct.m_Hours)));
            if(rtcInitStruct->m_TimeStruct.m_Hours>=12)
            {
                rtcInitStruct->m_TimeStruct.m_AMPM = RTC_TIME_PM;
            }
            else
            {
                rtcInitStruct->m_TimeStruct.m_AMPM = RTC_TIME_AM;
            }
        }
        CHECK_RESTRICTION(CHECK_RTC_MINUTES( \
                        RTC_Bcd_To_Byte(rtcInitStruct->m_TimeStruct.m_Minutes)));
        CHECK_RESTRICTION(CHECK_RTC_SECONDS( \
                        RTC_Bcd_To_Byte(rtcInitStruct->m_TimeStruct.m_Seconds)));
        CHECK_RESTRICTION(CHECK_RTC_WEEKDAY(rtcInitStruct->m_DateStruct.m_WeekDay));
        CHECK_RESTRICTION(CHECK_RTC_DATE( \
                        RTC_Bcd_To_Byte(rtcInitStruct->m_DateStruct.m_Day)));
        CHECK_RESTRICTION(CHECK_RTC_MONTH_BCD(rtcInitStruct->m_DateStruct.m_Month));
        CHECK_RESTRICTION(CHECK_RTC_YEAR( \
                        RTC_Bcd_To_Byte(rtcInitStruct->m_DateStruct.m_Year)));
    }

    /* ģʽ */
    SFR_SET_BIT_ASM(RTC_CR, RTC_CR_CNF_POS);

    /*-------------------- RTC_TMRĴ --------------------*/
    /* ݽṹԱm_TimeStruct.m_WeekDayWEKλ */
    /* ݽṹԱm_TimeStruct.m_HoursHOURλ */
    /* ݽṹԱm_TimeStruct.m_MinutesMINλ */
    /* ݽṹԱm_TimeStruct.m_SecondsSECλ */
    /* ݽṹԱm_TimeStruct.m_AMPMAMPMλ */
    if (TimeFormat != RTC_TIME_FORMAT_BCD)
    {
        tmpreg = ((uint32_t)rtcInitStruct->m_DateStruct.m_WeekDay \
                    << RTC_TMR_WEK0_POS) \
               | ((uint32_t)RTC_Byte_To_Bcd(rtcInitStruct->m_TimeStruct.m_Hours) \
                    << RTC_TMR_HOUR0_POS) \
               | ((uint32_t)RTC_Byte_To_Bcd(rtcInitStruct->m_TimeStruct.m_Minutes) \
                    << RTC_TMR_MIN0_POS) \
               | ((uint32_t)RTC_Byte_To_Bcd(rtcInitStruct->m_TimeStruct.m_Seconds) \
                    << RTC_TMR_SEC0_POS) \
               | ((uint32_t)rtcInitStruct->m_TimeStruct.m_AMPM << RTC_TMR_AMPM_POS);
    }
    else
    {
        tmpreg = ((uint32_t)rtcInitStruct->m_DateStruct.m_WeekDay << RTC_TMR_WEK0_POS) \
               | ((uint32_t)rtcInitStruct->m_TimeStruct.m_Hours << RTC_TMR_HOUR0_POS) \
               | ((uint32_t)rtcInitStruct->m_TimeStruct.m_Minutes << RTC_TMR_MIN0_POS) \
               | ((uint32_t)rtcInitStruct->m_TimeStruct.m_Seconds << RTC_TMR_SEC0_POS) \
               | ((uint32_t)rtcInitStruct->m_TimeStruct.m_AMPM << RTC_TMR_AMPM_POS);
    }
    RTC_TMR = SFR_Config (RTC_TMR,
                          ~RTC_TMR_INIT_MASK,
                          tmpreg);

    /*-------------------- RTC_DTRĴ --------------------*/
    /* ݽṹԱm_DateStruct.m_DayDAYλ */
    /* ݽṹԱm_DateStruct.m_MonthMTHλ */
    /* ݽṹԱm_DateStruct.m_YearYEARλ */
    if (TimeFormat != RTC_TIME_FORMAT_BCD)
    {
        tmpreg = ((uint32_t)RTC_Byte_To_Bcd(rtcInitStruct->m_DateStruct.m_Month) \
                    << RTC_DTR_MTH0_POS) \
               | ((uint32_t)RTC_Byte_To_Bcd(rtcInitStruct->m_DateStruct.m_Day) \
                    << RTC_DTR_DAY0_POS) \
               | ((uint32_t)RTC_Byte_To_Bcd(rtcInitStruct->m_DateStruct.m_Year) \
                    << RTC_DTR_YEAR0_POS);
    }
    else
    {
        tmpreg = ((uint32_t)rtcInitStruct->m_DateStruct.m_Month << RTC_DTR_MTH0_POS) \
               | ((uint32_t)rtcInitStruct->m_DateStruct.m_Day << RTC_DTR_DAY0_POS) \
               | ((uint32_t)rtcInitStruct->m_DateStruct.m_Year << RTC_DTR_YEAR0_POS);
    }
    RTC_DTR = SFR_Config (RTC_DTR,
                          ~RTC_DTR_INIT_MASK,
                          tmpreg);

    /*-------------------- RTC_CRĴ --------------------*/
    /* ݽṹԱm_HourFormatHTλ */
    tmpreg = rtcInitStruct->m_HourFormat;
    RTC_CR = SFR_Config (RTC_CR,
                          ~RTC_CR_HT,
                          tmpreg);

    /*-------------------- BKP_CTLĴ --------------------*/
    /* ݽṹԱm_ClockSourceRTCCLKSλ */
    BKP_CTL = SFR_Config (BKP_CTL,
                          ~BKP_CTL_RTCCLKS,
                          rtcInitStruct->m_ClockSource);

    /* ˳ģʽ */
    SFR_CLR_BIT_ASM(RTC_CR, RTC_CR_CNF_POS);
}

/**
  *   ʼʱϢṹ塣
  *   rtcTimeInitStruct: ָʼĽṹָ롣
  *   ޡ
  */
void
RTC_Time_Struct_Init (RTC_TimeTypeDef* rtcTimeInitStruct)
{
    /* ʱ: AM 00h:00m:00s */
    /* ʱ */
    rtcTimeInitStruct->m_Hours = 0;
    /* ÷ */
    rtcTimeInitStruct->m_Minutes = 0;
    /*  */
    rtcTimeInitStruct->m_Seconds = 0;
    /* AMPM */
    rtcTimeInitStruct->m_AMPM = RTC_TIME_AM;
}

/**
  *   ʼϢṹ塣
  *   rtcDateInitStruct: ָʼĽṹָ롣
  *   ޡ
  */
void
RTC_Date_Struct_Init (RTC_DateTypeDef* rtcDateInitStruct)
{
    /* : xx00/1/1 һ*/
    /*  */
    rtcDateInitStruct->m_WeekDay = RTC_WEEKDAY_MONDAY_BCD;
    /*  */
    rtcDateInitStruct->m_Year = 0;
    /*  */
    rtcDateInitStruct->m_Month = RTC_MONTH_JANUARY_BCD;
    /*  */
    rtcDateInitStruct->m_Day = 1;
}

/**
  *   ʼϢṹ塣
  *   rtcInitStruct: ָʼĽṹָ롣
  *   ޡ
  */
void
RTC_Struct_Init (RTC_InitTypeDef * rtcInitStruct)
{
    /* RTCʱԴ */
    rtcInitStruct->m_ClockSource = BKP_RTC_NO_CLK;
    /* RTCʱʽ */
    rtcInitStruct->m_HourFormat = RTC_HOUR_FORMAT_24;
    /* ʱ */
    rtcInitStruct->m_TimeStruct.m_Hours = 0;
    /* ÷ */
    rtcInitStruct->m_TimeStruct.m_Minutes = 0;
    /*  */
    rtcInitStruct->m_TimeStruct.m_Seconds = 0;
    /* AMPM */
    rtcInitStruct->m_TimeStruct.m_AMPM = RTC_TIME_AM;
    /*  */
    rtcInitStruct->m_DateStruct.m_WeekDay = RTC_WEEKDAY_MONDAY_BCD;
    /*  */
    rtcInitStruct->m_DateStruct.m_Year = 0;
    /*  */
    rtcInitStruct->m_DateStruct.m_Month = RTC_MONTH_JANUARY_BCD;
    /*  */
    rtcInitStruct->m_DateStruct.m_Day = 1;
}

/**
  *   ȡʱϢ
  *   TimeFormat: ʱֵʽѡǷΪBCD룬ȡֵΧΪ
  *                     RTC_TIME_FORMAT_BCD: BCD뷽ʽ
  *                     RTC_TIME_FORMAT_BIN: ʹBCD롣
  *       rtcTimeStruct: ʱϢ洢ָ롣
  *   ޡ
  */
void
RTC_Get_Time_Configuration (uint32_t TimeFormat,
                    RTC_TimeTypeDef* rtcTimeStruct)
{
    uint32_t tmpreg = 0;

    /* У */
    CHECK_RESTRICTION(CHECK_RTC_TIME_FORMAT(TimeFormat));

    /* ȡRTC_TMRĴ */
    tmpreg = RTC_TMR;

    /* ȡʱϢ */
    rtcTimeStruct->m_Hours = (uint8_t)((tmpreg & RTC_TMR_HOUR) \
                            >> RTC_TMR_HOUR0_POS);
    rtcTimeStruct->m_Minutes = (uint8_t)((tmpreg & RTC_TMR_MIN) \
                              >> RTC_TMR_MIN0_POS);
    rtcTimeStruct->m_Seconds = (uint8_t)((tmpreg & RTC_TMR_SEC) \
                              >> RTC_TMR_SEC0_POS);
    rtcTimeStruct->m_AMPM = (uint8_t)((tmpreg & RTC_TMR_AMPM) \
                           >> RTC_TMR_AMPM_POS);

    /* BCDתΪֵ */
    if (TimeFormat != RTC_TIME_FORMAT_BCD)
    {
        rtcTimeStruct->m_Hours = RTC_Bcd_To_Byte(rtcTimeStruct->m_Hours);
        rtcTimeStruct->m_Minutes = RTC_Bcd_To_Byte(rtcTimeStruct->m_Minutes);
        rtcTimeStruct->m_Seconds = RTC_Bcd_To_Byte(rtcTimeStruct->m_Seconds);
    }
}

/**
  *   ȡϢ
  *   TimeFormat: ʱֵʽѡǷΪBCD룬ȡֵΧΪ
  *                     RTC_TIME_FORMAT_BCD: BCD뷽ʽ
  *                     RTC_TIME_FORMAT_BIN: ʹBCD롣
  *       rtcDateStruct: Ϣ洢ָ롣
  *   ޡ
  */
void
RTC_Get_Date_Configuration (uint32_t TimeFormat,
                    RTC_DateTypeDef* rtcDateStruct)
{
    uint32_t tmpreg = 0;

    /* У */
    CHECK_RESTRICTION(CHECK_RTC_TIME_FORMAT(TimeFormat));

    /* ȡRTC_TMRĴ */
    tmpreg = RTC_TMR;

    /* ȡϢ */
    rtcDateStruct->m_WeekDay = (uint8_t)((tmpreg & RTC_TMR_WEK) \
                              >> RTC_TMR_WEK0_POS);

    /* ȡRTC_DTRĴ */
    tmpreg = RTC_DTR;

    /* ȡʱϢ */
    rtcDateStruct->m_Year = (uint8_t)((tmpreg & RTC_DTR_YEAR) \
                           >> RTC_DTR_YEAR0_POS);
    rtcDateStruct->m_Month = (uint8_t)((tmpreg & RTC_DTR_MTH) \
                           >> RTC_DTR_MTH0_POS);
    rtcDateStruct->m_Day = (uint8_t)((tmpreg & RTC_DTR_DAY) \
                           >> RTC_DTR_DAY0_POS);

    /* BCDתΪֵ */
    if (TimeFormat != RTC_TIME_FORMAT_BCD)
    {
        rtcDateStruct->m_Year = RTC_Bcd_To_Byte(rtcDateStruct->m_Year);
        rtcDateStruct->m_Month = RTC_Bcd_To_Byte(rtcDateStruct->m_Month);
        rtcDateStruct->m_Day = RTC_Bcd_To_Byte(rtcDateStruct->m_Day);
    }
}

/**
  *   ӳʼãô˺ǰHTλ
  *       ͨRTC_Hour_Format_Configʵ֡
  *   AlarmSelect: ѡȡֵΧΪ
  *                      RTC_ALARM_A_ADDR_OFFSET: A
  *                      RTC_ALARM_B_ADDR_OFFSET: B
  *       TimeFormat: ʱֵʽѡǷΪBCD룬ȡֵΧΪ
  *                     RTC_TIME_FORMAT_BCD: BCD뷽ʽ
  *                     RTC_TIME_FORMAT_BIN: ʹBCD롣
  *       rtcAlarmInitStruct: Ϣṹָ롣
  *   ޡ
  */
void
RTC_Alarm_Configuration (uint32_t AlarmSelect,
                    uint32_t TimeFormat,
                    RTC_AlarmTypeDef* rtcAlarmInitStruct)
{
    uint32_t tmpreg = 0;
    uint32_t tmpaddr = 0;

    /* У */
    CHECK_RESTRICTION(CHECK_RTC_ALARM(AlarmSelect));
    CHECK_RESTRICTION(CHECK_RTC_TIME_FORMAT(TimeFormat));
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(rtcAlarmInitStruct->m_WeekDayEnable));
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(rtcAlarmInitStruct->m_HoursEnable));
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(rtcAlarmInitStruct->m_MinutesEnable));
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(rtcAlarmInitStruct->m_SecondsEnable));

    if (TimeFormat != RTC_TIME_FORMAT_BCD)
    {
        if ((RTC_CR & RTC_CR_HT) != RTC_HOUR_FORMAT_24)
        {
            CHECK_RESTRICTION(CHECK_RTC_HOUR12(rtcAlarmInitStruct->m_Hours));
            CHECK_RESTRICTION(CHECK_RTC_TIME_AMPM(rtcAlarmInitStruct->m_AMPM));
        }
        else
        {
            rtcAlarmInitStruct->m_AMPM = RTC_TIME_AM;
            CHECK_RESTRICTION(CHECK_RTC_HOUR24(rtcAlarmInitStruct->m_Hours));
        }
        CHECK_RESTRICTION(CHECK_RTC_MINUTES(rtcAlarmInitStruct->m_Minutes));
        CHECK_RESTRICTION(CHECK_RTC_SECONDS(rtcAlarmInitStruct->m_Seconds));
        CHECK_RESTRICTION(CHECK_RTC_WEEKDAY(rtcAlarmInitStruct->m_WeekDay));
    }
    else
    {
        if ((RTC_CR & RTC_CR_HT) != RTC_HOUR_FORMAT_24)
        {
            CHECK_RESTRICTION(CHECK_RTC_HOUR12( \
                        RTC_Bcd_To_Byte(rtcAlarmInitStruct->m_Hours)));
            CHECK_RESTRICTION(CHECK_RTC_TIME_AMPM(rtcAlarmInitStruct->m_AMPM));
        }
        else
        {
            rtcAlarmInitStruct->m_AMPM = RTC_TIME_AM;
            CHECK_RESTRICTION(CHECK_RTC_HOUR24( \
                        RTC_Bcd_To_Byte(rtcAlarmInitStruct->m_Hours)));
        }
        CHECK_RESTRICTION(CHECK_RTC_MINUTES( \
                        RTC_Bcd_To_Byte(rtcAlarmInitStruct->m_Minutes)));
        CHECK_RESTRICTION(CHECK_RTC_SECONDS( \
                        RTC_Bcd_To_Byte(rtcAlarmInitStruct->m_Seconds)));
        CHECK_RESTRICTION(CHECK_RTC_WEEKDAY(rtcAlarmInitStruct->m_WeekDay));
    }

    /* ģʽ */
    SFR_SET_BIT_ASM(RTC_CR, RTC_CR_CNF_POS);

    /* AlarmSelectѡӦӿƼĴ */
    tmpaddr = (uint32_t)&RTC_ALRA;
    tmpaddr += AlarmSelect;

    /*-------------------- RTC_ALRxĴ --------------------*/
    /* ݽṹԱm_WeekDayEnableAWENxλ */
    /* ݽṹԱm_HoursEnableAHENxλ */
    /* ݽṹԱm_MinutesEnableAMENxλ */
    /* ݽṹԱm_SecondsEnableASENλ */
    /* ݽṹԱm_AMPMAMPMxλ */
    /* ݽṹԱm_WeekDayALRWxλ */
    /* ݽṹԱm_HoursALRHxλ */
    /* ݽṹԱm_MinutesALRMxλ */
    /* ݽṹԱm_SecondsALRSxλ */
    if (TimeFormat != RTC_TIME_FORMAT_BCD)
    {
        tmpreg = (rtcAlarmInitStruct->m_WeekDayEnable << RTC_ALRA_AWENA_POS) \
               | (rtcAlarmInitStruct->m_HoursEnable << RTC_ALRA_AHENA_POS) \
               | (rtcAlarmInitStruct->m_MinutesEnable << RTC_ALRA_AMENA_POS) \
               | (rtcAlarmInitStruct->m_SecondsEnable << RTC_ALRA_ASENA_POS) \
               | ((uint32_t)rtcAlarmInitStruct->m_AMPM << RTC_TMR_AMPM_POS) \
               | ((uint32_t)rtcAlarmInitStruct->m_WeekDay << RTC_ALRA_ALRWA0_POS) \
               | ((uint32_t)RTC_Byte_To_Bcd(rtcAlarmInitStruct->m_Hours) \
                    << RTC_ALRA_ALRHA0_POS) \
               | ((uint32_t)RTC_Byte_To_Bcd(rtcAlarmInitStruct->m_Minutes) \
                    << RTC_ALRA_ALRMA0_POS) \
               | ((uint32_t)RTC_Byte_To_Bcd(rtcAlarmInitStruct->m_Seconds) \
                    << RTC_ALRA_ALRSA0_POS);
    }
    else
    {
        tmpreg = (rtcAlarmInitStruct->m_WeekDayEnable << RTC_ALRA_AWENA_POS) \
               | (rtcAlarmInitStruct->m_HoursEnable << RTC_ALRA_AHENA_POS) \
               | (rtcAlarmInitStruct->m_MinutesEnable << RTC_ALRA_AMENA_POS) \
               | (rtcAlarmInitStruct->m_SecondsEnable << RTC_ALRA_ASENA_POS) \
               | ((uint32_t)rtcAlarmInitStruct->m_AMPM << RTC_TMR_AMPM_POS) \
               | ((uint32_t)rtcAlarmInitStruct->m_WeekDay << RTC_ALRA_ALRWA0_POS) \
               | ((uint32_t)rtcAlarmInitStruct->m_Hours << RTC_ALRA_ALRHA0_POS) \
               | ((uint32_t)rtcAlarmInitStruct->m_Minutes << RTC_ALRA_ALRMA0_POS) \
               | ((uint32_t)rtcAlarmInitStruct->m_Seconds << RTC_ALRA_ALRSA0_POS);
    }

    *(volatile uint32_t *)tmpaddr =
                    SFR_Config (*(volatile uint32_t *)tmpaddr,
                                ~RTC_ALR_INIT_MASK,
                                tmpreg);

    /* ˳ģʽ */
    SFR_CLR_BIT_ASM(RTC_CR, RTC_CR_CNF_POS);
}

/**
  *   ʼϢṹ塣
  *   rtcAlarmInitStruct: ָʼĽṹָ롣
  *   ޡ
  */
void
RTC_Alarm_Struct_Init (RTC_AlarmTypeDef* rtcAlarmInitStruct)
{
    /* AM/PM */
    rtcAlarmInitStruct->m_AMPM = RTC_TIME_AM;
    /*  */
    rtcAlarmInitStruct->m_WeekDay = RTC_WEEKDAY_MONDAY_BCD;
    /* ʹ */
    rtcAlarmInitStruct->m_WeekDayEnable = FALSE;
    /* ʱ */
    rtcAlarmInitStruct->m_Hours = 0;
    /* ʹʱ */
    rtcAlarmInitStruct->m_HoursEnable = FALSE;
    /* ÷ */
    rtcAlarmInitStruct->m_Minutes = 0;
    /* ʹܷ */
    rtcAlarmInitStruct->m_MinutesEnable = FALSE;
    /*  */
    rtcAlarmInitStruct->m_Seconds = 0;
    /* ʹ */
    rtcAlarmInitStruct->m_SecondsEnable = FALSE;
}
/**
  *   ##### ʵʱʱ(RTC)ܳʼ #####
  */


/**
  *   ##### ʵʱʱ(RTC)ƹܺ #####
  */
/**
  *   RTCʱУֵ
  *   Calibration: RTCʱƫֵȡֵΪ8λзֵ
  *   ޡ
  */
void
RTC_Clock_Calibration_Config (int8_t Calibration)
{
    uint32_t tmpreg = 0;

    /*---------------- RTC_CRĴRTCCALλ ----------------*/
    tmpreg = (uint32_t)Calibration << RTC_CR_RTCCAL0_POS;
    RTC_CR = SFR_Config (RTC_CR, ~RTC_CR_RTCCAL, tmpreg);
}

/**
  *   RTCʱģTTʹܡ
  *   NewState: RTCʱģTTʹ״̬ȡֵΪTRUE  FALSE
  *   ޡ
  */
void
RTC_Time_Tick_Output_Enable (FunctionalState NewState)
{
    /* У */
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

    /*---------------- RTC_CRĴTTOEλ ----------------*/
    if (NewState != FALSE)
    {
        /* ʹTT */
        SFR_SET_BIT_ASM(RTC_CR, RTC_CR_TTOE_POS);
    }
    else
    {
        /* ֹTT */
        SFR_CLR_BIT_ASM(RTC_CR, RTC_CR_TTOE_POS);
    }
}

/**
  *   ʱͨʹܡ
  *   TimeStampChannel: ʱͨȡֵΪ
  *                    RTC_TIME_STAMP_CHANNEL0: RTC_TS
  *                    RTC_TIME_STAMP_CHANNEL1: WKUP1
  *                    RTC_TIME_STAMP_CHANNEL2: WKUP2
  *                    RTC_TIME_STAMP_CHANNEL3: WKUP3
  *                    RTC_TIME_STAMP_CHANNEL4: WKUP4
  *                    RTC_TIME_STAMP_CHANNEL5: WKUP5
  *                    NewState: RTCʱʹãȡֵΪTRUE  FALSE
  *   ޡ
  */
void
RTC_Time_Stamp_Channel_Enable (uint32_t TimeStampChannel,FunctionalState NewState)
{
    /* У */
    CHECK_RESTRICTION(CHECK_RTC_TIME_STAMP_CHANNEL(TimeStampChannel));
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

    /*---------------- RTC_CRĴRTCTSCHλ ----------------*/
    if (NewState != FALSE)
    {
    	RTC_CR |= TimeStampChannel;
    }
    else
    {

    	RTC_CR &= ~TimeStampChannel;
    }
}

/**
  *   ʱء
  *   TimeStamp: ʱأȡֵΪ
  *                    RTC_TIME_STAMP_RISE: ش
  *                    RTC_TIME_STAMP_FALL: ½ش
  *   ޡ
  */
void
RTC_Time_Stamp_Edge_Config (uint32_t TimeStamp)
{
    /* У */
    CHECK_RESTRICTION(CHECK_RTC_TIME_STAMP_EDGE(TimeStamp));

    /*---------------- RTC_CRĴTSEDGEλ ----------------*/
    if (TimeStamp != RTC_TIME_STAMP_RISE)
    {
        /* ½ش */
        SFR_SET_BIT_ASM(RTC_CR, RTC_CR_TSEDGE_POS);
    }
    else
    {
        /* ش */
        SFR_CLR_BIT_ASM(RTC_CR, RTC_CR_TSEDGE_POS);
    }
}

/**
  *   ʱʹܡ
  *   NewState: ʱʹ״̬ȡֵΪTRUE  FALSE
  *   ޡ
  */
void
RTC_Time_Stamp_Edge_Enable (FunctionalState NewState)
{
    /* У */
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

    /*---------------- RTC_CRĴTSENλ ----------------*/
    if (NewState != FALSE)
    {
        /* ʹʱ */
        SFR_SET_BIT_ASM(RTC_CR, RTC_CR_TSEN_POS);
    }
    else
    {
        /* δʹʱ */
        SFR_CLR_BIT_ASM(RTC_CR, RTC_CR_TSEN_POS);
    }
}

/**
  *   RTCʱ1Сʱʹܡ
  *   NewState: RTCʱ1Сʱʹ״̬ȡֵΪTRUE  FALSE
  *   ޡ
  */
void
RTC_Add_One_Hour_Enable (FunctionalState NewState)
{
    /* У */
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

    /*---------------- RTC_CRĴADD1Hλ ----------------*/
    if (NewState != FALSE)
    {
        /* RTCʱ1Сʱ */
        SFR_SET_BIT_ASM(RTC_CR, RTC_CR_ADD1H_POS);
    }
    else
    {
        /* RTCʱ */
        SFR_CLR_BIT_ASM(RTC_CR, RTC_CR_ADD1H_POS);
    }
}

/**
  *   RTCʱ1Сʱʹܡ
  *   NewState: RTCʱ1Сʱʹ״̬ȡֵΪTRUE  FALSE
  *   ޡ
  */
void
RTC_Sub_One_Hour_Enable (FunctionalState NewState)
{
    /* У */
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

    /*---------------- RTC_CRĴSUB1Hλ ----------------*/
    if (NewState != FALSE)
    {
        /* RTCʱ1Сʱ */
        SFR_SET_BIT_ASM(RTC_CR, RTC_CR_SUB1H_POS);
    }
    else
    {
        /* RTCʱ */
        SFR_CLR_BIT_ASM(RTC_CR, RTC_CR_SUB1H_POS);
    }
}

/**
  *   ʱġ
  *   TimeTick: RTCʱģȡֵΪ:
  *                   RTC_TIME_TICK_DIV_1: ʱΪ1
  *                   RTC_TIME_TICK_DIV_2: ʱΪ1/2
  *                   RTC_TIME_TICK_DIV_4: ʱΪ1/4
  *                   RTC_TIME_TICK_DIV_8: ʱΪ1/8
  *                   RTC_TIME_TICK_DIV_16: ʱΪ1/16
  *                   RTC_TIME_TICK_DIV_32: ʱΪ1/32
  *                   RTC_TIME_TICK_DIV_64: ʱΪ1/64
  *                   RTC_TIME_TICK_DIV_128: ʱΪ1/128
  *   ޡ
  */
void
RTC_Time_Tick_Config (uint32_t Calibration)
{
    /* У */
    CHECK_RESTRICTION(CHECK_RTC_TIME_TICK(Calibration));

    /*---------------- RTC_CRĴRTCTTλ ----------------*/
    RTC_CR = SFR_Config (RTC_CR, ~RTC_CR_RTCTT, Calibration);
}


/**
  *   ʼʵʱʱģ顣
  *   ޡ
  *   ޡ
  */
void
RTC_Reset_Config (void)
{
    /*---------------- RTC_CRĴRESETλ ----------------*/
    /* λRTCģ */
    SFR_SET_BIT_ASM(RTC_CR, RTC_CR_RESET_POS);
    /* ˳λRTCģ */
    SFR_CLR_BIT_ASM(RTC_CR, RTC_CR_RESET_POS);
}

/**
  *   ȡָʾ־
  *   ޡ
  *   1:ǰΪꣻ0:ǰΪƽꡣ
  */
FlagStatus
RTC_Get_Leap_Year_Flag (void)
{
    /*---------------- ȡRTC_CRĴLIFλ ----------------*/
    if (RTC_CR & RTC_CR_LIF)
    {
        /* ǰΪ */
        return SET;
    }
    else
    {
        /* ǰΪƽ */
        return RESET;
    }
}

/**
  *   Сʱʾ͡
  *   HourFormat: RTCСʱʾͣȡֵΪ:
  *                     RTC_HOUR_FORMAT_24: 24Сʱƣ
  *                     RTC_HOUR_FORMAT_12: 12Сʱơ
  *   ޡ
  */
void
RTC_Hour_Format_Config (uint32_t HourFormat)
{
    /* У */
    CHECK_RESTRICTION(CHECK_RTC_HOURFORMAT(HourFormat));

    /*---------------- RTC_CRĴHTλ ----------------*/
    if (HourFormat != RTC_HOUR_FORMAT_24)
    {
        /* 12Сʱ */
        SFR_SET_BIT_ASM(RTC_CR, RTC_CR_HT_POS);
    }
    else
    {
        /* 24Сʱ */
        SFR_CLR_BIT_ASM(RTC_CR, RTC_CR_HT_POS);
    }
}

/**
  *   ģʽʹܡ
  *   ConfigMode: ģʽ״̬ȡֵΪTRUE  FALSE
  *   ޡ
  */
void
RTC_Config_Mode_Enable (FunctionalState ConfigMode)
{
    /* У */
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(ConfigMode));

    /*---------------- RTC_CRĴCNFλ ----------------*/
    if (ConfigMode != FALSE)
    {
        /* ģʽ */
        SFR_SET_BIT_ASM(RTC_CR, RTC_CR_CNF_POS);
    }
    else
    {
        /* ˳ģʽ */
        SFR_CLR_BIT_ASM(RTC_CR, RTC_CR_CNF_POS);
    }
}

/**
  *   ȡRTCرָʾ־
  *   ޡ
  *   1:һζRTCĴдѾɣ
  *       0:һζRTCĴдڽС
  */
FlagStatus
RTC_Get_Operation_Off_Flag (void)
{
    /*---------------- ȡRTC_CRĴRTOFFλ ----------------*/
    if (RTC_CR & RTC_CR_RTOFF)
    {
        /* һζRTCĴдѾ */
        return SET;
    }
    else
    {
        /* һζRTCĴдڽ */
        return RESET;
    }
}

/**
  *   ȡRTC״̬ 
  *   ޡ
  *   1:RTCЧ״̬
  *       0:RTCڸλ״̬
  */
FlagStatus
RTC_Get_Action_State_Flag (void)
{
    /*---------------- ȡRTC_CRĴRTCLDλ ----------------*/
    if (RTC_CR & RTC_CR_RTCLD)
    {
        /* RTCЧ״̬ */
        return SET;
    }
    else
    {
        /* RTCڸλ״̬ */
        return RESET;
    }
}

/**
  *   RTCʹܡ
  *   NewState: RTCʹ״̬ȡֵΪTRUE  FALSE
  *   ޡ
  */
void
RTC_Enable (FunctionalState NewState)
{
    /* У */
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

    /*---------------- RTC_CRĴRTCENλ ----------------*/
    if (NewState != FALSE)
    {
        /* ʹRTC */
        SFR_SET_BIT_ASM(RTC_CR, RTC_CR_RTCEN_POS);
    }
    else
    {
        /* ֹRTC */
        SFR_CLR_BIT_ASM(RTC_CR, RTC_CR_RTCEN_POS);
    }
}
/**
  *   ##### ʵʱʱ(RTC)ƹܺ #####
  */


/**
  *   ##### ʵʱʱ(RTC)ú #####
  */
/**
  *   Aʹܡ
  *   NewState: Aʹ״̬ȡֵΪTRUE  FALSE
  *   ޡ
  */
void
RTC_Alarm_A_Enable (FunctionalState NewState)
{
    /* У */
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

    /*---------------- RTC_ALRAĴALRENAλ ----------------*/
    if (NewState != FALSE)
    {
        /* ʹA */
        SFR_SET_BIT_ASM(RTC_ALRA, RTC_ALRA_ALRENA_POS);
    }
    else
    {
        /* ֹA */
        SFR_CLR_BIT_ASM(RTC_ALRA, RTC_ALRA_ALRENA_POS);
    }
}

/**
  *   Aʹܡ
  *   NewState: Aʹ״̬ȡֵΪTRUE  FALSE
  *   ޡ
  */
void
RTC_Alarm_A_Weekday_Enable (FunctionalState NewState)
{
    /* У */
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

    /*---------------- RTC_ALRAĴAWENAλ ----------------*/
    if (NewState != FALSE)
    {
        /* ʹAλ */
        SFR_SET_BIT_ASM(RTC_ALRA, RTC_ALRA_AWENA_POS);
    }
    else
    {
        /* ֹAλ */
        SFR_CLR_BIT_ASM(RTC_ALRA, RTC_ALRA_AWENA_POS);
    }
}

/**
  *   жʱ䡣
  *   Weekday: жʱ䣬ȡֵΪ:
  *                  RTC_WEEKDAY_MONDAY: һ
  *                  RTC_WEEKDAY_TUESDAY: ڶ
  *                  RTC_WEEKDAY_WEDNESDAY: 
  *                  RTC_WEEKDAY_THURSDAY: 
  *                  RTC_WEEKDAY_FRIDAY: 
  *                  RTC_WEEKDAY_SATURDAY: 
  *                  RTC_WEEKDAY_SUNDAY: 
  *   ޡ
  */
void
RTC_Alarm_A_Weekday_Config (uint8_t Weekday)
{
    uint32_t tmpreg = 0;

    /* У */
    CHECK_RESTRICTION(CHECK_RTC_WEEKDAY(Weekday));

    /*---------------- RTC_ALRAĴALRWAλ ----------------*/
    tmpreg = (uint32_t)Weekday << RTC_ALRA_ALRWA0_POS;
    RTC_ALRA = SFR_Config (RTC_ALRA, ~RTC_ALRA_ALRWA, tmpreg);
}

/**
  *   Aʱʹܡ
  *   NewState: Aʱʹ״̬ȡֵΪTRUE  FALSE
  *   ޡ
  */
void
RTC_Alarm_A_Hours_Enable (FunctionalState NewState)
{
    /* У */
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

    /*---------------- RTC_ALRAĴAHENAλ ----------------*/
    if (NewState != FALSE)
    {
        /* ʹAʱλ */
        SFR_SET_BIT_ASM(RTC_ALRA, RTC_ALRA_AHENA_POS);
    }
    else
    {
        /* ֹAʱλ */
        SFR_CLR_BIT_ASM(RTC_ALRA, RTC_ALRA_AHENA_POS);
    }
}

/**
  *   Aѡ
  *   NewSelect: AѡȡֵΪ:
  *                    RTC_TIME_AM: ѡʱ䣬
  *                    RTC_TIME_PM: ѡʱ䡣
  *   ޡ
  */
void
RTC_Alarm_A_AMPM_Config (uint32_t NewSelect)
{
    /* У */
    CHECK_RESTRICTION(CHECK_RTC_TIME_AMPM(NewSelect));

    /*---------------- RTC_ALRAĴAMPMAλ ----------------*/
    if (NewSelect != RTC_TIME_AM)
    {
        /* ѡʱ */
        SFR_SET_BIT_ASM(RTC_ALRA, RTC_ALRA_AMPMA_POS);
    }
    else
    {
        /* ѡʱ */
        SFR_CLR_BIT_ASM(RTC_ALRA, RTC_ALRA_AMPMA_POS);
    }
}

/**
  *   жСʱʱ䣬ûƥ12Сʱƻ24Сʱơ
  *   Hour: жСʱʱ䣬ȡֵƥ12Сʱƻ24Сʱơ
  *   ޡ
  */
void
RTC_Alarm_A_Hours_Config (uint32_t Hour)
{
    uint32_t tmpreg = 0;

    /* У */
    CHECK_RESTRICTION(CHECK_RTC_HOUR24(Hour));

    /*---------------- RTC_ALRAĴALRHAλ ----------------*/
    tmpreg = RTC_Byte_To_Bcd(Hour);
    tmpreg <<= RTC_ALRA_ALRHA0_POS;
    RTC_ALRA = SFR_Config (RTC_ALRA, ~RTC_ALRA_ALRHA, tmpreg);
}

/**
  *   Aʹܡ
  *   NewState: Aʹ״̬ȡֵΪTRUE  FALSE
  *   ޡ
  */
void
RTC_Alarm_A_Minutes_Enable (FunctionalState NewState)
{
    /* У */
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

    /*---------------- RTC_ALRAĴAMENAλ ----------------*/
    if (NewState != FALSE)
    {
        /* ʹAλ */
        SFR_SET_BIT_ASM(RTC_ALRA, RTC_ALRA_AMENA_POS);
    }
    else
    {
        /* ֹAλ */
        SFR_CLR_BIT_ASM(RTC_ALRA, RTC_ALRA_AMENA_POS);
    }
}

/**
  *   жϷʱ䡣
  *   Minutes: жϷʱ䣬ȡֵΪ0-59
  *   ޡ
  */
void
RTC_Alarm_A_Minutes_Config (uint32_t Minutes)
{
    uint32_t tmpreg = 0;

    /* У */
    CHECK_RESTRICTION(CHECK_RTC_MINUTES(Minutes));

    /*---------------- RTC_ALRAĴALRMAλ ----------------*/
    tmpreg = RTC_Byte_To_Bcd(Minutes);
    tmpreg <<= RTC_ALRA_ALRMA0_POS;
    RTC_ALRA = SFR_Config (RTC_ALRA, ~RTC_ALRA_ALRMA, tmpreg);
}

/**
  *   Aʹܡ
  *   NewState: Aʹ״̬ȡֵΪTRUE  FALSE
  *   ޡ
  */
void
RTC_Alarm_A_Seconds_Enable (FunctionalState NewState)
{
    /* У */
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

    /*---------------- RTC_ALRAĴASENAλ ----------------*/
    if (NewState != FALSE)
    {
        /* ʹAλ */
        SFR_SET_BIT_ASM(RTC_ALRA, RTC_ALRA_ASENA_POS);
    }
    else
    {
        /* ֹAλ */
        SFR_CLR_BIT_ASM(RTC_ALRA, RTC_ALRA_ASENA_POS);
    }
}

/**
  *   жʱ䡣
  *   Seconds: жʱ䣬ȡֵΪ0-59
  *   ޡ
  */
void
RTC_Alarm_A_Seconds_Config (uint32_t Seconds)
{
    uint32_t tmpreg = 0;

    /* У */
    CHECK_RESTRICTION(CHECK_RTC_SECONDS(Seconds));

    /*---------------- RTC_ALRAĴALRSAλ ----------------*/
    tmpreg = RTC_Byte_To_Bcd(Seconds);
    tmpreg <<= RTC_ALRA_ALRSA0_POS;
    RTC_ALRA = SFR_Config (RTC_ALRA, ~RTC_ALRA_ALRSA, tmpreg);
}

/**
  *   Bʹܡ
  *   NewState: Bʹ״̬ȡֵΪTRUE  FALSE
  *   ޡ
  */
void
RTC_Alarm_B_Enable (FunctionalState NewState)
{
    /* У */
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

    /*---------------- RTC_ALRBĴALRENBλ ----------------*/
    if (NewState != FALSE)
    {
        /* ʹB */
        SFR_SET_BIT_ASM(RTC_ALRB, RTC_ALRB_ALRENB_POS);
    }
    else
    {
        /* ֹB */
        SFR_CLR_BIT_ASM(RTC_ALRB, RTC_ALRB_ALRENB_POS);
    }
}

/**
  *   Bʹܡ
  *   NewState: Bʹ״̬ȡֵΪTRUE  FALSE
  *   ޡ
  */
void
RTC_Alarm_B_Weekday_Enable (FunctionalState NewState)
{
    /* У */
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

    /*---------------- RTC_ALRBĴAWENBλ ----------------*/
    if (NewState != FALSE)
    {
        /* ʹBλ */
        SFR_SET_BIT_ASM(RTC_ALRB, RTC_ALRB_AWENB_POS);
    }
    else
    {
        /* ֹBλ */
        SFR_CLR_BIT_ASM(RTC_ALRB, RTC_ALRB_AWENB_POS);
    }
}

/**
  *   жʱ䡣
  *   Weekday: жʱ䣬ȡֵΪ:
  *                  RTC_WEEKDAY_MONDAY: һ
  *                  RTC_WEEKDAY_TUESDAY: ڶ
  *                  RTC_WEEKDAY_WEDNESDAY: 
  *                  RTC_WEEKDAY_THURSDAY: 
  *                  RTC_WEEKDAY_FRIDAY: 
  *                  RTC_WEEKDAY_SATURDAY: 
  *                  RTC_WEEKDAY_SUNDAY: 
  *   ޡ
  */
void
RTC_Alarm_B_Weekday_Config (uint8_t Weekday)
{
    uint32_t tmpreg = 0;

    /* У */
    CHECK_RESTRICTION(CHECK_RTC_WEEKDAY(Weekday));

    /*---------------- RTC_ALRBĴALRWBλ ----------------*/
    tmpreg = (uint32_t)Weekday << RTC_ALRB_ALRWB0_POS;
    RTC_ALRB = SFR_Config (RTC_ALRB, ~RTC_ALRB_ALRWB, tmpreg);
}

/**
  *   Bʱʹܡ
  *   NewState: Bʱʹ״̬ȡֵΪTRUE  FALSE
  *   ޡ
  */
void
RTC_Alarm_B_Hours_Enable (FunctionalState NewState)
{
    /* У */
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

    /*---------------- RTC_ALRBĴAHENBλ ----------------*/
    if (NewState != FALSE)
    {
        /* ʹBʱλ */
        SFR_SET_BIT_ASM(RTC_ALRB, RTC_ALRB_AHENB_POS);
    }
    else
    {
        /* ֹBʱλ */
        SFR_CLR_BIT_ASM(RTC_ALRB, RTC_ALRB_AHENB_POS);
    }
}

/**
  *   Bѡ
  *   NewSelect: BѡȡֵΪ:
  *                    RTC_TIME_AM: ѡʱ䣬
  *                    RTC_TIME_PM: ѡʱ䡣
  *   ޡ
  */
void
RTC_Alarm_B_AMPM_Config (uint32_t NewSelect)
{
    /* У */
    CHECK_RESTRICTION(CHECK_RTC_TIME_AMPM(NewSelect));

    /*---------------- RTC_ALRBĴAMPMBλ ----------------*/
    if (NewSelect != RTC_TIME_AM)
    {
        /* ѡʱ */
        SFR_SET_BIT_ASM(RTC_ALRB, RTC_ALRB_AMPMB_POS);
    }
    else
    {
        /* ѡʱ */
        SFR_CLR_BIT_ASM(RTC_ALRB, RTC_ALRB_AMPMB_POS);
    }
}

/**
  *   жСʱʱ䣬ûƥ12Сʱƻ24Сʱơ
  *   Hour: жСʱʱ䣬ȡֵƥ12Сʱƻ24Сʱơ
  *   ޡ
  */
void
RTC_Alarm_B_Hours_Config (uint32_t Hour)
{
    uint32_t tmpreg = 0;

    /* У */
    CHECK_RESTRICTION(CHECK_RTC_HOUR24(Hour));

    /*---------------- RTC_ALRBĴALRHBλ ----------------*/
    tmpreg = RTC_Byte_To_Bcd(Hour);
    tmpreg <<= RTC_ALRB_ALRHB0_POS;
    RTC_ALRB = SFR_Config (RTC_ALRB, ~RTC_ALRB_ALRHB, tmpreg);
}

/**
  *   Bʹܡ
  *   NewState: Bʹ״̬ȡֵΪTRUE  FALSE
  *   ޡ
  */
void
RTC_Alarm_B_Minutes_Enable (FunctionalState NewState)
{
    /* У */
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

    /*---------------- RTC_ALRBĴAMENBλ ----------------*/
    if (NewState != FALSE)
    {
        /* ʹBλ */
        SFR_SET_BIT_ASM(RTC_ALRB, RTC_ALRB_AMENB_POS);
    }
    else
    {
        /* ֹBλ */
        SFR_CLR_BIT_ASM(RTC_ALRB, RTC_ALRB_AMENB_POS);
    }
}

/**
  *   жϷʱ䡣
  *   Minutes: жϷʱ䣬ȡֵΪ0-59
  *   ޡ
  */
void
RTC_Alarm_B_Minutes_Config (uint32_t Minutes)
{
    uint32_t tmpreg = 0;

    /* У */
    CHECK_RESTRICTION(CHECK_RTC_MINUTES(Minutes));

    /*---------------- RTC_ALRBĴALRMBλ ----------------*/
    tmpreg = RTC_Byte_To_Bcd(Minutes);
    tmpreg <<= RTC_ALRB_ALRMB0_POS;
    RTC_ALRB = SFR_Config (RTC_ALRB, ~RTC_ALRB_ALRMB, tmpreg);
}

/**
  *   Bʹܡ
  *   NewState: Bʹ״̬ȡֵΪTRUE  FALSE
  *   ޡ
  */
void
RTC_Alarm_B_Seconds_Enable (FunctionalState NewState)
{
    /* У */
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

    /*---------------- RTC_ALRBĴASENBλ ----------------*/
    if (NewState != FALSE)
    {
        /* ʹBλ */
        SFR_SET_BIT_ASM(RTC_ALRB, RTC_ALRB_ASENB_POS);
    }
    else
    {
        /* ֹBλ */
        SFR_CLR_BIT_ASM(RTC_ALRB, RTC_ALRB_ASENB_POS);
    }
}

/**
  *   жʱ䡣
  *   Seconds: жʱ䣬ȡֵΪ0-59
  *   ޡ
  */
void
RTC_Alarm_B_Seconds_Config (uint32_t Seconds)
{
    uint32_t tmpreg = 0;

    /* У */
    CHECK_RESTRICTION(CHECK_RTC_SECONDS(Seconds));

    /*---------------- RTC_ALRBĴALRSBλ ----------------*/
    tmpreg = RTC_Byte_To_Bcd(Seconds);
    tmpreg <<= RTC_ALRB_ALRSB0_POS;
    RTC_ALRB = SFR_Config (RTC_ALRB, ~RTC_ALRB_ALRSB, tmpreg);
}
/**
  *   ##### ʵʱʱ(RTC)ú #####
  */


/**
  *   ##### ʵʱʱ(RTC)ʱú #####
  */
/**
  *   RTCʱڡ
  *   Weekday: RTCʱڣȡֵΪ:
  *                  RTC_WEEKDAY_MONDAY: һ
  *                  RTC_WEEKDAY_TUESDAY: ڶ
  *                  RTC_WEEKDAY_WEDNESDAY: 
  *                  RTC_WEEKDAY_THURSDAY: 
  *                  RTC_WEEKDAY_FRIDAY: 
  *                  RTC_WEEKDAY_SATURDAY: 
  *                  RTC_WEEKDAY_SUNDAY: 
  *   ޡ
  */
void
RTC_Weekday_Config (uint8_t Weekday)
{
    uint32_t tmpreg = 0;

    /* У */
    CHECK_RESTRICTION(CHECK_RTC_WEEKDAY(Weekday));

    /*---------------- RTC_TMRĴWEKλ ----------------*/
    tmpreg = (uint32_t)Weekday << RTC_TMR_WEK0_POS;
    RTC_TMR = SFR_Config (RTC_TMR, ~RTC_TMR_WEK, tmpreg);
}

/**
  *   RTCʱѡ
  *   NewSelect: RTCʱѡȡֵΪ:
  *                    RTC_TIME_AM: ѡʱ䣬
  *                    RTC_TIME_PM: ѡʱ䡣
  *   ޡ
  */
void
RTC_AMPM_Config (uint32_t NewSelect)
{
    /* У */
    CHECK_RESTRICTION(CHECK_RTC_TIME_AMPM(NewSelect));

    /*---------------- RTC_TMRĴAMPMλ ----------------*/
    if (NewSelect != RTC_TIME_AM)
    {
        /* ѡʱ */
        SFR_SET_BIT_ASM(RTC_TMR, RTC_TMR_AMPM_POS);
    }
    else
    {
        /* ѡʱ */
        SFR_CLR_BIT_ASM(RTC_TMR, RTC_TMR_AMPM_POS);
    }
}

/**
  *   RTCʱʱʱ䡣
  *   Hour: RTCʱʱʱ䣬ȡֵƥ12Сʱƻ24Сʱơ
  *   ޡ
  */
void
RTC_Hours_Config (uint32_t Hour)
{
    uint32_t tmpreg = 0;

    /* У */
    CHECK_RESTRICTION(CHECK_RTC_HOUR24(Hour));

    /*---------------- RTC_TMRĴHOURλ ----------------*/
    tmpreg = RTC_Byte_To_Bcd(Hour);
    tmpreg <<= RTC_TMR_HOUR0_POS;
    RTC_TMR = SFR_Config (RTC_TMR, ~RTC_TMR_HOUR, tmpreg);
}

/**
  *   RTCʱӷʱ䡣
  *   Minutes: RTCʱӷʱ䣬ȡֵΪ0-59
  *   ޡ
  */
void
RTC_Minutes_Config (uint32_t Minutes)
{
    uint32_t tmpreg = 0;

    /* У */
    CHECK_RESTRICTION(CHECK_RTC_MINUTES(Minutes));

    /*---------------- RTC_TMRĴMINλ ----------------*/
    tmpreg = RTC_Byte_To_Bcd(Minutes);
    tmpreg <<= RTC_TMR_MIN0_POS;
    RTC_TMR = SFR_Config (RTC_TMR, ~RTC_TMR_MIN, tmpreg);
}

/**
  *   RTCʱʱ䡣
  *   Seconds: RTCʱʱ䣬ȡֵΪ0-59
  *   ޡ
  */
void
RTC_Seconds_Config (uint32_t Seconds)
{
    uint32_t tmpreg = 0;

    /* У */
    CHECK_RESTRICTION(CHECK_RTC_SECONDS(Seconds));

    /*---------------- RTC_TMRĴSECλ ----------------*/
    tmpreg = RTC_Byte_To_Bcd(Seconds);
    tmpreg <<= RTC_TMR_SEC0_POS;
    RTC_TMR = SFR_Config (RTC_TMR, ~RTC_TMR_SEC, tmpreg);
}

/**
  *   RTCʱݡ
  *   Year: RTCʱݣȡֵΪ0-99
  *   ޡ
  */
void
RTC_Year_Config (uint32_t Year)
{
    uint32_t tmpreg = 0;

    /* У */
    CHECK_RESTRICTION(CHECK_RTC_YEAR(Year));

    /*---------------- RTC_DTRĴYEARλ ----------------*/
    tmpreg = RTC_Byte_To_Bcd(Year);
    tmpreg <<= RTC_DTR_YEAR0_POS;
    RTC_DTR = SFR_Config (RTC_DTR, ~RTC_DTR_YEAR, tmpreg);
}

/**
  *   RTCʱ·ݡ
  *   Month: RTCʱ·ݣȡֵΪ:
  *                RTC_MONTH_JANUARY: 1
  *                RTC_MONTH_FEBRUARY: 2
  *                RTC_MONTH_MARCH: 3
  *                RTC_MONTH_APRIL: 4
  *                RTC_MONTH_MAY: 5
  *                RTC_MONTH_JUNE: 6
  *                RTC_MONTH_JULY: 7
  *                RTC_MONTH_AUGUST: 8
  *                RTC_MONTH_SEPTEMBER: 9
  *                RTC_MONTH_OCTOBER: 10
  *                RTC_MONTH_NOVEMBER: 11
  *                RTC_MONTH_DECEMBER: 12
  *   ޡ
  */
void
RTC_Month_Config (uint32_t Month)
{
    uint32_t tmpreg = 0;

    /* У */
    CHECK_RESTRICTION(CHECK_RTC_MONTH_BCD(Month));

    /*---------------- RTC_DTRĴMTHλ ----------------*/
    tmpreg = Month << RTC_DTR_MTH0_POS;
    RTC_DTR = SFR_Config (RTC_DTR, ~RTC_DTR_MTH, tmpreg);
}

/**
  *   RTCʱڡ
  *   Day: RTCʱڣȡֵΪ1-31
  *   ޡ
  */
void
RTC_Day_Config (uint32_t Day)
{
    uint32_t tmpreg = 0;

    /* У */
    CHECK_RESTRICTION(CHECK_RTC_DATE(Day));

    /*---------------- RTC_DTRĴDAYλ ----------------*/
    tmpreg = RTC_Byte_To_Bcd(Day);
    tmpreg <<= RTC_DTR_DAY0_POS;
    RTC_DTR = SFR_Config (RTC_DTR, ~RTC_DTR_DAY, tmpreg);
}

/**
  *   RTCʱڱݡ
  *   Weekday: RTCʱڱݣȡֵΪ:
  *                  RTC_WEEKDAY_MONDAY: һ
  *                  RTC_WEEKDAY_TUESDAY: ڶ
  *                  RTC_WEEKDAY_WEDNESDAY: 
  *                  RTC_WEEKDAY_THURSDAY: 
  *                  RTC_WEEKDAY_FRIDAY: 
  *                  RTC_WEEKDAY_SATURDAY: 
  *                  RTC_WEEKDAY_SUNDAY: 
  *   ޡ
  */
void
RTC_Weekday_Backup_Config (uint8_t Weekday)
{
    uint32_t tmpreg = 0;

    /* У */
    CHECK_RESTRICTION(CHECK_RTC_WEEKDAY(Weekday));

    /*---------------- RTC_TMBRĴWEKBλ ----------------*/
    tmpreg = (uint32_t)Weekday << RTC_TMBR_WEKB0_POS;
    RTC_TMBR = SFR_Config (RTC_TMBR, ~RTC_TMBR_WEKB, tmpreg);
}

/**
  *   RTCʱѡ񱸷ݡ
  *   NewSelect: RTCʱѡ񱸷ݣȡֵΪ:
  *                    RTC_TIME_AM: ѡʱ䣬
  *                    RTC_TIME_PM: ѡʱ䡣
  *   ޡ
  */
void
RTC_AMPM_Backup_Config (uint32_t NewSelect)
{
    /* У */
    CHECK_RESTRICTION(CHECK_RTC_TIME_AMPM(NewSelect));

    /*---------------- RTC_TMBRĴAMPMBλ ----------------*/
    if (NewSelect != RTC_TIME_AM)
    {
        /* ѡʱ */
        SFR_SET_BIT_ASM(RTC_TMBR, RTC_TMBR_AMPMB_POS);
    }
    else
    {
        /* ѡʱ */
        SFR_CLR_BIT_ASM(RTC_TMBR, RTC_TMBR_AMPMB_POS);
    }
}

/**
  *   RTCʱʱʱ䱸ݡ
  *   Hour: RTCʱʱʱ䱸ݣȡֵƥ12Сʱƻ24Сʱơ
  *   ޡ
  */
void
RTC_Hours_Backup_Config (uint32_t Hour)
{
    uint32_t tmpreg = 0;

    /* У */
    CHECK_RESTRICTION(CHECK_RTC_HOUR24(Hour));

    /*---------------- RTC_TMBRĴHOURBλ ----------------*/
    tmpreg = RTC_Byte_To_Bcd(Hour);
    tmpreg <<= RTC_TMBR_HOURB0_POS;
    RTC_TMBR = SFR_Config (RTC_TMBR, ~RTC_TMBR_HOURB, tmpreg);
}

/**
  *   RTCʱӷʱ䱸ݡ
  *   Minutes: RTCʱӷʱ䱸ݣȡֵΪ0-59
  *   ޡ
  */
void
RTC_Minutes_Backup_Config (uint32_t Minutes)
{
    uint32_t tmpreg = 0;

    /* У */
    CHECK_RESTRICTION(CHECK_RTC_MINUTES(Minutes));

    /*---------------- RTC_TMBRĴMINBλ ----------------*/
    tmpreg = RTC_Byte_To_Bcd(Minutes);
    tmpreg <<= RTC_TMBR_MINB0_POS;
    RTC_TMBR = SFR_Config (RTC_TMBR, ~RTC_TMBR_MINB, tmpreg);
}

/**
  *   RTCʱʱ䱸ݡ
  *   Seconds: RTCʱʱ䱸ݣȡֵΪ0-59
  *   ޡ
  */
void
RTC_Seconds_Backup_Config (uint32_t Seconds)
{
    uint32_t tmpreg = 0;

    /* У */
    CHECK_RESTRICTION(CHECK_RTC_SECONDS(Seconds));

    /*---------------- RTC_TMBRĴSECBλ ----------------*/
    tmpreg = RTC_Byte_To_Bcd(Seconds);
    tmpreg <<= RTC_TMBR_SECB0_POS;
    RTC_TMBR = SFR_Config (RTC_TMBR, ~RTC_TMBR_SECB, tmpreg);
}

/**
  *   RTCʱݱݡ
  *   Year: RTCʱݱݣȡֵΪ0-99
  *   ޡ
  */
void
RTC_Year_Backup_Config (uint32_t Year)
{
    uint32_t tmpreg = 0;

    /* У */
    CHECK_RESTRICTION(CHECK_RTC_YEAR(Year));

    /*---------------- RTC_DTBRĴYEARBλ ----------------*/
    tmpreg = RTC_Byte_To_Bcd(Year);
    tmpreg <<= RTC_DTBR_YEARB0_POS;
    RTC_DTBR = SFR_Config (RTC_DTBR, ~RTC_DTBR_YEARB, tmpreg);
}

/**
  *   RTCʱ·ݱݡ
  *   Month: RTCʱ·ݱݣȡֵΪ:
  *                RTC_MONTH_JANUARY: 1
  *                RTC_MONTH_FEBRUARY: 2
  *                RTC_MONTH_MARCH: 3
  *                RTC_MONTH_APRIL: 4
  *                RTC_MONTH_MAY: 5
  *                RTC_MONTH_JUNE: 6
  *                RTC_MONTH_JULY: 7
  *                RTC_MONTH_AUGUST: 8
  *                RTC_MONTH_SEPTEMBER: 9
  *                RTC_MONTH_OCTOBER: 10
  *                RTC_MONTH_NOVEMBER: 11
  *                RTC_MONTH_DECEMBER: 12
  *   ޡ
  */
void
RTC_Month_Backup_Config (uint32_t Month)
{
    uint32_t tmpreg = 0;

    /* У */
    CHECK_RESTRICTION(CHECK_RTC_MONTH_BCD(Month));

    /*---------------- RTC_DTBRĴMTHBλ ----------------*/
    tmpreg = Month << RTC_DTBR_MTHB0_POS;
    RTC_DTBR = SFR_Config (RTC_DTBR, ~RTC_DTBR_MTHB, tmpreg);
}

/**
  *   RTCʱڱݡ
  *   Day: RTCʱڱݣȡֵΪ1-31
  *   ޡ
  */
void
RTC_Day_Backup_Config (uint32_t Day)
{
    uint32_t tmpreg = 0;

    /* У */
    CHECK_RESTRICTION(CHECK_RTC_DATE(Day));

    /*---------------- RTC_DTBRĴDAYBλ ----------------*/
    tmpreg = RTC_Byte_To_Bcd(Day);
    tmpreg <<= RTC_DTBR_DAYB0_POS;
    RTC_DTBR = SFR_Config (RTC_DTBR, ~RTC_DTBR_DAYB, tmpreg);
}
/**
  *   ##### ʵʱʱ(RTC)ʱú #####
  */


/**
  *   ##### ʵʱʱ(RTC)ʱú #####
  */
/**
  *   RTCʱ1ֵ
  *   Counter: RTCʱ1ֵȡֵΪ16λֵ
  *   ޡ
  */
void
RTC_Timer1_Config (uint16_t Counter)
{
    uint32_t tmpreg = 0;

    /*---------------- RTC_TMERĴTMR1λ ----------------*/
    tmpreg = (uint32_t)Counter << RTC_TMER_TMR1_0_POS;
    RTC_TMER = SFR_Config (RTC_TMER, ~RTC_TMER_TMR1, tmpreg);
}

/**
  *   RTCʱ0ֵ
  *   Counter: RTCʱ0ֵȡֵΪ16λֵ
  *   ޡ
  */
void
RTC_Timer0_Config (uint16_t Counter)
{
    uint32_t tmpreg = 0;

    /*---------------- RTC_TMERĴTMR0λ ----------------*/
    tmpreg = (uint32_t)Counter << RTC_TMER_TMR0_0_POS;
    RTC_TMER = SFR_Config (RTC_TMER, ~RTC_TMER_TMR0, tmpreg);
}

/**
  *   RTCʱ1ʹܡ
  *   TimerEnable: RTCʱ1ʹ״̬ȡֵΪTRUE  FALSE
  *   ޡ
  */
void
RTC_Timer1_Enable (FunctionalState TimerEnable)
{
    /* У */
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(TimerEnable));

    /*---------------- RTC_TCRĴTMR1ENλ ----------------*/
    if (TimerEnable != FALSE)
    {
        /* ʹܶʱ1 */
        SFR_SET_BIT_ASM(RTC_TCR, RTC_TCR_TMR1EN_POS);
    }
    else
    {
        /* ֹʱ1 */
        SFR_CLR_BIT_ASM(RTC_TCR, RTC_TCR_TMR1EN_POS);
    }
}

/**
  *   RTCʱ0ʹܡ
  *   TimerEnable: RTCʱ0ʹ״̬ȡֵΪTRUE  FALSE
  *   ޡ
  */
void
RTC_Timer0_Enable (FunctionalState TimerEnable)
{
    /* У */
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(TimerEnable));

    /*---------------- RTC_TCRĴTMR0ENλ ----------------*/
    if (TimerEnable != FALSE)
    {
        /* ʹܶʱ0 */
        SFR_SET_BIT_ASM(RTC_TCR, RTC_TCR_TMR0EN_POS);
    }
    else
    {
        /* ֹʱ0 */
        SFR_CLR_BIT_ASM(RTC_TCR, RTC_TCR_TMR0EN_POS);
    }
}

/**
  *   öʱ1ʱԴѡ
  *   ClockSource: ʱ1ʱԴѡȡֵΪ:
  *                      RTC_TIMER_CLOCK_RTC_DIV_128: RTCʱԴ/128 Լ1/256s
  *                      RTC_TIMER_CLOCK_RTC_DIV_512: RTCʱԴ/512 Լ1/64s
  *                      RTC_TIMER_CLOCK_RTC_DIV_1024: RTCʱԴ/1024 Լ1/32s
  *                      RTC_TIMER_CLOCK_RTC_DIV_2048: RTCʱԴ/2048 Լ1/16s
  *                      RTC_TIMER_CLOCK_RTC_DIV_8192: RTCʱԴ/8192 Լ1/4s
  *                      RTC_TIMER_CLOCK_ONE_SECOND: 1s
  *                      RTC_TIMER_CLOCK_ONE_MINUTE: 1min
  *                      RTC_TIMER_CLOCK_ONE_HOUR: 1hour
  *                      RTC_TIMER_CLOCK_CONNECTION: TMR1TMR0
  *   ޡ
  */
void
RTC_Timer1_Source_Config (uint16_t ClockSource)
{
    uint32_t tmpreg = 0;

    /* У */
    CHECK_RESTRICTION(CHECK_RTC_TIMER1_CLOCK(ClockSource));

    /*---------------- RTC_TCRĴTMR1Cλ ----------------*/
    tmpreg = (uint32_t)ClockSource << RTC_TCR_TMR1C0_POS;
    RTC_TCR = SFR_Config (RTC_TCR, ~RTC_TCR_TMR1C, tmpreg);
}

/**
  *   öʱ0ʱԴѡ
  *   ClockSource: ʱ0ʱԴѡȡֵΪ:
  *                      RTC_TIMER_CLOCK_RTC_DIV_128: RTCʱԴ/128 Լ1/256s
  *                      RTC_TIMER_CLOCK_RTC_DIV_512: RTCʱԴ/512 Լ1/64s
  *                      RTC_TIMER_CLOCK_RTC_DIV_1024: RTCʱԴ/1024 Լ1/32s
  *                      RTC_TIMER_CLOCK_RTC_DIV_2048: RTCʱԴ/2048 Լ1/16s
  *                      RTC_TIMER_CLOCK_RTC_DIV_8192: RTCʱԴ/8192 Լ1/4s
  *                      RTC_TIMER_CLOCK_ONE_SECOND: 1s
  *                      RTC_TIMER_CLOCK_ONE_MINUTE: 1min
  *                      RTC_TIMER_CLOCK_ONE_HOUR: 1hour
  *   ޡ
  */
void
RTC_Timer0_Source_Config (uint16_t ClockSource)
{
    uint32_t tmpreg = 0;

    /* У */
    CHECK_RESTRICTION(CHECK_RTC_TIMER0_CLOCK(ClockSource));

    /*---------------- RTC_TCRĴTMR0Cλ ----------------*/
    tmpreg = (uint32_t)ClockSource << RTC_TCR_TMR0C0_POS;
    RTC_TCR = SFR_Config (RTC_TCR, ~RTC_TCR_TMR0C, tmpreg);
}

/**
  *   ##### ʵʱʱ(RTC)ʱú #####
  */


/**
  *   ##### ʵʱʱ(RTC)жϹ #####
  */
/**
  *   RTCʱжʹܡ
  *   NewState: RTCʱжʹ״̬ȡֵΪTRUE  FALSE
  *   ޡ
  */
void
RTC_Time_Stamp_INT_Enable (FunctionalState NewState)
{
    /* У */
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

    /*---------------- RTC_IERĴTSIEλ ----------------*/
    if (NewState != FALSE)
    {
        /* ʹʱж */
        SFR_SET_BIT_ASM(RTC_IER, RTC_IER_TSIE_POS);
    }
    else
    {
        /* ֹʱж */
        SFR_CLR_BIT_ASM(RTC_IER, RTC_IER_TSIE_POS);
    }
}

/**
  *   RTCʱжʹܡ
  *   NewState: RTCʱжʹ״̬ȡֵΪTRUE  FALSE
  *   ޡ
  */
void
RTC_Time_Stamp_Overflow_INT_Enable (FunctionalState NewState)
{
    /* У */
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

    /*---------------- RTC_IERĴTSOVFIEλ ----------------*/
    if (NewState != FALSE)
    {
        /* ʹʱж */
        SFR_SET_BIT_ASM(RTC_IER, RTC_IER_TSOVFIE_POS);
    }
    else
    {
        /* ֹʱж */
        SFR_CLR_BIT_ASM(RTC_IER, RTC_IER_TSOVFIE_POS);
    }
}

/**
  *   RTCʱ1жʹܡ
  *   NewState: RTCʱ1жʹ״̬ȡֵΪTRUE  FALSE
  *   ޡ
  */
void
RTC_Timer1_INT_Enable (FunctionalState NewState)
{
    /* У */
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

    /*---------------- RTC_IERĴRTCT1IEλ ----------------*/
    if (NewState != FALSE)
    {
        /* ʹܶʱ1ж */
        SFR_SET_BIT_ASM(RTC_IER, RTC_IER_RTCT1IE_POS);
    }
    else
    {
        /* ֹʱ1ж */
        SFR_CLR_BIT_ASM(RTC_IER, RTC_IER_RTCT1IE_POS);
    }
}

/**
  *   RTCʱ0жʹܡ
  *   NewState: RTCʱ0жʹ״̬ȡֵΪTRUE  FALSE
  *   ޡ
  */
void
RTC_Timer0_INT_Enable (FunctionalState NewState)
{
    /* У */
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

    /*---------------- RTC_IERĴRTCT0IEλ ----------------*/
    if (NewState != FALSE)
    {
        /* ʹܶʱ0ж */
        SFR_SET_BIT_ASM(RTC_IER, RTC_IER_RTCT0IE_POS);
    }
    else
    {
        /* ֹʱ0ж */
        SFR_CLR_BIT_ASM(RTC_IER, RTC_IER_RTCT0IE_POS);
    }
}

/**
  *   RTCʱжʹܡ
  *   NewState: RTCʱжʹ״̬ȡֵΪTRUE  FALSE
  *   ޡ
  */
void
RTC_Time_Tick_INT_Enable (FunctionalState NewState)
{
    /* У */
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

    /*---------------- RTC_IERĴTTIEλ ----------------*/
    if (NewState != FALSE)
    {
        /* ʹʱж */
        SFR_SET_BIT_ASM(RTC_IER, RTC_IER_TTIE_POS);
    }
    else
    {
        /* ֹʱж */
        SFR_CLR_BIT_ASM(RTC_IER, RTC_IER_TTIE_POS);
    }
}

/**
  *   RTCBжʹܡ
  *   NewState: RTCBжʹ״̬ȡֵΪTRUE  FALSE
  *   ޡ
  */
void
RTC_Alarm_B_INT_Enable (FunctionalState NewState)
{
    /* У */
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

    /*---------------- RTC_IERĴALRBIEλ ----------------*/
    if (NewState != FALSE)
    {
        /* ʹBж */
        SFR_SET_BIT_ASM(RTC_IER, RTC_IER_ALRBIE_POS);
    }
    else
    {
        /* ֹBж */
        SFR_CLR_BIT_ASM(RTC_IER, RTC_IER_ALRBIE_POS);
    }
}

/**
  *   RTCAжʹܡ
  *   NewState: RTCAжʹ״̬ȡֵΪTRUE  FALSE
  *   ޡ
  */
void
RTC_Alarm_A_INT_Enable (FunctionalState NewState)
{
    /* У */
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

    /*---------------- RTC_IERĴALRAIEλ ----------------*/
    if (NewState != FALSE)
    {
        /* ʹAж */
        SFR_SET_BIT_ASM(RTC_IER, RTC_IER_ALRAIE_POS);
    }
    else
    {
        /* ֹAж */
        SFR_CLR_BIT_ASM(RTC_IER, RTC_IER_ALRAIE_POS);
    }
}

/**
  *   RTCսжʹܡ
  *   NewState: RTCսжʹ״̬ȡֵΪTRUE  FALSE
  *   ޡ
  */
void
RTC_Days_INT_Enable (FunctionalState NewState)
{
    /* У */
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

    /*---------------- RTC_IERĴDAYIEλ ----------------*/
    if (NewState != FALSE)
    {
        /* ʹսж */
        SFR_SET_BIT_ASM(RTC_IER, RTC_IER_DAYIE_POS);
    }
    else
    {
        /* ֹսж */
        SFR_CLR_BIT_ASM(RTC_IER, RTC_IER_DAYIE_POS);
    }
}

/**
  *   RTCСʱжʹܡ
  *   NewState: RTCСʱжʹ״̬ȡֵΪTRUE  FALSE
  *   ޡ
  */
void
RTC_Hours_INT_Enable (FunctionalState NewState)
{
    /* У */
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

    /*---------------- RTC_IERĴHOURIEλ ----------------*/
    if (NewState != FALSE)
    {
        /* ʹСʱж */
        SFR_SET_BIT_ASM(RTC_IER, RTC_IER_HOURIE_POS);
    }
    else
    {
        /* ֹСʱж */
        SFR_CLR_BIT_ASM(RTC_IER, RTC_IER_HOURIE_POS);
    }
}

/**
  *   RTCֽжʹܡ
  *   NewState: RTCֽжʹ״̬ȡֵΪTRUE  FALSE
  *   ޡ
  */
void
RTC_Minutes_INT_Enable (FunctionalState NewState)
{
    /* У */
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

    /*---------------- RTC_IERĴMINIEλ ----------------*/
    if (NewState != FALSE)
    {
        /* ʹֽܷж */
        SFR_SET_BIT_ASM(RTC_IER, RTC_IER_MINIE_POS);
    }
    else
    {
        /* ֹֽж */
        SFR_CLR_BIT_ASM(RTC_IER, RTC_IER_MINIE_POS);
    }
}

/**
  *   RTCжʹܡ
  *   NewState: RTCжʹ״̬ȡֵΪTRUE  FALSE
  *   ޡ
  */
void
RTC_Seconds_INT_Enable (FunctionalState NewState)
{
    /* У */
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

    /*---------------- RTC_IERĴSECIEλ ----------------*/
    if (NewState != FALSE)
    {
        /* ʹж */
        SFR_SET_BIT_ASM(RTC_IER, RTC_IER_SECIE_POS);
    }
    else
    {
        /* ֹж */
        SFR_CLR_BIT_ASM(RTC_IER, RTC_IER_SECIE_POS);
    }
}

/**
  *   ȡʱжϱ־
  *   ޡ
  *   1:ʱжϣ0:δʱжϡ
  */
FlagStatus
RTC_Get_Time_Stamp_INT_Flag (void)
{
    /*---------------- ȡRTC_IFRĴTSIFλ ----------------*/
    if (RTC_IFR & RTC_IFR_TSIF)
    {
        /* ʱж */
        return SET;
    }
    else
    {
        /* δʱж */
        return RESET;
    }
}

/**
  *   ȡʱжϱ־
  *   ޡ
  *   1:ʱжϣ0:δʱжϡ
  */
FlagStatus
RTC_Get_Time_Stamp_Overflow_INT_Flag (void)
{
    /*---------------- ȡRTC_IFRĴTSOVFIFλ ----------------*/
    if (RTC_IFR & RTC_IFR_TSOVFIF)
    {
        /* ʱж */
        return SET;
    }
    else
    {
        /* δʱж */
        return RESET;
    }
}

/**
  *   ȡRTCʱ1жϱ־
  *   ޡ
  *   1:RTCʱ1жϣ0:δRTCʱ1жϡ
  */
FlagStatus
RTC_Get_Timer1_INT_Flag (void)
{
    /*---------------- ȡRTC_IFRĴRTCT1IFλ ----------------*/
    if (RTC_IFR & RTC_IFR_RTCT1IF)
    {
        /* RTCʱ1ж */
        return SET;
    }
    else
    {
        /* δRTCʱ1ж */
        return RESET;
    }
}

/**
  *   ȡRTCʱ0жϱ־
  *   ޡ
  *   1:RTCʱ0жϣ0:δRTCʱ0жϡ
  */
FlagStatus
RTC_Get_Timer0_INT_Flag (void)
{
    /*---------------- ȡRTC_IFRĴRTCT0IFλ ----------------*/
    if (RTC_IFR & RTC_IFR_RTCT0IF)
    {
        /* RTCʱ0ж */
        return SET;
    }
    else
    {
        /* δRTCʱ0ж */
        return RESET;
    }
}

/**
  *   ȡRTCʱжϱ־
  *   ޡ
  *   1:ʱжϣ0:δʱжϡ
  */
FlagStatus
RTC_Get_Time_Tick_INT_Flag (void)
{
    /*---------------- ȡRTC_IFRĴTTIFλ ----------------*/
    if (RTC_IFR & RTC_IFR_TTIF)
    {
        /* ʱж */
        return SET;
    }
    else
    {
        /* δʱж */
        return RESET;
    }
}

/**
  *   ȡRTCBжϱ־
  *   ޡ
  *   1:Bжϣ0:δBжϡ
  */
FlagStatus
RTC_Get_Alarm_B_INT_Flag (void)
{
    /*---------------- ȡRTC_IFRĴALRBIFλ ----------------*/
    if (RTC_IFR & RTC_IFR_ALRBIF)
    {
        /* Bж */
        return SET;
    }
    else
    {
        /* δBж */
        return RESET;
    }
}

/**
  *   ȡRTCAжϱ־
  *   ޡ
  *   1:Aжϣ0:δBжϡ
  */
FlagStatus
RTC_Get_Alarm_A_INT_Flag (void)
{
    /*---------------- ȡRTC_IFRĴALRAIFλ ----------------*/
    if (RTC_IFR & RTC_IFR_ALRAIF)
    {
        /* Aж */
        return SET;
    }
    else
    {
        /* δAж */
        return RESET;
    }
}

/**
  *   ȡRTCսжϱ־
  *   ޡ
  *   1:սжϣ0:δսжϡ
  */
FlagStatus
RTC_Get_Days_INT_Flag (void)
{
    /*---------------- ȡRTC_IFRĴDAYIFλ ----------------*/
    if (RTC_IFR & RTC_IFR_DAYIF)
    {
        /* սж */
        return SET;
    }
    else
    {
        /* δսж */
        return RESET;
    }
}

/**
  *   ȡRTCСʱжϱ־
  *   ޡ
  *   1:Сʱжϣ0:δСʱжϡ
  */
FlagStatus
RTC_Get_Hours_INT_Flag (void)
{
    /*---------------- ȡRTC_IFRĴHOURIFλ ----------------*/
    if (RTC_IFR & RTC_IFR_HOURIF)
    {
        /* Сʱж */
        return SET;
    }
    else
    {
        /* δСʱж */
        return RESET;
    }
}

/**
  *   ȡRTCֽжϱ־
  *   ޡ
  *   1:˷ֽжϣ0:δֽжϡ
  */
FlagStatus
RTC_Get_Minutes_INT_Flag (void)
{
    /*---------------- ȡRTC_IFRĴMINIFλ ----------------*/
    if (RTC_IFR & RTC_IFR_MINIF)
    {
        /* ˷ֽж */
        return SET;
    }
    else
    {
        /* δֽж */
        return RESET;
    }
}

/**
  *   ȡRTCжϱ־
  *   ޡ
  *   1:жϣ0:δжϡ
  */
FlagStatus
RTC_Get_Seconds_INT_Flag (void)
{
    /*---------------- ȡRTC_IFRĴSECIFλ ----------------*/
    if (RTC_IFR & RTC_IFR_SECIF)
    {
        /* ж */
        return SET;
    }
    else
    {
        /* δж */
        return RESET;
    }
}

/**
  *   RTCʱжϱ־
  *   ޡ
  *   ޡ
  */
void
RTC_Clear_Time_Stamp_INT_Flag (void)
{
    /*---------------- RTC_IFRĴTSICλ ----------------*/
    SFR_SET_BIT_ASM(RTC_IFR, RTC_IFR_TSIC_POS);
    while(RTC_IFR & RTC_IFR_TSIF);
    SFR_CLR_BIT_ASM(RTC_IFR, RTC_IFR_TSIC_POS);
}

/**
  *   RTCʱжϱ־
  *   ޡ
  *   ޡ
  */
void
RTC_Clear_Time_Stamp_Overflow_INT_Flag (void)
{
    /*---------------- RTC_IFRĴTSOVFICλ ----------------*/
    SFR_SET_BIT_ASM(RTC_IFR, RTC_IFR_TSOVFIC_POS);
    while(RTC_IFR & RTC_IFR_TSOVFIF);
    SFR_CLR_BIT_ASM(RTC_IFR, RTC_IFR_TSOVFIC_POS);
}

/**
  *   RTCʱ1жϱ־
  *   ޡ
  *   ޡ
  */
void
RTC_Clear_Timer1_INT_Flag (void)
{
    /*---------------- RTC_IFRĴRTCT1ICλ ----------------*/
    SFR_SET_BIT_ASM(RTC_IFR, RTC_IFR_RTCT1IC_POS);
    while(RTC_IFR & RTC_IFR_RTCT1IF);
    SFR_CLR_BIT_ASM(RTC_IFR, RTC_IFR_RTCT1IC_POS);
}

/**
  *   RTCʱ0жϱ־
  *   ޡ
  *   ޡ
  */
void
RTC_Clear_Timer0_INT_Flag (void)
{
    /*---------------- RTC_IFRĴRTCT0ICλ ----------------*/
    SFR_SET_BIT_ASM(RTC_IFR, RTC_IFR_RTCT0IC_POS);
    while(RTC_IFR & RTC_IFR_RTCT0IF);
    SFR_CLR_BIT_ASM(RTC_IFR, RTC_IFR_RTCT0IC_POS);
}

/**
  *   ʱжϱ־
  *   ޡ
  *   ޡ
  */
void
RTC_Clear_Time_Tick_INT_Flag (void)
{
    /*---------------- RTC_IFRĴTTICλ ----------------*/
    SFR_SET_BIT_ASM(RTC_IFR, RTC_IFR_TTIC_POS);
    while(RTC_IFR & RTC_IFR_TTIF);
    SFR_CLR_BIT_ASM(RTC_IFR, RTC_IFR_TTIC_POS);
}

/**
  *   Bжϱ־
  *   ޡ
  *   ޡ
  */
void
RTC_Clear_Alarm_B_INT_Flag (void)
{
    /*---------------- RTC_IFRĴALRBICλ ----------------*/
    SFR_SET_BIT_ASM(RTC_IFR, RTC_IFR_ALRBIC_POS);
    while(RTC_IFR & RTC_IFR_ALRBIF);
    SFR_CLR_BIT_ASM(RTC_IFR, RTC_IFR_ALRBIC_POS);
}

/**
  *   Aжϱ־
  *   ޡ
  *   ޡ
  */
void
RTC_Clear_Alarm_A_INT_Flag (void)
{
    /*---------------- RTC_IFRĴALRAICλ ----------------*/
    SFR_SET_BIT_ASM(RTC_IFR, RTC_IFR_ALRAIC_POS);
    while(RTC_IFR & RTC_IFR_ALRAIF);
    SFR_CLR_BIT_ASM(RTC_IFR, RTC_IFR_ALRAIC_POS);
}

/**
  *   RTCսжϱ־
  *   ޡ
  *   ޡ
  */
void
RTC_Clear_Days_INT_Flag (void)
{
    /*---------------- RTC_IFRĴDAYICλ ----------------*/
    SFR_SET_BIT_ASM(RTC_IFR, RTC_IFR_DAYIC_POS);
    while(RTC_IFR & RTC_IFR_DAYIF);
    SFR_CLR_BIT_ASM(RTC_IFR, RTC_IFR_DAYIC_POS);
}

/**
  *   RTCСʱжϱ־
  *   ޡ
  *   ޡ
  */
void
RTC_Clear_Hours_INT_Flag (void)
{
    /*---------------- RTC_IFRĴHOURICλ ----------------*/
    SFR_SET_BIT_ASM(RTC_IFR, RTC_IFR_HOURIC_POS);
    while(RTC_IFR & RTC_IFR_HOURIF);
    SFR_CLR_BIT_ASM(RTC_IFR, RTC_IFR_HOURIC_POS);
}

/**
  *   RTCֽжϱ־
  *   ޡ
  *   ޡ
  */
void
RTC_Clear_Minutes_INT_Flag (void)
{
    /*---------------- RTC_IFRĴMINICλ ----------------*/
    SFR_SET_BIT_ASM(RTC_IFR, RTC_IFR_MINIC_POS);
    while(RTC_IFR & RTC_IFR_MINIF);
    SFR_CLR_BIT_ASM(RTC_IFR, RTC_IFR_MINIC_POS);
}

/**
  *   RTCжϱ־
  *   ޡ
  *   ޡ
  */
void
RTC_Clear_Seconds_INT_Flag (void)
{
    /*---------------- RTC_IFRĴSECICλ ----------------*/
    SFR_SET_BIT_ASM(RTC_IFR, RTC_IFR_SECIC_POS);
    while(RTC_IFR & RTC_IFR_SECIF);
    SFR_CLR_BIT_ASM(RTC_IFR, RTC_IFR_SECIC_POS);
}
/**
  *   ##### ʵʱʱ(RTC)жϹ #####
  */


/**
  *   ##### ʵʱʱ(RTC)˽к #####
  */
/**
  *   ʮֵתΪBCD롣
  *   Value: תʮλ8λЧֵ
  *   2ֽBCD롣
  */
static uint8_t
RTC_Byte_To_Bcd (uint8_t Value)
{
    uint8_t bcdhigh = 0;
    uint8_t bcdlow = 0;

    bcdhigh = Value / ((uint8_t)10);
    bcdlow = Value - bcdhigh * ((uint8_t)10);

    return (uint8_t)((bcdhigh << (uint8_t)4) | bcdlow);
}

/**
  *   BCDתΪʮλ
  *   Value: תBCD룬8λЧֵ
  *   ʮλ
  */
static uint8_t
RTC_Bcd_To_Byte (uint8_t Value)
{
    uint8_t tmp = 0;

    tmp = (Value >> (uint8_t)4) * ((uint8_t)10);

    return (tmp + (Value & (uint8_t)0xF));
}
/**
  *   ##### ʵʱʱ(RTC)˽к #####
  */

