/***
  ******************************************************************************
  * ļ  kf32f_basic_int.c
  *     ChipON_AE/FAE_Group
  *     V3.0.1
  *     2021-11-25
  *     ļṩжصĹܺ
  *          + ж(INT)ú
  *          + ⲿж(INT)ܳʼ
  *          + ⲿж(INT)ú
  *
  *********************************************************************
  */

#include "kf32f_basic_int.h"

/* ж϶ʱ˽ж ----------------------------------------------------*/
/* INT_IPĴ */
#define INT_IP_INIT_MASK                ((uint32_t)0xF)

/* INT_EINTSSxĴ */
#define INT_EINTSS_INIT_MASK            ((uint32_t)0x7)


/**
  *   ##### ж(INT)ú #####
  */
/**
  *   ȡǰڴжš
  *   ޡ
  *   ǰжţ7λЧݡ
  */
uint8_t
INT_Get_Interrupt_Action (void)
{
    uint32_t tmpreg = 0;

    /* ȡINT_CTL0ĴINTACTλ */
    tmpreg = INT_CTL0;
    tmpreg &= INT_CTL0_INTACT;
    tmpreg >>= INT_CTL0_INTACT0_POS;

    return (uint8_t)tmpreg;
}

/**
  *   ȡǰӦȼжš
  *   ޡ
  *   Ӧȼжţ7λЧݡ
  */
uint8_t
INT_Get_Priority_Pending_Action (void)
{
    uint32_t tmpreg = 0;

    /* ȡINT_CTL0ĴINTPENDλ */
    tmpreg = INT_CTL0;
    tmpreg &= INT_CTL0_INTPEND;
    tmpreg >>= INT_CTL0_INTPEND0_POS;

    return (uint8_t)tmpreg;
}

/**
  *   ȼӦ
  *   PriBase: ȼӦȡֵ4λݡ
  *   ޡ
  */
void
INT_Priority_Base (uint8_t PriBase)
{
    uint32_t tmpreg = 0;

    CHECK_RESTRICTION(CHECK_INT_PRIORITY_BASE(PriBase));

    /*------------------ INT_CTL0Ĵ -----------------*/
    /* ݲPriBasePRIBASEλ */
    tmpreg = (uint32_t)PriBase << INT_CTL0_PRIBASE0_POS;
    INT_CTL0 = SFR_Config (INT_CTL0,
                          ~INT_CTL0_PRIBASE,
                          tmpreg);
}

/**
  *   ȡȼӦ
  *   ޡ
  *   ȼӦ4λЧݡ
  */
uint8_t
INT_Get_Priority_Base (void)
{
    uint32_t tmpreg = 0;

    /* ȡINT_CTL0ĴPRIBASEλ */
    tmpreg = INT_CTL0;
    tmpreg &= INT_CTL0_PRIBASE;
    tmpreg >>= INT_CTL0_PRIBASE0_POS;

    return (uint8_t)tmpreg;
}

/**
  *   жԶջѡ
  *   StackAlign: жԶջѡ
  *                   ȡֵΪ
  *                     INT_STACK_DOUBLE_ALIGN: жԶջʹ˫ֶ
  *                     INT_STACK_SINGLE_ALIGN: жԶջʹõֶ
  *   ޡ
  */
void
INT_Stack_Align_Config (uint32_t StackAlign)
{
    CHECK_RESTRICTION(CHECK_INT_STACK_ALIGN(StackAlign));

    /*---------------- INT_CTL0ĴDSALIGNλ ----------------*/
    if (StackAlign != INT_STACK_DOUBLE_ALIGN)
    {
        /* жԶջʹõֶ */
        SFR_SET_BIT_ASM(INT_CTL0, INT_CTL0_DSALIGN_POS);
    }
    else
    {
        /* жԶջʹ˫ֶ */
        SFR_CLR_BIT_ASM(INT_CTL0, INT_CTL0_DSALIGN_POS);
    }
}

/**
  *   Ӳжλ
  *   NewState: жԶջѡ
  *                 ȡֵΧΪTRUE  FALSE
  *   ޡ
  */
void
INT_Fault_Masking_Config (FunctionalState NewState)
{
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

    /*---------------- INT_CTL0ĴFAULTMASKλ ----------------*/
    if (NewState != FALSE)
    {
        /* FAULT쳣ȼжϱ */
        SFR_SET_BIT_ASM(INT_CTL0, INT_CTL0_FAULTMASK_POS);
    }
    else
    {
        /* FAULT쳣δ */
        SFR_CLR_BIT_ASM(INT_CTL0, INT_CTL0_FAULTMASK_POS);
    }
}

/**
  *   жǷһжϽһʱ״̬
  *   ޡ
  *   1:״̬0:״̬
  */
FlagStatus
INT_Get_Pre_Empty (void)
{
    uint32_t tmpreg = 0;

    /*---------------- INT_CTL0ĴINTPREEMPTλ ----------------*/
    tmpreg = INT_CTL0;
    if (tmpreg & INT_CTL0_INTPREEMPT)
    {
        /* жϽһʱ״̬ */
        return SET;
    }
    else
    {
        /* жϲ״̬ */
        return RESET;
    }
}

/**
  *   жϵǰǷгNMI֮жϹ
  *   ޡ
  *   1:гNMI֮жϹ0:ûгNMI֮жϹ
  */
FlagStatus
INT_Get_Pending_Flag (void)
{
    uint32_t tmpreg = 0;

    /*---------------- INT_CTL0ĴINTPENDINGλ ----------------*/
    tmpreg = INT_CTL0;
    if (tmpreg & INT_CTL0_INTPENDING)
    {
        /* гNMI֮жϹ */
        return SET;
    }
    else
    {
        /* ûгNMI֮жϹ */
        return RESET;
    }
}

/**
  *   ȼ顣
  *   PriorityGroup: жԶջѡ
  *                      ȡֵΧΪ
  *                        INT_PRIORITY_GROUP_3VS1: ռȼΪ3λȼΪ1λ
  *                        INT_PRIORITY_GROUP_2VS2: ռȼΪ2λȼΪ2λ
  *                        INT_PRIORITY_GROUP_1VS3: ռȼΪ1λȼΪ3λ
  *                        INT_PRIORITY_GROUP_0VS4: ռȼΪ0λȼΪ4λ
  *   ޡ
  */
void
INT_Priority_Group_Config (uint32_t PriorityGroup)
{
    CHECK_RESTRICTION(CHECK_INT_PRIORITY_GROUP(PriorityGroup));

    /*------------------ INT_CTL0Ĵ -----------------*/
    /* ݲPriorityGroupPRIGROUPλ */
    INT_CTL0 = SFR_Config (INT_CTL0,
                          ~INT_CTL0_PRIGROUP,
                          PriorityGroup);
}

/**
  *   ȡȼ顣
  *   ޡ
  *   ȼλã32λЧݡ
  */
uint32_t
INT_Get_Priority_Group (void)
{
    uint32_t tmpreg = 0;

    /*------------------ ȡINT_CTL0Ĵ -----------------*/
    tmpreg = INT_CTL0;
    tmpreg &= INT_CTL0_PRIGROUP;

    return tmpreg;
}

/**
  *   ȫֿжʹλжʹܿƲλ/NMI/Ӳжϡ
  *   NewState: ȫֿжʹܣ
  *                 ȡֵΧΪTRUE  FALSE
  *   ޡ
  */
void
INT_All_Enable (FunctionalState NewState)
{
    /* У */
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

    /*---------------- INT_CTL0ĴAIEλ ----------------*/
    if (NewState != FALSE)
    {
        /* ȫֿжʹ */
        SFR_SET_BIT_ASM(INT_CTL0, INT_CTL0_AIE_POS);
    }
    else
    {
        /* ȫֿжϽֹ */
        SFR_CLR_BIT_ASM(INT_CTL0, INT_CTL0_AIE_POS);
    }
}

/**
  *   ںжʹܿƣûδıж
  *       ܳδ֪
  *   Peripheral: ںжţȡֵΧΪ
  *                   öInterruptIndexежš
  *       NewState: ںжʹ״̬
  *                 ȡֵΧΪTRUE  FALSE
  *   ޡ
  */
void
INT_Interrupt_Enable (InterruptIndex Peripheral, FunctionalState NewState)
{
    uint32_t tmpreg = 0;
    uint32_t tmpreg1 = 0;

    /* У */
    CHECK_RESTRICTION(CHECK_PERIPHERAL_INTERRUPT_INDEX(Peripheral));
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

    if (Peripheral <= INT_SysTick)
    {
        /*---------------- INT_EIE0Ĵ ----------------*/
        tmpreg = Peripheral - INT_StackFault;
        tmpreg1 = INT_EIE0_STACKIE << tmpreg;
        INT_EIE0 = SFR_Config (INT_EIE0,
                          ~tmpreg1,
                          NewState << (tmpreg+5));
    }
    else if (Peripheral <= INT_SPI1)
    {
        /*---------------- INT_EIE1Ĵ ----------------*/
        tmpreg = Peripheral - INT_WWDT;
        tmpreg1 = INT_EIE1_WWDTIE << tmpreg;
        INT_EIE1 = SFR_Config (INT_EIE1,
                          ~tmpreg1,
                          NewState << tmpreg);
    }
    else if (Peripheral <= INT_USART7)
    {
        /*---------------- INT_EIE2Ĵ ----------------*/
        tmpreg = Peripheral - INT_DMA1;
        tmpreg1 = INT_EIE2_DMA1IE << tmpreg;
        INT_EIE2 = SFR_Config (INT_EIE2,
                          ~tmpreg1,
                          NewState << tmpreg);
    }
    else
    {
        /*---------------- INT_EIE4Ĵ ----------------*/
        /*---------------- Ϊж ----------------*/
    }
}

/**
  *   SYSTICKжϱ־λ
  *   ޡ
  *   ޡ
  */
void
INT_Set_Systick_Flag (void)
{
    SFR_SET_BIT_ASM(INT_EIF0, INT_EIF0_SYSTICKIF_POS);
}

/**
  *   PendSVжϱ־λ
  *   ޡ
  *   ޡ
  */
void
INT_Set_PendSV_Flag (void)
{
    SFR_SET_BIT_ASM(INT_EIF0, INT_EIF0_PENDSVIF_POS);
}

/**
  *   ȡںжϱ־ûδıж
  *       ܳδ֪
  *   Peripheral: ںжţȡֵΧΪ
  *                   öInterruptIndexежš
  *   ޡ
  */
FlagStatus
INT_Get_Interrupt_Flag (InterruptIndex Peripheral)
{
    uint32_t tmpreg = 0;
    uint32_t tmpreg1 = 0;

    /* У */
    CHECK_RESTRICTION(CHECK_PERIPHERAL_INTERRUPT_INDEX(Peripheral));

    if (Peripheral <= INT_SysTick)
    {
        /*---------------- INT_EIF0Ĵ ----------------*/
        tmpreg = INT_EIF0_NMIIF << (Peripheral - INT_NMI);
        tmpreg1 = INT_EIF0;
        if (INT_EIF0 & tmpreg)
        {
            /* жϹ */
            return SET;
        }
        else
        {
            /* жϹ */
            return RESET;
        }
    }
    else if (Peripheral <= INT_SPI1)
    {
        /*---------------- INT_EIF1Ĵ ----------------*/
        tmpreg = INT_EIF1_WWDTIF << (Peripheral - INT_WWDT);
        tmpreg1 = INT_EIF1;
        if (INT_EIF1 & tmpreg)
        {
            /* жϹ */
            return SET;
        }
        else
        {
            /* жϹ */
            return RESET;
        }
    }
    else if (Peripheral <= INT_USART7)
    {
        /*---------------- INT_EIF2Ĵ ----------------*/
        tmpreg = INT_EIF2_DMA1IF << (Peripheral - INT_DMA1);
        tmpreg1 = INT_EIF2;

    }
    else
    {
        /*---------------- INT_EIF4Ĵ ----------------*/
        /*---------------- Ϊж ----------------*/
    }

    /*---------------- Ӧжϱ־λ״̬ ----------------*/
    if ((*(volatile uint32_t*)tmpreg1) & tmpreg)
    {
        /* жϹ */
        return SET;
    }
    else
    {
        /* жϹ */
        return RESET;
    }
}
/**
  *  ںжϱ־
  *   Peripheral: ںжţȡֵΧΪ
  *                   öInterruptIndexежš
  *   ޡ
  */
void
INT_Clear_Interrupt_Flag (InterruptIndex Peripheral)
{
    uint32_t tmpreg = 0;
    volatile uint32_t *tmpreg1 = 0;

    /* У */
    CHECK_RESTRICTION(CHECK_PERIPHERAL_INTERRUPT_INDEX(Peripheral));

    if (Peripheral <= INT_SysTick)
    {
        /*---------------- INT_EIF0Ĵ ----------------*/
        tmpreg = INT_EIF0_NMIIF << (Peripheral - INT_NMI);
        tmpreg1 = &INT_EIF0;
    }
    else if (Peripheral <= INT_SPI1)
    {
        /*---------------- INT_EIF1Ĵ ----------------*/
        tmpreg = INT_EIF1_WWDTIF << (Peripheral - INT_WWDT);
        tmpreg1 = &INT_EIF1;
    }
    else if (Peripheral <= INT_USART7)
    {
        /*---------------- INT_EIF2Ĵ ----------------*/
        tmpreg = INT_EIF2_DMA1IF << (Peripheral - INT_DMA1);
        tmpreg1 = &INT_EIF2;
    }
    else
    {
        /*---------------- INT_EIF4Ĵ ----------------*/
        /*---------------- Ϊж ----------------*/
    }

    /*---------------- Ӧжϱ־λ״̬ ----------------*/
    //(*(volatile uint32_t*)tmpreg1) &= ~tmpreg;
    *tmpreg1 &= ~tmpreg;

}
/**
  *   ںжȼãûδıж
  *       ܳδ֪
  *   Peripheral: ںжţȡֵΧΪ
  *                   öInterruptIndexежš
  *       Preemption: ռȼͬʱPRIGROUPá
  *       SubPriority: ȼ ͬʱPRIGROUPá
  *       (GROUP) == INT_PRIORITY_GROUP_3VS1ʱPreemptionȡֵΧΪ0~7SubPriorityȡֵΧΪ0~1
  *       (GROUP) == INT_PRIORITY_GROUP_2VS2ʱPreemptionȡֵΧΪ0~3SubPriorityȡֵΧΪ0~3
  *       (GROUP) == INT_PRIORITY_GROUP_1VS3ʱPreemptionȡֵΧΪ0~1SubPriorityȡֵΧΪ0~7
  *       (GROUP) == INT_PRIORITY_GROUP_0VS4ʱPreemptionȡֵΧΪ0~0SubPriorityȡֵΧΪ0~15
  *
  *   ޡ
  */
void
INT_Interrupt_Priority_Config (InterruptIndex Peripheral,
                    uint32_t Preemption, uint32_t SubPriority)
{
    uint32_t tmpreg = 0;
    uint32_t regoffset = 0;
    uint32_t bitoffset = 0;
    uint32_t priorityconfig = 0;

    /*--------- ȡINT_CTL0ĴPRIGROUPλ ---------*/
    tmpreg = INT_CTL0;
    tmpreg &= INT_CTL0_PRIGROUP;

    /* У */
    CHECK_RESTRICTION(CHECK_PERIPHERAL_INTERRUPT_INDEX(Peripheral));
    CHECK_RESTRICTION(CHECK_PRIORITY_CONFIG(tmpreg, Preemption, SubPriority));

    /*--------- ȡжȼλֵ ---------*/
    switch (tmpreg)
    {
    case INT_PRIORITY_GROUP_3VS1:
        priorityconfig = (Preemption << 1) | (SubPriority & 0x1);
        break;
    case INT_PRIORITY_GROUP_2VS2:
        priorityconfig = (Preemption << 2) | (SubPriority & 0x3);
        break;
    case INT_PRIORITY_GROUP_1VS3:
        priorityconfig = (Preemption << 3) | (SubPriority & 0x7);
        break;
    case INT_PRIORITY_GROUP_0VS4:
        priorityconfig = SubPriority & 0xF;
        break;
    default:
        CHECK_RESTRICTION(0);
        break;
    }

    /*--------- жȼλ ---------*/
    if (Peripheral <= INT_USART7)
    {
        /*---------------- INT_IPx(x=0~18)Ĵ ----------------*/
        /* ȡжȼĴַ */
        regoffset = (Peripheral - INT_Reserved4) >> 2;
        tmpreg = (uint32_t)&INT_IP0;
        tmpreg = tmpreg + (regoffset << 2);
    }
    else
    {
    }

    /*---------------- INT_IPx(x=0~30)Ĵ ----------------*/
    bitoffset = ((Peripheral & 0x3) * 8) + 4;
    *(volatile uint32_t*)tmpreg
          = SFR_Config (*(volatile uint32_t*)tmpreg,
                      ~(INT_IP_INIT_MASK << bitoffset),
                      priorityconfig << bitoffset);
}

/**
  *   ںжȼãûδıж
  *      ܳδ֪
  *    Peripheral: ںжţȡֵΧΪ
  *                  öInterruptIndexежš
  *      Priority: ȼͬʱPRIGROUPá
  *      PriorityȡֵΧΪ0~15
  *
  *    ޡ
  */
void
INT_Set_Interrupt_Priority(InterruptIndex Peripheral, uint32_t Priority)
{
    uint32_t tmpreg = 0;
    uint32_t regoffset = 0;
    uint32_t bitoffset = 0;

    regoffset = (Peripheral - INT_Reserved4) >> 2;
    tmpreg = (uint32_t)&INT_IP0;
    tmpreg = tmpreg + (regoffset << 2);
    bitoffset = ((Peripheral & 0x3) << 0X03) + 4;
    *(volatile uint32_t*)tmpreg
               = SFR_Config (*(volatile uint32_t*)tmpreg,
               ~((uint32_t)0x0f << bitoffset),
               Priority << bitoffset);
}


/**
  *   жʱá
  *   IntDelay: жʱƣȡֵ8λݡ
  *   ޡ
  */
void
INT_Stack_Delay_Enable (uint8_t IntDelay)
{
    /*---------------- INT_CTL1ĴINTDELYλ ----------------*/
    INT_CTL1 = SFR_Config (INT_CTL1,
                      ~(INT_CTL1_INTDELY),
                      (uint32_t)IntDelay << INT_CTL1_INTDELY0_POS);
}
/**
  *   ##### ж(INT)ú #####
  */


/**
  *   ##### ⲿж(INT)ܳʼ #####
  */
/**
  *   ⲿж(EINT)ãʹжϡ
  *   eintInitStruct: ⲿжϢṹָ롣
  *   ޡ
  */
void
INT_External_Configuration (EINT_InitTypeDef* eintInitStruct)
{
    uint32_t eintoffset = 0;
    uint32_t tmpreg = 0;

    /* У */
    CHECK_RESTRICTION(CHECK_INT_EXTERNAL_NUM(eintInitStruct->m_Line));
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(eintInitStruct->m_Mask));
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(eintInitStruct->m_Rise));
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(eintInitStruct->m_Fall));
    CHECK_RESTRICTION(CHECK_INT_EXTERNAL_SOURCE(eintInitStruct->m_Source));

    eintoffset = eintInitStruct->m_Line;
    /* ʹж */
    /*------------------ INT_EINTRISEĴ -----------------*/
    /* ݽṹԱm_Linem_RiseEINTRIλ */
    INT_EINTRISE = SFR_Config (INT_EINTRISE,
                          ~(INT_EINTRISE_EINTRI0 << eintoffset),
                          eintInitStruct->m_Rise << eintoffset);

    /* ʹ½ж */
    /*------------------ INT_EINTFALLĴ -----------------*/
    /* ݽṹԱm_Linem_FallEINTFAλ */
    INT_EINTFALL = SFR_Config (INT_EINTFALL,
                          ~(INT_EINTFALL_EINTFA0 << eintoffset),
                          eintInitStruct->m_Fall << eintoffset);

    /* ѡжԴ */
    /*------------------ INT_EINTSSxĴ -----------------*/
    /* ݽṹԱm_Linem_SourceEINTRIλ */
    if (eintoffset < 8)
    {
        tmpreg = eintInitStruct->m_Line * 4;
        INT_EINTSS0 = SFR_Config (INT_EINTSS0,
                          ~(INT_EINTSS_INIT_MASK << tmpreg),
                          eintInitStruct->m_Source << tmpreg);
    }
    else if (eintoffset < 16)
    {
        tmpreg = (eintInitStruct->m_Line - 8) * 4;
        INT_EINTSS1 = SFR_Config (INT_EINTSS1,
                          ~(INT_EINTSS_INIT_MASK << tmpreg),
                          eintInitStruct->m_Source << tmpreg);
    }
    else
    {
    }

    /* ʹⲿж */
    /*------------------ INT_EINTMASKĴ -----------------*/
    /* ݽṹԱm_Linem_MaskEINTMλ */
    INT_EINTMASK = SFR_Config (INT_EINTMASK,
                          ~(INT_EINTMASK_EINTM0 << eintoffset),
                          eintInitStruct->m_Mask << eintoffset);
}

/**
  *   ʼⲿж(EINT)Ϣṹ塣
  *   eintInitStruct: ָʼĽṹָ롣
  *   ޡ
  */
void
INT_External_Struct_Init (EINT_InitTypeDef* eintInitStruct)
{
    /* ⲿжϱ */
    eintInitStruct->m_Line = INT_EXTERNAL_INTERRUPT_0;
    /* ⲿжʹܿ */
    eintInitStruct->m_Mask = FALSE;
    /* ⲿжжʹ */
    eintInitStruct->m_Rise = FALSE;
    /* ⲿж½жʹ */
    eintInitStruct->m_Fall = FALSE;
    /* ⲿжϵжԴѡ */
    eintInitStruct->m_Source = INT_EXTERNAL_SOURCE_PA;
}
/**
  *   ##### ⲿж(INT)ܳʼ #####
  */


/**
  *   ##### ⲿж(INT)ú #####
  */
/**
  *   ⲿж(EINT)ʹá
  *   EintMask: ⲿжϱ룬
  *                 ȡֵΪINT_EINTMASK_EINTM0INT_EINTMASK_EINTM31λϡ
  *       NewState: ⲿжʹ
  *                 ȡֵΧΪTRUE  FALSE
  *   ޡ
  */
void
INT_External_Mask_Enable (uint32_t EintMask, FunctionalState NewState)
{
    /* У */
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

    /*---------------- INT_EINTMASKĴEINTMxλ ----------------*/
    if (NewState != FALSE)
    {
        INT_EINTMASK |= EintMask;
    }
    else
    {
        INT_EINTMASK &= ~EintMask;
    }
}

/**
  *   ⲿж(EINT)жʹá
  *   EintMask: ⲿжϱ룬
  *                 ȡֵΪINT_EINTMASK_EINTM0INT_EINTMASK_EINTM31λϡ
  *       NewState: ⲿжжʹܣ
  *                 ȡֵΧΪTRUE  FALSE
  *   ޡ
  */
void
INT_External_Rise_Enable (uint32_t EintMask, FunctionalState NewState)
{
    /* У */
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

    /*---------------- INT_EINTRISEĴEINTRIxλ ----------------*/
    if (NewState != FALSE)
    {
        INT_EINTRISE |= EintMask;
    }
    else
    {
        INT_EINTRISE &= ~EintMask;
    }
}

/**
  *   ⲿж(EINT)½жʹá
  *   EintMask: ⲿжϱ룬
  *                 ȡֵΪINT_EINTMASK_EINTM0INT_EINTMASK_EINTM31λϡ
  *       NewState: ⲿж½жʹܣ
  *                 ȡֵΧΪTRUE  FALSE
  *   ޡ
  */
void
INT_External_Fall_Enable (uint32_t EintMask, FunctionalState NewState)
{
    /* У */
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

    /*---------------- INT_EINTFALLĴEINTFAxλ ----------------*/
    if (NewState != FALSE)
    {
        INT_EINTFALL |= EintMask;
    }
    else
    {
        INT_EINTFALL &= ~EintMask;
    }
}

/**
  *   ȡⲿж(EINT)жϱ־λ
  *   EintNum: ⲿжϱţ
  *                ȡֵΪINT_EXTERNAL_INTERRUPT_0
  *                INT_EXTERNAL_INTERRUPT_31еһ
  *                0~31
  *   ⲿж(EINT)жϱ־0ûзⲿжϣ1ⲿжϡ
  */
FlagStatus
INT_Get_External_Flag (uint32_t EintNum)
{
    uint32_t tmpreg = 0;

    /* У */
    CHECK_RESTRICTION(CHECK_INT_EXTERNAL_NUM(EintNum));

    /*---------------- ȡINT_EINTFĴEINTIFxλ ----------------*/
    tmpreg = INT_EINTF_EINTIF0 << EintNum;
    if (INT_EINTF & tmpreg)
    {
        /* ⲿж */
        return SET;
    }
    else
    {
        /* ûзⲿж */
        return RESET;
    }
}

/**
  *   ⲿж(EINT)жϱ־λ
  *   EintNum: ⲿжϱţ
  *                ȡֵΪINT_EXTERNAL_INTERRUPT_0
  *                INT_EXTERNAL_INTERRUPT_31еһ
  *                0~31
  *   ޡ
  */
void
INT_External_Clear_Flag (uint32_t EintNum)
{
    uint32_t tmpreg = 0;

    /* У */
    CHECK_RESTRICTION(CHECK_INT_EXTERNAL_NUM(EintNum));

    /*---------------- INT_EINTFĴEINTIFxλ ----------------*/
    tmpreg = INT_EINTF_EINTIF0 << EintNum;
    while((INT_EINTF & tmpreg)>>(EintNum+INT_EINTF_EINTIF0_POS))
    {
    	INT_EINTF &= ~tmpreg;
    }
}

/**
  *   ⲿж(EINT)жԴá
  *   EintNum: ⲿжϱţ
  *                ȡֵΪINT_EXTERNAL_INTERRUPT_0
  *                INT_EXTERNAL_INTERRUPT_31еһ
  *                0~15
  *       PeripheralSource: жߵжԴ
  *                         ȡֵΧΪ
  *                           INT_EXTERNAL_SOURCE_PA
  *                           INT_EXTERNAL_SOURCE_PB
  *                           INT_EXTERNAL_SOURCE_PC
  *                           INT_EXTERNAL_SOURCE_PD
  *                           INT_EXTERNAL_SOURCE_PE
  *                           INT_EXTERNAL_SOURCE_PF
  *                           INT_EXTERNAL_SOURCE_PG
  *                           INT_EXTERNAL_SOURCE_PH
  *                           INT_EXTERNAL_SOURCE_PVD
  *                           INT_EXTERNAL_SOURCE_RTC
  *                           INT_EXTERNAL_SOURCE_TAMPER
  *                           INT_EXTERNAL_SOURCE_ALARMCLK
  *                           INT_EXTERNAL_SOURCE_AES
  *                           INT_EXTERNAL_SOURCE_EINT21TO31
  *   ޡ
  */
void
INT_External_Source_Enable (uint32_t EintNum, uint32_t PeripheralSource)
{
    uint32_t tmpreg = 0;

    /* У */
    CHECK_RESTRICTION(CHECK_INT_EXTERNAL_PERIPHERAL(EintNum));
    CHECK_RESTRICTION(CHECK_INT_EXTERNAL_SOURCE(PeripheralSource));

    /*---------------- INT_EINTSS0ĴEINTSOUxλ ----------------*/
    tmpreg = (EintNum % 8) * 4;
    if (EintNum < 8)
    {
        INT_EINTSS0 = SFR_Config (INT_EINTSS0,
                          ~(INT_EINTSS_INIT_MASK << tmpreg),
                          PeripheralSource << tmpreg);
    }
    else if (EintNum < 16)
    {
        INT_EINTSS1 = SFR_Config (INT_EINTSS1,
                          ~(INT_EINTSS_INIT_MASK << tmpreg),
                          PeripheralSource << tmpreg);
    }
    else
    {
    }
}
/**
  *   ##### ⲿж(INT)ú #####
  */
