/**
  ******************************************************************************
  * ļ  kf32f_basic_crc.c
  *     ChipON_AE/FAE_Group
  *     V3.0.1
  *     2021-11-25
  *     ļṩ˶ʽУģ(CRC)صĹܺ
  *            + ʽУģ(CRC)ʼ
  *			   + ʽУģ(CRC)
  *			   + ʽУģ(CRC)ȡ
  *
  *********************************************************************
  */

#include "kf32f_basic_crc.h"
#include "kf32f_basic_rst.h"
#include "kf32f_basic_pclk.h"

#ifdef  KF32F_Periph_crc
/* CRC˽ж ----------------------------------------------------*/
/* CRC_CTLĴ */
#define CRC_CTL_INIT_MASK               (CRC_CTL_RSLTREV \
                                       | CRC_CTL_DATAREV \
                                       | CRC_CTL_DATASIZE \
                                       | CRC_CTL_RSET)

/**
  *   ##### ʼú #####
  */
/**
  *  CRC踴λʹʱӡ
  *   : 
  *   ޡ
  */
void
CRC_Reset ()
{
	RST_CTL3_Peripheral_Reset_Enable(RST_CTL3_CRCRST, TRUE);
	RST_CTL3_Peripheral_Reset_Enable(RST_CTL3_CRCRST, FALSE);
	PCLK_CTL3_Peripheral_Clock_Enable(PCLK_CTL3_CRCCLKEN, TRUE);
}

/**
  *   CRCá
  *   CRCx: CRCInitStruct: CRCϢ
  *   ޡ
  */
void
CRC_Configuration (CRC_InitTypeDef* CRCInitStruct)
{
    uint32_t tmpreg = 0;

	CHECK_RESTRICTION(CHECK_CRC_CAL_RSET(CRCInitStruct->m_CalUnitReset));
	CHECK_RESTRICTION(CHECK_CRC_INPUT_SEZE(CRCInitStruct->m_InputSize));
	CHECK_RESTRICTION(CHECK_CRC_INPUT_REVERSE(CRCInitStruct->m_InputReverse));
	CHECK_RESTRICTION(CHECK_CRC_RSLTREV_SEL(CRCInitStruct->m_ResultReverse));

	/*---------------------------- CRC_CTLĴ  -----------------*/
	/* ݽṹԱm_CalUnitResetRSETλ */
	/* ݽṹԱm_InputSizeDATASIZEλ */
	/* ݽṹԱm_InputReverseDATAREVλ */
	/* ݽṹԱm_ResultReverseRSLTREVλ */

   tmpreg = ((CRCInitStruct->m_CalUnitReset ) | \
			  (CRCInitStruct->m_InputSize) | \
			  (CRCInitStruct->m_InputReverse) | \
			  (CRCInitStruct->m_ResultReverse));
   CRC_SFR->CTL = SFR_Config (CRC_SFR->CTL,
			   ~CRC_CTL_INIT_MASK,
			   tmpreg);
}

/**
  *   ʼCRCϢṹ塣
  *   CRCInitStruct: ָʼĽṹָ롣
  *   ޡ
  */
void
CRC_Struct_Init (CRC_InitTypeDef* CRCInitStruct)
{
    /* ʼCRC㵥Ԫλλ */
    CRCInitStruct->m_CalUnitReset = CRC_CAL_RSET_DISABLE;
    /* ʼ CRCݸʽλ */
    CRCInitStruct->m_InputSize = CRC_INPUT_SEZE_8;
    /* ʼ CRCλλ */
    CRCInitStruct->m_InputReverse = CRC_INPUT_REVERSE_DISABLE;
    /* ʼ CRCλ */
    CRCInitStruct->m_ResultReverse = CRC_RESULT_REVERSE_DISABLE;
}

/**
  *   CRCݼĴ
  *   DATA: ֵ
  *   ޡ
  */
void
CRC_INPUT_DATA (uint32_t DATA)
{
    /* CRCݼĴ */
	CRC_SFR->DATA = DATA;
}
/**
  *   ȡCRC
  *   : 
  *   uint32_tλֵ
  */
uint32_t
CRC_GET_RESULT ()
{
    /* ȡCRCĴ */
	uint32_t DATA;
	DATA=CRC_SFR->RSLT;
	return DATA;
}
/**
  *   CRCĳʼֵ
  *   : 
  *   uint32_tλֵ
  */
void
CRC_SET_INITVALUE (uint32_t DATA)
{
    /* CRCĳʼֵĴ */
	CRC_SFR->INIT = DATA;
}
/**
  *   CRCʽ
  *   : 
  *   uint32_tλֵ
  */
void
CRC_SET_PLN (uint32_t DATA)
{
    /* CRCʽĴ */
	CRC_SFR->PLN = DATA;
}
/**
  *   CRCֵ
  *   : 
  *   uint32_tλֵ
  */
void
CRC_SET_RXOR (uint32_t DATA)
{
    /* ýֵĴ */
	CRC_SFR->RXOR = DATA;
}
/**
  *   CRC
  *   : 
  *   uint32_tλֵ
  */
void
CRC_SET_IDATA (uint32_t DATA)
{
    /* öݼĴ */
	CRC_SFR->IDATA = DATA;
}
/**
  *   CRC
  *   : 
  *   uint32_tλֵ
  */
uint32_t
CRC_GET_TEMP ()
{
    /* ûĴ */
	uint32_t DATA;
	DATA=CRC_SFR->TEMP;
	return DATA;
}
/**
  *   CRC 㵥Ԫλ
  *   : 
  * 
  */
void
CRC_SET_RSET ()
{
    /* ûĴ */
	CRC_SFR->CTL|=CRC_CTL_RSET;
}
#endif  //KF32F_Periph_crc
