/**
  ******************************************************************************
  * ļ  kf32f_basic_bkp.c
  *     ChipON_AE/FAE_Group
  *     V3.0.1
  *     2021-11-25
  *     ļṩ˱(BKP)蹦ܺ
  *          + (BKP)λд
  *          + (BKP)ú
  *          + (BKP)жϹ
  *
  *********************************************************************
  */

#include "kf32f_basic_bkp.h"


/**
  *   ##### (BKP)λд #####
  */
/**
  *   λ(BKP)裬úλĴ飬λRTCģ顣
  *   ޡ
  *   ޡ
  */
void
BKP_Reset (void)
{
    /* Ĵλ */
    SFR_SET_BIT_ASM(BKP_CTL, BKP_CTL_BKDRST_POS);
    SFR_CLR_BIT_ASM(BKP_CTL, BKP_CTL_BKDRST_POS);
}

/**
  *   (BKP)ĴдʱҪ¼Ĵλã
  *         1.  OSCCTL0ĴPMWRENλ1Ķд
  *         2.  PM_CTL0ĴBKPREGCLRλ1Ĵ˳λ
  *         3.  PM_CTL0ĴBKPWRλ1ݼĴRTCģڵļĴд
  *       дĴǰøúдٴεøúȱٻε޷ָԭʼá
  *   NewState: ĴдʹܣȡֵΧΪ
  *                   TRUE: Ĵдǰ
  *                   FALSE: Ĵдûָ
  *   ޡ
  */
void
BKP_Write_And_Read_Enable (FunctionalState NewState)
{
    uint32_t tmpreg = 0;
    static uint32_t pmwrenbkp = TRUE;
    static uint32_t bkpregclrbkp = TRUE;
    static uint32_t bkpwrbkp = TRUE;

    /* У */
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

    if (NewState != FALSE)
    {
        /* ׼д */
        /* PMWRENλ */
        tmpreg = OSC_CTL0;
        if (OSC_CTL0_PMWREN & tmpreg)
        {
            pmwrenbkp = TRUE;
        }
        else
        {
            pmwrenbkp = FALSE;
            /* Ķд */
            SFR_SET_BIT_ASM(OSC_CTL0, OSC_CTL0_PMWREN_POS);
        }

        /* BKPREGCLRλ */
        tmpreg = PM_CTL0;
        if (PM_CTL0_BKPREGCLR & tmpreg)
        {
            bkpregclrbkp = TRUE;
        }
        else
        {
            bkpregclrbkp = FALSE;
            /* Ĵ˳λ */
            SFR_SET_BIT_ASM(PM_CTL0, PM_CTL0_BKPREGCLR_POS);
        }

        /* BKPWRλ */
        tmpreg = PM_CTL0;
        if (PM_CTL0_BKPWR & tmpreg)
        {
            bkpwrbkp = TRUE;
        }
        else
        {
            bkpwrbkp = FALSE;
            /* ݼĴRTCģڵļĴд */
            SFR_SET_BIT_ASM(PM_CTL0, PM_CTL0_BKPWR_POS);
        }
    }
    else
    {
        /* д */
        /* ָPMWRENλ */
        if (pmwrenbkp != FALSE)
        {
            pmwrenbkp = TRUE;
        }
        else
        {
            pmwrenbkp = FALSE;
            /* ֹĶд */
            SFR_CLR_BIT_ASM(OSC_CTL0, OSC_CTL0_PMWREN_POS);
        }

        /* ָBKPREGCLRλ */
        if (bkpregclrbkp != FALSE)
        {
            bkpregclrbkp = TRUE;
        }
        else
        {
            bkpregclrbkp = FALSE;
            /* ֹĶд */
            SFR_CLR_BIT_ASM(PM_CTL0, PM_CTL0_BKPREGCLR_POS);
        }

        /* ָBKPWRλ */
        if (bkpwrbkp != FALSE)
        {
            bkpwrbkp = TRUE;
        }
        else
        {
            bkpwrbkp = FALSE;
            /* ֹĶд */
            SFR_CLR_BIT_ASM(PM_CTL0, PM_CTL0_BKPWR_POS);
        }
    }
}
/**
  *   ##### (BKP)λд #####
  */


/**
  *   ##### (BKP)ú #####
  */
/**
  *   ñĴλʹܡ
  *   NewState: ĴλȡֵΧΪTRUE  FALSE
  *   
  */
void
BKP_Reset_Enable (FunctionalState NewState)
{
    /* У */
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

    /*---------------- BKP_CTLĴBKDRSTλ ----------------*/
    if (NewState != FALSE)
    {
        /* Ĵ鸴λ */
        SFR_SET_BIT_ASM(BKP_CTL, BKP_CTL_BKDRST_POS);
    }
    else
    {
        /*  */
        SFR_CLR_BIT_ASM(BKP_CTL, BKP_CTL_BKDRST_POS);
    }
}

/**
  *   ŵЧƽ
  *   PinSel: ѡȡֵΪ
  *                 BKP_PIN_RTC_TAMP1: RTC_TAMP1
  *                 BKP_PIN_RTC_TAMP2: RTC_TAMP2
  *                 BKP_PIN_RTC_TAMP3: RTC_TAMP3
  *       Effective: ЧƽȡֵΪ:
  *                    BKP_HIGH_LEVEL_EFFECTIVE: ߵƽеݱݼĴ
  *                    BKP_LOW_LEVEL_EFFECTIVE: ͵ƽеݱݼĴ
  *   ޡ
  */
void
BKP_Pin_Effective_Level_Config (uint32_t PinSel, uint32_t Effective)
{
    uint32_t tmpreg = 0;

    /* У */
    CHECK_RESTRICTION(CHECK_BKP_PIN_RTC_TAMP(PinSel));
    CHECK_RESTRICTION(CHECK_BKP_EFFECTIVE_LEVEL(Effective));

    /*------------- BKP_CTLĴTAMPxLVLλ -------------*/
    tmpreg = BKP_CTL_TAMP1LVL << PinSel;
    if (BKP_HIGH_LEVEL_EFFECTIVE != Effective)
    {
        /* ϵĵ͵ƽеݱݼĴ */
        BKP_CTL |= tmpreg;
    }
    else
    {
        /* ϵĸߵƽеݱݼĴ */
        BKP_CTL &= ~tmpreg;
    }
}

/**
  *   RTC_TAMP1ʹܡ
  *   PinSel: ѡȡֵΪ
  *                 BKP_PIN_RTC_TAMP1: RTC_TAMP1
  *                 BKP_PIN_RTC_TAMP2: RTC_TAMP2
  *                 BKP_PIN_RTC_TAMP3: RTC_TAMP3
  *       NewState: RTC_TAMP1ʹ״̬ȡֵΧΪTRUE  FALSE
  *   ޡ
  */
void
BKP_Pin_Enable (uint32_t PinSel, FunctionalState NewState)
{
    uint32_t tmpreg = 0;

    /* У */
    CHECK_RESTRICTION(CHECK_BKP_PIN_RTC_TAMP(PinSel));
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

    /*------------- BKP_CTLĴTAMPxLVLλ -------------*/
    tmpreg = BKP_CTL_TAMP1EN << PinSel;
    if (NewState != FALSE)
    {
        /* ʹ1 */
        BKP_CTL |= tmpreg;
    }
    else
    {
        /* ֹ1 */
        BKP_CTL &= ~tmpreg;
    }
}

/**
  *   ͬܡ
  *   Mode: ȡֵΪ
  *                 BKP_TAMP_ASYNC: 첽
  *                 BKP_TAMP_SYNC: ͬ
  *   ޡ
  */
void
BKP_TAMP_SYNC_Mode_Select(uint32_t Mode)
{
	/* У */
	CHECK_RESTRICTION(CHECK_BKP_TAMP_MODE(Mode));

	BKP_CTL	= SFR_Config(BKP_CTL, ~BKP_CTL_SYNC, Mode << BKP_CTL_SYNC_POS);
}

/**
  *   ʱӡ
  *   CLK: ȡֵΪ
  *                 BKP_TAMP_SCK_SCLK: ѡ SCLK Ϊʱ
  *                 BKP_TAMP_SCK_INTLF: ѡ INTLF Ϊʱ
  *   ޡ
  */
void
BKP_TAMP_SCK_Select(uint32_t CLK)
{
	/* У */
	CHECK_RESTRICTION(CHECK_BKP_TAMP_SCK(CLK));

	BKP_CTL	= SFR_Config(BKP_CTL, ~BKP_CTL_SAMCLKS, CLK << BKP_CTL_SAMCLKS_POS);
}

/**
  *   RTCʱԴ
  *   Source: RTCʱԴѡȡֵΪ
                    BKP_RTC_NO_CLK: ʱ
                    BKP_RTC_EXTLF: EXTLFΪRTCʱ
                    BKP_RTC_INTLF: INTLFΪRTCʱ
                    BKP_RTC_EXTHF_DIV_128: EXTHF128ƵΪRTCʱ
  *   ޡ
  */
void
BKP_RTC_Clock_Config (uint32_t Source)
{
    /* У */
    CHECK_RESTRICTION(CHECK_BKP_RTC_CLK(Source));

    /*---------------- BKP_CTLĴRTCCLKSλ ----------------*/
    BKP_CTL = SFR_Config (BKP_CTL, ~BKP_CTL_RTCCLKS, Source);
}

/**
  *   ⲿʱ·ʹܡ
  *   Source: ʱѡȡֵΪ
  *                 BKP_EXTHF: ⲿƵʱ
  *                 BKP_EXTLF: ⲿƵʱ
  *       NewState: ⲿʱ·ʹ״̬ȡֵΧΪTRUE  FALSE
  *   ޡ
  */
void
BKP_External_Clock_Bypass_Enable (uint32_t Source, FunctionalState NewState)
{
    uint32_t tmpreg = 0;

    /* У */
    CHECK_RESTRICTION(CHECK_BKP_CLOCK_SOURCE(Source));
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

    /*------------- BKP_CTLĴTAMPxLVLλ -------------*/
    tmpreg = BKP_CTL_EXTHFBYP << Source;
    if (FALSE != NewState)
    {
        /* ⲿʱӱ· */
        BKP_CTL |= tmpreg;
    }
    else
    {
        /* ⲿʱδ· */
        BKP_CTL &= ~tmpreg;
    }
}

/**
  *   д򱸷ݼĴ
  *   OrderNumber: ݼĴţȡֵΧΪ0~31
  *       WriteData: дݣȡֵΧΪ32λݡ
  *   ޡ
  */
void
BKP_Data_Config (uint32_t OrderNumber, uint32_t WriteData)
{
    /* У */
    CHECK_RESTRICTION(CHECK_BKP_DATA_NUMBER(OrderNumber));

    /*------------- BKP_DATAĴBKPDATAλ -------------*/
    BKP_SFR->DATA[OrderNumber] = WriteData;
}

/**
  *   򱸷ݼĴ
  *   OrderNumber: ݼĴţȡֵΧΪ0~31
  *   ݼĴֵȡֵΧΪ32λݡ
  */
uint32_t
BKP_Get_Data (uint32_t OrderNumber)
{
    uint32_t tmpreg = 0;

    /* У */
    CHECK_RESTRICTION(CHECK_BKP_DATA_NUMBER(OrderNumber));

    /*------------- ȡBKP_DATAĴBKPDATAλ -------------*/
    tmpreg = BKP_SFR->DATA[OrderNumber];

    return tmpreg;
}
/**
  *   ##### (BKP)ú #####
  */


/**
  *   ##### (BKP)жϹ #####
  */
/**
  *   жʹܡ
  *   PinSel: ѡȡֵΪ
  *                 BKP_PIN_RTC_TAMP1: RTC_TAMP1
  *                 BKP_PIN_RTC_TAMP2: RTC_TAMP2
  *                 BKP_PIN_RTC_TAMP3: RTC_TAMP3
  *       NewState: жʹ״̬ȡֵΪTRUE  FALSE
  *   ޡ
  */
void
BKP_Pin_TAMP_INT_Enable (uint32_t PinSel, FunctionalState NewState)
{
    uint32_t tmpreg = 0;

    /* У */
    CHECK_RESTRICTION(CHECK_BKP_PIN_RTC_TAMP(PinSel));
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

    /*---------------- BKP_INTĴTAMPxIEλ ----------------*/
    tmpreg = BKP_INT_TAMP1IE << PinSel;
    if (NewState != FALSE)
    {
        /* ʹж */
        BKP_INT |= tmpreg;
    }
    else
    {
        /* ֹж */
        BKP_INT &= ~tmpreg;
    }
}

/**
  *   ȡжϱ־
  *   PinSel: ѡȡֵΪ
  *                 BKP_PIN_RTC_TAMP1: RTC_TAMP1
  *                 BKP_PIN_RTC_TAMP2: RTC_TAMP2
  *                 BKP_PIN_RTC_TAMP3: RTC_TAMP3
  *   1:¼0:¼
  */
FlagStatus
BKP_Get_Pin_TAMP_INT_Flag (uint32_t PinSel)
{
    uint32_t tmpreg = 0;

    /* У */
    CHECK_RESTRICTION(CHECK_BKP_PIN_RTC_TAMP(PinSel));

    /*---------------- ȡBKP_INTĴTAMPxIFλ ----------------*/
    tmpreg = BKP_INT_TAMP1IF << PinSel;
    if (BKP_INT & tmpreg)
    {
        /* ¼ */
        return SET;
    }
    else
    {
        /* ¼ */
        return RESET;
    }
}

/**
  *   жϱ־
  *   PinSel: ѡȡֵΪ
  *                 BKP_PIN_RTC_TAMP1: RTC_TAMP1
  *                 BKP_PIN_RTC_TAMP2: RTC_TAMP2
  *                 BKP_PIN_RTC_TAMP3: RTC_TAMP3
  *   ޡ
  */
void
BKP_Clear_Pin_TAMP_INT_Flag (uint32_t PinSel)
{
    uint32_t tmpreg = 0;
    uint32_t tmpreg1 = 0;
    /* У */
    CHECK_RESTRICTION(CHECK_BKP_PIN_RTC_TAMP(PinSel));

    /*---------------- BKP_INTĴTAMPxICλ ----------------*/
    tmpreg = BKP_INT_TAMP1IC << PinSel;
    tmpreg1 = BKP_INT_TAMP1IF << PinSel;
    BKP_INT |= tmpreg;
    while((BKP_INT & tmpreg1)>>(BKP_INT_TAMP1IF_POS+PinSel));
    BKP_INT &= ~tmpreg;
}
/**
  *   ##### (BKP)жϹ #####
  */
