/**
  ******************************************************************************
  * ļ  kf32f_basic_crc.h
  *     ChipON_AE/FAE_Group
  *     V3.0.1
  *     2021-11-25
  *     ļṩѭУ鵥Ԫعܺغ궨塣
  *********************************************************************
  */

#ifndef _KF32F_BASIC_CRC_H_
#define _KF32F_BASIC_CRC_H_

#include "KF32F_BASIC.h"


/**
  * ѭУ鵥Ԫ(CRC)ָ붨
  */
#define CHECK_CRC_PERIPH(PERIPH)     ((PERIPH) == CRC_SFR)

/**
 * CRC Ϣṹ
 */
typedef struct
{
 uint32_t m_CalUnitReset;       /*  CRC 㵥Ԫλ
                                    ȡΪCRC㵥Ԫλơеһ */
 uint32_t m_InputSize;          /*  CRC ݸʽλ
                                    ȡΪCRCݸʽλеһ */
 uint32_t m_InputReverse;       /*  CRC ݷλ
                                    ȡΪCRCݷλеһ */
 uint32_t m_ResultReverse;      /*  CRC 
                                    ȡΪCRCơеһ */
 uint32_t m_Data;               /*  CRC ֵȡֵ32λݣݺҪҶ */
 uint32_t m_Result;             /*  CRC ֵȡֵ32qλݣֵΪֻ */
 uint32_t m_InitialData;        /*  CRC ʼֵȡֵ32λ */
 uint32_t m_Polynomial;         /*  CRC ʽֵȡֵ32λֵ */
 uint32_t m_ResultXOR;          /*  CRC jֵȡֵ32λֵ */
 uint32_t m_IndepentData;       /*  CRC ݼĴֵȡֵ32λ*/
 uint32_t m_Temp;               /*  CRC ֵȡֵ32λֵΪֻ */
} CRC_InitTypeDef;

/**
 * CRC㵥Ԫλ
 */
#define CRC_CAL_RSET_ENABLE             ((uint32_t) 0x1 << CRC_CTL_RSET_POS)
#define CRC_CAL_RSET_DISABLE            ((uint32_t) 0x0 << CRC_CTL_RSET_POS)
#define CHECK_CRC_CAL_RSET(SEL)         (((SEL) == CRC_CAL_RSET_ENABLE) \
                                        || ((SEL) == CRC_CAL_RSET_DISABLE) )

/**
 * CRCݸʽλ
 */
#define CRC_INPUT_SEZE_8                ((uint32_t) 0X0 << CRC_CTL_DATASIZE0_POS)
#define CRC_INPUT_SEZE_16               ((uint32_t) 0X1 << CRC_CTL_DATASIZE0_POS)
#define CRC_INPUT_SEZE_24               ((uint32_t) 0X2 << CRC_CTL_DATASIZE0_POS)
#define CRC_INPUT_SEZE_32               ((uint32_t) 0X3 << CRC_CTL_DATASIZE0_POS)
#define CHECK_CRC_INPUT_SEZE(SIZE)      (((SIZE) == CRC_INPUT_SEZE_8) \
                                        || ((SIZE) == CRC_INPUT_SEZE_16) \
                                        || ((SIZE) == CRC_INPUT_SEZE_24) \
                                        || ((SIZE) == CRC_INPUT_SEZE_32) )

/**
 * CRCݷλ
 */
#define CRC_INPUT_REVERSE_ENABLE        ( (uint32_t) 0x1 << CRC_CTL_DATAREV_POS )
#define CRC_INPUT_REVERSE_DISABLE       ( (uint32_t) 0x0 << CRC_CTL_DATAREV_POS )
#define CHECK_CRC_INPUT_REVERSE(SEL)    (((SEL) == CRC_INPUT_REVERSE_ENABLE) \
                                        || ((SEL) == CRC_INPUT_REVERSE_DISABLE) )

/**
 * CRC
 */
#define CRC_RESULT_REVERSE_ENABLE       ((uint32_t) 0x1 << CRC_CTL_RSLTREV_POS)
#define CRC_RESULT_REVERSE_DISABLE      ((uint32_t) 0x0 << CRC_CTL_RSLTREV_POS)
#define CHECK_CRC_RSLTREV_SEL(SEL)      (((SEL) == CRC_RESULT_REVERSE_ENABLE) \
                                        || ((SEL) == CRC_RESULT_REVERSE_DISABLE))

#ifdef  KF32F_Periph_crc
void CRC_Reset ();
void CRC_Configuration (CRC_InitTypeDef* CRCInitStruct);
void CRC_Struct_Init (CRC_InitTypeDef* CRCInitStruct);
void CRC_INPUT_DATA (uint32_t DATA);
uint32_t CRC_GET_RESULT ();
void CRC_SET_INITVALUE (uint32_t DATA);
void CRC_SET_PLN (uint32_t DATA);
void CRC_SET_RXOR (uint32_t DATA);
void CRC_SET_IDATA (uint32_t DATA);
uint32_t CRC_GET_TEMP ();
void CRC_SET_RSET ();
#endif  //KF32F_Periph_crc
#endif /* _KF32F_BASIC_CRC_H */
