﻿# KungFu32 RT-Thread

#### 文件介绍
介绍ChipON 基于KF32系列MCU，Windows平台，进行RT-Thread nano V3.1.3版本的移植和开发。包括任务创建、调度，建立等。通过使用此软件包，开发者可以快速的在KungFu32系列上使用RT-Thread系统。

#### RT-Thread简述
[RT-Thread](https://www.rt-thread.org)是一个集实时操作系统（RTOS）内核、中间件组件和开发者社区于一体的技术平台，也是一个组件完整丰富、高度可伸缩、简易开发、超低功耗、高安全性的物联网操作系统


#### ChipON IDE 版本
版本:[KungFu32 IDE](http://https://www.chipon-ic.com/Product/kaifa/77091ccf-ee3e-4d68-aebb-677635ab9558?type=d2f35882-7c3c-482e-b147-02bb77e66acb#bawei)  V1.0.17.1，支持更高版本IDE

#### 库函数版本
库函数版本:KF32Lxxx_StdPeriph_Lib_V2.6.2，支持更高版本库函数。可登陆[Gitee](
https://gitee.com/chipon-kungfu) 获取更新的库函数版本

#### 功能简述
1.系统时钟120M，RT-Thread系统时钟节拍时间为1ms
2.建立两个任务，任务1进行500msLED闪烁，任务2进行300ms通过串口发送数据

#### 文件目录
源代码目录结构如下所示：
| 名称  | 描述  |
|---|---|
| config | KF32 MCU启动文件及中断向量表  |
| BSP | 外设驱动包  |
| sdk | 软件开发平台包  |
| sdk/bsp | KF32 MCU相关系列标准固件库函数  |
| sdk/oskernal | Rt-thread-Nano 内核文件 |
| ChangeLog | 代码发布版本记录  |
| LICENSE  | 开源协议  |

#### KF32不同型号移植
不同型号之前的移植主要分三个步骤：
1.在IDE中更换型号定义
2.更换对应系列的标准库函数及时钟配置文件
3.在board.c文件中更改对应的标准库函数的 "#include "xxxxx_BASIC.h"" 文件

#### 重要更新记录
###### 2020年01月31
1. ChipON-RT-Thread-Nano-Windows正式发布

###### 2020年06月16
1. 修复IDE更新，优化效率变更，嵌汇编时自动内联的漏洞


