/******************************************************************************
 *                  Shanghai ChipON Micro-Electronic Co.,Ltd                  *
 ******************************************************************************
 *  $File Name$       : kf32a156_sysctl.c                             	      *
 *  $Author$          : ChipON AE/FAE Group                                   *
 *  $Data$            : 2021-07-08                                            *
 *  $AutoSAR Version  : V1.0	                                              *
 *  $Description$     : This file provides the system control related 		  *
 *  					functions, including:								  *
 *          			+ System control (SYSCTL) function configuration 	  *
 *          			  function      								      *
 *          			+ Do directive function configuration	              *
 ******************************************************************************
 *  Copyright (C) by Shanghai ChipON Micro-Electronic Co.,Ltd                 *
 *  All rights reserved.                                                      *
 *                                                                            *
 *  This software is copyrght protected and proprietary to                    *
 *  Shanghai ChipON Micro-Electronic Co.,Ltd.                                 *
 ******************************************************************************
 *  ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~  *
 *                     		REVISON HISTORY                               	  *
 *  ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~  *
 *  Data       Version  Author        Description                             *
 *  ~~~~~~~~~~ ~~~~~~~~ ~~~~~~~~~~~~  ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~  *
 *  2021-07-08 00.01.00 FAE Group     new creat                               *
 *                                                                            *
 *                                                                            *
 *****************************************************************************/

/******************************************************************************
**                      		Include Files                                **
******************************************************************************/


#include "kf32a156_sysctl.h"


/**
  *   ##### ϵͳ(SYSCTL)ú #####
  */


/* ϵͳ˽ж ----------------------------------------------------*/
/* SYS_ARCTLĴдARKEY */
#define SYS_ARCTL_WRITE_CTL             ((uint32_t)0x05FA \
                                      << SYS_ARCTL_ARKEY0_POS)

/**
  *   ȡ״̬Vλ־
  *   ޡ
  *   1:0:
  */
FlagStatus
SYSCTL_Get_V_Flag (void)
{
    /*---------------- ȡSYS_PSWĴVλ ----------------*/

    if(SYS_PSW & SYS_PSW_V)
    {
        /*  */
        return SET;
    }
    else
    {
        /*  */
        return RESET;
    }
}

/**
  *   ȡ״̬Cλλλ־
  *   ޡ
  *   1:ӷнλ޽λ0:ӷ޽λнλ
  */
FlagStatus
SYSCTL_Get_C_Flag (void)
{
    /*---------------- ȡSYS_PSWĴCλ ----------------*/
    if (SYS_PSW & SYS_PSW_C)
    {
        /* ӷнλ޽λ */
        return SET;
    }
    else
    {
        /* ӷ޽λнλ */
        return RESET;
    }
}

/**
  *   ȡ״̬Zλֵ־
  *   ޡ
  *   1:ֵ0:ֵ
  */
FlagStatus
SYSCTL_Get_Z_Flag (void)
{
    /*---------------- ȡSYS_PSWĴZλ ----------------*/
    if (SYS_PSW & SYS_PSW_Z)
    {
        /* ֵ */
        return SET;
    }
    else
    {
        /* ֵ */
        return RESET;
    }
}

/**
  *   ȡ״̬Nλֵ־
  *   ޡ
  *   1:ֵ0:Ǹֵ
  */
FlagStatus
SYSCTL_Get_N_Flag (void)
{
    /*---------------- ȡSYS_PSWĴNλ ----------------*/
    if (SYS_PSW & SYS_PSW_N)
    {
        /* ֵ */
        return SET;
    }
    else
    {
        /* Ǹֵ */
        return RESET;
    }
}

/**
  *   ״̬Vλ־
  *   NewState: ״̬Vλ־
  *                 ȡֵΧΪTRUE  FALSE
  *   ޡ
  */
void
SYSCTL_Set_V_Flag (FunctionalState NewState)
{
    /* У */
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

    /*---------------- SYS_PSWĴVλ ----------------*/
    if (NewState != FALSE)
    {
        /* ־ */
        SFR_SET_BIT_ASM(SYS_PSW, SYS_PSW_V_POS);
    }
    else
    {
        /* ־ */
        SFR_CLR_BIT_ASM(SYS_PSW, SYS_PSW_V_POS);
    }
}

/**
  *   ״̬Cλ־
  *   NewState: ״̬Cλλλ־
  *                 ȡֵΧΪTRUE  FALSE
  *   ޡ
  */
void
SYSCTL_Set_C_Flag (FunctionalState NewState)
{
    /* У */
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

    /*---------------- SYS_PSWĴCλ ----------------*/
    if (NewState != FALSE)
    {
        /* ýλλ־ */
        SFR_SET_BIT_ASM(SYS_PSW, SYS_PSW_C_POS);
    }
    else
    {
        /* λλ־ */
        SFR_CLR_BIT_ASM(SYS_PSW, SYS_PSW_C_POS);
    }
}

/**
  *   ״̬Zλ־
  *   NewState: ״̬Zλλλ־
  *                 ȡֵΧΪTRUE  FALSE
  *   ޡ
  */
void
SYSCTL_Set_Z_Flag (FunctionalState NewState)
{
    /* У */
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

    /*---------------- SYS_PSWĴZλ ----------------*/
    if (NewState != FALSE)
    {
        /* ýλλ־ */
        SFR_SET_BIT_ASM(SYS_PSW, SYS_PSW_Z_POS);
    }
    else
    {
        /* λλ־ */
        SFR_CLR_BIT_ASM(SYS_PSW, SYS_PSW_Z_POS);
    }
}
/**
  *   ״̬Nλֵ־
  *   NewState: ״̬NλֵǸֵ־
  *                 ȡֵΧΪTRUE  FALSE
  *   ޡ
  */
void
SYSCTL_Set_N_Flag (FunctionalState NewState)
{
    /* У */
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

    /*---------------- SYS_PSWĴZλ ----------------*/
    if (NewState != FALSE)
    {
        /* ýλλ־ */
        SFR_SET_BIT_ASM(SYS_PSW, SYS_PSW_N_POS);
    }
    else
    {
        /* λλ־ */
        SFR_CLR_BIT_ASM(SYS_PSW, SYS_PSW_N_POS);
    }
}

/**
  *   жϴؽģʽʹܡ
  *   NewState: жϴؽģʽʹ״̬ȡֵΪTRUE  FALSE
  *   ޡ
  */
void
SYSCTL_Sleep_On_Exit_Enable (FunctionalState NewState)
{
    /* У */
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

    /*---------------- SYS_MCTLĴSLEEPONEXITλ ----------------*/
    if (NewState != FALSE)
    {
        /* ʹжϷʱģʽ */
        SFR_SET_BIT_ASM(SYS_MCTL, SYS_MCTL_SLEEPONEXIT_POS);
    }
    else
    {
        /* ֹжϷʱģʽ */
        SFR_CLR_BIT_ASM(SYS_MCTL, SYS_MCTL_SLEEPONEXIT_POS);
    }
}

/**
  *   ûģʽѡ
  *   NewState: жϻCPUʹ״̬ȡֵΪTRUE  FALSE
  *   ޡ
  */
void
SYSCTL_Interrupt_Awake_Enable (FunctionalState NewState)
{
    /* У */
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

    /*---------------- SYS_MCTLĴSLPONMODλ ----------------*/
    if (NewState != FALSE)
    {
        /* ж϶ܻCPU */
        SFR_SET_BIT_ASM(SYS_MCTL, SYS_MCTL_SLPONMOD_POS);
    }
    else
    {
        /* ֻежȼȵǰȼʱܻCPU */
        SFR_CLR_BIT_ASM(SYS_MCTL, SYS_MCTL_SLPONMOD_POS);
    }
}

/**
  *   ȡǰжԶջĶ뷽ʽ
  *   ޡ
  *   1:˫ֶʹܣ0:˫ֶδʹܡ
  */
FlagStatus
SYSCTL_Stack_Align_State (void)
{
    /*---------------- ȡSYS_MCTLĴSTACKALIGNλ ----------------*/
    if (SYS_MCTL & SYS_MCTL_STACKALIGN)
    {
        /* ˫ֶʹ */
        return SET;
    }
    else
    {
        /* ˫ֶδʹ */
        return RESET;
    }
}

/**
  *   óûơ
  *   NewState: ѡ񳬼û־ȡֵΪTRUE  FALSE
  *   ޡ
  */
void
SYSCTL_Super_User_Config (FunctionalState NewState)
{
    /* У */
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

    /*---------------- SYS_MCTLĴSUSTAλ ----------------*/
    if (NewState != FALSE)
    {
        /* ûģʽ */
        SFR_SET_BIT_ASM(SYS_MCTL, SYS_MCTL_SUSTA_POS);
    }
    else
    {
        /* ûģʽ */
        SFR_CLR_BIT_ASM(SYS_MCTL, SYS_MCTL_SUSTA_POS);
    }
}

/**
  *   ȡǰЧջָ״̬־
  *   ޡ
  *   1:PSPǵǰĶջָ룻0:MSPǵǰĶջָ롣
  */
FlagStatus
SYSCTL_Stack_Pointer_State (void)
{
    /*---------------- ȡSYS_MCTLĴSPSELλ ----------------*/
    if (SYS_MCTL & SYS_MCTL_SPSEL)
    {
        /* PSPǵǰĶջָ */
        return SET;
    }
    else
    {
        /* MSPǵǰĶջָ */
        return RESET;
    }
}

/**
  *   õǰЧջָ롣
  *   PresentSP: ǰЧջָ룬ȡֵΪ
  *                    SYSCTL_SP_IS_MSP: MSPǵǰĶջָ
  *                    SYSCTL_SP_IS_PSP: PSPǵǰĶջָ
  *   ޡ
  */
void
SYSCTL_Stack_Pointer_Config (uint32_t PresentSP)
{
    /* У */
    CHECK_RESTRICTION(CHECK_SYSCTL_SP(PresentSP));

    /*------------------ SYS_MCTLĴSPSELλ -----------------*/
    SYS_MCTL = SFR_Config (SYS_MCTL, ~SYS_MCTL_SPSEL, PresentSP);
}

/**
  *   쳣Ϣλ
  *   NewState: 쳣ϢλȡֵΪTRUE  FALSE
  *   ޡ
  */
void
SYSCTL_Exception_Reset_Enable (FunctionalState NewState)
{
    uint32_t tmpreg = 0;

    /* У */
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

    /*------------------ SYS_ARCTLĴVECTRSTλ -----------------*/
    tmpreg = SYS_ARCTL_WRITE_CTL | \
            ((uint32_t)NewState << SYS_ARCTL_VECTRST_POS);
    SYS_ARCTL = SFR_Config (SYS_ARCTL,
                        ~(SYS_ARCTL_VECTRST | SYS_ARCTL_ARKEY),
                        tmpreg);
}

/**
  *   ϵͳλ
  *   NewState: ϵͳλȡֵΪTRUE  FALSE
  *   ޡ
  */
void
SYSCTL_System_Reset_Enable (FunctionalState NewState)
{
    uint32_t tmpreg = 0;

    /* У */
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

    /*------------------ SYS_ARCTLĴSYSTEMRSTλ -----------------*/
    tmpreg = SYS_ARCTL_WRITE_CTL | \
            ((uint32_t)NewState << SYS_ARCTL_SYSTEMRST_POS);
    SYS_ARCTL = SFR_Config (SYS_ARCTL,
                        ~(SYS_ARCTL_SYSTEMRST | SYS_ARCTL_ARKEY),
                        tmpreg);
}

/**
  *   ںDMA״̬
  *   NewState: ںDMA״̬ȡֵΪTRUE  FALSE
  *   ޡ
  */
void
SYSCTL_Core_Dma_Clear_Enable(FunctionalState NewState)
{
	uint32_t tmpreg = 0x00;

    /* У */
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

    tmpreg = SYS_ARCTL_WRITE_CTL | ((uint32_t)NewState << SYS_ARCTL_CDMAR_POS);
    SYS_ARCTL = SFR_Config(SYS_ARCTL, ~(SYS_ARCTL_CDMAR | SYS_ARCTL_ARKEY), tmpreg);
}

/**
  *   ں DMA CPUдͻٲģʽѡ
  *   Mode: ٲģʽѡȡֵΪ
  * 				SYSCTL_FAST_MODE: ģʽ
  * 				SYSCTL_EFFICIENT_MODE Чģʽ
  *   ޡ
  */
void
SYSCTL_Cdmaam_Config(uint32_t Mode)
{
	uint32_t tmpreg = 0x00;

    /* У */
    CHECK_RESTRICTION(CHECK_SYSCTL_MODE(Mode));

    tmpreg = SYS_ARCTL_WRITE_CTL | ((uint32_t)Mode << SYS_ARCTL_CDMAAM_POS);
    SYS_ARCTL = SFR_Config(SYS_ARCTL, ~(SYS_ARCTL_CDMAAM | SYS_ARCTL_ARKEY), tmpreg);
}

/**
  *   CORE д賤ģʽơ
  *   Cycle: ٲģʽѡȡֵΪ
  * 				SYSCTL_READ_PER_2CYCLE: CORE /дֱΪ 2 ڣ RAM /дΪֱ 1 
  * 				SYSCTL_READ_PER_1CYCLE CORE /дֱΪ 1 
  *   ޡ
  */
void
SYSCTL_RW_Per_Cycle_Config(uint32_t Cycle)
{
	uint32_t tmpreg = 0x00;

    /* У */
    CHECK_RESTRICTION(CHECK_SYSCTL_RW_PER_CYCLE(Cycle));

    tmpreg = SYS_ARCTL_WRITE_CTL | ((uint32_t)Cycle << SYS_ARCTL_CRWDC_POS);
    SYS_ARCTL = SFR_Config(SYS_ARCTL, ~(SYS_ARCTL_CRWDC | SYS_ARCTL_ARKEY), tmpreg);
}

/**
  *   CORE  DMA д BKP ģʽơ
  *   Cycle: CORE  DMA д BKP ģʽƣȡֵΪ
  * 				SYSCTL_RW_DMA_4CYCLE: CORE  DMA  BKP /дֱΪ 4 
  * 				SYSCTL_RW_DMA_1CYCLE CORE  DMA  BKP /дֱΪ 1 
  *   ޡ
  */
void
SYSCTL_RW_Dma_Cycle_Config(uint32_t Cycle)
{
	uint32_t tmpreg = 0x00;

    /* У */
    CHECK_RESTRICTION(CHECK_SYSCTL_RW_DMA_CYCLE(Cycle));

    tmpreg = SYS_ARCTL_WRITE_CTL | ((uint32_t)Cycle << SYS_ARCTL_CDMADC_POS);
    SYS_ARCTL = SFR_Config(SYS_ARCTL, ~(SYS_ARCTL_CDMADC | SYS_ARCTL_ARKEY), tmpreg);
}

/**
  *  CORE  DMA д BKP ӳģʽơ
  *   Cycle ȡֵΪ
  * 				SYSCTL_RW_DMA_CDMADC: CORE  DMA  BKP  CDMADC 
  * 				SYSCTL_RW_DMA_16CYCLE CORE  DMA  BKP /дֱΪ 16 
  * 				SYSCTL_RW_DMA_32CYCLE: CORE  DMA  BKP /дֱΪ 32 
  * 				SYSCTL_RW_DMA_64CYCLE: CORE  DMA  BKP /дֱΪ 64 
  *   ޡ
  */
void
SYSCTL_RW_Dma_Long_Cycle_Config(uint32_t Cycle)
{
	uint32_t tmpreg = 0x00;

    /* У */
    CHECK_RESTRICTION(CHECK_SYSCTL_RW_DMA_LONG_CYCLE(Cycle));

    tmpreg = SYS_ARCTL_WRITE_CTL | ((uint32_t)Cycle << SYS_ARCTL_CDMALDC0_POS);
    SYS_ARCTL = SFR_Config(SYS_ARCTL, ~(SYS_ARCTL_CDMALDC | SYS_ARCTL_ARKEY), tmpreg);
}

/**
  *   жӳַá
  *   VectorOffset: жӳַȡֵ32λݣλӲԡ
  *   ޡ
  */
void
SYSCTL_Vector_Offset_Config (uint32_t VectorOffset)
{
	uint32_t tmpreg = 0;
    /*---------------- SYS_VECTOFFĴTBLOFFλ ----------------*/
	tmpreg = VectorOffset << SYS_VECTOFF_TBLOFF0_POS;
    SYS_VECTOFF = SFR_Config (SYS_VECTOFF,
                      ~(SYS_VECTOFF_TBLOFF),
                      tmpreg);
}

/**
  *   RAMռ䳤ȣָʾRAMռַ
  *   RamSpace: RAMռ䳤ȣȡֵΪ26λЧֵ
  *   ޡ
  */
void
SYSCTL_Ram_Space_Config (uint32_t RamSpace)
{
	uint32_t tmpreg = 0;
    /* У */
    CHECK_RESTRICTION(CHECK_RAM_SPACE(RamSpace));

    /*---------------- SYS_RAMSPAĴRAMSPAλ ----------------*/
    tmpreg = RamSpace << SYS_RAMSPA_RAMSPA0_POS;
    SYS_RAMSPA = SFR_Config (SYS_RAMSPA,
                      ~SYS_RAMSPA_RAMSPA,
                      tmpreg);
}

/**
  *   FLASHʼ512ֽڿռӳơ
  *   MemCtl: ӳƣȡֵΧΪ:
  *                 SYSCTL_FLASH_REMAP_FOR_ROM: ΪROMӳ
  *                 SYSCTL_FLASH_REMAP_FOR_RAM: ΪRAMӳ
  *                 SYSCTL_FLASH_REMAP_FOR_FLASH: ΪFLASHӳ
  *                 SYSCTL_FLASH_REMAP_STOP_CPU: ֹͣCPU
  *   ޡ
  */
void
SYSCTL_Flash_Start_Remap_Config (uint32_t MemCtl)
{
    /* У */
    CHECK_RESTRICTION(CHECK_SYSCTL_FLASH_REMAP(MemCtl));

    /*---------------- SYS_MEMCTLĴMEMMλ ----------------*/
    SYS_MEMCTL = SFR_Config (SYS_MEMCTL, ~SYS_MEMCTL_MEMM, MemCtl);
}

/**
  *   SYS_MSPSPAջָޡ
  *    Mspspah: ջָ MSP ռֵָʾȡֵΧΪ:0~0xFFFF
  *   ޡ
  */
void
SYSCTL_MSPSPAH_Threshold_Config (uint16_t Mspspah)
{
    /* У */
    CHECK_RESTRICTION(CHECK_SPA_Threshold(Mspspah));

    SYS_MSPSPA = SFR_Config(SYS_MSPSPA, ~(SYS_MSPSPA_MSPSPAH), Mspspah << SYS_MSPSPA_MSPSPAH0_POS);
}

/**
  *   SYS_MSPSPAջָ MSPռָʾĴ
  *    Mspspal: ջָ MSP ֵָʾȡֵΧΪ:0~0xFFFF
  *   ޡ
  */
void
SYSCTL_MSPSPAL_Threshold_Config (uint16_t Mspspal)
{
    /* У */
	CHECK_RESTRICTION(CHECK_SPA_Threshold(Mspspal));

    SYS_MSPSPA = SFR_Config(SYS_MSPSPA, ~(SYS_MSPSPA_MSPSPAL), Mspspal << SYS_MSPSPA_MSPSPAL0_POS);
}

/**
  *   SYS_PSPSPAջָޡ
  *    Pspspah: ջָ PSP ռֵָʾȡֵΧΪ:0~0xFFFF
  *   ޡ
  */
void
SYSCTL_PSPSPAH_Threshold_Config (uint16_t Pspspah)
{
    /* У */
    CHECK_RESTRICTION(CHECK_SPA_Threshold(Pspspah));

    SYS_PSPSPA = SFR_Config(SYS_PSPSPA, ~(SYS_PSPSPA_PSPSPAH), Pspspah << SYS_PSPSPA_PSPSPAH0_POS);
}

/**
  *   SYS_PSPSPAջָޡ
  *    Pspspah: ջָ PSP ռֵָʾȡֵΧΪ:0~0xFFFF
  *   ޡ
  */
void
SYSCTL_PSPSPAL_Threshold_Config (uint16_t Pspspal)
{
    /* У */
    CHECK_RESTRICTION(CHECK_SPA_Threshold(Pspspal));

    SYS_PSPSPA = SFR_Config(SYS_PSPSPA, ~(SYS_PSPSPA_PSPSPAL), Pspspal << SYS_PSPSPA_PSPSPAL0_POS);
}

/**
  *   ##### ϵͳ(SYSCTL)ú #####
  */
