/******************************************************************************
 *                  Shanghai ChipON Micro-Electronic Co.,Ltd                  *
 ******************************************************************************
 *  $File Name$       : kf32a156_pclk.c                              	      *
 *  $Author$          : ChipON AE/FAE Group                                   *
 *  $Data$            : 2021-07-08                                            *
 *  $AutoSAR Version  : V1.0	                                              *
 *  $Description$     : This file provides the peripheral clock enable module *
 *                      (PCLK) peripheral functions, including:               *
 *     					+ Peripheral clock enable module (PCLK) function 	  *
 *     					  configuration function							  *
 ******************************************************************************
 *  Copyright (C) by Shanghai ChipON Micro-Electronic Co.,Ltd                 *
 *  All rights reserved.                                                      *
 *                                                                            *
 *  This software is copyrght protected and proprietary to                    *
 *  Shanghai ChipON Micro-Electronic Co.,Ltd.                                 *
 ******************************************************************************
 *  ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~  *
 *                     		REVISON HISTORY                               	  *
 *  ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~  *
 *  Data       Version  Author        Description                             *
 *  ~~~~~~~~~~ ~~~~~~~~ ~~~~~~~~~~~~  ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~  *
 *  2021-07-08 00.01.00 FAE Group     new creat                               *
 *                                                                            *
 *                                                                            *
 *****************************************************************************/

/******************************************************************************
**                      		Include Files                                **
******************************************************************************/

#include "kf32a156_pclk.h"


/**
  *   ##### ʱʹģ(PCLK)ú #####
  **/

/**
  *   PCLK_CTL0Ƶʱʹܡ
  *   PCLK_CTL0_bit: ָʱʹλ룬ȡֵΪ
  *                        PCLK_CTL0_GPIOACLKEN: GPIOA
  *                        PCLK_CTL0_GPIOBCLKEN: GPIOB
  *                        PCLK_CTL0_GPIOCCLKEN: GPIOC
  *                        PCLK_CTL0_GPIODCLKEN: GPIOD
  *                        PCLK_CTL0_GPIOECLKEN: GPIOE
  *                        PCLK_CTL0_GPIOFCLKEN: GPIOF
  *                        PCLK_CTL0_GPIOGCLKEN: GPIOG
  *                        PCLK_CTL0_GPIOHCLKEN: GPIOH
  * NewState: ʱʹ״̬ȡֵΧΪTRUE  FALSE
  *   ޡ
  **/
void
PCLK_CTL0_Peripheral_Clock_Enable (uint32_t PCLK_CTL0_bit,
                    FunctionalState NewState)
{
    /* У */
    CHECK_RESTRICTION(CHECK_PCLK_CTL0_PERIPH(PCLK_CTL0_bit));
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

    if (NewState != FALSE)
    {
        PCLK_CTL0 |= PCLK_CTL0_bit;
    }
    else
    {
        PCLK_CTL0 &= ~PCLK_CTL0_bit;
    }
}

/**
  *   PCLK_CTL1Ƶʱʹܡ
  *   PCLK_CTL1_bit: ָʱʹλ룬ȡֵΪ
  *                        PCLK_CTL1_QEI1CLKENQEI1
  *                        PCLK_CTL1_T1CLKENT1
  *                        PCLK_CTL1_T2CLKENT2
  *                        PCLK_CTL1_T3CLKENT3
  *                        PCLK_CTL1_T4CLKENT4
  *                        PCLK_CTL1_T5T6CLKENT5T6
  *                        PCLK_CTL1_QEI0CLKENQEI0
  *                        PCLK_CTL1_ADC0CLKENADC0
  *                        PCLK_CTL1_ADC1CLKENADC1
  *                        PCLK_CTL1_ADC2CLKENADC2
  *                        PCLK_CTL1_DAC0CLKENDAC0
  *                        PCLK_CTL1_DAC1CLKENDAC1
  *                        PCLK_CTL1_CMPCLKENCMP
  *                        PCLK_CTL1_T0CLKENT0
  *                        PCLK_CTL1_USART0CLKENUSART0
  *                        PCLK_CTL1_USART1CLKENUSART1
  *                        PCLK_CTL1_USART2CLKENUSART2
  *                        PCLK_CTL1_USART4CLKENUSART4
  *                        PCLK_CTL1_SPI0CLKENSPI0
  *                        PCLK_CTL1_SPI1CLKENSPI1
  *                        PCLK_CTL1_I2C0CLKENI2C0
  *                        PCLK_CTL1_I2C1CLKENI2C1
  *                        PCLK_CTL1_I2C2CLKENI2C2
  * NewState: ʱʹ״̬ȡֵΧΪTRUE  FALSE
  *   ޡ
  **/
void
PCLK_CTL1_Peripheral_Clock_Enable (uint32_t PCLK_CTL1_bit,
                    FunctionalState NewState)
{
    /* У */
    CHECK_RESTRICTION(CHECK_PCLK_CTL1_PERIPH(PCLK_CTL1_bit));
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

    if (NewState != FALSE)
    {
        PCLK_CTL1 |= PCLK_CTL1_bit;
    }
    else
    {
        PCLK_CTL1 &= ~PCLK_CTL1_bit;
    }
}

/**
  *   PCLK_CTL2Ƶʱʹܡ
  *   PCLK_CTL2_bit: ָʱʹλ룬ȡֵΪ
  *                        PCLK_CTL2_I2C4CLKENI2C4
  *                        PCLK_CTL2_I2C5CLKENI2C5
  *                        PCLK_CTL2_WWDTCLKENWWDT
  *                        PCLK_CTL2_EPWM11CLKENEPWM11
  *                        PCLK_CTL2_EPWM12CLKENEPWM12
  *                        PCLK_CTL2_EPWM13CLKENEPWM13
  *                        PCLK_CTL2_EPWM16CLKENPWM16
  *                        PCLK_CTL2_DMA0CLKENDMA0
  *                        PCLK_CTL2_DMA1CLKENDMA1
  *                        PCLK_CTL2_T14CLKENT14
  *                        PCLK_CTL2_T18CLKENT18
  *                        PCLK_CTL2_T19CLKENT19
  *                        PCLK_CTL2_T21CLKENT21
  *                        PCLK_CTL2_DAC2CLKENDAC2
  *                        PCLK_CTL2_DAC3CLKENDAC3
  *                        PCLK_CTL2_USART5CLKENUSART5
  *                        PCLK_CTL2_USART7CLKENUSART7
  * NewState: ʱʹ״̬ȡֵΧΪTRUE  FALSE
  *   ޡ
  **/
void
PCLK_CTL2_Peripheral_Clock_Enable (uint32_t PCLK_CTL2_bit,
					FunctionalState NewState)
{
	/* У */
	CHECK_RESTRICTION(CHECK_PCLK_CTL2_PERIPH(PCLK_CTL2_bit));
	CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

	if(NewState != FALSE)
	{
		PCLK_CTL2 |= PCLK_CTL2_bit;
	}
	else
	{
		PCLK_CTL2 &= ~PCLK_CTL2_bit;
	}
}

/**
  *   PCLK_CTL3Ƶʱʹܡ
  *   PCLK_CTL3_bit: ָʱʹλ룬ȡֵΪ
  *                        PCLK_CTL3_SPI2CLKEN	SPI2
  *                        PCLK_CTL3_SPI3CLKEN	SPI3
  *                        PCLK_CTL3_I2C3CLKEN	I2C3
  *                        PCLK_CTL3_HRCAP0CLKENHRCAP0
  *                        PCLK_CTL3_HRCAP1CLKENHRCAP1
  *                        PCLK_CTL3_HRCAP2CLKENHRCAP2
  *                        PCLK_CTL3_CRCCLKENCRC
  *                        PCLK_CTL3_AESCLKENAES
  *                        PCLK_CTL3_EXICCLKENEXIC
  *                        PCLK_CTL3_CAN4CLKENCAN4
  *                        PCLK_CTL3_CFGLCLKEN	CFGL
  *                        PCLK_CTL3_OPCLKENOP
  *                        PCLK_CTL3_TRGMUXCLKENTRGMUX
  *                        PCLK_CTL3_PDB0CLKENPDB0
  *                        PCLK_CTL3_PDB1CLKENPDB1
  *                        PCLK_CTL3_PDB2CLKENPDB2
  *                        PCLK_CTL3_FLEXRPCLKENFLEXRP
  *                        PCLK_CTL3_PLAPCLKENPLAP
  *                        PCLK_CTL3_EWMCLKENEWM
  *                        PCLK_CTL3_RNGCLKENRNG
  *                        PCLK_CTL3_CAN6CLKENCAN6
  *                        PCLK_CTL3_CAN7CLKENCAN7
  *                        PCLK_CTL3_RTCCLKENRTC
  *
  *
  * NewState: ʱʹ״̬ȡֵΧΪTRUE  FALSE
  *   ޡ
  **/
void
PCLK_CTL3_Peripheral_Clock_Enable (uint32_t PCLK_CTL3_bit,
					FunctionalState NewState)
{
	/* У */
	CHECK_RESTRICTION(CHECK_PCLK_CTL3_PERIPH(PCLK_CTL3_bit));
	CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

	if(NewState != FALSE)
	{
		PCLK_CTL3 |= PCLK_CTL3_bit;
	}
	else
	{
		PCLK_CTL3 &= ~PCLK_CTL3_bit;
	}
}
/**
  *   ##### ʱʹģ(PCLK)ú #####
  **/
