/******************************************************************************
 *                  Shanghai ChipON Micro-Electronic Co.,Ltd                  *
 ******************************************************************************
 *  $File Name$       : KF32A156_hrcap.c                            	      *
 *  $Author$          : ChipON AE/FAE Group                                   *
 *  $Data$            : 2021-07-08                                            *
 *  $AutoSAR Version  : V1.0	                                              *
 *  $Description$     : This file provides the High precision capture 		  *
 *  				    peripherals function                              	  *
 ******************************************************************************
 *  Copyright (C) by Shanghai ChipON Micro-Electronic Co.,Ltd                 *
 *  All rights reserved.                                                      *
 *                                                                            *
 *  This software is copyrght protected and proprietary to                    *
 *  Shanghai ChipON Micro-Electronic Co.,Ltd.                                 *
 ******************************************************************************
 *  ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~  *
 *                     		REVISON HISTORY                               	  *
 *  ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~  *
 *  Data       Version  Author        Description                             *
 *  ~~~~~~~~~~ ~~~~~~~~ ~~~~~~~~~~~~  ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~  *
 *  2021-07-08 00.01.00 FAE Group     new creat                               *
 *                                                                            *
 *                                                                            *
 *****************************************************************************/

/******************************************************************************
**                      		Include Files                                **
******************************************************************************/

#include "kf32a156_hrcap.h"
#include "kf32a156_rst.h"
#include "kf32a156_pclk.h"


/**
  *   ##### ߾Ȳ׽(HRCAP)ƹܺ #####
  */
/**
  *  : λHRCAPģ飬ʹʱӡ
  *  : HRCAPx : 	HRCAP0_SFRHRCAP1_SFRHRCAP2_SFR
  *  : ޡ
  */
void
HRCAP_Reset (HRCAP_SFRmap* HRCAPx)
{
	/* У */
	CHECK_RESTRICTION(CHECK_HRCAP_ALL_PERIPH(HRCAPx));

	if(HRCAPx == HRCAP0_SFR)
	{
		/* λPLAģ */
		RST_CTL3_Peripheral_Reset_Enable(RST_CTL3_HRCAP0RST, TRUE);
		RST_CTL3_Peripheral_Reset_Enable(RST_CTL3_HRCAP0RST, FALSE);
		/* ʹPLAʱ */
		PCLK_CTL3_Peripheral_Clock_Enable(PCLK_CTL3_HRCAP0CLKEN, TRUE);
	}
	else if(HRCAPx == HRCAP1_SFR)
	{
		/* λPLAģ */
		RST_CTL3_Peripheral_Reset_Enable(RST_CTL3_HRCAP1RST, TRUE);
		RST_CTL3_Peripheral_Reset_Enable(RST_CTL3_HRCAP1RST, FALSE);
		/* ʹPLAʱ */
		PCLK_CTL3_Peripheral_Clock_Enable(PCLK_CTL3_HRCAP1CLKEN, TRUE);
	}
	else if(HRCAPx == HRCAP2_SFR)
	{
		/* λPLAģ */
		RST_CTL3_Peripheral_Reset_Enable(RST_CTL3_HRCAP2RST, TRUE);
		RST_CTL3_Peripheral_Reset_Enable(RST_CTL3_HRCAP2RST, FALSE);
		/* ʹPLAʱ */
		PCLK_CTL3_Peripheral_Clock_Enable(PCLK_CTL3_HRCAP2CLKEN, TRUE);
	}
	else
	{
		;
	}
}

/**
  *  : HRCAPxģ鹤ʱѡ
  *  : HRCAPx : 	HRCAP0_SFRHRCAP1_SFRHRCAP2_SFR
  * 	  CLK : 	HRCAP_CLK_SCLK : SCLK
  * 	  			HRCAP_CLK_HFCLK : HFCLK
  * 	  			HRCAP_CLK_LFCLK : LFCLK
  *  : ޡ
  */
void
HRCAP_CLK_Select(HRCAP_SFRmap* HRCAPx, uint32_t CLK)
{
	uint32_t tmpreg = 0;

	/* У */
	CHECK_RESTRICTION(CHECK_HRCAP_ALL_PERIPH(HRCAPx));
	CHECK_RESTRICTION(CHECK_HRCAP_CLK(CLK));

	tmpreg = CLK << HRCAP_CTL_CLKSEL0_POS;
	if(HRCAPx == HRCAP0_SFR)
	{
		HC0_CTL = SFR_Config(HC0_CTL, ~HRCAP_CTL_CLKSEL, tmpreg);
	}
	else if(HRCAPx == HRCAP1_SFR)
	{
		HC1_CTL = SFR_Config(HC1_CTL, ~HRCAP_CTL_CLKSEL, tmpreg);
	}
	else if(HRCAPx == HRCAP2_SFR)
	{
		HC2_CTL = SFR_Config(HC2_CTL, ~HRCAP_CTL_CLKSEL, tmpreg);
	}
	else
	{
		;
	}
}

/**
  *  : HRCAPxλʹܡ
  *  : HRCAPx : 	HRCAP0_SFRHRCAP1_SFRHRCAP2_SFR
  * 	  NewState : 	TRUE : ʹHRCAPxλ
  * 	  				FALSE : ֹHRCAPxλ
  *  : ޡ
  */
void
HRCAP_Software_Reset_Enable(HRCAP_SFRmap* HRCAPx, FunctionalState NewState)
{
	uint32_t tmpreg = 0;

	/* У */
	CHECK_RESTRICTION(CHECK_HRCAP_ALL_PERIPH(HRCAPx));
	CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

	tmpreg = NewState << HRCAP_CTL_SOFTRESET_POS;
	if(HRCAPx == HRCAP0_SFR)
	{
		HC0_CTL = SFR_Config(HC0_CTL, ~HRCAP_CTL_SOFTRESET, tmpreg);
	}
	else if(HRCAPx == HRCAP1_SFR)
	{
		HC1_CTL = SFR_Config(HC1_CTL, ~HRCAP_CTL_SOFTRESET, tmpreg);
	}
	else if(HRCAPx == HRCAP2_SFR)
	{
		HC2_CTL = SFR_Config(HC2_CTL, ~HRCAP_CTL_SOFTRESET, tmpreg);
	}
	else
	{
		;
	}
}

/**
  *  : HRCAPxжʹܡ
  *  : HRCAPx : 	HRCAP0_SFRHRCAP1_SFRHRCAP2_SFR
  * 	  Select : 		HRCAP_COUNTOVER_INT : HRCAPxж
  * 	  				HRCAP_FALL_INT : HRCAPx½ز׽ж
  * 	  				HRCAP_RISE_INT : HRCAPxز׽ж
  * 	  NewState : 	TRUE : ʹHRCAPxλ
  * 	  				FALSE : ֹHRCAPxλ
  *  : ޡ
  */
void
HRCAP_INT_Enable(HRCAP_SFRmap* HRCAPx,
			uint32_t Select, FunctionalState NewState)
{
	uint32_t tmpreg = 0;
	uint32_t tmask = 0;

	/* У */
	CHECK_RESTRICTION(CHECK_HRCAP_ALL_PERIPH(HRCAPx));
	CHECK_RESTRICTION(CHECK_HRCAP_INT(Select));
	CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

	tmpreg = NewState << (HRCAP_CTL_RISEINTE_POS + Select);
	tmask = 1 << (HRCAP_CTL_RISEINTE_POS + Select);
	if(HRCAPx == HRCAP0_SFR)
	{
		HC0_CTL = SFR_Config(HC0_CTL, ~tmask, tmpreg);
	}
	else if(HRCAPx == HRCAP1_SFR)
	{
		HC1_CTL = SFR_Config(HC1_CTL, ~tmask, tmpreg);
	}
	else if(HRCAPx == HRCAP2_SFR)
	{
		HC2_CTL = SFR_Config(HC2_CTL, ~tmask, tmpreg);
	}
	else
	{
		;
	}
}

/**
  *  : HRCAPx׽ѡ
  *  : HRCAPx : 	HRCAP0_SFRHRCAP1_SFRHRCAP2_SFR
  * 	  Select : 		HRCAP_EXTERNAL_INPUT : ѡרõHRCAPxⲿ
  * 	  				HRCAP_HRPWMX_OUTPUT : ѡӦHRPWMxź
  *  : ޡ
  */
void
HRCAP_Cap_Input_Select(HRCAP_SFRmap* HRCAPx, uint32_t Select)
{
	/* У */
	CHECK_RESTRICTION(CHECK_HRCAP_ALL_PERIPH(HRCAPx));
	CHECK_RESTRICTION(CHECK_HRCAP_CAP_INPUT(Select));

	if(HRCAPx == HRCAP0_SFR)
	{
		HC0_CTL = SFR_Config(HC0_CTL, ~HRCAP_CTL_HCINSEL, Select);
	}
	else if(HRCAPx == HRCAP1_SFR)
	{
		HC1_CTL = SFR_Config(HC1_CTL, ~HRCAP_CTL_HCINSEL, Select);
	}
	else if(HRCAPx == HRCAP2_SFR)
	{
		HC2_CTL = SFR_Config(HC2_CTL, ~HRCAP_CTL_HCINSEL, Select);
	}
	else
	{
		;
	}
}

/**
  *  : ȡ16λľ֮HRCAPxֵ
  *  : HRCAPx : 	HRCAP0_SFRHRCAP1_SFRHRCAP2_SFR
  *  : 16λļֵ
  * עƼʹô˺ȡHRCAPxֵ
  */
uint16_t
HRCAP_Read_Latch_Count_Value(HRCAP_SFRmap* HRCAPx)
{
	uint32_t Value = 0;

	/* У */
	CHECK_RESTRICTION(CHECK_HRCAP_ALL_PERIPH(HRCAPx));

	if(HRCAPx == HRCAP0_SFR)
	{
		Value = (HC0_COUNTER & HRCAP_COUNTER_COUNTERSR) >> HRCAP_COUNTER_COUNTERSR0_POS;
	}
	else if(HRCAPx == HRCAP1_SFR)
	{
		Value = (HC1_COUNTER & HRCAP_COUNTER_COUNTERSR) >> HRCAP_COUNTER_COUNTERSR0_POS;
	}
	else if(HRCAPx == HRCAP2_SFR)
	{
		Value = (HC2_COUNTER & HRCAP_COUNTER_COUNTERSR) >> HRCAP_COUNTER_COUNTERSR0_POS;
	}
	else
	{
		;
	}

	return Value;
}

/**
  *  : ȡ16λHRCAPxֵ
  *  : HRCAPx : 	HRCAP0_SFRHRCAP1_SFRHRCAP2_SFR
  *  : 16λļֵ
  */
uint16_t
HRCAP_Read_Count_Value(HRCAP_SFRmap* HRCAPx)
{
	uint32_t Value = 0;

	/* У */
	CHECK_RESTRICTION(CHECK_HRCAP_ALL_PERIPH(HRCAPx));

	if(HRCAPx == HRCAP0_SFR)
	{
		Value = HC0_COUNTER & HRCAP_COUNTER_COUNTER;
	}
	else if(HRCAPx == HRCAP1_SFR)
	{
		Value = HC1_COUNTER & HRCAP_COUNTER_COUNTER;
	}
	else if(HRCAPx == HRCAP2_SFR)
	{
		Value = HC2_COUNTER & HRCAP_COUNTER_COUNTER;
	}
	else
	{
		;
	}

	return Value;
}

/**
  *  : ȡ16λHRCAPx׽Ĵֵ
  *  : HRCAPx : 	HRCAP0_SFRHRCAP1_SFRHRCAP2_SFR
  * 	  HRCAP_REG     HRCAP_REGISTER0 : Ĵ0
  * 	  				HRCAP_REGISTER1 : Ĵ1
  *  : 16λֵ
  */
uint16_t
HRCAP_Read_Rise_Integer_Value(HRCAP_SFRmap* HRCAPx, uint32_t HRCAP_REG)
{
	uint32_t Value = 0;

	/* У */
	CHECK_RESTRICTION(CHECK_HRCAP_ALL_PERIPH(HRCAPx));
	CHECK_RESTRICTION(CHECK_HRCAP_CAP_REGISTER(HRCAP_REG));

	Value = HRCAPx->RISE[HRCAP_REG] & HRCAP_RISE0_RISE0;

	return Value;
}

/**
  *  : ȡ16λHRCAPx½׽Ĵֵ
  *  : HRCAPx : 	HRCAP0_SFRHRCAP1_SFRHRCAP2_SFR
  * 	  HRCAP_REG     HRCAP_REGISTER0 : Ĵ0
  * 	  				HRCAP_REGISTER1 : Ĵ1
  *  : 16λֵ
  */
uint16_t
HRCAP_Read_Fall_Integer_Value(HRCAP_SFRmap* HRCAPx, uint32_t HRCAP_REG)
{
	uint32_t Value = 0;

	/* У */
	CHECK_RESTRICTION(CHECK_HRCAP_ALL_PERIPH(HRCAPx));
	CHECK_RESTRICTION(CHECK_HRCAP_CAP_REGISTER(HRCAP_REG));

	Value = HRCAPx->FALL[HRCAP_REG] & HRCAP_FALL0_FALL0;

	return Value;
}

/**
  *  : ȡ16λHRCAPxС׽Ĵֵ
  *  : HRCAPx : 	HRCAP0_SFRHRCAP1_SFRHRCAP2_SFR
  * 	  HRCAP_REG     HRCAP_REGISTER0 : Ĵ0
  * 	  				HRCAP_REGISTER1 : Ĵ1
  *  : 16λֵ
  */
uint16_t
HRCAP_Read_Rise_Decimal_Value(HRCAP_SFRmap* HRCAPx, uint32_t HRCAP_REG)
{
	uint32_t Value = 0;

	/* У */
	CHECK_RESTRICTION(CHECK_HRCAP_ALL_PERIPH(HRCAPx));
	CHECK_RESTRICTION(CHECK_HRCAP_CAP_REGISTER(HRCAP_REG));

	Value = HRCAPx->HRRISE[HRCAP_REG] & HRCAP_HRRISE0_HRRISE0;

	return Value;
}

/**
  *  : ȡ16λHRCAPx½С׽Ĵֵ
  *  : HRCAPx : 	HRCAP0_SFRHRCAP1_SFRHRCAP2_SFR
  * 	  HRCAP_REG     HRCAP_REGISTER0 : Ĵ0
  * 	  				HRCAP_REGISTER1 : Ĵ1
  *  : 16λֵ
  */
uint16_t
HRCAP_Read_Fall_Decimal_Value(HRCAP_SFRmap* HRCAPx, uint32_t HRCAP_REG)
{
	uint32_t Value = 0;

	/* У */
	CHECK_RESTRICTION(CHECK_HRCAP_ALL_PERIPH(HRCAPx));
	CHECK_RESTRICTION(CHECK_HRCAP_CAP_REGISTER(HRCAP_REG));

	Value = HRCAPx->HRFALL[HRCAP_REG] & HRCAP_HRFALL0_HRFALL0;

	return Value;
}

/**
  *  : ȡHRCAPxжϱ־λ
  *  : HRCAPx : 	HRCAP0_SFRHRCAP1_SFRHRCAP2_SFR
  * 	  Select : 	HRCAP_RISEOVER_INT : ز׽ж¼
  * 	  			HRCAP_COUNTOVER_INT : ¼
  * 	  			HRCAP_FALL_INT : ½ز׽ж¼
  * 	  			HRCAP_RISE_INT : ز׽ж¼
  *  : 0 : ж¼
  * 	  1   ж¼
  */
FlagStatus
HRCAP_Get_INT_Flag(HRCAP_SFRmap* HRCAPx, uint32_t Select)
{
	uint32_t Value = 0;
	uint32_t tmask = 0;

	/* У */
	CHECK_RESTRICTION(CHECK_HRCAP_ALL_PERIPH(HRCAPx));
	CHECK_RESTRICTION(CHECK_HRCAP_INT_FLAG(Select));

	Select += HRCAP_SR_RISEIF_POS;
	tmask = 1 << Select;
	if(HRCAPx == HRCAP0_SFR)
	{
		Value = (HC0_SR & tmask) >> Select;
	}
	else if(HRCAPx == HRCAP1_SFR)
	{
		Value = (HC1_SR & tmask) >> Select;
	}
	else if(HRCAPx == HRCAP2_SFR)
	{
		Value = (HC2_SR & tmask) >> Select;
	}
	else
	{
		;
	}

	return Value;
}

/**
  *  : HRCAPxжϱ־λ
  *  : HRCAPx : 	HRCAP0_SFRHRCAP1_SFRHRCAP2_SFR
  * 	  Select : 	HRCAP_RISEOVER_INT : ز׽ж¼
  * 	  			HRCAP_COUNTOVER_INT : ¼
  * 	  			HRCAP_FALL_INT : ½ز׽ж¼
  * 	  			HRCAP_RISE_INT : ز׽ж¼
  */
void
HRCAP_Clear_INT_Flag(HRCAP_SFRmap* HRCAPx, uint32_t Select)
{
	uint32_t tmask = 0;

	/* У */
	CHECK_RESTRICTION(CHECK_HRCAP_ALL_PERIPH(HRCAPx));
	CHECK_RESTRICTION(CHECK_HRCAP_INT_FLAG(Select));


	tmask = 1 << (Select+HRCAP_SRIC_RISEIC_POS);

	HRCAPx->SRIC = SFR_Config(HRCAPx->SRIC, ~tmask, tmask);
	while(HRCAPx->SR & tmask);
	HRCAPx->SRIC = SFR_Config(HRCAPx->SRIC, ~tmask, 0);
}

/**
  *  : HRCAPxжϱ־λǿλʹܡ
  *  : HRCAPx : 	HRCAP0_SFRHRCAP1_SFRHRCAP2_SFR
  * 	  Select : 	HRCAP_COUNTOVER_INT : ¼
  * 	  			HRCAP_FALL_INT : ½ز׽ж¼
  * 	  			HRCAP_RISE_INT : ز׽ж¼
  * 	  NewState : TRUE : ǿλ
  * 	  			 FALSE : ޶
  */
void
HRCAP_INT_Mandatory_Enable(HRCAP_SFRmap* HRCAPx, uint32_t Select, FunctionalState NewState)
{
	uint32_t tmpreg = 0;
	uint32_t tmask = 0;

	/* У */
	CHECK_RESTRICTION(CHECK_HRCAP_ALL_PERIPH(HRCAPx));
	CHECK_RESTRICTION(CHECK_HRCAP_MANDATORY_INT(Select));
	CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

	tmpreg = NewState << (Select + HRCAP_IFRC_RISEIFRC_POS);
	tmask = 1 << (Select + HRCAP_IFRC_RISEIFRC_POS);

	if(HRCAPx == HRCAP0_SFR)
	{
		HC0_IFRC = SFR_Config(HC0_IFRC, ~tmask, tmpreg);
	}
	else if(HRCAPx == HRCAP1_SFR)
	{
		HC1_IFRC = SFR_Config(HC1_IFRC, ~tmask, tmpreg);
	}
	else if(HRCAPx == HRCAP2_SFR)
	{
		HC2_IFRC = SFR_Config(HC2_IFRC, ~tmask, tmpreg);
	}
	else
	{
		;
	}
}


