/******************************************************************************
 *                  Shanghai ChipON Micro-Electronic Co.,Ltd                  *
 ******************************************************************************
 *  $File Name$       : KF32A156_exic.c                             	      *
 *  $Author$          : ChipON AE/FAE Group                                   *
 *  $Data$            : 2021-07-08                                            *
 *  $AutoSAR Version  : V1.0	                                              *
 *  $Description$     : This file provides the EXIC peripherals function	  *
 ******************************************************************************
 *  Copyright (C) by Shanghai ChipON Micro-Electronic Co.,Ltd                 *
 *  All rights reserved.                                                      *
 *                                                                            *
 *  This software is copyrght protected and proprietary to                    *
 *  Shanghai ChipON Micro-Electronic Co.,Ltd.                                 *
 ******************************************************************************
 *  ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~  *
 *                     		REVISON HISTORY                               	  *
 *  ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~  *
 *  Data       Version  Author        Description                             *
 *  ~~~~~~~~~~ ~~~~~~~~ ~~~~~~~~~~~~  ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~  *
 *  2021-07-08 00.01.00 FAE Group     new creat                               *
 *                                                                            *
 *                                                                            *
 *****************************************************************************/

/******************************************************************************
**                      		Include Files                                **
******************************************************************************/
#include "kf32a156_exic.h"
#include "kf32a156_rst.h"
#include "kf32a156_pclk.h"

/**
  *   ##### EXICӿڹܳʼ #####
  */
/* EXIC_CTL0Ĵʼ */
#define EXIC_CTL0_INIT_MASK		 		(EXIC_CTL0_EXICEN \
                                       | EXIC_CTL0_CSEN \
                                       | EXIC_CTL0_DCSEL \
                                       | EXIC_CTL0_WRITEEN \
                                       | EXIC_CTL0_READEN \
                                       | EXIC_CTL0_TDMAEN \
                                       | EXIC_CTL0_RDMAEN \
                                       | EXIC_CTL0_WENDIN \
                                       | EXIC_CTL0_RENDIE \
                                       | EXIC_CTL0_WRITE1EN \
                                       | EXIC_CTL0_READ1EN \
                                       | EXIC_CTL0_DATATR \
                                       | EXIC_CTL0_MODESEL)
/* EXIC_CTL1Ĵʼ */
#define EXIC_CTL1_INIT_MASK		 		(EXIC_CTL1_EXICCS \
                                       | EXIC_CTL1_PULSEWIDTH)
/**
  *   λEXICģ顣
  *   ޡ
  *   ޡ
  */
void
EXIC_Reset (void)
{
	RST_CTL3_Peripheral_Reset_Enable(RST_CTL3_EXICRST, TRUE);
	RST_CTL3_Peripheral_Reset_Enable(RST_CTL3_EXICRST, FALSE);
	PCLK_CTL3_Peripheral_Clock_Enable(PCLK_CTL3_EXICCLKEN, TRUE);
}
/**
  *   EXICá
  *   EXICx: EXICInitStruct: EXICϢ
  *   ޡ
  */
void
EXIC_Configuration (EXIC_InitTypeDef* EXICInitStruct)
{
    uint32_t tmpreg = 0;

	CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(EXICInitStruct->m_Module_Enable));
	CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(EXICInitStruct->m_CS_Enable));
	CHECK_RESTRICTION(CHECK_EXIC_TRANSMIT(EXICInitStruct->m_Data_Control_Sel));
	CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(EXICInitStruct->m_Write_Enable));
	CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(EXICInitStruct->m_Read_Enable));
	CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(EXICInitStruct->m_DMA_Write_EN));
	CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(EXICInitStruct->m_DMA_Read_EN));
	CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(EXICInitStruct->m_WriteFnish_INT_EN));
	CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(EXICInitStruct->m_ReadFnish_INT_EN));
	CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(EXICInitStruct->m_WriteData_EN));
	CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(EXICInitStruct->m_ReadData_EN));
	CHECK_RESTRICTION(CHECK_DATA_DIRECTION(EXICInitStruct->m_Data_Direction_Sel));
	CHECK_RESTRICTION(CHECK_MODE_SEL(EXICInitStruct->m_Mode_Sel));
	CHECK_RESTRICTION(CHECK_EXIC_CLKSOURCE_SEL(EXICInitStruct->m_Source_Clock_Sel));
	CHECK_RESTRICTION(CHECK_PULSEWIDTH_SEL(EXICInitStruct->m_Pulse_Width_Sel));

	/*---------------------------- EXIC_CTLĴ  -----------------*/
	/* ݽṹԱm_Module_EnableEXICENλ */
	/* ݽṹԱm_CS_EnableCSENλ */
	/* ݽṹԱm_Data_Control_SelD/CSELλ */
	/* ݽṹԱm_Write_EnableWRITEENλ */
	/* ݽṹԱm_Read_EnableREADENλ */
	/* ݽṹԱm_DMA_Write_ENTDMAENλ */
	/* ݽṹԱm_DMA_Read_ENRDMAENλ */
	/* ݽṹԱm_WriteFnish_INT_ENWENDIEλ */
	/* ݽṹԱm_ReadFnish_INT_ENRENDIEλ */
	/* ݽṹԱm_WriteData_ENWRITE1ENλ */
	/* ݽṹԱm_ReadData_ENREAD1ENλ */
	/* ݽṹԱm_Data_Direction_SelDATATRλ */
	/* ݽṹԱm_Mode_SelMODESELλ */


   tmpreg = ((EXICInitStruct->m_Module_Enable << EXIC_CTL0_EXICEN_POS) | \
		     (EXICInitStruct->m_CS_Enable << EXIC_CTL0_CSEN_POS) | \
		     (EXICInitStruct->m_Data_Control_Sel ) | \
		     (EXICInitStruct->m_Write_Enable << EXIC_CTL0_WRITEEN_POS) | \
		     (EXICInitStruct->m_Read_Enable << EXIC_CTL0_READEN_POS) | \
		     (EXICInitStruct->m_DMA_Write_EN << EXIC_CTL0_TDMAEN_POS) | \
		     (EXICInitStruct->m_DMA_Read_EN << EXIC_CTL0_RDMAEN_POS) | \
		     (EXICInitStruct->m_WriteFnish_INT_EN << EXIC_CTL0_WENDIE_POS) | \
		     (EXICInitStruct->m_ReadFnish_INT_EN << EXIC_CTL0_RENDIE_POS) | \
		     (EXICInitStruct->m_WriteData_EN << EXIC_CTL0_WRITE1EN_POS) | \
		     (EXICInitStruct->m_ReadData_EN << EXIC_CTL0_READ1EN_POS) | \
		     (EXICInitStruct->m_Data_Direction_Sel ) | \
		     (EXICInitStruct->m_Mode_Sel) | \
		     (EXICInitStruct->m_Source_Clock_Sel) | \
		     (EXICInitStruct->m_Pulse_Width_Sel));
   EXIC_SFR->CTL0 = SFR_Config (EXIC_SFR->CTL0,
			   ~EXIC_CTL0_INIT_MASK,
			   tmpreg);
	/*---------------------------- EXIC_CTL1Ĵ  -----------------*/
	/* ݽṹԱm_Source_Clock_SelEXICCSλ */
	/* ݽṹԱm_Pulse_Width_SelPULSEWIDTHλ */
   tmpreg = ((EXICInitStruct->m_Source_Clock_Sel) | \
		     (EXICInitStruct->m_Pulse_Width_Sel));
   EXIC_SFR->CTL1 = SFR_Config (EXIC_SFR->CTL1,
			   ~EXIC_CTL1_INIT_MASK,
			   tmpreg);
}
/**
  *   ʼEXICϢṹ塣
  *   EXICInitStruct: ָʼĽṹָ롣
  *   ޡ
  */
void
EXIC_Struct_Init (EXIC_InitTypeDef* EXICInitStruct)
{
    /* ʼEXICӿʹѡ */
    EXICInitStruct->m_Module_Enable = FALSE;
    /* ʼEXICƬѡʹѡ */
    EXICInitStruct->m_CS_Enable = FALSE;
    /* ʼ EXIC/ѡ */
    EXICInitStruct->m_Data_Control_Sel = EXIC_TRANSMIT_DATA;
    /* ʼEXICдʹ */
    EXICInitStruct->m_Write_Enable = FALSE;
    /* ʼ EXICʹ */
    EXICInitStruct->m_Read_Enable = FALSE;
    /* ʼEXIC DMAдʹ*/
    EXICInitStruct->m_DMA_Write_EN = FALSE;
    /* ʼEXIC DMAʹ */
    EXICInitStruct->m_DMA_Read_EN = FALSE;
    /* ʼ EXICȼͨⲿתģʽʹ */
    EXICInitStruct->m_WriteFnish_INT_EN = FALSE;
    /* ʼ жʹ */
    EXICInitStruct->m_ReadFnish_INT_EN = FALSE;
    /* ʼ EXICдʹ */
    EXICInitStruct->m_WriteData_EN = FALSE;
    /* ʼ EXICʹ */
    EXICInitStruct->m_ReadData_EN = FALSE;
    /* ʼEXICݷѡ */
    EXICInitStruct->m_Data_Direction_Sel = EXIC_DATA_INPUT;
    /* ʼEXICģʽѡ */
	EXICInitStruct->m_Mode_Sel = EXIC_MODE_SEL_W1R1;
	/* ʼEXICʱԴѡ */
	EXICInitStruct->m_Source_Clock_Sel = EXIC_CLKSOURCE_SCLK;
	/* ʼ EXICдѡ */
	EXICInitStruct->m_Pulse_Width_Sel = EXIC_PULSEWIDTH_16Tclk;
}
/**
  *   ȡEXICдɱ־
  *   :
  *   ж״̬0δжϣ1ж
  */
FlagStatus
EXIC_Get_Write_Finish_INT_Flag (void)
{
    /*-------------------- ȡEXICSTATEĴWENFIFλ --------------------*/
    if (EXIC_STATE & EXIC_STATE_WENDIF)
    {
        /*  EXICдɱ־ */
        return SET;
    }
    else
    {
        /*  EXICδɱ־ */
        return RESET;
    }
}
/**
  *   EXICдɱ־
  *   :
  *   
  */
void EXIC_Clear_Write_Finish_INT_Flag (void)
{
    /*-------------------- EXICSTATEĴWENFIFλ --------------------*/
	while((EXIC_STATE & EXIC_STATE_WENDIF)>>EXIC_STATE_WENDIF_POS)
	{
		EXIC_SFR->STATE &= ~EXIC_STATE_WENDIF;
	}
}
/**
  *   ȡEXICɱ־
  *   :
  *   ж״̬0δжϣ1ж
  */
FlagStatus
EXIC_Get_Read_Finish_INT_Flag (void)
{
    /*-------------------- ȡEXICSTATEĴRENFIFλ --------------------*/
    if (EXIC_STATE & EXIC_STATE_RENDIF)
    {
        /*  EXICɱ־ */
        return SET;
    }
    else
    {
        /*  EXICδɱ־ */
        return RESET;
    }
}
/**
  *   EXICɱ־
  *   :
  *   
  */
void EXIC_Clear_Read_Finish_INT_Flag (void)
{
    /*-------------------- EXICSTATEĴRENFIFλ --------------------*/
	while((EXIC_STATE & EXIC_STATE_RENDIF)>>EXIC_STATE_RENDIF_POS)
	{
		EXIC_SFR->STATE &= ~EXIC_STATE_RENDIF;
	}
}
/**
  *   EXICдݻ档
  *   :DATAλ18,СΧΪ(0x00-0x3ffff)
  *   :
  */
void
EXIC_Write_Buff (uint32_t DATA)
{
   EXIC_SFR->WRITEBUF = DATA;
}
/**
  *   EXICݻ档
  *   :
  *   :DATAλ18,СΧΪ(0x00-0x3ffff)
  */
uint32_t
EXIC_Read_Buff (void)
{

   return(EXIC_SFR->READBUF);

}

