/******************************************************************************
 *                  Shanghai ChipON Micro-Electronic Co.,Ltd                  *
 ******************************************************************************
 *  $File Name$       : KF32A156_EWDT.c                                	      *
 *  $Author$          : ChipON AE/FAE Group                                   *
 *  $Data$            : 2021-07-08                                            *
 *  $AutoSAR Version  : V1.0	                                              *
 *  $Description$     : This file provides the External Watchdog (EWDT) 	  *
 *  				    peripherals function                          		  *
 ******************************************************************************
 *  Copyright (C) by Shanghai ChipON Micro-Electronic Co.,Ltd                 *
 *  All rights reserved.                                                      *
 *                                                                            *
 *  This software is copyrght protected and proprietary to                    *
 *  Shanghai ChipON Micro-Electronic Co.,Ltd.                                 *
 ******************************************************************************
 *  ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~  *
 *                     		REVISON HISTORY                               	  *
 *  ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~  *
 *  Data       Version  Author        Description                             *
 *  ~~~~~~~~~~ ~~~~~~~~ ~~~~~~~~~~~~  ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~  *
 *  2021-07-08 00.01.00 FAE Group     new creat                               *
 *                                                                            *
 *                                                                            *
 *****************************************************************************/

/******************************************************************************
**                      		Include Files                                **
******************************************************************************/

#include "kf32a156_ewdt.h"
#include "kf32a156_rst.h"
#include "kf32a156_pclk.h"


/**
  *   ##### ΧŹ(EWDT)ƹܺ #####
  */
/**
  *   λEWDTģ飬ʹʱӡ
  *   ޡ
  *   ޡ
  */
void
EWDT_Reset (void)
{
    /* λEWDTģ */
    RST_CTL3_Peripheral_Reset_Enable(RST_CTL3_EWDTRST, TRUE);
    RST_CTL3_Peripheral_Reset_Enable(RST_CTL3_EWDTRST, FALSE);
    /* ʹEWDTʱ */
    PCLK_CTL3_Peripheral_Clock_Enable(PCLK_CTL3_EWDTCLKEN, TRUE);
}

/**
  *   EWDTʱѡ
  *   CLK  	EWDT_CLK_INTLF  ѡINTLFΪʱ
  * 			EWDT_CLK_SCLK  ѡSCLKΪʱ
  * 			EWDT_CLK_LFCLK  ѡLFCLKΪʱ
  * 			EWDT_CLK_LP4M  ѡLP4MΪʱ
  *   
  * ע ͹ģʽ½ѡINTLFLP4M
  */
void
EWDT_CLK_Select(uint32_t CLK)
{
	uint32_t tmpreg = 0;

	/* У */
	CHECK_RESTRICTION(CHECK_EWDT_CLK(CLK));

	tmpreg = CLK << EWDT_CTL_CLKS0_POS;
	EWDT_CTL = SFR_Config(EWDT_CTL, ~EWDT_CTL_CLKS, tmpreg);
}

/**
  *   ΧŹԤƵ
  *   DIV : 	EWDT_CLK_DIV1 		: EWDTCLKΪѡʱ
  * 			EWDT_CLK_DIV2 		: EWDTCLKΪѡʱ/2
  * 			EWDT_CLK_DIV4 		: EWDTCLKΪѡʱ/4
  * 			EWDT_CLK_DIV8 		: EWDTCLKΪѡʱ/8
  * 			EWDT_CLK_DIV16 		: EWDTCLKΪѡʱ/16
  * 			EWDT_CLK_DIV32 		: EWDTCLKΪѡʱ/32
  * 			EWDT_CLK_DIV64 		: EWDTCLKΪѡʱ/64
  * 			EWDT_CLK_DIV128 	: EWDTCLKΪѡʱ/128
  * 			EWDT_CLK_DIV256 	: EWDTCLKΪѡʱ/256
  * 			EWDT_CLK_DIV512 	: EWDTCLKΪѡʱ/512
  * 			EWDT_CLK_DIV1024 	: EWDTCLKΪѡʱ/1024
  * 			EWDT_CLK_DIV2048 	: EWDTCLKΪѡʱ/2048
  * 			EWDT_CLK_DIV4096 	: EWDTCLKΪѡʱ/4096
  * 			EWDT_CLK_DIV8192 	: EWDTCLKΪѡʱ/8192
  * 			EWDT_CLK_DIV16384 	: EWDTCLKΪѡʱ/16384
  * 			EWDT_CLK_DIV32768 	: EWDTCLKΪѡʱ/32768
  * 			EWDT_CLK_DIV65536 	: EWDTCLKΪѡʱ/65536
  * 			EWDT_CLK_DIV131072 	: EWDTCLKΪѡʱ/131072
  * 			EWDT_CLK_DIV262144 	: EWDTCLKΪѡʱ/262144
  *   
  */
void
EWDT_Clock_Div_Select(uint32_t CLK_DIV)
{
	uint32_t tmpreg = 0;

	/* У */
	CHECK_RESTRICTION(CHECK_EWDT_CLK_DIV(CLK_DIV));

	tmpreg = CLK_DIV << EWDT_CTL_WPS0_POS;
	EWDT_CTL = SFR_Config(EWDT_CTL, ~EWDT_CTL_WPS, tmpreg);
}

/**
  *  EWDTINźżѡ
  *   Select : 	EWDT_INTPUT_EFFECTIVE_LOW : EWDTINźŵЧ
  * 	 			EWDT_INTPUT_EFFECTIVE_HIGH : EWDTINźŸЧ
  *   ޡ
  */
void
EWDT_Input_Effective_Single_Select(uint32_t Select)
{
	uint32_t tmpreg = 0;

	/* У */
	CHECK_RESTRICTION(CHECK_EWDT_INTPUT_EFFECTIVE(Select));

	tmpreg = Select << EWDT_CTL_EWDTIN_POL_POS;
	EWDT_CTL = SFR_Config(EWDT_CTL, ~EWDT_CTL_EWDTIN_POL, tmpreg);
}

/**
  *  EWDTINźʹܡ
  *   NewState : 	TRUE : EWDTINźδʹ
  * 	 			FALSE : EWDTINźδʹ
  *   ޡ
  */
void
EWDT_Input_Single_Enable(FunctionalState NewState)
{
	uint32_t tmpreg = 0;

	/* У */
	CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

	tmpreg = NewState << EWDT_CTL_EWDTIN_EN_POS;
	EWDT_CTL = SFR_Config(EWDT_CTL, ~EWDT_CTL_EWDTIN_EN, tmpreg);
}

/**
  *   EWDTЧźżѡ
  *   Select : 	EWDT_RESET_EFFECTIVE_LOW : EWDTĸλźŵЧ
  * 	 			EWDT_RESET_EFFECTIVE_HIGH : EWDTĸλźŸЧ
  *   ޡ
  */
void
EWDT_Output_Effective_Single_Select(uint32_t Select)
{
	uint32_t tmpreg = 0;

	/* У */
	CHECK_RESTRICTION(CHECK_EWDT_RESET_EFFECTIVE(Select));

	tmpreg = Select << EWDT_CTL_OUTSEL_POS;
	EWDT_CTL = SFR_Config(EWDT_CTL, ~EWDT_CTL_OUTSEL, tmpreg);
}

/**
  *   ΧŹ´á
  *   Threshold : Threshold <= 0x3F
  *   
  */
void
EWDT_Threshold_Config(uint32_t Threshold)
{
	uint32_t tmpreg = 0;

	/* У */
	CHECK_RESTRICTION(CHECK_EWDT_THRESHOLD(Threshold));

	tmpreg = Threshold << EWDT_CTL_WW0_POS;
	EWDT_CTL = SFR_Config(EWDT_CTL, ~EWDT_CTL_WW, tmpreg);
}

/**
  *  ΧŹʹܡ
  *   NewState : 	TRUE : ʹΧŹ
  * 	 			FALSE : ֹΧŹ
  *   ޡ
  */
void
EWDT_Enable(FunctionalState NewState)
{
	/* У */
	CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

	EWDT_CTL = SFR_Config(EWDT_CTL, ~EWDT_CTL_EWDTEN, NewState);
}

/**
  *  ȡΧŹֵ
  *  
  *   EWDTļֵ
  */
uint8_t
EWDT_Get_Count_Value(void)
{
	return (EWDT_CNT & EWDT_CNT_WT0);
}

/**
  *  ΧŹֵ
  *  Value  Value <= 0x3F
  *   ޡ
  */
void
EWDT_Set_Count_Value(uint8_t Value)
{
	/* У */
	CHECK_RESTRICTION(CHECK_EWDT_COUNT_VALUE(Value));

	EWDT_CNT = SFR_Config(EWDT_CNT, ~EWDT_CNT_WT0, Value);
}


/**
  *   ##### ΧŹ(EWDT)жϺ #####
  */


/**
  *   EWDTλźжʹܡ
  *   NewState  	TRUE  ʹEWDTλźŴж
  * 					FALSE  ֹEWDTλźŴж
  *   
  */
void
EWDT_Reset_Single_INT_Enable(FunctionalState NewState)
{
	uint32_t tmpreg = 0;

	/* У */
	CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

	tmpreg = NewState << EWDT_CTL_EWDTRSTIE_POS;
	EWDT_CTL = SFR_Config(EWDT_CTL, ~EWDT_CTL_EWDTRSTIE, tmpreg);
}

/**
  *  40ʱжʹܡ
  *   NewState : 	TRUE : 40ʱж
  * 	 			FALSE : ֹ40ʱж
  *   ޡ
  */
void
EWDT_Count40_INT_Enable(FunctionalState NewState)
{
	uint32_t tmpreg = 0;

	/* У */
	CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

	tmpreg = NewState << EWDT_CTL_WT40IE_POS;
	EWDT_CTL = SFR_Config(EWDT_CTL, ~EWDT_CTL_WT40IE, tmpreg);
}

/**
  *   ȡEWDTλʱжϱ־
  *   
  *   0  EWDTδλ
  * 	 1 : EWDTλ
  */
FlagStatus
EWDT_Get_Reset_INT_Flag(void)
{
	return ((EWDT_CTL & EWDT_CTL_EWDTRSTIF) >> EWDT_CTL_EWDTRSTIF_POS);
}

/**
  *   ȡΧŹ40жϱ־
  *   
  *   
  */
FlagStatus
EWDT_Get_Count40_INT_Flag(void)
{
	return ((EWDT_CTL & EWDT_CTL_WT40IF) >> EWDT_CTL_WT40IF_POS);
}

/**
  *   EWDTλʱжϱ־
  *   
  *   
  */
void
EWDT_Clear_Reset_INT_Flag(void)
{
	SFR_SET_BIT_ASM(EWDT_CTL, EWDT_CTL_EWDTRSTIC_POS);
	while(EWDT_CTL & EWDT_CTL_EWDTRSTIF);
	SFR_CLR_BIT_ASM(EWDT_CTL, EWDT_CTL_EWDTRSTIC_POS);
}

/**
  *   40ʱжϱ־λ
  *   
  *   
  */
void
EWDT_Clear_Count40_INT_Flag(void)
{
	SFR_SET_BIT_ASM(EWDT_CTL, EWDT_CTL_WW40IC_POS);
	while(EWDT_CTL & EWDT_CTL_WT40IF);
	SFR_CLR_BIT_ASM(EWDT_CTL, EWDT_CTL_WW40IC_POS);
}


