/*
    FreeRTOS V9.0.0 - Copyright (C) 2016 Real Time Engineers Ltd.
    All rights reserved

    VISIT http://www.FreeRTOS.org TO ENSURE YOU ARE USING THE LATEST VERSION.

    This file is part of the FreeRTOS distribution.

    FreeRTOS is free software; you can redistribute it and/or modify it under
    the terms of the GNU General Public License (version 2) as published by the
    Free Software Foundation >>>> AND MODIFIED BY <<<< the FreeRTOS exception.

    ***************************************************************************
    >>!   NOTE: The modification to the GPL is included to allow you to     !<<
    >>!   distribute a combined work that includes FreeRTOS without being   !<<
    >>!   obliged to provide the source code for proprietary components     !<<
    >>!   outside of the FreeRTOS kernel.                                   !<<
    ***************************************************************************

    FreeRTOS is distributed in the hope that it will be useful, but WITHOUT ANY
    WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
    FOR A PARTICULAR PURPOSE.  Full license text is available on the following
    link: http://www.freertos.org/a00114.html

    ***************************************************************************
     *                                                                       *
     *    FreeRTOS provides completely free yet professionally developed,    *
     *    robust, strictly quality controlled, supported, and cross          *
     *    platform software that is more than just the market leader, it     *
     *    is the industry's de facto standard.                               *
     *                                                                       *
     *    Help yourself get started quickly while simultaneously helping     *
     *    to support the FreeRTOS project by purchasing a FreeRTOS           *
     *    tutorial book, reference manual, or both:                          *
     *    http://www.FreeRTOS.org/Documentation                              *
     *                                                                       *
    ***************************************************************************

    http://www.FreeRTOS.org/FAQHelp.html - Having a problem?  Start by reading
    the FAQ page "My application does not run, what could be wrong?".  Have you
    defined configASSERT()?

    http://www.FreeRTOS.org/support - In return for receiving this top quality
    embedded software for free we request you assist our global community by
    participating in the support forum.

    http://www.FreeRTOS.org/training - Investing in training allows your team to
    be as productive as possible as early as possible.  Now you can receive
    FreeRTOS training directly from Richard Barry, CEO of Real Time Engineers
    Ltd, and the world's leading authority on the world's leading RTOS.

    http://www.FreeRTOS.org/plus - A selection of FreeRTOS ecosystem products,
    including FreeRTOS+Trace - an indispensable productivity tool, a DOS
    compatible FAT file system, and our tiny thread aware UDP/IP stack.

    http://www.FreeRTOS.org/labs - Where new FreeRTOS products go to incubate.
    Come and try FreeRTOS+TCP, our new open source TCP/IP stack for FreeRTOS.

    http://www.OpenRTOS.com - Real Time Engineers ltd. license FreeRTOS to High
    Integrity Systems ltd. to sell under the OpenRTOS brand.  Low cost OpenRTOS
    licenses offer ticketed support, indemnification and commercial middleware.

    http://www.SafeRTOS.com - High Integrity Systems also provide a safety
    engineered and independently SIL3 certified version for use in safety and
    mission critical applications that require provable dependability.

    1 tab == 4 spaces!
*/

/*-----------------------------------------------------------
 * Ϊʵporttable.hĹܶKF32ӿ
 *----------------------------------------------------------*/
// #include "uart.h"	//debug
/* Scheduler includes. */
/*ͷļ*/
#include "FreeRTOS.h"
#include "task.h"

uint32_t RTOSSYSTEM_ERROR;

#if configMAX_SYSCALL_INTERRUPT_PRIORITY == 0
	#error configMAX_SYSCALL_INTERRUPT_PRIORITY must not be set to 0.
#endif

#ifndef configSYSTICK_CLOCK_HZ
	#define configSYSTICK_CLOCK_HZ configCPU_CLOCK_HZ
	/* ȷRTOSϵͳʱCPUƵͬ*/
	#define portNVIC_SYSTICK_CLK_BIT	( 1UL << 2UL )
#else
	/*ڲͬ£޸SysTickʱ*/
	#define portNVIC_SYSTICK_CLK_BIT	( 0 )
#endif

/* ҪԼvPortSetupTimerInterrupt1Ĭ϶Ϊ0
 * */
#ifndef configOVERRIDE_DEFAULT_TICK_CONFIGURATION
	#define configOVERRIDE_DEFAULT_TICK_CONFIGURATION 0
#endif

/* ļĴ*/
#define portST_CTL_REG						( * ( ( volatile uint32_t * ) 0x402000A0 ) )//ϵͳĶʱƼĴ
#define portST_RELOAD_REG					( * ( ( volatile uint32_t * ) 0x402000A4 ) )//ϵͳĶʱؼؼĴ
#define portST_CV_REG						( * ( ( volatile uint32_t * ) 0x402000A8 ) )//ϵͳĶʱ
#define portINT_IP2_REG						( * ( ( volatile uint32_t * ) 0x4020003C ) )//жȼĴ2жϺͽĶʱжϣ

/* Ĵıλ*/
#define portST_CTL_TICKINTEN				( 1UL << 1UL	)//Ķʱжʹ
#define portST_CTL_STEN						( 1UL << 0UL	)//Ķʱʹ
#define portST_CTL_COUNTZERO				( 1UL << 16UL	)//ʱ0ʱλ1

//жȼ
#define portINT_SOFTSV_PRI					( ( ( uint32_t ) configKERNEL_INTERRUPT_PRIORITY ) << 16UL )
#define portINT_SYSTICK_PRI					( ( ( uint32_t ) configKERNEL_INTERRUPT_PRIORITY ) << 24UL )

/* ڼжȼȷԵĳ */
#define portFIRST_USER_INTERRUPT_NUMBER		( 16			)							//һûж
#define portINT_IP							( 0x40200030	)							//жȼ0Ĵ
#define portINT_CTL0						( * ( ( volatile uint32_t * ) 0x40200000 ) )//жϿƼĴ
#define portMAX_8_BIT_VALUE					( ( uint8_t ) 0xff	)						//8صֵ
#define portTOP_BIT_OF_BYTE					( ( uint8_t ) 0x80	)						//ֽ߱
#define portMAX_PRIGROUP_BITS				( ( uint8_t ) 3 	)						//ȼֵ
#define portPRIORITY_GROUP_MASK				( 0x03UL << 1UL		)						//ȼ
#define portPRIGROUP_SHIFT					( 1UL 				)						//ȼλ

/* ʼջ*/
#define portINITIAL_EXEC_RETURN		( 0xfffffffd )

/* 24λϵͳ*/
#define portMAX_24_BIT_NUMBER		( 0xffffffUL )

/* SysTickticklessмʱֹͣʱһfiddleȥSysTickֵ*/
#define portMISSED_COUNTS_FACTOR	( 45UL )

/* ַ룬ж뵽PCʱ0λ0*/
#define portSTART_ADDRESS_MASK		( ( StackType_t ) 0xfffffffeUL )

/* ٽǶױʹÿ񱣳Լж״̬*/
volatile static UBaseType_t uxCriticalNesting = 0xaaaaaaaa;

/* öʱжϡ*/
void vPortSetupTimerInterrupt( void );

/* ʼһ룬ܹ*/
static void prvStartFirstTask( void );

/* ˳ڿߴ˳ʱá*/
static void prvTaskExitError( void );

/*-----------------------------------------------------------*/

/* һµSysTick*/
#if configUSE_TICKLESS_IDLE == 1
	static uint32_t ulTimerCountsForOneTick = 0;
#endif /* configUSE_TICKLESS_IDLE */

/*24SysTickʱĵ*/
#if configUSE_TICKLESS_IDLE == 1
	static uint32_t xMaximumPossibleSuppressedTicks = 0;
#endif /* configUSE_TICKLESS_IDLE */

/* SysTickֹͣʱ(͹)ݲCPU*/
#if configUSE_TICKLESS_IDLE == 1
	static uint32_t ulStoppedTimerCompensation = 0;
#endif /* configUSE_TICKLESS_IDLE */

/* portASSERT_IF_INTERRUPT_PRIORITY_INVALID()֮ǰȥʹã
 * ȷFreeRTOSAPIʹ÷ȼֵ
 * (configMAX_SYSCALL_INTERRUPT_PRIORITY)Ҫж*/
#if ( configASSERT_DEFINED == 1 )
	/* ϵͳȼ*/
	static uint8_t ucMaxSysCallPriority = 0;
	/* ȼֵ*/
	static uint32_t ulMaxPRIGROUPValue = 0;
	/* жȼĴ*/
	static const volatile uint8_t * const pcInterruptPriorityRegisters = ( uint8_t * ) portINT_IP;
#endif /* configASSERT_DEFINED */

/*-----------------------------------------------------------*/

/* ջȿͨջн̡ͨüĴᱻöջ
 * */
StackType_t *pxPortInitialiseStack( StackType_t *pxTopOfStack, TaskFunction_t pxCode, void *pvParameters )
{
	/* xPSR */
	pxTopOfStack--;
	*pxTopOfStack = 0x0000ff00;

	/* ĴPCʼΪpxCode*/
	pxTopOfStack--;
	*pxTopOfStack = ( ( StackType_t ) pxCode ) & portSTART_ADDRESS_MASK;	/* PC */

	/* ĴLRʼΪprvTaskExitError*/
	pxTopOfStack--;
	*pxTopOfStack = ( StackType_t ) prvTaskExitError;	/* LR */

	/* ĴR4,R3,R2,R1,R0*/
	pxTopOfStack -= 5;//4ĴR4,R3,R2,R1
	*pxTopOfStack = ( StackType_t ) pvParameters;	/* R0 */

	/*EXC_RETURNֵ˳SVCSoftSVжϵʱӦôʲô״̬쳣ж
	 * ISRʱӼĴR14(LR)ֵᱻΪEXC_RETURNֵֵ֮쳣
	 * ʱ쳣ءΪΪ0xFFFFFFFDʾ˳쳣ԺCPU߳ģʽʹýջ*/
	pxTopOfStack--;
	*pxTopOfStack = portINITIAL_EXEC_RETURN;/* 0xFFFF FFFD */

	/* R12,R11,R10,R9,R8,R7,R6,R5*/
	pxTopOfStack -= 8;
	return pxTopOfStack;
}
/*-----------------------------------------------------------*/
//˳
/*
 * ͨ£ߵ˳ҪǰҲʹvTaskDelete(NULL)
 * configASSERT()Զһassert()Ϳͣڣ߿ڻȡϢ
 * */
static void prvTaskExitError( void )
{
	configASSERT( uxCriticalNesting == ~0UL );
	portDISABLE_INTERRUPTS();
	for( ;; );
}
/*-----------------------------------------------------------*/
/* SVCжϷ*/
/* ãڵһ񣬺òSVCˡ
 * */
void __attribute__((interrupt)) _SVC_exception (void)
{
	/* SVCж̽
	 * 1һR5-R13Ƴ
	 * 2ָлΪһĶջ
	 * 3жΣʹж
	 * */
	//************ жϳ    *******************************
	/*1һR5-R13Ƴ*/
	asm(".extern pxCurrentTCB"			);
	asm("MOV R3,#pxCurrentTCB"			);
	asm("LD.w R1,[R3]"					);//R3ֵַָR1
	asm("LD.w R0,[R1]"					);
	asm("LD.w R5,[R0++]"				);//ǽR0ָĵֵַĴ
	asm("LD.w R6,[R0++]"				);
	asm("LD.w R7,[R0++]"				);
	asm("LD.w R8,[R0++]"				);
	asm("LD.w R9,[R0++]"				);
	asm("LD.w R10,[R0++]"				);
	asm("LD.w R11,[R0++]"				);
	asm("LD.w R12,[R0++]"				);
	asm("LD.w R13,[R0++]"				);
	/*2ָлΪһĶջ*/
	asm("MOV PSP,R0"					);//MSPַָָջ
	asm("NOP"							);
	/*3жΣʹж*/
	asm("MOV R0,#0"						);
	asm("LSL R0,#8"						);//ȼ8λ
	asm("MOV R1,#0xFFFF00FF"			);
	asm("MOV R2,#0x40200000"			);
	asm("LD.w R3,[R2]"					);//ȡĴֵ
	asm("ANL R3,R1"						);//ȥԭֵ
	asm("ORL R3,R0"						);//ֵ
	asm("ST.w [R2],R3"					);//Ĵ
	/*ж˳ݷֵ0xFFFFFFFDԶлָΪPSPеһ*/
}
/*-----------------------------------------------------------*/
/*ʹSVCжϣһ*/
void prvStartFirstTask( void )
{
	asm("MOV R0,#0x402000BC"		);//ƫƼĴ
	asm("LD.w R0,[R0]"				);//ַ
	asm("LD.w R0,[R0]"				);//жΪ0ĵַ
	asm("MOV MSP,R0"				);//ַMSP
	asm("ENI"						);//ʹж
	asm("NOP"						);//
	asm("SVC"						);//ʹSVCж
	asm("NOP"						);
	asm("NOP"						);
}
/* Ӳ
 * SysTickжϣжȼͼֵûƥжƵʡ
 * SoftSVжȼ*/
BaseType_t xPortStartScheduler( void )
{
	/*ϵͳжȼУ*/
	configASSERT( configMAX_SYSCALL_INTERRUPT_PRIORITY );


	#if( configASSERT_DEFINED == 1 )
	{
		volatile uint32_t ulOriginalPriority;
		/*һûʹõȼĴ*/
		volatile uint8_t * const pucFirstUserPriorityRegister = ( uint8_t * ) ( portINT_IP + portFIRST_USER_INTERRUPT_NUMBER );
		volatile uint8_t ucMaxPriorityValue;

		/* ȷжȼʹáISRȫغꡢ"FromISR"βFreeRTOSϵͳ
		̺߳ISRӦýӿڣAPIȷжϼ*/
		ulOriginalPriority = *pucFirstUserPriorityRegister;

		/* ȷȼıλһдпܵıλ0xFF*/
		*pucFirstUserPriorityRegister = portMAX_8_BIT_VALUE;

		/* мλڸǣ0xF0*/
		ucMaxPriorityValue = *pucFirstUserPriorityRegister;

		/* жȼΪȼ*/
		configASSERT( ucMaxPriorityValue == ( configKERNEL_INTERRUPT_PRIORITY & ucMaxPriorityValue ) );

		/* ͬΪϵͳȼ*/
		ucMaxSysCallPriority = configMAX_SYSCALL_INTERRUPT_PRIORITY & ucMaxPriorityValue;

		/* ȼ鲢ֵ*/
		ulMaxPRIGROUPValue = portMAX_PRIGROUP_BITS;
		ucMaxPriorityValue &= 0xE0;//ռȼΪ3λ
		while( ( ucMaxPriorityValue & portTOP_BIT_OF_BYTE ) == portTOP_BIT_OF_BYTE )
		{
			ulMaxPRIGROUPValue--;
			ucMaxPriorityValue <<= ( uint8_t ) 0x01;
		}

		/* λȼ鲢׼ֵĴ*/
		ulMaxPRIGROUPValue <<= portPRIGROUP_SHIFT;
		ulMaxPRIGROUPValue &= portPRIORITY_GROUP_MASK;

		/* ָ޸ĵȼΪԭֵ*/
		*pucFirstUserPriorityRegister = ulOriginalPriority;
	}
	#endif /* conifgASSERT_DEFINED */

	/* ʹSoftSVSysTickΪȼ*/
	portINT_IP2_REG |= portINT_SOFTSV_PRI;
	portINT_IP2_REG |= portINT_SYSTICK_PRI;

	/*õδʱжڣʹж*/
	vPortSetupTimerInterrupt();

	/*ʼٽǶ׼*/
	uxCriticalNesting = 0;

	/* ʼһ*/
	prvStartFirstTask();

	/*Ӧе⣬е˵û*/
	return 0;
}
/*-----------------------------------------------------------*/
/* ȡѾͨxPortStartScheduler()ִеӲ/жϷãȳִֹͣк
 * Ӳԭʼ״̬
 * ӲرжϵĴڹرʹá
 * */
void vPortEndScheduler( void )
{
	configASSERT( uxCriticalNesting == 1000UL );
}
/*-----------------------------------------------------------*/
//ٽ
void vPortEnterCritical( void )
{
	portDISABLE_INTERRUPTS();
	uxCriticalNesting++;

	/* This is not the interrupt safe version of the enter critical function so
	assert() if it is being called from an interrupt context.  Only API
	functions that end in "FromISR" can be used in an interrupt.  Only assert if
	the critical nesting count is 1 to protect against recursive calls if the
	assert function also uses a critical section. */
	/* ⲻǽٽ繦ܵжϰȫ汾Ծ˴жʹassert()
	 * ֻFromISRβжϵAPIٽǶ׼(uxCriticalNesting)Ϊ1ʱ
	 * ȥ֤һٽѡʱԵݹԵĳ*/
//	if( uxCriticalNesting == 1 )
//	{
//		֤ǰжǷ0
//		configASSERT( ( portNVIC_INT_CTRL_REG & portVECTACTIVE_MASK ) == 0 );
//		/* ȴȶ*/
//	}
}
/*-----------------------------------------------------------*/
//˳ٽ
void vPortExitCritical( void )
{
	configASSERT( uxCriticalNesting );
	uxCriticalNesting--;
	if( uxCriticalNesting == 0 )
	{
		portENABLE_INTERRUPTS();
	}
}
/*-----------------------------------------------------------*/
/* SoftSVжϷ
 * лҲǺĵһжϷ
 * */

void __attribute__((interrupt)) _SoftSV_exception (void)
{
	/*
	 * жϾִǣ
	 * 1ѹջǰ
	 * 2رжϣȡһ
	 * 3ж
	 * 4ջһ
	 * */	/*һֲ̬configMAX_SYSCALL_INTERRUPT_PRIORITYú׺֣Ƕе*/
//	asm(".extern uxCriticalNesting");
	asm(".extern pxCurrentTCB");
	asm(".extern vTaskSwitchContext");
	/* 1ѹջǰ*/
	asm("MOV R0,PSP"                    );
	asm("MOV R3,#pxCurrentTCB"          );//ȡǰTCBַ
	asm("LD.w R2,[R3]"					);//ǰĵһ(ջָ)R2
	//R5-R13
	asm("SUB R0,#4");
	asm("ST.w [R0],R13");
	asm("SUB R0,#4");
	asm("ST.w [R0],R12");
	asm("SUB R0,#4");
	asm("ST.w [R0],R11");
	asm("SUB R0,#4");
	asm("ST.w [R0],R10");
	asm("SUB R0,#4");
	asm("ST.w [R0],R9");
	asm("SUB R0,#4");
	asm("ST.w [R0],R8");
	asm("SUB R0,#4");
	asm("ST.w [R0],R7");
	asm("SUB R0,#4");
	asm("ST.w [R0],R6");
	asm("SUB R0,#4");
	asm("ST.w [R0],R5");
	asm("ST.w [R2],R0");//ǰĶջָ
	/* 2رжϣȡһ*/
	asm("MOV R0,#%0"::"g"(configMAX_SYSCALL_INTERRUPT_PRIORITY));
	asm("LSL R0,#8"						);//ȼ8λ
	asm("MOV R1,#0xFFFF00FF"			);//жķ
	asm("MOV R2,#0x40200000"			);//жϿƼĴ
	asm("LD.w R3,[R2]"					);//ȡĴֵ
	asm("ANL R3,R1"						);//ȥԭֵ
	asm("ORL R3,R0"						);//ֵ
	asm("ST.w [R2],R3"					);//Ĵ
	asm("MOV R2,#vTaskSwitchContext"    );
	asm("LJMP R2"                       );//úvTaskSwitchContext()
	/* 3ж*/
	asm("MOV R0,#0"                     );//ж
	asm("LSL R0,#8"						);//ȼ8λ
	asm("MOV R1,#0xFFFF00FF"			);
	asm("MOV R2,#0x40200000"			);
	asm("LD.w R3,[R2]"					);//ȡĴֵ
	asm("ANL R3,R1"						);//ȥԭֵ
	asm("ORL R3,R0"						);//ֵ
	asm("ST.w [R2],R3"					);//Ĵ
	/* ջһ*/
	asm("MOV R3,#pxCurrentTCB"          );//ȡǰTCBַ
	asm("LD.w R1,[R3]"                  );//R3ֵָµ
	asm("LD.w R0,[R1]"                  );//ȡĶջ
	asm("LD.w R5,[R0++]"                );//ջR5-R13
	asm("LD.w R6,[R0++]"                );
	asm("LD.w R7,[R0++]"                );
	asm("LD.w R8,[R0++]"                );
	asm("LD.w R9,[R0++]"                );
	asm("LD.w R10,[R0++]"               );
	asm("LD.w R11,[R0++]"               );
	asm("LD.w R12,[R0++]"               );
	asm("LD.w R13,[R0++]"               );
	asm("MOV PSP,R0"                    );
	asm("NOP"                          );
	/*ж˳ԶR0-R4,PC,LR,xPSRֵ*/
}

/*
 * SysTickжϷ
 * */
void __attribute__((interrupt)) _SysTick_exception (void)
{
	/*رж*/
	vPortRaiseBASEPRI();
	{
		/* Ӽֵ */
		if( xTaskIncrementTick() != pdFALSE )//ʱӼxTickCountֵ
		{
			/* ͨжϿƺ״̬ĴICSRbit28д1SoftSVSoftSVжϡ
			 * ͿSoftSVжϷнл*/
			portNVIC_INT_CTRL_REG = portNVIC_SOFTSVSET_BIT;
		}
	}
	vPortClearBASEPRIFromISR();//ж
}
/*-----------------------------------------------------------*/
/* е͹ģʽ
 * δ
 * */
#if configUSE_TICKLESS_IDLE == 1

//	__weak void vPortSuppressTicksAndSleep( TickType_t xExpectedIdleTime )
//	{
//	uint32_t ulReloadValue, ulCompleteTickPeriods, ulCompletedSysTickDecrements, ulSysTickCTRL;
//	TickType_t xModifiableIdleTime;
//
//		/* Make sure the SysTick reload value does not overflow the counter. */
//		if( xExpectedIdleTime > xMaximumPossibleSuppressedTicks )
//		{
//			xExpectedIdleTime = xMaximumPossibleSuppressedTicks;
//		}
//
//		/* Stop the SysTick momentarily.  The time the SysTick is stopped for
//		is accounted for as best it can be, but using the tickless mode will
//		inevitably result in some tiny drift of the time maintained by the
//		kernel with respect to calendar time. */
//		portST_CTL_REG &= ~portST_CTL_STEN;
//
//		/* Calculate the reload value required to wait xExpectedIdleTime
//		tick periods.  -1 is used because this code will execute part way
//		through one of the tick periods. */
//		ulReloadValue = portST_CV_REG + ( ulTimerCountsForOneTick * ( xExpectedIdleTime - 1UL ) );
//		if( ulReloadValue > ulStoppedTimerCompensation )
//		{
//			ulReloadValue -= ulStoppedTimerCompensation;
//		}
//
//		/* Enter a critical section but don't use the taskENTER_CRITICAL()
//		method as that will mask interrupts that should exit sleep mode. */
//
//		__disable_irq();
//		__dsb( portSY_FULL_READ_WRITE );
//		__isb( portSY_FULL_READ_WRITE );
//
//		/* If a context switch is pending or a task is waiting for the scheduler
//		to be unsuspended then abandon the low power entry. */
//		if( eTaskConfirmSleepModeStatus() == eAbortSleep )
//		{
//			/* Restart from whatever is left in the count register to complete
//			this tick period. */
//			portST_RELOAD_REG = portST_CV_REG;
//
//			/* Restart SysTick. */
//			portST_CTL_REG |= portST_CTL_STEN;
//
//			/* Reset the reload register to the value required for normal tick
//			periods. */
//			portST_RELOAD_REG = ulTimerCountsForOneTick - 1UL;
//
//			/* Re-enable interrupts - see comments above __disable_irq() call
//			above. */
//			__enable_irq();
//		}
//		else
//		{
//			/* Set the new reload value. */
//			portST_RELOAD_REG = ulReloadValue;
//
//			/* Clear the SysTick count flag and set the count value back to
//			zero. */
//			portST_CV_REG = 0UL;
//
//			/* Restart SysTick. */
//			portST_CTL_REG |= portST_CTL_STEN;
//
//			/* Sleep until something happens.  configPRE_SLEEP_PROCESSING() can
//			set its parameter to 0 to indicate that its implementation contains
//			its own wait for interrupt or wait for event instruction, and so wfi
//			should not be executed again.  However, the original expected idle
//			time variable must remain unmodified, so a copy is taken. */
//			xModifiableIdleTime = xExpectedIdleTime;
//			configPRE_SLEEP_PROCESSING( xModifiableIdleTime );
//			if( xModifiableIdleTime > 0 )
//			{
//				/****************/
//				__dsb( portSY_FULL_READ_WRITE );
//				__wfi();
//				__isb( portSY_FULL_READ_WRITE );
//			}
//			configPOST_SLEEP_PROCESSING( xExpectedIdleTime );
//
//			/* Stop SysTick.  Again, the time the SysTick is stopped for is
//			accounted for as best it can be, but using the tickless mode will
//			inevitably result in some tiny drift of the time maintained by the
//			kernel with respect to calendar time. */
//			ulSysTickCTRL = portST_CTL_REG;
//			portST_CTL_REG = ( ulSysTickCTRL & ~portST_CTL_STEN );
//
//			/* Re-enable interrupts - see comments above __disable_irq() call
//			above. */
//			__enable_irq();
//
//			if( ( ulSysTickCTRL & portST_CTL_COUNTZERO ) != 0 )
//			{
//				uint32_t ulCalculatedLoadValue;
//
//				/* The tick interrupt has already executed, and the SysTick
//				count reloaded with ulReloadValue.  Reset the
//				portST_RELOAD_REG with whatever remains of this tick
//				period. */
//				ulCalculatedLoadValue = ( ulTimerCountsForOneTick - 1UL ) - ( ulReloadValue - portST_CV_REG );
//
//				/* Don't allow a tiny value, or values that have somehow
//				underflowed because the post sleep hook did something
//				that took too long. */
//				if( ( ulCalculatedLoadValue < ulStoppedTimerCompensation ) || ( ulCalculatedLoadValue > ulTimerCountsForOneTick ) )
//				{
//					ulCalculatedLoadValue = ( ulTimerCountsForOneTick - 1UL );
//				}
//
//				portST_RELOAD_REG = ulCalculatedLoadValue;
//
//				/* The tick interrupt handler will already have pended the tick
//				processing in the kernel.  As the pending tick will be
//				processed as soon as this function exits, the tick value
//				maintained by the tick is stepped forward by one less than the
//				time spent waiting. */
//				ulCompleteTickPeriods = xExpectedIdleTime - 1UL;
//			}
//			else
//			{
//				/* Something other than the tick interrupt ended the sleep.
//				Work out how long the sleep lasted rounded to complete tick
//				periods (not the ulReload value which accounted for part
//				ticks). */
//				ulCompletedSysTickDecrements = ( xExpectedIdleTime * ulTimerCountsForOneTick ) - portST_CV_REG;
//
//				/* How many complete tick periods passed while the processor
//				was waiting? */
//				ulCompleteTickPeriods = ulCompletedSysTickDecrements / ulTimerCountsForOneTick;
//
//				/* The reload value is set to whatever fraction of a single tick
//				period remains. */
//				portST_RELOAD_REG = ( ( ulCompleteTickPeriods + 1UL ) * ulTimerCountsForOneTick ) - ulCompletedSysTickDecrements;
//			}
//
//			/* Restart SysTick so it runs from portST_RELOAD_REG
//			again, then set portST_RELOAD_REG back to its standard
//			value.  The critical section is used to ensure the tick interrupt
//			can only execute once in the case that the reload register is near
//			zero. */
//			portST_CV_REG = 0UL;
//			portENTER_CRITICAL();
//			{
//				portST_CTL_REG |= portST_CTL_STEN;
//				vTaskStepTick( ulCompleteTickPeriods );
//				portST_RELOAD_REG = ulTimerCountsForOneTick - 1UL;
//			}
//			portEXIT_CRITICAL();
//		}
//	}

#endif /* #if configUSE_TICKLESS_IDLE */

/*-----------------------------------------------------------*/

//ýĶʱĽĶж
#if configOVERRIDE_DEFAULT_TICK_CONFIGURATION == 0

	void vPortSetupTimerInterrupt( void )
	{
		/* ýĶʱж*/
		#if configUSE_TICKLESS_IDLE == 1
		{
			ulTimerCountsForOneTick = ( configSYSTICK_CLOCK_HZ / configTICK_RATE_HZ );
			xMaximumPossibleSuppressedTicks = portMAX_24_BIT_NUMBER / ulTimerCountsForOneTick;
			ulStoppedTimerCompensation = portMISSED_COUNTS_FACTOR / ( configCPU_CLOCK_HZ / configSYSTICK_CLOCK_HZ );
		}
		#endif /* configUSE_TICKLESS_IDLE */
		/* ýĶʱĴ*/
		portST_CV_REG = 0;
		portST_RELOAD_REG = ( configSYSTICK_CLOCK_HZ / configTICK_RATE_HZ ) - 1UL;
		portST_CTL_REG = ( portNVIC_SYSTICK_CLK_BIT | portST_CTL_TICKINTEN | portST_CTL_STEN );
	}

	void vPortUpdateTimerTick( void )
	{
		if(portST_CTL_REG != 0){
			portST_RELOAD_REG = ( configSYSTICK_CLOCK_HZ / configTICK_RATE_HZ ) - 1UL;
			portST_CTL_REG = ( portNVIC_SYSTICK_CLK_BIT | portST_CTL_TICKINTEN | portST_CTL_STEN );
		}
	}
#endif /* configOVERRIDE_DEFAULT_TICK_CONFIGURATION */
/*-----------------------------------------------------------*/
/* ȡǰڴж*/
uint32_t __attribute__((noinline)) vPortGetIPSR(void)
{
	asm("MOV R1,#0x40200000"		);//жϿƼĴ
	asm("MOV R2,#0x7F000000"		);//ж
	asm("LD.w R1,[R1]"				);//ȡĴֵ
	asm("ANL R1,R2"					);//ȡӦֵ
	asm("MOV R2,#24"				);
	asm("LSR R0,R1,R2"				);//λֵR0
	asm("JMP LR"					);
}
/*-----------------------------------------------------------*/
#if( configASSERT_DEFINED == 1 )
	/*֤жȼ*/
	void vPortValidateInterruptPriority( void )
	{
	uint32_t ulCurrentInterrupt;
	uint8_t ucCurrentPriority;
		/* ȡж */
		ulCurrentInterrupt = vPortGetIPSR();

		/* ǷΪûж?*/
		if( ulCurrentInterrupt >= portFIRST_USER_INTERRUPT_NUMBER )
		{
			/* жȼĴвжȼ*/
			ucCurrentPriority = pcInterruptPriorityRegisters[ ulCurrentInterrupt ];
			/* һжϷȼconfigMAX_SYSCALL_INTERRUPT_PRIORITY
			 * (FreeRTOSϵͳٻжϵһȼ)ֹͣҪʹ
			 * жȼҪconfigMAX_SYSCALL_INTERRUPT_PRIORITY
			 *
			 * жȼֱȸȼĸߣжȼֵ
			 * configMAX_SYSCALL_INTERRUPT_PRIORITYߡ
			 *
			 * ʹFreeRTOSӦóӿڵжϵȼֵΪĬ0Ӧø
			 * configMAX_SYSCALL_INTERRUPT_PRIORITYȷЧ
			 *
			 * FreeRTOSϵͳ̺߳жAPIֿȷжϽ뾡ܿٺͼࡣ
			 * */
			// MY_MSG("INT_IP9:0x%x",INT_IP9);
			// MY_MSG("\r\nǰж%d,ǰȼ%d,ϵͳȼ%d\r\n",ulCurrentInterrupt,ucCurrentPriority,ucMaxSysCallPriority);
			configASSERT( ucCurrentPriority >= ucMaxSysCallPriority );
		}

		/* ȼ飺жϵͳУжȼλΪռȼȼΪ
		 * ѾܶȼΪռȼһЩbitλΪȼ֤ͻʧܡ
		 *
		 * ֮ǰȼΪռȼΪ0λȼΪ4λ
		 * Ļᵼ²ԤĴ
		 * */
		configASSERT( ( portINT_CTL0 & portPRIORITY_GROUP_MASK ) <= ulMaxPRIGROUPValue );
	}

#endif /* configASSERT_DEFINED */


