/******************************************************************************
 *                  Shanghai ChipON Micro-Electronic Co.,Ltd                  *
 ******************************************************************************
 *  $File Name$       : KF32A156.h                              	            *
 *  $Author$          : ChipON AE/FAE Group                  		  		      *
 *  $Data$            : 2021-07-08                                            *
 *  $AutoSAR Version  : V1.0 	                                       	      *
 *  $Description$     : KF32A156 series peripheral access entry file, 		   *
 *  					including:											                  *
 *  					+ The memory structure of all peripherals			            *
 *  					+ Declaration and definition of registers 			         *
 *  					  and bits for peripherals							               *
 *  					+ An access macro to a peripheral register			         *
 *  					+ Macro for special function register bit 			         *
 *  					  operation instructions							               *
 ******************************************************************************
 *  Copyright (C) by Shanghai ChipON Micro-Electronic Co.,Ltd                 *
 *  All rights reserved.                                                      *
 *                                                                            *
 *  This software is copyrght protected and proprietary to                    *
 *  Shanghai ChipON Micro-Electronic Co.,Ltd.                                 *
 ******************************************************************************
 *  ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~  *
 *                     		REVISON HISTORY                               	   *
 *  ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~  *
 *  Data       Version  Author        Description                             *
 *  ~~~~~~~~~~ ~~~~~~~~ ~~~~~~~~~~~~  ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~  *
 *  										                                             *
 *                                                                            *
 *                                                                            *
 *****************************************************************************/

#ifndef KF32A156_H_
#define KF32A156_H_

#include "stdint.h"

#define _CLOSE_SERVICE_     1

/* ûϵ㹦 */
#define USE_CHECK_ASSERT   0
#if USE_CHECK_ASSERT
   #define CHECK_RESTRICTION(expr) ((expr) ? (void)0 : check_failed((uint8_t *)__FILE__, __LINE__))
   /*  У ------------------------------------------------------- */
   void check_failed(uint8_t* file, uint32_t line);
#else
#define CHECK_RESTRICTION(expr) ((void)0)
#endif /* USE_CHECK_ASSERT */

/* Ĵλʹܿ */
typedef enum
{
	FALSE = 0,
	TRUE = !FALSE
}FunctionalState;
#define CHECK_FUNCTIONAL_STATE(STATE) (((STATE) == FALSE) || (STATE) == TRUE)

/* Ĵλ״̬־ */
typedef enum
{
	RESET = 0,
	SET = !RESET
}FlagStatus, INTStatus;

/* ״̬־ */
typedef enum
{
	FAILURE = 0,
	SUCCESS = !FAILURE
}RetStatus;

/* ʹ״̬־ */
typedef enum
{
	DISABLE = 0,
	ENABLE = !DISABLE
}AbleStatus;

/**
  * TIM־
  */
typedef enum
{
    DIR_DOWN = 0,
    DIR_UP = !DIR_DOWN
} DIRStatus;
#define CHECK_TIMER_DIR(state)          (((state) == DIR_DOWN) \
                                      || ((state) == DIR_UP))

/* ----------------------------------------------------------------------------
   -- ж
   ---------------------------------------------------------------------------- */

/* ж */
typedef enum
{
    INT_Initial_SP              = 0,         /* Initial stack pointer */
    INT_Reset                   = 1,         /* Reset */
    INT_NMI                     = 2,         /* NMI interrupt */
    INT_HardFault               = 3,         /* hard fault exception */
    INT_Reserved4               = 4,         /* Reserved interrupt 4 */
    INT_StackFault              = 5,         /* stack Fault exception */
    INT_AriFault                = 6,         /* arithmetic fault exception */
    INT_Reserved7               = 7,         /* Reserved interrupt 7 */
    INT_Reserved8               = 8,         /* Reserved interrupt 8 */
    INT_Reserved9               = 9,         /* Reserved interrupt 9 */
    INT_Reserved10              = 10,        /* Reserved interrupt 10 */
    INT_SVCAll                  = 11,        /* SVCall interrupt */
    INT_Reserved12              = 12,        /* Reserved interrupt 11 */
    INT_Reserved13              = 13,        /* Reserved interrupt 12 */
    INT_SoftSV                  = 14,        /* SoftSV interrupt */
    INT_SysTick                 = 15,        /* SysTick interrupt */
    INT_WWDT                    = 16,        /* WWDT interrupt */
    INT_EINT16                  = 17,        /* EINT16 interrupt */
    INT_EINT0                   = 18,        /* EINT0 interrupt */
    INT_EINT1                   = 19,        /* EINT1 interrupt */
    INT_EINT2                   = 20,        /* EINT2 interrupt */
    INT_EINT3                   = 21,        /* EINT3 interrupt */
    INT_EINT4                   = 22,        /* EINT4 interrupt */
    INT_EINT9TO5                = 23,        /* EINT<9:5> interrupt */
    INT_EINT15TO10              = 24,        /* EINT<15:10> interrupt */
    INT_T1                      = 25,        /* T1 interrupt */
    INT_T3                      = 26,        /* T3 interrupt */
    INT_T5                      = 27,        /* T5 interrupt */
    INT_T6                      = 28,        /* T6 interrupt */
    INT_QEI0					= 29,
    INT_QEI1					= 30,
    INT_T7						= INT_QEI0,
    INT_T8						= INT_QEI1,
    INT_ECFGL						= 31,
    INT_CAN4					= 32,
    INT_T14						= 33,
    INT_RNG						= 34,
    INT_FDC2					= 35,
    INT_EXIC					= 36,
    INT_ADC0					= 37,
    INT_ADC1					= 38,
    INT_CFGL					= 39,
    INT_T11						= 40,
    INT_T0						= 41,
    INT_DMA0					= 42,
    INT_CMP						= 43,
    INT_USART0					= 44,
    INT_USART1					= 45,
    INT_SPI0					= 46,
    INT_SPI1					= 47,
    INT_DMA1					= 48,
    INT_EINT19TO17				= 49,
    INT_CANFD6				= 50,
    INT_CANFD7				= 51,
    INT_FDC0					= 52,
    INT_FDC1					= 53,
    INT_EINT31TO20				= 54,
    INT_ECC						= 55,
    INT_OSC						= 56,
    INT_CLK						= INT_OSC,
    INT_I2C0					= 57,
    INT_I2C1					= 58,
    INT_I2C2					= 59,
    INT_T12						= 60,
    INT_T2						= 61,
    INT_T4						= 62,
    INT_T13						= 63,
    INT_USART2					= 64,
    INT_T16						= 65,
    INT_USART4					= 66,
    INT_SPI2					= 67,
    INT_SPI3					= 68,
    INT_ADC2					= 69,
    INT_T18						= 70,
    INT_T19						= 71,
    INT_HRCAP0					= 72,
    INT_WKP0					= 73,
    INT_WKP1					= INT_WKP0,
    INT_WKP2					= INT_WKP0,
    INT_WKP3					= INT_WKP0,
    INT_WKP4					= INT_WKP0,
    INT_HRCAP1					= 74,
    INT_T21						= 75,
    INT_I2C3					= 76,
    INT_USART5					= 77,
    INT_HRCAP2					= 78,
    INT_USART7					= 79
}InterruptIndex;
/* жŶ  */


/* ----------------------------------------------------------------------------
   -- ض
   ---------------------------------------------------------------------------- */

#if 1										/* GPIO */

/* ----------------------------------------------------------------------------
   -- ͨ˿(GPIO)
   ---------------------------------------------------------------------------- */
typedef struct GPIO_MenMap
{
	volatile const uint32_t PIR;          /* GPIO״̬Ĵ, ƫ:0x0 */
	volatile 	   uint32_t POR;          /* GPIO״̬Ĵ, ƫ:0x4 */
	volatile 	   uint32_t PUR;          /* GPIOʹܼĴ, ƫ:0x8 */
	volatile	   uint32_t PDR;          /* GPIOʹܼĴ, ƫ:0xC */
	volatile	   uint32_t PODR;         /* GPIO©ƼĴ, ƫ:0x10 */
	volatile   	   uint32_t PMOD;         /* GPIO˿ڷƼĴ, ƫ:0x14 */
	volatile	   uint32_t OMOD;         /* GPIO˿ٶȿƼĴ, ƫ:0x18 */
	volatile	   uint32_t LOCK;         /* GPIO˿Ĵ, ƫ:0x1C */
	volatile 	   uint32_t RMP[2];       /* GPIOӳƼĴ, ƫ:0x20 */
	volatile	   uint32_t RESERVED[3];   /* ƫ0x28 */
	volatile	   uint32_t RMP_MSB;       /* GPIOӳ˿ģѡĴ, ƫ:0x34 */
}GPIO_SFRmap;

/* ----------------------------------------------------------------------------
   -- GPIO - Ĵں
   ---------------------------------------------------------------------------- */

/* GPIO - Ĵڵַ */
#define GPIOA_ADDR						((uint32_t)0x50000000)
#define GPIOB_ADDR                      ((uint32_t)0x50000040)
#define GPIOC_ADDR                      ((uint32_t)0x50000080)
#define GPIOD_ADDR                      ((uint32_t)0x500000C0)
#define GPIOE_ADDR                      ((uint32_t)0x50000100)
#define GPIOF_ADDR                      ((uint32_t)0x50000140)
#define GPIOG_ADDR                      ((uint32_t)0x50000180)
#define GPIOH_ADDR                      ((uint32_t)0x500001C0)
#define GPIOA_SFR						((GPIO_SFRmap *) GPIOA_ADDR)
#define GPIOB_SFR						((GPIO_SFRmap *) GPIOB_ADDR)
#define GPIOC_SFR						((GPIO_SFRmap *) GPIOC_ADDR)
#define GPIOD_SFR                       ((GPIO_SFRmap *) GPIOD_ADDR)
#define GPIOE_SFR                       ((GPIO_SFRmap *) GPIOE_ADDR)
#define GPIOF_SFR                       ((GPIO_SFRmap *) GPIOF_ADDR)
#define GPIOG_SFR                       ((GPIO_SFRmap *) GPIOG_ADDR)
#define GPIOH_SFR                       ((GPIO_SFRmap *) GPIOH_ADDR)

/* GPIO - Ĵ */
#define GPIOA_PIR						(GPIOA_SFR->PIR)
#define GPIOA_POR						(GPIOA_SFR->POR)
#define GPIOA_PUR                       (GPIOA_SFR->PUR)
#define GPIOA_PDR                       (GPIOA_SFR->PDR)
#define GPIOA_PODR                      (GPIOA_SFR->PODR)
#define GPIOA_PMOD                      (GPIOA_SFR->PMOD)
#define GPIOA_OMOD                      (GPIOA_SFR->OMOD)
#define GPIOA_LOCK                      (GPIOA_SFR->LOCK)
#define GPIOA_RMPL                      (GPIOA_SFR->RMP[0])
#define GPIOA_RMPH                      (GPIOA_SFR->RMP[1])
#define GPIOA_RMP_MSB					(GPIOA_SFR->RMP_MSB)
#define GPIOB_PIR                       (GPIOB_SFR->PIR)
#define GPIOB_POR                       (GPIOB_SFR->POR)
#define GPIOB_PUR                       (GPIOB_SFR->PUR)
#define GPIOB_PDR                       (GPIOB_SFR->PDR)
#define GPIOB_PODR                      (GPIOB_SFR->PODR)
#define GPIOB_PMOD                      (GPIOB_SFR->PMOD)
#define GPIOB_OMOD                      (GPIOB_SFR->OMOD)
#define GPIOB_LOCK                      (GPIOB_SFR->LOCK)
#define GPIOB_RMPL                      (GPIOB_SFR->RMP[0])
#define GPIOB_RMPH                      (GPIOB_SFR->RMP[1])
#define GPIOB_RMP_MSB					(GPIOB_SFR->RMP_MSB)
#define GPIOC_PIR                       (GPIOC_SFR->PIR)
#define GPIOC_POR                       (GPIOC_SFR->POR)
#define GPIOC_PUR                       (GPIOC_SFR->PUR)
#define GPIOC_PDR                       (GPIOC_SFR->PDR)
#define GPIOC_PODR                      (GPIOC_SFR->PODR)
#define GPIOC_PMOD                      (GPIOC_SFR->PMOD)
#define GPIOC_OMOD                      (GPIOC_SFR->OMOD)
#define GPIOC_LOCK                      (GPIOC_SFR->LOCK)
#define GPIOC_RMPL                      (GPIOC_SFR->RMP[0])
#define GPIOC_RMPH                      (GPIOC_SFR->RMP[1])
#define GPIOC_RMP_MSB					(GPIOC_SFR->RMP_MSB)
#define GPIOD_PIR                       (GPIOD_SFR->PIR)
#define GPIOD_POR                       (GPIOD_SFR->POR)
#define GPIOD_PUR                       (GPIOD_SFR->PUR)
#define GPIOD_PDR                       (GPIOD_SFR->PDR)
#define GPIOD_PODR                      (GPIOD_SFR->PODR)
#define GPIOD_PMOD                      (GPIOD_SFR->PMOD)
#define GPIOD_OMOD                      (GPIOD_SFR->OMOD)
#define GPIOD_LOCK                      (GPIOD_SFR->LOCK)
#define GPIOD_RMPL                      (GPIOD_SFR->RMP[0])
#define GPIOD_RMPH                      (GPIOD_SFR->RMP[1])
#define GPIOD_RMP_MSB					(GPIOD_SFR->RMP_MSB)
#define GPIOE_PIR                       (GPIOE_SFR->PIR)
#define GPIOE_POR                       (GPIOE_SFR->POR)
#define GPIOE_PUR                       (GPIOE_SFR->PUR)
#define GPIOE_PDR                       (GPIOE_SFR->PDR)
#define GPIOE_PODR                      (GPIOE_SFR->PODR)
#define GPIOE_PMOD                      (GPIOE_SFR->PMOD)
#define GPIOE_OMOD                      (GPIOE_SFR->OMOD)
#define GPIOE_LOCK                      (GPIOE_SFR->LOCK)
#define GPIOE_RMPL                      (GPIOE_SFR->RMP[0])
#define GPIOE_RMPH                      (GPIOE_SFR->RMP[1])
#define GPIOE_RMP_MSB					(GPIOE_SFR->RMP_MSB)
#define GPIOF_PIR                       (GPIOF_SFR->PIR)
#define GPIOF_POR                       (GPIOF_SFR->POR)
#define GPIOF_PUR                       (GPIOF_SFR->PUR)
#define GPIOF_PDR                       (GPIOF_SFR->PDR)
#define GPIOF_PODR                      (GPIOF_SFR->PODR)
#define GPIOF_PMOD                      (GPIOF_SFR->PMOD)
#define GPIOF_OMOD                      (GPIOF_SFR->OMOD)
#define GPIOF_LOCK                      (GPIOF_SFR->LOCK)
#define GPIOF_RMPL                      (GPIOF_SFR->RMP[0])
#define GPIOF_RMPH                      (GPIOF_SFR->RMP[1])
#define GPIOF_RMP_MSB					(GPIOF_SFR->RMP_MSB)
#define GPIOG_PIR                       (GPIOG_SFR->PIR)
#define GPIOG_POR                       (GPIOG_SFR->POR)
#define GPIOG_PUR                       (GPIOG_SFR->PUR)
#define GPIOG_PDR                       (GPIOG_SFR->PDR)
#define GPIOG_PODR                      (GPIOG_SFR->PODR)
#define GPIOG_PMOD                      (GPIOG_SFR->PMOD)
#define GPIOG_OMOD                      (GPIOG_SFR->OMOD)
#define GPIOG_LOCK                      (GPIOG_SFR->LOCK)
#define GPIOG_RMPL                      (GPIOG_SFR->RMP[0])
#define GPIOG_RMPH                      (GPIOG_SFR->RMP[1])
#define GPIOG_RMP_MSB					(GPIOG_SFR->RMP_MSB)
#define GPIOH_PIR                       (GPIOH_SFR->PIR)
#define GPIOH_POR                       (GPIOH_SFR->POR)
#define GPIOH_PUR                       (GPIOH_SFR->PUR)
#define GPIOH_PDR                       (GPIOH_SFR->PDR)
#define GPIOH_PODR                      (GPIOH_SFR->PODR)
#define GPIOH_PMOD                      (GPIOH_SFR->PMOD)
#define GPIOH_OMOD                      (GPIOH_SFR->OMOD)
#define GPIOH_LOCK                      (GPIOH_SFR->LOCK)
#define GPIOH_RMPL                      (GPIOH_SFR->RMP[0])
#define GPIOH_RMPH                      (GPIOH_SFR->RMP[1])
#define GPIOH_RMP_MSB					(GPIOH_SFR->RMP_MSB)

/* GPIO_PIR λ */
#define GPIO_PIR_PXPIR0_POS             (0)
#define GPIO_PIR_PXPIR1_POS             (1)
#define GPIO_PIR_PXPIR2_POS             (2)
#define GPIO_PIR_PXPIR3_POS             (3)
#define GPIO_PIR_PXPIR4_POS             (4)
#define GPIO_PIR_PXPIR5_POS             (5)
#define GPIO_PIR_PXPIR6_POS             (6)
#define GPIO_PIR_PXPIR7_POS             (7)
#define GPIO_PIR_PXPIR8_POS             (8)
#define GPIO_PIR_PXPIR9_POS             (9)
#define GPIO_PIR_PXPIR10_POS            (10)
#define GPIO_PIR_PXPIR11_POS            (11)
#define GPIO_PIR_PXPIR12_POS            (12)
#define GPIO_PIR_PXPIR13_POS            (13)
#define GPIO_PIR_PXPIR14_POS            (14)
#define GPIO_PIR_PXPIR15_POS            (15)
#define GPIO_PIR_PXPIR                  ((uint32_t)0xFFFF<<(GPIO_PIR_PXPIR0_POS))
#define GPIO_PIR_PXPIR0                 ((uint32_t)1<<(GPIO_PIR_PXPIR0_POS))
#define GPIO_PIR_PXPIR1                 ((uint32_t)1<<(GPIO_PIR_PXPIR1_POS))
#define GPIO_PIR_PXPIR2                 ((uint32_t)1<<(GPIO_PIR_PXPIR2_POS))
#define GPIO_PIR_PXPIR3                 ((uint32_t)1<<(GPIO_PIR_PXPIR3_POS))
#define GPIO_PIR_PXPIR4                 ((uint32_t)1<<(GPIO_PIR_PXPIR4_POS))
#define GPIO_PIR_PXPIR5                 ((uint32_t)1<<(GPIO_PIR_PXPIR5_POS))
#define GPIO_PIR_PXPIR6                 ((uint32_t)1<<(GPIO_PIR_PXPIR6_POS))
#define GPIO_PIR_PXPIR7                 ((uint32_t)1<<(GPIO_PIR_PXPIR7_POS))
#define GPIO_PIR_PXPIR8                 ((uint32_t)1<<(GPIO_PIR_PXPIR8_POS))
#define GPIO_PIR_PXPIR9                 ((uint32_t)1<<(GPIO_PIR_PXPIR9_POS))
#define GPIO_PIR_PXPIR10                ((uint32_t)1<<(GPIO_PIR_PXPIR10_POS))
#define GPIO_PIR_PXPIR11                ((uint32_t)1<<(GPIO_PIR_PXPIR11_POS))
#define GPIO_PIR_PXPIR12                ((uint32_t)1<<(GPIO_PIR_PXPIR12_POS))
#define GPIO_PIR_PXPIR13                ((uint32_t)1<<(GPIO_PIR_PXPIR13_POS))
#define GPIO_PIR_PXPIR14                ((uint32_t)1<<(GPIO_PIR_PXPIR14_POS))
#define GPIO_PIR_PXPIR15                ((uint32_t)1<<(GPIO_PIR_PXPIR15_POS))

/* GPIO_POR λ */
#define GPIO_POR_PXPOR0_POS             (0)
#define GPIO_POR_PXPOR1_POS             (1)
#define GPIO_POR_PXPOR2_POS             (2)
#define GPIO_POR_PXPOR3_POS             (3)
#define GPIO_POR_PXPOR4_POS             (4)
#define GPIO_POR_PXPOR5_POS             (5)
#define GPIO_POR_PXPOR6_POS             (6)
#define GPIO_POR_PXPOR7_POS             (7)
#define GPIO_POR_PXPOR8_POS             (8)
#define GPIO_POR_PXPOR9_POS             (9)
#define GPIO_POR_PXPOR10_POS            (10)
#define GPIO_POR_PXPOR11_POS            (11)
#define GPIO_POR_PXPOR12_POS            (12)
#define GPIO_POR_PXPOR13_POS            (13)
#define GPIO_POR_PXPOR14_POS            (14)
#define GPIO_POR_PXPOR15_POS            (15)
#define GPIO_POR_PXPOR                  ((uint32_t)0xFFFF<<(GPIO_POR_PXPOR0_POS))
#define GPIO_POR_PXPOR0                 ((uint32_t)1<<(GPIO_POR_PXPOR0_POS))
#define GPIO_POR_PXPOR1                 ((uint32_t)1<<(GPIO_POR_PXPOR1_POS))
#define GPIO_POR_PXPOR2                 ((uint32_t)1<<(GPIO_POR_PXPOR2_POS))
#define GPIO_POR_PXPOR3                 ((uint32_t)1<<(GPIO_POR_PXPOR3_POS))
#define GPIO_POR_PXPOR4                 ((uint32_t)1<<(GPIO_POR_PXPOR4_POS))
#define GPIO_POR_PXPOR5                 ((uint32_t)1<<(GPIO_POR_PXPOR5_POS))
#define GPIO_POR_PXPOR6                 ((uint32_t)1<<(GPIO_POR_PXPOR6_POS))
#define GPIO_POR_PXPOR7                 ((uint32_t)1<<(GPIO_POR_PXPOR7_POS))
#define GPIO_POR_PXPOR8                 ((uint32_t)1<<(GPIO_POR_PXPOR8_POS))
#define GPIO_POR_PXPOR9                 ((uint32_t)1<<(GPIO_POR_PXPOR9_POS))
#define GPIO_POR_PXPOR10                ((uint32_t)1<<(GPIO_POR_PXPOR10_POS))
#define GPIO_POR_PXPOR11                ((uint32_t)1<<(GPIO_POR_PXPOR11_POS))
#define GPIO_POR_PXPOR12                ((uint32_t)1<<(GPIO_POR_PXPOR12_POS))
#define GPIO_POR_PXPOR13                ((uint32_t)1<<(GPIO_POR_PXPOR13_POS))
#define GPIO_POR_PXPOR14                ((uint32_t)1<<(GPIO_POR_PXPOR14_POS))
#define GPIO_POR_PXPOR15                ((uint32_t)1<<(GPIO_POR_PXPOR15_POS))

/* GPIO_PUR λ */
#define GPIO_PUR_PXPUR0_POS             (0)
#define GPIO_PUR_PXPUR1_POS             (1)
#define GPIO_PUR_PXPUR2_POS             (2)
#define GPIO_PUR_PXPUR3_POS             (3)
#define GPIO_PUR_PXPUR4_POS             (4)
#define GPIO_PUR_PXPUR5_POS             (5)
#define GPIO_PUR_PXPUR6_POS             (6)
#define GPIO_PUR_PXPUR7_POS             (7)
#define GPIO_PUR_PXPUR8_POS             (8)
#define GPIO_PUR_PXPUR9_POS             (9)
#define GPIO_PUR_PXPUR10_POS            (10)
#define GPIO_PUR_PXPUR11_POS            (11)
#define GPIO_PUR_PXPUR12_POS            (12)
#define GPIO_PUR_PXPUR13_POS            (13)
#define GPIO_PUR_PXPUR14_POS            (14)
#define GPIO_PUR_PXPUR15_POS            (15)
#define GPIO_PUR_PXPUR                  ((uint32_t)0xFFFF<<(GPIO_PUR_PXPUR0_POS))
#define GPIO_PUR_PXPUR0                 ((uint32_t)1<<(GPIO_PUR_PXPUR0_POS))
#define GPIO_PUR_PXPUR1                 ((uint32_t)1<<(GPIO_PUR_PXPUR1_POS))
#define GPIO_PUR_PXPUR2                 ((uint32_t)1<<(GPIO_PUR_PXPUR2_POS))
#define GPIO_PUR_PXPUR3                 ((uint32_t)1<<(GPIO_PUR_PXPUR3_POS))
#define GPIO_PUR_PXPUR4                 ((uint32_t)1<<(GPIO_PUR_PXPUR4_POS))
#define GPIO_PUR_PXPUR5                 ((uint32_t)1<<(GPIO_PUR_PXPUR5_POS))
#define GPIO_PUR_PXPUR6                 ((uint32_t)1<<(GPIO_PUR_PXPUR6_POS))
#define GPIO_PUR_PXPUR7                 ((uint32_t)1<<(GPIO_PUR_PXPUR7_POS))
#define GPIO_PUR_PXPUR8                 ((uint32_t)1<<(GPIO_PUR_PXPUR8_POS))
#define GPIO_PUR_PXPUR9                 ((uint32_t)1<<(GPIO_PUR_PXPUR9_POS))
#define GPIO_PUR_PXPUR10                ((uint32_t)1<<(GPIO_PUR_PXPUR10_POS))
#define GPIO_PUR_PXPUR11                ((uint32_t)1<<(GPIO_PUR_PXPUR11_POS))
#define GPIO_PUR_PXPUR12                ((uint32_t)1<<(GPIO_PUR_PXPUR12_POS))
#define GPIO_PUR_PXPUR13                ((uint32_t)1<<(GPIO_PUR_PXPUR13_POS))
#define GPIO_PUR_PXPUR14                ((uint32_t)1<<(GPIO_PUR_PXPUR14_POS))
#define GPIO_PUR_PXPUR15                ((uint32_t)1<<(GPIO_PUR_PXPUR15_POS))

/* GPIO_PDR λ */
#define GPIO_PDR_PXPDR0_POS             (0)
#define GPIO_PDR_PXPDR1_POS             (1)
#define GPIO_PDR_PXPDR2_POS             (2)
#define GPIO_PDR_PXPDR3_POS             (3)
#define GPIO_PDR_PXPDR4_POS             (4)
#define GPIO_PDR_PXPDR5_POS             (5)
#define GPIO_PDR_PXPDR6_POS             (6)
#define GPIO_PDR_PXPDR7_POS             (7)
#define GPIO_PDR_PXPDR8_POS             (8)
#define GPIO_PDR_PXPDR9_POS             (9)
#define GPIO_PDR_PXPDR10_POS            (10)
#define GPIO_PDR_PXPDR11_POS            (11)
#define GPIO_PDR_PXPDR12_POS            (12)
#define GPIO_PDR_PXPDR13_POS            (13)
#define GPIO_PDR_PXPDR14_POS            (14)
#define GPIO_PDR_PXPDR15_POS            (15)
#define GPIO_PDR_PXPDR                  ((uint32_t)0xFFFF<<(GPIO_PDR_PXPDR0_POS))
#define GPIO_PDR_PXPDR0                 ((uint32_t)1<<(GPIO_PDR_PXPDR0_POS))
#define GPIO_PDR_PXPDR1                 ((uint32_t)1<<(GPIO_PDR_PXPDR1_POS))
#define GPIO_PDR_PXPDR2                 ((uint32_t)1<<(GPIO_PDR_PXPDR2_POS))
#define GPIO_PDR_PXPDR3                 ((uint32_t)1<<(GPIO_PDR_PXPDR3_POS))
#define GPIO_PDR_PXPDR4                 ((uint32_t)1<<(GPIO_PDR_PXPDR4_POS))
#define GPIO_PDR_PXPDR5                 ((uint32_t)1<<(GPIO_PDR_PXPDR5_POS))
#define GPIO_PDR_PXPDR6                 ((uint32_t)1<<(GPIO_PDR_PXPDR6_POS))
#define GPIO_PDR_PXPDR7                 ((uint32_t)1<<(GPIO_PDR_PXPDR7_POS))
#define GPIO_PDR_PXPDR8                 ((uint32_t)1<<(GPIO_PDR_PXPDR8_POS))
#define GPIO_PDR_PXPDR9                 ((uint32_t)1<<(GPIO_PDR_PXPDR9_POS))
#define GPIO_PDR_PXPDR10                ((uint32_t)1<<(GPIO_PDR_PXPDR10_POS))
#define GPIO_PDR_PXPDR11                ((uint32_t)1<<(GPIO_PDR_PXPDR11_POS))
#define GPIO_PDR_PXPDR12                ((uint32_t)1<<(GPIO_PDR_PXPDR12_POS))
#define GPIO_PDR_PXPDR13                ((uint32_t)1<<(GPIO_PDR_PXPDR13_POS))
#define GPIO_PDR_PXPDR14                ((uint32_t)1<<(GPIO_PDR_PXPDR14_POS))
#define GPIO_PDR_PXPDR15                ((uint32_t)1<<(GPIO_PDR_PXPDR15_POS))

/* GPIO_PODR λ */
#define GPIO_PODR_PXPODR0_POS           (0)
#define GPIO_PODR_PXPODR1_POS           (1)
#define GPIO_PODR_PXPODR2_POS           (2)
#define GPIO_PODR_PXPODR3_POS           (3)
#define GPIO_PODR_PXPODR4_POS           (4)
#define GPIO_PODR_PXPODR5_POS           (5)
#define GPIO_PODR_PXPODR6_POS           (6)
#define GPIO_PODR_PXPODR7_POS           (7)
#define GPIO_PODR_PXPODR8_POS           (8)
#define GPIO_PODR_PXPODR9_POS           (9)
#define GPIO_PODR_PXPODR10_POS          (10)
#define GPIO_PODR_PXPODR11_POS          (11)
#define GPIO_PODR_PXPODR12_POS          (12)
#define GPIO_PODR_PXPODR13_POS          (13)
#define GPIO_PODR_PXPODR14_POS          (14)
#define GPIO_PODR_PXPODR15_POS          (15)
#define GPIO_PODR_PXPODR                ((uint32_t)0xFFFF<<(GPIO_PODR_PXPODR0_POS))
#define GPIO_PODR_PXPODR0               ((uint32_t)1<<(GPIO_PODR_PXPODR0_POS))
#define GPIO_PODR_PXPODR1               ((uint32_t)1<<(GPIO_PODR_PXPODR1_POS))
#define GPIO_PODR_PXPODR2               ((uint32_t)1<<(GPIO_PODR_PXPODR2_POS))
#define GPIO_PODR_PXPODR3               ((uint32_t)1<<(GPIO_PODR_PXPODR3_POS))
#define GPIO_PODR_PXPODR4               ((uint32_t)1<<(GPIO_PODR_PXPODR4_POS))
#define GPIO_PODR_PXPODR5               ((uint32_t)1<<(GPIO_PODR_PXPODR5_POS))
#define GPIO_PODR_PXPODR6               ((uint32_t)1<<(GPIO_PODR_PXPODR6_POS))
#define GPIO_PODR_PXPODR7               ((uint32_t)1<<(GPIO_PODR_PXPODR7_POS))
#define GPIO_PODR_PXPODR8               ((uint32_t)1<<(GPIO_PODR_PXPODR8_POS))
#define GPIO_PODR_PXPODR9               ((uint32_t)1<<(GPIO_PODR_PXPODR9_POS))
#define GPIO_PODR_PXPODR10              ((uint32_t)1<<(GPIO_PODR_PXPODR10_POS))
#define GPIO_PODR_PXPODR11              ((uint32_t)1<<(GPIO_PODR_PXPODR11_POS))
#define GPIO_PODR_PXPODR12              ((uint32_t)1<<(GPIO_PODR_PXPODR12_POS))
#define GPIO_PODR_PXPODR13              ((uint32_t)1<<(GPIO_PODR_PXPODR13_POS))
#define GPIO_PODR_PXPODR14              ((uint32_t)1<<(GPIO_PODR_PXPODR14_POS))
#define GPIO_PODR_PXPODR15              ((uint32_t)1<<(GPIO_PODR_PXPODR15_POS))

/* GPIO_PMOD λ */
#define GPIO_PMOD_PXPMD0_0_POS          (0)
#define GPIO_PMOD_PXPMD0_1_POS          (1)
#define GPIO_PMOD_PXPMD1_0_POS          (2)
#define GPIO_PMOD_PXPMD1_1_POS          (3)
#define GPIO_PMOD_PXPMD2_0_POS          (4)
#define GPIO_PMOD_PXPMD2_1_POS          (5)
#define GPIO_PMOD_PXPMD3_0_POS          (6)
#define GPIO_PMOD_PXPMD3_1_POS          (7)
#define GPIO_PMOD_PXPMD4_0_POS          (8)
#define GPIO_PMOD_PXPMD4_1_POS          (9)
#define GPIO_PMOD_PXPMD5_0_POS          (10)
#define GPIO_PMOD_PXPMD5_1_POS          (11)
#define GPIO_PMOD_PXPMD6_0_POS          (12)
#define GPIO_PMOD_PXPMD6_1_POS          (13)
#define GPIO_PMOD_PXPMD7_0_POS          (14)
#define GPIO_PMOD_PXPMD7_1_POS          (15)
#define GPIO_PMOD_PXPMD8_0_POS          (16)
#define GPIO_PMOD_PXPMD8_1_POS          (17)
#define GPIO_PMOD_PXPMD9_0_POS          (18)
#define GPIO_PMOD_PXPMD9_1_POS          (19)
#define GPIO_PMOD_PXPMD10_0_POS         (20)
#define GPIO_PMOD_PXPMD10_1_POS         (21)
#define GPIO_PMOD_PXPMD11_0_POS         (22)
#define GPIO_PMOD_PXPMD11_1_POS         (23)
#define GPIO_PMOD_PXPMD12_0_POS         (24)
#define GPIO_PMOD_PXPMD12_1_POS         (25)
#define GPIO_PMOD_PXPMD13_0_POS         (26)
#define GPIO_PMOD_PXPMD13_1_POS         (27)
#define GPIO_PMOD_PXPMD14_0_POS         (28)
#define GPIO_PMOD_PXPMD14_1_POS         (29)
#define GPIO_PMOD_PXPMD15_0_POS         (30)
#define GPIO_PMOD_PXPMD15_1_POS         (31)
#define GPIO_PMOD_PXPMD0                ((uint32_t)3<<(GPIO_PMOD_PXPMD0_0_POS))
#define GPIO_PMOD_PXPMD0_0              ((uint32_t)1<<(GPIO_PMOD_PXPMD0_0_POS))
#define GPIO_PMOD_PXPMD0_1              ((uint32_t)1<<(GPIO_PMOD_PXPMD0_1_POS))
#define GPIO_PMOD_PXPMD1                ((uint32_t)3<<(GPIO_PMOD_PXPMD1_0_POS))
#define GPIO_PMOD_PXPMD1_0              ((uint32_t)1<<(GPIO_PMOD_PXPMD1_0_POS))
#define GPIO_PMOD_PXPMD1_1              ((uint32_t)1<<(GPIO_PMOD_PXPMD1_1_POS))
#define GPIO_PMOD_PXPMD2                ((uint32_t)3<<(GPIO_PMOD_PXPMD2_0_POS))
#define GPIO_PMOD_PXPMD2_0              ((uint32_t)1<<(GPIO_PMOD_PXPMD2_0_POS))
#define GPIO_PMOD_PXPMD2_1              ((uint32_t)1<<(GPIO_PMOD_PXPMD2_1_POS))
#define GPIO_PMOD_PXPMD3                ((uint32_t)3<<(GPIO_PMOD_PXPMD3_0_POS))
#define GPIO_PMOD_PXPMD3_0              ((uint32_t)1<<(GPIO_PMOD_PXPMD3_0_POS))
#define GPIO_PMOD_PXPMD3_1              ((uint32_t)1<<(GPIO_PMOD_PXPMD3_1_POS))
#define GPIO_PMOD_PXPMD4                ((uint32_t)3<<(GPIO_PMOD_PXPMD4_0_POS))
#define GPIO_PMOD_PXPMD4_0              ((uint32_t)1<<(GPIO_PMOD_PXPMD4_0_POS))
#define GPIO_PMOD_PXPMD4_1              ((uint32_t)1<<(GPIO_PMOD_PXPMD4_1_POS))
#define GPIO_PMOD_PXPMD5                ((uint32_t)3<<(GPIO_PMOD_PXPMD5_0_POS))
#define GPIO_PMOD_PXPMD5_0              ((uint32_t)1<<(GPIO_PMOD_PXPMD5_0_POS))
#define GPIO_PMOD_PXPMD5_1              ((uint32_t)1<<(GPIO_PMOD_PXPMD5_1_POS))
#define GPIO_PMOD_PXPMD6                ((uint32_t)3<<(GPIO_PMOD_PXPMD6_0_POS))
#define GPIO_PMOD_PXPMD6_0              ((uint32_t)1<<(GPIO_PMOD_PXPMD6_0_POS))
#define GPIO_PMOD_PXPMD6_1              ((uint32_t)1<<(GPIO_PMOD_PXPMD6_1_POS))
#define GPIO_PMOD_PXPMD7                ((uint32_t)3<<(GPIO_PMOD_PXPMD7_0_POS))
#define GPIO_PMOD_PXPMD7_0              ((uint32_t)1<<(GPIO_PMOD_PXPMD7_0_POS))
#define GPIO_PMOD_PXPMD7_1              ((uint32_t)1<<(GPIO_PMOD_PXPMD7_1_POS))
#define GPIO_PMOD_PXPMD8                ((uint32_t)3<<(GPIO_PMOD_PXPMD8_0_POS))
#define GPIO_PMOD_PXPMD8_0              ((uint32_t)1<<(GPIO_PMOD_PXPMD8_0_POS))
#define GPIO_PMOD_PXPMD8_1              ((uint32_t)1<<(GPIO_PMOD_PXPMD8_1_POS))
#define GPIO_PMOD_PXPMD9                ((uint32_t)3<<(GPIO_PMOD_PXPMD9_0_POS))
#define GPIO_PMOD_PXPMD9_0              ((uint32_t)1<<(GPIO_PMOD_PXPMD9_0_POS))
#define GPIO_PMOD_PXPMD9_1              ((uint32_t)1<<(GPIO_PMOD_PXPMD9_1_POS))
#define GPIO_PMOD_PXPMD10               ((uint32_t)3<<(GPIO_PMOD_PXPMD10_0_POS))
#define GPIO_PMOD_PXPMD10_0             ((uint32_t)1<<(GPIO_PMOD_PXPMD10_0_POS))
#define GPIO_PMOD_PXPMD10_1             ((uint32_t)1<<(GPIO_PMOD_PXPMD10_1_POS))
#define GPIO_PMOD_PXPMD11               ((uint32_t)3<<(GPIO_PMOD_PXPMD11_0_POS))
#define GPIO_PMOD_PXPMD11_0             ((uint32_t)1<<(GPIO_PMOD_PXPMD11_0_POS))
#define GPIO_PMOD_PXPMD11_1             ((uint32_t)1<<(GPIO_PMOD_PXPMD11_1_POS))
#define GPIO_PMOD_PXPMD12               ((uint32_t)3<<(GPIO_PMOD_PXPMD12_0_POS))
#define GPIO_PMOD_PXPMD12_0             ((uint32_t)1<<(GPIO_PMOD_PXPMD12_0_POS))
#define GPIO_PMOD_PXPMD12_1             ((uint32_t)1<<(GPIO_PMOD_PXPMD12_1_POS))
#define GPIO_PMOD_PXPMD13               ((uint32_t)3<<(GPIO_PMOD_PXPMD13_0_POS))
#define GPIO_PMOD_PXPMD13_0             ((uint32_t)1<<(GPIO_PMOD_PXPMD13_0_POS))
#define GPIO_PMOD_PXPMD13_1             ((uint32_t)1<<(GPIO_PMOD_PXPMD13_1_POS))
#define GPIO_PMOD_PXPMD14               ((uint32_t)3<<(GPIO_PMOD_PXPMD14_0_POS))
#define GPIO_PMOD_PXPMD14_0             ((uint32_t)1<<(GPIO_PMOD_PXPMD14_0_POS))
#define GPIO_PMOD_PXPMD14_1             ((uint32_t)1<<(GPIO_PMOD_PXPMD14_1_POS))
#define GPIO_PMOD_PXPMD15               ((uint32_t)3<<(GPIO_PMOD_PXPMD15_0_POS))
#define GPIO_PMOD_PXPMD15_0             ((uint32_t)1<<(GPIO_PMOD_PXPMD15_0_POS))
#define GPIO_PMOD_PXPMD15_1             ((uint32_t)1<<(GPIO_PMOD_PXPMD15_1_POS))

/* GPIO_OMOD λ */
#define GPIO_OMOD_PXOMD0_POS            (0)
#define GPIO_OMOD_PXOMD1_POS            (2)
#define GPIO_OMOD_PXOMD2_POS            (4)
#define GPIO_OMOD_PXOMD3_POS            (6)
#define GPIO_OMOD_PXOMD4_POS            (8)
#define GPIO_OMOD_PXOMD5_POS            (10)
#define GPIO_OMOD_PXOMD6_POS            (12)
#define GPIO_OMOD_PXOMD7_POS            (14)
#define GPIO_OMOD_PXOMD8_POS            (16)
#define GPIO_OMOD_PXOMD9_POS            (18)
#define GPIO_OMOD_PXOMD10_POS           (20)
#define GPIO_OMOD_PXOMD11_POS           (22)
#define GPIO_OMOD_PXOMD12_POS           (24)
#define GPIO_OMOD_PXOMD13_POS           (26)
#define GPIO_OMOD_PXOMD14_POS           (28)
#define GPIO_OMOD_PXOMD15_POS           (30)
#define GPIO_OMOD_PXOMD0                ((uint32_t)1<<(GPIO_OMOD_PXOMD0_POS))
#define GPIO_OMOD_PXOMD1                ((uint32_t)1<<(GPIO_OMOD_PXOMD1_POS))
#define GPIO_OMOD_PXOMD2                ((uint32_t)1<<(GPIO_OMOD_PXOMD2_POS))
#define GPIO_OMOD_PXOMD3                ((uint32_t)1<<(GPIO_OMOD_PXOMD3_POS))
#define GPIO_OMOD_PXOMD4                ((uint32_t)1<<(GPIO_OMOD_PXOMD4_POS))
#define GPIO_OMOD_PXOMD5                ((uint32_t)1<<(GPIO_OMOD_PXOMD5_POS))
#define GPIO_OMOD_PXOMD6                ((uint32_t)1<<(GPIO_OMOD_PXOMD6_POS))
#define GPIO_OMOD_PXOMD7                ((uint32_t)1<<(GPIO_OMOD_PXOMD7_POS))
#define GPIO_OMOD_PXOMD8                ((uint32_t)1<<(GPIO_OMOD_PXOMD8_POS))
#define GPIO_OMOD_PXOMD9                ((uint32_t)1<<(GPIO_OMOD_PXOMD9_POS))
#define GPIO_OMOD_PXOMD10               ((uint32_t)1<<(GPIO_OMOD_PXOMD10_POS))
#define GPIO_OMOD_PXOMD11               ((uint32_t)1<<(GPIO_OMOD_PXOMD11_POS))
#define GPIO_OMOD_PXOMD12               ((uint32_t)1<<(GPIO_OMOD_PXOMD12_POS))
#define GPIO_OMOD_PXOMD13               ((uint32_t)1<<(GPIO_OMOD_PXOMD13_POS))
#define GPIO_OMOD_PXOMD14               ((uint32_t)1<<(GPIO_OMOD_PXOMD14_POS))
#define GPIO_OMOD_PXOMD15               ((uint32_t)1<<(GPIO_OMOD_PXOMD15_POS))

/* GPIO_LOCK λ */
#define GPIO_LOCK_PXLCK0_POS            (0)
#define GPIO_LOCK_PXLCK1_POS            (1)
#define GPIO_LOCK_PXLCK2_POS            (2)
#define GPIO_LOCK_PXLCK3_POS            (3)
#define GPIO_LOCK_PXLCK4_POS            (4)
#define GPIO_LOCK_PXLCK5_POS            (5)
#define GPIO_LOCK_PXLCK6_POS            (6)
#define GPIO_LOCK_PXLCK7_POS            (7)
#define GPIO_LOCK_PXLCK8_POS            (8)
#define GPIO_LOCK_PXLCK9_POS            (9)
#define GPIO_LOCK_PXLCK10_POS           (10)
#define GPIO_LOCK_PXLCK11_POS           (11)
#define GPIO_LOCK_PXLCK12_POS           (12)
#define GPIO_LOCK_PXLCK13_POS           (13)
#define GPIO_LOCK_PXLCK14_POS           (14)
#define GPIO_LOCK_PXLCK15_POS           (15)
#define GPIO_LOCK_PXLCKKEY0_POS         (16)
#define GPIO_LOCK_PXLCKKEY1_POS         (17)
#define GPIO_LOCK_PXLCKKEY2_POS         (18)
#define GPIO_LOCK_PXLCKKEY3_POS         (19)
#define GPIO_LOCK_PXLCKKEY4_POS         (20)
#define GPIO_LOCK_PXLCKKEY5_POS         (21)
#define GPIO_LOCK_PXLCKKEY6_POS         (22)
#define GPIO_LOCK_PXLCKKEY7_POS         (23)
#define GPIO_LOCK_PXLCKKEY8_POS         (24)
#define GPIO_LOCK_PXLCKKEY9_POS         (25)
#define GPIO_LOCK_PXLCKKEY10_POS        (26)
#define GPIO_LOCK_PXLCKKEY11_POS        (27)
#define GPIO_LOCK_PXLCKKEY12_POS        (28)
#define GPIO_LOCK_PXLCKKEY13_POS        (29)
#define GPIO_LOCK_PXLCKKEY14_POS        (30)
#define GPIO_LOCK_PXLCKKEY15_POS        (31)
#define GPIO_LOCK_PXLCK                 ((uint32_t)0xFFFF<<(GPIO_LOCK_PXLCK0_POS))
#define GPIO_LOCK_PXLCK0                ((uint32_t)1<<(GPIO_LOCK_PXLCK0_POS))
#define GPIO_LOCK_PXLCK1                ((uint32_t)1<<(GPIO_LOCK_PXLCK1_POS))
#define GPIO_LOCK_PXLCK2                ((uint32_t)1<<(GPIO_LOCK_PXLCK2_POS))
#define GPIO_LOCK_PXLCK3                ((uint32_t)1<<(GPIO_LOCK_PXLCK3_POS))
#define GPIO_LOCK_PXLCK4                ((uint32_t)1<<(GPIO_LOCK_PXLCK4_POS))
#define GPIO_LOCK_PXLCK5                ((uint32_t)1<<(GPIO_LOCK_PXLCK5_POS))
#define GPIO_LOCK_PXLCK6                ((uint32_t)1<<(GPIO_LOCK_PXLCK6_POS))
#define GPIO_LOCK_PXLCK7                ((uint32_t)1<<(GPIO_LOCK_PXLCK7_POS))
#define GPIO_LOCK_PXLCK8                ((uint32_t)1<<(GPIO_LOCK_PXLCK8_POS))
#define GPIO_LOCK_PXLCK9                ((uint32_t)1<<(GPIO_LOCK_PXLCK9_POS))
#define GPIO_LOCK_PXLCK10               ((uint32_t)1<<(GPIO_LOCK_PXLCK10_POS))
#define GPIO_LOCK_PXLCK11               ((uint32_t)1<<(GPIO_LOCK_PXLCK11_POS))
#define GPIO_LOCK_PXLCK12               ((uint32_t)1<<(GPIO_LOCK_PXLCK12_POS))
#define GPIO_LOCK_PXLCK13               ((uint32_t)1<<(GPIO_LOCK_PXLCK13_POS))
#define GPIO_LOCK_PXLCK14               ((uint32_t)1<<(GPIO_LOCK_PXLCK14_POS))
#define GPIO_LOCK_PXLCK15               ((uint32_t)1<<(GPIO_LOCK_PXLCK15_POS))
#define GPIO_LOCK_PXLCKKEY              ((uint32_t)0xFFFF<<(GPIO_LOCK_PXLCKKEY0_POS))
#define GPIO_LOCK_PXLCKKEY0             ((uint32_t)1<<(GPIO_LOCK_PXLCKKEY0_POS))
#define GPIO_LOCK_PXLCKKEY1             ((uint32_t)1<<(GPIO_LOCK_PXLCKKEY1_POS))
#define GPIO_LOCK_PXLCKKEY2             ((uint32_t)1<<(GPIO_LOCK_PXLCKKEY2_POS))
#define GPIO_LOCK_PXLCKKEY3             ((uint32_t)1<<(GPIO_LOCK_PXLCKKEY3_POS))
#define GPIO_LOCK_PXLCKKEY4             ((uint32_t)1<<(GPIO_LOCK_PXLCKKEY4_POS))
#define GPIO_LOCK_PXLCKKEY5             ((uint32_t)1<<(GPIO_LOCK_PXLCKKEY5_POS))
#define GPIO_LOCK_PXLCKKEY6             ((uint32_t)1<<(GPIO_LOCK_PXLCKKEY6_POS))
#define GPIO_LOCK_PXLCKKEY7             ((uint32_t)1<<(GPIO_LOCK_PXLCKKEY7_POS))
#define GPIO_LOCK_PXLCKKEY8             ((uint32_t)1<<(GPIO_LOCK_PXLCKKEY8_POS))
#define GPIO_LOCK_PXLCKKEY9             ((uint32_t)1<<(GPIO_LOCK_PXLCKKEY9_POS))
#define GPIO_LOCK_PXLCKKEY10            ((uint32_t)1<<(GPIO_LOCK_PXLCKKEY10_POS))
#define GPIO_LOCK_PXLCKKEY11            ((uint32_t)1<<(GPIO_LOCK_PXLCKKEY11_POS))
#define GPIO_LOCK_PXLCKKEY12            ((uint32_t)1<<(GPIO_LOCK_PXLCKKEY12_POS))
#define GPIO_LOCK_PXLCKKEY13            ((uint32_t)1<<(GPIO_LOCK_PXLCKKEY13_POS))
#define GPIO_LOCK_PXLCKKEY14            ((uint32_t)1<<(GPIO_LOCK_PXLCKKEY14_POS))
#define GPIO_LOCK_PXLCKKEY15            ((uint32_t)1<<(GPIO_LOCK_PXLCKKEY15_POS))

/* GPIO_RMPL λ */
#define GPIO_RMPL_PXRMP0_0_POS          (0)
#define GPIO_RMPL_PXRMP0_1_POS          (1)
#define GPIO_RMPL_PXRMP0_2_POS          (2)
#define GPIO_RMPL_PXRMP0_3_POS          (3)
#define GPIO_RMPL_PXRMP1_0_POS          (4)
#define GPIO_RMPL_PXRMP1_1_POS          (5)
#define GPIO_RMPL_PXRMP1_2_POS          (6)
#define GPIO_RMPL_PXRMP1_3_POS          (7)
#define GPIO_RMPL_PXRMP2_0_POS          (8)
#define GPIO_RMPL_PXRMP2_1_POS          (9)
#define GPIO_RMPL_PXRMP2_2_POS          (10)
#define GPIO_RMPL_PXRMP2_3_POS          (11)
#define GPIO_RMPL_PXRMP3_0_POS          (12)
#define GPIO_RMPL_PXRMP3_1_POS          (13)
#define GPIO_RMPL_PXRMP3_2_POS          (14)
#define GPIO_RMPL_PXRMP3_3_POS          (15)
#define GPIO_RMPL_PXRMP4_0_POS          (16)
#define GPIO_RMPL_PXRMP4_1_POS          (17)
#define GPIO_RMPL_PXRMP4_2_POS          (18)
#define GPIO_RMPL_PXRMP4_3_POS          (19)
#define GPIO_RMPL_PXRMP5_0_POS          (20)
#define GPIO_RMPL_PXRMP5_1_POS          (21)
#define GPIO_RMPL_PXRMP5_2_POS          (22)
#define GPIO_RMPL_PXRMP5_3_POS          (23)
#define GPIO_RMPL_PXRMP6_0_POS          (24)
#define GPIO_RMPL_PXRMP6_1_POS          (25)
#define GPIO_RMPL_PXRMP6_2_POS          (26)
#define GPIO_RMPL_PXRMP6_3_POS          (27)
#define GPIO_RMPL_PXRMP7_0_POS          (28)
#define GPIO_RMPL_PXRMP7_1_POS          (29)
#define GPIO_RMPL_PXRMP7_2_POS          (30)
#define GPIO_RMPL_PXRMP7_3_POS          (31)
#define GPIO_RMPL_PXRMP0                ((uint32_t)0xF<<(GPIO_RMPL_PXRMP0_0_POS))
#define GPIO_RMPL_PXRMP0_0              ((uint32_t)1<<(GPIO_RMPL_PXRMP0_0_POS))
#define GPIO_RMPL_PXRMP0_1              ((uint32_t)1<<(GPIO_RMPL_PXRMP0_1_POS))
#define GPIO_RMPL_PXRMP0_2              ((uint32_t)1<<(GPIO_RMPL_PXRMP0_2_POS))
#define GPIO_RMPL_PXRMP0_3              ((uint32_t)1<<(GPIO_RMPL_PXRMP0_3_POS))
#define GPIO_RMPL_PXRMP1                ((uint32_t)0xF<<(GPIO_RMPL_PXRMP1_0_POS))
#define GPIO_RMPL_PXRMP1_0              ((uint32_t)1<<(GPIO_RMPL_PXRMP1_0_POS))
#define GPIO_RMPL_PXRMP1_1              ((uint32_t)1<<(GPIO_RMPL_PXRMP1_1_POS))
#define GPIO_RMPL_PXRMP1_2              ((uint32_t)1<<(GPIO_RMPL_PXRMP1_2_POS))
#define GPIO_RMPL_PXRMP1_3              ((uint32_t)1<<(GPIO_RMPL_PXRMP1_3_POS))
#define GPIO_RMPL_PXRMP2                ((uint32_t)0xF<<(GPIO_RMPL_PXRMP2_0_POS))
#define GPIO_RMPL_PXRMP2_0              ((uint32_t)1<<(GPIO_RMPL_PXRMP2_0_POS))
#define GPIO_RMPL_PXRMP2_1              ((uint32_t)1<<(GPIO_RMPL_PXRMP2_1_POS))
#define GPIO_RMPL_PXRMP2_2              ((uint32_t)1<<(GPIO_RMPL_PXRMP2_2_POS))
#define GPIO_RMPL_PXRMP2_3              ((uint32_t)1<<(GPIO_RMPL_PXRMP2_3_POS))
#define GPIO_RMPL_PXRMP3                ((uint32_t)0xF<<(GPIO_RMPL_PXRMP3_0_POS))
#define GPIO_RMPL_PXRMP3_0              ((uint32_t)1<<(GPIO_RMPL_PXRMP3_0_POS))
#define GPIO_RMPL_PXRMP3_1              ((uint32_t)1<<(GPIO_RMPL_PXRMP3_1_POS))
#define GPIO_RMPL_PXRMP3_2              ((uint32_t)1<<(GPIO_RMPL_PXRMP3_2_POS))
#define GPIO_RMPL_PXRMP3_3              ((uint32_t)1<<(GPIO_RMPL_PXRMP3_3_POS))
#define GPIO_RMPL_PXRMP4                ((uint32_t)0xF<<(GPIO_RMPL_PXRMP4_0_POS))
#define GPIO_RMPL_PXRMP4_0              ((uint32_t)1<<(GPIO_RMPL_PXRMP4_0_POS))
#define GPIO_RMPL_PXRMP4_1              ((uint32_t)1<<(GPIO_RMPL_PXRMP4_1_POS))
#define GPIO_RMPL_PXRMP4_2              ((uint32_t)1<<(GPIO_RMPL_PXRMP4_2_POS))
#define GPIO_RMPL_PXRMP4_3              ((uint32_t)1<<(GPIO_RMPL_PXRMP4_3_POS))
#define GPIO_RMPL_PXRMP5                ((uint32_t)0xF<<(GPIO_RMPL_PXRMP5_0_POS))
#define GPIO_RMPL_PXRMP5_0              ((uint32_t)1<<(GPIO_RMPL_PXRMP5_0_POS))
#define GPIO_RMPL_PXRMP5_1              ((uint32_t)1<<(GPIO_RMPL_PXRMP5_1_POS))
#define GPIO_RMPL_PXRMP5_2              ((uint32_t)1<<(GPIO_RMPL_PXRMP5_2_POS))
#define GPIO_RMPL_PXRMP5_3              ((uint32_t)1<<(GPIO_RMPL_PXRMP5_3_POS))
#define GPIO_RMPL_PXRMP6                ((uint32_t)0xF<<(GPIO_RMPL_PXRMP6_0_POS))
#define GPIO_RMPL_PXRMP6_0              ((uint32_t)1<<(GPIO_RMPL_PXRMP6_0_POS))
#define GPIO_RMPL_PXRMP6_1              ((uint32_t)1<<(GPIO_RMPL_PXRMP6_1_POS))
#define GPIO_RMPL_PXRMP6_2              ((uint32_t)1<<(GPIO_RMPL_PXRMP6_2_POS))
#define GPIO_RMPL_PXRMP6_3              ((uint32_t)1<<(GPIO_RMPL_PXRMP6_3_POS))
#define GPIO_RMPL_PXRMP7                ((uint32_t)0xF<<(GPIO_RMPL_PXRMP7_0_POS))
#define GPIO_RMPL_PXRMP7_0              ((uint32_t)1<<(GPIO_RMPL_PXRMP7_0_POS))
#define GPIO_RMPL_PXRMP7_1              ((uint32_t)1<<(GPIO_RMPL_PXRMP7_1_POS))
#define GPIO_RMPL_PXRMP7_2              ((uint32_t)1<<(GPIO_RMPL_PXRMP7_2_POS))
#define GPIO_RMPL_PXRMP7_3              ((uint32_t)1<<(GPIO_RMPL_PXRMP7_3_POS))

/* GPIO_RMPH λ */
#define GPIO_RMPH_PXRMP8_0_POS          (0)
#define GPIO_RMPH_PXRMP8_1_POS          (1)
#define GPIO_RMPH_PXRMP8_2_POS          (2)
#define GPIO_RMPH_PXRMP8_3_POS          (3)
#define GPIO_RMPH_PXRMP9_0_POS          (4)
#define GPIO_RMPH_PXRMP9_1_POS          (5)
#define GPIO_RMPH_PXRMP9_2_POS          (6)
#define GPIO_RMPH_PXRMP9_3_POS          (7)
#define GPIO_RMPH_PXRMP10_0_POS         (8)
#define GPIO_RMPH_PXRMP10_1_POS         (9)
#define GPIO_RMPH_PXRMP10_2_POS         (10)
#define GPIO_RMPH_PXRMP10_3_POS         (11)
#define GPIO_RMPH_PXRMP11_0_POS         (12)
#define GPIO_RMPH_PXRMP11_1_POS         (13)
#define GPIO_RMPH_PXRMP11_2_POS         (14)
#define GPIO_RMPH_PXRMP11_3_POS         (15)
#define GPIO_RMPH_PXRMP12_0_POS         (16)
#define GPIO_RMPH_PXRMP12_1_POS         (17)
#define GPIO_RMPH_PXRMP12_2_POS         (18)
#define GPIO_RMPH_PXRMP12_3_POS         (19)
#define GPIO_RMPH_PXRMP13_0_POS         (20)
#define GPIO_RMPH_PXRMP13_1_POS         (21)
#define GPIO_RMPH_PXRMP13_2_POS         (22)
#define GPIO_RMPH_PXRMP13_3_POS         (23)
#define GPIO_RMPH_PXRMP14_0_POS         (24)
#define GPIO_RMPH_PXRMP14_1_POS         (25)
#define GPIO_RMPH_PXRMP14_2_POS         (26)
#define GPIO_RMPH_PXRMP14_3_POS         (27)
#define GPIO_RMPH_PXRMP15_0_POS         (28)
#define GPIO_RMPH_PXRMP15_1_POS         (29)
#define GPIO_RMPH_PXRMP15_2_POS         (30)
#define GPIO_RMPH_PXRMP15_3_POS         (31)
#define GPIO_RMPH_PXRMP8                ((uint32_t)0xF<<(GPIO_RMPH_PXRMP8_0_POS))
#define GPIO_RMPH_PXRMP8_0              ((uint32_t)1<<(GPIO_RMPH_PXRMP8_0_POS))
#define GPIO_RMPH_PXRMP8_1              ((uint32_t)1<<(GPIO_RMPH_PXRMP8_1_POS))
#define GPIO_RMPH_PXRMP8_2              ((uint32_t)1<<(GPIO_RMPH_PXRMP8_2_POS))
#define GPIO_RMPH_PXRMP8_3              ((uint32_t)1<<(GPIO_RMPH_PXRMP8_3_POS))
#define GPIO_RMPH_PXRMP9                ((uint32_t)0xF<<(GPIO_RMPH_PXRMP9_0_POS))
#define GPIO_RMPH_PXRMP9_0              ((uint32_t)1<<(GPIO_RMPH_PXRMP9_0_POS))
#define GPIO_RMPH_PXRMP9_1              ((uint32_t)1<<(GPIO_RMPH_PXRMP9_1_POS))
#define GPIO_RMPH_PXRMP9_2              ((uint32_t)1<<(GPIO_RMPH_PXRMP9_2_POS))
#define GPIO_RMPH_PXRMP9_3              ((uint32_t)1<<(GPIO_RMPH_PXRMP9_3_POS))
#define GPIO_RMPH_PXRMP10               ((uint32_t)0xF<<(GPIO_RMPH_PXRMP10_0_POS))
#define GPIO_RMPH_PXRMP10_0             ((uint32_t)1<<(GPIO_RMPH_PXRMP10_0_POS))
#define GPIO_RMPH_PXRMP10_1             ((uint32_t)1<<(GPIO_RMPH_PXRMP10_1_POS))
#define GPIO_RMPH_PXRMP10_2             ((uint32_t)1<<(GPIO_RMPH_PXRMP10_2_POS))
#define GPIO_RMPH_PXRMP10_3             ((uint32_t)1<<(GPIO_RMPH_PXRMP10_3_POS))
#define GPIO_RMPH_PXRMP11               ((uint32_t)0xF<<(GPIO_RMPH_PXRMP11_0_POS))
#define GPIO_RMPH_PXRMP11_0             ((uint32_t)1<<(GPIO_RMPH_PXRMP11_0_POS))
#define GPIO_RMPH_PXRMP11_1             ((uint32_t)1<<(GPIO_RMPH_PXRMP11_1_POS))
#define GPIO_RMPH_PXRMP11_2             ((uint32_t)1<<(GPIO_RMPH_PXRMP11_2_POS))
#define GPIO_RMPH_PXRMP11_3             ((uint32_t)1<<(GPIO_RMPH_PXRMP11_3_POS))
#define GPIO_RMPH_PXRMP12               ((uint32_t)0xF<<(GPIO_RMPH_PXRMP12_0_POS))
#define GPIO_RMPH_PXRMP12_0             ((uint32_t)1<<(GPIO_RMPH_PXRMP12_0_POS))
#define GPIO_RMPH_PXRMP12_1             ((uint32_t)1<<(GPIO_RMPH_PXRMP12_1_POS))
#define GPIO_RMPH_PXRMP12_2             ((uint32_t)1<<(GPIO_RMPH_PXRMP12_2_POS))
#define GPIO_RMPH_PXRMP12_3             ((uint32_t)1<<(GPIO_RMPH_PXRMP12_3_POS))
#define GPIO_RMPH_PXRMP13               ((uint32_t)0xF<<(GPIO_RMPH_PXRMP13_0_POS))
#define GPIO_RMPH_PXRMP13_0             ((uint32_t)1<<(GPIO_RMPH_PXRMP13_0_POS))
#define GPIO_RMPH_PXRMP13_1             ((uint32_t)1<<(GPIO_RMPH_PXRMP13_1_POS))
#define GPIO_RMPH_PXRMP13_2             ((uint32_t)1<<(GPIO_RMPH_PXRMP13_2_POS))
#define GPIO_RMPH_PXRMP13_3             ((uint32_t)1<<(GPIO_RMPH_PXRMP13_3_POS))
#define GPIO_RMPH_PXRMP14               ((uint32_t)0xF<<(GPIO_RMPH_PXRMP14_0_POS))
#define GPIO_RMPH_PXRMP14_0             ((uint32_t)1<<(GPIO_RMPH_PXRMP14_0_POS))
#define GPIO_RMPH_PXRMP14_1             ((uint32_t)1<<(GPIO_RMPH_PXRMP14_1_POS))
#define GPIO_RMPH_PXRMP14_2             ((uint32_t)1<<(GPIO_RMPH_PXRMP14_2_POS))
#define GPIO_RMPH_PXRMP14_3             ((uint32_t)1<<(GPIO_RMPH_PXRMP14_3_POS))
#define GPIO_RMPH_PXRMP15               ((uint32_t)0xF<<(GPIO_RMPH_PXRMP15_0_POS))
#define GPIO_RMPH_PXRMP15_0             ((uint32_t)1<<(GPIO_RMPH_PXRMP15_0_POS))
#define GPIO_RMPH_PXRMP15_1             ((uint32_t)1<<(GPIO_RMPH_PXRMP15_1_POS))
#define GPIO_RMPH_PXRMP15_2             ((uint32_t)1<<(GPIO_RMPH_PXRMP15_2_POS))
#define GPIO_RMPH_PXRMP15_3             ((uint32_t)1<<(GPIO_RMPH_PXRMP15_3_POS))

/* GPIO_RMP_MSB λ */
#define GPIO_RMP_MSBL0_POS		      	(0)
#define GPIO_RMP_MSBL1_POS		      	(1)
#define GPIO_RMP_MSBL2_POS		      	(2)
#define GPIO_RMP_MSBL3_POS		      	(3)
#define GPIO_RMP_MSBL4_POS		      	(4)
#define GPIO_RMP_MSBL5_POS		      	(5)
#define GPIO_RMP_MSBL6_POS		      	(6)
#define GPIO_RMP_MSBL7_POS		      	(7)
#define GPIO_RMP_MSBL8_POS		      	(8)
#define GPIO_RMP_MSBL9_POS		      	(9)
#define GPIO_RMP_MSBL10_POS	      		(10)
#define GPIO_RMP_MSBL11_POS	      		(11)
#define GPIO_RMP_MSBL12_POS	      		(12)
#define GPIO_RMP_MSBL13_POS	      		(13)
#define GPIO_RMP_MSBL14_POS	      		(14)
#define GPIO_RMP_MSBL15_POS				(15)
#define GPIO_RMP_MSBH0_POS		    	(16)
#define GPIO_RMP_MSBH1_POS		   	 	(17)
#define GPIO_RMP_MSBH2_POS		  	 	(18)
#define GPIO_RMP_MSBH3_POS		    	(19)
#define GPIO_RMP_MSBH4_POS		    	(20)
#define GPIO_RMP_MSBH5_POS		    	(21)
#define GPIO_RMP_MSBH6_POS		    	(22)
#define GPIO_RMP_MSBH7_POS		    	(23)
#define GPIO_RMP_MSBH8_POS		    	(24)
#define GPIO_RMP_MSBH9_POS		    	(25)
#define GPIO_RMP_MSBH10_POS		    	(26)
#define GPIO_RMP_MSBH11_POS		    	(27)
#define GPIO_RMP_MSBH12_POS		    	(28)
#define GPIO_RMP_MSBH13_POS		    	(29)
#define GPIO_RMP_MSBH14_POS		    	(30)
#define GPIO_RMP_MSBH15_POS		    	(31)
#define GPIO_RMP_MSBL					((uint32_t)0xFFFF<<(GPIO_RMP_MSBL0_POS))
#define GPIO_RMP_MSBL_0					((uint32_t)1<<(GPIO_RMP_MSBL0_POS))
#define GPIO_RMP_MSBL_1					((uint32_t)1<<(GPIO_RMP_MSBL1_POS))
#define GPIO_RMP_MSBL_2					((uint32_t)1<<(GPIO_RMP_MSBL2_POS))
#define GPIO_RMP_MSBL_3					((uint32_t)1<<(GPIO_RMP_MSBL3_POS))
#define GPIO_RMP_MSBL_4					((uint32_t)1<<(GPIO_RMP_MSBL4_POS))
#define GPIO_RMP_MSBL_5					((uint32_t)1<<(GPIO_RMP_MSBL5_POS))
#define GPIO_RMP_MSBL_6					((uint32_t)1<<(GPIO_RMP_MSBL6_POS))
#define GPIO_RMP_MSBL_7					((uint32_t)1<<(GPIO_RMP_MSBL7_POS))
#define GPIO_RMP_MSBL_8					((uint32_t)1<<(GPIO_RMP_MSBL8_POS))
#define GPIO_RMP_MSBL_9					((uint32_t)1<<(GPIO_RMP_MSBL9_POS))
#define GPIO_RMP_MSBL_10				((uint32_t)1<<(GPIO_RMP_MSBL10_POS))
#define GPIO_RMP_MSBL_11				((uint32_t)1<<(GPIO_RMP_MSBL11_POS))
#define GPIO_RMP_MSBL_12				((uint32_t)1<<(GPIO_RMP_MSBL12_POS))
#define GPIO_RMP_MSBL_13				((uint32_t)1<<(GPIO_RMP_MSBL13_POS))
#define GPIO_RMP_MSBL_14				((uint32_t)1<<(GPIO_RMP_MSBL14_POS))
#define GPIO_RMP_MSBL_15				((uint32_t)1<<(GPIO_RMP_MSBL15_POS))
#define GPIO_RMP_MSBH					((uint32_t)0xFFFF<<(GPIO_RMP_MSBH_16_POS))
#define GPIO_RMP_MSBH0					((uint32_t)1<<(GPIO_RMP_MSBH0_POS))
#define GPIO_RMP_MSBH1					((uint32_t)1<<(GPIO_RMP_MSBH1_POS))
#define GPIO_RMP_MSBH2					((uint32_t)1<<(GPIO_RMP_MSBH2_POS))
#define GPIO_RMP_MSBH3					((uint32_t)1<<(GPIO_RMP_MSBH3_POS))
#define GPIO_RMP_MSBH4					((uint32_t)1<<(GPIO_RMP_MSBH4_POS))
#define GPIO_RMP_MSBH5					((uint32_t)1<<(GPIO_RMP_MSBH5_POS))
#define GPIO_RMP_MSBH6					((uint32_t)1<<(GPIO_RMP_MSBH6_POS))
#define GPIO_RMP_MSBH7					((uint32_t)1<<(GPIO_RMP_MSBH7_POS))
#define GPIO_RMP_MSBH8					((uint32_t)1<<(GPIO_RMP_MSBH8_POS))
#define GPIO_RMP_MSBH9					((uint32_t)1<<(GPIO_RMP_MSBH9_POS))
#define GPIO_RMP_MSBH10					((uint32_t)1<<(GPIO_RMP_MSBH10_POS))
#define GPIO_RMP_MSBH11					((uint32_t)1<<(GPIO_RMP_MSBH11_POS))
#define GPIO_RMP_MSBH12					((uint32_t)1<<(GPIO_RMP_MSBH12_POS))
#define GPIO_RMP_MSBH13					((uint32_t)1<<(GPIO_RMP_MSBH13_POS))
#define GPIO_RMP_MSBH14					((uint32_t)1<<(GPIO_RMP_MSBH14_POS))
#define GPIO_RMP_MSBH15					((uint32_t)1<<(GPIO_RMP_MSBH15_POS))
/* ͨ˿(GPIO) */

#endif

#if 1										/* OSC */

/* ----------------------------------------------------------------------------
   -- (OSC)
   ---------------------------------------------------------------------------- */
/* OSC - Ĵڴṹ */
typedef struct OSC_MemMap
{
    volatile uint32_t CTL0;             /* ƼĴ0, ƫ:0x00 */
    volatile uint32_t CTL1;             /* ƼĴ1, ƫ:0x04 */
    volatile uint32_t INT;              /* жϿƼĴ, ƫ:0x08 */
    volatile uint32_t CTL2;             /* ƼĴ2, ƫ:0x0C */
    volatile uint32_t HFOSCCAL0;        /* ƵУ׼Ĵ0, ƫ:0x10 */
    volatile uint32_t HFOSCCAL1;        /* ƵУ׼Ĵ1, ƫ:0x14 */
}OSC_SFRmap;

/* PLL - Ĵڴṹ */
typedef struct PLL_MenMap
{
	volatile uint32_t CTL;				/* PLLƼĴƫƣ0x00 */
}PLL_SFRmap;

/* ----------------------------------------------------------------------------
   -- OSC - Ĵں
   ---------------------------------------------------------------------------- */
/* OSC - Ĵڵַ */
#define OSC_ADDR                        ((uint32_t)0x40000000)
#define OSC_SFR							((OSC_SFRmap *)OSC_ADDR)
#define PLL_ADDR						((uint32_t)0x40002580)
#define PLL_SFR							((PLL_SFRmap *)PLL_ADDR)

/* OSC - Ĵ */
#define OSC_CTL0                        (OSC_SFR->CTL0)
#define OSC_CTL1                        (OSC_SFR->CTL1)
#define OSC_INT                         (OSC_SFR->INT)
#define OSC_CTL2                        (OSC_SFR->CTL2)
#define OSC_HFOSCCAL0                   (OSC_SFR->HFOSCCAL0)
#define OSC_HFOSCCAL1                   (OSC_SFR->HFOSCCAL1)
#define PLL_CTL                         (PLL_SFR->CTL)

/* OSC_CTL0 λ */
#define OSC_CTL0_PMWREN_POS             (0)
#define OSC_CTL0_SCKS0_POS              (1)
#define OSC_CTL0_SCKS1_POS              (2)
#define OSC_CTL0_SCKS2_POS              (3)
#define OSC_CTL0_LFCKEN_POS             (4)
#define OSC_CTL0_LFCKS_POS              (6)
#define OSC_CTL0_HFCKEN_POS             (8)
#define OSC_CTL0_HFCKS0_POS             (9)
#define OSC_CTL0_HFCKS1_POS             (10)
#define OSC_CTL0_HFCKS2_POS             (11)
#define OSC_CTL0_PLLCKS_POS             (12)
#define OSC_CTL0_SCKDIV0_POS            (16)
#define OSC_CTL0_SCKDIV1_POS            (17)
#define OSC_CTL0_SCKDIV2_POS            (18)
#define OSC_CTL0_HFCKDIV0_POS           (20)
#define OSC_CTL0_HFCKDIV1_POS           (21)
#define OSC_CTL0_HFCKDIV2_POS           (22)
#define OSC_CTL0_HFCKDIV3_POS           (23)
#define OSC_CTL0_LFCKDIV0_POS           (24)
#define OSC_CTL0_LFCKDIV1_POS           (25)
#define OSC_CTL0_LFCKDIV2_POS           (26)
#define OSC_CTL0_PMWREN                 ((uint32_t)1<<(OSC_CTL0_PMWREN_POS))
#define OSC_CTL0_SCKS                   ((uint32_t)7<<(OSC_CTL0_SCKS0_POS))
#define OSC_CTL0_SCKS0                  ((uint32_t)1<<(OSC_CTL0_SCKS0_POS))
#define OSC_CTL0_SCKS1                  ((uint32_t)1<<(OSC_CTL0_SCKS1_POS))
#define OSC_CTL0_SCKS2                  ((uint32_t)1<<(OSC_CTL0_SCKS2_POS))
#define OSC_CTL0_LFCKEN                 ((uint32_t)1<<(OSC_CTL0_LFCKEN_POS))
#define OSC_CTL0_LFCKS                  ((uint32_t)1<<(OSC_CTL0_LFCKS_POS))
#define OSC_CTL0_HFCKEN                 ((uint32_t)1<<(OSC_CTL0_HFCKEN_POS))
#define OSC_CTL0_HFCKS                  ((uint32_t)7<<(OSC_CTL0_HFCKS0_POS))
#define OSC_CTL0_HFCKS0                 ((uint32_t)1<<(OSC_CTL0_HFCKS0_POS))
#define OSC_CTL0_HFCKS1                 ((uint32_t)1<<(OSC_CTL0_HFCKS1_POS))
#define OSC_CTL0_HFCKS2                 ((uint32_t)1<<(OSC_CTL0_HFCKS2_POS))
#define OSC_CTL0_PLLCKS                 ((uint32_t)1<<(OSC_CTL0_PLLCKS_POS))
#define OSC_CTL0_SCKDIV                 ((uint32_t)7<<(OSC_CTL0_SCKDIV0_POS))
#define OSC_CTL0_SCKDIV0                ((uint32_t)1<<(OSC_CTL0_SCKDIV0_POS))
#define OSC_CTL0_SCKDIV1                ((uint32_t)1<<(OSC_CTL0_SCKDIV1_POS))
#define OSC_CTL0_SCKDIV2                ((uint32_t)1<<(OSC_CTL0_SCKDIV2_POS))
#define OSC_CTL0_HFCKDIV                ((uint32_t)0xF<<(OSC_CTL0_HFCKDIV0_POS))
#define OSC_CTL0_HFCKDIV0               ((uint32_t)1<<(OSC_CTL0_HFCKDIV0_POS))
#define OSC_CTL0_HFCKDIV1               ((uint32_t)1<<(OSC_CTL0_HFCKDIV1_POS))
#define OSC_CTL0_HFCKDIV2               ((uint32_t)1<<(OSC_CTL0_HFCKDIV2_POS))
#define OSC_CTL0_HFCKDIV3               ((uint32_t)1<<(OSC_CTL0_HFCKDIV3_POS))
#define OSC_CTL0_LFCKDIV                ((uint32_t)7<<(OSC_CTL0_LFCKDIV0_POS))
#define OSC_CTL0_LFCKDIV0               ((uint32_t)1<<(OSC_CTL0_LFCKDIV0_POS))
#define OSC_CTL0_LFCKDIV1               ((uint32_t)1<<(OSC_CTL0_LFCKDIV1_POS))
#define OSC_CTL0_LFCKDIV2               ((uint32_t)1<<(OSC_CTL0_LFCKDIV2_POS))

/* OSC_CTL1 λ */
#define OSC_CTL1_FSCM_POS               (16)
#define OSC_CTL1_FSCMGAP0_POS			(17)
#define OSC_CTL1_FSCMGAP1_POS			(18)
#define OSC_CTL1_FSCMGAP2_POS			(19)
#define OSC_CTL1_FSCMS0_POS				(21)
#define OSC_CTL1_FSCMS1_POS				(22)
#define OSC_CTL1_FSCMS2_POS				(23)
#define OSC_CTL1_CLKOUTS0_POS           (25)
#define OSC_CTL1_CLKOUTS1_POS           (26)
#define OSC_CTL1_CLKOUTS2_POS           (27)
#define OSC_CTL1_CLKOE_POS              (28)
#define OSC_CTL1_CLKOUTDIV0_POS         (29)
#define OSC_CTL1_CLKOUTDIV1_POS         (30)
#define OSC_CTL1_CLKOUTDIV2_POS         (31)
#define OSC_CTL1_FSCM                   ((uint32_t)1<<(OSC_CTL1_FSCM_POS))
#define OSC_CTL1_FSCMGAP				((uint32_t)0x07<<(OSC_CTL1_FSCMGAP0_POS))
#define OSC_CTL1_FSCMGAP0				((uint32_t)1<<(OSC_CTL1_FSCMGAP0_POS))
#define OSC_CTL1_FSCMGAP1				((uint32_t)1<<(OSC_CTL1_FSCMGAP1_POS))
#define OSC_CTL1_FSCMGAP2				((uint32_t)1<<(OSC_CTL1_FSCMGAP2_POS))
#define OSC_CTL1_FSCMS  				((uint32_t)0x07<<(OSC_CTL1_FSCMS0_POS))
#define OSC_CTL1_FSCMS0 				((uint32_t)1<<(OSC_CTL1_FSCMS0_POS))
#define OSC_CTL1_FSCMS1 				((uint32_t)1<<(OSC_CTL1_FSCMS1_POS))
#define OSC_CTL1_FSCMS2 				((uint32_t)1<<(OSC_CTL1_FSCMS2_POS))
#define OSC_CTL1_CLKOUTS                ((uint32_t)0x07<<(OSC_CTL1_CLKOUTS0_POS))
#define OSC_CTL1_CLKOUTS0               ((uint32_t)1<<(OSC_CTL1_CLKOUTS0_POS))
#define OSC_CTL1_CLKOUTS1               ((uint32_t)1<<(OSC_CTL1_CLKOUTS1_POS))
#define OSC_CTL1_CLKOUTS2               ((uint32_t)1<<(OSC_CTL1_CLKOUTS2_POS))
#define OSC_CTL1_CLKOE                  ((uint32_t)1<<(OSC_CTL1_CLKOE_POS))
#define OSC_CTL1_CLKOUTDIV              ((uint32_t)7<<(OSC_CTL1_CLKOUTDIV0_POS))
#define OSC_CTL1_CLKOUTDIV0             ((uint32_t)1<<(OSC_CTL1_CLKOUTDIV0_POS))
#define OSC_CTL1_CLKOUTDIV1             ((uint32_t)1<<(OSC_CTL1_CLKOUTDIV1_POS))
#define OSC_CTL1_CLKOUTDIV2             ((uint32_t)1<<(OSC_CTL1_CLKOUTDIV2_POS))


/* OSC_INT λ */
#define OSC_INT_ILFIF_POS               (0)
#define OSC_INT_IHFIF_POS               (1)
#define OSC_INT_ELFIF_POS               (2)
#define OSC_INT_EHFIF_POS               (3)
#define OSC_INT_PLLIF_POS               (4)
#define OSC_INT_LP4MIF_POS              (6)
#define OSC_INT_CKFIF_POS               (7)
#define OSC_INT_ILFIE_POS               (8)
#define OSC_INT_IHFIE_POS               (9)
#define OSC_INT_ELFIE_POS               (10)
#define OSC_INT_EHFIE_POS               (11)
#define OSC_INT_PLLIE_POS               (12)
#define OSC_INT_LP4MIE_POS              (14)
#define OSC_INT_ILFIF                   ((uint32_t)1<<(OSC_INT_ILFIF_POS))
#define OSC_INT_IHFIF                   ((uint32_t)1<<(OSC_INT_IHFIF_POS))
#define OSC_INT_ELFIF                   ((uint32_t)1<<(OSC_INT_ELFIF_POS))
#define OSC_INT_EHFIF                   ((uint32_t)1<<(OSC_INT_EHFIF_POS))
#define OSC_INT_PLLIF                   ((uint32_t)1<<(OSC_INT_PLLIF_POS))
#define OSC_INT_LP4MIF                  ((uint32_t)1<<(OSC_INT_LP4MIF_POS))
#define OSC_INT_CKFIF                   ((uint32_t)1<<(OSC_INT_CKFIF_POS))
#define OSC_INT_ILFIE                   ((uint32_t)1<<(OSC_INT_ILFIE_POS))
#define OSC_INT_IHFIE                   ((uint32_t)1<<(OSC_INT_IHFIE_POS))
#define OSC_INT_ELFIE                   ((uint32_t)1<<(OSC_INT_ELFIE_POS))
#define OSC_INT_EHFIE                   ((uint32_t)1<<(OSC_INT_EHFIE_POS))
#define OSC_INT_PLLIE                   ((uint32_t)1<<(OSC_INT_PLLIE_POS))
#define OSC_INT_LP4MIE                  ((uint32_t)1<<(OSC_INT_LP4MIE_POS))

/* OSC_CTL2 λ */
#define OSC_CTL2_INTLFSWEN_POS          (0)
#define OSC_CTL2_INTHFSWEN_POS          (1)
#define OSC_CTL2_EXTLFSWEN_POS          (2)
#define OSC_CTL2_EXTHFSWEN_POS          (3)
#define OSC_CTL2_PLLSWEN_POS            (4)
#define OSC_CTL2_LP4MSWEN_POS           (6)
#define OSC_CTL2_ELFDLY0_POS            (16)
#define OSC_CTL2_ELFDLY1_POS            (17)
#define OSC_CTL2_ELFDLY2_POS            (18)
#define OSC_CTL2_ELFDLY3_POS            (19)
#define OSC_CTL2_EHFDLY0_POS            (20)
#define OSC_CTL2_EHFDLY1_POS            (21)
#define OSC_CTL2_EHFDLY2_POS            (22)
#define OSC_CTL2_EHFDLY3_POS            (23)
#define OSC_CTL2_PLLDLY0_POS            (24)
#define OSC_CTL2_PLLDLY1_POS            (25)
#define OSC_CTL2_PLLDLY2_POS            (26)
#define OSC_CTL2_PLLDLY3_POS            (27)
#define OSC_CTL2_INTLFSWEN              ((uint32_t)1<<(OSC_CTL2_INTLFSWEN_POS))
#define OSC_CTL2_INTHFSWEN              ((uint32_t)1<<(OSC_CTL2_INTHFSWEN_POS))
#define OSC_CTL2_EXTLFSWEN              ((uint32_t)1<<(OSC_CTL2_EXTLFSWEN_POS))
#define OSC_CTL2_EXTHFSWEN              ((uint32_t)1<<(OSC_CTL2_EXTHFSWEN_POS))
#define OSC_CTL2_PLLSWEN                ((uint32_t)1<<(OSC_CTL2_PLL0SWEN_POS))
#define OSC_CTL2_LP4MSWEN               ((uint32_t)1<<(OSC_CTL2_LP4MSWEN_POS))
#define OSC_CTL2_ELFDLY                 ((uint32_t)0x0F<<(OSC_CTL2_ELFDLY0_POS))
#define OSC_CTL2_ELFDLY0                ((uint32_t)1<<(OSC_CTL2_ELFDLY0_POS))
#define OSC_CTL2_ELFDLY1                ((uint32_t)1<<(OSC_CTL2_ELFDLY1_POS))
#define OSC_CTL2_ELFDLY2                ((uint32_t)1<<(OSC_CTL2_ELFDLY2_POS))
#define OSC_CTL2_ELFDLY3                ((uint32_t)1<<(OSC_CTL2_ELFDLY3_POS))
#define OSC_CTL2_EHFDLY                 ((uint32_t)0x0F<<(OSC_CTL2_EHFDLY0_POS))
#define OSC_CTL2_EHFDLY0                ((uint32_t)1<<(OSC_CTL2_EHFDLY0_POS))
#define OSC_CTL2_EHFDLY1                ((uint32_t)1<<(OSC_CTL2_EHFDLY1_POS))
#define OSC_CTL2_EHFDLY2                ((uint32_t)1<<(OSC_CTL2_EHFDLY2_POS))
#define OSC_CTL2_EHFDLY3                ((uint32_t)1<<(OSC_CTL2_EHFDLY3_POS))
#define OSC_CTL2_PLLDLY                 ((uint32_t)0x0F<<(OSC_CTL2_PLLDLY0_POS))
#define OSC_CTL2_PLLDLY0                ((uint32_t)1<<(OSC_CTL2_PLLDLY0_POS))
#define OSC_CTL2_PLLDLY1                ((uint32_t)1<<(OSC_CTL2_PLLDLY1_POS))
#define OSC_CTL2_PLLDLY2                ((uint32_t)1<<(OSC_CTL2_PLLDLY2_POS))
#define OSC_CTL2_PLLDLY3                ((uint32_t)1<<(OSC_CTL2_PLLDLY3_POS))

/* OSC_CTL2 λ */
#define OSC_CTL2_INTLFSWEN_POS          (0)
#define OSC_CTL2_INTHFSWEN_POS          (1)
#define OSC_CTL2_EXTLFSWEN_POS          (2)
#define OSC_CTL2_EXTHFSWEN_POS          (3)
#define OSC_CTL2_PLLSWEN_POS            (4)
#define OSC_CTL2_LP4MSWEN_POS           (6)
#define OSC_CTL2_ELFDLY0_POS            (16)
#define OSC_CTL2_ELFDLY1_POS            (17)
#define OSC_CTL2_ELFDLY2_POS            (18)
#define OSC_CTL2_ELFDLY3_POS            (19)
#define OSC_CTL2_EHFDLY0_POS            (20)
#define OSC_CTL2_EHFDLY1_POS            (21)
#define OSC_CTL2_EHFDLY2_POS            (22)
#define OSC_CTL2_EHFDLY3_POS            (23)
#define OSC_CTL2_PLLDLY0_POS            (24)
#define OSC_CTL2_PLLDLY1_POS            (25)
#define OSC_CTL2_PLLDLY2_POS            (26)
#define OSC_CTL2_PLLDLY3_POS            (27)
#define OSC_CTL2_INTLFSWEN              ((uint32_t)1<<(OSC_CTL2_INTLFSWEN_POS))
#define OSC_CTL2_INTHFSWEN              ((uint32_t)1<<(OSC_CTL2_INTHFSWEN_POS))
#define OSC_CTL2_EXTLFSWEN              ((uint32_t)1<<(OSC_CTL2_EXTLFSWEN_POS))
#define OSC_CTL2_EXTHFSWEN              ((uint32_t)1<<(OSC_CTL2_EXTHFSWEN_POS))
#define OSC_CTL2_PLLSWEN                ((uint32_t)1<<(OSC_CTL2_PLL0SWEN_POS))
#define OSC_CTL2_LP4MSWEN               ((uint32_t)1<<(OSC_CTL2_LP4MSWEN_POS))
#define OSC_CTL2_ELFDLY                 ((uint32_t)0x0F<<(OSC_CTL2_ELFDLY0_POS))
#define OSC_CTL2_ELFDLY0                ((uint32_t)1<<(OSC_CTL2_ELFDLY0_POS))
#define OSC_CTL2_ELFDLY1                ((uint32_t)1<<(OSC_CTL2_ELFDLY1_POS))
#define OSC_CTL2_ELFDLY2                ((uint32_t)1<<(OSC_CTL2_ELFDLY2_POS))
#define OSC_CTL2_ELFDLY3                ((uint32_t)1<<(OSC_CTL2_ELFDLY3_POS))
#define OSC_CTL2_EHFDLY                 ((uint32_t)0x0F<<(OSC_CTL2_EHFDLY0_POS))
#define OSC_CTL2_EHFDLY0                ((uint32_t)1<<(OSC_CTL2_EHFDLY0_POS))
#define OSC_CTL2_EHFDLY1                ((uint32_t)1<<(OSC_CTL2_EHFDLY1_POS))
#define OSC_CTL2_EHFDLY2                ((uint32_t)1<<(OSC_CTL2_EHFDLY2_POS))
#define OSC_CTL2_EHFDLY3                ((uint32_t)1<<(OSC_CTL2_EHFDLY3_POS))
#define OSC_CTL2_PLLDLY                 ((uint32_t)0x0F<<(OSC_CTL2_PLLDLY0_POS))
#define OSC_CTL2_PLLDLY0                ((uint32_t)1<<(OSC_CTL2_PLLDLY0_POS))
#define OSC_CTL2_PLLDLY1                ((uint32_t)1<<(OSC_CTL2_PLLDLY1_POS))
#define OSC_CTL2_PLLDLY2                ((uint32_t)1<<(OSC_CTL2_PLLDLY2_POS))
#define OSC_CTL2_PLLDLY3                ((uint32_t)1<<(OSC_CTL2_PLLDLY3_POS))

/* OSC_HFOSCCAL0 λ */
#define OSC_HFOSCCAL0_CTAT0_POS         (0)
#define OSC_HFOSCCAL0_CTAT1_POS         (1)
#define OSC_HFOSCCAL0_CTAT2_POS         (2)
#define OSC_HFOSCCAL0_CTAT3_POS         (3)
#define OSC_HFOSCCAL0_CTAT4_POS         (4)
#define OSC_HFOSCCAL0_PTAT0_POS         (5)
#define OSC_HFOSCCAL0_PTAT1_POS         (6)
#define OSC_HFOSCCAL0_PTAT2_POS         (7)
#define OSC_HFOSCCAL0_PTAT3_POS         (8)
#define OSC_HFOSCCAL0_PTAT4_POS         (9)
#define OSC_HFOSCCAL0_OSCLVBGTRIM0_POS	(10)
#define OSC_HFOSCCAL0_OSCLVBGTRIM1_POS	(11)
#define OSC_HFOSCCAL0_OSCLVBGTRIM2_POS	(12)
#define OSC_HFOSCCAL0_HSIHIGRADE_POS	(13)
#define OSC_HFOSCCAL0_SCALEDIV32_POS    (17)
#define OSC_HFOSCCAL0_SCALEDIV16_POS    (18)
#define OSC_HFOSCCAL0_SCALEDIV8_POS     (19)
#define OSC_HFOSCCAL0_SCALEDIV4_POS     (20)
#define OSC_HFOSCCAL0_SCALEDIV2_POS     (21)
#define OSC_HFOSCCAL0_SCALE1X_POS       (22)
#define OSC_HFOSCCAL0_SCALE2X_POS       (23)
#define OSC_HFOSCCAL0_SCALE4X_POS       (24)
#define OSC_HFOSCCAL0_SCALE8X_POS       (25)
#define OSC_HFOSCCAL0_SCALE16X0_POS     (26)
#define OSC_HFOSCCAL0_SCALE16X1_POS     (27)
#define OSC_HFOSCCAL0_SCALE16X2_POS     (28)
#define OSC_HFOSCCAL0_SCALE16X3_POS     (29)
#define OSC_HFOSCCAL0_SCALE16X4_POS     (30)
#define OSC_HFOSCCAL0_SCALE32X_POS      (31)
#define OSC_HFOSCCAL0_CTAT              ((uint32_t)0x1F<<(OSC_HFOSCCAL0_CTAT0_POS))
#define OSC_HFOSCCAL0_CTAT0             ((uint32_t)1<<(OSC_HFOSCCAL0_CTAT0_POS))
#define OSC_HFOSCCAL0_CTAT1             ((uint32_t)1<<(OSC_HFOSCCAL0_CTAT1_POS))
#define OSC_HFOSCCAL0_CTAT2             ((uint32_t)1<<(OSC_HFOSCCAL0_CTAT2_POS))
#define OSC_HFOSCCAL0_CTAT3             ((uint32_t)1<<(OSC_HFOSCCAL0_CTAT3_POS))
#define OSC_HFOSCCAL0_CTAT4             ((uint32_t)1<<(OSC_HFOSCCAL0_CTAT4_POS))
#define OSC_HFOSCCAL0_PTAT              ((uint32_t)0x1F<<(OSC_HFOSCCAL0_PTAT0_POS))
#define OSC_HFOSCCAL0_PTAT0             ((uint32_t)1<<(OSC_HFOSCCAL0_PTAT0_POS))
#define OSC_HFOSCCAL0_PTAT1             ((uint32_t)1<<(OSC_HFOSCCAL0_PTAT1_POS))
#define OSC_HFOSCCAL0_PTAT2             ((uint32_t)1<<(OSC_HFOSCCAL0_PTAT2_POS))
#define OSC_HFOSCCAL0_PTAT3             ((uint32_t)1<<(OSC_HFOSCCAL0_PTAT3_POS))
#define OSC_HFOSCCAL0_PTAT4             ((uint32_t)1<<(OSC_HFOSCCAL0_PTAT4_POS))
#define OSC_HFOSCCAL0_OSCLVBGTRIM		((uint32_t)0x07<<(OSC_HFOSCCAL0_OSCLVBGTRIM0_POS))
#define OSC_HFOSCCAL0_OSCLVBGTRIM0		((uint32_t)1<<(OSC_HFOSCCAL0_OSCLVBGTRIM0_POS))
#define OSC_HFOSCCAL0_OSCLVBGTRIM1		((uint32_t)1<<(OSC_HFOSCCAL0_OSCLVBGTRIM1_POS))
#define OSC_HFOSCCAL0_OSCLVBGTRIM2		((uint32_t)1<<(OSC_HFOSCCAL0_OSCLVBGTRIM2_POS))
#define OSC_HFOSCCAL0_HSIHIGRADE		((uint32_t)1<<(OSC_HFOSCCAL0_HSIHIGRADE_POS))
#define OSC_HFOSCCAL0_SCALEDIV32        ((uint32_t)1<<(OSC_HFOSCCAL0_SCALEDIV32_POS))
#define OSC_HFOSCCAL0_SCALEDIV16        ((uint32_t)1<<(OSC_HFOSCCAL0_SCALEDIV16_POS))
#define OSC_HFOSCCAL0_SCALEDIV8         ((uint32_t)1<<(OSC_HFOSCCAL0_SCALEDIV8_POS))
#define OSC_HFOSCCAL0_SCALEDIV4         ((uint32_t)1<<(OSC_HFOSCCAL0_SCALEDIV4_POS))
#define OSC_HFOSCCAL0_SCALEDIV2         ((uint32_t)1<<(OSC_HFOSCCAL0_SCALEDIV2_POS))
#define OSC_HFOSCCAL0_SCALE1X           ((uint32_t)1<<(OSC_HFOSCCAL0_SCALE1X_POS))
#define OSC_HFOSCCAL0_SCALE2X           ((uint32_t)1<<(OSC_HFOSCCAL0_SCALE2X_POS))
#define OSC_HFOSCCAL0_SCALE4X           ((uint32_t)1<<(OSC_HFOSCCAL0_SCALE4X_POS))
#define OSC_HFOSCCAL0_SCALE8X           ((uint32_t)1<<(OSC_HFOSCCAL0_SCALE8X_POS))
#define OSC_HFOSCCAL0_SCALE16X          ((uint32_t)0x1F<<(OSC_HFOSCCAL0_SCALE16X0_POS))
#define OSC_HFOSCCAL0_SCALE16X0         ((uint32_t)1<<(OSC_HFOSCCAL0_SCALE16X0_POS))
#define OSC_HFOSCCAL0_SCALE16X1         ((uint32_t)1<<(OSC_HFOSCCAL0_SCALE16X1_POS))
#define OSC_HFOSCCAL0_SCALE16X2         ((uint32_t)1<<(OSC_HFOSCCAL0_SCALE16X2_POS))
#define OSC_HFOSCCAL0_SCALE16X3         ((uint32_t)1<<(OSC_HFOSCCAL0_SCALE16X3_POS))
#define OSC_HFOSCCAL0_SCALE16X4         ((uint32_t)1<<(OSC_HFOSCCAL0_SCALE16X4_POS))
#define OSC_HFOSCCAL0_SCALE32X          ((uint32_t)1<<(OSC_HFOSCCAL0_SCALE32X_POS))

/* OSC_HFOSCCAL1 λ */
#define OSC_HFOSCCAL1_HLSW_POS          (0)
#define OSC_HFOSCCAL1_HSXTALEXEN_POS    (1)
#define OSC_HFOSCCAL1_HSFSEN_POS        (2)
#define OSC_HFOSCCAL1_SELGAIN0_POS      (3)
#define OSC_HFOSCCAL1_SELGAIN1_POS      (4)
#define OSC_HFOSCCAL1_HLSW              ((uint32_t)1<<(OSC_HFOSCCAL1_HLSW_POS))
#define OSC_HFOSCCAL1_HSXTALEXEN        ((uint32_t)1<<(OSC_HFOSCCAL1_HSXTALEXEN_POS))
#define OSC_HFOSCCAL1_HSFSEN            ((uint32_t)1<<(OSC_HFOSCCAL1_HSFSEN_POS))
#define OSC_HFOSCCAL1_SELGAIN           ((uint32_t)3<<(OSC_HFOSCCAL1_SELGAIN0_POS))
#define OSC_HFOSCCAL1_SELGAIN0          ((uint32_t)1<<(OSC_HFOSCCAL1_SELGAIN0_POS))
#define OSC_HFOSCCAL1_SELGAIN1          ((uint32_t)1<<(OSC_HFOSCCAL1_SELGAIN1_POS))

/* PLL_CTL λ */
#define PLL_CTL_PDRST_POS               (0)
#define PLL_CTL_M0_POS                  (2)
#define PLL_CTL_M1_POS                  (3)
#define PLL_CTL_M2_POS                  (4)
#define PLL_CTL_M3_POS                  (5)
#define PLL_CTL_M4_POS                  (6)
#define PLL_CTL_M5_POS                  (7)
#define PLL_CTL_M6_POS                  (8)
#define PLL_CTL_M7_POS                  (9)
#define PLL_CTL_M8_POS                  (10)
#define PLL_CTL_M9_POS                  (11)
#define PLL_CTL_M10_POS                 (12)
#define PLL_CTL_M11_POS                 (13)
#define PLL_CTL_M12_POS                 (14)
#define PLL_CTL_M13_POS                 (15)
#define PLL_CTL_N0_POS                  (16)
#define PLL_CTL_N1_POS                  (17)
#define PLL_CTL_N2_POS                  (18)
#define PLL_CTL_N3_POS                  (19)
#define PLL_CTL_OD0_POS                 (20)
#define PLL_CTL_OD1_POS                 (21)
#define PLL_CTL_PDRST                   ((uint32_t)1<<(PLL_CTL_PDRST_POS))
#define PLL_CTL_M                       ((uint32_t)0x3FFF<<(PLL_CTL_M0_POS))
#define PLL_CTL_M0                      ((uint32_t)1<<(PLL_CTL_M0_POS))
#define PLL_CTL_M1                      ((uint32_t)1<<(PLL_CTL_M1_POS))
#define PLL_CTL_M2                      ((uint32_t)1<<(PLL_CTL_M2_POS))
#define PLL_CTL_M3                      ((uint32_t)1<<(PLL_CTL_M3_POS))
#define PLL_CTL_M4                      ((uint32_t)1<<(PLL_CTL_M4_POS))
#define PLL_CTL_M5                      ((uint32_t)1<<(PLL_CTL_M5_POS))
#define PLL_CTL_M6                      ((uint32_t)1<<(PLL_CTL_M6_POS))
#define PLL_CTL_M7                      ((uint32_t)1<<(PLL_CTL_M7_POS))
#define PLL_CTL_M8                      ((uint32_t)1<<(PLL_CTL_M8_POS))
#define PLL_CTL_M9                      ((uint32_t)1<<(PLL_CTL_M9_POS))
#define PLL_CTL_M10                     ((uint32_t)1<<(PLL_CTL_M12_POS))
#define PLL_CTL_M11                     ((uint32_t)1<<(PLL_CTL_M12_POS))
#define PLL_CTL_M12                     ((uint32_t)1<<(PLL_CTL_M12_POS))
#define PLL_CTL_M13                     ((uint32_t)1<<(PLL_CTL_M13_POS))
#define PLL_CTL_N                       ((uint32_t)0xF<<(PLL_CTL_N0_POS))
#define PLL_CTL_N0                      ((uint32_t)1<<(PLL_CTL_N0_POS))
#define PLL_CTL_N1                      ((uint32_t)1<<(PLL_CTL_N1_POS))
#define PLL_CTL_N2                      ((uint32_t)1<<(PLL_CTL_N2_POS))
#define PLL_CTL_N3                      ((uint32_t)1<<(PLL_CTL_N3_POS))
#define PLL_CTL_OD                      ((uint32_t)0x3<<(PLL_CTL_OD0_POS))
#define PLL_CTL_OD0                     ((uint32_t)1<<(PLL_CTL_OD0_POS))
#define PLL_CTL_OD1                     ((uint32_t)1<<(PLL_CTL_OD1_POS))
/* (OSC) */

#endif

#if 1										/* INT */

/* ----------------------------------------------------------------------------
   -- ж(INT)
   ---------------------------------------------------------------------------- */

/* INT - жϼĴڴṹ */
typedef struct INT_MemMap
{
    volatile uint32_t CTL0;             /* жϿƼĴ0, ƫ:0x0000 */
    volatile uint32_t EIE0;             /* жʹܼĴ0, ƫ:0x0004 */
             uint32_t RESERVED1;        /* ַ, ƫ:0x0008 */
    volatile uint32_t EIE1;             /* жʹܼĴ1, ƫ:0x000C */
             uint32_t RESERVED2;        /* ַ, ƫ:0x0010 */
    volatile uint32_t EIE2;             /* жʹܼĴ2, ƫ:0x0014 */
    		 uint32_t RESERVED3;        /* ַ, ƫ:0x0018 */
    volatile uint32_t EIF0;             /* жϱ־λĴ0, ƫ:0x001C */
             uint32_t RESERVED4;        /* ַ, ƫ:0x0020 */
    volatile uint32_t EIF1;             /* жϱ־λĴ1, ƫ:0x0024 */
             uint32_t RESERVED5;        /* ַ, ƫ:0x0028 */
    volatile uint32_t EIF2;             /* жϱ־λĴ2, ƫ:0x002C */
             uint32_t RESERVED6;        /* ַ, ƫ:0x0030 */
    volatile uint32_t IP0;              /* жȼƼĴ0, ƫ:0x0034 */
    volatile uint32_t IP1;              /* жȼƼĴ1, ƫ:0x0038 */
    volatile uint32_t IP2;              /* жȼƼĴ2, ƫ:0x003C */
    volatile uint32_t IP3;              /* жȼƼĴ3, ƫ:0x0040 */
    volatile uint32_t IP4;              /* жȼƼĴ4, ƫ:0x0044 */
    volatile uint32_t IP5;              /* жȼƼĴ5, ƫ:0x0048 */
    volatile uint32_t IP6;              /* жȼƼĴ6, ƫ:0x004C */
    volatile uint32_t IP7;              /* жȼƼĴ7, ƫ:0x0050 */
    volatile uint32_t IP8;              /* жȼƼĴ8, ƫ:0x0054 */
    volatile uint32_t IP9;              /* жȼƼĴ9, ƫ:0x0058 */
    volatile uint32_t IP10;             /* жȼƼĴ10, ƫ:0x005C */
    volatile uint32_t IP11;             /* жȼƼĴ11, ƫ:0x0060 */
    volatile uint32_t IP12;             /* жȼƼĴ12, ƫ:0x0064 */
    volatile uint32_t IP13;             /* жȼƼĴ13, ƫ:0x0068 */
    volatile uint32_t IP14;             /* жȼƼĴ14, ƫ:0x006C */
    volatile uint32_t IP15;             /* жȼƼĴ15, ƫ:0x0070 */
    volatile uint32_t IP16;             /* жȼƼĴ16, ƫ:0x0074 */
    volatile uint32_t IP17;             /* жȼƼĴ17, ƫ:0x0078 */
    volatile uint32_t IP18;             /* жȼƼĴ18, ƫ:0x007C */
    volatile uint32_t EINTMASK;         /* ⲿжμĴ, ƫ:0x0080 */
    volatile uint32_t EINTRISE;         /* ⲿжѡĴ, ƫ:0x0084 */
    volatile uint32_t EINTFALL;         /* ⲿж½ѡĴ, ƫ:0x0088 */
    volatile uint32_t EINTF;            /* ⲿжϱ־λĴ, ƫ:0x008C */
             uint32_t RESERVED7;        /* ַ, ƫ:0x0090 */
    volatile uint32_t EINTSS0;          /* ⲿжжԴѡĴ0, ƫ:0x0094 */
    volatile uint32_t EINTSS1;          /* ⲿжжԴѡĴ1, ƫ:0x0098 */
    volatile uint32_t CTL1;             /* жϿƼĴ1, ƫ:0x009C */
}INT_SFRmap;

/* ----------------------------------------------------------------------------
   -- INT - жϼĴں
   ---------------------------------------------------------------------------- */

/* INT - Ĵڵַ */
#define INT_ADDR						((uint32_t)0x40200000)
#define INT_SFR							((INT_SFRmap *)INT_ADDR)

/* INT - Ĵ */
#define INT_CTL0                        (INT_SFR->CTL0)
#define INT_EIE0                        (INT_SFR->EIE0)
#define INT_EIE1                        (INT_SFR->EIE1)
#define INT_EIE2                        (INT_SFR->EIE2)
#define INT_EIF0                        (INT_SFR->EIF0)
#define INT_EIF1                        (INT_SFR->EIF1)
#define INT_EIF2                        (INT_SFR->EIF2)
#define INT_IP0                         (INT_SFR->IP0)
#define INT_IP1                         (INT_SFR->IP1)
#define INT_IP2                         (INT_SFR->IP2)
#define INT_IP3                         (INT_SFR->IP3)
#define INT_IP4                         (INT_SFR->IP4)
#define INT_IP5                         (INT_SFR->IP5)
#define INT_IP6                         (INT_SFR->IP6)
#define INT_IP7                         (INT_SFR->IP7)
#define INT_IP8                         (INT_SFR->IP8)
#define INT_IP9                         (INT_SFR->IP9)
#define INT_IP10                        (INT_SFR->IP10)
#define INT_IP11                        (INT_SFR->IP11)
#define INT_IP12                        (INT_SFR->IP12)
#define INT_IP13                        (INT_SFR->IP13)
#define INT_IP14                        (INT_SFR->IP14)
#define INT_IP15                        (INT_SFR->IP15)
#define INT_IP16                        (INT_SFR->IP16)
#define INT_IP17                        (INT_SFR->IP17)
#define INT_IP18                        (INT_SFR->IP18)
#define INT_EINTMASK                    (INT_SFR->EINTMASK)
#define INT_EINTRISE                    (INT_SFR->EINTRISE)
#define INT_EINTFALL                    (INT_SFR->EINTFALL)
#define INT_EINTF                       (INT_SFR->EINTF)
#define INT_EINTSS0                     (INT_SFR->EINTSS0)
#define INT_EINTSS1                     (INT_SFR->EINTSS1)
#define INT_CTL1                        (INT_SFR->CTL1)

/* INT_CTL0 λ */
#define INT_CTL0_AIE_POS                (0)
#define INT_CTL0_PRIGROUP0_POS          (1)
#define INT_CTL0_PRIGROUP1_POS          (2)
#define INT_CTL0_INTPENDING_POS         (4)
#define INT_CTL0_INTPREEMPT_POS         (5)
#define INT_CTL0_FAULTMASK_POS          (6)
#define INT_CTL0_DSALIGN_POS            (7)
#define INT_CTL0_PRIBASE0_POS           (12)
#define INT_CTL0_PRIBASE1_POS           (13)
#define INT_CTL0_PRIBASE2_POS           (14)
#define INT_CTL0_PRIBASE3_POS           (15)
#define INT_CTL0_INTPEND0_POS           (16)
#define INT_CTL0_INTPEND1_POS           (17)
#define INT_CTL0_INTPEND2_POS           (18)
#define INT_CTL0_INTPEND3_POS           (19)
#define INT_CTL0_INTPEND4_POS           (20)
#define INT_CTL0_INTPEND5_POS           (21)
#define INT_CTL0_INTPEND6_POS           (22)
#define INT_CTL0_INTACT0_POS            (24)
#define INT_CTL0_INTACT1_POS            (25)
#define INT_CTL0_INTACT2_POS            (26)
#define INT_CTL0_INTACT3_POS            (27)
#define INT_CTL0_INTACT4_POS            (28)
#define INT_CTL0_INTACT5_POS            (29)
#define INT_CTL0_INTACT6_POS            (30)
#define INT_CTL0_AIE                    ((uint32_t)1<<(INT_CTL0_AIE_POS))
#define INT_CTL0_PRIGROUP               ((uint32_t)3<<(INT_CTL0_PRIGROUP0_POS))
#define INT_CTL0_PRIGROUP0              ((uint32_t)1<<(INT_CTL0_PRIGROUP0_POS))
#define INT_CTL0_PRIGROUP1              ((uint32_t)1<<(INT_CTL0_PRIGROUP1_POS))
#define INT_CTL0_INTPENDING             ((uint32_t)1<<(INT_CTL0_INTPENDING_POS))
#define INT_CTL0_INTPREEMPT             ((uint32_t)1<<(INT_CTL0_INTPREEMPT_POS))
#define INT_CTL0_FAULTMASK              ((uint32_t)1<<(INT_CTL0_FAULTMASK_POS))
#define INT_CTL0_DSALIGN                ((uint32_t)1<<(INT_CTL0_DSALIGN_POS))
#define INT_CTL0_PRIBASE                ((uint32_t)0xF<<(INT_CTL0_PRIBASE0_POS))
#define INT_CTL0_PRIBASE0               ((uint32_t)1<<(INT_CTL0_PRIBASE0_POS))
#define INT_CTL0_PRIBASE1               ((uint32_t)1<<(INT_CTL0_PRIBASE1_POS))
#define INT_CTL0_PRIBASE2               ((uint32_t)1<<(INT_CTL0_PRIBASE2_POS))
#define INT_CTL0_PRIBASE3               ((uint32_t)1<<(INT_CTL0_PRIBASE3_POS))
#define INT_CTL0_INTPEND                ((uint32_t)0x7F<<(INT_CTL0_INTPEND0_POS))
#define INT_CTL0_INTPEND0               ((uint32_t)1<<(INT_CTL0_INTPEND0_POS))
#define INT_CTL0_INTPEND1               ((uint32_t)1<<(INT_CTL0_INTPEND1_POS))
#define INT_CTL0_INTPEND2               ((uint32_t)1<<(INT_CTL0_INTPEND2_POS))
#define INT_CTL0_INTPEND3               ((uint32_t)1<<(INT_CTL0_INTPEND3_POS))
#define INT_CTL0_INTPEND4               ((uint32_t)1<<(INT_CTL0_INTPEND4_POS))
#define INT_CTL0_INTPEND5               ((uint32_t)1<<(INT_CTL0_INTPEND5_POS))
#define INT_CTL0_INTPEND6               ((uint32_t)1<<(INT_CTL0_INTPEND6_POS))
#define INT_CTL0_INTACT                 ((uint32_t)0x7F<<(INT_CTL0_INTACT0_POS))
#define INT_CTL0_INTACT0                ((uint32_t)1<<(INT_CTL0_INTACT0_POS))
#define INT_CTL0_INTACT1                ((uint32_t)1<<(INT_CTL0_INTACT1_POS))
#define INT_CTL0_INTACT2                ((uint32_t)1<<(INT_CTL0_INTACT2_POS))
#define INT_CTL0_INTACT3                ((uint32_t)1<<(INT_CTL0_INTACT3_POS))
#define INT_CTL0_INTACT4                ((uint32_t)1<<(INT_CTL0_INTACT4_POS))
#define INT_CTL0_INTACT5                ((uint32_t)1<<(INT_CTL0_INTACT5_POS))
#define INT_CTL0_INTACT6                ((uint32_t)1<<(INT_CTL0_INTACT6_POS))

/* INT_EIE0 λ */
#define INT_EIE0_HARDFAULTIE_POS        (3)
#define INT_EIE0_STACKIE_POS            (5)
#define INT_EIE0_ARIFAULTIE_POS         (6)
#define INT_EIE0_SVCALLIE_POS           (11)
#define INT_EIE0_PENDSVIE_POS           (14)
#define INT_EIE0_SYSTICKIE_POS          (15)
#define INT_EIE0_HARDFAULTIE			((uint32_t)1<<(INT_EIE0_HARDFAULTIE_POS))
#define INT_EIE0_STACKIE                ((uint32_t)1<<(INT_EIE0_STACKIE_POS))
#define INT_EIE0_ARIFAULTIE             ((uint32_t)1<<(INT_EIE0_ARIFAULTIE_POS))
#define INT_EIE0_SVCALLIE               ((uint32_t)1<<(INT_EIE0_SVCALLIE_POS))
#define INT_EIE0_PENDSVIE               ((uint32_t)1<<(INT_EIE0_PENDSVIE_POS))
#define INT_EIE0_SYSTICKIE              ((uint32_t)1<<(INT_EIE0_SYSTICKIE_POS))

/* INT_EIE1 λ */
#define INT_EIE1_WWDTIE_POS             (0)
#define INT_EIE1_EINT16IE_POS           (1)
#define INT_EIE1_EINT0IE_POS            (2)
#define INT_EIE1_EINT1IE_POS            (3)
#define INT_EIE1_EINT2IE_POS            (4)
#define INT_EIE1_EINT3IE_POS            (5)
#define INT_EIE1_EINT4IE_POS            (6)
#define INT_EIE1_EINT9TO5IE_POS         (7)
#define INT_EIE1_EINT15TO10IE_POS       (8)
#define INT_EIE1_T1IE_POS               (9)
#define INT_EIE1_T3IE_POS               (10)
#define INT_EIE1_T5IE_POS               (11)
#define INT_EIE1_T6IE_POS               (12)
#define INT_EIE1_QEI0IE_POS             (13)
#define INT_EIE1_QEI1IE_POS             (14)
#define INT_EIE1_ECFGLIE_POS              (15)
#define INT_EIE1_CAN4IE_POS             (16)
#define INT_EIE1_T14IE_POS              (17)
#define INT_EIE1_RNGIE_POS              (18)
#define INT_EIE1_FDC2IE_POS             (19)
#define INT_EIE1_EXICIE_POS             (20)
#define INT_EIE1_ADC0IE_POS             (21)
#define INT_EIE1_ADC1IE_POS             (22)
#define INT_EIE1_CFGLIE_POS             (23)
#define INT_EIE1_T11IE_POS              (24)
#define INT_EIE1_T0IE_POS               (25)
#define INT_EIE1_DMA0IE_POS             (26)
#define INT_EIE1_CMPIE_POS              (27)
#define INT_EIE1_USART0IE_POS           (28)
#define INT_EIE1_USART1IE_POS           (29)
#define INT_EIE1_SPI0IE_POS             (30)
#define INT_EIE1_SPI1IE_POS             (31)
#define INT_EIE1_WWDTIE                 ((uint32_t)1<<(INT_EIE1_WWDTIE_POS))
#define INT_EIE1_EINT16IE               ((uint32_t)1<<(INT_EIE1_EINT16IE_POS))
#define INT_EIE1_EINT0IE                ((uint32_t)1<<(INT_EIE1_EINT0IE_POS))
#define INT_EIE1_EINT1IE                ((uint32_t)1<<(INT_EIE1_EINT1IE_POS))
#define INT_EIE1_EINT2IE                ((uint32_t)1<<(INT_EIE1_EINT2IE_POS))
#define INT_EIE1_EINT3IE                ((uint32_t)1<<(INT_EIE1_EINT3IE_POS))
#define INT_EIE1_EINT4IE                ((uint32_t)1<<(INT_EIE1_EINT4IE_POS))
#define INT_EIE1_EINT9TO5IE             ((uint32_t)1<<(INT_EIE1_EINT9TO5IE_POS))
#define INT_EIE1_EINT15TO10IE           ((uint32_t)1<<(INT_EIE1_EINT15TO10IE_POS))
#define INT_EIE1_T1IE                   ((uint32_t)1<<(INT_EIE1_T1IE_POS))
#define INT_EIE1_T3IE                   ((uint32_t)1<<(INT_EIE1_T3IE_POS))
#define INT_EIE1_T5IE                   ((uint32_t)1<<(INT_EIE1_T5IE_POS))
#define INT_EIE1_T6IE                   ((uint32_t)1<<(INT_EIE1_T6IE_POS))
#define INT_EIE1_QEI0IE                 ((uint32_t)1<<(INT_EIE1_QEI0IE_POS))
#define INT_EIE1_QEI1IE                 ((uint32_t)1<<(INT_EIE1_QEI1IE_POS))
#define INT_EIE1_ECFGLIE                  ((uint32_t)1<<(INT_EIE1_ECFGLIE_POS))
#define INT_EIE1_CAN4IE                 ((uint32_t)1<<(INT_EIE1_CAN4IE_POS))
#define INT_EIE1_T14IE                  ((uint32_t)1<<(INT_EIE1_T14IE_POS))
#define INT_EIE1_RNGIE                  ((uint32_t)1<<(INT_EIE1_RNGIE_POS))
#define INT_EIE1_FDC2IE                 ((uint32_t)1<<(INT_EIE1_FDC2IE_POS))
#define INT_EIE1_EXICIE                 ((uint32_t)1<<(INT_EIE1_EXICIE_POS))
#define INT_EIE1_ADC0IE                 ((uint32_t)1<<(INT_EIE1_ADC0IE_POS))
#define INT_EIE1_ADC1IE                 ((uint32_t)1<<(INT_EIE1_ADC1IE_POS))
#define INT_EIE1_CFGLIE                 ((uint32_t)1<<(INT_EIE1_CFGLIE_POS))
#define INT_EIE1_T11IE                  ((uint32_t)1<<(INT_EIE1_T11IE_POS))
#define INT_EIE1_T0IE                   ((uint32_t)1<<(INT_EIE1_T0IE_POS))
#define INT_EIE1_DMA0IE                 ((uint32_t)1<<(INT_EIE1_DMA0IE_POS))
#define INT_EIE1_CMPIE                  ((uint32_t)1<<(INT_EIE1_CMPIE_POS))
#define INT_EIE1_USART0IE               ((uint32_t)1<<(INT_EIE1_USART0IE_POS))
#define INT_EIE1_USART1IE               ((uint32_t)1<<(INT_EIE1_USART1IE_POS))
#define INT_EIE1_SPI0IE                 ((uint32_t)1<<(INT_EIE1_SPI0IE_POS))
#define INT_EIE1_SPI1IE                 ((uint32_t)1<<(INT_EIE1_SPI1IE_POS))

/* INT_EIE2 λ */
#define INT_EIE2_DMA1IE_POS             (0)
#define INT_EIE2_EINT19TO17IE_POS       (1)
#define INT_EIE2_CANFD6IE_POS         (2)
#define INT_EIE2_CANFD7IE_POS         (3)
#define INT_EIE2_FDC0IE_POS             (4)
#define INT_EIE2_FDC1IE_POS             (5)
#define INT_EIE2_EINT31TO20IE_POS       (6)
#define INT_EIE2_ECCIE_POS       		(7)
#define INT_EIE2_OSCIE_POS              (8)
#define INT_EIE2_I2C0IE_POS             (9)
#define INT_EIE2_I2C1IE_POS             (10)
#define INT_EIE2_I2C2IE_POS             (11)
#define INT_EIE2_T12IE_POS              (12)
#define INT_EIE2_T2IE_POS               (13)
#define INT_EIE2_T4IE_POS               (14)
#define INT_EIE2_T13_POS     	        (15)
#define INT_EIE2_USART2IE_POS           (16)
#define INT_EIE2_T16IE_POS         	    (17)
#define INT_EIE2_USART4IE_POS           (18)
#define INT_EIE2_SPI2IE_POS             (19)
#define INT_EIE2_SPI3IE_POS             (20)
#define INT_EIE2_ADC2IE_POS             (21)
#define INT_EIE2_T18IE_POS              (22)
#define INT_EIE2_T19IE_POS              (23)
#define INT_EIE2_HRCAP0IE_POS           (24)
#define INT_EIE2_WKPIE_POS              (25)
#define INT_EIE2_HRCAP1IE_POS           (26)
#define INT_EIE2_T21IE_POS              (27)
#define INT_EIE2_I2C3IE_POS             (28)
#define INT_EIE2_USART5IE_POS           (29)
#define INT_EIE2_HRCAP2IE_POS           (30)
#define INT_EIE2_USART7IE_POS           (31)

#define INT_EIE2_DMA1IE                 ((uint32_t)1<<(INT_EIE2_DMA1IE_POS))
#define INT_EIE2_EINT19TO17IE           ((uint32_t)1<<(INT_EIE2_EINT19TO17IE_POS))
#define INT_EIE2_CANFD6IE             ((uint32_t)1<<(INT_EIE2_CANFD6IE_POS))
#define INT_EIE2_CANFD7IE             ((uint32_t)1<<(INT_EIE2_CANFD7IE_POS))
#define INT_EIE2_FDC0IE                 ((uint32_t)1<<(INT_EIE2_FDC0IE_POS))
#define INT_EIE2_FDC1IE                 ((uint32_t)1<<(INT_EIE2_FDC1IE_POS))
#define INT_EIE2_EINT31TO20IE           ((uint32_t)1<<(INT_EIE2_EINT31TO20IE_POS))
#define INT_EIE2_ECCIE           		((uint32_t)1<<(INT_EIE2_ECCIE_POS))
#define INT_EIE2_OSCIE                  ((uint32_t)1<<(INT_EIE2_OSCIE_POS))
#define INT_EIE2_I2C0IE                 ((uint32_t)1<<(INT_EIE2_I2C0IE_POS))
#define INT_EIE2_I2C1IE                 ((uint32_t)1<<(INT_EIE2_I2C1IE_POS))
#define INT_EIE2_I2C2IE                 ((uint32_t)1<<(INT_EIE2_I2C2IE_POS))
#define INT_EIE2_T12IE                  ((uint32_t)1<<(INT_EIE2_T12IE_POS))
#define INT_EIE2_T2IE                   ((uint32_t)1<<(INT_EIE2_T2IE_POS))
#define INT_EIE2_T4IE                   ((uint32_t)1<<(INT_EIE2_T4IE_POS))
#define INT_EIE2_T13               		((uint32_t)1<<(INT_EIE2_T13_POS))
#define INT_EIE2_USART2IE               ((uint32_t)1<<(INT_EIE2_USART2IE_POS))
#define INT_EIE2_T16IE               	((uint32_t)1<<(INT_EIE2_T16IE_POS))
#define INT_EIE2_USART4IE               ((uint32_t)1<<(INT_EIE2_USART4IE_POS))
#define INT_EIE2_SPI2IE                 ((uint32_t)1<<(INT_EIE2_SPI2IE_POS))
#define INT_EIE2_SPI3IE                 ((uint32_t)1<<(INT_EIE2_SPI3IE_POS))
#define INT_EIE2_ADC2IE                 ((uint32_t)1<<(INT_EIE2_ADC2IE_POS))
#define INT_EIE2_T18IE                  ((uint32_t)1<<(INT_EIE2_T18IE_POS))
#define INT_EIE2_T19IE                  ((uint32_t)1<<(INT_EIE2_T19IE_POS))
#define INT_EIE2_HRCAP0IE               ((uint32_t)1<<(INT_EIE2_HRCAP0IE_POS))
#define INT_EIE2_WKPIE                  ((uint32_t)1<<(INT_EIE2_WKPIE_POS))
#define INT_EIE2_HRCAP1IE               ((uint32_t)1<<(INT_EIE2_HRCAP1IE_POS))
#define INT_EIE2_T21IE                  ((uint32_t)1<<(INT_EIE2_T21IE_POS))
#define INT_EIE2_I2C3IE                 ((uint32_t)1<<(INT_EIE2_I2C3IE_POS))
#define INT_EIE2_USART5IE               ((uint32_t)1<<(INT_EIE2_USART5IE_POS))
#define INT_EIE2_HRCAP2IE               ((uint32_t)1<<(INT_EIE2_HRCAP2IE_POS))
#define INT_EIE2_USART7IE               ((uint32_t)1<<(INT_EIE2_USART7IE_POS))

/* INT_EIF0 λ */
#define INT_EIF0_NMIIF_POS              (2)
#define INT_EIF0_HARDFAULTIF_POS        (3)
#define INT_EIF0_STACKIF_POS            (5)
#define INT_EIF0_ARIFAULTIF_POS         (6)
#define INT_EIF0_SVCALLIF_POS           (11)
#define INT_EIF0_SOFTSVIF_POS           (14)
#define INT_EIF0_SYSTICKIF_POS          (15)
#define INT_EIF0_NMIIF                  ((uint32_t)1<<(INT_EIF0_NMIIF_POS))
#define INT_EIF0_HARDFAULTIF            ((uint32_t)1<<(INT_EIF0_HARDFAULTIF_POS))
#define INT_EIF0_STACKIF                ((uint32_t)1<<(INT_EIF0_STACKIF_POS))
#define INT_EIF0_ARIFAULTIF             ((uint32_t)1<<(INT_EIF0_ARIFAULTIF_POS))
#define INT_EIF0_SVCALLIF               ((uint32_t)1<<(INT_EIF0_SVCALLIF_POS))
#define INT_EIF0_SOFTSVIF               ((uint32_t)1<<(INT_EIF0_SOFTSVIF_POS))
#define INT_EIF0_SYSTICKIF              ((uint32_t)1<<(INT_EIF0_SYSTICKIF_POS))

/* INT_EIF1 λ */
#define INT_EIF1_WWDTIF_POS             (0)
#define INT_EIF1_EINT16IF_POS           (1)
#define INT_EIF1_EINT0IF_POS            (2)
#define INT_EIF1_EINT1IF_POS            (3)
#define INT_EIF1_EINT2IF_POS            (4)
#define INT_EIF1_EINT3IF_POS            (5)
#define INT_EIF1_EINT4IF_POS            (6)
#define INT_EIF1_EINT9TO5IF_POS         (7)
#define INT_EIF1_EINT15TO10IF_POS       (8)
#define INT_EIF1_T1IF_POS               (9)
#define INT_EIF1_T3IF_POS               (10)
#define INT_EIF1_T5IF_POS               (11)
#define INT_EIF1_T6IF_POS               (12)
#define INT_EIF1_QEI0IF_POS             (13)
#define INT_EIF1_QEI1IF_POS             (14)
#define INT_EIF1_ECFGLIF_POS              (15)
#define INT_EIF1_CAN4IF_POS             (16)
#define INT_EIF1_T14IF_POS              (17)
#define INT_EIF1_RNGIF_POS              (18)
#define INT_EIF1_FDC2IF_POS             (19)
#define INT_EIF1_EXICIF_POS             (20)
#define INT_EIF1_ADC0IF_POS             (21)
#define INT_EIF1_ADC1IF_POS             (22)
#define INT_EIF1_CFGLIF_POS             (23)
#define INT_EIF1_T11IF_POS              (24)
#define INT_EIF1_T0IF_POS               (25)
#define INT_EIF1_DMA0IF_POS             (26)
#define INT_EIF1_CMPIF_POS              (27)
#define INT_EIF1_USART0IF_POS           (28)
#define INT_EIF1_USART1IF_POS           (29)
#define INT_EIF1_SPI0IF_POS             (30)
#define INT_EIF1_SPI1IF_POS             (31)

#define INT_EIF1_WWDTIF                 ((uint32_t)1<<(INT_EIF1_WWDTIF_POS))
#define INT_EIF1_EINT16IF               ((uint32_t)1<<(INT_EIF1_EINT16IF_POS))
#define INT_EIF1_EINT0IF                ((uint32_t)1<<(INT_EIF1_EINT0IF_POS))
#define INT_EIF1_EINT1IF                ((uint32_t)1<<(INT_EIF1_EINT1IF_POS))
#define INT_EIF1_EINT2IF                ((uint32_t)1<<(INT_EIF1_EINT2IF_POS))
#define INT_EIF1_EINT3IF                ((uint32_t)1<<(INT_EIF1_EINT3IF_POS))
#define INT_EIF1_EINT4IF                ((uint32_t)1<<(INT_EIF1_EINT4IF_POS))
#define INT_EIF1_EINT9TO5IF             ((uint32_t)1<<(INT_EIF1_EINT9TO5IF_POS))
#define INT_EIF1_EINT15TO10IF           ((uint32_t)1<<(INT_EIF1_EINT15TO10IF_POS))
#define INT_EIF1_T1IF                   ((uint32_t)1<<(INT_EIF1_T1IF_POS))
#define INT_EIF1_T3IF                   ((uint32_t)1<<(INT_EIF1_T3IF_POS))
#define INT_EIF1_T5IF                   ((uint32_t)1<<(INT_EIF1_T5IF_POS))
#define INT_EIF1_T6IF                   ((uint32_t)1<<(INT_EIF1_T6IF_POS))
#define INT_EIF1_QEI0IF                 ((uint32_t)1<<(INT_EIF1_QEI0IF_POS))
#define INT_EIF1_QEI1IF                 ((uint32_t)1<<(INT_EIF1_QEI1IF_POS))
#define INT_EIF1_ECFGLIF                  ((uint32_t)1<<(INT_EIF1_ECFGLIF_POS))
#define INT_EIF1_CAN4IF                 ((uint32_t)1<<(INT_EIF1_CAN4IF_POS))
#define INT_EIF1_T14IF                  ((uint32_t)1<<(INT_EIF1_T14IF_POS))
#define INT_EIF1_RNGIF                  ((uint32_t)1<<(INT_EIF1_RNGIF_POS))
#define INT_EIF1_FDC2IF                 ((uint32_t)1<<(INT_EIF1_FDC2IF_POS))
#define INT_EIF1_EXICIF                 ((uint32_t)1<<(INT_EIF1_EXICIF_POS))
#define INT_EIF1_ADC0IF                 ((uint32_t)1<<(INT_EIF1_ADC0IF_POS))
#define INT_EIF1_ADC1IF                 ((uint32_t)1<<(INT_EIF1_ADC1IF_POS))
#define INT_EIF1_CFGLIF                 ((uint32_t)1<<(INT_EIF1_CFGLIF_POS))
#define INT_EIF1_T11IF                  ((uint32_t)1<<(INT_EIF1_T11IF_POS))
#define INT_EIF1_T0IF                   ((uint32_t)1<<(INT_EIF1_T0IF_POS))
#define INT_EIF1_DMA0IF                 ((uint32_t)1<<(INT_EIF1_DMA0IF_POS))
#define INT_EIF1_CMPIF                  ((uint32_t)1<<(INT_EIF1_CMPIF_POS))
#define INT_EIF1_USART0IF               ((uint32_t)1<<(INT_EIF1_USART0IF_POS))
#define INT_EIF1_USART1IF               ((uint32_t)1<<(INT_EIF1_USART1IF_POS))
#define INT_EIF1_SPI0IF                 ((uint32_t)1<<(INT_EIF1_SPI0IF_POS))
#define INT_EIF1_SPI1IF                 ((uint32_t)1<<(INT_EIF1_SPI1IF_POS))

/* INT_EIF2 λ */
#define INT_EIF2_DMA1IF_POS             (0)
#define INT_EIF2_EINT19TO17IF_POS       (1)
#define INT_EIF2_CANFD6IF_POS         (2)
#define INT_EIF2_CANFD7IF_POS         (3)
#define INT_EIF2_FDC0IF_POS             (4)
#define INT_EIF2_FDC1IF_POS             (5)
#define INT_EIF2_EINT31TO20IF_POS       (6)
#define INT_EIF2_ECCIF_POS       		(7)
#define INT_EIF2_OSCIF_POS              (8)
#define INT_EIF2_I2C0IF_POS             (9)
#define INT_EIF2_I2C1IF_POS             (10)
#define INT_EIF2_I2C2IF_POS             (11)
#define INT_EIF2_T12IF_POS              (12)
#define INT_EIF2_T2IF_POS               (13)
#define INT_EIF2_T4IF_POS               (14)
#define INT_EIF2_T13IF_POS              (15)
#define INT_EIF2_USART2IF_POS           (16)
#define INT_EIF2_T16IF_POS              (17)
#define INT_EIF2_USART4IF_POS           (18)
#define INT_EIF2_SPI2IF_POS             (19)
#define INT_EIF2_SPI3IF_POS             (20)
#define INT_EIF2_ADC2IF_POS             (21)
#define INT_EIF2_T18IF_POS              (22)
#define INT_EIF2_T19IF_POS              (23)
#define INT_EIF2_HRCAP0IF_POS           (24)
#define INT_EIF2_WKPIF_POS              (25)
#define INT_EIF2_HRCAP1IF_POS           (26)
#define INT_EIF2_T21IF_POS              (27)
#define INT_EIF2_I2C3IF_POS             (28)
#define INT_EIF2_USART5IF_POS           (29)
#define INT_EIF2_HRCAP2IF_POS           (30)
#define INT_EIF2_USART7IF_POS           (31)

#define INT_EIF2_DMA1IF                 ((uint32_t)1<<(INT_EIF2_DMA1IF_POS))
#define INT_EIF2_EINT19TO17IF           ((uint32_t)1<<(INT_EIF2_EINT19TO17IF_POS))
#define INT_EIF2_CANFD6IF             ((uint32_t)1<<(INT_EIF2_CANFD6IF_POS))
#define INT_EIF2_CANFD7IF             ((uint32_t)1<<(INT_EIF2_CANFD7IF_POS))
#define INT_EIF2_FDC0IF                 ((uint32_t)1<<(INT_EIF2_FDC0IF_POS))
#define INT_EIF2_FDC1IF                 ((uint32_t)1<<(INT_EIF2_FDC1IF_POS))
#define INT_EIF2_EINT31TO20IF           ((uint32_t)1<<(INT_EIF2_EINT31TO20IF_POS))
#define INT_EIF2_ECCIF          		((uint32_t)1<<(INT_EIF2_ECCIF_POS))
#define INT_EIF2_OSCIF                  ((uint32_t)1<<(INT_EIF2_OSCIF_POS))
#define INT_EIF2_I2C0IF                 ((uint32_t)1<<(INT_EIF2_I2C0IF_POS))
#define INT_EIF2_I2C1IF                 ((uint32_t)1<<(INT_EIF2_I2C1IF_POS))
#define INT_EIF2_I2C2IF                 ((uint32_t)1<<(INT_EIF2_I2C2IF_POS))
#define INT_EIF2_T12IF                  ((uint32_t)1<<(INT_EIF2_T12IF_POS))
#define INT_EIF2_T2IF                   ((uint32_t)1<<(INT_EIF2_T2IF_POS))
#define INT_EIF2_T4IF                   ((uint32_t)1<<(INT_EIF2_T4IF_POS))
#define INT_EIF2_T13IF              	((uint32_t)1<<(INT_EIF2_T13IF_POS))
#define INT_EIF2_USART2IF               ((uint32_t)1<<(INT_EIF2_USART2IF_POS))
#define INT_EIF2_T16IF               	((uint32_t)1<<(INT_EIF2_T16IF_POS))
#define INT_EIF2_USART4IF               ((uint32_t)1<<(INT_EIF2_USART4IF_POS))
#define INT_EIF2_SPI2IF                 ((uint32_t)1<<(INT_EIF2_SPI2IF_POS))
#define INT_EIF2_SPI3IF                 ((uint32_t)1<<(INT_EIF2_SPI3IF_POS))
#define INT_EIF2_ADC2IF                 ((uint32_t)1<<(INT_EIF2_ADC2IF_POS))
#define INT_EIF2_T18IF                  ((uint32_t)1<<(INT_EIF2_T18IF_POS))
#define INT_EIF2_T19IF                  ((uint32_t)1<<(INT_EIF2_T19IF_POS))
#define INT_EIF2_HRCAP0IF               ((uint32_t)1<<(INT_EIF2_HRCAP0IF_POS))
#define INT_EIF2_WKPIF                  ((uint32_t)1<<(INT_EIF2_WKPIF_POS))
#define INT_EIF2_EMIIF                  ((uint32_t)1<<(INT_EIF2_EMIIF_POS))
#define INT_EIF2_HRCAP1IF               ((uint32_t)1<<(INT_EIF2_HRCAP1IF_POS))
#define INT_EIF2_T21IF                  ((uint32_t)1<<(INT_EIF2_T21IF_POS))
#define INT_EIF2_I2C3IF                 ((uint32_t)1<<(INT_EIF2_I2C3IF_POS))
#define INT_EIF2_USART5IF               ((uint32_t)1<<(INT_EIF2_USART5IF_POS))
#define INT_EIF2_HRCAP2IF               ((uint32_t)1<<(INT_EIF2_HRCAP2IF_POS))
#define INT_EIF2_USART7IF               ((uint32_t)1<<(INT_EIF2_USART7IF_POS))

/* INT_IP0 λ */
#define INT_IP0_PRI4_4_POS              (4)
#define INT_IP0_PRI4_5_POS              (5)
#define INT_IP0_PRI4_6_POS              (6)
#define INT_IP0_PRI4_7_POS              (7)
#define INT_IP0_PRI5_4_POS              (12)
#define INT_IP0_PRI5_5_POS              (13)
#define INT_IP0_PRI5_6_POS              (14)
#define INT_IP0_PRI5_7_POS              (15)
#define INT_IP0_PRI6_4_POS              (20)
#define INT_IP0_PRI6_5_POS              (21)
#define INT_IP0_PRI6_6_POS              (22)
#define INT_IP0_PRI6_7_POS              (23)
#define INT_IP0_PRI7_4_POS              (28)
#define INT_IP0_PRI7_5_POS              (29)
#define INT_IP0_PRI7_6_POS              (30)
#define INT_IP0_PRI7_7_POS              (31)
#define INT_IP0_PRI4_4                  ((uint32_t)1<<(INT_IP0_PRI4_4_POS))
#define INT_IP0_PRI4_5                  ((uint32_t)1<<(INT_IP0_PRI4_5_POS))
#define INT_IP0_PRI4_6                  ((uint32_t)1<<(INT_IP0_PRI4_6_POS))
#define INT_IP0_PRI4_7                  ((uint32_t)1<<(INT_IP0_PRI4_7_POS))
#define INT_IP0_PRI5_4                  ((uint32_t)1<<(INT_IP0_PRI5_4_POS))
#define INT_IP0_PRI5_5                  ((uint32_t)1<<(INT_IP0_PRI5_5_POS))
#define INT_IP0_PRI5_6                  ((uint32_t)1<<(INT_IP0_PRI5_6_POS))
#define INT_IP0_PRI5_7                  ((uint32_t)1<<(INT_IP0_PRI5_7_POS))
#define INT_IP0_PRI6_4                  ((uint32_t)1<<(INT_IP0_PRI6_4_POS))
#define INT_IP0_PRI6_5                  ((uint32_t)1<<(INT_IP0_PRI6_5_POS))
#define INT_IP0_PRI6_6                  ((uint32_t)1<<(INT_IP0_PRI6_6_POS))
#define INT_IP0_PRI6_7                  ((uint32_t)1<<(INT_IP0_PRI6_7_POS))
#define INT_IP0_PRI7_4                  ((uint32_t)1<<(INT_IP0_PRI7_4_POS))
#define INT_IP0_PRI7_5                  ((uint32_t)1<<(INT_IP0_PRI7_5_POS))
#define INT_IP0_PRI7_6                  ((uint32_t)1<<(INT_IP0_PRI7_6_POS))
#define INT_IP0_PRI7_7                  ((uint32_t)1<<(INT_IP0_PRI7_7_POS))

/* INT_IP1 λ */
#define INT_IP1_PRI8_4_POS              (4)
#define INT_IP1_PRI8_5_POS              (5)
#define INT_IP1_PRI8_6_POS              (6)
#define INT_IP1_PRI8_7_POS              (7)
#define INT_IP1_PRI9_4_POS              (12)
#define INT_IP1_PRI9_5_POS              (13)
#define INT_IP1_PRI9_6_POS              (14)
#define INT_IP1_PRI9_7_POS              (15)
#define INT_IP1_PRI10_4_POS             (20)
#define INT_IP1_PRI10_5_POS             (21)
#define INT_IP1_PRI10_6_POS             (22)
#define INT_IP1_PRI10_7_POS             (23)
#define INT_IP1_PRI11_4_POS             (28)
#define INT_IP1_PRI11_5_POS             (29)
#define INT_IP1_PRI11_6_POS             (30)
#define INT_IP1_PRI11_7_POS             (31)
#define INT_IP1_PRI8_4                  ((uint32_t)1<<(INT_IP1_PRI8_4_POS))
#define INT_IP1_PRI8_5                  ((uint32_t)1<<(INT_IP1_PRI8_5_POS))
#define INT_IP1_PRI8_6                  ((uint32_t)1<<(INT_IP1_PRI8_6_POS))
#define INT_IP1_PRI8_7                  ((uint32_t)1<<(INT_IP1_PRI8_7_POS))
#define INT_IP1_PRI9_4                  ((uint32_t)1<<(INT_IP1_PRI9_4_POS))
#define INT_IP1_PRI9_5                  ((uint32_t)1<<(INT_IP1_PRI9_5_POS))
#define INT_IP1_PRI9_6                  ((uint32_t)1<<(INT_IP1_PRI9_6_POS))
#define INT_IP1_PRI9_7                  ((uint32_t)1<<(INT_IP1_PRI9_7_POS))
#define INT_IP1_PRI10_4                 ((uint32_t)1<<(INT_IP1_PRI10_4_POS))
#define INT_IP1_PRI10_5                 ((uint32_t)1<<(INT_IP1_PRI10_5_POS))
#define INT_IP1_PRI10_6                 ((uint32_t)1<<(INT_IP1_PRI10_6_POS))
#define INT_IP1_PRI10_7                 ((uint32_t)1<<(INT_IP1_PRI10_7_POS))
#define INT_IP1_PRI11_4                 ((uint32_t)1<<(INT_IP1_PRI11_4_POS))
#define INT_IP1_PRI11_5                 ((uint32_t)1<<(INT_IP1_PRI11_5_POS))
#define INT_IP1_PRI11_6                 ((uint32_t)1<<(INT_IP1_PRI11_6_POS))
#define INT_IP1_PRI11_7                 ((uint32_t)1<<(INT_IP1_PRI11_7_POS))

/* INT_IP2 λ */
#define INT_IP2_PRI12_4_POS             (4)
#define INT_IP2_PRI12_5_POS             (5)
#define INT_IP2_PRI12_6_POS             (6)
#define INT_IP2_PRI12_7_POS             (7)
#define INT_IP2_PRI13_4_POS             (12)
#define INT_IP2_PRI13_5_POS             (13)
#define INT_IP2_PRI13_6_POS             (14)
#define INT_IP2_PRI13_7_POS             (15)
#define INT_IP2_PRI14_4_POS             (20)
#define INT_IP2_PRI14_5_POS             (21)
#define INT_IP2_PRI14_6_POS             (22)
#define INT_IP2_PRI14_7_POS             (23)
#define INT_IP2_PRI15_4_POS             (28)
#define INT_IP2_PRI15_5_POS             (29)
#define INT_IP2_PRI15_6_POS             (30)
#define INT_IP2_PRI15_7_POS             (31)
#define INT_IP2_PRI12_4                 ((uint32_t)1<<(INT_IP2_PRI12_4_POS))
#define INT_IP2_PRI12_5                 ((uint32_t)1<<(INT_IP2_PRI12_5_POS))
#define INT_IP2_PRI12_6                 ((uint32_t)1<<(INT_IP2_PRI12_6_POS))
#define INT_IP2_PRI12_7                 ((uint32_t)1<<(INT_IP2_PRI12_7_POS))
#define INT_IP2_PRI13_4                 ((uint32_t)1<<(INT_IP2_PRI13_4_POS))
#define INT_IP2_PRI13_5                 ((uint32_t)1<<(INT_IP2_PRI13_5_POS))
#define INT_IP2_PRI13_6                 ((uint32_t)1<<(INT_IP2_PRI13_6_POS))
#define INT_IP2_PRI13_7                 ((uint32_t)1<<(INT_IP2_PRI13_7_POS))
#define INT_IP2_PRI14_4                 ((uint32_t)1<<(INT_IP2_PRI14_4_POS))
#define INT_IP2_PRI14_5                 ((uint32_t)1<<(INT_IP2_PRI14_5_POS))
#define INT_IP2_PRI14_6                 ((uint32_t)1<<(INT_IP2_PRI14_6_POS))
#define INT_IP2_PRI14_7                 ((uint32_t)1<<(INT_IP2_PRI14_7_POS))
#define INT_IP2_PRI15_4                 ((uint32_t)1<<(INT_IP2_PRI15_4_POS))
#define INT_IP2_PRI15_5                 ((uint32_t)1<<(INT_IP2_PRI15_5_POS))
#define INT_IP2_PRI15_6                 ((uint32_t)1<<(INT_IP2_PRI15_6_POS))
#define INT_IP2_PRI15_7                 ((uint32_t)1<<(INT_IP2_PRI15_7_POS))

/* INT_IP3 λ */
#define INT_IP3_PRI16_4_POS             (4)
#define INT_IP3_PRI16_5_POS             (5)
#define INT_IP3_PRI16_6_POS             (6)
#define INT_IP3_PRI16_7_POS             (7)
#define INT_IP3_PRI17_4_POS             (12)
#define INT_IP3_PRI17_5_POS             (13)
#define INT_IP3_PRI17_6_POS             (14)
#define INT_IP3_PRI17_7_POS             (15)
#define INT_IP3_PRI18_4_POS             (20)
#define INT_IP3_PRI18_5_POS             (21)
#define INT_IP3_PRI18_6_POS             (22)
#define INT_IP3_PRI18_7_POS             (23)
#define INT_IP3_PRI19_4_POS             (28)
#define INT_IP3_PRI19_5_POS             (29)
#define INT_IP3_PRI19_6_POS             (30)
#define INT_IP3_PRI19_7_POS             (31)
#define INT_IP3_PRI16_4                 ((uint32_t)1<<(INT_IP3_PRI16_4_POS))
#define INT_IP3_PRI16_5                 ((uint32_t)1<<(INT_IP3_PRI16_5_POS))
#define INT_IP3_PRI16_6                 ((uint32_t)1<<(INT_IP3_PRI16_6_POS))
#define INT_IP3_PRI16_7                 ((uint32_t)1<<(INT_IP3_PRI16_7_POS))
#define INT_IP3_PRI17_4                 ((uint32_t)1<<(INT_IP3_PRI17_4_POS))
#define INT_IP3_PRI17_5                 ((uint32_t)1<<(INT_IP3_PRI17_5_POS))
#define INT_IP3_PRI17_6                 ((uint32_t)1<<(INT_IP3_PRI17_6_POS))
#define INT_IP3_PRI17_7                 ((uint32_t)1<<(INT_IP3_PRI17_7_POS))
#define INT_IP3_PRI18_4                 ((uint32_t)1<<(INT_IP3_PRI18_4_POS))
#define INT_IP3_PRI18_5                 ((uint32_t)1<<(INT_IP3_PRI18_5_POS))
#define INT_IP3_PRI18_6                 ((uint32_t)1<<(INT_IP3_PRI18_6_POS))
#define INT_IP3_PRI18_7                 ((uint32_t)1<<(INT_IP3_PRI18_7_POS))
#define INT_IP3_PRI19_4                 ((uint32_t)1<<(INT_IP3_PRI19_4_POS))
#define INT_IP3_PRI19_5                 ((uint32_t)1<<(INT_IP3_PRI19_5_POS))
#define INT_IP3_PRI19_6                 ((uint32_t)1<<(INT_IP3_PRI19_6_POS))
#define INT_IP3_PRI19_7                 ((uint32_t)1<<(INT_IP3_PRI19_7_POS))

/* INT_IP4 λ */
#define INT_IP4_PRI20_4_POS             (4)
#define INT_IP4_PRI20_5_POS             (5)
#define INT_IP4_PRI20_6_POS             (6)
#define INT_IP4_PRI20_7_POS             (7)
#define INT_IP4_PRI21_4_POS             (12)
#define INT_IP4_PRI21_5_POS             (13)
#define INT_IP4_PRI21_6_POS             (14)
#define INT_IP4_PRI21_7_POS             (15)
#define INT_IP4_PRI22_4_POS             (20)
#define INT_IP4_PRI22_5_POS             (21)
#define INT_IP4_PRI22_6_POS             (22)
#define INT_IP4_PRI22_7_POS             (23)
#define INT_IP4_PRI23_4_POS             (28)
#define INT_IP4_PRI23_5_POS             (29)
#define INT_IP4_PRI23_6_POS             (30)
#define INT_IP4_PRI23_7_POS             (31)
#define INT_IP4_PRI20_4                 ((uint32_t)1<<(INT_IP4_PRI20_4_POS))
#define INT_IP4_PRI20_5                 ((uint32_t)1<<(INT_IP4_PRI20_5_POS))
#define INT_IP4_PRI20_6                 ((uint32_t)1<<(INT_IP4_PRI20_6_POS))
#define INT_IP4_PRI20_7                 ((uint32_t)1<<(INT_IP4_PRI20_7_POS))
#define INT_IP4_PRI21_4                 ((uint32_t)1<<(INT_IP4_PRI21_4_POS))
#define INT_IP4_PRI21_5                 ((uint32_t)1<<(INT_IP4_PRI21_5_POS))
#define INT_IP4_PRI21_6                 ((uint32_t)1<<(INT_IP4_PRI21_6_POS))
#define INT_IP4_PRI21_7                 ((uint32_t)1<<(INT_IP4_PRI21_7_POS))
#define INT_IP4_PRI22_4                 ((uint32_t)1<<(INT_IP4_PRI22_4_POS))
#define INT_IP4_PRI22_5                 ((uint32_t)1<<(INT_IP4_PRI22_5_POS))
#define INT_IP4_PRI22_6                 ((uint32_t)1<<(INT_IP4_PRI22_6_POS))
#define INT_IP4_PRI22_7                 ((uint32_t)1<<(INT_IP4_PRI22_7_POS))
#define INT_IP4_PRI23_4                 ((uint32_t)1<<(INT_IP4_PRI23_4_POS))
#define INT_IP4_PRI23_5                 ((uint32_t)1<<(INT_IP4_PRI23_5_POS))
#define INT_IP4_PRI23_6                 ((uint32_t)1<<(INT_IP4_PRI23_6_POS))
#define INT_IP4_PRI23_7                 ((uint32_t)1<<(INT_IP4_PRI23_7_POS))

/* INT_IP5 λ */
#define INT_IP5_PRI24_4_POS             (4)
#define INT_IP5_PRI24_5_POS             (5)
#define INT_IP5_PRI24_6_POS             (6)
#define INT_IP5_PRI24_7_POS             (7)
#define INT_IP5_PRI25_4_POS             (12)
#define INT_IP5_PRI25_5_POS             (13)
#define INT_IP5_PRI25_6_POS             (14)
#define INT_IP5_PRI25_7_POS             (15)
#define INT_IP5_PRI26_4_POS             (20)
#define INT_IP5_PRI26_5_POS             (21)
#define INT_IP5_PRI26_6_POS             (22)
#define INT_IP5_PRI26_7_POS             (23)
#define INT_IP5_PRI27_4_POS             (28)
#define INT_IP5_PRI27_5_POS             (29)
#define INT_IP5_PRI27_6_POS             (30)
#define INT_IP5_PRI27_7_POS             (31)
#define INT_IP5_PRI24_4                 ((uint32_t)1<<(INT_IP5_PRI24_4_POS))
#define INT_IP5_PRI24_5                 ((uint32_t)1<<(INT_IP5_PRI24_5_POS))
#define INT_IP5_PRI24_6                 ((uint32_t)1<<(INT_IP5_PRI24_6_POS))
#define INT_IP5_PRI24_7                 ((uint32_t)1<<(INT_IP5_PRI24_7_POS))
#define INT_IP5_PRI25_4                 ((uint32_t)1<<(INT_IP5_PRI25_4_POS))
#define INT_IP5_PRI25_5                 ((uint32_t)1<<(INT_IP5_PRI25_5_POS))
#define INT_IP5_PRI25_6                 ((uint32_t)1<<(INT_IP5_PRI25_6_POS))
#define INT_IP5_PRI25_7                 ((uint32_t)1<<(INT_IP5_PRI25_7_POS))
#define INT_IP5_PRI26_4                 ((uint32_t)1<<(INT_IP5_PRI26_4_POS))
#define INT_IP5_PRI26_5                 ((uint32_t)1<<(INT_IP5_PRI26_5_POS))
#define INT_IP5_PRI26_6                 ((uint32_t)1<<(INT_IP5_PRI26_6_POS))
#define INT_IP5_PRI26_7                 ((uint32_t)1<<(INT_IP5_PRI26_7_POS))
#define INT_IP5_PRI27_4                 ((uint32_t)1<<(INT_IP5_PRI27_4_POS))
#define INT_IP5_PRI27_5                 ((uint32_t)1<<(INT_IP5_PRI27_5_POS))
#define INT_IP5_PRI27_6                 ((uint32_t)1<<(INT_IP5_PRI27_6_POS))
#define INT_IP5_PRI27_7                 ((uint32_t)1<<(INT_IP5_PRI27_7_POS))

/* INT_IP6 λ */
#define INT_IP6_PRI28_4_POS             (4)
#define INT_IP6_PRI28_5_POS             (5)
#define INT_IP6_PRI28_6_POS             (6)
#define INT_IP6_PRI28_7_POS             (7)
#define INT_IP6_PRI29_4_POS             (12)
#define INT_IP6_PRI29_5_POS             (13)
#define INT_IP6_PRI29_6_POS             (14)
#define INT_IP6_PRI29_7_POS             (15)
#define INT_IP6_PRI30_4_POS             (20)
#define INT_IP6_PRI30_5_POS             (21)
#define INT_IP6_PRI30_6_POS             (22)
#define INT_IP6_PRI30_7_POS             (23)
#define INT_IP6_PRI31_4_POS             (28)
#define INT_IP6_PRI31_5_POS             (29)
#define INT_IP6_PRI31_6_POS             (30)
#define INT_IP6_PRI31_7_POS             (31)
#define INT_IP6_PRI28_4                 ((uint32_t)1<<(INT_IP6_PRI28_4_POS))
#define INT_IP6_PRI28_5                 ((uint32_t)1<<(INT_IP6_PRI28_5_POS))
#define INT_IP6_PRI28_6                 ((uint32_t)1<<(INT_IP6_PRI28_6_POS))
#define INT_IP6_PRI28_7                 ((uint32_t)1<<(INT_IP6_PRI28_7_POS))
#define INT_IP6_PRI29_4                 ((uint32_t)1<<(INT_IP6_PRI29_4_POS))
#define INT_IP6_PRI29_5                 ((uint32_t)1<<(INT_IP6_PRI29_5_POS))
#define INT_IP6_PRI29_6                 ((uint32_t)1<<(INT_IP6_PRI29_6_POS))
#define INT_IP6_PRI29_7                 ((uint32_t)1<<(INT_IP6_PRI29_7_POS))
#define INT_IP6_PRI30_4                 ((uint32_t)1<<(INT_IP6_PRI30_4_POS))
#define INT_IP6_PRI30_5                 ((uint32_t)1<<(INT_IP6_PRI30_5_POS))
#define INT_IP6_PRI30_6                 ((uint32_t)1<<(INT_IP6_PRI30_6_POS))
#define INT_IP6_PRI30_7                 ((uint32_t)1<<(INT_IP6_PRI30_7_POS))
#define INT_IP6_PRI31_4                 ((uint32_t)1<<(INT_IP6_PRI31_4_POS))
#define INT_IP6_PRI31_5                 ((uint32_t)1<<(INT_IP6_PRI31_5_POS))
#define INT_IP6_PRI31_6                 ((uint32_t)1<<(INT_IP6_PRI31_6_POS))
#define INT_IP6_PRI31_7                 ((uint32_t)1<<(INT_IP6_PRI31_7_POS))

/* INT_IP7 λ */
#define INT_IP7_PRI32_4_POS             (4)
#define INT_IP7_PRI32_5_POS             (5)
#define INT_IP7_PRI32_6_POS             (6)
#define INT_IP7_PRI32_7_POS             (7)
#define INT_IP7_PRI33_4_POS             (12)
#define INT_IP7_PRI33_5_POS             (13)
#define INT_IP7_PRI33_6_POS             (14)
#define INT_IP7_PRI33_7_POS             (15)
#define INT_IP7_PRI34_4_POS             (20)
#define INT_IP7_PRI34_5_POS             (21)
#define INT_IP7_PRI34_6_POS             (22)
#define INT_IP7_PRI34_7_POS             (23)
#define INT_IP7_PRI35_4_POS             (28)
#define INT_IP7_PRI35_5_POS             (29)
#define INT_IP7_PRI35_6_POS             (30)
#define INT_IP7_PRI35_7_POS             (31)
#define INT_IP7_PRI32_4                 ((uint32_t)1<<(INT_IP7_PRI32_4_POS))
#define INT_IP7_PRI32_5                 ((uint32_t)1<<(INT_IP7_PRI32_5_POS))
#define INT_IP7_PRI32_6                 ((uint32_t)1<<(INT_IP7_PRI32_6_POS))
#define INT_IP7_PRI32_7                 ((uint32_t)1<<(INT_IP7_PRI32_7_POS))
#define INT_IP7_PRI33_4                 ((uint32_t)1<<(INT_IP7_PRI33_4_POS))
#define INT_IP7_PRI33_5                 ((uint32_t)1<<(INT_IP7_PRI33_5_POS))
#define INT_IP7_PRI33_6                 ((uint32_t)1<<(INT_IP7_PRI33_6_POS))
#define INT_IP7_PRI33_7                 ((uint32_t)1<<(INT_IP7_PRI33_7_POS))
#define INT_IP7_PRI34_4                 ((uint32_t)1<<(INT_IP7_PRI34_4_POS))
#define INT_IP7_PRI34_5                 ((uint32_t)1<<(INT_IP7_PRI34_5_POS))
#define INT_IP7_PRI34_6                 ((uint32_t)1<<(INT_IP7_PRI34_6_POS))
#define INT_IP7_PRI34_7                 ((uint32_t)1<<(INT_IP7_PRI34_7_POS))
#define INT_IP7_PRI35_4                 ((uint32_t)1<<(INT_IP7_PRI35_4_POS))
#define INT_IP7_PRI35_5                 ((uint32_t)1<<(INT_IP7_PRI35_5_POS))
#define INT_IP7_PRI35_6                 ((uint32_t)1<<(INT_IP7_PRI35_6_POS))
#define INT_IP7_PRI35_7                 ((uint32_t)1<<(INT_IP7_PRI35_7_POS))

/* INT_IP8 λ */
#define INT_IP8_PRI36_4_POS             (4)
#define INT_IP8_PRI36_5_POS             (5)
#define INT_IP8_PRI36_6_POS             (6)
#define INT_IP8_PRI36_7_POS             (7)
#define INT_IP8_PRI37_4_POS             (12)
#define INT_IP8_PRI37_5_POS             (13)
#define INT_IP8_PRI37_6_POS             (14)
#define INT_IP8_PRI37_7_POS             (15)
#define INT_IP8_PRI38_4_POS             (20)
#define INT_IP8_PRI38_5_POS             (21)
#define INT_IP8_PRI38_6_POS             (22)
#define INT_IP8_PRI38_7_POS             (23)
#define INT_IP8_PRI39_4_POS             (28)
#define INT_IP8_PRI39_5_POS             (29)
#define INT_IP8_PRI39_6_POS             (30)
#define INT_IP8_PRI39_7_POS             (31)
#define INT_IP8_PRI36_4                 ((uint32_t)1<<(INT_IP8_PRI36_4_POS))
#define INT_IP8_PRI36_5                 ((uint32_t)1<<(INT_IP8_PRI36_5_POS))
#define INT_IP8_PRI36_6                 ((uint32_t)1<<(INT_IP8_PRI36_6_POS))
#define INT_IP8_PRI36_7                 ((uint32_t)1<<(INT_IP8_PRI36_7_POS))
#define INT_IP8_PRI37_4                 ((uint32_t)1<<(INT_IP8_PRI37_4_POS))
#define INT_IP8_PRI37_5                 ((uint32_t)1<<(INT_IP8_PRI37_5_POS))
#define INT_IP8_PRI37_6                 ((uint32_t)1<<(INT_IP8_PRI37_6_POS))
#define INT_IP8_PRI37_7                 ((uint32_t)1<<(INT_IP8_PRI37_7_POS))
#define INT_IP8_PRI38_4                 ((uint32_t)1<<(INT_IP8_PRI38_4_POS))
#define INT_IP8_PRI38_5                 ((uint32_t)1<<(INT_IP8_PRI38_5_POS))
#define INT_IP8_PRI38_6                 ((uint32_t)1<<(INT_IP8_PRI38_6_POS))
#define INT_IP8_PRI38_7                 ((uint32_t)1<<(INT_IP8_PRI38_7_POS))
#define INT_IP8_PRI39_4                 ((uint32_t)1<<(INT_IP8_PRI39_4_POS))
#define INT_IP8_PRI39_5                 ((uint32_t)1<<(INT_IP8_PRI39_5_POS))
#define INT_IP8_PRI39_6                 ((uint32_t)1<<(INT_IP8_PRI39_6_POS))
#define INT_IP8_PRI39_7                 ((uint32_t)1<<(INT_IP8_PRI39_7_POS))

/* INT_IP9 λ */
#define INT_IP9_PRI40_4_POS             (4)
#define INT_IP9_PRI40_5_POS             (5)
#define INT_IP9_PRI40_6_POS             (6)
#define INT_IP9_PRI40_7_POS             (7)
#define INT_IP9_PRI41_4_POS             (12)
#define INT_IP9_PRI41_5_POS             (13)
#define INT_IP9_PRI41_6_POS             (14)
#define INT_IP9_PRI41_7_POS             (15)
#define INT_IP9_PRI42_4_POS             (20)
#define INT_IP9_PRI42_5_POS             (21)
#define INT_IP9_PRI42_6_POS             (22)
#define INT_IP9_PRI42_7_POS             (23)
#define INT_IP9_PRI43_4_POS             (28)
#define INT_IP9_PRI43_5_POS             (29)
#define INT_IP9_PRI43_6_POS             (30)
#define INT_IP9_PRI43_7_POS             (31)
#define INT_IP9_PRI40_4                 ((uint32_t)1<<(INT_IP9_PRI40_4_POS))
#define INT_IP9_PRI40_5                 ((uint32_t)1<<(INT_IP9_PRI40_5_POS))
#define INT_IP9_PRI40_6                 ((uint32_t)1<<(INT_IP9_PRI40_6_POS))
#define INT_IP9_PRI40_7                 ((uint32_t)1<<(INT_IP9_PRI40_7_POS))
#define INT_IP9_PRI41_4                 ((uint32_t)1<<(INT_IP9_PRI41_4_POS))
#define INT_IP9_PRI41_5                 ((uint32_t)1<<(INT_IP9_PRI41_5_POS))
#define INT_IP9_PRI41_6                 ((uint32_t)1<<(INT_IP9_PRI41_6_POS))
#define INT_IP9_PRI41_7                 ((uint32_t)1<<(INT_IP9_PRI41_7_POS))
#define INT_IP9_PRI42_4                 ((uint32_t)1<<(INT_IP9_PRI42_4_POS))
#define INT_IP9_PRI42_5                 ((uint32_t)1<<(INT_IP9_PRI42_5_POS))
#define INT_IP9_PRI42_6                 ((uint32_t)1<<(INT_IP9_PRI42_6_POS))
#define INT_IP9_PRI42_7                 ((uint32_t)1<<(INT_IP9_PRI42_7_POS))
#define INT_IP9_PRI43_4                 ((uint32_t)1<<(INT_IP9_PRI43_4_POS))
#define INT_IP9_PRI43_5                 ((uint32_t)1<<(INT_IP9_PRI43_5_POS))
#define INT_IP9_PRI43_6                 ((uint32_t)1<<(INT_IP9_PRI43_6_POS))
#define INT_IP9_PRI43_7                 ((uint32_t)1<<(INT_IP9_PRI43_7_POS))

/* INT_IP10 λ */
#define INT_IP10_PRI44_4_POS            (4)
#define INT_IP10_PRI44_5_POS            (5)
#define INT_IP10_PRI44_6_POS            (6)
#define INT_IP10_PRI44_7_POS            (7)
#define INT_IP10_PRI45_4_POS            (12)
#define INT_IP10_PRI45_5_POS            (13)
#define INT_IP10_PRI45_6_POS            (14)
#define INT_IP10_PRI45_7_POS            (15)
#define INT_IP10_PRI46_4_POS            (20)
#define INT_IP10_PRI46_5_POS            (21)
#define INT_IP10_PRI46_6_POS            (22)
#define INT_IP10_PRI46_7_POS            (23)
#define INT_IP10_PRI47_4_POS            (28)
#define INT_IP10_PRI47_5_POS            (29)
#define INT_IP10_PRI47_6_POS            (30)
#define INT_IP10_PRI47_7_POS            (31)
#define INT_IP10_PRI44_4                ((uint32_t)1<<(INT_IP10_PRI44_4_POS))
#define INT_IP10_PRI44_5                ((uint32_t)1<<(INT_IP10_PRI44_5_POS))
#define INT_IP10_PRI44_6                ((uint32_t)1<<(INT_IP10_PRI44_6_POS))
#define INT_IP10_PRI44_7                ((uint32_t)1<<(INT_IP10_PRI44_7_POS))
#define INT_IP10_PRI45_4                ((uint32_t)1<<(INT_IP10_PRI45_4_POS))
#define INT_IP10_PRI45_5                ((uint32_t)1<<(INT_IP10_PRI45_5_POS))
#define INT_IP10_PRI45_6                ((uint32_t)1<<(INT_IP10_PRI45_6_POS))
#define INT_IP10_PRI45_7                ((uint32_t)1<<(INT_IP10_PRI45_7_POS))
#define INT_IP10_PRI46_4                ((uint32_t)1<<(INT_IP10_PRI46_4_POS))
#define INT_IP10_PRI46_5                ((uint32_t)1<<(INT_IP10_PRI46_5_POS))
#define INT_IP10_PRI46_6                ((uint32_t)1<<(INT_IP10_PRI46_6_POS))
#define INT_IP10_PRI46_7                ((uint32_t)1<<(INT_IP10_PRI46_7_POS))
#define INT_IP10_PRI47_4                ((uint32_t)1<<(INT_IP10_PRI47_4_POS))
#define INT_IP10_PRI47_5                ((uint32_t)1<<(INT_IP10_PRI47_5_POS))
#define INT_IP10_PRI47_6                ((uint32_t)1<<(INT_IP10_PRI47_6_POS))
#define INT_IP10_PRI47_7                ((uint32_t)1<<(INT_IP10_PRI47_7_POS))

/* INT_IP11 λ */
#define INT_IP11_PRI48_4_POS            (4)
#define INT_IP11_PRI48_5_POS            (5)
#define INT_IP11_PRI48_6_POS            (6)
#define INT_IP11_PRI48_7_POS            (7)
#define INT_IP11_PRI49_4_POS            (12)
#define INT_IP11_PRI49_5_POS            (13)
#define INT_IP11_PRI49_6_POS            (14)
#define INT_IP11_PRI49_7_POS            (15)
#define INT_IP11_PRI50_4_POS            (20)
#define INT_IP11_PRI50_5_POS            (21)
#define INT_IP11_PRI50_6_POS            (22)
#define INT_IP11_PRI50_7_POS            (23)
#define INT_IP11_PRI51_4_POS            (28)
#define INT_IP11_PRI51_5_POS            (29)
#define INT_IP11_PRI51_6_POS            (30)
#define INT_IP11_PRI51_7_POS            (31)
#define INT_IP11_PRI48_4                ((uint32_t)1<<(INT_IP11_PRI48_4_POS))
#define INT_IP11_PRI48_5                ((uint32_t)1<<(INT_IP11_PRI48_5_POS))
#define INT_IP11_PRI48_6                ((uint32_t)1<<(INT_IP11_PRI48_6_POS))
#define INT_IP11_PRI48_7                ((uint32_t)1<<(INT_IP11_PRI48_7_POS))
#define INT_IP11_PRI49_4                ((uint32_t)1<<(INT_IP11_PRI49_4_POS))
#define INT_IP11_PRI49_5                ((uint32_t)1<<(INT_IP11_PRI49_5_POS))
#define INT_IP11_PRI49_6                ((uint32_t)1<<(INT_IP11_PRI49_6_POS))
#define INT_IP11_PRI49_7                ((uint32_t)1<<(INT_IP11_PRI49_7_POS))
#define INT_IP11_PRI50_4                ((uint32_t)1<<(INT_IP11_PRI50_4_POS))
#define INT_IP11_PRI50_5                ((uint32_t)1<<(INT_IP11_PRI50_5_POS))
#define INT_IP11_PRI50_6                ((uint32_t)1<<(INT_IP11_PRI50_6_POS))
#define INT_IP11_PRI50_7                ((uint32_t)1<<(INT_IP11_PRI50_7_POS))
#define INT_IP11_PRI51_4                ((uint32_t)1<<(INT_IP11_PRI51_4_POS))
#define INT_IP11_PRI51_5                ((uint32_t)1<<(INT_IP11_PRI51_5_POS))
#define INT_IP11_PRI51_6                ((uint32_t)1<<(INT_IP11_PRI51_6_POS))
#define INT_IP11_PRI51_7                ((uint32_t)1<<(INT_IP11_PRI51_7_POS))

/* INT_IP12 λ */
#define INT_IP12_PRI52_4_POS            (4)
#define INT_IP12_PRI52_5_POS            (5)
#define INT_IP12_PRI52_6_POS            (6)
#define INT_IP12_PRI52_7_POS            (7)
#define INT_IP12_PRI53_4_POS            (12)
#define INT_IP12_PRI53_5_POS            (13)
#define INT_IP12_PRI53_6_POS            (14)
#define INT_IP12_PRI53_7_POS            (15)
#define INT_IP12_PRI54_4_POS            (20)
#define INT_IP12_PRI54_5_POS            (21)
#define INT_IP12_PRI54_6_POS            (22)
#define INT_IP12_PRI54_7_POS            (23)
#define INT_IP12_PRI55_4_POS            (28)
#define INT_IP12_PRI55_5_POS            (29)
#define INT_IP12_PRI55_6_POS            (30)
#define INT_IP12_PRI55_7_POS            (31)
#define INT_IP12_PRI52_4                ((uint32_t)1<<(INT_IP12_PRI52_4_POS))
#define INT_IP12_PRI52_5                ((uint32_t)1<<(INT_IP12_PRI52_5_POS))
#define INT_IP12_PRI52_6                ((uint32_t)1<<(INT_IP12_PRI52_6_POS))
#define INT_IP12_PRI52_7                ((uint32_t)1<<(INT_IP12_PRI52_7_POS))
#define INT_IP12_PRI53_4                ((uint32_t)1<<(INT_IP12_PRI53_4_POS))
#define INT_IP12_PRI53_5                ((uint32_t)1<<(INT_IP12_PRI53_5_POS))
#define INT_IP12_PRI53_6                ((uint32_t)1<<(INT_IP12_PRI53_6_POS))
#define INT_IP12_PRI53_7                ((uint32_t)1<<(INT_IP12_PRI53_7_POS))
#define INT_IP12_PRI54_4                ((uint32_t)1<<(INT_IP12_PRI54_4_POS))
#define INT_IP12_PRI54_5                ((uint32_t)1<<(INT_IP12_PRI54_5_POS))
#define INT_IP12_PRI54_6                ((uint32_t)1<<(INT_IP12_PRI54_6_POS))
#define INT_IP12_PRI54_7                ((uint32_t)1<<(INT_IP12_PRI54_7_POS))
#define INT_IP12_PRI55_4                ((uint32_t)1<<(INT_IP12_PRI55_4_POS))
#define INT_IP12_PRI55_5                ((uint32_t)1<<(INT_IP12_PRI55_5_POS))
#define INT_IP12_PRI55_6                ((uint32_t)1<<(INT_IP12_PRI55_6_POS))
#define INT_IP12_PRI55_7                ((uint32_t)1<<(INT_IP12_PRI55_7_POS))

/* INT_IP13 λ */
#define INT_IP13_PRI56_4_POS            (4)
#define INT_IP13_PRI56_5_POS            (5)
#define INT_IP13_PRI56_6_POS            (6)
#define INT_IP13_PRI56_7_POS            (7)
#define INT_IP13_PRI57_4_POS            (12)
#define INT_IP13_PRI57_5_POS            (13)
#define INT_IP13_PRI57_6_POS            (14)
#define INT_IP13_PRI57_7_POS            (15)
#define INT_IP13_PRI58_4_POS            (20)
#define INT_IP13_PRI58_5_POS            (21)
#define INT_IP13_PRI58_6_POS            (22)
#define INT_IP13_PRI58_7_POS            (23)
#define INT_IP13_PRI59_4_POS            (28)
#define INT_IP13_PRI59_5_POS            (29)
#define INT_IP13_PRI59_6_POS            (30)
#define INT_IP13_PRI59_7_POS            (31)
#define INT_IP13_PRI56_4                ((uint32_t)1<<(INT_IP13_PRI56_4_POS))
#define INT_IP13_PRI56_5                ((uint32_t)1<<(INT_IP13_PRI56_5_POS))
#define INT_IP13_PRI56_6                ((uint32_t)1<<(INT_IP13_PRI56_6_POS))
#define INT_IP13_PRI56_7                ((uint32_t)1<<(INT_IP13_PRI56_7_POS))
#define INT_IP13_PRI57_4                ((uint32_t)1<<(INT_IP13_PRI57_4_POS))
#define INT_IP13_PRI57_5                ((uint32_t)1<<(INT_IP13_PRI57_5_POS))
#define INT_IP13_PRI57_6                ((uint32_t)1<<(INT_IP13_PRI57_6_POS))
#define INT_IP13_PRI57_7                ((uint32_t)1<<(INT_IP13_PRI57_7_POS))
#define INT_IP13_PRI58_4                ((uint32_t)1<<(INT_IP13_PRI58_4_POS))
#define INT_IP13_PRI58_5                ((uint32_t)1<<(INT_IP13_PRI58_5_POS))
#define INT_IP13_PRI58_6                ((uint32_t)1<<(INT_IP13_PRI58_6_POS))
#define INT_IP13_PRI58_7                ((uint32_t)1<<(INT_IP13_PRI58_7_POS))
#define INT_IP13_PRI59_4                ((uint32_t)1<<(INT_IP13_PRI59_4_POS))
#define INT_IP13_PRI59_5                ((uint32_t)1<<(INT_IP13_PRI59_5_POS))
#define INT_IP13_PRI59_6                ((uint32_t)1<<(INT_IP13_PRI59_6_POS))
#define INT_IP13_PRI59_7                ((uint32_t)1<<(INT_IP13_PRI59_7_POS))

/* INT_IP14 λ */
#define INT_IP14_PRI60_4_POS            (4)
#define INT_IP14_PRI60_5_POS            (5)
#define INT_IP14_PRI60_6_POS            (6)
#define INT_IP14_PRI60_7_POS            (7)
#define INT_IP14_PRI61_4_POS            (12)
#define INT_IP14_PRI61_5_POS            (13)
#define INT_IP14_PRI61_6_POS            (14)
#define INT_IP14_PRI61_7_POS            (15)
#define INT_IP14_PRI62_4_POS            (20)
#define INT_IP14_PRI62_5_POS            (21)
#define INT_IP14_PRI62_6_POS            (22)
#define INT_IP14_PRI62_7_POS            (23)
#define INT_IP14_PRI63_4_POS            (28)
#define INT_IP14_PRI63_5_POS            (29)
#define INT_IP14_PRI63_6_POS            (30)
#define INT_IP14_PRI63_7_POS            (31)
#define INT_IP14_PRI60_4                ((uint32_t)1<<(INT_IP14_PRI60_4_POS))
#define INT_IP14_PRI60_5                ((uint32_t)1<<(INT_IP14_PRI60_5_POS))
#define INT_IP14_PRI60_6                ((uint32_t)1<<(INT_IP14_PRI60_6_POS))
#define INT_IP14_PRI60_7                ((uint32_t)1<<(INT_IP14_PRI60_7_POS))
#define INT_IP14_PRI61_4                ((uint32_t)1<<(INT_IP14_PRI61_4_POS))
#define INT_IP14_PRI61_5                ((uint32_t)1<<(INT_IP14_PRI61_5_POS))
#define INT_IP14_PRI61_6                ((uint32_t)1<<(INT_IP14_PRI61_6_POS))
#define INT_IP14_PRI61_7                ((uint32_t)1<<(INT_IP14_PRI61_7_POS))
#define INT_IP14_PRI62_4                ((uint32_t)1<<(INT_IP14_PRI62_4_POS))
#define INT_IP14_PRI62_5                ((uint32_t)1<<(INT_IP14_PRI62_5_POS))
#define INT_IP14_PRI62_6                ((uint32_t)1<<(INT_IP14_PRI62_6_POS))
#define INT_IP14_PRI62_7                ((uint32_t)1<<(INT_IP14_PRI62_7_POS))
#define INT_IP14_PRI63_4                ((uint32_t)1<<(INT_IP14_PRI63_4_POS))
#define INT_IP14_PRI63_5                ((uint32_t)1<<(INT_IP14_PRI63_5_POS))
#define INT_IP14_PRI63_6                ((uint32_t)1<<(INT_IP14_PRI63_6_POS))
#define INT_IP14_PRI63_7                ((uint32_t)1<<(INT_IP14_PRI63_7_POS))

/* INT_IP15 λ */
#define INT_IP15_PRI64_4_POS            (4)
#define INT_IP15_PRI64_5_POS            (5)
#define INT_IP15_PRI64_6_POS            (6)
#define INT_IP15_PRI64_7_POS            (7)
#define INT_IP15_PRI65_4_POS            (12)
#define INT_IP15_PRI65_5_POS            (13)
#define INT_IP15_PRI65_6_POS            (14)
#define INT_IP15_PRI65_7_POS            (15)
#define INT_IP15_PRI66_4_POS            (20)
#define INT_IP15_PRI66_5_POS            (21)
#define INT_IP15_PRI66_6_POS            (22)
#define INT_IP15_PRI66_7_POS            (23)
#define INT_IP15_PRI67_4_POS            (28)
#define INT_IP15_PRI67_5_POS            (29)
#define INT_IP15_PRI67_6_POS            (30)
#define INT_IP15_PRI67_7_POS            (31)
#define INT_IP15_PRI64_4                ((uint32_t)1<<(INT_IP15_PRI64_4_POS))
#define INT_IP15_PRI64_5                ((uint32_t)1<<(INT_IP15_PRI64_5_POS))
#define INT_IP15_PRI64_6                ((uint32_t)1<<(INT_IP15_PRI64_6_POS))
#define INT_IP15_PRI64_7                ((uint32_t)1<<(INT_IP15_PRI64_7_POS))
#define INT_IP15_PRI65_4                ((uint32_t)1<<(INT_IP15_PRI65_4_POS))
#define INT_IP15_PRI65_5                ((uint32_t)1<<(INT_IP15_PRI65_5_POS))
#define INT_IP15_PRI65_6                ((uint32_t)1<<(INT_IP15_PRI65_6_POS))
#define INT_IP15_PRI65_7                ((uint32_t)1<<(INT_IP15_PRI65_7_POS))
#define INT_IP15_PRI66_4                ((uint32_t)1<<(INT_IP15_PRI66_4_POS))
#define INT_IP15_PRI66_5                ((uint32_t)1<<(INT_IP15_PRI66_5_POS))
#define INT_IP15_PRI66_6                ((uint32_t)1<<(INT_IP15_PRI66_6_POS))
#define INT_IP15_PRI66_7                ((uint32_t)1<<(INT_IP15_PRI66_7_POS))
#define INT_IP15_PRI67_4                ((uint32_t)1<<(INT_IP15_PRI67_4_POS))
#define INT_IP15_PRI67_5                ((uint32_t)1<<(INT_IP15_PRI67_5_POS))
#define INT_IP15_PRI67_6                ((uint32_t)1<<(INT_IP15_PRI67_6_POS))
#define INT_IP15_PRI67_7                ((uint32_t)1<<(INT_IP15_PRI67_7_POS))

/* INT_IP16 λ */
#define INT_IP16_PRI68_4_POS            (4)
#define INT_IP16_PRI68_5_POS            (5)
#define INT_IP16_PRI68_6_POS            (6)
#define INT_IP16_PRI68_7_POS            (7)
#define INT_IP16_PRI69_4_POS            (12)
#define INT_IP16_PRI69_5_POS            (13)
#define INT_IP16_PRI69_6_POS            (14)
#define INT_IP16_PRI69_7_POS            (15)
#define INT_IP16_PRI70_4_POS            (20)
#define INT_IP16_PRI70_5_POS            (21)
#define INT_IP16_PRI70_6_POS            (22)
#define INT_IP16_PRI70_7_POS            (23)
#define INT_IP16_PRI71_4_POS            (28)
#define INT_IP16_PRI71_5_POS            (29)
#define INT_IP16_PRI71_6_POS            (30)
#define INT_IP16_PRI71_7_POS            (31)
#define INT_IP16_PRI68_4                ((uint32_t)1<<(INT_IP16_PRI68_4_POS))
#define INT_IP16_PRI68_5                ((uint32_t)1<<(INT_IP16_PRI68_5_POS))
#define INT_IP16_PRI68_6                ((uint32_t)1<<(INT_IP16_PRI68_6_POS))
#define INT_IP16_PRI68_7                ((uint32_t)1<<(INT_IP16_PRI68_7_POS))
#define INT_IP16_PRI69_4                ((uint32_t)1<<(INT_IP16_PRI69_4_POS))
#define INT_IP16_PRI69_5                ((uint32_t)1<<(INT_IP16_PRI69_5_POS))
#define INT_IP16_PRI69_6                ((uint32_t)1<<(INT_IP16_PRI69_6_POS))
#define INT_IP16_PRI69_7                ((uint32_t)1<<(INT_IP16_PRI69_7_POS))
#define INT_IP16_PRI70_4                ((uint32_t)1<<(INT_IP16_PRI70_4_POS))
#define INT_IP16_PRI70_5                ((uint32_t)1<<(INT_IP16_PRI70_5_POS))
#define INT_IP16_PRI70_6                ((uint32_t)1<<(INT_IP16_PRI70_6_POS))
#define INT_IP16_PRI70_7                ((uint32_t)1<<(INT_IP16_PRI70_7_POS))
#define INT_IP16_PRI71_4                ((uint32_t)1<<(INT_IP16_PRI71_4_POS))
#define INT_IP16_PRI71_5                ((uint32_t)1<<(INT_IP16_PRI71_5_POS))
#define INT_IP16_PRI71_6                ((uint32_t)1<<(INT_IP16_PRI71_6_POS))
#define INT_IP16_PRI71_7                ((uint32_t)1<<(INT_IP16_PRI71_7_POS))

/* INT_IP17 λ */
#define INT_IP17_PRI72_4_POS            (4)
#define INT_IP17_PRI72_5_POS            (5)
#define INT_IP17_PRI72_6_POS            (6)
#define INT_IP17_PRI72_7_POS            (7)
#define INT_IP17_PRI73_4_POS            (12)
#define INT_IP17_PRI73_5_POS            (13)
#define INT_IP17_PRI73_6_POS            (14)
#define INT_IP17_PRI73_7_POS            (15)
#define INT_IP17_PRI74_4_POS            (20)
#define INT_IP17_PRI74_5_POS            (21)
#define INT_IP17_PRI74_6_POS            (22)
#define INT_IP17_PRI74_7_POS            (23)
#define INT_IP17_PRI75_4_POS            (28)
#define INT_IP17_PRI75_5_POS            (29)
#define INT_IP17_PRI75_6_POS            (30)
#define INT_IP17_PRI75_7_POS            (31)
#define INT_IP17_PRI72_4                ((uint32_t)1<<(INT_IP17_PRI72_4_POS))
#define INT_IP17_PRI72_5                ((uint32_t)1<<(INT_IP17_PRI72_5_POS))
#define INT_IP17_PRI72_6                ((uint32_t)1<<(INT_IP17_PRI72_6_POS))
#define INT_IP17_PRI72_7                ((uint32_t)1<<(INT_IP17_PRI72_7_POS))
#define INT_IP17_PRI73_4                ((uint32_t)1<<(INT_IP17_PRI73_4_POS))
#define INT_IP17_PRI73_5                ((uint32_t)1<<(INT_IP17_PRI73_5_POS))
#define INT_IP17_PRI73_6                ((uint32_t)1<<(INT_IP17_PRI73_6_POS))
#define INT_IP17_PRI73_7                ((uint32_t)1<<(INT_IP17_PRI73_7_POS))
#define INT_IP17_PRI74_4                ((uint32_t)1<<(INT_IP17_PRI74_4_POS))
#define INT_IP17_PRI74_5                ((uint32_t)1<<(INT_IP17_PRI74_5_POS))
#define INT_IP17_PRI74_6                ((uint32_t)1<<(INT_IP17_PRI74_6_POS))
#define INT_IP17_PRI74_7                ((uint32_t)1<<(INT_IP17_PRI74_7_POS))
#define INT_IP17_PRI75_4                ((uint32_t)1<<(INT_IP17_PRI75_4_POS))
#define INT_IP17_PRI75_5                ((uint32_t)1<<(INT_IP17_PRI75_5_POS))
#define INT_IP17_PRI75_6                ((uint32_t)1<<(INT_IP17_PRI75_6_POS))
#define INT_IP17_PRI75_7                ((uint32_t)1<<(INT_IP17_PRI75_7_POS))

/* INT_IP18 λ */
#define INT_IP18_PRI76_4_POS            (4)
#define INT_IP18_PRI76_5_POS            (5)
#define INT_IP18_PRI76_6_POS            (6)
#define INT_IP18_PRI76_7_POS            (7)
#define INT_IP18_PRI77_4_POS            (12)
#define INT_IP18_PRI77_5_POS            (13)
#define INT_IP18_PRI77_6_POS            (14)
#define INT_IP18_PRI77_7_POS            (15)
#define INT_IP18_PRI78_4_POS            (20)
#define INT_IP18_PRI78_5_POS            (21)
#define INT_IP18_PRI78_6_POS            (22)
#define INT_IP18_PRI78_7_POS            (23)
#define INT_IP18_PRI79_4_POS            (28)
#define INT_IP18_PRI79_5_POS            (29)
#define INT_IP18_PRI79_6_POS            (30)
#define INT_IP18_PRI79_7_POS            (31)
#define INT_IP18_PRI76_4                ((uint32_t)1<<(INT_IP18_PRI76_4_POS))
#define INT_IP18_PRI76_5                ((uint32_t)1<<(INT_IP18_PRI76_5_POS))
#define INT_IP18_PRI76_6                ((uint32_t)1<<(INT_IP18_PRI76_6_POS))
#define INT_IP18_PRI76_7                ((uint32_t)1<<(INT_IP18_PRI76_7_POS))
#define INT_IP18_PRI77_4                ((uint32_t)1<<(INT_IP18_PRI77_4_POS))
#define INT_IP18_PRI77_5                ((uint32_t)1<<(INT_IP18_PRI77_5_POS))
#define INT_IP18_PRI77_6                ((uint32_t)1<<(INT_IP18_PRI77_6_POS))
#define INT_IP18_PRI77_7                ((uint32_t)1<<(INT_IP18_PRI77_7_POS))
#define INT_IP18_PRI78_4                ((uint32_t)1<<(INT_IP18_PRI78_4_POS))
#define INT_IP18_PRI78_5                ((uint32_t)1<<(INT_IP18_PRI78_5_POS))
#define INT_IP18_PRI78_6                ((uint32_t)1<<(INT_IP18_PRI78_6_POS))
#define INT_IP18_PRI78_7                ((uint32_t)1<<(INT_IP18_PRI78_7_POS))
#define INT_IP18_PRI79_4                ((uint32_t)1<<(INT_IP18_PRI79_4_POS))
#define INT_IP18_PRI79_5                ((uint32_t)1<<(INT_IP18_PRI79_5_POS))
#define INT_IP18_PRI79_6                ((uint32_t)1<<(INT_IP18_PRI79_6_POS))
#define INT_IP18_PRI79_7                ((uint32_t)1<<(INT_IP18_PRI79_7_POS))

/* INT_EINTMASK λ */
#define INT_EINTMASK_EINTM0_POS         (0)
#define INT_EINTMASK_EINTM1_POS         (1)
#define INT_EINTMASK_EINTM2_POS         (2)
#define INT_EINTMASK_EINTM3_POS         (3)
#define INT_EINTMASK_EINTM4_POS         (4)
#define INT_EINTMASK_EINTM5_POS         (5)
#define INT_EINTMASK_EINTM6_POS         (6)
#define INT_EINTMASK_EINTM7_POS         (7)
#define INT_EINTMASK_EINTM8_POS         (8)
#define INT_EINTMASK_EINTM9_POS         (9)
#define INT_EINTMASK_EINTM10_POS        (10)
#define INT_EINTMASK_EINTM11_POS        (11)
#define INT_EINTMASK_EINTM12_POS        (12)
#define INT_EINTMASK_EINTM13_POS        (13)
#define INT_EINTMASK_EINTM14_POS        (14)
#define INT_EINTMASK_EINTM15_POS        (15)
#define INT_EINTMASK_EINTM16_POS        (16)
#define INT_EINTMASK_EINTM17_POS        (17)
#define INT_EINTMASK_EINTM18_POS        (18)
#define INT_EINTMASK_EINTM19_POS        (19)
#define INT_EINTMASK_EINTM20_POS        (20)
#define INT_EINTMASK_EINTM0             ((uint32_t)1<<(INT_EINTMASK_EINTM0_POS))
#define INT_EINTMASK_EINTM1             ((uint32_t)1<<(INT_EINTMASK_EINTM1_POS))
#define INT_EINTMASK_EINTM2             ((uint32_t)1<<(INT_EINTMASK_EINTM2_POS))
#define INT_EINTMASK_EINTM3             ((uint32_t)1<<(INT_EINTMASK_EINTM3_POS))
#define INT_EINTMASK_EINTM4             ((uint32_t)1<<(INT_EINTMASK_EINTM4_POS))
#define INT_EINTMASK_EINTM5             ((uint32_t)1<<(INT_EINTMASK_EINTM5_POS))
#define INT_EINTMASK_EINTM6             ((uint32_t)1<<(INT_EINTMASK_EINTM6_POS))
#define INT_EINTMASK_EINTM7             ((uint32_t)1<<(INT_EINTMASK_EINTM7_POS))
#define INT_EINTMASK_EINTM8             ((uint32_t)1<<(INT_EINTMASK_EINTM8_POS))
#define INT_EINTMASK_EINTM9             ((uint32_t)1<<(INT_EINTMASK_EINTM9_POS))
#define INT_EINTMASK_EINTM10            ((uint32_t)1<<(INT_EINTMASK_EINTM10_POS))
#define INT_EINTMASK_EINTM11            ((uint32_t)1<<(INT_EINTMASK_EINTM11_POS))
#define INT_EINTMASK_EINTM12            ((uint32_t)1<<(INT_EINTMASK_EINTM12_POS))
#define INT_EINTMASK_EINTM13            ((uint32_t)1<<(INT_EINTMASK_EINTM13_POS))
#define INT_EINTMASK_EINTM14            ((uint32_t)1<<(INT_EINTMASK_EINTM14_POS))
#define INT_EINTMASK_EINTM15            ((uint32_t)1<<(INT_EINTMASK_EINTM15_POS))
#define INT_EINTMASK_EINTM16            ((uint32_t)1<<(INT_EINTMASK_EINTM16_POS))
#define INT_EINTMASK_EINTM17            ((uint32_t)1<<(INT_EINTMASK_EINTM17_POS))
#define INT_EINTMASK_EINTM18            ((uint32_t)1<<(INT_EINTMASK_EINTM18_POS))
#define INT_EINTMASK_EINTM19            ((uint32_t)1<<(INT_EINTMASK_EINTM19_POS))
#define INT_EINTMASK_EINTM20            ((uint32_t)1<<(INT_EINTMASK_EINTM20_POS))

/* INT_EINTRISE λ */
#define INT_EINTRISE_EINTRI0_POS        (0)
#define INT_EINTRISE_EINTRI1_POS        (1)
#define INT_EINTRISE_EINTRI2_POS        (2)
#define INT_EINTRISE_EINTRI3_POS        (3)
#define INT_EINTRISE_EINTRI4_POS        (4)
#define INT_EINTRISE_EINTRI5_POS        (5)
#define INT_EINTRISE_EINTRI6_POS        (6)
#define INT_EINTRISE_EINTRI7_POS        (7)
#define INT_EINTRISE_EINTRI8_POS        (8)
#define INT_EINTRISE_EINTRI9_POS        (9)
#define INT_EINTRISE_EINTRI10_POS       (10)
#define INT_EINTRISE_EINTRI11_POS       (11)
#define INT_EINTRISE_EINTRI12_POS       (12)
#define INT_EINTRISE_EINTRI13_POS       (13)
#define INT_EINTRISE_EINTRI14_POS       (14)
#define INT_EINTRISE_EINTRI15_POS       (15)
#define INT_EINTRISE_EINTRI16_POS       (16)
#define INT_EINTRISE_EINTRI17_POS       (17)
#define INT_EINTRISE_EINTRI18_POS       (18)
#define INT_EINTRISE_EINTRI19_POS       (19)
#define INT_EINTRISE_EINTRI20_POS       (20)
#define INT_EINTRISE_EINTRI0            ((uint32_t)1<<(INT_EINTRISE_EINTRI0_POS))
#define INT_EINTRISE_EINTRI1            ((uint32_t)1<<(INT_EINTRISE_EINTRI1_POS))
#define INT_EINTRISE_EINTRI2            ((uint32_t)1<<(INT_EINTRISE_EINTRI2_POS))
#define INT_EINTRISE_EINTRI3            ((uint32_t)1<<(INT_EINTRISE_EINTRI3_POS))
#define INT_EINTRISE_EINTRI4            ((uint32_t)1<<(INT_EINTRISE_EINTRI4_POS))
#define INT_EINTRISE_EINTRI5            ((uint32_t)1<<(INT_EINTRISE_EINTRI5_POS))
#define INT_EINTRISE_EINTRI6            ((uint32_t)1<<(INT_EINTRISE_EINTRI6_POS))
#define INT_EINTRISE_EINTRI7            ((uint32_t)1<<(INT_EINTRISE_EINTRI7_POS))
#define INT_EINTRISE_EINTRI8            ((uint32_t)1<<(INT_EINTRISE_EINTRI8_POS))
#define INT_EINTRISE_EINTRI9            ((uint32_t)1<<(INT_EINTRISE_EINTRI9_POS))
#define INT_EINTRISE_EINTRI10           ((uint32_t)1<<(INT_EINTRISE_EINTRI10_POS))
#define INT_EINTRISE_EINTRI11           ((uint32_t)1<<(INT_EINTRISE_EINTRI11_POS))
#define INT_EINTRISE_EINTRI12           ((uint32_t)1<<(INT_EINTRISE_EINTRI12_POS))
#define INT_EINTRISE_EINTRI13           ((uint32_t)1<<(INT_EINTRISE_EINTRI13_POS))
#define INT_EINTRISE_EINTRI14           ((uint32_t)1<<(INT_EINTRISE_EINTRI14_POS))
#define INT_EINTRISE_EINTRI15           ((uint32_t)1<<(INT_EINTRISE_EINTRI15_POS))
#define INT_EINTRISE_EINTRI16           ((uint32_t)1<<(INT_EINTRISE_EINTRI16_POS))
#define INT_EINTRISE_EINTRI17           ((uint32_t)1<<(INT_EINTRISE_EINTRI17_POS))
#define INT_EINTRISE_EINTRI18           ((uint32_t)1<<(INT_EINTRISE_EINTRI18_POS))
#define INT_EINTRISE_EINTRI19           ((uint32_t)1<<(INT_EINTRISE_EINTRI19_POS))
#define INT_EINTRISE_EINTRI20           ((uint32_t)1<<(INT_EINTRISE_EINTRI20_POS))

/* INT_EINTFALL λ */
#define INT_EINTFALL_EINTFA0_POS        (0)
#define INT_EINTFALL_EINTFA1_POS        (1)
#define INT_EINTFALL_EINTFA2_POS        (2)
#define INT_EINTFALL_EINTFA3_POS        (3)
#define INT_EINTFALL_EINTFA4_POS        (4)
#define INT_EINTFALL_EINTFA5_POS        (5)
#define INT_EINTFALL_EINTFA6_POS        (6)
#define INT_EINTFALL_EINTFA7_POS        (7)
#define INT_EINTFALL_EINTFA8_POS        (8)
#define INT_EINTFALL_EINTFA9_POS        (9)
#define INT_EINTFALL_EINTFA10_POS       (10)
#define INT_EINTFALL_EINTFA11_POS       (11)
#define INT_EINTFALL_EINTFA12_POS       (12)
#define INT_EINTFALL_EINTFA13_POS       (13)
#define INT_EINTFALL_EINTFA14_POS       (14)
#define INT_EINTFALL_EINTFA15_POS       (15)
#define INT_EINTFALL_EINTFA16_POS       (16)
#define INT_EINTFALL_EINTFA17_POS       (17)
#define INT_EINTFALL_EINTFA18_POS       (18)
#define INT_EINTFALL_EINTFA19_POS       (19)
#define INT_EINTFALL_EINTFA20_POS       (20)
#define INT_EINTFALL_EINTFA0            ((uint32_t)1<<(INT_EINTFALL_EINTFA0_POS))
#define INT_EINTFALL_EINTFA1            ((uint32_t)1<<(INT_EINTFALL_EINTFA1_POS))
#define INT_EINTFALL_EINTFA2            ((uint32_t)1<<(INT_EINTFALL_EINTFA2_POS))
#define INT_EINTFALL_EINTFA3            ((uint32_t)1<<(INT_EINTFALL_EINTFA3_POS))
#define INT_EINTFALL_EINTFA4            ((uint32_t)1<<(INT_EINTFALL_EINTFA4_POS))
#define INT_EINTFALL_EINTFA5            ((uint32_t)1<<(INT_EINTFALL_EINTFA5_POS))
#define INT_EINTFALL_EINTFA6            ((uint32_t)1<<(INT_EINTFALL_EINTFA6_POS))
#define INT_EINTFALL_EINTFA7            ((uint32_t)1<<(INT_EINTFALL_EINTFA7_POS))
#define INT_EINTFALL_EINTFA8            ((uint32_t)1<<(INT_EINTFALL_EINTFA8_POS))
#define INT_EINTFALL_EINTFA9            ((uint32_t)1<<(INT_EINTFALL_EINTFA9_POS))
#define INT_EINTFALL_EINTFA10           ((uint32_t)1<<(INT_EINTFALL_EINTFA10_POS))
#define INT_EINTFALL_EINTFA11           ((uint32_t)1<<(INT_EINTFALL_EINTFA11_POS))
#define INT_EINTFALL_EINTFA12           ((uint32_t)1<<(INT_EINTFALL_EINTFA12_POS))
#define INT_EINTFALL_EINTFA13           ((uint32_t)1<<(INT_EINTFALL_EINTFA13_POS))
#define INT_EINTFALL_EINTFA14           ((uint32_t)1<<(INT_EINTFALL_EINTFA14_POS))
#define INT_EINTFALL_EINTFA15           ((uint32_t)1<<(INT_EINTFALL_EINTFA15_POS))
#define INT_EINTFALL_EINTFA16           ((uint32_t)1<<(INT_EINTFALL_EINTFA16_POS))
#define INT_EINTFALL_EINTFA17           ((uint32_t)1<<(INT_EINTFALL_EINTFA17_POS))
#define INT_EINTFALL_EINTFA18           ((uint32_t)1<<(INT_EINTFALL_EINTFA18_POS))
#define INT_EINTFALL_EINTFA19           ((uint32_t)1<<(INT_EINTFALL_EINTFA19_POS))
#define INT_EINTFALL_EINTFA20           ((uint32_t)1<<(INT_EINTFALL_EINTFA20_POS))

/* INT_EINTF λ */
#define INT_EINTF_EINTIF0_POS           (0)
#define INT_EINTF_EINTIF1_POS           (1)
#define INT_EINTF_EINTIF2_POS           (2)
#define INT_EINTF_EINTIF3_POS           (3)
#define INT_EINTF_EINTIF4_POS           (4)
#define INT_EINTF_EINTIF5_POS           (5)
#define INT_EINTF_EINTIF6_POS           (6)
#define INT_EINTF_EINTIF7_POS           (7)
#define INT_EINTF_EINTIF8_POS           (8)
#define INT_EINTF_EINTIF9_POS           (9)
#define INT_EINTF_EINTIF10_POS          (10)
#define INT_EINTF_EINTIF11_POS          (11)
#define INT_EINTF_EINTIF12_POS          (12)
#define INT_EINTF_EINTIF13_POS          (13)
#define INT_EINTF_EINTIF14_POS          (14)
#define INT_EINTF_EINTIF15_POS          (15)
#define INT_EINTF_EINTIF16_POS          (16)
#define INT_EINTF_EINTIF17_POS          (17)
#define INT_EINTF_EINTIF18_POS          (18)
#define INT_EINTF_EINTIF19_POS          (19)
#define INT_EINTF_EINTIF20_POS          (20)
#define INT_EINTF_EINTIF0               ((uint32_t)1<<(INT_EINTF_EINTIF0_POS))
#define INT_EINTF_EINTIF1               ((uint32_t)1<<(INT_EINTF_EINTIF1_POS))
#define INT_EINTF_EINTIF2               ((uint32_t)1<<(INT_EINTF_EINTIF2_POS))
#define INT_EINTF_EINTIF3               ((uint32_t)1<<(INT_EINTF_EINTIF3_POS))
#define INT_EINTF_EINTIF4               ((uint32_t)1<<(INT_EINTF_EINTIF4_POS))
#define INT_EINTF_EINTIF5               ((uint32_t)1<<(INT_EINTF_EINTIF5_POS))
#define INT_EINTF_EINTIF6               ((uint32_t)1<<(INT_EINTF_EINTIF6_POS))
#define INT_EINTF_EINTIF7               ((uint32_t)1<<(INT_EINTF_EINTIF7_POS))
#define INT_EINTF_EINTIF8               ((uint32_t)1<<(INT_EINTF_EINTIF8_POS))
#define INT_EINTF_EINTIF9               ((uint32_t)1<<(INT_EINTF_EINTIF9_POS))
#define INT_EINTF_EINTIF10              ((uint32_t)1<<(INT_EINTF_EINTIF10_POS))
#define INT_EINTF_EINTIF11              ((uint32_t)1<<(INT_EINTF_EINTIF11_POS))
#define INT_EINTF_EINTIF12              ((uint32_t)1<<(INT_EINTF_EINTIF12_POS))
#define INT_EINTF_EINTIF13              ((uint32_t)1<<(INT_EINTF_EINTIF13_POS))
#define INT_EINTF_EINTIF14              ((uint32_t)1<<(INT_EINTF_EINTIF14_POS))
#define INT_EINTF_EINTIF15              ((uint32_t)1<<(INT_EINTF_EINTIF15_POS))
#define INT_EINTF_EINTIF16              ((uint32_t)1<<(INT_EINTF_EINTIF16_POS))
#define INT_EINTF_EINTIF17              ((uint32_t)1<<(INT_EINTF_EINTIF17_POS))
#define INT_EINTF_EINTIF18              ((uint32_t)1<<(INT_EINTF_EINTIF18_POS))
#define INT_EINTF_EINTIF19              ((uint32_t)1<<(INT_EINTF_EINTIF19_POS))
#define INT_EINTF_EINTIF20              ((uint32_t)1<<(INT_EINTF_EINTIF20_POS))

/* INT_EINTSS0 λ */
#define INT_EINTSS0_EINTSOU0_0_POS      (0)
#define INT_EINTSS0_EINTSOU0_1_POS      (1)
#define INT_EINTSS0_EINTSOU0_2_POS      (2)
#define INT_EINTSS0_EINTSOU0_3_POS      (3)
#define INT_EINTSS0_EINTSOU1_0_POS      (4)
#define INT_EINTSS0_EINTSOU1_1_POS      (5)
#define INT_EINTSS0_EINTSOU1_2_POS      (6)
#define INT_EINTSS0_EINTSOU1_3_POS      (7)
#define INT_EINTSS0_EINTSOU2_0_POS      (8)
#define INT_EINTSS0_EINTSOU2_1_POS      (9)
#define INT_EINTSS0_EINTSOU2_2_POS      (10)
#define INT_EINTSS0_EINTSOU2_3_POS      (11)
#define INT_EINTSS0_EINTSOU3_0_POS      (12)
#define INT_EINTSS0_EINTSOU3_1_POS      (13)
#define INT_EINTSS0_EINTSOU3_2_POS      (14)
#define INT_EINTSS0_EINTSOU3_3_POS      (15)
#define INT_EINTSS0_EINTSOU4_0_POS      (16)
#define INT_EINTSS0_EINTSOU4_1_POS      (17)
#define INT_EINTSS0_EINTSOU4_2_POS      (18)
#define INT_EINTSS0_EINTSOU4_3_POS      (19)
#define INT_EINTSS0_EINTSOU5_0_POS      (20)
#define INT_EINTSS0_EINTSOU5_1_POS      (21)
#define INT_EINTSS0_EINTSOU5_2_POS      (22)
#define INT_EINTSS0_EINTSOU5_3_POS      (23)
#define INT_EINTSS0_EINTSOU6_0_POS      (24)
#define INT_EINTSS0_EINTSOU6_1_POS      (25)
#define INT_EINTSS0_EINTSOU6_2_POS      (26)
#define INT_EINTSS0_EINTSOU6_3_POS      (27)
#define INT_EINTSS0_EINTSOU7_0_POS      (28)
#define INT_EINTSS0_EINTSOU7_1_POS      (29)
#define INT_EINTSS0_EINTSOU7_2_POS      (30)
#define INT_EINTSS0_EINTSOU7_3_POS      (31)
#define INT_EINTSS0_EINTSOU0            ((uint32_t)0xf<<(INT_EINTSS0_EINTSOU0_0_POS))
#define INT_EINTSS0_EINTSOU0_0          ((uint32_t)1<<(INT_EINTSS0_EINTSOU0_0_POS))
#define INT_EINTSS0_EINTSOU0_1          ((uint32_t)1<<(INT_EINTSS0_EINTSOU0_1_POS))
#define INT_EINTSS0_EINTSOU0_2          ((uint32_t)1<<(INT_EINTSS0_EINTSOU0_2_POS))
#define INT_EINTSS0_EINTSOU0_3          ((uint32_t)1<<(INT_EINTSS0_EINTSOU0_3_POS))
#define INT_EINTSS0_EINTSOU1            ((uint32_t)0xf<<(INT_EINTSS0_EINTSOU1_0_POS))
#define INT_EINTSS0_EINTSOU1_0          ((uint32_t)1<<(INT_EINTSS0_EINTSOU1_0_POS))
#define INT_EINTSS0_EINTSOU1_1          ((uint32_t)1<<(INT_EINTSS0_EINTSOU1_1_POS))
#define INT_EINTSS0_EINTSOU1_2          ((uint32_t)1<<(INT_EINTSS0_EINTSOU1_2_POS))
#define INT_EINTSS0_EINTSOU1_3          ((uint32_t)1<<(INT_EINTSS0_EINTSOU1_3_POS))
#define INT_EINTSS0_EINTSOU2            ((uint32_t)0xf<<(INT_EINTSS0_EINTSOU2_0_POS))
#define INT_EINTSS0_EINTSOU2_0          ((uint32_t)1<<(INT_EINTSS0_EINTSOU2_0_POS))
#define INT_EINTSS0_EINTSOU2_1          ((uint32_t)1<<(INT_EINTSS0_EINTSOU2_1_POS))
#define INT_EINTSS0_EINTSOU2_2          ((uint32_t)1<<(INT_EINTSS0_EINTSOU2_2_POS))
#define INT_EINTSS0_EINTSOU2_3          ((uint32_t)1<<(INT_EINTSS0_EINTSOU2_3_POS))
#define INT_EINTSS0_EINTSOU3            ((uint32_t)0xf<<(INT_EINTSS0_EINTSOU3_0_POS))
#define INT_EINTSS0_EINTSOU3_0          ((uint32_t)1<<(INT_EINTSS0_EINTSOU3_0_POS))
#define INT_EINTSS0_EINTSOU3_1          ((uint32_t)1<<(INT_EINTSS0_EINTSOU3_1_POS))
#define INT_EINTSS0_EINTSOU3_2          ((uint32_t)1<<(INT_EINTSS0_EINTSOU3_2_POS))
#define INT_EINTSS0_EINTSOU3_3          ((uint32_t)1<<(INT_EINTSS0_EINTSOU3_3_POS))
#define INT_EINTSS0_EINTSOU4            ((uint32_t)0xf<<(INT_EINTSS0_EINTSOU4_0_POS))
#define INT_EINTSS0_EINTSOU4_0          ((uint32_t)1<<(INT_EINTSS0_EINTSOU4_0_POS))
#define INT_EINTSS0_EINTSOU4_1          ((uint32_t)1<<(INT_EINTSS0_EINTSOU4_1_POS))
#define INT_EINTSS0_EINTSOU4_2          ((uint32_t)1<<(INT_EINTSS0_EINTSOU4_2_POS))
#define INT_EINTSS0_EINTSOU4_3          ((uint32_t)1<<(INT_EINTSS0_EINTSOU4_3_POS))
#define INT_EINTSS0_EINTSOU5            ((uint32_t)0xf<<(INT_EINTSS0_EINTSOU5_0_POS))
#define INT_EINTSS0_EINTSOU5_0          ((uint32_t)1<<(INT_EINTSS0_EINTSOU5_0_POS))
#define INT_EINTSS0_EINTSOU5_1          ((uint32_t)1<<(INT_EINTSS0_EINTSOU5_1_POS))
#define INT_EINTSS0_EINTSOU5_2          ((uint32_t)1<<(INT_EINTSS0_EINTSOU5_2_POS))
#define INT_EINTSS0_EINTSOU5_3          ((uint32_t)1<<(INT_EINTSS0_EINTSOU5_3_POS))
#define INT_EINTSS0_EINTSOU6            ((uint32_t)0xf<<(INT_EINTSS0_EINTSOU6_0_POS))
#define INT_EINTSS0_EINTSOU6_0          ((uint32_t)1<<(INT_EINTSS0_EINTSOU6_0_POS))
#define INT_EINTSS0_EINTSOU6_1          ((uint32_t)1<<(INT_EINTSS0_EINTSOU6_1_POS))
#define INT_EINTSS0_EINTSOU6_2          ((uint32_t)1<<(INT_EINTSS0_EINTSOU6_2_POS))
#define INT_EINTSS0_EINTSOU6_3          ((uint32_t)1<<(INT_EINTSS0_EINTSOU6_3_POS))
#define INT_EINTSS0_EINTSOU7            ((uint32_t)0xf<<(INT_EINTSS0_EINTSOU7_0_POS))
#define INT_EINTSS0_EINTSOU7_0          ((uint32_t)1<<(INT_EINTSS0_EINTSOU7_0_POS))
#define INT_EINTSS0_EINTSOU7_1          ((uint32_t)1<<(INT_EINTSS0_EINTSOU7_1_POS))
#define INT_EINTSS0_EINTSOU7_2          ((uint32_t)1<<(INT_EINTSS0_EINTSOU7_2_POS))
#define INT_EINTSS0_EINTSOU7_3          ((uint32_t)1<<(INT_EINTSS0_EINTSOU7_3_POS))

/* INT_EINTSS1 λ */
#define INT_EINTSS1_EINTSOU8_0_POS      (0)
#define INT_EINTSS1_EINTSOU8_1_POS      (1)
#define INT_EINTSS1_EINTSOU8_2_POS      (2)
#define INT_EINTSS1_EINTSOU8_3_POS      (3)
#define INT_EINTSS1_EINTSOU9_0_POS      (4)
#define INT_EINTSS1_EINTSOU9_1_POS      (5)
#define INT_EINTSS1_EINTSOU9_2_POS      (6)
#define INT_EINTSS1_EINTSOU9_3_POS      (7)
#define INT_EINTSS1_EINTSOU10_0_POS     (8)
#define INT_EINTSS1_EINTSOU10_1_POS     (9)
#define INT_EINTSS1_EINTSOU10_2_POS     (10)
#define INT_EINTSS1_EINTSOU10_3_POS     (11)
#define INT_EINTSS1_EINTSOU11_0_POS     (12)
#define INT_EINTSS1_EINTSOU11_1_POS     (13)
#define INT_EINTSS1_EINTSOU11_2_POS     (14)
#define INT_EINTSS1_EINTSOU11_3_POS     (15)
#define INT_EINTSS1_EINTSOU12_0_POS     (16)
#define INT_EINTSS1_EINTSOU12_1_POS     (17)
#define INT_EINTSS1_EINTSOU12_2_POS     (18)
#define INT_EINTSS1_EINTSOU12_3_POS     (19)
#define INT_EINTSS1_EINTSOU13_0_POS     (20)
#define INT_EINTSS1_EINTSOU13_1_POS     (21)
#define INT_EINTSS1_EINTSOU13_2_POS     (22)
#define INT_EINTSS1_EINTSOU13_3_POS     (23)
#define INT_EINTSS1_EINTSOU14_0_POS     (24)
#define INT_EINTSS1_EINTSOU14_1_POS     (25)
#define INT_EINTSS1_EINTSOU14_2_POS     (26)
#define INT_EINTSS1_EINTSOU14_3_POS     (27)
#define INT_EINTSS1_EINTSOU15_0_POS     (28)
#define INT_EINTSS1_EINTSOU15_1_POS     (29)
#define INT_EINTSS1_EINTSOU15_2_POS     (30)
#define INT_EINTSS1_EINTSOU15_3_POS     (31)
#define INT_EINTSS1_EINTSOU0            ((uint32_t)0xf<<(INT_EINTSS1_EINTSOU8_0_POS))
#define INT_EINTSS1_EINTSOU0_0          ((uint32_t)1<<(INT_EINTSS1_EINTSOU8_0_POS))
#define INT_EINTSS1_EINTSOU0_1          ((uint32_t)1<<(INT_EINTSS1_EINTSOU8_1_POS))
#define INT_EINTSS1_EINTSOU0_2          ((uint32_t)1<<(INT_EINTSS1_EINTSOU8_2_POS))
#define INT_EINTSS1_EINTSOU0_3          ((uint32_t)1<<(INT_EINTSS1_EINTSOU8_3_POS))
#define INT_EINTSS1_EINTSOU1            ((uint32_t)0xf<<(INT_EINTSS1_EINTSOU9_0_POS))
#define INT_EINTSS1_EINTSOU1_0          ((uint32_t)1<<(INT_EINTSS1_EINTSOU9_0_POS))
#define INT_EINTSS1_EINTSOU1_1          ((uint32_t)1<<(INT_EINTSS1_EINTSOU9_1_POS))
#define INT_EINTSS1_EINTSOU1_2          ((uint32_t)1<<(INT_EINTSS1_EINTSOU9_2_POS))
#define INT_EINTSS1_EINTSOU1_3          ((uint32_t)1<<(INT_EINTSS1_EINTSOU9_3_POS))
#define INT_EINTSS1_EINTSOU2            ((uint32_t)0xf<<(INT_EINTSS1_EINTSOU10_0_POS))
#define INT_EINTSS1_EINTSOU2_0          ((uint32_t)1<<(INT_EINTSS1_EINTSOU10_0_POS))
#define INT_EINTSS1_EINTSOU2_1          ((uint32_t)1<<(INT_EINTSS1_EINTSOU10_1_POS))
#define INT_EINTSS1_EINTSOU2_2          ((uint32_t)1<<(INT_EINTSS1_EINTSOU10_2_POS))
#define INT_EINTSS1_EINTSOU2_3          ((uint32_t)1<<(INT_EINTSS1_EINTSOU10_3_POS))
#define INT_EINTSS1_EINTSOU3            ((uint32_t)0xf<<(INT_EINTSS1_EINTSOU11_0_POS))
#define INT_EINTSS1_EINTSOU3_0          ((uint32_t)1<<(INT_EINTSS1_EINTSOU11_0_POS))
#define INT_EINTSS1_EINTSOU3_1          ((uint32_t)1<<(INT_EINTSS1_EINTSOU11_1_POS))
#define INT_EINTSS1_EINTSOU3_2          ((uint32_t)1<<(INT_EINTSS1_EINTSOU11_2_POS))
#define INT_EINTSS1_EINTSOU3_3          ((uint32_t)1<<(INT_EINTSS1_EINTSOU11_3_POS))
#define INT_EINTSS1_EINTSOU4            ((uint32_t)0xf<<(INT_EINTSS1_EINTSOU12_0_POS))
#define INT_EINTSS1_EINTSOU4_0          ((uint32_t)1<<(INT_EINTSS1_EINTSOU12_0_POS))
#define INT_EINTSS1_EINTSOU4_1          ((uint32_t)1<<(INT_EINTSS1_EINTSOU12_1_POS))
#define INT_EINTSS1_EINTSOU4_2          ((uint32_t)1<<(INT_EINTSS1_EINTSOU12_2_POS))
#define INT_EINTSS1_EINTSOU4_3          ((uint32_t)1<<(INT_EINTSS1_EINTSOU12_3_POS))
#define INT_EINTSS1_EINTSOU5            ((uint32_t)0xf<<(INT_EINTSS1_EINTSOU13_0_POS))
#define INT_EINTSS1_EINTSOU5_0          ((uint32_t)1<<(INT_EINTSS1_EINTSOU13_0_POS))
#define INT_EINTSS1_EINTSOU5_1          ((uint32_t)1<<(INT_EINTSS1_EINTSOU13_1_POS))
#define INT_EINTSS1_EINTSOU5_2          ((uint32_t)1<<(INT_EINTSS1_EINTSOU13_2_POS))
#define INT_EINTSS1_EINTSOU5_3          ((uint32_t)1<<(INT_EINTSS1_EINTSOU13_3_POS))
#define INT_EINTSS1_EINTSOU6            ((uint32_t)0xf<<(INT_EINTSS1_EINTSOU14_0_POS))
#define INT_EINTSS1_EINTSOU6_0          ((uint32_t)1<<(INT_EINTSS1_EINTSOU14_0_POS))
#define INT_EINTSS1_EINTSOU6_1          ((uint32_t)1<<(INT_EINTSS1_EINTSOU14_1_POS))
#define INT_EINTSS1_EINTSOU6_2          ((uint32_t)1<<(INT_EINTSS1_EINTSOU14_2_POS))
#define INT_EINTSS1_EINTSOU6_3          ((uint32_t)1<<(INT_EINTSS1_EINTSOU14_3_POS))
#define INT_EINTSS1_EINTSOU7            ((uint32_t)0xf<<(INT_EINTSS1_EINTSOU15_0_POS))
#define INT_EINTSS1_EINTSOU7_0          ((uint32_t)1<<(INT_EINTSS1_EINTSOU15_0_POS))
#define INT_EINTSS1_EINTSOU7_1          ((uint32_t)1<<(INT_EINTSS1_EINTSOU15_1_POS))
#define INT_EINTSS1_EINTSOU7_2          ((uint32_t)1<<(INT_EINTSS1_EINTSOU15_2_POS))
#define INT_EINTSS1_EINTSOU7_3          ((uint32_t)1<<(INT_EINTSS1_EINTSOU15_3_POS))

/* INT_CTL1 λ */
#define INT_CTL1_INTDELY0_POS			(0)
#define INT_CTL1_INTDELY1_POS			(1)
#define INT_CTL1_INTDELY2_POS			(2)
#define INT_CTL1_INTDELY3_POS			(3)
#define INT_CTL1_INTDELY4_POS			(4)
#define INT_CTL1_INTDELY5_POS			(5)
#define INT_CTL1_INTDELY6_POS			(6)
#define INT_CTL1_INTDELY7_POS			(7)
#define INT_CTL1_INTDELY				((uint32_t)0xFF<<(INT_CTL1_INTDELY0_POS))
#define INT_CTL1_INTDELY0				((uint32_t)1<<(INT_CTL1_INTDELY0_POS))
#define INT_CTL1_INTDELY1				((uint32_t)1<<(INT_CTL1_INTDELY1_POS))
#define INT_CTL1_INTDELY2				((uint32_t)1<<(INT_CTL1_INTDELY2_POS))
#define INT_CTL1_INTDELY3				((uint32_t)1<<(INT_CTL1_INTDELY3_POS))
#define INT_CTL1_INTDELY4				((uint32_t)1<<(INT_CTL1_INTDELY4_POS))
#define INT_CTL1_INTDELY5				((uint32_t)1<<(INT_CTL1_INTDELY5_POS))
#define INT_CTL1_INTDELY6				((uint32_t)1<<(INT_CTL1_INTDELY6_POS))
#define INT_CTL1_INTDELY7				((uint32_t)1<<(INT_CTL1_INTDELY7_POS))
/* ж϶ */

#endif

#if 1										/* SYSCTL */

/* ----------------------------------------------------------------------------
   -- ϵͳ(SYSCTL)
   ---------------------------------------------------------------------------- */
/* SYSCTL - ڴṹ */
typedef struct SYSCTL_MemMap {
    volatile	uint32_t PSW;        /* ״̬Ĵ, ƫ:0x00 */
    volatile    uint32_t MCTL;       /* ϵͳģʽƼĴ, ƫ:0x04 */
    volatile    uint32_t ARCTL;      /* Ӧøλ, ƫ:0x08 */
    volatile    uint32_t VECTOFF;    /* жӳƼĴ, ƫ:0x0C */
    			uint32_t RESEVRVE1;	/* , ƫ:0x10 */
    volatile    uint32_t RAMSPA;     /* RAMռָʾĴ, ƫ:0x14 */
    volatile    uint32_t MEMCTL;     /* ռƼĴ, ƫ:0x18 */
    volatile	uint32_t MSPSPA;     /* ռƼĴ, ƫ:0x1C */
    volatile	uint32_t PSPSPA;     /* ռƼĴ, ƫ:0x20 */
}SYSCTL_SFRmap;

/* ----------------------------------------------------------------------------
   -- SYSCTL - Ĵں
   ---------------------------------------------------------------------------- */

/* SYSCTL - Ĵڵַ */
#define SYSCTL_ADDR						((uint32_t) 0x402000B0)
#define SYSCTL_SFR						((SYSCTL_SFRmap *)SYSCTL_ADDR)

/* SYSCTL - Ĵ */
#define SYS_PSW                         (SYSCTL_SFR->PSW)
#define SYS_MCTL                        (SYSCTL_SFR->MCTL)
#define SYS_ARCTL                       (SYSCTL_SFR->ARCTL)
#define SYS_VECTOFF                     (SYSCTL_SFR->VECTOFF)
#define SYS_RAMSPA                      (SYSCTL_SFR->RAMSPA)
#define SYS_MEMCTL                      (SYSCTL_SFR->MEMCTL)
#define SYS_MSPSPA						(SYSCTL_SFR->MSPSPA)
#define SYS_PSPSPA						(SYSCTL_SFR->PSPSPA)

/* SYS_PSW λ */
#define SYS_PSW_V_POS                   (28)
#define SYS_PSW_C_POS                   (29)
#define SYS_PSW_Z_POS                   (30)
#define SYS_PSW_N_POS                   (31)
#define SYS_PSW_V                       ((uint32_t)1<<(SYS_PSW_V_POS))
#define SYS_PSW_C                       ((uint32_t)1<<(SYS_PSW_C_POS))
#define SYS_PSW_Z                       ((uint32_t)1<<(SYS_PSW_Z_POS))
#define SYS_PSW_N                       ((uint32_t)1<<(SYS_PSW_N_POS))

/* SYS_MCTL λ */
#define SYS_MCTL_SLEEPONEXIT_POS        (1)
#define SYS_MCTL_SLEEPDEEP_POS          (2)
#define SYS_MCTL_SLPONMOD_POS           (4)
#define SYS_MCTL_STACKALIGN_POS         (9)
#define SYS_MCTL_SUSTA_POS              (15)
#define SYS_MCTL_SPSEL_POS              (16)
#define SYS_MCTL_SLEEPONEXIT            ((uint32_t)1<<(SYS_MCTL_SLEEPONEXIT_POS))
#define SYS_MCTL_SLEEPDEEP              ((uint32_t)1<<(SYS_MCTL_SLEEPDEEP_POS))
#define SYS_MCTL_SLPONMOD               ((uint32_t)1<<(SYS_MCTL_SLPONMOD_POS))
#define SYS_MCTL_STACKALIGN             ((uint32_t)1<<(SYS_MCTL_STACKALIGN_POS))
#define SYS_MCTL_SUSTA                  ((uint32_t)1<<(SYS_MCTL_SUSTA_POS))
#define SYS_MCTL_SPSEL                  ((uint32_t)1<<(SYS_MCTL_SPSEL_POS))

/* SYS_ARCTL λ */
#define SYS_ARCTL_VECTRST_POS           (1)
#define SYS_ARCTL_SYSTEMRST_POS         (2)
#define SYS_ARCTL_CDMAR_POS             (4)
#define SYS_ARCTL_CDMAAM_POS            (5)
#define SYS_ARCTL_CRWDC_POS             (6)
#define SYS_ARCTL_CDMADC_POS            (7)
#define SYS_ARCTL_CDBUGBS_POS           (8)
#define SYS_ARCTL_CDMALDC0_POS          (9)
#define SYS_ARCTL_ARKEY0_POS            (16)
#define SYS_ARCTL_ARKEY1_POS            (17)
#define SYS_ARCTL_ARKEY2_POS            (18)
#define SYS_ARCTL_ARKEY3_POS            (19)
#define SYS_ARCTL_ARKEY4_POS            (20)
#define SYS_ARCTL_ARKEY5_POS            (21)
#define SYS_ARCTL_ARKEY6_POS            (22)
#define SYS_ARCTL_ARKEY7_POS            (23)
#define SYS_ARCTL_ARKEY8_POS            (24)
#define SYS_ARCTL_ARKEY9_POS            (25)
#define SYS_ARCTL_ARKEY10_POS           (26)
#define SYS_ARCTL_ARKEY11_POS           (27)
#define SYS_ARCTL_ARKEY12_POS           (28)
#define SYS_ARCTL_ARKEY13_POS           (29)
#define SYS_ARCTL_ARKEY14_POS           (30)
#define SYS_ARCTL_ARKEY15_POS           (31)
#define SYS_ARCTL_VECTRST               ((uint32_t)1<<(SYS_ARCTL_VECTRST_POS))
#define SYS_ARCTL_SYSTEMRST             ((uint32_t)1<<(SYS_ARCTL_SYSTEMRST_POS))
#define SYS_ARCTL_IDC                   ((uint32_t)1<<(SYS_ARCTL_IDC_POS))
#define SYS_ARCTL_CDMAR                 ((uint32_t)1<<(SYS_ARCTL_CDMAR_POS))
#define SYS_ARCTL_CDMAAM                ((uint32_t)1<<(SYS_ARCTL_CDMAAM_POS))
#define SYS_ARCTL_CRWDC                 ((uint32_t)1<<(SYS_ARCTL_CRWDC_POS))
#define SYS_ARCTL_CDMADC                ((uint32_t)1<<(SYS_ARCTL_CDMADC_POS))
#define SYS_ARCTL_CDMALDC				((uint32_t)0x03<<(SYS_ARCTL_CDMALDC0_POS))
#define SYS_ARCTL_ARKEY                 ((uint32_t)0xFFFF<<(SYS_ARCTL_ARKEY0_POS))
#define SYS_ARCTL_ARKEY0                ((uint32_t)1<<(SYS_ARCTL_ARKEY0_POS))
#define SYS_ARCTL_ARKEY1                ((uint32_t)1<<(SYS_ARCTL_ARKEY1_POS))
#define SYS_ARCTL_ARKEY2                ((uint32_t)1<<(SYS_ARCTL_ARKEY2_POS))
#define SYS_ARCTL_ARKEY3                ((uint32_t)1<<(SYS_ARCTL_ARKEY3_POS))
#define SYS_ARCTL_ARKEY4                ((uint32_t)1<<(SYS_ARCTL_ARKEY4_POS))
#define SYS_ARCTL_ARKEY5                ((uint32_t)1<<(SYS_ARCTL_ARKEY5_POS))
#define SYS_ARCTL_ARKEY6                ((uint32_t)1<<(SYS_ARCTL_ARKEY6_POS))
#define SYS_ARCTL_ARKEY7                ((uint32_t)1<<(SYS_ARCTL_ARKEY7_POS))
#define SYS_ARCTL_ARKEY8                ((uint32_t)1<<(SYS_ARCTL_ARKEY8_POS))
#define SYS_ARCTL_ARKEY9                ((uint32_t)1<<(SYS_ARCTL_ARKEY9_POS))
#define SYS_ARCTL_ARKEY10               ((uint32_t)1<<(SYS_ARCTL_ARKEY10_POS))
#define SYS_ARCTL_ARKEY11               ((uint32_t)1<<(SYS_ARCTL_ARKEY11_POS))
#define SYS_ARCTL_ARKEY12               ((uint32_t)1<<(SYS_ARCTL_ARKEY12_POS))
#define SYS_ARCTL_ARKEY13               ((uint32_t)1<<(SYS_ARCTL_ARKEY13_POS))
#define SYS_ARCTL_ARKEY14               ((uint32_t)1<<(SYS_ARCTL_ARKEY14_POS))
#define SYS_ARCTL_ARKEY15               ((uint32_t)1<<(SYS_ARCTL_ARKEY15_POS))

/* SYS_VECTOFF λ */
#define SYS_VECTOFF_TBLOFF0_POS         (0)
#define SYS_VECTOFF_TBLOFF              ((uint32_t)0xFFFFFFFF<<(SYS_VECTOFF_TBLOFF0_POS))

/* SYS_RAMSPA λ */
#define SYS_RAMSPA_RAMSPA0_POS          (0)
#define SYS_RAMSPA_RAMSPA               ((uint32_t)0x3FFFFFF<<(SYS_RAMSPA_RAMSPA0_POS))

/* SYS_MEMCTL λ */
#define SYS_MEMCTL_MEMM0_POS            (0)
#define SYS_MEMCTL_MEMM1_POS            (1)
#define SYS_MEMCTL_MEMM                 ((uint32_t)3<<(SYS_MEMCTL_MEMM0_POS))

/* SYS_MSPSPA λ */
#define SYS_MSPSPA_MSPSPAL0_POS			(0)
#define SYS_MSPSPA_MSPSPAH0_POS			(16)
#define SYS_MSPSPA_MSPSPAL				((uint32_t)0xFFFF<<(SYS_MSPSPA_MSPSPAL0_POS))
#define SYS_MSPSPA_MSPSPAH				((uint32_t)0xFFFF<<(SYS_MSPSPA_MSPSPAH0_POS))


/* SYS_PSPSPA λ */
#define SYS_PSPSPA_PSPSPAL0_POS			(0)
#define SYS_PSPSPA_PSPSPAH0_POS			(16)
#define SYS_PSPSPA_PSPSPAL				((uint32_t)0xFFFF<<(SYS_PSPSPA_PSPSPAL0_POS))
#define SYS_PSPSPA_PSPSPAH				((uint32_t)0xFFFF<<(SYS_PSPSPA_PSPSPAH0_POS))

/* ϵͳ(SYSCTL) */

#endif

#if 1										/* DMA */

/* ----------------------------------------------------------------------------
   -- ֱڴȡģ(DMA)
   ---------------------------------------------------------------------------- */

/* DMA - Ĵڴṹ */
typedef struct DMA_MenMap
{
	union
	{
		struct
		{
            volatile uint32_t CTLR1;            /* DMAͨ1ƼĴ, ƫ:0x00 */
            volatile uint32_t CTLR2;            /* DMAͨ2ƼĴ, ƫ:0x04 */
            volatile uint32_t CTLR3;            /* DMAͨ3ƼĴ, ƫ:0x08 */
            volatile uint32_t CTLR4;            /* DMAͨ4ƼĴ, ƫ:0x0C */
            volatile uint32_t CTLR5;            /* DMAͨ5ƼĴ, ƫ:0x10 */
            volatile uint32_t CTLR6;            /* DMAͨ6ƼĴ, ƫ:0x14 */
            volatile uint32_t CTLR7;            /* DMAͨ7ƼĴ, ƫ:0x18 */
		};
		volatile uint32_t CTLR[7];              /* DMAͨ1~7ƼĴ, ƫ:0x00 */
	};
	uint32_t RESERVED1;          		        /* ַ, ƫ:0x1C */

    union
    {
        struct
        {
            volatile uint32_t PADDR1;           /* DMAͨ1ַĴ, ƫ:0x20 */
            volatile uint32_t PADDR2;           /* DMAͨ2ַĴ, ƫ:0x24 */
            volatile uint32_t PADDR3;           /* DMAͨ3ַĴ, ƫ:0x28 */
            volatile uint32_t PADDR4;           /* DMAͨ4ַĴ, ƫ:0x2C */
            volatile uint32_t PADDR5;           /* DMAͨ5ַĴ, ƫ:0x30 */
            volatile uint32_t PADDR6;           /* DMAͨ6ַĴ, ƫ:0x34 */
            volatile uint32_t PADDR7;           /* DMAͨ7ַĴ, ƫ:0x38 */
        };
        volatile uint32_t PADDR[7];             /* DMAͨ1~7ַĴ, ƫ:0x20 */
    };
    uint32_t RESERVED2;          		        /* ַ, ƫ:0x3C */

    union
    {
        struct
        {
            volatile uint32_t MADDR1;           /* DMAͨ1洢ַĴ, ƫ:0x40 */
            volatile uint32_t MADDR2;           /* DMAͨ2洢ַĴ, ƫ:0x44 */
            volatile uint32_t MADDR3;           /* DMAͨ3洢ַĴ, ƫ:0x48 */
            volatile uint32_t MADDR4;           /* DMAͨ4洢ַĴ, ƫ:0x4C */
            volatile uint32_t MADDR5;           /* DMAͨ5洢ַĴ, ƫ:0x50 */
            volatile uint32_t MADDR6;           /* DMAͨ6洢ַĴ, ƫ:0x54 */
            volatile uint32_t MADDR7;           /* DMAͨ7洢ַĴ, ƫ:0x58 */
        };
        volatile uint32_t MADDR[7];             /* DMAͨ1~7洢ַĴ, ƫ:0x40 */
    };
    uint32_t RESERVED3;          		        /* ַ, ƫ:0x5C */

    union
    {
        struct
        {
            volatile const uint32_t CPAR1;      /* DMAͨ1ǰַĴ, ƫ:0x60 */
            volatile const uint32_t CPAR2;      /* DMAͨ2ǰַĴ, ƫ:0x64 */
            volatile const uint32_t CPAR3;      /* DMAͨ3ǰַĴ, ƫ:0x68 */
            volatile const uint32_t CPAR4;      /* DMAͨ4ǰַĴ, ƫ:0x6C */
            volatile const uint32_t CPAR5;      /* DMAͨ5ǰַĴ, ƫ:0x70 */
            volatile const uint32_t CPAR6;      /* DMAͨ6ǰַĴ, ƫ:0x74 */
            volatile const uint32_t CPAR7;      /* DMAͨ7ǰַĴ, ƫ:0x78 */
        };
        volatile const uint32_t CPAR[7];        /* DMAͨ1~7ǰַĴ, ƫ:0x60 */
    };
    uint32_t RESERVED4;          				/* ַ, ƫ:0x7C */

    union
    {
        struct
        {
            volatile const uint32_t CMAR1;      /* DMAͨ1ǰ洢ַĴ, ƫ:0x80 */
            volatile const uint32_t CMAR2;      /* DMAͨ2ǰ洢ַĴ, ƫ:0x84 */
            volatile const uint32_t CMAR3;      /* DMAͨ3ǰ洢ַĴ, ƫ:0x88 */
            volatile const uint32_t CMAR4;      /* DMAͨ4ǰ洢ַĴ, ƫ:0x8C */
            volatile const uint32_t CMAR5;      /* DMAͨ5ǰ洢ַĴ, ƫ:0x90 */
            volatile const uint32_t CMAR6;      /* DMAͨ6ǰ洢ַĴ, ƫ:0x94 */
            volatile const uint32_t CMAR7;      /* DMAͨ7ǰ洢ַĴ, ƫ:0x98 */
        };
        volatile const uint32_t CMAR[7];        /* DMAͨ1~7ǰ洢ַĴ, ƫ:0x80 */
    };
    uint32_t RESERVED5;          				/* ַ, ƫ:0x9C */

    union
    {
        struct
        {
            volatile const uint32_t NCT1;       /* DMAͨ1ǰʣݼĴ, ƫ:0xA0 */
            volatile const uint32_t NCT2;       /* DMAͨ2ǰʣݼĴ, ƫ:0xA4 */
            volatile const uint32_t NCT3;       /* DMAͨ3ǰʣݼĴ, ƫ:0xA8 */
            volatile const uint32_t NCT4;       /* DMAͨ4ǰʣݼĴ, ƫ:0xAC */
            volatile const uint32_t NCT5;       /* DMAͨ5ǰʣݼĴ, ƫ:0xB0 */
            volatile const uint32_t NCT6;       /* DMAͨ6ǰʣݼĴ, ƫ:0xB4 */
            volatile const uint32_t NCT7;       /* DMAͨ7ǰʣݼĴ, ƫ:0xB8 */
        };
        volatile const uint32_t NCT[7];         /* DMAͨ1~7ǰʣݼĴ, ƫ:0xA0 */
    };
    uint32_t RESERVED6;          				/* ַ, ƫ:0xBC */

    volatile uint32_t LIFR;               		/* DMAжϱ־Ĵ, ƫ:0xC0 */
    volatile uint32_t LIER;               		/* DMAжʹܼĴ, ƫ:0xC4 */
}DMA_SFRmap;

/* ----------------------------------------------------------------------------
   -- DMA - Ĵں
   ---------------------------------------------------------------------------- */

/* DMA - Ĵڵַ */
#define DMA0_ADDR                       ((uint32_t)0x40001600)
#define DMA1_ADDR                       ((uint32_t)0x40001700)
#define DMA0_SFR                        ((DMA_SFRmap *) DMA0_ADDR)
#define DMA1_SFR                        ((DMA_SFRmap *) DMA1_ADDR)

/* DMA - Ĵ */
#define DMA0_CTLR1                      (DMA0_SFR->CTLR1)
#define DMA0_CTLR2                      (DMA0_SFR->CTLR2)
#define DMA0_CTLR3                      (DMA0_SFR->CTLR3)
#define DMA0_CTLR4                      (DMA0_SFR->CTLR4)
#define DMA0_CTLR5                      (DMA0_SFR->CTLR5)
#define DMA0_CTLR6                      (DMA0_SFR->CTLR6)
#define DMA0_CTLR7                      (DMA0_SFR->CTLR7)
#define DMA0_PADDR1                     (DMA0_SFR->PADDR1)
#define DMA0_PADDR2                     (DMA0_SFR->PADDR2)
#define DMA0_PADDR3                     (DMA0_SFR->PADDR3)
#define DMA0_PADDR4                     (DMA0_SFR->PADDR4)
#define DMA0_PADDR5                     (DMA0_SFR->PADDR5)
#define DMA0_PADDR6                     (DMA0_SFR->PADDR6)
#define DMA0_PADDR7                     (DMA0_SFR->PADDR7)
#define DMA0_MADDR1                     (DMA0_SFR->MADDR1)
#define DMA0_MADDR2                     (DMA0_SFR->MADDR2)
#define DMA0_MADDR3                     (DMA0_SFR->MADDR3)
#define DMA0_MADDR4                     (DMA0_SFR->MADDR4)
#define DMA0_MADDR5                     (DMA0_SFR->MADDR5)
#define DMA0_MADDR6                     (DMA0_SFR->MADDR6)
#define DMA0_MADDR7                     (DMA0_SFR->MADDR7)
#define DMA0_CPAR1                      (DMA0_SFR->CPAR1)
#define DMA0_CPAR2                      (DMA0_SFR->CPAR2)
#define DMA0_CPAR3                      (DMA0_SFR->CPAR3)
#define DMA0_CPAR4                      (DMA0_SFR->CPAR4)
#define DMA0_CPAR5                      (DMA0_SFR->CPAR5)
#define DMA0_CPAR6                      (DMA0_SFR->CPAR6)
#define DMA0_CPAR7                      (DMA0_SFR->CPAR7)
#define DMA0_CMAR1                      (DMA0_SFR->CMAR1)
#define DMA0_CMAR2                      (DMA0_SFR->CMAR2)
#define DMA0_CMAR3                      (DMA0_SFR->CMAR3)
#define DMA0_CMAR4                      (DMA0_SFR->CMAR4)
#define DMA0_CMAR5                      (DMA0_SFR->CMAR5)
#define DMA0_CMAR6                      (DMA0_SFR->CMAR6)
#define DMA0_CMAR7                      (DMA0_SFR->CMAR7)
#define DMA0_NCT1                       (DMA0_SFR->NCT1)
#define DMA0_NCT2                       (DMA0_SFR->NCT2)
#define DMA0_NCT3                       (DMA0_SFR->NCT3)
#define DMA0_NCT4                       (DMA0_SFR->NCT4)
#define DMA0_NCT5                       (DMA0_SFR->NCT5)
#define DMA0_NCT6                       (DMA0_SFR->NCT6)
#define DMA0_NCT7                       (DMA0_SFR->NCT7)
#define DMA0_LIFR                       (DMA0_SFR->LIFR)
#define DMA0_LIER                       (DMA0_SFR->LIER)

#define DMA1_CTLR1                      (DMA1_SFR->CTLR1)
#define DMA1_CTLR2                      (DMA1_SFR->CTLR2)
#define DMA1_CTLR3                      (DMA1_SFR->CTLR3)
#define DMA1_CTLR4                      (DMA1_SFR->CTLR4)
#define DMA1_CTLR5                      (DMA1_SFR->CTLR5)
#define DMA1_CTLR6                      (DMA1_SFR->CTLR6)
#define DMA1_CTLR7                      (DMA1_SFR->CTLR7)
#define DMA1_PADDR1                     (DMA1_SFR->PADDR1)
#define DMA1_PADDR2                     (DMA1_SFR->PADDR2)
#define DMA1_PADDR3                     (DMA1_SFR->PADDR3)
#define DMA1_PADDR4                     (DMA1_SFR->PADDR4)
#define DMA1_PADDR5                     (DMA1_SFR->PADDR5)
#define DMA1_PADDR6                     (DMA1_SFR->PADDR6)
#define DMA1_PADDR7                     (DMA1_SFR->PADDR7)
#define DMA1_MADDR1                     (DMA1_SFR->MADDR1)
#define DMA1_MADDR2                     (DMA1_SFR->MADDR2)
#define DMA1_MADDR3                     (DMA1_SFR->MADDR3)
#define DMA1_MADDR4                     (DMA1_SFR->MADDR4)
#define DMA1_MADDR5                     (DMA1_SFR->MADDR5)
#define DMA1_MADDR6                     (DMA1_SFR->MADDR6)
#define DMA1_MADDR7                     (DMA1_SFR->MADDR7)
#define DMA1_CPAR1                      (DMA1_SFR->CPAR1)
#define DMA1_CPAR2                      (DMA1_SFR->CPAR2)
#define DMA1_CPAR3                      (DMA1_SFR->CPAR3)
#define DMA1_CPAR4                      (DMA1_SFR->CPAR4)
#define DMA1_CPAR5                      (DMA1_SFR->CPAR5)
#define DMA1_CPAR6                      (DMA1_SFR->CPAR6)
#define DMA1_CPAR7                      (DMA1_SFR->CPAR7)
#define DMA1_CMAR1                      (DMA1_SFR->CMAR1)
#define DMA1_CMAR2                      (DMA1_SFR->CMAR2)
#define DMA1_CMAR3                      (DMA1_SFR->CMAR3)
#define DMA1_CMAR4                      (DMA1_SFR->CMAR4)
#define DMA1_CMAR5                      (DMA1_SFR->CMAR5)
#define DMA1_CMAR6                      (DMA1_SFR->CMAR6)
#define DMA1_CMAR7                      (DMA1_SFR->CMAR7)
#define DMA1_NCT1                       (DMA1_SFR->NCT1)
#define DMA1_NCT2                       (DMA1_SFR->NCT2)
#define DMA1_NCT3                       (DMA1_SFR->NCT3)
#define DMA1_NCT4                       (DMA1_SFR->NCT4)
#define DMA1_NCT5                       (DMA1_SFR->NCT5)
#define DMA1_NCT6                       (DMA1_SFR->NCT6)
#define DMA1_NCT7                       (DMA1_SFR->NCT7)
#define DMA1_LIFR                       (DMA1_SFR->LIFR)
#define DMA1_LIER                       (DMA1_SFR->LIER)

/* DMA_CTLRy λ */
#define DMA_CTLR_DMAEN_POS              (0)
#define DMA_CTLR_BLKM_POS               (3)
#define DMA_CTLR_DDIR_POS               (4)
#define DMA_CTLR_LPM_POS                (5)
#define DMA_CTLR_MINC_POS               (6)
#define DMA_CTLR_PINC_POS               (7)
#define DMA_CTLR_MDS0_POS               (8)
#define DMA_CTLR_MDS1_POS               (9)
#define DMA_CTLR_PDS0_POS               (10)
#define DMA_CTLR_PDS1_POS               (11)
#define DMA_CTLR_ONESHOT_POS            (12)
#define DMA_CTLR_CPL0_POS               (13)
#define DMA_CTLR_CPL1_POS               (14)
#define DMA_CTLR_M2M_POS                (15)
#define DMA_CTLR_NUMODT0_POS            (16)
#define DMA_CTLR_NUMODT1_POS            (17)
#define DMA_CTLR_NUMODT2_POS            (18)
#define DMA_CTLR_NUMODT3_POS            (19)
#define DMA_CTLR_NUMODT4_POS            (20)
#define DMA_CTLR_NUMODT5_POS            (21)
#define DMA_CTLR_NUMODT6_POS            (22)
#define DMA_CTLR_NUMODT7_POS            (23)
#define DMA_CTLR_NUMODT8_POS            (24)
#define DMA_CTLR_NUMODT9_POS            (25)
#define DMA_CTLR_NUMODT10_POS           (26)
#define DMA_CTLR_NUMODT11_POS           (27)
#define DMA_CTLR_NUMODT12_POS           (28)
#define DMA_CTLR_NUMODT13_POS           (29)
#define DMA_CTLR_NUMODT14_POS           (30)
#define DMA_CTLR_NUMODT15_POS           (31)
#define DMA_CTLR_DMAEN                  ((uint32_t)1<<(DMA_CTLR_DMAEN_POS))
#define DMA_CTLR_BLKM                   ((uint32_t)1<<(DMA_CTLR_BLKM_POS))
#define DMA_CTLR_DDIR                   ((uint32_t)1<<(DMA_CTLR_DDIR_POS))
#define DMA_CTLR_LPM                    ((uint32_t)1<<(DMA_CTLR_LPM_POS))
#define DMA_CTLR_MINC                   ((uint32_t)1<<(DMA_CTLR_MINC_POS))
#define DMA_CTLR_PINC                   ((uint32_t)1<<(DMA_CTLR_PINC_POS))
#define DMA_CTLR_MDS                    ((uint32_t)3<<(DMA_CTLR_MDS0_POS))
#define DMA_CTLR_MDS0                   ((uint32_t)1<<(DMA_CTLR_MDS0_POS))
#define DMA_CTLR_MDS1                   ((uint32_t)1<<(DMA_CTLR_MDS1_POS))
#define DMA_CTLR_PDS                    ((uint32_t)3<<(DMA_CTLR_PDS0_POS))
#define DMA_CTLR_PDS0                   ((uint32_t)1<<(DMA_CTLR_PDS0_POS))
#define DMA_CTLR_PDS1                   ((uint32_t)1<<(DMA_CTLR_PDS1_POS))
#define DMA_CTLR_CPL                    ((uint32_t)3<<(DMA_CTLR_CPL0_POS))
#define DMA_CTLR_CPL0                   ((uint32_t)1<<(DMA_CTLR_CPL0_POS))
#define DMA_CTLR_CPL1                   ((uint32_t)1<<(DMA_CTLR_CPL1_POS))
#define DMA_CTLR_M2M                    ((uint32_t)1<<(DMA_CTLR_M2M_POS))
#define DMA_CTLR_NUMODT                 ((uint32_t)0xFFFF<<(DMA_CTLR_NUMODT0_POS))
#define DMA_CTLR_NUMODT0                ((uint32_t)1<<(DMA_CTLR_NUMODT0_POS))
#define DMA_CTLR_NUMODT1                ((uint32_t)1<<(DMA_CTLR_NUMODT1_POS))
#define DMA_CTLR_NUMODT2                ((uint32_t)1<<(DMA_CTLR_NUMODT2_POS))
#define DMA_CTLR_NUMODT3                ((uint32_t)1<<(DMA_CTLR_NUMODT3_POS))
#define DMA_CTLR_NUMODT4                ((uint32_t)1<<(DMA_CTLR_NUMODT4_POS))
#define DMA_CTLR_NUMODT5                ((uint32_t)1<<(DMA_CTLR_NUMODT5_POS))
#define DMA_CTLR_NUMODT6                ((uint32_t)1<<(DMA_CTLR_NUMODT6_POS))
#define DMA_CTLR_NUMODT7                ((uint32_t)1<<(DMA_CTLR_NUMODT7_POS))
#define DMA_CTLR_NUMODT8                ((uint32_t)1<<(DMA_CTLR_NUMODT8_POS))
#define DMA_CTLR_NUMODT9                ((uint32_t)1<<(DMA_CTLR_NUMODT9_POS))
#define DMA_CTLR_NUMODT10               ((uint32_t)1<<(DMA_CTLR_NUMODT10_POS))
#define DMA_CTLR_NUMODT11               ((uint32_t)1<<(DMA_CTLR_NUMODT11_POS))
#define DMA_CTLR_NUMODT12               ((uint32_t)1<<(DMA_CTLR_NUMODT12_POS))
#define DMA_CTLR_NUMODT13               ((uint32_t)1<<(DMA_CTLR_NUMODT13_POS))
#define DMA_CTLR_NUMODT14               ((uint32_t)1<<(DMA_CTLR_NUMODT14_POS))
#define DMA_CTLR_NUMODT15               ((uint32_t)1<<(DMA_CTLR_NUMODT15_POS))

/* DMA_PADDR λ */
#define DMA_PADDR_PADDR0_POS            (0)
#define DMA_PADDR_PADDR1_POS            (1)
#define DMA_PADDR_PADDR2_POS            (2)
#define DMA_PADDR_PADDR3_POS            (3)
#define DMA_PADDR_PADDR4_POS            (4)
#define DMA_PADDR_PADDR5_POS            (5)
#define DMA_PADDR_PADDR6_POS            (6)
#define DMA_PADDR_PADDR7_POS            (7)
#define DMA_PADDR_PADDR8_POS            (8)
#define DMA_PADDR_PADDR9_POS            (9)
#define DMA_PADDR_PADDR10_POS           (10)
#define DMA_PADDR_PADDR11_POS           (11)
#define DMA_PADDR_PADDR12_POS           (12)
#define DMA_PADDR_PADDR13_POS           (13)
#define DMA_PADDR_PADDR14_POS           (14)
#define DMA_PADDR_PADDR15_POS           (15)
#define DMA_PADDR_PADDR16_POS           (16)
#define DMA_PADDR_PADDR17_POS           (17)
#define DMA_PADDR_PADDR18_POS           (18)
#define DMA_PADDR_PADDR19_POS           (19)
#define DMA_PADDR_PADDR20_POS           (20)
#define DMA_PADDR_PADDR21_POS           (21)
#define DMA_PADDR_PADDR22_POS           (22)
#define DMA_PADDR_PADDR23_POS           (23)
#define DMA_PADDR_PADDR24_POS           (24)
#define DMA_PADDR_PADDR25_POS           (25)
#define DMA_PADDR_PADDR26_POS           (26)
#define DMA_PADDR_PADDR27_POS           (27)
#define DMA_PADDR_PADDR28_POS           (28)
#define DMA_PADDR_PADDR29_POS           (29)
#define DMA_PADDR_PADDR30_POS           (30)
#define DMA_PADDR_PADDR31_POS           (31)
#define DMA_PADDR_PADDR                 ((uint32_t)0xFFFFFFFF)
#define DMA_PADDR_PADDR0                ((uint32_t)1<<(DMA_PADDR_PADDR0_POS))
#define DMA_PADDR_PADDR1                ((uint32_t)1<<(DMA_PADDR_PADDR1_POS))
#define DMA_PADDR_PADDR2                ((uint32_t)1<<(DMA_PADDR_PADDR2_POS))
#define DMA_PADDR_PADDR3                ((uint32_t)1<<(DMA_PADDR_PADDR3_POS))
#define DMA_PADDR_PADDR4                ((uint32_t)1<<(DMA_PADDR_PADDR4_POS))
#define DMA_PADDR_PADDR5                ((uint32_t)1<<(DMA_PADDR_PADDR5_POS))
#define DMA_PADDR_PADDR6                ((uint32_t)1<<(DMA_PADDR_PADDR6_POS))
#define DMA_PADDR_PADDR7                ((uint32_t)1<<(DMA_PADDR_PADDR7_POS))
#define DMA_PADDR_PADDR8                ((uint32_t)1<<(DMA_PADDR_PADDR8_POS))
#define DMA_PADDR_PADDR9                ((uint32_t)1<<(DMA_PADDR_PADDR9_POS))
#define DMA_PADDR_PADDR10               ((uint32_t)1<<(DMA_PADDR_PADDR10_POS))
#define DMA_PADDR_PADDR11               ((uint32_t)1<<(DMA_PADDR_PADDR11_POS))
#define DMA_PADDR_PADDR12               ((uint32_t)1<<(DMA_PADDR_PADDR12_POS))
#define DMA_PADDR_PADDR13               ((uint32_t)1<<(DMA_PADDR_PADDR13_POS))
#define DMA_PADDR_PADDR14               ((uint32_t)1<<(DMA_PADDR_PADDR14_POS))
#define DMA_PADDR_PADDR15               ((uint32_t)1<<(DMA_PADDR_PADDR15_POS))
#define DMA_PADDR_PADDR16               ((uint32_t)1<<(DMA_PADDR_PADDR16_POS))
#define DMA_PADDR_PADDR17               ((uint32_t)1<<(DMA_PADDR_PADDR17_POS))
#define DMA_PADDR_PADDR18               ((uint32_t)1<<(DMA_PADDR_PADDR18_POS))
#define DMA_PADDR_PADDR19               ((uint32_t)1<<(DMA_PADDR_PADDR19_POS))
#define DMA_PADDR_PADDR20               ((uint32_t)1<<(DMA_PADDR_PADDR20_POS))
#define DMA_PADDR_PADDR21               ((uint32_t)1<<(DMA_PADDR_PADDR21_POS))
#define DMA_PADDR_PADDR22               ((uint32_t)1<<(DMA_PADDR_PADDR22_POS))
#define DMA_PADDR_PADDR23               ((uint32_t)1<<(DMA_PADDR_PADDR23_POS))
#define DMA_PADDR_PADDR24               ((uint32_t)1<<(DMA_PADDR_PADDR24_POS))
#define DMA_PADDR_PADDR25               ((uint32_t)1<<(DMA_PADDR_PADDR25_POS))
#define DMA_PADDR_PADDR26               ((uint32_t)1<<(DMA_PADDR_PADDR26_POS))
#define DMA_PADDR_PADDR27               ((uint32_t)1<<(DMA_PADDR_PADDR27_POS))
#define DMA_PADDR_PADDR28               ((uint32_t)1<<(DMA_PADDR_PADDR28_POS))
#define DMA_PADDR_PADDR29               ((uint32_t)1<<(DMA_PADDR_PADDR29_POS))
#define DMA_PADDR_PADDR30               ((uint32_t)1<<(DMA_PADDR_PADDR30_POS))
#define DMA_PADDR_PADDR31               ((uint32_t)1<<(DMA_PADDR_PADDR31_POS))

/* DMA_MADDRy λ */
#define DMA_MADDR_MADDR0_POS            (0)
#define DMA_MADDR_MADDR1_POS            (1)
#define DMA_MADDR_MADDR2_POS            (2)
#define DMA_MADDR_MADDR3_POS            (3)
#define DMA_MADDR_MADDR4_POS            (4)
#define DMA_MADDR_MADDR5_POS            (5)
#define DMA_MADDR_MADDR6_POS            (6)
#define DMA_MADDR_MADDR7_POS            (7)
#define DMA_MADDR_MADDR8_POS            (8)
#define DMA_MADDR_MADDR9_POS            (9)
#define DMA_MADDR_MADDR10_POS           (10)
#define DMA_MADDR_MADDR11_POS           (11)
#define DMA_MADDR_MADDR12_POS           (12)
#define DMA_MADDR_MADDR13_POS           (13)
#define DMA_MADDR_MADDR14_POS           (14)
#define DMA_MADDR_MADDR15_POS           (15)
#define DMA_MADDR_MADDR16_POS           (16)
#define DMA_MADDR_MADDR17_POS           (17)
#define DMA_MADDR_MADDR18_POS           (18)
#define DMA_MADDR_MADDR19_POS           (19)
#define DMA_MADDR_MADDR20_POS           (20)
#define DMA_MADDR_MADDR21_POS           (21)
#define DMA_MADDR_MADDR22_POS           (22)
#define DMA_MADDR_MADDR23_POS           (23)
#define DMA_MADDR_MADDR24_POS           (24)
#define DMA_MADDR_MADDR25_POS           (25)
#define DMA_MADDR_MADDR26_POS           (26)
#define DMA_MADDR_MADDR27_POS           (27)
#define DMA_MADDR_MADDR28_POS           (28)
#define DMA_MADDR_MADDR29_POS           (29)
#define DMA_MADDR_MADDR30_POS           (30)
#define DMA_MADDR_MADDR31_POS           (31)
#define DMA_MADDR_MADDR                 ((uint32_t)0xFFFFFFFF)
#define DMA_MADDR_MADDR0                ((uint32_t)1<<(DMA_MADDR_MADDR0_POS))
#define DMA_MADDR_MADDR1                ((uint32_t)1<<(DMA_MADDR_MADDR1_POS))
#define DMA_MADDR_MADDR2                ((uint32_t)1<<(DMA_MADDR_MADDR2_POS))
#define DMA_MADDR_MADDR3                ((uint32_t)1<<(DMA_MADDR_MADDR3_POS))
#define DMA_MADDR_MADDR4                ((uint32_t)1<<(DMA_MADDR_MADDR4_POS))
#define DMA_MADDR_MADDR5                ((uint32_t)1<<(DMA_MADDR_MADDR5_POS))
#define DMA_MADDR_MADDR6                ((uint32_t)1<<(DMA_MADDR_MADDR6_POS))
#define DMA_MADDR_MADDR7                ((uint32_t)1<<(DMA_MADDR_MADDR7_POS))
#define DMA_MADDR_MADDR8                ((uint32_t)1<<(DMA_MADDR_MADDR8_POS))
#define DMA_MADDR_MADDR9                ((uint32_t)1<<(DMA_MADDR_MADDR9_POS))
#define DMA_MADDR_MADDR10               ((uint32_t)1<<(DMA_MADDR_MADDR10_POS))
#define DMA_MADDR_MADDR11               ((uint32_t)1<<(DMA_MADDR_MADDR11_POS))
#define DMA_MADDR_MADDR12               ((uint32_t)1<<(DMA_MADDR_MADDR12_POS))
#define DMA_MADDR_MADDR13               ((uint32_t)1<<(DMA_MADDR_MADDR13_POS))
#define DMA_MADDR_MADDR14               ((uint32_t)1<<(DMA_MADDR_MADDR14_POS))
#define DMA_MADDR_MADDR15               ((uint32_t)1<<(DMA_MADDR_MADDR15_POS))
#define DMA_MADDR_MADDR16               ((uint32_t)1<<(DMA_MADDR_MADDR16_POS))
#define DMA_MADDR_MADDR17               ((uint32_t)1<<(DMA_MADDR_MADDR17_POS))
#define DMA_MADDR_MADDR18               ((uint32_t)1<<(DMA_MADDR_MADDR18_POS))
#define DMA_MADDR_MADDR19               ((uint32_t)1<<(DMA_MADDR_MADDR19_POS))
#define DMA_MADDR_MADDR20               ((uint32_t)1<<(DMA_MADDR_MADDR20_POS))
#define DMA_MADDR_MADDR21               ((uint32_t)1<<(DMA_MADDR_MADDR21_POS))
#define DMA_MADDR_MADDR22               ((uint32_t)1<<(DMA_MADDR_MADDR22_POS))
#define DMA_MADDR_MADDR23               ((uint32_t)1<<(DMA_MADDR_MADDR23_POS))
#define DMA_MADDR_MADDR24               ((uint32_t)1<<(DMA_MADDR_MADDR24_POS))
#define DMA_MADDR_MADDR25               ((uint32_t)1<<(DMA_MADDR_MADDR25_POS))
#define DMA_MADDR_MADDR26               ((uint32_t)1<<(DMA_MADDR_MADDR26_POS))
#define DMA_MADDR_MADDR27               ((uint32_t)1<<(DMA_MADDR_MADDR27_POS))
#define DMA_MADDR_MADDR28               ((uint32_t)1<<(DMA_MADDR_MADDR28_POS))
#define DMA_MADDR_MADDR29               ((uint32_t)1<<(DMA_MADDR_MADDR29_POS))
#define DMA_MADDR_MADDR30               ((uint32_t)1<<(DMA_MADDR_MADDR30_POS))
#define DMA_MADDR_MADDR31               ((uint32_t)1<<(DMA_MADDR_MADDR31_POS))

/* DMA_CPARy λ */
#define DMA_CPAR_CPAR0_POS              (0)
#define DMA_CPAR_CPAR1_POS              (1)
#define DMA_CPAR_CPAR2_POS              (2)
#define DMA_CPAR_CPAR3_POS              (3)
#define DMA_CPAR_CPAR4_POS              (4)
#define DMA_CPAR_CPAR5_POS              (5)
#define DMA_CPAR_CPAR6_POS              (6)
#define DMA_CPAR_CPAR7_POS              (7)
#define DMA_CPAR_CPAR8_POS              (8)
#define DMA_CPAR_CPAR9_POS              (9)
#define DMA_CPAR_CPAR10_POS             (10)
#define DMA_CPAR_CPAR11_POS             (11)
#define DMA_CPAR_CPAR12_POS             (12)
#define DMA_CPAR_CPAR13_POS             (13)
#define DMA_CPAR_CPAR14_POS             (14)
#define DMA_CPAR_CPAR15_POS             (15)
#define DMA_CPAR_CPAR16_POS             (16)
#define DMA_CPAR_CPAR17_POS             (17)
#define DMA_CPAR_CPAR18_POS             (18)
#define DMA_CPAR_CPAR19_POS             (19)
#define DMA_CPAR_CPAR20_POS             (20)
#define DMA_CPAR_CPAR21_POS             (21)
#define DMA_CPAR_CPAR22_POS             (22)
#define DMA_CPAR_CPAR23_POS             (23)
#define DMA_CPAR_CPAR24_POS             (24)
#define DMA_CPAR_CPAR25_POS             (25)
#define DMA_CPAR_CPAR26_POS             (26)
#define DMA_CPAR_CPAR27_POS             (27)
#define DMA_CPAR_CPAR28_POS             (28)
#define DMA_CPAR_CPAR29_POS             (29)
#define DMA_CPAR_CPAR30_POS             (30)
#define DMA_CPAR_CPAR31_POS             (31)
#define DMA_CPAR_CPAR                   ((uint32_t)0xFFFFFFFF)
#define DMA_CPAR_CPAR0                  ((uint32_t)1<<(DMA_CPAR_CPAR0_POS))
#define DMA_CPAR_CPAR1                  ((uint32_t)1<<(DMA_CPAR_CPAR1_POS))
#define DMA_CPAR_CPAR2                  ((uint32_t)1<<(DMA_CPAR_CPAR2_POS))
#define DMA_CPAR_CPAR3                  ((uint32_t)1<<(DMA_CPAR_CPAR3_POS))
#define DMA_CPAR_CPAR4                  ((uint32_t)1<<(DMA_CPAR_CPAR4_POS))
#define DMA_CPAR_CPAR5                  ((uint32_t)1<<(DMA_CPAR_CPAR5_POS))
#define DMA_CPAR_CPAR6                  ((uint32_t)1<<(DMA_CPAR_CPAR6_POS))
#define DMA_CPAR_CPAR7                  ((uint32_t)1<<(DMA_CPAR_CPAR7_POS))
#define DMA_CPAR_CPAR8                  ((uint32_t)1<<(DMA_CPAR_CPAR8_POS))
#define DMA_CPAR_CPAR9                  ((uint32_t)1<<(DMA_CPAR_CPAR9_POS))
#define DMA_CPAR_CPAR10                 ((uint32_t)1<<(DMA_CPAR_CPAR10_POS))
#define DMA_CPAR_CPAR11                 ((uint32_t)1<<(DMA_CPAR_CPAR11_POS))
#define DMA_CPAR_CPAR12                 ((uint32_t)1<<(DMA_CPAR_CPAR12_POS))
#define DMA_CPAR_CPAR13                 ((uint32_t)1<<(DMA_CPAR_CPAR13_POS))
#define DMA_CPAR_CPAR14                 ((uint32_t)1<<(DMA_CPAR_CPAR14_POS))
#define DMA_CPAR_CPAR15                 ((uint32_t)1<<(DMA_CPAR_CPAR15_POS))
#define DMA_CPAR_CPAR16                 ((uint32_t)1<<(DMA_CPAR_CPAR16_POS))
#define DMA_CPAR_CPAR17                 ((uint32_t)1<<(DMA_CPAR_CPAR17_POS))
#define DMA_CPAR_CPAR18                 ((uint32_t)1<<(DMA_CPAR_CPAR18_POS))
#define DMA_CPAR_CPAR19                 ((uint32_t)1<<(DMA_CPAR_CPAR19_POS))
#define DMA_CPAR_CPAR20                 ((uint32_t)1<<(DMA_CPAR_CPAR20_POS))
#define DMA_CPAR_CPAR21                 ((uint32_t)1<<(DMA_CPAR_CPAR21_POS))
#define DMA_CPAR_CPAR22                 ((uint32_t)1<<(DMA_CPAR_CPAR22_POS))
#define DMA_CPAR_CPAR23                 ((uint32_t)1<<(DMA_CPAR_CPAR23_POS))
#define DMA_CPAR_CPAR24                 ((uint32_t)1<<(DMA_CPAR_CPAR24_POS))
#define DMA_CPAR_CPAR25                 ((uint32_t)1<<(DMA_CPAR_CPAR25_POS))
#define DMA_CPAR_CPAR26                 ((uint32_t)1<<(DMA_CPAR_CPAR26_POS))
#define DMA_CPAR_CPAR27                 ((uint32_t)1<<(DMA_CPAR_CPAR27_POS))
#define DMA_CPAR_CPAR28                 ((uint32_t)1<<(DMA_CPAR_CPAR28_POS))
#define DMA_CPAR_CPAR29                 ((uint32_t)1<<(DMA_CPAR_CPAR29_POS))
#define DMA_CPAR_CPAR30                 ((uint32_t)1<<(DMA_CPAR_CPAR30_POS))
#define DMA_CPAR_CPAR31                 ((uint32_t)1<<(DMA_CPAR_CPAR31_POS))

/* DMA_CMARy λ */
#define DMA_CMAR_CMAR0_POS              (0)
#define DMA_CMAR_CMAR1_POS              (1)
#define DMA_CMAR_CMAR2_POS              (2)
#define DMA_CMAR_CMAR3_POS              (3)
#define DMA_CMAR_CMAR4_POS              (4)
#define DMA_CMAR_CMAR5_POS              (5)
#define DMA_CMAR_CMAR6_POS              (6)
#define DMA_CMAR_CMAR7_POS              (7)
#define DMA_CMAR_CMAR8_POS              (8)
#define DMA_CMAR_CMAR9_POS              (9)
#define DMA_CMAR_CMAR10_POS             (10)
#define DMA_CMAR_CMAR11_POS             (11)
#define DMA_CMAR_CMAR12_POS             (12)
#define DMA_CMAR_CMAR13_POS             (13)
#define DMA_CMAR_CMAR14_POS             (14)
#define DMA_CMAR_CMAR15_POS             (15)
#define DMA_CMAR_CMAR16_POS             (16)
#define DMA_CMAR_CMAR17_POS             (17)
#define DMA_CMAR_CMAR18_POS             (18)
#define DMA_CMAR_CMAR19_POS             (19)
#define DMA_CMAR_CMAR20_POS             (20)
#define DMA_CMAR_CMAR21_POS             (21)
#define DMA_CMAR_CMAR22_POS             (22)
#define DMA_CMAR_CMAR23_POS             (23)
#define DMA_CMAR_CMAR24_POS             (24)
#define DMA_CMAR_CMAR25_POS             (25)
#define DMA_CMAR_CMAR26_POS             (26)
#define DMA_CMAR_CMAR27_POS             (27)
#define DMA_CMAR_CMAR28_POS             (28)
#define DMA_CMAR_CMAR29_POS             (29)
#define DMA_CMAR_CMAR30_POS             (30)
#define DMA_CMAR_CMAR31_POS             (31)
#define DMA_CMAR_CMAR                   ((uint32_t)0xFFFFFFFF)
#define DMA_CMAR_CMAR0                  ((uint32_t)1<<(DMA_CMAR_CMAR0_POS))
#define DMA_CMAR_CMAR1                  ((uint32_t)1<<(DMA_CMAR_CMAR1_POS))
#define DMA_CMAR_CMAR2                  ((uint32_t)1<<(DMA_CMAR_CMAR2_POS))
#define DMA_CMAR_CMAR3                  ((uint32_t)1<<(DMA_CMAR_CMAR3_POS))
#define DMA_CMAR_CMAR4                  ((uint32_t)1<<(DMA_CMAR_CMAR4_POS))
#define DMA_CMAR_CMAR5                  ((uint32_t)1<<(DMA_CMAR_CMAR5_POS))
#define DMA_CMAR_CMAR6                  ((uint32_t)1<<(DMA_CMAR_CMAR6_POS))
#define DMA_CMAR_CMAR7                  ((uint32_t)1<<(DMA_CMAR_CMAR7_POS))
#define DMA_CMAR_CMAR8                  ((uint32_t)1<<(DMA_CMAR_CMAR8_POS))
#define DMA_CMAR_CMAR9                  ((uint32_t)1<<(DMA_CMAR_CMAR9_POS))
#define DMA_CMAR_CMAR10                 ((uint32_t)1<<(DMA_CMAR_CMAR10_POS))
#define DMA_CMAR_CMAR11                 ((uint32_t)1<<(DMA_CMAR_CMAR11_POS))
#define DMA_CMAR_CMAR12                 ((uint32_t)1<<(DMA_CMAR_CMAR12_POS))
#define DMA_CMAR_CMAR13                 ((uint32_t)1<<(DMA_CMAR_CMAR13_POS))
#define DMA_CMAR_CMAR14                 ((uint32_t)1<<(DMA_CMAR_CMAR14_POS))
#define DMA_CMAR_CMAR15                 ((uint32_t)1<<(DMA_CMAR_CMAR15_POS))
#define DMA_CMAR_CMAR16                 ((uint32_t)1<<(DMA_CMAR_CMAR16_POS))
#define DMA_CMAR_CMAR17                 ((uint32_t)1<<(DMA_CMAR_CMAR17_POS))
#define DMA_CMAR_CMAR18                 ((uint32_t)1<<(DMA_CMAR_CMAR18_POS))
#define DMA_CMAR_CMAR19                 ((uint32_t)1<<(DMA_CMAR_CMAR19_POS))
#define DMA_CMAR_CMAR20                 ((uint32_t)1<<(DMA_CMAR_CMAR20_POS))
#define DMA_CMAR_CMAR21                 ((uint32_t)1<<(DMA_CMAR_CMAR21_POS))
#define DMA_CMAR_CMAR22                 ((uint32_t)1<<(DMA_CMAR_CMAR22_POS))
#define DMA_CMAR_CMAR23                 ((uint32_t)1<<(DMA_CMAR_CMAR23_POS))
#define DMA_CMAR_CMAR24                 ((uint32_t)1<<(DMA_CMAR_CMAR24_POS))
#define DMA_CMAR_CMAR25                 ((uint32_t)1<<(DMA_CMAR_CMAR25_POS))
#define DMA_CMAR_CMAR26                 ((uint32_t)1<<(DMA_CMAR_CMAR26_POS))
#define DMA_CMAR_CMAR27                 ((uint32_t)1<<(DMA_CMAR_CMAR27_POS))
#define DMA_CMAR_CMAR28                 ((uint32_t)1<<(DMA_CMAR_CMAR28_POS))
#define DMA_CMAR_CMAR29                 ((uint32_t)1<<(DMA_CMAR_CMAR29_POS))
#define DMA_CMAR_CMAR30                 ((uint32_t)1<<(DMA_CMAR_CMAR30_POS))
#define DMA_CMAR_CMAR31                 ((uint32_t)1<<(DMA_CMAR_CMAR31_POS))

/* DMA_NCTy λ */
#define DMA_NCT_NCT16_POS               (16)
#define DMA_NCT_NCT17_POS               (17)
#define DMA_NCT_NCT18_POS               (18)
#define DMA_NCT_NCT19_POS               (19)
#define DMA_NCT_NCT20_POS               (20)
#define DMA_NCT_NCT21_POS               (21)
#define DMA_NCT_NCT22_POS               (22)
#define DMA_NCT_NCT23_POS               (23)
#define DMA_NCT_NCT24_POS               (24)
#define DMA_NCT_NCT25_POS               (25)
#define DMA_NCT_NCT26_POS               (26)
#define DMA_NCT_NCT27_POS               (27)
#define DMA_NCT_NCT28_POS               (28)
#define DMA_NCT_NCT29_POS               (29)
#define DMA_NCT_NCT30_POS               (30)
#define DMA_NCT_NCT31_POS               (31)
#define DMA_NCT_NCT                     ((uint32_t)0xFFFF<<(DMA_NCT_NCT16_POS))
#define DMA_NCT_NCT16                   ((uint32_t)1<<(DMA_NCT_NCT16_POS))
#define DMA_NCT_NCT17                   ((uint32_t)1<<(DMA_NCT_NCT17_POS))
#define DMA_NCT_NCT18                   ((uint32_t)1<<(DMA_NCT_NCT18_POS))
#define DMA_NCT_NCT19                   ((uint32_t)1<<(DMA_NCT_NCT19_POS))
#define DMA_NCT_NCT20                   ((uint32_t)1<<(DMA_NCT_NCT20_POS))
#define DMA_NCT_NCT21                   ((uint32_t)1<<(DMA_NCT_NCT21_POS))
#define DMA_NCT_NCT22                   ((uint32_t)1<<(DMA_NCT_NCT22_POS))
#define DMA_NCT_NCT23                   ((uint32_t)1<<(DMA_NCT_NCT23_POS))
#define DMA_NCT_NCT24                   ((uint32_t)1<<(DMA_NCT_NCT24_POS))
#define DMA_NCT_NCT25                   ((uint32_t)1<<(DMA_NCT_NCT25_POS))
#define DMA_NCT_NCT26                   ((uint32_t)1<<(DMA_NCT_NCT26_POS))
#define DMA_NCT_NCT27                   ((uint32_t)1<<(DMA_NCT_NCT27_POS))
#define DMA_NCT_NCT28                   ((uint32_t)1<<(DMA_NCT_NCT28_POS))
#define DMA_NCT_NCT29                   ((uint32_t)1<<(DMA_NCT_NCT29_POS))
#define DMA_NCT_NCT30                   ((uint32_t)1<<(DMA_NCT_NCT30_POS))
#define DMA_NCT_NCT31                   ((uint32_t)1<<(DMA_NCT_NCT31_POS))

/* DMA_LIFR λ */
#define DMA_LIFR_FTIF1_POS              (0)
#define DMA_LIFR_HTIF1_POS              (1)
#define DMA_LIFR_ETIF1_POS              (2)
#define DMA_LIFR_FTIF2_POS              (3)
#define DMA_LIFR_HTIF2_POS              (4)
#define DMA_LIFR_ETIF2_POS              (5)
#define DMA_LIFR_FTIF3_POS              (6)
#define DMA_LIFR_HTIF3_POS              (7)
#define DMA_LIFR_ETIF3_POS              (8)
#define DMA_LIFR_FTIF4_POS              (9)
#define DMA_LIFR_HTIF4_POS              (10)
#define DMA_LIFR_ETIF4_POS              (11)
#define DMA_LIFR_FTIF5_POS              (12)
#define DMA_LIFR_HTIF5_POS              (13)
#define DMA_LIFR_ETIF5_POS              (14)
#define DMA_LIFR_FTIF6_POS              (15)
#define DMA_LIFR_HTIF6_POS              (16)
#define DMA_LIFR_ETIF6_POS              (17)
#define DMA_LIFR_FTIF7_POS              (18)
#define DMA_LIFR_HTIF7_POS              (19)
#define DMA_LIFR_ETIF7_POS              (20)
#define DMA_LIFR_FTIF1                  ((uint32_t)1<<(DMA_LIFR_FTIF1_POS))
#define DMA_LIFR_HTIF1                  ((uint32_t)1<<(DMA_LIFR_HTIF1_POS))
#define DMA_LIFR_ETIF1                  ((uint32_t)1<<(DMA_LIFR_ETIF1_POS))
#define DMA_LIFR_FTIF2                  ((uint32_t)1<<(DMA_LIFR_FTIF2_POS))
#define DMA_LIFR_HTIF2                  ((uint32_t)1<<(DMA_LIFR_HTIF2_POS))
#define DMA_LIFR_ETIF2                  ((uint32_t)1<<(DMA_LIFR_ETIF2_POS))
#define DMA_LIFR_FTIF3                  ((uint32_t)1<<(DMA_LIFR_FTIF3_POS))
#define DMA_LIFR_HTIF3                  ((uint32_t)1<<(DMA_LIFR_HTIF3_POS))
#define DMA_LIFR_ETIF3                  ((uint32_t)1<<(DMA_LIFR_ETIF3_POS))
#define DMA_LIFR_FTIF4                  ((uint32_t)1<<(DMA_LIFR_FTIF4_POS))
#define DMA_LIFR_HTIF4                  ((uint32_t)1<<(DMA_LIFR_HTIF4_POS))
#define DMA_LIFR_ETIF4                  ((uint32_t)1<<(DMA_LIFR_ETIF4_POS))
#define DMA_LIFR_FTIF5                  ((uint32_t)1<<(DMA_LIFR_FTIF5_POS))
#define DMA_LIFR_HTIF5                  ((uint32_t)1<<(DMA_LIFR_HTIF5_POS))
#define DMA_LIFR_ETIF5                  ((uint32_t)1<<(DMA_LIFR_ETIF5_POS))
#define DMA_LIFR_FTIF6                  ((uint32_t)1<<(DMA_LIFR_FTIF6_POS))
#define DMA_LIFR_HTIF6                  ((uint32_t)1<<(DMA_LIFR_HTIF6_POS))
#define DMA_LIFR_ETIF6                  ((uint32_t)1<<(DMA_LIFR_ETIF6_POS))
#define DMA_LIFR_FTIF7                  ((uint32_t)1<<(DMA_LIFR_FTIF7_POS))
#define DMA_LIFR_HTIF7                  ((uint32_t)1<<(DMA_LIFR_HTIF7_POS))
#define DMA_LIFR_ETIF7                  ((uint32_t)1<<(DMA_LIFR_ETIF7_POS))

/* DMA_LIER λ */
#define DMA_LIER_FTIE1_POS              (0)
#define DMA_LIER_HTIE1_POS              (1)
#define DMA_LIER_ETIE1_POS              (2)
#define DMA_LIER_FTIE2_POS              (3)
#define DMA_LIER_HTIE2_POS              (4)
#define DMA_LIER_ETIE2_POS              (5)
#define DMA_LIER_FTIE3_POS              (6)
#define DMA_LIER_HTIE3_POS              (7)
#define DMA_LIER_ETIE3_POS              (8)
#define DMA_LIER_FTIE4_POS              (9)
#define DMA_LIER_HTIE4_POS              (10)
#define DMA_LIER_ETIE4_POS              (11)
#define DMA_LIER_FTIE5_POS              (12)
#define DMA_LIER_HTIE5_POS              (13)
#define DMA_LIER_ETIE5_POS              (14)
#define DMA_LIER_FTIE6_POS              (15)
#define DMA_LIER_HTIE6_POS              (16)
#define DMA_LIER_ETIE6_POS              (17)
#define DMA_LIER_FTIE7_POS              (18)
#define DMA_LIER_HTIE7_POS              (19)
#define DMA_LIER_ETIE7_POS              (20)
#define DMA_LIER_FTIE1                  ((uint32_t)1<<(DMA_LIER_FTIE1_POS))
#define DMA_LIER_HTIE1                  ((uint32_t)1<<(DMA_LIER_HTIE1_POS))
#define DMA_LIER_ETIE1                  ((uint32_t)1<<(DMA_LIER_ETIE1_POS))
#define DMA_LIER_FTIE2                  ((uint32_t)1<<(DMA_LIER_FTIE2_POS))
#define DMA_LIER_HTIE2                  ((uint32_t)1<<(DMA_LIER_HTIE2_POS))
#define DMA_LIER_ETIE2                  ((uint32_t)1<<(DMA_LIER_ETIE2_POS))
#define DMA_LIER_FTIE3                  ((uint32_t)1<<(DMA_LIER_FTIE3_POS))
#define DMA_LIER_HTIE3                  ((uint32_t)1<<(DMA_LIER_HTIE3_POS))
#define DMA_LIER_ETIE3                  ((uint32_t)1<<(DMA_LIER_ETIE3_POS))
#define DMA_LIER_FTIE4                  ((uint32_t)1<<(DMA_LIER_FTIE4_POS))
#define DMA_LIER_HTIE4                  ((uint32_t)1<<(DMA_LIER_HTIE4_POS))
#define DMA_LIER_ETIE4                  ((uint32_t)1<<(DMA_LIER_ETIE4_POS))
#define DMA_LIER_FTIE5                  ((uint32_t)1<<(DMA_LIER_FTIE5_POS))
#define DMA_LIER_HTIE5                  ((uint32_t)1<<(DMA_LIER_HTIE5_POS))
#define DMA_LIER_ETIE5                  ((uint32_t)1<<(DMA_LIER_ETIE5_POS))
#define DMA_LIER_FTIE6                  ((uint32_t)1<<(DMA_LIER_FTIE6_POS))
#define DMA_LIER_HTIE6                  ((uint32_t)1<<(DMA_LIER_HTIE6_POS))
#define DMA_LIER_ETIE6                  ((uint32_t)1<<(DMA_LIER_ETIE6_POS))
#define DMA_LIER_FTIE7                  ((uint32_t)1<<(DMA_LIER_FTIE7_POS))
#define DMA_LIER_HTIE7                  ((uint32_t)1<<(DMA_LIER_HTIE7_POS))
#define DMA_LIER_ETIE7                  ((uint32_t)1<<(DMA_LIER_ETIE7_POS))
/* ֱڴȡģ(DMA) */

#endif

#if 1										/* SYSTICK */


/* ----------------------------------------------------------------------------
   -- Ķʱ(SYSTICK)
   ---------------------------------------------------------------------------- */

/* SYSTICK - Ĵڴṹ */
typedef struct SYSTICK_MemMap
{
    volatile uint32_t CTL;            /* ϵͳĶʱƺ״̬Ĵ, ƫ:0xA0 */
    volatile uint32_t RELOAD;         /* ϵͳĶʱֵĴ, ƫ:0xA4 */
    volatile uint32_t CV;             /* ϵͳĶʱǰֵĴ, ƫ:0xA8 */
    volatile uint32_t CALI;           /* ϵͳĶʱУĴ, ƫ:0xAC */
}SYSTICK_SFRmap;

/* ----------------------------------------------------------------------------
   -- SYSTICK - Ĵں
   ---------------------------------------------------------------------------- */

/* SYSTICK - Ĵڵַ */
#define SYSTICK_ADDR                    ((uint32_t)0x402000A0)
#define SYSTICK_SFR                     ((SYSTICK_SFRmap *) SYSTICK_ADDR)

/* SYSTICK - Ĵ */
#define ST_CTL                          (SYSTICK_SFR->CTL)
#define ST_RELOAD                       (SYSTICK_SFR->RELOAD)
#define ST_CV                           (SYSTICK_SFR->CV)
#define ST_CALI                         (SYSTICK_SFR->CALI)

/* ST_CTL λ */
#define ST_CTL_STEN_POS                 (0)
#define ST_CTL_TICKINTEN_POS            (1)
#define ST_CTL_STCLKS_POS               (2)
#define ST_CTL_COUNTZERO_POS            (16)
#define ST_CTL_STEN                     ((uint32_t)1<<(ST_CTL_STEN_POS))
#define ST_CTL_TICKINTEN                ((uint32_t)1<<(ST_CTL_TICKINTEN_POS))
#define ST_CTL_STCLKS                   ((uint32_t)1<<(ST_CTL_STCLKS_POS))
#define ST_CTL_COUNTZERO                ((uint32_t)1<<(ST_CTL_COUNTZERO_POS))

/* ST_RELOAD λ */
#define ST_RELOAD_STRELOAD0_POS         (0)
#define ST_RELOAD_STRELOAD              ((uint32_t)0x00FFFFFF<<(ST_RELOAD_STRELOAD0_POS))

/* STCV λ */
#define ST_CV_STCV0_POS                 (0)
#define ST_CV_STCV                      ((uint32_t)0x00FFFFFF<<(ST_CV_STCV0_POS))

/* STCALIB λ */
#define ST_CALII_STCALIB0_POS           (0)
#define ST_CALII_SKEW_POS               (30)
#define ST_CALII_STCLKREF_POS           (31)
#define ST_CALII_STCALIB                ((uint32_t)0x00FFFFFF<<(ST_CALII_STCALIB0_POS))
#define ST_CALII_SKEW                   ((uint32_t)1<<(ST_CALII_SKEW_POS))
#define ST_CALII_STCLKREF               ((uint32_t)1<<(ST_CALII_STCLKREF_POS))
/* Ķʱ(SYSTICK) */

#endif

#if 1										/* BTIM */

/* ----------------------------------------------------------------------------
   -- ʱ(BTIM)
   ---------------------------------------------------------------------------- */

/* Basic Timer - Ĵڴṹ */
typedef struct BTIM_MemMap
{
    volatile       uint32_t CNT;      /* TxCNTĴ, ƫ:0x00 */
    volatile       uint32_t CTL1;     /* TxƼĴ1, ƫ:0x04 */
    volatile       uint32_t CTL2;     /* TxƼĴ2, ƫ:0x08 */
    volatile       uint32_t PRSC;     /* TxԤƵĴ, ƫ:0x0C */
    volatile       uint32_t PPX;      /* PPxڼĴ, ƫ:0x10 */
    volatile       uint32_t DIER;     /* TxжʹܿƼĴ, ƫ:0x14 */
    volatile const uint32_t SR;       /* Txж״̬Ĵ, ƫ:0x18 */
    volatile       uint32_t SRIC;     /* Txж״̬Ĵ, ƫ:0x1C */
}BTIM_SFRmap;	/* T14 */

/* ----------------------------------------------------------------------------
   -- Basic Timer - Ĵں
   ---------------------------------------------------------------------------- */

/* Basic Timer - Ĵڵַ */
#define T14_ADDR                        ((uint32_t)0x40001800)
#define T14_SFR                         ((BTIM_SFRmap *)T14_ADDR)

/* Basic Timer - Ĵ */
#define T14_CNT                         (T14_SFR->CNT)
#define T14_CTL1                        (T14_SFR->CTL1)
#define T14_CTL2                        (T14_SFR->CTL2)
#define T14_PRSC                        (T14_SFR->PRSC)
#define T14_PPX                         (T14_SFR->PPX)
#define T14_DIER                        (T14_SFR->DIER)
#define T14_SR                          (T14_SFR->SR)
#define T14_SRIC                        (T14_SFR->SRIC)

/* Tx_CNT λ */
#define BTIM_CNT_TXCNT0_POS             (0)
#define BTIM_CNT_TXCNT                  ((uint32_t)0xFFFF<<(BTIM_CNT_TXCNT0_POS))

/* Tx_CTL1 λ */
#define BTIM_CTL1_TXEN_POS              (0)
#define BTIM_CTL1_TXCS_POS              (1)
#define BTIM_CTL1_TXSY_POS              (2)
#define BTIM_CTL1_TXCLK0_POS            (3)
#define BTIM_CTL1_TXCLK1_POS            (4)
#define BTIM_CTL1_TXDIR_POS             (5)
#define BTIM_CTL1_TXCMS0_POS            (6)
#define BTIM_CTL1_TXCMS1_POS            (7)
#define BTIM_CTL1_TXCMS2_POS            (8)
#define BTIM_CTL1_TXEN                  ((uint32_t)1<<(BTIM_CTL1_TXEN_POS))
#define BTIM_CTL1_TXCS                  ((uint32_t)1<<(BTIM_CTL1_TXCS_POS))
#define BTIM_CTL1_TXSY                  ((uint32_t)1<<(BTIM_CTL1_TXSY_POS))
#define BTIM_CTL1_TXCLK                 ((uint32_t)3<<(BTIM_CTL1_TXCLK0_POS))
#define BTIM_CTL1_TXCLK0                ((uint32_t)1<<(BTIM_CTL1_TXCLK0_POS))
#define BTIM_CTL1_TXCLK1                ((uint32_t)1<<(BTIM_CTL1_TXCLK1_POS))
#define BTIM_CTL1_TXDIR                 ((uint32_t)1<<(BTIM_CTL1_TXDIR_POS))
#define BTIM_CTL1_TXCMS                 ((uint32_t)7<<(BTIM_CTL1_TXCMS0_POS))
#define BTIM_CTL1_TXCMS0                ((uint32_t)1<<(BTIM_CTL1_TXCMS0_POS))
#define BTIM_CTL1_TXCMS1                ((uint32_t)1<<(BTIM_CTL1_TXCMS1_POS))
#define BTIM_CTL1_TXCMS2                ((uint32_t)1<<(BTIM_CTL1_TXCMS2_POS))

/* Tx_CTL2 λ */
#define BTIM_CTL2_TXUDEN_POS            (0)
#define BTIM_CTL2_TXUDEVT_POS           (1)
#define BTIM_CTL2_TXMMS0_POS            (2)
#define BTIM_CTL2_TXMMS1_POS            (3)
#define BTIM_CTL2_TXSMS0_POS            (4)
#define BTIM_CTL2_TXSMS1_POS            (5)
#define BTIM_CTL2_TXSMS2_POS            (6)
#define BTIM_CTL2_TXTS0_POS             (7)
#define BTIM_CTL2_TXTS1_POS             (8)
#define BTIM_CTL2_TXTS2_POS             (9)
#define BTIM_CTL2_TXTS3_POS             (10)
#define BTIM_CTL2_TXMSSYNC_POS          (11)
#define BTIM_CTL2_TXUR_POS              (12)
#define BTIM_CTL2_PXSPMST_POS           (13)
#define BTIM_CTL2_PXSPM_POS             (14)
#define BTIM_CTL2_TXTRG_POS             (15)
#define BTIM_CTL2_TXUDEN                ((uint32_t)1<<(BTIM_CTL2_TXUDEN_POS))
#define BTIM_CTL2_TXUDEVT               ((uint32_t)1<<(BTIM_CTL2_TXUDEVT_POS))
#define BTIM_CTL2_TXMMS                 ((uint32_t)3<<(BTIM_CTL2_TXMMS0_POS))
#define BTIM_CTL2_TXMMS0                ((uint32_t)1<<(BTIM_CTL2_TXMMS0_POS))
#define BTIM_CTL2_TXMMS1                ((uint32_t)1<<(BTIM_CTL2_TXMMS1_POS))
#define BTIM_CTL2_TXSMS                 ((uint32_t)7<<(BTIM_CTL2_TXSMS0_POS))
#define BTIM_CTL2_TXSMS0                ((uint32_t)1<<(BTIM_CTL2_TXSMS0_POS))
#define BTIM_CTL2_TXSMS1                ((uint32_t)1<<(BTIM_CTL2_TXSMS1_POS))
#define BTIM_CTL2_TXSMS2                ((uint32_t)1<<(BTIM_CTL2_TXSMS2_POS))
#define BTIM_CTL2_TXTS                  ((uint32_t)0xF<<(BTIM_CTL2_TXTS0_POS))
#define BTIM_CTL2_TXTS0                 ((uint32_t)1<<(BTIM_CTL2_TXTS0_POS))
#define BTIM_CTL2_TXTS1                 ((uint32_t)1<<(BTIM_CTL2_TXTS1_POS))
#define BTIM_CTL2_TXTS2                 ((uint32_t)1<<(BTIM_CTL2_TXTS2_POS))
#define BTIM_CTL2_TXTS3                 ((uint32_t)1<<(BTIM_CTL2_TXTS3_POS))
#define BTIM_CTL2_TXMSSYNC              ((uint32_t)1<<(BTIM_CTL2_TXMSSYNC_POS))
#define BTIM_CTL2_TXUR                  ((uint32_t)1<<(BTIM_CTL2_TXUR_POS))
#define BTIM_CTL2_PXSPMST               ((uint32_t)1<<(BTIM_CTL2_PXSPMST_POS))
#define BTIM_CTL2_PXSPM                 ((uint32_t)1<<(BTIM_CTL2_PXSPM_POS))
#define BTIM_CTL2_TXTRG                 ((uint32_t)1<<(BTIM_CTL2_TXTRG_POS))

/* Tx_PRSC λ */
#define BTIM_PRSC_TXCKS0_POS            (0)
#define BTIM_PRSC_TXCKS1_POS            (1)
#define BTIM_PRSC_TXCKS2_POS            (2)
#define BTIM_PRSC_TXCKS3_POS            (3)
#define BTIM_PRSC_TXCKS4_POS            (4)
#define BTIM_PRSC_TXCKS5_POS            (5)
#define BTIM_PRSC_TXCKS6_POS            (6)
#define BTIM_PRSC_TXCKS7_POS            (7)
#define BTIM_PRSC_TXCKS8_POS            (8)
#define BTIM_PRSC_TXCKS9_POS            (9)
#define BTIM_PRSC_TXCKS10_POS           (10)
#define BTIM_PRSC_TXCKS11_POS           (11)
#define BTIM_PRSC_TXCKS12_POS           (12)
#define BTIM_PRSC_TXCKS13_POS           (13)
#define BTIM_PRSC_TXCKS14_POS           (14)
#define BTIM_PRSC_TXCKS15_POS           (15)
#define BTIM_PRSC_TXCKS                 ((uint32_t)0xFFFF<<(BTIM_PRSC_TXCKS0_POS))
#define BTIM_PRSC_TXCKS0                ((uint32_t)1<<(BTIM_PRSC_TXCKS0_POS))
#define BTIM_PRSC_TXCKS1                ((uint32_t)1<<(BTIM_PRSC_TXCKS1_POS))
#define BTIM_PRSC_TXCKS2                ((uint32_t)1<<(BTIM_PRSC_TXCKS2_POS))
#define BTIM_PRSC_TXCKS3                ((uint32_t)1<<(BTIM_PRSC_TXCKS3_POS))
#define BTIM_PRSC_TXCKS4                ((uint32_t)1<<(BTIM_PRSC_TXCKS4_POS))
#define BTIM_PRSC_TXCKS5                ((uint32_t)1<<(BTIM_PRSC_TXCKS5_POS))
#define BTIM_PRSC_TXCKS6                ((uint32_t)1<<(BTIM_PRSC_TXCKS6_POS))
#define BTIM_PRSC_TXCKS7                ((uint32_t)1<<(BTIM_PRSC_TXCKS7_POS))
#define BTIM_PRSC_TXCKS8                ((uint32_t)1<<(BTIM_PRSC_TXCKS8_POS))
#define BTIM_PRSC_TXCKS9                ((uint32_t)1<<(BTIM_PRSC_TXCKS9_POS))
#define BTIM_PRSC_TXCKS10               ((uint32_t)1<<(BTIM_PRSC_TXCKS10_POS))
#define BTIM_PRSC_TXCKS11               ((uint32_t)1<<(BTIM_PRSC_TXCKS11_POS))
#define BTIM_PRSC_TXCKS12               ((uint32_t)1<<(BTIM_PRSC_TXCKS12_POS))
#define BTIM_PRSC_TXCKS13               ((uint32_t)1<<(BTIM_PRSC_TXCKS13_POS))
#define BTIM_PRSC_TXCKS14               ((uint32_t)1<<(BTIM_PRSC_TXCKS14_POS))
#define BTIM_PRSC_TXCKS15               ((uint32_t)1<<(BTIM_PRSC_TXCKS15_POS))

/* Tx_PPX λ */
#define BTIM_PPX_PPX0_POS               (0)
#define BTIM_PPX_PPX                    ((uint32_t)0xFFFF<<(BTIM_PPX_PPX0_POS))

/* Tx_DIER λ */
#define BTIM_DIER_TXUIE_POS             (0)
#define BTIM_DIER_TXTIE_POS             (1)
#define BTIM_DIER_TXIE_POS              (2)
#define BTIM_DIER_TXUDE_POS             (3)
#define BTIM_DIER_TXTDE_POS             (4)
#define BTIM_DIER_TXUIE                 ((uint32_t)1<<(BTIM_DIER_TXUIE_POS))
#define BTIM_DIER_TXTIE                 ((uint32_t)1<<(BTIM_DIER_TXTIE_POS))
#define BTIM_DIER_TXIE                  ((uint32_t)1<<(BTIM_DIER_TXIE_POS))
#define BTIM_DIER_TXUDE                 ((uint32_t)1<<(BTIM_DIER_TXUDE_POS))
#define BTIM_DIER_TXTDE                 ((uint32_t)1<<(BTIM_DIER_TXTDE_POS))

/* Tx_SR λ */
#define BTIM_SR_TXUIF_POS               (0)
#define BTIM_SR_TXTIF_POS               (1)
#define BTIM_SR_TXIF_POS                (2)
#define BTIM_SR_TXUDF_POS               (3)
#define BTIM_SR_TXTDF_POS               (4)
#define BTIM_SR_TXUIF                   ((uint32_t)1<<(BTIM_SR_TXUIF_POS))
#define BTIM_SR_TXTIF                   ((uint32_t)1<<(BTIM_SR_TXTIF_POS))
#define BTIM_SR_TXIF                    ((uint32_t)1<<(BTIM_SR_TXIF_POS))
#define BTIM_SR_TXUDF                   ((uint32_t)1<<(BTIM_SR_TXUDF_POS))
#define BTIM_SR_TXTDF                   ((uint32_t)1<<(BTIM_SR_TXTDF_POS))

/* Tx_SRIC λ */
#define BTIM_SRIC_TXUIC_POS             (0)
#define BTIM_SRIC_TXTIC_POS             (1)
#define BTIM_SRIC_TXIC_POS              (2)
#define BTIM_SRIC_TXUIC                 ((uint32_t)1<<(BTIM_SRIC_TXUIC_POS))
#define BTIM_SRIC_TXTIC                 ((uint32_t)1<<(BTIM_SRIC_TXTIC_POS))
#define BTIM_SRIC_TXIC                  ((uint32_t)1<<(BTIM_SRIC_TXIC_POS))
/* ʱ(BTIM) */

#endif

#if 1										/* GPTIM */

/* ----------------------------------------------------------------------------
   -- ͨöʱ(GPTIM)
   ---------------------------------------------------------------------------- */

/* GPTIM - Ĵڴṹ */

/* GPTIM - Ĵڴṹ */
typedef struct GPTIM_MemMap
{
    volatile       uint32_t CNT;          /* TxCNTĴ, ƫ:0x00 */
    volatile       uint32_t CTL1;         /* ƼĴ1, ƫ:0x04 */
    volatile       uint32_t CTL2;         /* ƼĴ2, ƫ:0x08 */
    volatile       uint32_t PRSC;         /* TxԤƵĴ, ƫ:0x0C */
    volatile       uint32_t PPX;          /* Tx_PPxڼĴ, ƫ:0x10 */
    volatile       uint32_t UDTIM;        /* ¼, ƫ:0x14 */
                   uint32_t RESERVED1[2]; /* ַ, ƫ:0x18 */
    volatile const uint32_t CCPXC1;       /* CCP׽Ĵ1, ƫ:0x20 */
    volatile const uint32_t CCPXC2;       /* CCP׽Ĵ2, ƫ:0x24 */
    volatile const uint32_t CCPXC3;       /* CCP׽Ĵ3, ƫ:0x28 */
    volatile const uint32_t CCPXC4;       /* CCP׽Ĵ4, ƫ:0x2C */
    volatile       uint32_t CCPXSRIC;     /* CCPжϱ־Ĵ, ƫ:0x30 */
    volatile const uint32_t CCPXDF;       /* CCPDMAжϱ־Ĵ, ƫ:0x34 */
                   uint32_t RESERVED2[2]; /* ַ, ƫ:0x3C */
    volatile       uint32_t CCPXCTL1;     /* CCPƼĴ1, ƫ:0x40 */
    volatile       uint32_t CCPXR1;       /* CCPȽ/PWMռձȼĴ1, ƫ:0x44 */
    volatile       uint32_t CCPXR2;       /* CCPȽ/PWMռձȼĴ2, ƫ:0x48 */
    volatile       uint32_t CCPXR3;       /* CCPȽ/PWMռձȼĴ3, ƫ:0x4C */
    volatile       uint32_t CCPXR4;       /* CCPȽ/PWMռձȼĴ4, ƫ:0x50 */
    volatile       uint32_t CCPXCTL2;     /* CCPƼĴ2, ƫ:0x54 */
    volatile       uint32_t CCPXCTL3;     /* CCPƼĴ3, ƫ:0x58 */
    volatile       uint32_t CCPXEGIF;     /* CCPxж״̬/¼Ĵ, ƫ:0x5C */
}GPTIM_SFRmap, CCP_SFRmap;/* T0 / T1 / T2 / T3 / T4 / T18 / T19 / T21 */

/* ----------------------------------------------------------------------------
   -- GPTIM - Ĵں
   ---------------------------------------------------------------------------- */
/* GPTIM - Ĵڵַ */
#define T0_ADDR                         ((uint32_t)0x40000880)
#define T1_ADDR                         ((uint32_t)0x40000100)
#define T2_ADDR                         ((uint32_t)0x40000180)
#define T3_ADDR                         ((uint32_t)0x40000200)
#define T4_ADDR                         ((uint32_t)0x40000280)
#define T18_ADDR                        ((uint32_t)0x40001A80)
#define T19_ADDR                        ((uint32_t)0x40001B00)
#define T21_ADDR                        ((uint32_t)0x40001C00)
#define T0_SFR                          ((GPTIM_SFRmap *) T0_ADDR)
#define T1_SFR                          ((GPTIM_SFRmap *) T1_ADDR)
#define T2_SFR                          ((GPTIM_SFRmap *) T2_ADDR)
#define T3_SFR                          ((GPTIM_SFRmap *) T3_ADDR)
#define T4_SFR                          ((GPTIM_SFRmap *) T4_ADDR)
#define T18_SFR                         ((GPTIM_SFRmap *) T18_ADDR)
#define T19_SFR                         ((GPTIM_SFRmap *) T19_ADDR)
#define T21_SFR                         ((GPTIM_SFRmap *) T21_ADDR)

#define CCP0_ADDR                       T0_ADDR
#define CCP1_ADDR                       T1_ADDR
#define CCP2_ADDR                       T2_ADDR
#define CCP3_ADDR                       T3_ADDR
#define CCP4_ADDR                       T4_ADDR
#define CCP18_ADDR                      T18_ADDR
#define CCP19_ADDR                      T19_ADDR
#define CCP21_ADDR                      T21_ADDR
#define CCP0_SFR                        ((CCP_SFRmap *) CCP0_ADDR)
#define CCP1_SFR                        ((CCP_SFRmap *) CCP1_ADDR)
#define CCP2_SFR                        ((CCP_SFRmap *) CCP2_ADDR)
#define CCP3_SFR                        ((CCP_SFRmap *) CCP3_ADDR)
#define CCP4_SFR                        ((CCP_SFRmap *) CCP4_ADDR)
#define CCP18_SFR                       ((CCP_SFRmap *) CCP18_ADDR)
#define CCP19_SFR                       ((CCP_SFRmap *) CCP19_ADDR)
#define CCP21_SFR                       ((CCP_SFRmap *) CCP21_ADDR)

/* GPTIM - Ĵ */
#define T0_CNT                          (T0_SFR->CNT)
#define T0_CTL1                         (T0_SFR->CTL1)
#define T0_CTL2                         (T0_SFR->CTL2)
#define T0_PRSC                         (T0_SFR->PRSC)
#define T0_PPX                          (T0_SFR->PPX)
#define T0_UDTIM                        (T0_SFR->UDTIM)
#define CCP0_C1                         (CCP0_SFR->CCPXC1)
#define CCP0_C2                         (CCP0_SFR->CCPXC2)
#define CCP0_C3                         (CCP0_SFR->CCPXC3)
#define CCP0_C4                         (CCP0_SFR->CCPXC4)
#define CCP0_SRIC                       (CCP0_SFR->CCPXSRIC)
#define CCP0_DF                         (CCP0_SFR->CCPXDF)
#define CCP0_CTL1                       (CCP0_SFR->CCPXCTL1)
#define CCP0_R1                         (CCP0_SFR->CCPXR1)
#define CCP0_R2                         (CCP0_SFR->CCPXR2)
#define CCP0_R3                         (CCP0_SFR->CCPXR3)
#define CCP0_R4                         (CCP0_SFR->CCPXR4)
#define CCP0_CTL2                       (CCP0_SFR->CCPXCTL2)
#define CCP0_CTL3                       (CCP0_SFR->CCPXCTL3)
#define CCP0_EGIF                       (CCP0_SFR->CCPXEGIF)
#define T1_CNT                          (T1_SFR->CNT)
#define T1_CTL1                         (T1_SFR->CTL1)
#define T1_CTL2                         (T1_SFR->CTL2)
#define T1_PRSC                         (T1_SFR->PRSC)
#define T1_PPX                          (T1_SFR->PPX)
#define T1_UDTIM                        (T1_SFR->UDTIM)
#define CCP1_C1                         (CCP1_SFR->CCPXC1)
#define CCP1_C2                         (CCP1_SFR->CCPXC2)
#define CCP1_C3                         (CCP1_SFR->CCPXC3)
#define CCP1_C4                         (CCP1_SFR->CCPXC4)
#define CCP1_SRIC                       (CCP1_SFR->CCPXSRIC)
#define CCP1_DF                         (CCP1_SFR->CCPXDF)
#define CCP1_CTL1                       (CCP1_SFR->CCPXCTL1)
#define CCP1_R1                         (CCP1_SFR->CCPXR1)
#define CCP1_R2                         (CCP1_SFR->CCPXR2)
#define CCP1_R3                         (CCP1_SFR->CCPXR3)
#define CCP1_R4                         (CCP1_SFR->CCPXR4)
#define CCP1_CTL2                       (CCP1_SFR->CCPXCTL2)
#define CCP1_CTL3                       (CCP1_SFR->CCPXCTL3)
#define CCP1_EGIF                       (CCP1_SFR->CCPXEGIF)
#define T2_CNT                          (T2_SFR->CNT)
#define T2_CTL1                         (T2_SFR->CTL1)
#define T2_CTL2                         (T2_SFR->CTL2)
#define T2_PRSC                         (T2_SFR->PRSC)
#define T2_PPX                          (T2_SFR->PPX)
#define T2_UDTIM                        (T2_SFR->UDTIM)
#define CCP2_C1                         (CCP2_SFR->CCPXC1)
#define CCP2_C2                         (CCP2_SFR->CCPXC2)
#define CCP2_C3                         (CCP2_SFR->CCPXC3)
#define CCP2_C4                         (CCP2_SFR->CCPXC4)
#define CCP2_SRIC                       (CCP2_SFR->CCPXSRIC)
#define CCP2_DF                         (CCP2_SFR->CCPXDF)
#define CCP2_CTL1                       (CCP2_SFR->CCPXCTL1)
#define CCP2_R1                         (CCP2_SFR->CCPXR1)
#define CCP2_R2                         (CCP2_SFR->CCPXR2)
#define CCP2_R3                         (CCP2_SFR->CCPXR3)
#define CCP2_R4                         (CCP2_SFR->CCPXR4)
#define CCP2_CTL2                       (CCP2_SFR->CCPXCTL2)
#define CCP2_CTL3                       (CCP2_SFR->CCPXCTL3)
#define CCP2_EGIF                       (CCP2_SFR->CCPXEGIF)
#define T3_CNT                          (T3_SFR->CNT)
#define T3_CTL1                         (T3_SFR->CTL1)
#define T3_CTL2                         (T3_SFR->CTL2)
#define T3_PRSC                         (T3_SFR->PRSC)
#define T3_PPX                          (T3_SFR->PPX)
#define T3_UDTIM                        (T3_SFR->UDTIM)
#define CCP3_C1                         (CCP3_SFR->CCPXC1)
#define CCP3_C2                         (CCP3_SFR->CCPXC2)
#define CCP3_C3                         (CCP3_SFR->CCPXC3)
#define CCP3_C4                         (CCP3_SFR->CCPXC4)
#define CCP3_SRIC                       (CCP3_SFR->CCPXSRIC)
#define CCP3_DF                         (CCP3_SFR->CCPXDF)
#define CCP3_CTL1                       (CCP3_SFR->CCPXCTL1)
#define CCP3_R1                         (CCP3_SFR->CCPXR1)
#define CCP3_R2                         (CCP3_SFR->CCPXR2)
#define CCP3_R3                         (CCP3_SFR->CCPXR3)
#define CCP3_R4                         (CCP3_SFR->CCPXR4)
#define CCP3_CTL2                       (CCP3_SFR->CCPXCTL2)
#define CCP3_CTL3                       (CCP3_SFR->CCPXCTL3)
#define CCP3_EGIF                       (CCP3_SFR->CCPXEGIF)
#define T4_CNT                          (T4_SFR->CNT)
#define T4_CTL1                         (T4_SFR->CTL1)
#define T4_CTL2                         (T4_SFR->CTL2)
#define T4_PRSC                         (T4_SFR->PRSC)
#define T4_PPX                          (T4_SFR->PPX)
#define T4_UDTIM                        (T4_SFR->UDTIM)
#define CCP4_C1                         (CCP4_SFR->CCPXC1)
#define CCP4_C2                         (CCP4_SFR->CCPXC2)
#define CCP4_C3                         (CCP4_SFR->CCPXC3)
#define CCP4_C4                         (CCP4_SFR->CCPXC4)
#define CCP4_SRIC                       (CCP4_SFR->CCPXSRIC)
#define CCP4_DF                         (CCP4_SFR->CCPXDF)
#define CCP4_CTL1                       (CCP4_SFR->CCPXCTL1)
#define CCP4_R1                         (CCP4_SFR->CCPXR1)
#define CCP4_R2                         (CCP4_SFR->CCPXR2)
#define CCP4_R3                         (CCP4_SFR->CCPXR3)
#define CCP4_R4                         (CCP4_SFR->CCPXR4)
#define CCP4_CTL2                       (CCP4_SFR->CCPXCTL2)
#define CCP4_CTL3                       (CCP4_SFR->CCPXCTL3)
#define CCP4_EGIF                       (CCP4_SFR->CCPXEGIF)
#define T18_CNT                         (T18_SFR->CNT)
#define T18_CTL1                        (T18_SFR->CTL1)
#define T18_CTL2                        (T18_SFR->CTL2)
#define T18_PRSC                        (T18_SFR->PRSC)
#define T18_PPX                         (T18_SFR->PPX)
#define T18_UDTIM                       (T18_SFR->UDTIM)
#define CCP18_C1                        (CCP18_SFR->CCPXC1)
#define CCP18_C2                        (CCP18_SFR->CCPXC2)
#define CCP18_C3                        (CCP18_SFR->CCPXC3)
#define CCP18_C4                        (CCP18_SFR->CCPXC4)
#define CCP18_SRIC                      (CCP18_SFR->CCPXSRIC)
#define CCP18_DF                        (CCP18_SFR->CCPXDF)
#define CCP18_CTL1                      (CCP18_SFR->CCPXCTL1)
#define CCP18_R1                        (CCP18_SFR->CCPXR1)
#define CCP18_R2                        (CCP18_SFR->CCPXR2)
#define CCP18_R3                        (CCP18_SFR->CCPXR3)
#define CCP18_R4                        (CCP18_SFR->CCPXR4)
#define CCP18_CTL2                      (CCP18_SFR->CCPXCTL2)
#define CCP18_CTL3                      (CCP18_SFR->CCPXCTL3)
#define CCP18_EGIF                      (CCP18_SFR->CCPXEGIF)
#define T19_CNT                         (T19_SFR->CNT)
#define T19_CTL1                        (T19_SFR->CTL1)
#define T19_CTL2                        (T19_SFR->CTL2)
#define T19_PRSC                        (T19_SFR->PRSC)
#define T19_PPX                         (T19_SFR->PPX)
#define T19_UDTIM                       (T19_SFR->UDTIM)
#define CCP19_C1                        (CCP19_SFR->CCPXC1)
#define CCP19_C2                        (CCP19_SFR->CCPXC2)
#define CCP19_C3                        (CCP19_SFR->CCPXC3)
#define CCP19_C4                        (CCP19_SFR->CCPXC4)
#define CCP19_SRIC                      (CCP19_SFR->CCPXSRIC)
#define CCP19_DF                        (CCP19_SFR->CCPXDF)
#define CCP19_CTL1                      (CCP19_SFR->CCPXCTL1)
#define CCP19_R1                        (CCP19_SFR->CCPXR1)
#define CCP19_R2                        (CCP19_SFR->CCPXR2)
#define CCP19_R3                        (CCP19_SFR->CCPXR3)
#define CCP19_R4                        (CCP19_SFR->CCPXR4)
#define CCP19_CTL2                      (CCP19_SFR->CCPXCTL2)
#define CCP19_CTL3                      (CCP19_SFR->CCPXCTL3)
#define CCP19_EGIF                      (CCP19_SFR->CCPXEGIF)
#define T21_CNT                         (T21_SFR->CNT)
#define T21_CTL1                        (T21_SFR->CTL1)
#define T21_CTL2                        (T21_SFR->CTL2)
#define T21_PRSC                        (T21_SFR->PRSC)
#define T21_PPX                         (T21_SFR->PPX)
#define T21_UDTIM                       (T21_SFR->UDTIM)
#define CCP21_C1                        (CCP21_SFR->CCPXC1)
#define CCP21_C2                        (CCP21_SFR->CCPXC2)
#define CCP21_C3                        (CCP21_SFR->CCPXC3)
#define CCP21_C4                        (CCP21_SFR->CCPXC4)
#define CCP21_SRIC                      (CCP21_SFR->CCPXSRIC)
#define CCP21_DF                        (CCP21_SFR->CCPXDF)
#define CCP21_CTL1                      (CCP21_SFR->CCPXCTL1)
#define CCP21_R1                        (CCP21_SFR->CCPXR1)
#define CCP21_R2                        (CCP21_SFR->CCPXR2)
#define CCP21_R3                        (CCP21_SFR->CCPXR3)
#define CCP21_R4                        (CCP21_SFR->CCPXR4)
#define CCP21_CTL2                      (CCP21_SFR->CCPXCTL2)
#define CCP21_CTL3                      (CCP21_SFR->CCPXCTL3)
#define CCP21_EGIF                      (CCP21_SFR->CCPXEGIF)

/* TX_CTL1 λ */
#define GPTIM_CTL1_TXEN_POS             (0)
#define GPTIM_CTL1_TXCS_POS             (1)
#define GPTIM_CTL1_TXSY_POS             (3)
#define GPTIM_CTL1_TXCLK0_POS           (5)
#define GPTIM_CTL1_TXCLK1_POS           (6)
#define GPTIM_CTL1_TXDIR_POS            (7)
#define GPTIM_CTL1_TXCMS0_POS           (8)
#define GPTIM_CTL1_TXCMS1_POS           (9)
#define GPTIM_CTL1_TXCMS2_POS           (10)
#define GPTIM_CTL1_TXIE_POS             (12)
#define GPTIM_CTL1_TXIF_POS             (13)
#define GPTIM_CTL1_TXEN                 ((uint32_t)1<<(GPTIM_CTL1_TXEN_POS))
#define GPTIM_CTL1_TXCS                 ((uint32_t)1<<(GPTIM_CTL1_TXCS_POS))
#define GPTIM_CTL1_TXSY                 ((uint32_t)1<<(GPTIM_CTL1_TXSY_POS))
#define GPTIM_CTL1_TXCLK                ((uint32_t)3<<(GPTIM_CTL1_TXCLK0_POS))
#define GPTIM_CTL1_TXCLK0               ((uint32_t)1<<(GPTIM_CTL1_TXCLK0_POS))
#define GPTIM_CTL1_TXCLK1               ((uint32_t)1<<(GPTIM_CTL1_TXCLK1_POS))
#define GPTIM_CTL1_TXDIR                ((uint32_t)1<<(GPTIM_CTL1_TXDIR_POS))
#define GPTIM_CTL1_TXCMS                ((uint32_t)7<<(GPTIM_CTL1_TXCMS0_POS))
#define GPTIM_CTL1_TXCMS0               ((uint32_t)1<<(GPTIM_CTL1_TXCMS0_POS))
#define GPTIM_CTL1_TXCMS1               ((uint32_t)1<<(GPTIM_CTL1_TXCMS1_POS))
#define GPTIM_CTL1_TXCMS2               ((uint32_t)1<<(GPTIM_CTL1_TXCMS2_POS))
#define GPTIM_CTL1_TXIE                 ((uint32_t)1<<(GPTIM_CTL1_TXIE_POS))
#define GPTIM_CTL1_TXIF                 ((uint32_t)1<<(GPTIM_CTL1_TXIF_POS))

/* TX_CTL2 λ */
#define GPTIM_CTL2_TXUDEN_POS           (0)
#define GPTIM_CTL2_TXUDEVT_POS          (1)
#define GPTIM_CTL2_TXMMS0_POS           (2)
#define GPTIM_CTL2_TXMMS1_POS           (3)
#define GPTIM_CTL2_TXMMS2_POS           (4)
#define GPTIM_CTL2_TXSMS0_POS           (5)
#define GPTIM_CTL2_TXSMS1_POS           (6)
#define GPTIM_CTL2_TXSMS2_POS           (7)
#define GPTIM_CTL2_TXTS0_POS            (8)
#define GPTIM_CTL2_TXTS1_POS            (9)
#define GPTIM_CTL2_TXTS2_POS            (10)
#define GPTIM_CTL2_TXTS3_POS            (11)
#define GPTIM_CTL2_TXMSSYNC_POS         (12)
#define GPTIM_CTL2_TXUR_POS             (13)
#define GPTIM_CTL2_TXUDEN               ((uint32_t)1<<(GPTIM_CTL2_TXUDEN_POS))
#define GPTIM_CTL2_TXUDEVT              ((uint32_t)1<<(GPTIM_CTL2_TXUDEVT_POS))
#define GPTIM_CTL2_TXMMS                ((uint32_t)7<<(GPTIM_CTL2_TXMMS0_POS))
#define GPTIM_CTL2_TXMMS0               ((uint32_t)1<<(GPTIM_CTL2_TXMMS0_POS))
#define GPTIM_CTL2_TXMMS1               ((uint32_t)1<<(GPTIM_CTL2_TXMMS1_POS))
#define GPTIM_CTL2_TXMMS2               ((uint32_t)1<<(GPTIM_CTL2_TXMMS2_POS))
#define GPTIM_CTL2_TXSMS                ((uint32_t)7<<(GPTIM_CTL2_TXSMS0_POS))
#define GPTIM_CTL2_TXSMS0               ((uint32_t)1<<(GPTIM_CTL2_TXSMS0_POS))
#define GPTIM_CTL2_TXSMS1               ((uint32_t)1<<(GPTIM_CTL2_TXSMS1_POS))
#define GPTIM_CTL2_TXSMS2               ((uint32_t)1<<(GPTIM_CTL2_TXSMS2_POS))
#define GPTIM_CTL2_TXTS                 ((uint32_t)0xF<<(GPTIM_CTL2_TXTS0_POS))
#define GPTIM_CTL2_TXTS0                ((uint32_t)1<<(GPTIM_CTL2_TXTS0_POS))
#define GPTIM_CTL2_TXTS1                ((uint32_t)1<<(GPTIM_CTL2_TXTS1_POS))
#define GPTIM_CTL2_TXTS2                ((uint32_t)1<<(GPTIM_CTL2_TXTS2_POS))
#define GPTIM_CTL2_TXTS3                ((uint32_t)1<<(GPTIM_CTL2_TXTS3_POS))
#define GPTIM_CTL2_TXMSSYNC             ((uint32_t)1<<(GPTIM_CTL2_TXMSSYNC_POS))
#define GPTIM_CTL2_TXUR                 ((uint32_t)1<<(GPTIM_CTL2_TXUR_POS))

/* TX_UDTIMx λ */
#define GPTIM_UDTIM_TXUD0_POS           (0)
#define GPTIM_UDTIM_TXUD1_POS           (1)
#define GPTIM_UDTIM_TXUD2_POS           (2)
#define GPTIM_UDTIM_TXUD3_POS           (3)
#define GPTIM_UDTIM_TXUD4_POS           (4)
#define GPTIM_UDTIM_TXUD5_POS           (5)
#define GPTIM_UDTIM_TXUD6_POS           (6)
#define GPTIM_UDTIM_TXUD7_POS           (7)
#define GPTIM_UDTIM_TXUD                ((uint32_t)0xFF<<(GPTIM_UDTIM_TXUD0_POS))
#define GPTIM_UDTIM_TXUD0               ((uint32_t)1<<(GPTIM_UDTIM_TXUD0_POS))
#define GPTIM_UDTIM_TXUD1               ((uint32_t)1<<(GPTIM_UDTIM_TXUD1_POS))
#define GPTIM_UDTIM_TXUD2               ((uint32_t)1<<(GPTIM_UDTIM_TXUD2_POS))
#define GPTIM_UDTIM_TXUD3               ((uint32_t)1<<(GPTIM_UDTIM_TXUD3_POS))
#define GPTIM_UDTIM_TXUD4               ((uint32_t)1<<(GPTIM_UDTIM_TXUD4_POS))
#define GPTIM_UDTIM_TXUD5               ((uint32_t)1<<(GPTIM_UDTIM_TXUD5_POS))
#define GPTIM_UDTIM_TXUD6               ((uint32_t)1<<(GPTIM_UDTIM_TXUD6_POS))
#define GPTIM_UDTIM_TXUD7               ((uint32_t)1<<(GPTIM_UDTIM_TXUD7_POS))

/* CCPX_SRIC λ */
#define CCP_SRIC_CC1IC_POS              (0)
#define CCP_SRIC_CC2IC_POS              (1)
#define CCP_SRIC_CC3IC_POS              (2)
#define CCP_SRIC_CC4IC_POS              (3)
#define CCP_SRIC_TXTIC_POS              (4)
#define CCP_SRIC_TXUIC_POS              (5)
#define CCP_SRIC_TXIC_POS               (6)
#define CCP_SRIC_CC1IC                  ((uint32_t)1<<(CCP_SRIC_CC1IC_POS))
#define CCP_SRIC_CC2IC                  ((uint32_t)1<<(CCP_SRIC_CC2IC_POS))
#define CCP_SRIC_CC3IC                  ((uint32_t)1<<(CCP_SRIC_CC3IC_POS))
#define CCP_SRIC_CC4IC                  ((uint32_t)1<<(CCP_SRIC_CC4IC_POS))
#define CCP_SRIC_TXTIC                  ((uint32_t)1<<(CCP_SRIC_TXTIC_POS))
#define CCP_SRIC_TXUIC                  ((uint32_t)1<<(CCP_SRIC_TXUIC_POS))
#define CCP_SRIC_TXIC                   ((uint32_t)1<<(CCP_SRIC_TXIC_POS))

/* CCPX_DF λ */
#define CCP_DF_CC1DF_POS                (0)
#define CCP_DF_CC2DF_POS                (1)
#define CCP_DF_CC3DF_POS                (2)
#define CCP_DF_CC4DF_POS                (3)
#define CCP_DF_TXTDF_POS                (4)
#define CCP_DF_TXUDF_POS                (5)
#define CCP_DF_CC1DF                    ((uint32_t)1<<(CCP_DF_CC1DF_POS))
#define CCP_DF_CC2DF                    ((uint32_t)1<<(CCP_DF_CC2DF_POS))
#define CCP_DF_CC3DF                    ((uint32_t)1<<(CCP_DF_CC3DF_POS))
#define CCP_DF_CC4DF                    ((uint32_t)1<<(CCP_DF_CC4DF_POS))
#define CCP_DF_TXTDF                    ((uint32_t)1<<(CCP_DF_TXTDF_POS))
#define CCP_DF_TXUDF                    ((uint32_t)1<<(CCP_DF_TXUDF_POS))

/* CCPX_CTL1 λ */
#define CCP_CTL1_CH1M0_POS              (0)
#define CCP_CTL1_CH1M1_POS              (1)
#define CCP_CTL1_CH1M2_POS              (2)
#define CCP_CTL1_CH1M3_POS              (3)
#define CCP_CTL1_CH2M0_POS              (4)
#define CCP_CTL1_CH2M1_POS              (5)
#define CCP_CTL1_CH2M2_POS              (6)
#define CCP_CTL1_CH2M3_POS              (7)
#define CCP_CTL1_CH3M0_POS              (8)
#define CCP_CTL1_CH3M1_POS              (9)
#define CCP_CTL1_CH3M2_POS              (10)
#define CCP_CTL1_CH3M3_POS              (11)
#define CCP_CTL1_CH4M0_POS              (12)
#define CCP_CTL1_CH4M1_POS              (13)
#define CCP_CTL1_CH4M2_POS              (14)
#define CCP_CTL1_CH4M3_POS              (15)
#define CCP_CTL1_CH1M                   ((uint32_t)0xF<<(CCP_CTL1_CH1M0_POS))
#define CCP_CTL1_CH1M0                  ((uint32_t)1<<(CCP_CTL1_CH1M0_POS))
#define CCP_CTL1_CH1M1                  ((uint32_t)1<<(CCP_CTL1_CH1M1_POS))
#define CCP_CTL1_CH1M2                  ((uint32_t)1<<(CCP_CTL1_CH1M2_POS))
#define CCP_CTL1_CH1M3                  ((uint32_t)1<<(CCP_CTL1_CH1M3_POS))
#define CCP_CTL1_CH2M                   ((uint32_t)0xF<<(CCP_CTL1_CH2M0_POS))
#define CCP_CTL1_CH2M0                  ((uint32_t)1<<(CCP_CTL1_CH2M0_POS))
#define CCP_CTL1_CH2M1                  ((uint32_t)1<<(CCP_CTL1_CH2M1_POS))
#define CCP_CTL1_CH2M2                  ((uint32_t)1<<(CCP_CTL1_CH2M2_POS))
#define CCP_CTL1_CH2M3                  ((uint32_t)1<<(CCP_CTL1_CH2M3_POS))
#define CCP_CTL1_CH3M                   ((uint32_t)0xF<<(CCP_CTL1_CH3M0_POS))
#define CCP_CTL1_CH3M0                  ((uint32_t)1<<(CCP_CTL1_CH3M0_POS))
#define CCP_CTL1_CH3M1                  ((uint32_t)1<<(CCP_CTL1_CH3M1_POS))
#define CCP_CTL1_CH3M2                  ((uint32_t)1<<(CCP_CTL1_CH3M2_POS))
#define CCP_CTL1_CH3M3                  ((uint32_t)1<<(CCP_CTL1_CH3M3_POS))
#define CCP_CTL1_CH4M                   ((uint32_t)0xF<<(CCP_CTL1_CH4M0_POS))
#define CCP_CTL1_CH4M0                  ((uint32_t)1<<(CCP_CTL1_CH4M0_POS))
#define CCP_CTL1_CH4M1                  ((uint32_t)1<<(CCP_CTL1_CH4M1_POS))
#define CCP_CTL1_CH4M2                  ((uint32_t)1<<(CCP_CTL1_CH4M2_POS))
#define CCP_CTL1_CH4M3                  ((uint32_t)1<<(CCP_CTL1_CH4M3_POS))

/* CCPX_CTL2 λ */
#define CCP_CTL2_PXOC1_0_POS            (0)
#define CCP_CTL2_PXOC1_1_POS            (1)
#define CCP_CTL2_PXOC2_0_POS            (2)
#define CCP_CTL2_PXOC2_1_POS            (3)
#define CCP_CTL2_PXOC3_0_POS            (4)
#define CCP_CTL2_PXOC3_1_POS            (5)
#define CCP_CTL2_PXOC4_0_POS            (6)
#define CCP_CTL2_PXOC4_1_POS            (7)
#define CCP_CTL2_PXASS0_POS             (10)
#define CCP_CTL2_PXASS1_POS             (11)
#define CCP_CTL2_PXOC1CE_POS            (12)
#define CCP_CTL2_PXOC2CE_POS            (13)
#define CCP_CTL2_PXOC3CE_POS            (14)
#define CCP_CTL2_PXOC4CE_POS            (15)
#define CCP_CTL2_PXOC1                  ((uint32_t)3<<(CCP_CTL2_PXOC1_0_POS))
#define CCP_CTL2_PXOC1_0                ((uint32_t)1<<(CCP_CTL2_PXOC1_0_POS))
#define CCP_CTL2_PXOC1_1                ((uint32_t)1<<(CCP_CTL2_PXOC1_1_POS))
#define CCP_CTL2_PXOC2                  ((uint32_t)3<<(CCP_CTL2_PXOC2_0_POS))
#define CCP_CTL2_PXOC2_0                ((uint32_t)1<<(CCP_CTL2_PXOC2_0_POS))
#define CCP_CTL2_PXOC2_1                ((uint32_t)1<<(CCP_CTL2_PXOC2_1_POS))
#define CCP_CTL2_PXOC3                  ((uint32_t)3<<(CCP_CTL2_PXOC3_0_POS))
#define CCP_CTL2_PXOC3_0                ((uint32_t)1<<(CCP_CTL2_PXOC3_0_POS))
#define CCP_CTL2_PXOC3_1                ((uint32_t)1<<(CCP_CTL2_PXOC3_1_POS))
#define CCP_CTL2_PXOC4                  ((uint32_t)3<<(CCP_CTL2_PXOC4_0_POS))
#define CCP_CTL2_PXOC4_0                ((uint32_t)1<<(CCP_CTL2_PXOC4_0_POS))
#define CCP_CTL2_PXOC4_1                ((uint32_t)1<<(CCP_CTL2_PXOC4_1_POS))
#define CCP_CTL2_PXASS                  ((uint32_t)3<<(CCP_CTL2_PXASS0_POS))
#define CCP_CTL2_PXASS0                 ((uint32_t)1<<(CCP_CTL2_PXASS0_POS))
#define CCP_CTL2_PXASS1                 ((uint32_t)1<<(CCP_CTL2_PXASS1_POS))
#define CCP_CTL2_PXOC1CE                ((uint32_t)1<<(CCP_CTL2_PXOC1CE_POS))
#define CCP_CTL2_PXOC2CE                ((uint32_t)1<<(CCP_CTL2_PXOC2CE_POS))
#define CCP_CTL2_PXOC3CE                ((uint32_t)1<<(CCP_CTL2_PXOC3CE_POS))
#define CCP_CTL2_PXOC4CE                ((uint32_t)1<<(CCP_CTL2_PXOC4CE_POS))

/* CCPX_CTL3 λ */
#define CCP_CTL3_CC1IE_POS              (0)
#define CCP_CTL3_CC2IE_POS              (1)
#define CCP_CTL3_CC3IE_POS              (2)
#define CCP_CTL3_CC4IE_POS              (3)
#define CCP_CTL3_TXTIE_POS              (4)
#define CCP_CTL3_TXUIE_POS              (5)
#define CCP_CTL3_TXUDE_POS              (6)
#define CCP_CTL3_CC1DE_POS              (7)
#define CCP_CTL3_CC2DE_POS              (8)
#define CCP_CTL3_CC3DE_POS              (9)
#define CCP_CTL3_CC4DE_POS              (10)
#define CCP_CTL3_TXTDE_POS              (11)
#define CCP_CTL3_PXSPM_POS              (12)
#define CCP_CTL3_PXXORM_POS             (13)
#define CCP_CTL3_PXPWMI_POS             (14)
#define CCP_CTL3_PXSPMST_POS            (15)
#define CCP_CTL3_CC1IE                  ((uint32_t)1<<(CCP_CTL3_CC1IE_POS))
#define CCP_CTL3_CC2IE                  ((uint32_t)1<<(CCP_CTL3_CC2IE_POS))
#define CCP_CTL3_CC3IE                  ((uint32_t)1<<(CCP_CTL3_CC3IE_POS))
#define CCP_CTL3_CC4IE                  ((uint32_t)1<<(CCP_CTL3_CC4IE_POS))
#define CCP_CTL3_TXTIE                  ((uint32_t)1<<(CCP_CTL3_TXTIE_POS))
#define CCP_CTL3_TXUIE                  ((uint32_t)1<<(CCP_CTL3_TXUIE_POS))
#define CCP_CTL3_TXUDE                  ((uint32_t)1<<(CCP_CTL3_TXUDE_POS))
#define CCP_CTL3_CC1DE                  ((uint32_t)1<<(CCP_CTL3_CC1DE_POS))
#define CCP_CTL3_CC2DE                  ((uint32_t)1<<(CCP_CTL3_CC2DE_POS))
#define CCP_CTL3_CC3DE                  ((uint32_t)1<<(CCP_CTL3_CC3DE_POS))
#define CCP_CTL3_CC4DE                  ((uint32_t)1<<(CCP_CTL3_CC4DE_POS))
#define CCP_CTL3_TXTDE                  ((uint32_t)1<<(CCP_CTL3_TXTDE_POS))
#define CCP_CTL3_PXSPM                  ((uint32_t)1<<(CCP_CTL3_PXSPM_POS))
#define CCP_CTL3_PXXORM                 ((uint32_t)1<<(CCP_CTL3_PXXORM_POS))
#define CCP_CTL3_PXPWMI                 ((uint32_t)1<<(CCP_CTL3_PXPWMI_POS))
#define CCP_CTL3_PXSPMST                ((uint32_t)1<<(CCP_CTL3_PXSPMST_POS))

/* CCPX_EGIF λ */
#define CCP_EGIF_UARTRXEN_POS           (0)
#define CCP_EGIF_CC1G_POS               (1)
#define CCP_EGIF_CC2G_POS               (2)
#define CCP_EGIF_CC3G_POS               (3)
#define CCP_EGIF_CC4G_POS               (4)
#define CCP_EGIF_TXTRG_POS              (5)
#define CCP_EGIF_CC1IF_POS              (6)
#define CCP_EGIF_CC2IF_POS              (7)
#define CCP_EGIF_CC3IF_POS              (8)
#define CCP_EGIF_CC4IF_POS              (9)
#define CCP_EGIF_TXTIF_POS              (10)
#define CCP_EGIF_TXUIF_POS              (11)
#define CCP_EGIF_UARTRXEN               ((uint32_t)1<<(CCP_EGIF_UARTRXEN_POS))
#define CCP_EGIF_CC1G                   ((uint32_t)1<<(CCP_EGIF_CC1G_POS))
#define CCP_EGIF_CC2G                   ((uint32_t)1<<(CCP_EGIF_CC2G_POS))
#define CCP_EGIF_CC3G                   ((uint32_t)1<<(CCP_EGIF_CC3G_POS))
#define CCP_EGIF_CC4G                   ((uint32_t)1<<(CCP_EGIF_CC4G_POS))
#define CCP_EGIF_TXTRG                  ((uint32_t)1<<(CCP_EGIF_TXTRG_POS))
#define CCP_EGIF_CC1IF                  ((uint32_t)1<<(CCP_EGIF_CC1IF_POS))
#define CCP_EGIF_CC2IF                  ((uint32_t)1<<(CCP_EGIF_CC2IF_POS))
#define CCP_EGIF_CC3IF                  ((uint32_t)1<<(CCP_EGIF_CC3IF_POS))
#define CCP_EGIF_CC4IF                  ((uint32_t)1<<(CCP_EGIF_CC4IF_POS))
#define CCP_EGIF_TXTIF                  ((uint32_t)1<<(CCP_EGIF_TXTIF_POS))
#define CCP_EGIF_TXUIF                  ((uint32_t)1<<(CCP_EGIF_TXUIF_POS))
/* ͨöʱ(GPTIM) */

#endif

#if 1										/* ATIM */

/* ----------------------------------------------------------------------------
   -- ߼ʱ(ATIM)
   ---------------------------------------------------------------------------- */

/* ATIM - Ĵڴṹ */
typedef struct ATIM_MemMap
{
    volatile       uint32_t TXCNT;      		/* Tx_CNTĴ, ƫ:0x00 */
    volatile       uint32_t TZCNT;      		/* Tz_CNTĴ, ƫ:0x04 */
    volatile       uint32_t TXPPX;      		/* Tx_PPxڼĴ, ƫ:0x08 */
    volatile       uint32_t TZPPZ;      		/* Tz_PPzڼĴ, ƫ:0x0C */
    volatile       uint32_t TXPRSC;     		/* TxԤƵüĴ, ƫ:0x10 */
    volatile       uint32_t TZPRSC;     		/* TzԤƵüĴ, ƫ:0x14 */
    volatile       uint32_t TXCCR0;     		/* TxADCüĴ0, ƫ:0x18 */
    volatile       uint32_t TXCCR1;     		/* TxADCüĴ1, ƫ:0x1C */
    volatile       uint32_t TZCCR0;     		/* TzADCüĴ0, ƫ:0x20 */
    volatile       uint32_t TXCTL;      		/* TxƼĴ, ƫ:0x24 */
    volatile       uint32_t TZCTL;      		/* TzƼĴ, ƫ:0x28 */
    volatile       uint32_t PXPDCTL;    		/* λüƼĴ, ƫ:0x2C */
    volatile       uint32_t PXASCTL;    		/* ضϿƼĴ, ƫ:0x30 */
    volatile	   uint32_t TXCCTCTL;	    	/* Ƚ㶨ʱ Tx ƼĴ, ƫ:0x34 */
    volatile	   uint32_t TZCCTCTL;    		/* Ƚ㶨ʱ Tz ƼĴ, ƫ:0x38 */
    			   uint32_t RESERVED0;			/* ַ, ƫ:0x3C */
    volatile	   uint32_t COMH1;    			/* ECCPͨ1ϿƼĴH, ƫ:0x40 */
    volatile	   uint32_t COML1;    			/* ECCPͨ1ϿƼĴL, ƫ:0x44 */
    volatile	   uint32_t FAUCTL1;    		/* FaultƼĴ1, ƫ:0x48 */
    volatile	   uint32_t DITCTL;    			/* ƼĴ, ƫ:0x4C */
    volatile	   uint32_t COMH2;    			/* ECCPͨ2ϿƼĴH, ƫ:0x50 */
    volatile	   uint32_t COML2;    			/* ECCPͨ2ϿƼĴL, ƫ:0x54 */
    volatile	   uint32_t FAUCTL2;    		/* FaultƼĴ2, ƫ:0x58 */
    volatile	   uint32_t CCRCTL;    			/* Tx/zADƼĴ, ƫ:0x5C */
    volatile	   uint32_t COMH3;    			/* ECCPͨ3ϿƼĴH, ƫ:0x60 */
    volatile	   uint32_t COML3;    			/* ECCPͨ3ϿƼĴL, ƫ:0x64 */
    volatile	   uint32_t FAUCTL3;    		/* FaultƼĴ3, ƫ:0x68 */
    			   uint32_t RESERVED1;			/* ַ, ƫ:0x6C */
    volatile	   uint32_t COMH4;    			/* ECCPͨ4ϿƼĴH, ƫ:0x70 */
    volatile	   uint32_t COML4;    			/* ECCPͨ4ϿƼĴL, ƫ:0x74 */
    volatile	   uint32_t FAUCTL4;    		/* FaultƼĴ4, ƫ:0x78 */
    			   uint32_t RESERVED2; 			/* ַ, ƫ:0x7C */
    volatile       uint32_t ECCPXCTL1;  		/* ECCPƼĴ1, ƫ:0x80 */
    volatile       uint32_t ECCPXR1;    		/* ECCPȽ/PWMĴ1, ƫ:0x84 */
    volatile       uint32_t ECCPXR2;    		/* ECCPȽ/PWMĴ2, ƫ:0x88 */
    volatile       uint32_t ECCPXR3;    		/* ECCPȽ/PWMĴ3, ƫ:0x8C */
    volatile       uint32_t ECCPXR4;    		/* ECCPȽ/PWMĴ4, ƫ:0x90 */
    volatile       uint32_t PXUDCTL;    		/* ECCP¿ƼĴ, ƫ:0x94 */
    volatile       uint32_t ECCPXCTL2;  		/* ECCPƼĴ2, ƫ:0x98 */
    volatile       uint32_t PXDTCTL;    		/* ECCPƼĴ, ƫ:0x9C */
    volatile       uint32_t PWMXOC;     		/* ECCP PWMxƼĴ, ƫ:0xA0 */
    volatile       uint32_t PXATRCTL;   		/* ECCP PWMxüĴ, ƫ:0xA4 */
    volatile       uint32_t PXASCTL0;   		/* ECCP PWMxضϿƼĴ0, ƫ:0xA8 */
    volatile       uint32_t PXASCTL1;   		/* ECCP PWMxضϿƼĴ1, ƫ:0xAC */
    volatile       uint32_t ZPDCTL0;    		/* ECCPƼĴ0, ƫ:0xB0 */
    volatile       uint32_t ZPDCTL1;    		/* ECCPƼĴ1, ƫ:0xB4 */
    volatile       uint32_t ZPDPORT;    		/* ECCP˿ڿƼĴ, ƫ:0xB8 */
    volatile       uint32_t ECCPXIE;    		/* ECCPжʹܼĴ, ƫ:0xBC */
    volatile       uint32_t ECCPXEGIF;  		/* ECCPж״̬Ĵ, ƫ:0xC0 */
    volatile       uint32_t TXUDTIM;    		/* Tx¼, ƫ:0xC4 */
    volatile       uint32_t TZUDTIM;    		/* Tz¼, ƫ:0xC8 */
    volatile const uint32_t ECCPXDF;    		/* DMAжϱ־Ĵ, ƫ:0xCC */
    volatile const uint32_t ECCPXC1;    		/* ׽Ĵ1, ƫ:0xD0 */
    volatile const uint32_t ECCPXC2;    		/* ׽Ĵ2, ƫ:0xD4 */
    volatile const uint32_t ECCPXC3;    		/* ׽Ĵ3, ƫ:0xD8 */
    volatile const uint32_t ECCPXC4;    		/* ׽Ĵ4, ƫ:0xDC */
                   uint32_t RESERVED3;  		/* ַ, ƫ:0xE0 */
    volatile       uint32_t ECCPXDE;    		/* DMAжʹܼĴ, ƫ:0xE4 */
    volatile       uint32_t ECCPXSRIC;  		/* ECCPжĴ, ƫ:0xE8 */
    volatile       uint32_t ECCPXCTL3;  		/* ECCPƼĴ3, ƫ:0xEC */
}ATIM_SFRmap, ECCP_SFRmap; /* T5 / T6 */


/* ----------------------------------------------------------------------------
   -- ATIM - Ĵں
   ---------------------------------------------------------------------------- */

/* ATIM - Ĵڵַ */
#define T5_ADDR                         ((uint32_t)0x40000300)
#define T6_ADDR                         ((uint32_t)0x40000300)
#define T5_SFR                          ((ATIM_SFRmap *) T5_ADDR)
#define T6_SFR                          ((ATIM_SFRmap *) T6_ADDR)
#define ECCP5_ADDR                      T5_ADDR
#define ECCP6_ADDR                      T6_ADDR
#define ECCP5_SFR                       ((ECCP_SFRmap *) ECCP5_ADDR)
#define ECCP6_SFR                       ((ECCP_SFRmap *) ECCP6_ADDR)

/* ATIM - Ĵ */
#define T5_CNT                          (T5_SFR->TXCNT)
#define T6_CNT                          (T6_SFR->TZCNT)
#define T5_PPX                          (T5_SFR->TXPPX)
#define T6_PPZ                          (T6_SFR->TZPPZ)
#define T5_PRSC                         (T5_SFR->TXPRSC)
#define T6_PRSC                         (T6_SFR->TZPRSC)
#define T5_CCR0                         (T5_SFR->TXCCR0)
#define T5_CCR1                         (T5_SFR->TXCCR1)
#define T6_CCR0                         (T6_SFR->TZCCR0)
#define T5_CTL                          (T5_SFR->TXCTL)
#define T6_CTL                          (T6_SFR->TZCTL)
#define ECCP5_PDCTL						(T5_SFR->PXPDCTL)
#define ECCP5_PXASCTL					(T5_SFR->PXASCTL)
#define T5_CCTCTL                		(T5_SFR->TXCCTCTL)
#define T6_CCTCTL                		(T6_SFR->TZCCTCTL)
#define ECCP5_COMH1                		(T5_SFR->COMH1)
#define ECCP5_COML1                		(T5_SFR->COML1)
#define ECCP5_FAUCTL1                	(T5_SFR->FAUCTL1)
#define ECCP5_DITCTL                	(T5_SFR->DITCTL)
#define ECCP5_COMH2                		(T5_SFR->COMH2)
#define ECCP5_COML2                		(T5_SFR->COML2)
#define ECCP5_FAUCTL2                	(T5_SFR->FAUCTL2)
#define ECCP5_CCRCTL                	(T5_SFR->CCRCTL)
#define ECCP5_COMH3                		(T5_SFR->COMH3)
#define ECCP5_COML3                		(T5_SFR->COML3)
#define ECCP5_FAUCTL3                	(T5_SFR->FAUCTL3)
#define ECCP5_COMH4                		(T5_SFR->COMH4)
#define ECCP5_COML4                		(T5_SFR->COML4)
#define ECCP5_FAUCTL4                	(T5_SFR->FAUCTL4)
#define ECCP5_CTL1                      (T5_SFR->ECCPXCTL1)
#define ECCP5_R1                        (T5_SFR->ECCPXR1)
#define ECCP5_R2                        (T5_SFR->ECCPXR2)
#define ECCP5_R3                        (T5_SFR->ECCPXR3)
#define ECCP5_R4                        (T5_SFR->ECCPXR4)
#define ECCP5_PXUDCTL                   (T5_SFR->PXUDCTL)
#define ECCP5_CTL2                      (T5_SFR->ECCPXCTL2)
#define ECCP5_PXDTCTL                   (T5_SFR->PXDTCTL)
#define ECCP5_PWMXOC                    (T5_SFR->PWMXOC)
#define ECCP5_PXATRCTL                  (T5_SFR->PXATRCTL)
#define ECCP5_PXASCTL0                  (T5_SFR->PXASCTL0)
#define ECCP5_PXASCTL1                  (T5_SFR->PXASCTL1)
#define ECCP5_ZPDCTL0                   (T5_SFR->ZPDCTL0)
#define ECCP5_ZPDCTL1                   (T5_SFR->ZPDCTL1)
#define ECCP5_ZPDPORT                   (T5_SFR->ZPDPORT)
#define ECCP5_IE                        (T5_SFR->ECCPXIE)
#define ECCP5_EGIF                      (T5_SFR->ECCPXEGIF)
#define T5_UDTIM                        (T5_SFR->TXUDTIM)
#define T6_UDTIM                        (T6_SFR->TZUDTIM)
#define ECCP5_DF                        (T5_SFR->ECCPXDF)
#define ECCP5_C1                        (T5_SFR->ECCPXC1)
#define ECCP5_C2                        (T5_SFR->ECCPXC2)
#define ECCP5_C3                        (T5_SFR->ECCPXC3)
#define ECCP5_C4                        (T5_SFR->ECCPXC4)
#define ECCP5_DE                        (T5_SFR->ECCPXDE)
#define ECCP5_SRIC                      (T5_SFR->ECCPXSRIC)
#define ECCP5_CTL3                      (T5_SFR->ECCPXCTL3)

/* TX_CNT λ */
#define ATIM_TXCNT_TXCNT0_POS           (0)
#define ATIM_TXCNT_TXCNT                ((uint32_t)0xFFFF<<(ATIM_TXCNT_TXCNT0_POS))

/* TZ_CNT λ */
#define ATIM_TZCNT_TZCNT0_POS           (0)
#define ATIM_TZCNT_TZCNT                ((uint32_t)0xFFFF<<(ATIM_TZCNT_TZCNT0_POS))

/* TX_PPX λ */
#define ATIM_TXPPX_TXPPX0_POS           (0)
#define ATIM_TXPPX_TXPPX                ((uint32_t)0xFFFF<<(ATIM_TXPPX_TXPPX0_POS))

/* TZ_PPX λ */
#define ATIM_TZPPZ_TZPPZ0_POS           (0)
#define ATIM_TZPPZ_TZPPZ                ((uint32_t)0xFFFF<<(ATIM_TZPPZ_TZPPZ0_POS))

/* TX_PRSC λ */
#define ATIM_TXPRSC_TXCKS0_POS          (0)
#define ATIM_TXPRSC_TXCKS               ((uint32_t)0xFFFF<<(ATIM_TXPRSC_TXCKS0_POS))

/* TZ_PRSC λ */
#define ATIM_TZPRSC_TZCKS0_POS          (0)
#define ATIM_TZPRSC_TZCKS               ((uint32_t)0xFFFF<<(ATIM_TZPRSC_TZCKS0_POS))

/* TX_CCR0 λ */
#define ATIM_TXCCR0_TXCCR0_0_POS        (0)
#define ATIM_TXCCR0_TXCCR0              ((uint32_t)0xFFFF<<(ATIM_TXCCR0_TXCCR0_0_POS))

/* TX_CCR1 λ */
#define ATIM_TXCCR1_TXCCR1_0_POS        (0)
#define ATIM_TXCCR1_TXCCR1              ((uint32_t)0xFFFF<<(ATIM_TXCCR1_TXCCR1_0_POS))

/* TZ_CCR0 λ */
#define ATIM_TZCCR0_TZCCR0_0_POS        (0)
#define ATIM_TZCCR0_TZCCR0              ((uint32_t)0xFFFF<<(ATIM_TZCCR0_TZCCR0_0_POS))

/* TX_CTL λ */
#define ATIM_TXCTL_TXCS_POS             (0)
#define ATIM_TXCTL_TXSY_POS             (1)
#define ATIM_TXCTL_TXEN_POS             (2)
#define ATIM_TXCTL_TXCKBS0_POS          (3)
#define ATIM_TXCTL_TXCKBS1_POS          (4)
#define ATIM_TXCTL_TXCKBS2_POS          (5)
#define ATIM_TXCTL_TXCKBS3_POS          (6)
#define ATIM_TXCTL_TXDIR_POS            (7)
#define ATIM_TXCTL_TXCLK0_POS           (8)
#define ATIM_TXCTL_TXCLK1_POS           (9)
#define ATIM_TXCTL_TXADAUTO_POS         (10)
#define ATIM_TXCTL_TXOFS0_POS           (11)
#define ATIM_TXCTL_TXOFS1_POS           (12)
#define ATIM_TXCTL_TXCMS0_POS           (13)
#define ATIM_TXCTL_TXCMS1_POS           (14)
#define ATIM_TXCTL_TXCMS2_POS           (15)
#define ATIM_TXCTL_TXCS                 ((uint32_t)1<<(ATIM_TXCTL_TXCS_POS))
#define ATIM_TXCTL_TXSY                 ((uint32_t)1<<(ATIM_TXCTL_TXSY_POS))
#define ATIM_TXCTL_TXEN                 ((uint32_t)1<<(ATIM_TXCTL_TXEN_POS))
#define ATIM_TXCTL_TXCKBS               ((uint32_t)0xF<<(ATIM_TXCTL_TXCKBS0_POS))
#define ATIM_TXCTL_TXCKBS0              ((uint32_t)1<<(ATIM_TXCTL_TXCKBS0_POS))
#define ATIM_TXCTL_TXCKBS1              ((uint32_t)1<<(ATIM_TXCTL_TXCKBS1_POS))
#define ATIM_TXCTL_TXCKBS2              ((uint32_t)1<<(ATIM_TXCTL_TXCKBS2_POS))
#define ATIM_TXCTL_TXCKBS3              ((uint32_t)1<<(ATIM_TXCTL_TXCKBS3_POS))
#define ATIM_TXCTL_TXDIR                ((uint32_t)1<<(ATIM_TXCTL_TXDIR_POS))
#define ATIM_TXCTL_TXCLK                ((uint32_t)3<<(ATIM_TXCTL_TXCLK0_POS))
#define ATIM_TXCTL_TXCLK0               ((uint32_t)1<<(ATIM_TXCTL_TXCLK0_POS))
#define ATIM_TXCTL_TXCLK1               ((uint32_t)1<<(ATIM_TXCTL_TXCLK1_POS))
#define ATIM_TXCTL_TXADAUTO             ((uint32_t)1<<(ATIM_TXCTL_TXADAUTO_POS))
#define ATIM_TXCTL_TXOFS                ((uint32_t)3<<(ATIM_TXCTL_TXOFS0_POS))
#define ATIM_TXCTL_TXOFS0               ((uint32_t)1<<(ATIM_TXCTL_TXOFS0_POS))
#define ATIM_TXCTL_TXOFS1               ((uint32_t)1<<(ATIM_TXCTL_TXOFS1_POS))
#define ATIM_TXCTL_TXCMS                ((uint32_t)7<<(ATIM_TXCTL_TXCMS0_POS))
#define ATIM_TXCTL_TXCMS0               ((uint32_t)1<<(ATIM_TXCTL_TXCMS0_POS))
#define ATIM_TXCTL_TXCMS1               ((uint32_t)1<<(ATIM_TXCTL_TXCMS1_POS))
#define ATIM_TXCTL_TXCMS2               ((uint32_t)1<<(ATIM_TXCTL_TXCMS2_POS))

/* TZ_CTL λ */
#define ATIM_TZCTL_TZCS_POS             (0)
#define ATIM_TZCTL_TZSY_POS             (1)
#define ATIM_TZCTL_TZEN_POS             (2)
#define ATIM_TZCTL_TZCKBS0_POS          (3)
#define ATIM_TZCTL_TZCKBS1_POS          (4)
#define ATIM_TZCTL_TZCKBS2_POS          (5)
#define ATIM_TZCTL_TZCKBS3_POS          (6)
#define ATIM_TZCTL_TZDIR_POS            (7)
#define ATIM_TZCTL_TZCLK0_POS           (8)
#define ATIM_TZCTL_TZCLK1_POS           (9)
#define ATIM_TZCTL_TZADAUTO_POS         (10)
#define ATIM_TZCTL_TZOFS0_POS           (11)
#define ATIM_TZCTL_TZOFS1_POS           (12)
#define ATIM_TZCTL_TZCMS0_POS           (13)
#define ATIM_TZCTL_TZCMS1_POS           (14)
#define ATIM_TZCTL_TZCMS2_POS           (15)
#define ATIM_TZCTL_TZCS                 ((uint32_t)1<<(ATIM_TZCTL_TZCS_POS))
#define ATIM_TZCTL_TZSY                 ((uint32_t)1<<(ATIM_TZCTL_TZSY_POS))
#define ATIM_TZCTL_TZEN                 ((uint32_t)1<<(ATIM_TZCTL_TZEN_POS))
#define ATIM_TZCTL_TZCKBS               ((uint32_t)0xF<<(ATIM_TZCTL_TZCKBS0_POS))
#define ATIM_TZCTL_TZCKBS0              ((uint32_t)1<<(ATIM_TZCTL_TZCKBS0_POS))
#define ATIM_TZCTL_TZCKBS1              ((uint32_t)1<<(ATIM_TZCTL_TZCKBS1_POS))
#define ATIM_TZCTL_TZCKBS2              ((uint32_t)1<<(ATIM_TZCTL_TZCKBS2_POS))
#define ATIM_TZCTL_TZCKBS3              ((uint32_t)1<<(ATIM_TZCTL_TZCKBS3_POS))
#define ATIM_TZCTL_TZDIR                ((uint32_t)1<<(ATIM_TZCTL_TZDIR_POS))
#define ATIM_TZCTL_TZCLK                ((uint32_t)3<<(ATIM_TZCTL_TZCLK0_POS))
#define ATIM_TZCTL_TZCLK0               ((uint32_t)1<<(ATIM_TZCTL_TZCLK0_POS))
#define ATIM_TZCTL_TZCLK1               ((uint32_t)1<<(ATIM_TZCTL_TZCLK1_POS))
#define ATIM_TZCTL_TZADAUTO             ((uint32_t)1<<(ATIM_TZCTL_TZADAUTO_POS))
#define ATIM_TZCTL_TZOFS                ((uint32_t)3<<(ATIM_TZCTL_TZOFS0_POS))
#define ATIM_TZCTL_TZOFS0               ((uint32_t)1<<(ATIM_TZCTL_TZOFS0_POS))
#define ATIM_TZCTL_TZOFS1               ((uint32_t)1<<(ATIM_TZCTL_TZOFS1_POS))
#define ATIM_TZCTL_TZCMS                ((uint32_t)7<<(ATIM_TZCTL_TZCMS0_POS))
#define ATIM_TZCTL_TZCMS0               ((uint32_t)1<<(ATIM_TZCTL_TZCMS0_POS))
#define ATIM_TZCTL_TZCMS1               ((uint32_t)1<<(ATIM_TZCTL_TZCMS1_POS))
#define ATIM_TZCTL_TZCMS2               ((uint32_t)1<<(ATIM_TZCTL_TZCMS2_POS))

/* TX_CCTCTL λ */
#define ATIM_TXCCTCTL_CCTEN_POS			(0)
#define ATIM_TXCCTCTL_CRSET_POS			(1)
#define ATIM_TXCCTCTL_CCTSEL0_POS		(2)
#define ATIM_TXCCTCTL_CCTSEL1_POS		(3)
#define ATIM_TXCCTCTL_CCTEN				((uint32_t)1<<(ATIM_TXCCTCTL_CCTEN_POS))
#define ATIM_TXCCTCTL_CRSET				((uint32_t)1<<(ATIM_TXCCTCTL_CRSET_POS))
#define ATIM_TXCCTCTL_CCTSEL			((uint32_t)0x03<<(ATIM_TXCCTCTL_CCTSEL0_POS))
#define ATIM_TXCCTCTL_CCTSEL0			((uint32_t)1<<(ATIM_TXCCTCTL_CCTSEL0_POS))
#define ATIM_TXCCTCTL_CCTSEL1			((uint32_t)1<<(ATIM_TXCCTCTL_CCTSEL1_POS))

/* TZ_CCTCTL λ */
#define ATIM_TZCCTCTL_CCTEN_POS			(0)
#define ATIM_TZCCTCTL_CRSET_POS			(1)
#define ATIM_TZCCTCTL_CCTSEL0_POS		(2)
#define ATIM_TZCCTCTL_CCTSEL1_POS		(3)
#define ATIM_TZCCTCTL_CCTEN				((uint32_t)1<<(ATIM_TZCCTCTL_CCTEN_POS))
#define ATIM_TZCCTCTL_CRSET				((uint32_t)1<<(ATIM_TZCCTCTL_CRSET_POS))
#define ATIM_TZCCTCTL_CCTSEL			((uint32_t)0x03<<(ATIM_TZCCTCTL_CCTSEL0_POS))
#define ATIM_TZCCTCTL_CCTSEL0			((uint32_t)1<<(ATIM_TZCCTCTL_CCTSEL0_POS))
#define ATIM_TZCCTCTL_CCTSEL1			((uint32_t)1<<(ATIM_TZCCTCTL_CCTSEL1_POS))

/* ECCPX_CTL1 λ */
#define ECCP_CTL1_CH1M0_POS             (0)
#define ECCP_CTL1_CH1M1_POS             (1)
#define ECCP_CTL1_CH1M2_POS             (2)
#define ECCP_CTL1_CH1M3_POS             (3)
#define ECCP_CTL1_CH2M0_POS             (4)
#define ECCP_CTL1_CH2M1_POS             (5)
#define ECCP_CTL1_CH2M2_POS             (6)
#define ECCP_CTL1_CH2M3_POS             (7)
#define ECCP_CTL1_CH3M0_POS             (8)
#define ECCP_CTL1_CH3M1_POS             (9)
#define ECCP_CTL1_CH3M2_POS             (10)
#define ECCP_CTL1_CH3M3_POS             (11)
#define ECCP_CTL1_CH4M0_POS             (12)
#define ECCP_CTL1_CH4M1_POS             (13)
#define ECCP_CTL1_CH4M2_POS             (14)
#define ECCP_CTL1_CH4M3_POS             (15)
#define ECCP_CTL1_CH1M                  ((uint32_t)0xF<<(ECCP_CTL1_CH1M0_POS))
#define ECCP_CTL1_CH1M0                 ((uint32_t)1<<(ECCP_CTL1_CH1M0_POS))
#define ECCP_CTL1_CH1M1                 ((uint32_t)1<<(ECCP_CTL1_CH1M1_POS))
#define ECCP_CTL1_CH1M2                 ((uint32_t)1<<(ECCP_CTL1_CH1M2_POS))
#define ECCP_CTL1_CH1M3                 ((uint32_t)1<<(ECCP_CTL1_CH1M3_POS))
#define ECCP_CTL1_CH2M                  ((uint32_t)0xF<<(ECCP_CTL1_CH2M0_POS))
#define ECCP_CTL1_CH2M0                 ((uint32_t)1<<(ECCP_CTL1_CH2M0_POS))
#define ECCP_CTL1_CH2M1                 ((uint32_t)1<<(ECCP_CTL1_CH2M1_POS))
#define ECCP_CTL1_CH2M2                 ((uint32_t)1<<(ECCP_CTL1_CH2M2_POS))
#define ECCP_CTL1_CH2M3                 ((uint32_t)1<<(ECCP_CTL1_CH2M3_POS))
#define ECCP_CTL1_CH3M                  ((uint32_t)0xF<<(ECCP_CTL1_CH3M0_POS))
#define ECCP_CTL1_CH3M0                 ((uint32_t)1<<(ECCP_CTL1_CH3M0_POS))
#define ECCP_CTL1_CH3M1                 ((uint32_t)1<<(ECCP_CTL1_CH3M1_POS))
#define ECCP_CTL1_CH3M2                 ((uint32_t)1<<(ECCP_CTL1_CH3M2_POS))
#define ECCP_CTL1_CH3M3                 ((uint32_t)1<<(ECCP_CTL1_CH3M3_POS))
#define ECCP_CTL1_CH4M                  ((uint32_t)0xF<<(ECCP_CTL1_CH4M0_POS))
#define ECCP_CTL1_CH4M0                 ((uint32_t)1<<(ECCP_CTL1_CH4M0_POS))
#define ECCP_CTL1_CH4M1                 ((uint32_t)1<<(ECCP_CTL1_CH4M1_POS))
#define ECCP_CTL1_CH4M2                 ((uint32_t)1<<(ECCP_CTL1_CH4M2_POS))
#define ECCP_CTL1_CH4M3                 ((uint32_t)1<<(ECCP_CTL1_CH4M3_POS))

/* ECCPX_Ry λ */
#define ECCP_R1_ECCPXR1_0_POS           (0)
#define ECCP_R1_ECCPXR1                 ((uint32_t)0xFFFF<<(ECCP_R1_ECCPXR1_0_POS))

/* ECCPX_PXUDCTL λ */
#define ECCP_PXUDCTL_PXUDEN0_POS        (0)
#define ECCP_PXUDCTL_PXUDEN1_POS        (1)
#define ECCP_PXUDCTL_PXUDEVT0_POS       (2)
#define ECCP_PXUDCTL_PXUDEVT1_POS       (3)
#define ECCP_PXUDCTL_PXUDEVT2_POS       (4)
#define ECCP_PXUDCTL_PXUDEVT3_POS       (5)
#define ECCP_PXUDCTL_PXMPEN_POS         (6)
#define ECCP_PXUDCTL_TXUDR_POS			(7)
#define ECCP_PXUDCTL_TXIFUDREN_POS		(8)
#define ECCP_PXUDCTL_TZUDR_POS			(9)
#define ECCP_PXUDCTL_TZIFUDREN_POS		(10)
#define ECCP_PXUDCTL_PXUDEN             ((uint32_t)3<<(ECCP_PXUDCTL_PXUDEN0_POS))
#define ECCP_PXUDCTL_PXUDEN0            ((uint32_t)1<<(ECCP_PXUDCTL_PXUDEN0_POS))
#define ECCP_PXUDCTL_PXUDEN1            ((uint32_t)1<<(ECCP_PXUDCTL_PXUDEN1_POS))
#define ECCP_PXUDCTL_PXUDEVT            ((uint32_t)0xF<<(ECCP_PXUDCTL_PXUDEVT0_POS))
#define ECCP_PXUDCTL_PXUDEVT0           ((uint32_t)1<<(ECCP_PXUDCTL_PXUDEVT0_POS))
#define ECCP_PXUDCTL_PXUDEVT1           ((uint32_t)1<<(ECCP_PXUDCTL_PXUDEVT1_POS))
#define ECCP_PXUDCTL_PXUDEVT2           ((uint32_t)1<<(ECCP_PXUDCTL_PXUDEVT2_POS))
#define ECCP_PXUDCTL_PXUDEVT3           ((uint32_t)1<<(ECCP_PXUDCTL_PXUDEVT3_POS))
#define ECCP_PXUDCTL_PXMPEN             ((uint32_t)1<<(ECCP_PXUDCTL_PXMPEN_POS))
#define ECCP_PXUDCTL_TXUDR				((uint32_t)1<<(ECCP_PXUDCTL_TXUDR_POS))
#define ECCP_PXUDCTL_TXIFUDREN			((uint32_t)1<<(ECCP_PXUDCTL_TXIFUDREN_POS))
#define ECCP_PXUDCTL_TZUDR				((uint32_t)1<<(ECCP_PXUDCTL_TZUDR_POS))
#define ECCP_PXUDCTL_TZIFUDREN			((uint32_t)1<<(ECCP_PXUDCTL_TZIFUDREN_POS))

/* ECCPX_CTL2 λ */
#define ECCP_CTL2_TXMMS0_POS            (0)
#define ECCP_CTL2_TXMMS1_POS            (1)
#define ECCP_CTL2_TXMMS2_POS            (2)
#define ECCP_CTL2_TXSMS0_POS            (3)
#define ECCP_CTL2_TXSMS1_POS            (4)
#define ECCP_CTL2_TXSMS2_POS            (5)
#define ECCP_CTL2_TXTS0_POS             (6)
#define ECCP_CTL2_TXTS1_POS             (7)
#define ECCP_CTL2_TXTS2_POS             (8)
#define ECCP_CTL2_TXMSSYNC_POS          (9)
#define ECCP_CTL2_PXSPM_POS             (10)
#define ECCP_CTL2_PXXORM_POS            (11)
#define ECCP_CTL2_PXPWMI_POS            (12)
#define ECCP_CTL2_TZSMS0_POS            (13)
#define ECCP_CTL2_TZSMS1_POS            (14)
#define ECCP_CTL2_TZSMS2_POS            (15)
#define ECCP_CTL2_TXMMS                 ((uint32_t)7<<(ECCP_CTL2_TXMMS0_POS))
#define ECCP_CTL2_TXMMS0                ((uint32_t)1<<(ECCP_CTL2_TXMMS0_POS))
#define ECCP_CTL2_TXMMS1                ((uint32_t)1<<(ECCP_CTL2_TXMMS1_POS))
#define ECCP_CTL2_TXMMS2                ((uint32_t)1<<(ECCP_CTL2_TXMMS2_POS))
#define ECCP_CTL2_TXSMS                 ((uint32_t)7<<(ECCP_CTL2_TXSMS0_POS))
#define ECCP_CTL2_TXSMS0                ((uint32_t)1<<(ECCP_CTL2_TXSMS0_POS))
#define ECCP_CTL2_TXSMS1                ((uint32_t)1<<(ECCP_CTL2_TXSMS1_POS))
#define ECCP_CTL2_TXSMS2                ((uint32_t)1<<(ECCP_CTL2_TXSMS2_POS))
#define ECCP_CTL2_TXTS                  ((uint32_t)7<<(ECCP_CTL2_TXTS0_POS))
#define ECCP_CTL2_TXTS0                 ((uint32_t)1<<(ECCP_CTL2_TXTS0_POS))
#define ECCP_CTL2_TXTS1                 ((uint32_t)1<<(ECCP_CTL2_TXTS1_POS))
#define ECCP_CTL2_TXTS2                 ((uint32_t)1<<(ECCP_CTL2_TXTS2_POS))
#define ECCP_CTL2_TXMSSYNC              ((uint32_t)1<<(ECCP_CTL2_TXMSSYNC_POS))
#define ECCP_CTL2_PXSPM                 ((uint32_t)1<<(ECCP_CTL2_PXSPM_POS))
#define ECCP_CTL2_PXXORM                ((uint32_t)1<<(ECCP_CTL2_PXXORM_POS))
#define ECCP_CTL2_PXPWMI                ((uint32_t)1<<(ECCP_CTL2_PXPWMI_POS))
#define ECCP_CTL2_TZSMS                 ((uint32_t)7<<(ECCP_CTL2_TZSMS0_POS))
#define ECCP_CTL2_TZSMS0                ((uint32_t)1<<(ECCP_CTL2_TZSMS0_POS))
#define ECCP_CTL2_TZSMS1                ((uint32_t)1<<(ECCP_CTL2_TZSMS1_POS))
#define ECCP_CTL2_TZSMS2                ((uint32_t)1<<(ECCP_CTL2_TZSMS2_POS))

/* ECCPX_PXDTCTL λ */
#define ECCP_PXDTCTL_PXDC0_POS          (0)
#define ECCP_PXDTCTL_PZDC0_POS          (8)
#define ECCP_PXDTCTL_PXDC               ((uint32_t)0xFF<<(ECCP_PXDTCTL_PXDC0_POS))
#define ECCP_PXDTCTL_PZDC               ((uint32_t)0xFF<<(ECCP_PXDTCTL_PZDC0_POS))

/* ECCPX_PWMXOC λ */
#define ECCP_PWMXOC_PXOC1L0_POS         (0)
#define ECCP_PWMXOC_PXOC1L1_POS         (1)
#define ECCP_PWMXOC_PXOC1H0_POS         (2)
#define ECCP_PWMXOC_PXOC1H1_POS         (3)
#define ECCP_PWMXOC_PXOC2L0_POS         (4)
#define ECCP_PWMXOC_PXOC2L1_POS         (5)
#define ECCP_PWMXOC_PXOC2H0_POS         (6)
#define ECCP_PWMXOC_PXOC2H1_POS         (7)
#define ECCP_PWMXOC_PXOC3L0_POS         (8)
#define ECCP_PWMXOC_PXOC3L1_POS         (9)
#define ECCP_PWMXOC_PXOC3H0_POS         (10)
#define ECCP_PWMXOC_PXOC3H1_POS         (11)
#define ECCP_PWMXOC_PXOC4L0_POS         (12)
#define ECCP_PWMXOC_PXOC4L1_POS         (13)
#define ECCP_PWMXOC_PXOC4H0_POS         (14)
#define ECCP_PWMXOC_PXOC4H1_POS         (15)
#define ECCP_PWMXOC_PXOC1L              ((uint32_t)3<<(ECCP_PWMXOC_PXOC1L0_POS))
#define ECCP_PWMXOC_PXOC1L0             ((uint32_t)1<<(ECCP_PWMXOC_PXOC1L0_POS))
#define ECCP_PWMXOC_PXOC1L1             ((uint32_t)1<<(ECCP_PWMXOC_PXOC1L1_POS))
#define ECCP_PWMXOC_PXOC1H              ((uint32_t)3<<(ECCP_PWMXOC_PXOC1H0_POS))
#define ECCP_PWMXOC_PXOC1H0             ((uint32_t)1<<(ECCP_PWMXOC_PXOC1H0_POS))
#define ECCP_PWMXOC_PXOC1H1             ((uint32_t)1<<(ECCP_PWMXOC_PXOC1H1_POS))
#define ECCP_PWMXOC_PXOC2L              ((uint32_t)3<<(ECCP_PWMXOC_PXOC2L0_POS))
#define ECCP_PWMXOC_PXOC2L0             ((uint32_t)1<<(ECCP_PWMXOC_PXOC2L0_POS))
#define ECCP_PWMXOC_PXOC2L1             ((uint32_t)1<<(ECCP_PWMXOC_PXOC2L1_POS))
#define ECCP_PWMXOC_PXOC2H              ((uint32_t)3<<(ECCP_PWMXOC_PXOC2H0_POS))
#define ECCP_PWMXOC_PXOC2H0             ((uint32_t)1<<(ECCP_PWMXOC_PXOC2H0_POS))
#define ECCP_PWMXOC_PXOC2H1             ((uint32_t)1<<(ECCP_PWMXOC_PXOC2H1_POS))
#define ECCP_PWMXOC_PXOC3L              ((uint32_t)3<<(ECCP_PWMXOC_PXOC3L0_POS))
#define ECCP_PWMXOC_PXOC3L0             ((uint32_t)1<<(ECCP_PWMXOC_PXOC3L0_POS))
#define ECCP_PWMXOC_PXOC3L1             ((uint32_t)1<<(ECCP_PWMXOC_PXOC3L1_POS))
#define ECCP_PWMXOC_PXOC3H              ((uint32_t)3<<(ECCP_PWMXOC_PXOC3H0_POS))
#define ECCP_PWMXOC_PXOC3H0             ((uint32_t)1<<(ECCP_PWMXOC_PXOC3H0_POS))
#define ECCP_PWMXOC_PXOC3H1             ((uint32_t)1<<(ECCP_PWMXOC_PXOC3H1_POS))
#define ECCP_PWMXOC_PXOC4L              ((uint32_t)3<<(ECCP_PWMXOC_PXOC4L0_POS))
#define ECCP_PWMXOC_PXOC4L0             ((uint32_t)1<<(ECCP_PWMXOC_PXOC4L0_POS))
#define ECCP_PWMXOC_PXOC4L1             ((uint32_t)1<<(ECCP_PWMXOC_PXOC4L1_POS))
#define ECCP_PWMXOC_PXOC4H              ((uint32_t)3<<(ECCP_PWMXOC_PXOC4H0_POS))
#define ECCP_PWMXOC_PXOC4H0             ((uint32_t)1<<(ECCP_PWMXOC_PXOC4H0_POS))
#define ECCP_PWMXOC_PXOC4H1             ((uint32_t)1<<(ECCP_PWMXOC_PXOC4H1_POS))

/* ECCPX_PXATRCTL λ */
#define ECCP_PXATRCTL_PXCH1MOD_POS      (8)
#define ECCP_PXATRCTL_PXCH2MOD_POS      (9)
#define ECCP_PXATRCTL_PXCH3MOD_POS      (10)
#define ECCP_PXATRCTL_PXCH4MOD_POS      (11)
#define ECCP_PXATRCTL_PXCH1MOD          ((uint32_t)1<<(ECCP_PXATRCTL_PXCH1MOD_POS))
#define ECCP_PXATRCTL_PXCH2MOD          ((uint32_t)1<<(ECCP_PXATRCTL_PXCH2MOD_POS))
#define ECCP_PXATRCTL_PXCH3MOD          ((uint32_t)1<<(ECCP_PXATRCTL_PXCH3MOD_POS))
#define ECCP_PXATRCTL_PXCH4MOD          ((uint32_t)1<<(ECCP_PXATRCTL_PXCH4MOD_POS))


/* ECCPX_PXASCTL0 λ */
#define ECCP_PXASCTL0_PXASS1_0_POS      (0)
#define ECCP_PXASCTL0_PXASS1_1_POS      (1)
#define ECCP_PXASCTL0_PXASS2_0_POS      (2)
#define ECCP_PXASCTL0_PXASS2_1_POS      (3)
#define ECCP_PXASCTL0_PXASS3_0_POS      (4)
#define ECCP_PXASCTL0_PXASS3_1_POS      (5)
#define ECCP_PXASCTL0_PXASS4_0_POS      (6)
#define ECCP_PXASCTL0_PXASS4_1_POS      (7)
#define ECCP_PXASCTL0_PXASE1_POS        (8)
#define ECCP_PXASCTL0_PXASE2_POS        (9)
#define ECCP_PXASCTL0_PXASE3_POS        (10)
#define ECCP_PXASCTL0_PXASE4_POS        (11)
#define ECCP_PXASCTL0_PXASS1            ((uint32_t)3<<(ECCP_PXASCTL0_PXASS1_0_POS))
#define ECCP_PXASCTL0_PXASS1_0          ((uint32_t)1<<(ECCP_PXASCTL0_PXASS1_0_POS))
#define ECCP_PXASCTL0_PXASS1_1          ((uint32_t)1<<(ECCP_PXASCTL0_PXASS1_1_POS))
#define ECCP_PXASCTL0_PXASS2            ((uint32_t)3<<(ECCP_PXASCTL0_PXASS2_0_POS))
#define ECCP_PXASCTL0_PXASS2_0          ((uint32_t)1<<(ECCP_PXASCTL0_PXASS2_0_POS))
#define ECCP_PXASCTL0_PXASS2_1          ((uint32_t)1<<(ECCP_PXASCTL0_PXASS2_1_POS))
#define ECCP_PXASCTL0_PXASS3            ((uint32_t)3<<(ECCP_PXASCTL0_PXASS3_0_POS))
#define ECCP_PXASCTL0_PXASS3_0          ((uint32_t)1<<(ECCP_PXASCTL0_PXASS3_0_POS))
#define ECCP_PXASCTL0_PXASS3_1          ((uint32_t)1<<(ECCP_PXASCTL0_PXASS3_1_POS))
#define ECCP_PXASCTL0_PXASS4            ((uint32_t)3<<(ECCP_PXASCTL0_PXASS4_0_POS))
#define ECCP_PXASCTL0_PXASS4_0          ((uint32_t)1<<(ECCP_PXASCTL0_PXASS4_0_POS))
#define ECCP_PXASCTL0_PXASS4_1          ((uint32_t)1<<(ECCP_PXASCTL0_PXASS4_1_POS))
#define ECCP_PXASCTL0_PXASE1            ((uint32_t)1<<(ECCP_PXASCTL0_PXASE1_POS))
#define ECCP_PXASCTL0_PXASE2            ((uint32_t)1<<(ECCP_PXASCTL0_PXASE2_POS))
#define ECCP_PXASCTL0_PXASE3            ((uint32_t)1<<(ECCP_PXASCTL0_PXASE3_POS))
#define ECCP_PXASCTL0_PXASE4            ((uint32_t)1<<(ECCP_PXASCTL0_PXASE4_POS))

/* ECCPX_PXASCTL1 λ */
#define ECCP_PXASCTL1_PXSS1L0_POS       (0)
#define ECCP_PXASCTL1_PXSS1L1_POS       (1)
#define ECCP_PXASCTL1_PXSS1H0_POS       (2)
#define ECCP_PXASCTL1_PXSS1H1_POS       (3)
#define ECCP_PXASCTL1_PXSS2L0_POS       (4)
#define ECCP_PXASCTL1_PXSS2L1_POS       (5)
#define ECCP_PXASCTL1_PXSS2H0_POS       (6)
#define ECCP_PXASCTL1_PXSS2H1_POS       (7)
#define ECCP_PXASCTL1_PXSS3L0_POS       (8)
#define ECCP_PXASCTL1_PXSS3L1_POS       (9)
#define ECCP_PXASCTL1_PXSS3H0_POS       (10)
#define ECCP_PXASCTL1_PXSS3H1_POS       (11)
#define ECCP_PXASCTL1_PXSS4L0_POS       (12)
#define ECCP_PXASCTL1_PXSS4L1_POS       (13)
#define ECCP_PXASCTL1_PXSS4H0_POS       (14)
#define ECCP_PXASCTL1_PXSS4H1_POS       (15)
#define ECCP_PXASCTL1_PXSS1L            ((uint32_t)3<<(ECCP_PXASCTL1_PXSS1L0_POS))
#define ECCP_PXASCTL1_PXSS1L0           ((uint32_t)1<<(ECCP_PXASCTL1_PXSS1L0_POS))
#define ECCP_PXASCTL1_PXSS1L1           ((uint32_t)1<<(ECCP_PXASCTL1_PXSS1L1_POS))
#define ECCP_PXASCTL1_PXSS1H            ((uint32_t)3<<(ECCP_PXASCTL1_PXSS1H0_POS))
#define ECCP_PXASCTL1_PXSS1H0           ((uint32_t)1<<(ECCP_PXASCTL1_PXSS1H0_POS))
#define ECCP_PXASCTL1_PXSS1H1           ((uint32_t)1<<(ECCP_PXASCTL1_PXSS1H1_POS))
#define ECCP_PXASCTL1_PXSS2L            ((uint32_t)3<<(ECCP_PXASCTL1_PXSS2L0_POS))
#define ECCP_PXASCTL1_PXSS2L0           ((uint32_t)1<<(ECCP_PXASCTL1_PXSS2L0_POS))
#define ECCP_PXASCTL1_PXSS2L1           ((uint32_t)1<<(ECCP_PXASCTL1_PXSS2L1_POS))
#define ECCP_PXASCTL1_PXSS2H            ((uint32_t)3<<(ECCP_PXASCTL1_PXSS2H0_POS))
#define ECCP_PXASCTL1_PXSS2H0           ((uint32_t)1<<(ECCP_PXASCTL1_PXSS2H0_POS))
#define ECCP_PXASCTL1_PXSS2H1           ((uint32_t)1<<(ECCP_PXASCTL1_PXSS2H1_POS))
#define ECCP_PXASCTL1_PXSS3L            ((uint32_t)3<<(ECCP_PXASCTL1_PXSS3L0_POS))
#define ECCP_PXASCTL1_PXSS3L0           ((uint32_t)1<<(ECCP_PXASCTL1_PXSS3L0_POS))
#define ECCP_PXASCTL1_PXSS3L1           ((uint32_t)1<<(ECCP_PXASCTL1_PXSS3L1_POS))
#define ECCP_PXASCTL1_PXSS3H            ((uint32_t)3<<(ECCP_PXASCTL1_PXSS3H0_POS))
#define ECCP_PXASCTL1_PXSS3H0           ((uint32_t)1<<(ECCP_PXASCTL1_PXSS3H0_POS))
#define ECCP_PXASCTL1_PXSS3H1           ((uint32_t)1<<(ECCP_PXASCTL1_PXSS3H1_POS))
#define ECCP_PXASCTL1_PXSS4L            ((uint32_t)3<<(ECCP_PXASCTL1_PXSS4L0_POS))
#define ECCP_PXASCTL1_PXSS4L0           ((uint32_t)1<<(ECCP_PXASCTL1_PXSS4L0_POS))
#define ECCP_PXASCTL1_PXSS4L1           ((uint32_t)1<<(ECCP_PXASCTL1_PXSS4L1_POS))
#define ECCP_PXASCTL1_PXSS4H            ((uint32_t)3<<(ECCP_PXASCTL1_PXSS4H0_POS))
#define ECCP_PXASCTL1_PXSS4H0           ((uint32_t)1<<(ECCP_PXASCTL1_PXSS4H0_POS))
#define ECCP_PXASCTL1_PXSS4H1           ((uint32_t)1<<(ECCP_PXASCTL1_PXSS4H1_POS))

/* ECCPX_ZPDCTL0 λ */
#define ECCP_ZPDCTL0_ZPD1FLAG_POS       (0)
#define ECCP_ZPDCTL0_ZPD2FLAG_POS       (1)
#define ECCP_ZPDCTL0_ZPD3FLAG_POS       (2)
#define ECCP_ZPDCTL0_ZPD4FLAG_POS       (3)
#define ECCP_ZPDCTL0_ZPD1TWIN_POS       (4)
#define ECCP_ZPDCTL0_ZPD2TWIN_POS       (5)
#define ECCP_ZPDCTL0_ZPD3TWIN_POS       (6)
#define ECCP_ZPDCTL0_ZPD4TWIN_POS       (7)
#define ECCP_ZPDCTL0_ZCLK0_POS          (8)
#define ECCP_ZPDCTL0_ZCLK1_POS          (9)
#define ECCP_ZPDCTL0_ZCLK2_POS          (10)
#define ECCP_ZPDCTL0_ZCLK3_POS          (11)
#define ECCP_ZPDCTL0_ZPD1FLAG           ((uint32_t)1<<(ECCP_ZPDCTL0_ZPD1FLAG_POS))
#define ECCP_ZPDCTL0_ZPD2FLAG           ((uint32_t)1<<(ECCP_ZPDCTL0_ZPD2FLAG_POS))
#define ECCP_ZPDCTL0_ZPD3FLAG           ((uint32_t)1<<(ECCP_ZPDCTL0_ZPD3FLAG_POS))
#define ECCP_ZPDCTL0_ZPD4FLAG           ((uint32_t)1<<(ECCP_ZPDCTL0_ZPD4FLAG_POS))
#define ECCP_ZPDCTL0_ZPD1TWIN           ((uint32_t)1<<(ECCP_ZPDCTL0_ZPD1TWIN_POS))
#define ECCP_ZPDCTL0_ZPD2TWIN           ((uint32_t)1<<(ECCP_ZPDCTL0_ZPD2TWIN_POS))
#define ECCP_ZPDCTL0_ZPD3TWIN           ((uint32_t)1<<(ECCP_ZPDCTL0_ZPD3TWIN_POS))
#define ECCP_ZPDCTL0_ZPD4TWIN           ((uint32_t)1<<(ECCP_ZPDCTL0_ZPD4TWIN_POS))
#define ECCP_ZPDCTL0_ZCLK               ((uint32_t)0xF<<(ECCP_ZPDCTL0_ZCLK0_POS))
#define ECCP_ZPDCTL0_ZCLK0              ((uint32_t)1<<(ECCP_ZPDCTL0_ZCLK0_POS))
#define ECCP_ZPDCTL0_ZCLK1              ((uint32_t)1<<(ECCP_ZPDCTL0_ZCLK1_POS))
#define ECCP_ZPDCTL0_ZCLK2              ((uint32_t)1<<(ECCP_ZPDCTL0_ZCLK2_POS))
#define ECCP_ZPDCTL0_ZCLK3              ((uint32_t)1<<(ECCP_ZPDCTL0_ZCLK3_POS))

/* ECCPX_ZPDCTL1 λ */
#define ECCP_ZPDCTL1_ZPD1S0_POS         (0)
#define ECCP_ZPDCTL1_ZPD1S1_POS         (1)
#define ECCP_ZPDCTL1_ZPD1S2_POS         (2)
#define ECCP_ZPDCTL1_ZPD2S0_POS         (3)
#define ECCP_ZPDCTL1_ZPD2S1_POS         (4)
#define ECCP_ZPDCTL1_ZPD2S2_POS         (5)
#define ECCP_ZPDCTL1_ZPD3S0_POS         (6)
#define ECCP_ZPDCTL1_ZPD3S1_POS         (7)
#define ECCP_ZPDCTL1_ZPD3S2_POS         (8)
#define ECCP_ZPDCTL1_ZPD4S0_POS         (9)
#define ECCP_ZPDCTL1_ZPD4S1_POS         (10)
#define ECCP_ZPDCTL1_ZPD4S2_POS         (11)
#define ECCP_ZPDCTL1_ZPD1EN_POS         (12)
#define ECCP_ZPDCTL1_ZPD2EN_POS         (13)
#define ECCP_ZPDCTL1_ZPD3EN_POS         (14)
#define ECCP_ZPDCTL1_ZPD4EN_POS         (15)
#define ECCP_ZPDCTL1_ZPD1S              ((uint32_t)7<<(ECCP_ZPDCTL1_ZPD1S0_POS))
#define ECCP_ZPDCTL1_ZPD1S0             ((uint32_t)1<<(ECCP_ZPDCTL1_ZPD1S0_POS))
#define ECCP_ZPDCTL1_ZPD1S1             ((uint32_t)1<<(ECCP_ZPDCTL1_ZPD1S1_POS))
#define ECCP_ZPDCTL1_ZPD1S2             ((uint32_t)1<<(ECCP_ZPDCTL1_ZPD1S2_POS))
#define ECCP_ZPDCTL1_ZPD2S              ((uint32_t)7<<(ECCP_ZPDCTL1_ZPD2S0_POS))
#define ECCP_ZPDCTL1_ZPD2S0             ((uint32_t)1<<(ECCP_ZPDCTL1_ZPD2S0_POS))
#define ECCP_ZPDCTL1_ZPD2S1             ((uint32_t)1<<(ECCP_ZPDCTL1_ZPD2S1_POS))
#define ECCP_ZPDCTL1_ZPD2S2             ((uint32_t)1<<(ECCP_ZPDCTL1_ZPD2S2_POS))
#define ECCP_ZPDCTL1_ZPD3S              ((uint32_t)7<<(ECCP_ZPDCTL1_ZPD3S0_POS))
#define ECCP_ZPDCTL1_ZPD3S0             ((uint32_t)1<<(ECCP_ZPDCTL1_ZPD3S0_POS))
#define ECCP_ZPDCTL1_ZPD3S1             ((uint32_t)1<<(ECCP_ZPDCTL1_ZPD3S1_POS))
#define ECCP_ZPDCTL1_ZPD3S2             ((uint32_t)1<<(ECCP_ZPDCTL1_ZPD3S2_POS))
#define ECCP_ZPDCTL1_ZPD4S              ((uint32_t)7<<(ECCP_ZPDCTL1_ZPD4S0_POS))
#define ECCP_ZPDCTL1_ZPD4S0             ((uint32_t)1<<(ECCP_ZPDCTL1_ZPD4S0_POS))
#define ECCP_ZPDCTL1_ZPD4S1             ((uint32_t)1<<(ECCP_ZPDCTL1_ZPD4S1_POS))
#define ECCP_ZPDCTL1_ZPD4S2             ((uint32_t)1<<(ECCP_ZPDCTL1_ZPD4S2_POS))
#define ECCP_ZPDCTL1_ZPD1EN             ((uint32_t)1<<(ECCP_ZPDCTL1_ZPD1EN_POS))
#define ECCP_ZPDCTL1_ZPD2EN             ((uint32_t)1<<(ECCP_ZPDCTL1_ZPD2EN_POS))
#define ECCP_ZPDCTL1_ZPD3EN             ((uint32_t)1<<(ECCP_ZPDCTL1_ZPD3EN_POS))
#define ECCP_ZPDCTL1_ZPD4EN             ((uint32_t)1<<(ECCP_ZPDCTL1_ZPD4EN_POS))

/* ECCPX_ZPDPORT λ */
#define ECCP_ZPDPORT_ZPORT0_POS         (0)
#define ECCP_ZPDPORT_ZPORT              ((uint32_t)0xFF<<(ECCP_ZPDPORT_ZPORT0_POS))

/* ECCPX_IE λ */
#define ECCP_IE_CC1IE_POS               (0)
#define ECCP_IE_CC2IE_POS               (1)
#define ECCP_IE_CC3IE_POS               (2)
#define ECCP_IE_CC4IE_POS               (3)
#define ECCP_IE_TXTIE_POS               (4)
#define ECCP_IE_TZIE_POS                (5)
#define ECCP_IE_TXIE_POS                (6)
#define ECCP_IE_TZUIE_POS               (7)
#define ECCP_IE_TXUIE_POS               (8)
#define ECCP_IE_CPIE_POS                (9)
#define ECCP_IE_PDIE_POS                (10)
#define ECCP_IE_CC1IE                   ((uint32_t)1<<(ECCP_IE_CC1IE_POS))
#define ECCP_IE_CC2IE                   ((uint32_t)1<<(ECCP_IE_CC2IE_POS))
#define ECCP_IE_CC3IE                   ((uint32_t)1<<(ECCP_IE_CC3IE_POS))
#define ECCP_IE_CC4IE                   ((uint32_t)1<<(ECCP_IE_CC4IE_POS))
#define ECCP_IE_TXTIE                   ((uint32_t)1<<(ECCP_IE_TXTIE_POS))
#define ECCP_IE_TZIE                    ((uint32_t)1<<(ECCP_IE_TZIE_POS))
#define ECCP_IE_TXIE                    ((uint32_t)1<<(ECCP_IE_TXIE_POS))
#define ECCP_IE_TZUIE                   ((uint32_t)1<<(ECCP_IE_TZUIE_POS))
#define ECCP_IE_TXUIE                   ((uint32_t)1<<(ECCP_IE_TXUIE_POS))
#define ECCP_IE_CPIE                    ((uint32_t)1<<(ECCP_IE_CPIE_POS))
#define ECCP_IE_PDIE                    ((uint32_t)1<<(ECCP_IE_PDIE_POS))

/* ECCPX_EGIF λ */
#define ECCP_EGIF_CPIF_POS              (0)
#define ECCP_EGIF_CC1G_POS              (1)
#define ECCP_EGIF_CC2G_POS              (2)
#define ECCP_EGIF_CC3G_POS              (3)
#define ECCP_EGIF_CC4G_POS              (4)
#define ECCP_EGIF_TXTRG_POS             (5)
#define ECCP_EGIF_CC1IF_POS             (6)
#define ECCP_EGIF_CC2IF_POS             (7)
#define ECCP_EGIF_CC3IF_POS             (8)
#define ECCP_EGIF_CC4IF_POS             (9)
#define ECCP_EGIF_TXTIF_POS             (10)
#define ECCP_EGIF_TZIF_POS              (11)
#define ECCP_EGIF_TXIF_POS              (12)
#define ECCP_EGIF_TZUIF_POS             (13)
#define ECCP_EGIF_TXUIF_POS             (14)
#define ECCP_EGIF_PDIF_POS              (15)
#define ECCP_EGIF_CPIF                  ((uint32_t)1<<(ECCP_EGIF_CPIF_POS))
#define ECCP_EGIF_CC1G                  ((uint32_t)1<<(ECCP_EGIF_CC1G_POS))
#define ECCP_EGIF_CC2G                  ((uint32_t)1<<(ECCP_EGIF_CC2G_POS))
#define ECCP_EGIF_CC3G                  ((uint32_t)1<<(ECCP_EGIF_CC3G_POS))
#define ECCP_EGIF_CC4G                  ((uint32_t)1<<(ECCP_EGIF_CC4G_POS))
#define ECCP_EGIF_TXTRG                 ((uint32_t)1<<(ECCP_EGIF_TXTRG_POS))
#define ECCP_EGIF_CC1IF                 ((uint32_t)1<<(ECCP_EGIF_CC1IF_POS))
#define ECCP_EGIF_CC2IF                 ((uint32_t)1<<(ECCP_EGIF_CC2IF_POS))
#define ECCP_EGIF_CC3IF                 ((uint32_t)1<<(ECCP_EGIF_CC3IF_POS))
#define ECCP_EGIF_CC4IF                 ((uint32_t)1<<(ECCP_EGIF_CC4IF_POS))
#define ECCP_EGIF_TXTIF                 ((uint32_t)1<<(ECCP_EGIF_TXTIF_POS))
#define ECCP_EGIF_TZIF                  ((uint32_t)1<<(ECCP_EGIF_TZIF_POS))
#define ECCP_EGIF_TXIF                  ((uint32_t)1<<(ECCP_EGIF_TXIF_POS))
#define ECCP_EGIF_TZUIF                 ((uint32_t)1<<(ECCP_EGIF_TZUIF_POS))
#define ECCP_EGIF_TXUIF                 ((uint32_t)1<<(ECCP_EGIF_TXUIF_POS))
#define ECCP_EGIF_PDIF                  ((uint32_t)1<<(ECCP_EGIF_PDIF_POS))

/* TX_UDTIMX λ */
#define ATIM_UDTIMX_UDCNT0_POS          (0)
#define ATIM_UDTIMX_UDCNT               ((uint32_t)0xFFFF<<(ATIM_UDTIMX_UDCNT0_POS))

/* TZ_UDTIMZ λ */
#define ATIM_UDTIMZ_UDCNT0_POS          (0)
#define ATIM_UDTIMZ_UDCNT               ((uint32_t)0xFFFF<<(ATIM_UDTIMZ_UDCNT0_POS))

/* ECCPX_DF λ */
#define ECCP_DF_CH1DF_POS               (0)
#define ECCP_DF_CH2DF_POS               (1)
#define ECCP_DF_CH3DF_POS               (2)
#define ECCP_DF_CH4DF_POS               (3)
#define ECCP_DF_CLSDF_POS               (4)
#define ECCP_DF_TRIGDF_POS              (5)
#define ECCP_DF_TZUDF_POS               (6)
#define ECCP_DF_TXUDF_POS               (7)
#define ECCP_DF_CH1DF                   ((uint32_t)1<<(ECCP_DF_CH1DF_POS))
#define ECCP_DF_CH2DF                   ((uint32_t)1<<(ECCP_DF_CH2DF_POS))
#define ECCP_DF_CH3DF                   ((uint32_t)1<<(ECCP_DF_CH3DF_POS))
#define ECCP_DF_CH4DF                   ((uint32_t)1<<(ECCP_DF_CH4DF_POS))
#define ECCP_DF_CLSDF                   ((uint32_t)1<<(ECCP_DF_CLSDF_POS))
#define ECCP_DF_TRIGDF                  ((uint32_t)1<<(ECCP_DF_TRIGDF_POS))
#define ECCP_DF_TZUDF                   ((uint32_t)1<<(ECCP_DF_TZUDF_POS))
#define ECCP_DF_TXUDF                   ((uint32_t)1<<(ECCP_DF_TXUDF_POS))

/* ECCPX_C1 λ */
#define ECCP_C1_ECCPXC0_0_POS           (0)
#define ECCP_C1_ECCPXC0                 ((uint32_t)0xFFFF<<(ECCP_C1_ECCPXC0_0_POS))

/* ECCPX_DE λ */
#define ECCP_DE_CH1DE_POS               (0)
#define ECCP_DE_CH2DE_POS               (1)
#define ECCP_DE_CH3DE_POS               (2)
#define ECCP_DE_CH4DE_POS               (3)
#define ECCP_DE_CLSDE_POS               (4)
#define ECCP_DE_TXTDE_POS               (5)
#define ECCP_DE_TZUDE_POS               (6)
#define ECCP_DE_TXUDE_POS               (7)
#define ECCP_DE_CH1DE                   ((uint32_t)1<<(ECCP_DE_CH1DE_POS))
#define ECCP_DE_CH2DE                   ((uint32_t)1<<(ECCP_DE_CH2DE_POS))
#define ECCP_DE_CH3DE                   ((uint32_t)1<<(ECCP_DE_CH3DE_POS))
#define ECCP_DE_CH4DE                   ((uint32_t)1<<(ECCP_DE_CH4DE_POS))
#define ECCP_DE_CLSDE                   ((uint32_t)1<<(ECCP_DE_CLSDE_POS))
#define ECCP_DE_TXTDE                   ((uint32_t)1<<(ECCP_DE_TXTDE_POS))
#define ECCP_DE_TZDE                    ((uint32_t)1<<(ECCP_DE_TZUDE_POS))
#define ECCP_DE_TXDE                    ((uint32_t)1<<(ECCP_DE_TXUDE_POS))

/* ECCPX_SRIC λ */
#define ECCP_SRIC_CC1IC_POS             (0)
#define ECCP_SRIC_CC2IC_POS             (1)
#define ECCP_SRIC_CC3IC_POS             (2)
#define ECCP_SRIC_CC4IC_POS             (3)
#define ECCP_SRIC_TXTIC_POS             (4)
#define ECCP_SRIC_TZIC_POS              (5)
#define ECCP_SRIC_TXIC_POS              (6)
#define ECCP_SRIC_TZUIC_POS             (7)
#define ECCP_SRIC_TXUIC_POS             (8)
#define ECCP_SRIC_CPIC_POS              (9)
#define ECCP_SRIC_PDIC_POS              (10)
#define ECCP_SRIC_CC1IC                 ((uint32_t)1<<(ECCP_SRIC_CC1IC_POS))
#define ECCP_SRIC_CC2IC                 ((uint32_t)1<<(ECCP_SRIC_CC2IC_POS))
#define ECCP_SRIC_CC3IC                 ((uint32_t)1<<(ECCP_SRIC_CC3IC_POS))
#define ECCP_SRIC_CC4IC                 ((uint32_t)1<<(ECCP_SRIC_CC4IC_POS))
#define ECCP_SRIC_TXTIC                 ((uint32_t)1<<(ECCP_SRIC_TXTIC_POS))
#define ECCP_SRIC_TZIC                  ((uint32_t)1<<(ECCP_SRIC_TZIC_POS))
#define ECCP_SRIC_TXIC                  ((uint32_t)1<<(ECCP_SRIC_TXIC_POS))
#define ECCP_SRIC_TZUIC                 ((uint32_t)1<<(ECCP_SRIC_TZUIC_POS))
#define ECCP_SRIC_TXUIC                 ((uint32_t)1<<(ECCP_SRIC_TXUIC_POS))
#define ECCP_SRIC_CPIC                  ((uint32_t)1<<(ECCP_SRIC_CPIC_POS))
#define ECCP_SRIC_PDIC                  ((uint32_t)1<<(ECCP_SRIC_PDIC_POS))

/* ECCPX_CTL3 λ */
#define ECCP_CTL3_PXSPMST_POS           (0)
#define ECCP_CTL3_TUNITE_POS            (1)
#define ECCP_CTL3_PXRSEN_POS            (2)
#define ECCP_CTL3_COMBEN_POS            (3)
#define ECCP_CTL3_COMINV0_POS           (4)
#define ECCP_CTL3_COMINV1_POS           (5)
#define ECCP_CTL3_CAPTST_POS            (6)
#define ECCP_CTL3_GTBBEN_POS            (7)
#define ECCP_CTL3_GTBEOUT_POS           (8)
#define ECCP_CTL3_CH0HM_POS            	(9)
#define ECCP_CTL3_CH1HM_POS            	(10)
#define ECCP_CTL3_CH2HM_POS            	(11)
#define ECCP_CTL3_CH3HM_POS            	(12)
#define ECCP_CTL3_TRGSEL0_POS           (13)
#define ECCP_CTL3_TRGSEL1_POS           (14)
#define ECCP_CTL3_PXSPMST               ((uint32_t)1<<(ECCP_CTL3_PXSPMST_POS))
#define ECCP_CTL3_TUNITE                ((uint32_t)1<<(ECCP_CTL3_TUNITE_POS))
#define ECCP_CTL3_PXRSEN                ((uint32_t)1<<(ECCP_CTL3_PXRSEN_POS))
#define ECCP_CTL3_COMBEN   				((uint32_t)1<<(ECCP_CTL3_COMBEN_POS))
#define ECCP_CTL3_COMINV				((uint32_t)0x03<<(ECCP_CTL3_COMINV0_POS))
#define ECCP_CTL3_COMINV0           	((uint32_t)1<<(ECCP_CTL3_COMINV0_POS))
#define ECCP_CTL3_COMINV1           	((uint32_t)1<<(ECCP_CTL3_COMINV1_POS))
#define ECCP_CTL3_CAPTST            	((uint32_t)1<<(ECCP_CTL3_CAPTST_POS))
#define ECCP_CTL3_GTBBEN            	((uint32_t)1<<(ECCP_CTL3_GTBBEN_POS))
#define ECCP_CTL3_GTBEOUT           	((uint32_t)1<<(ECCP_CTL3_GTBEOUT_POS))
#define ECCP_CTL3_CH0HM           		((uint32_t)1<<(ECCP_CTL3_CH0HM_POS))
#define ECCP_CTL3_CH1HM            		((uint32_t)1<<(ECCP_CTL3_CH1HM_POS))
#define ECCP_CTL3_CH2HM            		((uint32_t)1<<(ECCP_CTL3_CH2HM_POS))
#define ECCP_CTL3_CH3HM					((uint32_t)1<<(ECCP_CTL3_CH3HM_POS))
#define ECCP_CTL3_TRGSEL				((uint32_t)0x03<<(ECCP_CTL3_TRGSEL0_POS))
#define ECCP_CTL3_TRGSEL0           	((uint32_t)1<<(ECCP_CTL3_TRGSEL0_POS))
#define ECCP_CTL3_TRGSEL1           	((uint32_t)1<<(ECCP_CTL3_TRGSEL1_POS))

/* ECCPx_PDCTL λ */
#define ECCP_PDCTL_CPE0_POS				(0)
#define ECCP_PDCTL_CPE1_POS				(1)
#define ECCP_PDCTL_CMPE_POS				(2)
#define ECCP_PDCTL_TI0_EN_POS			(3)
#define ECCP_PDCTL_TI1_EN_POS			(4)
#define ECCP_PDCTL_TI2_EN_POS			(5)
#define ECCP_PDCTL_SMPEN_POS			(7)
#define ECCP_PDCTL_RDA0_POS				(8)
#define ECCP_PDCTL_RDA1_POS				(9)
#define ECCP_PDCTL_RDA2_POS				(10)
#define ECCP_PDCTL_CPD0_POS				(12)
#define ECCP_PDCTL_CPD1_POS				(13)
#define ECCP_PDCTL_CPD2_POS				(14)
#define ECCP_PDCTL_CPE					((uint32_t)0x03<<(ECCP_PDCTL_CPE0_POS))
#define ECCP_PDCTL_CPE0					((uint32_t)1<<(ECCP_PDCTL_CPE0_POS))
#define ECCP_PDCTL_CPE1					((uint32_t)1<<(ECCP_PDCTL_CPE1_POS))
#define ECCP_PDCTL_CMPE					((uint32_t)1<<(ECCP_PDCTL_CMPE_POS))
#define ECCP_PDCTL_TI0_EN				((uint32_t)1<<(ECCP_PDCTL_TI0_EN_POS))
#define ECCP_PDCTL_TI1_EN				((uint32_t)1<<(ECCP_PDCTL_TI1_EN_POS))
#define ECCP_PDCTL_TI2_EN				((uint32_t)1<<(ECCP_PDCTL_TI2_EN_POS))
#define ECCP_PDCTL_SMPEN				((uint32_t)1<<(ECCP_PDCTL_SMPEN_POS))
#define ECCP_PDCTL_RDA					((uint32_t)0x03<<(ECCP_PDCTL_RDA0_POS))
#define ECCP_PDCTL_RDA0					((uint32_t)1<<(ECCP_PDCTL_RDA0_POS))
#define ECCP_PDCTL_RDA1					((uint32_t)1<<(ECCP_PDCTL_RDA1_POS))
#define ECCP_PDCTL_RDA2					((uint32_t)1<<(ECCP_PDCTL_RDA2_POS))
#define ECCP_PDCTL_CPD					((uint32_t)0x03<<(ECCP_PDCTL_CPD0_POS))
#define ECCP_PDCTL_CPD0					((uint32_t)1<<(ECCP_PDCTL_CPD0_POS))
#define ECCP_PDCTL_CPD1					((uint32_t)1<<(ECCP_PDCTL_CPD1_POS))
#define ECCP_PDCTL_CPD2					((uint32_t)1<<(ECCP_PDCTL_CPD2_POS))

/* ECCPX_PXASCTL λ */
#define ECCP_PXASCTL_TXPXASS0_POS       (0)
#define ECCP_PXASCTL_TXPXASS1_POS       (1)
#define ECCP_PXASCTL_TZPXASS0_POS       (2)
#define ECCP_PXASCTL_TZPXASS1_POS       (3)
#define ECCP_PXASCTL_TXBKINS_POS        (4)
#define ECCP_PXASCTL_TZBKINS_POS        (5)
#define ECCP_PXASCTL_TXPXASS            ((uint32_t)0x03<<(ECCP_PXASCTL_TXPXASS0_POS))
#define ECCP_PXASCTL_TXPXASS0           ((uint32_t)1<<(ECCP_PXASCTL_TXPXASS0_POS))
#define ECCP_PXASCTL_TXPXASS1           ((uint32_t)1<<(ECCP_PXASCTL_TXPXASS1_POS))
#define ECCP_PXASCTL_TZPXASS            ((uint32_t)0x03<<(ECCP_PXASCTL_TZPXASS0_POS))
#define ECCP_PXASCTL_TZPXASS0           ((uint32_t)1<<(ECCP_PXASCTL_TZPXASS0_POS))
#define ECCP_PXASCTL_TZPXASS1           ((uint32_t)1<<(ECCP_PXASCTL_TZPXASS1_POS))
#define ECCP_PXASCTL_TXBKINS            ((uint32_t)1<<(ECCP_PXASCTL_TXBKINS_POS))
#define ECCP_PXASCTL_TZBKINS            ((uint32_t)1<<(ECCP_PXASCTL_TZBKINS_POS))

/* ECCPX_COMH λ */
#define ECCP_COMH0_POS					(0)
#define ECCP_COMH						((uint32_t)0xFFFF<<(ECCP_COMH0_POS))

/* ECCPX_COML λ */
#define ECCP_COML0_POS					(0)
#define ECCP_COML						((uint32_t)0xFFFF<<(ECCP_COML0_POS))


/* ECCPX_FAUCTL λ */
#define ECCP_FAUCTL_FAUEN_POS			(0)
#define ECCP_FAUCTL_FLTP0_POS			(1)
#define ECCP_FAUCTL_FLTP1_POS			(2)
#define ECCP_FAUCTL_FLTP2_POS			(3)
#define ECCP_FAUCTL_FLTP3_POS			(4)
#define ECCP_FAUCTL_FLTEN_POS			(5)
#define ECCP_FAUCTL_FAUIE_POS			(6)
#define ECCP_FAUCTL_FAUIC_POS			(7)
#define ECCP_FAUCTL_FAUIF_POS			(8)
#define ECCP_FAUCTL_FVAL0_POS			(9)
#define ECCP_FAUCTL_FVAL1_POS			(10)
#define ECCP_FAUCTL_FVAL2_POS			(11)
#define ECCP_FAUCTL_FINV0_POS			(12)
#define ECCP_FAUCTL_FINV1_POS			(13)
#define ECCP_FAUCTL_TRST_POS			(14)
#define ECCP_FAUCTL_FAUEN				((uint32_t)1<<(ECCP_FAUCTL_FAUEN_POS))
#define ECCP_FAUCTL_FLTP				((uint32_t)0x0F<<(ECCP_FAUCTL_FLTP0_POS))
#define ECCP_FAUCTL_FLTP0				((uint32_t)1<<(ECCP_FAUCTL_FLTP0_POS))
#define ECCP_FAUCTL_FLTP1				((uint32_t)1<<(ECCP_FAUCTL_FLTP1_POS))
#define ECCP_FAUCTL_FLTP2				((uint32_t)1<<(ECCP_FAUCTL_FLTP2_POS))
#define ECCP_FAUCTL_FLTP3				((uint32_t)1<<(ECCP_FAUCTL_FLTP3_POS))
#define ECCP_FAUCTL_FLTEN				((uint32_t)1<<(ECCP_FAUCTL_FLTEN_POS))
#define ECCP_FAUCTL_FAUIE				((uint32_t)1<<(ECCP_FAUCTL_FAUIE_POS))
#define ECCP_FAUCTL_FAUIC				((uint32_t)1<<(ECCP_FAUCTL_FAUIC_POS))
#define ECCP_FAUCTL_FAUIF				((uint32_t)1<<(ECCP_FAUCTL_FAUIF_POS))
#define ECCP_FAUCTL_FVAL				((uint32_t)0x07<<(ECCP_FAUCTL_FVAL0_POS))
#define ECCP_FAUCTL_FVAL0				((uint32_t)1<<(ECCP_FAUCTL_FVAL0_POS))
#define ECCP_FAUCTL_FVAL1				((uint32_t)1<<(ECCP_FAUCTL_FVAL1_POS))
#define ECCP_FAUCTL_FVAL2				((uint32_t)1<<(ECCP_FAUCTL_FVAL2_POS))
#define ECCP_FAUCTL_FINV				((uint32_t)0x03<<(ECCP_FAUCTL_FINV0_POS))
#define ECCP_FAUCTL_FINV0				((uint32_t)1<<(ECCP_FAUCTL_FINV0_POS))
#define ECCP_FAUCTL_FINV1				((uint32_t)1<<(ECCP_FAUCTL_FINV1_POS))
#define ECCP_FAUCTL_TRST				((uint32_t)1<<(ECCP_FAUCTL_TRST_POS))

/* ECCPX_DITCTL λ*/
#define ECCP_DITCTL_FRCVAL0_POS			(0)
#define ECCP_DITCTL_FRCVAL1_POS			(1)
#define ECCP_DITCTL_FRCVAL2_POS			(2)
#define ECCP_DITCTL_FRCVAL3_POS			(3)
#define ECCP_DITCTL_FRCVAL4_POS			(4)
#define ECCP_DITCTL_DEDEN_POS			(5)
#define ECCP_DITCTL_DPEEN_POS			(6)
#define ECCP_DITCTL_DCOMEN_POS			(7)
#define ECCP_DITCTL_FRCVAL				((uint32_t)0x1F<<(ECCP_DITCTL_FRCVAL0_POS))
#define ECCP_DITCTL_FRCVAL0				((uint32_t)1<<(ECCP_DITCTL_FRCVAL0_POS))
#define ECCP_DITCTL_FRCVAL1				((uint32_t)1<<(ECCP_DITCTL_FRCVAL1_POS))
#define ECCP_DITCTL_FRCVAL2				((uint32_t)1<<(ECCP_DITCTL_FRCVAL2_POS))
#define ECCP_DITCTL_FRCVAL3				((uint32_t)1<<(ECCP_DITCTL_FRCVAL3_POS))
#define ECCP_DITCTL_FRCVAL4				((uint32_t)1<<(ECCP_DITCTL_FRCVAL4_POS))
#define ECCP_DITCTL_DEDEN				((uint32_t)1<<(ECCP_DITCTL_DEDEN_POS))
#define ECCP_DITCTL_DPEEN				((uint32_t)1<<(ECCP_DITCTL_DPEEN_POS))
#define ECCP_DITCTL_DCOMEN				((uint32_t)1<<(ECCP_DITCTL_DCOMEN_POS))

/* ECCPX_CCRCTL λ */
#define ECCP_CCRCTL_TXCCR0SEN_POS		(0)
#define ECCP_CCRCTL_TXCCR1SEN_POS		(1)
#define ECCP_CCRCTL_TZCCR0SEN_POS		(2)
#define ECCP_CCRCTL_TXCCR0SEL_POS		(3)
#define ECCP_CCRCTL_TXCCR1SEL_POS		(4)
#define ECCP_CCRCTL_TZCCR0SEL_POS		(5)
#define ECCP_CCRCTL_TXCCR0SEN			((uint32_t)1<<(ECCP_CCRCTL_TXCCR0SEN_POS))
#define ECCP_CCRCTL_TXCCR1SEN			((uint32_t)1<<(ECCP_CCRCTL_TXCCR1SEN_POS))
#define ECCP_CCRCTL_TZCCR0SEN			((uint32_t)1<<(ECCP_CCRCTL_TZCCR0SEN_POS))
#define ECCP_CCRCTL_TXCCR0SEL			((uint32_t)1<<(ECCP_CCRCTL_TXCCR0SEL_POS))
#define ECCP_CCRCTL_TXCCR1SEL			((uint32_t)1<<(ECCP_CCRCTL_TXCCR1SEL_POS))
#define ECCP_CCRCTL_TZCCR0SEL			((uint32_t)1<<(ECCP_CCRCTL_TZCCR0SEL_POS))
/* ߼ʱ(ATIM) */

#endif

#if 1										/* EPWM */

/* ----------------------------------------------------------------------------
   -- ǿģ(EPWM)
   ---------------------------------------------------------------------------- */

/* EPWM - Ĵڴṹ */
typedef struct EPWM_MemMap
{
	volatile       uint32_t CNT;				/*Tx_CNTĴƫ0x00*/
	volatile	   uint32_t	PHS;				/*TxλĴƫ0x04*/
	volatile	   uint32_t	PPX;				/*TxڼĴƫ0x08*/
	volatile	   uint32_t	PRSC;				/*TxԤƵüĴƫ0x0C*/
	volatile	   uint32_t	CTL;				/*TxƼĴƫ0x10*/
	volatile	   uint32_t	RA;					/*EPWMxռձAĴƫ0x14*/
	volatile	   uint32_t	RB;					/*EPWMxռձBĴƫ0x18*/
	volatile	   uint32_t	CTLA;				/*EPWMxAƼĴƫ0x1C*/
	volatile	   uint32_t	CTLB;				/*EPWMxBƼĴƫ0x20*/
	volatile	   uint32_t	DBCTL;				/*TEPWMxƼĴƫ0x24*/
	volatile	   uint32_t	DBT;				/*EPWMxʱƼĴƫ0x28*/
	volatile	   uint32_t	PCCTL;				/*EPWMxնƼĴƫ0x2C*/
	volatile	   uint32_t	PXASCTL;			/*EPWMxضϿƼĴƫ0x30*/
	volatile	   uint32_t	ETCTL;				/*¼ƼĴƫ0x34*/
	volatile	   uint32_t	IE;					/*EPWMxжʹܼĴƫ0x38*/
	volatile const uint32_t	IF;					/*EPWMxжϱ־Ĵƫ0x3C*/
	volatile	   uint32_t	IC;					/*EPWMxжĴƫ0x40*/
	volatile	   uint32_t	DE;					/*EPWMxDMAʹܼĴƫ0x44*/
	volatile const uint32_t	DF;					/*EPWMxDMA־Ĵƫ0x48*/
				   uint32_t RESERVED0;        	/* ַ, ƫ:0x4C */
	volatile	   uint32_t	HRPWMCTL;			/*߾PWMƼĴƫ0x50*/
	volatile	   uint32_t	HRCMP;				/*߾ռձȼĴƫ0x54*/
	volatile const uint32_t	CAP;				/*EPWMx׽Ĵƫ0x58*/
	volatile	   uint32_t	RC;					/*EPWMxռձCĴƫ0x5C*/
	volatile	   uint32_t	RD;					/*EPWMxռձDĴƫ0x60*/
	volatile	   uint32_t	UDCTL;				/*EPWMx¿ƼĴƫ0x64*/
}EPWM_SFRmap;

/* ----------------------------------------------------------------------------
   -- EPWM - Ĵں
   ---------------------------------------------------------------------------- */

/* EPWM - Ĵڵַ */
#define T11_ADDR						((uint32_t)0x40001A00)
#define T12_ADDR						((uint32_t)0x40001300)
#define T13_ADDR						((uint32_t)0x40001380)
#define T16_ADDR						((uint32_t)0x40002E00)
#define EPWM11_ADDR						(T11_ADDR)
#define EPWM12_ADDR						(T12_ADDR)
#define EPWM13_ADDR						(T13_ADDR)
#define EPWM16_ADDR						(T16_ADDR)
#define T11_SFR							((EPWM_SFRmap *) T11_ADDR)
#define T12_SFR							((EPWM_SFRmap *) T12_ADDR)
#define T13_SFR							((EPWM_SFRmap *) T13_ADDR)
#define T16_SFR							((EPWM_SFRmap *) T16_ADDR)
#define EPWM11_SFR						((EPWM_SFRmap *) EPWM11_ADDR)
#define EPWM12_SFR						((EPWM_SFRmap *) EPWM12_ADDR)
#define EPWM13_SFR						((EPWM_SFRmap *) EPWM13_ADDR)
#define EPWM16_SFR						((EPWM_SFRmap *) EPWM16_ADDR)

/* EPWM - Ĵ */
#define	T11_CNT							(T11_SFR->CNT)
#define T11_PHS							(T11_SFR->PHS)
#define T11_PPX							(T11_SFR->PPX)
#define T11_PRSC						(T11_SFR->PRSC)
#define T11_CTL							(T11_SFR->CTL)
#define EPWM11_RA						(EPWM11_SFR->RA)
#define EPWM11_RB						(EPWM11_SFR->RB)
#define EPWM11_CTLA						(EPWM11_SFR->CTLA)
#define EPWM11_CTLB						(EPWM11_SFR->CTLB)
#define EPWM11_DBCTL					(EPWM11_SFR->DBCTL)
#define EPWM11_DBT						(EPWM11_SFR->DBT)
#define EPWM11_PCCTL					(EPWM11_SFR->PCCTL)
#define EPWM11_PXASCTL					(EPWM11_SFR->PXASCTL)
#define EPWM11_ETCTL					(EPWM11_SFR->ETCTL)
#define EPWM11_IE						(EPWM11_SFR->IE)
#define EPWM11_IF						(EPWM11_SFR->IF)
#define EPWM11_IC						(EPWM11_SFR->IC)
#define EPWM11_DE						(EPWM11_SFR->DE)
#define EPWM11_DF						(EPWM11_SFR->DF)
#define EPWM11_HRPWMCTL					(EPWM11_SFR->HRPWMCTL)
#define EPWM11_HRCMP					(EPWM11_SFR->HRCMP)
#define EPWM11_CAP						(EPWM11_SFR->CAP)
#define EPWM11_RC						(EPWM11_SFR->RC)
#define EPWM11_RD						(EPWM11_SFR->RD)
#define EPWM11_UDCTL					(EPWM11_SFR->UDCTL)
#define	T12_CNT							(T12_SFR->CNT)
#define T12_PHS							(T12_SFR->PHS)
#define T12_PPX							(T12_SFR->PPX)
#define T12_PRSC						(T12_SFR->PRSC)
#define T12_CTL							(T12_SFR->CTL)
#define EPWM12_RA						(EPWM12_SFR->RA)
#define EPWM12_RB						(EPWM12_SFR->RB)
#define EPWM12_CTLA						(EPWM12_SFR->CTLA)
#define EPWM12_CTLB						(EPWM12_SFR->CTLB)
#define EPWM12_DBCTL					(EPWM12_SFR->DBCTL)
#define EPWM12_DBT						(EPWM12_SFR->DBT)
#define EPWM12_PCCTL					(EPWM12_SFR->PCCTL)
#define EPWM12_PXASCTL					(EPWM12_SFR->PXASCTL)
#define EPWM12_ETCTL					(EPWM12_SFR->ETCTL)
#define EPWM12_IE						(EPWM12_SFR->IE)
#define EPWM12_IF						(EPWM12_SFR->IF)
#define EPWM12_IC						(EPWM12_SFR->IC)
#define EPWM12_DE						(EPWM12_SFR->DE)
#define EPWM12_DF						(EPWM12_SFR->DF)
#define EPWM12_HRPWMCTL					(EPWM12_SFR->HRPWMCTL)
#define EPWM12_HRCMP					(EPWM12_SFR->HRCMP)
#define EPWM12_CAP						(EPWM12_SFR->CAP)
#define EPWM12_RC						(EPWM12_SFR->RC)
#define EPWM12_RD						(EPWM12_SFR->RD)
#define EPWM12_UDCTL					(EPWM12_SFR->UDCTL)
#define	T13_CNT							(T13_SFR->CNT)
#define T13_PHS							(T13_SFR->PHS)
#define T13_PPX							(T13_SFR->PPX)
#define T13_PRSC						(T13_SFR->PRSC)
#define T13_CTL							(T13_SFR->CTL)
#define EPWM13_RA						(EPWM13_SFR->RA)
#define EPWM13_RB						(EPWM13_SFR->RB)
#define EPWM13_CTLA						(EPWM13_SFR->CTLA)
#define EPWM13_CTLB						(EPWM13_SFR->CTLB)
#define EPWM13_DBCTL					(EPWM13_SFR->DBCTL)
#define EPWM13_DBT						(EPWM13_SFR->DBT)
#define EPWM13_PCCTL					(EPWM13_SFR->PCCTL)
#define EPWM13_PXASCTL					(EPWM13_SFR->PXASCTL)
#define EPWM13_ETCTL					(EPWM13_SFR->ETCTL)
#define EPWM13_IE						(EPWM13_SFR->IE)
#define EPWM13_IF						(EPWM13_SFR->IF)
#define EPWM13_IC						(EPWM13_SFR->IC)
#define EPWM13_DE						(EPWM13_SFR->DE)
#define EPWM13_DF						(EPWM13_SFR->DF)
#define EPWM13_HRPWMCTL					(EPWM13_SFR->HRPWMCTL)
#define EPWM13_HRCMP					(EPWM13_SFR->HRCMP)
#define EPWM13_CAP						(EPWM13_SFR->CAP)
#define EPWM13_RC						(EPWM13_SFR->RC)
#define EPWM13_RD						(EPWM13_SFR->RD)
#define EPWM13_UDCTL					(EPWM13_SFR->UDCTL)
#define	T16_CNT							(T16_SFR->CNT)
#define T16_PHS							(T16_SFR->PHS)
#define T16_PPX							(T16_SFR->PPX)
#define T16_PRSC						(T16_SFR->PRSC)
#define T16_CTL							(T16_SFR->CTL)
#define EPWM16_RA						(EPWM16_SFR->RA)
#define EPWM16_RB						(EPWM16_SFR->RB)
#define EPWM16_CTLA						(EPWM16_SFR->CTLA)
#define EPWM16_CTLB						(EPWM16_SFR->CTLB)
#define EPWM16_DBCTL					(EPWM16_SFR->DBCTL)
#define EPWM16_DBT						(EPWM16_SFR->DBT)
#define EPWM16_PCCTL					(EPWM16_SFR->PCCTL)
#define EPWM16_PXASCTL					(EPWM16_SFR->PXASCTL)
#define EPWM16_ETCTL					(EPWM16_SFR->ETCTL)
#define EPWM16_IE						(EPWM16_SFR->IE)
#define EPWM16_IF						(EPWM16_SFR->IF)
#define EPWM16_IC						(EPWM16_SFR->IC)
#define EPWM16_DE						(EPWM16_SFR->DE)
#define EPWM16_DF						(EPWM16_SFR->DF)
#define EPWM16_HRPWMCTL					(EPWM16_SFR->HRPWMCTL)
#define EPWM16_HRCMP					(EPWM16_SFR->HRCMP)
#define EPWM16_CAP						(EPWM16_SFR->CAP)
#define EPWM16_RC						(EPWM16_SFR->RC)
#define EPWM16_RD						(EPWM16_SFR->RD)
#define EPWM16_UDCTL					(EPWM16_SFR->UDCTL)

/* Tx_CNT λ */
#define EPWM_CNT_TXCNT0_POS				(0)
#define EPWM_CNT_TXCNT					((uint32_t)0xFFFFFFFF<<(EPWM_CNT_TXCNT0_POS))

/* Tx_PHS λ */
#define EPWM_PHS_TXPHS0_POS				(0)
#define EPWM_PHS_TXPHS					((uint32_t)0xFFFFFFFF<<(EPWM_PHS_TXPHS0_POS))

/* Tx_PPX λ */
#define EPWM_PPX_TXPPX0_POS				(0)
#define EPWM_PPX_TXPPX					((uint32_t)0xFFFFFFFF<<(EPWM_PPX_TXPPX0_POS))

/* Tx_PRSC λ */
#define EPWM_PRSC_TXPRSC0_POS			(0)
#define EPWM_PRSC_TXPRSC				((uint32_t)0xFFFFFFFF<<(EPWM_PRSC_TXPRSC0_POS))

/* Tx_CTL λ */
#define EPWM_CTL_TXEN_POS				(0)
#define EPWM_CTL_TXCS_POS				(1)
#define EPWM_CTL_TXGATE_POS				(2)
#define EPWM_CTL_TXSY_POS				(3)
#define EPWM_CTL_TXCLK0_POS				(4)
#define EPWM_CTL_TXCLK1_POS				(5)
#define EPWM_CTL_TTXDIR_POS				(6)
#define EPWM_CTL_TXCMS0_POS				(7)
#define EPWM_CTL_TXCMS1_POS				(8)
#define EPWM_CTL_TXCMS2_POS				(9)
#define EPWM_CTL_TXUDEN_POS				(10)
#define EPWM_CTL_TXEUDEVT_POS			(11)
#define EPWM_CTL_TXUR_POS				(12)
#define EPWM_CTL_SYNCI_POS				(13)
#define EPWM_CTL_PHSEN_POS				(14)
#define EPWM_CTL_SYNCOSEL0_POS			(15)
#define EPWM_CTL_SYNCOSEL1_POS			(16)
#define EPWM_CTL_SWFSYNC_POS			(17)
#define EPWM_CTL_PHSDIR_POS				(18)
#define EPWM_CTL_TXMAX_POS				(19)
#define EPWM_CTL_CAPSEL0_POS			(20)
#define EPWM_CTL_CAPSEL1_POS			(21)
#define EPWM_CTL_CAPEN_POS				(22)
#define EPWM_CTL_AQLOCKA_POS			(23)
#define EPWM_CTL_AQLOCKB_POS			(24)
#define EPWM_CTL_DBLOCK_POS				(25)
#define EPWM_CTL_PCLOCK_POS				(26)
#define EPWM_CTL_ETLOCK_POS				(27)
#define EPWM_CTL_HRLOCK_POS				(28)
#define EPWM_CTL_UDSYNEN_POS			(29)
#define EPWM_CTL_LINKEN_POS				(30)
#define EPWM_CTL_BLINKEN_POS			(31)
#define EPWM_CTL_TXEN					((uint32_t)1<<(EPWM_CTL_TXEN_POS))
#define EPWM_CTL_TXCS					((uint32_t)1<<(EPWM_CTL_TXCS_POS))
#define EPWM_CTL_TXGATE					((uint32_t)1<<(EPWM_CTL_TXGATE_POS))
#define EPWM_CTL_TXSY					((uint32_t)1<<(EPWM_CTL_TXSY_POS))
#define EPWM_CTL_TXCLK					((uint32_t)0x03<<(EPWM_CTL_TXCLK0_POS))
#define EPWM_CTL_TXCLK0					((uint32_t)1<<(EPWM_CTL_TXCLK0_POS))
#define EPWM_CTL_TXCLK1					((uint32_t)1<<(EPWM_CTL_TXCLK1_POS))
#define EPWM_CTL_TTXDIR					((uint32_t)1<<(EPWM_CTL_TTXDIR_POS))
#define EPWM_CTL_TXCMS					((uint32_t)0x07<<(EPWM_CTL_TXCMS0_POS))
#define EPWM_CTL_TXCMS0					((uint32_t)1<<(EPWM_CTL_TXCMS0_POS))
#define EPWM_CTL_TXCMS1					((uint32_t)1<<(EPWM_CTL_TXCMS1_POS))
#define EPWM_CTL_TXCMS2					((uint32_t)1<<(EPWM_CTL_TXCMS2_POS))
#define EPWM_CTL_TXUDEN					((uint32_t)1<<(EPWM_CTL_TXUDEN_POS))
#define EPWM_CTL_TXEUDEVT				((uint32_t)1<<(EPWM_CTL_TXEUDEVT_POS))
#define EPWM_CTL_TXUR					((uint32_t)1<<(EPWM_CTL_TXUR_POS))
#define EPWM_CTL_SYNCI					((uint32_t)1<<(EPWM_CTL_SYNCI_POS))
#define EPWM_CTL_PHSEN					((uint32_t)1<<(EPWM_CTL_PHSEN_POS))
#define EPWM_CTL_SYNCOSEL				((uint32_t)0x03<<(EPWM_CTL_SYNCOSEL0_POS))
#define EPWM_CTL_SYNCOSEL0				((uint32_t)0x03<<(EPWM_CTL_SYNCOSEL0_POS))
#define EPWM_CTL_SYNCOSEL1				((uint32_t)0x03<<(EPWM_CTL_SYNCOSEL1_POS))
#define EPWM_CTL_SWFSYNC				((uint32_t)1<<(EPWM_CTL_SWFSYNC_POS))
#define EPWM_CTL_PHSDIR					((uint32_t)1<<(EPWM_CTL_PHSDIR_POS))
#define EPWM_CTL_TXMAX					((uint32_t)1<<(EPWM_CTL_TXMAX_POS))
#define EPWM_CTL_CAPSEL					((uint32_t)0x03<<(EPWM_CTL_CAPSEL0_POS))
#define EPWM_CTL_CAPSEL0				((uint32_t)1<<(EPWM_CTL_CAPSEL0_POS))
#define EPWM_CTL_CAPSEL1				((uint32_t)1<<(EPWM_CTL_CAPSEL1_POS))
#define EPWM_CTL_CAPEN					((uint32_t)1<<(EPWM_CTL_CAPEN_POS))
#define EPWM_CTL_AQLOCKA				((uint32_t)1<<(EPWM_CTL_AQLOCKA_POS))
#define EPWM_CTL_AQLOCKB				((uint32_t)1<<(EPWM_CTL_AQLOCKB_POS))
#define EPWM_CTL_DBLOCK					((uint32_t)1<<(EPWM_CTL_DBLOCK_POS))
#define EPWM_CTL_PCLOCK					((uint32_t)1<<(EPWM_CTL_PCLOCK_POS))
#define EPWM_CTL_ETLOCK					((uint32_t)1<<(EPWM_CTL_ETLOCK_POS))
#define EPWM_CTL_HRLOCK					((uint32_t)1<<(EPWM_CTL_HRLOCK_POS))
#define EPWM_CTL_UDSYNEN				((uint32_t)1<<(EPWM_CTL_UDSYNEN_POS))
#define EPWM_CTL_LINKEN					((uint32_t)1<<(EPWM_CTL_LINKEN_POS))
#define EPWM_CTL_BLINKEN				((uint32_t)1<<(EPWM_CTL_BLINKEN_POS))

/* EPWMx_RA λ */
#define EPWM_RA_EPWMRA0_POS				(0)
#define EPWM_RA_EPWMRA					((uint32_t)0xFFFFFFFF<<(EPWM_RA_EPWMRA0_POS))

/* EPWMx_RB λ */
#define EPWM_RB_EPWMRB0_POS				(0)
#define EPWM_RB_EPWMRB					((uint32_t)0xFFFFFFFF<<(EPWM_RB_EPWMRB0_POS))

/*EPWMx_CTLA λ*/
#define EPWM_CTLA_AZRO0_POS             (0)
#define EPWM_CTLA_AZRO1_POS             (1)
#define EPWM_CTLA_APRD0_POS             (2)
#define EPWM_CTLA_APRD1_POS             (3)
#define EPWM_CTLA_ACAU0_POS             (4)
#define EPWM_CTLA_ACAU1_POS             (5)
#define EPWM_CTLA_ACAD0_POS             (6)
#define EPWM_CTLA_ACAD1_POS             (7)
#define EPWM_CTLA_ACBU0_POS             (8)
#define EPWM_CTLA_ACBU1_POS             (9)
#define EPWM_CTLA_ACBD0_POS             (10)
#define EPWM_CTLA_ACBD1_POS             (11)
#define EPWM_CTLA_CSFA0_POS             (12)
#define EPWM_CTLA_CSFA1_POS             (13)
#define EPWM_CTLA_ACTSFA0_POS           (14)
#define EPWM_CTLA_ACTSFA1_POS           (15)
#define EPWM_CTLA_OTSFA_POS             (16)
#define EPWM_CTLA_AZRO                 	((uint32_t)0x03<<(EPWM_CTLA_AZRO0_POS))
#define EPWM_CTLA_AZRO0                 ((uint32_t)1<<(EPWM_CTLA_AZRO0_POS))
#define EPWM_CTLA_AZRO1                 ((uint32_t)1<<(EPWM_CTLA_AZRO1_POS))
#define EPWM_CTLA_APRD                 	((uint32_t)0x03<<(EPWM_CTLA_APRD0_POS))
#define EPWM_CTLA_APRD0                 ((uint32_t)1<<(EPWM_CTLA_APRD0_POS))
#define EPWM_CTLA_APRD1                 ((uint32_t)1<<(EPWM_CTLA_APRD1_POS))
#define EPWM_CTLA_ACAU                 	((uint32_t)0x03<<(EPWM_CTLA_ACAU0_POS))
#define EPWM_CTLA_ACAU0                 ((uint32_t)1<<(EPWM_CTLA_ACAU0_POS))
#define EPWM_CTLA_ACAU1                 ((uint32_t)1<<(EPWM_CTLA_ACAU1_POS))
#define EPWM_CTLA_ACAD                 	((uint32_t)0x03<<(EPWM_CTLA_ACAD0_POS))
#define EPWM_CTLA_ACAD0                 ((uint32_t)1<<(EPWM_CTLA_ACAD0_POS))
#define EPWM_CTLA_ACAD1                 ((uint32_t)1<<(EPWM_CTLA_ACAD1_POS))
#define EPWM_CTLA_ACBU                 	((uint32_t)0x03<<(EPWM_CTLA_ACBU0_POS))
#define EPWM_CTLA_ACBU0                 ((uint32_t)1<<(EPWM_CTLA_ACBU0_POS))
#define EPWM_CTLA_ACBU1                 ((uint32_t)1<<(EPWM_CTLA_ACBU1_POS))
#define EPWM_CTLA_ACBD                 	((uint32_t)0x03<<(EPWM_CTLA_ACBD0_POS))
#define EPWM_CTLA_ACBD0                 ((uint32_t)1<<(EPWM_CTLA_ACBD0_POS))
#define EPWM_CTLA_ACBD1                 ((uint32_t)1<<(EPWM_CTLA_ACBD1_POS))
#define EPWM_CTLA_CSFA                 	((uint32_t)0x03<<(EPWM_CTLA_CSFA0_POS))
#define EPWM_CTLA_CSFA0                 ((uint32_t)1<<(EPWM_CTLA_CSFA0_POS))
#define EPWM_CTLA_CSFA1                 ((uint32_t)1<<(EPWM_CTLA_CSFA1_POS))
#define EPWM_CTLA_ACTSFA               	((uint32_t)0x03<<(EPWM_CTLA_ACTSFA0_POS))
#define EPWM_CTLA_ACTSFA0               ((uint32_t)1<<(EPWM_CTLA_ACTSFA0_POS))
#define EPWM_CTLA_ACTSFA1               ((uint32_t)1<<(EPWM_CTLA_ACTSFA1_POS))
#define EPWM_CTLA_OTSFA                	((uint32_t)1<<(EPWM_CTLA_OTSFA_POS))

/*EPWMx_CTLB λ*/
#define EPWM_CTLB_AZRO0_POS             (0)
#define EPWM_CTLB_AZRO1_POS             (1)
#define EPWM_CTLB_APRD0_POS             (2)
#define EPWM_CTLB_APRD1_POS             (3)
#define EPWM_CTLB_ACAU0_POS             (4)
#define EPWM_CTLB_ACAU1_POS             (5)
#define EPWM_CTLB_ACAD0_POS             (6)
#define EPWM_CTLB_ACAD1_POS             (7)
#define EPWM_CTLB_ACBU0_POS             (8)
#define EPWM_CTLB_ACBU1_POS             (9)
#define EPWM_CTLB_ACBD0_POS             (10)
#define EPWM_CTLB_ACBD1_POS             (11)
#define EPWM_CTLB_CSFA0_POS             (12)
#define EPWM_CTLB_CSFA1_POS             (13)
#define EPWM_CTLB_ACTSFA0_POS           (14)
#define EPWM_CTLB_ACTSFA1_POS           (15)
#define EPWM_CTLB_OTSFA_POS             (16)
#define EPWM_CTLB_AZRO                 	((uint32_t)0x03<<(EPWM_CTLB_AZRO0_POS))
#define EPWM_CTLB_AZRO0                 ((uint32_t)1<<(EPWM_CTLB_AZRO0_POS))
#define EPWM_CTLB_AZRO1                 ((uint32_t)1<<(EPWM_CTLB_AZRO1_POS))
#define EPWM_CTLB_APRD                 	((uint32_t)0x03<<(EPWM_CTLB_APRD0_POS))
#define EPWM_CTLB_APRD0                 ((uint32_t)1<<(EPWM_CTLB_APRD0_POS))
#define EPWM_CTLB_APRD1                 ((uint32_t)1<<(EPWM_CTLB_APRD1_POS))
#define EPWM_CTLB_ACAU                 	((uint32_t)0x03<<(EPWM_CTLB_ACAU0_POS))
#define EPWM_CTLB_ACAU0                 ((uint32_t)1<<(EPWM_CTLB_ACAU0_POS))
#define EPWM_CTLB_ACAU1                 ((uint32_t)1<<(EPWM_CTLB_ACAU1_POS))
#define EPWM_CTLB_ACAD                 	((uint32_t)0x03<<(EPWM_CTLB_ACAD0_POS))
#define EPWM_CTLB_ACAD0                 ((uint32_t)1<<(EPWM_CTLB_ACAD0_POS))
#define EPWM_CTLB_ACAD1                 ((uint32_t)1<<(EPWM_CTLB_ACAD1_POS))
#define EPWM_CTLB_ACBU                 	((uint32_t)0x03<<(EPWM_CTLB_ACBU0_POS))
#define EPWM_CTLB_ACBU0                 ((uint32_t)1<<(EPWM_CTLB_ACBU0_POS))
#define EPWM_CTLB_ACBU1                 ((uint32_t)1<<(EPWM_CTLB_ACBU1_POS))
#define EPWM_CTLB_ACBD                 	((uint32_t)0x03<<(EPWM_CTLB_ACBD0_POS))
#define EPWM_CTLB_ACBD0                 ((uint32_t)1<<(EPWM_CTLB_ACBD0_POS))
#define EPWM_CTLB_ACBD1                 ((uint32_t)1<<(EPWM_CTLB_ACBD1_POS))
#define EPWM_CTLB_CSFA                 	((uint32_t)0x03<<(EPWM_CTLB_CSFA0_POS))
#define EPWM_CTLB_CSFA0                 ((uint32_t)1<<(EPWM_CTLB_CSFA0_POS))
#define EPWM_CTLB_CSFA1                 ((uint32_t)1<<(EPWM_CTLB_CSFA1_POS))
#define EPWM_CTLB_ACTSFA               	((uint32_t)0x03<<(EPWM_CTLB_ACTSFA0_POS))
#define EPWM_CTLB_ACTSFA0               ((uint32_t)1<<(EPWM_CTLB_ACTSFA0_POS))
#define EPWM_CTLB_ACTSFA1               ((uint32_t)1<<(EPWM_CTLB_ACTSFA1_POS))
#define EPWM_CTLB_OTSFA                	((uint32_t)1<<(EPWM_CTLB_OTSFA_POS))

/* EPWMx_DBCTL λ */
#define EPWM_DBCTL_OUTMODE0_POS         (0)
#define EPWM_DBCTL_OUTMODE1_POS         (1)
#define EPWM_DBCTL_POLSEL0_POS          (2)
#define EPWM_DBCTL_POLSEL1_POS          (3)
#define EPWM_DBCTL_INMODE0_POS          (4)
#define EPWM_DBCTL_INMODE1_POS          (5)
#define EPWM_DBCTL_OUTMODE              ((uint32_t)0x03<<(EPWM_DBCTL_OUTMODE0_POS))
#define EPWM_DBCTL_OUTMODE0             ((uint32_t)1<<(EPWM_DBCTL_OUTMODE0_POS))
#define EPWM_DBCTL_OUTMODE1             ((uint32_t)1<<(EPWM_DBCTL_OUTMODE1_POS))
#define EPWM_DBCTL_POLSEL               ((uint32_t)0x03<<(EPWM_DBCTL_POLSEL0_POS))
#define EPWM_DBCTL_POLSEL0              ((uint32_t)1<<(EPWM_DBCTL_POLSEL0_POS))
#define EPWM_DBCTL_POLSEL1              ((uint32_t)1<<(EPWM_DBCTL_POLSEL1_POS))
#define EPWM_DBCTL_INMODE               ((uint32_t)0x03<<(EPWM_DBCTL_INMODE0_POS))
#define EPWM_DBCTL_INMODE0              ((uint32_t)1<<(EPWM_DBCTL_INMODE0_POS))
#define EPWM_DBCTL_INMODE1              ((uint32_t)1<<(EPWM_DBCTL_INMODE1_POS))

/* EPWMx_DBTλ */
#define EPWM_DBT_FDBT0_POS              (0)
#define EPWM_DBT_RDBT0_POS              (16)
#define EPWM_DBT_FDBT                 	((uint32_t)0xFFFF<<(EPWM_DBT_FDBT0_POS))
#define EPWM_DBT_RDBT                 	((uint32_t)0xFFFF<<(EPWM_DBT_RDBT0_POS))

/* EPWMx_PCCTLλ */
#define EPWM_PCCTL_CHPEN_POS            (0)
#define EPWM_PCCTL_OSHTWTH0_POS         (1)
#define EPWM_PCCTL_OSHTWTH1_POS         (2)
#define EPWM_PCCTL_OSHTWTH2_POS         (3)
#define EPWM_PCCTL_OSHTWTH3_POS         (4)
#define EPWM_PCCTL_CHPDUTY0_POS         (5)
#define EPWM_PCCTL_CHPDUTY1_POS         (6)
#define EPWM_PCCTL_CHPDUTY2_POS         (7)
#define EPWM_PCCTL_CHPFREQ0_POS         (8)
#define EPWM_PCCTL_CHPFREQ1_POS         (9)
#define EPWM_PCCTL_CHPFREQ2_POS         (10)
#define EPWM_PCCTL_CHPEN                ((uint32_t)1<<(EPWM_PCCTL_CHPEN_POS))
#define EPWM_PCCTL_OSHTWTH              ((uint32_t)0x0F<<(EPWM_PCCTL_OSHTWTH0_POS))
#define EPWM_PCCTL_OSHTWTH0             ((uint32_t)1<<(EPWM_PCCTL_OSHTWTH0_POS))
#define EPWM_PCCTL_OSHTWTH1             ((uint32_t)1<<(EPWM_PCCTL_OSHTWTH1_POS))
#define EPWM_PCCTL_OSHTWTH2             ((uint32_t)1<<(EPWM_PCCTL_OSHTWTH2_POS))
#define EPWM_PCCTL_OSHTWTH3             ((uint32_t)1<<(EPWM_PCCTL_OSHTWTH3_POS))
#define EPWM_PCCTL_CHPDUTY              ((uint32_t)0x07<<(EPWM_PCCTL_CHPDUTY0_POS))
#define EPWM_PCCTL_CHPDUTY0             ((uint32_t)1<<(EPWM_PCCTL_CHPDUTY0_POS))
#define EPWM_PCCTL_CHPDUTY1             ((uint32_t)1<<(EPWM_PCCTL_CHPDUTY1_POS))
#define EPWM_PCCTL_CHPDUTY2             ((uint32_t)1<<(EPWM_PCCTL_CHPDUTY2_POS))
#define EPWM_PCCTL_CHPFREQ              ((uint32_t)0x07<<(EPWM_PCCTL_CHPFREQ0_POS))
#define EPWM_PCCTL_CHPFREQ0             ((uint32_t)1<<(EPWM_PCCTL_CHPFREQ0_POS))
#define EPWM_PCCTL_CHPFREQ1             ((uint32_t)1<<(EPWM_PCCTL_CHPFREQ1_POS))
#define EPWM_PCCTL_CHPFREQ2             ((uint32_t)1<<(EPWM_PCCTL_CHPFREQ2_POS))

/* EPWMx_PXASCTLλ */
#define EPWM_PXASCTL_PXASS0_POS         (0)
#define EPWM_PXASCTL_PXASS1_POS         (1)
#define EPWM_PXASCTL_PXASS2_POS         (2)
#define EPWM_PXASCTL_PXASE_POS          (3)
#define EPWM_PXASCTL_PXSSB0_POS         (4)
#define EPWM_PXASCTL_PXSSB1_POS         (5)
#define EPWM_PXASCTL_PXSSA0_POS         (6)
#define EPWM_PXASCTL_PXSSA1_POS         (7)
#define EPWM_PXASCTL_PXRSEN_POS         (8)
#define EPWM_PXASCTL_PXASS              ((uint32_t)0x07<<(EPWM_PXASCTL_PXASS0_POS))
#define EPWM_PXASCTL_PXASS0             ((uint32_t)1<<(EPWM_PXASCTL_PXASS1_POS))
#define EPWM_PXASCTL_PXASS1             ((uint32_t)1<<(EPWM_PXASCTL_PXASS2_POS))
#define EPWM_PXASCTL_PXASS2             ((uint32_t)1<<(EPWM_PXASCTL_PXASS3_POS))
#define EPWM_PXASCTL_PXASE              ((uint32_t)1<<(EPWM_PXASCTL_PXASE_POS))
#define EPWM_PXASCTL_PXSSB              ((uint32_t)0x03<<(EPWM_PXASCTL_PXSSB0_POS))
#define EPWM_PXASCTL_PXSSB0             ((uint32_t)1<<(EPWM_PXASCTL_PXSSB0_POS))
#define EPWM_PXASCTL_PXSSB1             ((uint32_t)1<<(EPWM_PXASCTL_PXSSB1_POS))
#define EPWM_PXASCTL_PXSSA              ((uint32_t)0x03<<(EPWM_PXASCTL_PXSSA0_POS))
#define EPWM_PXASCTL_PXSSA0             ((uint32_t)1<<(EPWM_PXASCTL_PXSSA0_POS))
#define EPWM_PXASCTL_PXSSA1             ((uint32_t)1<<(EPWM_PXASCTL_PXSSA1_POS))
#define EPWM_PXASCTL_PXRSEN             ((uint32_t)1<<(EPWM_PXASCTL_PXRSEN_POS))

/* EPWMx_ETCTLλ */
#define EPWM_ETCTL_TOADENA_POS          (0)
#define EPWM_ETCTL_SELA0_POS            (1)
#define EPWM_ETCTL_SELA1_POS            (2)
#define EPWM_ETCTL_FRCA_POS             (3)
#define EPWM_ETCTL_APP0_POS             (4)
#define EPWM_ETCTL_APP1_POS             (5)
#define EPWM_ETCTL_AT0_POS             	(6)
#define EPWM_ETCTL_AT1_POS             	(7)
#define EPWM_ETCTL_ATSEL0_POS           (8)
#define EPWM_ETCTL_ATSEL1_POS           (9)
#define EPWM_ETCTL_TOADENB_POS          (16)
#define EPWM_ETCTL_SELB0_POS            (17)
#define EPWM_ETCTL_SELB1_POS            (18)
#define EPWM_ETCTL_FRCB_POS             (19)
#define EPWM_ETCTL_BPP0_POS             (20)
#define EPWM_ETCTL_BPP1_POS             (21)
#define EPWM_ETCTL_BT0_POS              (22)
#define EPWM_ETCTL_BT1_POS              (23)
#define EPWM_ETCTL_BTSEL0_POS           (24)
#define EPWM_ETCTL_BTSEL1_POS           (25)
#define EPWM_ETCTL_TOADENA              ((uint32_t)1<<(EPWM_ETCTL_TOADENA_POS))
#define EPWM_ETCTL_SELA                 ((uint32_t)0x03<<(EPWM_ETCTL_SELA0_POS))
#define EPWM_ETCTL_SELA0                ((uint32_t)1<<(EPWM_ETCTL_SELA0_POS))
#define EPWM_ETCTL_SELA1                ((uint32_t)1<<(EPWM_ETCTL_SELA1_POS))
#define EPWM_ETCTL_FRCA                 ((uint32_t)1<<(EPWM_ETCTL_FRCA_POS))
#define EPWM_ETCTL_APP                 	((uint32_t)0x03<<(EPWM_ETCTL_APP0_POS))
#define EPWM_ETCTL_APP0                 ((uint32_t)1<<(EPWM_ETCTL_APP0_POS))
#define EPWM_ETCTL_APP1                 ((uint32_t)1<<(EPWM_ETCTL_APP1_POS))
#define EPWM_ETCTL_AT                 	((uint32_t)0x03<<(EPWM_ETCTL_AT0_POS))
#define EPWM_ETCTL_AT0                 	((uint32_t)1<<(EPWM_ETCTL_AT0_POS))
#define EPWM_ETCTL_AT1                 	((uint32_t)1<<(EPWM_ETCTL_AT1_POS))
#define EPWM_ETCTL_ATSEL                ((uint32_t)0x03<<(EPWM_ETCTL_ATSEL0_POS))
#define EPWM_ETCTL_ATSEL0               ((uint32_t)1<<(EPWM_ETCTL_ATSEL0_POS))
#define EPWM_ETCTL_ATSEL1               ((uint32_t)1<<(EPWM_ETCTL_ATSEL1_POS))
#define EPWM_ETCTL_TOADENB              ((uint32_t)1<<(EPWM_ETCTL_TOADENB_POS))
#define EPWM_ETCTL_SELB                 ((uint32_t)0x03<<(EPWM_ETCTL_SELB0_POS))
#define EPWM_ETCTL_SELB0                ((uint32_t)1<<(EPWM_ETCTL_SELB0_POS))
#define EPWM_ETCTL_SELB1                ((uint32_t)1<<(EPWM_ETCTL_SELB1_POS))
#define EPWM_ETCTL_FRCB                 ((uint32_t)1<<(EPWM_ETCTL_FRCB_POS))
#define EPWM_ETCTL_BPP                 	((uint32_t)0x03<<(EPWM_ETCTL_BPP0_POS))
#define EPWM_ETCTL_BPP0                 ((uint32_t)1<<(EPWM_ETCTL_BPP0_POS))
#define EPWM_ETCTL_BPP1                 ((uint32_t)1<<(EPWM_ETCTL_BPP1_POS))
#define EPWM_ETCTL_BT                 	((uint32_t)0x03<<(EPWM_ETCTL_BT0_POS))
#define EPWM_ETCTL_BT0                 	((uint32_t)1<<(EPWM_ETCTL_BT0_POS))
#define EPWM_ETCTL_BT1                 	((uint32_t)1<<(EPWM_ETCTL_BT1_POS))
#define EPWM_ETCTL_BTSEL                ((uint32_t)0x03<<(EPWM_ETCTL_BTSEL0_POS))
#define EPWM_ETCTL_BTSEL0               ((uint32_t)1<<(EPWM_ETCTL_BTSEL0_POS))
#define EPWM_ETCTL_BTSEL1               ((uint32_t)1<<(EPWM_ETCTL_BTSEL1_POS))

/* EPWMx_IEλ */
#define EPWM_IE_TXTIE0_POS             	(0)
#define EPWM_IE_TXTIE1_POS             	(1)
#define EPWM_IE_TXGIE_POS             	(2)
#define EPWM_IE_TXUIE_POS             	(3)
#define EPWM_IE_TXIE_POS             	(4)
#define EPWM_IE_TXBIE_POS             	(5)
#define EPWM_IE_TXAIE_POS             	(6)
#define EPWM_IE_TXCIE_POS             	(7)
#define EPWM_IE_TXDIE_POS             	(8)
#define EPWM_IE_TXTIE0                 	((uint32_t)1<<(EPWM_IE_TXTIE0_POS))
#define EPWM_IE_TXTIE1                 	((uint32_t)1<<(EPWM_IE_TXTIE1_POS))
#define EPWM_IE_TXGIE                 	((uint32_t)1<<(EPWM_IE_TXGIE_POS))
#define EPWM_IE_TXUIE                 	((uint32_t)1<<(EPWM_IE_TXUIE_POS))
#define EPWM_IE_TXIE                 	((uint32_t)1<<(EPWM_IE_TXIE_POS))
#define EPWM_IE_TXBIE                 	((uint32_t)1<<(EPWM_IE_TXBIE_POS))
#define EPWM_IE_TXAIE                 	((uint32_t)1<<(EPWM_IE_TXAIE_POS))
#define EPWM_IE_TXCIE                 	((uint32_t)1<<(EPWM_IE_TXCIE_POS))
#define EPWM_IE_TXDIE                 	((uint32_t)1<<(EPWM_IE_TXDIE_POS))

/* EPWMx_IFλ */
#define EPWM_IF_TXTIF0_POS             	(0)
#define EPWM_IF_TXTIF1_POS             	(1)
#define EPWM_IF_TXGIF_POS             	(2)
#define EPWM_IF_TXUIF_POS             	(3)
#define EPWM_IF_TXIF_POS             	(4)
#define EPWM_IF_TXBIF_POS             	(5)
#define EPWM_IF_TXAIF_POS             	(6)
#define EPWM_IF_TXCIF_POS             	(7)
#define EPWM_IF_TXDIF_POS             	(8)
#define EPWM_IF_TXTIF0                 	((uint32_t)1<<(EPWM_IF_TXTIF0_POS))
#define EPWM_IF_TXTIF1                 	((uint32_t)1<<(EPWM_IF_TXTIF1_POS))
#define EPWM_IF_TXGIF                 	((uint32_t)1<<(EPWM_IF_TXGIF_POS))
#define EPWM_IF_TXUIF                 	((uint32_t)1<<(EPWM_IF_TXUIF_POS))
#define EPWM_IF_TXIF                 	((uint32_t)1<<(EPWM_IF_TXIF_POS))
#define EPWM_IF_TXBIF                 	((uint32_t)1<<(EPWM_IF_TXBIF_POS))
#define EPWM_IF_TXAIF                 	((uint32_t)1<<(EPWM_IF_TXAIF_POS))
#define EPWM_IF_TXCIF                 	((uint32_t)1<<(EPWM_IF_TXCIF_POS))
#define EPWM_IF_TXDIF                 	((uint32_t)1<<(EPWM_IF_TXDIF_POS))

/* EPWMx_ICλ */
#define EPWM_IC_TXTIC0_POS             	(0)
#define EPWM_IC_TXTIC1_POS             	(1)
#define EPWM_IC_TXGIC_POS             	(2)
#define EPWM_IC_TXUIC_POS             	(3)
#define EPWM_IC_TXIC_POS             	(4)
#define EPWM_IC_TXBIC_POS             	(5)
#define EPWM_IC_TXAIC_POS             	(6)
#define EPWM_IC_TXCIC_POS             	(7)
#define EPWM_IC_TXDIC_POS             	(8)
#define EPWM_IC_TXTIC0                 	((uint32_t)1<<(EPWM_IC_TXTIC0_POS))
#define EPWM_IC_TXTIC1                 	((uint32_t)1<<(EPWM_IC_TXTIC1_POS))
#define EPWM_IC_TXGIC                 	((uint32_t)1<<(EPWM_IC_TXGIC_POS))
#define EPWM_IC_TXUIC                 	((uint32_t)1<<(EPWM_IC_TXUIC_POS))
#define EPWM_IC_TXIC                 	((uint32_t)1<<(EPWM_IC_TXIC_POS))
#define EPWM_IC_TXBIC                 	((uint32_t)1<<(EPWM_IC_TXBIC_POS))
#define EPWM_IC_TXAIC                 	((uint32_t)1<<(EPWM_IC_TXAIC_POS))
#define EPWM_IC_TXCIC                 	((uint32_t)1<<(EPWM_IC_TXCIC_POS))
#define EPWM_IC_TXDIC                 	((uint32_t)1<<(EPWM_IC_TXDIC_POS))

/* EPWMx_DEλ */
#define EPWM_DE_TXTDE0_POS             	(0)
#define EPWM_DE_TXTDE1_POS             	(1)
#define EPWM_DE_TXGDE_POS             	(2)
#define EPWM_DE_TXUDE_POS             	(3)
#define EPWM_DE_TXDE_POS             	(4)
#define EPWM_DE_TXBDE_POS             	(5)
#define EPWM_DE_TXADE_POS             	(6)
#define EPWM_DE_TXCDE_POS             	(7)
#define EPWM_DE_TXDDE_POS             	(8)
#define EPWM_DE_TXTDE0                 	((uint32_t)1<<(EPWM_DE_TXTDE0_POS))
#define EPWM_DE_TXTDE1                 	((uint32_t)1<<(EPWM_DE_TXTDE1_POS))
#define EPWM_DE_TXGDE                 	((uint32_t)1<<(EPWM_DE_TXGDE_POS))
#define EPWM_DE_TXUDE                 	((uint32_t)1<<(EPWM_DE_TXUDE_POS))
#define EPWM_DE_TXDE                 	((uint32_t)1<<(EPWM_DE_TXDE_POS))
#define EPWM_DE_TXBDE                 	((uint32_t)1<<(EPWM_DE_TXBDE_POS))
#define EPWM_DE_TXADE                 	((uint32_t)1<<(EPWM_DE_TXADE_POS))
#define EPWM_DE_TXCDE                 	((uint32_t)1<<(EPWM_DE_TXCDE_POS))
#define EPWM_DE_TXDDE                 	((uint32_t)1<<(EPWM_DE_TXDDE_POS))

/* EPWMx_DFλ */
#define EPWM_DF_TXTDF0_POS             	(0)
#define EPWM_DF_TXTDF1_POS             	(1)
#define EPWM_DF_TXGDF_POS             	(2)
#define EPWM_DF_TXUDF_POS             	(3)
#define EPWM_DF_TXDF_POS             	(4)
#define EPWM_DF_TXBDF_POS             	(5)
#define EPWM_DF_TXADF_POS             	(6)
#define EPWM_DF_TXCDF_POS             	(7)
#define EPWM_DF_TXDDF_POS             	(8)
#define EPWM_DF_TXTDF0                 	((uint32_t)1<<(EPWM_DF_TXTDF0_POS))
#define EPWM_DF_TXTDF1                 	((uint32_t)1<<(EPWM_DF_TXTDF1_POS))
#define EPWM_DF_TXGDF                 	((uint32_t)1<<(EPWM_DF_TXGDF_POS))
#define EPWM_DF_TXUDF                 	((uint32_t)1<<(EPWM_DF_TXUDF_POS))
#define EPWM_DF_TXDF                 	((uint32_t)1<<(EPWM_DF_TXDF_POS))
#define EPWM_DF_TXBDF                 	((uint32_t)1<<(EPWM_DF_TXBDF_POS))
#define EPWM_DF_TXADF                 	((uint32_t)1<<(EPWM_DF_TXADF_POS))
#define EPWM_DF_TXCDF                 	((uint32_t)1<<(EPWM_DF_TXCDF_POS))
#define EPWM_DF_TXDDF                 	((uint32_t)1<<(EPWM_DF_TXDDF_POS))

/* EPWMx_HRPWMCTLλ */
#define EPWM_HRPWMCTL_HRPEN_POS         (0)
#define EPWM_HRPWMCTL_HRPOUTB_POS       (1)
#define EPWM_HRPWMCTL_HRPEN             ((uint32_t)1<<(EPWM_HRPWMCTL_HRPEN_POS))
#define EPWM_HRPWMCTL_HRPOUTB           ((uint32_t)1<<(EPWM_HRPWMCTL_HRPOUTB_POS))

/* EPWMx_HRCMPλ */
#define EPWM_HRCMP_HRCMP0_POS           (0)
#define EPWM_HRCMP_HRCMP                ((uint32_t)0xFF<<(EPWM_HRCMP_HRCMP0_POS))

/* EPWMx_CAPλ */
#define EPWM_CAP_CAP0_POS           	(0)
#define EPWM_CAP_CAP               		((uint32_t)0xFFFFFFFF<<(EPWM_CAP_CAP0_POS))

/* EPWMx_RCλ */
#define EPWM_RC_EPWMRC0_POS            	(0)
#define EPWM_RC_EPWMRC                	((uint32_t)0xFFFFFFFF<<(EPWM_RC_EPWMRC0_POS))

/* EPWMx_RDλ */
#define EPWM_RD_EPWMRD0_POS            	(0)
#define EPWM_RD_EPWMRD                	((uint32_t)0xFFFFFFFF<<(EPWM_RD_EPWMRD0_POS))

/* EPWMx_UDCTLλ */
#define EPWM_UDCTL_PPUDEN_POS            (0)
#define EPWM_UDCTL_PPUDSEL0_POS          (1)
#define EPWM_UDCTL_PPUDSEL1_POS          (2)
#define EPWM_UDCTL_PRUDEN_POS            (3)
#define EPWM_UDCTL_PRUDSEL0_POS          (4)
#define EPWM_UDCTL_PRUDSEL1_POS          (5)
#define EPWM_UDCTL_CMAUDEN_POS           (6)
#define EPWM_UDCTL_CMAUDSEL0_POS         (7)
#define EPWM_UDCTL_CMAUDSEL1_POS         (8)
#define EPWM_UDCTL_CMBUDEN_POS           (9)
#define EPWM_UDCTL_CMBUDSEL0_POS         (10)
#define EPWM_UDCTL_CMBUDSEL1_POS         (11)
#define EPWM_UDCTL_CMCUDEN_POS           (12)
#define EPWM_UDCTL_CMCUDSEL0_POS         (13)
#define EPWM_UDCTL_CMCUDSEL1_POS         (14)
#define EPWM_UDCTL_CMDUDEN_POS           (15)
#define EPWM_UDCTL_CMDUDSEL0_POS         (16)
#define EPWM_UDCTL_CMDUDSEL1_POS         (17)
#define EPWM_UDCTL_EAUDEN_POS            (18)
#define EPWM_UDCTL_EAUDSEL0_POS          (19)
#define EPWM_UDCTL_EAUDSEL1_POS          (20)
#define EPWM_UDCTL_EBUDEN_POS            (21)
#define EPWM_UDCTL_EBUDSEL0_POS          (22)
#define EPWM_UDCTL_EBUDSEL1_POS          (23)
#define EPWM_UDCTL_HRPUDEN_POS           (24)
#define EPWM_UDCTL_HRPUDSEL0_POS         (25)
#define EPWM_UDCTL_HRPUDSEL1_POS         (26)
#define EPWM_UDCTL_GBUDEN_POS            (27)
#define EPWM_UDCTL_PPUDEN                ((uint32_t)1<<(EPWM_UDCTL_PPUDEN_POS))
#define EPWM_UDCTL_PPUDSEL               ((uint32_t)0x03<<(EPWM_UDCTL_PPUDSEL0_POS))
#define EPWM_UDCTL_PPUDSEL0              ((uint32_t)1<<(EPWM_UDCTL_PPUDSEL0_POS))
#define EPWM_UDCTL_PPUDSEL1              ((uint32_t)1<<(EPWM_UDCTL_PPUDSEL1_POS))
#define EPWM_UDCTL_PRUDEN                ((uint32_t)1<<(EPWM_UDCTL_PRUDEN_POS))
#define EPWM_UDCTL_PRUDSEL               ((uint32_t)0x03<<(EPWM_UDCTL_PRUDSEL0_POS))
#define EPWM_UDCTL_PRUDSEL0              ((uint32_t)1<<(EPWM_UDCTL_PRUDSEL0_POS))
#define EPWM_UDCTL_PRUDSEL1              ((uint32_t)1<<(EPWM_UDCTL_PRUDSEL1_POS))
#define EPWM_UDCTL_CMAUDEN               ((uint32_t)1<<(EPWM_UDCTL_CMAUDEN_POS))
#define EPWM_UDCTL_CMAUDSEL              ((uint32_t)0x03<<(EPWM_UDCTL_CMAUDSEL0_POS))
#define EPWM_UDCTL_CMAUDSEL0             ((uint32_t)1<<(EPWM_UDCTL_CMAUDSEL0_POS))
#define EPWM_UDCTL_CMAUDSEL1             ((uint32_t)1<<(EPWM_UDCTL_CMAUDSEL1_POS))
#define EPWM_UDCTL_CMBUDEN               ((uint32_t)1<<(EPWM_UDCTL_CMBUDEN_POS))
#define EPWM_UDCTL_CMBUDSEL              ((uint32_t)0x03<<(EPWM_UDCTL_CMBUDSEL0_POS))
#define EPWM_UDCTL_CMBUDSEL0             ((uint32_t)1<<(EPWM_UDCTL_CMBUDSEL0_POS))
#define EPWM_UDCTL_CMBUDSEL1             ((uint32_t)1<<(EPWM_UDCTL_CMBUDSEL1_POS))
#define EPWM_UDCTL_CMCUDEN               ((uint32_t)1<<(EPWM_UDCTL_CMCUDEN_POS))
#define EPWM_UDCTL_CMCUDSEL              ((uint32_t)0x03<<(EPWM_UDCTL_CMCUDSEL0_POS))
#define EPWM_UDCTL_CMCUDSEL0             ((uint32_t)1<<(EPWM_UDCTL_CMCUDSEL0_POS))
#define EPWM_UDCTL_CMCUDSEL1             ((uint32_t)1<<(EPWM_UDCTL_CMCUDSEL1_POS))
#define EPWM_UDCTL_CMDUDEN               ((uint32_t)1<<(EPWM_UDCTL_CMDUDEN_POS))
#define EPWM_UDCTL_CMDUDSEL              ((uint32_t)0x03<<(EPWM_UDCTL_CMDUDSEL0_POS))
#define EPWM_UDCTL_CMDUDSEL0             ((uint32_t)1<<(EPWM_UDCTL_CMDUDSEL0_POS))
#define EPWM_UDCTL_CMDUDSEL1             ((uint32_t)1<<(EPWM_UDCTL_CMDUDSEL1_POS))
#define EPWM_UDCTL_EAUDEN                ((uint32_t)1<<(EPWM_UDCTL_EAUDEN_POS))
#define EPWM_UDCTL_EAUDSEL               ((uint32_t)0x03<<(EPWM_UDCTL_EAUDSEL0_POS))
#define EPWM_UDCTL_EAUDSEL0              ((uint32_t)1<<(EPWM_UDCTL_EAUDSEL0_POS))
#define EPWM_UDCTL_EAUDSEL1              ((uint32_t)1<<(EPWM_UDCTL_EAUDSEL1_POS))
#define EPWM_UDCTL_EBUDEN                ((uint32_t)1<<(EPWM_UDCTL_EBUDEN_POS))
#define EPWM_UDCTL_EBUDSEL               ((uint32_t)0x03<<(EPWM_UDCTL_EBUDSEL0_POS))
#define EPWM_UDCTL_EBUDSEL0              ((uint32_t)1<<(EPWM_UDCTL_EBUDSEL0_POS))
#define EPWM_UDCTL_EBUDSEL1              ((uint32_t)1<<(EPWM_UDCTL_EBUDSEL1_POS))
#define EPWM_UDCTL_HRPUDEN               ((uint32_t)1<<(EPWM_UDCTL_HRPUDEN_POS))
#define EPWM_UDCTL_HRPUDSEL              ((uint32_t)0x03<<(EPWM_UDCTL_HRPUDSEL0_POS))
#define EPWM_UDCTL_HRPUDSEL0             ((uint32_t)1<<(EPWM_UDCTL_HRPUDSEL0_POS))
#define EPWM_UDCTL_HRPUDSEL1             ((uint32_t)1<<(EPWM_UDCTL_HRPUDSEL1_POS))
#define EPWM_UDCTL_GBUDEN                ((uint32_t)1<<(EPWM_UDCTL_GBUDEN_POS))
/* ǿ(EPWM) */

#endif

#if 1										/* HRCAP */

/* ----------------------------------------------------------------------------
   -- ߾Ȳ׽ģ(HRCAP)
   ---------------------------------------------------------------------------- */

/* HRCAP - Ĵڴṹ */
typedef struct HRCAP_MenMap
{
	volatile 	   uint32_t CTL;      			/* HRCAPxƼĴ,ƫƣ0x000 */
	volatile const uint32_t COUNTER;      		/* HRCAPxĴ,ƫƣ0x004 */
	volatile const uint32_t RISE[2];      		/* HRCAPx׽Ĵ0,ƫƣ0x008 */
	volatile const uint32_t FALL[2];      		/* HRCAPx½׽Ĵ0,ƫƣ0x010 */
	volatile const uint32_t HRRISE[2];      		/* HRCAPxС׽Ĵ0,ƫƣ0x018 */
	volatile const uint32_t HRFALL[2];      		/* HRCAPx½С׽Ĵ0,ƫƣ0x020 */
	volatile const uint32_t SR;      			/* HRCAPx״̬Ĵ,ƫƣ0x028 */
	volatile       uint32_t SRIC;      			/* HRCAPx״̬Ĵ,ƫƣ0x02C */
	volatile       uint32_t IFRC;      			/* HRCAPx״̬ǿƼĴ,ƫƣ0x030 */
}HRCAP_SFRmap;


/* ----------------------------------------------------------------------------
   -- HRCAP - Ĵں
   ---------------------------------------------------------------------------- */

/* HRCAP - Ĵڵַ */
#define HRCAP0_ADDR						((uint32_t)0x40002400)
#define HRCAP1_ADDR						((uint32_t)0x40002480)
#define HRCAP2_ADDR						((uint32_t)0x40002500)
#define HRCAP0_SFR						((HRCAP_SFRmap *) HRCAP0_ADDR)
#define HRCAP1_SFR						((HRCAP_SFRmap *) HRCAP1_ADDR)
#define HRCAP2_SFR						((HRCAP_SFRmap *) HRCAP2_ADDR)

/* HRCAP - Ĵ */
#define HC0_CTL        					(HRCAP0_SFR->CTL)
#define HC0_COUNTER        				(HRCAP0_SFR->COUNTER)
#define HC0_RISE0        				(HRCAP0_SFR->RISE[0])
#define HC0_RISE1        				(HRCAP0_SFR->RISE[1])
#define HC0_FALL0        				(HRCAP0_SFR->FALL[0])
#define HC0_FALL1        				(HRCAP0_SFR->FALL[1])
#define HC0_HRRISE0        				(HRCAP0_SFR->HRRISE[0])
#define HC0_HRRISE1        				(HRCAP0_SFR->HRRISE[1])
#define HC0_HRFALL0        				(HRCAP0_SFR->HRFALL[0])
#define HC0_HRFALL1        				(HRCAP0_SFR->HRFALL[1])
#define HC0_SR        					(HRCAP0_SFR->SR)
#define HC0_SRIC        				(HRCAP0_SFR->SRIC)
#define HC0_IFRC        				(HRCAP0_SFR->IFRC)
#define HC1_CTL        					(HRCAP1_SFR->CTL)
#define HC1_COUNTER        				(HRCAP1_SFR->COUNTER)
#define HC1_RISE0        				(HRCAP1_SFR->RISE[0])
#define HC1_RISE1        				(HRCAP1_SFR->RISE[1])
#define HC1_FALL0        				(HRCAP1_SFR->FALL[0])
#define HC1_FALL1        				(HRCAP1_SFR->FALL[1])
#define HC1_HRRISE0        				(HRCAP1_SFR->HRRISE[0])
#define HC1_HRRISE1        				(HRCAP1_SFR->HRRISE[1])
#define HC1_HRFALL0        				(HRCAP1_SFR->HRFALL[0])
#define HC1_HRFALL1        				(HRCAP1_SFR->HRFALL[1])
#define HC1_SR        					(HRCAP1_SFR->SR)
#define HC1_SRIC        				(HRCAP1_SFR->SRIC)
#define HC1_IFRC        				(HRCAP1_SFR->IFRC)
#define HC2_CTL        					(HRCAP2_SFR->CTL)
#define HC2_COUNTER        				(HRCAP2_SFR->COUNTER)
#define HC2_RISE0        				(HRCAP2_SFR->RISE[0])
#define HC2_RISE1        				(HRCAP2_SFR->RISE[1])
#define HC2_FALL0        				(HRCAP2_SFR->FALL[0])
#define HC2_FALL1        				(HRCAP2_SFR->FALL[1])
#define HC2_HRRISE0        				(HRCAP2_SFR->HRRISE[0])
#define HC2_HRRISE1        				(HRCAP2_SFR->HRRISE[1])
#define HC2_HRFALL0        				(HRCAP2_SFR->HRFALL[0])
#define HC2_HRFALL1        				(HRCAP2_SFR->HRFALL[1])
#define HC2_SR        					(HRCAP2_SFR->SR)
#define HC2_SRIC        				(HRCAP2_SFR->SRIC)
#define HC2_IFRC        				(HRCAP2_SFR->IFRC)

/* HRCAPx_CTLλ */
#define HRCAP_CTL_HCINSEL_POS           (0)
#define HRCAP_CTL_RISEINTE_POS          (1)
#define HRCAP_CTL_FALLINTE_POS          (2)
#define HRCAP_CTL_OVERINTE_POS          (3)
#define HRCAP_CTL_SOFTRESET_POS         (4)
#define HRCAP_CTL_CLKSEL0_POS           (5)
#define HRCAP_CTL_CLKSEL1_POS           (6)
#define HRCAP_CTL_HCINSEL               ((uint32_t)1<<(HRCAP_CTL_HCINSEL_POS))
#define HRCAP_CTL_RISEINTE              ((uint32_t)1<<(HRCAP_CTL_RISEINTE_POS))
#define HRCAP_CTL_FALLINTE              ((uint32_t)1<<(HRCAP_CTL_FALLINTE_POS))
#define HRCAP_CTL_OVERINTE              ((uint32_t)1<<(HRCAP_CTL_OVERINTE_POS))
#define HRCAP_CTL_SOFTRESET             ((uint32_t)1<<(HRCAP_CTL_SOFTRESET_POS))
#define HRCAP_CTL_CLKSEL                ((uint32_t)0x03<<(HRCAP_CTL_CLKSEL0_POS))
#define HRCAP_CTL_CLKSEL0               ((uint32_t)1<<(HRCAP_CTL_CLKSEL0_POS))
#define HRCAP_CTL_CLKSEL1               ((uint32_t)1<<(HRCAP_CTL_CLKSEL1_POS))

/* HRCAPx_COUNTERλ */
#define HRCAP_COUNTER_COUNTER0_POS      (0)
#define HRCAP_COUNTER_COUNTERSR0_POS    (16)
#define HRCAP_COUNTER_COUNTER           ((uint32_t)0xFFFF<<(HRCAP_COUNTER_COUNTER0_POS))
#define HRCAP_COUNTER_COUNTERSR         ((uint32_t)0xFFFF<<(HRCAP_COUNTER_COUNTERSR0_POS))

/* HRCAPx_RISE0λ */
#define HRCAP_RISE0_RISE0_0_POS         (0)
#define HRCAP_RISE0_RISE0               ((uint32_t)0xFFFF<<(HRCAP_RISE0_RISE0_0_POS))

/* HRCAPx_RISE1λ */
#define HRCAP_RISE1_RISE1_0_POS         (0)
#define HRCAP_RISE1_RISE1               ((uint32_t)0xFFFF<<(HRCAP_RISE1_RISE1_0_POS))

/* HRCAPx_FALL0λ */
#define HRCAP_FALL0_FALL0_0_POS         (0)
#define HRCAP_FALL0_FALL0               ((uint32_t)0xFFFF<<(HRCAP_FALL0_FALL0_0_POS))

/* HRCAPx_FALL1λ */
#define HRCAP_FALL1_FALL1_0_POS         (0)
#define HRCAP_FALL1_FALL1               ((uint32_t)0xFFFF<<(HRCAP_FALL1_FALL1_0_POS))

/* HRCAPx_HRRISE0λ */
#define HRCAP_HRRISE0_HRRISE0_0_POS     (0)
#define HRCAP_HRRISE0_HRRISE0           ((uint32_t)0xFFFF<<(HRCAP_HRRISE0_HRRISE0_0_POS))

/* HRCAPx_HRRISE1λ */
#define HRCAP_HRRISE1_HRRISE1_0_POS     (0)
#define HRCAP_HRRISE1_HRRISE1           ((uint32_t)0xFFFF<<(HRCAP_HRRISE1_HRRISE1_0_POS))

/* HRCAPx_HRFALL0λ */
#define HRCAP_HRFALL0_HRFALL0_0_POS     (0)
#define HRCAP_HRFALL0_HRFALL0           ((uint32_t)0xFFFF<<(HRCAP_HRFALL0_HRFALL0_0_POS))

/* HRCAPx_HRFALL1λ */
#define HRCAP_HRFALL1_HRFALL1_0_POS     (0)
#define HRCAP_HRFALL1_HRFALL1           ((uint32_t)0xFFFF<<(HRCAP_HRFALL1_HRFALL1_0_POS))

/* HRCAPx_SRλ */
#define HRCAP_SR_RISEIF_POS            (1)
#define HRCAP_SR_FALLIF_POS            (2)
#define HRCAP_SR_COUNTEROVF_POS        (3)
#define HRCAP_SR_RISEOVF_POS           (4)
#define HRCAP_SR_RISEIF                ((uint32_t)1<<(HRCAP_SR_RISEIF_POS))
#define HRCAP_SR_FALLIF                ((uint32_t)1<<(HRCAP_SR_FALLIF_POS))
#define HRCAP_SR_COUNTEROVF            ((uint32_t)1<<(HRCAP_SR_COUNTEROVF_POS))
#define HRCAP_SR_RISEOVF               ((uint32_t)1<<(HRCAP_SR_RISEOVF_POS))

/* HRCAPx_SRICλ */
#define HRCAP_SRIC_RISEIC_POS          (1)
#define HRCAP_SRIC_FALLIC_POS          (2)
#define HRCAP_SRIC_COUNTEROVC_POS      (3)
#define HRCAP_SRIC_RISEOVC_POS         (4)
#define HRCAP_SRIC_RISEIC              ((uint32_t)1<<(HRCAP_SRIC_RISEIC_POS))
#define HRCAP_SRIC_FALLIC              ((uint32_t)1<<(HRCAP_SRIC_FALLIC_POS))
#define HRCAP_SRIC_COUNTEROVC          ((uint32_t)1<<(HRCAP_SRIC_COUNTEROVC_POS))
#define HRCAP_SRIC_RISEOVC             ((uint32_t)1<<(HRCAP_SRIC_RISEOVC_POS))

/* HRCAPx_IFRCλ */
#define HRCAP_IFRC_RISEIFRC_POS        (1)
#define HRCAP_IFRC_FALLIFRC_POS        (2)
#define HRCAP_IFRC_COUNTEROVFRC_POS    (3)
#define HRCAP_IFRC_RISEIFRC            ((uint32_t)1<<(HRCAP_IFRC_RISEIFRC_POS))
#define HRCAP_IFRC_FALLIFRC            ((uint32_t)1<<(HRCAP_IFRC_FALLIFRC_POS))
#define HRCAP_IFRC_COUNTEROVFRC        ((uint32_t)1<<(HRCAP_IFRC_COUNTEROVFRC_POS))
/* ߾Ȳ׽(HRCAP) */

#endif

#if 1										/* QEI */

/* ----------------------------------------------------------------------------
   -- · (QEI)
   ---------------------------------------------------------------------------- */

/* QEI - Ĵڴṹ */
typedef struct QEI_MenMap
{
    volatile uint32_t CTL0;             /* QEIƼĴ, ƫ:0x0 */
    volatile uint32_t CTL1;             /* QEI˲ƼĴ, ƫ:0x4 */
    volatile uint32_t CNT;              /* QEI TxĴ, ƫ:0x8 */
    volatile uint32_t PPX;              /* QEI TxڼĴ, ƫ:0xC */
    volatile uint32_t PRSC;             /* QEI TxԤƵ, ƫ:0x10 */
    volatile uint32_t DIER;             /* QEIжϿƼĴ, ƫ:0x14 */
}QEI_SFRmap;

/* ----------------------------------------------------------------------------
   -- QEI - Ĵں
   ---------------------------------------------------------------------------- */
/* QEI - Ĵڵַ */
#define QEI0_ADDR                       ((uint32_t)0x40000500)
#define QEI1_ADDR                       ((uint32_t)0x40000080)
#define QEI0_SFR                        ((QEI_SFRmap *) QEI0_ADDR)
#define QEI1_SFR                        ((QEI_SFRmap *) QEI1_ADDR)
#define T7_ADDR                         ((uint32_t)0x40000500)
#define T8_ADDR                         ((uint32_t)0x40000080)
#define T7_SFR                          QEI0_SFR
#define T8_SFR                          QEI1_SFR

/* QEI - Ĵ */
#define QEI0_CTL0                       (QEI0_SFR->CTL0)
#define QEI0_CTL1                       (QEI0_SFR->CTL1)
#define T7_CNT                          (QEI0_SFR->CNT)
#define T7_PPX                          (QEI0_SFR->PPX)
#define T7_PRSC                         (QEI0_SFR->PRSC)
#define QEI0_DIER                       (QEI0_SFR->DIER)
#define QEI1_CTL0                       (QEI1_SFR->CTL0)
#define QEI1_CTL1                       (QEI1_SFR->CTL1)
#define T8_CNT                          (QEI1_SFR->CNT)
#define T8_PPX                          (QEI1_SFR->PPX)
#define T8_PRSC                         (QEI1_SFR->PRSC)
#define QEI1_DIER                       (QEI1_SFR->DIER)

/* QEIy_CTL0 λ */
#define QEI_CTL0_TXDIR_POS              (0)
#define QEI_CTL0_TXDIROUT_POS           (1)
#define QEI_CTL0_INDEX_POS              (2)
#define QEI_CTL0_TXCS_POS               (3)
#define QEI_CTL0_INDRES_POS             (4)
#define QEI_CTL0_QEIMOD0_POS            (5)
#define QEI_CTL0_QEIMOD1_POS            (6)
#define QEI_CTL0_QEIMOD2_POS            (7)
#define QEI_CTL0_CNTERRIF_POS           (8)
#define QEI_CTL0_PHEIF_POS              (9)
#define QEI_CTL0_TXIF_POS               (10)
#define QEI_CTL0_LPCLK_POS              (11)
#define QEI_CTL0_TXDIR                  ((uint32_t)1<<(QEI_CTL0_TXDIR_POS))
#define QEI_CTL0_TXDIROUT               ((uint32_t)1<<(QEI_CTL0_TXDIROUT_POS))
#define QEI_CTL0_INDEX                  ((uint32_t)1<<(QEI_CTL0_INDEX_POS))
#define QEI_CTL0_TXCS                   ((uint32_t)1<<(QEI_CTL0_TXCS_POS))
#define QEI_CTL0_INDRES                 ((uint32_t)1<<(QEI_CTL0_INDRES_POS))
#define QEI_CTL0_QEIMOD                 ((uint32_t)7<<(QEI_CTL0_QEIMOD0_POS))
#define QEI_CTL0_QEIMOD0                ((uint32_t)1<<(QEI_CTL0_QEIMOD0_POS))
#define QEI_CTL0_QEIMOD1                ((uint32_t)1<<(QEI_CTL0_QEIMOD1_POS))
#define QEI_CTL0_QEIMOD2                ((uint32_t)1<<(QEI_CTL0_QEIMOD2_POS))
#define QEI_CTL0_CNTERRIF               ((uint32_t)1<<(QEI_CTL0_CNTERRIF_POS))
#define QEI_CTL0_PHEIF                  ((uint32_t)1<<(QEI_CTL0_PHEIF_POS))
#define QEI_CTL0_TXIF                   ((uint32_t)1<<(QEI_CTL0_TXIF_POS))
#define QEI_CTL0_LPCLK	                ((uint32_t)1<<(QEI_CTL0_LPCLK_POS))

/* QEIy_CTL1 λ */
#define QEI_CTL1_SWPAB_POS              (0)
#define QEI_CTL1_QEICK0_POS             (1)
#define QEI_CTL1_QEICK1_POS             (2)
#define QEI_CTL1_QEICK2_POS             (3)
#define QEI_CTL1_QEIOUT_POS             (4)
#define QEI_CTL1_QEICLK0_POS            (5)
#define QEI_CTL1_QEICLK1_POS            (6)
#define QEI_CTL1_SWPAB                  ((uint32_t)1<<(QEI_CTL1_SWPAB_POS))
#define QEI_CTL1_QEICK                  ((uint32_t)7<<(QEI_CTL1_QEICK0_POS))
#define QEI_CTL1_QEICK0                 ((uint32_t)1<<(QEI_CTL1_QEICK0_POS))
#define QEI_CTL1_QEICK1                 ((uint32_t)1<<(QEI_CTL1_QEICK1_POS))
#define QEI_CTL1_QEICK2                 ((uint32_t)1<<(QEI_CTL1_QEICK2_POS))
#define QEI_CTL1_QEIOUT                 ((uint32_t)1<<(QEI_CTL1_QEIOUT_POS))
#define QEI_CTL1_QEICLK                 ((uint32_t)3<<(QEI_CTL1_QEICLK0_POS))
#define QEI_CTL1_QEICLK0                ((uint32_t)1<<(QEI_CTL1_QEICLK0_POS))
#define QEI_CTL1_QEICLK1                ((uint32_t)1<<(QEI_CTL1_QEICLK1_POS))

/* Tx_CNT λ */
#define QEI_TXCNT_TXCNT0_POS            (0)
#define QEI_TXCNT_TXCNT                 ((uint32_t)0xFFFF<<(QEI_TXCNT_TXCNT0_POS))

/* Tx_PPX λ */
#define QEI_PPX_PPX0_POS                (0)
#define QEI_PPX_PPX                     ((uint32_t)0xFFFF<<(QEI_PPX_PPX0_POS))

/* Tx_PRSC λ */
#define QEI_TXPRSC_TXPRSC0_POS          (0)
#define QEI_TXPRSC_TXPRSC               ((uint32_t)0xFFFF<<(QEI_TXPRSC_TXPRSC0_POS))

/* QEIy_DIER λ */
#define QEI_DIER_CNTERRIE_POS           (0)
#define QEI_DIER_PHEIE_POS              (1)
#define QEI_DIER_TXIE_POS               (2)
#define QEI_DIER_CNTERRIC_POS           (3)
#define QEI_DIER_PHEIC_POS              (4)
#define QEI_DIER_TXIC_POS               (5)
#define QEI_DIER_CNTERRIE               ((uint32_t)0xFFFF<<(QEI_DIER_CNTERRIE_POS))
#define QEI_DIER_PHEIE                  ((uint32_t)0xFFFF<<(QEI_DIER_PHEIE_POS))
#define QEI_DIER_TXIE                   ((uint32_t)0xFFFF<<(QEI_DIER_TXIE_POS))
#define QEI_DIER_CNTERRIC               ((uint32_t)0xFFFF<<(QEI_DIER_CNTERRIC_POS))
#define QEI_DIER_PHEIC                  ((uint32_t)0xFFFF<<(QEI_DIER_PHEIC_POS))
#define QEI_DIER_TXIC                   ((uint32_t)0xFFFF<<(QEI_DIER_TXIC_POS))
/* ·(QEI) */

#endif

#if 1										/* ADC */


/* ----------------------------------------------------------------------------
   -- ģת(ADC)
   ---------------------------------------------------------------------------- */

/* ADC - Ĵڴṹ */
typedef struct ADC_MemMap {
    volatile       uint32_t CTL0;       /* ADCƼĴ0, ƫ:0x00 */
    volatile       uint32_t CTL1;       /* ADCƼĴ1, ƫ:0x04 */
    volatile       uint32_t SCANSQ0;    /* ADCͨɨüĴ0, ƫ:0x08 */
    volatile       uint32_t SCANSQ1;    /* ADCͨɨüĴ1, ƫ:0x0C */
    volatile       uint32_t SCANSQ2;    /* ADCͨɨüĴ2, ƫ:0x10 */
    volatile       uint32_t HSCANSQ;    /* ADCȼͨɨüĴ, ƫ:0x14 */
    volatile       uint32_t WDH;        /* ADCģ⿴ŹֵĴ, ƫ:0x18 */
    volatile       uint32_t WDL;        /* ADCģ⿴ŹֵĴ, ƫ:0x1C */
    volatile const uint32_t DATA;       /* ADCͨݼĴ, ƫ:0x20 */
    volatile const uint32_t HPDATA0;    /* ADCȼͨݼĴ0, ƫ:0x24 */
    volatile const uint32_t HPDATA1;    /* ADCȼͨݼĴ1, ƫ:0x28 */
    volatile const uint32_t HPDATA2;    /* ADCȼͨݼĴ2, ƫ:0x2C */
    volatile const uint32_t HPDATA3;    /* ADCȼͨݼĴ3, ƫ:0x30 */
    volatile       uint32_t HPDOFF0;     /* ADCȼͨƫƼĴ0, ƫ:0x34 */
    volatile       uint32_t HPDOFF1;     /* ADCȼͨƫƼĴ1, ƫ:0x38 */
    volatile       uint32_t HPDOFF2;     /* ADCȼͨƫƼĴ2, ƫ:0x3C */
    volatile       uint32_t HPDOFF3;     /* ADCȼͨƫƼĴ3, ƫ:0x40 */
    volatile       uint32_t SCANSQ3;    /* ADCͨɨüĴ3, ƫ:0x44 */
                   uint32_t RESERVED[2];/* ַ, ƫ:0x48 */
    volatile       uint32_t STATE;      /* ADC״̬Ĵ, ƫ:0x50 */
    volatile       uint32_t DELAY;      /* ʱĴ,ADC0, ƫ:0x54 */
    volatile	   uint32_t SCANCTL;	/* ADCɨƼĴ, ƫ0x58 */
}ADC_SFRmap;

/* ----------------------------------------------------------------------------
   -- ADC - Ĵں
   ---------------------------------------------------------------------------- */

/* ADC - Ĵڵַ */
#define ADC0_ADDR                       ((uint32_t)0x40000580)
#define ADC1_ADDR                       ((uint32_t)0x40000600)
#define ADC2_ADDR                       ((uint32_t)0x40000680)
#define ADC0_SFR                        ((ADC_SFRmap *) ADC0_ADDR)
#define ADC1_SFR                        ((ADC_SFRmap *) ADC1_ADDR)
#define ADC2_SFR                        ((ADC_SFRmap *) ADC2_ADDR)

/* ADC - Ĵ */
#define ADC0_CTL0                       (ADC0_SFR->CTL0)
#define ADC0_CTL1                       (ADC0_SFR->CTL1)
#define ADC0_SCANSQ0                    (ADC0_SFR->SCANSQ0)
#define ADC0_SCANSQ1                    (ADC0_SFR->SCANSQ1)
#define ADC0_SCANSQ2                    (ADC0_SFR->SCANSQ2)
#define ADC0_SCANSQ3                    (ADC0_SFR->SCANSQ3)
#define ADC0_HSCANSQ                    (ADC0_SFR->HSCANSQ)
#define ADC0_WDH                        (ADC0_SFR->WDH)
#define ADC0_WDL                        (ADC0_SFR->WDL)
#define ADC0_DATA                       (ADC0_SFR->DATA)
#define ADC0_HPDATA0                    (ADC0_SFR->HPDATA0)
#define ADC0_HPDATA1                    (ADC0_SFR->HPDATA1)
#define ADC0_HPDATA2                    (ADC0_SFR->HPDATA2)
#define ADC0_HPDATA3                    (ADC0_SFR->HPDATA3)
#define ADC0_HPDOFF0                    (ADC0_SFR->HPDOFF0)
#define ADC0_HPDOFF1                    (ADC0_SFR->HPDOFF1)
#define ADC0_HPDOFF2                    (ADC0_SFR->HPDOFF2)
#define ADC0_HPDOFF3                    (ADC0_SFR->HPDOFF3)
#define ADC0_STATE                      (ADC0_SFR->STATE)
#define ADC0_DELAY                      (ADC0_SFR->DELAY)
#define	ADC0_SCANCTL					(ADC0_SFR->SCANCTL)
#define ADC1_CTL0                       (ADC1_SFR->CTL0)
#define ADC1_CTL1                       (ADC1_SFR->CTL1)
#define ADC1_SCANSQ0                    (ADC1_SFR->SCANSQ0)
#define ADC1_SCANSQ1                    (ADC1_SFR->SCANSQ1)
#define ADC1_SCANSQ2                    (ADC1_SFR->SCANSQ2)
#define ADC1_SCANSQ3                    (ADC1_SFR->SCANSQ3)
#define ADC1_HSCANSQ                    (ADC1_SFR->HSCANSQ)
#define ADC1_WDH                        (ADC1_SFR->WDH)
#define ADC1_WDL                        (ADC1_SFR->WDL)
#define ADC1_DATA                       (ADC1_SFR->DATA)
#define ADC1_HPDATA0                    (ADC1_SFR->HPDATA0)
#define ADC1_HPDATA1                    (ADC1_SFR->HPDATA1)
#define ADC1_HPDATA2                    (ADC1_SFR->HPDATA2)
#define ADC1_HPDATA3                    (ADC1_SFR->HPDATA3)
#define ADC1_HPDOFF0                    (ADC1_SFR->HPDOFF0)
#define ADC1_HPDOFF1                    (ADC1_SFR->HPDOFF1)
#define ADC1_HPDOFF2                    (ADC1_SFR->HPDOFF2)
#define ADC1_HPDOFF3                    (ADC1_SFR->HPDOFF3)
#define ADC1_STATE                      (ADC1_SFR->STATE)
#define	ADC1_SCANCTL					(ADC1_SFR->SCANCTL)
#define ADC2_CTL0                       (ADC2_SFR->CTL0)
#define ADC2_CTL1                       (ADC2_SFR->CTL1)
#define ADC2_SCANSQ0                    (ADC2_SFR->SCANSQ0)
#define ADC2_SCANSQ1                    (ADC2_SFR->SCANSQ1)
#define ADC2_SCANSQ2                    (ADC2_SFR->SCANSQ2)
#define ADC2_SCANSQ3                    (ADC2_SFR->SCANSQ3)
#define ADC2_HSCANSQ                    (ADC2_SFR->HSCANSQ)
#define ADC2_WDH                        (ADC2_SFR->WDH)
#define ADC2_WDL                        (ADC2_SFR->WDL)
#define ADC2_DATA                       (ADC2_SFR->DATA)
#define ADC2_HPDATA0                    (ADC2_SFR->HPDATA0)
#define ADC2_HPDATA1                    (ADC2_SFR->HPDATA1)
#define ADC2_HPDATA2                    (ADC2_SFR->HPDATA2)
#define ADC2_HPDATA3                    (ADC2_SFR->HPDATA3)
#define ADC2_HPDOFF0                    (ADC2_SFR->HPDOFF0)
#define ADC2_HPDOFF1                    (ADC2_SFR->HPDOFF1)
#define ADC2_HPDOFF2                    (ADC2_SFR->HPDOFF2)
#define ADC2_HPDOFF3                    (ADC2_SFR->HPDOFF3)
#define ADC2_STATE                      (ADC2_SFR->STATE)
#define	ADC2_SCANCTL					(ADC2_SFR->SCANCTL)

/* ADC_CTL0 λ */
#define ADC_CTL0_EN_POS                 (0)
#define ADC_CTL0_CLKS0_POS              (1)
#define ADC_CTL0_CLKS1_POS              (2)
#define ADC_CTL0_LR_POS                 (3)
#define ADC_CTL0_ADCCLKS0_POS           (8)
#define ADC_CTL0_ADCCLKS1_POS           (9)
#define ADC_CTL0_ADCCLKS2_POS           (10)
#define ADC_CTL0_NDMAEN_POS             (13)
#define ADC_CTL0_TRIMIBIAS_POS          (14)
#define ADC_CTL0_BOSSSEL_POS            (15)
#define ADC_CTL0_BOSSSELCOMP_POS        (16)
#define ADC_CTL0_SCANEN_POS             (17)
#define ADC_CTL0_CONT_POS               (18)
#define ADC_CTL0_HPAUTO_POS             (19)
#define ADC_CTL0_DSEN_POS               (20)
#define ADC_CTL0_HPDSEN_POS             (21)
#define ADC_CTL0_HP0DMAEN_POS           (22)
#define ADC_CTL0_HP1DMAEN_POS           (23)
#define ADC_CTL0_HP2DMAEN_POS           (24)
#define ADC_CTL0_HP3DMAEN_POS           (25)
#define ADC_CTL0_DSNUM0_POS             (26)
#define ADC_CTL0_DSNUM1_POS             (27)
#define ADC_CTL0_DSNUM2_POS             (28)
#define ADC_CTL0_WDEN_POS               (29)
#define ADC_CTL0_HPWDEN_POS             (30)
#define ADC_CTL0_WDSCH_POS              (31)
#define ADC_CTL0_EN                     ((uint32_t)1<<(ADC_CTL0_EN_POS))
#define ADC_CTL0_CLKS                   ((uint32_t)3<<(ADC_CTL0_CLKS0_POS))
#define ADC_CTL0_CLKS0                  ((uint32_t)1<<(ADC_CTL0_CLKS0_POS))
#define ADC_CTL0_CLKS1                  ((uint32_t)1<<(ADC_CTL0_CLKS1_POS))
#define ADC_CTL0_LR                     ((uint32_t)1<<(ADC_CTL0_LR_POS))
#define ADC_CTL0_ADCCLKS                ((uint32_t)7<<(ADC_CTL0_ADCCLKS0_POS))
#define ADC_CTL0_ADCCLKS0               ((uint32_t)1<<(ADC_CTL0_ADCCLKS0_POS))
#define ADC_CTL0_ADCCLKS1               ((uint32_t)1<<(ADC_CTL0_ADCCLKS1_POS))
#define ADC_CTL0_ADCCLKS2               ((uint32_t)1<<(ADC_CTL0_ADCCLKS2_POS))
#define ADC_CTL0_NDMAEN                  ((uint32_t)1<<(ADC_CTL0_NDMAEN_POS))
#define ADC_CTL0_TRIMIBIAS              ((uint32_t)1<<(ADC_CTL0_TRIMIBIAS_POS))
#define ADC_CTL0_BOSSSEL                ((uint32_t)1<<(ADC_CTL0_BOSSSEL_POS))
#define ADC_CTL0_BOSSSELCOMP            ((uint32_t)1<<(ADC_CTL0_BOSSSELCOMP_POS))
#define ADC_CTL0_SCANEN                 ((uint32_t)1<<(ADC_CTL0_SCANEN_POS))
#define ADC_CTL0_CONT                   ((uint32_t)1<<(ADC_CTL0_CONT_POS))
#define ADC_CTL0_HPAUTO                 ((uint32_t)1<<(ADC_CTL0_HPAUTO_POS))
#define ADC_CTL0_DSEN                   ((uint32_t)1<<(ADC_CTL0_DSEN_POS))
#define ADC_CTL0_HPDSEN                 ((uint32_t)1<<(ADC_CTL0_HPDSEN_POS))
#define ADC_CTL0_HP0DMAEN               ((uint32_t)1<<(ADC_CTL0_HP0DMAEN_POS))
#define ADC_CTL0_HP1DMAEN               ((uint32_t)1<<(ADC_CTL0_HP1DMAEN_POS))
#define ADC_CTL0_HP2DMAEN               ((uint32_t)1<<(ADC_CTL0_HP2DMAEN_POS))
#define ADC_CTL0_HP3DMAEN               ((uint32_t)1<<(ADC_CTL0_HP3DMAEN_POS))
#define ADC_CTL0_DSNUM                  ((uint32_t)7<<(ADC_CTL0_DSNUM0_POS))
#define ADC_CTL0_DSNUM0                 ((uint32_t)1<<(ADC_CTL0_DSNUM0_POS))
#define ADC_CTL0_DSNUM1                 ((uint32_t)1<<(ADC_CTL0_DSNUM1_POS))
#define ADC_CTL0_DSNUM2                 ((uint32_t)1<<(ADC_CTL0_DSNUM2_POS))
#define ADC_CTL0_WDEN                   ((uint32_t)1<<(ADC_CTL0_WDEN_POS))
#define ADC_CTL0_HPWDEN                 ((uint32_t)1<<(ADC_CTL0_HPWDEN_POS))
#define ADC_CTL0_WDSCH                  ((uint32_t)1<<(ADC_CTL0_WDSCH_POS))

/* ADC_CTL1 λ */
#define ADC_CTL1_START_POS              (2)
#define ADC_CTL1_HPSTART_POS            (3)
#define ADC_CTL1_NCH0_POS               (4)
#define ADC_CTL1_NCH1_POS               (5)
#define ADC_CTL1_NCH2_POS               (6)
#define ADC_CTL1_NCH3_POS               (7)
#define ADC_CTL1_NCH4_POS               (8)
#define ADC_CTL1_NCH5_POS               (9)
#define ADC_CTL1_NCH6_POS               (10)
#define ADC_CTL1_EXTEN_POS              (11)
#define ADC_CTL1_REF0_POS               (17)
#define ADC_CTL1_REF1_POS               (18)
#define ADC_CTL1_REF2_POS               (19)
#define ADC_CTL1_HCH0_POS               (20)
#define ADC_CTL1_HCH1_POS               (21)
#define ADC_CTL1_HCH2_POS               (22)
#define ADC_CTL1_HCH3_POS               (23)
#define ADC_CTL1_HCH4_POS               (24)
#define ADC_CTL1_HCH5_POS               (25)
#define ADC_CTL1_HCH6_POS               (26)
#define ADC_CTL1_HPEXTEN_POS            (27)
#define ADC_CTL1_DOUMOD0_POS            (28)
#define ADC_CTL1_DOUMOD1_POS            (29)
#define ADC_CTL1_DOUMOD2_POS            (30)
#define ADC_CTL1_DOUMOD3_POS            (31)
#define ADC_CTL1_START                  ((uint32_t)1<<(ADC_CTL1_START_POS))
#define ADC_CTL1_HPSTART                ((uint32_t)1<<(ADC_CTL1_HPSTART_POS))
#define ADC_CTL1_NCH                    ((uint32_t)0x7F<<(ADC_CTL1_NCH0_POS))
#define ADC_CTL1_NCH0                   ((uint32_t)1<<(ADC_CTL1_NCH0_POS))
#define ADC_CTL1_NCH1                   ((uint32_t)1<<(ADC_CTL1_NCH1_POS))
#define ADC_CTL1_NCH2                   ((uint32_t)1<<(ADC_CTL1_NCH2_POS))
#define ADC_CTL1_NCH3                   ((uint32_t)1<<(ADC_CTL1_NCH3_POS))
#define ADC_CTL1_NCH4                   ((uint32_t)1<<(ADC_CTL1_NCH4_POS))
#define ADC_CTL1_NCH5                   ((uint32_t)1<<(ADC_CTL1_NCH5_POS))
#define ADC_CTL1_NCH6                   ((uint32_t)1<<(ADC_CTL1_NCH6_POS))
#define ADC_CTL1_EXTEN                  ((uint32_t)1<<(ADC_CTL1_EXTEN_POS))
#define ADC_CTL1_REF                    ((uint32_t)7<<(ADC_CTL1_REF0_POS))
#define ADC_CTL1_REF0                   ((uint32_t)1<<(ADC_CTL1_REF0_POS))
#define ADC_CTL1_REF1                   ((uint32_t)1<<(ADC_CTL1_REF1_POS))
#define ADC_CTL1_REF2                   ((uint32_t)1<<(ADC_CTL1_REF2_POS))
#define ADC_CTL1_HCH                    ((uint32_t)0x7F<<(ADC_CTL1_HCH0_POS))
#define ADC_CTL1_HCH0                   ((uint32_t)1<<(ADC_CTL1_HCH0_POS))
#define ADC_CTL1_HCH1                   ((uint32_t)1<<(ADC_CTL1_HCH1_POS))
#define ADC_CTL1_HCH2                   ((uint32_t)1<<(ADC_CTL1_HCH2_POS))
#define ADC_CTL1_HCH3                   ((uint32_t)1<<(ADC_CTL1_HCH3_POS))
#define ADC_CTL1_HCH4                   ((uint32_t)1<<(ADC_CTL1_HCH4_POS))
#define ADC_CTL1_HCH5                   ((uint32_t)1<<(ADC_CTL1_HCH5_POS))
#define ADC_CTL1_HCH6                   ((uint32_t)1<<(ADC_CTL1_HCH6_POS))
#define ADC_CTL1_HPEXTEN                ((uint32_t)1<<(ADC_CTL1_HPEXTEN_POS))
#define ADC_CTL1_DOUMOD                 ((uint32_t)0xF<<(ADC_CTL1_DOUMOD0_POS))
#define ADC_CTL1_DOUMOD0                ((uint32_t)1<<(ADC_CTL1_DOUMOD0_POS))
#define ADC_CTL1_DOUMOD1                ((uint32_t)1<<(ADC_CTL1_DOUMOD1_POS))
#define ADC_CTL1_DOUMOD2                ((uint32_t)1<<(ADC_CTL1_DOUMOD2_POS))
#define ADC_CTL1_DOUMOD3                ((uint32_t)1<<(ADC_CTL1_DOUMOD3_POS))

/* ADC_SCANSQ0 λ */
#define ADC_SCANSQ0_SSQ0_0_POS          (0)
#define ADC_SCANSQ0_SSQ0_1_POS          (1)
#define ADC_SCANSQ0_SSQ0_2_POS          (2)
#define ADC_SCANSQ0_SSQ0_3_POS          (3)
#define ADC_SCANSQ0_SSQ0_4_POS          (4)
#define ADC_SCANSQ0_SSQ0_5_POS          (5)
#define ADC_SCANSQ0_SSQ0_6_POS          (6)
#define ADC_SCANSQ0_SSQ0_7_POS          (7)
#define ADC_SCANSQ0_SSQ1_0_POS          (8)
#define ADC_SCANSQ0_SSQ1_1_POS          (9)
#define ADC_SCANSQ0_SSQ1_2_POS          (10)
#define ADC_SCANSQ0_SSQ1_3_POS          (11)
#define ADC_SCANSQ0_SSQ1_4_POS          (12)
#define ADC_SCANSQ0_SSQ1_5_POS          (13)
#define ADC_SCANSQ0_SSQ1_6_POS          (14)
#define ADC_SCANSQ0_SSQ1_7_POS          (15)
#define ADC_SCANSQ0_SSQ2_0_POS          (16)
#define ADC_SCANSQ0_SSQ2_1_POS          (17)
#define ADC_SCANSQ0_SSQ2_2_POS          (18)
#define ADC_SCANSQ0_SSQ2_3_POS          (19)
#define ADC_SCANSQ0_SSQ2_4_POS          (20)
#define ADC_SCANSQ0_SSQ2_5_POS          (21)
#define ADC_SCANSQ0_SSQ2_6_POS          (22)
#define ADC_SCANSQ0_SSQ2_7_POS          (23)
#define ADC_SCANSQ0_SSQ3_0_POS          (24)
#define ADC_SCANSQ0_SSQ3_1_POS          (25)
#define ADC_SCANSQ0_SSQ3_2_POS          (26)
#define ADC_SCANSQ0_SSQ3_3_POS          (27)
#define ADC_SCANSQ0_SSQ3_4_POS          (28)
#define ADC_SCANSQ0_SSQ3_5_POS          (29)
#define ADC_SCANSQ0_SSQ3_6_POS          (30)
#define ADC_SCANSQ0_SSQ3_7_POS          (31)
#define ADC_SCANSQ0_SSQ0                ((uint32_t)0xFF<<(ADC_SCANSQ0_SSQ0_0_POS))
#define ADC_SCANSQ0_SSQ0_0              ((uint32_t)1<<(ADC_SCANSQ0_SSQ0_0_POS))
#define ADC_SCANSQ0_SSQ0_1              ((uint32_t)1<<(ADC_SCANSQ0_SSQ0_1_POS))
#define ADC_SCANSQ0_SSQ0_2              ((uint32_t)1<<(ADC_SCANSQ0_SSQ0_2_POS))
#define ADC_SCANSQ0_SSQ0_3              ((uint32_t)1<<(ADC_SCANSQ0_SSQ0_3_POS))
#define ADC_SCANSQ0_SSQ0_4              ((uint32_t)1<<(ADC_SCANSQ0_SSQ0_4_POS))
#define ADC_SCANSQ0_SSQ0_5              ((uint32_t)1<<(ADC_SCANSQ0_SSQ0_5_POS))
#define ADC_SCANSQ0_SSQ0_6              ((uint32_t)1<<(ADC_SCANSQ0_SSQ0_6_POS))
#define ADC_SCANSQ0_SSQ0_7              ((uint32_t)1<<(ADC_SCANSQ0_SSQ0_7_POS))
#define ADC_SCANSQ0_SSQ1                ((uint32_t)0xFF<<(ADC_SCANSQ0_SSQ1_0_POS))
#define ADC_SCANSQ0_SSQ1_0              ((uint32_t)1<<(ADC_SCANSQ0_SSQ1_0_POS))
#define ADC_SCANSQ0_SSQ1_1              ((uint32_t)1<<(ADC_SCANSQ0_SSQ1_1_POS))
#define ADC_SCANSQ0_SSQ1_2              ((uint32_t)1<<(ADC_SCANSQ0_SSQ1_2_POS))
#define ADC_SCANSQ0_SSQ1_3              ((uint32_t)1<<(ADC_SCANSQ0_SSQ1_3_POS))
#define ADC_SCANSQ0_SSQ1_4              ((uint32_t)1<<(ADC_SCANSQ0_SSQ1_4_POS))
#define ADC_SCANSQ0_SSQ1_5              ((uint32_t)1<<(ADC_SCANSQ0_SSQ1_5_POS))
#define ADC_SCANSQ0_SSQ1_6              ((uint32_t)1<<(ADC_SCANSQ0_SSQ1_6_POS))
#define ADC_SCANSQ0_SSQ1_7              ((uint32_t)1<<(ADC_SCANSQ0_SSQ1_7_POS))
#define ADC_SCANSQ0_SSQ2                ((uint32_t)0xFF<<(ADC_SCANSQ0_SSQ2_0_POS))
#define ADC_SCANSQ0_SSQ2_0              ((uint32_t)1<<(ADC_SCANSQ0_SSQ2_0_POS))
#define ADC_SCANSQ0_SSQ2_1              ((uint32_t)1<<(ADC_SCANSQ0_SSQ2_1_POS))
#define ADC_SCANSQ0_SSQ2_2              ((uint32_t)1<<(ADC_SCANSQ0_SSQ2_2_POS))
#define ADC_SCANSQ0_SSQ2_3              ((uint32_t)1<<(ADC_SCANSQ0_SSQ2_3_POS))
#define ADC_SCANSQ0_SSQ2_4              ((uint32_t)1<<(ADC_SCANSQ0_SSQ2_4_POS))
#define ADC_SCANSQ0_SSQ2_5              ((uint32_t)1<<(ADC_SCANSQ0_SSQ2_5_POS))
#define ADC_SCANSQ0_SSQ2_6              ((uint32_t)1<<(ADC_SCANSQ0_SSQ2_6_POS))
#define ADC_SCANSQ0_SSQ2_7              ((uint32_t)1<<(ADC_SCANSQ0_SSQ2_7_POS))
#define ADC_SCANSQ0_SSQ3                ((uint32_t)0xFF<<(ADC_SCANSQ0_SSQ3_0_POS))
#define ADC_SCANSQ0_SSQ3_0              ((uint32_t)1<<(ADC_SCANSQ0_SSQ3_0_POS))
#define ADC_SCANSQ0_SSQ3_1              ((uint32_t)1<<(ADC_SCANSQ0_SSQ3_1_POS))
#define ADC_SCANSQ0_SSQ3_2              ((uint32_t)1<<(ADC_SCANSQ0_SSQ3_2_POS))
#define ADC_SCANSQ0_SSQ3_3              ((uint32_t)1<<(ADC_SCANSQ0_SSQ3_3_POS))
#define ADC_SCANSQ0_SSQ3_4              ((uint32_t)1<<(ADC_SCANSQ0_SSQ3_4_POS))
#define ADC_SCANSQ0_SSQ3_5              ((uint32_t)1<<(ADC_SCANSQ0_SSQ3_5_POS))
#define ADC_SCANSQ0_SSQ3_6              ((uint32_t)1<<(ADC_SCANSQ0_SSQ3_6_POS))
#define ADC_SCANSQ0_SSQ3_7              ((uint32_t)1<<(ADC_SCANSQ0_SSQ3_7_POS))

/* ADC_SCANSQ1 λ */
#define ADC_SCANSQ1_SSQ4_0_POS          (0)
#define ADC_SCANSQ1_SSQ4_1_POS          (1)
#define ADC_SCANSQ1_SSQ4_2_POS          (2)
#define ADC_SCANSQ1_SSQ4_3_POS          (3)
#define ADC_SCANSQ1_SSQ4_4_POS          (4)
#define ADC_SCANSQ1_SSQ4_5_POS          (5)
#define ADC_SCANSQ1_SSQ4_6_POS          (6)
#define ADC_SCANSQ1_SSQ4_7_POS          (7)
#define ADC_SCANSQ1_SSQ5_0_POS          (8)
#define ADC_SCANSQ1_SSQ5_1_POS          (9)
#define ADC_SCANSQ1_SSQ5_2_POS          (10)
#define ADC_SCANSQ1_SSQ5_3_POS          (11)
#define ADC_SCANSQ1_SSQ5_4_POS          (12)
#define ADC_SCANSQ1_SSQ5_5_POS          (13)
#define ADC_SCANSQ1_SSQ5_6_POS          (14)
#define ADC_SCANSQ1_SSQ5_7_POS          (15)
#define ADC_SCANSQ1_SSQ6_0_POS          (16)
#define ADC_SCANSQ1_SSQ6_1_POS          (17)
#define ADC_SCANSQ1_SSQ6_2_POS          (18)
#define ADC_SCANSQ1_SSQ6_3_POS          (19)
#define ADC_SCANSQ1_SSQ6_4_POS          (20)
#define ADC_SCANSQ1_SSQ6_5_POS          (21)
#define ADC_SCANSQ1_SSQ6_6_POS          (22)
#define ADC_SCANSQ1_SSQ6_7_POS          (23)
#define ADC_SCANSQ1_SSQ7_0_POS          (24)
#define ADC_SCANSQ1_SSQ7_1_POS          (25)
#define ADC_SCANSQ1_SSQ7_2_POS          (26)
#define ADC_SCANSQ1_SSQ7_3_POS          (27)
#define ADC_SCANSQ1_SSQ7_4_POS          (28)
#define ADC_SCANSQ1_SSQ7_5_POS          (29)
#define ADC_SCANSQ1_SSQ7_6_POS          (30)
#define ADC_SCANSQ1_SSQ7_7_POS          (31)
#define ADC_SCANSQ1_SSQ4                ((uint32_t)0xFF<<(ADC_SCANSQ1_SSQ4_0_POS))
#define ADC_SCANSQ1_SSQ4_0              ((uint32_t)1<<(ADC_SCANSQ1_SSQ4_0_POS))
#define ADC_SCANSQ1_SSQ4_1              ((uint32_t)1<<(ADC_SCANSQ1_SSQ4_1_POS))
#define ADC_SCANSQ1_SSQ4_2              ((uint32_t)1<<(ADC_SCANSQ1_SSQ4_2_POS))
#define ADC_SCANSQ1_SSQ4_3              ((uint32_t)1<<(ADC_SCANSQ1_SSQ4_3_POS))
#define ADC_SCANSQ1_SSQ4_4              ((uint32_t)1<<(ADC_SCANSQ1_SSQ4_4_POS))
#define ADC_SCANSQ1_SSQ4_5              ((uint32_t)1<<(ADC_SCANSQ1_SSQ4_5_POS))
#define ADC_SCANSQ1_SSQ4_6              ((uint32_t)1<<(ADC_SCANSQ1_SSQ4_6_POS))
#define ADC_SCANSQ1_SSQ4_7              ((uint32_t)1<<(ADC_SCANSQ1_SSQ4_7_POS))
#define ADC_SCANSQ1_SSQ5                ((uint32_t)0xFF<<(ADC_SCANSQ1_SSQ5_0_POS))
#define ADC_SCANSQ1_SSQ5_0              ((uint32_t)1<<(ADC_SCANSQ1_SSQ5_0_POS))
#define ADC_SCANSQ1_SSQ5_1              ((uint32_t)1<<(ADC_SCANSQ1_SSQ5_1_POS))
#define ADC_SCANSQ1_SSQ5_2              ((uint32_t)1<<(ADC_SCANSQ1_SSQ5_2_POS))
#define ADC_SCANSQ1_SSQ5_3              ((uint32_t)1<<(ADC_SCANSQ1_SSQ5_3_POS))
#define ADC_SCANSQ1_SSQ5_4              ((uint32_t)1<<(ADC_SCANSQ1_SSQ5_4_POS))
#define ADC_SCANSQ1_SSQ5_5              ((uint32_t)1<<(ADC_SCANSQ1_SSQ5_5_POS))
#define ADC_SCANSQ1_SSQ5_6              ((uint32_t)1<<(ADC_SCANSQ1_SSQ5_6_POS))
#define ADC_SCANSQ1_SSQ5_7              ((uint32_t)1<<(ADC_SCANSQ1_SSQ5_7_POS))
#define ADC_SCANSQ1_SSQ6                ((uint32_t)0xFF<<(ADC_SCANSQ1_SSQ6_0_POS))
#define ADC_SCANSQ1_SSQ6_0              ((uint32_t)1<<(ADC_SCANSQ1_SSQ6_0_POS))
#define ADC_SCANSQ1_SSQ6_1              ((uint32_t)1<<(ADC_SCANSQ1_SSQ6_1_POS))
#define ADC_SCANSQ1_SSQ6_2              ((uint32_t)1<<(ADC_SCANSQ1_SSQ6_2_POS))
#define ADC_SCANSQ1_SSQ6_3              ((uint32_t)1<<(ADC_SCANSQ1_SSQ6_3_POS))
#define ADC_SCANSQ1_SSQ6_4              ((uint32_t)1<<(ADC_SCANSQ1_SSQ6_4_POS))
#define ADC_SCANSQ1_SSQ6_5              ((uint32_t)1<<(ADC_SCANSQ1_SSQ6_5_POS))
#define ADC_SCANSQ1_SSQ6_6              ((uint32_t)1<<(ADC_SCANSQ1_SSQ6_6_POS))
#define ADC_SCANSQ1_SSQ6_7              ((uint32_t)1<<(ADC_SCANSQ1_SSQ6_7_POS))
#define ADC_SCANSQ1_SSQ7                ((uint32_t)0xFF<<(ADC_SCANSQ1_SSQ7_0_POS))
#define ADC_SCANSQ1_SSQ7_0              ((uint32_t)1<<(ADC_SCANSQ1_SSQ7_0_POS))
#define ADC_SCANSQ1_SSQ7_1              ((uint32_t)1<<(ADC_SCANSQ1_SSQ7_1_POS))
#define ADC_SCANSQ1_SSQ7_2              ((uint32_t)1<<(ADC_SCANSQ1_SSQ7_2_POS))
#define ADC_SCANSQ1_SSQ7_3              ((uint32_t)1<<(ADC_SCANSQ1_SSQ7_3_POS))
#define ADC_SCANSQ1_SSQ7_4              ((uint32_t)1<<(ADC_SCANSQ1_SSQ7_4_POS))
#define ADC_SCANSQ1_SSQ7_5              ((uint32_t)1<<(ADC_SCANSQ1_SSQ7_5_POS))
#define ADC_SCANSQ1_SSQ7_6              ((uint32_t)1<<(ADC_SCANSQ1_SSQ7_6_POS))
#define ADC_SCANSQ1_SSQ7_7              ((uint32_t)1<<(ADC_SCANSQ1_SSQ7_7_POS))

/* ADC_SCANSQ2 λ */
#define ADC_SCANSQ2_SSQ8_0_POS          (0)
#define ADC_SCANSQ2_SSQ8_1_POS          (1)
#define ADC_SCANSQ2_SSQ8_2_POS          (2)
#define ADC_SCANSQ2_SSQ8_3_POS          (3)
#define ADC_SCANSQ2_SSQ8_4_POS          (4)
#define ADC_SCANSQ2_SSQ8_5_POS          (5)
#define ADC_SCANSQ2_SSQ8_6_POS          (6)
#define ADC_SCANSQ2_SSQ8_7_POS          (7)
#define ADC_SCANSQ2_SSQ9_0_POS          (8)
#define ADC_SCANSQ2_SSQ9_1_POS          (9)
#define ADC_SCANSQ2_SSQ9_2_POS          (10)
#define ADC_SCANSQ2_SSQ9_3_POS          (11)
#define ADC_SCANSQ2_SSQ9_4_POS          (12)
#define ADC_SCANSQ2_SSQ9_5_POS          (13)
#define ADC_SCANSQ2_SSQ9_6_POS          (14)
#define ADC_SCANSQ2_SSQ9_7_POS          (15)
#define ADC_SCANSQ2_SSQ10_0_POS          (16)
#define ADC_SCANSQ2_SSQ10_1_POS          (17)
#define ADC_SCANSQ2_SSQ10_2_POS          (18)
#define ADC_SCANSQ2_SSQ10_3_POS          (19)
#define ADC_SCANSQ2_SSQ10_4_POS          (20)
#define ADC_SCANSQ2_SSQ10_5_POS          (21)
#define ADC_SCANSQ2_SSQ10_6_POS          (22)
#define ADC_SCANSQ2_SSQ10_7_POS          (23)
#define ADC_SCANSQ2_SSQ11_0_POS          (24)
#define ADC_SCANSQ2_SSQ11_1_POS          (25)
#define ADC_SCANSQ2_SSQ11_2_POS          (26)
#define ADC_SCANSQ2_SSQ11_3_POS          (27)
#define ADC_SCANSQ2_SSQ11_4_POS          (28)
#define ADC_SCANSQ2_SSQ11_5_POS          (29)
#define ADC_SCANSQ2_SSQ11_6_POS          (30)
#define ADC_SCANSQ2_SSQ11_7_POS          (31)
#define ADC_SCANSQ2_SSQ8                ((uint32_t)0xFF<<(ADC_SCANSQ2_SSQ8_0_POS))
#define ADC_SCANSQ2_SSQ8_0              ((uint32_t)1<<(ADC_SCANSQ2_SSQ8_0_POS))
#define ADC_SCANSQ2_SSQ8_1              ((uint32_t)1<<(ADC_SCANSQ2_SSQ8_1_POS))
#define ADC_SCANSQ2_SSQ8_2              ((uint32_t)1<<(ADC_SCANSQ2_SSQ8_2_POS))
#define ADC_SCANSQ2_SSQ8_3              ((uint32_t)1<<(ADC_SCANSQ2_SSQ8_3_POS))
#define ADC_SCANSQ2_SSQ8_4              ((uint32_t)1<<(ADC_SCANSQ2_SSQ8_4_POS))
#define ADC_SCANSQ2_SSQ8_5              ((uint32_t)1<<(ADC_SCANSQ2_SSQ8_5_POS))
#define ADC_SCANSQ2_SSQ8_6              ((uint32_t)1<<(ADC_SCANSQ2_SSQ8_6_POS))
#define ADC_SCANSQ2_SSQ8_7              ((uint32_t)1<<(ADC_SCANSQ2_SSQ8_7_POS))
#define ADC_SCANSQ2_SSQ9                ((uint32_t)0xFF<<(ADC_SCANSQ2_SSQ9_0_POS))
#define ADC_SCANSQ2_SSQ9_0              ((uint32_t)1<<(ADC_SCANSQ2_SSQ9_0_POS))
#define ADC_SCANSQ2_SSQ9_1              ((uint32_t)1<<(ADC_SCANSQ2_SSQ9_1_POS))
#define ADC_SCANSQ2_SSQ9_2              ((uint32_t)1<<(ADC_SCANSQ2_SSQ9_2_POS))
#define ADC_SCANSQ2_SSQ9_3              ((uint32_t)1<<(ADC_SCANSQ2_SSQ9_3_POS))
#define ADC_SCANSQ2_SSQ9_4              ((uint32_t)1<<(ADC_SCANSQ2_SSQ9_4_POS))
#define ADC_SCANSQ2_SSQ9_5              ((uint32_t)1<<(ADC_SCANSQ2_SSQ9_5_POS))
#define ADC_SCANSQ2_SSQ9_6              ((uint32_t)1<<(ADC_SCANSQ2_SSQ9_6_POS))
#define ADC_SCANSQ2_SSQ9_7              ((uint32_t)1<<(ADC_SCANSQ2_SSQ9_7_POS))
#define ADC_SCANSQ2_SSQ10                ((uint32_t)0xFF<<(ADC_SCANSQ2_SSQ10_0_POS))
#define ADC_SCANSQ2_SSQ10_0              ((uint32_t)1<<(ADC_SCANSQ2_SSQ10_0_POS))
#define ADC_SCANSQ2_SSQ10_1              ((uint32_t)1<<(ADC_SCANSQ2_SSQ10_1_POS))
#define ADC_SCANSQ2_SSQ10_2              ((uint32_t)1<<(ADC_SCANSQ2_SSQ10_2_POS))
#define ADC_SCANSQ2_SSQ10_3              ((uint32_t)1<<(ADC_SCANSQ2_SSQ10_3_POS))
#define ADC_SCANSQ2_SSQ10_4              ((uint32_t)1<<(ADC_SCANSQ2_SSQ10_4_POS))
#define ADC_SCANSQ2_SSQ10_5              ((uint32_t)1<<(ADC_SCANSQ2_SSQ10_5_POS))
#define ADC_SCANSQ2_SSQ10_6              ((uint32_t)1<<(ADC_SCANSQ2_SSQ10_6_POS))
#define ADC_SCANSQ2_SSQ10_7              ((uint32_t)1<<(ADC_SCANSQ2_SSQ10_7_POS))
#define ADC_SCANSQ2_SSQ11                ((uint32_t)0xFF<<(ADC_SCANSQ2_SSQ11_0_POS))
#define ADC_SCANSQ2_SSQ11_0              ((uint32_t)1<<(ADC_SCANSQ2_SSQ11_0_POS))
#define ADC_SCANSQ2_SSQ11_1              ((uint32_t)1<<(ADC_SCANSQ2_SSQ11_1_POS))
#define ADC_SCANSQ2_SSQ11_2              ((uint32_t)1<<(ADC_SCANSQ2_SSQ11_2_POS))
#define ADC_SCANSQ2_SSQ11_3              ((uint32_t)1<<(ADC_SCANSQ2_SSQ11_3_POS))
#define ADC_SCANSQ2_SSQ11_4              ((uint32_t)1<<(ADC_SCANSQ2_SSQ11_4_POS))
#define ADC_SCANSQ2_SSQ11_5              ((uint32_t)1<<(ADC_SCANSQ2_SSQ11_5_POS))
#define ADC_SCANSQ2_SSQ11_6              ((uint32_t)1<<(ADC_SCANSQ2_SSQ11_6_POS))
#define ADC_SCANSQ2_SSQ11_7              ((uint32_t)1<<(ADC_SCANSQ2_SSQ11_7_POS))

/* ADC_SCANSQ3 λ */
#define ADC_SCANSQ3_SSQ12_0_POS          (0)
#define ADC_SCANSQ3_SSQ12_1_POS          (1)
#define ADC_SCANSQ3_SSQ12_2_POS          (2)
#define ADC_SCANSQ3_SSQ12_3_POS          (3)
#define ADC_SCANSQ3_SSQ12_4_POS          (4)
#define ADC_SCANSQ3_SSQ12_5_POS          (5)
#define ADC_SCANSQ3_SSQ12_6_POS          (6)
#define ADC_SCANSQ3_SSQ12_7_POS          (7)
#define ADC_SCANSQ3_SSQ13_0_POS          (8)
#define ADC_SCANSQ3_SSQ13_1_POS          (9)
#define ADC_SCANSQ3_SSQ13_2_POS          (10)
#define ADC_SCANSQ3_SSQ13_3_POS          (11)
#define ADC_SCANSQ3_SSQ13_4_POS          (12)
#define ADC_SCANSQ3_SSQ13_5_POS          (13)
#define ADC_SCANSQ3_SSQ13_6_POS          (14)
#define ADC_SCANSQ3_SSQ13_7_POS          (15)
#define ADC_SCANSQ3_SSQ14_0_POS          (16)
#define ADC_SCANSQ3_SSQ14_1_POS          (17)
#define ADC_SCANSQ3_SSQ14_2_POS          (18)
#define ADC_SCANSQ3_SSQ14_3_POS          (19)
#define ADC_SCANSQ3_SSQ14_4_POS          (20)
#define ADC_SCANSQ3_SSQ14_5_POS          (21)
#define ADC_SCANSQ3_SSQ14_6_POS          (22)
#define ADC_SCANSQ3_SSQ14_7_POS          (23)
#define ADC_SCANSQ3_SSQ15_0_POS          (24)
#define ADC_SCANSQ3_SSQ15_1_POS          (25)
#define ADC_SCANSQ3_SSQ15_2_POS          (26)
#define ADC_SCANSQ3_SSQ15_3_POS          (27)
#define ADC_SCANSQ3_SSQ15_4_POS          (28)
#define ADC_SCANSQ3_SSQ15_5_POS          (29)
#define ADC_SCANSQ3_SSQ15_6_POS          (30)
#define ADC_SCANSQ3_SSQ15_7_POS          (31)
#define ADC_SCANSQ3_SSQ12                ((uint32_t)0xFF<<(ADC_SCANSQ3_SSQ12_0_POS))
#define ADC_SCANSQ3_SSQ12_0              ((uint32_t)1<<(ADC_SCANSQ3_SSQ12_0_POS))
#define ADC_SCANSQ3_SSQ12_1              ((uint32_t)1<<(ADC_SCANSQ3_SSQ12_1_POS))
#define ADC_SCANSQ3_SSQ12_2              ((uint32_t)1<<(ADC_SCANSQ3_SSQ12_2_POS))
#define ADC_SCANSQ3_SSQ12_3              ((uint32_t)1<<(ADC_SCANSQ3_SSQ12_3_POS))
#define ADC_SCANSQ3_SSQ12_4              ((uint32_t)1<<(ADC_SCANSQ3_SSQ12_4_POS))
#define ADC_SCANSQ3_SSQ12_5              ((uint32_t)1<<(ADC_SCANSQ3_SSQ12_5_POS))
#define ADC_SCANSQ3_SSQ12_6              ((uint32_t)1<<(ADC_SCANSQ3_SSQ12_6_POS))
#define ADC_SCANSQ3_SSQ12_7              ((uint32_t)1<<(ADC_SCANSQ3_SSQ12_7_POS))
#define ADC_SCANSQ3_SSQ13                ((uint32_t)0xFF<<(ADC_SCANSQ3_SSQ13_0_POS))
#define ADC_SCANSQ3_SSQ13_0              ((uint32_t)1<<(ADC_SCANSQ3_SSQ13_0_POS))
#define ADC_SCANSQ3_SSQ13_1              ((uint32_t)1<<(ADC_SCANSQ3_SSQ13_1_POS))
#define ADC_SCANSQ3_SSQ13_2              ((uint32_t)1<<(ADC_SCANSQ3_SSQ13_2_POS))
#define ADC_SCANSQ3_SSQ13_3              ((uint32_t)1<<(ADC_SCANSQ3_SSQ13_3_POS))
#define ADC_SCANSQ3_SSQ13_4              ((uint32_t)1<<(ADC_SCANSQ3_SSQ13_4_POS))
#define ADC_SCANSQ3_SSQ13_5              ((uint32_t)1<<(ADC_SCANSQ3_SSQ13_5_POS))
#define ADC_SCANSQ3_SSQ13_6              ((uint32_t)1<<(ADC_SCANSQ3_SSQ13_6_POS))
#define ADC_SCANSQ3_SSQ13_7              ((uint32_t)1<<(ADC_SCANSQ3_SSQ13_7_POS))
#define ADC_SCANSQ3_SSQ14                ((uint32_t)0xFF<<(ADC_SCANSQ3_SSQ14_0_POS))
#define ADC_SCANSQ3_SSQ14_0              ((uint32_t)1<<(ADC_SCANSQ3_SSQ14_0_POS))
#define ADC_SCANSQ3_SSQ14_1              ((uint32_t)1<<(ADC_SCANSQ3_SSQ14_1_POS))
#define ADC_SCANSQ3_SSQ14_2              ((uint32_t)1<<(ADC_SCANSQ3_SSQ14_2_POS))
#define ADC_SCANSQ3_SSQ14_3              ((uint32_t)1<<(ADC_SCANSQ3_SSQ14_3_POS))
#define ADC_SCANSQ3_SSQ14_4              ((uint32_t)1<<(ADC_SCANSQ3_SSQ14_4_POS))
#define ADC_SCANSQ3_SSQ14_5              ((uint32_t)1<<(ADC_SCANSQ3_SSQ14_5_POS))
#define ADC_SCANSQ3_SSQ14_6              ((uint32_t)1<<(ADC_SCANSQ3_SSQ14_6_POS))
#define ADC_SCANSQ3_SSQ14_7              ((uint32_t)1<<(ADC_SCANSQ3_SSQ14_7_POS))
#define ADC_SCANSQ3_SSQ15                ((uint32_t)0xFF<<(ADC_SCANSQ3_SSQ15_0_POS))
#define ADC_SCANSQ3_SSQ15_0              ((uint32_t)1<<(ADC_SCANSQ3_SSQ15_0_POS))
#define ADC_SCANSQ3_SSQ15_1              ((uint32_t)1<<(ADC_SCANSQ3_SSQ15_1_POS))
#define ADC_SCANSQ3_SSQ15_2              ((uint32_t)1<<(ADC_SCANSQ3_SSQ15_2_POS))
#define ADC_SCANSQ3_SSQ15_3              ((uint32_t)1<<(ADC_SCANSQ3_SSQ15_3_POS))
#define ADC_SCANSQ3_SSQ15_4              ((uint32_t)1<<(ADC_SCANSQ3_SSQ15_4_POS))
#define ADC_SCANSQ3_SSQ15_5              ((uint32_t)1<<(ADC_SCANSQ3_SSQ15_5_POS))
#define ADC_SCANSQ3_SSQ15_6              ((uint32_t)1<<(ADC_SCANSQ3_SSQ15_6_POS))
#define ADC_SCANSQ3_SSQ15_7              ((uint32_t)1<<(ADC_SCANSQ3_SSQ15_7_POS))

/* ADC_HSCANSQ λ */
#define ADC_HSCANSQ_HSSQ0_0_POS          (0)
#define ADC_HSCANSQ_HSSQ0_1_POS          (1)
#define ADC_HSCANSQ_HSSQ0_2_POS          (2)
#define ADC_HSCANSQ_HSSQ0_3_POS          (3)
#define ADC_HSCANSQ_HSSQ0_4_POS          (4)
#define ADC_HSCANSQ_HSSQ0_5_POS          (5)
#define ADC_HSCANSQ_HSSQ0_6_POS          (6)
#define ADC_HSCANSQ_HSSQ0_7_POS          (7)
#define ADC_HSCANSQ_HSSQ1_0_POS          (8)
#define ADC_HSCANSQ_HSSQ1_1_POS          (9)
#define ADC_HSCANSQ_HSSQ1_2_POS          (10)
#define ADC_HSCANSQ_HSSQ1_3_POS          (11)
#define ADC_HSCANSQ_HSSQ1_4_POS          (12)
#define ADC_HSCANSQ_HSSQ1_5_POS          (13)
#define ADC_HSCANSQ_HSSQ1_6_POS          (14)
#define ADC_HSCANSQ_HSSQ1_7_POS          (15)
#define ADC_HSCANSQ_HSSQ2_0_POS          (16)
#define ADC_HSCANSQ_HSSQ2_1_POS          (17)
#define ADC_HSCANSQ_HSSQ2_2_POS          (18)
#define ADC_HSCANSQ_HSSQ2_3_POS          (19)
#define ADC_HSCANSQ_HSSQ2_4_POS          (20)
#define ADC_HSCANSQ_HSSQ2_5_POS          (21)
#define ADC_HSCANSQ_HSSQ2_6_POS          (22)
#define ADC_HSCANSQ_HSSQ2_7_POS          (23)
#define ADC_HSCANSQ_HSSQ3_0_POS          (24)
#define ADC_HSCANSQ_HSSQ3_1_POS          (25)
#define ADC_HSCANSQ_HSSQ3_2_POS          (26)
#define ADC_HSCANSQ_HSSQ3_3_POS          (27)
#define ADC_HSCANSQ_HSSQ3_4_POS          (28)
#define ADC_HSCANSQ_HSSQ3_5_POS          (29)
#define ADC_HSCANSQ_HSSQ3_6_POS          (30)
#define ADC_HSCANSQ_HSSQ3_7_POS          (31)
#define ADC_HSCANSQ_HSSQ0                ((uint32_t)0xFF<<(ADC_HSCANSQ_HSSQ0_0_POS))
#define ADC_HSCANSQ_HSSQ0_0              ((uint32_t)1<<(ADC_HSCANSQ_HSSQ0_0_POS))
#define ADC_HSCANSQ_HSSQ0_1              ((uint32_t)1<<(ADC_HSCANSQ_HSSQ0_1_POS))
#define ADC_HSCANSQ_HSSQ0_2              ((uint32_t)1<<(ADC_HSCANSQ_HSSQ0_2_POS))
#define ADC_HSCANSQ_HSSQ0_3              ((uint32_t)1<<(ADC_HSCANSQ_HSSQ0_3_POS))
#define ADC_HSCANSQ_HSSQ0_4              ((uint32_t)1<<(ADC_HSCANSQ_HSSQ0_4_POS))
#define ADC_HSCANSQ_HSSQ0_5              ((uint32_t)1<<(ADC_HSCANSQ_HSSQ0_5_POS))
#define ADC_HSCANSQ_HSSQ0_6              ((uint32_t)1<<(ADC_HSCANSQ_HSSQ0_6_POS))
#define ADC_HSCANSQ_HSSQ0_7              ((uint32_t)1<<(ADC_HSCANSQ_HSSQ0_7_POS))
#define ADC_HSCANSQ_HSSQ1                ((uint32_t)0xFF<<(ADC_HSCANSQ_HSSQ1_0_POS))
#define ADC_HSCANSQ_HSSQ1_0              ((uint32_t)1<<(ADC_HSCANSQ_HSSQ1_0_POS))
#define ADC_HSCANSQ_HSSQ1_1              ((uint32_t)1<<(ADC_HSCANSQ_HSSQ1_1_POS))
#define ADC_HSCANSQ_HSSQ1_2              ((uint32_t)1<<(ADC_HSCANSQ_HSSQ1_2_POS))
#define ADC_HSCANSQ_HSSQ1_3              ((uint32_t)1<<(ADC_HSCANSQ_HSSQ1_3_POS))
#define ADC_HSCANSQ_HSSQ1_4              ((uint32_t)1<<(ADC_HSCANSQ_HSSQ1_4_POS))
#define ADC_HSCANSQ_HSSQ1_5              ((uint32_t)1<<(ADC_HSCANSQ_HSSQ1_5_POS))
#define ADC_HSCANSQ_HSSQ1_6              ((uint32_t)1<<(ADC_HSCANSQ_HSSQ1_6_POS))
#define ADC_HSCANSQ_HSSQ1_7              ((uint32_t)1<<(ADC_HSCANSQ_HSSQ1_7_POS))
#define ADC_HSCANSQ_HSSQ2                ((uint32_t)0xFF<<(ADC_HSCANSQ_HSSQ2_0_POS))
#define ADC_HSCANSQ_HSSQ2_0              ((uint32_t)1<<(ADC_HSCANSQ_HSSQ2_0_POS))
#define ADC_HSCANSQ_HSSQ2_1              ((uint32_t)1<<(ADC_HSCANSQ_HSSQ2_1_POS))
#define ADC_HSCANSQ_HSSQ2_2              ((uint32_t)1<<(ADC_HSCANSQ_HSSQ2_2_POS))
#define ADC_HSCANSQ_HSSQ2_3              ((uint32_t)1<<(ADC_HSCANSQ_HSSQ2_3_POS))
#define ADC_HSCANSQ_HSSQ2_4              ((uint32_t)1<<(ADC_HSCANSQ_HSSQ2_4_POS))
#define ADC_HSCANSQ_HSSQ2_5              ((uint32_t)1<<(ADC_HSCANSQ_HSSQ2_5_POS))
#define ADC_HSCANSQ_HSSQ2_6              ((uint32_t)1<<(ADC_HSCANSQ_HSSQ2_6_POS))
#define ADC_HSCANSQ_HSSQ2_7              ((uint32_t)1<<(ADC_HSCANSQ_HSSQ2_7_POS))
#define ADC_HSCANSQ_HSSQ3                ((uint32_t)0xFF<<(ADC_HSCANSQ_HSSQ3_0_POS))
#define ADC_HSCANSQ_HSSQ3_0              ((uint32_t)1<<(ADC_HSCANSQ_HSSQ3_0_POS))
#define ADC_HSCANSQ_HSSQ3_1              ((uint32_t)1<<(ADC_HSCANSQ_HSSQ3_1_POS))
#define ADC_HSCANSQ_HSSQ3_2              ((uint32_t)1<<(ADC_HSCANSQ_HSSQ3_2_POS))
#define ADC_HSCANSQ_HSSQ3_3              ((uint32_t)1<<(ADC_HSCANSQ_HSSQ3_3_POS))
#define ADC_HSCANSQ_HSSQ3_4              ((uint32_t)1<<(ADC_HSCANSQ_HSSQ3_4_POS))
#define ADC_HSCANSQ_HSSQ3_5              ((uint32_t)1<<(ADC_HSCANSQ_HSSQ3_5_POS))
#define ADC_HSCANSQ_HSSQ3_6              ((uint32_t)1<<(ADC_HSCANSQ_HSSQ3_6_POS))
#define ADC_HSCANSQ_HSSQ3_7              ((uint32_t)1<<(ADC_HSCANSQ_HSSQ3_7_POS))

/* ADCx_SCANCTLλ */
#define ADC_SCANCTL_SLEN0_POS            (0)
#define ADC_SCANCTL_SLEN1_POS            (1)
#define ADC_SCANCTL_SLEN2_POS            (2)
#define ADC_SCANCTL_SLEN3_POS            (3)
#define ADC_SCANCTL_HSLEN0_POS           (4)
#define ADC_SCANCTL_HSLEN1_POS           (5)
#define ADC_SCANCTL_WDCH0_POS            (16)
#define ADC_SCANCTL_WDCH1_POS            (17)
#define ADC_SCANCTL_WDCH2_POS            (18)
#define ADC_SCANCTL_WDCH3_POS            (19)
#define ADC_SCANCTL_WDCH4_POS            (20)
#define ADC_SCANCTL_WDCH5_POS            (21)
#define ADC_SCANCTL_WDCH6_POS            (22)
#define ADC_SCANCTL_SAMSE0_POS           (24)
#define ADC_SCANCTL_SAMSE1_POS           (25)
#define ADC_SCANCTL_SAMSE2_POS           (26)
#define ADC_SCANCTL_SAMSE3_POS           (27)
#define ADC_SCANCTL_SLEN                 ((uint32_t)0x0F<<(ADC_SCANCTL_SLEN0_POS))
#define ADC_SCANCTL_SLEN0                ((uint32_t)1<<(ADC_SCANCTL_SLEN0_POS))
#define ADC_SCANCTL_SLEN1                ((uint32_t)1<<(ADC_SCANCTL_SLEN1_POS))
#define ADC_SCANCTL_SLEN2                ((uint32_t)1<<(ADC_SCANCTL_SLEN2_POS))
#define ADC_SCANCTL_SLEN3                ((uint32_t)1<<(ADC_SCANCTL_SLEN3_POS))
#define ADC_SCANCTL_HSLEN                ((uint32_t)0x03<<(ADC_SCANCTL_HSLEN0_POS))
#define ADC_SCANCTL_HSLEN0               ((uint32_t)1<<(ADC_SCANCTL_HSLEN0_POS))
#define ADC_SCANCTL_HSLEN1               ((uint32_t)1<<(ADC_SCANCTL_HSLEN1_POS))
#define ADC_SCANCTL_WDCH                 ((uint32_t)0x7F<<(ADC_SCANCTL_WDCH0_POS))
#define ADC_SCANCTL_WDCH0                ((uint32_t)1<<(ADC_SCANCTL_WDCH0_POS))
#define ADC_SCANCTL_WDCH1                ((uint32_t)1<<(ADC_SCANCTL_WDCH1_POS))
#define ADC_SCANCTL_WDCH2                ((uint32_t)1<<(ADC_SCANCTL_WDCH2_POS))
#define ADC_SCANCTL_WDCH3                ((uint32_t)1<<(ADC_SCANCTL_WDCH3_POS))
#define ADC_SCANCTL_WDCH4                ((uint32_t)1<<(ADC_SCANCTL_WDCH4_POS))
#define ADC_SCANCTL_WDCH5                ((uint32_t)1<<(ADC_SCANCTL_WDCH5_POS))
#define ADC_SCANCTL_WDCH6                ((uint32_t)1<<(ADC_SCANCTL_WDCH6_POS))
#define ADC_SCANCTL_SAMSE                ((uint32_t)0x0F<<(ADC_SCANCTL_SAMSE0_POS))
#define ADC_SCANCTL_SAMSE0               ((uint32_t)1<<(ADC_SCANCTL_SAMSE0_POS))
#define ADC_SCANCTL_SAMSE1               ((uint32_t)1<<(ADC_SCANCTL_SAMSE1_POS))
#define ADC_SCANCTL_SAMSE2               ((uint32_t)1<<(ADC_SCANCTL_SAMSE2_POS))
#define ADC_SCANCTL_SAMSE3               ((uint32_t)1<<(ADC_SCANCTL_SAMSE3_POS))

/* ADC_WDH λ */
#define ADC_WDH_WDH0_POS                (0)
#define ADC_WDH_WDH                     ((uint32_t)0xFFF<<(ADC_WDH_WDH0_POS))

/* ADC_WDL λ */
#define ADC_WDL_WDL0_POS                (0)
#define ADC_WDL_WDL                     ((uint32_t)0xFFF<<(ADC_WDL_WDL0_POS))

/* ADC_DATA λ */
#define ADC_DATA_DATA0_POS              (0)
#define ADC_DATA_DATA                   ((uint32_t)0xFFFF<<(ADC_DATA_DATA0_POS))

/* ADC_HPDATA λ */
#define ADC_HPDATA_HPDATA0_POS          (0)
#define ADC_HPDATA_HPDATA               ((uint32_t)0xFFFF<<(ADC_HPDATA_HPDATA0_POS))

/* ADC_HPDOFF λ */
#define ADC_HPDOFF_HPDOFF0_POS          (0)
#define ADC_HPDOFF_HPDOFF               ((uint32_t)0xFFFF<<(ADC_HPDOFF_HPDOFF0_POS))

/* ADC_STATE λ */
#define ADC_STATE_STARTIF_POS           (0)
#define ADC_STATE_HPSTARTIF_POS         (1)
#define ADC_STATE_ENDIF_POS             (2)
#define ADC_STATE_HPENDIF_POS           (3)
#define ADC_STATE_WDIF_POS              (4)
#define ADC_STATE_ENDIC_POS             (5)
#define ADC_STATE_HPENDIC_POS           (6)
#define ADC_STATE_WDIC_POS              (7)
#define ADC_STATE_ENDIE_POS             (8)
#define ADC_STATE_HPENDIE_POS           (9)
#define ADC_STATE_WDIE_POS              (10)
#define ADC_STATE_EOCIF_POS             (11)
#define ADC_STATE_EOCIC_POS             (12)
#define ADC_STATE_EOCIE_POS             (13)
#define ADC_STATE_CCR0N_POS             (14)
#define ADC_STATE_CCR0H_POS             (15)
#define ADC_STATE_CCR1N_POS             (16)
#define ADC_STATE_CCR1H_POS             (17)
#define ADC_STATE_CCR2N_POS             (18)
#define ADC_STATE_CCR2H_POS             (19)
#define ADC_STATE_TSSELTOADCIS0_POS     (26)
#define ADC_STATE_TRIMIBIASOPA_POS      (27)
#define ADC_STATE_TSSELTOADCIS1_POS     (28)
#define ADC_STATE_TSSELTOADCIS2_POS     (29)
#define ADC_STATE_TRIMERROR0_POS        (30)
#define ADC_STATE_TRIMERROR1_POS        (31)
#define ADC_STATE_STARTIF               ((uint32_t)1<<(ADC_STATE_STARTIF_POS))
#define ADC_STATE_HPSTARTIF             ((uint32_t)1<<(ADC_STATE_HPSTARTIF_POS))
#define ADC_STATE_ENDIF                 ((uint32_t)1<<(ADC_STATE_ENDIF_POS))
#define ADC_STATE_HPENDIF               ((uint32_t)1<<(ADC_STATE_HPENDIF_POS))
#define ADC_STATE_WDIF                  ((uint32_t)1<<(ADC_STATE_WDIF_POS))
#define ADC_STATE_ENDIC                 ((uint32_t)1<<(ADC_STATE_ENDIC_POS))
#define ADC_STATE_HPENDIC               ((uint32_t)1<<(ADC_STATE_HPENDIC_POS))
#define ADC_STATE_WDIC                  ((uint32_t)1<<(ADC_STATE_WDIC_POS))
#define ADC_STATE_ENDIE                 ((uint32_t)1<<(ADC_STATE_ENDIE_POS))
#define ADC_STATE_HPENDIE               ((uint32_t)1<<(ADC_STATE_HPENDIE_POS))
#define ADC_STATE_WDIE                  ((uint32_t)1<<(ADC_STATE_WDIE_POS))
#define ADC_STATE_EOCIF                 ((uint32_t)1<<(ADC_STATE_EOCIF_POS))
#define ADC_STATE_EOCIC                 ((uint32_t)1<<(ADC_STATE_EOCIC_POS))
#define ADC_STATE_EOCIE                 ((uint32_t)1<<(ADC_STATE_EOCIE_POS))
#define ADC_STATE_CCR0N                 ((uint32_t)1<<(ADC_STATE_CCR0N_POS))
#define ADC_STATE_CCR0H                 ((uint32_t)1<<(ADC_STATE_CCR0H_POS))
#define ADC_STATE_CCR1N                 ((uint32_t)1<<(ADC_STATE_CCR1N_POS))
#define ADC_STATE_CCR1H                 ((uint32_t)1<<(ADC_STATE_CCR1H_POS))
#define ADC_STATE_CCR2N                 ((uint32_t)1<<(ADC_STATE_CCR2N_POS))
#define ADC_STATE_CCR2H                 ((uint32_t)1<<(ADC_STATE_CCR2H_POS))
#define ADC_STATE_TSSELTOADCIS          ((uint32_t)0xD<<(ADC_STATE_TSSELTOADCIS0_POS))
#define ADC_STATE_TSSELTOADCIS0         ((uint32_t)1<<(ADC_STATE_TSSELTOADCIS0_POS))
#define ADC_STATE_TRIMIBIASOPA          ((uint32_t)1<<(ADC_STATE_TRIMIBIASOPA_POS))
#define ADC_STATE_TSSELTOADCIS1         ((uint32_t)1<<(ADC_STATE_TSSELTOADCIS1_POS))
#define ADC_STATE_TSSELTOADCIS2         ((uint32_t)1<<(ADC_STATE_TSSELTOADCIS2_POS))
#define ADC_STATE_TRIMERROR             ((uint32_t)3<<(ADC_STATE_TRIMERROR0_POS))
#define ADC_STATE_TRIMERROR0            ((uint32_t)1<<(ADC_STATE_TRIMERROR0_POS))
#define ADC_STATE_TRIMERROR1            ((uint32_t)1<<(ADC_STATE_TRIMERROR1_POS))

/* ADC0_DELAY λ */
#define ADC0_DELAY_FDELAY0_POS          (0)
#define ADC0_DELAY_FDELAY1_POS          (1)
#define ADC0_DELAY_FDELAY2_POS          (2)
#define ADC0_DELAY_FDELAY3_POS          (3)
#define ADC0_DELAY_FDELAY4_POS          (4)
#define ADC0_DELAY_FDELAY5_POS          (5)
#define ADC0_DELAY_FDELAY               ((uint32_t)0x3F<<(ADC0_DELAY_FDELAY0_POS))
#define ADC0_DELAY_FDELAY0              ((uint32_t)1<<(ADC0_DELAY_FDELAY0_POS))
#define ADC0_DELAY_FDELAY1              ((uint32_t)1<<(ADC0_DELAY_FDELAY1_POS))
#define ADC0_DELAY_FDELAY2              ((uint32_t)1<<(ADC0_DELAY_FDELAY2_POS))
#define ADC0_DELAY_FDELAY3              ((uint32_t)1<<(ADC0_DELAY_FDELAY3_POS))
#define ADC0_DELAY_FDELAY4              ((uint32_t)1<<(ADC0_DELAY_FDELAY4_POS))
#define ADC0_DELAY_FDELAY5              ((uint32_t)1<<(ADC0_DELAY_FDELAY5_POS))
/* ģת(ADC) */

#endif

#if 1										/* DAC */


/* ----------------------------------------------------------------------------
   -- ģתģ (DAC)
   ---------------------------------------------------------------------------- */

/* DAC - Ĵڴṹ */
typedef struct DAC_MemMap
{
    volatile       uint32_t CTL;        /* DACƼĴ, ƫ:0x0 */
    volatile       uint32_t DAHD;       /* DACݱּĴ, ƫ:0x4 */
    volatile const uint32_t DATA;       /* DACݼĴ, ƫ:0x8 */
    volatile       uint32_t CTL1;       /* DACƼĴ1, ƫ:0xC */
                   uint32_t RESERVED;   /* ַ, ƫ:0x10 */
    volatile       uint32_t CAL;        /* DACУĴ, ƫ:0x14 */
}DAC_SFRmap;

/* ----------------------------------------------------------------------------
   -- DAC - Ĵں
   ---------------------------------------------------------------------------- */

/* DAC - Ĵڵַ */
#define DAC0_ADDR                       ((uint32_t)0x40000700)
#define DAC1_ADDR                       ((uint32_t)0x40000780)
#define DAC2_ADDR                       ((uint32_t)0x40001D80)
#define DAC3_ADDR                       ((uint32_t)0x40001E00)
#define DAC0_SFR                        ((DAC_SFRmap *) DAC0_ADDR)
#define DAC1_SFR                        ((DAC_SFRmap *) DAC1_ADDR)
#define DAC2_SFR                        ((DAC_SFRmap *) DAC2_ADDR)
#define DAC3_SFR                        ((DAC_SFRmap *) DAC3_ADDR)

/* DAC - Ĵ */
#define DAC0_CTL                        (DAC0_SFR->CTL)
#define DAC0_DAHD                       (DAC0_SFR->DAHD)
#define DAC0_DATA                       (DAC0_SFR->DATA)
#define DAC0_CTL1                       (DAC0_SFR->CTL1)
#define DAC0_CAL                        (DAC0_SFR->CAL)
#define DAC1_CTL                        (DAC1_SFR->CTL)
#define DAC1_DAHD                       (DAC1_SFR->DAHD)
#define DAC1_DATA                       (DAC1_SFR->DATA)
#define DAC1_CTL1                       (DAC1_SFR->CTL1)
#define DAC1_CAL                        (DAC1_SFR->CAL)
#define DAC2_CTL                        (DAC2_SFR->CTL)
#define DAC2_DAHD                       (DAC2_SFR->DAHD)
#define DAC2_DATA                       (DAC2_SFR->DATA)
#define DAC2_CTL1                       (DAC2_SFR->CTL1)
#define DAC2_CAL                        (DAC2_SFR->CAL)
#define DAC3_CTL                        (DAC3_SFR->CTL)
#define DAC3_DAHD                       (DAC3_SFR->DAHD)
#define DAC3_DATA                       (DAC3_SFR->DATA)
#define DAC3_CTL1                       (DAC3_SFR->CTL1)
#define DAC3_CAL                        (DAC3_SFR->CAL)

/* DACx_CTL λ */
#define DAC_CTL_EN_POS                  (0)
#define DAC_CTL_DE_POS                  (1)
#define DAC_CTL_TRIGEN_POS              (3)
#define DAC_CTL_TREVT0_POS              (4)
#define DAC_CTL_TREVT1_POS              (5)
#define DAC_CTL_TREVT2_POS              (6)
#define DAC_CTL_TREVT3_POS              (7)
#define DAC_CTL_WAVE0_POS               (8)
#define DAC_CTL_WAVE1_POS               (9)
#define DAC_CTL_MAS0_POS                (10)
#define DAC_CTL_MAS1_POS                (11)
#define DAC_CTL_MAS2_POS                (12)
#define DAC_CTL_MAS3_POS                (13)
#define DAC_CTL_SWTRIG_POS              (14)
#define DAC_CTL_DF_POS                  (15)
#define DAC_CTL_EN                      ((uint32_t)1<<(DAC_CTL_EN_POS))
#define DAC_CTL_DE                      ((uint32_t)1<<(DAC_CTL_DE_POS))
#define DAC_CTL_TRIGEN                  ((uint32_t)1<<(DAC_CTL_TRIGEN_POS))
#define DAC_CTL_TREVT                   ((uint32_t)0xF<<(DAC_CTL_TREVT0_POS))
#define DAC_CTL_TREVT0                  ((uint32_t)1<<(DAC_CTL_TREVT0_POS))
#define DAC_CTL_TREVT1                  ((uint32_t)1<<(DAC_CTL_TREVT1_POS))
#define DAC_CTL_TREVT2                  ((uint32_t)1<<(DAC_CTL_TREVT2_POS))
#define DAC_CTL_TREVT3                  ((uint32_t)1<<(DAC_CTL_TREVT3_POS))
#define DAC_CTL_WAVE                    ((uint32_t)3<<(DAC_CTL_WAVE0_POS))
#define DAC_CTL_WAVE0                   ((uint32_t)1<<(DAC_CTL_WAVE0_POS))
#define DAC_CTL_WAVE1                   ((uint32_t)1<<(DAC_CTL_WAVE1_POS))
#define DAC_CTL_MAS                     ((uint32_t)0xF<<(DAC_CTL_MAS0_POS))
#define DAC_CTL_MAS0                    ((uint32_t)1<<(DAC_CTL_MAS0_POS))
#define DAC_CTL_MAS1                    ((uint32_t)1<<(DAC_CTL_MAS1_POS))
#define DAC_CTL_MAS2                    ((uint32_t)1<<(DAC_CTL_MAS2_POS))
#define DAC_CTL_MAS3                    ((uint32_t)1<<(DAC_CTL_MAS3_POS))
#define DAC_CTL_SWTRIG                  ((uint32_t)1<<(DAC_CTL_SWTRIG_POS))
#define DAC_CTL_DF                      ((uint32_t)1<<(DAC_CTL_DF_POS))

/* DACx_DAHD λ */
#define DAC_DAHD_DAHD0_POS              (0)
#define DAC_DAHD_DAHD                   ((uint32_t)0xFFF<<(DAC_DAHD_DAHD0_POS))

/* DACx_DATA λ */
#define DAC_DATA_DATA0_POS              (0)
#define DAC_DATA_DATA                   ((uint32_t)0xFFF<<(DAC_DATA_DATA0_POS))

/* DACx_CTL1 λ */
#define DAC_CTL1_SEL_POS                (0)
#define DAC_CTL1_RFS0_POS               (1)
#define DAC_CTL1_RFS1_POS               (2)
#define DAC_CTL1_CLK0_POS               (4)
#define DAC_CTL1_CLK1_POS               (5)
#define DAC_CTL1_BUFEN_POS              (6)
#define DAC_CTL1_CLKDIV0_POS            (9)
#define DAC_CTL1_CLKDIV1_POS            (10)
#define DAC_CTL1_CLKDIV2_POS            (11)
#define DAC_CTL1_SEL                    ((uint32_t)1<<(DAC_CTL1_SEL_POS))
#define DAC_CTL1_RFS                    ((uint32_t)0x03<<(DAC_CTL1_RFS0_POS))
#define DAC_CTL1_RFS0                   ((uint32_t)1<<(DAC_CTL1_RFS0_POS))
#define DAC_CTL1_RFS1                   ((uint32_t)1<<(DAC_CTL1_RFS1_POS))
#define DAC_CTL1_CLK                    ((uint32_t)0x03<<(DAC_CTL1_CLK0_POS))
#define DAC_CTL1_CLK0                   ((uint32_t)1<<(DAC_CTL1_CLK0_POS))
#define DAC_CTL1_CLK1                   ((uint32_t)1<<(DAC_CTL1_CLK1_POS))
#define DAC_CTL1_BUFEN                  ((uint32_t)1<<(DAC_CTL1_BUFEN_POS))
#define DAC_CTL1_CLKDIV                 ((uint32_t)0x07<<(DAC_CTL1_CLKDIV0_POS))
#define DAC_CTL1_CLKDIV0                ((uint32_t)1<<(DAC_CTL1_CLKDIV0_POS))
#define DAC_CTL1_CLKDIV1                ((uint32_t)1<<(DAC_CTL1_CLKDIV1_POS))
#define DAC_CTL1_CLKDIV2                ((uint32_t)1<<(DAC_CTL1_CLKDIV2_POS))

/* DACx_CALλ */
#define DAC_CAL_TPEN_POS            	(0)
#define DAC_CAL_TP0_POS            		(1)
#define DAC_CAL_TP1_POS            		(2)
#define DAC_CAL_TRIMLO_POS            	(13)
#define DAC_CAL_TRIMHI_POS            	(14)
#define DAC_CAL_TRIMSTATE_POS           (15)
#define DAC_CAL_TRIMN0_POS            	(16)
#define DAC_CAL_TRIMN1_POS            	(17)
#define DAC_CAL_TRIMN2_POS            	(18)
#define DAC_CAL_TRIMN3_POS            	(19)
#define DAC_CAL_TRIMN4_POS            	(20)
#define DAC_CAL_TRIMN5_POS            	(21)
#define DAC_CAL_TRIMNPOL_POS            (22)
#define DAC_CAL_TRIMP0_POS            	(24)
#define DAC_CAL_TRIMP1_POS            	(25)
#define DAC_CAL_TRIMP2_POS            	(26)
#define DAC_CAL_TRIMP3_POS            	(27)
#define DAC_CAL_TRIMP4_POS            	(28)
#define DAC_CAL_TRIMP5_POS            	(29)
#define DAC_CAL_TRIMPPOL_POS            (30)
#define DAC_CAL_TPEN                	((uint32_t)1<<(DAC_CAL_TPEN_POS))
#define DAC_CAL_TP                		((uint32_t)0x03<<(DAC_CAL_TP0_POS))
#define DAC_CAL_TP0                		((uint32_t)1<<(DAC_CAL_TP0_POS))
#define DAC_CAL_TP1                		((uint32_t)1<<(DAC_CAL_TP1_POS))
#define DAC_CAL_TRIMLO                	((uint32_t)1<<(DAC_CAL_TRIMLO_POS))
#define DAC_CAL_TRIMHI                	((uint32_t)1<<(DAC_CAL_TRIMHI_POS))
#define DAC_CAL_TRIMSTATE               ((uint32_t)1<<(DAC_CAL_TRIMSTATE_POS))
#define DAC_CAL_TRIMN                	((uint32_t)0x3F<<(DAC_CAL_TRIMN0_POS))
#define DAC_CAL_TRIMN0                	((uint32_t)1<<(DAC_CAL_TRIMN0_POS))
#define DAC_CAL_TRIMN1                	((uint32_t)1<<(DAC_CAL_TRIMN1_POS))
#define DAC_CAL_TRIMN2                	((uint32_t)1<<(DAC_CAL_TRIMN2_POS))
#define DAC_CAL_TRIMN3                	((uint32_t)1<<(DAC_CAL_TRIMN3_POS))
#define DAC_CAL_TRIMN4                	((uint32_t)1<<(DAC_CAL_TRIMN4_POS))
#define DAC_CAL_TRIMN5                	((uint32_t)1<<(DAC_CAL_TRIMN5_POS))
#define DAC_CAL_TRIMNPOL                ((uint32_t)1<<(DAC_CAL_TRIMNPOL_POS))
#define DAC_CAL_TRIMP                	((uint32_t)0x3F<<(DAC_CAL_TRIMP0_POS))
#define DAC_CAL_TRIMP0                	((uint32_t)1<<(DAC_CAL_TRIMP0_POS))
#define DAC_CAL_TRIMP1                	((uint32_t)1<<(DAC_CAL_TRIMP1_POS))
#define DAC_CAL_TRIMP2                	((uint32_t)1<<(DAC_CAL_TRIMP2_POS))
#define DAC_CAL_TRIMP3                	((uint32_t)1<<(DAC_CAL_TRIMP3_POS))
#define DAC_CAL_TRIMP4                	((uint32_t)1<<(DAC_CAL_TRIMP4_POS))
#define DAC_CAL_TRIMP5                	((uint32_t)1<<(DAC_CAL_TRIMP5_POS))
#define DAC_CAL_TRIMPPOL                ((uint32_t)1<<(DAC_CAL_TRIMPPOL_POS))
/* ģתģ (DAC) */

#endif

#if 1										/* CMP */

/* ----------------------------------------------------------------------------
   -- Ƚģ (CMP)
   ---------------------------------------------------------------------------- */

/* CMP - Ĵڴṹ */
typedef struct CMP_MemMap
{
    volatile uint32_t CTL0;       	/* ģȽƼĴ0, ƫ:0x0 */
    volatile uint32_t CTL1;       	/* ģȽƼĴ1, ƫ:0x4 */
    volatile uint32_t CTL2;       	/* ģȽƼĴ2, ƫ:0x8 */
    volatile uint32_t CTL3;       	/* ģȽƼĴ3, ƫ:0xC */
    volatile uint32_t CTL4;   		/* ģȽƼĴ4, ƫ:0x10 */
    volatile uint32_t CTL5;   		/* ģȽƼĴ5, ƫ:0x14 */
    volatile uint32_t TRIM0;   		/* ģȽУ׼Ĵ0, ƫ:0x18 */
    volatile uint32_t TRIM1;   		/* ģȽУ׼Ĵ1, ƫ:0x1C */
    volatile uint32_t TRIM2;   		/* ģȽУ׼Ĵ2, ƫ:0x20 */
    volatile uint32_t TRIM3;   		/* ģȽУ׼Ĵ3, ƫ:0x24 */
}CMP_SFRmap;

/* ----------------------------------------------------------------------------
   -- CMP - Ĵں
   ---------------------------------------------------------------------------- */

/* CMP - Ĵڵַ */
#define CMP_ADDR                        ((uint32_t)0x40000800)
#define CMP0_ADDR                       ((uint32_t)0x40000800)
#define CMP1_ADDR                       ((uint32_t)0x40000804)
#define CMP2_ADDR                       ((uint32_t)0x40000808)
#define CMP3_ADDR                       ((uint32_t)0x4000080C)

#define CMP_SFR                         ((CMP_SFRmap *) CMP_ADDR)

/* CMP - Ĵ */
#define CMP_CTL0                        (CMP_SFR->CTL0)
#define CMP_CTL1                        (CMP_SFR->CTL1)
#define CMP_CTL2                        (CMP_SFR->CTL2)
#define CMP_CTL3                        (CMP_SFR->CTL3)
#define CMP_CTL4                        (CMP_SFR->CTL4)
#define CMP_CTL5                        (CMP_SFR->CTL5)
#define CMP_TRIM0						(CMP_SFR->TRIM0)
#define CMP_TRIM1						(CMP_SFR->TRIM1)
#define CMP_TRIM2						(CMP_SFR->TRIM2)
#define CMP_TRIM3						(CMP_SFR->TRIM3)

/* CMP_CTL0 λ */
#define CMP_CTL0_POL_POS                (1)
#define CMP_CTL0_WINEN_POS              (2)
#define CMP_CTL0_FLTEN_POS              (3)
#define CMP_CTL0_FLTCNT0_POS            (4)
#define CMP_CTL0_FLTCNT1_POS            (5)
#define CMP_CTL0_FLTCNT2_POS            (6)
#define CMP_CTL0_WINCLKSEL_POS			(7)
#define CMP_CTL0_FLTDIV0_POS            (8)
#define CMP_CTL0_FLTDIV1_POS            (9)
#define CMP_CTL0_FLTDIV2_POS            (10)
#define CMP_CTL0_FLTDIV3_POS            (11)
#define CMP_CTL0_FLTDIV4_POS            (12)
#define CMP_CTL0_FLTDIV5_POS            (13)
#define CMP_CTL0_FLTDIV6_POS            (14)
#define CMP_CTL0_FLTDIV7_POS            (15)
#define CMP_CTL0_FLTCS0_POS             (16)
#define CMP_CTL0_FLTCS1_POS             (17)
#define CMP_CTL0_IFREN_POS              (18)
#define CMP_CTL0_IFFEN_POS              (19)
#define CMP_CTL0_NMOD0_POS              (24)
#define CMP_CTL0_NMOD1_POS              (25)
#define CMP_CTL0_NMOD2_POS              (26)
#define CMP_CTL0_NMOD3_POS              (27)
#define CMP_CTL0_PMOD0_POS              (28)
#define CMP_CTL0_PMOD1_POS              (29)
#define CMP_CTL0_PMOD2_POS              (30)
#define CMP_CTL0_PMOD3_POS              (31)
#define CMP_CTL0_POL                    ((uint32_t)1<<(CMP_CTL0_POL_POS))
#define CMP_CTL0_WINEN                  ((uint32_t)1<<(CMP_CTL0_WINEN_POS))
#define CMP_CTL0_FLTEN                  ((uint32_t)1<<(CMP_CTL0_FLTEN_POS))
#define CMP_CTL0_FLTCNT                 ((uint32_t)0x7<<(CMP_CTL0_FLTCNT0_POS))
#define CMP_CTL0_FLTCNT0                ((uint32_t)1<<(CMP_CTL0_FLTCNT0_POS))
#define CMP_CTL0_FLTCNT1                ((uint32_t)1<<(CMP_CTL0_FLTCNT1_POS))
#define CMP_CTL0_FLTCNT2                ((uint32_t)1<<(CMP_CTL0_FLTCNT2_POS))
#define CMP_CTL0_WINCLKSEL				((uint32_t)1<<CMP_CTL0_WINCLKSEL_POS)
#define CMP_CTL0_FLTDIV                 ((uint32_t)0xFF<<(CMP_CTL0_FLTDIV0_POS))
#define CMP_CTL0_FLTDIV0                ((uint32_t)1<<(CMP_CTL0_FLTDIV0_POS))
#define CMP_CTL0_FLTDIV1                ((uint32_t)1<<(CMP_CTL0_FLTDIV1_POS))
#define CMP_CTL0_FLTDIV2                ((uint32_t)1<<(CMP_CTL0_FLTDIV2_POS))
#define CMP_CTL0_FLTDIV3                ((uint32_t)1<<(CMP_CTL0_FLTDIV3_POS))
#define CMP_CTL0_FLTDIV4                ((uint32_t)1<<(CMP_CTL0_FLTDIV4_POS))
#define CMP_CTL0_FLTDIV5                ((uint32_t)1<<(CMP_CTL0_FLTDIV5_POS))
#define CMP_CTL0_FLTDIV6                ((uint32_t)1<<(CMP_CTL0_FLTDIV6_POS))
#define CMP_CTL0_FLTDIV7                ((uint32_t)1<<(CMP_CTL0_FLTDIV7_POS))
#define CMP_CTL0_FLTCS                  ((uint32_t)0x3<<(CMP_CTL0_FLTCS0_POS))
#define CMP_CTL0_FLTCS0                 ((uint32_t)1<<(CMP_CTL0_FLTCS0_POS))
#define CMP_CTL0_FLTCS1                 ((uint32_t)1<<(CMP_CTL0_FLTCS1_POS))
#define CMP_CTL0_IFREN                  ((uint32_t)1<<(CMP_CTL0_IFREN_POS))
#define CMP_CTL0_IFFEN                  ((uint32_t)1<<(CMP_CTL0_IFFEN_POS))
#define CMP_CTL0_NMOD                   ((uint32_t)0x0F<<(CMP_CTL0_NMOD0_POS))
#define CMP_CTL0_NMOD0                  ((uint32_t)1<<(CMP_CTL0_NMOD0_POS))
#define CMP_CTL0_NMOD1                  ((uint32_t)1<<(CMP_CTL0_NMOD1_POS))
#define CMP_CTL0_NMOD2                  ((uint32_t)1<<(CMP_CTL0_NMOD2_POS))
#define CMP_CTL0_NMOD3                  ((uint32_t)1<<(CMP_CTL0_NMOD3_POS))
#define CMP_CTL0_PMOD                   ((uint32_t)0x0F<<(CMP_CTL0_PMOD0_POS))
#define CMP_CTL0_PMOD0                  ((uint32_t)1<<(CMP_CTL0_PMOD0_POS))
#define CMP_CTL0_PMOD1                  ((uint32_t)1<<(CMP_CTL0_PMOD1_POS))
#define CMP_CTL0_PMOD2                  ((uint32_t)1<<(CMP_CTL0_PMOD2_POS))
#define CMP_CTL0_PMOD3                  ((uint32_t)1<<(CMP_CTL0_PMOD3_POS))

/* CMP_CTL1 λ */
#define CMP_CTL1_POL_POS                (1)
#define CMP_CTL1_WINEN_POS              (2)
#define CMP_CTL1_FLTEN_POS              (3)
#define CMP_CTL1_FLTCNT0_POS            (4)
#define CMP_CTL1_FLTCNT1_POS            (5)
#define CMP_CTL1_FLTCNT2_POS            (6)
#define CMP_CTL1_WINCLKSEL_POS			(7)
#define CMP_CTL1_FLTDIV0_POS            (8)
#define CMP_CTL1_FLTDIV1_POS            (9)
#define CMP_CTL1_FLTDIV2_POS            (10)
#define CMP_CTL1_FLTDIV3_POS            (11)
#define CMP_CTL1_FLTDIV4_POS            (12)
#define CMP_CTL1_FLTDIV5_POS            (13)
#define CMP_CTL1_FLTDIV6_POS            (14)
#define CMP_CTL1_FLTDIV7_POS            (15)
#define CMP_CTL1_FLTCS0_POS             (16)
#define CMP_CTL1_FLTCS1_POS             (17)
#define CMP_CTL1_IFREN_POS              (18)
#define CMP_CTL1_IFFEN_POS              (19)
#define CMP_CTL1_NMOD0_POS              (24)
#define CMP_CTL1_NMOD1_POS              (25)
#define CMP_CTL1_NMOD2_POS              (26)
#define CMP_CTL1_NMOD3_POS              (27)
#define CMP_CTL1_PMOD0_POS              (28)
#define CMP_CTL1_PMOD1_POS              (29)
#define CMP_CTL1_PMOD2_POS              (30)
#define CMP_CTL1_PMOD3_POS              (31)
#define CMP_CTL1_POL                    ((uint32_t)1<<(CMP_CTL1_POL_POS))
#define CMP_CTL1_WINEN                  ((uint32_t)1<<(CMP_CTL1_WINEN_POS))
#define CMP_CTL1_FLTEN                  ((uint32_t)1<<(CMP_CTL1_FLTEN_POS))
#define CMP_CTL1_FLTCNT                 ((uint32_t)0x7<<(CMP_CTL1_FLTCNT0_POS))
#define CMP_CTL1_FLTCNT0                ((uint32_t)1<<(CMP_CTL1_FLTCNT0_POS))
#define CMP_CTL1_FLTCNT1                ((uint32_t)1<<(CMP_CTL1_FLTCNT1_POS))
#define CMP_CTL1_FLTCNT2                ((uint32_t)1<<(CMP_CTL1_FLTCNT2_POS))
#define CMP_CTL1_WINCLKSEL				((uint32_t)1<<CMP_CTL1_WINCLKSEL_POS)
#define CMP_CTL1_FLTDIV                 ((uint32_t)0xFF<<(CMP_CTL1_FLTDIV0_POS))
#define CMP_CTL1_FLTDIV0                ((uint32_t)1<<(CMP_CTL1_FLTDIV0_POS))
#define CMP_CTL1_FLTDIV1                ((uint32_t)1<<(CMP_CTL1_FLTDIV1_POS))
#define CMP_CTL1_FLTDIV2                ((uint32_t)1<<(CMP_CTL1_FLTDIV2_POS))
#define CMP_CTL1_FLTDIV3                ((uint32_t)1<<(CMP_CTL1_FLTDIV3_POS))
#define CMP_CTL1_FLTDIV4                ((uint32_t)1<<(CMP_CTL1_FLTDIV4_POS))
#define CMP_CTL1_FLTDIV5                ((uint32_t)1<<(CMP_CTL1_FLTDIV5_POS))
#define CMP_CTL1_FLTDIV6                ((uint32_t)1<<(CMP_CTL1_FLTDIV6_POS))
#define CMP_CTL1_FLTDIV7                ((uint32_t)1<<(CMP_CTL1_FLTDIV7_POS))
#define CMP_CTL1_FLTCS                  ((uint32_t)0x3<<(CMP_CTL1_FLTCS0_POS))
#define CMP_CTL1_FLTCS0                 ((uint32_t)1<<(CMP_CTL1_FLTCS0_POS))
#define CMP_CTL1_FLTCS1                 ((uint32_t)1<<(CMP_CTL1_FLTCS1_POS))
#define CMP_CTL1_IFREN                  ((uint32_t)1<<(CMP_CTL1_IFREN_POS))
#define CMP_CTL1_IFFEN                  ((uint32_t)1<<(CMP_CTL1_IFFEN_POS))
#define CMP_CTL1_NMOD                   ((uint32_t)0x0F<<(CMP_CTL1_NMOD0_POS))
#define CMP_CTL1_NMOD0                  ((uint32_t)1<<(CMP_CTL1_NMOD0_POS))
#define CMP_CTL1_NMOD1                  ((uint32_t)1<<(CMP_CTL1_NMOD1_POS))
#define CMP_CTL1_NMOD2                  ((uint32_t)1<<(CMP_CTL1_NMOD2_POS))
#define CMP_CTL1_NMOD3                  ((uint32_t)1<<(CMP_CTL1_NMOD3_POS))
#define CMP_CTL1_PMOD                   ((uint32_t)0x0F<<(CMP_CTL1_PMOD0_POS))
#define CMP_CTL1_PMOD0                  ((uint32_t)1<<(CMP_CTL1_PMOD0_POS))
#define CMP_CTL1_PMOD1                  ((uint32_t)1<<(CMP_CTL1_PMOD1_POS))
#define CMP_CTL1_PMOD2                  ((uint32_t)1<<(CMP_CTL1_PMOD2_POS))
#define CMP_CTL1_PMOD3                  ((uint32_t)1<<(CMP_CTL1_PMOD3_POS))

/* CMP_CTL2 λ */
#define CMP_CTL2_POL_POS                (1)
#define CMP_CTL2_WINEN_POS              (2)
#define CMP_CTL2_FLTEN_POS              (3)
#define CMP_CTL2_FLTCNT0_POS            (4)
#define CMP_CTL2_FLTCNT1_POS            (5)
#define CMP_CTL2_FLTCNT2_POS            (6)
#define CMP_CTL2_WINCLKSEL_POS			(7)
#define CMP_CTL2_FLTDIV0_POS            (8)
#define CMP_CTL2_FLTDIV1_POS            (9)
#define CMP_CTL2_FLTDIV2_POS            (10)
#define CMP_CTL2_FLTDIV3_POS            (11)
#define CMP_CTL2_FLTDIV4_POS            (12)
#define CMP_CTL2_FLTDIV5_POS            (13)
#define CMP_CTL2_FLTDIV6_POS            (14)
#define CMP_CTL2_FLTDIV7_POS            (15)
#define CMP_CTL2_FLTCS0_POS             (16)
#define CMP_CTL2_FLTCS1_POS             (17)
#define CMP_CTL2_IFREN_POS              (18)
#define CMP_CTL2_IFFEN_POS              (19)
#define CMP_CTL2_NMOD0_POS              (24)
#define CMP_CTL2_NMOD1_POS              (25)
#define CMP_CTL2_NMOD2_POS              (26)
#define CMP_CTL2_NMOD3_POS              (27)
#define CMP_CTL2_PMOD0_POS              (28)
#define CMP_CTL2_PMOD1_POS              (29)
#define CMP_CTL2_PMOD2_POS              (30)
#define CMP_CTL2_PMOD3_POS              (31)
#define CMP_CTL2_POL                    ((uint32_t)1<<(CMP_CTL2_POL_POS))
#define CMP_CTL2_WINEN                  ((uint32_t)1<<(CMP_CTL2_WINEN_POS))
#define CMP_CTL2_FLTEN                  ((uint32_t)1<<(CMP_CTL2_FLTEN_POS))
#define CMP_CTL2_FLTCNT                 ((uint32_t)0x7<<(CMP_CTL2_FLTCNT0_POS))
#define CMP_CTL2_FLTCNT0                ((uint32_t)1<<(CMP_CTL2_FLTCNT0_POS))
#define CMP_CTL2_FLTCNT1                ((uint32_t)1<<(CMP_CTL2_FLTCNT1_POS))
#define CMP_CTL2_FLTCNT2                ((uint32_t)1<<(CMP_CTL2_FLTCNT2_POS))
#define CMP_CTL2_WINCLKSEL				((uint32_t)1<<CMP_CTL2_WINCLKSEL_POS)
#define CMP_CTL2_FLTDIV                 ((uint32_t)0xFF<<(CMP_CTL2_FLTDIV0_POS))
#define CMP_CTL2_FLTDIV0                ((uint32_t)1<<(CMP_CTL2_FLTDIV0_POS))
#define CMP_CTL2_FLTDIV1                ((uint32_t)1<<(CMP_CTL2_FLTDIV1_POS))
#define CMP_CTL2_FLTDIV2                ((uint32_t)1<<(CMP_CTL2_FLTDIV2_POS))
#define CMP_CTL2_FLTDIV3                ((uint32_t)1<<(CMP_CTL2_FLTDIV3_POS))
#define CMP_CTL2_FLTDIV4                ((uint32_t)1<<(CMP_CTL2_FLTDIV4_POS))
#define CMP_CTL2_FLTDIV5                ((uint32_t)1<<(CMP_CTL2_FLTDIV5_POS))
#define CMP_CTL2_FLTDIV6                ((uint32_t)1<<(CMP_CTL2_FLTDIV6_POS))
#define CMP_CTL2_FLTDIV7                ((uint32_t)1<<(CMP_CTL2_FLTDIV7_POS))
#define CMP_CTL2_FLTCS                  ((uint32_t)0x3<<(CMP_CTL2_FLTCS0_POS))
#define CMP_CTL2_FLTCS0                 ((uint32_t)1<<(CMP_CTL2_FLTCS0_POS))
#define CMP_CTL2_FLTCS1                 ((uint32_t)1<<(CMP_CTL2_FLTCS1_POS))
#define CMP_CTL2_IFREN                  ((uint32_t)1<<(CMP_CTL2_IFREN_POS))
#define CMP_CTL2_IFFEN                  ((uint32_t)1<<(CMP_CTL2_IFFEN_POS))
#define CMP_CTL2_NMOD                   ((uint32_t)0x0F<<(CMP_CTL2_NMOD0_POS))
#define CMP_CTL2_NMOD0                  ((uint32_t)1<<(CMP_CTL2_NMOD0_POS))
#define CMP_CTL2_NMOD1                  ((uint32_t)1<<(CMP_CTL2_NMOD1_POS))
#define CMP_CTL2_NMOD2                  ((uint32_t)1<<(CMP_CTL2_NMOD2_POS))
#define CMP_CTL2_NMOD3                  ((uint32_t)1<<(CMP_CTL2_NMOD3_POS))
#define CMP_CTL2_PMOD                   ((uint32_t)0x0F<<(CMP_CTL2_PMOD0_POS))
#define CMP_CTL2_PMOD0                  ((uint32_t)1<<(CMP_CTL2_PMOD0_POS))
#define CMP_CTL2_PMOD1                  ((uint32_t)1<<(CMP_CTL2_PMOD1_POS))
#define CMP_CTL2_PMOD2                  ((uint32_t)1<<(CMP_CTL2_PMOD2_POS))
#define CMP_CTL2_PMOD3                  ((uint32_t)1<<(CMP_CTL2_PMOD3_POS))

/* CMP_CTL3 λ */
#define CMP_CTL3_EN_POS                 (0)
#define CMP_CTL3_POL_POS                (1)
#define CMP_CTL3_WINEN_POS              (2)
#define CMP_CTL3_FLTEN_POS              (3)
#define CMP_CTL3_FLTCNT0_POS            (4)
#define CMP_CTL3_FLTCNT1_POS            (5)
#define CMP_CTL3_FLTCNT2_POS            (6)
#define CMP_CTL3_WINCLKSEL_POS			(7)
#define CMP_CTL3_FLTDIV0_POS            (8)
#define CMP_CTL3_FLTDIV1_POS            (9)
#define CMP_CTL3_FLTDIV2_POS            (10)
#define CMP_CTL3_FLTDIV3_POS            (11)
#define CMP_CTL3_FLTDIV4_POS            (12)
#define CMP_CTL3_FLTDIV5_POS            (13)
#define CMP_CTL3_FLTDIV6_POS            (14)
#define CMP_CTL3_FLTDIV7_POS            (15)
#define CMP_CTL3_FLTCS0_POS             (16)
#define CMP_CTL3_FLTCS1_POS             (17)
#define CMP_CTL3_IFREN_POS              (18)
#define CMP_CTL3_IFFEN_POS              (19)
#define CMP_CTL3_CMP3PSEL_POS           (23)
#define CMP_CTL3_NMOD0_POS              (24)
#define CMP_CTL3_NMOD1_POS              (25)
#define CMP_CTL3_NMOD2_POS              (26)
#define CMP_CTL3_NMOD3_POS              (27)
#define CMP_CTL3_PMOD0_POS              (28)
#define CMP_CTL3_PMOD1_POS              (29)
#define CMP_CTL3_PMOD2_POS              (30)
#define CMP_CTL3_PMOD3_POS              (31)
#define CMP_CTL3_EN		                ((uint32_t)1<<(CMP_CTL3_EN_POS))
#define CMP_CTL3_POL                    ((uint32_t)1<<(CMP_CTL3_POL_POS))
#define CMP_CTL3_WINEN                  ((uint32_t)1<<(CMP_CTL3_WINEN_POS))
#define CMP_CTL3_FLTEN                  ((uint32_t)1<<(CMP_CTL3_FLTEN_POS))
#define CMP_CTL3_FLTCNT                 ((uint32_t)0x7<<(CMP_CTL3_FLTCNT0_POS))
#define CMP_CTL3_FLTCNT0                ((uint32_t)1<<(CMP_CTL3_FLTCNT0_POS))
#define CMP_CTL3_FLTCNT1                ((uint32_t)1<<(CMP_CTL3_FLTCNT1_POS))
#define CMP_CTL3_FLTCNT2                ((uint32_t)1<<(CMP_CTL3_FLTCNT2_POS))
#define CMP_CTL3_WINCLKSEL				((uint32_t)1<<CMP_CTL3_WINCLKSEL_POS)
#define CMP_CTL3_FLTDIV                 ((uint32_t)0xFF<<(CMP_CTL3_FLTDIV0_POS))
#define CMP_CTL3_FLTDIV0                ((uint32_t)1<<(CMP_CTL3_FLTDIV0_POS))
#define CMP_CTL3_FLTDIV1                ((uint32_t)1<<(CMP_CTL3_FLTDIV1_POS))
#define CMP_CTL3_FLTDIV2                ((uint32_t)1<<(CMP_CTL3_FLTDIV2_POS))
#define CMP_CTL3_FLTDIV3                ((uint32_t)1<<(CMP_CTL3_FLTDIV3_POS))
#define CMP_CTL3_FLTDIV4                ((uint32_t)1<<(CMP_CTL3_FLTDIV4_POS))
#define CMP_CTL3_FLTDIV5                ((uint32_t)1<<(CMP_CTL3_FLTDIV5_POS))
#define CMP_CTL3_FLTDIV6                ((uint32_t)1<<(CMP_CTL3_FLTDIV6_POS))
#define CMP_CTL3_FLTDIV7                ((uint32_t)1<<(CMP_CTL3_FLTDIV7_POS))
#define CMP_CTL3_FLTCS                  ((uint32_t)0x3<<(CMP_CTL3_FLTCS0_POS))
#define CMP_CTL3_FLTCS0                 ((uint32_t)1<<(CMP_CTL3_FLTCS0_POS))
#define CMP_CTL3_FLTCS1                 ((uint32_t)1<<(CMP_CTL3_FLTCS1_POS))
#define CMP_CTL3_IFREN                  ((uint32_t)1<<(CMP_CTL3_IFREN_POS))
#define CMP_CTL3_IFFEN                  ((uint32_t)1<<(CMP_CTL3_IFFEN_POS))
#define CMP_CTL3_CMP3PSEL               ((uint32_t)1<<(CMP_CTL3_CMP3PSEL_POS))
#define CMP_CTL3_NMOD                   ((uint32_t)0x0F<<(CMP_CTL3_NMOD0_POS))
#define CMP_CTL3_NMOD0                  ((uint32_t)1<<(CMP_CTL3_NMOD0_POS))
#define CMP_CTL3_NMOD1                  ((uint32_t)1<<(CMP_CTL3_NMOD1_POS))
#define CMP_CTL3_NMOD2                  ((uint32_t)1<<(CMP_CTL3_NMOD2_POS))
#define CMP_CTL3_NMOD3                  ((uint32_t)1<<(CMP_CTL3_NMOD3_POS))
#define CMP_CTL3_PMOD                   ((uint32_t)0x0F<<(CMP_CTL3_PMOD0_POS))
#define CMP_CTL3_PMOD0                  ((uint32_t)1<<(CMP_CTL3_PMOD0_POS))
#define CMP_CTL3_PMOD1                  ((uint32_t)1<<(CMP_CTL3_PMOD1_POS))
#define CMP_CTL3_PMOD2                  ((uint32_t)1<<(CMP_CTL3_PMOD2_POS))
#define CMP_CTL3_PMOD3                  ((uint32_t)1<<(CMP_CTL3_PMOD3_POS))

/* CMP_CTL4λ */
#define CMP_CTL4_C0EN_POS            	(0)
#define CMP_CTL4_C1EN_POS            	(1)
#define CMP_CTL4_C2EN_POS            	(2)
#define CMP_CTL4_FLTINSEL_POS           (3)
#define CMP_CTL4_BEMFEN_POS            	(4)
#define CMP_CTL4_HALSEL_POS            	(5)
#define CMP_CTL4_DELAYVOL0_POS          (6)
#define CMP_CTL4_DELAYVOL1_POS          (7)
#define CMP_CTL4_CMPOUTDSEL0_POS        (8)
#define CMP_CTL4_CMPOUTDSEL1_POS        (9)
#define CMP_CTL4_IOEN_POS            	(10)
#define CMP_CTL4_C0IE_POS            	(12)
#define CMP_CTL4_C1IE_POS            	(13)
#define CMP_CTL4_C2IE_POS            	(14)
#define CMP_CTL4_C3IE_POS            	(15)
#define CMP_CTL4_C0IC_POS            	(16)
#define CMP_CTL4_C1IC_POS            	(17)
#define CMP_CTL4_C2IC_POS            	(18)
#define CMP_CTL4_C3IC_POS            	(19)
#define CMP_CTL4_CMPOUTASEL0_POS        (20)
#define CMP_CTL4_CMPOUTASEL1_POS        (21)
#define CMP_CTL4_PWMCMP_POS            	(22)
#define CMP_CTL4_CIFMS_POS            	(23)
#define CMP_CTL4_C0IF_POS            	(24)
#define CMP_CTL4_C1IF_POS            	(25)
#define CMP_CTL4_C2IF_POS            	(26)
#define CMP_CTL4_C3IF_POS            	(27)
#define CMP_CTL4_C0OUT_POS            	(28)
#define CMP_CTL4_C1OUT_POS            	(29)
#define CMP_CTL4_C2OUT_POS            	(30)
#define CMP_CTL4_C3OUT_POS            	(31)
#define CMP_CTL4_C0EN                	((uint32_t)1<<(CMP_CTL4_C0EN_POS))
#define CMP_CTL4_C1EN                	((uint32_t)1<<(CMP_CTL4_C1EN_POS))
#define CMP_CTL4_C2EN                	((uint32_t)1<<(CMP_CTL4_C2EN_POS))
#define CMP_CTL4_FLTINSEL               ((uint32_t)1<<(CMP_CTL4_FLTINSEL_POS))
#define CMP_CTL4_BEMFEN                	((uint32_t)1<<(CMP_CTL4_BEMFEN_POS))
#define CMP_CTL4_HALSEL                	((uint32_t)1<<(CMP_CTL4_HALSEL_POS))
#define CMP_CTL4_DELAYVOL               ((uint32_t)0x03<<(CMP_CTL4_DELAYVOL0_POS))
#define CMP_CTL4_DELAYVOL0              ((uint32_t)1<<(CMP_CTL4_DELAYVOL0_POS))
#define CMP_CTL4_DELAYVOL1              ((uint32_t)1<<(CMP_CTL4_DELAYVOL1_POS))
#define CMP_CTL4_CMPOUTDSEL             ((uint32_t)0x03<<(CMP_CTL4_CMPOUTDSEL0_POS))
#define CMP_CTL4_CMPOUTDSEL0            ((uint32_t)1<<(CMP_CTL4_CMPOUTDSEL0_POS))
#define CMP_CTL4_CMPOUTDSEL1            ((uint32_t)1<<(CMP_CTL4_CMPOUTDSEL1_POS))
#define CMP_CTL4_IOEN                	((uint32_t)1<<(CMP_CTL4_IOEN_POS))
#define CMP_CTL4_C0IE                	((uint32_t)1<<(CMP_CTL4_C0IE_POS))
#define CMP_CTL4_C1IE                	((uint32_t)1<<(CMP_CTL4_C1IE_POS))
#define CMP_CTL4_C2IE                	((uint32_t)1<<(CMP_CTL4_C2IE_POS))
#define CMP_CTL4_C3IE                	((uint32_t)1<<(CMP_CTL4_C3IE_POS))
#define CMP_CTL4_C0IC                	((uint32_t)1<<(CMP_CTL4_C0IC_POS))
#define CMP_CTL4_C1IC                	((uint32_t)1<<(CMP_CTL4_C1IC_POS))
#define CMP_CTL4_C2IC                	((uint32_t)1<<(CMP_CTL4_C2IC_POS))
#define CMP_CTL4_C3IC                	((uint32_t)1<<(CMP_CTL4_C3IC_POS))
#define CMP_CTL4_CMPOUTASEL             ((uint32_t)0x03<<(CMP_CTL4_CMPOUTASEL0_POS))
#define CMP_CTL4_CMPOUTASEL0            ((uint32_t)1<<(CMP_CTL4_CMPOUTASEL0_POS))
#define CMP_CTL4_CMPOUTASEL1            (uint32_t)1<<(CMP_CTL4_CMPOUTASEL1_POS))
#define CMP_CTL4_PWMCMP                	((uint32_t)1<<(CMP_CTL4_PWMCMP_POS))
#define CMP_CTL4_CIFMS                	((uint32_t)1<<(CMP_CTL4_CIFMS_POS))
#define CMP_CTL4_C0IF                	((uint32_t)1<<(CMP_CTL4_C0IF_POS))
#define CMP_CTL4_C1IF                	((uint32_t)1<<(CMP_CTL4_C1IF_POS))
#define CMP_CTL4_C2IF                	((uint32_t)1<<(CMP_CTL4_C2IF_POS))
#define CMP_CTL4_C3IF                	((uint32_t)1<<(CMP_CTL4_C3IF_POS))
#define CMP_CTL4_C0OUT                	((uint32_t)1<<(CMP_CTL4_C0OUT_POS))
#define CMP_CTL4_C1OUT                	((uint32_t)1<<(CMP_CTL4_C1OUT_POS))
#define CMP_CTL4_C2OUT                	((uint32_t)1<<(CMP_CTL4_C2OUT_POS))
#define CMP_CTL4_C3OUT                	((uint32_t)1<<(CMP_CTL4_C3OUT_POS))

/* CMP_CTL5λ */
#define CMP_CTL5_C0TRGSEL0_POS          (0)
#define CMP_CTL5_C0TRGSEL1_POS          (1)
#define CMP_CTL5_C1TRGSEL0_POS          (2)
#define CMP_CTL5_C1TRGSEL1_POS          (3)
#define CMP_CTL5_C2TRGSEL0_POS          (4)
#define CMP_CTL5_C2TRGSEL1_POS          (5)
#define CMP_CTL5_C3TRGSEL0_POS          (6)
#define CMP_CTL5_C3TRGSEL1_POS          (7)
#define CMP_CTL5_CMPLPEN_POS            (8)
#define CMP_CTL5_C0PSEL0_POS            (28)
#define CMP_CTL5_C0PSEL1_POS            (29)
#define CMP_CTL5_MOTORSEL_POS           (30)
#define CMP_CTL5_INSCM_POS            	(31)
#define CMP_CTL5_C0TRGSEL               ((uint32_t)0x03<<(CMP_CTL5_C0TRGSEL0_POS))
#define CMP_CTL5_C0TRGSEL0              ((uint32_t)1<<(CMP_CTL5_C0TRGSEL0_POS))
#define CMP_CTL5_C0TRGSEL1              ((uint32_t)1<<(CMP_CTL5_C0TRGSEL1_POS))
#define CMP_CTL5_C1TRGSEL               ((uint32_t)0x03<<(CMP_CTL5_C1TRGSEL0_POS))
#define CMP_CTL5_C1TRGSEL0              ((uint32_t)1<<(CMP_CTL5_C1TRGSEL0_POS))
#define CMP_CTL5_C1TRGSEL1              ((uint32_t)1<<(CMP_CTL5_C1TRGSEL1_POS))
#define CMP_CTL5_C2TRGSEL               ((uint32_t)0x03<<(CMP_CTL5_C2TRGSEL0_POS))
#define CMP_CTL5_C2TRGSEL0              ((uint32_t)1<<(CMP_CTL5_C2TRGSEL0_POS))
#define CMP_CTL5_C2TRGSEL1              ((uint32_t)1<<(CMP_CTL5_C2TRGSEL1_POS))
#define CMP_CTL5_C3TRGSEL               ((uint32_t)0x03<<(CMP_CTL5_C3TRGSEL0_POS))
#define CMP_CTL5_C3TRGSEL0              ((uint32_t)1<<(CMP_CTL5_C3TRGSEL0_POS))
#define CMP_CTL5_C3TRGSEL1              ((uint32_t)1<<(CMP_CTL5_C3TRGSEL1_POS))
#define CMP_CTL5_CMPLPEN                ((uint32_t)1<<(CMP_CTL5_CMPLPEN_POS))
#define CMP_CTL5_C0PSEL                 ((uint32_t)0x03<<(CMP_CTL5_C0PSEL0_POS))
#define CMP_CTL5_C0PSEL0                ((uint32_t)1<<(CMP_CTL5_C0PSEL0_POS))
#define CMP_CTL5_C0PSEL1                ((uint32_t)1<<(CMP_CTL5_C0PSEL1_POS))
#define CMP_CTL5_MOTORSEL               ((uint32_t)1<<(CMP_CTL5_MOTORSEL_POS))
#define CMP_CTL5_INSCM               	((uint32_t)1<<(CMP_CTL5_INSCM_POS))

/* CMP_TRIM0λ */
#define CMP_TRIM0_C0TRIMNPOL_POS          (0)
#define CMP_TRIM0_C0TRIMN0_POS            (1)
#define CMP_TRIM0_C0TRIMN1_POS            (2)
#define CMP_TRIM0_C0TRIMN2_POS            (3)
#define CMP_TRIM0_C0TRIMN3_POS            (4)
#define CMP_TRIM0_C0TRIMN4_POS            (5)
#define CMP_TRIM0_C0TRIMN5_POS            (6)
#define CMP_TRIM0_C0TRIMPPOL_POS          (7)
#define CMP_TRIM0_C0TRIMP0_POS            (8)
#define CMP_TRIM0_C0TRIMP1_POS            (9)
#define CMP_TRIM0_C0TRIMP2_POS            (10)
#define CMP_TRIM0_C0TRIMP3_POS            (11)
#define CMP_TRIM0_C0TRIMP4_POS            (12)
#define CMP_TRIM0_C0TRIMP5_POS            (13)
#define CMP_TRIM0_CMPTRIMLOWEN_POS        (30)
#define CMP_TRIM0_CMPTRIMHIEN_POS         (31)
#define CMP_TRIM0_C0TRIMNPOL              ((uint32_t)1<<(CMP_TRIM0_C0TRIMNPOL_POS))
#define CMP_TRIM0_C0TRIMN                 ((uint32_t)0x3F<<(CMP_TRIM0_C0TRIMN0_POS))
#define CMP_TRIM0_C0TRIMN0                ((uint32_t)1<<(CMP_TRIM0_C0TRIMN0_POS))
#define CMP_TRIM0_C0TRIMN1                ((uint32_t)1<<(CMP_TRIM0_C0TRIMN1_POS))
#define CMP_TRIM0_C0TRIMN2                ((uint32_t)1<<(CMP_TRIM0_C0TRIMN2_POS))
#define CMP_TRIM0_C0TRIMN3                ((uint32_t)1<<(CMP_TRIM0_C0TRIMN3_POS))
#define CMP_TRIM0_C0TRIMN4                ((uint32_t)1<<(CMP_TRIM0_C0TRIMN4_POS))
#define CMP_TRIM0_C0TRIMN5                ((uint32_t)1<<(CMP_TRIM0_C0TRIMN5_POS))
#define CMP_TRIM0_C0TRIMPPOL              ((uint32_t)1<<(CMP_TRIM0_C0TRIMPPOL_POS))
#define CMP_TRIM0_C0TRIMP                 ((uint32_t)0x3F<<(CMP_TRIM0_C0TRIMP0_POS))
#define CMP_TRIM0_C0TRIMP0                ((uint32_t)1<<(CMP_TRIM0_C0TRIMP0_POS))
#define CMP_TRIM0_C0TRIMP1                ((uint32_t)1<<(CMP_TRIM0_C0TRIMP1_POS))
#define CMP_TRIM0_C0TRIMP2                ((uint32_t)1<<(CMP_TRIM0_C0TRIMP2_POS))
#define CMP_TRIM0_C0TRIMP3                ((uint32_t)1<<(CMP_TRIM0_C0TRIMP3_POS))
#define CMP_TRIM0_C0TRIMP4                ((uint32_t)1<<(CMP_TRIM0_C0TRIMP4_POS))
#define CMP_TRIM0_C0TRIMP5                ((uint32_t)1<<(CMP_TRIM0_C0TRIMP5_POS))
#define CMP_TRIM0_CMPTRIMLOWEN            ((uint32_t)1<<(CMP_TRIM0_CMPTRIMLOWEN_POS))
#define CMP_TRIM0_CMPTRIMHIEN             ((uint32_t)1<<(CMP_TRIM0_CMPTRIMHIEN_POS))
/* ģתģ (CMP) */

#endif

#if 1										/* OP */

/* ----------------------------------------------------------------------------
   -- ˷ģ (OP)
   ---------------------------------------------------------------------------- */

/* OPɱŴģڴṹ */
typedef struct OP_MemMap
{
	volatile uint32_t CTL0;       /* ŴƼĴ0,ƫƣ0x00 */
	volatile uint32_t CTL1;       /* ŴƼĴ1,ƫƣ0x04 */
	volatile uint32_t TRIM0;      /* ŴУ׼Ĵ0,ƫƣ0x08 */
	volatile uint32_t TRIM1;      /* ŴУ׼Ĵ1,ƫƣ0x0C */
	volatile uint32_t TRIM2;      /* ŴУ׼Ĵ2,ƫƣ0x10 */
	volatile uint32_t TRIM3;      /* ŴУ׼Ĵ3,ƫƣ0x14 */
}OP_SFRmap;

/* ----------------------------------------------------------------------------
   -- OP - Ĵں
   ---------------------------------------------------------------------------- */

/* OP - Ĵڵַ */
#define OP_ADDR                  		((uint32_t)0x40002A00)
#define OP_SFR                   		((OP_SFRmap *) OP_ADDR)

/* OP - Ĵ */
#define OP_CTL0        			 		(OP_SFR->CTL0)
#define OP_CTL1        					(OP_SFR->CTL1)
#define OP_TRIM0        				(OP_SFR->TRIM0)
#define OP_TRIM1        				(OP_SFR->TRIM1)
#define OP_TRIM2              			(OP_SFR->TRIM2)
#define OP_TRIM3              			(OP_SFR->TRIM3)

/* OP_CTL0λ */
#define OP_CTL0_OP0EN_POS           	(0)
#define OP_CTL0_OP1EN_POS           	(1)
#define OP_CTL0_OP2EN_POS           	(2)
#define OP_CTL0_OP3EN_POS           	(3)
#define OP_CTL0_OP0OUTEN_POS        	(4)
#define OP_CTL0_OP1OUTEN_POS        	(5)
#define OP_CTL0_OP2OUTEN_POS        	(6)
#define OP_CTL0_OP3OUTEN_POS        	(7)
#define OP_CTL0_OP0GAIN2X_POS       	(8)
#define OP_CTL0_OP0GAIN4X_POS       	(9)
#define OP_CTL0_OP0GAIN8X_POS       	(10)
#define OP_CTL0_OP0GAIN16X_POS      	(11)
#define OP_CTL0_OP0GAIN32X_POS      	(12)
#define OP_CTL0_OP0GAIN64X_POS      	(13)
#define OP_CTL0_OP1GAIN2X_POS       	(14)
#define OP_CTL0_OP1GAIN4X_POS           (15)
#define OP_CTL0_OP1GAIN8X_POS           (16)
#define OP_CTL0_OP1GAIN16X_POS          (17)
#define OP_CTL0_OP1GAIN32X_POS          (18)
#define OP_CTL0_OP1GAIN64X_POS          (19)
#define OP_CTL0_OP2GAIN2X_POS           (20)
#define OP_CTL0_OP2GAIN4X_POS           (21)
#define OP_CTL0_OP2GAIN8X_POS           (22)
#define OP_CTL0_OP2GAIN16X_POS          (23)
#define OP_CTL0_OP2GAIN32X_POS          (24)
#define OP_CTL0_OP2GAIN64X_POS          (25)
#define OP_CTL0_OP3GAIN2X_POS           (26)
#define OP_CTL0_OP3GAIN4X_POS           (27)
#define OP_CTL0_OP3GAIN8X_POS           (28)
#define OP_CTL0_OP3GAIN16X_POS          (29)
#define OP_CTL0_OP3GAIN32X_POS          (30)
#define OP_CTL0_OP3GAIN64X_POS          (31)
#define OP_CTL0_OP0EN                	((uint32_t)1<<(OP_CTL0_OP0EN_POS))
#define OP_CTL0_OP1EN                	((uint32_t)1<<(OP_CTL0_OP1EN_POS))
#define OP_CTL0_OP2EN                	((uint32_t)1<<(OP_CTL0_OP2EN_POS))
#define OP_CTL0_OP3EN                	((uint32_t)1<<(OP_CTL0_OP3EN_POS))
#define OP_CTL0_OP0OUTEN                ((uint32_t)1<<(OP_CTL0_OP0OUTEN_POS))
#define OP_CTL0_OP1OUTEN                ((uint32_t)1<<(OP_CTL0_OP1OUTEN_POS))
#define OP_CTL0_OP2OUTEN                ((uint32_t)1<<(OP_CTL0_OP2OUTEN_POS))
#define OP_CTL0_OP3OUTEN                ((uint32_t)1<<(OP_CTL0_OP3OUTEN_POS))
#define OP_CTL0_OP0GAIN2X               ((uint32_t)1<<(OP_CTL0_OP0GAIN2X_POS))
#define OP_CTL0_OP0GAIN4X               ((uint32_t)1<<(OP_CTL0_OP0GAIN4X_POS))
#define OP_CTL0_OP0GAIN8X               ((uint32_t)1<<(OP_CTL0_OP0GAIN8X_POS))
#define OP_CTL0_OP0GAIN16X              ((uint32_t)1<<(OP_CTL0_OP0GAIN16X_POS))
#define OP_CTL0_OP0GAIN32X              ((uint32_t)1<<(OP_CTL0_OP0GAIN32X_POS))
#define OP_CTL0_OP0GAIN64X              ((uint32_t)1<<(OP_CTL0_OP0GAIN64X_POS))
#define OP_CTL0_OP1GAIN2X               ((uint32_t)1<<(OP_CTL0_OP1GAIN2X_POS))
#define OP_CTL0_OP1GAIN4X               ((uint32_t)1<<(OP_CTL0_OP1GAIN4X_POS))
#define OP_CTL0_OP1GAIN8X               ((uint32_t)1<<(OP_CTL0_OP1GAIN8X_POS))
#define OP_CTL0_OP1GAIN16X              ((uint32_t)1<<(OP_CTL0_OP1GAIN16X_POS))
#define OP_CTL0_OP1GAIN32X              ((uint32_t)1<<(OP_CTL0_OP1GAIN32X_POS))
#define OP_CTL0_OP1GAIN64X              ((uint32_t)1<<(OP_CTL0_OP1GAIN64X_POS))
#define OP_CTL0_OP2GAIN2X               ((uint32_t)1<<(OP_CTL0_OP2GAIN2X_POS))
#define OP_CTL0_OP2GAIN4X               ((uint32_t)1<<(OP_CTL0_OP2GAIN4X_POS))
#define OP_CTL0_OP2GAIN8X               ((uint32_t)1<<(OP_CTL0_OP2GAIN8X_POS))
#define OP_CTL0_OP2GAIN16X              ((uint32_t)1<<(OP_CTL0_OP2GAIN16X_POS))
#define OP_CTL0_OP2GAIN32X              ((uint32_t)1<<(OP_CTL0_OP2GAIN32X_POS))
#define OP_CTL0_OP2GAIN64X              ((uint32_t)1<<(OP_CTL0_OP2GAIN64X_POS))
#define OP_CTL0_OP3GAIN2X               ((uint32_t)1<<(OP_CTL0_OP3GAIN2X_POS))
#define OP_CTL0_OP3GAIN4X               ((uint32_t)1<<(OP_CTL0_OP3GAIN4X_POS))
#define OP_CTL0_OP3GAIN8X               ((uint32_t)1<<(OP_CTL0_OP3GAIN8X_POS))
#define OP_CTL0_OP3GAIN16X              ((uint32_t)1<<(OP_CTL0_OP3GAIN16X_POS))
#define OP_CTL0_OP3GAIN32X              ((uint32_t)1<<(OP_CTL0_OP3GAIN32X_POS))
#define OP_CTL0_OP3GAIN64X              ((uint32_t)1<<(OP_CTL0_OP3GAIN64X_POS))

/* OP_CTL1λ */
#define	OP_CTL1_ENCMP3_POS				(0)
#define	OP_CTL1_ENOPVCOM_POS			(1)
#define	OP_CTL1_OPVCOMOUTEN_POS			(2)
#define	OP_CTL1_VCOMPSEL0_POS			(3)
#define	OP_CTL1_VCOMPSEL1_POS			(4)
#define	OP_CTL1_ENOP0INSHORT_POS		(5)
#define	OP_CTL1_ENOP1INSHORT_POS		(6)
#define	OP_CTL1_ENOP2INSHORT_POS		(7)
#define	OP_CTL1_ENOP3INSHORT_POS		(8)
#define	OP_CTL1_OP0TOCU_POS				(16)
#define	OP_CTL1_OP0TOCV_POS				(17)
#define	OP_CTL1_OP0TOCW_POS				(18)
#define	OP_CTL1_OP1TOCU_POS				(19)
#define	OP_CTL1_OP1TOCV_POS				(20)
#define	OP_CTL1_OP1TOCW_POS				(21)
#define	OP_CTL1_OP2TOCU_POS				(22)
#define	OP_CTL1_OP2TOCV_POS				(23)
#define	OP_CTL1_OP2TOCW_POS				(24)
#define	OP_CTL1_OP3TOCU_POS				(25)
#define	OP_CTL1_OP3TOCV_POS				(26)
#define	OP_CTL1_OP3TOCW_POS				(27)
#define	OP_CTL1_OP010KSEL_POS		    (28)
#define	OP_CTL1_OP110KSEL_POS			(29)
#define	OP_CTL1_OP210KSEL_POS			(30)
#define	OP_CTL1_OP310KSEL_POS			(31)
#define	OP_CTL1_ENCMP3					((uint32_t)1<<(OP_CTL1_ENCMP3_POS))
#define	OP_CTL1_ENOPVCOM				((uint32_t)1<<(OP_CTL1_ENOPVCOM_POS))
#define	OP_CTL1_OPVCOMOUTEN				((uint32_t)1<<(OP_CTL1_OPVCOMOUTEN_POS))
#define	OP_CTL1_VCOMPSEL				((uint32_t)0x03<<(OP_CTL1_VCOMPSEL0_POS))
#define	OP_CTL1_VCOMPSEL0				((uint32_t)1<<(OP_CTL1_VCOMPSEL0_POS))
#define	OP_CTL1_VCOMPSEL1				((uint32_t)1<<(OP_CTL1_VCOMPSEL1_POS))
#define	OP_CTL1_ENOP0INSHORT			((uint32_t)1<<(OP_CTL1_ENOP0INSHORT_POS))
#define	OP_CTL1_ENOP1INSHORT			((uint32_t)1<<(OP_CTL1_ENOP1INSHORT_POS))
#define	OP_CTL1_ENOP2INSHORT			((uint32_t)1<<(OP_CTL1_ENOP2INSHORT_POS))
#define	OP_CTL1_ENOP3INSHORT			((uint32_t)1<<(OP_CTL1_ENOP3INSHORT_POS))
#define	OP_CTL1_OP0TOCU					((uint32_t)1<<(OP_CTL1_OP0TOCU_POS))
#define	OP_CTL1_OP0TOCV					((uint32_t)1<<(OP_CTL1_OP0TOCV_POS))
#define	OP_CTL1_OP0TOCW					((uint32_t)1<<(OP_CTL1_OP0TOCW_POS))
#define	OP_CTL1_OP1TOCU					((uint32_t)1<<(OP_CTL1_OP1TOCU_POS))
#define	OP_CTL1_OP1TOCV					((uint32_t)1<<(OP_CTL1_OP1TOCV_POS))
#define	OP_CTL1_OP1TOCW					((uint32_t)1<<(OP_CTL1_OP1TOCW_POS))
#define	OP_CTL1_OP2TOCU					((uint32_t)1<<(OP_CTL1_OP2TOCU_POS))
#define	OP_CTL1_OP2TOCV					((uint32_t)1<<(OP_CTL1_OP2TOCV_POS))
#define	OP_CTL1_OP2TOCW					((uint32_t)1<<(OP_CTL1_OP2TOCW_POS))
#define	OP_CTL1_OP3TOCU					((uint32_t)1<<(OP_CTL1_OP3TOCU_POS))
#define	OP_CTL1_OP3TOCV					((uint32_t)1<<(OP_CTL1_OP3TOCV_POS))
#define	OP_CTL1_OP3TOCW					((uint32_t)1<<(OP_CTL1_OP3TOCW_POS))
#define	OP_CTL1_OP010KSEL				((uint32_t)1<<(OP_CTL1_OP010KSEL_POS))
#define	OP_CTL1_OP110KSEL				((uint32_t)1<<(OP_CTL1_OP110KSEL_POS))
#define	OP_CTL1_OP210KSEL				((uint32_t)1<<(OP_CTL1_OP210KSEL_POS))
#define	OP_CTL1_OP310KSEL				((uint32_t)1<<(OP_CTL1_OP310KSEL_POS))

/* OP0_TRIMλ */
#define	OP_TRIM_OP0TRIMNPOL_POS			(0)
#define	OP_TRIM_OP0TRIMN0_POS			(1)
#define	OP_TRIM_OP0TRIMN1_POS			(2)
#define	OP_TRIM_OP0TRIMN2_POS			(3)
#define	OP_TRIM_OP0TRIMN3_POS			(4)
#define	OP_TRIM_OP0TRIMN4_POS			(5)
#define	OP_TRIM_OP0TRIMN5_POS			(6)
#define	OP_TRIM_OP0TRIMPPOL_POS			(7)
#define	OP_TRIM_OP0TRIMP0_POS			(8)
#define	OP_TRIM_OP0TRIMP1_POS			(9)
#define	OP_TRIM_OP0TRIMP2_POS			(10)
#define	OP_TRIM_OP0TRIMP3_POS			(11)
#define	OP_TRIM_OP0TRIMP4_POS			(12)
#define	OP_TRIM_OP0TRIMP5_POS			(13)
#define	OP_TRIM_OP0TRIMOUT_POS			(24)
#define	OP_TRIM_OPTRIMLOWEN_POS			(30)
#define	OP_TRIM_OPTRIMHIEN_POS			(31)
#define	OP_TRIM_OP0TRIMNPOL				((uint32_t)1<<(OP_TRIM_OP0TRIMNPOL_POS))
#define	OP_TRIM_OP0TRIMN				((uint32_t)0x3F<<(OP_TRIM_OP0TRIMN0_POS))
#define	OP_TRIM_OP0TRIMN0				((uint32_t)1<<(OP_TRIM_OP0TRIMN0_POS))
#define	OP_TRIM_OP0TRIMN1				((uint32_t)1<<(OP_TRIM_OP0TRIMN1_POS))
#define	OP_TRIM_OP0TRIMN2				((uint32_t)1<<(OP_TRIM_OP0TRIMN2_POS))
#define	OP_TRIM_OP0TRIMN3				((uint32_t)1<<(OP_TRIM_OP0TRIMN3_POS))
#define	OP_TRIM_OP0TRIMN4				((uint32_t)1<<(OP_TRIM_OP0TRIMN4_POS))
#define	OP_TRIM_OP0TRIMN5				((uint32_t)1<<(OP_TRIM_OP0TRIMN5_POS))
#define	OP_TRIM_OP0TRIMPPOL				((uint32_t)1<<(OP_TRIM_OP0TRIMPPOL_POS))
#define	OP_TRIM_OP0TRIMP				((uint32_t)0x3F<<(OP_TRIM_OP0TRIMP0_POS))
#define	OP_TRIM_OP0TRIMP0				((uint32_t)1<<(OP_TRIM_OP0TRIMP0_POS))
#define	OP_TRIM_OP0TRIMP1				((uint32_t)1<<(OP_TRIM_OP0TRIMP1_POS))
#define	OP_TRIM_OP0TRIMP2				((uint32_t)1<<(OP_TRIM_OP0TRIMP2_POS))
#define	OP_TRIM_OP0TRIMP3				((uint32_t)1<<(OP_TRIM_OP0TRIMP3_POS))
#define	OP_TRIM_OP0TRIMP4				((uint32_t)1<<(OP_TRIM_OP0TRIMP4_POS))
#define	OP_TRIM_OP0TRIMP5				((uint32_t)1<<(OP_TRIM_OP0TRIMP5_POS))
#define	OP_TRIM_OP0TRIMOUT				((uint32_t)1<<(OP_TRIM_OP0TRIMOUT_POS))
#define	OP_TRIM_OPTRIMLOWEN				((uint32_t)1<<(OP_TRIM_OPTRIMLOWEN_POS))
#define	OP_TRIM_OPTRIMHIEN				((uint32_t)1<<(OP_TRIM_OPTRIMHIEN_POS))

/* OP1_TRIM1λ */
#define	OP_TRIM1_OP1TRIMNPOL_POS		(0)
#define	OP_TRIM1_OP1TRIMN0_POS			(1)
#define	OP_TRIM1_OP1TRIMN1_POS			(2)
#define	OP_TRIM1_OP1TRIMN2_POS			(3)
#define	OP_TRIM1_OP1TRIMN3_POS			(4)
#define	OP_TRIM1_OP1TRIMN4_POS			(5)
#define	OP_TRIM1_OP1TRIMN5_POS			(6)
#define	OP_TRIM1_OP1TRIMPPOL_POS		(7)
#define	OP_TRIM1_OP1TRIMP0_POS			(8)
#define	OP_TRIM1_OP1TRIMP1_POS			(9)
#define	OP_TRIM1_OP1TRIMP2_POS			(10)
#define	OP_TRIM1_OP1TRIMP3_POS			(11)
#define	OP_TRIM1_OP1TRIMP4_POS			(12)
#define	OP_TRIM1_OP1TRIMP5_POS			(13)
#define	OP_TRIM1_OP1TRIMOUT_POS			(24)
#define	OP_TRIM1_OP1TRIMNPOL			((uint32_t)1<<(OP_TRIM1_OP1TRIMNPOL_POS))
#define	OP_TRIM1_OP1TRIMN				((uint32_t)0x3F<<(OP_TRIM1_OP1TRIMN0_POS))
#define	OP_TRIM1_OP1TRIMN0				((uint32_t)1<<(OP_TRIM1_OP1TRIMN0_POS))
#define	OP_TRIM1_OP1TRIMN1				((uint32_t)1<<(OP_TRIM1_OP1TRIMN1_POS))
#define	OP_TRIM1_OP1TRIMN2				((uint32_t)1<<(OP_TRIM1_OP1TRIMN2_POS))
#define	OP_TRIM1_OP1TRIMN3				((uint32_t)1<<(OP_TRIM1_OP1TRIMN3_POS))
#define	OP_TRIM1_OP1TRIMN4				((uint32_t)1<<(OP_TRIM1_OP1TRIMN4_POS))
#define	OP_TRIM1_OP1TRIMN5				((uint32_t)1<<(OP_TRIM1_OP1TRIMN5_POS))
#define	OP_TRIM1_OP1TRIMPPOL			((uint32_t)1<<(OP_TRIM1_OP1TRIMPPOL_POS))
#define	OP_TRIM1_OP1TRIMP				((uint32_t)0x3F<<(OP_TRIM1_OP1TRIMP0_POS))
#define	OP_TRIM1_OP1TRIMP0				((uint32_t)1<<(OP_TRIM1_OP1TRIMP0_POS))
#define	OP_TRIM1_OP1TRIMP1				((uint32_t)1<<(OP_TRIM1_OP1TRIMP1_POS))
#define	OP_TRIM1_OP1TRIMP2				((uint32_t)1<<(OP_TRIM1_OP1TRIMP2_POS))
#define	OP_TRIM1_OP1TRIMP3				((uint32_t)1<<(OP_TRIM1_OP1TRIMP3_POS))
#define	OP_TRIM1_OP1TRIMP4				((uint32_t)1<<(OP_TRIM1_OP1TRIMP4_POS))
#define	OP_TRIM1_OP1TRIMP5				((uint32_t)1<<(OP_TRIM1_OP1TRIMP5_POS))
#define	OP_TRIM1_OP1TRIMOUT				((uint32_t)1<<(OP_TRIM1_OP1TRIMOUT_POS))

/* OP2_TRIM2λ */
#define	OP_TRIM2_OP2TRIMNPOL_POS		(0)
#define	OP_TRIM2_OP2TRIMN0_POS			(1)
#define	OP_TRIM2_OP2TRIMN1_POS			(2)
#define	OP_TRIM2_OP2TRIMN2_POS			(3)
#define	OP_TRIM2_OP2TRIMN3_POS			(4)
#define	OP_TRIM2_OP2TRIMN4_POS			(5)
#define	OP_TRIM2_OP2TRIMN5_POS			(6)
#define	OP_TRIM2_OP2TRIMPPOL_POS		(7)
#define	OP_TRIM2_OP2TRIMP0_POS			(8)
#define	OP_TRIM2_OP2TRIMP1_POS			(9)
#define	OP_TRIM2_OP2TRIMP2_POS			(10)
#define	OP_TRIM2_OP2TRIMP3_POS			(11)
#define	OP_TRIM2_OP2TRIMP4_POS			(12)
#define	OP_TRIM2_OP2TRIMP5_POS			(13)
#define	OP_TRIM2_OP2TRIMOUT_POS			(24)
#define	OP_TRIM2_OP2TRIMNPOL			((uint32_t)1<<(OP_TRIM2_OP2TRIMNPOL_POS))
#define	OP_TRIM2_OP2TRIMN				((uint32_t)0x3F<<(OP_TRIM2_OP2TRIMN0_POS))
#define	OP_TRIM2_OP2TRIMN0				((uint32_t)1<<(OP_TRIM2_OP2TRIMN0_POS))
#define	OP_TRIM2_OP2TRIMN1				((uint32_t)1<<(OP_TRIM2_OP2TRIMN1_POS))
#define	OP_TRIM2_OP2TRIMN2				((uint32_t)1<<(OP_TRIM2_OP2TRIMN2_POS))
#define	OP_TRIM2_OP2TRIMN3				((uint32_t)1<<(OP_TRIM2_OP2TRIMN3_POS))
#define	OP_TRIM2_OP2TRIMN4				((uint32_t)1<<(OP_TRIM2_OP2TRIMN4_POS))
#define	OP_TRIM2_OP2TRIMN5				((uint32_t)1<<(OP_TRIM2_OP2TRIMN5_POS))
#define	OP_TRIM2_OP2TRIMPPOL			((uint32_t)1<<(OP_TRIM2_OP2TRIMPPOL_POS))
#define	OP_TRIM2_OP2TRIMP				((uint32_t)0x3F<<(OP_TRIM2_OP2TRIMP0_POS))
#define	OP_TRIM2_OP2TRIMP0				((uint32_t)1<<(OP_TRIM2_OP2TRIMP0_POS))
#define	OP_TRIM2_OP2TRIMP1				((uint32_t)1<<(OP_TRIM2_OP2TRIMP1_POS))
#define	OP_TRIM2_OP2TRIMP2				((uint32_t)1<<(OP_TRIM2_OP2TRIMP2_POS))
#define	OP_TRIM2_OP2TRIMP3				((uint32_t)1<<(OP_TRIM2_OP2TRIMP3_POS))
#define	OP_TRIM2_OP2TRIMP4				((uint32_t)1<<(OP_TRIM2_OP2TRIMP4_POS))
#define	OP_TRIM2_OP2TRIMP5				((uint32_t)1<<(OP_TRIM2_OP2TRIMP5_POS))
#define	OP_TRIM2_OP2TRIMOUT				((uint32_t)1<<(OP_TRIM2_OP2TRIMOUT_POS))

/* OP3_TRIM3λ */
#define	OP_TRIM3_OP3TRIMNPOL_POS		(0)
#define	OP_TRIM3_OP3TRIMN0_POS			(1)
#define	OP_TRIM3_OP3TRIMN1_POS			(2)
#define	OP_TRIM3_OP3TRIMN2_POS			(3)
#define	OP_TRIM3_OP3TRIMN3_POS			(4)
#define	OP_TRIM3_OP3TRIMN4_POS			(5)
#define	OP_TRIM3_OP3TRIMN5_POS			(6)
#define	OP_TRIM3_OP3TRIMPPOL_POS		(7)
#define	OP_TRIM3_OP3TRIMP0_POS			(8)
#define	OP_TRIM3_OP3TRIMP1_POS			(9)
#define	OP_TRIM3_OP3TRIMP2_POS			(10)
#define	OP_TRIM3_OP3TRIMP3_POS			(11)
#define	OP_TRIM3_OP3TRIMP4_POS			(12)
#define	OP_TRIM3_OP3TRIMP5_POS			(13)
#define	OP_TRIM3_OP3TRIMOUT_POS			(24)
#define	OP_TRIM3_OP3TRIMNPOL			((uint32_t)1<<(OP_TRIM3_OP3TRIMNPOL_POS))
#define	OP_TRIM3_OP3TRIMN				((uint32_t)0x3F<<(OP_TRIM3_OP3TRIMN0_POS))
#define	OP_TRIM3_OP3TRIMN0				((uint32_t)1<<(OP_TRIM3_OP3TRIMN0_POS))
#define	OP_TRIM3_OP3TRIMN1				((uint32_t)1<<(OP_TRIM3_OP3TRIMN1_POS))
#define	OP_TRIM3_OP3TRIMN2				((uint32_t)1<<(OP_TRIM3_OP3TRIMN2_POS))
#define	OP_TRIM3_OP3TRIMN3				((uint32_t)1<<(OP_TRIM3_OP3TRIMN3_POS))
#define	OP_TRIM3_OP3TRIMN4				((uint32_t)1<<(OP_TRIM3_OP3TRIMN4_POS))
#define	OP_TRIM3_OP3TRIMN5				((uint32_t)1<<(OP_TRIM3_OP3TRIMN5_POS))
#define	OP_TRIM3_OP3TRIMPPOL			((uint32_t)1<<(OP_TRIM3_OP3TRIMPPOL_POS))
#define	OP_TRIM3_OP3TRIMP				((uint32_t)0x3F<<(OP_TRIM3_OP3TRIMP0_POS))
#define	OP_TRIM3_OP3TRIMP0				((uint32_t)1<<(OP_TRIM3_OP3TRIMP0_POS))
#define	OP_TRIM3_OP3TRIMP1				((uint32_t)1<<(OP_TRIM3_OP3TRIMP1_POS))
#define	OP_TRIM3_OP3TRIMP2				((uint32_t)1<<(OP_TRIM3_OP3TRIMP2_POS))
#define	OP_TRIM3_OP3TRIMP3				((uint32_t)1<<(OP_TRIM3_OP3TRIMP3_POS))
#define	OP_TRIM3_OP3TRIMP4				((uint32_t)1<<(OP_TRIM3_OP3TRIMP4_POS))
#define	OP_TRIM3_OP3TRIMP5				((uint32_t)1<<(OP_TRIM3_OP3TRIMP5_POS))
#define	OP_TRIM3_OP3TRIMOUT				((uint32_t)1<<(OP_TRIM3_OP3TRIMOUT_POS))
/* ɱŴ(OP) */

#endif

#if 1										/* USART */

/* ----------------------------------------------------------------------------
   -- ͨȫ/˫շ (USART)
   ---------------------------------------------------------------------------- */

/* USART - Ĵڴṹ */
typedef struct USART_MemMap
{
    volatile uint32_t CTLR;             /* USARTƼĴ, ƫ:0x00 */
    volatile uint32_t BRGR;             /* USARTʼĴ, ƫ:0x04 */
    volatile uint32_t STR;              /* USART״̬Ĵ, ƫ:0x08 */
    union
    {
        volatile       uint32_t TBUFR;  /* USARTݼĴ, ƫ:0x0C */
        volatile const uint32_t RBUFR;  /* USARTݼĴ, ƫ:0x0C */
    };
    volatile uint32_t U7816R;           /* 7816ƼĴ, ƫ:0x10 */
    volatile uint32_t IER;              /* USARTжʹܼĴ, ƫ:0x14 */
    volatile uint32_t ADM;              /* ַƥüĴ, ƫ:0x18 */
}USART_SFRmap;

/* ----------------------------------------------------------------------------
   -- USART - Ĵں
   ---------------------------------------------------------------------------- */

/* USART - Ĵڵַ */
#define USART0_ADDR                     ((uint32_t)0x40000980)
#define USART1_ADDR                     ((uint32_t)0x40000A00)
#define USART2_ADDR                     ((uint32_t)0x40000A80)
#define USART5_ADDR                     ((uint32_t)0x40001E80)
#define USART0_SFR                      ((USART_SFRmap *) USART0_ADDR)
#define USART1_SFR                      ((USART_SFRmap *) USART1_ADDR)
#define USART2_SFR                      ((USART_SFRmap *) USART2_ADDR)
#define USART5_SFR                      ((USART_SFRmap *) USART5_ADDR)

/* USART - Ĵ */
#define USART0_CTLR                     (USART0_SFR->CTLR)
#define USART0_BRGR                     (USART0_SFR->BRGR)
#define USART0_STR                      (USART0_SFR->STR)
#define USART0_TBUFR                    (USART0_SFR->TBUFR)
#define USART0_RBUFR                    (USART0_SFR->RBUFR)
#define USART0_U7816R                   (USART0_SFR->U7816R)
#define USART0_IER                      (USART0_SFR->IER)
#define USART0_ADM                      (USART0_SFR->ADM)

#define USART1_CTLR                     (USART1_SFR->CTLR)
#define USART1_BRGR                     (USART1_SFR->BRGR)
#define USART1_STR                      (USART1_SFR->STR)
#define USART1_TBUFR                    (USART1_SFR->TBUFR)
#define USART1_RBUFR                    (USART1_SFR->RBUFR)
#define USART1_U7816R                   (USART1_SFR->U7816R)
#define USART1_IER                      (USART1_SFR->IER)
#define USART1_ADM                      (USART1_SFR->ADM)

#define USART2_CTLR                     (USART2_SFR->CTLR)
#define USART2_BRGR                     (USART2_SFR->BRGR)
#define USART2_STR                      (USART2_SFR->STR)
#define USART2_TBUFR                    (USART2_SFR->TBUFR)
#define USART2_RBUFR                    (USART2_SFR->RBUFR)
#define USART2_U7816R                   (USART2_SFR->U7816R)
#define USART2_IER                      (USART2_SFR->IER)
#define USART2_ADM                      (USART2_SFR->ADM)

#define USART5_CTLR                     (USART5_SFR->CTLR)
#define USART5_BRGR                     (USART5_SFR->BRGR)
#define USART5_STR                      (USART5_SFR->STR)
#define USART5_TBUFR                    (USART5_SFR->TBUFR)
#define USART5_RBUFR                    (USART5_SFR->RBUFR)
#define USART5_U7816R                   (USART5_SFR->U7816R)
#define USART5_IER                      (USART5_SFR->IER)
#define USART5_ADM                      (USART5_SFR->ADM)

/* USART_CTLR λ */
#define USART_CTLR_USARTEN_POS          (0)
#define USART_CTLR_BRCKS0_POS           (1)
#define USART_CTLR_BRCKS1_POS           (2)
#define USART_CTLR_SCKPS_POS            (3)
#define USART_CTLR_TCONV_POS            (4)
#define USART_CTLR_RCONV_POS            (5)
#define USART_CTLR_DINV_POS             (6)
#define USART_CTLR_WUEN_POS             (7)
#define USART_CTLR_CSRS_POS             (8)
#define USART_CTLR_ADREN_POS            (9)
#define USART_CTLR_ABRDEN_POS           (11)
#define USART_CTLR_RIDLEIS_POS          (12)
#define USART_CTLR_SENDB_POS            (13)
#define USART_CTLR_SYNC_POS             (14)
#define USART_CTLR_TXEN_POS             (15)
#define USART_CTLR_RXEN_POS             (16)
#define USART_CTLR_TIDLEEN_POS          (17)
#define USART_CTLR_STPW_POS             (18)
#define USART_CTLR_TX9SEL_POS           (19)
#define USART_CTLR_PARM_POS             (20)
#define USART_CTLR_DT9EN_POS            (21)
#define USART_CTLR_CTSEN_POS            (24)
#define USART_CTLR_RTSEN_POS            (25)
#define USART_CTLR_BKPWS_POS            (26)
#define USART_CTLR_IRDAEN_POS           (29)
#define USART_CTLR_RESHD_POS            (30)
#define USART_CTLR_SLMEN_POS            (31)
#define USART_CTLR_USARTEN              ((uint32_t)1<<(USART_CTLR_USARTEN_POS))
#define USART_CTLR_BRCKS                ((uint32_t)3<<(USART_CTLR_BRCKS0_POS))
#define USART_CTLR_BRCKS0               ((uint32_t)1<<(USART_CTLR_BRCKS0_POS))
#define USART_CTLR_BRCKS1               ((uint32_t)1<<(USART_CTLR_BRCKS1_POS))
#define USART_CTLR_SCKPS                ((uint32_t)1<<(USART_CTLR_SCKPS_POS))
#define USART_CTLR_TCONV                ((uint32_t)1<<(USART_CTLR_TCONV_POS))
#define USART_CTLR_RCONV                ((uint32_t)1<<(USART_CTLR_RCONV_POS))
#define USART_CTLR_DINV                 ((uint32_t)1<<(USART_CTLR_DINV_POS))
#define USART_CTLR_WUEN                 ((uint32_t)1<<(USART_CTLR_WUEN_POS))
#define USART_CTLR_CSRS                 ((uint32_t)1<<(USART_CTLR_CSRS_POS))
#define USART_CTLR_ADREN                ((uint32_t)1<<(USART_CTLR_ADREN_POS))
#define USART_CTLR_ABRDEN               ((uint32_t)1<<(USART_CTLR_ABRDEN_POS))
#define USART_CTLR_RIDLEIS               ((uint32_t)1<<(USART_CTLR_RIDLEIS_POS))
#define USART_CTLR_SENDB                ((uint32_t)1<<(USART_CTLR_SENDB_POS))
#define USART_CTLR_SYNC                 ((uint32_t)1<<(USART_CTLR_SYNC_POS))
#define USART_CTLR_TXEN                 ((uint32_t)1<<(USART_CTLR_TXEN_POS))
#define USART_CTLR_RXEN                 ((uint32_t)1<<(USART_CTLR_RXEN_POS))
#define USART_CTLR_TIDLEEN              ((uint32_t)1<<(USART_CTLR_TIDLEEN_POS))
#define USART_CTLR_STPW                 ((uint32_t)1<<(USART_CTLR_STPW_POS))
#define USART_CTLR_TX9SEL               ((uint32_t)1<<(USART_CTLR_TX9SEL_POS))
#define USART_CTLR_PARM                 ((uint32_t)1<<(USART_CTLR_PARM_POS))
#define USART_CTLR_DT9EN                ((uint32_t)1<<(USART_CTLR_DT9EN_POS))
#define USART_CTLR_CTSEN                ((uint32_t)1<<(USART_CTLR_CTSEN_POS))
#define USART_CTLR_RTSEN                ((uint32_t)1<<(USART_CTLR_RTSEN_POS))
#define USART_CTLR_BKPWS                ((uint32_t)1<<(USART_CTLR_BKPWS_POS))
#define USART_CTLR_IRDAEN               ((uint32_t)1<<(USART_CTLR_IRDAEN_POS))
#define USART_CTLR_RESHD                ((uint32_t)1<<(USART_CTLR_RESHD_POS))
#define USART_CTLR_SLMEN                ((uint32_t)1<<(USART_CTLR_SLMEN_POS))

/* USART_BRGR λ*/
#define USART_BRGR_BRGM0_POS            (0)
#define USART_BRGR_BRGF1_0_POS          (16)
#define USART_BRGR_BRGF2_0_POS          (20)
#define USART_BRGR_BRGM                 ((uint32_t)0xFFFF<<(USART_BRGR_BRGM0_POS))
#define USART_BRGR_BRGF1                ((uint32_t)0xF<<(USART_BRGR_BRGF1_0_POS))
#define USART_BRGR_BRGF2                ((uint32_t)0xF<<(USART_BRGR_BRGF2_0_POS))

/* USART_STR λ*/
#define USART_STR_OVFEIF_POS            (0)
#define USART_STR_PAREIF_POS            (1)
#define USART_STR_FREIF_POS             (2)
#define USART_STR_BRIF_POS              (3)
#define USART_STR_ABTOIF_POS            (4)
#define USART_STR_WUIF_POS              (5)
#define USART_STR_TEIF_POS              (6)
#define USART_STR_REIF_POS              (7)
#define USART_STR_CTSIF_POS             (8)
#define USART_STR_RCFR_POS              (9)
#define USART_STR_TXFR_POS              (10)
#define USART_STR_RDRIF_POS             (11)
#define USART_STR_TFEIF_POS             (12)
#define USART_STR_TXEIF_POS             (13)
#define USART_STR_UADMIF_POS            (14)
#define USART_STR_IDLEIF_POS            (15)
#define USART_STR_OVFEIC_POS            (16)
#define USART_STR_PAREIC_POS            (17)
#define USART_STR_FREIC_POS             (18)
#define USART_STR_BRIC_POS              (19)
#define USART_STR_ABTOIC_POS            (20)
#define USART_STR_WUIC_POS              (21)
#define USART_STR_TEIC_POS              (22)
#define USART_STR_REIC_POS              (23)
#define USART_STR_CTSIC_POS             (24)
#define USART_STR_UADMIC_POS            (25)
#define USART_STR_IDLEIC_POS            (26)
#define USART_STR_OVFEIF                ((uint32_t)1<<(USART_STR_OVFEIF_POS))
#define USART_STR_PAREIF                ((uint32_t)1<<(USART_STR_PAREIF_POS))
#define USART_STR_FREIF                 ((uint32_t)1<<(USART_STR_FREIF_POS))
#define USART_STR_BRIF                  ((uint32_t)1<<(USART_STR_BRIF_POS))
#define USART_STR_ABTOIF                ((uint32_t)1<<(USART_STR_ABTOIF_POS))
#define USART_STR_WUIF                  ((uint32_t)1<<(USART_STR_WUIF_POS))
#define USART_STR_TEIF                  ((uint32_t)1<<(USART_STR_TEIF_POS))
#define USART_STR_REIF                  ((uint32_t)1<<(USART_STR_REIF_POS))
#define USART_STR_CTSIF                 ((uint32_t)1<<(USART_STR_CTSIF_POS))
#define USART_STR_RCFR                  ((uint32_t)1<<(USART_STR_RCFR_POS))
#define USART_STR_TXFR                  ((uint32_t)1<<(USART_STR_TXFR_POS))
#define USART_STR_RDRIF                 ((uint32_t)1<<(USART_STR_RDRIF_POS))
#define USART_STR_TFEIF                 ((uint32_t)1<<(USART_STR_TFEIF_POS))
#define USART_STR_TXEIF                 ((uint32_t)1<<(USART_STR_TXEIF_POS))
#define USART_STR_UADMIF                ((uint32_t)1<<(USART_STR_UADMIF_POS))
#define USART_STR_IDLEIF                ((uint32_t)1<<(USART_STR_IDLEIF_POS))
#define USART_STR_OVFEIC                ((uint32_t)1<<(USART_STR_OVFEIC_POS))
#define USART_STR_PAREIC                ((uint32_t)1<<(USART_STR_PAREIC_POS))
#define USART_STR_FREIC                 ((uint32_t)1<<(USART_STR_FREIC_POS))
#define USART_STR_BRIC                  ((uint32_t)1<<(USART_STR_BRIC_POS))
#define USART_STR_ABTOIC                ((uint32_t)1<<(USART_STR_ABTOIC_POS))
#define USART_STR_WUIC                  ((uint32_t)1<<(USART_STR_WUIC_POS))
#define USART_STR_TEIC                  ((uint32_t)1<<(USART_STR_TEIC_POS))
#define USART_STR_REIC                  ((uint32_t)1<<(USART_STR_REIC_POS))
#define USART_STR_CTSIC                 ((uint32_t)1<<(USART_STR_CTSIC_POS))
#define USART_STR_UADMIC                ((uint32_t)1<<(USART_STR_UADMIC_POS))
#define USART_STR_IDLEIC                ((uint32_t)1<<(USART_STR_IDLEIC_POS))

/* USART_TBUFR λ*/
#define USART_TBUFR_TBUF0_POS           (0)
#define USART_TBUFR_TBUF                ((uint32_t)0xFF<<(USART_TBUFR_TBUF0_POS))

/* USART_RBUFR λ*/
#define USART_RBUFR_RBUF0_POS           (0)
#define USART_RBUFR_RBUF                ((uint32_t)0xFF<<(USART_RBUFR_RBUF0_POS))

/* USART_U7816R λ*/
#define USART_U7816R_7816EN_POS         (0)
#define USART_U7816R_CLKOUT_POS         (1)
#define USART_U7816R_ERSW0_POS          (2)
#define USART_U7816R_ERSW1_POS          (3)
#define USART_U7816R_PSEL_POS           (4)
#define USART_U7816R_BGT_POS            (5)
#define USART_U7816R_TREPEN_POS         (8)
#define USART_U7816R_RREPEN_POS         (9)
#define USART_U7816R_TXRE0_POS          (10)
#define USART_U7816R_TXRE1_POS          (11)
#define USART_U7816R_RXRE0_POS          (12)
#define USART_U7816R_RXRE1_POS          (13)
#define USART_U7816R_TREPMS_POS         (14)
#define USART_U7816R_CLKDIV0_POS        (16)
#define USART_U7816R_CLKDIV1_POS        (17)
#define USART_U7816R_CLKDIV2_POS        (18)
#define USART_U7816R_CLKDIV3_POS        (19)
#define USART_U7816R_CLKDIV4_POS        (20)
#define USART_U7816R_CLKDIV5_POS        (21)
#define USART_U7816R_CLKDIV6_POS        (22)
#define USART_U7816R_CLKDIV7_POS        (23)
#define USART_U7816R_EGT0_POS           (24)
#define USART_U7816R_EGT1_POS           (25)
#define USART_U7816R_EGT2_POS           (26)
#define USART_U7816R_EGT3_POS           (27)
#define USART_U7816R_EGT4_POS           (28)
#define USART_U7816R_EGT5_POS           (29)
#define USART_U7816R_EGT6_POS           (30)
#define USART_U7816R_EGT7_POS           (31)
#define USART_U7816R_7816EN             ((uint32_t)1<<(USART_U7816R_7816EN_POS))
#define USART_U7816R_CLKOUT             ((uint32_t)1<<(USART_U7816R_CLKOUT_POS))
#define USART_U7816R_ERSW               ((uint32_t)3<<(USART_U7816R_ERSW0_POS))
#define USART_U7816R_ERSW0              ((uint32_t)1<<(USART_U7816R_ERSW0_POS))
#define USART_U7816R_ERSW1              ((uint32_t)1<<(USART_U7816R_ERSW1_POS))
#define USART_U7816R_PSEL               ((uint32_t)1<<(USART_U7816R_PSEL_POS))
#define USART_U7816R_BGT                ((uint32_t)1<<(USART_U7816R_BGT_POS))
#define USART_U7816R_TREPEN             ((uint32_t)1<<(USART_U7816R_TREPEN_POS))
#define USART_U7816R_RREPEN             ((uint32_t)1<<(USART_U7816R_RREPEN_POS))
#define USART_U7816R_TXRE               ((uint32_t)3<<(USART_U7816R_TXRE0_POS))
#define USART_U7816R_TXRE0              ((uint32_t)1<<(USART_U7816R_TXRE0_POS))
#define USART_U7816R_TXRE1              ((uint32_t)1<<(USART_U7816R_TXRE1_POS))
#define USART_U7816R_RXRE               ((uint32_t)3<<(USART_U7816R_RXRE0_POS))
#define USART_U7816R_RXRE0              ((uint32_t)1<<(USART_U7816R_RXRE0_POS))
#define USART_U7816R_RXRE1              ((uint32_t)1<<(USART_U7816R_RXRE1_POS))
#define USART_U7816R_TREPMS             ((uint32_t)1<<(USART_U7816R_TREPMS_POS))
#define USART_U7816R_CLKDIV             ((uint32_t)0xFF<<(USART_U7816R_CLKDIV0_POS))
#define USART_U7816R_CLKDIV0            ((uint32_t)1<<(USART_U7816R_CLKDIV0_POS))
#define USART_U7816R_CLKDIV1            ((uint32_t)1<<(USART_U7816R_CLKDIV1_POS))
#define USART_U7816R_CLKDIV2            ((uint32_t)1<<(USART_U7816R_CLKDIV2_POS))
#define USART_U7816R_CLKDIV3            ((uint32_t)1<<(USART_U7816R_CLKDIV3_POS))
#define USART_U7816R_CLKDIV4            ((uint32_t)1<<(USART_U7816R_CLKDIV4_POS))
#define USART_U7816R_CLKDIV5            ((uint32_t)1<<(USART_U7816R_CLKDIV5_POS))
#define USART_U7816R_CLKDIV6            ((uint32_t)1<<(USART_U7816R_CLKDIV6_POS))
#define USART_U7816R_CLKDIV7            ((uint32_t)1<<(USART_U7816R_CLKDIV7_POS))
#define USART_U7816R_EGT                ((uint32_t)0xFF<<(USART_U7816R_EGT0_POS))
#define USART_U7816R_EGT0               ((uint32_t)1<<(USART_U7816R_EGT0_POS))
#define USART_U7816R_EGT1               ((uint32_t)1<<(USART_U7816R_EGT1_POS))
#define USART_U7816R_EGT2               ((uint32_t)1<<(USART_U7816R_EGT2_POS))
#define USART_U7816R_EGT3               ((uint32_t)1<<(USART_U7816R_EGT3_POS))
#define USART_U7816R_EGT4               ((uint32_t)1<<(USART_U7816R_EGT4_POS))
#define USART_U7816R_EGT5               ((uint32_t)1<<(USART_U7816R_EGT5_POS))
#define USART_U7816R_EGT6               ((uint32_t)1<<(USART_U7816R_EGT6_POS))
#define USART_U7816R_EGT7               ((uint32_t)1<<(USART_U7816R_EGT7_POS))

/* USART_IER λ*/
#define USART_IER_OVFEIE_POS            (0)
#define USART_IER_PAREIE_POS            (1)
#define USART_IER_FREIE_POS             (2)
#define USART_IER_BRIE_POS              (3)
#define USART_IER_ABTOIE_POS            (4)
#define USART_IER_WUIE_POS              (5)
#define USART_IER_TEIE_POS              (6)
#define USART_IER_REIE_POS              (7)
#define USART_IER_CTSIE_POS             (8)
#define USART_IER_RDRIE_POS             (9)
#define USART_IER_TFEIE_POS             (10)
#define USART_IER_TXEIE_POS             (11)
#define USART_IER_IDLEIE_POS            (12)
#define USART_IER_URCDE_POS             (16)
#define USART_IER_UTXDE_POS             (17)
#define USART_IER_OVFEIE                ((uint32_t)1<<(USART_IER_OVFEIE_POS))
#define USART_IER_PAREIE                ((uint32_t)1<<(USART_IER_PAREIE_POS))
#define USART_IER_FREIE                 ((uint32_t)1<<(USART_IER_FREIE_POS))
#define USART_IER_BRIE                  ((uint32_t)1<<(USART_IER_BRIE_POS))
#define USART_IER_ABTOIE                ((uint32_t)1<<(USART_IER_ABTOIE_POS))
#define USART_IER_WUIE                  ((uint32_t)1<<(USART_IER_WUIE_POS))
#define USART_IER_TEIE                  ((uint32_t)1<<(USART_IER_TEIE_POS))
#define USART_IER_REIE                  ((uint32_t)1<<(USART_IER_REIE_POS))
#define USART_IER_CTSIE                 ((uint32_t)1<<(USART_IER_CTSIE_POS))
#define USART_IER_RDRIE                 ((uint32_t)1<<(USART_IER_RDRIE_POS))
#define USART_IER_TFEIE                 ((uint32_t)1<<(USART_IER_TFEIE_POS))
#define USART_IER_TXEIE                 ((uint32_t)1<<(USART_IER_TXEIE_POS))
#define USART_IER_IDLEIE                 ((uint32_t)1<<(USART_IER_IDLEIE_POS))
#define USART_IER_URCDE                 ((uint32_t)1<<(USART_IER_URCDE_POS))
#define USART_IER_UTXDE                 ((uint32_t)1<<(USART_IER_UTXDE_POS))

/* USART_ADM λ*/
#define USART_ADM_ADM0_POS              (0)
#define USART_ADM_ADM1_POS              (1)
#define USART_ADM_ADM2_POS              (2)
#define USART_ADM_ADM3_POS              (3)
#define USART_ADM_ADM4_POS              (4)
#define USART_ADM_ADM5_POS              (5)
#define USART_ADM_ADM6_POS              (6)
#define USART_ADM_ADM7_POS              (7)
#define USART_ADM_ADM                   ((uint32_t)0xFF<<(USART_ADM_ADM0_POS))
#define USART_ADM_ADM0                  ((uint32_t)1<<(USART_ADM_ADM0_POS))
#define USART_ADM_ADM1                  ((uint32_t)1<<(USART_ADM_ADM1_POS))
#define USART_ADM_ADM2                  ((uint32_t)1<<(USART_ADM_ADM2_POS))
#define USART_ADM_ADM3                  ((uint32_t)1<<(USART_ADM_ADM3_POS))
#define USART_ADM_ADM4                  ((uint32_t)1<<(USART_ADM_ADM4_POS))
#define USART_ADM_ADM5                  ((uint32_t)1<<(USART_ADM_ADM5_POS))
#define USART_ADM_ADM6                  ((uint32_t)1<<(USART_ADM_ADM6_POS))
#define USART_ADM_ADM7                  ((uint32_t)1<<(USART_ADM_ADM7_POS))
/* ͨȫ/˫շ (USART) */

#endif

#if 1										/* SPI */

/* ----------------------------------------------------------------------------
   -- ӿ (SPI)
   ---------------------------------------------------------------------------- */

/* SPI - Ĵڴṹ */
typedef struct SPI_MemMap
{
    volatile uint32_t BRGR;             /* SPIƼĴ, ƫ:0x00 */
    volatile uint32_t CTLR;             /* SPIʼĴ, ƫ:0x04 */
    volatile uint32_t BUFR;             /* SPIݼĴ, ƫ:0x08 */
    volatile uint32_t STR;              /* SPI״̬Ĵ, ƫ:0x0C */
}SPI_SFRmap;

/* ----------------------------------------------------------------------------
   -- SPI - Ĵں
   ---------------------------------------------------------------------------- */

/* SPI - Ĵڵַ */
#define SPI0_ADDR                       ((uint32_t)0x40000C00)
#define SPI1_ADDR                       ((uint32_t)0x40000C80)
#define SPI2_ADDR                       ((uint32_t)0x40002080)
#define SPI3_ADDR                       ((uint32_t)0x40002100)
#define SPI0_SFR                        ((SPI_SFRmap *) SPI0_ADDR)
#define SPI1_SFR                        ((SPI_SFRmap *) SPI1_ADDR)
#define SPI2_SFR                        ((SPI_SFRmap *) SPI2_ADDR)
#define SPI3_SFR                        ((SPI_SFRmap *) SPI3_ADDR)

/* SPI - Ĵ */
#define SPI0_BRGR                       (SPI0_SFR->BRGR)
#define SPI0_CTLR                       (SPI0_SFR->CTLR)
#define SPI0_BUFR                       (SPI0_SFR->BUFR)
#define SPI0_STR                        (SPI0_SFR->STR)
#define SPI1_BRGR                       (SPI1_SFR->BRGR)
#define SPI1_CTLR                       (SPI1_SFR->CTLR)
#define SPI1_BUFR                       (SPI1_SFR->BUFR)
#define SPI1_STR                        (SPI1_SFR->STR)
#define SPI2_BRGR                       (SPI2_SFR->BRGR)
#define SPI2_CTLR                       (SPI2_SFR->CTLR)
#define SPI2_BUFR                       (SPI2_SFR->BUFR)
#define SPI2_STR                        (SPI2_SFR->STR)
#define SPI3_BRGR                       (SPI3_SFR->BRGR)
#define SPI3_CTLR                       (SPI3_SFR->CTLR)
#define SPI3_BUFR                       (SPI3_SFR->BUFR)
#define SPI3_STR                        (SPI3_SFR->STR)

/* SPI_BRGR λ */
#define SPI_BRGR_SPIBRG0_POS            (0)
#define SPI_BRGR_I2SDIV0_POS            (16)
#define SPI_BRGR_MCKEN_POS              (24)
#define SPI_BRGR_I2SODD_POS             (25)
#define SPI_BRGR_SPIBRG                 ((uint32_t)0xFFFF<<(SPI_BRGR_SPIBRG0_POS))
#define SPI_BRGR_I2SDIV                 ((uint32_t)0xFF<<(SPI_BRGR_I2SDIV0_POS))
#define SPI_BRGR_MCKEN                  ((uint32_t)1<<(SPI_BRGR_MCKEN_POS))
#define SPI_BRGR_I2SODD                 ((uint32_t)1<<(SPI_BRGR_I2SODD_POS))

/* SPI_CTLR λ */
#define SPI_CTLR_SPIEN_POS              (0)
#define SPI_CTLR_SPIMS0_POS             (1)
#define SPI_CTLR_SPIMS1_POS             (2)
#define SPI_CTLR_SPIMS2_POS             (3)
#define SPI_CTLR_SPICKS0_POS            (4)
#define SPI_CTLR_SPICKS1_POS            (5)
#define SPI_CTLR_SPIDS_POS              (6)
#define SPI_CTLR_SPIIOS_POS             (7)
#define SPI_CTLR_SPICKP_POS             (8)
#define SPI_CTLR_SPICKE_POS             (9)
#define SPI_CTLR_SPIBS0_POS             (12)
#define SPI_CTLR_SPIBS1_POS             (13)
#define SPI_CTLR_SSEL0_POS              (14)
#define SPI_CTLR_SSEL1_POS              (15)
#define SPI_CTLR_I2SMOD_POS             (16)
#define SPI_CTLR_SMINS_POS				(17)
#define SPI_CTLR_MCKOS_POS				(18)
#define SPI_CTLR_I2SMC0_POS             (20)
#define SPI_CTLR_I2SMC1_POS             (21)
#define SPI_CTLR_I2SSS0_POS             (22)
#define SPI_CTLR_I2SSS1_POS             (23)
#define SPI_CTLR_PCMS_POS               (24)
#define SPI_CTLR_I2SCKS0_POS            (25)
#define SPI_CTLR_I2SCKS1_POS            (26)
#define SPI_CTLR_PCMCKP_POS             (27)
#define SPI_CTLR_SPIEN                  ((uint32_t)1<<(SPI_CTLR_SPIEN_POS))
#define SPI_CTLR_SPIMS                  ((uint32_t)7<<(SPI_CTLR_SPIMS0_POS))
#define SPI_CTLR_SPIMS0                 ((uint32_t)1<<(SPI_CTLR_SPIMS0_POS))
#define SPI_CTLR_SPIMS1                 ((uint32_t)1<<(SPI_CTLR_SPIMS1_POS))
#define SPI_CTLR_SPIMS2                 ((uint32_t)1<<(SPI_CTLR_SPIMS2_POS))
#define SPI_CTLR_SPICKS                 ((uint32_t)3<<(SPI_CTLR_SPICKS0_POS))
#define SPI_CTLR_SPICKS0                ((uint32_t)1<<(SPI_CTLR_SPICKS0_POS))
#define SPI_CTLR_SPICKS1                ((uint32_t)1<<(SPI_CTLR_SPICKS1_POS))
#define SPI_CTLR_SPIDS                  ((uint32_t)1<<(SPI_CTLR_SPIDS_POS))
#define SPI_CTLR_SPIIOS                 ((uint32_t)1<<(SPI_CTLR_SPIIOS_POS))
#define SPI_CTLR_SPICKP                 ((uint32_t)1<<(SPI_CTLR_SPICKP_POS))
#define SPI_CTLR_SPICKE                 ((uint32_t)1<<(SPI_CTLR_SPICKE_POS))
#define SPI_CTLR_SPIBS                  ((uint32_t)3<<(SPI_CTLR_SPIBS0_POS))
#define SPI_CTLR_SPIBS0                 ((uint32_t)1<<(SPI_CTLR_SPIBS0_POS))
#define SPI_CTLR_SPIBS1                 ((uint32_t)1<<(SPI_CTLR_SPIBS1_POS))
#define SPI_CTLR_SSEL0                  ((uint32_t)1<<(SPI_CTLR_SSEL0_POS))
#define SPI_CTLR_SSEL1                  ((uint32_t)1<<(SPI_CTLR_SSEL1_POS))
#define SPI_CTLR_SSEL                   ((uint32_t)3<<(SPI_CTLR_SSEL0_POS))
#define SPI_CTLR_I2SMOD                 ((uint32_t)1<<(SPI_CTLR_I2SMOD_POS))
#define SPI_CTLR_SMINS                  ((uint32_t)3<<(SPI_CTLR_SMINS_POS))
#define SPI_CTLR_MCKOS                  ((uint32_t)1<<(SPI_CTLR_MCKOS_POS))
#define SPI_CTLR_I2SMC                  ((uint32_t)3<<(SPI_CTLR_I2SMC0_POS))
#define SPI_CTLR_I2SMC0                 ((uint32_t)1<<(SPI_CTLR_I2SMC0_POS))
#define SPI_CTLR_I2SMC1                 ((uint32_t)1<<(SPI_CTLR_I2SMC1_POS))
#define SPI_CTLR_I2SSS                  ((uint32_t)3<<(SPI_CTLR_I2SSS0_POS))
#define SPI_CTLR_I2SSS0                 ((uint32_t)1<<(SPI_CTLR_I2SSS0_POS))
#define SPI_CTLR_I2SSS1                 ((uint32_t)1<<(SPI_CTLR_I2SSS1_POS))
#define SPI_CTLR_PCMS                   ((uint32_t)1<<(SPI_CTLR_PCMS_POS))
#define SPI_CTLR_I2SCKS                 ((uint32_t)0x3<<(SPI_CTLR_I2SCKS0_POS))
#define SPI_CTLR_I2SCKS0                ((uint32_t)1<<(SPI_CTLR_I2SCKS0_POS))
#define SPI_CTLR_I2SCKS1                ((uint32_t)1<<(SPI_CTLR_I2SCKS1_POS))
#define SPI_CTLR_PCMCKP                 ((uint32_t)1<<(SPI_CTLR_PCMCKP_POS))

/* SPI_BUFR λ*/
#define SPI_BUFR_SPIBUF0_POS            (0)
#define SPI_BUFR_SPIBUF                 ((uint32_t)0xFFFFFFFF<<(SPI_BUFR_SPIBUF0_POS))

/* SPI_STR λ*/
#define SPI_STR_SPIBUSY_POS             (0)
#define SPI_STR_RNE_POS                 (1)
#define SPI_STR_TNE_POS                 (2)
#define SPI_STR_CHSIDE_POS              (3)
#define SPI_STR_ROVFIF_POS              (4)
#define SPI_STR_TOVFIF_POS              (5)
#define SPI_STR_UDRIF_POS               (6)
#define SPI_STR_UDRIE_POS               (11)
#define SPI_STR_ROVFIE_POS              (12)
#define SPI_STR_TOVFIE_POS              (13)
#define SPI_STR_RNEIE_POS               (14)
#define SPI_STR_TNEIE_POS               (15)
#define SPI_STR_ROVFIC_POS              (16)
#define SPI_STR_TOVFIC_POS              (17)
#define SPI_STR_UDRIC_POS               (18)
#define SPI_STR_SRCDE_POS               (20)
#define SPI_STR_STXDE_POS               (21)
#define SPI_STR_SPIBUSY                 ((uint32_t)1<<(SPI_STR_SPIBUSY_POS))
#define SPI_STR_RNE                     ((uint32_t)1<<(SPI_STR_RNE_POS))
#define SPI_STR_TNE                     ((uint32_t)1<<(SPI_STR_TNE_POS))
#define SPI_STR_CHSIDE                  ((uint32_t)1<<(SPI_STR_CHSIDE_POS))
#define SPI_STR_ROVFIF                  ((uint32_t)1<<(SPI_STR_ROVFIF_POS))
#define SPI_STR_TOVFIF                  ((uint32_t)1<<(SPI_STR_TOVFIF_POS))
#define SPI_STR_UDRIF                   ((uint32_t)1<<(SPI_STR_UDRIF_POS))
#define SPI_STR_UDRIE                   ((uint32_t)1<<(SPI_STR_UDRIE_POS))
#define SPI_STR_ROVFIE                  ((uint32_t)1<<(SPI_STR_ROVFIE_POS))
#define SPI_STR_TOVFIE                  ((uint32_t)1<<(SPI_STR_TOVFIE_POS))
#define SPI_STR_RNEIE                   ((uint32_t)1<<(SPI_STR_RNEIE_POS))
#define SPI_STR_TNEIE                   ((uint32_t)1<<(SPI_STR_TNEIE_POS))
#define SPI_STR_ROVFIC                  ((uint32_t)1<<(SPI_STR_ROVFIC_POS))
#define SPI_STR_TOVFIC                  ((uint32_t)1<<(SPI_STR_TOVFIC_POS))
#define SPI_STR_UDRIC                   ((uint32_t)1<<(SPI_STR_UDRIC_POS))
#define SPI_STR_SRCDE                   ((uint32_t)1<<(SPI_STR_SRCDE_POS))
#define SPI_STR_STXDE                   ((uint32_t)1<<(SPI_STR_STXDE_POS))
/* ӿ (SPI) */

#endif

#if 1										/* I2C */

/* ----------------------------------------------------------------------------
   -- ڲɵ·ӿ (I2C)
   ---------------------------------------------------------------------------- */

/* I2C - Ĵڴṹ */
typedef struct I2C_MemMap
{
    volatile uint32_t CTLR;             /* I2CƼĴ, ƫ:0x0 */
    volatile uint32_t SR;               /* I2C״̬Ĵ, ƫ:0x4 */
    volatile uint32_t BUFR;             /* I2CݼĴ, ƫ:0x8 */
    volatile uint32_t ADDR0;            /* I2CַĴ0, ƫ:0xC */
    volatile uint32_t BRGR;             /* I2CʼĴ, ƫ:0x10 */
    volatile uint32_t ADDR1;            /* I2CַĴ1, ƫ:0x14 */
    volatile uint32_t ADDR2;            /* I2CַĴ2, ƫ:0x18 */
    volatile uint32_t ADDR3;            /* I2CַĴ3, ƫ:0x1C */
    volatile uint32_t IER;              /* I2CжʹܼĴ, ƫ:0x20 */
}I2C_SFRmap;

/* ----------------------------------------------------------------------------
   -- I2C - Ĵں
   ---------------------------------------------------------------------------- */

/* I2C - Ĵڵַ */
#define I2C0_ADDR                       ((uint32_t)0x40000D00)
#define I2C1_ADDR                       ((uint32_t)0x40000D80)
#define I2C2_ADDR                       ((uint32_t)0x40000E00)
#define I2C3_ADDR                       ((uint32_t)0x40002380)
#define I2C0_SFR                        ((I2C_SFRmap *) I2C0_ADDR)
#define I2C1_SFR                        ((I2C_SFRmap *) I2C1_ADDR)
#define I2C2_SFR                        ((I2C_SFRmap *) I2C2_ADDR)
#define I2C3_SFR                        ((I2C_SFRmap *) I2C3_ADDR)

/* I2C - Ĵڵַ */
#define I2C0_ADDR                       ((uint32_t)0x40000D00)
#define I2C1_ADDR                       ((uint32_t)0x40000D80)
#define I2C2_ADDR                       ((uint32_t)0x40000E00)
#define I2C3_ADDR                       ((uint32_t)0x40002380)
#define I2C0_SFR                        ((I2C_SFRmap *) I2C0_ADDR)
#define I2C1_SFR                        ((I2C_SFRmap *) I2C1_ADDR)
#define I2C2_SFR                        ((I2C_SFRmap *) I2C2_ADDR)
#define I2C3_SFR                        ((I2C_SFRmap *) I2C3_ADDR)

/* I2C - Ĵ */
#define I2C0_CTLR                       (I2C0_SFR->CTLR)
#define I2C0_SR                         (I2C0_SFR->SR)
#define I2C0_BUFR                       (I2C0_SFR->BUFR)
#define I2C0_ADDR0                      (I2C0_SFR->ADDR0)
#define I2C0_BRGR                       (I2C0_SFR->BRGR)
#define I2C0_ADDR1                      (I2C0_SFR->ADDR1)
#define I2C0_ADDR2                      (I2C0_SFR->ADDR2)
#define I2C0_ADDR3                      (I2C0_SFR->ADDR3)
#define I2C0_IER                        (I2C0_SFR->IER)

#define I2C1_CTLR                       (I2C1_SFR->CTLR)
#define I2C1_SR                         (I2C1_SFR->SR)
#define I2C1_BUFR                       (I2C1_SFR->BUFR)
#define I2C1_ADDR0                      (I2C1_SFR->ADDR0)
#define I2C1_BRGR                       (I2C1_SFR->BRGR)
#define I2C1_ADDR1                      (I2C1_SFR->ADDR1)
#define I2C1_ADDR2                      (I2C1_SFR->ADDR2)
#define I2C1_ADDR3                      (I2C1_SFR->ADDR3)
#define I2C1_IER                        (I2C1_SFR->IER)

#define I2C2_CTLR                       (I2C2_SFR->CTLR)
#define I2C2_SR                         (I2C2_SFR->SR)
#define I2C2_BUFR                       (I2C2_SFR->BUFR)
#define I2C2_ADDR0                      (I2C2_SFR->ADDR0)
#define I2C2_BRGR                       (I2C2_SFR->BRGR)
#define I2C2_ADDR1                      (I2C2_SFR->ADDR1)
#define I2C2_ADDR2                      (I2C2_SFR->ADDR2)
#define I2C2_ADDR3                      (I2C2_SFR->ADDR3)
#define I2C2_IER                        (I2C2_SFR->IER)

#define I2C3_CTLR                       (I2C3_SFR->CTLR)
#define I2C3_SR                         (I2C3_SFR->SR)
#define I2C3_BUFR                       (I2C3_SFR->BUFR)
#define I2C3_ADDR0                      (I2C3_SFR->ADDR0)
#define I2C3_BRGR                       (I2C3_SFR->BRGR)
#define I2C3_ADDR1                      (I2C3_SFR->ADDR1)
#define I2C3_ADDR2                      (I2C3_SFR->ADDR2)
#define I2C3_ADDR3                      (I2C3_SFR->ADDR3)
#define I2C3_IER                        (I2C3_SFR->IER)

/* I2C_CTLR λ */
#define I2C_CTLR_I2CEN_POS              (0)
#define I2C_CTLR_BADR10_POS             (1)
#define I2C_CTLR_DHCNT0_POS             (2)
#define I2C_CTLR_DHCNT1_POS             (3)
#define I2C_CTLR_DHCNT2_POS             (4)
#define I2C_CTLR_DHCNT3_POS             (5)
#define I2C_CTLR_SEN_POS                (8)
#define I2C_CTLR_PEN_POS                (10)
#define I2C_CTLR_ACKEN_POS              (12)
#define I2C_CTLR_ACKDT_POS              (13)
#define I2C_CTLR_GCEM_POS               (14)
#define I2C_CTLR_I2CCKS0_POS            (16)
#define I2C_CTLR_I2CCKS1_POS            (17)
#define I2C_CTLR_I2CCKDIV0_POS			(18)
#define I2C_CTLR_I2CCKDIV1_POS			(19)
#define I2C_CTLR_MTHALL_POS             (20)
#define I2C_CTLR_ENASCL_POS             (21)
#define I2C_CTLR_NMENA_POS              (22)
#define I2C_CTLR_SMBUS_POS              (24)
#define I2C_CTLR_SMBT_POS               (25)
#define I2C_CTLR_ARPEN_POS              (26)
#define I2C_CTLR_ALERT_POS              (27)
#define I2C_CTLR_ADRL_POS               (31)
#define I2C_CTLR_I2CEN                  ((uint32_t)1<<(I2C_CTLR_I2CEN_POS))
#define I2C_CTLR_BADR10                 ((uint32_t)1<<(I2C_CTLR_BADR10_POS))
#define I2C_CTLR_DHCNT                  ((uint32_t)0x0F<<(I2C_CTLR_DHCNT0_POS))
#define I2C_CTLR_DHCNT0                 ((uint32_t)1<<(I2C_CTLR_DHCNT0_POS))
#define I2C_CTLR_DHCNT1                 ((uint32_t)1<<(I2C_CTLR_DHCNT1_POS))
#define I2C_CTLR_DHCNT2                 ((uint32_t)1<<(I2C_CTLR_DHCNT2_POS))
#define I2C_CTLR_DHCNT3                 ((uint32_t)1<<(I2C_CTLR_DHCNT3_POS))
#define I2C_CTLR_SEN                    ((uint32_t)1<<(I2C_CTLR_SEN_POS))
#define I2C_CTLR_PEN                    ((uint32_t)1<<(I2C_CTLR_PEN_POS))
#define I2C_CTLR_ACKEN                  ((uint32_t)1<<(I2C_CTLR_ACKEN_POS))
#define I2C_CTLR_ACKDT                  ((uint32_t)1<<(I2C_CTLR_ACKDT_POS))
#define I2C_CTLR_GCEM                   ((uint32_t)1<<(I2C_CTLR_GCEM_POS))
#define I2C_CTLR_I2CCKS                 ((uint32_t)3<<(I2C_CTLR_I2CCKS0_POS))
#define I2C_CTLR_I2CCKS0                ((uint32_t)1<<(I2C_CTLR_I2CCKS0_POS))
#define I2C_CTLR_I2CCKS1                ((uint32_t)1<<(I2C_CTLR_I2CCKS1_POS))
#define I2C_CTLR_I2CCKDIV 		    	((uint32_t)3<<(I2C_CTLR_I2CCKDIV0_POS))
#define I2C_CTLR_I2CCKDIV0 		    	((uint32_t)1<<(I2C_CTLR_I2CCKDIV0_POS))
#define I2C_CTLR_I2CCKDIV1  			((uint32_t)1<<(I2C_CTLR_I2CCKDIV1_POS))
#define I2C_CTLR_MTHALL                 ((uint32_t)1<<(I2C_CTLR_MTHALL_POS))
#define I2C_CTLR_ENASCL                 ((uint32_t)1<<(I2C_CTLR_ENASCL_POS))
#define I2C_CTLR_NMENA                  ((uint32_t)1<<(I2C_CTLR_NMENA_POS))
#define I2C_CTLR_SMBUS                  ((uint32_t)1<<(I2C_CTLR_SMBUS_POS))
#define I2C_CTLR_SMBT                   ((uint32_t)1<<(I2C_CTLR_SMBT_POS))
#define I2C_CTLR_ARPEN                  ((uint32_t)1<<(I2C_CTLR_ARPEN_POS))
#define I2C_CTLR_ALERT                  ((uint32_t)1<<(I2C_CTLR_ALERT_POS))
#define I2C_CTLR_ADRL                   ((uint32_t)1<<(I2C_CTLR_ADRL_POS))

/* I2C_SR λ*/
#define I2C_SR_SIF_POS                  (0)
#define I2C_SR_PIF_POS                  (1)
#define I2C_SR_ADDR_POS                 (2)
#define I2C_SR_ADD10_POS                (3)
#define I2C_SR_DATA_POS                 (4)
#define I2C_SR_AFIF_POS                 (5)
#define I2C_SR_ARBLIF_POS               (6)
#define I2C_SR_RNW_POS                  (7)
#define I2C_SR_SMBAIF_POS               (8)
#define I2C_SR_SMBHIF_POS               (9)
#define I2C_SR_SMBDIF_POS               (10)
#define I2C_SR_ISIF_POS                 (11)
#define I2C_SR_RCBF_POS                 (12)
#define I2C_SR_TXBE_POS                 (13)
#define I2C_SR_IRCDF_POS                (16)
#define I2C_SR_ITXDF_POS                (17)
#define I2C_SR_BERRIF_POS               (18)
#define I2C_SR_SIF                      ((uint32_t)1<<(I2C_SR_SIF_POS))
#define I2C_SR_PIF                      ((uint32_t)1<<(I2C_SR_PIF_POS))
#define I2C_SR_ADDR                     ((uint32_t)1<<(I2C_SR_ADDR_POS))
#define I2C_SR_ADD10                    ((uint32_t)1<<(I2C_SR_ADD10_POS))
#define I2C_SR_DATA                     ((uint32_t)1<<(I2C_SR_DATA_POS))
#define I2C_SR_AFIF                     ((uint32_t)1<<(I2C_SR_AFIF_POS))
#define I2C_SR_ARBLIF                   ((uint32_t)1<<(I2C_SR_ARBLIF_POS))
#define I2C_SR_RNW                      ((uint32_t)1<<(I2C_SR_RNW_POS))
#define I2C_SR_SMBAIF                   ((uint32_t)1<<(I2C_SR_SMBAIF_POS))
#define I2C_SR_SMBHIF                   ((uint32_t)1<<(I2C_SR_SMBHIF_POS))
#define I2C_SR_SMBDIF                   ((uint32_t)1<<(I2C_SR_SMBDIF_POS))
#define I2C_SR_ISIF                     ((uint32_t)1<<(I2C_SR_ISIF_POS))
#define I2C_SR_RCBF                     ((uint32_t)1<<(I2C_SR_RCBF_POS))
#define I2C_SR_TXBE                     ((uint32_t)1<<(I2C_SR_TXBE_POS))
#define I2C_SR_IRCDF                    ((uint32_t)1<<(I2C_SR_IRCDF_POS))
#define I2C_SR_ITXDF                    ((uint32_t)1<<(I2C_SR_ITXDF_POS))
#define I2C_SR_BERRIF                   ((uint32_t)1<<(I2C_SR_BERRIF_POS))

/* I2C_BUFR λ*/
#define I2C_BUFR_I2CBUF0_POS            (0)
#define I2C_BUFR_I2CBUF                 ((uint32_t)0x3FF<<(I2C_BUFR_I2CBUF0_POS))

/* I2C_ADDR λ*/
#define I2C_ADDR_I2CADD0_POS            (0)
#define I2C_ADDR_I2CADD1_POS            (1)
#define I2C_ADDR_I2CADD2_POS            (2)
#define I2C_ADDR_I2CADD3_POS            (3)
#define I2C_ADDR_I2CADD4_POS            (4)
#define I2C_ADDR_I2CADD5_POS            (5)
#define I2C_ADDR_I2CADD6_POS            (6)
#define I2C_ADDR_I2CADD7_POS            (7)
#define I2C_ADDR_I2CADD8_POS            (8)
#define I2C_ADDR_I2CADD9_POS            (9)
#define I2C_ADDR_I2CMSK0_POS            (16)
#define I2C_ADDR_I2CMSK1_POS            (17)
#define I2C_ADDR_I2CMSK2_POS            (18)
#define I2C_ADDR_I2CMSK3_POS            (19)
#define I2C_ADDR_I2CMSK4_POS            (20)
#define I2C_ADDR_I2CMSK5_POS            (21)
#define I2C_ADDR_I2CMSK6_POS            (22)
#define I2C_ADDR_I2CMSK7_POS            (23)
#define I2C_ADDR_I2CMSK8_POS            (24)
#define I2C_ADDR_I2CMSK9_POS            (25)
#define I2C_ADDR_I2CADD                 ((uint32_t)0x3FF<<(I2C_ADDR_I2CADD0_POS))
#define I2C_ADDR_I2CADD0                ((uint32_t)1<<(I2C_ADDR_I2CADD0_POS))
#define I2C_ADDR_I2CADD1                ((uint32_t)1<<(I2C_ADDR_I2CADD1_POS))
#define I2C_ADDR_I2CADD2                ((uint32_t)1<<(I2C_ADDR_I2CADD2_POS))
#define I2C_ADDR_I2CADD3                ((uint32_t)1<<(I2C_ADDR_I2CADD3_POS))
#define I2C_ADDR_I2CADD4                ((uint32_t)1<<(I2C_ADDR_I2CADD4_POS))
#define I2C_ADDR_I2CADD5                ((uint32_t)1<<(I2C_ADDR_I2CADD5_POS))
#define I2C_ADDR_I2CADD6                ((uint32_t)1<<(I2C_ADDR_I2CADD6_POS))
#define I2C_ADDR_I2CADD7                ((uint32_t)1<<(I2C_ADDR_I2CADD7_POS))
#define I2C_ADDR_I2CADD8                ((uint32_t)1<<(I2C_ADDR_I2CADD8_POS))
#define I2C_ADDR_I2CADD9                ((uint32_t)1<<(I2C_ADDR_I2CADD9_POS))
#define I2C_ADDR_I2CMSK                 ((uint32_t)0x3FF<<(I2C_ADDR_I2CMSK0_POS))
#define I2C_ADDR_I2CMSK0                ((uint32_t)1<<(I2C_ADDR_I2CMSK0_POS))
#define I2C_ADDR_I2CMSK1                ((uint32_t)1<<(I2C_ADDR_I2CMSK1_POS))
#define I2C_ADDR_I2CMSK2                ((uint32_t)1<<(I2C_ADDR_I2CMSK2_POS))
#define I2C_ADDR_I2CMSK3                ((uint32_t)1<<(I2C_ADDR_I2CMSK3_POS))
#define I2C_ADDR_I2CMSK4                ((uint32_t)1<<(I2C_ADDR_I2CMSK4_POS))
#define I2C_ADDR_I2CMSK5                ((uint32_t)1<<(I2C_ADDR_I2CMSK5_POS))
#define I2C_ADDR_I2CMSK6                ((uint32_t)1<<(I2C_ADDR_I2CMSK6_POS))
#define I2C_ADDR_I2CMSK7                ((uint32_t)1<<(I2C_ADDR_I2CMSK7_POS))
#define I2C_ADDR_I2CMSK8                ((uint32_t)1<<(I2C_ADDR_I2CMSK8_POS))
#define I2C_ADDR_I2CMSK9                ((uint32_t)1<<(I2C_ADDR_I2CMSK9_POS))

/* I2C_BRGR λ*/
#define I2C_BRGR_I2CBRGH0_POS           (0)
#define I2C_BRGR_I2CBRGL0_POS           (16)
#define I2C_BRGR_I2CBRGH                ((uint32_t)0xFFFF<<(I2C_BRGR_I2CBRGH0_POS))
#define I2C_BRGR_I2CBRGL                ((uint32_t)0xFFFF<<(I2C_BRGR_I2CBRGL0_POS))

/* I2C_IER  λ*/
#define I2C_IER_SIE_POS                 (0)
#define I2C_IER_PIE_POS                 (1)
#define I2C_IER_AFIE_POS                (5)
#define I2C_IER_ARBLIE_POS              (6)
#define I2C_IER_SMBAIE_POS              (8)
#define I2C_IER_SMBHIE_POS              (9)
#define I2C_IER_SMBDIE_POS              (10)
#define I2C_IER_ISIE_POS                (11)
#define I2C_IER_IRCDE_POS               (16)
#define I2C_IER_ITXDE_POS               (17)
#define I2C_IER_BERRIE_POS              (18)
#define I2C_IER_SIE                     ((uint32_t)1<<(I2C_IER_SIE_POS))
#define I2C_IER_PIE                     ((uint32_t)1<<(I2C_IER_PIE_POS))
#define I2C_IER_AFIE                    ((uint32_t)1<<(I2C_IER_AFIE_POS))
#define I2C_IER_ARBLIE                  ((uint32_t)1<<(I2C_IER_ARBLIE_POS))
#define I2C_IER_SMBAIE                  ((uint32_t)1<<(I2C_IER_SMBAIE_POS))
#define I2C_IER_SMBHIE                  ((uint32_t)1<<(I2C_IER_SMBHIE_POS))
#define I2C_IER_SMBDIE                  ((uint32_t)1<<(I2C_IER_SMBDIE_POS))
#define I2C_IER_ISIE                    ((uint32_t)1<<(I2C_IER_ISIE_POS))
#define I2C_IER_IRCDE                   ((uint32_t)1<<(I2C_IER_IRCDE_POS))
#define I2C_IER_ITXDE                   ((uint32_t)1<<(I2C_IER_ITXDE_POS))
#define I2C_IER_BERRIE                  ((uint32_t)1<<(I2C_IER_BERRIE_POS))
/* ڲɵ·ӿ (I2C) */

#endif

#if 1										/* CAN */

/* ----------------------------------------------------------------------------
   --  (CAN)
   ---------------------------------------------------------------------------- */

/* CAN - Ĵڴṹ */
typedef struct CAN_MemMap
{
    volatile       uint32_t CTLR;       /* CANƼĴ, ƫ:0x0 */
    volatile       uint32_t BRGR;       /* CANʼĴ, ƫ:0x4 */
    volatile const uint32_t RCR;        /* CAN¼Ĵ, ƫ:0x8 */
    volatile       uint32_t EROR;       /* CANĴ, ƫ:0xC */
    volatile       uint32_t ACRR;       /* CANմĴ, ƫ:0x10 */
    volatile       uint32_t MSKR;       /* CANμĴ, ƫ:0x14 */
    volatile       uint32_t IER;        /* CANжʹܼĴ, ƫ:0x18 */
    volatile       uint32_t IFR;        /* CANжϱ־Ĵ, ƫ:0x1C */
    volatile       uint32_t INFR;       /* CANϢĴ, ƫ:0x20 */
    volatile       uint32_t TX0R;       /* CANݼĴ0, ƫ:0x24 */
    volatile       uint32_t TX1R;       /* CANݼĴ1, ƫ:0x28 */
    volatile       uint32_t TX2R;       /* CANݼĴ2, ƫ:0x2C */
    volatile const uint32_t RXDATA0;	/* CANݽջĴ0ƫ:0x30*/
    volatile const uint32_t RXDATA1;	/* CANݽջĴ1ƫ:0x34*/
    volatile const uint32_t RXDATA2;	/* CANݽջĴ2ƫ:0x38*/
    volatile const uint32_t RXDATA3;	/* CANݽջĴ3ƫ:0x3C*/
}CAN_SFRmap;

typedef struct CAN_FILTER_Map
{
    volatile       uint32_t ACR1R;       /* CANմĴ1, ƫ:0x00 */
    volatile       uint32_t MSK1R;       /* CANμĴ1, ƫ:0x04 */
    volatile       uint32_t ACR2R;       /* CANմĴ2, ƫ:0x08 */
    volatile       uint32_t MSK2R;       /* CANμĴ2, ƫ:0x0C */
    volatile       uint32_t ACR3R;       /* CANմĴ3, ƫ:0x10 */
    volatile       uint32_t MSK3R;       /* CANμĴ3, ƫ:0x14 */
    volatile       uint32_t ACR4R;       /* CANմĴ4, ƫ:0x18 */
    volatile       uint32_t MSK4R;       /* CANμĴ4, ƫ:0x1C */
    volatile       uint32_t ACR5R;       /* CANմĴ5, ƫ:0x20 */
    volatile       uint32_t MSK5R;       /* CANμĴ5, ƫ:0x24 */
    volatile       uint32_t ACR6R;       /* CANմĴ6, ƫ:0x28 */
    volatile       uint32_t MSK6R;       /* CANμĴ6, ƫ:0x2C */
    volatile       uint32_t ACR7R;       /* CANմĴ7, ƫ:0x30 */
    volatile       uint32_t MSK7R;       /* CANμĴ7, ƫ:0x34 */
    volatile       uint32_t ACR8R;       /* CANմĴ8, ƫ:0x38 */
    volatile       uint32_t MSK8R;       /* CANμĴ8, ƫ:0x3C */
}CAN_FILTER_SFRmap;

/* ----------------------------------------------------------------------------
   -- CAN - Ĵں
   ---------------------------------------------------------------------------- */

/* CAN - Ĵڵַ */
#define CAN4_ADDR                       ((uint32_t)0x40002880)
#define CAN4_SFR                        ((CAN_SFRmap *) CAN4_ADDR)
#define CAN4_FILTER_ADDR                ((uint32_t)0x40002900)
#define CAN4_FILTER_SFR                 ((CAN_FILTER_SFRmap *) CAN4_FILTER_ADDR)

/* CAN - Ĵ */
#define CAN4_CTLR                       (CAN4_SFR->CTLR)
#define CAN4_BRGR                       (CAN4_SFR->BRGR)
#define CAN4_RCR                        (CAN4_SFR->RCR)
#define CAN4_EROR                       (CAN4_SFR->EROR)
#define CAN4_ACRR                       (CAN4_SFR->ACRR)
#define CAN4_MSKR                       (CAN4_SFR->MSKR)
#define CAN4_IER                        (CAN4_SFR->IER)
#define CAN4_IFR                        (CAN4_SFR->IFR)
#define CAN4_INFR                       (CAN4_SFR->INFR)
#define CAN4_TX0R                       (CAN4_SFR->TX0R)
#define CAN4_TX1R                       (CAN4_SFR->TX1R)
#define CAN4_TX2R                       (CAN4_SFR->TX2R)
#define CAN4_RXDATA0					(CAN4_SFR->RXDATA0)
#define CAN4_RXDATA1					(CAN4_SFR->RXDATA1)
#define CAN4_RXDATA2					(CAN4_SFR->RXDATA2)
#define CAN4_RXDATA3					(CAN4_SFR->RXDATA3)
#define CAN4_ACR1R                      (CAN4_FILTER_SFR->ACR1R)
#define CAN4_MSK1R                      (CAN4_FILTER_SFR->MSK1R)
#define CAN4_ACR2R                      (CAN4_FILTER_SFR->ACR2R)
#define CAN4_MSK2R                      (CAN4_FILTER_SFR->MSK2R)
#define CAN4_ACR3R                      (CAN4_FILTER_SFR->ACR3R)
#define CAN4_MSK3R                      (CAN4_FILTER_SFR->MSK3R)
#define CAN4_ACR4R                      (CAN4_FILTER_SFR->ACR4R)
#define CAN4_MSK4R                      (CAN4_FILTER_SFR->MSK4R)
#define CAN4_ACR5R                      (CAN4_FILTER_SFR->ACR5R)
#define CAN4_MSK5R                      (CAN4_FILTER_SFR->MSK5R)
#define CAN4_ACR6R                      (CAN4_FILTER_SFR->ACR6R)
#define CAN4_MSK6R                      (CAN4_FILTER_SFR->MSK6R)
#define CAN4_ACR7R                      (CAN4_FILTER_SFR->ACR7R)
#define CAN4_MSK7R                      (CAN4_FILTER_SFR->MSK7R)
#define CAN4_ACR8R                      (CAN4_FILTER_SFR->ACR8R)
#define CAN4_MSK8R                      (CAN4_FILTER_SFR->MSK8R)

/* CAN_CTLR λ */
#define CAN_CTLR_RSMOD_POS              (0)
#define CAN_CTLR_SILENT_POS             (1)
#define CAN_CTLR_LBACK_POS              (2)
#define CAN_CTLR_SLEEP_POS              (3)
#define CAN_CTLR_FILTEREXT_POS			(4)
#define CAN_CTLR_CANCKS0_POS            (5)
#define CAN_CTLR_CANCKS1_POS            (6)
#define CAN_CTLR_CANEN_POS              (7)
#define CAN_CTLR_TXR_POS                (8)
#define CAN_CTLR_ATX_POS                (9)
#define CAN_CTLR_RELRX_POS              (10)
#define CAN_CTLR_RELF_POS               (11)
#define CAN_CTLR_LBSEL_POS              (12)
#define CAN_CTLR_BOFFREC_POS            (13)
#define CAN_CTLR_CKMODE_POS             (14)
#define CAN_CTLR_RELRXALL_POS           (15)
#define CAN_CTLR_RXBSTA_POS             (16)
#define CAN_CTLR_DOSTA_POS              (17)
#define CAN_CTLR_TXBSTA_POS             (18)
#define CAN_CTLR_TCSTA_POS              (19)
#define CAN_CTLR_RXSTA_POS              (20)
#define CAN_CTLR_TXSTA_POS              (21)
#define CAN_CTLR_CERROR_POS             (22)
#define CAN_CTLR_BOFF_POS               (23)
#define CAN_CTLR_CANRMC0_POS            (24)
#define CAN_CTLR_CANRMC1_POS            (25)
#define CAN_CTLR_CANRMC2_POS            (26)
#define CAN_CTLR_CANRMC3_POS            (27)
#define CAN_CTLR_CANRMC4_POS            (28)
#define CAN_CTLR_CANRMC5_POS            (29)
#define CAN_CTLR_CANRMC6_POS            (30)
#define CAN_CTLR_RSMOD                  ((uint32_t)1<<(CAN_CTLR_RSMOD_POS))
#define CAN_CTLR_SILENT                 ((uint32_t)1<<(CAN_CTLR_SILENT_POS))
#define CAN_CTLR_LBACK                  ((uint32_t)1<<(CAN_CTLR_LBACK_POS))
#define CAN_CTLR_SLEEP                  ((uint32_t)1<<(CAN_CTLR_SLEEP_POS))
#define CAN_CTLR_FILTEREXT				((uint32_t)1<<(CAN_CTLR_FILTEREXT_POS))
#define CAN_CTLR_CANCKS                 ((uint32_t)3<<(CAN_CTLR_CANCKS0_POS))
#define CAN_CTLR_CANCKS0                ((uint32_t)1<<(CAN_CTLR_CANCKS0_POS))
#define CAN_CTLR_CANCKS1                ((uint32_t)1<<(CAN_CTLR_CANCKS1_POS))
#define CAN_CTLR_CANEN                  ((uint32_t)1<<(CAN_CTLR_CANEN_POS))
#define CAN_CTLR_TXR                    ((uint32_t)1<<(CAN_CTLR_TXR_POS))
#define CAN_CTLR_ATX                    ((uint32_t)1<<(CAN_CTLR_ATX_POS))
#define CAN_CTLR_RELRX                  ((uint32_t)1<<(CAN_CTLR_RELRX_POS))
#define CAN_CTLR_RELF                   ((uint32_t)1<<(CAN_CTLR_RELF_POS))
#define CAN_CTLR_LBSEL                  ((uint32_t)1<<(CAN_CTLR_LBSEL_POS))
#define CAN_CTLR_BOFFREC                ((uint32_t)1<<(CAN_CTLR_BOFFREC_POS))
#define CAN_CTLR_CKMODE                 ((uint32_t)1<<(CAN_CTLR_CKMODE_POS))
#define CAN_CTLR_RELRXALL               ((uint32_t)1<<(CAN_CTLR_RELRXALL_POS))
#define CAN_CTLR_RXBSTA                 ((uint32_t)1<<(CAN_CTLR_RXBSTA_POS))
#define CAN_CTLR_DOSTA                  ((uint32_t)1<<(CAN_CTLR_DOSTA_POS))
#define CAN_CTLR_TXBSTA                 ((uint32_t)1<<(CAN_CTLR_TXBSTA_POS))
#define CAN_CTLR_TCSTA                  ((uint32_t)1<<(CAN_CTLR_TCSTA_POS))
#define CAN_CTLR_RXSTA                  ((uint32_t)1<<(CAN_CTLR_RXSTA_POS))
#define CAN_CTLR_TXSTA                  ((uint32_t)1<<(CAN_CTLR_TXSTA_POS))
#define CAN_CTLR_CERROR                 ((uint32_t)1<<(CAN_CTLR_CERROR_POS))
#define CAN_CTLR_BOFF                   ((uint32_t)1<<(CAN_CTLR_BOFF_POS))
#define CAN_CTLR_CANRMC                 ((uint32_t)0x7F<<(CAN_CTLR_CANRMC0_POS))
#define CAN_CTLR_CANRMC0                ((uint32_t)1<<(CAN_CTLR_CANRMC0_POS))
#define CAN_CTLR_CANRMC1                ((uint32_t)1<<(CAN_CTLR_CANRMC1_POS))
#define CAN_CTLR_CANRMC2                ((uint32_t)1<<(CAN_CTLR_CANRMC2_POS))
#define CAN_CTLR_CANRMC3                ((uint32_t)1<<(CAN_CTLR_CANRMC3_POS))
#define CAN_CTLR_CANRMC4                ((uint32_t)1<<(CAN_CTLR_CANRMC4_POS))
#define CAN_CTLR_CANRMC5                ((uint32_t)1<<(CAN_CTLR_CANRMC5_POS))
#define CAN_CTLR_CANRMC6                ((uint32_t)1<<(CAN_CTLR_CANRMC6_POS))

/* CAN_BRGR λ*/
#define CAN_BRGR_CANBRP0_POS            (0)
#define CAN_BRGR_CANBRP1_POS            (1)
#define CAN_BRGR_CANBRP2_POS            (2)
#define CAN_BRGR_CANBRP3_POS            (3)
#define CAN_BRGR_CANBRP4_POS            (4)
#define CAN_BRGR_CANBRP5_POS            (5)
#define CAN_BRGR_SJW0_POS               (6)
#define CAN_BRGR_SJW1_POS               (7)
#define CAN_BRGR_TSEG1_0_POS            (8)
#define CAN_BRGR_TSEG1_1_POS            (9)
#define CAN_BRGR_TSEG1_2_POS            (10)
#define CAN_BRGR_TSEG1_3_POS            (11)
#define CAN_BRGR_TSEG2_0_POS            (12)
#define CAN_BRGR_TSEG2_1_POS            (13)
#define CAN_BRGR_TSEG2_2_POS            (14)
#define CAN_BRGR_SAM_POS                (15)
#define CAN_BRGR_CANBRP                 ((uint32_t)0x3F<<(CAN_BRGR_CANBRP0_POS))
#define CAN_BRGR_CANBRP0                ((uint32_t)1<<(CAN_BRGR_CANBRP0_POS))
#define CAN_BRGR_CANBRP1                ((uint32_t)1<<(CAN_BRGR_CANBRP1_POS))
#define CAN_BRGR_CANBRP2                ((uint32_t)1<<(CAN_BRGR_CANBRP2_POS))
#define CAN_BRGR_CANBRP3                ((uint32_t)1<<(CAN_BRGR_CANBRP3_POS))
#define CAN_BRGR_CANBRP4                ((uint32_t)1<<(CAN_BRGR_CANBRP4_POS))
#define CAN_BRGR_CANBRP5                ((uint32_t)1<<(CAN_BRGR_CANBRP5_POS))
#define CAN_BRGR_SJW                    ((uint32_t)3<<(CAN_BRGR_SJW0_POS))
#define CAN_BRGR_SJW0                   ((uint32_t)1<<(CAN_BRGR_SJW0_POS))
#define CAN_BRGR_SJW1                   ((uint32_t)1<<(CAN_BRGR_SJW1_POS))
#define CAN_BRGR_TSEG1                  ((uint32_t)0xF<<(CAN_BRGR_TSEG1_0_POS))
#define CAN_BRGR_TSEG1_0                ((uint32_t)1<<(CAN_BRGR_TSEG1_0_POS))
#define CAN_BRGR_TSEG1_1                ((uint32_t)1<<(CAN_BRGR_TSEG1_1_POS))
#define CAN_BRGR_TSEG1_2                ((uint32_t)1<<(CAN_BRGR_TSEG1_2_POS))
#define CAN_BRGR_TSEG1_3                ((uint32_t)1<<(CAN_BRGR_TSEG1_3_POS))
#define CAN_BRGR_TSEG2                  ((uint32_t)7<<(CAN_BRGR_TSEG2_0_POS))
#define CAN_BRGR_TSEG2_0                ((uint32_t)1<<(CAN_BRGR_TSEG2_0_POS))
#define CAN_BRGR_TSEG2_1                ((uint32_t)1<<(CAN_BRGR_TSEG2_1_POS))
#define CAN_BRGR_TSEG2_2                ((uint32_t)1<<(CAN_BRGR_TSEG2_2_POS))
#define CAN_BRGR_SAM                    ((uint32_t)1<<(CAN_BRGR_SAM_POS))

/* CAN_RCR λ*/
#define CAN_RCR_CANALC0_POS             (0)
#define CAN_RCR_CANALC1_POS             (1)
#define CAN_RCR_CANALC2_POS             (2)
#define CAN_RCR_CANALC3_POS             (3)
#define CAN_RCR_CANALC4_POS             (4)
#define CAN_RCR_CANSEG0_POS             (8)
#define CAN_RCR_CANSEG1_POS             (9)
#define CAN_RCR_CANSEG2_POS             (10)
#define CAN_RCR_CANSEG3_POS             (11)
#define CAN_RCR_CANSEG4_POS             (12)
#define CAN_RCR_CANDIR_POS              (13)
#define CAN_RCR_CANERRC0_POS            (14)
#define CAN_RCR_CANERRC1_POS            (15)
#define CAN_RCR_RAMMB0_POS				(16)
#define CAN_RCR_RAMMB1_POS				(17)
#define CAN_RCR_RAMMB2_POS				(18)
#define CAN_RCR_RAMMB3_POS				(19)
#define CAN_RCR_RAMMB4_POS				(20)
#define CAN_RCR_RAMMB5_POS				(21)
#define CAN_RCR_CANALC                  ((uint32_t)0x1F<<(CAN_RCR_CANALC0_POS))
#define CAN_RCR_CANALC0                 ((uint32_t)1<<(CAN_RCR_CANALC0_POS))
#define CAN_RCR_CANALC1                 ((uint32_t)1<<(CAN_RCR_CANALC1_POS))
#define CAN_RCR_CANALC2                 ((uint32_t)1<<(CAN_RCR_CANALC2_POS))
#define CAN_RCR_CANALC3                 ((uint32_t)1<<(CAN_RCR_CANALC3_POS))
#define CAN_RCR_CANALC4                 ((uint32_t)1<<(CAN_RCR_CANALC4_POS))
#define CAN_RCR_CANSEG                  ((uint32_t)0x1F<<(CAN_RCR_CANSEG0_POS))
#define CAN_RCR_CANSEG0                 ((uint32_t)1<<(CAN_RCR_CANSEG0_POS))
#define CAN_RCR_CANSEG1                 ((uint32_t)1<<(CAN_RCR_CANSEG1_POS))
#define CAN_RCR_CANSEG2                 ((uint32_t)1<<(CAN_RCR_CANSEG2_POS))
#define CAN_RCR_CANSEG3                 ((uint32_t)1<<(CAN_RCR_CANSEG3_POS))
#define CAN_RCR_CANSEG4                 ((uint32_t)1<<(CAN_RCR_CANSEG4_POS))
#define CAN_RCR_CANDIR                  ((uint32_t)1<<(CAN_RCR_CANDIR_POS))
#define CAN_RCR_CANERRC                 ((uint32_t)3<<(CAN_RCR_CANERRC0_POS))
#define CAN_RCR_CANERRC0                ((uint32_t)1<<(CAN_RCR_CANERRC0_POS))
#define CAN_RCR_CANERRC1                ((uint32_t)1<<(CAN_RCR_CANERRC1_POS))
#define CAN_RCR_RAMMB					((uint32_t)0x3F<<(CAN_RCR_RAMMB0_POS))
#define CAN_RCR_RAMMB0					((uint32_t)1<<(CAN_RCR_RAMMB0_POS))
#define CAN_RCR_RAMMB1					((uint32_t)1<<(CAN_RCR_RAMMB1_POS))
#define CAN_RCR_RAMMB2					((uint32_t)1<<(CAN_RCR_RAMMB2_POS))
#define CAN_RCR_RAMMB3					((uint32_t)1<<(CAN_RCR_RAMMB3_POS))
#define CAN_RCR_RAMMB4					((uint32_t)1<<(CAN_RCR_RAMMB4_POS))
#define CAN_RCR_RAMMB5					((uint32_t)1<<(CAN_RCR_RAMMB5_POS))

/* CAN_EROR λ*/
#define CAN_EROR_CANRXE0_POS            (0)
#define CAN_EROR_CANRXE1_POS            (1)
#define CAN_EROR_CANRXE2_POS            (2)
#define CAN_EROR_CANRXE3_POS            (3)
#define CAN_EROR_CANRXE4_POS            (4)
#define CAN_EROR_CANRXE5_POS            (5)
#define CAN_EROR_CANRXE6_POS            (6)
#define CAN_EROR_CANRXE7_POS            (7)
#define CAN_EROR_CANTXE0_POS            (8)
#define CAN_EROR_CANTXE1_POS            (9)
#define CAN_EROR_CANTXE2_POS            (10)
#define CAN_EROR_CANTXE3_POS            (11)
#define CAN_EROR_CANTXE4_POS            (12)
#define CAN_EROR_CANTXE5_POS            (13)
#define CAN_EROR_CANTXE6_POS            (14)
#define CAN_EROR_CANTXE7_POS            (15)
#define CAN_EROR_CANEWL0_POS            (16)
#define CAN_EROR_CANEWL1_POS            (17)
#define CAN_EROR_CANEWL2_POS            (18)
#define CAN_EROR_CANEWL3_POS            (19)
#define CAN_EROR_CANEWL4_POS            (20)
#define CAN_EROR_CANEWL5_POS            (21)
#define CAN_EROR_CANEWL6_POS            (22)
#define CAN_EROR_CANEWL7_POS            (23)
#define CAN_EROR_CANRXE                 ((uint32_t)0xFF<<(CAN_EROR_CANRXE0_POS))
#define CAN_EROR_CANRXE0                ((uint32_t)1<<(CAN_EROR_CANRXE0_POS))
#define CAN_EROR_CANRXE1                ((uint32_t)1<<(CAN_EROR_CANRXE1_POS))
#define CAN_EROR_CANRXE2                ((uint32_t)1<<(CAN_EROR_CANRXE2_POS))
#define CAN_EROR_CANRXE3                ((uint32_t)1<<(CAN_EROR_CANRXE3_POS))
#define CAN_EROR_CANRXE4                ((uint32_t)1<<(CAN_EROR_CANRXE4_POS))
#define CAN_EROR_CANRXE5                ((uint32_t)1<<(CAN_EROR_CANRXE5_POS))
#define CAN_EROR_CANRXE6                ((uint32_t)1<<(CAN_EROR_CANRXE6_POS))
#define CAN_EROR_CANRXE7                ((uint32_t)1<<(CAN_EROR_CANRXE7_POS))
#define CAN_EROR_CANTXE                 ((uint32_t)0xFF<<(CAN_EROR_CANTXE0_POS))
#define CAN_EROR_CANTXE0                ((uint32_t)1<<(CAN_EROR_CANTXE0_POS))
#define CAN_EROR_CANTXE1                ((uint32_t)1<<(CAN_EROR_CANTXE1_POS))
#define CAN_EROR_CANTXE2                ((uint32_t)1<<(CAN_EROR_CANTXE2_POS))
#define CAN_EROR_CANTXE3                ((uint32_t)1<<(CAN_EROR_CANTXE3_POS))
#define CAN_EROR_CANTXE4                ((uint32_t)1<<(CAN_EROR_CANTXE4_POS))
#define CAN_EROR_CANTXE5                ((uint32_t)1<<(CAN_EROR_CANTXE5_POS))
#define CAN_EROR_CANTXE6                ((uint32_t)1<<(CAN_EROR_CANTXE6_POS))
#define CAN_EROR_CANTXE7                ((uint32_t)1<<(CAN_EROR_CANTXE7_POS))
#define CAN_EROR_CANEWL                 ((uint32_t)0xFF<<(CAN_EROR_CANEWL0_POS))
#define CAN_EROR_CANEWL0                ((uint32_t)1<<(CAN_EROR_CANEWL0_POS))
#define CAN_EROR_CANEWL1                ((uint32_t)1<<(CAN_EROR_CANEWL1_POS))
#define CAN_EROR_CANEWL2                ((uint32_t)1<<(CAN_EROR_CANEWL2_POS))
#define CAN_EROR_CANEWL3                ((uint32_t)1<<(CAN_EROR_CANEWL3_POS))
#define CAN_EROR_CANEWL4                ((uint32_t)1<<(CAN_EROR_CANEWL4_POS))
#define CAN_EROR_CANEWL5                ((uint32_t)1<<(CAN_EROR_CANEWL5_POS))
#define CAN_EROR_CANEWL6                ((uint32_t)1<<(CAN_EROR_CANEWL6_POS))
#define CAN_EROR_CANEWL7                ((uint32_t)1<<(CAN_EROR_CANEWL7_POS))

/* CAN_ACRR λ*/
#define CAN_ACRR_ACR0_POS               (0)
#define CAN_ACRR_ACR1_POS               (1)
#define CAN_ACRR_ACR2_POS               (2)
#define CAN_ACRR_ACR3_POS               (3)
#define CAN_ACRR_ACR4_POS               (4)
#define CAN_ACRR_ACR5_POS               (5)
#define CAN_ACRR_ACR6_POS               (6)
#define CAN_ACRR_ACR7_POS               (7)
#define CAN_ACRR_ACR8_POS               (8)
#define CAN_ACRR_ACR9_POS               (9)
#define CAN_ACRR_ACR10_POS              (10)
#define CAN_ACRR_ACR11_POS              (11)
#define CAN_ACRR_ACR12_POS              (12)
#define CAN_ACRR_ACR13_POS              (13)
#define CAN_ACRR_ACR14_POS              (14)
#define CAN_ACRR_ACR15_POS              (15)
#define CAN_ACRR_ACR16_POS              (16)
#define CAN_ACRR_ACR17_POS              (17)
#define CAN_ACRR_ACR18_POS              (18)
#define CAN_ACRR_ACR19_POS              (19)
#define CAN_ACRR_ACR20_POS              (20)
#define CAN_ACRR_ACR21_POS              (21)
#define CAN_ACRR_ACR22_POS              (22)
#define CAN_ACRR_ACR23_POS              (23)
#define CAN_ACRR_ACR24_POS              (24)
#define CAN_ACRR_ACR25_POS              (25)
#define CAN_ACRR_ACR26_POS              (26)
#define CAN_ACRR_ACR27_POS              (27)
#define CAN_ACRR_ACR28_POS              (28)
#define CAN_ACRR_ACR29_POS              (29)
#define CAN_ACRR_ACR30_POS              (30)
#define CAN_ACRR_ACR31_POS              (31)
#define CAN_ACRR_ACR                    ((uint32_t)0xFFFFFFFF<<(CAN_ACRR_ACR0_POS))
#define CAN_ACRR_ACR0                   ((uint32_t)1<<(CAN_ACRR_ACR0_POS))
#define CAN_ACRR_ACR1                   ((uint32_t)1<<(CAN_ACRR_ACR1_POS))
#define CAN_ACRR_ACR2                   ((uint32_t)1<<(CAN_ACRR_ACR2_POS))
#define CAN_ACRR_ACR3                   ((uint32_t)1<<(CAN_ACRR_ACR3_POS))
#define CAN_ACRR_ACR4                   ((uint32_t)1<<(CAN_ACRR_ACR4_POS))
#define CAN_ACRR_ACR5                   ((uint32_t)1<<(CAN_ACRR_ACR5_POS))
#define CAN_ACRR_ACR6                   ((uint32_t)1<<(CAN_ACRR_ACR6_POS))
#define CAN_ACRR_ACR7                   ((uint32_t)1<<(CAN_ACRR_ACR7_POS))
#define CAN_ACRR_ACR8                   ((uint32_t)1<<(CAN_ACRR_ACR8_POS))
#define CAN_ACRR_ACR9                   ((uint32_t)1<<(CAN_ACRR_ACR9_POS))
#define CAN_ACRR_ACR10                  ((uint32_t)1<<(CAN_ACRR_ACR10_POS))
#define CAN_ACRR_ACR11                  ((uint32_t)1<<(CAN_ACRR_ACR11_POS))
#define CAN_ACRR_ACR12                  ((uint32_t)1<<(CAN_ACRR_ACR12_POS))
#define CAN_ACRR_ACR13                  ((uint32_t)1<<(CAN_ACRR_ACR13_POS))
#define CAN_ACRR_ACR14                  ((uint32_t)1<<(CAN_ACRR_ACR14_POS))
#define CAN_ACRR_ACR15                  ((uint32_t)1<<(CAN_ACRR_ACR15_POS))
#define CAN_ACRR_ACR16                  ((uint32_t)1<<(CAN_ACRR_ACR16_POS))
#define CAN_ACRR_ACR17                  ((uint32_t)1<<(CAN_ACRR_ACR17_POS))
#define CAN_ACRR_ACR18                  ((uint32_t)1<<(CAN_ACRR_ACR18_POS))
#define CAN_ACRR_ACR19                  ((uint32_t)1<<(CAN_ACRR_ACR19_POS))
#define CAN_ACRR_ACR20                  ((uint32_t)1<<(CAN_ACRR_ACR20_POS))
#define CAN_ACRR_ACR21                  ((uint32_t)1<<(CAN_ACRR_ACR21_POS))
#define CAN_ACRR_ACR22                  ((uint32_t)1<<(CAN_ACRR_ACR22_POS))
#define CAN_ACRR_ACR23                  ((uint32_t)1<<(CAN_ACRR_ACR23_POS))
#define CAN_ACRR_ACR24                  ((uint32_t)1<<(CAN_ACRR_ACR24_POS))
#define CAN_ACRR_ACR25                  ((uint32_t)1<<(CAN_ACRR_ACR25_POS))
#define CAN_ACRR_ACR26                  ((uint32_t)1<<(CAN_ACRR_ACR26_POS))
#define CAN_ACRR_ACR27                  ((uint32_t)1<<(CAN_ACRR_ACR27_POS))
#define CAN_ACRR_ACR28                  ((uint32_t)1<<(CAN_ACRR_ACR28_POS))
#define CAN_ACRR_ACR29                  ((uint32_t)1<<(CAN_ACRR_ACR29_POS))
#define CAN_ACRR_ACR30                  ((uint32_t)1<<(CAN_ACRR_ACR30_POS))
#define CAN_ACRR_ACR31                  ((uint32_t)1<<(CAN_ACRR_ACR31_POS))

/* CAN_MSKR  λ*/
#define CAN_MSKR_MSK0_POS               (0)
#define CAN_MSKR_MSK1_POS               (1)
#define CAN_MSKR_MSK2_POS               (2)
#define CAN_MSKR_MSK3_POS               (3)
#define CAN_MSKR_MSK4_POS               (4)
#define CAN_MSKR_MSK5_POS               (5)
#define CAN_MSKR_MSK6_POS               (6)
#define CAN_MSKR_MSK7_POS               (7)
#define CAN_MSKR_MSK8_POS               (8)
#define CAN_MSKR_MSK9_POS               (9)
#define CAN_MSKR_MSK10_POS              (10)
#define CAN_MSKR_MSK11_POS              (11)
#define CAN_MSKR_MSK12_POS              (12)
#define CAN_MSKR_MSK13_POS              (13)
#define CAN_MSKR_MSK14_POS              (14)
#define CAN_MSKR_MSK15_POS              (15)
#define CAN_MSKR_MSK16_POS              (16)
#define CAN_MSKR_MSK17_POS              (17)
#define CAN_MSKR_MSK18_POS              (18)
#define CAN_MSKR_MSK19_POS              (19)
#define CAN_MSKR_MSK20_POS              (20)
#define CAN_MSKR_MSK21_POS              (21)
#define CAN_MSKR_MSK22_POS              (22)
#define CAN_MSKR_MSK23_POS              (23)
#define CAN_MSKR_MSK24_POS              (24)
#define CAN_MSKR_MSK25_POS              (25)
#define CAN_MSKR_MSK26_POS              (26)
#define CAN_MSKR_MSK27_POS              (27)
#define CAN_MSKR_MSK28_POS              (28)
#define CAN_MSKR_MSK29_POS              (29)
#define CAN_MSKR_MSK30_POS              (30)
#define CAN_MSKR_MSK31_POS              (31)
#define CAN_MSKR_MSK                    ((uint32_t)0xFFFFFFFF<<(CAN_MSKR_MSK0_POS))
#define CAN_MSKR_MSK0                   ((uint32_t)1<<(CAN_MSKR_MSK0_POS))
#define CAN_MSKR_MSK1                   ((uint32_t)1<<(CAN_MSKR_MSK1_POS))
#define CAN_MSKR_MSK2                   ((uint32_t)1<<(CAN_MSKR_MSK2_POS))
#define CAN_MSKR_MSK3                   ((uint32_t)1<<(CAN_MSKR_MSK3_POS))
#define CAN_MSKR_MSK4                   ((uint32_t)1<<(CAN_MSKR_MSK4_POS))
#define CAN_MSKR_MSK5                   ((uint32_t)1<<(CAN_MSKR_MSK5_POS))
#define CAN_MSKR_MSK6                   ((uint32_t)1<<(CAN_MSKR_MSK6_POS))
#define CAN_MSKR_MSK7                   ((uint32_t)1<<(CAN_MSKR_MSK7_POS))
#define CAN_MSKR_MSK8                   ((uint32_t)1<<(CAN_MSKR_MSK8_POS))
#define CAN_MSKR_MSK9                   ((uint32_t)1<<(CAN_MSKR_MSK9_POS))
#define CAN_MSKR_MSK10                  ((uint32_t)1<<(CAN_MSKR_MSK10_POS))
#define CAN_MSKR_MSK11                  ((uint32_t)1<<(CAN_MSKR_MSK11_POS))
#define CAN_MSKR_MSK12                  ((uint32_t)1<<(CAN_MSKR_MSK12_POS))
#define CAN_MSKR_MSK13                  ((uint32_t)1<<(CAN_MSKR_MSK13_POS))
#define CAN_MSKR_MSK14                  ((uint32_t)1<<(CAN_MSKR_MSK14_POS))
#define CAN_MSKR_MSK15                  ((uint32_t)1<<(CAN_MSKR_MSK15_POS))
#define CAN_MSKR_MSK16                  ((uint32_t)1<<(CAN_MSKR_MSK16_POS))
#define CAN_MSKR_MSK17                  ((uint32_t)1<<(CAN_MSKR_MSK17_POS))
#define CAN_MSKR_MSK18                  ((uint32_t)1<<(CAN_MSKR_MSK18_POS))
#define CAN_MSKR_MSK19                  ((uint32_t)1<<(CAN_MSKR_MSK19_POS))
#define CAN_MSKR_MSK20                  ((uint32_t)1<<(CAN_MSKR_MSK20_POS))
#define CAN_MSKR_MSK21                  ((uint32_t)1<<(CAN_MSKR_MSK21_POS))
#define CAN_MSKR_MSK22                  ((uint32_t)1<<(CAN_MSKR_MSK22_POS))
#define CAN_MSKR_MSK23                  ((uint32_t)1<<(CAN_MSKR_MSK23_POS))
#define CAN_MSKR_MSK24                  ((uint32_t)1<<(CAN_MSKR_MSK24_POS))
#define CAN_MSKR_MSK25                  ((uint32_t)1<<(CAN_MSKR_MSK25_POS))
#define CAN_MSKR_MSK26                  ((uint32_t)1<<(CAN_MSKR_MSK26_POS))
#define CAN_MSKR_MSK27                  ((uint32_t)1<<(CAN_MSKR_MSK27_POS))
#define CAN_MSKR_MSK28                  ((uint32_t)1<<(CAN_MSKR_MSK28_POS))
#define CAN_MSKR_MSK29                  ((uint32_t)1<<(CAN_MSKR_MSK29_POS))
#define CAN_MSKR_MSK30                  ((uint32_t)1<<(CAN_MSKR_MSK30_POS))
#define CAN_MSKR_MSK31                  ((uint32_t)1<<(CAN_MSKR_MSK31_POS))

/* CAN_INFR  λ*/
#define CAN_INFR_DLC0_POS               (0)
#define CAN_INFR_DLC1_POS               (1)
#define CAN_INFR_DLC2_POS               (2)
#define CAN_INFR_DLC3_POS               (3)
#define CAN_INFR_RTR_POS                (6)
#define CAN_INFR_IDE_POS                (7)
#define CAN_INFR_DLC                    ((uint32_t)0xF<<(CAN_INFR_DLC0_POS))
#define CAN_INFR_DLC0                   ((uint32_t)1<<(CAN_INFR_DLC0_POS))
#define CAN_INFR_DLC1                   ((uint32_t)1<<(CAN_INFR_DLC1_POS))
#define CAN_INFR_DLC2                   ((uint32_t)1<<(CAN_INFR_DLC2_POS))
#define CAN_INFR_DLC3                   ((uint32_t)1<<(CAN_INFR_DLC3_POS))
#define CAN_INFR_RTR                    ((uint32_t)1<<(CAN_INFR_RTR_POS))
#define CAN_INFR_IDE                    ((uint32_t)1<<(CAN_INFR_IDE_POS))

/* CAN_TX0R  λ*/
#define CAN_TX0R_SFF_RTR_POS            (20)
#define CAN_TX0R_EFF_RTR_POS            (2)
#define CAN_TX0R_ID0_POS                (3)
#define CAN_TX0R_ID1_POS                (4)
#define CAN_TX0R_ID2_POS                (5)
#define CAN_TX0R_ID3_POS                (6)
#define CAN_TX0R_ID4_POS                (7)
#define CAN_TX0R_ID5_POS                (8)
#define CAN_TX0R_ID6_POS                (9)
#define CAN_TX0R_ID7_POS                (10)
#define CAN_TX0R_ID8_POS                (11)
#define CAN_TX0R_ID9_POS                (12)
#define CAN_TX0R_ID10_POS               (13)
#define CAN_TX0R_ID11_POS               (14)
#define CAN_TX0R_ID12_POS               (15)
#define CAN_TX0R_ID13_POS               (16)
#define CAN_TX0R_ID14_POS               (17)
#define CAN_TX0R_ID15_POS               (18)
#define CAN_TX0R_ID16_POS               (19)
#define CAN_TX0R_ID17_POS               (20)
#define CAN_TX0R_ID18_POS               (21)
#define CAN_TX0R_ID19_POS               (22)
#define CAN_TX0R_ID20_POS               (23)
#define CAN_TX0R_ID21_POS               (24)
#define CAN_TX0R_ID22_POS               (25)
#define CAN_TX0R_ID23_POS               (26)
#define CAN_TX0R_ID24_POS               (27)
#define CAN_TX0R_ID25_POS               (28)
#define CAN_TX0R_ID26_POS               (29)
#define CAN_TX0R_ID27_POS               (30)
#define CAN_TX0R_ID28_POS               (31)
#define CAN_TX0R_SFF_RTR                ((uint32_t)1<<(CAN_TX0R_SFF_RTR_POS))
#define CAN_TX0R_EFF_RTR                ((uint32_t)1<<(CAN_TX0R_EFF_RTR_POS))
#define CAN_TX0R_SFF_ID                 ((uint32_t)0x7FF<<(CAN_TX0R_ID18_POS))
#define CAN_TX0R_EFF_ID                 ((uint32_t)0x1FFFFFFF<<(CAN_TX0R_ID0_POS))
#define CAN_TX0R_ID1                    ((uint32_t)1<<(CAN_TX0R_ID1_POS))
#define CAN_TX0R_ID2                    ((uint32_t)1<<(CAN_TX0R_ID2_POS))
#define CAN_TX0R_ID3                    ((uint32_t)1<<(CAN_TX0R_ID3_POS))
#define CAN_TX0R_ID4                    ((uint32_t)1<<(CAN_TX0R_ID4_POS))
#define CAN_TX0R_ID5                    ((uint32_t)1<<(CAN_TX0R_ID5_POS))
#define CAN_TX0R_ID6                    ((uint32_t)1<<(CAN_TX0R_ID6_POS))
#define CAN_TX0R_ID7                    ((uint32_t)1<<(CAN_TX0R_ID7_POS))
#define CAN_TX0R_ID8                    ((uint32_t)1<<(CAN_TX0R_ID8_POS))
#define CAN_TX0R_ID9                    ((uint32_t)1<<(CAN_TX0R_ID9_POS))
#define CAN_TX0R_ID10                   ((uint32_t)1<<(CAN_TX0R_ID10_POS))
#define CAN_TX0R_ID11                   ((uint32_t)1<<(CAN_TX0R_ID11_POS))
#define CAN_TX0R_ID12                   ((uint32_t)1<<(CAN_TX0R_ID12_POS))
#define CAN_TX0R_ID13                   ((uint32_t)1<<(CAN_TX0R_ID13_POS))
#define CAN_TX0R_ID14                   ((uint32_t)1<<(CAN_TX0R_ID14_POS))
#define CAN_TX0R_ID15                   ((uint32_t)1<<(CAN_TX0R_ID15_POS))
#define CAN_TX0R_ID16                   ((uint32_t)1<<(CAN_TX0R_ID16_POS))
#define CAN_TX0R_ID17                   ((uint32_t)1<<(CAN_TX0R_ID17_POS))
#define CAN_TX0R_ID18                   ((uint32_t)1<<(CAN_TX0R_ID18_POS))
#define CAN_TX0R_ID19                   ((uint32_t)1<<(CAN_TX0R_ID19_POS))
#define CAN_TX0R_ID20                   ((uint32_t)1<<(CAN_TX0R_ID20_POS))
#define CAN_TX0R_ID21                   ((uint32_t)1<<(CAN_TX0R_ID21_POS))
#define CAN_TX0R_ID22                   ((uint32_t)1<<(CAN_TX0R_ID22_POS))
#define CAN_TX0R_ID23                   ((uint32_t)1<<(CAN_TX0R_ID23_POS))
#define CAN_TX0R_ID24                   ((uint32_t)1<<(CAN_TX0R_ID24_POS))
#define CAN_TX0R_ID25                   ((uint32_t)1<<(CAN_TX0R_ID25_POS))
#define CAN_TX0R_ID26                   ((uint32_t)1<<(CAN_TX0R_ID26_POS))
#define CAN_TX0R_ID27                   ((uint32_t)1<<(CAN_TX0R_ID27_POS))
#define CAN_TX0R_ID28                   ((uint32_t)1<<(CAN_TX0R_ID28_POS))

#define CAN_TX0R_CANTX0_0_POS           (0)
#define CAN_TX0R_CANTX0_1_POS           (1)
#define CAN_TX0R_CANTX0_2_POS           (2)
#define CAN_TX0R_CANTX0_3_POS           (3)
#define CAN_TX0R_CANTX0_4_POS           (4)
#define CAN_TX0R_CANTX0_5_POS           (5)
#define CAN_TX0R_CANTX0_6_POS           (6)
#define CAN_TX0R_CANTX0_7_POS           (7)
#define CAN_TX0R_CANTX0_8_POS           (8)
#define CAN_TX0R_CANTX0_9_POS           (9)
#define CAN_TX0R_CANTX0_10_POS          (10)
#define CAN_TX0R_CANTX0_11_POS          (11)
#define CAN_TX0R_CANTX0_12_POS          (12)
#define CAN_TX0R_CANTX0_13_POS          (13)
#define CAN_TX0R_CANTX0_14_POS          (14)
#define CAN_TX0R_CANTX0_15_POS          (15)
#define CAN_TX0R_CANTX0_16_POS          (16)
#define CAN_TX0R_CANTX0_17_POS          (17)
#define CAN_TX0R_CANTX0_18_POS          (18)
#define CAN_TX0R_CANTX0_19_POS          (19)
#define CAN_TX0R_CANTX0_20_POS          (20)
#define CAN_TX0R_CANTX0_21_POS          (21)
#define CAN_TX0R_CANTX0_22_POS          (22)
#define CAN_TX0R_CANTX0_23_POS          (23)
#define CAN_TX0R_CANTX0_24_POS          (24)
#define CAN_TX0R_CANTX0_25_POS          (25)
#define CAN_TX0R_CANTX0_26_POS          (26)
#define CAN_TX0R_CANTX0_27_POS          (27)
#define CAN_TX0R_CANTX0_28_POS          (28)
#define CAN_TX0R_CANTX0_29_POS          (29)
#define CAN_TX0R_CANTX0_30_POS          (30)
#define CAN_TX0R_CANTX0_31_POS          (31)
#define CAN_TX0R_CANTX0                 ((uint32_t)0xFFFFFFFF<<(CAN_TX0R_CANTX0_0_POS))
#define CAN_TX0R_CANTX0_0               ((uint32_t)1<<(CAN_TX0R_CANTX0_0_POS))
#define CAN_TX0R_CANTX0_1               ((uint32_t)1<<(CAN_TX0R_CANTX0_1_POS))
#define CAN_TX0R_CANTX0_2               ((uint32_t)1<<(CAN_TX0R_CANTX0_2_POS))
#define CAN_TX0R_CANTX0_3               ((uint32_t)1<<(CAN_TX0R_CANTX0_3_POS))
#define CAN_TX0R_CANTX0_4               ((uint32_t)1<<(CAN_TX0R_CANTX0_4_POS))
#define CAN_TX0R_CANTX0_5               ((uint32_t)1<<(CAN_TX0R_CANTX0_5_POS))
#define CAN_TX0R_CANTX0_6               ((uint32_t)1<<(CAN_TX0R_CANTX0_6_POS))
#define CAN_TX0R_CANTX0_7               ((uint32_t)1<<(CAN_TX0R_CANTX0_7_POS))
#define CAN_TX0R_CANTX0_8               ((uint32_t)1<<(CAN_TX0R_CANTX0_8_POS))
#define CAN_TX0R_CANTX0_9               ((uint32_t)1<<(CAN_TX0R_CANTX0_9_POS))
#define CAN_TX0R_CANTX0_10              ((uint32_t)1<<(CAN_TX0R_CANTX0_10_POS))
#define CAN_TX0R_CANTX0_11              ((uint32_t)1<<(CAN_TX0R_CANTX0_11_POS))
#define CAN_TX0R_CANTX0_12              ((uint32_t)1<<(CAN_TX0R_CANTX0_12_POS))
#define CAN_TX0R_CANTX0_13              ((uint32_t)1<<(CAN_TX0R_CANTX0_13_POS))
#define CAN_TX0R_CANTX0_14              ((uint32_t)1<<(CAN_TX0R_CANTX0_14_POS))
#define CAN_TX0R_CANTX0_15              ((uint32_t)1<<(CAN_TX0R_CANTX0_15_POS))
#define CAN_TX0R_CANTX0_16              ((uint32_t)1<<(CAN_TX0R_CANTX0_16_POS))
#define CAN_TX0R_CANTX0_17              ((uint32_t)1<<(CAN_TX0R_CANTX0_17_POS))
#define CAN_TX0R_CANTX0_18              ((uint32_t)1<<(CAN_TX0R_CANTX0_18_POS))
#define CAN_TX0R_CANTX0_19              ((uint32_t)1<<(CAN_TX0R_CANTX0_19_POS))
#define CAN_TX0R_CANTX0_20              ((uint32_t)1<<(CAN_TX0R_CANTX0_20_POS))
#define CAN_TX0R_CANTX0_21              ((uint32_t)1<<(CAN_TX0R_CANTX0_21_POS))
#define CAN_TX0R_CANTX0_22              ((uint32_t)1<<(CAN_TX0R_CANTX0_22_POS))
#define CAN_TX0R_CANTX0_23              ((uint32_t)1<<(CAN_TX0R_CANTX0_23_POS))
#define CAN_TX0R_CANTX0_24              ((uint32_t)1<<(CAN_TX0R_CANTX0_24_POS))
#define CAN_TX0R_CANTX0_25              ((uint32_t)1<<(CAN_TX0R_CANTX0_25_POS))
#define CAN_TX0R_CANTX0_26              ((uint32_t)1<<(CAN_TX0R_CANTX0_26_POS))
#define CAN_TX0R_CANTX0_27              ((uint32_t)1<<(CAN_TX0R_CANTX0_27_POS))
#define CAN_TX0R_CANTX0_28              ((uint32_t)1<<(CAN_TX0R_CANTX0_28_POS))
#define CAN_TX0R_CANTX0_29              ((uint32_t)1<<(CAN_TX0R_CANTX0_29_POS))
#define CAN_TX0R_CANTX0_30              ((uint32_t)1<<(CAN_TX0R_CANTX0_30_POS))
#define CAN_TX0R_CANTX0_31              ((uint32_t)1<<(CAN_TX0R_CANTX0_31_POS))

/* CAN_TX1R  λ*/
#define CAN_TX1R_CANTX1_0_POS           (0)
#define CAN_TX1R_CANTX1_1_POS           (1)
#define CAN_TX1R_CANTX1_2_POS           (2)
#define CAN_TX1R_CANTX1_3_POS           (3)
#define CAN_TX1R_CANTX1_4_POS           (4)
#define CAN_TX1R_CANTX1_5_POS           (5)
#define CAN_TX1R_CANTX1_6_POS           (6)
#define CAN_TX1R_CANTX1_7_POS           (7)
#define CAN_TX1R_CANTX1_8_POS           (8)
#define CAN_TX1R_CANTX1_9_POS           (9)
#define CAN_TX1R_CANTX1_10_POS          (10)
#define CAN_TX1R_CANTX1_11_POS          (11)
#define CAN_TX1R_CANTX1_12_POS          (12)
#define CAN_TX1R_CANTX1_13_POS          (13)
#define CAN_TX1R_CANTX1_14_POS          (14)
#define CAN_TX1R_CANTX1_15_POS          (15)
#define CAN_TX1R_CANTX1_16_POS          (16)
#define CAN_TX1R_CANTX1_17_POS          (17)
#define CAN_TX1R_CANTX1_18_POS          (18)
#define CAN_TX1R_CANTX1_19_POS          (19)
#define CAN_TX1R_CANTX1_20_POS          (20)
#define CAN_TX1R_CANTX1_21_POS          (21)
#define CAN_TX1R_CANTX1_22_POS          (22)
#define CAN_TX1R_CANTX1_23_POS          (23)
#define CAN_TX1R_CANTX1_24_POS          (24)
#define CAN_TX1R_CANTX1_25_POS          (25)
#define CAN_TX1R_CANTX1_26_POS          (26)
#define CAN_TX1R_CANTX1_27_POS          (27)
#define CAN_TX1R_CANTX1_28_POS          (28)
#define CAN_TX1R_CANTX1_29_POS          (29)
#define CAN_TX1R_CANTX1_30_POS          (30)
#define CAN_TX1R_CANTX1_31_POS          (31)
#define CAN_TX1R_CANTX1                 ((uint32_t)0xFFFFFFFF<<(CAN_TX1R_CANTX1_0_POS))
#define CAN_TX1R_CANTX1_0               ((uint32_t)1<<(CAN_TX1R_CANTX1_0_POS))
#define CAN_TX1R_CANTX1_1               ((uint32_t)1<<(CAN_TX1R_CANTX1_1_POS))
#define CAN_TX1R_CANTX1_2               ((uint32_t)1<<(CAN_TX1R_CANTX1_2_POS))
#define CAN_TX1R_CANTX1_3               ((uint32_t)1<<(CAN_TX1R_CANTX1_3_POS))
#define CAN_TX1R_CANTX1_4               ((uint32_t)1<<(CAN_TX1R_CANTX1_4_POS))
#define CAN_TX1R_CANTX1_5               ((uint32_t)1<<(CAN_TX1R_CANTX1_5_POS))
#define CAN_TX1R_CANTX1_6               ((uint32_t)1<<(CAN_TX1R_CANTX1_6_POS))
#define CAN_TX1R_CANTX1_7               ((uint32_t)1<<(CAN_TX1R_CANTX1_7_POS))
#define CAN_TX1R_CANTX1_8               ((uint32_t)1<<(CAN_TX1R_CANTX1_8_POS))
#define CAN_TX1R_CANTX1_9               ((uint32_t)1<<(CAN_TX1R_CANTX1_9_POS))
#define CAN_TX1R_CANTX1_10              ((uint32_t)1<<(CAN_TX1R_CANTX1_10_POS))
#define CAN_TX1R_CANTX1_11              ((uint32_t)1<<(CAN_TX1R_CANTX1_11_POS))
#define CAN_TX1R_CANTX1_12              ((uint32_t)1<<(CAN_TX1R_CANTX1_12_POS))
#define CAN_TX1R_CANTX1_13              ((uint32_t)1<<(CAN_TX1R_CANTX1_13_POS))
#define CAN_TX1R_CANTX1_14              ((uint32_t)1<<(CAN_TX1R_CANTX1_14_POS))
#define CAN_TX1R_CANTX1_15              ((uint32_t)1<<(CAN_TX1R_CANTX1_15_POS))
#define CAN_TX1R_CANTX1_16              ((uint32_t)1<<(CAN_TX1R_CANTX1_16_POS))
#define CAN_TX1R_CANTX1_17              ((uint32_t)1<<(CAN_TX1R_CANTX1_17_POS))
#define CAN_TX1R_CANTX1_18              ((uint32_t)1<<(CAN_TX1R_CANTX1_18_POS))
#define CAN_TX1R_CANTX1_19              ((uint32_t)1<<(CAN_TX1R_CANTX1_19_POS))
#define CAN_TX1R_CANTX1_20              ((uint32_t)1<<(CAN_TX1R_CANTX1_20_POS))
#define CAN_TX1R_CANTX1_21              ((uint32_t)1<<(CAN_TX1R_CANTX1_21_POS))
#define CAN_TX1R_CANTX1_22              ((uint32_t)1<<(CAN_TX1R_CANTX1_22_POS))
#define CAN_TX1R_CANTX1_23              ((uint32_t)1<<(CAN_TX1R_CANTX1_23_POS))
#define CAN_TX1R_CANTX1_24              ((uint32_t)1<<(CAN_TX1R_CANTX1_24_POS))
#define CAN_TX1R_CANTX1_25              ((uint32_t)1<<(CAN_TX1R_CANTX1_25_POS))
#define CAN_TX1R_CANTX1_26              ((uint32_t)1<<(CAN_TX1R_CANTX1_26_POS))
#define CAN_TX1R_CANTX1_27              ((uint32_t)1<<(CAN_TX1R_CANTX1_27_POS))
#define CAN_TX1R_CANTX1_28              ((uint32_t)1<<(CAN_TX1R_CANTX1_28_POS))
#define CAN_TX1R_CANTX1_29              ((uint32_t)1<<(CAN_TX1R_CANTX1_29_POS))
#define CAN_TX1R_CANTX1_30              ((uint32_t)1<<(CAN_TX1R_CANTX1_30_POS))
#define CAN_TX1R_CANTX1_31              ((uint32_t)1<<(CAN_TX1R_CANTX1_31_POS))

/* CAN_TX2R  λ*/
#define CAN_TX2R_CANTX2_0_POS           (0)
#define CAN_TX2R_CANTX2_1_POS           (1)
#define CAN_TX2R_CANTX2_2_POS           (2)
#define CAN_TX2R_CANTX2_3_POS           (3)
#define CAN_TX2R_CANTX2_4_POS           (4)
#define CAN_TX2R_CANTX2_5_POS           (5)
#define CAN_TX2R_CANTX2_6_POS           (6)
#define CAN_TX2R_CANTX2_7_POS           (7)
#define CAN_TX2R_CANTX2_8_POS           (8)
#define CAN_TX2R_CANTX2_9_POS           (9)
#define CAN_TX2R_CANTX2_10_POS          (10)
#define CAN_TX2R_CANTX2_11_POS          (11)
#define CAN_TX2R_CANTX2_12_POS          (12)
#define CAN_TX2R_CANTX2_13_POS          (13)
#define CAN_TX2R_CANTX2_14_POS          (14)
#define CAN_TX2R_CANTX2_15_POS          (15)
#define CAN_TX2R_CANTX2_16_POS          (16)
#define CAN_TX2R_CANTX2_17_POS          (17)
#define CAN_TX2R_CANTX2_18_POS          (18)
#define CAN_TX2R_CANTX2_19_POS          (19)
#define CAN_TX2R_CANTX2_20_POS          (20)
#define CAN_TX2R_CANTX2_21_POS          (21)
#define CAN_TX2R_CANTX2_22_POS          (22)
#define CAN_TX2R_CANTX2_23_POS          (23)
#define CAN_TX2R_CANTX2_24_POS          (24)
#define CAN_TX2R_CANTX2_25_POS          (25)
#define CAN_TX2R_CANTX2_26_POS          (26)
#define CAN_TX2R_CANTX2_27_POS          (27)
#define CAN_TX2R_CANTX2_28_POS          (28)
#define CAN_TX2R_CANTX2_29_POS          (29)
#define CAN_TX2R_CANTX2_30_POS          (30)
#define CAN_TX2R_CANTX2_31_POS          (31)
#define CAN_TX2R_CANTX2                 ((uint32_t)0xFFFFFFFF<<(CAN_TX2R_CANTX2_0_POS))
#define CAN_TX2R_CANTX2_0               ((uint32_t)1<<(CAN_TX2R_CANTX2_0_POS))
#define CAN_TX2R_CANTX2_1               ((uint32_t)1<<(CAN_TX2R_CANTX2_1_POS))
#define CAN_TX2R_CANTX2_2               ((uint32_t)1<<(CAN_TX2R_CANTX2_2_POS))
#define CAN_TX2R_CANTX2_3               ((uint32_t)1<<(CAN_TX2R_CANTX2_3_POS))
#define CAN_TX2R_CANTX2_4               ((uint32_t)1<<(CAN_TX2R_CANTX2_4_POS))
#define CAN_TX2R_CANTX2_5               ((uint32_t)1<<(CAN_TX2R_CANTX2_5_POS))
#define CAN_TX2R_CANTX2_6               ((uint32_t)1<<(CAN_TX2R_CANTX2_6_POS))
#define CAN_TX2R_CANTX2_7               ((uint32_t)1<<(CAN_TX2R_CANTX2_7_POS))
#define CAN_TX2R_CANTX2_8               ((uint32_t)1<<(CAN_TX2R_CANTX2_8_POS))
#define CAN_TX2R_CANTX2_9               ((uint32_t)1<<(CAN_TX2R_CANTX2_9_POS))
#define CAN_TX2R_CANTX2_10              ((uint32_t)1<<(CAN_TX2R_CANTX2_10_POS))
#define CAN_TX2R_CANTX2_11              ((uint32_t)1<<(CAN_TX2R_CANTX2_11_POS))
#define CAN_TX2R_CANTX2_12              ((uint32_t)1<<(CAN_TX2R_CANTX2_12_POS))
#define CAN_TX2R_CANTX2_13              ((uint32_t)1<<(CAN_TX2R_CANTX2_13_POS))
#define CAN_TX2R_CANTX2_14              ((uint32_t)1<<(CAN_TX2R_CANTX2_14_POS))
#define CAN_TX2R_CANTX2_15              ((uint32_t)1<<(CAN_TX2R_CANTX2_15_POS))
#define CAN_TX2R_CANTX2_16              ((uint32_t)1<<(CAN_TX2R_CANTX2_16_POS))
#define CAN_TX2R_CANTX2_17              ((uint32_t)1<<(CAN_TX2R_CANTX2_17_POS))
#define CAN_TX2R_CANTX2_18              ((uint32_t)1<<(CAN_TX2R_CANTX2_18_POS))
#define CAN_TX2R_CANTX2_19              ((uint32_t)1<<(CAN_TX2R_CANTX2_19_POS))
#define CAN_TX2R_CANTX2_20              ((uint32_t)1<<(CAN_TX2R_CANTX2_20_POS))
#define CAN_TX2R_CANTX2_21              ((uint32_t)1<<(CAN_TX2R_CANTX2_21_POS))
#define CAN_TX2R_CANTX2_22              ((uint32_t)1<<(CAN_TX2R_CANTX2_22_POS))
#define CAN_TX2R_CANTX2_23              ((uint32_t)1<<(CAN_TX2R_CANTX2_23_POS))
#define CAN_TX2R_CANTX2_24              ((uint32_t)1<<(CAN_TX2R_CANTX2_24_POS))
#define CAN_TX2R_CANTX2_25              ((uint32_t)1<<(CAN_TX2R_CANTX2_25_POS))
#define CAN_TX2R_CANTX2_26              ((uint32_t)1<<(CAN_TX2R_CANTX2_26_POS))
#define CAN_TX2R_CANTX2_27              ((uint32_t)1<<(CAN_TX2R_CANTX2_27_POS))
#define CAN_TX2R_CANTX2_28              ((uint32_t)1<<(CAN_TX2R_CANTX2_28_POS))
#define CAN_TX2R_CANTX2_29              ((uint32_t)1<<(CAN_TX2R_CANTX2_29_POS))
#define CAN_TX2R_CANTX2_30              ((uint32_t)1<<(CAN_TX2R_CANTX2_30_POS))
#define CAN_TX2R_CANTX2_31              ((uint32_t)1<<(CAN_TX2R_CANTX2_31_POS))

/* CAN_RXDATA0	λ*/
#define CAN_RXDATA0_DLC0_POS               (0)
#define CAN_RXDATA0_DLC1_POS               (1)
#define CAN_RXDATA0_DLC2_POS               (2)
#define CAN_RXDATA0_DLC3_POS               (3)
#define CAN_RXDATA0_RTR_POS                (6)
#define CAN_RXDATA0_IDE_POS                (7)
#define CAN_RXDATA0_DLC                    ((uint32_t)0xF<<(CAN_RXDATA0_DLC0_POS))
#define CAN_RXDATA0_DLC0                   ((uint32_t)1<<(CAN_RXDATA0_DLC0_POS))
#define CAN_RXDATA0_DLC1                   ((uint32_t)1<<(CAN_RXDATA0_DLC1_POS))
#define CAN_RXDATA0_DLC2                   ((uint32_t)1<<(CAN_RXDATA0_DLC2_POS))
#define CAN_RXDATA0_DLC3                   ((uint32_t)1<<(CAN_RXDATA0_DLC3_POS))
#define CAN_RXDATA0_RTR                    ((uint32_t)1<<(CAN_RXDATA0_RTR_POS))
#define CAN_RXDATA0_IDE                    ((uint32_t)1<<(CAN_RXDATA0_IDE_POS))

/* CAN_RXDATA1	λ*/
#define	CAN_RXDATA1_SFF_CANRXDT1_0_POS		(0)
#define	CAN_RXDATA1_SFF_CANRXDT1_1_POS		(1)
#define	CAN_RXDATA1_SFF_CANRXDT1_2_POS		(2)
#define	CAN_RXDATA1_SFF_CANRXDT1_3_POS		(3)
#define	CAN_RXDATA1_SFF_CANRXDT1_4_POS		(4)
#define	CAN_RXDATA1_SFF_CANRXDT1_5_POS		(5)
#define	CAN_RXDATA1_SFF_CANRXDT1_6_POS		(6)
#define	CAN_RXDATA1_SFF_CANRXDT1_7_POS		(7)
#define	CAN_RXDATA1_SFF_CANRXDT0_0_POS		(8)
#define	CAN_RXDATA1_SFF_CANRXDT0_1_POS		(9)
#define	CAN_RXDATA1_SFF_CANRXDT0_2_POS		(10)
#define	CAN_RXDATA1_SFF_CANRXDT0_3_POS		(11)
#define	CAN_RXDATA1_SFF_CANRXDT0_4_POS		(12)
#define	CAN_RXDATA1_SFF_CANRXDT0_5_POS		(13)
#define	CAN_RXDATA1_SFF_CANRXDT0_6_POS		(14)
#define	CAN_RXDATA1_SFF_CANRXDT0_7_POS		(15)
#define	CAN_RXDATA1_SFF_RTR_POS				(20)
#define	CAN_RXDATA1_SFF_ID18_POS			(21)
#define	CAN_RXDATA1_SFF_ID19_POS			(22)
#define	CAN_RXDATA1_SFF_ID20_POS			(23)
#define	CAN_RXDATA1_SFF_ID21_POS			(24)
#define	CAN_RXDATA1_SFF_ID22_POS			(25)
#define	CAN_RXDATA1_SFF_ID23_POS			(26)
#define	CAN_RXDATA1_SFF_ID24_POS			(27)
#define	CAN_RXDATA1_SFF_ID25_POS			(28)
#define	CAN_RXDATA1_SFF_ID26_POS			(29)
#define	CAN_RXDATA1_SFF_ID27_POS			(30)
#define	CAN_RXDATA1_SFF_ID28_POS			(31)
#define	CAN_RXDATA1_SFF_CANRXDT1			((uint32_t)0xFF<<(CAN_RXDATA1_SFF_CANRXDT1_0_POS))
#define	CAN_RXDATA1_SFF_CANRXDT1_0			((uint32_t)1<<(CAN_RXDATA1_SFF_CANRXDT1_0_POS))
#define	CAN_RXDATA1_SFF_CANRXDT1_1			((uint32_t)1<<(CAN_RXDATA1_SFF_CANRXDT1_1_POS))
#define	CAN_RXDATA1_SFF_CANRXDT1_2			((uint32_t)1<<(CAN_RXDATA1_SFF_CANRXDT1_2_POS))
#define	CAN_RXDATA1_SFF_CANRXDT1_3			((uint32_t)1<<(CAN_RXDATA1_SFF_CANRXDT1_3_POS))
#define	CAN_RXDATA1_SFF_CANRXDT1_4			((uint32_t)1<<(CAN_RXDATA1_SFF_CANRXDT1_4_POS))
#define	CAN_RXDATA1_SFF_CANRXDT1_5			((uint32_t)1<<(CAN_RXDATA1_SFF_CANRXDT1_5_POS))
#define	CAN_RXDATA1_SFF_CANRXDT1_6			((uint32_t)1<<(CAN_RXDATA1_SFF_CANRXDT1_6_POS))
#define	CAN_RXDATA1_SFF_CANRXDT1_7			((uint32_t)1<<(CAN_RXDATA1_SFF_CANRXDT1_7_POS))
#define	CAN_RXDATA1_SFF_CANRXDT0			((uint32_t)0xFF<<(CAN_RXDATA1_SFF_CANRXDT0_0_POS))
#define	CAN_RXDATA1_SFF_CANRXDT0_0			((uint32_t)1<<(CAN_RXDATA1_SFF_CANRXDT0_0_POS))
#define	CAN_RXDATA1_SFF_CANRXDT0_1			((uint32_t)1<<(CAN_RXDATA1_SFF_CANRXDT0_1_POS))
#define	CAN_RXDATA1_SFF_CANRXDT0_2			((uint32_t)1<<(CAN_RXDATA1_SFF_CANRXDT0_2_POS))
#define	CAN_RXDATA1_SFF_CANRXDT0_3			((uint32_t)1<<(CAN_RXDATA1_SFF_CANRXDT0_3_POS))
#define	CAN_RXDATA1_SFF_CANRXDT0_4			((uint32_t)1<<(CAN_RXDATA1_SFF_CANRXDT0_4_POS))
#define	CAN_RXDATA1_SFF_CANRXDT0_5			((uint32_t)1<<(CAN_RXDATA1_SFF_CANRXDT0_5_POS))
#define	CAN_RXDATA1_SFF_CANRXDT0_6			((uint32_t)1<<(CAN_RXDATA1_SFF_CANRXDT0_6_POS))
#define	CAN_RXDATA1_SFF_CANRXDT0_7			((uint32_t)1<<(CAN_RXDATA1_SFF_CANRXDT0_7_POS))
#define	CAN_RXDATA1_SFF_RTR				    ((uint32_t)1<<(CAN_RXDATA1_SFF_RTR_POS))
#define	CAN_RXDATA1_SFF_ID18				((uint32_t)1<<(CAN_RXDATA1_SFF_ID18_POS))
#define	CAN_RXDATA1_SFF_ID19				((uint32_t)1<<(CAN_RXDATA1_SFF_ID19_POS))
#define	CAN_RXDATA1_SFF_ID20				((uint32_t)1<<(CAN_RXDATA1_SFF_ID20_POS))
#define	CAN_RXDATA1_SFF_ID21				((uint32_t)1<<(CAN_RXDATA1_SFF_ID21_POS))
#define	CAN_RXDATA1_SFF_ID22				((uint32_t)1<<(CAN_RXDATA1_SFF_ID22_POS))
#define	CAN_RXDATA1_SFF_ID23				((uint32_t)1<<(CAN_RXDATA1_SFF_ID23_POS))
#define	CAN_RXDATA1_SFF_ID24				((uint32_t)1<<(CAN_RXDATA1_SFF_ID24_POS))
#define	CAN_RXDATA1_SFF_ID25				((uint32_t)1<<(CAN_RXDATA1_SFF_ID25_POS))
#define	CAN_RXDATA1_SFF_ID26				((uint32_t)1<<(CAN_RXDATA1_SFF_ID26_POS))
#define	CAN_RXDATA1_SFF_ID27				((uint32_t)1<<(CAN_RXDATA1_SFF_ID27_POS))
#define	CAN_RXDATA1_SFF_ID28				((uint32_t)1<<(CAN_RXDATA1_SFF_ID28_POS))


#define CAN_RXDATA1_EFF_RTR_POS            (2)
#define CAN_RXDATA1_EFF_ID0_POS            (3)
#define CAN_RXDATA1_EFF_ID1_POS            (4)
#define CAN_RXDATA1_EFF_ID2_POS            (5)
#define CAN_RXDATA1_EFF_ID3_POS            (6)
#define CAN_RXDATA1_EFF_ID4_POS            (7)
#define CAN_RXDATA1_EFF_ID5_POS            (8)
#define CAN_RXDATA1_EFF_ID6_POS            (9)
#define CAN_RXDATA1_EFF_ID7_POS            (10)
#define CAN_RXDATA1_EFF_ID8_POS            (11)
#define CAN_RXDATA1_EFF_ID9_POS            (12)
#define CAN_RXDATA1_EFF_ID10_POS           (13)
#define CAN_RXDATA1_EFF_ID11_POS           (14)
#define CAN_RXDATA1_EFF_ID12_POS           (15)
#define CAN_RXDATA1_EFF_ID13_POS           (16)
#define CAN_RXDATA1_EFF_ID14_POS           (17)
#define CAN_RXDATA1_EFF_ID15_POS           (18)
#define CAN_RXDATA1_EFF_ID16_POS           (19)
#define CAN_RXDATA1_EFF_ID17_POS           (20)
#define CAN_RXDATA1_EFF_ID18_POS           (21)
#define CAN_RXDATA1_EFF_ID19_POS           (22)
#define CAN_RXDATA1_EFF_ID20_POS           (23)
#define CAN_RXDATA1_EFF_ID21_POS           (24)
#define CAN_RXDATA1_EFF_ID22_POS           (25)
#define CAN_RXDATA1_EFF_ID23_POS           (26)
#define CAN_RXDATA1_EFF_ID24_POS           (27)
#define CAN_RXDATA1_EFF_ID25_POS           (28)
#define CAN_RXDATA1_EFF_ID26_POS           (29)
#define CAN_RXDATA1_EFF_ID27_POS           (30)
#define CAN_RXDATA1_EFF_ID28_POS           (31)
#define CAN_RXDATA1_EFF_EFF_RTR            ((uint32_t)1<<(CAN_RXDATA1_EFF_EFF_RTR_POS))
#define CAN_RXDATA1_EFF_ID1                ((uint32_t)1<<(CAN_RXDATA1_EFF_ID1_POS))
#define CAN_RXDATA1_EFF_ID2                ((uint32_t)1<<(CAN_RXDATA1_EFF_ID2_POS))
#define CAN_RXDATA1_EFF_ID3                ((uint32_t)1<<(CAN_RXDATA1_EFF_ID3_POS))
#define CAN_RXDATA1_EFF_ID4                ((uint32_t)1<<(CAN_RXDATA1_EFF_ID4_POS))
#define CAN_RXDATA1_EFF_ID5                ((uint32_t)1<<(CAN_RXDATA1_EFF_ID5_POS))
#define CAN_RXDATA1_EFF_ID6                ((uint32_t)1<<(CAN_RXDATA1_EFF_ID6_POS))
#define CAN_RXDATA1_EFF_ID7                ((uint32_t)1<<(CAN_RXDATA1_EFF_ID7_POS))
#define CAN_RXDATA1_EFF_ID8                ((uint32_t)1<<(CAN_RXDATA1_EFF_ID8_POS))
#define CAN_RXDATA1_EFF_ID9                ((uint32_t)1<<(CAN_RXDATA1_EFF_ID9_POS))
#define CAN_RXDATA1_EFF_ID10               ((uint32_t)1<<(CAN_RXDATA1_EFF_ID10_POS))
#define CAN_RXDATA1_EFF_ID11               ((uint32_t)1<<(CAN_RXDATA1_EFF_ID11_POS))
#define CAN_RXDATA1_EFF_ID12               ((uint32_t)1<<(CAN_RXDATA1_EFF_ID12_POS))
#define CAN_RXDATA1_EFF_ID13               ((uint32_t)1<<(CAN_RXDATA1_EFF_ID13_POS))
#define CAN_RXDATA1_EFF_ID14               ((uint32_t)1<<(CAN_RXDATA1_EFF_ID14_POS))
#define CAN_RXDATA1_EFF_ID15               ((uint32_t)1<<(CAN_RXDATA1_EFF_ID15_POS))
#define CAN_RXDATA1_EFF_ID16               ((uint32_t)1<<(CAN_RXDATA1_EFF_ID16_POS))
#define CAN_RXDATA1_EFF_ID17               ((uint32_t)1<<(CAN_RXDATA1_EFF_ID17_POS))
#define CAN_RXDATA1_EFF_ID18               ((uint32_t)1<<(CAN_RXDATA1_EFF_ID18_POS))
#define CAN_RXDATA1_EFF_ID19               ((uint32_t)1<<(CAN_RXDATA1_EFF_ID19_POS))
#define CAN_RXDATA1_EFF_ID20               ((uint32_t)1<<(CAN_RXDATA1_EFF_ID20_POS))
#define CAN_RXDATA1_EFF_ID21               ((uint32_t)1<<(CAN_RXDATA1_EFF_ID21_POS))
#define CAN_RXDATA1_EFF_ID22               ((uint32_t)1<<(CAN_RXDATA1_EFF_ID22_POS))
#define CAN_RXDATA1_EFF_ID23               ((uint32_t)1<<(CAN_RXDATA1_EFF_ID23_POS))
#define CAN_RXDATA1_EFF_ID24               ((uint32_t)1<<(CAN_RXDATA1_EFF_ID24_POS))
#define CAN_RXDATA1_EFF_ID25               ((uint32_t)1<<(CAN_RXDATA1_EFF_ID25_POS))
#define CAN_RXDATA1_EFF_ID26               ((uint32_t)1<<(CAN_RXDATA1_EFF_ID26_POS))
#define CAN_RXDATA1_EFF_ID27               ((uint32_t)1<<(CAN_RXDATA1_EFF_ID27_POS))
#define CAN_RXDATA1_EFF_ID28               ((uint32_t)1<<(CAN_RXDATA1_EFF_ID28_POS))

/* CANx_RXDATA2λ */
#define	CAN_RXDATA2_SFF_CANRXDT5_0_POS			(0)
#define	CAN_RXDATA2_SFF_CANRXDT5_1_POS			(1)
#define	CAN_RXDATA2_SFF_CANRXDT5_2_POS			(2)
#define	CAN_RXDATA2_SFF_CANRXDT5_3_POS			(3)
#define	CAN_RXDATA2_SFF_CANRXDT5_4_POS			(4)
#define	CAN_RXDATA2_SFF_CANRXDT5_5_POS			(5)
#define	CAN_RXDATA2_SFF_CANRXDT5_6_POS			(6)
#define	CAN_RXDATA2_SFF_CANRXDT5_7_POS			(7)
#define	CAN_RXDATA2_SFF_CANRXDT4_0_POS			(8)
#define	CAN_RXDATA2_SFF_CANRXDT4_1_POS			(9)
#define	CAN_RXDATA2_SFF_CANRXDT4_2_POS			(10)
#define	CAN_RXDATA2_SFF_CANRXDT4_3_POS			(11)
#define	CAN_RXDATA2_SFF_CANRXDT4_4_POS			(12)
#define	CAN_RXDATA2_SFF_CANRXDT4_5_POS			(13)
#define	CAN_RXDATA2_SFF_CANRXDT4_6_POS			(14)
#define	CAN_RXDATA2_SFF_CANRXDT4_7_POS			(15)
#define	CAN_RXDATA2_SFF_CANRXDT3_0_POS			(16)
#define	CAN_RXDATA2_SFF_CANRXDT3_1_POS			(17)
#define	CAN_RXDATA2_SFF_CANRXDT3_2_POS			(18)
#define	CAN_RXDATA2_SFF_CANRXDT3_3_POS			(19)
#define	CAN_RXDATA2_SFF_CANRXDT3_4_POS			(20)
#define	CAN_RXDATA2_SFF_CANRXDT3_5_POS			(21)
#define	CAN_RXDATA2_SFF_CANRXDT3_6_POS			(22)
#define	CAN_RXDATA2_SFF_CANRXDT3_7_POS			(23)
#define	CAN_RXDATA2_SFF_CANRXDT2_0_POS			(24)
#define	CAN_RXDATA2_SFF_CANRXDT2_1_POS			(25)
#define	CAN_RXDATA2_SFF_CANRXDT2_2_POS			(26)
#define	CAN_RXDATA2_SFF_CANRXDT2_3_POS			(27)
#define	CAN_RXDATA2_SFF_CANRXDT2_4_POS			(28)
#define	CAN_RXDATA2_SFF_CANRXDT2_5_POS			(29)
#define	CAN_RXDATA2_SFF_CANRXDT2_6_POS			(30)
#define	CAN_RXDATA2_SFF_CANRXDT2_7_POS			(31)
#define	CAN_RXDATA2_SFF_CANRXDT5				((uint32_t)0xFF<<(CAN_RXDATA2_SFF_CANRXDT5_0_POS))
#define	CAN_RXDATA2_SFF_CANRXDT5_0				((uint32_t)1<<(CAN_RXDATA2_SFF_CANRXDT5_0_POS))
#define	CAN_RXDATA2_SFF_CANRXDT5_1				((uint32_t)1<<(CAN_RXDATA2_SFF_CANRXDT5_1_POS))
#define	CAN_RXDATA2_SFF_CANRXDT5_2				((uint32_t)1<<(CAN_RXDATA2_SFF_CANRXDT5_2_POS))
#define	CAN_RXDATA2_SFF_CANRXDT5_3				((uint32_t)1<<(CAN_RXDATA2_SFF_CANRXDT5_3_POS))
#define	CAN_RXDATA2_SFF_CANRXDT5_4				((uint32_t)1<<(CAN_RXDATA2_SFF_CANRXDT5_4_POS))
#define	CAN_RXDATA2_SFF_CANRXDT5_5				((uint32_t)1<<(CAN_RXDATA2_SFF_CANRXDT5_5_POS))
#define	CAN_RXDATA2_SFF_CANRXDT5_6				((uint32_t)1<<(CAN_RXDATA2_SFF_CANRXDT5_6_POS))
#define	CAN_RXDATA2_SFF_CANRXDT5_7				((uint32_t)1<<(CAN_RXDATA2_SFF_CANRXDT5_7_POS))
#define	CAN_RXDATA2_SFF_CANRXDT4				((uint32_t)0xFF<<(CAN_RXDATA2_SFF_CANRXDT4_0_POS))
#define	CAN_RXDATA2_SFF_CANRXDT4_0				((uint32_t)1<<(CAN_RXDATA2_SFF_CANRXDT4_0_POS))
#define	CAN_RXDATA2_SFF_CANRXDT4_1				((uint32_t)1<<(CAN_RXDATA2_SFF_CANRXDT4_1_POS))
#define	CAN_RXDATA2_SFF_CANRXDT4_2				((uint32_t)1<<(CAN_RXDATA2_SFF_CANRXDT4_2_POS))
#define	CAN_RXDATA2_SFF_CANRXDT4_3				((uint32_t)1<<(CAN_RXDATA2_SFF_CANRXDT4_3_POS))
#define	CAN_RXDATA2_SFF_CANRXDT4_4				((uint32_t)1<<(CAN_RXDATA2_SFF_CANRXDT4_4_POS))
#define	CAN_RXDATA2_SFF_CANRXDT4_5				((uint32_t)1<<(CAN_RXDATA2_SFF_CANRXDT4_5_POS))
#define	CAN_RXDATA2_SFF_CANRXDT4_6				((uint32_t)1<<(CAN_RXDATA2_SFF_CANRXDT4_6_POS))
#define	CAN_RXDATA2_SFF_CANRXDT4_7				((uint32_t)1<<(CAN_RXDATA2_SFF_CANRXDT4_7_POS))
#define	CAN_RXDATA2_SFF_CANRXDT3				((uint32_t)0xFF<<(CAN_RXDATA2_SFF_CANRXDT3_0_POS))
#define	CAN_RXDATA2_SFF_CANRXDT3_0				((uint32_t)1<<(CAN_RXDATA2_SFF_CANRXDT3_0_POS))
#define	CAN_RXDATA2_SFF_CANRXDT3_1				((uint32_t)1<<(CAN_RXDATA2_SFF_CANRXDT3_1_POS))
#define	CAN_RXDATA2_SFF_CANRXDT3_2				((uint32_t)1<<(CAN_RXDATA2_SFF_CANRXDT3_2_POS))
#define	CAN_RXDATA2_SFF_CANRXDT3_3				((uint32_t)1<<(CAN_RXDATA2_SFF_CANRXDT3_3_POS))
#define	CAN_RXDATA2_SFF_CANRXDT3_4				((uint32_t)1<<(CAN_RXDATA2_SFF_CANRXDT3_4_POS))
#define	CAN_RXDATA2_SFF_CANRXDT3_5				((uint32_t)1<<(CAN_RXDATA2_SFF_CANRXDT3_5_POS))
#define	CAN_RXDATA2_SFF_CANRXDT3_6				((uint32_t)1<<(CAN_RXDATA2_SFF_CANRXDT3_6_POS))
#define	CAN_RXDATA2_SFF_CANRXDT3_7				((uint32_t)1<<(CAN_RXDATA2_SFF_CANRXDT3_7_POS))
#define	CAN_RXDATA2_SFF_CANRXDT2				((uint32_t)0xFF<<(CAN_RXDATA2_SFF_CANRXDT2_0_POS))
#define	CAN_RXDATA2_SFF_CANRXDT2_0				((uint32_t)1<<(CAN_RXDATA2_SFF_CANRXDT2_0_POS))
#define	CAN_RXDATA2_SFF_CANRXDT2_1				((uint32_t)1<<(CAN_RXDATA2_SFF_CANRXDT2_1_POS))
#define	CAN_RXDATA2_SFF_CANRXDT2_2				((uint32_t)1<<(CAN_RXDATA2_SFF_CANRXDT2_2_POS))
#define	CAN_RXDATA2_SFF_CANRXDT2_3				((uint32_t)1<<(CAN_RXDATA2_SFF_CANRXDT2_3_POS))
#define	CAN_RXDATA2_SFF_CANRXDT2_4				((uint32_t)1<<(CAN_RXDATA2_SFF_CANRXDT2_4_POS))
#define	CAN_RXDATA2_SFF_CANRXDT2_5				((uint32_t)1<<(CAN_RXDATA2_SFF_CANRXDT2_5_POS))
#define	CAN_RXDATA2_SFF_CANRXDT2_6				((uint32_t)1<<(CAN_RXDATA2_SFF_CANRXDT2_6_POS))
#define	CAN_RXDATA2_SFF_CANRXDT2_7				((uint32_t)1<<(CAN_RXDATA2_SFF_CANRXDT2_7_POS))

#define	CAN_RXDATA2_EFF_CANRXDT3_0_POS			(0)
#define	CAN_RXDATA2_EFF_CANRXDT3_1_POS			(1)
#define	CAN_RXDATA2_EFF_CANRXDT3_2_POS			(2)
#define	CAN_RXDATA2_EFF_CANRXDT3_3_POS			(3)
#define	CAN_RXDATA2_EFF_CANRXDT3_4_POS			(4)
#define	CAN_RXDATA2_EFF_CANRXDT3_5_POS			(5)
#define	CAN_RXDATA2_EFF_CANRXDT3_6_POS			(6)
#define	CAN_RXDATA2_EFF_CANRXDT3_7_POS			(7)
#define	CAN_RXDATA2_EFF_CANRXDT2_0_POS			(8)
#define	CAN_RXDATA2_EFF_CANRXDT2_1_POS			(9)
#define	CAN_RXDATA2_EFF_CANRXDT2_2_POS			(10)
#define	CAN_RXDATA2_EFF_CANRXDT2_3_POS			(11)
#define	CAN_RXDATA2_EFF_CANRXDT2_4_POS			(12)
#define	CAN_RXDATA2_EFF_CANRXDT2_5_POS			(13)
#define	CAN_RXDATA2_EFF_CANRXDT2_6_POS			(14)
#define	CAN_RXDATA2_EFF_CANRXDT2_7_POS			(15)
#define	CAN_RXDATA2_EFF_CANRXDT1_0_POS			(16)
#define	CAN_RXDATA2_EFF_CANRXDT1_1_POS			(17)
#define	CAN_RXDATA2_EFF_CANRXDT1_2_POS			(18)
#define	CAN_RXDATA2_EFF_CANRXDT1_3_POS			(19)
#define	CAN_RXDATA2_EFF_CANRXDT1_4_POS			(20)
#define	CAN_RXDATA2_EFF_CANRXDT1_5_POS			(21)
#define	CAN_RXDATA2_EFF_CANRXDT1_6_POS			(22)
#define	CAN_RXDATA2_EFF_CANRXDT1_7_POS			(23)
#define	CAN_RXDATA2_EFF_CANRXDT0_0_POS			(24)
#define	CAN_RXDATA2_EFF_CANRXDT0_1_POS			(25)
#define	CAN_RXDATA2_EFF_CANRXDT0_2_POS			(26)
#define	CAN_RXDATA2_EFF_CANRXDT0_3_POS			(27)
#define	CAN_RXDATA2_EFF_CANRXDT0_4_POS			(28)
#define	CAN_RXDATA2_EFF_CANRXDT0_5_POS			(29)
#define	CAN_RXDATA2_EFF_CANRXDT0_6_POS			(30)
#define	CAN_RXDATA2_EFF_CANRXDT0_7_POS			(31)
#define	CAN_RXDATA2_EFF_CANRXDT3				((uint32_t)0xFF<<(CAN_RXDATA2_EFF_CANRXDT3_0_POS)
#define	CAN_RXDATA2_EFF_CANRXDT3_0				((uint32_t)1<<(CAN_RXDATA2_EFF_CANRXDT3_0_POS))
#define	CAN_RXDATA2_EFF_CANRXDT3_1				((uint32_t)1<<(CAN_RXDATA2_EFF_CANRXDT3_1_POS))
#define	CAN_RXDATA2_EFF_CANRXDT3_2				((uint32_t)1<<(CAN_RXDATA2_EFF_CANRXDT3_2_POS))
#define	CAN_RXDATA2_EFF_CANRXDT3_3				((uint32_t)1<<(CAN_RXDATA2_EFF_CANRXDT3_3_POS))
#define	CAN_RXDATA2_EFF_CANRXDT3_4				((uint32_t)1<<(CAN_RXDATA2_EFF_CANRXDT3_4_POS))
#define	CAN_RXDATA2_EFF_CANRXDT3_5				((uint32_t)1<<(CAN_RXDATA2_EFF_CANRXDT3_5_POS))
#define	CAN_RXDATA2_EFF_CANRXDT3_6				((uint32_t)1<<(CAN_RXDATA2_EFF_CANRXDT3_6_POS))
#define	CAN_RXDATA2_EFF_CANRXDT3_7				((uint32_t)1<<(CAN_RXDATA2_EFF_CANRXDT3_7_POS))
#define	CAN_RXDATA2_EFF_CANRXDT2				((uint32_t)0xFF<<(CAN_RXDATA2_EFF_CANRXDT2_0_POS)
#define	CAN_RXDATA2_EFF_CANRXDT2_0				((uint32_t)1<<(CAN_RXDATA2_EFF_CANRXDT2_0_POS))
#define	CAN_RXDATA2_EFF_CANRXDT2_1				((uint32_t)1<<(CAN_RXDATA2_EFF_CANRXDT2_1_POS))
#define	CAN_RXDATA2_EFF_CANRXDT2_2				((uint32_t)1<<(CAN_RXDATA2_EFF_CANRXDT2_2_POS))
#define	CAN_RXDATA2_EFF_CANRXDT2_3				((uint32_t)1<<(CAN_RXDATA2_EFF_CANRXDT2_3_POS))
#define	CAN_RXDATA2_EFF_CANRXDT2_4				((uint32_t)1<<(CAN_RXDATA2_EFF_CANRXDT2_4_POS))
#define	CAN_RXDATA2_EFF_CANRXDT2_5				((uint32_t)1<<(CAN_RXDATA2_EFF_CANRXDT2_5_POS))
#define	CAN_RXDATA2_EFF_CANRXDT2_6				((uint32_t)1<<(CAN_RXDATA2_EFF_CANRXDT2_6_POS))
#define	CAN_RXDATA2_EFF_CANRXDT2_7				((uint32_t)1<<(CAN_RXDATA2_EFF_CANRXDT2_7_POS))
#define	CAN_RXDATA2_EFF_CANRXDT1				((uint32_t)0xFF<<(CAN_RXDATA2_EFF_CANRXDT1_0_POS)
#define	CAN_RXDATA2_EFF_CANRXDT1_0				((uint32_t)1<<(CAN_RXDATA2_EFF_CANRXDT1_0_POS))
#define	CAN_RXDATA2_EFF_CANRXDT1_1				((uint32_t)1<<(CAN_RXDATA2_EFF_CANRXDT1_1_POS))
#define	CAN_RXDATA2_EFF_CANRXDT1_2				((uint32_t)1<<(CAN_RXDATA2_EFF_CANRXDT1_2_POS))
#define	CAN_RXDATA2_EFF_CANRXDT1_3				((uint32_t)1<<(CAN_RXDATA2_EFF_CANRXDT1_3_POS))
#define	CAN_RXDATA2_EFF_CANRXDT1_4				((uint32_t)1<<(CAN_RXDATA2_EFF_CANRXDT1_4_POS))
#define	CAN_RXDATA2_EFF_CANRXDT1_5				((uint32_t)1<<(CAN_RXDATA2_EFF_CANRXDT1_5_POS))
#define	CAN_RXDATA2_EFF_CANRXDT1_6				((uint32_t)1<<(CAN_RXDATA2_EFF_CANRXDT1_6_POS))
#define	CAN_RXDATA2_EFF_CANRXDT1_7				((uint32_t)1<<(CAN_RXDATA2_EFF_CANRXDT1_7_POS))
#define	CAN_RXDATA2_EFF_CANRXDT0				((uint32_t)0xFF<<(CAN_RXDATA2_EFF_CANRXDT0_0_POS)
#define	CAN_RXDATA2_EFF_CANRXDT0_0				((uint32_t)1<<(CAN_RXDATA2_EFF_CANRXDT0_0_POS))
#define	CAN_RXDATA2_EFF_CANRXDT0_1				((uint32_t)1<<(CAN_RXDATA2_EFF_CANRXDT0_1_POS))
#define	CAN_RXDATA2_EFF_CANRXDT0_2				((uint32_t)1<<(CAN_RXDATA2_EFF_CANRXDT0_2_POS))
#define	CAN_RXDATA2_EFF_CANRXDT0_3				((uint32_t)1<<(CAN_RXDATA2_EFF_CANRXDT0_3_POS))
#define	CAN_RXDATA2_EFF_CANRXDT0_4				((uint32_t)1<<(CAN_RXDATA2_EFF_CANRXDT0_4_POS))
#define	CAN_RXDATA2_EFF_CANRXDT0_5				((uint32_t)1<<(CAN_RXDATA2_EFF_CANRXDT0_5_POS))
#define	CAN_RXDATA2_EFF_CANRXDT0_6				((uint32_t)1<<(CAN_RXDATA2_EFF_CANRXDT0_6_POS))
#define	CAN_RXDATA2_EFF_CANRXDT0_7				((uint32_t)1<<(CAN_RXDATA2_EFF_CANRXDT0_7_POS))

/* CAN_RXDATA3λ */
#define	CAN_RXDATA3_SFF_CANRXDT7_0_POS			(16)
#define	CAN_RXDATA3_SFF_CANRXDT7_1_POS			(17)
#define	CAN_RXDATA3_SFF_CANRXDT7_2_POS			(18)
#define	CAN_RXDATA3_SFF_CANRXDT7_3_POS			(19)
#define	CAN_RXDATA3_SFF_CANRXDT7_4_POS			(20)
#define	CAN_RXDATA3_SFF_CANRXDT7_5_POS			(21)
#define	CAN_RXDATA3_SFF_CANRXDT7_6_POS			(22)
#define	CAN_RXDATA3_SFF_CANRXDT7_7_POS			(23)
#define	CAN_RXDATA3_SFF_CANRXDT6_0_POS			(24)
#define	CAN_RXDATA3_SFF_CANRXDT6_1_POS			(25)
#define	CAN_RXDATA3_SFF_CANRXDT6_2_POS			(26)
#define	CAN_RXDATA3_SFF_CANRXDT6_3_POS			(27)
#define	CAN_RXDATA3_SFF_CANRXDT6_4_POS			(28)
#define	CAN_RXDATA3_SFF_CANRXDT6_5_POS			(29)
#define	CAN_RXDATA3_SFF_CANRXDT6_6_POS			(30)
#define	CAN_RXDATA3_SFF_CANRXDT6_7_POS			(31)
#define	CAN_RXDATA3_SFF_CANRXDT7				((uint32_t)0xFF<<(CAN_RXDATA3_SFF_CANRXDT7_0_POS))
#define	CAN_RXDATA3_SFF_CANRXDT7_0				((uint32_t)1<<(CAN_RXDATA3_SFF_CANRXDT7_0_POS))
#define	CAN_RXDATA3_SFF_CANRXDT7_1				((uint32_t)1<<(CAN_RXDATA3_SFF_CANRXDT7_1_POS))
#define	CAN_RXDATA3_SFF_CANRXDT7_2				((uint32_t)1<<(CAN_RXDATA3_SFF_CANRXDT7_2_POS))
#define	CAN_RXDATA3_SFF_CANRXDT7_3				((uint32_t)1<<(CAN_RXDATA3_SFF_CANRXDT7_3_POS))
#define	CAN_RXDATA3_SFF_CANRXDT7_4				((uint32_t)1<<(CAN_RXDATA3_SFF_CANRXDT7_4_POS))
#define	CAN_RXDATA3_SFF_CANRXDT7_5				((uint32_t)1<<(CAN_RXDATA3_SFF_CANRXDT7_5_POS))
#define	CAN_RXDATA3_SFF_CANRXDT7_6				((uint32_t)1<<(CAN_RXDATA3_SFF_CANRXDT7_6_POS))
#define	CAN_RXDATA3_SFF_CANRXDT7_7				((uint32_t)1<<(CAN_RXDATA3_SFF_CANRXDT7_7_POS))
#define	CAN_RXDATA3_SFF_CANRXDT6				((uint32_t)0xFF<<(CAN_RXDATA3_SFF_CANRXDT6_0_POS))
#define	CAN_RXDATA3_SFF_CANRXDT6_0				((uint32_t)1<<(CAN_RXDATA3_SFF_CANRXDT6_0_POS))
#define	CAN_RXDATA3_SFF_CANRXDT6_1				((uint32_t)1<<(CAN_RXDATA3_SFF_CANRXDT6_1_POS))
#define	CAN_RXDATA3_SFF_CANRXDT6_2				((uint32_t)1<<(CAN_RXDATA3_SFF_CANRXDT6_2_POS))
#define	CAN_RXDATA3_SFF_CANRXDT6_3				((uint32_t)1<<(CAN_RXDATA3_SFF_CANRXDT6_3_POS))
#define	CAN_RXDATA3_SFF_CANRXDT6_4				((uint32_t)1<<(CAN_RXDATA3_SFF_CANRXDT6_4_POS))
#define	CAN_RXDATA3_SFF_CANRXDT6_5				((uint32_t)1<<(CAN_RXDATA3_SFF_CANRXDT6_5_POS))
#define	CAN_RXDATA3_SFF_CANRXDT6_6				((uint32_t)1<<(CAN_RXDATA3_SFF_CANRXDT6_6_POS))
#define	CAN_RXDATA3_SFF_CANRXDT6_7				((uint32_t)1<<(CAN_RXDATA3_SFF_CANRXDT6_7_POS))

#define	CAN_RXDATA3_EFF_CANRXDT7_0_POS			(0)
#define	CAN_RXDATA3_EFF_CANRXDT7_1_POS			(1)
#define	CAN_RXDATA3_EFF_CANRXDT7_2_POS			(2)
#define	CAN_RXDATA3_EFF_CANRXDT7_3_POS			(3)
#define	CAN_RXDATA3_EFF_CANRXDT7_4_POS			(4)
#define	CAN_RXDATA3_EFF_CANRXDT7_5_POS			(5)
#define	CAN_RXDATA3_EFF_CANRXDT7_6_POS			(6)
#define	CAN_RXDATA3_EFF_CANRXDT7_7_POS			(7)
#define	CAN_RXDATA3_EFF_CANRXDT6_0_POS			(8)
#define	CAN_RXDATA3_EFF_CANRXDT6_1_POS			(9)
#define	CAN_RXDATA3_EFF_CANRXDT6_2_POS			(10)
#define	CAN_RXDATA3_EFF_CANRXDT6_3_POS			(11)
#define	CAN_RXDATA3_EFF_CANRXDT6_4_POS			(12)
#define	CAN_RXDATA3_EFF_CANRXDT6_5_POS			(13)
#define	CAN_RXDATA3_EFF_CANRXDT6_6_POS			(14)
#define	CAN_RXDATA3_EFF_CANRXDT6_7_POS			(15)
#define	CAN_RXDATA3_EFF_CANRXDT5_0_POS			(16)
#define	CAN_RXDATA3_EFF_CANRXDT5_1_POS			(17)
#define	CAN_RXDATA3_EFF_CANRXDT5_2_POS			(18)
#define	CAN_RXDATA3_EFF_CANRXDT5_3_POS			(19)
#define	CAN_RXDATA3_EFF_CANRXDT5_4_POS			(20)
#define	CAN_RXDATA3_EFF_CANRXDT5_5_POS			(21)
#define	CAN_RXDATA3_EFF_CANRXDT5_6_POS			(22)
#define	CAN_RXDATA3_EFF_CANRXDT5_7_POS			(23)
#define	CAN_RXDATA3_EFF_CANRXDT4_0_POS			(24)
#define	CAN_RXDATA3_EFF_CANRXDT4_1_POS			(25)
#define	CAN_RXDATA3_EFF_CANRXDT4_2_POS			(26)
#define	CAN_RXDATA3_EFF_CANRXDT4_3_POS			(27)
#define	CAN_RXDATA3_EFF_CANRXDT4_4_POS			(28)
#define	CAN_RXDATA3_EFF_CANRXDT4_5_POS			(29)
#define	CAN_RXDATA3_EFF_CANRXDT4_6_POS			(30)
#define	CAN_RXDATA3_EFF_CANRXDT4_7_POS			(31)
#define	CAN_RXDATA3_EFF_CANRXDT7				((uint32_t)0xFF<<(CAN_RXDATA3_EFF_CANRXDT7_0_POS))
#define	CAN_RXDATA3_EFF_CANRXDT7_0				((uint32_t)1<<(CAN_RXDATA3_EFF_CANRXDT7_0_POS))
#define	CAN_RXDATA3_EFF_CANRXDT7_1				((uint32_t)1<<(CAN_RXDATA3_EFF_CANRXDT7_1_POS))
#define	CAN_RXDATA3_EFF_CANRXDT7_2				((uint32_t)1<<(CAN_RXDATA3_EFF_CANRXDT7_2_POS))
#define	CAN_RXDATA3_EFF_CANRXDT7_3				((uint32_t)1<<(CAN_RXDATA3_EFF_CANRXDT7_3_POS))
#define	CAN_RXDATA3_EFF_CANRXDT7_4				((uint32_t)1<<(CAN_RXDATA3_EFF_CANRXDT7_4_POS))
#define	CAN_RXDATA3_EFF_CANRXDT7_5				((uint32_t)1<<(CAN_RXDATA3_EFF_CANRXDT7_5_POS))
#define	CAN_RXDATA3_EFF_CANRXDT7_6				((uint32_t)1<<(CAN_RXDATA3_EFF_CANRXDT7_6_POS))
#define	CAN_RXDATA3_EFF_CANRXDT7_7				((uint32_t)1<<(CAN_RXDATA3_EFF_CANRXDT7_7_POS))
#define	CAN_RXDATA3_EFF_CANRXDT6				((uint32_t)0xFF<<(CAN_RXDATA3_EFF_CANRXDT6_0_POS))
#define	CAN_RXDATA3_EFF_CANRXDT6_0				((uint32_t)1<<(CAN_RXDATA3_EFF_CANRXDT6_0_POS))
#define	CAN_RXDATA3_EFF_CANRXDT6_1				((uint32_t)1<<(CAN_RXDATA3_EFF_CANRXDT6_1_POS))
#define	CAN_RXDATA3_EFF_CANRXDT6_2				((uint32_t)1<<(CAN_RXDATA3_EFF_CANRXDT6_2_POS))
#define	CAN_RXDATA3_EFF_CANRXDT6_3				((uint32_t)1<<(CAN_RXDATA3_EFF_CANRXDT6_3_POS))
#define	CAN_RXDATA3_EFF_CANRXDT6_4				((uint32_t)1<<(CAN_RXDATA3_EFF_CANRXDT6_4_POS))
#define	CAN_RXDATA3_EFF_CANRXDT6_5				((uint32_t)1<<(CAN_RXDATA3_EFF_CANRXDT6_5_POS))
#define	CAN_RXDATA3_EFF_CANRXDT6_6				((uint32_t)1<<(CAN_RXDATA3_EFF_CANRXDT6_6_POS))
#define	CAN_RXDATA3_EFF_CANRXDT6_7				((uint32_t)1<<(CAN_RXDATA3_EFF_CANRXDT6_7_POS))
#define	CAN_RXDATA3_EFF_CANRXDT5				((uint32_t)0xFF<<(CAN_RXDATA3_EFF_CANRXDT5_0_POS))
#define	CAN_RXDATA3_EFF_CANRXDT5_0				((uint32_t)1<<(CAN_RXDATA3_EFF_CANRXDT5_0_POS))
#define	CAN_RXDATA3_EFF_CANRXDT5_1				((uint32_t)1<<(CAN_RXDATA3_EFF_CANRXDT5_1_POS))
#define	CAN_RXDATA3_EFF_CANRXDT5_2				((uint32_t)1<<(CAN_RXDATA3_EFF_CANRXDT5_2_POS))
#define	CAN_RXDATA3_EFF_CANRXDT5_3				((uint32_t)1<<(CAN_RXDATA3_EFF_CANRXDT5_3_POS))
#define	CAN_RXDATA3_EFF_CANRXDT5_4				((uint32_t)1<<(CAN_RXDATA3_EFF_CANRXDT5_4_POS))
#define	CAN_RXDATA3_EFF_CANRXDT5_5				((uint32_t)1<<(CAN_RXDATA3_EFF_CANRXDT5_5_POS))
#define	CAN_RXDATA3_EFF_CANRXDT5_6				((uint32_t)1<<(CAN_RXDATA3_EFF_CANRXDT5_6_POS))
#define	CAN_RXDATA3_EFF_CANRXDT5_7				((uint32_t)1<<(CAN_RXDATA3_EFF_CANRXDT5_7_POS))
#define	CAN_RXDATA3_EFF_CANRXDT4				((uint32_t)0xFF<<(CAN_RXDATA3_EFF_CANRXDT4_0_POS))
#define	CAN_RXDATA3_EFF_CANRXDT4_0				((uint32_t)1<<(CAN_RXDATA3_EFF_CANRXDT4_0_POS))
#define	CAN_RXDATA3_EFF_CANRXDT4_1				((uint32_t)1<<(CAN_RXDATA3_EFF_CANRXDT4_1_POS))
#define	CAN_RXDATA3_EFF_CANRXDT4_2				((uint32_t)1<<(CAN_RXDATA3_EFF_CANRXDT4_2_POS))
#define	CAN_RXDATA3_EFF_CANRXDT4_3				((uint32_t)1<<(CAN_RXDATA3_EFF_CANRXDT4_3_POS))
#define	CAN_RXDATA3_EFF_CANRXDT4_4				((uint32_t)1<<(CAN_RXDATA3_EFF_CANRXDT4_4_POS))
#define	CAN_RXDATA3_EFF_CANRXDT4_5				((uint32_t)1<<(CAN_RXDATA3_EFF_CANRXDT4_5_POS))
#define	CAN_RXDATA3_EFF_CANRXDT4_6				((uint32_t)1<<(CAN_RXDATA3_EFF_CANRXDT4_6_POS))
#define	CAN_RXDATA3_EFF_CANRXDT4_7				((uint32_t)1<<(CAN_RXDATA3_EFF_CANRXDT4_7_POS))

/* CAN_IER  λ*/
#define CAN_IER_CANRXIE_POS             (0)
#define CAN_IER_CANTXIE_POS             (1)
#define CAN_IER_EAIE_POS                (2)
#define CAN_IER_DOVFIE_POS              (3)
#define CAN_IER_WUIE_POS                (4)
#define CAN_IER_ENIE_POS                (5)
#define CAN_IER_ALIE_POS                (6)
#define CAN_IER_BEIE_POS                (7)
#define CAN_IER_CANTXDE_POS             (8)
#define CAN_IER_CANRXDE_POS             (9)
#define CAN_IER_CANRFIE_POS				(10)
#define CAN_IER_BOFFIE_POS				(12)
#define CAN_IER_CANRXIC_POS             (16)
#define CAN_IER_CANTXIC_POS             (17)
#define CAN_IER_EAIC_POS                (18)
#define CAN_IER_DOVFIC_POS              (19)
#define CAN_IER_WUIC_POS                (20)
#define CAN_IER_ENIC_POS                (21)
#define CAN_IER_ALIC_POS                (22)
#define CAN_IER_BEIC_POS                (23)
#define CAN_IER_BOFFIC_POS              (28)
#define CAN_IER_CANRXIE                 ((uint32_t)1<<(CAN_IER_CANRXIE_POS))
#define CAN_IER_CANTXIE                 ((uint32_t)1<<(CAN_IER_CANTXIE_POS))
#define CAN_IER_EAIE                    ((uint32_t)1<<(CAN_IER_EAIE_POS))
#define CAN_IER_DOVFIE                  ((uint32_t)1<<(CAN_IER_DOVFIE_POS))
#define CAN_IER_WUIE                    ((uint32_t)1<<(CAN_IER_WUIE_POS))
#define CAN_IER_ENIE                    ((uint32_t)1<<(CAN_IER_ENIE_POS))
#define CAN_IER_ALIE                    ((uint32_t)1<<(CAN_IER_ALIE_POS))
#define CAN_IER_BEIE                    ((uint32_t)1<<(CAN_IER_BEIE_POS))
#define CAN_IER_CANTXDE	                ((uint32_t)1<<(CAN_IER_CANTXDE_POS))
#define CAN_IER_CANRXDE	                ((uint32_t)1<<(CAN_IER_CANRXDE_POS))
#define	CAN_IER_CANRFIE					((uint32_t)1<<(CAN_IER_CANRFIE_POS))
#define CAN_IER_CANRXIC                 ((uint32_t)1<<(CAN_IER_CANRXIC_POS))
#define CAN_IER_BOFFIE                  ((uint32_t)1<<(CAN_IER_BOFFIE_POS))
#define CAN_IER_CANTXIC                 ((uint32_t)1<<(CAN_IER_CANTXIC_POS))
#define CAN_IER_EAIC                    ((uint32_t)1<<(CAN_IER_EAIC_POS))
#define CAN_IER_DOVFIC                  ((uint32_t)1<<(CAN_IER_DOVFIC_POS))
#define CAN_IER_WUIC                    ((uint32_t)1<<(CAN_IER_WUIC_POS))
#define CAN_IER_ENIC                    ((uint32_t)1<<(CAN_IER_ENIC_POS))
#define CAN_IER_ALIC                    ((uint32_t)1<<(CAN_IER_ALIC_POS))
#define CAN_IER_BEIC                    ((uint32_t)1<<(CAN_IER_BEIC_POS))
#define CAN_IER_BOFFIC                  ((uint32_t)1<<(CAN_IER_BOFFIC_POS))

/* CAN_IFR  λ*/
#define CAN_IFR_CANRXIF_POS             (0)
#define CAN_IFR_CANTXIF_POS             (1)
#define CAN_IFR_EAIF_POS                (2)
#define CAN_IFR_DOVFIF_POS              (3)
#define CAN_IFR_WUIF_POS                (4)
#define CAN_IFR_ENIF_POS                (5)
#define CAN_IFR_ALIF_POS                (6)
#define CAN_IFR_BEIF_POS                (7)
#define CAN_IFR_CANTXDE_POS             (8)
#define CAN_IFR_CANRXDE_POS             (9)
#define CAN_IFR_CANRFIF_POS				(10)
#define CAN_IFR_BOFFIF_POS				(12)
#define CAN_IFR_CANRXIF                 ((uint32_t)1<<(CAN_IFR_CANRXIF_POS))
#define CAN_IFR_CANTXIF                 ((uint32_t)1<<(CAN_IFR_CANTXIF_POS))
#define CAN_IFR_EAIF                    ((uint32_t)1<<(CAN_IFR_EAIF_POS))
#define CAN_IFR_DOVFIF                  ((uint32_t)1<<(CAN_IFR_DOVFIF_POS))
#define CAN_IFR_WUIF                    ((uint32_t)1<<(CAN_IFR_WUIF_POS))
#define CAN_IFR_ENIF                    ((uint32_t)1<<(CAN_IFR_ENIF_POS))
#define CAN_IFR_ALIF                    ((uint32_t)1<<(CAN_IFR_ALIF_POS))
#define CAN_IFR_BEIF                    ((uint32_t)1<<(CAN_IFR_BEIF_POS))
#define CAN_IFR_CANTXDE	                ((uint32_t)1<<(CAN_IFR_CANTXDE_POS))
#define CAN_IFR_CANRXDE	                ((uint32_t)1<<(CAN_IFR_CANRXDE_POS))
#define	CAN_IFR_CANRFIF					((uint32_t)1<<(CAN_IFR_CANRFIF_POS))
#define	CAN_IFR_BOFFIF					((uint32_t)1<<(CAN_IFR_BOFFIF_POS))

/*  (CAN) */

#endif

#if 1										/* CANFD */

/* ----------------------------------------------------------------------------
   -- ǿͿߣCANFD
   ---------------------------------------------------------------------------- */

/* CANFD - Ĵڴṹ */
typedef struct CANFD_MenMap
{
	volatile 	   uint32_t 	CTLR0;   		/* CANFDƼĴ0,ƫƣ0x000 */
	volatile 	   uint32_t 	BRGR;   		/* CANFDʼĴ,ƫƣ0x004 */
	volatile const uint32_t 	RCR;      		/* CANFD¼Ĵ,ƫƣ0x008 */
	volatile 	   uint32_t 	EROR;   		/* CANFDĴ,ƫƣ0x00C */
	volatile 	   uint32_t 	NOUSE1;   		/* ռλ                                                                  */
	volatile 	   uint32_t 	MSKR;   		/* CANFDμĴ,ƫƣ0x014 */
	volatile 	   uint32_t 	IER;   		    /* CANFDжʹܼĴ,ƫƣ0x018 */
	volatile 	   uint32_t 	IFR;   		    /* CANFDжϱ־Ĵ,ƫƣ0x01C */
	volatile const uint32_t  	RX_SET1;        /* CANFDݽջĴ0,ƫƣ0x020 */
	union
	{
		struct
		{
			uint8_t  RX_SET2_1;
			uint8_t  RX_SET2_2;
			uint16_t  RX_SET2_34;
		};
		struct
		{
			uint32_t RX_SET2;
		};

	};
	union
	{
		volatile const uint8_t  	RXDATA[64];
		volatile const uint32_t  	RXDATA_32[16];
	};
	volatile 	   uint32_t 	TIMER;   		/* ʱ,ƫƣ0x068 */
	volatile const uint32_t 	CRC;      		/* FLEXCRCĴ,ƫƣ0x06C */
	volatile 	   uint32_t 	NOUSE2;   		/* ռλ                                                                     */
	volatile 	   uint32_t 	CTLR1;   		/* CANFDƼĴ1,ƫƣ0x074 */
	volatile const uint32_t 	AMSTA;      	/* CANFDٲƥ״̬Ĵ,ƫƣ0x078 */

}CANFD_SFRMap;

/* ----------------------------------------------------------------------------
   -- CANFD - Ĵں
   ---------------------------------------------------------------------------- */

/* CANFD - Ĵڵַ */
#define CANFD6_ADDR                       ((uint32_t)0x40002E80)
#define CANFD7_ADDR                       ((uint32_t)0x40002F00)
#define CANFD6_SFR						((CANFD_SFRMap *)CANFD6_ADDR)
#define CANFD7_SFR						((CANFD_SFRMap *)CANFD7_ADDR)

/* CANFD - Ĵ */
#define	CANFD6_CTLR0						(CANFD6_SFR->CTLR0)
#define	CANFD6_BRGR						(CANFD6_SFR->BRGR)
#define	CANFD6_RCR						(CANFD6_SFR->RCR)
#define	CANFD6_EROR						(CANFD6_SFR->EROR)
#define	CANFD6_MSKR						(CANFD6_SFR->MSKR)
#define	CANFD6_IER				        (CANFD6_SFR->IER)
#define	CANFD6_IFR				        (CANFD6_SFR->IFR)
#define	CANFD6_RXDATA0			        (CANFD6_SFR->RXDATA0)
#define	CANFD6_RXDATA1			        (CANFD6_SFR->RXDATA1)
#define	CANFD6_RXDATA2			        (CANFD6_SFR->RXDATA2)
#define	CANFD6_RXDATA3			        (CANFD6_SFR->RXDATA3)
#define	CANFD6_RXDATA4			        (CANFD6_SFR->RXDATA4)
#define	CANFD6_RXDATA5			        (CANFD6_SFR->RXDATA5)
#define	CANFD6_RXDATA6			        (CANFD6_SFR->RXDATA6)
#define	CANFD6_RXDATA7			        (CANFD6_SFR->RXDATA7)
#define	CANFD6_RXDATA8			        (CANFD6_SFR->RXDATA8)
#define	CANFD6_RXDATA9			        (CANFD6_SFR->RXDATA9)
#define	CANFD6_RXDATA10			        (CANFD6_SFR->RXDATA10)
#define	CANFD6_RXDATA11			        (CANFD6_SFR->RXDATA11)
#define	CANFD6_RXDATA12			        (CANFD6_SFR->RXDATA12)
#define	CANFD6_RXDATA13			        (CANFD6_SFR->RXDATA13)
#define	CANFD6_RXDATA14			        (CANFD6_SFR->RXDATA14)
#define	CANFD6_RXDATA15			        (CANFD6_SFR->RXDATA15)
#define	CANFD6_RXDATA16			        (CANFD6_SFR->RXDATA16)
#define	CANFD6_RXDATA17			        (CANFD6_SFR->RXDATA17)
#define	CANFD6_TIMER			            (CANFD6_SFR->TIMER)
#define	CANFD6_CRC				        (CANFD6_SFR->CRC)
#define	CANFD6_CTLR1			            (CANFD6_SFR->CTLR1)
#define	CANFD6_AMSTA			            (CANFD6_SFR->AMSTA)
#define	CANFD7_CTLR0						(CANFD7_SFR->CTLR0)
#define	CANFD7_BRGR						(CANFD7_SFR->BRGR)
#define	CANFD7_RCR						(CANFD7_SFR->RCR)
#define	CANFD7_EROR						(CANFD7_SFR->EROR)
#define	CANFD7_MSKR						(CANFD7_SFR->MSKR)
#define	CANFD7_IER				        (CANFD7_SFR->IER)
#define	CANFD7_IFR				        (CANFD7_SFR->IFR)
#define	CANFD7_RXDATA0			        (CANFD7_SFR->RXDATA0)
#define	CANFD7_RXDATA1			        (CANFD7_SFR->RXDATA1)
#define	CANFD7_RXDATA2			        (CANFD7_SFR->RXDATA2)
#define	CANFD7_RXDATA3			        (CANFD7_SFR->RXDATA3)
#define	CANFD7_RXDATA4			        (CANFD7_SFR->RXDATA4)
#define	CANFD7_RXDATA5			        (CANFD7_SFR->RXDATA5)
#define	CANFD7_RXDATA6			        (CANFD7_SFR->RXDATA6)
#define	CANFD7_RXDATA7			        (CANFD7_SFR->RXDATA7)
#define	CANFD7_RXDATA8			        (CANFD7_SFR->RXDATA8)
#define	CANFD7_RXDATA9			        (CANFD7_SFR->RXDATA9)
#define	CANFD7_RXDATA10			        (CANFD7_SFR->RXDATA10)
#define	CANFD7_RXDATA11			        (CANFD7_SFR->RXDATA11)
#define	CANFD7_RXDATA12			        (CANFD7_SFR->RXDATA12)
#define	CANFD7_RXDATA13			        (CANFD7_SFR->RXDATA13)
#define	CANFD7_RXDATA14			        (CANFD7_SFR->RXDATA14)
#define	CANFD7_RXDATA15			        (CANFD7_SFR->RXDATA15)
#define	CANFD7_RXDATA16			        (CANFD7_SFR->RXDATA16)
#define	CANFD7_RXDATA17			        (CANFD7_SFR->RXDATA17)
#define	CANFD7_TIMER			            (CANFD7_SFR->TIMER)
#define	CANFD7_CRC				        (CANFD7_SFR->CRC)
#define	CANFD7_CTLR1			            (CANFD7_SFR->CTLR1)
#define	CANFD7_AMSTA			            (CANFD7_SFR->AMSTA)

/* CANFD_CTLR0 λ */
#define	CANFD_CTLR0_RSMOD_POS				(0)
#define	CANFD_CTLR0_SILENT_POS			(1)
#define	CANFD_CTLR0_LBACK_POS				(2)
#define	CANFD_CTLR0_SLEEP_POS				(3)
#define	CANFD_CTLR0_ISOFDCANEN_POS		(4)
#define	CANFD_CTLR0_CANCKS0_POS			(5)
#define	CANFD_CTLR0_CANCKS1_POS			(6)
#define	CANFD_CTLR0_CANEN_POS				(7)
#define	CANFD_CTLR0_TXR_POS				(8)
#define	CANFD_CTLR0_ATX_POS				(9)
#define	CANFD_CTLR0_RELRX_POS				(10)
#define	CANFD_CTLR0_RELF_POS				(11)
#define	CANFD_CTLR0_MBSIZE0_POS			(12)
#define	CANFD_CTLR0_MBSIZE1_POS			(13)
#define	CANFD_CTLR0_FULLRXEN_POS			(14)
#define	CANFD_CTLR0_ANSWEREN_POS			(15)
#define	CANFD_CTLR0_RXBSTA_POS			(16)
#define	CANFD_CTLR0_DOSTA_POS				(17)
#define	CANFD_CTLR0_TXBSTA_POS			(18)
#define	CANFD_CTLR0_TCSTA_POS				(19)
#define	CANFD_CTLR0_RXSTA_POS				(20)
#define	CANFD_CTLR0_TXSTA_POS				(21)
#define	CANFD_CTLR0_CERROR_POS			(22)
#define	CANFD_CTLR0_BOFF_POS				(23)
#define	CANFD_CTLR0_CANRMC0_POS			(24)
#define	CANFD_CTLR0_CANRMC1_POS			(25)
#define	CANFD_CTLR0_CANRMC2_POS			(26)
#define	CANFD_CTLR0_CANRMC3_POS			(27)
#define	CANFD_CTLR0_CANRMC4_POS			(28)
#define	CANFD_CTLR0_CANRMC5_POS			(29)
#define	CANFD_CTLR0_CANRMC6_POS			(30)
#define	CANFD_CTLR0_TRIEN_POS				(31)
#define	CANFD_CTLR0_RSMOD					((uint32_t)1<<(CANFD_CTLR0_RSMOD_POS))
#define	CANFD_CTLR0_SILENT				((uint32_t)1<<(CANFD_CTLR0_SILENT_POS))
#define	CANFD_CTLR0_LBACK					((uint32_t)1<<(CANFD_CTLR0_LBACK_POS))
#define	CANFD_CTLR0_SLEEP					((uint32_t)1<<(CANFD_CTLR0_SLEEP_POS))
#define	CANFD_CTLR0_ISOFDCANEN			((uint32_t)1<<(CANFD_CTLR0_ISOFDCANEN_POS))
#define	CANFD_CTLR0_CANCKS				((uint32_t)0x03<<(CANFD_CTLR0_CANCKS0_POS))
#define	CANFD_CTLR0_CANCKS0				((uint32_t)1<<(CANFD_CTLR0_CANCKS0_POS))
#define	CANFD_CTLR0_CANCKS1				((uint32_t)1<<(CANFD_CTLR0_CANCKS1_POS))
#define	CANFD_CTLR0_CANEN					((uint32_t)1<<(CANFD_CTLR0_CANEN_POS))
#define	CANFD_CTLR0_TXR					((uint32_t)1<<(CANFD_CTLR0_TXR_POS))
#define	CANFD_CTLR0_ATX					((uint32_t)1<<(CANFD_CTLR0_ATX_POS))
#define	CANFD_CTLR0_RELRX					((uint32_t)1<<(CANFD_CTLR0_RELRX_POS))
#define	CANFD_CTLR0_RELF					((uint32_t)1<<(CANFD_CTLR0_RELF_POS))
#define	CANFD_CTLR0_MBSIZE				((uint32_t)0x03<<(CANFD_CTLR0_MBSIZE0_POS))
#define	CANFD_CTLR0_MBSIZE0				((uint32_t)1<<(CANFD_CTLR0_MBSIZE0_POS))
#define	CANFD_CTLR0_MBSIZE1				((uint32_t)1<<(CANFD_CTLR0_MBSIZE1_POS))
#define	CANFD_CTLR0_FULLRXEN				((uint32_t)1<<(CANFD_CTLR0_FULLRXEN_POS))
#define	CANFD_CTLR0_ANSWEREN				((uint32_t)1<<(CANFD_CTLR0_ANSWEREN_POS))
#define	CANFD_CTLR0_RXBSTA				((uint32_t)1<<(CANFD_CTLR0_RXBSTA_POS))
#define	CANFD_CTLR0_DOSTA					((uint32_t)1<<(CANFD_CTLR0_DOSTA_POS))
#define	CANFD_CTLR0_TXBSTA				((uint32_t)1<<(CANFD_CTLR0_TXBSTA_POS))
#define	CANFD_CTLR0_TCSTA					((uint32_t)1<<(CANFD_CTLR0_TCSTA_POS))
#define	CANFD_CTLR0_RXSTA					((uint32_t)1<<(CANFD_CTLR0_RXSTA_POS))
#define	CANFD_CTLR0_TXSTA					((uint32_t)1<<(CANFD_CTLR0_TXSTA_POS))
#define	CANFD_CTLR0_CERROR				((uint32_t)1<<(CANFD_CTLR0_CERROR_POS))
#define	CANFD_CTLR0_BOFF					((uint32_t)1<<(CANFD_CTLR0_BOFF_POS))
#define	CANFD_CTLR0_CANRMC				((uint32_t)0x7F<<(CANFD_CTLR0_CANRMC0_POS))
#define	CANFD_CTLR0_CANRMC0				((uint32_t)1<<(CANFD_CTLR0_CANRMC0_POS))
#define	CANFD_CTLR0_CANRMC1				((uint32_t)1<<(CANFD_CTLR0_CANRMC1_POS))
#define	CANFD_CTLR0_CANRMC2				((uint32_t)1<<(CANFD_CTLR0_CANRMC2_POS))
#define	CANFD_CTLR0_CANRMC3				((uint32_t)1<<(CANFD_CTLR0_CANRMC3_POS))
#define	CANFD_CTLR0_CANRMC4				((uint32_t)1<<(CANFD_CTLR0_CANRMC4_POS))
#define	CANFD_CTLR0_CANRMC5				((uint32_t)1<<(CANFD_CTLR0_CANRMC5_POS))
#define	CANFD_CTLR0_CANRMC6				((uint32_t)1<<(CANFD_CTLR0_CANRMC6_POS))
#define	CANFD_CTLR0_TRIEN					((uint32_t)1<<(CANFD_CTLR0_TRIEN_POS))

/* CANFDx_CTLR1λ */
#define	CANFD_CTLR1_AMCKS0_POS			(0)
#define	CANFD_CTLR1_AMCKS1_POS			(1)
#define	CANFD_CTLR1_RXMUX0_POS			(2)
#define	CANFD_CTLR1_RXMUX1_POS			(3)
#define	CANFD_CTLR1_RXMUX2_POS			(4)
#define	CANFD_CTLR1_RXMUX3_POS			(5)
#define	CANFD_CTLR1_RXMUX4_POS			(6)
#define	CANFD_CTLR1_RXMUX5_POS			(7)
#define	CANFD_CTLR1_RXMUX6_POS			(8)
#define	CANFD_CTLR1_ST_POS				(9)
#define	CANFD_CTLR1_FTCLKS_POS			(10)
#define	CANFD_CTLR1_TSYN_POS				(11)
#define	CANFD_CTLR1_AMCKS					((uint32_t)0x03<<(CANFD_CTLR1_AMCKS0_POS))
#define	CANFD_CTLR1_AMCKS0				((uint32_t)1<<(CANFD_CTLR1_AMCKS0_POS))
#define	CANFD_CTLR1_AMCKS1				((uint32_t)1<<(CANFD_CTLR1_AMCKS1_POS))
#define	CANFD_CTLR1_RXMUX					((uint32_t)0x7F<<(CANFD_CTLR1_RXMUX0_POS))
#define	CANFD_CTLR1_RXMUX0				((uint32_t)1<<(CANFD_CTLR1_RXMUX0_POS))
#define	CANFD_CTLR1_RXMUX1				((uint32_t)1<<(CANFD_CTLR1_RXMUX1_POS))
#define	CANFD_CTLR1_RXMUX2				((uint32_t)1<<(CANFD_CTLR1_RXMUX2_POS))
#define	CANFD_CTLR1_RXMUX3				((uint32_t)1<<(CANFD_CTLR1_RXMUX3_POS))
#define	CANFD_CTLR1_RXMUX4				((uint32_t)1<<(CANFD_CTLR1_RXMUX4_POS))
#define	CANFD_CTLR1_RXMUX5				((uint32_t)1<<(CANFD_CTLR1_RXMUX5_POS))
#define	CANFD_CTLR1_RXMUX6				((uint32_t)1<<(CANFD_CTLR1_RXMUX6_POS))
#define	CANFD_CTLR1_ST					((uint32_t)1<<(CANFD_CTLR1_ST_POS))
#define	CANFD_CTLR1_FTCLKS				((uint32_t)1<<(CANFD_CTLR1_FTCLKS_POS))
#define	CANFD_CTLR1_TSYN					((uint32_t)1<<(CANFD_CTLR1_TSYN_POS))

/* CANFDx_BRGRλ */
#define	CANFD_BRGR_CANBRP0_POS			(0)
#define	CANFD_BRGR_CANBRP1_POS			(1)
#define	CANFD_BRGR_CANBRP2_POS			(2)
#define	CANFD_BRGR_CANBRP3_POS			(3)
#define	CANFD_BRGR_CANBRP4_POS			(4)
#define	CANFD_BRGR_CANBRP5_POS			(5)
#define	CANFD_BRGR_SJW0_POS				(6)
#define	CANFD_BRGR_SJW1_POS				(7)
#define	CANFD_BRGR_TSEG1_0_POS			(8)
#define	CANFD_BRGR_TSEG1_1_POS			(9)
#define	CANFD_BRGR_TSEG1_2_POS			(10)
#define	CANFD_BRGR_TSEG1_3_POS			(11)
#define	CANFD_BRGR_TSEG2_0_POS			(12)
#define	CANFD_BRGR_TSEG2_1_POS			(13)
#define	CANFD_BRGR_TSEG2_2_POS			(14)
#define	CANFD_BRGR_SAM_POS				(15)
#define	CANFD_BRGR_BRSBRP0_POS			(16)
#define	CANFD_BRGR_BRSBRP1_POS			(17)
#define	CANFD_BRGR_BRSBRP2_POS			(18)
#define	CANFD_BRGR_BRSBRP3_POS			(19)
#define	CANFD_BRGR_BRSBRP4_POS			(20)
#define	CANFD_BRGR_BRSBRP5_POS			(21)
#define	CANFD_BRGR_CANBRP					((uint32_t)0x3F<<(CANFD_BRGR_CANBRP0_POS))
#define	CANFD_BRGR_CANBRP0				((uint32_t)1<<(CANFD_BRGR_CANBRP0_POS))
#define	CANFD_BRGR_CANBRP1				((uint32_t)1<<(CANFD_BRGR_CANBRP1_POS))
#define	CANFD_BRGR_CANBRP2				((uint32_t)1<<(CANFD_BRGR_CANBRP2_POS))
#define	CANFD_BRGR_CANBRP3				((uint32_t)1<<(CANFD_BRGR_CANBRP3_POS))
#define	CANFD_BRGR_CANBRP4				((uint32_t)1<<(CANFD_BRGR_CANBRP4_POS))
#define	CANFD_BRGR_CANBRP5				((uint32_t)1<<(CANFD_BRGR_CANBRP5_POS))
#define	CANFD_BRGR_SJW					((uint32_t)0x03<<(CANFD_BRGR_SJW0_POS))
#define	CANFD_BRGR_SJW0					((uint32_t)1<<(CANFD_BRGR_SJW0_POS))
#define	CANFD_BRGR_SJW1					((uint32_t)1<<(CANFD_BRGR_SJW1_POS))
#define	CANFD_BRGR_TSEG1					((uint32_t)0x0F<<(CANFD_BRGR_TSEG1_0_POS))
#define	CANFD_BRGR_TSEG1_0				((uint32_t)1<<(CANFD_BRGR_TSEG1_0_POS))
#define	CANFD_BRGR_TSEG1_1				((uint32_t)1<<(CANFD_BRGR_TSEG1_1_POS))
#define	CANFD_BRGR_TSEG1_2				((uint32_t)1<<(CANFD_BRGR_TSEG1_2_POS))
#define	CANFD_BRGR_TSEG1_3				((uint32_t)1<<(CANFD_BRGR_TSEG1_3_POS))
#define	CANFD_BRGR_TSEG2					((uint32_t)0x07<<(CANFD_BRGR_TSEG2_0_POS))
#define	CANFD_BRGR_TSEG2_0				((uint32_t)1<<(CANFD_BRGR_TSEG2_0_POS))
#define	CANFD_BRGR_TSEG2_1				((uint32_t)1<<(CANFD_BRGR_TSEG2_1_POS))
#define	CANFD_BRGR_TSEG2_2				((uint32_t)1<<(CANFD_BRGR_TSEG2_2_POS))
#define	CANFD_BRGR_SAM					((uint32_t)1<<(CANFD_BRGR_SAM_POS))
#define	CANFD_BRGR_BRSBRP					((uint32_t)0x3F<<(CANFD_BRGR_BRSBRP0_POS))
#define	CANFD_BRGR_BRSBRP0				((uint32_t)1<<(CANFD_BRGR_BRSBRP0_POS))
#define	CANFD_BRGR_BRSBRP1				((uint32_t)1<<(CANFD_BRGR_BRSBRP1_POS))
#define	CANFD_BRGR_BRSBRP2				((uint32_t)1<<(CANFD_BRGR_BRSBRP2_POS))
#define	CANFD_BRGR_BRSBRP3				((uint32_t)1<<(CANFD_BRGR_BRSBRP3_POS))
#define	CANFD_BRGR_BRSBRP4				((uint32_t)1<<(CANFD_BRGR_BRSBRP4_POS))
#define	CANFD_BRGR_BRSBRP5				((uint32_t)1<<(CANFD_BRGR_BRSBRP5_POS))

/* CANFDx_RCRλ */
#define	CANFD_RCR_CANALC0_POS				(0)
#define	CANFD_RCR_CANALC1_POS				(1)
#define	CANFD_RCR_CANALC2_POS				(2)
#define	CANFD_RCR_CANALC3_POS				(3)
#define	CANFD_RCR_CANALC4_POS				(4)
#define	CANFD_RCR_CANSEG0_POS				(8)
#define	CANFD_RCR_CANSEG1_POS				(9)
#define	CANFD_RCR_CANSEG2_POS				(10)
#define	CANFD_RCR_CANSEG3_POS				(11)
#define	CANFD_RCR_CANSEG4_POS				(12)
#define	CANFD_RCR_CANDIR_POS				(13)
#define	CANFD_RCR_CANERRC0_POS			(14)
#define	CANFD_RCR_CANERRC1_POS			(15)
#define	CANFD_RCR_CANALC					((uint32_t)0x1F<<(CANFD_RCR_CANALC0_POS))
#define	CANFD_RCR_CANALC0					((uint32_t)1<<(CANFD_RCR_CANALC0_POS))
#define	CANFD_RCR_CANALC1					((uint32_t)1<<(CANFD_RCR_CANALC1_POS))
#define	CANFD_RCR_CANALC2					((uint32_t)1<<(CANFD_RCR_CANALC2_POS))
#define	CANFD_RCR_CANALC3					((uint32_t)1<<(CANFD_RCR_CANALC3_POS))
#define	CANFD_RCR_CANALC4					((uint32_t)1<<(CANFD_RCR_CANALC4_POS))
#define	CANFD_RCR_CANSEG					((uint32_t)0x1F<<(CANFD_RCR_CANSEG0_POS))
#define	CANFD_RCR_CANSEG0					((uint32_t)1<<(CANFD_RCR_CANSEG0_POS))
#define	CANFD_RCR_CANSEG1					((uint32_t)1<<(CANFD_RCR_CANSEG1_POS))
#define	CANFD_RCR_CANSEG2					((uint32_t)1<<(CANFD_RCR_CANSEG2_POS))
#define	CANFD_RCR_CANSEG3					((uint32_t)1<<(CANFD_RCR_CANSEG3_POS))
#define	CANFD_RCR_CANSEG4					((uint32_t)1<<(CANFD_RCR_CANSEG4_POS))
#define	CANFD_RCR_CANDIR					((uint32_t)1<<(CANFD_RCR_CANDIR_POS))
#define	CANFD_RCR_CANERRC					((uint32_t)0x03<<(CANFD_RCR_CANERRC0_POS))
#define	CANFD_RCR_CANERRC0				((uint32_t)1<<(CANFD_RCR_CANERRC0_POS))
#define	CANFD_RCR_CANERRC1				((uint32_t)1<<(CANFD_RCR_CANERRC1_POS))

/* CANFDx_ERORλ */
#define	CANFD_EROR_CANRXE0_POS			(0)
#define	CANFD_EROR_CANRXE1_POS			(1)
#define	CANFD_EROR_CANRXE2_POS			(2)
#define	CANFD_EROR_CANRXE3_POS			(3)
#define	CANFD_EROR_CANRXE4_POS			(4)
#define	CANFD_EROR_CANRXE5_POS			(5)
#define	CANFD_EROR_CANRXE6_POS			(6)
#define	CANFD_EROR_CANRXE7_POS			(7)
#define	CANFD_EROR_CANTXE0_POS			(8)
#define	CANFD_EROR_CANTXE1_POS			(9)
#define	CANFD_EROR_CANTXE2_POS			(10)
#define	CANFD_EROR_CANTXE3_POS			(11)
#define	CANFD_EROR_CANTXE4_POS			(12)
#define	CANFD_EROR_CANTXE5_POS			(13)
#define	CANFD_EROR_CANTXE6_POS			(14)
#define	CANFD_EROR_CANTXE7_POS			(15)
#define	CANFD_EROR_CANEWL0_POS			(16)
#define	CANFD_EROR_CANEWL1_POS			(17)
#define	CANFD_EROR_CANEWL2_POS			(18)
#define	CANFD_EROR_CANEWL3_POS			(19)
#define	CANFD_EROR_CANEWL4_POS			(20)
#define	CANFD_EROR_CANEWL5_POS			(21)
#define	CANFD_EROR_CANEWL6_POS			(22)
#define	CANFD_EROR_CANEWL7_POS			(23)
#define	CANFD_EROR_CANRXE					((uint32_t)0xFF<<(CANFD_EROR_CANRXE0_POS))
#define	CANFD_EROR_CANRXE0				((uint32_t)1<<(CANFD_EROR_CANRXE0_POS))
#define	CANFD_EROR_CANRXE1				((uint32_t)1<<(CANFD_EROR_CANRXE1_POS))
#define	CANFD_EROR_CANRXE2				((uint32_t)1<<(CANFD_EROR_CANRXE2_POS))
#define	CANFD_EROR_CANRXE3				((uint32_t)1<<(CANFD_EROR_CANRXE3_POS))
#define	CANFD_EROR_CANRXE4				((uint32_t)1<<(CANFD_EROR_CANRXE4_POS))
#define	CANFD_EROR_CANRXE5				((uint32_t)1<<(CANFD_EROR_CANRXE5_POS))
#define	CANFD_EROR_CANRXE6				((uint32_t)1<<(CANFD_EROR_CANRXE6_POS))
#define	CANFD_EROR_CANRXE7				((uint32_t)1<<(CANFD_EROR_CANRXE7_POS))
#define	CANFD_EROR_CANTXE					((uint32_t)0xFF<<(CANFD_EROR_CANTXE0_POS))
#define	CANFD_EROR_CANTXE0				((uint32_t)1<<(CANFD_EROR_CANTXE0_POS))
#define	CANFD_EROR_CANTXE1				((uint32_t)1<<(CANFD_EROR_CANTXE1_POS))
#define	CANFD_EROR_CANTXE2				((uint32_t)1<<(CANFD_EROR_CANTXE2_POS))
#define	CANFD_EROR_CANTXE3				((uint32_t)1<<(CANFD_EROR_CANTXE3_POS))
#define	CANFD_EROR_CANTXE4				((uint32_t)1<<(CANFD_EROR_CANTXE4_POS))
#define	CANFD_EROR_CANTXE5				((uint32_t)1<<(CANFD_EROR_CANTXE5_POS))
#define	CANFD_EROR_CANTXE6				((uint32_t)1<<(CANFD_EROR_CANTXE6_POS))
#define	CANFD_EROR_CANTXE7				((uint32_t)1<<(CANFD_EROR_CANTXE7_POS))
#define	CANFD_EROR_CANEWL					((uint32_t)0xFF<<(CANFD_EROR_CANEWL0_POS))
#define	CANFD_EROR_CANEWL0				((uint32_t)1<<(CANFD_EROR_CANEWL0_POS))
#define	CANFD_EROR_CANEWL1				((uint32_t)1<<(CANFD_EROR_CANEWL1_POS))
#define	CANFD_EROR_CANEWL2				((uint32_t)1<<(CANFD_EROR_CANEWL2_POS))
#define	CANFD_EROR_CANEWL3				((uint32_t)1<<(CANFD_EROR_CANEWL3_POS))
#define	CANFD_EROR_CANEWL4				((uint32_t)1<<(CANFD_EROR_CANEWL4_POS))
#define	CANFD_EROR_CANEWL5				((uint32_t)1<<(CANFD_EROR_CANEWL5_POS))
#define	CANFD_EROR_CANEWL6				((uint32_t)1<<(CANFD_EROR_CANEWL6_POS))
#define	CANFD_EROR_CANEWL7				((uint32_t)1<<(CANFD_EROR_CANEWL7_POS))

/* CANFDx_MASKλ */
#define	CANFD_MASK_MASK0_POS				(0)
#define	CANFD_MASK_MASK1_POS				(1)
#define	CANFD_MASK_MASK2_POS				(2)
#define	CANFD_MASK_MASK3_POS				(3)
#define	CANFD_MASK_MASK4_POS				(4)
#define	CANFD_MASK_MASK5_POS				(5)
#define	CANFD_MASK_MASK6_POS				(6)
#define	CANFD_MASK_MASK7_POS				(7)
#define	CANFD_MASK_MASK8_POS				(8)
#define	CANFD_MASK_MASK9_POS				(9)
#define	CANFD_MASK_MASK10_POS				(10)
#define	CANFD_MASK_MASK11_POS				(11)
#define	CANFD_MASK_MASK12_POS				(12)
#define	CANFD_MASK_MASK13_POS				(13)
#define	CANFD_MASK_MASK14_POS				(14)
#define	CANFD_MASK_MASK15_POS				(15)
#define	CANFD_MASK_MASK16_POS				(16)
#define	CANFD_MASK_MASK17_POS				(17)
#define	CANFD_MASK_MASK18_POS				(18)
#define	CANFD_MASK_MASK19_POS				(19)
#define	CANFD_MASK_MASK20_POS				(20)
#define	CANFD_MASK_MASK21_POS				(21)
#define	CANFD_MASK_MASK22_POS				(22)
#define	CANFD_MASK_MASK23_POS				(23)
#define	CANFD_MASK_MASK24_POS				(24)
#define	CANFD_MASK_MASK25_POS				(25)
#define	CANFD_MASK_MASK26_POS				(26)
#define	CANFD_MASK_MASK27_POS				(27)
#define	CANFD_MASK_MASK28_POS				(28)
#define	CANFD_MASK_MASK29_POS				(29)
#define	CANFD_MASK_MASK30_POS				(30)
#define	CANFD_MASK_MASK31_POS				(31)
#define	CANFD_MASK_MASK				    ((uint32_t)0xFFFFFFFF<<(CANFD_MASK_MASK0_POS))
#define	CANFD_MASK_MASK0				    ((uint32_t)1<<(CANFD_MASK_MASK0_POS))
#define	CANFD_MASK_MASK1				    ((uint32_t)1<<(CANFD_MASK_MASK1_POS))
#define	CANFD_MASK_MASK2				    ((uint32_t)1<<(CANFD_MASK_MASK2_POS))
#define	CANFD_MASK_MASK3				    ((uint32_t)1<<(CANFD_MASK_MASK3_POS))
#define	CANFD_MASK_MASK4				    ((uint32_t)1<<(CANFD_MASK_MASK4_POS))
#define	CANFD_MASK_MASK5				    ((uint32_t)1<<(CANFD_MASK_MASK5_POS))
#define	CANFD_MASK_MASK6				    ((uint32_t)1<<(CANFD_MASK_MASK6_POS))
#define	CANFD_MASK_MASK7				    ((uint32_t)1<<(CANFD_MASK_MASK7_POS))
#define	CANFD_MASK_MASK8				    ((uint32_t)1<<(CANFD_MASK_MASK8_POS))
#define	CANFD_MASK_MASK9				    ((uint32_t)1<<(CANFD_MASK_MASK9_POS))
#define	CANFD_MASK_MASK10				    ((uint32_t)1<<(CANFD_MASK_MASK10_POS))
#define	CANFD_MASK_MASK11				    ((uint32_t)1<<(CANFD_MASK_MASK11_POS))
#define	CANFD_MASK_MASK12				    ((uint32_t)1<<(CANFD_MASK_MASK12_POS))
#define	CANFD_MASK_MASK13				    ((uint32_t)1<<(CANFD_MASK_MASK13_POS))
#define	CANFD_MASK_MASK14				    ((uint32_t)1<<(CANFD_MASK_MASK14_POS))
#define	CANFD_MASK_MASK15				    ((uint32_t)1<<(CANFD_MASK_MASK15_POS))
#define	CANFD_MASK_MASK16				    ((uint32_t)1<<(CANFD_MASK_MASK16_POS))
#define	CANFD_MASK_MASK17				    ((uint32_t)1<<(CANFD_MASK_MASK17_POS))
#define	CANFD_MASK_MASK18				    ((uint32_t)1<<(CANFD_MASK_MASK18_POS))
#define	CANFD_MASK_MASK19				    ((uint32_t)1<<(CANFD_MASK_MASK19_POS))
#define	CANFD_MASK_MASK20				    ((uint32_t)1<<(CANFD_MASK_MASK20_POS))
#define	CANFD_MASK_MASK21				    ((uint32_t)1<<(CANFD_MASK_MASK21_POS))
#define	CANFD_MASK_MASK22				    ((uint32_t)1<<(CANFD_MASK_MASK22_POS))
#define	CANFD_MASK_MASK23				    ((uint32_t)1<<(CANFD_MASK_MASK23_POS))
#define	CANFD_MASK_MASK24				    ((uint32_t)1<<(CANFD_MASK_MASK24_POS))
#define	CANFD_MASK_MASK25				    ((uint32_t)1<<(CANFD_MASK_MASK25_POS))
#define	CANFD_MASK_MASK26				    ((uint32_t)1<<(CANFD_MASK_MASK26_POS))
#define	CANFD_MASK_MASK27				    ((uint32_t)1<<(CANFD_MASK_MASK27_POS))
#define	CANFD_MASK_MASK28				    ((uint32_t)1<<(CANFD_MASK_MASK28_POS))
#define	CANFD_MASK_MASK29				    ((uint32_t)1<<(CANFD_MASK_MASK29_POS))
#define	CANFD_MASK_MASK30				    ((uint32_t)1<<(CANFD_MASK_MASK30_POS))
#define	CANFD_MASK_MASK31				    ((uint32_t)1<<(CANFD_MASK_MASK31_POS))

/* CANFDx_RXDATAλ */
#define	CANFD_RXDATA_RXDATA0_POS			(1)
#define	CANFD_RXDATA_RXDATA				((uint32_t)0xFFFFFFFF<<(CANFD_RXDATA_RXDATA0_POS))

/* CANFDx_TIMERλ */
#define	CANFD_TIMER_CANTIMER0_POS			(1)
#define	CANFD_TIMER_CANTIMER				((uint32_t)0xFFFF<<(CANFD_TIMER_CANTIMER0_POS))

/* CANFDx_CRCλ */
#define	CANFD_CRC_CRC0_POS				(0)
#define	CANFD_CRC_CRC					    ((uint32_t)0x1FFF<<(CANFD_CRC_CRC0_POS))

/* CANFDx_IERλ */
#define	CANFD_IER_CANRXIE_POS				(0)
#define	CANFD_IER_CANTXIE_POS				(1)
#define	CANFD_IER_EAIE_POS				(2)
#define	CANFD_IER_DOVFIE_POS				(3)
#define	CANFD_IER_WUIE_POS				(4)
#define	CANFD_IER_ENIE_POS				(5)
#define	CANFD_IER_ALIE_POS				(6)
#define	CANFD_IER_BEIE_POS				(7)
#define	CANFD_IER_CTXDE_POS				(8)
#define	CANFD_IER_CRXDE_POS				(9)
#define	CANFD_IER_RXBSTAIE_POS			(10)
#define	CANFD_IER_CANRXIC_POS				(16)
#define	CANFD_IER_CANTXIC_POS				(17)
#define	CANFD_IER_EAIC_POS				(18)
#define	CANFD_IER_DOVFIC_POS				(19)
#define	CANFD_IER_WUIC_POS				(20)
#define	CANFD_IER_ENIC_POS				(21)
#define	CANFD_IER_ALIC_POS				(22)
#define	CANFD_IER_BEIC_POS				(23)
#define	CANFD_IER_LPCANGPIOSEL0_POS		(30)
#define	CANFD_IER_CANRXIE				    ((uint32_t)1<<(CANFD_IER_CANRXIE_POS))
#define	CANFD_IER_CANTXIE				    ((uint32_t)1<<(CANFD_IER_CANTXIE_POS))
#define	CANFD_IER_EAIE				    ((uint32_t)1<<(CANFD_IER_EAIE_POS))
#define	CANFD_IER_DOVFIE				    ((uint32_t)1<<(CANFD_IER_DOVFIE_POS))
#define	CANFD_IER_WUIE				    ((uint32_t)1<<(CANFD_IER_WUIE_POS))
#define	CANFD_IER_ENIE				    ((uint32_t)1<<(CANFD_IER_ENIE_POS))
#define	CANFD_IER_ALIE				    ((uint32_t)1<<(CANFD_IER_ALIE_POS))
#define	CANFD_IER_BEIE				    ((uint32_t)1<<(CANFD_IER_BEIE_POS))
#define	CANFD_IER_CTXDE				    ((uint32_t)1<<(CANFD_IER_CTXDE_POS))
#define	CANFD_IER_CRXDE				    ((uint32_t)1<<(CANFD_IER_CRXDE_POS))
#define	CANFD_IER_RXBSTAIE			    ((uint32_t)1<<(CANFD_IER_RXBSTAIE_POS))
#define	CANFD_IER_CANRXIC				((uint32_t)1<<(CANFD_IER_CANRXIC_POS))
#define	CANFD_IER_CANTXIC				((uint32_t)1<<(CANFD_IER_CANTXIC_POS))
#define	CANFD_IER_EAIC				    ((uint32_t)1<<(CANFD_IER_EAIC_POS))
#define	CANFD_IER_DOVFIC				((uint32_t)1<<(CANFD_IER_DOVFIC_POS))
#define	CANFD_IER_WUIC				    ((uint32_t)1<<(CANFD_IER_WUIC_POS))
#define	CANFD_IER_ENIC				    ((uint32_t)1<<(CANFD_IER_ENIC_POS))
#define	CANFD_IER_ALIC				    ((uint32_t)1<<(CANFD_IER_ALIC_POS))
#define	CANFD_IER_BEIC				    ((uint32_t)1<<(CANFD_IER_BEIC_POS))
#define	CANFD_IER_LPCANGPIOSEL0		    ((uint32_t)1<<(CANFD_IER_LPCANGPIOSEL0_POS))

/* CANFDx_IFRλ */
#define	CANFD_IFR_CANRXIF_POS			(0)
#define	CANFD_IFR_CANTXIF_POS			(1)
#define	CANFD_IFR_EAIF_POS				(2)
#define	CANFD_IFR_DOVFIF_POS			(3)
#define	CANFD_IFR_WUIF_POS				(4)
#define	CANFD_IFR_ENIF_POS				(5)
#define	CANFD_IFR_ALIF_POS				(6)
#define	CANFD_IFR_BEIF_POS				(7)
#define	CANFD_IFR_CTXDF_POS				(8)
#define	CANFD_IFR_CRXDF_POS				(9)
#define	CANFD_IFR_RXBSTAIF_POS			(10)
#define	CANFD_IFR_CANRXIF				((uint32_t)1<<(CANFD_IFR_CANRXIF_POS))
#define	CANFD_IFR_CANTXIF				((uint32_t)1<<(CANFD_IFR_CANTXIF_POS))
#define	CANFD_IFR_EAIF					((uint32_t)1<<(CANFD_IFR_EAIF_POS))
#define	CANFD_IFR_DOVFIF				((uint32_t)1<<(CANFD_IFR_DOVFIF_POS))
#define	CANFD_IFR_WUIF					((uint32_t)1<<(CANFD_IFR_WUIF_POS))
#define	CANFD_IFR_ENIF					((uint32_t)1<<(CANFD_IFR_ENIF_POS))
#define	CANFD_IFR_ALIF					((uint32_t)1<<(CANFD_IFR_ALIF_POS))
#define	CANFD_IFR_BEIF					((uint32_t)1<<(CANFD_IFR_BEIF_POS))
#define	CANFD_IFR_CTXDF					((uint32_t)1<<(CANFD_IFR_CTXDF_POS))
#define	CANFD_IFR_CRXDF					((uint32_t)1<<(CANFD_IFR_CRXDF_POS))
#define	CANFD_IFR_RXBSTAIF				((uint32_t)1<<(CANFD_IFR_RXBSTAIF_POS))

/* CANFDx_AMSTAλ */
#define	CANFD_AMSTA_MATWINNER0_POS		(0)
#define	CANFD_AMSTA_MATWINNER1_POS		(1)
#define	CANFD_AMSTA_MATWINNER2_POS		(2)
#define	CANFD_AMSTA_MATWINNER3_POS		(3)
#define	CANFD_AMSTA_MATWINNER4_POS		(4)
#define	CANFD_AMSTA_MATWINNER5_POS		(5)
#define	CANFD_AMSTA_MATWINNER6_POS		(6)
#define	CANFD_AMSTA_MATWINNER7_POS		(7)
#define	CANFD_AMSTA_MATWINNER8_POS		(8)
#define	CANFD_AMSTA_MATSTA_POS			(9)
#define	CANFD_AMSTA_ARBWINNER0_POS		(16)
#define	CANFD_AMSTA_ARBWINNER1_POS		(17)
#define	CANFD_AMSTA_ARBWINNER2_POS		(18)
#define	CANFD_AMSTA_ARBWINNER3_POS		(19)
#define	CANFD_AMSTA_ARBWINNER4_POS		(20)
#define	CANFD_AMSTA_ARBWINNER5_POS		(21)
#define	CANFD_AMSTA_ARBWINNER6_POS		(22)
#define	CANFD_AMSTA_ARBWINNER7_POS		(23)
#define	CANFD_AMSTA_ARBWINNER8_POS		(24)
#define	CANFD_AMSTA_ARBSTA0_POS			(25)
#define	CANFD_AMSTA_ARBSTA1_POS			(26)
#define	CANFD_AMSTA_MATWINNER			((uint32_t)0x1FF<<(CANFD_AMSTA_MATWINNER0_POS))
#define	CANFD_AMSTA_MATWINNER0			((uint32_t)1<<(CANFD_AMSTA_MATWINNER0_POS))
#define	CANFD_AMSTA_MATWINNER1			((uint32_t)1<<(CANFD_AMSTA_MATWINNER1_POS))
#define	CANFD_AMSTA_MATWINNER2			((uint32_t)1<<(CANFD_AMSTA_MATWINNER2_POS))
#define	CANFD_AMSTA_MATWINNER3			((uint32_t)1<<(CANFD_AMSTA_MATWINNER3_POS))
#define	CANFD_AMSTA_MATWINNER4			((uint32_t)1<<(CANFD_AMSTA_MATWINNER4_POS))
#define	CANFD_AMSTA_MATWINNER5			((uint32_t)1<<(CANFD_AMSTA_MATWINNER5_POS))
#define	CANFD_AMSTA_MATWINNER6			((uint32_t)1<<(CANFD_AMSTA_MATWINNER6_POS))
#define	CANFD_AMSTA_MATWINNER7			((uint32_t)1<<(CANFD_AMSTA_MATWINNER7_POS))
#define	CANFD_AMSTA_MATWINNER8			((uint32_t)1<<(CANFD_AMSTA_MATWINNER8_POS))
#define	CANFD_AMSTA_MATSTA				((uint32_t)1<<(CANFD_AMSTA_MATSTA_POS))
#define	CANFD_AMSTA_ARBWINNER			((uint32_t)0x1FF<<(CANFD_AMSTA_ARBWINNER0_POS))
#define	CANFD_AMSTA_ARBWINNER0			((uint32_t)1<<(CANFD_AMSTA_ARBWINNER0_POS))
#define	CANFD_AMSTA_ARBWINNER1			((uint32_t)1<<(CANFD_AMSTA_ARBWINNER1_POS))
#define	CANFD_AMSTA_ARBWINNER2			((uint32_t)1<<(CANFD_AMSTA_ARBWINNER2_POS))
#define	CANFD_AMSTA_ARBWINNER3			((uint32_t)1<<(CANFD_AMSTA_ARBWINNER3_POS))
#define	CANFD_AMSTA_ARBWINNER4			((uint32_t)1<<(CANFD_AMSTA_ARBWINNER4_POS))
#define	CANFD_AMSTA_ARBWINNER5			((uint32_t)1<<(CANFD_AMSTA_ARBWINNER5_POS))
#define	CANFD_AMSTA_ARBWINNER6			((uint32_t)1<<(CANFD_AMSTA_ARBWINNER6_POS))
#define	CANFD_AMSTA_ARBWINNER7			((uint32_t)1<<(CANFD_AMSTA_ARBWINNER7_POS))
#define	CANFD_AMSTA_ARBWINNER8			((uint32_t)1<<(CANFD_AMSTA_ARBWINNER8_POS))
#define	CANFD_AMSTA_ARBSTA0				((uint32_t)1<<(CANFD_AMSTA_ARBSTA0_POS))
#define	CANFD_AMSTA_ARBSTA1				((uint32_t)1<<(CANFD_AMSTA_ARBSTA1_POS))
/* ǿͿ (CANFD) */

#endif

#if 1										/* EXIC */


/* ----------------------------------------------------------------------------
   -- EXICӿ (EXIC)
   ---------------------------------------------------------------------------- */

/* EXICģĴڴṹ */
typedef struct EXIC_MemMap
{
    volatile uint32_t CTL0;          /* EXICݼĴ0, ƫ:0x00 */
    volatile uint32_t CTL1;          /* EXICݼĴ1, ƫ:0x04 */
    volatile uint32_t STATE;         /* EXICݼĴ2, ƫ:0x08 */
    		 uint32_t RESERVED1;     /* , ƫ:0x0C */
    volatile uint32_t WRITEBUF;      /* EXICݼĴ3, ƫ:0x10 */
    volatile uint32_t READBUF;       /* EXICݼĴ4, ƫ:0x14 */

}EXIC_SFRmap;

/* ----------------------------------------------------------------------------
   -- EXIC - Ĵں
   ---------------------------------------------------------------------------- */

/* EXIC - Ĵڵַ */
#define EXIC_ADDR                      ((uint32_t)0x40002800)
#define EXIC_SFR                       ((EXIC_SFRmap *) EXIC_ADDR)

/* EXIC - Ĵ */
#define EXIC_CTL0                      (EXIC_SFR->CTL0)
#define EXIC_CTL1                      (EXIC_SFR->CTL1)
#define EXIC_STATE                     (EXIC_SFR->STATE)
#define EXIC_WRITEBUF                  (EXIC_SFR->WRITEBUF)
#define EXIC_READBUF                   (EXIC_SFR->READBUF)

/* EXIC_CTL0 λ */
#define EXIC_CTL0_EXICEN_POS       		(0)
#define EXIC_CTL0_CSEN_POS              (1)
#define EXIC_CTL0_DCSEL_POS             (2)
#define EXIC_CTL0_WRITEEN_POS           (3)
#define EXIC_CTL0_READEN_POS            (4)
#define EXIC_CTL0_TDMAEN_POS            (8)
#define EXIC_CTL0_RDMAEN_POS            (9)
#define EXIC_CTL0_WENDIE_POS      	    (16)
#define EXIC_CTL0_RENDIE_POS            (17)
#define EXIC_CTL0_WRITE1EN_POS          (28)
#define EXIC_CTL0_READ1EN_POS           (29)
#define EXIC_CTL0_DATATR_POS            (30)
#define EXIC_CTL0_MODESEL_POS      	    (31)
#define EXIC_CTL0_EXICEN                ((uint32_t)1<<(EXIC_CTL0_EXICEN_POS))
#define EXIC_CTL0_CSEN                  ((uint32_t)1<<(EXIC_CTL0_CSEN_POS))
#define EXIC_CTL0_DCSEL                 ((uint32_t)1<<(EXIC_CTL0_DCSEL_POS))
#define EXIC_CTL0_WRITEEN               ((uint32_t)1<<(EXIC_CTL0_WRITEEN_POS))
#define EXIC_CTL0_READEN                ((uint32_t)1<<(EXIC_CTL0_READEN_POS))
#define EXIC_CTL0_TDMAEN                ((uint32_t)1<<(EXIC_CTL0_TDMAEN_POS))
#define EXIC_CTL0_RDMAEN                ((uint32_t)1<<(EXIC_CTL0_RDMAEN_POS))
#define EXIC_CTL0_WENDIN                ((uint32_t)1<<(EXIC_CTL0_WENDIE_POS))
#define EXIC_CTL0_RENDIE                ((uint32_t)1<<(EXIC_CTL0_RENDIE_POS))
#define EXIC_CTL0_WRITE1EN              ((uint32_t)1<<(EXIC_CTL0_WRITE1EN_POS))
#define EXIC_CTL0_READ1EN               ((uint32_t)1<<(EXIC_CTL0_READ1EN_POS))
#define EXIC_CTL0_DATATR                ((uint32_t)1<<(EXIC_CTL0_DATATR_POS))
#define EXIC_CTL0_MODESEL               ((uint32_t)1<<(EXIC_CTL0_MODESEL_POS))

/* EXIC_CTL1 λ */
#define EXIC_CTL1_EXICCS0_POS       	(0)
#define EXIC_CTL1_EXICCS1_POS           (1)
#define EXIC_CTL1_PULSEWIDTH0_POS       (4)
#define EXIC_CTL1_PULSEWIDTH1_POS       (5)
#define EXIC_CTL1_PULSEWIDTH2_POS       (6)
#define EXIC_CTL1_PULSEWIDTH3_POS       (7)
#define EXIC_CTL1_EXICCS                ((uint32_t)3<<(EXIC_CTL1_EXICCS0_POS))
#define EXIC_CTL1_EXICCS0               ((uint32_t)1<<(EXIC_CTL1_EXICCS0_POS))
#define EXIC_CTL1_EXICCS1               ((uint32_t)1<<(EXIC_CTL1_EXICCS1_POS))
#define EXIC_CTL1_PULSEWIDTH            ((uint32_t)0xf<<(EXIC_CTL1_PULSEWIDTH0_POS))
#define EXIC_CTL1_PULSEWIDTH0           ((uint32_t)1<<(EXIC_CTL1_PULSEWIDTH0_POS))
#define EXIC_CTL1_PULSEWIDTH1           ((uint32_t)1<<(EXIC_CTL1_PULSEWIDTH1_POS))
#define EXIC_CTL1_PULSEWIDTH2           ((uint32_t)1<<(EXIC_CTL1_PULSEWIDTH2_POS))
#define EXIC_CTL1_PULSEWIDTH3           ((uint32_t)1<<(EXIC_CTL1_PULSEWIDTH3_POS))

/* EXIC_STATE λ */
#define EXIC_STATE_WENDIF_POS       	(0)
#define EXIC_STATE_RENDIF_POS           (1)
#define EXIC_STATE_WENDIF               ((uint32_t)1<<(EXIC_STATE_WENDIF_POS))
#define EXIC_STATE_RENDIF               ((uint32_t)1<<(EXIC_STATE_RENDIF_POS))

/* EXIC_WRITEBUF λ */
#define EXIC_WRITEBUF_WRITEBUF0_POS		(0)
#define EXIC_WRITEBUF_WRITEBUF			((uint32_t)0x3FFFF<<(EXIC_WRITEBUF_WRITEBUF0_POS))

/* EXIC_READBUF λ */
#define EXIC_READBUF_READBUF0_POS		(0)
#define EXIC_READBUF_READBUF			((uint32_t)0x3FFFF<<(EXIC_READBUF_READBUF0_POS))
/* EXIC  */

#endif

#if 1										/* RTC */

/* ----------------------------------------------------------------------------
   -- ʵʱʱ (RTC)
   ---------------------------------------------------------------------------- */

/* RTC - Ĵڴṹ */
typedef struct RTC_MemMap
{
    volatile uint32_t CR;               /* RTCƼĴ, ƫ:0x0 */
    volatile uint32_t ALRA;             /* RTCAƼĴ, ƫ:0x4 */
    volatile uint32_t TMR;              /* RTCʱĴ, ƫ:0x8 */
    volatile uint32_t DTR;              /* RTCڼĴ, ƫ:0xC */
    volatile uint32_t ALRB;             /* RTCBƼĴ, ƫ:0x10 */
    volatile uint32_t TMER;             /* RTCʱĴ, ƫ:0x14 */
    volatile uint32_t TCR;              /* RTCʱƼĴ, ƫ:0x18 */
    volatile uint32_t IER;              /* RTCжʹܼĴ, ƫ:0x1C */
    volatile uint32_t IFR;              /* RTCжϱ־Ĵ, ƫ:0x20 */
    volatile uint32_t TMBR;             /* RTCʱ䱸ݼĴ, ƫ:0x24 */
    volatile uint32_t DTBR;             /* RTCڱݼĴ, ƫ:0x28 */
}RTC_SFRmap;

/* ----------------------------------------------------------------------------
   -- RTC - Ĵں
   ---------------------------------------------------------------------------- */

/* RTC - Ĵڵַ */
#define RTC_ADDR                        ((uint32_t)0x40000F00)
#define RTC_SFR                         ((RTC_SFRmap *) RTC_ADDR)

/* RTC - Ĵ */
#define RTC_CR                          (RTC_SFR->CR)
#define RTC_ALRA                        (RTC_SFR->ALRA)
#define RTC_TMR                         (RTC_SFR->TMR)
#define RTC_DTR                         (RTC_SFR->DTR)
#define RTC_ALRB                        (RTC_SFR->ALRB)
#define RTC_TMER                        (RTC_SFR->TMER)
#define RTC_TCR                         (RTC_SFR->TCR)
#define RTC_IER                         (RTC_SFR->IER)
#define RTC_IFR                         (RTC_SFR->IFR)
#define RTC_TMBR                        (RTC_SFR->TMBR)
#define RTC_DTBR                        (RTC_SFR->DTBR)

/* RTC_CR λ */
#define RTC_CR_RTCEN_POS                (0)
#define RTC_CR_RTCLD_POS                (1)
#define RTC_CR_RTOFF_POS                (2)
#define RTC_CR_CNF_POS                  (3)
#define RTC_CR_HT_POS                   (4)
#define RTC_CR_LIF_POS                  (5)
#define RTC_CR_RESET_POS                (6)
#define RTC_CR_RTCTSCH0_POS             (8)
#define RTC_CR_RTCTSCH1_POS             (9)
#define RTC_CR_RTCTSCH2_POS             (10)
#define RTC_CR_RTCTSCH3_POS             (11)
#define RTC_CR_RTCTSCH4_POS             (12)
#define RTC_CR_RTCTSCH5_POS             (13)
#define RTC_CR_RTCCLKS0_POS             (14)
#define RTC_CR_RTCCLKS1_POS             (15)
#define RTC_CR_RTCTT0_POS               (16)
#define RTC_CR_RTCTT1_POS               (17)
#define RTC_CR_RTCTT2_POS               (18)
#define RTC_CR_SUB1H_POS                (19)
#define RTC_CR_ADD1H_POS                (20)
#define RTC_CR_TSEN_POS                 (21)
#define RTC_CR_TSEDGE_POS               (22)
#define RTC_CR_TTOE_POS                 (23)
#define RTC_CR_RTCCAL0_POS              (24)
#define RTC_CR_RTCCAL1_POS              (25)
#define RTC_CR_RTCCAL2_POS              (26)
#define RTC_CR_RTCCAL3_POS              (27)
#define RTC_CR_RTCCAL4_POS              (28)
#define RTC_CR_RTCCAL5_POS              (29)
#define RTC_CR_RTCCAL6_POS              (30)
#define RTC_CR_RTCCAL7_POS              (31)
#define RTC_CR_RTCEN                    ((uint32_t)1<<(RTC_CR_RTCEN_POS))
#define RTC_CR_RTCLD                    ((uint32_t)1<<(RTC_CR_RTCLD_POS))
#define RTC_CR_RTOFF                    ((uint32_t)1<<(RTC_CR_RTOFF_POS))
#define RTC_CR_CNF                      ((uint32_t)1<<(RTC_CR_CNF_POS))
#define RTC_CR_HT                       ((uint32_t)1<<(RTC_CR_HT_POS))
#define RTC_CR_LIF                      ((uint32_t)1<<(RTC_CR_LIF_POS))
#define RTC_CR_RESET                    ((uint32_t)1<<(RTC_CR_RESET_POS))
#define RTC_CR_RTCTSCH                  ((uint32_t)0x3F<<(RTC_CR_RTCTSCH0_POS))
#define RTC_CR_RTCTSCH0                 ((uint32_t)1<<(RTC_CR_RTCTSCH0_POS))
#define RTC_CR_RTCTSCH1                 ((uint32_t)1<<(RTC_CR_RTCTSCH1_POS))
#define RTC_CR_RTCTSCH2                 ((uint32_t)1<<(RTC_CR_RTCTSCH2_POS))
#define RTC_CR_RTCTSCH3                 ((uint32_t)1<<(RTC_CR_RTCTSCH3_POS))
#define RTC_CR_RTCTSCH4                 ((uint32_t)1<<(RTC_CR_RTCTSCH4_POS))
#define RTC_CR_RTCTSCH5                 ((uint32_t)1<<(RTC_CR_RTCTSCH5_POS))
#define RTC_CR_RTCCLKS 	                ((uint32_t)0x03<<(RTC_CR_RTCCLKS0_POS))
#define RTC_CR_RTCCLKS0 	            ((uint32_t)1<<(RTC_CR_RTCCLKS0_POS))
#define RTC_CR_RTCCLKS1 	            ((uint32_t)1<<(RTC_CR_RTCCLKS1_POS))
#define RTC_CR_RTCTT                    ((uint32_t)7<<(RTC_CR_RTCTT0_POS))
#define RTC_CR_RTCTT0                   ((uint32_t)1<<(RTC_CR_RTCTT0_POS))
#define RTC_CR_RTCTT1                   ((uint32_t)1<<(RTC_CR_RTCTT1_POS))
#define RTC_CR_RTCTT2                   ((uint32_t)1<<(RTC_CR_RTCTT2_POS))
#define RTC_CR_SUB1H                    ((uint32_t)1<<(RTC_CR_SUB1H_POS))
#define RTC_CR_ADD1H                    ((uint32_t)1<<(RTC_CR_ADD1H_POS))
#define RTC_CR_TSEN                     ((uint32_t)1<<(RTC_CR_TSEN_POS))
#define RTC_CR_TSEDGE                   ((uint32_t)1<<(RTC_CR_TSEDGE_POS))
#define RTC_CR_TTOE                     ((uint32_t)1<<(RTC_CR_TTOE_POS))
#define RTC_CR_RTCCAL                   ((uint32_t)0xFF<<(RTC_CR_RTCCAL0_POS))
#define RTC_CR_RTCCAL0                  ((uint32_t)1<<(RTC_CR_RTCCAL0_POS))
#define RTC_CR_RTCCAL1                  ((uint32_t)1<<(RTC_CR_RTCCAL1_POS))
#define RTC_CR_RTCCAL2                  ((uint32_t)1<<(RTC_CR_RTCCAL2_POS))
#define RTC_CR_RTCCAL3                  ((uint32_t)1<<(RTC_CR_RTCCAL3_POS))
#define RTC_CR_RTCCAL4                  ((uint32_t)1<<(RTC_CR_RTCCAL4_POS))
#define RTC_CR_RTCCAL5                  ((uint32_t)1<<(RTC_CR_RTCCAL5_POS))
#define RTC_CR_RTCCAL6                  ((uint32_t)1<<(RTC_CR_RTCCAL6_POS))
#define RTC_CR_RTCCAL7                  ((uint32_t)1<<(RTC_CR_RTCCAL7_POS))

/* RTC_ALRA λ */
#define RTC_ALRA_ALRSA0_POS             (0)
#define RTC_ALRA_ALRSA1_POS             (1)
#define RTC_ALRA_ALRSA2_POS             (2)
#define RTC_ALRA_ALRSA3_POS             (3)
#define RTC_ALRA_ALRSA4_POS             (4)
#define RTC_ALRA_ALRSA5_POS             (5)
#define RTC_ALRA_ALRSA6_POS             (6)
#define RTC_ALRA_ASENA_POS              (7)
#define RTC_ALRA_ALRMA0_POS             (8)
#define RTC_ALRA_ALRMA1_POS             (9)
#define RTC_ALRA_ALRMA2_POS             (10)
#define RTC_ALRA_ALRMA3_POS             (11)
#define RTC_ALRA_ALRMA4_POS             (12)
#define RTC_ALRA_ALRMA5_POS             (13)
#define RTC_ALRA_ALRMA6_POS             (14)
#define RTC_ALRA_AMENA_POS              (15)
#define RTC_ALRA_ALRHA0_POS             (16)
#define RTC_ALRA_ALRHA1_POS             (17)
#define RTC_ALRA_ALRHA2_POS             (18)
#define RTC_ALRA_ALRHA3_POS             (19)
#define RTC_ALRA_ALRHA4_POS             (20)
#define RTC_ALRA_ALRHA5_POS             (21)
#define RTC_ALRA_AMPMA_POS              (22)
#define RTC_ALRA_AHENA_POS              (23)
#define RTC_ALRA_ALRWA0_POS             (24)
#define RTC_ALRA_ALRWA1_POS             (25)
#define RTC_ALRA_ALRWA2_POS             (26)
#define RTC_ALRA_AWENA_POS              (27)
#define RTC_ALRA_ALRENA_POS             (31)
#define RTC_ALRA_ALRSA                  ((uint32_t)0x7F<<(RTC_ALRA_ALRSA0_POS))
#define RTC_ALRA_ALRSA0                 ((uint32_t)1<<(RTC_ALRA_ALRSA0_POS))
#define RTC_ALRA_ALRSA1                 ((uint32_t)1<<(RTC_ALRA_ALRSA1_POS))
#define RTC_ALRA_ALRSA2                 ((uint32_t)1<<(RTC_ALRA_ALRSA2_POS))
#define RTC_ALRA_ALRSA3                 ((uint32_t)1<<(RTC_ALRA_ALRSA3_POS))
#define RTC_ALRA_ALRSA4                 ((uint32_t)1<<(RTC_ALRA_ALRSA4_POS))
#define RTC_ALRA_ALRSA5                 ((uint32_t)1<<(RTC_ALRA_ALRSA5_POS))
#define RTC_ALRA_ALRSA6                 ((uint32_t)1<<(RTC_ALRA_ALRSA6_POS))
#define RTC_ALRA_ASENA                  ((uint32_t)1<<(RTC_ALRA_ASENA_POS))
#define RTC_ALRA_ALRMA                  ((uint32_t)0x7F<<(RTC_ALRA_ALRMA0_POS))
#define RTC_ALRA_ALRMA0                 ((uint32_t)1<<(RTC_ALRA_ALRMA0_POS))
#define RTC_ALRA_ALRMA1                 ((uint32_t)1<<(RTC_ALRA_ALRMA1_POS))
#define RTC_ALRA_ALRMA2                 ((uint32_t)1<<(RTC_ALRA_ALRMA2_POS))
#define RTC_ALRA_ALRMA3                 ((uint32_t)1<<(RTC_ALRA_ALRMA3_POS))
#define RTC_ALRA_ALRMA4                 ((uint32_t)1<<(RTC_ALRA_ALRMA4_POS))
#define RTC_ALRA_ALRMA5                 ((uint32_t)1<<(RTC_ALRA_ALRMA5_POS))
#define RTC_ALRA_ALRMA6                 ((uint32_t)1<<(RTC_ALRA_ALRMA6_POS))
#define RTC_ALRA_AMENA                  ((uint32_t)1<<(RTC_ALRA_AMENA_POS))
#define RTC_ALRA_ALRHA                  ((uint32_t)0x3F<<(RTC_ALRA_ALRHA0_POS))
#define RTC_ALRA_ALRHA0                 ((uint32_t)1<<(RTC_ALRA_ALRHA0_POS))
#define RTC_ALRA_ALRHA1                 ((uint32_t)1<<(RTC_ALRA_ALRHA1_POS))
#define RTC_ALRA_ALRHA2                 ((uint32_t)1<<(RTC_ALRA_ALRHA2_POS))
#define RTC_ALRA_ALRHA3                 ((uint32_t)1<<(RTC_ALRA_ALRHA3_POS))
#define RTC_ALRA_ALRHA4                 ((uint32_t)1<<(RTC_ALRA_ALRHA4_POS))
#define RTC_ALRA_ALRHA5                 ((uint32_t)1<<(RTC_ALRA_ALRHA5_POS))
#define RTC_ALRA_AMPMA                  ((uint32_t)1<<(RTC_ALRA_AMPMA_POS))
#define RTC_ALRA_AHENA                  ((uint32_t)1<<(RTC_ALRA_AHENA_POS))
#define RTC_ALRA_ALRWA                  ((uint32_t)7<<(RTC_ALRA_ALRWA0_POS))
#define RTC_ALRA_ALRWA0                 ((uint32_t)1<<(RTC_ALRA_ALRWA0_POS))
#define RTC_ALRA_ALRWA1                 ((uint32_t)1<<(RTC_ALRA_ALRWA1_POS))
#define RTC_ALRA_ALRWA2                 ((uint32_t)1<<(RTC_ALRA_ALRWA2_POS))
#define RTC_ALRA_AWENA                  ((uint32_t)1<<(RTC_ALRA_AWENA_POS))
#define RTC_ALRA_ALRENA                 ((uint32_t)1<<(RTC_ALRA_ALRENA_POS))

/* RTC_ALRB λ */
#define RTC_ALRB_ALRSB0_POS             (0)
#define RTC_ALRB_ALRSB1_POS             (1)
#define RTC_ALRB_ALRSB2_POS             (2)
#define RTC_ALRB_ALRSB3_POS             (3)
#define RTC_ALRB_ALRSB4_POS             (4)
#define RTC_ALRB_ALRSB5_POS             (5)
#define RTC_ALRB_ALRSB6_POS             (6)
#define RTC_ALRB_ASENB_POS              (7)
#define RTC_ALRB_ALRMB0_POS             (8)
#define RTC_ALRB_ALRMB1_POS             (9)
#define RTC_ALRB_ALRMB2_POS             (10)
#define RTC_ALRB_ALRMB3_POS             (11)
#define RTC_ALRB_ALRMB4_POS             (12)
#define RTC_ALRB_ALRMB5_POS             (13)
#define RTC_ALRB_ALRMB6_POS             (14)
#define RTC_ALRB_AMENB_POS              (15)
#define RTC_ALRB_ALRHB0_POS             (16)
#define RTC_ALRB_ALRHB1_POS             (17)
#define RTC_ALRB_ALRHB2_POS             (18)
#define RTC_ALRB_ALRHB3_POS             (19)
#define RTC_ALRB_ALRHB4_POS             (20)
#define RTC_ALRB_ALRHB5_POS             (21)
#define RTC_ALRB_AMPMB_POS              (22)
#define RTC_ALRB_AHENB_POS              (23)
#define RTC_ALRB_ALRWB0_POS             (24)
#define RTC_ALRB_ALRWB1_POS             (25)
#define RTC_ALRB_ALRWB2_POS             (26)
#define RTC_ALRB_AWENB_POS              (27)
#define RTC_ALRB_ALRENB_POS             (31)
#define RTC_ALRB_ALRSB                  ((uint32_t)0x7F<<(RTC_ALRB_ALRSB0_POS))
#define RTC_ALRB_ALRSB0                 ((uint32_t)1<<(RTC_ALRB_ALRSB0_POS))
#define RTC_ALRB_ALRSB1                 ((uint32_t)1<<(RTC_ALRB_ALRSB1_POS))
#define RTC_ALRB_ALRSB2                 ((uint32_t)1<<(RTC_ALRB_ALRSB2_POS))
#define RTC_ALRB_ALRSB3                 ((uint32_t)1<<(RTC_ALRB_ALRSB3_POS))
#define RTC_ALRB_ALRSB4                 ((uint32_t)1<<(RTC_ALRB_ALRSB4_POS))
#define RTC_ALRB_ALRSB5                 ((uint32_t)1<<(RTC_ALRB_ALRSB5_POS))
#define RTC_ALRB_ALRSB6                 ((uint32_t)1<<(RTC_ALRB_ALRSB6_POS))
#define RTC_ALRB_ASENB                  ((uint32_t)1<<(RTC_ALRB_ASENB_POS))
#define RTC_ALRB_ALRMB                  ((uint32_t)0x7F<<(RTC_ALRB_ALRMB0_POS))
#define RTC_ALRB_ALRMB0                 ((uint32_t)1<<(RTC_ALRB_ALRMB0_POS))
#define RTC_ALRB_ALRMB1                 ((uint32_t)1<<(RTC_ALRB_ALRMB1_POS))
#define RTC_ALRB_ALRMB2                 ((uint32_t)1<<(RTC_ALRB_ALRMB2_POS))
#define RTC_ALRB_ALRMB3                 ((uint32_t)1<<(RTC_ALRB_ALRMB3_POS))
#define RTC_ALRB_ALRMB4                 ((uint32_t)1<<(RTC_ALRB_ALRMB4_POS))
#define RTC_ALRB_ALRMB5                 ((uint32_t)1<<(RTC_ALRB_ALRMB5_POS))
#define RTC_ALRB_ALRMB6                 ((uint32_t)1<<(RTC_ALRB_ALRMB6_POS))
#define RTC_ALRB_AMENB                  ((uint32_t)1<<(RTC_ALRB_AMENB_POS))
#define RTC_ALRB_ALRHB                  ((uint32_t)0x3F<<(RTC_ALRB_ALRHB0_POS))
#define RTC_ALRB_ALRHB0                 ((uint32_t)1<<(RTC_ALRB_ALRHB0_POS))
#define RTC_ALRB_ALRHB1                 ((uint32_t)1<<(RTC_ALRB_ALRHB1_POS))
#define RTC_ALRB_ALRHB2                 ((uint32_t)1<<(RTC_ALRB_ALRHB2_POS))
#define RTC_ALRB_ALRHB3                 ((uint32_t)1<<(RTC_ALRB_ALRHB3_POS))
#define RTC_ALRB_ALRHB4                 ((uint32_t)1<<(RTC_ALRB_ALRHB4_POS))
#define RTC_ALRB_ALRHB5                 ((uint32_t)1<<(RTC_ALRB_ALRHB5_POS))
#define RTC_ALRB_AMPMB                  ((uint32_t)1<<(RTC_ALRB_AMPMB_POS))
#define RTC_ALRB_AHENB                  ((uint32_t)1<<(RTC_ALRB_AHENB_POS))
#define RTC_ALRB_ALRWB                  ((uint32_t)7<<(RTC_ALRB_ALRWB0_POS))
#define RTC_ALRB_ALRWB0                 ((uint32_t)1<<(RTC_ALRB_ALRWB0_POS))
#define RTC_ALRB_ALRWB1                 ((uint32_t)1<<(RTC_ALRB_ALRWB1_POS))
#define RTC_ALRB_ALRWB2                 ((uint32_t)1<<(RTC_ALRB_ALRWB2_POS))
#define RTC_ALRB_AWENB                  ((uint32_t)1<<(RTC_ALRB_AWENB_POS))
#define RTC_ALRB_ALRENB                 ((uint32_t)1<<(RTC_ALRB_ALRENB_POS))

/* RTC_TMR λ */
#define RTC_TMR_SEC0_POS                (0)
#define RTC_TMR_SEC1_POS                (1)
#define RTC_TMR_SEC2_POS                (2)
#define RTC_TMR_SEC3_POS                (3)
#define RTC_TMR_SEC4_POS                (4)
#define RTC_TMR_SEC5_POS                (5)
#define RTC_TMR_SEC6_POS                (6)
#define RTC_TMR_MIN0_POS                (8)
#define RTC_TMR_MIN1_POS                (9)
#define RTC_TMR_MIN2_POS                (10)
#define RTC_TMR_MIN3_POS                (11)
#define RTC_TMR_MIN4_POS                (12)
#define RTC_TMR_MIN5_POS                (13)
#define RTC_TMR_MIN6_POS                (14)
#define RTC_TMR_HOUR0_POS               (16)
#define RTC_TMR_HOUR1_POS               (17)
#define RTC_TMR_HOUR2_POS               (18)
#define RTC_TMR_HOUR3_POS               (19)
#define RTC_TMR_HOUR4_POS               (20)
#define RTC_TMR_HOUR5_POS               (21)
#define RTC_TMR_AMPM_POS                (22)
#define RTC_TMR_WEK0_POS                (24)
#define RTC_TMR_WEK1_POS                (25)
#define RTC_TMR_WEK2_POS                (26)
#define RTC_TMR_SEC                     ((uint32_t)0x7F<<(RTC_TMR_SEC0_POS))
#define RTC_TMR_SEC0                    ((uint32_t)1<<(RTC_TMR_SEC0_POS))
#define RTC_TMR_SEC1                    ((uint32_t)1<<(RTC_TMR_SEC1_POS))
#define RTC_TMR_SEC2                    ((uint32_t)1<<(RTC_TMR_SEC2_POS))
#define RTC_TMR_SEC3                    ((uint32_t)1<<(RTC_TMR_SEC3_POS))
#define RTC_TMR_SEC4                    ((uint32_t)1<<(RTC_TMR_SEC4_POS))
#define RTC_TMR_SEC5                    ((uint32_t)1<<(RTC_TMR_SEC5_POS))
#define RTC_TMR_SEC6                    ((uint32_t)1<<(RTC_TMR_SEC6_POS))
#define RTC_TMR_MIN                     ((uint32_t)0x7F<<(RTC_TMR_MIN0_POS))
#define RTC_TMR_MIN0                    ((uint32_t)1<<(RTC_TMR_MIN0_POS))
#define RTC_TMR_MIN1                    ((uint32_t)1<<(RTC_TMR_MIN1_POS))
#define RTC_TMR_MIN2                    ((uint32_t)1<<(RTC_TMR_MIN2_POS))
#define RTC_TMR_MIN3                    ((uint32_t)1<<(RTC_TMR_MIN3_POS))
#define RTC_TMR_MIN4                    ((uint32_t)1<<(RTC_TMR_MIN4_POS))
#define RTC_TMR_MIN5                    ((uint32_t)1<<(RTC_TMR_MIN5_POS))
#define RTC_TMR_MIN6                    ((uint32_t)1<<(RTC_TMR_MIN6_POS))
#define RTC_TMR_HOUR                    ((uint32_t)0x3F<<(RTC_TMR_HOUR0_POS))
#define RTC_TMR_HOUR0                   ((uint32_t)1<<(RTC_TMR_HOUR0_POS))
#define RTC_TMR_HOUR1                   ((uint32_t)1<<(RTC_TMR_HOUR1_POS))
#define RTC_TMR_HOUR2                   ((uint32_t)1<<(RTC_TMR_HOUR2_POS))
#define RTC_TMR_HOUR3                   ((uint32_t)1<<(RTC_TMR_HOUR3_POS))
#define RTC_TMR_HOUR4                   ((uint32_t)1<<(RTC_TMR_HOUR4_POS))
#define RTC_TMR_HOUR5                   ((uint32_t)1<<(RTC_TMR_HOUR5_POS))
#define RTC_TMR_AMPM                    ((uint32_t)1<<(RTC_TMR_AMPM_POS))
#define RTC_TMR_WEK                     ((uint32_t)7<<(RTC_TMR_WEK0_POS))
#define RTC_TMR_WEK0                    ((uint32_t)1<<(RTC_TMR_WEK0_POS))
#define RTC_TMR_WEK1                    ((uint32_t)1<<(RTC_TMR_WEK1_POS))
#define RTC_TMR_WEK2                    ((uint32_t)1<<(RTC_TMR_WEK2_POS))

/* RTC_DTR λ */
#define RTC_DTR_DAY0_POS                (0)
#define RTC_DTR_DAY1_POS                (1)
#define RTC_DTR_DAY2_POS                (2)
#define RTC_DTR_DAY3_POS                (3)
#define RTC_DTR_DAY4_POS                (4)
#define RTC_DTR_DAY5_POS                (5)
#define RTC_DTR_MTH0_POS                (8)
#define RTC_DTR_MTH1_POS                (9)
#define RTC_DTR_MTH2_POS                (10)
#define RTC_DTR_MTH3_POS                (11)
#define RTC_DTR_MTH4_POS                (12)
#define RTC_DTR_YEAR0_POS               (16)
#define RTC_DTR_YEAR1_POS               (17)
#define RTC_DTR_YEAR2_POS               (18)
#define RTC_DTR_YEAR3_POS               (19)
#define RTC_DTR_YEAR4_POS               (20)
#define RTC_DTR_YEAR5_POS               (21)
#define RTC_DTR_YEAR6_POS               (22)
#define RTC_DTR_YEAR7_POS               (23)
#define RTC_DTR_DAY                     ((uint32_t)0x7F<<(RTC_DTR_DAY0_POS))
#define RTC_DTR_DAY0                    ((uint32_t)1<<(RTC_DTR_DAY0_POS))
#define RTC_DTR_DAY1                    ((uint32_t)1<<(RTC_DTR_DAY1_POS))
#define RTC_DTR_DAY2                    ((uint32_t)1<<(RTC_DTR_DAY2_POS))
#define RTC_DTR_DAY3                    ((uint32_t)1<<(RTC_DTR_DAY3_POS))
#define RTC_DTR_DAY4                    ((uint32_t)1<<(RTC_DTR_DAY4_POS))
#define RTC_DTR_DAY5                    ((uint32_t)1<<(RTC_DTR_DAY5_POS))
#define RTC_DTR_MTH                     ((uint32_t)0x7F<<(RTC_DTR_MTH0_POS))
#define RTC_DTR_MTH0                    ((uint32_t)1<<(RTC_DTR_MTH0_POS))
#define RTC_DTR_MTH1                    ((uint32_t)1<<(RTC_DTR_MTH1_POS))
#define RTC_DTR_MTH2                    ((uint32_t)1<<(RTC_DTR_MTH2_POS))
#define RTC_DTR_MTH3                    ((uint32_t)1<<(RTC_DTR_MTH3_POS))
#define RTC_DTR_MTH4                    ((uint32_t)1<<(RTC_DTR_MTH4_POS))
#define RTC_DTR_YEAR                    ((uint32_t)0x3F<<(RTC_DTR_YEAR0_POS))
#define RTC_DTR_YEAR0                   ((uint32_t)1<<(RTC_DTR_YEAR0_POS))
#define RTC_DTR_YEAR1                   ((uint32_t)1<<(RTC_DTR_YEAR1_POS))
#define RTC_DTR_YEAR2                   ((uint32_t)1<<(RTC_DTR_YEAR2_POS))
#define RTC_DTR_YEAR3                   ((uint32_t)1<<(RTC_DTR_YEAR3_POS))
#define RTC_DTR_YEAR4                   ((uint32_t)1<<(RTC_DTR_YEAR4_POS))
#define RTC_DTR_YEAR5                   ((uint32_t)1<<(RTC_DTR_YEAR5_POS))
#define RTC_DTR_YEAR6                   ((uint32_t)1<<(RTC_DTR_YEAR6_POS))
#define RTC_DTR_YEAR7                   ((uint32_t)1<<(RTC_DTR_YEAR7_POS))

/* RTC_TMER λ */
#define RTC_TMER_TMR0_0_POS             (0)
#define RTC_TMER_TMR1_0_POS             (16)
#define RTC_TMER_TMR0                   ((uint32_t)0xFFFF<<(RTC_TMER_TMR0_0_POS))
#define RTC_TMER_TMR1                   ((uint32_t)0xFFFF<<(RTC_TMER_TMR1_0_POS))

/* RTC_TCR λ */
#define RTC_TCR_TMR0C0_POS              (0)
#define RTC_TCR_TMR0C1_POS              (1)
#define RTC_TCR_TMR0C2_POS              (2)
#define RTC_TCR_TMR0C3_POS              (3)
#define RTC_TCR_TMR1C0_POS              (4)
#define RTC_TCR_TMR1C1_POS              (5)
#define RTC_TCR_TMR1C2_POS              (6)
#define RTC_TCR_TMR1C3_POS              (7)
#define RTC_TCR_TMR0EN_POS              (8)
#define RTC_TCR_TMR1EN_POS              (9)
#define RTC_TCR_TMR0C                   ((uint32_t)0xF<<(RTC_TCR_TMR0C0_POS))
#define RTC_TCR_TMR0C0                  ((uint32_t)1<<(RTC_TCR_TMR0C0_POS))
#define RTC_TCR_TMR0C1                  ((uint32_t)1<<(RTC_TCR_TMR0C1_POS))
#define RTC_TCR_TMR0C2                  ((uint32_t)1<<(RTC_TCR_TMR0C2_POS))
#define RTC_TCR_TMR0C3                  ((uint32_t)1<<(RTC_TCR_TMR0C3_POS))
#define RTC_TCR_TMR1C                   ((uint32_t)0xF<<(RTC_TCR_TMR1C0_POS))
#define RTC_TCR_TMR1C0                  ((uint32_t)1<<(RTC_TCR_TMR1C0_POS))
#define RTC_TCR_TMR1C1                  ((uint32_t)1<<(RTC_TCR_TMR1C1_POS))
#define RTC_TCR_TMR1C2                  ((uint32_t)1<<(RTC_TCR_TMR1C2_POS))
#define RTC_TCR_TMR1C3                  ((uint32_t)1<<(RTC_TCR_TMR1C3_POS))
#define RTC_TCR_TMR0EN                  ((uint32_t)1<<(RTC_TCR_TMR0EN_POS))
#define RTC_TCR_TMR1EN                  ((uint32_t)1<<(RTC_TCR_TMR1EN_POS))

/* RTC_IER λ */
#define RTC_IER_SECIE_POS               (0)
#define RTC_IER_MINIE_POS               (1)
#define RTC_IER_HOURIE_POS              (2)
#define RTC_IER_DAYIE_POS               (3)
#define RTC_IER_ALRAIE_POS              (4)
#define RTC_IER_ALRBIE_POS              (5)
#define RTC_IER_TTIE_POS                (6)
#define RTC_IER_RTCT0IE_POS             (8)
#define RTC_IER_RTCT1IE_POS             (9)
#define RTC_IER_TSOVFIE_POS             (10)
#define RTC_IER_TSIE_POS                (11)
#define RTC_IER_SECIE                   ((uint32_t)1<<(RTC_IER_SECIE_POS))
#define RTC_IER_MINIE                   ((uint32_t)1<<(RTC_IER_MINIE_POS))
#define RTC_IER_HOURIE                  ((uint32_t)1<<(RTC_IER_HOURIE_POS))
#define RTC_IER_DAYIE                   ((uint32_t)1<<(RTC_IER_DAYIE_POS))
#define RTC_IER_ALRAIE                  ((uint32_t)1<<(RTC_IER_ALRAIE_POS))
#define RTC_IER_ALRBIE                  ((uint32_t)1<<(RTC_IER_ALRBIE_POS))
#define RTC_IER_TTIE                    ((uint32_t)1<<(RTC_IER_TTIE_POS))
#define RTC_IER_RTCT0IE                 ((uint32_t)1<<(RTC_IER_RTCT0IE_POS))
#define RTC_IER_RTCT1IE                 ((uint32_t)1<<(RTC_IER_RTCT1IE_POS))
#define RTC_IER_TSOVFIE                 ((uint32_t)1<<(RTC_IER_TSOVFIE_POS))
#define RTC_IER_TSIE                    ((uint32_t)1<<(RTC_IER_TSIE_POS))

/* RTC_IFR λ */
#define RTC_IFR_SECIF_POS               (0)
#define RTC_IFR_MINIF_POS               (1)
#define RTC_IFR_HOURIF_POS              (2)
#define RTC_IFR_DAYIF_POS               (3)
#define RTC_IFR_ALRAIF_POS              (4)
#define RTC_IFR_ALRBIF_POS              (5)
#define RTC_IFR_TTIF_POS                (6)
#define RTC_IFR_RTCT0IF_POS             (8)
#define RTC_IFR_RTCT1IF_POS             (9)
#define RTC_IFR_TSOVFIF_POS             (10)
#define RTC_IFR_TSIF_POS                (11)
#define RTC_IFR_SECIC_POS               (16)
#define RTC_IFR_MINIC_POS               (17)
#define RTC_IFR_HOURIC_POS              (18)
#define RTC_IFR_DAYIC_POS               (19)
#define RTC_IFR_ALRAIC_POS              (20)
#define RTC_IFR_ALRBIC_POS              (21)
#define RTC_IFR_TTIC_POS                (22)
#define RTC_IFR_RTCT0IC_POS             (24)
#define RTC_IFR_RTCT1IC_POS             (25)
#define RTC_IFR_TSOVFIC_POS             (26)
#define RTC_IFR_TSIC_POS                (27)
#define RTC_IFR_SECIF                   ((uint32_t)1<<(RTC_IFR_SECIF_POS))
#define RTC_IFR_MINIF                   ((uint32_t)1<<(RTC_IFR_MINIF_POS))
#define RTC_IFR_HOURIF                  ((uint32_t)1<<(RTC_IFR_HOURIF_POS))
#define RTC_IFR_DAYIF                   ((uint32_t)1<<(RTC_IFR_DAYIF_POS))
#define RTC_IFR_ALRAIF                  ((uint32_t)1<<(RTC_IFR_ALRAIF_POS))
#define RTC_IFR_ALRBIF                  ((uint32_t)1<<(RTC_IFR_ALRBIF_POS))
#define RTC_IFR_TTIF                    ((uint32_t)1<<(RTC_IFR_TTIF_POS))
#define RTC_IFR_RTCT0IF                 ((uint32_t)1<<(RTC_IFR_RTCT0IF_POS))
#define RTC_IFR_RTCT1IF                 ((uint32_t)1<<(RTC_IFR_RTCT1IF_POS))
#define RTC_IFR_TSOVFIF                 ((uint32_t)1<<(RTC_IFR_TSOVFIF_POS))
#define RTC_IFR_TSIF                    ((uint32_t)1<<(RTC_IFR_TSIF_POS))
#define RTC_IFR_SECIC                   ((uint32_t)1<<(RTC_IFR_SECIC_POS))
#define RTC_IFR_MINIC                   ((uint32_t)1<<(RTC_IFR_MINIC_POS))
#define RTC_IFR_HOURIC                  ((uint32_t)1<<(RTC_IFR_HOURIC_POS))
#define RTC_IFR_DAYIC                   ((uint32_t)1<<(RTC_IFR_DAYIC_POS))
#define RTC_IFR_ALRAIC                  ((uint32_t)1<<(RTC_IFR_ALRAIC_POS))
#define RTC_IFR_ALRBIC                  ((uint32_t)1<<(RTC_IFR_ALRBIC_POS))
#define RTC_IFR_TTIC                    ((uint32_t)1<<(RTC_IFR_TTIC_POS))
#define RTC_IFR_RTCT0IC                 ((uint32_t)1<<(RTC_IFR_RTCT0IC_POS))
#define RTC_IFR_RTCT1IC                 ((uint32_t)1<<(RTC_IFR_RTCT1IC_POS))
#define RTC_IFR_TSOVFIC                 ((uint32_t)1<<(RTC_IFR_TSOVFIC_POS))
#define RTC_IFR_TSIC                    ((uint32_t)1<<(RTC_IFR_TSIC_POS))

/* RTC_TMBR λ */
#define RTC_TMBR_SECB0_POS              (0)
#define RTC_TMBR_SECB1_POS              (1)
#define RTC_TMBR_SECB2_POS              (2)
#define RTC_TMBR_SECB3_POS              (3)
#define RTC_TMBR_SECB4_POS              (4)
#define RTC_TMBR_SECB5_POS              (5)
#define RTC_TMBR_SECB6_POS              (6)
#define RTC_TMBR_MINB0_POS              (8)
#define RTC_TMBR_MINB1_POS              (9)
#define RTC_TMBR_MINB2_POS              (10)
#define RTC_TMBR_MINB3_POS              (11)
#define RTC_TMBR_MINB4_POS              (12)
#define RTC_TMBR_MINB5_POS              (13)
#define RTC_TMBR_MINB6_POS              (14)
#define RTC_TMBR_HOURB0_POS             (16)
#define RTC_TMBR_HOURB1_POS             (17)
#define RTC_TMBR_HOURB2_POS             (18)
#define RTC_TMBR_HOURB3_POS             (19)
#define RTC_TMBR_HOURB4_POS             (20)
#define RTC_TMBR_HOURB5_POS             (21)
#define RTC_TMBR_AMPMB_POS              (22)
#define RTC_TMBR_WEKB0_POS              (24)
#define RTC_TMBR_WEKB1_POS              (25)
#define RTC_TMBR_WEKB2_POS              (26)
#define RTC_TMBR_SECB                   ((uint32_t)0x7F<<(RTC_TMBR_SECB0_POS))
#define RTC_TMBR_SECB0                  ((uint32_t)1<<(RTC_TMBR_SECB0_POS))
#define RTC_TMBR_SECB1                  ((uint32_t)1<<(RTC_TMBR_SECB1_POS))
#define RTC_TMBR_SECB2                  ((uint32_t)1<<(RTC_TMBR_SECB2_POS))
#define RTC_TMBR_SECB3                  ((uint32_t)1<<(RTC_TMBR_SECB3_POS))
#define RTC_TMBR_SECB4                  ((uint32_t)1<<(RTC_TMBR_SECB4_POS))
#define RTC_TMBR_SECB5                  ((uint32_t)1<<(RTC_TMBR_SECB5_POS))
#define RTC_TMBR_SECB6                  ((uint32_t)1<<(RTC_TMBR_SECB6_POS))
#define RTC_TMBR_MINB                   ((uint32_t)0x7F<<(RTC_TMBR_MINB0_POS))
#define RTC_TMBR_MINB0                  ((uint32_t)1<<(RTC_TMBR_MINB0_POS))
#define RTC_TMBR_MINB1                  ((uint32_t)1<<(RTC_TMBR_MINB1_POS))
#define RTC_TMBR_MINB2                  ((uint32_t)1<<(RTC_TMBR_MINB2_POS))
#define RTC_TMBR_MINB3                  ((uint32_t)1<<(RTC_TMBR_MINB3_POS))
#define RTC_TMBR_MINB4                  ((uint32_t)1<<(RTC_TMBR_MINB4_POS))
#define RTC_TMBR_MINB5                  ((uint32_t)1<<(RTC_TMBR_MINB5_POS))
#define RTC_TMBR_MINB6                  ((uint32_t)1<<(RTC_TMBR_MINB6_POS))
#define RTC_TMBR_HOURB                  ((uint32_t)0x3F<<(RTC_TMBR_HOURB0_POS))
#define RTC_TMBR_HOURB0                 ((uint32_t)1<<(RTC_TMBR_HOURB0_POS))
#define RTC_TMBR_HOURB1                 ((uint32_t)1<<(RTC_TMBR_HOURB1_POS))
#define RTC_TMBR_HOURB2                 ((uint32_t)1<<(RTC_TMBR_HOURB2_POS))
#define RTC_TMBR_HOURB3                 ((uint32_t)1<<(RTC_TMBR_HOURB3_POS))
#define RTC_TMBR_HOURB4                 ((uint32_t)1<<(RTC_TMBR_HOURB4_POS))
#define RTC_TMBR_HOURB5                 ((uint32_t)1<<(RTC_TMBR_HOURB5_POS))
#define RTC_TMBR_AMPMB                  ((uint32_t)1<<(RTC_TMBR_AMPMB_POS))
#define RTC_TMBR_WEKB                   ((uint32_t)7<<(RTC_TMBR_WEKB0_POS))
#define RTC_TMBR_WEKB0                  ((uint32_t)1<<(RTC_TMBR_WEKB0_POS))
#define RTC_TMBR_WEKB1                  ((uint32_t)1<<(RTC_TMBR_WEKB1_POS))
#define RTC_TMBR_WEKB2                  ((uint32_t)1<<(RTC_TMBR_WEKB2_POS))

/* RTC_DTBR λ */
#define RTC_DTBR_DAYB0_POS              (0)
#define RTC_DTBR_DAYB1_POS              (1)
#define RTC_DTBR_DAYB2_POS              (2)
#define RTC_DTBR_DAYB3_POS              (3)
#define RTC_DTBR_DAYB4_POS              (4)
#define RTC_DTBR_DAYB5_POS              (5)
#define RTC_DTBR_MTHB0_POS              (8)
#define RTC_DTBR_MTHB1_POS              (9)
#define RTC_DTBR_MTHB2_POS              (10)
#define RTC_DTBR_MTHB3_POS              (11)
#define RTC_DTBR_MTHB4_POS              (12)
#define RTC_DTBR_YEARB0_POS             (16)
#define RTC_DTBR_YEARB1_POS             (17)
#define RTC_DTBR_YEARB2_POS             (18)
#define RTC_DTBR_YEARB3_POS             (19)
#define RTC_DTBR_YEARB4_POS             (20)
#define RTC_DTBR_YEARB5_POS             (21)
#define RTC_DTBR_YEARB6_POS             (22)
#define RTC_DTBR_YEARB7_POS             (23)
#define RTC_DTBR_DAYB                   ((uint32_t)0x7F<<(RTC_DTBR_DAYB0_POS))
#define RTC_DTBR_DAYB0                  ((uint32_t)1<<(RTC_DTBR_DAYB0_POS))
#define RTC_DTBR_DAYB1                  ((uint32_t)1<<(RTC_DTBR_DAYB1_POS))
#define RTC_DTBR_DAYB2                  ((uint32_t)1<<(RTC_DTBR_DAYB2_POS))
#define RTC_DTBR_DAYB3                  ((uint32_t)1<<(RTC_DTBR_DAYB3_POS))
#define RTC_DTBR_DAYB4                  ((uint32_t)1<<(RTC_DTBR_DAYB4_POS))
#define RTC_DTBR_DAYB5                  ((uint32_t)1<<(RTC_DTBR_DAYB5_POS))
#define RTC_DTBR_MTHB                   ((uint32_t)0x7F<<(RTC_DTBR_MTHB0_POS))
#define RTC_DTBR_MTHB0                  ((uint32_t)1<<(RTC_DTBR_MTHB0_POS))
#define RTC_DTBR_MTHB1                  ((uint32_t)1<<(RTC_DTBR_MTHB1_POS))
#define RTC_DTBR_MTHB2                  ((uint32_t)1<<(RTC_DTBR_MTHB2_POS))
#define RTC_DTBR_MTHB3                  ((uint32_t)1<<(RTC_DTBR_MTHB3_POS))
#define RTC_DTBR_MTHB4                  ((uint32_t)1<<(RTC_DTBR_MTHB4_POS))
#define RTC_DTBR_YEARB                  ((uint32_t)0x3F<<(RTC_DTBR_YEARB0_POS))
#define RTC_DTBR_YEARB0                 ((uint32_t)1<<(RTC_DTBR_YEARB0_POS))
#define RTC_DTBR_YEARB1                 ((uint32_t)1<<(RTC_DTBR_YEARB1_POS))
#define RTC_DTBR_YEARB2                 ((uint32_t)1<<(RTC_DTBR_YEARB2_POS))
#define RTC_DTBR_YEARB3                 ((uint32_t)1<<(RTC_DTBR_YEARB3_POS))
#define RTC_DTBR_YEARB4                 ((uint32_t)1<<(RTC_DTBR_YEARB4_POS))
#define RTC_DTBR_YEARB5                 ((uint32_t)1<<(RTC_DTBR_YEARB5_POS))
#define RTC_DTBR_YEARB6                 ((uint32_t)1<<(RTC_DTBR_YEARB6_POS))
#define RTC_DTBR_YEARB7                 ((uint32_t)1<<(RTC_DTBR_YEARB7_POS))
/* ʵʱʱ (RTC) */

#endif

#if 1										/* IWDT */

/* ----------------------------------------------------------------------------
   -- Ź(IWDT)
   ---------------------------------------------------------------------------- */

/* IWDT - Ĵڴṹ */
typedef struct IWDT_MemMap
{
    volatile uint32_t CTL;              /* ŹƼĴ, ƫ:0x00 */
    volatile uint32_t FD;               /* ŹιĴ, ƫ:0x04 */
}IWDT_SFRmap;

/* ----------------------------------------------------------------------------
   -- IWDT - Ĵں
   ---------------------------------------------------------------------------- */

/* IWDT - Ĵڵַ */
#define IWDT_ADDR                       ((uint32_t)0x40001200)
#define IWDT_SFR                        ((IWDT_SFRmap *) IWDT_ADDR)

/* IWDT - Ĵ */
#define IWDT_CTL                        (IWDT_SFR->CTL)
#define IWDT_FD                         (IWDT_SFR->FD)

/* IWDT_CTL λ */
#define IWDT_CTL_IWDTPS0_POS            (0)
#define IWDT_CTL_IWDTPS1_POS            (1)
#define IWDT_CTL_IWDTPS2_POS            (2)
#define IWDT_CTL_IWDTPS3_POS            (3)
#define IWDT_CTL_IWDTOVF0_POS           (4)
#define IWDT_CTL_CLKS_POS               (29)
#define IWDT_CTL_IWDTEN_POS             (31)
#define IWDT_CTL_IWDTPS                 ((uint32_t)0xF<<(IWDT_CTL_IWDTPS0_POS))
#define IWDT_CTL_IWDTPS0                ((uint32_t)1<<(IWDT_CTL_IWDTPS0_POS))
#define IWDT_CTL_IWDTPS1                ((uint32_t)1<<(IWDT_CTL_IWDTPS1_POS))
#define IWDT_CTL_IWDTPS2                ((uint32_t)1<<(IWDT_CTL_IWDTPS2_POS))
#define IWDT_CTL_IWDTPS3                ((uint32_t)1<<(IWDT_CTL_IWDTPS3_POS))
#define IWDT_CTL_IWDTOVF                ((uint32_t)0xFFF<<(IWDT_CTL_IWDTOVF0_POS))
#define IWDT_CTL_CLKS                   ((uint32_t)1<<(IWDT_CTL_CLKS_POS))
#define IWDT_CTL_IWDTEN                 ((uint32_t)1<<(IWDT_CTL_IWDTEN_POS))

/* IWDT_FD λ */
#define IWDT_FD_IWDTFD0_POS             (0)
#define IWDT_FD_IWDTFD0            		((uint32_t)0xFFFFFFFF<<(IWDT_FD_IWDTFD0_POS))
/* Ź(IWDT) */

#endif

#if 1										/* WWDT */

/* ----------------------------------------------------------------------------
   -- ڿŹ(WWDT)
   ---------------------------------------------------------------------------- */

/* WWDT - Ĵڴṹ */
typedef struct WWDT_MemMap
{
    volatile uint32_t CTL;              /* ŹƼĴ, ƫ:0x00 */
    volatile uint32_t CNT;              /* ŹĴ, ƫ:0x04 */
    volatile uint32_t CTL1;             /* ŹƼĴ1, ƫ:0x08 */
}WWDT_SFRmap;

/* ----------------------------------------------------------------------------
   -- WWDT - Ĵں
   ---------------------------------------------------------------------------- */

/* WWDT - Ĵڵַ */
#define WWDT_ADDR                       ((uint32_t)0x40001280)
#define WWDT_SFR                        ((WWDT_SFRmap *) WWDT_ADDR)

/* WWDT - Ĵ */
#define WWDT_CTL                        (WWDT_SFR->CTL)
#define WWDT_CNT                        (WWDT_SFR->CNT)
#define WWDT_CTL1                       (WWDT_SFR->CTL1)

/* WWDT_CTL λ */
#define WWDT_CTL_WWDTEN_POS             (0)
#define WWDT_CTL_WWDTIE_POS             (1)
#define WWDT_CTL_WWDTIF_POS             (2)
#define WWDT_CTL_WPS0_POS               (3)
#define WWDT_CTL_WPS1_POS               (4)
#define WWDT_CTL_WPS2_POS               (5)
#define WWDT_CTL_WPS3_POS               (6)
#define WWDT_CTL_WPS4_POS               (7)
#define WWDT_CTL_WW0_POS                (8)
#define WWDT_CTL_WW1_POS                (9)
#define WWDT_CTL_WW2_POS                (10)
#define WWDT_CTL_WW3_POS                (11)
#define WWDT_CTL_WW4_POS                (12)
#define WWDT_CTL_WW5_POS                (13)
#define WWDT_CTL_WW6_POS                (14)
#define WWDT_CTL_WWDTIC_POS             (15)
#define WWDT_CTL_WWDTEN                 ((uint32_t)1<<(WWDT_CTL_WWDTEN_POS))
#define WWDT_CTL_WWDTIE                 ((uint32_t)1<<(WWDT_CTL_WWDTIE_POS))
#define WWDT_CTL_WWDTIF                 ((uint32_t)1<<(WWDT_CTL_WWDTIF_POS))
#define WWDT_CTL_WPS                    ((uint32_t)0x1F<<(WWDT_CTL_WPS0_POS))
#define WWDT_CTL_WPS0                   ((uint32_t)0x1<<(WWDT_CTL_WPS0_POS))
#define WWDT_CTL_WPS1                   ((uint32_t)0x1<<(WWDT_CTL_WPS1_POS))
#define WWDT_CTL_WPS2                   ((uint32_t)0x1<<(WWDT_CTL_WPS2_POS))
#define WWDT_CTL_WPS3                   ((uint32_t)0x1<<(WWDT_CTL_WPS3_POS))
#define WWDT_CTL_WPS4                   ((uint32_t)0x1<<(WWDT_CTL_WPS4_POS))
#define WWDT_CTL_WW                     ((uint32_t)0x7F<<(WWDT_CTL_WW0_POS))
#define WWDT_CTL_WW0                    ((uint32_t)1<<(WWDT_CTL_WW0_POS))
#define WWDT_CTL_WW1                    ((uint32_t)1<<(WWDT_CTL_WW1_POS))
#define WWDT_CTL_WW2                    ((uint32_t)1<<(WWDT_CTL_WW2_POS))
#define WWDT_CTL_WW3                    ((uint32_t)1<<(WWDT_CTL_WW3_POS))
#define WWDT_CTL_WW4                    ((uint32_t)1<<(WWDT_CTL_WW4_POS))
#define WWDT_CTL_WW5                    ((uint32_t)1<<(WWDT_CTL_WW5_POS))
#define WWDT_CTL_WW6                    ((uint32_t)1<<(WWDT_CTL_WW6_POS))
#define WWDT_CTL_WWDTIC                 ((uint32_t)1<<(WWDT_CTL_WWDTIC_POS))

/* WWDT_CNT λ */
#define WWDT_CNT_WT_POS                 (0)
#define WWDT_CNT_WT                     ((uint32_t)0x7F<<(WWDT_CNT_WT_POS))

/* WWDT_CTL1 λ */
#define WWDT_CTL1_CLKS0_POS             (0)
#define WWDT_CTL1_CLKS1_POS             (1)
#define WWDT_CTL1_TPEN_POS              (3)
#define WWDT_CTL1_CLKS                  ((uint32_t)0x03<<(WWDT_CTL1_CLKS0_POS))
#define WWDT_CTL1_CLKS0                 ((uint32_t)1<<(WWDT_CTL1_CLKS0_POS))
#define WWDT_CTL1_CLKS1                 ((uint32_t)1<<(WWDT_CTL1_CLKS1_POS))
#define WWDT_CTL1_TPEN                  ((uint32_t)1<<(WWDT_CTL1_TPEN_POS))
/* Ź(WWDT) */

#endif

#if 1										/* EWDT */

/* ----------------------------------------------------------------------------
   -- ΧŹ(EWDT)
   ---------------------------------------------------------------------------- */

/* EWDT - Ĵڴṹ */
typedef struct EWDT_MenMap
{
	volatile uint32_t CTL;   /* ΧŹƼĴ,ƫƣ0x000 */
	volatile uint32_t CNT;   /* ΧŹĴ,ƫƣ0x004 */
}EWDT_SFRmap;

/* ----------------------------------------------------------------------------
   -- EWDT - Ĵں
   ---------------------------------------------------------------------------- */

/* EWDT - Ĵڵַ */
#define EWDT_ADDR                        ((uint32_t)0x40002B00)
#define EWDT_SFR                         ((EWDT_SFRmap *) EWDT_ADDR)

/* RST_SFR - Ĵ */
#define EWDT_CTL   						(EWDT_SFR->CTL)
#define EWDT_CNT   						(EWDT_SFR->CNT)

/* EWDTx_CTLλ */
#define	EWDT_CTL_EWDTEN_POS				(0)
#define	EWDT_CTL_WT40IE_POS				(1)
#define	EWDT_CTL_WT40IF_POS				(2)
#define	EWDT_CTL_WPS0_POS				(3)
#define	EWDT_CTL_WPS1_POS				(4)
#define	EWDT_CTL_WPS2_POS				(5)
#define	EWDT_CTL_WPS3_POS				(6)
#define	EWDT_CTL_WPS4_POS				(7)
#define	EWDT_CTL_WW0_POS					(8)
#define	EWDT_CTL_WW1_POS					(9)
#define	EWDT_CTL_WW2_POS					(10)
#define	EWDT_CTL_WW3_POS					(11)
#define	EWDT_CTL_WW4_POS					(12)
#define	EWDT_CTL_WW5_POS					(13)
#define	EWDT_CTL_WW6_POS					(14)
#define	EWDT_CTL_WW40IC_POS				(15)
#define	EWDT_CTL_EWDTIN_EN_POS			(16)
#define	EWDT_CTL_EWDTIN_POL_POS			(17)
#define	EWDT_CTL_CLKS0_POS				(18)
#define	EWDT_CTL_CLKS1_POS				(19)
#define	EWDT_CTL_TPEN_POS				(20)
#define	EWDT_CTL_EWDTRSTIE_POS			(21)
#define	EWDT_CTL_EWDTRSTIC_POS			(22)
#define	EWDT_CTL_EWDTRSTIF_POS			(23)
#define	EWDT_CTL_OUTSEL_POS				(24)
#define	EWDT_CTL_EWDTEN				    ((uint32_t)1<<(EWDT_CTL_EWDTEN_POS))
#define	EWDT_CTL_WT40IE				    ((uint32_t)1<<(EWDT_CTL_WT40IE_POS))
#define	EWDT_CTL_WT40IF				    ((uint32_t)1<<(EWDT_CTL_WT40IF_POS))
#define	EWDT_CTL_WPS 				    ((uint32_t)0x1F<<(EWDT_CTL_WPS0_POS))
#define	EWDT_CTL_WPS0				    ((uint32_t)1<<(EWDT_CTL_WPS0_POS))
#define	EWDT_CTL_WPS1				    ((uint32_t)1<<(EWDT_CTL_WPS1_POS))
#define	EWDT_CTL_WPS2				    ((uint32_t)1<<(EWDT_CTL_WPS2_POS))
#define	EWDT_CTL_WPS3				    ((uint32_t)1<<(EWDT_CTL_WPS3_POS))
#define	EWDT_CTL_WPS4				    ((uint32_t)1<<(EWDT_CTL_WPS4_POS))
#define	EWDT_CTL_WW				        ((uint32_t)0x7F<<(EWDT_CTL_WW0_POS))
#define	EWDT_CTL_WW0				        ((uint32_t)1<<(EWDT_CTL_WW0_POS))
#define	EWDT_CTL_WW1				        ((uint32_t)1<<(EWDT_CTL_WW1_POS))
#define	EWDT_CTL_WW2				        ((uint32_t)1<<(EWDT_CTL_WW2_POS))
#define	EWDT_CTL_WW3				        ((uint32_t)1<<(EWDT_CTL_WW3_POS))
#define	EWDT_CTL_WW4				        ((uint32_t)1<<(EWDT_CTL_WW4_POS))
#define	EWDT_CTL_WW5				        ((uint32_t)1<<(EWDT_CTL_WW5_POS))
#define	EWDT_CTL_WW6				        ((uint32_t)1<<(EWDT_CTL_WW6_POS))
#define	EWDT_CTL_WW40IC				    ((uint32_t)1<<(EWDT_CTL_WW40IC_POS))
#define	EWDT_CTL_EWDTIN_EN				((uint32_t)1<<(EWDT_CTL_EWDTIN_EN_POS))
#define	EWDT_CTL_EWDTIN_POL				((uint32_t)1<<(EWDT_CTL_EWDTIN_POL_POS))
#define	EWDT_CTL_CLKS				    ((uint32_t)0x03<<(EWDT_CTL_CLKS0_POS))
#define	EWDT_CTL_CLKS0				    ((uint32_t)1<<(EWDT_CTL_CLKS0_POS))
#define	EWDT_CTL_CLKS1				    ((uint32_t)1<<(EWDT_CTL_CLKS1_POS))
#define	EWDT_CTL_TPEN				    ((uint32_t)1<<(EWDT_CTL_TPEN_POS))
#define	EWDT_CTL_EWDTRSTIE				((uint32_t)1<<(EWDT_CTL_EWDTRSTIE_POS))
#define	EWDT_CTL_EWDTRSTIC				((uint32_t)1<<(EWDT_CTL_EWDTRSTIC_POS))
#define	EWDT_CTL_EWDTRSTIF				((uint32_t)1<<(EWDT_CTL_EWDTRSTIF_POS))
#define	EWDT_CTL_OUTSEL				    ((uint32_t)1<<(EWDT_CTL_OUTSEL_POS))

/* EWDTx_CNTλ */
#define	EWDT_CNT_WT0_POS					(0)
#define	EWDT_CNT_WT0						((uint32_t)0x7F<<(EWDT_CNT_WT0_POS))
/* ΧŹ(EWDT) */

#endif

#if 1										/* CFGL */
/* ----------------------------------------------------------------------------
   -- CFGLģ (CFGL)
   ---------------------------------------------------------------------------- */

/* CFGLģĴڴṹ */
typedef struct CFGL_MemMap
{
    volatile uint32_t CTL0;          /* CFGLƼĴ0, ƫ:0x00 */
    volatile uint32_t CTL1;          /* CFGLƼĴ1, ƫ:0x04 */
    volatile uint32_t IFR;           //(0x40002990)
}CFGL_SFRmap;

/* ----------------------------------------------------------------------------
   -- CFGL - Ĵں
   ---------------------------------------------------------------------------- */

/* CFGL - Ĵڵַ */
#define CFGL1_ADDR                      ((uint32_t)0x40002980)
#define CFGL2_ADDR                      ((uint32_t)0x40002988)
#define CFGL1_SFR                       ((CFGL_SFRmap *) CFGL1_ADDR)
#define CFGL2_SFR                       ((CFGL_SFRmap *) CFGL2_ADDR)
#define CFGLIFR_ADDR                    ((uint32_t)0x40002988)
#define CFGLIFR_SFR                     ((CFGL_SFRmap *) CFGLIFR_ADDR)

/* CFGL - Ĵ */
#define CFGL1_CTL0                      (CFGL1_SFR->CTL0)
#define CFGL1_CTL1                      (CFGL1_SFR->CTL1)
#define CFGL2_CTL0                      (CFGL2_SFR->CTL0)
#define CFGL2_CTL1                      (CFGL2_SFR->CTL1)
#define CFGL_IFR                        (CFGLIFR_SFR->IFR)

/* CFGL_CTL0 λ */
#define CFGL_CTL0_TPSEL0_POS       		(0)
#define CFGL_CTL0_TPSEL1_POS            (1)
#define CFGL_CTL0_TPSEL2_POS            (2)
#define CFGL_CTL0_REGIN_POS             (3)
#define CFGL_CTL0_D1S0_POS              (4)
#define CFGL_CTL0_D1S1_POS              (5)
#define CFGL_CTL0_D1S2_POS              (6)
#define CFGL_CTL0_D2S0_POS      	    (8)
#define CFGL_CTL0_D2S1_POS              (9)
#define CFGL_CTL0_D2S2_POS              (10)
#define CFGL_CTL0_D3S0_POS              (12)
#define CFGL_CTL0_D3S1_POS              (13)
#define CFGL_CTL0_D3S2_POS      	    (14)
#define CFGL_CTL0_D4S0_POS              (16)
#define CFGL_CTL0_D4S1_POS              (17)
#define CFGL_CTL0_D4S2_POS      	    (18)
#define CFGL_CTL0_G1POL_POS      	    (20)
#define CFGL_CTL0_G2POL_POS      	    (21)
#define CFGL_CTL0_G3POL_POS      	    (22)
#define CFGL_CTL0_G4POL_POS      	    (23)
#define CFGL_CTL0_POL_POS      	        (24)
#define CFGL_CTL0_MD0_POS      	        (25)
#define CFGL_CTL0_MD1_POS      	        (26)
#define CFGL_CTL0_MD2_POS      	        (27)
#define CFGL_CTL0_INTN_POS      	    (28)
#define CFGL_CTL0_INTP_POS      	    (29)
#define CFGL_CTL0_OE_POS      	        (30)
#define CFGL_CTL0_EN_POS      	        (31)
#define CFGL_CTL0_TPSEL                 ((uint32_t)7<<(CFGL_CTL0_TPSEL0_POS))
#define CFGL_CTL0_TPSEL0                ((uint32_t)1<<(CFGL_CTL0_TPSEL0_POS))
#define CFGL_CTL0_TPSEL1                ((uint32_t)1<<(CFGL_CTL0_TPSEL1_POS))
#define CFGL_CTL0_TPSEL2                ((uint32_t)1<<(CFGL_CTL0_TPSEL2_POS))
#define CFGL_CTL0_REGIN                 ((uint32_t)1<<(CFGL_CTL0_REGIN_POS))
#define CFGL_CTL0_D1S                   ((uint32_t)7<<(CFGL_CTL0_D1S0_POS))
#define CFGL_CTL0_D1S0                  ((uint32_t)1<<(CFGL_CTL0_D1S0_POS))
#define CFGL_CTL0_D1S1                  ((uint32_t)1<<(CFGL_CTL0_D1S1_POS))
#define CFGL_CTL0_D1S2                  ((uint32_t)1<<(CFGL_CTL0_D1S2_POS))
#define CFGL_CTL0_D2S                   ((uint32_t)7<<(CFGL_CTL0_D2S0_POS))
#define CFGL_CTL0_D2S0                  ((uint32_t)1<<(CFGL_CTL0_D2S0_POS))
#define CFGL_CTL0_D2S1                  ((uint32_t)1<<(CFGL_CTL0_D2S1_POS))
#define CFGL_CTL0_D2S2                  ((uint32_t)1<<(CFGL_CTL0_D2S2_POS))
#define CFGL_CTL0_D3S                   ((uint32_t)7<<(CFGL_CTL0_D3S0_POS))
#define CFGL_CTL0_D3S0                  ((uint32_t)1<<(CFGL_CTL0_D3S0_POS))
#define CFGL_CTL0_D3S1                  ((uint32_t)1<<(CFGL_CTL0_D3S1_POS))
#define CFGL_CTL0_D3S2                  ((uint32_t)1<<(CFGL_CTL0_D3S2_POS))
#define CFGL_CTL0_D4S                   ((uint32_t)7<<(CFGL_CTL0_D4S0_POS))
#define CFGL_CTL0_D4S0                  ((uint32_t)1<<(CFGL_CTL0_D4S0_POS))
#define CFGL_CTL0_D4S1                  ((uint32_t)1<<(CFGL_CTL0_D4S1_POS))
#define CFGL_CTL0_D4S2                  ((uint32_t)1<<(CFGL_CTL0_D4S2_POS))
#define CFGL_CTL0_G1POL                 ((uint32_t)1<<(CFGL_CTL0_G1POL_POS))
#define CFGL_CTL0_G2POL                 ((uint32_t)1<<(CFGL_CTL0_G2POL_POS))
#define CFGL_CTL0_G3POL                 ((uint32_t)1<<(CFGL_CTL0_G3POL_POS))
#define CFGL_CTL0_G4POL                 ((uint32_t)1<<(CFGL_CTL0_G4POL_POS))
#define CFGL_CTL0_POL                   ((uint32_t)1<<(CFGL_CTL0_POL_POS))
#define CFGL_CTL0_MD                    ((uint32_t)7<<(CFGL_CTL0_MD0_POS))
#define CFGL_CTL0_MD0                   ((uint32_t)1<<(CFGL_CTL0_MD0_POS))
#define CFGL_CTL0_MD1                   ((uint32_t)1<<(CFGL_CTL0_MD1_POS))
#define CFGL_CTL0_MD2                   ((uint32_t)1<<(CFGL_CTL0_MD2_POS))
#define CFGL_CTL0_INTN                  ((uint32_t)1<<(CFGL_CTL0_INTN_POS))
#define CFGL_CTL0_INTP                  ((uint32_t)1<<(CFGL_CTL0_INTP_POS))
#define CFGL_CTL0_OE                    ((uint32_t)1<<(CFGL_CTL0_OE_POS))
#define CFGL_CTL0_EN                    ((uint32_t)1<<(CFGL_CTL0_EN_POS))

/* CFGL_CTL1 λ */
#define CFGL_CTL1_G1D1N_POS       		(0)
#define CFGL_CTL1_G1D1T_POS             (1)
#define CFGL_CTL1_G1D2N_POS             (2)
#define CFGL_CTL1_G1D2T_POS             (3)
#define CFGL_CTL1_G1D3N_POS             (4)
#define CFGL_CTL1_G1D3T_POS             (5)
#define CFGL_CTL1_G1D4N_POS             (6)
#define CFGL_CTL1_G1D4T_POS      	    (7)
#define CFGL_CTL1_G2D1N_POS             (8)
#define CFGL_CTL1_G2D1T_POS             (9)
#define CFGL_CTL1_G2D2N_POS             (10)
#define CFGL_CTL1_G2D2T_POS             (11)
#define CFGL_CTL1_G2D3N_POS      	    (12)
#define CFGL_CTL1_G2D3T_POS             (13)
#define CFGL_CTL1_G2D4N_POS             (14)
#define CFGL_CTL1_G2D4T_POS      	    (15)
#define CFGL_CTL1_G3D1N_POS      	    (16)
#define CFGL_CTL1_G3D1T_POS      	    (17)
#define CFGL_CTL1_G3D2N_POS      	    (18)
#define CFGL_CTL1_G3D2T_POS      	    (19)
#define CFGL_CTL1_G3D3N_POS      	    (20)
#define CFGL_CTL1_G3D3T_POS      	    (21)
#define CFGL_CTL1_G3D4N_POS      	    (22)
#define CFGL_CTL1_G3D4T_POS      	    (23)
#define CFGL_CTL1_G4D1N_POS      	    (24)
#define CFGL_CTL1_G4D1T_POS      	    (25)
#define CFGL_CTL1_G4D2N_POS      	    (26)
#define CFGL_CTL1_G4D2T_POS      	    (27)
#define CFGL_CTL1_G4D3N_POS      	    (28)
#define CFGL_CTL1_G4D3T_POS      	    (29)
#define CFGL_CTL1_G4D4N_POS      	    (30)
#define CFGL_CTL1_G4D4T_POS      	    (31)
#define CFGL_CTL1_G1D1N                 ((uint32_t)1<<(CFGL_CTL1_G1D1N_POS))
#define CFGL_CTL1_G1D1T                 ((uint32_t)1<<(CFGL_CTL1_G1D1T_POS))
#define CFGL_CTL1_G1D2N                 ((uint32_t)1<<(CFGL_CTL1_G1D2N_POS))
#define CFGL_CTL1_G1D2T                 ((uint32_t)1<<(CFGL_CTL1_G1D2T_POS))
#define CFGL_CTL1_G1D3N                 ((uint32_t)1<<(CFGL_CTL1_G1D3N_POS))
#define CFGL_CTL1_G1D3T                 ((uint32_t)1<<(CFGL_CTL1_G1D3T_POS))
#define CFGL_CTL1_G1D4N                 ((uint32_t)1<<(CFGL_CTL1_G1D4N_POS))
#define CFGL_CTL1_G1D4T                 ((uint32_t)1<<(CFGL_CTL1_G1D4T_POS))
#define CFGL_CTL1_G2D1N                 ((uint32_t)1<<(CFGL_CTL1_G2D1N_POS))
#define CFGL_CTL1_G2D1T                 ((uint32_t)1<<(CFGL_CTL1_G2D1T_POS))
#define CFGL_CTL1_G2D2N                 ((uint32_t)1<<(CFGL_CTL1_G2D2N_POS))
#define CFGL_CTL1_G2D2T                 ((uint32_t)1<<(CFGL_CTL1_G2D2T_POS))
#define CFGL_CTL1_G2D3N                 ((uint32_t)1<<(CFGL_CTL1_G2D3N_POS))
#define CFGL_CTL1_G2D3T                 ((uint32_t)1<<(CFGL_CTL1_G2D3T_POS))
#define CFGL_CTL1_G2D4N                 ((uint32_t)1<<(CFGL_CTL1_G2D4N_POS))
#define CFGL_CTL1_G2D4T                 ((uint32_t)1<<(CFGL_CTL1_G2D4T_POS))
#define CFGL_CTL1_G3D1N                 ((uint32_t)1<<(CFGL_CTL1_G3D1N_POS))
#define CFGL_CTL1_G3D1T                 ((uint32_t)1<<(CFGL_CTL1_G3D1T_POS))
#define CFGL_CTL1_G3D2N                 ((uint32_t)1<<(CFGL_CTL1_G3D2N_POS))
#define CFGL_CTL1_G3D2T                 ((uint32_t)1<<(CFGL_CTL1_G3D2T_POS))
#define CFGL_CTL1_G3D3N                 ((uint32_t)1<<(CFGL_CTL1_G3D3N_POS))
#define CFGL_CTL1_G3D3T                 ((uint32_t)1<<(CFGL_CTL1_G3D3T_POS))
#define CFGL_CTL1_G3D4N                 ((uint32_t)1<<(CFGL_CTL1_G3D4N_POS))
#define CFGL_CTL1_G3D4T                 ((uint32_t)1<<(CFGL_CTL1_G3D4T_POS))
#define CFGL_CTL1_G4D1N                 ((uint32_t)1<<(CFGL_CTL1_G4D1N_POS))
#define CFGL_CTL1_G4D1T                 ((uint32_t)1<<(CFGL_CTL1_G4D1T_POS))
#define CFGL_CTL1_G4D2N                 ((uint32_t)1<<(CFGL_CTL1_G4D2N_POS))
#define CFGL_CTL1_G4D2T                 ((uint32_t)1<<(CFGL_CTL1_G4D2T_POS))
#define CFGL_CTL1_G4D3N                 ((uint32_t)1<<(CFGL_CTL1_G4D3N_POS))
#define CFGL_CTL1_G4D3T                 ((uint32_t)1<<(CFGL_CTL1_G4D3T_POS))
#define CFGL_CTL1_G4D4N                 ((uint32_t)1<<(CFGL_CTL1_G4D4N_POS))
#define CFGL_CTL1_G4D4T                 ((uint32_t)1<<(CFGL_CTL1_G4D4T_POS))

/* CFGL_IFR λ */
#define CFGL_IFR_CFGL1OUT_POS       	(0)
#define CFGL_IFR_CFGL2OUT_POS           (1)
#define CFGL_IFR_CFGLIC_POS           	(2)
#define CFGL_IFR_CFGL1IF_POS            (8)
#define CFGL_IFR_CFGL2IF_POS            (9)
#define CFGL_IFR_CFGL1IE_POS            (28)
#define CFGL_IFR_CFGL2IE_POS            (29)
#define CFGL_IFR_CFGL1SYNCEN_POS        (30)
#define CFGL_IFR_CFGL2SYNCEN_POS      	(31)
#define CFGL_IFR_CFGL1OUT               ((uint32_t)1<<(CFGL_IFR_CFGL1OUT_POS))
#define CFGL_IFR_CFGL2OUT               ((uint32_t)1<<(CFGL_IFR_CFGL2OUT_POS))
#define CFGL_IFR_CFGLIC	           		((uint32_t)1<<(CFGL_IFR_CFGLIC_POS))
#define CFGL_IFR_CFGL1IF                ((uint32_t)1<<(CFGL_IFR_CFGL1IF_POS))
#define CFGL_IFR_CFGL2IF                ((uint32_t)1<<(CFGL_IFR_CFGL2IF_POS))
#define CFGL_IFR_CFGL1IE                ((uint32_t)7<<(CFGL_IFR_CFGL1IE_POS))
#define CFGL_IFR_CFGL2IE                ((uint32_t)1<<(CFGL_IFR_CFGL2IE_POS))
#define CFGL_IFR_CFGL1SYNCEN            ((uint32_t)1<<(CFGL_IFR_CFGL1SYNCEN_POS))
#define CFGL_IFR_CFGL2SYNCEN            ((uint32_t)1<<(CFGL_IFR_CFGL2SYNCEN_POS))
/* CFGL  */

#endif

#if 1										/* ECFGL */


/* ----------------------------------------------------------------------------
   -- ɱ߼ģ (ECFGL)
   ---------------------------------------------------------------------------- */

/* ECFGL ģĴڴṹ */
typedef struct ECFGL_MenMap
{
	union
	{
		struct
		{
			volatile	uint32_t ECFGL0_CTL;   		/* ECFGLƼĴ0,ƫƣ0x00 */
			volatile	uint32_t ECFGL1_CTL;   		/* ECFGLƼĴ1,ƫƣ0x04 */
			volatile 	uint32_t ECFGL2_CTL;   		/* ECFGLƼĴ2,ƫƣ0x08 */
			volatile 	uint32_t ECFGL3_CTL;   		/* ECFGLƼĴ3,ƫƣ0x0C */
			volatile 	uint32_t ECFGL4_CTL;   		/* ECFGLƼĴ4,ƫƣ0x10 */
			volatile 	uint32_t ECFGL5_CTL;   		/* ECFGLƼĴ5,ƫƣ0x14 */
			volatile 	uint32_t ECFGL6_CTL;   		/* ECFGLƼĴ6,ƫƣ0x18 */
			volatile 	uint32_t ECFGL7_CTL;   		/* ECFGLƼĴ7,ƫƣ0x1C */
			volatile 	uint32_t ECFGL8_CTL;   		/* ECFGLƼĴ8,ƫƣ0x20 */
			volatile 	uint32_t ECFGL9_CTL;   		/* ECFGLƼĴ9,ƫƣ0x24 */
			volatile 	uint32_t ECFGL10_CTL;   		/* ECFGLƼĴ10,ƫƣ0x28 */
			volatile 	uint32_t ECFGL11_CTL;   		/* ECFGLƼĴ11,ƫƣ0x2C */
			volatile 	uint32_t ECFGL12_CTL;   		/* ECFGLƼĴ12,ƫƣ0x30 */
			volatile 	uint32_t ECFGL13_CTL;   		/* ECFGLƼĴ13,ƫƣ0x34 */
			volatile 	uint32_t ECFGL14_CTL;   		/* ECFGLƼĴ14,ƫƣ0x38 */
			volatile 	uint32_t ECFGL15_CTL;   		/* ECFGLƼĴ15,ƫƣ0x3C */
		};
		volatile 	   uint32_t ECFGL_CTL[16];   		/* ECFGLƼĴ0,ƫƣ0x00 */
	};
	volatile 	   uint32_t SOFTSEL;   		/* ECFGL˲ʱӿƼĴ,ƫƣ0x40 */
	volatile 	   uint32_t FCLK;   		/* ECFGL˲ʱӿƼĴ,ƫƣ0x44 */
	volatile 	   uint32_t IC;   			/* ECFGLжĴ,ƫƣ0x48 */
	volatile 	   uint32_t IF;   			/* ECFGLжϱ־Ĵ,ƫƣ0x4C */
	volatile 	   uint32_t RFCTL;   		/* жؿƼĴ,ƫƣ0x50 */
	volatile 	   uint32_t FFCTL;   		/* жؿƼĴ,ƫƣ0x54 */
	volatile 	   uint32_t ADC;   			/* ECFGLADCƼĴ,ƫƣ0x58 */
	volatile const uint32_t OUT;      		/* ECFGL״̬Ĵ,ƫƣ0x5C */
}ECFGL_SFRmap;

/* ----------------------------------------------------------------------------
   -- ECFGL - Ĵں
   ---------------------------------------------------------------------------- */

/* ECFGL - Ĵڵַ */
#define ECFGL_ADDR                    ((uint32_t)0x40002A80)
#define ECFGL_SFR                     ((ECFGL_SFRmap *) ECFGL_ADDR)

/* ECFGL - Ĵ */
#define	ECFGL0_CTL			        (ECFGL_SFR->ECFGL_CTL[0])
#define	ECFGL1_CTL			        (ECFGL_SFR->ECFGL_CTL[1])
#define	ECFGL2_CTL			        (ECFGL_SFR->ECFGL_CTL[2])
#define	ECFGL3_CTL			        (ECFGL_SFR->ECFGL_CTL[3])
#define	ECFGL4_CTL			        (ECFGL_SFR->ECFGL_CTL[4])
#define	ECFGL5_CTL			        (ECFGL_SFR->ECFGL_CTL[5])
#define	ECFGL6_CTL			        (ECFGL_SFR->ECFGL_CTL[6])
#define	ECFGL7_CTL			        (ECFGL_SFR->ECFGL_CTL[7])
#define	ECFGL8_CTL			        (ECFGL_SFR->ECFGL_CTL[8])
#define	ECFGL9_CTL			        (ECFGL_SFR->ECFGL_CTL[9])
#define	ECFGL10_CTL			        (ECFGL_SFR->ECFGL_CTL[10])
#define	ECFGL11_CTL			        (ECFGL_SFR->ECFGL_CTL[11])
#define	ECFGL12_CTL			        (ECFGL_SFR->ECFGL_CTL[12])
#define	ECFGL13_CTL			        (ECFGL_SFR->ECFGL_CTL[13])
#define	ECFGL14_CTL			        (ECFGL_SFR->ECFGL_CTL[14])
#define	ECFGL15_CTL			        (ECFGL_SFR->ECFGL_CTL[15])
#define ECFGL_SOFTSEL   			(ECFGL_SFR->SOFTSEL)
#define ECFGL_FCLK   				(ECFGL_SFR->FCLK)
#define ECFGL_IC   					(ECFGL_SFR->IC)
#define ECFGL_IF   					(ECFGL_SFR->IF)
#define ECFGL_RFCTL   				(ECFGL_SFR->RFCTL)
#define ECFGL_FFCTL   				(ECFGL_SFR->FFCTL)
#define ECFGL_ADC   				(ECFGL_SFR->ADC)
#define ECFGL_OUT   				(ECFGL_SFR->OUT)

/* ECFGL_CTLλ */
	#define	ECFGL_CTL_MUX0SEL0_POS		(0)
	#define	ECFGL_CTL_MUX0SEL1_POS		(1)
	#define	ECFGL_CTL_MUX1SEL0_POS		(2)
	#define	ECFGL_CTL_MUX1SEL1_POS		(3)
#define	ECFGL_CTL_MUX2SEL_POS			(4)
#define	ECFGL_CTL_MUX3SEL_POS			(5)
#define	ECFGL_CTL_MUX4SEL_POS			(6)
#define	ECFGL_CTL_FLITEN_POS			(7)
#define	ECFGL_CTL_FUNSEL0_POS			(8)
#define	ECFGL_CTL_FUNSEL1_POS			(9)
#define	ECFGL_CTL_FUNSEL2_POS			(10)
#define	ECFGL_CTL_FUNSEL3_POS			(11)
#define	ECFGL_CTL_EN_POS				(12)
#define	ECFGL_CTL_MUX0SEL				((uint32_t)0x03<<(ECFGL_CTL_MUX0SEL0_POS))
#define	ECFGL_CTL_MUX0SEL0			    ((uint32_t)1<<(ECFGL_CTL_MUX0SEL0_POS))
#define	ECFGL_CTL_MUX0SEL1			    ((uint32_t)1<<(ECFGL_CTL_MUX0SEL1_POS))
#define	ECFGL_CTL_MUX1SEL				((uint32_t)0x03<<(ECFGL_CTL_MUX1SEL0_POS))
#define	ECFGL_CTL_MUX1SEL0			    ((uint32_t)1<<(ECFGL_CTL_MUX1SEL0_POS))
#define	ECFGL_CTL_MUX1SEL1			    ((uint32_t)1<<(ECFGL_CTL_MUX1SEL1_POS))
#define	ECFGL_CTL_MUX2SEL				((uint32_t)1<<(ECFGL_CTL_MUX2SEL_POS))
#define	ECFGL_CTL_MUX3SEL				((uint32_t)1<<(ECFGL_CTL_MUX3SEL_POS))
#define	ECFGL_CTL_MUX4SEL				((uint32_t)1<<(ECFGL_CTL_MUX4SEL_POS))
#define	ECFGL_CTL_FLITEN				((uint32_t)1<<(ECFGL_CTL_FLITEN_POS))
#define	ECFGL_CTL_FUNSEL				((uint32_t)0x0F<<(ECFGL_CTL_FUNSEL0_POS))
#define	ECFGL_CTL_FUNSEL0				((uint32_t)1<<(ECFGL_CTL_FUNSEL0_POS))
#define	ECFGL_CTL_FUNSEL1				((uint32_t)1<<(ECFGL_CTL_FUNSEL1_POS))
#define	ECFGL_CTL_FUNSEL2				((uint32_t)1<<(ECFGL_CTL_FUNSEL2_POS))
#define	ECFGL_CTL_FUNSEL3				((uint32_t)1<<(ECFGL_CTL_FUNSEL3_POS))
#define	ECFGL_CTL_EN					((uint32_t)1<<(ECFGL_CTL_EN_POS))

/* ECFGL_SOFTSELλ */
#define	ECFGL_SOFTSEL_ECFGL0_MUX2_SOFTSE_POS			(0)
#define	ECFGL_SOFTSEL_ECFGL1_MUX2_SOFTSE_POS			(1)
#define	ECFGL_SOFTSEL_ECFGL2_MUX2_SOFTSE_POS			(2)
#define	ECFGL_SOFTSEL_ECFGL3_MUX2_SOFTSE_POS			(3)
#define	ECFGL_SOFTSEL_ECFGL4_MUX2_SOFTSE_POS			(4)
#define	ECFGL_SOFTSEL_ECFGL5_MUX2_SOFTSE_POS			(5)
#define	ECFGL_SOFTSEL_ECFGL6_MUX2_SOFTSE_POS			(6)
#define	ECFGL_SOFTSEL_ECFGL7_MUX2_SOFTSE_POS			(7)
#define	ECFGL_SOFTSEL_ECFGL8_MUX2_SOFTSE_POS			(8)
#define	ECFGL_SOFTSEL_ECFGL9_MUX2_SOFTSE_POS			(9)
#define	ECFGL_SOFTSEL_ECFGL10_MUX2_SOFTSE_POS			(10)
#define	ECFGL_SOFTSEL_ECFGL11_MUX2_SOFTSE_POS			(11)
#define	ECFGL_SOFTSEL_ECFGL12_MUX2_SOFTSE_POS			(12)
#define	ECFGL_SOFTSEL_ECFGL13_MUX2_SOFTSE_POS			(13)
#define	ECFGL_SOFTSEL_ECFGL14_MUX2_SOFTSE_POS			(14)
#define	ECFGL_SOFTSEL_ECFGL15_MUX2_SOFTSE_POS			(15)
#define	ECFGL_SOFTSEL_ECFGL0_MUX2_SOFTSE				((uint32_t)1<<(ECFGL_SOFTSEL_ECFGL0_MUX2_SOFTSE_POS))
#define	ECFGL_SOFTSEL_ECFGL1_MUX2_SOFTSE				((uint32_t)1<<(ECFGL_SOFTSEL_ECFGL1_MUX2_SOFTSE_POS))
#define	ECFGL_SOFTSEL_ECFGL2_MUX2_SOFTSE				((uint32_t)1<<(ECFGL_SOFTSEL_ECFGL2_MUX2_SOFTSE_POS))
#define	ECFGL_SOFTSEL_ECFGL3_MUX2_SOFTSE				((uint32_t)1<<(ECFGL_SOFTSEL_ECFGL3_MUX2_SOFTSE_POS))
#define	ECFGL_SOFTSEL_ECFGL4_MUX2_SOFTSE				((uint32_t)1<<(ECFGL_SOFTSEL_ECFGL4_MUX2_SOFTSE_POS))
#define	ECFGL_SOFTSEL_ECFGL5_MUX2_SOFTSE				((uint32_t)1<<(ECFGL_SOFTSEL_ECFGL5_MUX2_SOFTSE_POS))
#define	ECFGL_SOFTSEL_ECFGL6_MUX2_SOFTSE				((uint32_t)1<<(ECFGL_SOFTSEL_ECFGL6_MUX2_SOFTSE_POS))
#define	ECFGL_SOFTSEL_ECFGL7_MUX2_SOFTSE				((uint32_t)1<<(ECFGL_SOFTSEL_ECFGL7_MUX2_SOFTSE_POS))
#define	ECFGL_SOFTSEL_ECFGL8_MUX2_SOFTSE				((uint32_t)1<<(ECFGL_SOFTSEL_ECFGL8_MUX2_SOFTSE_POS))
#define	ECFGL_SOFTSEL_ECFGL9_MUX2_SOFTSE				((uint32_t)1<<(ECFGL_SOFTSEL_ECFGL9_MUX2_SOFTSE_POS))
#define	ECFGL_SOFTSEL_ECFGL10_MUX2_SOFTSE				((uint32_t)1<<(ECFGL_SOFTSEL_ECFGL10_MUX2_SOFTSE_POS))
#define	ECFGL_SOFTSEL_ECFGL11_MUX2_SOFTSE				((uint32_t)1<<(ECFGL_SOFTSEL_ECFGL11_MUX2_SOFTSE_POS))
#define	ECFGL_SOFTSEL_ECFGL12_MUX2_SOFTSE				((uint32_t)1<<(ECFGL_SOFTSEL_ECFGL12_MUX2_SOFTSE_POS))
#define	ECFGL_SOFTSEL_ECFGL13_MUX2_SOFTSE				((uint32_t)1<<(ECFGL_SOFTSEL_ECFGL13_MUX2_SOFTSE_POS))
#define	ECFGL_SOFTSEL_ECFGL14_MUX2_SOFTSE				((uint32_t)1<<(ECFGL_SOFTSEL_ECFGL14_MUX2_SOFTSE_POS))
#define	ECFGL_SOFTSEL_ECFGL15_MUX2_SOFTSE				((uint32_t)1<<(ECFGL_SOFTSEL_ECFGL15_MUX2_SOFTSE_POS))

/* ECFGL_FCLKλ */
#define	ECFGL_FCLK_FCLKSEL0_POS				(0)
#define	ECFGL_FCLK_FCLKSEL1_POS				(1)
#define	ECFGL_FCLK_FCLKSEL2_POS				(2)
#define	ECFGL_FCLK_FCLKDIV0_POS				(4)
#define	ECFGL_FCLK_FCLKDIV1_POS				(5)
#define	ECFGL_FCLK_FCLKDIV2_POS				(6)
#define	ECFGL_FCLK_FCLKSEL					((uint32_t)0x07<<(ECFGL_FCLK_FCLKSEL0_POS))
#define	ECFGL_FCLK_FCLKSEL0				    ((uint32_t)1<<(ECFGL_FCLK_FCLKSEL0_POS))
#define	ECFGL_FCLK_FCLKSEL1				    ((uint32_t)1<<(ECFGL_FCLK_FCLKSEL1_POS))
#define	ECFGL_FCLK_FCLKSEL2				    ((uint32_t)1<<(ECFGL_FCLK_FCLKSEL2_POS))
#define	ECFGL_FCLK_FCLKDIV				    ((uint32_t)0x07<<(ECFGL_FCLK_FCLKDIV0_POS))
#define	ECFGL_FCLK_FCLKDIV0				    ((uint32_t)1<<(ECFGL_FCLK_FCLKDIV0_POS))
#define	ECFGL_FCLK_FCLKDIV1				    ((uint32_t)1<<(ECFGL_FCLK_FCLKDIV1_POS))
#define	ECFGL_FCLK_FCLKDIV2				    ((uint32_t)1<<(ECFGL_FCLK_FCLKDIV2_POS))

/* ECFGL_ICλ */
#define	ECFGL_IC_ECFGLIC0_POS				(0)
#define	ECFGL_IC_ECFGLIC1_POS				(1)
#define	ECFGL_IC_ECFGLIC2_POS				(2)
#define	ECFGL_IC_ECFGLIC3_POS				(3)
#define	ECFGL_IC_ECFGLIC4_POS				(4)
#define	ECFGL_IC_ECFGLIC5_POS				(5)
#define	ECFGL_IC_ECFGLIC6_POS				(6)
#define	ECFGL_IC_ECFGLIC7_POS				(7)
#define	ECFGL_IC_ECFGLIC8_POS				(8)
#define	ECFGL_IC_ECFGLIC9_POS				(9)
#define	ECFGL_IC_ECFGLIC10_POS				(10)
#define	ECFGL_IC_ECFGLIC11_POS				(11)
#define	ECFGL_IC_ECFGLIC12_POS				(12)
#define	ECFGL_IC_ECFGLIC13_POS				(13)
#define	ECFGL_IC_ECFGLIC14_POS				(14)
#define	ECFGL_IC_ECFGLIC15_POS				(15)
#define	ECFGL_IC_ECFGLIC				    ((uint32_t)0xFFFF<<(ECFGL_IC_ECFGLIC0_POS))
#define	ECFGL_IC_ECFGLIC0				    ((uint32_t)1<<(ECFGL_IC_ECFGLIC0_POS))
#define	ECFGL_IC_ECFGLIC1				    ((uint32_t)1<<(ECFGL_IC_ECFGLIC1_POS))
#define	ECFGL_IC_ECFGLIC2				    ((uint32_t)1<<(ECFGL_IC_ECFGLIC2_POS))
#define	ECFGL_IC_ECFGLIC3				    ((uint32_t)1<<(ECFGL_IC_ECFGLIC3_POS))
#define	ECFGL_IC_ECFGLIC4				    ((uint32_t)1<<(ECFGL_IC_ECFGLIC4_POS))
#define	ECFGL_IC_ECFGLIC5				    ((uint32_t)1<<(ECFGL_IC_ECFGLIC5_POS))
#define	ECFGL_IC_ECFGLIC6				    ((uint32_t)1<<(ECFGL_IC_ECFGLIC6_POS))
#define	ECFGL_IC_ECFGLIC7				    ((uint32_t)1<<(ECFGL_IC_ECFGLIC7_POS))
#define	ECFGL_IC_ECFGLIC8				    ((uint32_t)1<<(ECFGL_IC_ECFGLIC8_POS))
#define	ECFGL_IC_ECFGLIC9				    ((uint32_t)1<<(ECFGL_IC_ECFGLIC9_POS))
#define	ECFGL_IC_ECFGLIC10				    ((uint32_t)1<<(ECFGL_IC_ECFGLIC10_POS))
#define	ECFGL_IC_ECFGLIC11				    ((uint32_t)1<<(ECFGL_IC_ECFGLIC11_POS))
#define	ECFGL_IC_ECFGLIC12				    ((uint32_t)1<<(ECFGL_IC_ECFGLIC12_POS))
#define	ECFGL_IC_ECFGLIC13				    ((uint32_t)1<<(ECFGL_IC_ECFGLIC13_POS))
#define	ECFGL_IC_ECFGLIC14				    ((uint32_t)1<<(ECFGL_IC_ECFGLIC14_POS))
#define	ECFGL_IC_ECFGLIC15				    ((uint32_t)1<<(ECFGL_IC_ECFGLIC15_POS))

/* ECFGL_IFλ */
#define	ECFGL_IF_ECFGLIF0_POS				(0)
#define	ECFGL_IF_ECFGLIF1_POS				(1)
#define	ECFGL_IF_ECFGLIF2_POS				(2)
#define	ECFGL_IF_ECFGLIF3_POS				(3)
#define	ECFGL_IF_ECFGLIF4_POS				(4)
#define	ECFGL_IF_ECFGLIF5_POS				(5)
#define	ECFGL_IF_ECFGLIF6_POS				(6)
#define	ECFGL_IF_ECFGLIF7_POS				(7)
#define	ECFGL_IF_ECFGLIF8_POS				(8)
#define	ECFGL_IF_ECFGLIF9_POS				(9)
#define	ECFGL_IF_ECFGLIF10_POS				(10)
#define	ECFGL_IF_ECFGLIF11_POS				(11)
#define	ECFGL_IF_ECFGLIF12_POS				(12)
#define	ECFGL_IF_ECFGLIF13_POS				(13)
#define	ECFGL_IF_ECFGLIF14_POS				(14)
#define	ECFGL_IF_ECFGLIF15_POS				(15)
#define	ECFGL_IF_ECFGLIF				    ((uint32_t)0xFFFF<<(ECFGL_IF_ECFGLIF0_POS))
#define	ECFGL_IF_ECFGLIF0				    ((uint32_t)1<<(ECFGL_IF_ECFGLIF0_POS))
#define	ECFGL_IF_ECFGLIF1				    ((uint32_t)1<<(ECFGL_IF_ECFGLIF1_POS))
#define	ECFGL_IF_ECFGLIF2				    ((uint32_t)1<<(ECFGL_IF_ECFGLIF2_POS))
#define	ECFGL_IF_ECFGLIF3				    ((uint32_t)1<<(ECFGL_IF_ECFGLIF3_POS))
#define	ECFGL_IF_ECFGLIF4				    ((uint32_t)1<<(ECFGL_IF_ECFGLIF4_POS))
#define	ECFGL_IF_ECFGLIF5				    ((uint32_t)1<<(ECFGL_IF_ECFGLIF5_POS))
#define	ECFGL_IF_ECFGLIF6				    ((uint32_t)1<<(ECFGL_IF_ECFGLIF6_POS))
#define	ECFGL_IF_ECFGLIF7				    ((uint32_t)1<<(ECFGL_IF_ECFGLIF7_POS))
#define	ECFGL_IF_ECFGLIF8				    ((uint32_t)1<<(ECFGL_IF_ECFGLIF8_POS))
#define	ECFGL_IF_ECFGLIF9				    ((uint32_t)1<<(ECFGL_IF_ECFGLIF9_POS))
#define	ECFGL_IF_ECFGLIF10				    ((uint32_t)1<<(ECFGL_IF_ECFGLIF10_POS))
#define	ECFGL_IF_ECFGLIF11				    ((uint32_t)1<<(ECFGL_IF_ECFGLIF11_POS))
#define	ECFGL_IF_ECFGLIF12				    ((uint32_t)1<<(ECFGL_IF_ECFGLIF12_POS))
#define	ECFGL_IF_ECFGLIF13				    ((uint32_t)1<<(ECFGL_IF_ECFGLIF13_POS))
#define	ECFGL_IF_ECFGLIF14				    ((uint32_t)1<<(ECFGL_IF_ECFGLIF14_POS))
#define	ECFGL_IF_ECFGLIF15				    ((uint32_t)1<<(ECFGL_IF_ECFGLIF15_POS)

/* ECFGL_RFCTLλ */
#define	ECFGL_RFCTL_ECFGLR0_POS				(0)
#define	ECFGL_RFCTL_ECFGLR1_POS				(1)
#define	ECFGL_RFCTL_ECFGLR2_POS				(2)
#define	ECFGL_RFCTL_ECFGLR3_POS				(3)
#define	ECFGL_RFCTL_ECFGLR4_POS				(4)
#define	ECFGL_RFCTL_ECFGLR5_POS				(5)
#define	ECFGL_RFCTL_ECFGLR6_POS				(6)
#define	ECFGL_RFCTL_ECFGLR7_POS				(7)
#define	ECFGL_RFCTL_ECFGLR8_POS				(8)
#define	ECFGL_RFCTL_ECFGLR9_POS				(9)
#define	ECFGL_RFCTL_ECFGLR10_POS			(10)
#define	ECFGL_RFCTL_ECFGLR11_POS			(11)
#define	ECFGL_RFCTL_ECFGLR12_POS			(12)
#define	ECFGL_RFCTL_ECFGLR13_POS			(13)
#define	ECFGL_RFCTL_ECFGLR14_POS			(14)
#define	ECFGL_RFCTL_ECFGLR15_POS			(15)
#define	ECFGL_RFCTL_ECFGLR				    ((uint32_t)0xFFFF<<(ECFGL_RFCTL_ECFGLR0_POS))
#define	ECFGL_RFCTL_ECFGLR0				    ((uint32_t)1<<(ECFGL_RFCTL_ECFGLR0_POS))
#define	ECFGL_RFCTL_ECFGLR1				    ((uint32_t)1<<(ECFGL_RFCTL_ECFGLR1_POS))
#define	ECFGL_RFCTL_ECFGLR2				    ((uint32_t)1<<(ECFGL_RFCTL_ECFGLR2_POS))
#define	ECFGL_RFCTL_ECFGLR3				    ((uint32_t)1<<(ECFGL_RFCTL_ECFGLR3_POS))
#define	ECFGL_RFCTL_ECFGLR4				    ((uint32_t)1<<(ECFGL_RFCTL_ECFGLR4_POS))
#define	ECFGL_RFCTL_ECFGLR5				    ((uint32_t)1<<(ECFGL_RFCTL_ECFGLR5_POS))
#define	ECFGL_RFCTL_ECFGLR6				    ((uint32_t)1<<(ECFGL_RFCTL_ECFGLR6_POS))
#define	ECFGL_RFCTL_ECFGLR7				    ((uint32_t)1<<(ECFGL_RFCTL_ECFGLR7_POS))
#define	ECFGL_RFCTL_ECFGLR8				    ((uint32_t)1<<(ECFGL_RFCTL_ECFGLR8_POS))
#define	ECFGL_RFCTL_ECFGLR9				    ((uint32_t)1<<(ECFGL_RFCTL_ECFGLR9_POS))
#define	ECFGL_RFCTL_ECFGLR10				((uint32_t)1<<(ECFGL_RFCTL_ECFGLR10_POS))
#define	ECFGL_RFCTL_ECFGLR11				((uint32_t)1<<(ECFGL_RFCTL_ECFGLR11_POS))
#define	ECFGL_RFCTL_ECFGLR12				((uint32_t)1<<(ECFGL_RFCTL_ECFGLR12_POS))
#define	ECFGL_RFCTL_ECFGLR13				((uint32_t)1<<(ECFGL_RFCTL_ECFGLR13_POS))
#define	ECFGL_RFCTL_ECFGLR14				((uint32_t)1<<(ECFGL_RFCTL_ECFGLR14_POS))
#define	ECFGL_RFCTL_ECFGLR15				((uint32_t)1<<(ECFGL_RFCTL_ECFGLR15_POS))

/* ECFGL_FFCTLλ */
#define	ECFGL_FFCTL_ECFGLF0_POS				(0)
#define	ECFGL_FFCTL_ECFGLF1_POS				(1)
#define	ECFGL_FFCTL_ECFGLF2_POS				(2)
#define	ECFGL_FFCTL_ECFGLF3_POS				(3)
#define	ECFGL_FFCTL_ECFGLF4_POS				(4)
#define	ECFGL_FFCTL_ECFGLF5_POS				(5)
#define	ECFGL_FFCTL_ECFGLF6_POS				(6)
#define	ECFGL_FFCTL_ECFGLF7_POS				(7)
#define	ECFGL_FFCTL_ECFGLF8_POS				(8)
#define	ECFGL_FFCTL_ECFGLF9_POS				(9)
#define	ECFGL_FFCTL_ECFGLF10_POS			(10)
#define	ECFGL_FFCTL_ECFGLF11_POS			(11)
#define	ECFGL_FFCTL_ECFGLF12_POS			(12)
#define	ECFGL_FFCTL_ECFGLF13_POS			(13)
#define	ECFGL_FFCTL_ECFGLF14_POS			(14)
#define	ECFGL_FFCTL_ECFGLF15_POS			(15)
#define	ECFGL_FFCTL_ECFGLF				    ((uint32_t)0xFFFF<<(ECFGL_FFCTL_ECFGLF0_POS))
#define	ECFGL_FFCTL_ECFGLF0				    ((uint32_t)1<<(ECFGL_FFCTL_ECFGLF0_POS))
#define	ECFGL_FFCTL_ECFGLF1				    ((uint32_t)1<<(ECFGL_FFCTL_ECFGLF1_POS))
#define	ECFGL_FFCTL_ECFGLF2				    ((uint32_t)1<<(ECFGL_FFCTL_ECFGLF2_POS))
#define	ECFGL_FFCTL_ECFGLF3				    ((uint32_t)1<<(ECFGL_FFCTL_ECFGLF3_POS))
#define	ECFGL_FFCTL_ECFGLF4				    ((uint32_t)1<<(ECFGL_FFCTL_ECFGLF4_POS))
#define	ECFGL_FFCTL_ECFGLF5				    ((uint32_t)1<<(ECFGL_FFCTL_ECFGLF5_POS))
#define	ECFGL_FFCTL_ECFGLF6				    ((uint32_t)1<<(ECFGL_FFCTL_ECFGLF6_POS))
#define	ECFGL_FFCTL_ECFGLF7				    ((uint32_t)1<<(ECFGL_FFCTL_ECFGLF7_POS))
#define	ECFGL_FFCTL_ECFGLF8				    ((uint32_t)1<<(ECFGL_FFCTL_ECFGLF8_POS))
#define	ECFGL_FFCTL_ECFGLF9				    ((uint32_t)1<<(ECFGL_FFCTL_ECFGLF9_POS))
#define	ECFGL_FFCTL_ECFGLF10				((uint32_t)1<<(ECFGL_FFCTL_ECFGLF10_POS))
#define	ECFGL_FFCTL_ECFGLF11				((uint32_t)1<<(ECFGL_FFCTL_ECFGLF11_POS))
#define	ECFGL_FFCTL_ECFGLF12				((uint32_t)1<<(ECFGL_FFCTL_ECFGLF12_POS))
#define	ECFGL_FFCTL_ECFGLF13				((uint32_t)1<<(ECFGL_FFCTL_ECFGLF13_POS))
#define	ECFGL_FFCTL_ECFGLF14				((uint32_t)1<<(ECFGL_FFCTL_ECFGLF14_POS))
#define	ECFGL_FFCTL_ECFGLF15				((uint32_t)1<<(ECFGL_FFCTL_ECFGLF15_POS))

/* ECFGL_ADCλ */
#define	ECFGL_ADC_ADCTRISEL0_POS			(0)
#define	ECFGL_ADC_ADCTRISEL1_POS			(1)
#define	ECFGL_ADC_ADCTRISEL2_POS			(2)
#define	ECFGL_ADC_ADCTRISEL3_POS			(3)
#define	ECFGL_ADC_ADCTRIEN_POS			    (4)
#define	ECFGL_ADC_ADCTRISEL				    ((uint32_t)0x0F<<(ECFGL_ADC_ADCTRISEL0_POS))
#define	ECFGL_ADC_ADCTRISEL0				((uint32_t)1<<(ECFGL_ADC_ADCTRISEL0_POS))
#define	ECFGL_ADC_ADCTRISEL1				((uint32_t)1<<(ECFGL_ADC_ADCTRISEL1_POS))
#define	ECFGL_ADC_ADCTRISEL2				((uint32_t)1<<(ECFGL_ADC_ADCTRISEL2_POS))
#define	ECFGL_ADC_ADCTRISEL3				((uint32_t)1<<(ECFGL_ADC_ADCTRISEL3_POS))
#define	ECFGL_ADC_ADCTRIEN				    ((uint32_t)1<<(ECFGL_ADC_ADCTRIEN_POS))

/* ECFGLx_OUTλ */
#define	ECFGL_OUT_ECFGL0OUT_POS				(0)
#define	ECFGL_OUT_ECFGL1OUT_POS				(1)
#define	ECFGL_OUT_ECFGL2OUT_POS				(2)
#define	ECFGL_OUT_ECFGL3OUT_POS				(3)
#define	ECFGL_OUT_ECFGL4OUT_POS				(4)
#define	ECFGL_OUT_ECFGL5OUT_POS				(5)
#define	ECFGL_OUT_ECFGL6OUT_POS				(6)
#define	ECFGL_OUT_ECFGL7OUT_POS				(7)
#define	ECFGL_OUT_ECFGL8OUT_POS				(8)
#define	ECFGL_OUT_ECFGL9OUT_POS				(9)
#define	ECFGL_OUT_ECFGL10OUT_POS			(10)
#define	ECFGL_OUT_ECFGL11OUT_POS			(11)
#define	ECFGL_OUT_ECFGL12OUT_POS			(12)
#define	ECFGL_OUT_ECFGL13OUT_POS			(13)
#define	ECFGL_OUT_ECFGL14OUT_POS			(14)
#define	ECFGL_OUT_ECFGL15OUT_POS			(15)
#define	ECFGL_OUT_ECFGL0OUT				    ((uint32_t)1<<(ECFGL_OUT_ECFGL0OUT_POS))
#define	ECFGL_OUT_ECFGL1OUT				    ((uint32_t)1<<(ECFGL_OUT_ECFGL1OUT_POS))
#define	ECFGL_OUT_ECFGL2OUT				    ((uint32_t)1<<(ECFGL_OUT_ECFGL2OUT_POS))
#define	ECFGL_OUT_ECFGL3OUT				    ((uint32_t)1<<(ECFGL_OUT_ECFGL3OUT_POS))
#define	ECFGL_OUT_ECFGL4OUT				    ((uint32_t)1<<(ECFGL_OUT_ECFGL4OUT_POS))
#define	ECFGL_OUT_ECFGL5OUT				    ((uint32_t)1<<(ECFGL_OUT_ECFGL5OUT_POS))
#define	ECFGL_OUT_ECFGL6OUT				    ((uint32_t)1<<(ECFGL_OUT_ECFGL6OUT_POS))
#define	ECFGL_OUT_ECFGL7OUT				    ((uint32_t)1<<(ECFGL_OUT_ECFGL7OUT_POS))
#define	ECFGL_OUT_ECFGL8OUT				    ((uint32_t)1<<(ECFGL_OUT_ECFGL8OUT_POS))
#define	ECFGL_OUT_ECFGL9OUT				    ((uint32_t)1<<(ECFGL_OUT_ECFGL9OUT_POS))
#define	ECFGL_OUT_ECFGL10OUT				((uint32_t)1<<(ECFGL_OUT_ECFGL10OUT_POS))
#define	ECFGL_OUT_ECFGL11OUT				((uint32_t)1<<(ECFGL_OUT_ECFGL11OUT_POS))
#define	ECFGL_OUT_ECFGL12OUT				((uint32_t)1<<(ECFGL_OUT_ECFGL12OUT_POS))
#define	ECFGL_OUT_ECFGL13OUT				((uint32_t)1<<(ECFGL_OUT_ECFGL13OUT_POS))
#define	ECFGL_OUT_ECFGL14OUT				((uint32_t)1<<(ECFGL_OUT_ECFGL14OUT_POS))
#define	ECFGL_OUT_ECFGL15OUT				((uint32_t)1<<(ECFGL_OUT_ECFGL15OUT_POS))
/* ECFGL ģ鶨 */

#endif

#if 1										/* RESET */

/* ----------------------------------------------------------------------------
   -- λ(RST)
   ---------------------------------------------------------------------------- */

/* RST - Ĵڴṹ */
typedef struct RST_MemMap
{
    volatile uint32_t CTL0;             /* λƼĴ0, ƫ:0x0 */
    volatile uint32_t CTL1;             /* λƼĴ1, ƫ:0x4 */
    volatile uint32_t CTL2;             /* λƼĴ2, ƫ:0x8 */
    volatile uint32_t CTL3;             /* λƼĴ3, ƫ:0xC */
}RST_SFRmap;

/* ----------------------------------------------------------------------------
   -- RST - Ĵں
   ---------------------------------------------------------------------------- */

/* RST - Ĵڵַ */
#define RST_ADDR                        ((uint32_t)0x40001500)
#define RST_SFR                         ((RST_SFRmap *) RST_ADDR)

/* RST_SFR - Ĵ */
#define RST_CTL0                        (RST_SFR->CTL0)
#define RST_CTL1                        (RST_SFR->CTL1)
#define RST_CTL2                        (RST_SFR->CTL2)
#define RST_CTL3                        (RST_SFR->CTL3)

/* RST_CTL0 λ */
#define RST_CTL0_GPIOARST_POS           (0)
#define RST_CTL0_GPIOBRST_POS           (1)
#define RST_CTL0_GPIOCRST_POS           (2)
#define RST_CTL0_GPIODRST_POS           (3)
#define RST_CTL0_GPIOERST_POS           (4)
#define RST_CTL0_GPIOFRST_POS           (5)
#define RST_CTL0_GPIOGRST_POS           (6)
#define RST_CTL0_GPIOHRST_POS           (7)
#define RST_CTL0_GPIOARST               ((uint32_t)1<<(RST_CTL0_GPIOARST_POS))
#define RST_CTL0_GPIOBRST               ((uint32_t)1<<(RST_CTL0_GPIOBRST_POS))
#define RST_CTL0_GPIOCRST               ((uint32_t)1<<(RST_CTL0_GPIOCRST_POS))
#define RST_CTL0_GPIODRST               ((uint32_t)1<<(RST_CTL0_GPIODRST_POS))
#define RST_CTL0_GPIOERST               ((uint32_t)1<<(RST_CTL0_GPIOERST_POS))
#define RST_CTL0_GPIOFRST               ((uint32_t)1<<(RST_CTL0_GPIOFRST_POS))
#define RST_CTL0_GPIOGRST               ((uint32_t)1<<(RST_CTL0_GPIOGRST_POS))
#define RST_CTL0_GPIOHRST               ((uint32_t)1<<(RST_CTL0_GPIOHRST_POS))

/* RST_CTL1 λ */
#define RST_CTL1_QEI1RST_POS            (1)
#define RST_CTL1_T1RST_POS              (2)
#define RST_CTL1_T2RST_POS              (3)
#define RST_CTL1_T3RST_POS              (4)
#define RST_CTL1_T4RST_POS              (5)
#define RST_CTL1_T5T6RST_POS            (6)
#define RST_CTL1_QEI0RST_POS            (10)
#define RST_CTL1_ADC0RST_POS            (11)
#define RST_CTL1_ADC1RST_POS            (12)
#define RST_CTL1_ADC2RST_POS            (13)
#define RST_CTL1_DAC0RST_POS            (14)
#define RST_CTL1_DAC1RST_POS            (15)
#define RST_CTL1_CMPRST_POS             (16)
#define RST_CTL1_T0RST_POS              (17)
#define RST_CTL1_USART0RST_POS          (19)
#define RST_CTL1_USART1RST_POS          (20)
#define RST_CTL1_USART2RST_POS          (21)
#define RST_CTL1_USART4RST_POS          (23)
#define RST_CTL1_SPI0RST_POS            (24)
#define RST_CTL1_SPI1RST_POS            (25)
#define RST_CTL1_I2C0RST_POS            (26)
#define RST_CTL1_I2C1RST_POS            (27)
#define RST_CTL1_I2C2RST_POS            (28)
#define RST_CTL1_QEI1RST                ((uint32_t)1<<(RST_CTL1_QEI1RST_POS))
#define RST_CTL1_T1RST                  ((uint32_t)1<<(RST_CTL1_T1RST_POS))
#define RST_CTL1_T2RST                  ((uint32_t)1<<(RST_CTL1_T2RST_POS))
#define RST_CTL1_T3RST                  ((uint32_t)1<<(RST_CTL1_T3RST_POS))
#define RST_CTL1_T4RST                  ((uint32_t)1<<(RST_CTL1_T4RST_POS))
#define RST_CTL1_T5T6RST                ((uint32_t)1<<(RST_CTL1_T5T6RST_POS))
#define RST_CTL1_QEI0RST                ((uint32_t)1<<(RST_CTL1_QEI0RST_POS))
#define RST_CTL1_ADC0RST                ((uint32_t)1<<(RST_CTL1_ADC0RST_POS))
#define RST_CTL1_ADC1RST                ((uint32_t)1<<(RST_CTL1_ADC1RST_POS))
#define RST_CTL1_ADC2RST                ((uint32_t)1<<(RST_CTL1_ADC2RST_POS))
#define RST_CTL1_DAC0RST                ((uint32_t)1<<(RST_CTL1_DAC0RST_POS))
#define RST_CTL1_DAC1RST                ((uint32_t)1<<(RST_CTL1_DAC1RST_POS))
#define RST_CTL1_CMPRST                 ((uint32_t)1<<(RST_CTL1_CMPRST_POS))
#define RST_CTL1_T0RST                  ((uint32_t)1<<(RST_CTL1_T0RST_POS))
#define RST_CTL1_USART0RST              ((uint32_t)1<<(RST_CTL1_USART0RST_POS))
#define RST_CTL1_USART1RST              ((uint32_t)1<<(RST_CTL1_USART1RST_POS))
#define RST_CTL1_USART2RST              ((uint32_t)1<<(RST_CTL1_USART2RST_POS))
#define RST_CTL1_USART4RST              ((uint32_t)1<<(RST_CTL1_USART4RST_POS))
#define RST_CTL1_SPI0RST                ((uint32_t)1<<(RST_CTL1_SPI0RST_POS))
#define RST_CTL1_SPI1RST                ((uint32_t)1<<(RST_CTL1_SPI1RST_POS))
#define RST_CTL1_I2C0RST                ((uint32_t)1<<(RST_CTL1_I2C0RST_POS))
#define RST_CTL1_I2C1RST                ((uint32_t)1<<(RST_CTL1_I2C1RST_POS))
#define RST_CTL1_I2C2RST                ((uint32_t)1<<(RST_CTL1_I2C2RST_POS))

/* RST_CTL2 λ */
#define RST_CTL2_I2C4RST_POS            (0)
#define RST_CTL2_I2C5RST_POS            (1)
#define RST_CTL2_WWDTRST_POS            (5)
#define RST_CTL2_EPWM11TRST_POS         (8)
#define RST_CTL2_EPWM12TRST_POS         (9)
#define RST_CTL2_EPWM13TRST_POS         (10)
#define RST_CTL2_EPWM16TRST_POS         (11)
#define RST_CTL2_DMA0RST_POS            (12)
#define RST_CTL2_DMA1RST_POS            (14)
#define RST_CTL2_T14RST_POS             (16)
#define RST_CTL2_T18RST_POS             (21)
#define RST_CTL2_T19RST_POS             (22)
#define RST_CTL2_T21RST_POS             (24)
#define RST_CTL2_DAC2RST_POS            (27)
#define RST_CTL2_DAC3RST_POS            (28)
#define RST_CTL2_USART5RST_POS          (29)
#define RST_CTL2_USART7RST_POS          (31)
#define RST_CTL2_I2C4RST                ((uint32_t)1<<(RST_CTL2_I2C4RST_POS))
#define RST_CTL2_I2C5RST                ((uint32_t)1<<(RST_CTL2_I2C5RST_POS))
#define RST_CTL2_WWDTRST                ((uint32_t)1<<(RST_CTL2_WWDTRST_POS))
#define RST_CTL2_EPWM11TRST             ((uint32_t)1<<(RST_CTL2_EPWM11TRST_POS))
#define RST_CTL2_EPWM12TRST             ((uint32_t)1<<(RST_CTL2_EPWM12TRST_POS))
#define RST_CTL2_EPWM13TRST             ((uint32_t)1<<(RST_CTL2_EPWM13TRST_POS))
#define RST_CTL2_EPWM16TRST             ((uint32_t)1<<(RST_CTL2_EPWM16TRST_POS))
#define RST_CTL2_DMA0RST                ((uint32_t)1<<(RST_CTL2_DMA0RST_POS))
#define RST_CTL2_DMA1RST                ((uint32_t)1<<(RST_CTL2_DMA1RST_POS))
#define RST_CTL2_T14RST                 ((uint32_t)1<<(RST_CTL2_T14RST_POS))
#define RST_CTL2_T18RST                 ((uint32_t)1<<(RST_CTL2_T18RST_POS))
#define RST_CTL2_T19RST                 ((uint32_t)1<<(RST_CTL2_T19RST_POS))
#define RST_CTL2_T21RST                 ((uint32_t)1<<(RST_CTL2_T21RST_POS))
#define RST_CTL2_DAC2RST                ((uint32_t)1<<(RST_CTL2_DAC2RST_POS))
#define RST_CTL2_DAC3RST                ((uint32_t)1<<(RST_CTL2_DAC3RST_POS))
#define RST_CTL2_USART5RST              ((uint32_t)1<<(RST_CTL2_USART5RST_POS))
#define RST_CTL2_USART7RST              ((uint32_t)1<<(RST_CTL2_USART7RST_POS))

/* RST_CTL3 λ */
#define RST_CTL3_SPI2RST_POS            (1)
#define RST_CTL3_SPI3RST_POS            (2)
#define RST_CTL3_I2C3RST_POS            (7)
#define RST_CTL3_HRCAP0RST_POS          (8)
#define RST_CTL3_HRCAP1RST_POS          (9)
#define RST_CTL3_HRCAP2RST_POS          (10)
#define RST_CTL3_CRCRST_POS             (13)
#define RST_CTL3_AESRST_POS             (14)
#define RST_CTL3_EXICRST_POS            (16)
#define RST_CTL3_CAN4RST_POS            (17)
#define RST_CTL3_CFGLRST_POS            (19)
#define RST_CTL3_OPRST_POS              (20)
#define	RST_CTL3_FlexMUXRST_POS			(21)
#define	RST_CTL3_FDC0RST_POS			(22)
#define	RST_CTL3_FDC1RST_POS			(23)
#define	RST_CTL3_FDC2RST_POS			(24)
#define	RST_CTL3_FlexRMRST_POS			(25)
#define	RST_CTL3_ECFGLRST_POS				(26)
#define	RST_CTL3_EWDTRST_POS				(27)
#define	RST_CTL3_RNGRST_POS				(28)
#define	RST_CTL3_CAN6RST_POS			(29)
#define	RST_CTL3_CAN7RST_POS			(30)
#define	RST_CTL3_RTCRST_POS				(31)
#define RST_CTL3_SPI2RST                ((uint32_t)1<<(RST_CTL3_SPI2RST_POS))
#define RST_CTL3_SPI3RST                ((uint32_t)1<<(RST_CTL3_SPI3RST_POS))
#define RST_CTL3_I2C3RST                ((uint32_t)1<<(RST_CTL3_I2C3RST_POS))
#define RST_CTL3_HRCAP0RST              ((uint32_t)1<<(RST_CTL3_HRCAP0RST_POS))
#define RST_CTL3_HRCAP1RST              ((uint32_t)1<<(RST_CTL3_HRCAP1RST_POS))
#define RST_CTL3_HRCAP2RST              ((uint32_t)1<<(RST_CTL3_HRCAP2RST_POS))
#define RST_CTL3_CRCRST                 ((uint32_t)1<<(RST_CTL3_CRCRST_POS))
#define RST_CTL3_AESRST                 ((uint32_t)1<<(RST_CTL3_AESRST_POS))
#define RST_CTL3_EXICRST                ((uint32_t)1<<(RST_CTL3_EXICRST_POS))
#define RST_CTL3_CAN4RST                ((uint32_t)1<<(RST_CTL3_CAN4RST_POS))
#define RST_CTL3_CFGLRST                ((uint32_t)1<<(RST_CTL3_CFGLRST_POS))
#define RST_CTL3_OPRST                  ((uint32_t)1<<(RST_CTL3_OPRST_POS))
#define	RST_CTL3_FlexMUXRST				((uint32_t)1<<(RST_CTL3_FlexMUXRST_POS))
#define	RST_CTL3_FDC0RST				((uint32_t)1<<(RST_CTL3_FDC0RST_POS))
#define	RST_CTL3_FDC1RST				((uint32_t)1<<(RST_CTL3_FDC1RST_POS))
#define	RST_CTL3_FDC2RST				((uint32_t)1<<(RST_CTL3_FDC2RST_POS))
#define	RST_CTL3_FlexRMRST				((uint32_t)1<<(RST_CTL3_FlexRMRST_POS))
#define	RST_CTL3_ECFGLRST					((uint32_t)1<<(RST_CTL3_ECFGLRST_POS))
#define	RST_CTL3_EWDTRST					((uint32_t)1<<(RST_CTL3_EWDTRST_POS))
#define	RST_CTL3_RNGRST					((uint32_t)1<<(RST_CTL3_RNGRST_POS))
#define	RST_CTL3_CAN6RST				((uint32_t)1<<(RST_CTL3_CAN6RST_POS))
#define	RST_CTL3_CAN7RST				((uint32_t)1<<(RST_CTL3_CAN7RST_POS))
#define	RST_CTL3_RTCRST					((uint32_t)1<<(RST_CTL3_RTCRST_POS))
/* λ(RST)  */

#endif

#if 1										/* CLK_EN */

/* ----------------------------------------------------------------------------
   -- ģʱʹģ(PCLK)
   ---------------------------------------------------------------------------- */

/* PCLK - Ĵڴṹ */
typedef struct PCLK_MemMap
{
    volatile uint32_t CTL0;             /* PCLKƼĴ0, ƫ:0x00 */
    volatile uint32_t CTL1;             /* PCLKƼĴ1, ƫ:0x04 */
    volatile uint32_t CTL2;             /* PCLKƼĴ2, ƫ:0x08 */
    volatile uint32_t CTL3;             /* PCLKƼĴ3, ƫ:0x0C */
}PCLK_SFRmap;

/* ----------------------------------------------------------------------------
   -- PCLK - Ĵں
   ---------------------------------------------------------------------------- */

/* PCLK - Ĵڵַ */
#define PCLK_ADDR                       ((uint32_t)0x40002640)
#define PCLK_SFR                        ((PCLK_SFRmap *) PCLK_ADDR)

/* PCLK - Ĵ */
#define PCLK_CTL0                       (PCLK_SFR->CTL0)
#define PCLK_CTL1                       (PCLK_SFR->CTL1)
#define PCLK_CTL2                       (PCLK_SFR->CTL2)
#define PCLK_CTL3                       (PCLK_SFR->CTL3)

/* PCLK_CTL0 λ */
#define PCLK_CTL0_GPIOACLKEN_POS        (0x0)
#define PCLK_CTL0_GPIOBCLKEN_POS        (0x1)
#define PCLK_CTL0_GPIOCCLKEN_POS        (0x2)
#define PCLK_CTL0_GPIODCLKEN_POS        (0x3)
#define PCLK_CTL0_GPIOECLKEN_POS        (0x4)
#define PCLK_CTL0_GPIOFCLKEN_POS        (0x5)
#define PCLK_CTL0_GPIOGCLKEN_POS        (0x6)
#define PCLK_CTL0_GPIOHCLKEN_POS        (0x7)
#define PCLK_CTL0_GPIOACLKEN            ((uint32_t)1<<(PCLK_CTL0_GPIOACLKEN_POS))
#define PCLK_CTL0_GPIOBCLKEN            ((uint32_t)1<<(PCLK_CTL0_GPIOBCLKEN_POS))
#define PCLK_CTL0_GPIOCCLKEN            ((uint32_t)1<<(PCLK_CTL0_GPIOCCLKEN_POS))
#define PCLK_CTL0_GPIODCLKEN            ((uint32_t)1<<(PCLK_CTL0_GPIODCLKEN_POS))
#define PCLK_CTL0_GPIOECLKEN            ((uint32_t)1<<(PCLK_CTL0_GPIOECLKEN_POS))
#define PCLK_CTL0_GPIOFCLKEN            ((uint32_t)1<<(PCLK_CTL0_GPIOFCLKEN_POS))
#define PCLK_CTL0_GPIOGCLKEN            ((uint32_t)1<<(PCLK_CTL0_GPIOGCLKEN_POS))
#define PCLK_CTL0_GPIOHCLKEN            ((uint32_t)1<<(PCLK_CTL0_GPIOHCLKEN_POS))

/* PCLK_CTL1 λ */
#define PCLK_CTL1_QEI1CLKEN_POS         (1)
#define PCLK_CTL1_T1CLKEN_POS           (2)
#define PCLK_CTL1_T2CLKEN_POS           (3)
#define PCLK_CTL1_T3CLKEN_POS           (4)
#define PCLK_CTL1_T4CLKEN_POS           (5)
#define PCLK_CTL1_T5T6CLKEN_POS         (6)
#define PCLK_CTL1_QEI0CLKEN_POS         (10)
#define PCLK_CTL1_ADC0CLKEN_POS         (11)
#define PCLK_CTL1_ADC1CLKEN_POS         (12)
#define PCLK_CTL1_ADC2CLKEN_POS         (13)
#define PCLK_CTL1_DAC0CLKEN_POS         (14)
#define PCLK_CTL1_DAC1CLKEN_POS         (15)
#define PCLK_CTL1_CMPCLKEN_POS          (16)
#define PCLK_CTL1_T0CLKEN_POS           (17)
#define PCLK_CTL1_USART0CLKEN_POS       (19)
#define PCLK_CTL1_USART1CLKEN_POS       (20)
#define PCLK_CTL1_USART2CLKEN_POS       (21)
#define PCLK_CTL1_USART4CLKEN_POS       (23)
#define PCLK_CTL1_SPI0CLKEN_POS         (24)
#define PCLK_CTL1_SPI1CLKEN_POS         (25)
#define PCLK_CTL1_I2C0CLKEN_POS         (26)
#define PCLK_CTL1_I2C1CLKEN_POS         (27)
#define PCLK_CTL1_I2C2CLKEN_POS         (28)
#define PCLK_CTL1_QEI1CLKEN             ((uint32_t)1<<(PCLK_CTL1_QEI1CLKEN_POS))
#define PCLK_CTL1_T1CLKEN               ((uint32_t)1<<(PCLK_CTL1_T1CLKEN_POS))
#define PCLK_CTL1_T2CLKEN               ((uint32_t)1<<(PCLK_CTL1_T2CLKEN_POS))
#define PCLK_CTL1_T3CLKEN               ((uint32_t)1<<(PCLK_CTL1_T3CLKEN_POS))
#define PCLK_CTL1_T4CLKEN               ((uint32_t)1<<(PCLK_CTL1_T4CLKEN_POS))
#define PCLK_CTL1_T5T6CLKEN             ((uint32_t)1<<(PCLK_CTL1_T5T6CLKEN_POS))
#define PCLK_CTL1_QEI0CLKEN             ((uint32_t)1<<(PCLK_CTL1_QEI0CLKEN_POS))
#define PCLK_CTL1_ADC0CLKEN             ((uint32_t)1<<(PCLK_CTL1_ADC0CLKEN_POS))
#define PCLK_CTL1_ADC1CLKEN             ((uint32_t)1<<(PCLK_CTL1_ADC1CLKEN_POS))
#define PCLK_CTL1_ADC2CLKEN             ((uint32_t)1<<(PCLK_CTL1_ADC2CLKEN_POS))
#define PCLK_CTL1_DAC0CLKEN             ((uint32_t)1<<(PCLK_CTL1_DAC0CLKEN_POS))
#define PCLK_CTL1_DAC1CLKEN             ((uint32_t)1<<(PCLK_CTL1_DAC1CLKEN_POS))
#define PCLK_CTL1_CMPCLKEN              ((uint32_t)1<<(PCLK_CTL1_CMPCLKEN_POS))
#define PCLK_CTL1_T0CLKEN               ((uint32_t)1<<(PCLK_CTL1_T0CLKEN_POS))
#define PCLK_CTL1_USART0CLKEN           ((uint32_t)1<<(PCLK_CTL1_USART0CLKEN_POS))
#define PCLK_CTL1_USART1CLKEN           ((uint32_t)1<<(PCLK_CTL1_USART1CLKEN_POS))
#define PCLK_CTL1_USART2CLKEN           ((uint32_t)1<<(PCLK_CTL1_USART2CLKEN_POS))
#define PCLK_CTL1_USART4CLKEN           ((uint32_t)1<<(PCLK_CTL1_USART4CLKEN_POS))
#define PCLK_CTL1_SPI0CLKEN             ((uint32_t)1<<(PCLK_CTL1_SPI0CLKEN_POS))
#define PCLK_CTL1_SPI1CLKEN             ((uint32_t)1<<(PCLK_CTL1_SPI1CLKEN_POS))
#define PCLK_CTL1_I2C0CLKEN             ((uint32_t)1<<(PCLK_CTL1_I2C0CLKEN_POS))
#define PCLK_CTL1_I2C1CLKEN             ((uint32_t)1<<(PCLK_CTL1_I2C1CLKEN_POS))
#define PCLK_CTL1_I2C2CLKEN             ((uint32_t)1<<(PCLK_CTL1_I2C2CLKEN_POS))

/* PCLK_CTL2λ */
#define	PCLK_CTL2_I2C4CLKEN_POS			(0)
#define	PCLK_CTL2_I2C5CLKEN_POS			(1)
#define	PCLK_CTL2_WWDTCLKEN_POS			(5)
#define	PCLK_CTL2_EPWM11CLKEN_POS		(8)
#define	PCLK_CTL2_EPWM12CLKEN_POS		(9)
#define	PCLK_CTL2_EPWM13CLKEN_POS		(10)
#define	PCLK_CTL2_EPWM16CLKEN_POS		(11)
#define	PCLK_CTL2_DMA0CLKEN_POS			(12)
#define	PCLK_CTL2_DMA1CLKEN_POS			(14)
#define	PCLK_CTL2_T14CLKEN_POS			(16)
#define	PCLK_CTL2_T18CLKEN_POS			(21)
#define	PCLK_CTL2_T19CLKEN_POS			(22)
#define	PCLK_CTL2_T21CLKEN_POS			(24)
#define	PCLK_CTL2_DAC2CLKEN_POS			(27)
#define	PCLK_CTL2_DAC3CLKEN_POS			(28)
#define	PCLK_CTL2_USART5CLKEN_POS		(29)
#define	PCLK_CTL2_USART7CLKEN_POS		(31)
#define	PCLK_CTL2_I2C4CLKEN				((uint32_t)1<<(PCLK_CTL2_I2C4CLKEN_POS))
#define	PCLK_CTL2_I2C5CLKEN				((uint32_t)1<<(PCLK_CTL2_I2C5CLKEN_POS))
#define	PCLK_CTL2_WWDTCLKEN				((uint32_t)1<<(PCLK_CTL2_WWDTCLKEN_POS))
#define	PCLK_CTL2_EPWM11CLKEN			((uint32_t)1<<(PCLK_CTL2_EPWM11CLKEN_POS))
#define	PCLK_CTL2_EPWM12CLKEN			((uint32_t)1<<(PCLK_CTL2_EPWM12CLKEN_POS))
#define	PCLK_CTL2_EPWM13CLKEN			((uint32_t)1<<(PCLK_CTL2_EPWM13CLKEN_POS))
#define	PCLK_CTL2_EPWM16CLKEN			((uint32_t)1<<(PCLK_CTL2_EPWM16CLKEN_POS))
#define	PCLK_CTL2_DMA0CLKEN				((uint32_t)1<<(PCLK_CTL2_DMA0CLKEN_POS))
#define	PCLK_CTL2_DMA1CLKEN				((uint32_t)1<<(PCLK_CTL2_DMA1CLKEN_POS))
#define	PCLK_CTL2_T14CLKEN				((uint32_t)1<<(PCLK_CTL2_T14CLKEN_POS))
#define	PCLK_CTL2_T18CLKEN				((uint32_t)1<<(PCLK_CTL2_T18CLKEN_POS))
#define	PCLK_CTL2_T19CLKEN				((uint32_t)1<<(PCLK_CTL2_T19CLKEN_POS))
#define	PCLK_CTL2_T21CLKEN				((uint32_t)1<<(PCLK_CTL2_T21CLKEN_POS))
#define	PCLK_CTL2_DAC2CLKEN				((uint32_t)1<<(PCLK_CTL2_DAC2CLKEN_POS))
#define	PCLK_CTL2_DAC3CLKEN				((uint32_t)1<<(PCLK_CTL2_DAC3CLKEN_POS))
#define	PCLK_CTL2_USART5CLKEN			((uint32_t)1<<(PCLK_CTL2_USART5CLKEN_POS))
#define	PCLK_CTL2_USART7CLKEN			((uint32_t)1<<(PCLK_CTL2_USART7CLKEN_POS))

/* PCLK_CTL3λ */
#define	PCLK_CTL3_SPI2CLKEN_POS			(1)
#define	PCLK_CTL3_SPI3CLKEN_POS			(2)
#define	PCLK_CTL3_I2C3CLKEN_POS			(7)
#define	PCLK_CTL3_HRCAP0CLKEN_POS		(8)
#define	PCLK_CTL3_HRCAP1CLKEN_POS		(9)
#define	PCLK_CTL3_HRCAP2CLKEN_POS		(10)
#define	PCLK_CTL3_CRCCLKEN_POS			(13)
#define	PCLK_CTL3_AESCLKEN_POS			(14)
#define	PCLK_CTL3_EXICCLKEN_POS			(16)
#define	PCLK_CTL3_CAN4CLKEN_POS			(17)
#define	PCLK_CTL3_CFGLCLKEN_POS			(19)
#define	PCLK_CTL3_OPCLKEN_POS			(20)
#define	PCLK_CTL3_FlexMUXCLKEN_POS		(21)
#define	PCLK_CTL3_FDC0CLKEN_POS			(22)
#define	PCLK_CTL3_FDC1CLKEN_POS			(23)
#define	PCLK_CTL3_FDC2CLKEN_POS			(24)
#define	PCLK_CTL3_FlexRMCLKEN_POS		(25)
#define	PCLK_CTL3_ECFGLPCLKEN_POS		(26)
#define	PCLK_CTL3_EWDTCLKEN_POS			(27)
#define	PCLK_CTL3_RNGCLKEN_POS			(28)
#define	PCLK_CTL3_CAN6CLKEN_POS			(29)
#define	PCLK_CTL3_CAN7CLKEN_POS			(30)
#define	PCLK_CTL3_RTCCLKEN_POS			(31)
#define	PCLK_CTL3_SPI2CLKEN				((uint32_t)1<<(PCLK_CTL3_SPI2CLKEN_POS))
#define	PCLK_CTL3_SPI3CLKEN				((uint32_t)1<<(PCLK_CTL3_SPI3CLKEN_POS))
#define	PCLK_CTL3_I2C3CLKEN				((uint32_t)1<<(PCLK_CTL3_I2C3CLKEN_POS))
#define	PCLK_CTL3_HRCAP0CLKEN			((uint32_t)1<<(PCLK_CTL3_HRCAP0CLKEN_POS))
#define	PCLK_CTL3_HRCAP1CLKEN			((uint32_t)1<<(PCLK_CTL3_HRCAP1CLKEN_POS))
#define	PCLK_CTL3_HRCAP2CLKEN			((uint32_t)1<<(PCLK_CTL3_HRCAP2CLKEN_POS))
#define	PCLK_CTL3_CRCCLKEN				((uint32_t)1<<(PCLK_CTL3_CRCCLKEN_POS))
#define	PCLK_CTL3_AESCLKEN				((uint32_t)1<<(PCLK_CTL3_AESCLKEN_POS))
#define	PCLK_CTL3_EXICCLKEN				((uint32_t)1<<(PCLK_CTL3_EXICCLKEN_POS))
#define	PCLK_CTL3_CAN4CLKEN				((uint32_t)1<<(PCLK_CTL3_CAN4CLKEN_POS))
#define	PCLK_CTL3_CFGLCLKEN				((uint32_t)1<<(PCLK_CTL3_CFGLCLKEN_POS))
#define	PCLK_CTL3_OPCLKEN				((uint32_t)1<<(PCLK_CTL3_OPCLKEN_POS))
#define	PCLK_CTL3_FlexMUXCLKEN			((uint32_t)1<<(PCLK_CTL3_FlexMUXCLKEN_POS))
#define	PCLK_CTL3_FDC0CLKEN				((uint32_t)1<<(PCLK_CTL3_FDC0CLKEN_POS))
#define	PCLK_CTL3_FDC1CLKEN				((uint32_t)1<<(PCLK_CTL3_FDC1CLKEN_POS))
#define	PCLK_CTL3_FDC2CLKEN				((uint32_t)1<<(PCLK_CTL3_FDC2CLKEN_POS))
#define	PCLK_CTL3_FlexRMCLKEN			((uint32_t)1<<(PCLK_CTL3_FlexRMCLKEN_POS))
#define	PCLK_CTL3_ECFGLPCLKEN			((uint32_t)1<<(PCLK_CTL3_ECFGLPCLKEN_POS))
#define	PCLK_CTL3_EWDTCLKEN				((uint32_t)1<<(PCLK_CTL3_EWDTCLKEN_POS))
#define	PCLK_CTL3_RNGCLKEN				((uint32_t)1<<(PCLK_CTL3_RNGCLKEN_POS))
#define	PCLK_CTL3_CAN6CLKEN				((uint32_t)1<<(PCLK_CTL3_CAN6CLKEN_POS))
#define	PCLK_CTL3_CAN7CLKEN				((uint32_t)1<<(PCLK_CTL3_CAN7CLKEN_POS))
#define	PCLK_CTL3_RTCCLKEN				((uint32_t)1<<(PCLK_CTL3_RTCCLKEN_POS))
/* PCLK  */

#endif

#if 1										/* PM */

/* ----------------------------------------------------------------------------
   -- Դģ (PM)
   ---------------------------------------------------------------------------- */

/* PM - Ĵڴṹ */
typedef struct PM_MemMap {
    volatile       uint32_t CTL0;       /* PM ģʽƼĴ0, ƫ;0x00 */
    volatile       uint32_t CTL1;       /* PM ģʽƼĴ1, ƫ;0x04 */
    volatile const uint32_t STA0;       /* PM ģʽ״̬Ĵ0, ƫ;0x08 */
    volatile const uint32_t STA1;       /* PM ģʽ״̬Ĵ1, ƫ;0x0C */
    volatile       uint32_t STAC;       /* PM ģʽ״̬Ĵ, ƫ;0x10 */
    volatile       uint32_t CTL2;       /* PM ģʽƼĴ2, ƫ;0x14 */
    volatile       uint32_t CAL0;       /* PM У׼Ĵ0, ƫ;0X18 */
    volatile       uint32_t CAL1;       /* PM У׼Ĵ1, ƫ;0X1C */
    volatile       uint32_t CAL2;       /* PM У׼Ĵ1, ƫ;0X20 */
}PM_SFRmap;

/* ----------------------------------------------------------------------------
   -- PM - Ĵں
   ---------------------------------------------------------------------------- */
/* PM - Ĵڵַ */
#define PM_ADDR                         ((uint32_t)0x40001580)
#define PM_SFR                          ((PM_SFRmap *) PM_ADDR)

/* PM - Ĵ */
#define PM_CTL0                         (PM_SFR->CTL0)
#define PM_CTL1                         (PM_SFR->CTL1)
#define PM_STA0                         (PM_SFR->STA0)
#define PM_STA1                         (PM_SFR->STA1)
#define PM_STAC                         (PM_SFR->STAC)
#define PM_CTL2                         (PM_SFR->CTL2)
#define PM_CAL0                         (PM_SFR->CAL0)
#define PM_CAL1                         (PM_SFR->CAL1)
#define PM_CAL2                         (PM_SFR->CAL2)

/* PM_CTL0λ */
#define	PM_CTL0_LPMS0_POS				(0)
#define	PM_CTL0_LPMS1_POS				(1)
#define	PM_CTL0_LPMS2_POS				(2)
#define	PM_CTL0_MEMSEL_POS				(3)
#define	PM_CTL0_LPREN_POS				(5)
#define	PM_CTL0_OCALLOCK_POS			(6)
#define	PM_CTL0_BKPWR_POS				(7)
#define	PM_CTL0_HSIEN_POS				(8)
#define	PM_CTL0_PDMDELAY0_POS			(9)
#define	PM_CTL0_PDMDELAY1_POS			(10)
#define	PM_CTL0_PDMSEL_POS				(11)
#define	PM_CTL0_PHERIIOSEL_POS			(13)
#define	PM_CTL0_PORDELAYSEL_POS			(14)
#define	PM_CTL0_BKPPORDELAYSEL_POS		(15)
#define	PM_CTL0_IWDTRMSEL_POS			(16)
#define	PM_CTL0_LSECONF_POS				(17)
#define	PM_CTL0_LP4MEN_POS				(18)
#define	PM_CTL0_LPRAMSEL_POS			(19)
#define	PM_CTL0_DPRAMASEL_POS			(20)
#define	PM_CTL0_IWDTCLR_POS				(21)
#define	PM_CTL0_BKPREGCLR_POS			(22)
#define	PM_CTL0_LPBGON_POS				(23)
#define	PM_CTL0_LDO18EN_POS				(24)
#define	PM_CTL0_MRBGEN_POS				(25)
#define	PM_CTL0_LSEEXEN_POS				(27)
#define	PM_CTL0_LSEEN_POS				(28)
#define	PM_CTL0_LSIEN_POS				(29)
#define	PM_CTL0_VDDPORON_POS			(30)
#define	PM_CTL0_IOLATCH_POS				(31)
#define	PM_CTL0_LPMS				    ((uint32_t)0x07<<(PM_CTL0_LPMS0_POS))
#define	PM_CTL0_LPMS0				    ((uint32_t)1<<(PM_CTL0_LPMS0_POS))
#define	PM_CTL0_LPMS1				    ((uint32_t)1<<(PM_CTL0_LPMS1_POS))
#define	PM_CTL0_LPMS2				    ((uint32_t)1<<(PM_CTL0_LPMS2_POS))
#define	PM_CTL0_MEMSEL				    ((uint32_t)1<<(PM_CTL0_MEMSEL_POS))
#define	PM_CTL0_LPREN				    ((uint32_t)1<<(PM_CTL0_LPREN_POS))
#define	PM_CTL0_OCALLOCK				((uint32_t)1<<(PM_CTL0_OCALLOCK_POS))
#define	PM_CTL0_BKPWR				    ((uint32_t)1<<(PM_CTL0_BKPWR_POS))
#define	PM_CTL0_HSIEN				    ((uint32_t)1<<(PM_CTL0_HSIEN_POS))
#define	PM_CTL0_PDMDELAY				((uint32_t)0x03<<(PM_CTL0_PDMDELAY0_POS))
#define	PM_CTL0_PDMDELAY0				((uint32_t)1<<(PM_CTL0_PDMDELAY0_POS))
#define	PM_CTL0_PDMDELAY1				((uint32_t)1<<(PM_CTL0_PDMDELAY1_POS))
#define	PM_CTL0_PDMSEL				    ((uint32_t)1<<(PM_CTL0_PDMSEL_POS))
#define	PM_CTL0_PHERIIOSEL				((uint32_t)1<<(PM_CTL0_PHERIIOSEL_POS))
#define	PM_CTL0_PORDELAYSEL				((uint32_t)1<<(PM_CTL0_PORDELAYSEL_POS))
#define	PM_CTL0_BKPPORDELAYSEL			((uint32_t)1<<(PM_CTL0_BKPPORDELAYSEL_POS))
#define	PM_CTL0_IWDTRMSEL				((uint32_t)1<<(PM_CTL0_IWDTRMSEL_POS))
#define	PM_CTL0_LSECONF				    ((uint32_t)1<<(PM_CTL0_LSECONF_POS))
#define	PM_CTL0_LP4MEN				    ((uint32_t)1<<(PM_CTL0_LP4MEN_POS))
#define	PM_CTL0_LPRAMSEL				((uint32_t)1<<(PM_CTL0_LPRAMSEL_POS))
#define	PM_CTL0_DPRAMASEL				((uint32_t)1<<(PM_CTL0_DPRAMASEL_POS))
#define	PM_CTL0_IWDTCLR				    ((uint32_t)1<<(PM_CTL0_IWDTCLR_POS))
#define	PM_CTL0_BKPREGCLR				((uint32_t)1<<(PM_CTL0_BKPREGCLR_POS))
#define	PM_CTL0_LPBGON				    ((uint32_t)1<<(PM_CTL0_LPBGON_POS))
#define	PM_CTL0_LDO18EN				    ((uint32_t)1<<(PM_CTL0_LDO18EN_POS))
#define	PM_CTL0_MRBGEN				    ((uint32_t)1<<(PM_CTL0_MRBGEN_POS))
#define	PM_CTL0_LSEEXEN				    ((uint32_t)1<<(PM_CTL0_LSEEXEN_POS))
#define	PM_CTL0_LSEEN				    ((uint32_t)1<<(PM_CTL0_LSEEN_POS))
#define	PM_CTL0_LSIEN				    ((uint32_t)1<<(PM_CTL0_LSIEN_POS))
#define	PM_CTL0_VDDPORON				((uint32_t)1<<(PM_CTL0_VDDPORON_POS))
#define	PM_CTL0_IOLATCH				    ((uint32_t)1<<(PM_CTL0_IOLATCH_POS))

/* PM_CTL1λ */
#define	PM_CTL1_PVDEN_POS				(0)
#define	PM_CTL1_BKPLPRTYPE_POS		    (1)
#define	PM_CTL1_PVDS0_POS				(2)
#define	PM_CTL1_PVDS1_POS				(3)
#define	PM_CTL1_PVDS2_POS				(4)
#define	PM_CTL1_VREFEN_POS				(5)
#define	PM_CTL1_VREFSEL0_POS			(6)
#define	PM_CTL1_VREFSEL1_POS			(7)
#define	PM_CTL1_LPDEBUG_POS				(8)
#define	PM_CTL1_P18LVLSENB_POS			(9)
#define	PM_CTL1_DPRAMECCEN_POS			(10)
#define	PM_CTL1_LPCANCLKS_POS			(11)
#define	PM_CTL1_BATBORSEL0_POS			(12)
#define	PM_CTL1_BATBORSEL1_POS			(13)
#define	PM_CTL1_BATBORSEL2_POS			(14)
#define	PM_CTL1_BATBOREN_POS			(15)
#define	PM_CTL1_BUFCLKDIV0_POS			(22)
#define	PM_CTL1_BUFCLKDIV1_POS			(23)
#define	PM_CTL1_BUFCLKDIV2_POS			(24)
#define	PM_CTL1_BUFCLKEN_POS			(25)
#define	PM_CTL1_INTBUFEN_POS			(26)
#define	PM_CTL1_P18OE_POS				(27)
#define	PM_CTL1_TSOE_POS				(28)
#define	PM_CTL1_TSEN_POS				(29)
#define	PM_CTL1_LPBOREN_POS				(30)
#define	PM_CTL1_BOREN_POS				(31)
#define	PM_CTL1_PVDEN				    ((uint32_t)1<<(PM_CTL1_PVDEN_POS))
#define	PM_CTL1_BKPLPRTYPE			    ((uint32_t)1<<(PM_CTL1_BKPLPRTYPE_POS))
#define	PM_CTL1_PVDS				    ((uint32_t)0x07<<(PM_CTL1_PVDS0_POS))
#define	PM_CTL1_PVDS0				    ((uint32_t)1<<(PM_CTL1_PVDS0_POS))
#define	PM_CTL1_PVDS1				    ((uint32_t)1<<(PM_CTL1_PVDS1_POS))
#define	PM_CTL1_PVDS2				    ((uint32_t)1<<(PM_CTL1_PVDS2_POS))
#define	PM_CTL1_VREFEN				    ((uint32_t)1<<(PM_CTL1_VREFEN_POS))
#define	PM_CTL1_VREFSEL 			    ((uint32_t)0x03<<(PM_CTL1_VREFSEL0_POS))
#define	PM_CTL1_VREFSEL0			    ((uint32_t)1<<(PM_CTL1_VREFSEL0_POS))
#define	PM_CTL1_VREFSEL1			    ((uint32_t)1<<(PM_CTL1_VREFSEL1_POS))
#define	PM_CTL1_LPDEBUG				    ((uint32_t)1<<(PM_CTL1_LPDEBUG_POS))
#define	PM_CTL1_P18LVLSENB				((uint32_t)1<<(PM_CTL1_P18LVLSENB_POS))
#define	PM_CTL1_DPRAMECCEN				((uint32_t)1<<(PM_CTL1_DPRAMECCEN_POS))
#define	PM_CTL1_LPCANCLKS				((uint32_t)1<<(PM_CTL1_LPCANCLKS_POS))
#define	PM_CTL1_BATBORSEL				((uint32_t)0x07<<(PM_CTL1_BATBORSEL0_POS))
#define	PM_CTL1_BATBORSEL0				((uint32_t)1<<(PM_CTL1_BATBORSEL0_POS))
#define	PM_CTL1_BATBORSEL1				((uint32_t)1<<(PM_CTL1_BATBORSEL1_POS))
#define	PM_CTL1_BATBORSEL2				((uint32_t)1<<(PM_CTL1_BATBORSEL2_POS))
#define	PM_CTL1_BATBOREN				((uint32_t)1<<(PM_CTL1_BATBOREN_POS))
#define	PM_CTL1_BUFCLKDIV				((uint32_t)0x07<<(PM_CTL1_BUFCLKDIV0_POS))
#define	PM_CTL1_BUFCLKDIV0				((uint32_t)1<<(PM_CTL1_BUFCLKDIV0_POS))
#define	PM_CTL1_BUFCLKDIV1				((uint32_t)1<<(PM_CTL1_BUFCLKDIV1_POS))
#define	PM_CTL1_BUFCLKDIV2				((uint32_t)1<<(PM_CTL1_BUFCLKDIV2_POS))
#define	PM_CTL1_BUFCLKEN				((uint32_t)1<<(PM_CTL1_BUFCLKEN_POS))
#define	PM_CTL1_INTBUFEN				((uint32_t)1<<(PM_CTL1_INTBUFEN_POS))
#define	PM_CTL1_P18OE				    ((uint32_t)1<<(PM_CTL1_P18OE_POS))
#define	PM_CTL1_TSOE				    ((uint32_t)1<<(PM_CTL1_TSOE_POS))
#define	PM_CTL1_TSEN				    ((uint32_t)1<<(PM_CTL1_TSEN_POS))
#define	PM_CTL1_LPBOREN				    ((uint32_t)1<<(PM_CTL1_LPBOREN_POS))
#define	PM_CTL1_BOREN				    ((uint32_t)1<<(PM_CTL1_BOREN_POS))

/* PMx_CTL2λ */
#define	PM_CTL2_CAN6LPEN_POS			(0)
#define	PM_CTL2_CCP0LPEN_POS			(1)
#define	PM_CTL2_EWDTLPEN_POS			(2)
#define	PM_CTL2_USART0LPEN_POS			(3)
#define	PM_CTL2_CAN6CLKLPEN_POS			(4)
#define	PM_CTL2_CCP0CLKLPEN_POS			(5)
#define	PM_CTL2_EWDTCLKLPEN_POS			(6)
#define	PM_CTL2_USART0CLKLPEN_POS		(7)
#define	PM_CTL2_POR18SHD_POS			(8)
#define	PM_CTL2_VF12INF0_POS			(9)
#define	PM_CTL2_VF12INF1_POS			(10)
#define	PM_CTL2_VF12EN_POS				(11)
#define	PM_CTL2_RTCLPEN_POS				(14)
#define	PM_CTL2_RTCCLKLPEN_POS			(15)
#define	PM_CTL2_QEI0CLKLPEN_POS			(16)
#define	PM_CTL2_GPIOALPEN_POS			(17)
#define	PM_CTL2_QEI0LPEN_POS			(18)
#define	PM_CTL2_PMCIE_POS				(19)
#define	PM_CTL2_WKP1P_POS				(22)
#define	PM_CTL2_WKP2P_POS				(23)
#define	PM_CTL2_WKP3P_POS				(24)
#define	PM_CTL2_WKP4P_POS				(25)
#define	PM_CTL2_WKP5P_POS				(26)
#define	PM_CTL2_WKP1EN_POS				(27)
#define	PM_CTL2_WKP2EN_POS				(28)
#define	PM_CTL2_WKP3EN_POS				(29)
#define	PM_CTL2_WKP4EN_POS				(30)
#define	PM_CTL2_WKP5EN_POS				(31)
#define	PM_CTL2_CAN6LPEN				((uint32_t)1<<(PM_CTL2_CAN6LPEN_POS))
#define	PM_CTL2_CCP0LPEN				((uint32_t)1<<(PM_CTL2_CCP0LPEN_POS))
#define	PM_CTL2_EWDTLPEN				((uint32_t)1<<(PM_CTL2_EWDTLPEN_POS))
#define	PM_CTL2_USART0LPEN				((uint32_t)1<<(PM_CTL2_USART0LPEN_POS))
#define	PM_CTL2_CAN6CLKLPEN				((uint32_t)1<<(PM_CTL2_CAN6CLKLPEN_POS))
#define	PM_CTL2_CCP0CLKLPEN				((uint32_t)1<<(PM_CTL2_CCP0CLKLPEN_POS))
#define	PM_CTL2_EWDTCLKLPEN				((uint32_t)1<<(PM_CTL2_EWDTCLKLPEN_POS))
#define	PM_CTL2_USART0CLKLPEN			((uint32_t)1<<(PM_CTL2_USART0CLKLPEN_POS))
#define	PM_CTL2_POR18SHD				((uint32_t)1<<(PM_CTL2_POR18SHD_POS))
#define	PM_CTL2_VF12INF0				((uint32_t)1<<(PM_CTL2_VF12INF0_POS))
#define	PM_CTL2_VF12INF1				((uint32_t)1<<(PM_CTL2_VF12INF1_POS))
#define	PM_CTL2_VF12EN					((uint32_t)1<<(PM_CTL2_VF12EN_POS))
#define	PM_CTL2_RTCLPEN					((uint32_t)1<<(PM_CTL2_RTCLPEN_POS))
#define	PM_CTL2_RTCCLKLPEN				((uint32_t)1<<(PM_CTL2_RTCCLKLPEN_POS))
#define	PM_CTL2_QEI0CLKLPEN				((uint32_t)1<<(PM_CTL2_QEI0CLKLPEN_POS))
#define	PM_CTL2_GPIOALPEN				((uint32_t)1<<(PM_CTL2_GPIOALPEN_POS))
#define	PM_CTL2_QEI0LPEN				((uint32_t)1<<(PM_CTL2_QEI0LPEN_POS))
#define	PM_CTL2_PMCIE				    ((uint32_t)1<<(PM_CTL2_PMCIE_POS))
#define	PM_CTL2_WKP1P				    ((uint32_t)1<<(PM_CTL2_WKP1P_POS))
#define	PM_CTL2_WKP2P				    ((uint32_t)1<<(PM_CTL2_WKP2P_POS))
#define	PM_CTL2_WKP3P				    ((uint32_t)1<<(PM_CTL2_WKP3P_POS))
#define	PM_CTL2_WKP4P				    ((uint32_t)1<<(PM_CTL2_WKP4P_POS))
#define	PM_CTL2_WKP5P				    ((uint32_t)1<<(PM_CTL2_WKP5P_POS))
#define	PM_CTL2_WKP1EN				    ((uint32_t)1<<(PM_CTL2_WKP1EN_POS))
#define	PM_CTL2_WKP2EN				    ((uint32_t)1<<(PM_CTL2_WKP2EN_POS))
#define	PM_CTL2_WKP3EN				    ((uint32_t)1<<(PM_CTL2_WKP3EN_POS))
#define	PM_CTL2_WKP4EN				    ((uint32_t)1<<(PM_CTL2_WKP4EN_POS))
#define	PM_CTL2_WKP5EN				    ((uint32_t)1<<(PM_CTL2_WKP5EN_POS))

/* PM_STA0λ */
#define	PM_STA0_LPRSTA_POS				(0)
#define	PM_STA0_LPRUNF_POS				(1)
#define	PM_STA0_WSRSTF_POS				(25)
#define	PM_STA0_BORF_POS				(26)
#define	PM_STA0_PORF_POS				(27)
#define	PM_STA0_WKPPINF_POS				(28)
#define	PM_STA0_0_POS				    (29)
#define	PM_STA0_IWDTF_POS				(30)
#define	PM_STA0_RSTFC_POS				(31)
#define	PM_STA0_LPRSTA				    ((uint32_t)1<<(PM_STA0_LPRSTA_POS))
#define	PM_STA0_LPRUNF				    ((uint32_t)1<<(PM_STA0_LPRUNF_POS))
#define	PM_STA0_WSRSTF				    ((uint32_t)1<<(PM_STA0_WSRSTF_POS))
#define	PM_STA0_BORF				    ((uint32_t)1<<(PM_STA0_BORF_POS))
#define	PM_STA0_PORF				    ((uint32_t)1<<(PM_STA0_PORF_POS))
#define	PM_STA0_WKPPINF				    ((uint32_t)1<<(PM_STA0_WKPPINF_POS))
#define	PM_STA0_0					    ((uint32_t)1<<(PM_STA0_0_POS))
#define	PM_STA0_IWDTF				    ((uint32_t)1<<(PM_STA0_IWDTF_POS))
#define	PM_STA0_RSTFC				    ((uint32_t)1<<(PM_STA0_RSTFC_POS))

/* PM_STA1λ */
#define	PM_STA1_PVDSTA_POS				(0)
#define	PM_STA1_STOPERROR_POS			(18)
#define	PM_STA1_PMCERROR_POS			(19)
#define	PM_STA1_POR18STA_POS			(22)
#define	PM_STA1_PMCIF_POS				(26)
#define	PM_STA1_WKP1STA_POS				(27)
#define	PM_STA1_WKP2STA_POS				(28)
#define	PM_STA1_WKP3STA_POS				(29)
#define	PM_STA1_WKP4STA_POS				(30)
#define	PM_STA1_WKP5STA_POS				(31)
#define	PM_STA1_PVDSTA					((uint32_t)1<<(PM_STA1_PVDSTA_POS))
#define	PM_STA1_STOPERROR				((uint32_t)1<<(PM_STA1_STOPERROR_POS))
#define	PM_STA1_PMCERROR				((uint32_t)1<<(PM_STA1_PMCERROR_POS))
#define	PM_STA1_POR18STA				((uint32_t)1<<(PM_STA1_POR18STA_POS))
#define	PM_STA1_PMCIF				    ((uint32_t)1<<(PM_STA1_PMCIF_POS))
#define	PM_STA1_WKP1STA				    ((uint32_t)1<<(PM_STA1_WKP1STA_POS))
#define	PM_STA1_WKP2STA				    ((uint32_t)1<<(PM_STA1_WKP2STA_POS))
#define	PM_STA1_WKP3STA				    ((uint32_t)1<<(PM_STA1_WKP3STA_POS))
#define	PM_STA1_WKP4STA				    ((uint32_t)1<<(PM_STA1_WKP4STA_POS))
#define	PM_STA1_WKP5STA				    ((uint32_t)1<<(PM_STA1_WKP5STA_POS))

/* PM_STACλ */
#define	PM_STAC_IWDTDBGEN_POS			(25)
#define	PM_STAC_PMCIC_POS				(26)
#define	PM_STAC_WKP1SC_POS				(27)
#define	PM_STAC_WKP2SC_POS				(28)
#define	PM_STAC_WKP3SC_POS				(29)
#define	PM_STAC_WKP4SC_POS				(30)
#define	PM_STAC_WKP5SC_POS				(31)
#define	PM_STAC_IWDTDBGEN				((uint32_t)1<<(PM_STAC_IWDTDBGEN_POS))
#define	PM_STAC_PMCIC				    ((uint32_t)1<<(PM_STAC_PMCIC_POS))
#define	PM_STAC_WKP1SC				    ((uint32_t)1<<(PM_STAC_WKP1SC_POS))
#define	PM_STAC_WKP2SC				    ((uint32_t)1<<(PM_STAC_WKP2SC_POS))
#define	PM_STAC_WKP3SC				    ((uint32_t)1<<(PM_STAC_WKP3SC_POS))
#define	PM_STAC_WKP4SC				    ((uint32_t)1<<(PM_STAC_WKP4SC_POS))
#define	PM_STAC_WKP5SC				    ((uint32_t)1<<(PM_STAC_WKP5SC_POS))

/* PM_CAL0λ */
#define	PM_CAL0_BGTRIMFLLDO0_POS		(0)
#define	PM_CAL0_BGTRIMFLLDO1_POS		(1)
#define	PM_CAL0_BGTRIMFLLDO2_POS		(2)
#define	PM_CAL0_BGTRIMFLLDO3_POS		(3)
#define	PM_CAL0_BGTRIMFLLDO4_POS		(4)
#define	PM_CAL0_BGTRIMMRLDO0_POS		(5)
#define	PM_CAL0_BGTRIMMRLDO1_POS		(6)
#define	PM_CAL0_BGTRIMMRLDO2_POS		(7)
#define	PM_CAL0_BGTRIMMRLDO3_POS		(8)
#define	PM_CAL0_BGTRIMMRLDO4_POS		(9)
#define	PM_CAL0_NRST0EN_POS				(10)
#define	PM_CAL0_NRST1EN_POS				(11)
#define	PM_CAL0_MRHVTRIM0_POS			(13)
#define	PM_CAL0_MRHVTRIM1_POS			(14)
#define	PM_CAL0_MRHVEN_POS				(15)
#define	PM_CAL0_MRTRIM0_POS				(16)
#define	PM_CAL0_MRTRIM1_POS				(17)
#define	PM_CAL0_BOR_VREF_SEL_POS		(18)
#define	PM_CAL0_PM_IWDTEN_POS			(19)
#define	PM_CAL0_BORSEL0_POS				(20)
#define	PM_CAL0_BORSEL1_POS				(21)
#define	PM_CAL0_FLBGEN_POS				(22)
#define	PM_CAL0_BOR_HSEN_POS			(23)
#define	PM_CAL0_ZEROTISTRIM0_POS		(24)
#define	PM_CAL0_ZEROTISTRIM1_POS		(25)
#define	PM_CAL0_FLBG0_POS				(26)
#define	PM_CAL0_FLBG1_POS				(27)
#define	PM_CAL0_FLBG2_POS				(28)
#define	PM_CAL0_LPRSEL_POS				(29)
#define	PM_CAL0_MRBGSEL_POS				(30)
#define	PM_CAL0_BGTRIMFLLDO 			((uint32_t)0x1F<<(PM_CAL0_BGTRIMFLLDO0_POS))
#define	PM_CAL0_BGTRIMFLLDO0			((uint32_t)1<<(PM_CAL0_BGTRIMFLLDO0_POS))
#define	PM_CAL0_BGTRIMFLLDO1			((uint32_t)1<<(PM_CAL0_BGTRIMFLLDO1_POS))
#define	PM_CAL0_BGTRIMFLLDO2			((uint32_t)1<<(PM_CAL0_BGTRIMFLLDO2_POS))
#define	PM_CAL0_BGTRIMFLLDO3			((uint32_t)1<<(PM_CAL0_BGTRIMFLLDO3_POS))
#define	PM_CAL0_BGTRIMFLLDO4			((uint32_t)1<<(PM_CAL0_BGTRIMFLLDO4_POS))
#define	PM_CAL0_BGTRIMMRLDO 			((uint32_t)0x1F<<(PM_CAL0_BGTRIMMRLDO0_POS))
#define	PM_CAL0_BGTRIMMRLDO0			((uint32_t)1<<(PM_CAL0_BGTRIMMRLDO0_POS))
#define	PM_CAL0_BGTRIMMRLDO1			((uint32_t)1<<(PM_CAL0_BGTRIMMRLDO1_POS))
#define	PM_CAL0_BGTRIMMRLDO2			((uint32_t)1<<(PM_CAL0_BGTRIMMRLDO2_POS))
#define	PM_CAL0_BGTRIMMRLDO3			((uint32_t)1<<(PM_CAL0_BGTRIMMRLDO3_POS))
#define	PM_CAL0_BGTRIMMRLDO4			((uint32_t)1<<(PM_CAL0_BGTRIMMRLDO4_POS))
#define	PM_CAL0_NRST0EN				    ((uint32_t)1<<(PM_CAL0_NRST0EN_POS))
#define	PM_CAL0_NRST1EN				    ((uint32_t)1<<(PM_CAL0_NRST1EN_POS))
#define	PM_CAL0_MRHVTRIM				((uint32_t)0x03<<(PM_CAL0_MRHVTRIM0_POS))
#define	PM_CAL0_MRHVTRIM0				((uint32_t)1<<(PM_CAL0_MRHVTRIM0_POS))
#define	PM_CAL0_MRHVTRIM1				((uint32_t)1<<(PM_CAL0_MRHVTRIM1_POS))
#define	PM_CAL0_MRHVEN				    ((uint32_t)1<<(PM_CAL0_MRHVEN_POS))
#define	PM_CAL0_MRTRIM				    ((uint32_t)0x03<<(PM_CAL0_MRTRIM0_POS))
#define	PM_CAL0_MRTRIM0				    ((uint32_t)1<<(PM_CAL0_MRTRIM0_POS))
#define	PM_CAL0_MRTRIM1				    ((uint32_t)1<<(PM_CAL0_MRTRIM1_POS))
#define	PM_CAL0_BOR_VREF_SEL			((uint32_t)1<<(PM_CAL0_BOR_VREF_SEL_POS))
#define	PM_CAL0_PM_IWDTEN				((uint32_t)1<<(PM_CAL0_PM_IWDTEN_POS))
#define	PM_CAL0_BORSEL				    ((uint32_t)0x03<<(PM_CAL0_BORSEL0_POS))
#define	PM_CAL0_BORSEL0				    ((uint32_t)1<<(PM_CAL0_BORSEL0_POS))
#define	PM_CAL0_BORSEL1				    ((uint32_t)1<<(PM_CAL0_BORSEL1_POS))
#define	PM_CAL0_FLBGEN				    ((uint32_t)1<<(PM_CAL0_FLBGEN_POS))
#define	PM_CAL0_BOR_HSEN				((uint32_t)1<<(PM_CAL0_BOR_HSEN_POS))
#define	PM_CAL0_ZEROTISTRIM				((uint32_t)0x03<<(PM_CAL0_ZEROTISTRIM0_POS))
#define	PM_CAL0_ZEROTISTRIM0			((uint32_t)1<<(PM_CAL0_ZEROTISTRIM0_POS))
#define	PM_CAL0_ZEROTISTRIM1			((uint32_t)1<<(PM_CAL0_ZEROTISTRIM1_POS))
#define	PM_CAL0_FLBG				    ((uint32_t)0x07<<(PM_CAL0_FLBG0_POS))
#define	PM_CAL0_FLBG0				    ((uint32_t)1<<(PM_CAL0_FLBG0_POS))
#define	PM_CAL0_FLBG1				    ((uint32_t)1<<(PM_CAL0_FLBG1_POS))
#define	PM_CAL0_FLBG2				    ((uint32_t)1<<(PM_CAL0_FLBG2_POS))
#define	PM_CAL0_LPRSEL				    ((uint32_t)1<<(PM_CAL0_LPRSEL_POS))
#define	PM_CAL0_MRBGSEL				    ((uint32_t)1<<(PM_CAL0_MRBGSEL_POS))

/* PM_CAL1λ */
#define	PM_CAL1_LSE_TRIM_NBIAS0_POS		(0)
#define	PM_CAL1_LSE_TRIM_NBIAS1_POS		(1)
#define	PM_CAL1_LSE_TRIMBIAS0_POS		(2)
#define	PM_CAL1_LSE_TRIMBIAS1_POS		(3)
#define	PM_CAL1_LSE_TRIMBIAS2_POS		(4)
#define	PM_CAL1_LSE_TRIMBIAS3_POS		(5)
#define	PM_CAL1_LP4M_TRIM0_POS			(6)
#define	PM_CAL1_LP4M_TRIM1_POS			(7)
#define	PM_CAL1_LP4M_TRIM2_POS			(8)
#define	PM_CAL1_LP4M_TRIM3_POS			(9)
#define	PM_CAL1_LP4M_TRIM4_POS			(10)
#define	PM_CAL1_LP4M_TRIM5_POS			(11)
#define	PM_CAL1_LP4M_TRIM6_POS			(12)
#define	PM_CAL1_LP4M_TRIM7_POS			(13)
#define	PM_CAL1_LP4M_TRIM8_POS			(14)
#define	PM_CAL1_HSE_SEL_POS				(15)
#define	PM_CAL1_LPBG_TRIM_PUMP0_POS		(16)
#define	PM_CAL1_LPBG_TRIM_PUMP1_POS		(17)
#define	PM_CAL1_LPBG_TRIM_PUMP2_POS		(18)
#define	PM_CAL1_LSE_SEL_POS				(19)
#define	PM_CAL1_LP_TRIM_BIAS0_POS		(20)
#define	PM_CAL1_LP_TRIM_BIAS1_POS		(21)
#define	PM_CAL1_LP_TRIM_BIAS2_POS		(22)
#define	PM_CAL1_SPCPUR_POS				(23)
#define	PM_CAL1_LSI_TRIM_CAP0_POS		(24)
#define	PM_CAL1_LSI_TRIM_CAP1_POS		(25)
#define	PM_CAL1_LSI_TRIM_CAP2_POS		(26)
#define	PM_CAL1_LSI_TRIM_CAP3_POS		(27)
#define	PM_CAL1_LSI_TRIM_CAP4_POS		(28)
#define	PM_CAL1_LSI_TRIM_BIAS0_POS		(29)
#define	PM_CAL1_LSI_TRIM_BIAS1_POS		(30)
#define	PM_CAL1_LSI_TRIM_BIAS2_POS		(31)
#define	PM_CAL1_LSE_TRIM_NBIAS			((uint32_t)0x03<<(PM_CAL1_LSE_TRIM_NBIAS0_POS))
#define	PM_CAL1_LSE_TRIM_NBIAS0			((uint32_t)1<<(PM_CAL1_LSE_TRIM_NBIAS0_POS))
#define	PM_CAL1_LSE_TRIM_NBIAS1			((uint32_t)1<<(PM_CAL1_LSE_TRIM_NBIAS1_POS))
#define	PM_CAL1_LSE_TRIMBIAS			((uint32_t)0x0F<<(PM_CAL1_LSE_TRIMBIAS0_POS))
#define	PM_CAL1_LSE_TRIMBIAS0			((uint32_t)1<<(PM_CAL1_LSE_TRIMBIAS0_POS))
#define	PM_CAL1_LSE_TRIMBIAS1			((uint32_t)1<<(PM_CAL1_LSE_TRIMBIAS1_POS))
#define	PM_CAL1_LSE_TRIMBIAS2			((uint32_t)1<<(PM_CAL1_LSE_TRIMBIAS2_POS))
#define	PM_CAL1_LSE_TRIMBIAS3			((uint32_t)1<<(PM_CAL1_LSE_TRIMBIAS3_POS))
#define	PM_CAL1_LP4M_TRIM				((uint32_t)0x1FF<<(PM_CAL1_LP4M_TRIM0_POS))
#define	PM_CAL1_LP4M_TRIM0				((uint32_t)1<<(PM_CAL1_LP4M_TRIM0_POS))
#define	PM_CAL1_LP4M_TRIM1				((uint32_t)1<<(PM_CAL1_LP4M_TRIM1_POS))
#define	PM_CAL1_LP4M_TRIM2				((uint32_t)1<<(PM_CAL1_LP4M_TRIM2_POS))
#define	PM_CAL1_LP4M_TRIM3				((uint32_t)1<<(PM_CAL1_LP4M_TRIM3_POS))
#define	PM_CAL1_LP4M_TRIM4				((uint32_t)1<<(PM_CAL1_LP4M_TRIM4_POS))
#define	PM_CAL1_LP4M_TRIM5				((uint32_t)1<<(PM_CAL1_LP4M_TRIM5_POS))
#define	PM_CAL1_LP4M_TRIM6				((uint32_t)1<<(PM_CAL1_LP4M_TRIM6_POS))
#define	PM_CAL1_LP4M_TRIM7				((uint32_t)1<<(PM_CAL1_LP4M_TRIM7_POS))
#define	PM_CAL1_LP4M_TRIM8				((uint32_t)1<<(PM_CAL1_LP4M_TRIM8_POS))
#define	PM_CAL1_HSE_SEL					((uint32_t)1<<(PM_CAL1_HSE_SEL_POS))
#define	PM_CAL1_LPBG_TRIM_PUMP			((uint32_t)0x07<<(PM_CAL1_LPBG_TRIM_PUMP0_POS))
#define	PM_CAL1_LPBG_TRIM_PUMP0			((uint32_t)1<<(PM_CAL1_LPBG_TRIM_PUMP0_POS))
#define	PM_CAL1_LPBG_TRIM_PUMP1			((uint32_t)1<<(PM_CAL1_LPBG_TRIM_PUMP1_POS))
#define	PM_CAL1_LPBG_TRIM_PUMP2			((uint32_t)1<<(PM_CAL1_LPBG_TRIM_PUMP2_POS))
#define	PM_CAL1_LSE_SEL					((uint32_t)1<<(PM_CAL1_LSE_SEL_POS))
#define	PM_CAL1_LP_TRIM_BIAS			((uint32_t)0x07<<(PM_CAL1_LP_TRIM_BIAS0_POS))
#define	PM_CAL1_LP_TRIM_BIAS0			((uint32_t)1<<(PM_CAL1_LP_TRIM_BIAS0_POS))
#define	PM_CAL1_LP_TRIM_BIAS1			((uint32_t)1<<(PM_CAL1_LP_TRIM_BIAS1_POS))
#define	PM_CAL1_LP_TRIM_BIAS2			((uint32_t)1<<(PM_CAL1_LP_TRIM_BIAS2_POS))
#define	PM_CAL1_SPCPUR					((uint32_t)1<<(PM_CAL1_SPCPUR_POS))
#define	PM_CAL1_LSI_TRIM_CAP			((uint32_t)0x1F<<(PM_CAL1_LSI_TRIM_CAP0_POS))
#define	PM_CAL1_LSI_TRIM_CAP0			((uint32_t)1<<(PM_CAL1_LSI_TRIM_CAP0_POS))
#define	PM_CAL1_LSI_TRIM_CAP1			((uint32_t)1<<(PM_CAL1_LSI_TRIM_CAP1_POS))
#define	PM_CAL1_LSI_TRIM_CAP2			((uint32_t)1<<(PM_CAL1_LSI_TRIM_CAP2_POS))
#define	PM_CAL1_LSI_TRIM_CAP3			((uint32_t)1<<(PM_CAL1_LSI_TRIM_CAP3_POS))
#define	PM_CAL1_LSI_TRIM_CAP4			((uint32_t)1<<(PM_CAL1_LSI_TRIM_CAP4_POS))
#define	PM_CAL1_LSI_TRIM_BIAS			((uint32_t)0x07<<(PM_CAL1_LSI_TRIM_BIAS0_POS))
#define	PM_CAL1_LSI_TRIM_BIAS0			((uint32_t)1<<(PM_CAL1_LSI_TRIM_BIAS0_POS))
#define	PM_CAL1_LSI_TRIM_BIAS1			((uint32_t)1<<(PM_CAL1_LSI_TRIM_BIAS1_POS))
#define	PM_CAL1_LSI_TRIM_BIAS2			((uint32_t)1<<(PM_CAL1_LSI_TRIM_BIAS2_POS))

/* PM_CAL2λ */
#define	PM_CAL2_MRDELAYS0_POS			(0)
#define	PM_CAL2_MRDELAYS1_POS			(1)
#define	PM_CAL2_VCOREDELAYS0_POS		(2)
#define	PM_CAL2_VCOREDELAYS1_POS		(3)
#define	PM_CAL2_LPRDELAYS0_POS			(4)
#define	PM_CAL2_LPRDELAYS1_POS			(5)
#define	PM_CAL2_STOP_TEST_POS			(8)
#define	PM_CAL2_POR12NODELAY_POS		(9)
#define	PM_CAL2_DELAYUSEHSI_POS			(10)
#define	PM_CAL2_ICSPCAL12EN_POS			(12)
#define	PM_CAL2_ICSPCAL13EN_POS			(13)
#define	PM_CAL2_PMCWKPSEL_POS			(14)
#define	PM_CAL2_BGTRIMREFBUF0_POS		(16)
#define	PM_CAL2_BGTRIMREFBUF1_POS		(17)
#define	PM_CAL2_BGTRIMREFBUF2_POS		(18)
#define	PM_CAL2_BGTRIMREFBUF3_POS		(19)
#define	PM_CAL2_BGTRIMREFBUF4_POS		(20)
#define	PM_CAL2_BGTRIMREFBUF5_POS		(21)
#define	PM_CAL2_CAP_FREE_LDO_IS0_POS	(22)
#define	PM_CAL2_CAP_FREE_LDO_IS1_POS	(23)
#define	PM_CAL2_LPR12_CAPLESS_I0_POS	(24)
#define	PM_CAL2_LPR12_CAPLESS_I1_POS	(25)
#define	PM_CAL2_LPR12_CAPLESS_I2_POS	(26)
#define	PM_CAL2_LPR12_CAPLESS_I3_POS	(27)
#define	PM_CAL2_LPR12_CAPLESS_I4_POS	(28)
#define	PM_CAL2_MRDELAYS				((uint32_t)0x03<<(PM_CAL2_MRDELAYS0_POS))
#define	PM_CAL2_MRDELAYS0				((uint32_t)1<<(PM_CAL2_MRDELAYS0_POS))
#define	PM_CAL2_MRDELAYS1				((uint32_t)1<<(PM_CAL2_MRDELAYS1_POS))
#define	PM_CAL2_VCOREDELAYS 			((uint32_t)0x03<<(PM_CAL2_VCOREDELAYS0_POS))
#define	PM_CAL2_VCOREDELAYS0			((uint32_t)1<<(PM_CAL2_VCOREDELAYS0_POS))
#define	PM_CAL2_VCOREDELAYS1			((uint32_t)1<<(PM_CAL2_VCOREDELAYS1_POS))
#define	PM_CAL2_LPRDELAYS				((uint32_t)0x03<<(PM_CAL2_LPRDELAYS0_POS))
#define	PM_CAL2_LPRDELAYS0				((uint32_t)1<<(PM_CAL2_LPRDELAYS0_POS))
#define	PM_CAL2_LPRDELAYS1				((uint32_t)1<<(PM_CAL2_LPRDELAYS1_POS))
#define	PM_CAL2_STOP_TEST				((uint32_t)1<<(PM_CAL2_STOP_TEST_POS))
#define	PM_CAL2_POR12NODELAY			((uint32_t)1<<(PM_CAL2_POR12NODELAY_POS))
#define	PM_CAL2_DELAYUSEHSI				((uint32_t)1<<(PM_CAL2_DELAYUSEHSI_POS))
#define	PM_CAL2_ICSPCAL12EN				((uint32_t)1<<(PM_CAL2_ICSPCAL12EN_POS))
#define	PM_CAL2_ICSPCAL13EN				((uint32_t)1<<(PM_CAL2_ICSPCAL13EN_POS))
#define	PM_CAL2_PMCWKPSEL				((uint32_t)1<<(PM_CAL2_PMCWKPSEL_POS))
#define	PM_CAL2_BGTRIMREFBUF			((uint32_t)0x3F<<(PM_CAL2_BGTRIMREFBUF0_POS))
#define	PM_CAL2_BGTRIMREFBUF0			((uint32_t)1<<(PM_CAL2_BGTRIMREFBUF0_POS))
#define	PM_CAL2_BGTRIMREFBUF1			((uint32_t)1<<(PM_CAL2_BGTRIMREFBUF1_POS))
#define	PM_CAL2_BGTRIMREFBUF2			((uint32_t)1<<(PM_CAL2_BGTRIMREFBUF2_POS))
#define	PM_CAL2_BGTRIMREFBUF3			((uint32_t)1<<(PM_CAL2_BGTRIMREFBUF3_POS))
#define	PM_CAL2_BGTRIMREFBUF4			((uint32_t)1<<(PM_CAL2_BGTRIMREFBUF4_POS))
#define	PM_CAL2_BGTRIMREFBUF5			((uint32_t)1<<(PM_CAL2_BGTRIMREFBUF5_POS))
#define	PM_CAL2_CAP_FREE_LDO_IS 		((uint32_t)0x03<<(PM_CAL2_CAP_FREE_LDO_IS0_POS))
#define	PM_CAL2_CAP_FREE_LDO_IS0		((uint32_t)1<<(PM_CAL2_CAP_FREE_LDO_IS0_POS))
#define	PM_CAL2_CAP_FREE_LDO_IS1		((uint32_t)1<<(PM_CAL2_CAP_FREE_LDO_IS1_POS))
#define	PM_CAL2_LPR12_CAPLESS_I 		((uint32_t)0x1F<<(PM_CAL2_LPR12_CAPLESS_I0_POS))
#define	PM_CAL2_LPR12_CAPLESS_I0		((uint32_t)1<<(PM_CAL2_LPR12_CAPLESS_I0_POS))
#define	PM_CAL2_LPR12_CAPLESS_I1		((uint32_t)1<<(PM_CAL2_LPR12_CAPLESS_I1_POS))
#define	PM_CAL2_LPR12_CAPLESS_I2		((uint32_t)1<<(PM_CAL2_LPR12_CAPLESS_I2_POS))
#define	PM_CAL2_LPR12_CAPLESS_I3		((uint32_t)1<<(PM_CAL2_LPR12_CAPLESS_I3_POS))
#define	PM_CAL2_LPR12_CAPLESS_I4		((uint32_t)1<<(PM_CAL2_LPR12_CAPLESS_I4_POS))
/* PM ģ鶨 */

#endif

#if 1										/* BKP */

/* ----------------------------------------------------------------------------
   --  (BKP)
   ---------------------------------------------------------------------------- */

/* BKP - Ĵڴṹ */
typedef struct BKP_MemMap
{
    volatile uint32_t CTL;              /* ƼĴ, ƫ:0x00 */
    volatile uint32_t INT;              /* жϿƼĴ, ƫ:0x04 */
             uint32_t RESERVED[14];     /* ַ, ƫ:0x08 */
    volatile uint32_t DATA[8];         /* ݼĴ(0~7), ƫ:0x40 */
}BKP_SFRmap;

/* ----------------------------------------------------------------------------
   -- BKP - Ĵں
   ---------------------------------------------------------------------------- */

/* BKP - Ĵڵַ */
#define BKP_ADDR                        ((uint32_t)0x40001400)
#define BKP_SFR                         ((BKP_SFRmap *) BKP_ADDR)

/* BKP - Ĵ */
#define BKP_CTL                         (BKP_SFR->CTL)
#define BKP_INT                         (BKP_SFR->INT)
#define BKP_DATA0                       (BKP_SFR->DATA[0])
#define BKP_DATA1                       (BKP_SFR->DATA[1])
#define BKP_DATA2                       (BKP_SFR->DATA[2])
#define BKP_DATA3                       (BKP_SFR->DATA[3])
#define BKP_DATA4                       (BKP_SFR->DATA[4])
#define BKP_DATA5                       (BKP_SFR->DATA[5])
#define BKP_DATA6                       (BKP_SFR->DATA[6])
#define BKP_DATA7                       (BKP_SFR->DATA[7])

/* BKP_CTLλ */
#define	BKP_CTL_EXTHFBYP_POS			(1)
#define	BKP_CTL_EXTLFBYP_POS			(2)
#define	BKP_CTL_SAMCLKS_POS				(3)
#define	BKP_CTL_SYNC_POS				(4)
#define	BKP_CTL_TAMP1EN_POS				(16)
#define	BKP_CTL_TAMP2EN_POS				(17)
#define	BKP_CTL_TAMP3EN_POS				(18)
#define	BKP_CTL_TAMP1LVL_POS			(20)
#define	BKP_CTL_TAMP2LVL_POS			(21)
#define	BKP_CTL_TAMP3LVL_POS			(22)
#define	BKP_CTL_BKDRST_POS				(31)
#define	BKP_CTL_EXTHFBYP				((uint32_t)1<<(BKP_CTL_EXTHFBYP_POS))
#define	BKP_CTL_EXTLFBYP				((uint32_t)1<<(BKP_CTL_EXTLFBYP_POS))
#define	BKP_CTL_SAMCLKS				    ((uint32_t)1<<(BKP_CTL_SAMCLKS_POS))
#define	BKP_CTL_SYNC				    ((uint32_t)1<<(BKP_CTL_SYNC_POS))
#define	BKP_CTL_TAMP1EN				    ((uint32_t)1<<(BKP_CTL_TAMP1EN_POS))
#define	BKP_CTL_TAMP2EN				    ((uint32_t)1<<(BKP_CTL_TAMP2EN_POS))
#define	BKP_CTL_TAMP3EN				    ((uint32_t)1<<(BKP_CTL_TAMP3EN_POS))
#define	BKP_CTL_TAMP1LVL				((uint32_t)1<<(BKP_CTL_TAMP1LVL_POS))
#define	BKP_CTL_TAMP2LVL				((uint32_t)1<<(BKP_CTL_TAMP2LVL_POS))
#define	BKP_CTL_TAMP3LVL				((uint32_t)1<<(BKP_CTL_TAMP3LVL_POS))
#define	BKP_CTL_BKDRST				    ((uint32_t)1<<(BKP_CTL_BKDRST_POS))

/* BKP_INTλ */
#define	BKP_INT_TAMP1IC_POS				(0)
#define	BKP_INT_TAMP2IC_POS				(1)
#define	BKP_INT_TAMP3IC_POS				(2)
#define	BKP_INT_TAMP1IE_POS				(8)
#define	BKP_INT_TAMP2IE_POS				(9)
#define	BKP_INT_TAMP3IE_POS				(10)
#define	BKP_INT_TAMP1IF_POS				(16)
#define	BKP_INT_TAMP2IF_POS				(17)
#define	BKP_INT_TAMP3IF_POS				(18)
#define	BKP_INT_TAMP1IC				    ((uint32_t)1<<(BKP_INT_TAMP1IC_POS))
#define	BKP_INT_TAMP2IC				    ((uint32_t)1<<(BKP_INT_TAMP2IC_POS))
#define	BKP_INT_TAMP3IC				    ((uint32_t)1<<(BKP_INT_TAMP3IC_POS))
#define	BKP_INT_TAMP1IE				    ((uint32_t)1<<(BKP_INT_TAMP1IE_POS))
#define	BKP_INT_TAMP2IE				    ((uint32_t)1<<(BKP_INT_TAMP2IE_POS))
#define	BKP_INT_TAMP3IE				    ((uint32_t)1<<(BKP_INT_TAMP3IE_POS))
#define	BKP_INT_TAMP1IF				    ((uint32_t)1<<(BKP_INT_TAMP1IF_POS))
#define	BKP_INT_TAMP2IF				    ((uint32_t)1<<(BKP_INT_TAMP2IF_POS))
#define	BKP_INT_TAMP3IF				    ((uint32_t)1<<(BKP_INT_TAMP3IF_POS))

/* BKP_DATA λ */
#define BKP_DATA_BKPDATA0_POS           (0)
#define BKP_DATA_BKPDATA                ((uint32_t)0xFFFFFFFF<<(BKP_DATA_BKPDATA0_POS))
/*  (BKP) */

#endif

#if 1										/* FLASH */

/* ----------------------------------------------------------------------------
   -- FLASH洢 (FLASH)
   ---------------------------------------------------------------------------- */

/* FLASH - Ĵڴṹ */
typedef struct FLASH_MemMap
{
    volatile uint32_t ISPCON0;          /* FLASH ƼĴ, ƫ:0x00 */
    volatile uint32_t ISPCON1;          /* FLASH ƼĴ, ƫ:0x04 */
    volatile uint32_t ISPCMD;           /* FLASH ƼĴ, ƫ:0x08 */
    volatile uint32_t ISPTRG;           /* FLASH ƼĴ, ƫ:0x0C */
             uint32_t RESERVED1;        /* ַ, ƫ:0x10 */
    volatile uint32_t CFG;              /* FLASH ƼĴ, ƫ:0x14 */
             uint32_t RESERVED2;        /* ַ, ƫ:0x18 */
    volatile uint32_t ISPADDR;          /* FLASH ַĴ, ƫ:0x1C */
    volatile uint32_t STATE;            /* FLASH ״̬Ĵ, ƫ:0x20 */
             uint32_t RESERVED3;        /* ַ, ƫ:0x24 */
    volatile uint32_t NVMUNLOCK;        /* FLASH KEYĴ, ƫ:0x28 */
    volatile uint32_t PROUNLOCK;        /* FLASH KEYĴ, ƫ:0x2C */
    volatile uint32_t CFGUNLOCK;        /* FLASH KEYĴ, ƫ:0x30 */
             uint32_t RESERVED4;        /* ַ, ƫ:0x34 */
    volatile uint32_t CSSTART;          /* FLASH CheckSum׵ַĴ, ƫ:0x38 */
    volatile uint32_t CSSTOP;           /* FLASH CheckSumβַĴ, ƫ:0x3C */
    volatile uint32_t CSRES[4];         /* FLASH CheckSumĴ, ƫ:0x40 */
}FLASH_SFRmap;

/* ----------------------------------------------------------------------------
   -- FLASH - Ĵں
   ---------------------------------------------------------------------------- */

/* FLASH - Ĵڵַ */
#define FLASH_ADDR                      ((uint32_t)0x40200100)
#define FLASH_SFR                       ((FLASH_SFRmap *) FLASH_ADDR)

/* FLASH - Ĵ */
#define FLASH_ISPCON0                   (FLASH_SFR->ISPCON0)
#define FLASH_ISPCON1                   (FLASH_SFR->ISPCON1)
#define FLASH_ISPCMD                    (FLASH_SFR->ISPCMD)
#define FLASH_ISPTRG                    (FLASH_SFR->ISPTRG)
#define FLASH_CFG                       (FLASH_SFR->CFG)
#define FLASH_ISPADDR                   (FLASH_SFR->ISPADDR)
#define FLASH_STATE                     (FLASH_SFR->STATE)
#define FLASH_NVMUNLOCK                 (FLASH_SFR->NVMUNLOCK)
#define FLASH_PROUNLOCK                 (FLASH_SFR->PROUNLOCK)
#define FLASH_CFGUNLOCK                 (FLASH_SFR->CFGUNLOCK)
#define FLASH_CSSTART                   (FLASH_SFR->CSSTART)
#define FLASH_CSSTOP                    (FLASH_SFR->CSSTOP)
#define FLASH_CSRES0                    (FLASH_SFR->CSRES[0])
#define FLASH_CSRES1                    (FLASH_SFR->CSRES[1])
#define FLASH_CSRES2                    (FLASH_SFR->CSRES[2])
#define FLASH_CSRES3                    (FLASH_SFR->CSRES[3])

/* FLASH_ISPCON0 λ */
#define FLASH_ISPCON0_NVMLOCK_POS       (0)
#define FLASH_ISPCON0_FLASHLOCK_POS     (1)
#define FLASH_ISPCON0_CFGLOCK_POS       (2)
#define FLASH_ISPCON0_DWEN_POS          (3)
#define FLASH_ISPCON0_IFEN_POS          (4)
#define FLASH_ISPCON0_STANDBY1_POS      (5)
#define FLASH_ISPCON0_NVMLOCK           ((uint32_t)1<<(FLASH_ISPCON0_NVMLOCK_POS))
#define FLASH_ISPCON0_FLASHLOCK         ((uint32_t)1<<(FLASH_ISPCON0_FLASHLOCK_POS))
#define FLASH_ISPCON0_CFGLOCK           ((uint32_t)1<<(FLASH_ISPCON0_CFGLOCK_POS))
#define FLASH_ISPCON0_DWEN              ((uint32_t)1<<(FLASH_ISPCON0_DWEN_POS))
#define FLASH_ISPCON0_IFEN              ((uint32_t)1<<(FLASH_ISPCON0_IFEN_POS))
#define FLASH_ISPCON0_STANDBY1          ((uint32_t)1<<(FLASH_ISPCON0_STANDBY1_POS))

/* FLASH_ISPCON1 λ */
#define FLASH_ISPCON1_IPSEL_POS         (0)
#define FLASH_ISPCON1_RECALLEN_POS      (1)
#define FLASH_ISPCON1_CONFEN_POS        (2)
#define FLASH_ISPCON1_CHIPONEN_POS      (15)
#define FLASH_ISPCON1_IPSEL             ((uint32_t)1<(FLASH_ISPCON1_IPSEL_POS))
#define FLASH_ISPCON1_RECALLEN          ((uint32_t)1<(FLASH_ISPCON1_RECALLEN_POS))
#define FLASH_ISPCON1_CONFEN            ((uint32_t)1<(FLASH_ISPCON1_CONFEN_POS))
#define FLASH_ISPCON1_CHIPONEN          ((uint32_t)1<(FLASH_ISPCON1_CHIPONEN_POS))

/* FLASH_ISPCMD λ */
#define FLASH_ISPCMD_CMD0_POS           (0)
#define FLASH_ISPCMD_CMD1_POS           (1)
#define FLASH_ISPCMD_CMD2_POS           (2)
#define FLASH_ISPCMD_CMD3_POS           (3)
#define FLASH_ISPCMD_CMD4_POS           (4)
#define FLASH_ISPCMD_WSIZE0_POS         (5)
#define FLASH_ISPCMD_WSIZE1_POS         (6)
#define FLASH_ISPCMD_WSIZE2_POS         (7)
#define FLASH_ISPCMD_WSIZE3_POS         (8)
#define FLASH_ISPCMD_WSIZE4_POS         (9)
#define FLASH_ISPCMD_WSIZE5_POS         (10)
#define FLASH_ISPCMD_CMD                ((uint32_t)0x1F<<(FLASH_ISPCMD_CMD0_POS))
#define FLASH_ISPCMD_CMD0               ((uint32_t)1<<(FLASH_ISPCMD_CMD0_POS))
#define FLASH_ISPCMD_CMD1               ((uint32_t)1<<(FLASH_ISPCMD_CMD1_POS))
#define FLASH_ISPCMD_CMD2               ((uint32_t)1<<(FLASH_ISPCMD_CMD2_POS))
#define FLASH_ISPCMD_CMD3               ((uint32_t)1<<(FLASH_ISPCMD_CMD3_POS))
#define FLASH_ISPCMD_CMD4               ((uint32_t)1<<(FLASH_ISPCMD_CMD4_POS))
#define FLASH_ISPCMD_WSIZE              ((uint32_t)0x3F<<(FLASH_ISPCMD_WSIZE0_POS))
#define FLASH_ISPCMD_WSIZE0             ((uint32_t)1<<(FLASH_ISPCMD_WSIZE0_POS))
#define FLASH_ISPCMD_WSIZE1             ((uint32_t)1<<(FLASH_ISPCMD_WSIZE1_POS))
#define FLASH_ISPCMD_WSIZE2             ((uint32_t)1<<(FLASH_ISPCMD_WSIZE2_POS))
#define FLASH_ISPCMD_WSIZE3             ((uint32_t)1<<(FLASH_ISPCMD_WSIZE3_POS))
#define FLASH_ISPCMD_WSIZE4             ((uint32_t)1<<(FLASH_ISPCMD_WSIZE4_POS))
#define FLASH_ISPCMD_WSIZE5             ((uint32_t)1<<(FLASH_ISPCMD_WSIZE5_POS))

/* FLASH_ISPTRG λ */
#define FLASH_ISPTRG_ISPGO_POS          (0)
#define FLASH_ISPTRG_ISPGO              ((uint32_t)1<<(FLASH_ISPTRG_ISPGO_POS))

/* FLASH_CFG λ */
#define FLASH_CFG_TCFG0_POS             (0)
#define FLASH_CFG_TCFG1_POS             (1)
#define FLASH_CFG_TCFG2_POS             (2)
#define FLASH_CFG_TCFG3_POS             (3)
#define FLASH_CFG_PREFETCHEN_POS        (6)
#define FLASH_CFG_ECCREADEN_POS         (7)
#define FLASH_CFG_TCFG                  ((uint32_t)0xF<<(FLASH_CFG_TCFG0_POS))
#define FLASH_CFG_TCFG0                 ((uint32_t)1<<(FLASH_CFG_TCFG0_POS))
#define FLASH_CFG_TCFG1                 ((uint32_t)1<<(FLASH_CFG_TCFG1_POS))
#define FLASH_CFG_TCFG2                 ((uint32_t)1<<(FLASH_CFG_TCFG2_POS))
#define FLASH_CFG_TCFG3                 ((uint32_t)1<<(FLASH_CFG_TCFG3_POS))
#define FLASH_CFG_PREFETCHEN            ((uint32_t)1<<(FLASH_CFG_PREFETCHEN_POS))
#define FLASH_CFG_ECCREADEN             ((uint32_t)1<<(FLASH_CFG_ECCREADEN_POS))

/* FLASH_ISPADDR λ */
#define FLASH_ISPADDR_SADDR0_POS        (0)
#define FLASH_ISPADDR_SADDR1_POS        (1)
#define FLASH_ISPADDR_SADDR2_POS        (2)
#define FLASH_ISPADDR_SADDR3_POS        (3)
#define FLASH_ISPADDR_SADDR4_POS        (4)
#define FLASH_ISPADDR_SADDR5_POS        (5)
#define FLASH_ISPADDR_SADDR6_POS        (6)
#define FLASH_ISPADDR_SADDR7_POS        (7)
#define FLASH_ISPADDR_SADDR8_POS        (8)
#define FLASH_ISPADDR_SADDR9_POS        (9)
#define FLASH_ISPADDR_SADDR10_POS       (10)
#define FLASH_ISPADDR_SADDR11_POS       (11)
#define FLASH_ISPADDR_SADDR12_POS       (12)
#define FLASH_ISPADDR_SADDR13_POS       (13)
#define FLASH_ISPADDR_SADDR14_POS       (14)
#define FLASH_ISPADDR_SADDR15_POS       (15)
#define FLASH_ISPADDR_SADDR16_POS       (16)
#define FLASH_ISPADDR_SADDR17_POS       (17)
#define FLASH_ISPADDR_SADDR18_POS       (18)
#define FLASH_ISPADDR_SADDR19_POS       (19)
#define FLASH_ISPADDR_SADDR             ((uint32_t)0x3FFFF<<(FLASH_ISPADDR_SADDR2_POS))

/* FLASH_STATE λ */
#define FLASH_STATE_CFGERROR_POS        (0)
#define FLASH_STATE_SIGDONE_POS         (1)
#define FLASH_STATE_TBIT_POS            (2)
#define FLASH_STATE_TBUSY_POS           (3)
#define FLASH_STATE_BDBG_POS            (12)
#define FLASH_STATE_BDBGREM_POS         (13)
#define FLASH_STATE_CFGERROR            ((uint32_t)1<<(FLASH_STATE_CFGERROR_POS))
#define FLASH_STATE_SIGDONE             ((uint32_t)1<<(FLASH_STATE_SIGDONE_POS))
#define FLASH_STATE_TBIT                ((uint32_t)1<<(FLASH_STATE_TBIT_POS))
#define FLASH_STATE_TBUSY               ((uint32_t)1<<(FLASH_STATE_TBUSY_POS))
#define FLASH_STATE_BDBG                ((uint32_t)1<<(FLASH_STATE_BDBG_POS))
#define FLASH_STATE_BDBGREM             ((uint32_t)1<<(FLASH_STATE_BDBGREM_POS))

/* FLASH_NVMUNLOCK λ */
#define FLASH_NVMUNLOCK_NVMUNLOCK0_POS  (0)
#define FLASH_NVMUNLOCK_NVMUNLOCK       ((uint32_t)0xFFFFFFFF<<(FLASH_NVMUNLOCK_NVMUNLOCK0_POS))

/* FLASH_PROUNLOCK λ */
#define FLASH_PROUNLOCK_PROUNLOCK0_POS  (0)
#define FLASH_PROUNLOCK_PROUNLOCK       ((uint32_t)0xFFFFFFFF<<(FLASH_PROUNLOCK_PROUNLOCK0_POS))

/* FLASH_CFGUNLOCK λ */
#define FLASH_CFGUNLOCK_CFGUNLOCK0_POS  (0)
#define FLASH_CFGUNLOCK_CFGUNLOCK       ((uint32_t)0xFFFFFFFF<<(FLASH_CFGUNLOCK_CFGUNLOCK0_POS))

/* FLASH_CSSTART λ */
#define FLASH_CSSTART_CKSTADDR0_POS     (4)
#define FLASH_CSSTART_CKSTADDR          ((uint32_t)0xFFFF<<(FLASH_CSSTART_CKSTADDR0_POS))

/* FLASH_CSSTOP λ */
#define FLASH_CSSTOP_CKSPADDR0_POS      (4)
#define FLASH_CSSTOP_SIGGO_POS          (20)
#define FLASH_CSSTOP_CKSPADDR           ((uint32_t)0xFFFF<<(FLASH_CSSTOP_CKSPADDR0_POS))
#define FLASH_CSSTOP_SIGGO              ((uint32_t)1<<(FLASH_CSSTOP_SIGGO_POS))

/* FLASH_CSRES0 λ */
#define FLASH_CSRES0_CKSPRES0_0_POS     (0)
#define FLASH_CSRES0_CKSPRES0           ((uint32_t)0xFFFFFFFF<<(FLASH_CSRES0_CKSPRES0_0_POS))

/* FLASH_CSRES1 λ */
#define FLASH_CSRES1_CKSPRES1_0_POS     (0)
#define FLASH_CSRES1_CKSPRES1           ((uint32_t)0xFFFFFFFF<<(FLASH_CSRES1_CKSPRES1_0_POS))

/* FLASH_CSRES2 λ */
#define FLASH_CSRES2_CKSPRES2_0_POS     (0)
#define FLASH_CSRES2_CKSPRES2           ((uint32_t)0xFFFFFFFF<<(FLASH_CSRES2_CKSPRES2_0_POS))

/* FLASH_CSRES3 λ */
#define FLASH_CSRES3_CKSPRES3_0_POS     (0)
#define FLASH_CSRES3_CKSPRES3           ((uint32_t)0xFFFFFFFF<<(FLASH_CSRES3_CKSPRES3_0_POS))
/* FLASH洢 (FLASH) */

#endif

#if 1										/* CRC */

/* ----------------------------------------------------------------------------
   -- ѭУ鵥Ԫ (CRC)
   ---------------------------------------------------------------------------- */

/* CRC - Ĵڴṹ */
typedef struct CRC_MemMap
{
	volatile 		uint32_t CTL;			/*	CRCƼĴ,ƫƣ0x000	*/
	volatile   		uint32_t DATA;			/*	CRCݼĴ,ƫƣ0x004	*/
	volatile const  uint32_t RSLT;			/*	CRCĴ,ƫƣ0x008	*/
	volatile 		uint32_t INIT;			/*	CRCʼֵĴ,ƫƣ0x00C	*/
	volatile 		uint32_t PLN;			/*	CRCʽĴ,ƫƣ0x010	*/
	volatile 		uint32_t RXOR;			/*	CRCֵĴ,ƫƣ0x014	*/
	volatile 		uint32_t IDATA;			/*	CRCĴ,ƫƣ0x018	*/
	volatile const uint32_t TEMP;			/*	CRCĴ,ƫƣ0x01C	*/

}CRC_SFRmap;

/* ----------------------------------------------------------------------------
   -- CRC - Ĵں
   ---------------------------------------------------------------------------- */

/* CRC - Ĵڵַ */
#define CRC_ADDR                      ((uint32_t)0x40002680)
#define CRC_SFR                       ((CRC_SFRmap *) CRC_ADDR)

/* CRC - Ĵ */
#define CRC_CTL                       (CRC_SFR->CTL)
#define CRC_DATA                      (CRC_SFR->DATA)
#define CRC_RSLT                      (CRC_SFR->RSLT)
#define CRC_INIT                      (CRC_SFR->INIT)
#define CRC_CFG                       (CRC_SFR->CFG)
#define CRC_PLN                       (CRC_SFR->PLN)
#define CRC_RXOR                      (CRC_SFR->RXOR)
#define CRC_IDATA                     (CRC_SFR->IDATA)
#define CRC_TEMP                      (CRC_SFR->TEMP)

/* CRC_CTL λ */
#define CRC_CTL_RSET_POS       		  (0)
#define CRC_CTL_DATASIZE0_POS         (2)
#define CRC_CTL_DATASIZE1_POS         (3)
#define CRC_CTL_DATAREV_POS           (5)
#define CRC_CTL_RSLTREV_POS      	  (7)
#define CRC_CTL_RSET                  ((uint32_t)1<<(CRC_CTL_RSET_POS))
#define CRC_CTL_DATASIZE              ((uint32_t)0x3<<(CRC_CTL_DATASIZE0_POS))
#define CRC_CTL_DATASIZE0             ((uint32_t)1<<(CRC_CTL_DATASIZE0_POS))
#define CRC_CTL_DATASIZE1             ((uint32_t)1<<(CRC_CTL_DATASIZE1_POS))
#define CRC_CTL_DATAREV               ((uint32_t)1<<(CRC_CTL_DATAREV_POS))
#define CRC_CTL_RSLTREV               ((uint32_t)1<<(CRC_CTL_RSLTREV_POS))
/* CRC  */








#endif

#if 1										/* AES */

/* ----------------------------------------------------------------------------
   -- ģ (AES)
   ---------------------------------------------------------------------------- */

/* AESģĴڴṹ */
typedef struct AES_MenMap
{
	volatile 	   uint32_t CTL;   /* AESƼĴ,ƫƣ0x000 */
	volatile 	   uint32_t INT;      /* AESжϼĴ,ƫƣ0x004 */
				   uint32_t RESERVED1;      /* ,ƫƣ0x008 */
				   uint32_t RESERVED2;      /* ,ƫƣ0x00C */
	volatile 	   uint32_t INPUT0;   /* AESĴ0,ƫƣ0x010 */
	volatile 	   uint32_t INPUT1;   /* AESĴ1,ƫƣ0x014 */
	volatile 	   uint32_t INPUT2;   /* AESĴ2,ƫƣ0x018 */
	volatile 	   uint32_t INPUT3;   /* AESĴ3,ƫƣ0x01C */
	volatile const uint32_t OUTPUT0;      /* AESĴ0,ƫƣ0x020 */
	volatile const uint32_t OUTPUT1;      /* AESĴ1,ƫƣ0x024 */
	volatile const uint32_t OUTPUT2;      /* AESĴ2,ƫƣ0x028 */
	volatile const uint32_t OUTPUT3;      /* AESĴ3,ƫƣ0x02C */
}AES_SFRmap;

/* ----------------------------------------------------------------------------
   -- AES - Ĵں
   ---------------------------------------------------------------------------- */

/* AES - Ĵڵַ */
#define AES_ADDR                   		((uint32_t)0x40002700)
#define AES_SFR                    		((AES_SFRmap *) AES_ADDR)

/* AES - Ĵ */
#define	AES_CTL							(AES_SFR->CTL)
#define	AES_INT				            (AES_SFR->INT)
#define	AES_INPUT0			            (AES_SFR->INPUT0)
#define	AES_INPUT1			            (AES_SFR->INPUT1)
#define	AES_INPUT2			            (AES_SFR->INPUT2)
#define	AES_INPUT3			            (AES_SFR->INPUT3)
#define	AES_OUTPUT0			            (AES_SFR->OUTPUT0)
#define	AES_OUTPUT1			            (AES_SFR->OUTPUT1)
#define	AES_OUTPUT2			            (AES_SFR->OUTPUT2)
#define	AES_OUTPUT3			            (AES_SFR->OUTPUT3)

/* AES_CTLλ */
#define	AES_CTL_AESEN_POS				(0)
#define	AES_CTL_AESLIKE_POS				(1)
#define	AES_CTL_ENCRYPT_POS				(2)
#define	AES_CTL_SB0X_INV_POS			(3)
#define	AES_CTL_KEY_LEN0_POS			(4)
#define	AES_CTL_KEY_LEN1_POS			(5)
#define	AES_CTL_KEY_LEN2_POS			(6)
#define	AES_CTL_RND_NUM0_POS			(8)
#define	AES_CTL_RND_NUM1_POS			(9)
#define	AES_CTL_RND_NUM2_POS			(10)
#define	AES_CTL_RND_NUM3_POS			(11)
#define	AES_CTL_RND_NUM4_POS			(12)
#define	AES_CTL_DIV0_POS				(13)
#define	AES_CTL_DIV1_POS				(14)
#define	AES_CTL_DIV2_POS				(15)
#define	AES_CTL_CKS0_POS				(16)
#define	AES_CTL_CKS1_POS				(17)
#define	AES_CTL_CBCEN_POS				(20)
#define	AES_CTL_HSMODE_POS				(30)
#define	AES_CTL_AESRUN_POS				(31)
#define	AES_CTL_AESEN				    ((uint32_t)1<<(AES_CTL_AESEN_POS))
#define	AES_CTL_AESLIKE				    ((uint32_t)1<<(AES_CTL_AESLIKE_POS))
#define	AES_CTL_ENCRYPT				    ((uint32_t)1<<(AES_CTL_ENCRYPT_POS))
#define	AES_CTL_SB0X_INV				((uint32_t)1<<(AES_CTL_SB0X_INV_POS))
#define	AES_CTL_KEY_LEN					((uint32_t)0x07<<(AES_CTL_KEY_LEN0_POS))
#define	AES_CTL_KEY_LEN0				((uint32_t)1<<(AES_CTL_KEY_LEN0_POS))
#define	AES_CTL_KEY_LEN1				((uint32_t)1<<(AES_CTL_KEY_LEN1_POS))
#define	AES_CTL_KEY_LEN2				((uint32_t)1<<(AES_CTL_KEY_LEN2_POS))
#define	AES_CTL_RND_NUM					((uint32_t)0x1F<<(AES_CTL_RND_NUM0_POS))
#define	AES_CTL_RND_NUM0				((uint32_t)1<<(AES_CTL_RND_NUM0_POS))
#define	AES_CTL_RND_NUM1				((uint32_t)1<<(AES_CTL_RND_NUM1_POS))
#define	AES_CTL_RND_NUM2				((uint32_t)1<<(AES_CTL_RND_NUM2_POS))
#define	AES_CTL_RND_NUM3				((uint32_t)1<<(AES_CTL_RND_NUM3_POS))
#define	AES_CTL_RND_NUM4				((uint32_t)1<<(AES_CTL_RND_NUM4_POS))
#define	AES_CTL_DIV				    	((uint32_t)0x07<<(AES_CTL_DIV0_POS))
#define	AES_CTL_DIV0				    ((uint32_t)1<<(AES_CTL_DIV0_POS))
#define	AES_CTL_DIV1				    ((uint32_t)1<<(AES_CTL_DIV1_POS))
#define	AES_CTL_DIV2				    ((uint32_t)1<<(AES_CTL_DIV2_POS))
#define	AES_CTL_CKS				    	((uint32_t)0x03<<(AES_CTL_CKS0_POS))
#define	AES_CTL_CKS0				    ((uint32_t)1<<(AES_CTL_CKS0_POS))
#define	AES_CTL_CKS1				    ((uint32_t)1<<(AES_CTL_CKS1_POS))
#define	AES_CTL_CBCEN				    ((uint32_t)1<<(AES_CTL_CBCEN_POS))
#define	AES_CTL_HSMODE				    ((uint32_t)1<<(AES_CTL_HSMODE_POS))
#define	AES_CTL_AESRUN				    ((uint32_t)1<<(AES_CTL_AESRUN_POS))

/* AES_INTλ */
#define	AES_INT_AESIE_POS				(0)
#define	AES_INT_AESIC_POS				(1)
#define	AES_INT_AESIF_POS				(2)
#define	AES_INT_AESIE				    ((uint32_t)1<<(AES_INT_AESIE_POS))
#define	AES_INT_AESIC				    ((uint32_t)1<<(AES_INT_AESIC_POS))
#define	AES_INT_AESIF				    ((uint32_t)1<<(AES_INT_AESIF_POS))

/* AES_INPUTλ */
#define AES_INPUT_AESINPUT0_POS    		(0)
#define AES_INPUT_AESINPUT    			((uint32_t)0xFFFFFFFF<<(AES_INPUT_AESINPUT0_POS))

/* AES_OUTPUTλ */
#define AES_OUTPUT_AESOUTPUT0_POS    	(0)
#define AES_OUTPUT_AESOUTPUT    		((uint32_t)0xFFFFFFFF<<(AES_OUTPUT_AESOUTPUT0_POS))
/* AES  */

#endif

#if 1										/* RNG */

/* ----------------------------------------------------------------------------
   -- ģ (RNG)
   ---------------------------------------------------------------------------- */

/* RNGģĴڴṹ */
typedef struct RNG_MenMap
{
	volatile 	   uint32_t CTL;			/*	RNGƼĴ,ƫƣ0x000	*/
	volatile 	   uint32_t STATE;			/*	RNG״̬Ĵ,ƫƣ0x004	*/
	volatile const uint32_t	SEED;			/*	ӼĴ,ƫƣ0x008	*/
	volatile const uint32_t	DR;				/*	RNGݼĴ,ƫƣ0x00C	*/
}RNG_SFRmap;

/* ----------------------------------------------------------------------------
   -- RNG - Ĵں
   ---------------------------------------------------------------------------- */

/* RNG - Ĵڵַ */
#define RNG_ADDR				        ((uint32_t) 0x40002F80)
#define RNG_SFR					        ((RNG_SFRmap *) RNG_ADDR)

/* RNG - Ĵ */
#define	RNG_CTL					        (RNG_SFR->CTL)
#define	RNG_STATE				        (RNG_SFR->STATE)
#define	RNG_SEED				        (RNG_SFR->SEED)
#define	RNG_DR					        (RNG_SFR->DR)

/* RNG_CTLλ */
#define	RNG_CTL_RNGEN_POS				(0)
#define	RNG_CTL_RNGSEL_POS				(1)
#define	RNG_CTL_CLKS0_POS				(2)
#define	RNG_CTL_CLKS1_POS				(3)
#define	RNG_CTL_CLKDIV0_POS				(4)
#define	RNG_CTL_CLKDIV1_POS				(5)
#define	RNG_CTL_CLKDIV2_POS				(6)
#define	RNG_CTL_CLKDIV3_POS				(7)
#define	RNG_CTL_TSEEDEN_POS				(8)
#define	RNG_CTL_TSEEDGO_POS				(9)
#define	RNG_CTL_ADD0_POS				(10)
#define	RNG_CTL_ADD1_POS				(11)
#define	RNG_CTL_HIPOW_POS				(28)
#define	RNG_CTL_RECEN_POS				(29)
#define	RNG_CTL_TRNGMS_POS				(30)
#define	RNG_CTL_RNGEN				    ((uint32_t)1<<(RNG_CTL_RNGEN_POS))
#define	RNG_CTL_RNGSEL				    ((uint32_t)1<<(RNG_CTL_RNGSEL_POS))
#define	RNG_CTL_CLKS				    ((uint32_t)0x03<<(RNG_CTL_CLKS0_POS))
#define	RNG_CTL_CLKS0				    ((uint32_t)1<<(RNG_CTL_CLKS0_POS))
#define	RNG_CTL_CLKS1				    ((uint32_t)1<<(RNG_CTL_CLKS1_POS))
#define	RNG_CTL_CLKDIV				    ((uint32_t)0x0F<<(RNG_CTL_CLKDIV0_POS))
#define	RNG_CTL_CLKDIV0				    ((uint32_t)1<<(RNG_CTL_CLKDIV0_POS))
#define	RNG_CTL_CLKDIV1				    ((uint32_t)1<<(RNG_CTL_CLKDIV1_POS))
#define	RNG_CTL_CLKDIV2				    ((uint32_t)1<<(RNG_CTL_CLKDIV2_POS))
#define	RNG_CTL_CLKDIV3				    ((uint32_t)1<<(RNG_CTL_CLKDIV3_POS))
#define	RNG_CTL_TSEEDEN				    ((uint32_t)1<<(RNG_CTL_TSEEDEN_POS))
#define	RNG_CTL_TSEEDGO				    ((uint32_t)1<<(RNG_CTL_TSEEDGO_POS))
#define	RNG_CTL_ADD					    ((uint32_t)0x03<<(RNG_CTL_ADD0_POS))
#define	RNG_CTL_ADD0				    ((uint32_t)1<<(RNG_CTL_ADD0_POS))
#define	RNG_CTL_ADD1				    ((uint32_t)1<<(RNG_CTL_ADD1_POS))
#define	RNG_CTL_HIPOW				    ((uint32_t)1<<(RNG_CTL_HIPOW_POS))
#define	RNG_CTL_RECEN				    ((uint32_t)1<<(RNG_CTL_RECEN_POS))
#define	RNG_CTL_TRNGMS				    ((uint32_t)1<<(RNG_CTL_TRNGMS_POS))

/* RNG_STATEλ */
#define	RNG_STATE_DEIF_POS				(0)
#define	RNG_STATE_DRIF_POS				(1)
#define	RNG_STATE_TSRIF_POS				(2)
#define	RNG_STATE_DEIC_POS				(4)
#define	RNG_STATE_DRIC_POS				(5)
#define	RNG_STATE_TSRIC_POS				(6)
#define	RNG_STATE_DEIE_POS				(8)
#define	RNG_STATE_DRIE_POS				(9)
#define	RNG_STATE_TSRIE_POS				(10)
#define	RNG_STATE_HSPD0_POS				(12)
#define	RNG_STATE_HSPD1_POS				(13)
#define	RNG_STATE_READSEED_POS			(14)
#define	RNG_STATE_DEIS_POS				(15)
#define	RNG_STATE_DEIF				    ((uint32_t)1<<(RNG_STATE_DEIF_POS))
#define	RNG_STATE_DRIF				    ((uint32_t)1<<(RNG_STATE_DRIF_POS))
#define	RNG_STATE_TSRIF				    ((uint32_t)1<<(RNG_STATE_TSRIF_POS))
#define	RNG_STATE_DEIC				    ((uint32_t)1<<(RNG_STATE_DEIC_POS))
#define	RNG_STATE_DRIC				    ((uint32_t)1<<(RNG_STATE_DRIC_POS))
#define	RNG_STATE_TSRIC				    ((uint32_t)1<<(RNG_STATE_TSRIC_POS))
#define	RNG_STATE_DEIE				    ((uint32_t)1<<(RNG_STATE_DEIE_POS))
#define	RNG_STATE_DRIE				    ((uint32_t)1<<(RNG_STATE_DRIE_POS))
#define	RNG_STATE_TSRIE				    ((uint32_t)1<<(RNG_STATE_TSRIE_POS))
#define	RNG_STATE_HSPD0				    ((uint32_t)1<<(RNG_STATE_HSPD0_POS))
#define	RNG_STATE_HSPD1				    ((uint32_t)1<<(RNG_STATE_HSPD1_POS))
#define	RNG_STATE_READSEED			    ((uint32_t)1<<(RNG_STATE_READSEED_POS))
#define	RNG_STATE_DEIS				    ((uint32_t)1<<(RNG_STATE_DEIS_POS))

/* RNG_SEEDλ */
#define RNG_SEED_SEED0_POS    			(0)
#define RNG_SEED_SEED    				((uint32_t)0xFFFF<<(RNG_SEED_SEED0_POS))

/* RNG_DRλ */
#define RNG_DR_DR0_POS    				(0)
#define RNG_DR_DR    					((uint32_t)0xFFFFFFFF<<(RNG_DR_DR0_POS))


#endif

#if 1										/* FlexMUX */

/* ----------------------------------------------------------------------------
   -- ѡģ (FlexMUX)
   ---------------------------------------------------------------------------- */

/* FlexMUXѡģĴڴṹ */
typedef struct FlexMUX_MenMap
{
	volatile uint32_t SOU;   				/* FlexMUXԴѡĴ,ƫƣ0x000 */
	volatile uint32_t TAR;   				/* FlexMUXѡĴ,ƫƣ0x004 */
}FlexMUX_SFRmap;

/* ----------------------------------------------------------------------------
   -- FlexMUX - Ĵں
   ---------------------------------------------------------------------------- */

/* FlexMUX - Ĵڵַ */
#define FMUX_ADDR						((uint32_t) 0x40002D00)
#define FMUX_SFR						((FlexMUX_SFRmap*) FMUX_ADDR)

/* FlexMUX - Ĵ */
#define FMUX_SOU   						(FMUX_SFR->SOU)
#define FMUX_TAR   						(FMUX_SFR->TAR)

/* FMUX_SOUλ */
#define	FMUX_SOU_SEL1_0_POS				(0)
#define	FMUX_SOU_SEL1_1_POS				(1)
#define	FMUX_SOU_SEL1_2_POS				(2)
#define	FMUX_SOU_SEL1_3_POS				(3)
#define	FMUX_SOU_SEL1_4_POS				(4)
#define	FMUX_SOU_SEL1_5_POS				(5)
#define	FMUX_SOU_SEL1_6_POS				(6)
#define	FMUX_SOU_CH1EN_POS				(7)
#define	FMUX_SOU_SEL2_0_POS				(8)
#define	FMUX_SOU_SEL2_1_POS				(9)
#define	FMUX_SOU_SEL2_2_POS				(10)
#define	FMUX_SOU_SEL2_3_POS				(11)
#define	FMUX_SOU_SEL2_4_POS				(12)
#define	FMUX_SOU_SEL2_5_POS				(13)
#define	FMUX_SOU_SEL2_6_POS				(14)
#define	FMUX_SOU_CH2EN_POS				(15)
#define	FMUX_SOU_SEL3_0_POS				(16)
#define	FMUX_SOU_SEL3_1_POS				(17)
#define	FMUX_SOU_SEL3_2_POS				(18)
#define	FMUX_SOU_SEL3_3_POS				(19)
#define	FMUX_SOU_SEL3_4_POS				(20)
#define	FMUX_SOU_SEL3_5_POS				(21)
#define	FMUX_SOU_SEL3_6_POS				(22)
#define	FMUX_SOU_CH3EN_POS				(23)
#define	FMUX_SOU_SEL4_0_POS				(24)
#define	FMUX_SOU_SEL4_1_POS				(25)
#define	FMUX_SOU_SEL4_2_POS				(26)
#define	FMUX_SOU_SEL4_3_POS				(27)
#define	FMUX_SOU_SEL4_4_POS				(28)
#define	FMUX_SOU_SEL4_5_POS				(29)
#define	FMUX_SOU_SEL4_6_POS				(30)
#define	FMUX_SOU_CH4EN_POS				(31)
#define	FMUX_SOU_SEL1				    ((uint32_t)0x7F<<(FMUX_SOU_SEL1_0_POS))
#define	FMUX_SOU_SEL1_0				    ((uint32_t)1<<(FMUX_SOU_SEL1_0_POS))
#define	FMUX_SOU_SEL1_1				    ((uint32_t)1<<(FMUX_SOU_SEL1_1_POS))
#define	FMUX_SOU_SEL1_2				    ((uint32_t)1<<(FMUX_SOU_SEL1_2_POS))
#define	FMUX_SOU_SEL1_3				    ((uint32_t)1<<(FMUX_SOU_SEL1_3_POS))
#define	FMUX_SOU_SEL1_4				    ((uint32_t)1<<(FMUX_SOU_SEL1_4_POS))
#define	FMUX_SOU_SEL1_5				    ((uint32_t)1<<(FMUX_SOU_SEL1_5_POS))
#define	FMUX_SOU_SEL1_6				    ((uint32_t)1<<(FMUX_SOU_SEL1_6_POS))
#define	FMUX_SOU_CH1EN				    ((uint32_t)1<<(FMUX_SOU_CH1EN_POS))
#define	FMUX_SOU_SEL2				    ((uint32_t)0x7F<<(FMUX_SOU_SEL2_0_POS))
#define	FMUX_SOU_SEL2_0				    ((uint32_t)1<<(FMUX_SOU_SEL2_0_POS))
#define	FMUX_SOU_SEL2_1				    ((uint32_t)1<<(FMUX_SOU_SEL2_1_POS))
#define	FMUX_SOU_SEL2_2				    ((uint32_t)1<<(FMUX_SOU_SEL2_2_POS))
#define	FMUX_SOU_SEL2_3				    ((uint32_t)1<<(FMUX_SOU_SEL2_3_POS))
#define	FMUX_SOU_SEL2_4				    ((uint32_t)1<<(FMUX_SOU_SEL2_4_POS))
#define	FMUX_SOU_SEL2_5				    ((uint32_t)1<<(FMUX_SOU_SEL2_5_POS))
#define	FMUX_SOU_SEL2_6				    ((uint32_t)1<<(FMUX_SOU_SEL2_6_POS))
#define	FMUX_SOU_CH2EN				    ((uint32_t)1<<(FMUX_SOU_CH2EN_POS))
#define	FMUX_SOU_SEL3				    ((uint32_t)0x7F<<(FMUX_SOU_SEL3_0_POS))
#define	FMUX_SOU_SEL3_0				    ((uint32_t)1<<(FMUX_SOU_SEL3_0_POS))
#define	FMUX_SOU_SEL3_1				    ((uint32_t)1<<(FMUX_SOU_SEL3_1_POS))
#define	FMUX_SOU_SEL3_2				    ((uint32_t)1<<(FMUX_SOU_SEL3_2_POS))
#define	FMUX_SOU_SEL3_3				    ((uint32_t)1<<(FMUX_SOU_SEL3_3_POS))
#define	FMUX_SOU_SEL3_4				    ((uint32_t)1<<(FMUX_SOU_SEL3_4_POS))
#define	FMUX_SOU_SEL3_5				    ((uint32_t)1<<(FMUX_SOU_SEL3_5_POS))
#define	FMUX_SOU_SEL3_6				    ((uint32_t)1<<(FMUX_SOU_SEL3_6_POS))
#define	FMUX_SOU_CH3EN				    ((uint32_t)1<<(FMUX_SOU_CH3EN_POS))
#define	FMUX_SOU_SEL4				    ((uint32_t)0x7F<<(FMUX_SOU_SEL4_0_POS))
#define	FMUX_SOU_SEL4_0				    ((uint32_t)1<<(FMUX_SOU_SEL4_0_POS))
#define	FMUX_SOU_SEL4_1				    ((uint32_t)1<<(FMUX_SOU_SEL4_1_POS))
#define	FMUX_SOU_SEL4_2				    ((uint32_t)1<<(FMUX_SOU_SEL4_2_POS))
#define	FMUX_SOU_SEL4_3				    ((uint32_t)1<<(FMUX_SOU_SEL4_3_POS))
#define	FMUX_SOU_SEL4_4				    ((uint32_t)1<<(FMUX_SOU_SEL4_4_POS))
#define	FMUX_SOU_SEL4_5				    ((uint32_t)1<<(FMUX_SOU_SEL4_5_POS))
#define	FMUX_SOU_SEL4_6				    ((uint32_t)1<<(FMUX_SOU_SEL4_6_POS))
#define	FMUX_SOU_CH4EN				    ((uint32_t)1<<(FMUX_SOU_CH4EN_POS))

/* FMUX_TARλ */
#define	FMUX_TAR_TRGEN_POS				(0)
#define	FMUX_TAR_CH1DE_POS				(1)
#define	FMUX_TAR_CH2DE_POS				(2)
#define	FMUX_TAR_CH3DE_POS				(3)
#define	FMUX_TAR_CH4DE_POS				(4)
#define	FMUX_TAR_CH1DIV0_POS			(5)
#define	FMUX_TAR_CH1DIV1_POS			(6)
#define	FMUX_TAR_CH2DIV0_POS			(7)
#define	FMUX_TAR_CH2DIV1_POS			(8)
#define	FMUX_TAR_CH3DIV0_POS			(9)
#define	FMUX_TAR_CH3DIV1_POS			(10)
#define	FMUX_TAR_CH4DIV0_POS			(11)
#define	FMUX_TAR_CH4DIV1_POS			(12)
#define	FMUX_TAR_CH1SEL0_POS			(13)
#define	FMUX_TAR_CH1SEL1_POS			(14)
#define	FMUX_TAR_CH2SEL0_POS			(15)
#define	FMUX_TAR_CH2SEL1_POS			(16)
#define	FMUX_TAR_CH3SEL0_POS			(17)
#define	FMUX_TAR_CH3SEL1_POS			(18)
#define	FMUX_TAR_CH4SEL0_POS			(19)
#define	FMUX_TAR_CH4SEL1_POS			(20)
#define	FMUX_TAR_TCKS0_POS				(21)
#define	FMUX_TAR_TCKS1_POS				(22)
#define	FMUX_TAR_TRGEN				    ((uint32_t)1<<(FMUX_TAR_TRGEN_POS))
#define	FMUX_TAR_CH1DE				    ((uint32_t)1<<(FMUX_TAR_CH1DE_POS))
#define	FMUX_TAR_CH2DE				    ((uint32_t)1<<(FMUX_TAR_CH2DE_POS))
#define	FMUX_TAR_CH3DE				    ((uint32_t)1<<(FMUX_TAR_CH3DE_POS))
#define	FMUX_TAR_CH4DE				    ((uint32_t)1<<(FMUX_TAR_CH4DE_POS))
#define	FMUX_TAR_CH1DIV				    ((uint32_t)0x03<<(FMUX_TAR_CH1DIV0_POS))
#define	FMUX_TAR_CH1DIV0				((uint32_t)1<<(FMUX_TAR_CH1DIV0_POS))
#define	FMUX_TAR_CH1DIV1				((uint32_t)1<<(FMUX_TAR_CH1DIV1_POS))
#define	FMUX_TAR_CH2DIV					((uint32_t)0x03<<(FMUX_TAR_CH2DIV0_POS))
#define	FMUX_TAR_CH2DIV0				((uint32_t)1<<(FMUX_TAR_CH2DIV0_POS))
#define	FMUX_TAR_CH2DIV1				((uint32_t)1<<(FMUX_TAR_CH2DIV1_POS))
#define	FMUX_TAR_CH3DIV					((uint32_t)0x03<<(FMUX_TAR_CH3DIV0_POS))
#define	FMUX_TAR_CH3DIV0				((uint32_t)1<<(FMUX_TAR_CH3DIV0_POS))
#define	FMUX_TAR_CH3DIV1				((uint32_t)1<<(FMUX_TAR_CH3DIV1_POS))
#define	FMUX_TAR_CH4DIV					((uint32_t)0x03<<(FMUX_TAR_CH4DIV0_POS))
#define	FMUX_TAR_CH4DIV0				((uint32_t)1<<(FMUX_TAR_CH4DIV0_POS))
#define	FMUX_TAR_CH4DIV1				((uint32_t)1<<(FMUX_TAR_CH4DIV1_POS))
#define	FMUX_TAR_CH1SEL					((uint32_t)0x03<<(FMUX_TAR_CH1SEL0_POS))
#define	FMUX_TAR_CH1SEL0				((uint32_t)1<<(FMUX_TAR_CH1SEL0_POS))
#define	FMUX_TAR_CH1SEL1				((uint32_t)1<<(FMUX_TAR_CH1SEL1_POS))
#define	FMUX_TAR_CH2SEL					((uint32_t)0x03<<(FMUX_TAR_CH2SEL0_POS))
#define	FMUX_TAR_CH2SEL0				((uint32_t)1<<(FMUX_TAR_CH2SEL0_POS))
#define	FMUX_TAR_CH2SEL1				((uint32_t)1<<(FMUX_TAR_CH2SEL1_POS))
#define	FMUX_TAR_CH3SEL					((uint32_t)0x03<<(FMUX_TAR_CH3SEL0_POS))
#define	FMUX_TAR_CH3SEL0				((uint32_t)1<<(FMUX_TAR_CH3SEL0_POS))
#define	FMUX_TAR_CH3SEL1				((uint32_t)1<<(FMUX_TAR_CH3SEL1_POS))
#define	FMUX_TAR_CH4SEL					((uint32_t)0x03<<(FMUX_TAR_CH4SEL0_POS))
#define	FMUX_TAR_CH4SEL0				((uint32_t)1<<(FMUX_TAR_CH4SEL0_POS))
#define	FMUX_TAR_CH4SEL1				((uint32_t)1<<(FMUX_TAR_CH4SEL1_POS))
#define	FMUX_TAR_TCKS				    ((uint32_t)0x03<<(FMUX_TAR_TCKS0_POS))
#define	FMUX_TAR_TCKS0				    ((uint32_t)1<<(FMUX_TAR_TCKS0_POS))
#define	FMUX_TAR_TCKS1				    ((uint32_t)1<<(FMUX_TAR_TCKS1_POS))
/* FlexMUX  */

#endif

#if 1										/* FDC */

/* ----------------------------------------------------------------------------
   -- ɱʱģ (FDC)
   ---------------------------------------------------------------------------- */

/* FDCɱʱģĴڴṹ */
typedef struct FDC_MenMap
{
	volatile 	   uint32_t CTL;   			/* FDCxƼĴ,ƫƣ0x000 */
	volatile 	   uint32_t MOD;   			/* FDCxڼĴ,ƫƣ0x004 */
	volatile const uint32_t CNT;     		/* FDCxĴ,ƫƣ0x008 */
	volatile 	   uint32_t IDLY;   		/* FDCxжʱĴ,ƫƣ0x00C */
	volatile 	   uint32_t CH0CTL;   		/* FDCxͨ0ƼĴ,ƫƣ0x010 */
	volatile 	   uint32_t CH1CTL;   		/* FDCxͨ1ƼĴ,ƫƣ0x014 */
	volatile 	   uint32_t CH2CTL;   		/* FDCxͨ2ƼĴ,ƫƣ0x018 */
	volatile 	   uint32_t CH3CTL;   		/* FDCxͨ3ƼĴ,ƫƣ0x01C */
				   uint32_t RESERVED[4];      /* ,ƫƣ0x020 */
	volatile 	   uint32_t CH0DLY0;   		/* FDCxͨ0ʱĴ0,ƫƣ0x030 */
	volatile 	   uint32_t CH0DLY1;   		/* FDCxͨ0ʱĴ1,ƫƣ0x034 */
	volatile 	   uint32_t CH0DLY2;   		/* FDCxͨ0ʱĴ2,ƫƣ0x038 */
				   uint32_t RESERVED5;      /* ,ƫƣ0x03C */
	volatile 	   uint32_t CH1DLY0;   		/* FDCxͨ1ʱĴ0,ƫƣ0x040 */
	volatile 	   uint32_t CH1DLY1;   		/* FDCxͨ1ʱĴ1,ƫƣ0x044 */
	volatile 	   uint32_t CH1DLY2;   		/* FDCxͨ1ʱĴ2,ƫƣ0x048 */
				   uint32_t RESERVED6;      /* ,ƫƣ0x04C */
	volatile 	   uint32_t CH2DLY0;   		/* FDCxͨ2ʱĴ0,ƫƣ0x050 */
	volatile 	   uint32_t CH2DLY1;   		/* FDCxͨ2ʱĴ1,ƫƣ0x054 */
	volatile 	   uint32_t CH2DLY2;   		/* FDCxͨ2ʱĴ2,ƫƣ0x058 */
				   uint32_t RESERVED7;      /* ,ƫƣ0x05C */
	volatile 	   uint32_t CH3DLY0;   		/* FDCxͨ3ʱĴ0,ƫƣ0x060 */
	volatile 	   uint32_t CH3DLY1;   		/* FDCxͨ3ʱĴ1,ƫƣ0x064 */
	volatile 	   uint32_t CH3DLY2;   		/* FDCxͨ3ʱĴ2,ƫƣ0x068 */
				   uint32_t RESERVED8;      /* ,ƫƣ0x06C */
	volatile 	   uint32_t PO0DLY;   		/* FDCxͨ0ʱĴ,ƫƣ0x070 */
	volatile 	   uint32_t PO1DLY;   		/* FDCxͨ1ʱĴ,ƫƣ0x074 */
	volatile 	   uint32_t PO2DLY;   		/* FDCxͨ2ʱĴ,ƫƣ0x078 */
	volatile 	   uint32_t PO3DLY;   		/* FDCxͨ3ʱĴ,ƫƣ0x07C */
}FDC_SFRmap;


/* ----------------------------------------------------------------------------
   -- FDC - Ĵں
   ---------------------------------------------------------------------------- */

/* FDC - Ĵڵַ */
#define FDC0_ADDR					    ((uint32_t) 0x40002B80)
#define FDC1_ADDR					    ((uint32_t) 0x40002C00)
#define FDC2_ADDR					    ((uint32_t) 0x40002C80)
#define FDC0_SFR					    ((FDC_SFRmap *) FDC0_ADDR)
#define FDC1_SFR					    ((FDC_SFRmap *) FDC1_ADDR)
#define FDC2_SFR					    ((FDC_SFRmap *) FDC2_ADDR)

/* FDC - Ĵ */
#define	FDC0_CTL			            (FDC0_SFR->CTL)
#define	FDC0_MOD			            (FDC0_SFR->MOD)
#define	FDC0_CNT			            (FDC0_SFR->CNT)
#define	FDC0_IDLY			            (FDC0_SFR->IDLY)
#define	FDC0_CH0CTL			            (FDC0_SFR->CH0CTL)
#define	FDC0_CH1CTL			            (FDC0_SFR->CH1CTL)
#define	FDC0_CH2CTL			            (FDC0_SFR->CH2CTL)
#define	FDC0_CH3CTL			            (FDC0_SFR->CH3CTL)
#define	FDC0_CH0DLY0			        (FDC0_SFR->CH0DLY0)
#define	FDC0_CH0DLY1			        (FDC0_SFR->CH0DLY1)
#define	FDC0_CH0DLY2			        (FDC0_SFR->CH0DLY2)
#define	FDC0_CH1DLY0			        (FDC0_SFR->CH1DLY0)
#define	FDC0_CH1DLY1			        (FDC0_SFR->CH1DLY1)
#define	FDC0_CH1DLY2			        (FDC0_SFR->CH1DLY2)
#define	FDC0_CH2DLY0			        (FDC0_SFR->CH2DLY0)
#define	FDC0_CH2DLY1			        (FDC0_SFR->CH2DLY1)
#define	FDC0_CH2DLY2			        (FDC0_SFR->CH2DLY2)
#define	FDC0_CH3DLY0			        (FDC0_SFR->CH3DLY0)
#define	FDC0_CH3DLY1			        (FDC0_SFR->CH3DLY1)
#define	FDC0_CH3DLY2			        (FDC0_SFR->CH3DLY2)
#define	FDC0_PO0DLY			            (FDC0_SFR->PO0DLY)
#define	FDC0_PO1DLY			            (FDC0_SFR->PO1DLY)
#define	FDC0_PO2DLY			            (FDC0_SFR->PO2DLY)
#define	FDC0_PO3DLY			            (FDC0_SFR->PO3DLY)

#define	FDC1_CTL			            (FDC1_SFR->CTL)
#define	FDC1_MOD			            (FDC1_SFR->MOD)
#define	FDC1_CNT			            (FDC1_SFR->CNT)
#define	FDC1_IDLY			            (FDC1_SFR->IDLY)
#define	FDC1_CH0CTL			            (FDC1_SFR->CH0CTL)
#define	FDC1_CH1CTL			            (FDC1_SFR->CH1CTL)
#define	FDC1_CH2CTL			            (FDC1_SFR->CH2CTL)
#define	FDC1_CH3CTL			            (FDC1_SFR->CH3CTL)
#define	FDC1_CH0DLY0		        	(FDC1_SFR->CH0DLY0)
#define	FDC1_CH0DLY1		        	(FDC1_SFR->CH0DLY1)
#define	FDC1_CH0DLY2		        	(FDC1_SFR->CH0DLY2)
#define	FDC1_CH1DLY0		        	(FDC1_SFR->CH1DLY0)
#define	FDC1_CH1DLY1		        	(FDC1_SFR->CH1DLY1)
#define	FDC1_CH1DLY2		        	(FDC1_SFR->CH1DLY2)
#define	FDC1_CH2DLY0		        	(FDC1_SFR->CH2DLY0)
#define	FDC1_CH2DLY1		        	(FDC1_SFR->CH2DLY1)
#define	FDC1_CH2DLY2		        	(FDC1_SFR->CH2DLY2)
#define	FDC1_CH3DLY0		        	(FDC1_SFR->CH3DLY0)
#define	FDC1_CH3DLY1		        	(FDC1_SFR->CH3DLY1)
#define	FDC1_CH3DLY2		        	(FDC1_SFR->CH3DLY2)
#define	FDC1_PO0DLY			            (FDC1_SFR->PO0DLY)
#define	FDC1_PO1DLY			            (FDC1_SFR->PO1DLY)
#define	FDC1_PO2DLY			            (FDC1_SFR->PO2DLY)
#define	FDC1_PO3DLY			            (FDC1_SFR->PO3DLY)

#define	FDC2_CTL			            (FDC2_SFR->CTL)
#define	FDC2_MOD			            (FDC2_SFR->MOD)
#define	FDC2_CNT			            (FDC2_SFR->CNT)
#define	FDC2_IDLY			            (FDC2_SFR->IDLY)
#define	FDC2_CH0CTL			            (FDC2_SFR->CH0CTL)
#define	FDC2_CH1CTL			            (FDC2_SFR->CH1CTL)
#define	FDC2_CH2CTL			            (FDC2_SFR->CH2CTL)
#define	FDC2_CH3CTL			            (FDC2_SFR->CH3CTL)
#define	FDC2_CH0DLY0			        (FDC2_SFR->CH0DLY0)
#define	FDC2_CH0DLY1			        (FDC2_SFR->CH0DLY1)
#define	FDC2_CH0DLY2			        (FDC2_SFR->CH0DLY2)
#define	FDC2_CH1DLY0			        (FDC2_SFR->CH1DLY0)
#define	FDC2_CH1DLY1			        (FDC2_SFR->CH1DLY1)
#define	FDC2_CH1DLY2			        (FDC2_SFR->CH1DLY2)
#define	FDC2_CH2DLY0			        (FDC2_SFR->CH2DLY0)
#define	FDC2_CH2DLY1			        (FDC2_SFR->CH2DLY1)
#define	FDC2_CH2DLY2			        (FDC2_SFR->CH2DLY2)
#define	FDC2_CH3DLY0			        (FDC2_SFR->CH3DLY0)
#define	FDC2_CH3DLY1			        (FDC2_SFR->CH3DLY1)
#define	FDC2_CH3DLY2			        (FDC2_SFR->CH3DLY2)
#define	FDC2_PO0DLY			            (FDC2_SFR->PO0DLY)
#define	FDC2_PO1DLY			            (FDC2_SFR->PO1DLY)
#define	FDC2_PO2DLY			            (FDC2_SFR->PO2DLY)
#define	FDC2_PO3DLY			            (FDC2_SFR->PO3DLY)

/* FDC_CTLλ */
#define	FDC_CTL_FDCEN_POS				(0)
#define	FDC_CTL_POEN_POS				(1)
#define	FDC_CTL_LDOK_POS				(2)
#define	FDC_CTL_CONT_POS				(3)
#define	FDC_CTL_MDLIF_POS				(4)
#define	FDC_CTL_MDLIE_POS				(5)
#define	FDC_CTL_TRGSEL_POS				(6)
#define	FDC_CTL_MULSEL0_POS				(7)
#define	FDC_CTL_MULSEL1_POS				(8)
#define	FDC_CTL_MULSEL2_POS				(9)
#define	FDC_CTL_MULSEL3_POS				(10)
#define	FDC_CTL_MULSEL4_POS				(11)
#define	FDC_CTL_MULSEL5_POS				(12)
#define	FDC_CTL_PRESC0_POS				(13)
#define	FDC_CTL_PRESC1_POS				(14)
#define	FDC_CTL_PRESC2_POS				(15)
#define	FDC_CTL_FDCDE_POS				(16)
#define	FDC_CTL_SWTRIG_POS				(17)
#define	FDC_CTL_FDCEIE_POS				(18)
#define	FDC_CTL_LDMOD0_POS				(19)
#define	FDC_CTL_LDMOD1_POS				(20)
#define	FDC_CTL_BBMODE_POS				(21)
#define	FDC_CTL_CMODE_POS				(22)
#define	FDC_CTL_MDLIC_POS				(23)
#define	FDC_CTL_CLKSEL0_POS				(24)
#define	FDC_CTL_CLKSEL1_POS				(25)
#define	FDC_CTL_TCLR_POS				(26)
#define	FDC_CTL_TP0_POS				    (27)
#define	FDC_CTL_TP1_POS				    (28)
#define	FDC_CTL_FDCEN				    ((uint32_t)1<<(FDC_CTL_FDCEN_POS))
#define	FDC_CTL_POEN				    ((uint32_t)1<<(FDC_CTL_POEN_POS))
#define	FDC_CTL_LDOK				    ((uint32_t)1<<(FDC_CTL_LDOK_POS))
#define	FDC_CTL_CONT				    ((uint32_t)1<<(FDC_CTL_CONT_POS))
#define	FDC_CTL_MDLIF				    ((uint32_t)1<<(FDC_CTL_MDLIF_POS))
#define	FDC_CTL_MDLIE				    ((uint32_t)1<<(FDC_CTL_MDLIE_POS))
#define	FDC_CTL_TRGSEL				    ((uint32_t)1<<(FDC_CTL_TRGSEL_POS))
#define	FDC_CTL_MULSEL				    ((uint32_t)0x3F<<(FDC_CTL_MULSEL0_POS))
#define	FDC_CTL_MULSEL0				    ((uint32_t)1<<(FDC_CTL_MULSEL0_POS))
#define	FDC_CTL_MULSEL1				    ((uint32_t)1<<(FDC_CTL_MULSEL1_POS))
#define	FDC_CTL_MULSEL2				    ((uint32_t)1<<(FDC_CTL_MULSEL2_POS))
#define	FDC_CTL_MULSEL3				    ((uint32_t)1<<(FDC_CTL_MULSEL3_POS))
#define	FDC_CTL_MULSEL4				    ((uint32_t)1<<(FDC_CTL_MULSEL4_POS))
#define	FDC_CTL_MULSEL5				    ((uint32_t)1<<(FDC_CTL_MULSEL5_POS))
#define	FDC_CTL_PRESC				    ((uint32_t)0x07<<(FDC_CTL_PRESC0_POS))
#define	FDC_CTL_PRESC0				    ((uint32_t)1<<(FDC_CTL_PRESC0_POS))
#define	FDC_CTL_PRESC1				    ((uint32_t)1<<(FDC_CTL_PRESC1_POS))
#define	FDC_CTL_PRESC2				    ((uint32_t)1<<(FDC_CTL_PRESC2_POS))
#define	FDC_CTL_FDCDE				    ((uint32_t)1<<(FDC_CTL_FDCDE_POS))
#define	FDC_CTL_SWTRIG				    ((uint32_t)1<<(FDC_CTL_SWTRIG_POS))
#define	FDC_CTL_FDCEIE				    ((uint32_t)1<<(FDC_CTL_FDCEIE_POS))
#define	FDC_CTL_LDMOD				    ((uint32_t)0x03<<(FDC_CTL_LDMOD0_POS))
#define	FDC_CTL_LDMOD0				    ((uint32_t)1<<(FDC_CTL_LDMOD0_POS))
#define	FDC_CTL_LDMOD1				    ((uint32_t)1<<(FDC_CTL_LDMOD1_POS))
#define	FDC_CTL_BBMODE				    ((uint32_t)1<<(FDC_CTL_BBMODE_POS))
#define	FDC_CTL_CMODE				    ((uint32_t)1<<(FDC_CTL_CMODE_POS))
#define	FDC_CTL_MDLIC				    ((uint32_t)1<<(FDC_CTL_MDLIC_POS))
#define	FDC_CTL_CLKSEL				    ((uint32_t)0x03<<(FDC_CTL_CLKSEL0_POS))
#define	FDC_CTL_CLKSEL0				    ((uint32_t)1<<(FDC_CTL_CLKSEL0_POS))
#define	FDC_CTL_CLKSEL1				    ((uint32_t)1<<(FDC_CTL_CLKSEL1_POS))
#define	FDC_CTL_TCLR				    ((uint32_t)1<<(FDC_CTL_TCLR_POS))
#define	FDC_CTL_TP				        ((uint32_t)0x03<<(FDC_CTL_TP0_POS))
#define	FDC_CTL_TP0				        ((uint32_t)1<<(FDC_CTL_TP0_POS))
#define	FDC_CTL_TP1				        ((uint32_t)1<<(FDC_CTL_TP1_POS))

/* FDC_MODλ */
#define	FDC_MOD_MOD0_POS		        (0)
#define	FDC_MOD_MOD				        ((uint32_t)0xFFFF<<(FDC_MOD_MOD0_POS))

/* FDC_CNTλ */
#define	FDC_CNT_CNT0_POS		        (0)
#define	FDC_CNT_CNT				        ((uint32_t)0xFFFF<<(FDC_CNT_CNT0_POS))

/* FDC_IDLYλ */
#define	FDC_IDLY_IDLY0_POS				(0)
#define	FDC_IDLY_IDLY					((uint32_t)0xFFFF<<(FDC_IDLY_IDLY0_POS))

/* FDC_CH0CTLλ */
#define	FDC_CH0CTL_PREN0_POS			(0)
#define	FDC_CH0CTL_PREN1_POS			(1)
#define	FDC_CH0CTL_PREN2_POS			(2)
#define	FDC_CH0CTL_PREN3_POS			(3)
#define	FDC_CH0CTL_PREN4_POS			(4)
#define	FDC_CH0CTL_TOS0_POS				(5)
#define	FDC_CH0CTL_TOS1_POS				(6)
#define	FDC_CH0CTL_TOS2_POS				(7)
#define	FDC_CH0CTL_TOS3_POS				(8)
#define	FDC_CH0CTL_TOS4_POS				(9)
#define	FDC_CH0CTL_CF0_POS				(10)
#define	FDC_CH0CTL_CF1_POS				(11)
#define	FDC_CH0CTL_CF2_POS				(12)
#define	FDC_CH0CTL_CF3_POS				(13)
#define	FDC_CH0CTL_CF4_POS				(14)
#define	FDC_CH0CTL_ERR0_POS				(15)
#define	FDC_CH0CTL_ERR1_POS				(16)
#define	FDC_CH0CTL_ERR2_POS				(17)
#define	FDC_CH0CTL_ERR3_POS				(18)
#define	FDC_CH0CTL_ERR4_POS				(19)
#define	FDC_CH0CTL_ERRIC0_POS			(20)
#define	FDC_CH0CTL_ERRIC1_POS			(21)
#define	FDC_CH0CTL_ERRIC2_POS			(22)
#define	FDC_CH0CTL_ERRIC3_POS			(23)
#define	FDC_CH0CTL_ERRIC4_POS			(24)
#define	FDC_CH0CTL_PREN0				((uint32_t)1<<(FDC_CH0CTL_PREN0_POS))
#define	FDC_CH0CTL_PREN1				((uint32_t)1<<(FDC_CH0CTL_PREN1_POS))
#define	FDC_CH0CTL_PREN2				((uint32_t)1<<(FDC_CH0CTL_PREN2_POS))
#define	FDC_CH0CTL_PREN3				((uint32_t)1<<(FDC_CH0CTL_PREN3_POS))
#define	FDC_CH0CTL_PREN4				((uint32_t)1<<(FDC_CH0CTL_PREN4_POS))
#define	FDC_CH0CTL_TOS0				    ((uint32_t)1<<(FDC_CH0CTL_TOS0_POS))
#define	FDC_CH0CTL_TOS1				    ((uint32_t)1<<(FDC_CH0CTL_TOS1_POS))
#define	FDC_CH0CTL_TOS2				    ((uint32_t)1<<(FDC_CH0CTL_TOS2_POS))
#define	FDC_CH0CTL_TOS3				    ((uint32_t)1<<(FDC_CH0CTL_TOS3_POS))
#define	FDC_CH0CTL_TOS4				    ((uint32_t)1<<(FDC_CH0CTL_TOS4_POS))
#define	FDC_CH0CTL_CF0				    ((uint32_t)1<<(FDC_CH0CTL_CF0_POS))
#define	FDC_CH0CTL_CF1				    ((uint32_t)1<<(FDC_CH0CTL_CF1_POS))
#define	FDC_CH0CTL_CF2				    ((uint32_t)1<<(FDC_CH0CTL_CF2_POS))
#define	FDC_CH0CTL_CF3				    ((uint32_t)1<<(FDC_CH0CTL_CF3_POS))
#define	FDC_CH0CTL_CF4				    ((uint32_t)1<<(FDC_CH0CTL_CF4_POS))
#define	FDC_CH0CTL_ERR0				    ((uint32_t)1<<(FDC_CH0CTL_ERR0_POS))
#define	FDC_CH0CTL_ERR1				    ((uint32_t)1<<(FDC_CH0CTL_ERR1_POS))
#define	FDC_CH0CTL_ERR2				    ((uint32_t)1<<(FDC_CH0CTL_ERR2_POS))
#define	FDC_CH0CTL_ERR3				    ((uint32_t)1<<(FDC_CH0CTL_ERR3_POS))
#define	FDC_CH0CTL_ERR4				    ((uint32_t)1<<(FDC_CH0CTL_ERR4_POS))
#define	FDC_CH0CTL_ERRIC0				((uint32_t)1<<(FDC_CH0CTL_ERRIC0_POS))
#define	FDC_CH0CTL_ERRIC1				((uint32_t)1<<(FDC_CH0CTL_ERRIC1_POS))
#define	FDC_CH0CTL_ERRIC2				((uint32_t)1<<(FDC_CH0CTL_ERRIC2_POS))
#define	FDC_CH0CTL_ERRIC3				((uint32_t)1<<(FDC_CH0CTL_ERRIC3_POS))
#define	FDC_CH0CTL_ERRIC4				((uint32_t)1<<(FDC_CH0CTL_ERRIC4_POS))

/* FDC_CH0DLY0λ */
#define	FDC_CH0DLY0_DLY0_0_POS			(0)
#define	FDC_CH0DLY0_DLY0_1_POS			(1)
#define	FDC_CH0DLY0_DLY0_2_POS			(2)
#define	FDC_CH0DLY0_DLY0_3_POS			(3)
#define	FDC_CH0DLY0_DLY0_4_POS			(4)
#define	FDC_CH0DLY0_DLY0_5_POS			(5)
#define	FDC_CH0DLY0_DLY0_6_POS			(6)
#define	FDC_CH0DLY0_DLY0_7_POS			(7)
#define	FDC_CH0DLY0_DLY0_8_POS			(8)
#define	FDC_CH0DLY0_DLY0_9_POS			(9)
#define	FDC_CH0DLY0_DLY0_10_POS			(10)
#define	FDC_CH0DLY0_DLY0_11_POS			(11)
#define	FDC_CH0DLY0_DLY0_12_POS			(12)
#define	FDC_CH0DLY0_DLY0_13_POS			(13)
#define	FDC_CH0DLY0_DLY0_14_POS			(14)
#define	FDC_CH0DLY0_DLY0_15_POS			(15)
#define	FDC_CH0DLY0_DLY1_0_POS			(16)
#define	FDC_CH0DLY0_DLY1_1_POS			(17)
#define	FDC_CH0DLY0_DLY1_2_POS			(18)
#define	FDC_CH0DLY0_DLY1_3_POS			(19)
#define	FDC_CH0DLY0_DLY1_4_POS			(20)
#define	FDC_CH0DLY0_DLY1_5_POS			(21)
#define	FDC_CH0DLY0_DLY1_6_POS			(22)
#define	FDC_CH0DLY0_DLY1_7_POS			(23)
#define	FDC_CH0DLY0_DLY1_8_POS			(24)
#define	FDC_CH0DLY0_DLY1_9_POS			(25)
#define	FDC_CH0DLY0_DLY1_10_POS			(26)
#define	FDC_CH0DLY0_DLY1_11_POS			(27)
#define	FDC_CH0DLY0_DLY1_12_POS			(28)
#define	FDC_CH0DLY0_DLY1_13_POS			(29)
#define	FDC_CH0DLY0_DLY1_14_POS			(30)
#define	FDC_CH0DLY0_DLY1_15_POS			(31)
#define	FDC_CH0DLY0_DLY0				((uint32_t)0xFFFF<<(FDC_CH0DLY0_DLY0_0_POS))
#define	FDC_CH0DLY0_DLY0_0				((uint32_t)1<<(FDC_CH0DLY0_DLY0_0_POS))
#define	FDC_CH0DLY0_DLY0_1				((uint32_t)1<<(FDC_CH0DLY0_DLY0_1_POS))
#define	FDC_CH0DLY0_DLY0_2				((uint32_t)1<<(FDC_CH0DLY0_DLY0_2_POS))
#define	FDC_CH0DLY0_DLY0_3				((uint32_t)1<<(FDC_CH0DLY0_DLY0_3_POS))
#define	FDC_CH0DLY0_DLY0_4				((uint32_t)1<<(FDC_CH0DLY0_DLY0_4_POS))
#define	FDC_CH0DLY0_DLY0_5				((uint32_t)1<<(FDC_CH0DLY0_DLY0_5_POS))
#define	FDC_CH0DLY0_DLY0_6				((uint32_t)1<<(FDC_CH0DLY0_DLY0_6_POS))
#define	FDC_CH0DLY0_DLY0_7				((uint32_t)1<<(FDC_CH0DLY0_DLY0_7_POS))
#define	FDC_CH0DLY0_DLY0_8				((uint32_t)1<<(FDC_CH0DLY0_DLY0_8_POS))
#define	FDC_CH0DLY0_DLY0_9				((uint32_t)1<<(FDC_CH0DLY0_DLY0_9_POS))
#define	FDC_CH0DLY0_DLY0_10				((uint32_t)1<<(FDC_CH0DLY0_DLY0_10_POS))
#define	FDC_CH0DLY0_DLY0_11				((uint32_t)1<<(FDC_CH0DLY0_DLY0_11_POS))
#define	FDC_CH0DLY0_DLY0_12				((uint32_t)1<<(FDC_CH0DLY0_DLY0_12_POS))
#define	FDC_CH0DLY0_DLY0_13				((uint32_t)1<<(FDC_CH0DLY0_DLY0_13_POS))
#define	FDC_CH0DLY0_DLY0_14				((uint32_t)1<<(FDC_CH0DLY0_DLY0_14_POS))
#define	FDC_CH0DLY0_DLY0_15				((uint32_t)1<<(FDC_CH0DLY0_DLY0_15_POS))
#define	FDC_CH0DLY0_DLY1				((uint32_t)0xFFFF<<(FDC_CH0DLY0_DLY1_0_POS))
#define	FDC_CH0DLY0_DLY1_0				((uint32_t)1<<(FDC_CH0DLY0_DLY1_0_POS))
#define	FDC_CH0DLY0_DLY1_1				((uint32_t)1<<(FDC_CH0DLY0_DLY1_1_POS))
#define	FDC_CH0DLY0_DLY1_2				((uint32_t)1<<(FDC_CH0DLY0_DLY1_2_POS))
#define	FDC_CH0DLY0_DLY1_3				((uint32_t)1<<(FDC_CH0DLY0_DLY1_3_POS))
#define	FDC_CH0DLY0_DLY1_4				((uint32_t)1<<(FDC_CH0DLY0_DLY1_4_POS))
#define	FDC_CH0DLY0_DLY1_5				((uint32_t)1<<(FDC_CH0DLY0_DLY1_5_POS))
#define	FDC_CH0DLY0_DLY1_6				((uint32_t)1<<(FDC_CH0DLY0_DLY1_6_POS))
#define	FDC_CH0DLY0_DLY1_7				((uint32_t)1<<(FDC_CH0DLY0_DLY1_7_POS))
#define	FDC_CH0DLY0_DLY1_8				((uint32_t)1<<(FDC_CH0DLY0_DLY1_8_POS))
#define	FDC_CH0DLY0_DLY1_9				((uint32_t)1<<(FDC_CH0DLY0_DLY1_9_POS))
#define	FDC_CH0DLY0_DLY1_10				((uint32_t)1<<(FDC_CH0DLY0_DLY1_10_POS))
#define	FDC_CH0DLY0_DLY1_11				((uint32_t)1<<(FDC_CH0DLY0_DLY1_11_POS))
#define	FDC_CH0DLY0_DLY1_12				((uint32_t)1<<(FDC_CH0DLY0_DLY1_12_POS))
#define	FDC_CH0DLY0_DLY1_13				((uint32_t)1<<(FDC_CH0DLY0_DLY1_13_POS))
#define	FDC_CH0DLY0_DLY1_14				((uint32_t)1<<(FDC_CH0DLY0_DLY1_14_POS))
#define	FDC_CH0DLY0_DLY1_15				((uint32_t)1<<(FDC_CH0DLY0_DLY1_15_POS))

/* FDC_CH0DLY1λ */
#define	FDC_CH0DLY1_DLY2_0_POS			(0)
#define	FDC_CH0DLY1_DLY2_1_POS			(1)
#define	FDC_CH0DLY1_DLY2_2_POS			(2)
#define	FDC_CH0DLY1_DLY2_3_POS			(3)
#define	FDC_CH0DLY1_DLY2_4_POS			(4)
#define	FDC_CH0DLY1_DLY2_5_POS			(5)
#define	FDC_CH0DLY1_DLY2_6_POS			(6)
#define	FDC_CH0DLY1_DLY2_7_POS			(7)
#define	FDC_CH0DLY1_DLY2_8_POS			(8)
#define	FDC_CH0DLY1_DLY2_9_POS			(9)
#define	FDC_CH0DLY1_DLY2_10_POS			(10)
#define	FDC_CH0DLY1_DLY2_11_POS			(11)
#define	FDC_CH0DLY1_DLY2_12_POS			(12)
#define	FDC_CH0DLY1_DLY2_13_POS			(13)
#define	FDC_CH0DLY1_DLY2_14_POS			(14)
#define	FDC_CH0DLY1_DLY2_15_POS			(15)
#define	FDC_CH0DLY1_DLY3_0_POS			(16)
#define	FDC_CH0DLY1_DLY3_1_POS			(17)
#define	FDC_CH0DLY1_DLY3_2_POS			(18)
#define	FDC_CH0DLY1_DLY3_3_POS			(19)
#define	FDC_CH0DLY1_DLY3_4_POS			(20)
#define	FDC_CH0DLY1_DLY3_5_POS			(21)
#define	FDC_CH0DLY1_DLY3_6_POS			(22)
#define	FDC_CH0DLY1_DLY3_7_POS			(23)
#define	FDC_CH0DLY1_DLY3_8_POS			(24)
#define	FDC_CH0DLY1_DLY3_9_POS			(25)
#define	FDC_CH0DLY1_DLY3_10_POS			(26)
#define	FDC_CH0DLY1_DLY3_11_POS			(27)
#define	FDC_CH0DLY1_DLY3_12_POS			(28)
#define	FDC_CH0DLY1_DLY3_13_POS			(29)
#define	FDC_CH0DLY1_DLY3_14_POS			(30)
#define	FDC_CH0DLY1_DLY3_15_POS			(31)
#define	FDC_CH0DLY1_DLY2				((uint32_t)0xFFFF<<(FDC_CH0DLY1_DLY2_0_POS))
#define	FDC_CH0DLY1_DLY2_0				((uint32_t)1<<(FDC_CH0DLY1_DLY2_0_POS))
#define	FDC_CH0DLY1_DLY2_1				((uint32_t)1<<(FDC_CH0DLY1_DLY2_1_POS))
#define	FDC_CH0DLY1_DLY2_2				((uint32_t)1<<(FDC_CH0DLY1_DLY2_2_POS))
#define	FDC_CH0DLY1_DLY2_3				((uint32_t)1<<(FDC_CH0DLY1_DLY2_3_POS))
#define	FDC_CH0DLY1_DLY2_4				((uint32_t)1<<(FDC_CH0DLY1_DLY2_4_POS))
#define	FDC_CH0DLY1_DLY2_5				((uint32_t)1<<(FDC_CH0DLY1_DLY2_5_POS))
#define	FDC_CH0DLY1_DLY2_6				((uint32_t)1<<(FDC_CH0DLY1_DLY2_6_POS))
#define	FDC_CH0DLY1_DLY2_7				((uint32_t)1<<(FDC_CH0DLY1_DLY2_7_POS))
#define	FDC_CH0DLY1_DLY2_8				((uint32_t)1<<(FDC_CH0DLY1_DLY2_8_POS))
#define	FDC_CH0DLY1_DLY2_9				((uint32_t)1<<(FDC_CH0DLY1_DLY2_9_POS))
#define	FDC_CH0DLY1_DLY2_10				((uint32_t)1<<(FDC_CH0DLY1_DLY2_10_POS))
#define	FDC_CH0DLY1_DLY2_11				((uint32_t)1<<(FDC_CH0DLY1_DLY2_11_POS))
#define	FDC_CH0DLY1_DLY2_12				((uint32_t)1<<(FDC_CH0DLY1_DLY2_12_POS))
#define	FDC_CH0DLY1_DLY2_13				((uint32_t)1<<(FDC_CH0DLY1_DLY2_13_POS))
#define	FDC_CH0DLY1_DLY2_14				((uint32_t)1<<(FDC_CH0DLY1_DLY2_14_POS))
#define	FDC_CH0DLY1_DLY2_15				((uint32_t)1<<(FDC_CH0DLY1_DLY2_15_POS))
#define	FDC_CH0DLY1_DLY3				((uint32_t)0xFFFF<<(FDC_CH0DLY1_DLY3_0_POS))
#define	FDC_CH0DLY1_DLY3_0				((uint32_t)1<<(FDC_CH0DLY1_DLY3_0_POS))
#define	FDC_CH0DLY1_DLY3_1				((uint32_t)1<<(FDC_CH0DLY1_DLY3_1_POS))
#define	FDC_CH0DLY1_DLY3_2				((uint32_t)1<<(FDC_CH0DLY1_DLY3_2_POS))
#define	FDC_CH0DLY1_DLY3_3				((uint32_t)1<<(FDC_CH0DLY1_DLY3_3_POS))
#define	FDC_CH0DLY1_DLY3_4				((uint32_t)1<<(FDC_CH0DLY1_DLY3_4_POS))
#define	FDC_CH0DLY1_DLY3_5				((uint32_t)1<<(FDC_CH0DLY1_DLY3_5_POS))
#define	FDC_CH0DLY1_DLY3_6				((uint32_t)1<<(FDC_CH0DLY1_DLY3_6_POS))
#define	FDC_CH0DLY1_DLY3_7				((uint32_t)1<<(FDC_CH0DLY1_DLY3_7_POS))
#define	FDC_CH0DLY1_DLY3_8				((uint32_t)1<<(FDC_CH0DLY1_DLY3_8_POS))
#define	FDC_CH0DLY1_DLY3_9				((uint32_t)1<<(FDC_CH0DLY1_DLY3_9_POS))
#define	FDC_CH0DLY1_DLY3_10				((uint32_t)1<<(FDC_CH0DLY1_DLY3_10_POS))
#define	FDC_CH0DLY1_DLY3_11				((uint32_t)1<<(FDC_CH0DLY1_DLY3_11_POS))
#define	FDC_CH0DLY1_DLY3_12				((uint32_t)1<<(FDC_CH0DLY1_DLY3_12_POS))
#define	FDC_CH0DLY1_DLY3_13				((uint32_t)1<<(FDC_CH0DLY1_DLY3_13_POS))
#define	FDC_CH0DLY1_DLY3_14				((uint32_t)1<<(FDC_CH0DLY1_DLY3_14_POS))
#define	FDC_CH0DLY1_DLY3_15				((uint32_t)1<<(FDC_CH0DLY1_DLY3_15_POS))

/* FDC_CH0DLY2λ */
#define	FDC_CH0DLY2_DLY4_0_POS			(0)
#define	FDC_CH0DLY2_DLY4_1_POS			(1)
#define	FDC_CH0DLY2_DLY4_2_POS			(2)
#define	FDC_CH0DLY2_DLY4_3_POS			(3)
#define	FDC_CH0DLY2_DLY4_4_POS			(4)
#define	FDC_CH0DLY2_DLY4_5_POS			(5)
#define	FDC_CH0DLY2_DLY4_6_POS			(6)
#define	FDC_CH0DLY2_DLY4_7_POS			(7)
#define	FDC_CH0DLY2_DLY4_8_POS			(8)
#define	FDC_CH0DLY2_DLY4_9_POS			(9)
#define	FDC_CH0DLY2_DLY4_10_POS			(10)
#define	FDC_CH0DLY2_DLY4_11_POS			(11)
#define	FDC_CH0DLY2_DLY4_12_POS			(12)
#define	FDC_CH0DLY2_DLY4_13_POS			(13)
#define	FDC_CH0DLY2_DLY4_14_POS			(14)
#define	FDC_CH0DLY2_DLY4_15_POS			(15)
#define	FDC_CH0DLY2_DLY4				((uint32_t)0xFFFF<<(FDC_CH0DLY2_DLY4_0_POS))
#define	FDC_CH0DLY2_DLY4_0				((uint32_t)1<<(FDC_CH0DLY2_DLY4_0_POS))
#define	FDC_CH0DLY2_DLY4_1				((uint32_t)1<<(FDC_CH0DLY2_DLY4_1_POS))
#define	FDC_CH0DLY2_DLY4_2				((uint32_t)1<<(FDC_CH0DLY2_DLY4_2_POS))
#define	FDC_CH0DLY2_DLY4_3				((uint32_t)1<<(FDC_CH0DLY2_DLY4_3_POS))
#define	FDC_CH0DLY2_DLY4_4				((uint32_t)1<<(FDC_CH0DLY2_DLY4_4_POS))
#define	FDC_CH0DLY2_DLY4_5				((uint32_t)1<<(FDC_CH0DLY2_DLY4_5_POS))
#define	FDC_CH0DLY2_DLY4_6				((uint32_t)1<<(FDC_CH0DLY2_DLY4_6_POS))
#define	FDC_CH0DLY2_DLY4_7				((uint32_t)1<<(FDC_CH0DLY2_DLY4_7_POS))
#define	FDC_CH0DLY2_DLY4_8				((uint32_t)1<<(FDC_CH0DLY2_DLY4_8_POS))
#define	FDC_CH0DLY2_DLY4_9				((uint32_t)1<<(FDC_CH0DLY2_DLY4_9_POS))
#define	FDC_CH0DLY2_DLY4_10				((uint32_t)1<<(FDC_CH0DLY2_DLY4_10_POS))
#define	FDC_CH0DLY2_DLY4_11				((uint32_t)1<<(FDC_CH0DLY2_DLY4_11_POS))
#define	FDC_CH0DLY2_DLY4_12				((uint32_t)1<<(FDC_CH0DLY2_DLY4_12_POS))
#define	FDC_CH0DLY2_DLY4_13				((uint32_t)1<<(FDC_CH0DLY2_DLY4_13_POS))
#define	FDC_CH0DLY2_DLY4_14				((uint32_t)1<<(FDC_CH0DLY2_DLY4_14_POS))
#define	FDC_CH0DLY2_DLY4_15				((uint32_t)1<<(FDC_CH0DLY2_DLY4_15_POS))

/* FDC_PO0DLYλ */
#define	FDC_PO0DLY_DLYL0_POS			(0)
#define	FDC_PO0DLY_DLYL1_POS			(1)
#define	FDC_PO0DLY_DLYL2_POS			(2)
#define	FDC_PO0DLY_DLYL3_POS			(3)
#define	FDC_PO0DLY_DLYL4_POS			(4)
#define	FDC_PO0DLY_DLYL5_POS			(5)
#define	FDC_PO0DLY_DLYL6_POS			(6)
#define	FDC_PO0DLY_DLYL7_POS			(7)
#define	FDC_PO0DLY_DLYL8_POS			(8)
#define	FDC_PO0DLY_DLYL9_POS			(9)
#define	FDC_PO0DLY_DLYL10_POS			(10)
#define	FDC_PO0DLY_DLYL11_POS			(11)
#define	FDC_PO0DLY_DLYL12_POS			(12)
#define	FDC_PO0DLY_DLYL13_POS			(13)
#define	FDC_PO0DLY_DLYL14_POS			(14)
#define	FDC_PO0DLY_DLYL15_POS			(15)
#define	FDC_PO0DLY_DLYH0_POS			(16)
#define	FDC_PO0DLY_DLYH1_POS			(17)
#define	FDC_PO0DLY_DLYH2_POS			(18)
#define	FDC_PO0DLY_DLYH3_POS			(19)
#define	FDC_PO0DLY_DLYH4_POS			(20)
#define	FDC_PO0DLY_DLYH5_POS			(21)
#define	FDC_PO0DLY_DLYH6_POS			(22)
#define	FDC_PO0DLY_DLYH7_POS			(23)
#define	FDC_PO0DLY_DLYH8_POS			(24)
#define	FDC_PO0DLY_DLYH9_POS			(25)
#define	FDC_PO0DLY_DLYH10_POS			(26)
#define	FDC_PO0DLY_DLYH11_POS			(27)
#define	FDC_PO0DLY_DLYH12_POS			(28)
#define	FDC_PO0DLY_DLYH13_POS			(29)
#define	FDC_PO0DLY_DLYH14_POS			(30)
#define	FDC_PO0DLY_DLYH15_POS			(31)
#define	FDC_PO0DLY_DLYL					((uint32_t)0xFFFF<<(FDC_PO0DLY_DLYL0_POS))
#define	FDC_PO0DLY_DLYL0				((uint32_t)1<<(FDC_PO0DLY_DLYL0_POS))
#define	FDC_PO0DLY_DLYL1				((uint32_t)1<<(FDC_PO0DLY_DLYL1_POS))
#define	FDC_PO0DLY_DLYL2				((uint32_t)1<<(FDC_PO0DLY_DLYL2_POS))
#define	FDC_PO0DLY_DLYL3				((uint32_t)1<<(FDC_PO0DLY_DLYL3_POS))
#define	FDC_PO0DLY_DLYL4				((uint32_t)1<<(FDC_PO0DLY_DLYL4_POS))
#define	FDC_PO0DLY_DLYL5				((uint32_t)1<<(FDC_PO0DLY_DLYL5_POS))
#define	FDC_PO0DLY_DLYL6				((uint32_t)1<<(FDC_PO0DLY_DLYL6_POS))
#define	FDC_PO0DLY_DLYL7				((uint32_t)1<<(FDC_PO0DLY_DLYL7_POS))
#define	FDC_PO0DLY_DLYL8				((uint32_t)1<<(FDC_PO0DLY_DLYL8_POS))
#define	FDC_PO0DLY_DLYL9				((uint32_t)1<<(FDC_PO0DLY_DLYL9_POS))
#define	FDC_PO0DLY_DLYL10				((uint32_t)1<<(FDC_PO0DLY_DLYL10_POS))
#define	FDC_PO0DLY_DLYL11				((uint32_t)1<<(FDC_PO0DLY_DLYL11_POS))
#define	FDC_PO0DLY_DLYL12				((uint32_t)1<<(FDC_PO0DLY_DLYL12_POS))
#define	FDC_PO0DLY_DLYL13				((uint32_t)1<<(FDC_PO0DLY_DLYL13_POS))
#define	FDC_PO0DLY_DLYL14				((uint32_t)1<<(FDC_PO0DLY_DLYL14_POS))
#define	FDC_PO0DLY_DLYL15				((uint32_t)1<<(FDC_PO0DLY_DLYL15_POS))
#define	FDC_PO0DLY_DLYH					((uint32_t)0xFFFF<<(FDC_PO0DLY_DLYH0_POS))
#define	FDC_PO0DLY_DLYH0				((uint32_t)1<<(FDC_PO0DLY_DLYH0_POS))
#define	FDC_PO0DLY_DLYH1				((uint32_t)1<<(FDC_PO0DLY_DLYH1_POS))
#define	FDC_PO0DLY_DLYH2				((uint32_t)1<<(FDC_PO0DLY_DLYH2_POS))
#define	FDC_PO0DLY_DLYH3				((uint32_t)1<<(FDC_PO0DLY_DLYH3_POS))
#define	FDC_PO0DLY_DLYH4				((uint32_t)1<<(FDC_PO0DLY_DLYH4_POS))
#define	FDC_PO0DLY_DLYH5				((uint32_t)1<<(FDC_PO0DLY_DLYH5_POS))
#define	FDC_PO0DLY_DLYH6				((uint32_t)1<<(FDC_PO0DLY_DLYH6_POS))
#define	FDC_PO0DLY_DLYH7				((uint32_t)1<<(FDC_PO0DLY_DLYH7_POS))
#define	FDC_PO0DLY_DLYH8				((uint32_t)1<<(FDC_PO0DLY_DLYH8_POS))
#define	FDC_PO0DLY_DLYH9				((uint32_t)1<<(FDC_PO0DLY_DLYH9_POS))
#define	FDC_PO0DLY_DLYH10				((uint32_t)1<<(FDC_PO0DLY_DLYH10_POS))
#define	FDC_PO0DLY_DLYH11				((uint32_t)1<<(FDC_PO0DLY_DLYH11_POS))
#define	FDC_PO0DLY_DLYH12				((uint32_t)1<<(FDC_PO0DLY_DLYH12_POS))
#define	FDC_PO0DLY_DLYH13				((uint32_t)1<<(FDC_PO0DLY_DLYH13_POS))
#define	FDC_PO0DLY_DLYH14				((uint32_t)1<<(FDC_PO0DLY_DLYH14_POS))
#define	FDC_PO0DLY_DLYH15				((uint32_t)1<<(FDC_PO0DLY_DLYH15_POS))
/* FDC  */

#endif

#if 1										/* FlexRM */


/* ----------------------------------------------------------------------------
   -- ӿӳģ (FlexRM)
   ---------------------------------------------------------------------------- */

/* FlexRM ӿӳģĴڴṹ */
typedef struct FlexRM_MenMap
{
	volatile uint32_t CTL;   		/* FlexRMƼĴ,ƫƣ0x000 */
	volatile uint32_t GPSR0;   		/* PortͨѡĴ0,ƫƣ0x004 */
	volatile uint32_t GPSR1;   		/* PortͨѡĴ1,ƫƣ0x008 */
	volatile uint32_t GCSR0;   		/* CHͨѡĴ0,ƫƣ0x00C */
	volatile uint32_t GCSR1;   		/* CHͨѡĴ1,ƫƣ0x010 */
	volatile uint32_t GCSR2;   		/* CHͨѡĴ2,ƫƣ0x014 */
}FlexRM_SFRmap;

/* ----------------------------------------------------------------------------
   -- FlexRM - Ĵں
   ---------------------------------------------------------------------------- */

/* FlexRM - Ĵڵַ */
#define FlexRM_ADDR					        ((uint32_t) 0x40002D80)
#define FlexRM_SFR					        ((FlexRM_SFRmap *) FlexRM_ADDR)

/* FlexRM - Ĵ */
#define FlexRM_CTL                          (FlexRM_SFR->CTL)
#define FlexRM_GPSR0                        (FlexRM_SFR->GPSR0)
#define FlexRM_GPSR1                        (FlexRM_SFR->GPSR1)
#define FlexRM_GCSR0                        (FlexRM_SFR->GCSR0)
#define FlexRM_GCSR1                        (FlexRM_SFR->GCSR1)
#define FlexRM_GCSR2                        (FlexRM_SFR->GCSR2)

/* FlexRM_CTLλ */
#define	FlexRM_CTL_G0EN_POS				    (0)
#define	FlexRM_CTL_G1EN_POS				    (1)
#define	FlexRM_CTL_G2EN_POS				    (2)
#define	FlexRM_CTL_G3EN_POS				    (3)
#define	FlexRM_CTL_G4EN_POS				    (4)
#define	FlexRM_CTL_G5EN_POS				    (5)
#define	FlexRM_CTL_G6EN_POS				    (6)
#define	FlexRM_CTL_G7EN_POS				    (7)
#define	FlexRM_CTL_G8EN_POS				    (8)
#define	FlexRM_CTL_G9EN_POS				    (9)
#define	FlexRM_CTL_G10EN_POS				(10)
#define	FlexRM_CTL_G11EN_POS				(11)
#define	FlexRM_CTL_CH0TRSEL_POS				(12)
#define	FlexRM_CTL_CH1TRSEL_POS				(13)
#define	FlexRM_CTL_CH2TRSEL_POS				(14)
#define	FlexRM_CTL_CH3TRSEL_POS				(15)
#define	FlexRM_CTL_CH4TRSEL_POS				(16)
#define	FlexRM_CTL_CH5TRSEL_POS				(17)
#define	FlexRM_CTL_CH6TRSEL_POS				(18)
#define	FlexRM_CTL_CH7TRSEL_POS				(19)
#define	FlexRM_CTL_CH8TRSEL_POS				(20)
#define	FlexRM_CTL_CH9TRSEL_POS				(21)
#define	FlexRM_CTL_CH10TRSEL_POS			(22)
#define	FlexRM_CTL_CH11TRSEL_POS			(23)
#define	FlexRM_CTL_G0EN				        ((uint32_t)1<<(FlexRM_CTL_G0EN_POS))
#define	FlexRM_CTL_G1EN				        ((uint32_t)1<<(FlexRM_CTL_G1EN_POS))
#define	FlexRM_CTL_G2EN				        ((uint32_t)1<<(FlexRM_CTL_G2EN_POS))
#define	FlexRM_CTL_G3EN				        ((uint32_t)1<<(FlexRM_CTL_G3EN_POS))
#define	FlexRM_CTL_G4EN				        ((uint32_t)1<<(FlexRM_CTL_G4EN_POS))
#define	FlexRM_CTL_G5EN				        ((uint32_t)1<<(FlexRM_CTL_G5EN_POS))
#define	FlexRM_CTL_G6EN				        ((uint32_t)1<<(FlexRM_CTL_G6EN_POS))
#define	FlexRM_CTL_G7EN				        ((uint32_t)1<<(FlexRM_CTL_G7EN_POS))
#define	FlexRM_CTL_G8EN				        ((uint32_t)1<<(FlexRM_CTL_G8EN_POS))
#define	FlexRM_CTL_G9EN				        ((uint32_t)1<<(FlexRM_CTL_G9EN_POS))
#define	FlexRM_CTL_G10EN			        ((uint32_t)1<<(FlexRM_CTL_G10EN_POS))
#define	FlexRM_CTL_G11EN			        ((uint32_t)1<<(FlexRM_CTL_G11EN_POS))
#define	FlexRM_CTL_CH0TRSEL			        ((uint32_t)1<<(FlexRM_CTL_CH0TRSEL_POS))
#define	FlexRM_CTL_CH1TRSEL			        ((uint32_t)1<<(FlexRM_CTL_CH1TRSEL_POS))
#define	FlexRM_CTL_CH2TRSEL			        ((uint32_t)1<<(FlexRM_CTL_CH2TRSEL_POS))
#define	FlexRM_CTL_CH3TRSEL			        ((uint32_t)1<<(FlexRM_CTL_CH3TRSEL_POS))
#define	FlexRM_CTL_CH4TRSEL			        ((uint32_t)1<<(FlexRM_CTL_CH4TRSEL_POS))
#define	FlexRM_CTL_CH5TRSEL			        ((uint32_t)1<<(FlexRM_CTL_CH5TRSEL_POS))
#define	FlexRM_CTL_CH6TRSEL			        ((uint32_t)1<<(FlexRM_CTL_CH6TRSEL_POS))
#define	FlexRM_CTL_CH7TRSEL			        ((uint32_t)1<<(FlexRM_CTL_CH7TRSEL_POS))
#define	FlexRM_CTL_CH8TRSEL			        ((uint32_t)1<<(FlexRM_CTL_CH8TRSEL_POS))
#define	FlexRM_CTL_CH9TRSEL			        ((uint32_t)1<<(FlexRM_CTL_CH9TRSEL_POS))
#define	FlexRM_CTL_CH10TRSEL		        ((uint32_t)1<<(FlexRM_CTL_CH10TRSEL_POS))
#define	FlexRM_CTL_CH11TRSEL		        ((uint32_t)1<<(FlexRM_CTL_CH11TRSEL_POS))

/* FlexRM_GPSR0λ */
#define	FlexRM_GPSR0_G0PS0_POS				(0)
#define	FlexRM_GPSR0_G0PS1_POS				(1)
#define	FlexRM_GPSR0_G0PS2_POS				(2)
#define	FlexRM_GPSR0_G0PS3_POS				(3)
#define	FlexRM_GPSR0_G1PS0_POS				(4)
#define	FlexRM_GPSR0_G1PS1_POS				(5)
#define	FlexRM_GPSR0_G1PS2_POS				(6)
#define	FlexRM_GPSR0_G1PS3_POS				(7)
#define	FlexRM_GPSR0_G2PS0_POS				(8)
#define	FlexRM_GPSR0_G2PS1_POS				(9)
#define	FlexRM_GPSR0_G2PS2_POS				(10)
#define	FlexRM_GPSR0_G2PS3_POS				(11)
#define	FlexRM_GPSR0_G3PS0_POS				(12)
#define	FlexRM_GPSR0_G3PS1_POS				(13)
#define	FlexRM_GPSR0_G3PS2_POS				(14)
#define	FlexRM_GPSR0_G3PS3_POS				(15)
#define	FlexRM_GPSR0_G4PS0_POS				(16)
#define	FlexRM_GPSR0_G4PS1_POS				(17)
#define	FlexRM_GPSR0_G4PS2_POS				(18)
#define	FlexRM_GPSR0_G4PS3_POS				(19)
#define	FlexRM_GPSR0_G5PS0_POS				(20)
#define	FlexRM_GPSR0_G5PS1_POS				(21)
#define	FlexRM_GPSR0_G5PS2_POS				(22)
#define	FlexRM_GPSR0_G5PS3_POS				(23)
#define	FlexRM_GPSR0_G6PS0_POS				(24)
#define	FlexRM_GPSR0_G6PS1_POS				(25)
#define	FlexRM_GPSR0_G6PS2_POS				(26)
#define	FlexRM_GPSR0_G6PS3_POS				(27)
#define	FlexRM_GPSR0_G7PS0_POS				(28)
#define	FlexRM_GPSR0_G7PS1_POS				(29)
#define	FlexRM_GPSR0_G7PS2_POS				(30)
#define	FlexRM_GPSR0_G7PS3_POS				(31)
#define	FlexRM_GPSR0_G0PS				    ((uint32_t)0x0F<<(FlexRM_GPSR0_G0PS0_POS))
#define	FlexRM_GPSR0_G0PS0				    ((uint32_t)1<<(FlexRM_GPSR0_G0PS0_POS))
#define	FlexRM_GPSR0_G0PS1				    ((uint32_t)1<<(FlexRM_GPSR0_G0PS1_POS))
#define	FlexRM_GPSR0_G0PS2				    ((uint32_t)1<<(FlexRM_GPSR0_G0PS2_POS))
#define	FlexRM_GPSR0_G0PS3				    ((uint32_t)1<<(FlexRM_GPSR0_G0PS3_POS))
#define	FlexRM_GPSR0_G1PS				    ((uint32_t)0x0F<<(FlexRM_GPSR0_G1PS0_POS))
#define	FlexRM_GPSR0_G1PS0				    ((uint32_t)1<<(FlexRM_GPSR0_G1PS0_POS))
#define	FlexRM_GPSR0_G1PS1				    ((uint32_t)1<<(FlexRM_GPSR0_G1PS1_POS))
#define	FlexRM_GPSR0_G1PS2				    ((uint32_t)1<<(FlexRM_GPSR0_G1PS2_POS))
#define	FlexRM_GPSR0_G1PS3				    ((uint32_t)1<<(FlexRM_GPSR0_G1PS3_POS))
#define	FlexRM_GPSR0_G2PS				    ((uint32_t)0x0F<<(FlexRM_GPSR0_G2PS0_POS))
#define	FlexRM_GPSR0_G2PS0				    ((uint32_t)1<<(FlexRM_GPSR0_G2PS0_POS))
#define	FlexRM_GPSR0_G2PS1				    ((uint32_t)1<<(FlexRM_GPSR0_G2PS1_POS))
#define	FlexRM_GPSR0_G2PS2				    ((uint32_t)1<<(FlexRM_GPSR0_G2PS2_POS))
#define	FlexRM_GPSR0_G2PS3				    ((uint32_t)1<<(FlexRM_GPSR0_G2PS3_POS))
#define	FlexRM_GPSR0_G3PS				    ((uint32_t)0x0F<<(FlexRM_GPSR0_G3PS0_POS))
#define	FlexRM_GPSR0_G3PS0				    ((uint32_t)1<<(FlexRM_GPSR0_G3PS0_POS))
#define	FlexRM_GPSR0_G3PS1				    ((uint32_t)1<<(FlexRM_GPSR0_G3PS1_POS))
#define	FlexRM_GPSR0_G3PS2				    ((uint32_t)1<<(FlexRM_GPSR0_G3PS2_POS))
#define	FlexRM_GPSR0_G3PS3				    ((uint32_t)1<<(FlexRM_GPSR0_G3PS3_POS))
#define	FlexRM_GPSR0_G4PS				    ((uint32_t)0x0F<<(FlexRM_GPSR0_G4PS0_POS))
#define	FlexRM_GPSR0_G4PS0				    ((uint32_t)1<<(FlexRM_GPSR0_G4PS0_POS))
#define	FlexRM_GPSR0_G4PS1				    ((uint32_t)1<<(FlexRM_GPSR0_G4PS1_POS))
#define	FlexRM_GPSR0_G4PS2				    ((uint32_t)1<<(FlexRM_GPSR0_G4PS2_POS))
#define	FlexRM_GPSR0_G4PS3				    ((uint32_t)1<<(FlexRM_GPSR0_G4PS3_POS))
#define	FlexRM_GPSR0_G5PS				    ((uint32_t)0x0F<<(FlexRM_GPSR0_G5PS0_POS))
#define	FlexRM_GPSR0_G5PS0				    ((uint32_t)1<<(FlexRM_GPSR0_G5PS0_POS))
#define	FlexRM_GPSR0_G5PS1				    ((uint32_t)1<<(FlexRM_GPSR0_G5PS1_POS))
#define	FlexRM_GPSR0_G5PS2				    ((uint32_t)1<<(FlexRM_GPSR0_G5PS2_POS))
#define	FlexRM_GPSR0_G5PS3				    ((uint32_t)1<<(FlexRM_GPSR0_G5PS3_POS))
#define	FlexRM_GPSR0_G6PS				    ((uint32_t)0x0F<<(FlexRM_GPSR0_G6PS0_POS))
#define	FlexRM_GPSR0_G6PS0				    ((uint32_t)1<<(FlexRM_GPSR0_G6PS0_POS))
#define	FlexRM_GPSR0_G6PS1				    ((uint32_t)1<<(FlexRM_GPSR0_G6PS1_POS))
#define	FlexRM_GPSR0_G6PS2				    ((uint32_t)1<<(FlexRM_GPSR0_G6PS2_POS))
#define	FlexRM_GPSR0_G6PS3				    ((uint32_t)1<<(FlexRM_GPSR0_G6PS3_POS))
#define	FlexRM_GPSR0_G7PS				    ((uint32_t)0x0F<<(FlexRM_GPSR0_G7PS0_POS))
#define	FlexRM_GPSR0_G7PS0				    ((uint32_t)1<<(FlexRM_GPSR0_G7PS0_POS))
#define	FlexRM_GPSR0_G7PS1				    ((uint32_t)1<<(FlexRM_GPSR0_G7PS1_POS))
#define	FlexRM_GPSR0_G7PS2				    ((uint32_t)1<<(FlexRM_GPSR0_G7PS2_POS))
#define	FlexRM_GPSR0_G7PS3				    ((uint32_t)1<<(FlexRM_GPSR0_G7PS3_POS))

/* FlexRM_GPSR1λ */
#define	FlexRM_GPSR1_G8PS0_POS				(0)
#define	FlexRM_GPSR1_G8PS1_POS				(1)
#define	FlexRM_GPSR1_G8PS2_POS				(2)
#define	FlexRM_GPSR1_G8PS3_POS				(3)
#define	FlexRM_GPSR1_G9PS0_POS				(4)
#define	FlexRM_GPSR1_G9PS1_POS				(5)
#define	FlexRM_GPSR1_G9PS2_POS				(6)
#define	FlexRM_GPSR1_G9PS3_POS				(7)
#define	FlexRM_GPSR1_G10PS0_POS				(8)
#define	FlexRM_GPSR1_G10PS1_POS				(9)
#define	FlexRM_GPSR1_G10PS2_POS				(10)
#define	FlexRM_GPSR1_G10PS3_POS				(11)
#define	FlexRM_GPSR1_G11PS0_POS				(12)
#define	FlexRM_GPSR1_G11PS1_POS				(13)
#define	FlexRM_GPSR1_G11PS2_POS				(14)
#define	FlexRM_GPSR1_G11PS3_POS				(15)
#define	FlexRM_GPSR1_G8PS				    ((uint32_t)0x0F<<(FlexRM_GPSR1_G8PS0_POS))
#define	FlexRM_GPSR1_G8PS0				    ((uint32_t)1<<(FlexRM_GPSR1_G8PS0_POS))
#define	FlexRM_GPSR1_G8PS1				    ((uint32_t)1<<(FlexRM_GPSR1_G8PS1_POS))
#define	FlexRM_GPSR1_G8PS2				    ((uint32_t)1<<(FlexRM_GPSR1_G8PS2_POS))
#define	FlexRM_GPSR1_G8PS3				    ((uint32_t)1<<(FlexRM_GPSR1_G8PS3_POS))
#define	FlexRM_GPSR1_G9PS				    ((uint32_t)0x0F<<(FlexRM_GPSR1_G9PS0_POS))
#define	FlexRM_GPSR1_G9PS0				    ((uint32_t)1<<(FlexRM_GPSR1_G9PS0_POS))
#define	FlexRM_GPSR1_G9PS1				    ((uint32_t)1<<(FlexRM_GPSR1_G9PS1_POS))
#define	FlexRM_GPSR1_G9PS2				    ((uint32_t)1<<(FlexRM_GPSR1_G9PS2_POS))
#define	FlexRM_GPSR1_G9PS3				    ((uint32_t)1<<(FlexRM_GPSR1_G9PS3_POS))
#define	FlexRM_GPSR1_G10PS				    ((uint32_t)0x0F<<(FlexRM_GPSR1_G10PS0_POS))
#define	FlexRM_GPSR1_G10PS0				    ((uint32_t)1<<(FlexRM_GPSR1_G10PS0_POS))
#define	FlexRM_GPSR1_G10PS1				    ((uint32_t)1<<(FlexRM_GPSR1_G10PS1_POS))
#define	FlexRM_GPSR1_G10PS2				    ((uint32_t)1<<(FlexRM_GPSR1_G10PS2_POS))
#define	FlexRM_GPSR1_G10PS3				    ((uint32_t)1<<(FlexRM_GPSR1_G10PS3_POS))
#define	FlexRM_GPSR1_G11PS				    ((uint32_t)0x0F<<(FlexRM_GPSR1_G11PS0_POS))
#define	FlexRM_GPSR1_G11PS0				    ((uint32_t)1<<(FlexRM_GPSR1_G11PS0_POS))
#define	FlexRM_GPSR1_G11PS1				    ((uint32_t)1<<(FlexRM_GPSR1_G11PS1_POS))
#define	FlexRM_GPSR1_G11PS2				    ((uint32_t)1<<(FlexRM_GPSR1_G11PS2_POS))
#define	FlexRM_GPSR1_G11PS3				    ((uint32_t)1<<(FlexRM_GPSR1_G11PS3_POS))

/* FlexRM_GCSR0λ */
#define	FlexRM_GCSR0_CH0OS0_POS				(0)
#define	FlexRM_GCSR0_CH0OS1_POS				(1)
#define	FlexRM_GCSR0_CH0OS2_POS				(2)
#define	FlexRM_GCSR0_CH0OS3_POS				(3)
#define	FlexRM_GCSR0_G0CIS0_POS				(4)
#define	FlexRM_GCSR0_G0CIS1_POS				(5)
#define	FlexRM_GCSR0_G0CIS2_POS				(6)
#define	FlexRM_GCSR0_G0CIS3_POS				(7)
#define	FlexRM_GCSR0_CH1OS0_POS				(8)
#define	FlexRM_GCSR0_CH1OS1_POS				(9)
#define	FlexRM_GCSR0_CH1OS2_POS				(10)
#define	FlexRM_GCSR0_CH1OS3_POS				(11)
#define	FlexRM_GCSR0_G1CIS0_POS				(12)
#define	FlexRM_GCSR0_G1CIS1_POS				(13)
#define	FlexRM_GCSR0_G1CIS2_POS				(14)
#define	FlexRM_GCSR0_G1CIS3_POS				(15)
#define	FlexRM_GCSR0_CH2OS0_POS				(16)
#define	FlexRM_GCSR0_CH2OS1_POS				(17)
#define	FlexRM_GCSR0_CH2OS2_POS				(18)
#define	FlexRM_GCSR0_CH2OS3_POS				(19)
#define	FlexRM_GCSR0_G2CIS0_POS				(20)
#define	FlexRM_GCSR0_G2CIS1_POS				(21)
#define	FlexRM_GCSR0_G2CIS2_POS				(22)
#define	FlexRM_GCSR0_G2CIS3_POS				(23)
#define	FlexRM_GCSR0_CH3OS0_POS				(24)
#define	FlexRM_GCSR0_CH3OS1_POS				(25)
#define	FlexRM_GCSR0_CH3OS2_POS				(26)
#define	FlexRM_GCSR0_CH3OS3_POS				(27)
#define	FlexRM_GCSR0_G3CIS0_POS				(28)
#define	FlexRM_GCSR0_G3CIS1_POS				(29)
#define	FlexRM_GCSR0_G3CIS2_POS				(30)
#define	FlexRM_GCSR0_G3CIS3_POS				(31)
#define	FlexRM_GCSR0_CH0OS				    ((uint32_t)0x0F<<(FlexRM_GCSR0_CH0OS0_POS))
#define	FlexRM_GCSR0_CH0OS0				    ((uint32_t)1<<(FlexRM_GCSR0_CH0OS0_POS))
#define	FlexRM_GCSR0_CH0OS1				    ((uint32_t)1<<(FlexRM_GCSR0_CH0OS1_POS))
#define	FlexRM_GCSR0_CH0OS2				    ((uint32_t)1<<(FlexRM_GCSR0_CH0OS2_POS))
#define	FlexRM_GCSR0_CH0OS3				    ((uint32_t)1<<(FlexRM_GCSR0_CH0OS3_POS))
#define	FlexRM_GCSR0_G0CIS				    ((uint32_t)0x0F<<(FlexRM_GCSR0_G0CIS0_POS))
#define	FlexRM_GCSR0_G0CIS0				    ((uint32_t)1<<(FlexRM_GCSR0_G0CIS0_POS))
#define	FlexRM_GCSR0_G0CIS1				    ((uint32_t)1<<(FlexRM_GCSR0_G0CIS1_POS))
#define	FlexRM_GCSR0_G0CIS2				    ((uint32_t)1<<(FlexRM_GCSR0_G0CIS2_POS))
#define	FlexRM_GCSR0_G0CIS3				    ((uint32_t)1<<(FlexRM_GCSR0_G0CIS3_POS))
#define	FlexRM_GCSR0_CH1OS				    ((uint32_t)0x0F<<(FlexRM_GCSR0_CH1OS0_POS))
#define	FlexRM_GCSR0_CH1OS0				    ((uint32_t)1<<(FlexRM_GCSR0_CH1OS0_POS))
#define	FlexRM_GCSR0_CH1OS1				    ((uint32_t)1<<(FlexRM_GCSR0_CH1OS1_POS))
#define	FlexRM_GCSR0_CH1OS2				    ((uint32_t)1<<(FlexRM_GCSR0_CH1OS2_POS))
#define	FlexRM_GCSR0_CH1OS3				    ((uint32_t)1<<(FlexRM_GCSR0_CH1OS3_POS))
#define	FlexRM_GCSR0_G1CIS				    ((uint32_t)0x0F<<(FlexRM_GCSR0_G1CIS0_POS))
#define	FlexRM_GCSR0_G1CIS0				    ((uint32_t)1<<(FlexRM_GCSR0_G1CIS0_POS))
#define	FlexRM_GCSR0_G1CIS1				    ((uint32_t)1<<(FlexRM_GCSR0_G1CIS1_POS))
#define	FlexRM_GCSR0_G1CIS2				    ((uint32_t)1<<(FlexRM_GCSR0_G1CIS2_POS))
#define	FlexRM_GCSR0_G1CIS3				    ((uint32_t)1<<(FlexRM_GCSR0_G1CIS3_POS))
#define	FlexRM_GCSR0_CH2OS				    ((uint32_t)0x0F<<(FlexRM_GCSR0_CH2OS0_POS))
#define	FlexRM_GCSR0_CH2OS0				    ((uint32_t)1<<(FlexRM_GCSR0_CH2OS0_POS))
#define	FlexRM_GCSR0_CH2OS1				    ((uint32_t)1<<(FlexRM_GCSR0_CH2OS1_POS))
#define	FlexRM_GCSR0_CH2OS2				    ((uint32_t)1<<(FlexRM_GCSR0_CH2OS2_POS))
#define	FlexRM_GCSR0_CH2OS3				    ((uint32_t)1<<(FlexRM_GCSR0_CH2OS3_POS))
#define	FlexRM_GCSR0_G2CIS				    ((uint32_t)0x0F<<(FlexRM_GCSR0_G2CIS0_POS))
#define	FlexRM_GCSR0_G2CIS0				    ((uint32_t)1<<(FlexRM_GCSR0_G2CIS0_POS))
#define	FlexRM_GCSR0_G2CIS1				    ((uint32_t)1<<(FlexRM_GCSR0_G2CIS1_POS))
#define	FlexRM_GCSR0_G2CIS2				    ((uint32_t)1<<(FlexRM_GCSR0_G2CIS2_POS))
#define	FlexRM_GCSR0_G2CIS3				    ((uint32_t)1<<(FlexRM_GCSR0_G2CIS3_POS))
#define	FlexRM_GCSR0_CH3OS				    ((uint32_t)0x0F<<(FlexRM_GCSR0_CH3OS0_POS))
#define	FlexRM_GCSR0_CH3OS0				    ((uint32_t)1<<(FlexRM_GCSR0_CH3OS0_POS))
#define	FlexRM_GCSR0_CH3OS1				    ((uint32_t)1<<(FlexRM_GCSR0_CH3OS1_POS))
#define	FlexRM_GCSR0_CH3OS2				    ((uint32_t)1<<(FlexRM_GCSR0_CH3OS2_POS))
#define	FlexRM_GCSR0_CH3OS3				    ((uint32_t)1<<(FlexRM_GCSR0_CH3OS3_POS))
#define	FlexRM_GCSR0_G3CIS				    ((uint32_t)0x0F<<(FlexRM_GCSR0_G3CIS0_POS))
#define	FlexRM_GCSR0_G3CIS0				    ((uint32_t)1<<(FlexRM_GCSR0_G3CIS0_POS))
#define	FlexRM_GCSR0_G3CIS1				    ((uint32_t)1<<(FlexRM_GCSR0_G3CIS1_POS))
#define	FlexRM_GCSR0_G3CIS2				    ((uint32_t)1<<(FlexRM_GCSR0_G3CIS2_POS))
#define	FlexRM_GCSR0_G3CIS3				    ((uint32_t)1<<(FlexRM_GCSR0_G3CIS3_POS))

/* FlexRM_GCSR1λ */
#define	FlexRM_GCSR1_G4COS0_POS				(0)
#define	FlexRM_GCSR1_G4COS1_POS				(1)
#define	FlexRM_GCSR1_G4COS2_POS				(2)
#define	FlexRM_GCSR1_G4COS3_POS				(3)
#define	FlexRM_GCSR1_CH4OS0_POS				(4)
#define	FlexRM_GCSR1_CH4OS1_POS				(5)
#define	FlexRM_GCSR1_CH4OS2_POS				(6)
#define	FlexRM_GCSR1_CH4OS3_POS				(7)
#define	FlexRM_GCSR1_G5COS0_POS				(8)
#define	FlexRM_GCSR1_G5COS1_POS				(9)
#define	FlexRM_GCSR1_G5COS2_POS				(10)
#define	FlexRM_GCSR1_G5COS3_POS				(11)
#define	FlexRM_GCSR1_CH5OS0_POS				(12)
#define	FlexRM_GCSR1_CH5OS1_POS				(13)
#define	FlexRM_GCSR1_CH5OS2_POS				(14)
#define	FlexRM_GCSR1_CH5OS3_POS				(15)
#define	FlexRM_GCSR1_G6COS0_POS				(16)
#define	FlexRM_GCSR1_G6COS1_POS				(17)
#define	FlexRM_GCSR1_G6COS2_POS				(18)
#define	FlexRM_GCSR1_G6COS3_POS				(19)
#define	FlexRM_GCSR1_CH6OS0_POS				(20)
#define	FlexRM_GCSR1_CH6OS1_POS				(21)
#define	FlexRM_GCSR1_CH6OS2_POS				(22)
#define	FlexRM_GCSR1_CH6OS3_POS				(23)
#define	FlexRM_GCSR1_G7COS0_POS				(24)
#define	FlexRM_GCSR1_G7COS1_POS				(25)
#define	FlexRM_GCSR1_G7COS2_POS				(26)
#define	FlexRM_GCSR1_G7COS3_POS				(27)
#define	FlexRM_GCSR1_CH7OS0_POS				(28)
#define	FlexRM_GCSR1_CH7OS1_POS				(29)
#define	FlexRM_GCSR1_CH7OS2_POS				(30)
#define	FlexRM_GCSR1_CH7OS3_POS				(31)
#define	FlexRM_GCSR1_G4COS				    ((uint32_t)0x0F<<(FlexRM_GCSR1_G4COS0_POS))
#define	FlexRM_GCSR1_G4COS0				    ((uint32_t)1<<(FlexRM_GCSR1_G4COS0_POS))
#define	FlexRM_GCSR1_G4COS1				    ((uint32_t)1<<(FlexRM_GCSR1_G4COS1_POS))
#define	FlexRM_GCSR1_G4COS2				    ((uint32_t)1<<(FlexRM_GCSR1_G4COS2_POS))
#define	FlexRM_GCSR1_G4COS3				    ((uint32_t)1<<(FlexRM_GCSR1_G4COS3_POS))
#define	FlexRM_GCSR1_CH4OS				    ((uint32_t)0x0F<<(FlexRM_GCSR1_CH4OS0_POS))
#define	FlexRM_GCSR1_CH4OS0				    ((uint32_t)1<<(FlexRM_GCSR1_CH4OS0_POS))
#define	FlexRM_GCSR1_CH4OS1				    ((uint32_t)1<<(FlexRM_GCSR1_CH4OS1_POS))
#define	FlexRM_GCSR1_CH4OS2				    ((uint32_t)1<<(FlexRM_GCSR1_CH4OS2_POS))
#define	FlexRM_GCSR1_CH4OS3				    ((uint32_t)1<<(FlexRM_GCSR1_CH4OS3_POS))
#define	FlexRM_GCSR1_G5COS				    ((uint32_t)0x0F<<(FlexRM_GCSR1_G5COS0_POS))
#define	FlexRM_GCSR1_G5COS0				    ((uint32_t)1<<(FlexRM_GCSR1_G5COS0_POS))
#define	FlexRM_GCSR1_G5COS1				    ((uint32_t)1<<(FlexRM_GCSR1_G5COS1_POS))
#define	FlexRM_GCSR1_G5COS2				    ((uint32_t)1<<(FlexRM_GCSR1_G5COS2_POS))
#define	FlexRM_GCSR1_G5COS3				    ((uint32_t)1<<(FlexRM_GCSR1_G5COS3_POS))
#define	FlexRM_GCSR1_CH5OS				    ((uint32_t)0x0F<<(FlexRM_GCSR1_CH5OS0_POS))
#define	FlexRM_GCSR1_CH5OS0				    ((uint32_t)1<<(FlexRM_GCSR1_CH5OS0_POS))
#define	FlexRM_GCSR1_CH5OS1				    ((uint32_t)1<<(FlexRM_GCSR1_CH5OS1_POS))
#define	FlexRM_GCSR1_CH5OS2				    ((uint32_t)1<<(FlexRM_GCSR1_CH5OS2_POS))
#define	FlexRM_GCSR1_CH5OS3				    ((uint32_t)1<<(FlexRM_GCSR1_CH5OS3_POS))
#define	FlexRM_GCSR1_G6COS				    ((uint32_t)0x0F<<(FlexRM_GCSR1_G6COS0_POS))
#define	FlexRM_GCSR1_G6COS0				    ((uint32_t)1<<(FlexRM_GCSR1_G6COS0_POS))
#define	FlexRM_GCSR1_G6COS1				    ((uint32_t)1<<(FlexRM_GCSR1_G6COS1_POS))
#define	FlexRM_GCSR1_G6COS2				    ((uint32_t)1<<(FlexRM_GCSR1_G6COS2_POS))
#define	FlexRM_GCSR1_G6COS3				    ((uint32_t)1<<(FlexRM_GCSR1_G6COS3_POS))
#define	FlexRM_GCSR1_CH6OS				    ((uint32_t)0x0F<<(FlexRM_GCSR1_CH6OS0_POS))
#define	FlexRM_GCSR1_CH6OS0				    ((uint32_t)1<<(FlexRM_GCSR1_CH6OS0_POS))
#define	FlexRM_GCSR1_CH6OS1				    ((uint32_t)1<<(FlexRM_GCSR1_CH6OS1_POS))
#define	FlexRM_GCSR1_CH6OS2				    ((uint32_t)1<<(FlexRM_GCSR1_CH6OS2_POS))
#define	FlexRM_GCSR1_CH6OS3				    ((uint32_t)1<<(FlexRM_GCSR1_CH6OS3_POS))
#define	FlexRM_GCSR1_G7COS				    ((uint32_t)0x0F<<(FlexRM_GCSR1_G7COS0_POS))
#define	FlexRM_GCSR1_G7COS0				    ((uint32_t)1<<(FlexRM_GCSR1_G7COS0_POS))
#define	FlexRM_GCSR1_G7COS1				    ((uint32_t)1<<(FlexRM_GCSR1_G7COS1_POS))
#define	FlexRM_GCSR1_G7COS2				    ((uint32_t)1<<(FlexRM_GCSR1_G7COS2_POS))
#define	FlexRM_GCSR1_G7COS3				    ((uint32_t)1<<(FlexRM_GCSR1_G7COS3_POS))
#define	FlexRM_GCSR1_CH7OS				    ((uint32_t)0x0F<<(FlexRM_GCSR1_CH7OS0_POS))
#define	FlexRM_GCSR1_CH7OS0				    ((uint32_t)1<<(FlexRM_GCSR1_CH7OS0_POS))
#define	FlexRM_GCSR1_CH7OS1				    ((uint32_t)1<<(FlexRM_GCSR1_CH7OS1_POS))
#define	FlexRM_GCSR1_CH7OS2				    ((uint32_t)1<<(FlexRM_GCSR1_CH7OS2_POS))
#define	FlexRM_GCSR1_CH7OS3				    ((uint32_t)1<<(FlexRM_GCSR1_CH7OS3_POS))

/* FlexRM_GCSR2λ */
#define	FlexRM_GCSR2_G8COS0_POS				(0)
#define	FlexRM_GCSR2_G8COS1_POS				(1)
#define	FlexRM_GCSR2_G8COS2_POS				(2)
#define	FlexRM_GCSR2_G8COS3_POS				(3)
#define	FlexRM_GCSR2_CH8OS0_POS				(4)
#define	FlexRM_GCSR2_CH8OS1_POS				(5)
#define	FlexRM_GCSR2_CH8OS2_POS				(6)
#define	FlexRM_GCSR2_CH8OS3_POS				(7)
#define	FlexRM_GCSR2_G9COS0_POS				(8)
#define	FlexRM_GCSR2_G9COS1_POS				(9)
#define	FlexRM_GCSR2_G9COS2_POS				(10)
#define	FlexRM_GCSR2_G9COS3_POS				(11)
#define	FlexRM_GCSR2_CH9OS0_POS				(12)
#define	FlexRM_GCSR2_CH9OS1_POS				(13)
#define	FlexRM_GCSR2_CH9OS2_POS				(14)
#define	FlexRM_GCSR2_CH9OS3_POS				(15)
#define	FlexRM_GCSR2_G10COS0_POS			(16)
#define	FlexRM_GCSR2_G10COS1_POS			(17)
#define	FlexRM_GCSR2_G10COS2_POS			(18)
#define	FlexRM_GCSR2_G10COS3_POS			(19)
#define	FlexRM_GCSR2_CH10OS0_POS			(20)
#define	FlexRM_GCSR2_CH10OS1_POS			(21)
#define	FlexRM_GCSR2_CH10OS2_POS			(22)
#define	FlexRM_GCSR2_CH10OS3_POS			(23)
#define	FlexRM_GCSR2_G11COS0_POS			(24)
#define	FlexRM_GCSR2_G11COS1_POS			(25)
#define	FlexRM_GCSR2_G11COS2_POS			(26)
#define	FlexRM_GCSR2_G11COS3_POS			(27)
#define	FlexRM_GCSR2_CH11OS0_POS			(28)
#define	FlexRM_GCSR2_CH11OS1_POS			(29)
#define	FlexRM_GCSR2_CH11OS2_POS			(30)
#define	FlexRM_GCSR2_CH11OS3_POS			(31)
#define	FlexRM_GCSR2_G8COS				    ((uint32_t)0x0F<<(FlexRM_GCSR2_G8COS0_POS))
#define	FlexRM_GCSR2_G8COS0				    ((uint32_t)1<<(FlexRM_GCSR2_G8COS0_POS))
#define	FlexRM_GCSR2_G8COS1				    ((uint32_t)1<<(FlexRM_GCSR2_G8COS1_POS))
#define	FlexRM_GCSR2_G8COS2				    ((uint32_t)1<<(FlexRM_GCSR2_G8COS2_POS))
#define	FlexRM_GCSR2_G8COS3				    ((uint32_t)1<<(FlexRM_GCSR2_G8COS3_POS))
#define	FlexRM_GCSR2_CH8OS				    ((uint32_t)0x0F<<(FlexRM_GCSR2_CH8OS0_POS))
#define	FlexRM_GCSR2_CH8OS0				    ((uint32_t)1<<(FlexRM_GCSR2_CH8OS0_POS))
#define	FlexRM_GCSR2_CH8OS1				    ((uint32_t)1<<(FlexRM_GCSR2_CH8OS1_POS))
#define	FlexRM_GCSR2_CH8OS2				    ((uint32_t)1<<(FlexRM_GCSR2_CH8OS2_POS))
#define	FlexRM_GCSR2_CH8OS3				    ((uint32_t)1<<(FlexRM_GCSR2_CH8OS3_POS))
#define	FlexRM_GCSR2_G9COS				    ((uint32_t)0x0F<<(FlexRM_GCSR2_G9COS0_POS))
#define	FlexRM_GCSR2_G9COS0				    ((uint32_t)1<<(FlexRM_GCSR2_G9COS0_POS))
#define	FlexRM_GCSR2_G9COS1				    ((uint32_t)1<<(FlexRM_GCSR2_G9COS1_POS))
#define	FlexRM_GCSR2_G9COS2				    ((uint32_t)1<<(FlexRM_GCSR2_G9COS2_POS))
#define	FlexRM_GCSR2_G9COS3				    ((uint32_t)1<<(FlexRM_GCSR2_G9COS3_POS))
#define	FlexRM_GCSR2_CH9OS				    ((uint32_t)0x0F<<(FlexRM_GCSR2_CH9OS0_POS))
#define	FlexRM_GCSR2_CH9OS0				    ((uint32_t)1<<(FlexRM_GCSR2_CH9OS0_POS))
#define	FlexRM_GCSR2_CH9OS1				    ((uint32_t)1<<(FlexRM_GCSR2_CH9OS1_POS))
#define	FlexRM_GCSR2_CH9OS2				    ((uint32_t)1<<(FlexRM_GCSR2_CH9OS2_POS))
#define	FlexRM_GCSR2_CH9OS3				    ((uint32_t)1<<(FlexRM_GCSR2_CH9OS3_POS))
#define	FlexRM_GCSR2_G10COS				    ((uint32_t)0x0F<<(FlexRM_GCSR2_G10COS0_POS))
#define	FlexRM_GCSR2_G10COS0				((uint32_t)1<<(FlexRM_GCSR2_G10COS0_POS))
#define	FlexRM_GCSR2_G10COS1				((uint32_t)1<<(FlexRM_GCSR2_G10COS1_POS))
#define	FlexRM_GCSR2_G10COS2				((uint32_t)1<<(FlexRM_GCSR2_G10COS2_POS))
#define	FlexRM_GCSR2_G10COS3				((uint32_t)1<<(FlexRM_GCSR2_G10COS3_POS))
#define	FlexRM_GCSR2_CH10OS					((uint32_t)0x0F<<(FlexRM_GCSR2_CH10OS0_POS))
#define	FlexRM_GCSR2_CH10OS0				((uint32_t)1<<(FlexRM_GCSR2_CH10OS0_POS))
#define	FlexRM_GCSR2_CH10OS1				((uint32_t)1<<(FlexRM_GCSR2_CH10OS1_POS))
#define	FlexRM_GCSR2_CH10OS2				((uint32_t)1<<(FlexRM_GCSR2_CH10OS2_POS))
#define	FlexRM_GCSR2_CH10OS3				((uint32_t)1<<(FlexRM_GCSR2_CH10OS3_POS))
#define	FlexRM_GCSR2_G11COS					((uint32_t)0x0F<<(FlexRM_GCSR2_G11COS0_POS))
#define	FlexRM_GCSR2_G11COS0				((uint32_t)1<<(FlexRM_GCSR2_G11COS0_POS))
#define	FlexRM_GCSR2_G11COS1				((uint32_t)1<<(FlexRM_GCSR2_G11COS1_POS))
#define	FlexRM_GCSR2_G11COS2				((uint32_t)1<<(FlexRM_GCSR2_G11COS2_POS))
#define	FlexRM_GCSR2_G11COS3				((uint32_t)1<<(FlexRM_GCSR2_G11COS3_POS))
#define	FlexRM_GCSR2_CH11OS					((uint32_t)0x0F<<(FlexRM_GCSR2_CH11OS0_POS))
#define	FlexRM_GCSR2_CH11OS0				((uint32_t)1<<(FlexRM_GCSR2_CH11OS0_POS))
#define	FlexRM_GCSR2_CH11OS1				((uint32_t)1<<(FlexRM_GCSR2_CH11OS1_POS))
#define	FlexRM_GCSR2_CH11OS2				((uint32_t)1<<(FlexRM_GCSR2_CH11OS2_POS))
#define	FlexRM_GCSR2_CH11OS3				((uint32_t)1<<(FlexRM_GCSR2_CH11OS3_POS))
/* FlexRM ӿӳģ鶨 */

/* ض */


#endif

#if 1										/* CACHE */

/* ----------------------------------------------------------------------------
   -- ָ洢 (CACHE)
   ---------------------------------------------------------------------------- */

/* CACHEָ洢ģĴڴṹ */
typedef struct CACHE_MenMap
{
	volatile	uint32_t CTLR;   /* CACHE_CTLRƼĴ,ƫƣ0x000 */
}CACHE_SFRmap;

/* ----------------------------------------------------------------------------
   -- CACHE - Ĵں
   ---------------------------------------------------------------------------- */

/* CACHE - Ĵڵַ */
#define CACHE_ADDR                   		((uint32_t)0x402000C0)
#define CACHE_SFR                    		((CACHE_SFRmap *) CACHE_ADDR)

/* CACHE - Ĵ */
#define	CACHE_CTLR							(CACHE_SFR->CTLR)

/* CACHE_CTLRλ */
#define	PCLK_CTL3_CACHEEN_POS				(0)
#define	PCLK_CTL3_CACHERST_POS				(1)
#define	PCLK_CTL3_ICWR2LEN_POS				(2)
#define	PCLK_CTL3_ICRD2LEN_POS				(3)
#define	PCLK_CTL3_CECCEN_POS				(4)
#define	PCLK_CTL3_FECCERRIE_POS				(5)
#define	PCLK_CTL3_CECCERRIE_POS				(6)
#define	PCLK_CTL3_RECCERRIE_POS				(7)
#define	PCLK_CTL3_FECCERRFLAG_POS			(8)
#define	PCLK_CTL3_CECCERRFLAG_POS			(9)
#define	PCLK_CTL3_RES_POS					(10)
#define	PCLK_CTL3_FAESEL_POS				(11)
#define	PCLK_CTL3_CACHEEN				    ((uint32_t)1<<(PCLK_CTL3_CACHEEN_POS))
#define	PCLK_CTL3_CACHERST				    ((uint32_t)1<<(PCLK_CTL3_CACHERST_POS))
#define	PCLK_CTL3_ICWR2LEN				    ((uint32_t)1<<(PCLK_CTL3_ICWR2LEN_POS))
#define	PCLK_CTL3_ICRD2LEN				    ((uint32_t)1<<(PCLK_CTL3_ICRD2LEN_POS))
#define	PCLK_CTL3_CECCEN				    ((uint32_t)1<<(PCLK_CTL3_CECCEN_POS))
#define	PCLK_CTL3_FECCERRIE				    ((uint32_t)1<<(PCLK_CTL3_FECCERRIE_POS))
#define	PCLK_CTL3_CECCERRIE				    ((uint32_t)1<<(PCLK_CTL3_CECCERRIE_POS))
#define	PCLK_CTL3_RECCERRIE				    ((uint32_t)1<<(PCLK_CTL3_RECCERRIE_POS))
#define	PCLK_CTL3_FECCERRFLAG				((uint32_t)1<<(PCLK_CTL3_FECCERRFLAG_POS))
#define	PCLK_CTL3_CECCERRFLAG				((uint32_t)1<<(PCLK_CTL3_CECCERRFLAG_POS))
#define	PCLK_CTL3_RES						((uint32_t)1<<(PCLK_CTL3_RES_POS))
#define	PCLK_CTL3_FAESEL					((uint32_t)1<<(PCLK_CTL3_FAESEL_POS))


#endif

/* ----------------------------------------------------------------------------
   -- ܺ궨
   ---------------------------------------------------------------------------- */
/* SFRλһ */
#define SFR_SET_BIT_ASM(SFR, POS) \
        __asm volatile("SET [%0], #%1"::"r"(&(SFR)),"i"(POS))
/* SFRλ */
#define SFR_CLR_BIT_ASM(SFR, POS) \
        __asm volatile("CLR [%0], #%1"::"r"(&(SFR)),"i"(POS))
/* дڴ */
#define STW_ASM(ADDR, DATA) \
        __asm volatile("ST.w [%0], %1"::"r"(ADDR),"r"(DATA))
/* ܺ궨 */



/* ----------------------------------------------------------------------------
   -- 
   ---------------------------------------------------------------------------- */
/* д⹦ܼĴ */
static inline uint32_t
SFR_Config (uint32_t SfrMem, uint32_t SfrMask, uint32_t WriteVal)
{
    return ((SfrMem & SfrMask) | (WriteVal));
}
/* д⹦ܼĴ */



#endif /* KF32A156_H_ */
