/**
  ******************************************************************************
  * ļ  kf32a_basic_usb.c
  *     ChipON_AE/FAE_Group
  *     V2.6.2
  *     2019-11-16
  *     ļṩUSBģ(USB)صĹܺ
  *          + USBģ(USB)ʼ
  *          + USBģ(USB)ú
  *          + USBģ(USB)
  *          + USBģ(USB)жϹ
  *
  *********************************************************************
  */

#include "kf32a_basic_usb.h"
#include "kf32a_basic_rst.h"
#include "kf32a_basic_pclk.h"
#include "string.h"


#ifdef KF32A_Periph_usb
/* ʱ˽ж ----------------------------------------------------*/
/* USB_UCONĴʼ */
#define USB_UCON_INIT_MASK              (USB_UCON_SPEEDEN \
                                       | USB_UCON_UPUEN \
                                       | USB_UCON_DB)

/* USB_UEPĴʼ */
#define USB_UEP_INIT_MASK               (USB_UEP_EPHSHK \
                                       | USB_UEP_EPCONDIS \
                                       | USB_UEP_EPOUTEN \
                                       | USB_UEP_EPINEN)

/* USB_UEPĴʼ */
#define USB_BDSTAT_INIT_MASK            (USB_BDSTAT_BADDR \
                                       | USB_BDSTAT_BC \
                                       | USB_BDSTAT_UOWN \
                                       | USB_BDSTAT_DTS \
                                       | USB_BDSTAT_DTSEN \
                                       | USB_BDSTAT_BSTALL)

/**
  *   ##### USBģ(USB)ʼ #####
  */
/**
  *   λUSB裬ʹʱӡ
  *   ޡ
  *   ޡ
  */
void
USB_Reset(void)
{
    /* λUSB */
    RST_CTL1_Peripheral_Reset_Enable(RST_CTL1_USBRST, TRUE);
    RST_CTL1_Peripheral_Reset_Enable(RST_CTL1_USBRST, FALSE);

    /* ʹUSBʱ */
    PCLK_CTL1_Peripheral_Clock_Enable(PCLK_CTL1_USBCLKEN, TRUE);
}

/**
  *   USBģ(USB)ʼ
  *   usbInitStruct: USBϢṹ塣
  *   ޡ
  */
void
USB_Configuration(USB_InitTypeDef* usbInitStruct)
{
    uint32_t tmpreg = 0;
    uint32_t tmpreg1 = 0;
    uint32_t i = 0;

    /* У */
    CHECK_RESTRICTION(CHECK_USB_SPEED_SELECT(usbInitStruct->m_Speed));
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(usbInitStruct->m_Pullup));
    CHECK_RESTRICTION(CHECK_USB_DOUBLE_BUFFER(usbInitStruct->m_DoubleBufferCfg));
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(usbInitStruct->m_DoubleBufferRst));
    CHECK_RESTRICTION(CHECK_USB_ENDPOINT_MASK(usbInitStruct->m_EndPointMask));
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(usbInitStruct->m_Handshake));
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(usbInitStruct->m_Bidirectional));
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(usbInitStruct->m_Output));
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(usbInitStruct->m_Input));

    /*---------------- USB_UCONĴ ----------------*/
    /* ݽṹԱm_SpeedSPEEDENλ */
    /* ݽṹԱm_PullupUPUENλ */
    /* ݽṹԱm_DoubleBufferCfgDBλ */
    tmpreg = usbInitStruct->m_Speed \
           | ((uint32_t)usbInitStruct->m_Pullup << USB_UCON_UPUEN_POS) \
           | usbInitStruct->m_DoubleBufferCfg
           | ((uint32_t)usbInitStruct->m_DoubleBufferRst << USB_UCON_DBRST_POS);
    USB_UCON = SFR_Config (USB_UCON, ~USB_UCON_INIT_MASK, tmpreg);

    if (usbInitStruct->m_DoubleBufferRst != FALSE)
    {
        /* ˫λ */
        SFR_CLR_BIT_ASM(USB_UCON, USB_UCON_DBRST_POS);
    }
    else
    {
        ;
    }

    /*---------------- USB_UEPnĴ ----------------*/
    /* ݽṹԱm_EndPointMaskѡUSB_UEPnĴ */
    /* ݽṹԱm_HandshakeEPHSHKλ */
    /* ݽṹԱm_BidirectionalEPCONDISλ */
    /* ݽṹԱm_OutputEPOUTENλ */
    /* ݽṹԱm_InputEPINENλ */
    tmpreg = ((uint32_t)usbInitStruct->m_Handshake << USB_UEP_EPHSHK_POS) \
           | ((uint32_t)usbInitStruct->m_Bidirectional << USB_UEP_EPCONDIS_POS) \
           | ((uint32_t)usbInitStruct->m_Output << USB_UEP_EPOUTEN_POS) \
           | ((uint32_t)usbInitStruct->m_Input << USB_UEP_EPINEN_POS);
    tmpreg1 = usbInitStruct->m_EndPointMask;
    for (i = 0; i <= USB_ENDPOINT_7; i++)
    {
        if (tmpreg1 & 0x1)
        {
            USB_SFR->UEP[i] = SFR_Config (USB_SFR->UEP[i],
                                    ~USB_UEP_INIT_MASK,
                                    tmpreg);
        }
        else
        {
            ;
        }
        tmpreg1 >>= 1;
    }
}

/**
  *   USBģ(USB)ʼ
  *   usbInitStruct: USBϢṹ塣
  *   ޡ
  */
void
USB_Buffer_Configuration(USB_BufferTypeDef* usbInitStruct)
{
    uint32_t tmpreg = 0;
    uint32_t tmpreg1 = 0;
    uint32_t tmpaddr = 0;

    /* У */
    CHECK_RESTRICTION(CHECK_USB_ENDPOINT_NUM(usbInitStruct->m_EndPoint));
    CHECK_RESTRICTION(CHECK_USB_ENDPOINT_DIRECT(usbInitStruct->m_Direction));
    CHECK_RESTRICTION(CHECK_USB_ODD_EVEN(usbInitStruct->m_BDPointer));
    CHECK_RESTRICTION(CHECK_USB_DATA_LENGTH(usbInitStruct->m_ByteCount));
    CHECK_RESTRICTION(CHECK_USB_OWN_BD(usbInitStruct->m_Own));
    CHECK_RESTRICTION(CHECK_USB_DATA_TOGGLE_SYNC(usbInitStruct->m_DataToggleSync));
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(usbInitStruct->m_DataToggleSyncEn));
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(usbInitStruct->m_BufferStall));

    /* ȡõַڴ */
    tmpaddr = USB_Get_Endpoint_Double_Buffer_Addr (usbInitStruct->m_EndPoint, \
                                usbInitStruct->m_Direction,
                                usbInitStruct->m_BDPointer);
    tmpreg = *(volatile uint32_t *) tmpaddr;

    /*---------------- USB_BDnSTATĴ ----------------*/
    /* ݽṹԱm_BufferAddrBADDRλ */
    /* ݽṹԱm_ByteCountBCλ */
    /* ݽṹԱm_OwnUOWNλ */
    /* ݽṹԱm_DataToggleSyncDTSλ */
    /* ݽṹԱm_DataToggleSyncEnDTSENλ */
    /* ݽṹԱm_BufferStallBSTALLλ */

    /* ȡBCλĸλ */
    tmpreg &= USB_BDSTAT_BCH;
    tmpreg >>= USB_BDSTAT_BC8_POS;
    /* ȡBCλĵλ */
    tmpreg1 &= USB_BDSTAT_BCL;
    tmpreg1 >>= USB_BDSTAT_BC0_POS;
    /* BCBITλ */
    tmpreg = (tmpreg << (USB_BDSTAT_BC7_POS + 1)) | (tmpreg1);

    /* USB_BDnSTATĴϢ */
    tmpreg = ((uint32_t)usbInitStruct->m_BufferAddr << USB_BDSTAT_BADDR0_POS) \
           | tmpreg \
           | (usbInitStruct->m_Own << USB_BDSTAT_UOWN_POS) \
           | usbInitStruct->m_DataToggleSync \
           | ((uint32_t)usbInitStruct->m_DataToggleSyncEn << USB_BDSTAT_DTSEN_POS) \
           | ((uint32_t)usbInitStruct->m_BufferStall << USB_BDSTAT_BSTALL_POS);

    *(volatile uint32_t *) tmpaddr =
                    SFR_Config (*(volatile uint32_t *) tmpaddr,
                            ~USB_BDSTAT_INIT_MASK,
                            tmpreg);
}

/**
  *   ʼUSBϢṹ塣
  *   usbInitStruct: ָʼĽṹָ롣
  *   ޡ
  */
void
USB_Struct_Init (USB_InitTypeDef* usbInitStruct)
{
    /* ʼ USBٶ */
    usbInitStruct->m_Speed = USB_LOW_SPEED;

    /* ʼ USBƬʹ */
    usbInitStruct->m_Pullup = FALSE;

    /* ʼ USB˫ */
    usbInitStruct->m_DoubleBufferCfg = USB_DOUBLE_BUFFER_FORBID;

    /* ʼ USB˵ */
    usbInitStruct->m_EndPointMask = USB_ENDPOINT_MASK_NONE;

    /* ʼ USB˵ʹ */
    usbInitStruct->m_Handshake = FALSE;

    /* ʼ ˫˵ʹ */
    usbInitStruct->m_Bidirectional = FALSE;

    /* ʼ USB˵ʹ */
    usbInitStruct->m_Output = FALSE;

    /* ʼ USB˵ʹ */
    usbInitStruct->m_Input = FALSE;
}

/**
  *   ʼUSBϢṹ塣
  *   usbInitStruct: ָʼĽṹָ롣
  *   ޡ
  */
void
USB_Buffer_Struct_Init (USB_BufferTypeDef* usbInitStruct)
{
    /* ʼ USB˵ */
    usbInitStruct->m_EndPoint = USB_ENDPOINT_0;

    /* ʼ USB˵㷽 */
    usbInitStruct->m_Direction = USB_ENDPOINT_OUTPUT;

    /* ʼ USB˵żBD洢 */
    usbInitStruct->m_BDPointer = USB_EVEN_BUFFER_DESCRIPOR;

    /* ʼ RAMַ */
    usbInitStruct->m_BufferAddr = 0;

    /* ʼ RAMֽڼ */
    usbInitStruct->m_ByteCount = 0;

    /* ʼ USB ӵλ */
    usbInitStruct->m_Own = USB_KERNEL_OWN_BD;

    /* ʼ USBݷתͬ */
    usbInitStruct->m_DataToggleSync = USB_DATA_0_TOGGLE_SYNC;

    /* ʼ USBݷתͬʹ */
    usbInitStruct->m_DataToggleSyncEn = FALSE;

    /* ʼ USBֹͣʹ */
    usbInitStruct->m_BufferStall = FALSE;
}
/**
  *   ##### USBģ(USB)ʼ #####
  */


/**
  *   ##### USBģ(USB)ú #####
  */
/**
  *   USB˫λʹܡ
  *   NewState: USB˫λʹ״̬ȡֵΪTRUE  FALSE
  *   ޡ
  */
void
USB_Double_Buffer_Pointer_Enable (FunctionalState NewState)
{
    /* У */
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

    /*---------------- USB_UCONĴDBRSTλ ----------------*/
    if (NewState != FALSE)
    {
        /* ˫ָ븴λΪżBD洢 */
        SFR_SET_BIT_ASM(USB_UCON, USB_UCON_DBRST_POS);
    }
    else
    {
        /* λ˫ָ */
        SFR_CLR_BIT_ASM(USB_UCON, USB_UCON_DBRST_POS);
    }
}

/**
  *   ȡЧ0ƽ־
  *   ޡ
  *   1:USBϵĵ0ƽЧ0:δ⵽0ƽ
  */
FlagStatus
USB_Get_Single_Ended_0_Flag (void)
{
    /*---------------- ȡUSB_UCONĴSE0λ ----------------*/
    if (USB_UCON_SE0 & USB_UCON)
    {
        /* USBϵĵ0ƽЧ */
        return SET;
    }
    else
    {
        /* δ⵽0ƽ */
        return RESET;
    }
}

/**
  *   Ч0ƽ־
  *   ޡ
  *   ޡ
  */
void
USB_Clear_Single_Ended_0_Flag (void)
{
    /*---------------- USB_UCONĴSE0λ ----------------*/
	while(USB_UCON_SE0 & USB_UCON)
	{
		SFR_CLR_BIT_ASM(USB_UCON, USB_UCON_SE0_POS);
	}
}

/**
  *   ȡݰͱ־
  *   ޡ
  *   1: ѽֹSIEƺݰյSETUPƣ
  *       0: SIEƺݰ
  */
FlagStatus
USB_Get_Package_Transmit_Flag (void)
{
    /*---------------- ȡUSB_UCONĴPKTDISλ ----------------*/
    if (USB_UCON_PKTDIS & USB_UCON)
    {
        /* ѽֹSIEƺݰյSETUP */
        return SET;
    }
    else
    {
        /* SIEƺݰ */
        return RESET;
    }
}

/**
  *   ݰͱ־
  *   ޡ
  *   ޡ
  */
void
USB_Clear_Package_Transmit_Flag (void)
{
    /*---------------- USB_UCONĴPKTDISλ ----------------*/
	while(USB_UCON_PKTDIS & USB_UCON)
	{
		SFR_CLR_BIT_ASM(USB_UCON, USB_UCON_PKTDIS_POS);
	}
}

/**
  *   USBͣ()ʹܡ
  *   NewState: USBͣ()ʹ״̬ȡֵΪTRUE  FALSE
  *   ޡ
  */
void
USB_Suspend_Enable (FunctionalState NewState)
{
    /* У */
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

    /*---------------- USB_UCONĴSUSPNDλ ----------------*/
    if (NewState != FALSE)
    {
        /* USBģֵ֧·ģʽSIEʱӲ */
        SFR_SET_BIT_ASM(USB_UCON, USB_UCON_SUSPND_POS);
    }
    else
    {
        /* USBģֵ֧·״̬SIEʱõ */
        SFR_CLR_BIT_ASM(USB_UCON, USB_UCON_SUSPND_POS);
    }
}

/**
  *   USBָźŴʹܡ
  *   NewState: USBָźŴʹ״̬ȡֵΪTRUE  FALSE
  *   ޡ
  */
void
USB_Resume_Signal_Transmit_Enable (FunctionalState NewState)
{
    /* У */
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

    /*---------------- USB_UCONĴRESUMEλ ----------------*/
    if (NewState != FALSE)
    {
        /* ָźŴ */
        SFR_SET_BIT_ASM(USB_UCON, USB_UCON_RESUME_POS);
    }
    else
    {
        /* ָֹźŴ */
        SFR_CLR_BIT_ASM(USB_UCON, USB_UCON_RESUME_POS);
    }
}

/**
  *   USBģʹܡ
  *   NewState: USBģʹ״̬ȡֵΪTRUE  FALSE
  *   ޡ
  */
void
USB_Cmd (FunctionalState NewState)
{
    /* У */
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

    /*---------------- USB_UCONĴUSBENλ ----------------*/
    if (NewState != FALSE)
    {
        /* ʹUSBģֵ֧·豸 */
        SFR_SET_BIT_ASM(USB_UCON, USB_UCON_USBEN_POS);
    }
    else
    {
        /* ֹUSBģֵ֧·Ͽ豸 */
        SFR_CLR_BIT_ASM(USB_UCON, USB_UCON_USBEN_POS);
    }
}

/**
  *   USBͼʹܡ
  *   NewState: USBͼʹ״̬ȡֵΪTRUE  FALSE
  *   ޡ
  */
void
USB_Eye_Test_Enable (FunctionalState NewState)
{
    /* У */
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

    /*---------------- USB_UCONĴEYETESTλ ----------------*/
    if (NewState != FALSE)
    {
        /* ʹԶͼ */
        SFR_SET_BIT_ASM(USB_UCON, USB_UCON_EYETEST_POS);
    }
    else
    {
        /* ֹԶͼ */
        SFR_CLR_BIT_ASM(USB_UCON, USB_UCON_EYETEST_POS);
    }
}

/**
  *   USBٶѡ
  *   SpeedSelect: USBٶѡȡֵΪ:
  *                      USB_LOW_SPEED: 豸
  *                      USB_FULL_SPEED: ȫ豸
  *   ޡ
  */
void
USB_Speed_Config (uint32_t SpeedSelect)
{
    /* У */
    CHECK_RESTRICTION(CHECK_USB_SPEED_SELECT(SpeedSelect));

    /*---------------- USB_UCONĴSPEEDENλ ----------------*/
    if (SpeedSelect != USB_LOW_SPEED)
    {
        /* ȫ豸 */
        SFR_SET_BIT_ASM(USB_UCON, USB_UCON_SPEEDEN_POS);
    }
    else
    {
        /* 豸 */
        SFR_CLR_BIT_ASM(USB_UCON, USB_UCON_SPEEDEN_POS);
    }
}

/**
  *   USBƬʹܡ
  *   NewState: USBƬʹ״̬ȡֵΪTRUE  FALSE
  *   ޡ
  */
void
USB_On_Chip_Pull_Up_Enable (FunctionalState NewState)
{
    /* У */
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

    /*---------------- USB_UCONĴUPUENλ ----------------*/
    if (NewState != FALSE)
    {
        /* ʹƬ */
        SFR_SET_BIT_ASM(USB_UCON, USB_UCON_UPUEN_POS);
    }
    else
    {
        /* ֹƬ */
        SFR_CLR_BIT_ASM(USB_UCON, USB_UCON_UPUEN_POS);
    }
}

/**
  *   USB˫ʹܡ
  *   DoubleBuffer: USB˫ʹ״̬ȡֵΪ:
  *                       USB_DOUBLE_BUFFER_FORBID: ֹż/˫
  *                       USB_OUT_ENDPOINT_0: ʹOUT˵0ż/˫
  *                       USB_ALL_ENDPOINTS: ʹж˵ż/˫
  *                       USB_ENDPOINT_1_TO_7: ʹܶ˵17ż/˫
  *   ޡ
  */
void
USB_Double_Buffer_Config (uint32_t DoubleBuffer)
{
    /* У */
    CHECK_RESTRICTION(CHECK_USB_DOUBLE_BUFFER(DoubleBuffer));

    /*---------------- USB_UCONĴDBλ ----------------*/
    USB_UCON = SFR_Config (USB_UCON, ~USB_UCON_DB, DoubleBuffer);
}

/**
  *   ȡUSB״̬Ϣ
  *   usbStateStruct: USB״̬Ϣṹ壬¼SIEе״̬
  *   ޡ
  */
void
USB_Get_Arrangement_State (USB_StateTypeDef* usbStateStruct)
{
    uint32_t tmpreg = 0;
    uint32_t tmpreg1 = 0;

    /* У */
    CHECK_RESTRICTION(usbStateStruct != (USB_StateTypeDef*)0);

    /*---------------- ȡUSB_USTATĴ ----------------*/
    tmpreg = USB_USTAT;

    /*---------------- ȡUSB_USTATĴPEPλ ----------------*/
    /* ¼m_EndPointm_EndPointDirection */
    tmpreg1 = tmpreg & USB_USTAT_PEP;
    tmpreg1 >>= USB_USTAT_PEP0_POS;
    usbStateStruct->m_EndPoint = tmpreg1;

    /*---------------- ȡUSB_USTATĴPDIRλ ----------------*/
    tmpreg1 = tmpreg & USB_USTAT_PDIR;
    tmpreg1 >>= USB_USTAT_PDIR_POS;
    usbStateStruct->m_BDDirection = tmpreg1;

    /*---------------- ȡUSB_USTATĴDBIλ ----------------*/
    tmpreg1 = tmpreg & USB_USTAT_DBI;
    tmpreg1 >>= USB_USTAT_DBI_POS;
    usbStateStruct->m_BDPointer = tmpreg1;
}

/**
  *   USBַ
  *   Address: USBַȡֵΪ0~0x7F
  *   ޡ
  */
void
USB_Address_Config (uint32_t Address)
{
	uint32_t tmpreg = 0;
    /* У */
    CHECK_RESTRICTION(CHECK_USB_ADDRESS(Address));

    /*---------------- USB_UADDRĴUADDRλ ----------------*/
    tmpreg = Address << USB_UADDR_UADDR0_POS;
    USB_UADDR = SFR_Config (USB_UADDR, ~USB_UADDR_UADDR, tmpreg);
}

/**
  *   ȡUSBַ
  *   ޡ
  *   USBַȡֵΪ0~0x7F
  */
uint32_t
USB_Get_Address (void)
{
    uint32_t tmpreg = 0;

    /*------------- ȡUSB_UADDRĴUADDRλ -------------*/
    tmpreg = USB_UADDR;
    tmpreg &= USB_UADDR_UADDR;
    tmpreg >>= USB_UADDR_UADDR0_POS;

    return tmpreg;
}

/**
  *   ȡUSB֡š
  *   ޡ
  *   USB֡ţȡֵΪ0~0x7FF
  */
uint32_t
USB_Get_Frame_Num (void)
{
    uint32_t tmpreg = 0;

    /*------------- ȡUSB_UFRMĴUFRMλ -------------*/
    tmpreg = USB_UFRM;
    tmpreg &= USB_UFRM_UFRM;
    tmpreg >>= USB_UFRM_UFRM0_POS;

    return tmpreg;
}

/**
  *   USB˵ʹܡ
  *   EndPoint: USB˵ţȡֵΪUSB_ENDPOINT_0~USB_ENDPOINT_8
  *       NewState: USB˵ʹ״̬ȡֵΪTRUE  FALSE
  *   ޡ
  */
void
USB_Endpoint_Handshake_Enable (uint32_t EndPoint, FunctionalState NewState)
{
    /* У */
    CHECK_RESTRICTION(CHECK_USB_ENDPOINT_NUM(EndPoint));
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

    /*---------------- USB_UEPĴEPHSHKλ ----------------*/
    if (NewState != FALSE)
    {
        /* ʹܶ˵ */
        SFR_SET_BIT_ASM(USB_SFR->UEP[EndPoint], USB_UEP_EPHSHK_POS);
    }
    else
    {
        /* ֹ˵ */
        SFR_CLR_BIT_ASM(USB_SFR->UEP[EndPoint], USB_UEP_EPHSHK_POS);
    }
}

/**
  *   USB˫˵ʹܡ
  *   EndPoint: USB˵ţȡֵΪUSB_ENDPOINT_0~USB_ENDPOINT_8
  *       NewState: USB˫˵ʹ״̬ȡֵΪTRUE  FALSE
  *   ޡ
  */
void
USB_Bidirectional_Endpoint_Enable (uint32_t EndPoint, FunctionalState NewState)
{
    /* У */
    CHECK_RESTRICTION(CHECK_USB_ENDPOINT_NUM(EndPoint));
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

    /*---------------- USB_UEPĴEPCONDISλ ----------------*/
    if (NewState != FALSE)
    {
        /* ʹܶ˵ƣSETUPͣͬʱIN OUT  */
        SFR_CLR_BIT_ASM(USB_SFR->UEP[EndPoint], USB_UEP_EPCONDIS_POS);
    }
    else
    {
        /* ֹ˵ƴͣIN OUT  */
        SFR_SET_BIT_ASM(USB_SFR->UEP[EndPoint], USB_UEP_EPCONDIS_POS);
    }
}

/**
  *   USB˵ʹܡ
  *   EndPoint: USB˵ţȡֵΪUSB_ENDPOINT_0~USB_ENDPOINT_8
  *       NewState: USB˵ʹ״̬ȡֵΪTRUE  FALSE
  *   ޡ
  */
void
USB_Endpoint_Output_Enable (uint32_t EndPoint, FunctionalState NewState)
{
    /* У */
    CHECK_RESTRICTION(CHECK_USB_ENDPOINT_NUM(EndPoint));
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

    /*---------------- USB_UEPĴEPOUTENλ ----------------*/
    if (NewState != FALSE)
    {
        /* ʹܶ˵ */
        SFR_SET_BIT_ASM(USB_SFR->UEP[EndPoint], USB_UEP_EPOUTEN_POS);
    }
    else
    {
        /* ֹ˵ */
        SFR_CLR_BIT_ASM(USB_SFR->UEP[EndPoint], USB_UEP_EPOUTEN_POS);
    }
}

/**
  *   USB˵ʹܡ
  *   EndPoint: USB˵ţȡֵΪUSB_ENDPOINT_0~USB_ENDPOINT_8
  *       NewState: USB˵ʹ״̬ȡֵΪTRUE  FALSE
  *   ޡ
  */
void
USB_Endpoint_Input_Enable (uint32_t EndPoint, FunctionalState NewState)
{
    /* У */
    CHECK_RESTRICTION(CHECK_USB_ENDPOINT_NUM(EndPoint));
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

    /*---------------- USB_UEPĴEPINENλ ----------------*/
    if (NewState != FALSE)
    {
        /* ʹܶ˵ */
        SFR_SET_BIT_ASM(USB_SFR->UEP[EndPoint], USB_UEP_EPINEN_POS);
    }
    else
    {
        /* ֹ˵ */
        SFR_CLR_BIT_ASM(USB_SFR->UEP[EndPoint], USB_UEP_EPINEN_POS);
    }
}

/**
  *   ȡUSB˵STALLָʾ־
  *   EndPoint: USB˵ţȡֵΪUSB_ENDPOINT_0~USB_ENDPOINT_8
  *   USB˵STALLָʾ־1˵ϷSTALLְ2˵δ
  *       STALLְ
  */
FlagStatus
USB_Get_Endpoint_STALL_Flag (uint32_t EndPoint)
{
    /* У */
    CHECK_RESTRICTION(CHECK_USB_ENDPOINT_NUM(EndPoint));

    /*---------------- ȡUSB_UEPĴEPSTLλ ----------------*/
    if (USB_SFR->UEP[EndPoint] & USB_UEP_EPSTL)
    {
        /* ˵ϷSTALLְ */
        return SET;
    }
    else
    {
        /* ˵δSTALLְ */
        return RESET;
    }
}

/**
  *   USB˵STALLָʾ־
  *   EndPoint: USB˵ţȡֵΪUSB_ENDPOINT_0~USB_ENDPOINT_8
  *   ޡ
  */
void
USB_Clear_Endpoint_STALL_Flag (uint32_t EndPoint)
{
    /* У */
    CHECK_RESTRICTION(CHECK_USB_ENDPOINT_NUM(EndPoint));

    /*---------------- USB_UEPĴEPSTLλ ----------------*/
    while(USB_SFR->UEP[EndPoint] & USB_UEP_EPSTL)
    {
    	SFR_CLR_BIT_ASM(USB_SFR->UEP[EndPoint], USB_UEP_EPSTL_POS);
    }
}

/**
  *   USB Debugʹܡ
  *   NewState: USB Debugʹ״̬ȡֵΪTRUE  FALSE
  *   ޡ
  */
void
USB_Debug_Signal_Output_Enable (FunctionalState NewState)
{
    /* У */
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

    /*---------------- USB_UDBĴDEBUGENλ ----------------*/
    if (NewState != FALSE)
    {
        /* ʹDebugź */
        SFR_SET_BIT_ASM(USB_UDB, USB_UDB_DEBUGEN_POS);
    }
    else
    {
        /* ֹDebugź */
        SFR_CLR_BIT_ASM(USB_UDB, USB_UDB_DEBUGEN_POS);
    }
}

/**
  *   USB Debugѡ
  *   DebugCtl: USB DebugѡȡֵΪ:
  *                   USB_DBG_DATA_OUTPUT_AND_CLOCK: ˡˡڲʱ
  *                   USB_DBG_RECEIVE_AND_CLOCK: ģ鴦ݡģģյݡģͬʱ
  *                   USB_DBG_DATA_INPUT_AND_CLOCK: ˡ븺ˡʹ
  *                   USB_DBG_RAM_DATA: RAM
  *                   USB_DBG_USB_STATE_MACHINE: USB״̬
  *                   USB_DBG_RAM_STATE_MACHINE: USB RAM״̬
  *                   USB_DBG_RAM_ADDRESS: RAMַ
  *                   USB_DBG_OPERATIONAL_CONTROL: CRC5пơCRC16пơUSBտ
  *   ޡ
  */
void
USB_Debug_Output_Config (uint32_t DebugCtl)
{
    /* У */
    CHECK_RESTRICTION(CHECK_USB_DBG_CONFIG(DebugCtl));

    /*---------------- USB_UDBĴDEBUGλ ----------------*/
    USB_UDB = SFR_Config (USB_UDB, ~USB_UDB_DEBUG, DebugCtl);
}
/**
  *   ##### USBģ(USB)ú #####
  */


/**
  *   ##### USBģ(USB) #####
  */
/**
  *   ȡUSB˵㻺RAMַUSB_UCONĴDBλѡӦĲ
  *       ӦĻżBufferDescriporЧ
  *   EndPoint: USB˵ţȡֵΪUSB_ENDPOINT_0~USB_ENDPOINT_8
  *       Direction: USB˵㷽ȡֵΪ
  *                    USB_ENDPOINT_OUTPUT: ˵
  *                    USB_ENDPOINT_INPUT: ˵
  *       BufferDescripor: USBżBD洢ȡֵΪ
  *                          USB_ODD_BUFFER_DESCRIPOR: 
  *                          USB_EVEN_BUFFER_DESCRIPOR: ż
  *   USB˵㻺32λRAMַ򷵻0
  */
uint32_t
USB_Get_Endpoint_Double_Buffer_Addr (uint32_t EndPoint,
                    uint32_t Direction, uint32_t BufferDescripor)
{
    uint32_t tmpreg = 0;
    uint32_t tmpaddr = 0;

    /* У */
    CHECK_RESTRICTION(CHECK_USB_ENDPOINT_NUM(EndPoint));
    CHECK_RESTRICTION(CHECK_USB_ENDPOINT_DIRECT(Direction));
    CHECK_RESTRICTION(CHECK_USB_ODD_EVEN(BufferDescripor));

    /*------------- ȡUSB_UCONĴDBλ -------------*/
    tmpreg = USB_UCON;
    tmpreg &= USB_UCON_DB;

    /* ˵㻺Ĺģʽƥ */
    switch (tmpreg)
    {
        /* ֹż/˫ */
        case USB_DOUBLE_BUFFER_FORBID:
        {
            /* ˵07˫ */
            tmpaddr = USB_BUFFER_START_ADDR;
            tmpaddr += EndPoint * 8;
            tmpaddr += Direction * 4;
        }
            break;
        /* ʹOUT˵0ż/˫ */
        case USB_OUT_ENDPOINT_0:
        {
            if (EndPoint != USB_ENDPOINT_0)
            {
                /* ˵17˫ */
                tmpaddr = USB_BUFFER_START_ADDR + (4 * 3);
                tmpaddr += (EndPoint - 1) * 8;
                tmpaddr += Direction * 4;
            }
            else
            {
                /* ˵0˫ */
                if (Direction != USB_ENDPOINT_INPUT)
                {
                    /* ˵0˫ */
                    tmpaddr = USB_BUFFER_START_ADDR;
                    tmpaddr += (uint32_t)(!BufferDescripor) * 4;
                }
                else
                {
                    /* ˵0˫ */
                    tmpaddr = USB_BUFFER_START_ADDR + (4 * 2);
                }
            }
        }
            break;
        /* ʹж˵ż/˫ */
        case USB_ALL_ENDPOINTS:
        {
            tmpaddr = USB_BUFFER_START_ADDR;
            tmpaddr += EndPoint * 4 * 4;
            tmpaddr += Direction * 4 * 2;
            tmpaddr += (uint32_t)(!BufferDescripor) * 4;
        }
            break;
        /* ʹܶ˵17ż/˫ */
        case USB_ENDPOINT_1_TO_7:
        {
            if (EndPoint != USB_ENDPOINT_0)
            {
                /* ˵17˫ */
                tmpaddr = USB_BUFFER_START_ADDR + 4 * 2;
                tmpaddr += (EndPoint - 1) * 4 * 4;
                tmpaddr += Direction * 4 * 2;
                tmpaddr += (uint32_t)(!BufferDescripor) * 4;
            }
            else
            {
                /* ˵0˫ */
                tmpaddr = USB_BUFFER_START_ADDR;
                tmpaddr += Direction * 4;
            }
        }
            break;
        default:
            CHECK_RESTRICTION(0);
            break;
    }

    return tmpaddr;
}

/**
  *   USB RAMַӲ10λЧֶ롣
  *   SfrAddr: USB ״̬ĴַȡֵΪָ32λRAMַ
  *                ɺUSB_Get_Endpoint_Double_Buffer_Addrȡ
  *       BufferAddr: USB RAMַȡֵΪ0~0xFFFF
  *   ޡ
  */
void
USB_Buffer_Address_Config (uint32_t SfrAddr, uint16_t BufferAddr)
{
    uint32_t tmpaddr = 0;
    uint32_t tmpreg = 0;

    /* У */
    CHECK_RESTRICTION(CHECK_USB_BUFFER_ADDR(SfrAddr));

    /*---------------- USB_BDnSTATĴBADDRλ ----------------*/
    tmpaddr = SfrAddr;
    tmpreg = ((uint32_t)BufferAddr) << USB_BDSTAT_BADDR0_POS;
    *(volatile uint32_t *) tmpaddr =
                    SFR_Config (*(volatile uint32_t *) tmpaddr,
                            ~USB_BDSTAT_BADDR,
                            tmpreg);
}

/**
  *   ȡUSB RAMַӲ10λЧֶ롣
  *   SfrAddr: USB ״̬ĴַȡֵΪָ32λRAMַ
  *                ɺUSB_Get_Endpoint_Double_Buffer_Addrȡ
  *   USB RAMֶַ룬10λЧֵ
  */
uint32_t
USB_Get_Buffer_Address (uint32_t SfrAddr)
{
    uint32_t tmpreg = 0;

    /* У */
    CHECK_RESTRICTION(CHECK_USB_BUFFER_ADDR(SfrAddr));

    /*---------------- ȡUSB_BDnSTATĴBADDRλ ----------------*/
    tmpreg = *(volatile uint32_t *) SfrAddr;
    tmpreg &= USB_BDSTAT_BADDR;
    tmpreg >>= USB_BDSTAT_BADDR0_POS;

    return tmpreg;
}

/**
  *   USB RAMֽڳȡ
  *   SfrAddr: USB ״̬ĴַȡֵΪָ32λRAMַ
  *                ɺUSB_Get_Endpoint_Double_Buffer_Addrȡ
  *       ByteLength: USB RAMֽڳȣȡֵΪ0~0x3FF
  *   ޡ
  */
void
USB_Buffer_Data_Length_Config (uint32_t SfrAddr, uint32_t ByteLength)
{
    uint32_t tmpreg = 0;
    uint32_t tmpaddr = 0;

    /* У */
    CHECK_RESTRICTION(CHECK_USB_BUFFER_ADDR(SfrAddr));
    CHECK_RESTRICTION(CHECK_USB_DATA_LENGTH(ByteLength));

    /*---------------- USB_BDnSTATĴBCλ ----------------*/
    tmpaddr = SfrAddr;
    tmpreg = ((ByteLength >> 8) & USB_BDSTAT_BCH) << USB_BDSTAT_BC8_POS;
    tmpreg |= (ByteLength & 0xFF) << USB_BDSTAT_BC0_POS;
    *(volatile uint32_t *) tmpaddr =
                    SFR_Config (*(volatile uint32_t *) tmpaddr,
                            ~USB_BDSTAT_BC,
                            tmpreg);
}

/**
  *   ȡUSBֽ
  *   SfrAddr: USB ״̬ĴַȡֵΪָ32λRAMַ
  *                ɺUSB_Get_Endpoint_Double_Buffer_Addrȡ
  *   USBֽ10λЧֵ
  */
uint32_t
USB_Get_Buffer_Data_Length (uint32_t SfrAddr)
{
    uint32_t tmpreg = 0;
    uint32_t tmpreg1 = 0;
    uint32_t tmpaddr = 0;

    /* У */
    CHECK_RESTRICTION(CHECK_USB_BUFFER_ADDR(SfrAddr));

    /*---------------- ȡUSB_BDnSTATĴBADDRλ ----------------*/
    tmpaddr = SfrAddr;
    tmpreg =  *(volatile uint32_t *) tmpaddr;
    tmpreg1 = *(volatile uint32_t *) tmpaddr;
    /* ȡBCλĸλ */
    tmpreg &= USB_BDSTAT_BCH;
    tmpreg >>= USB_BDSTAT_BC8_POS;
    /* ȡBCλĵλ */
    tmpreg1 &= USB_BDSTAT_BCL;
    tmpreg1 >>= USB_BDSTAT_BC0_POS;

    tmpreg = (tmpreg << (USB_BDSTAT_BC7_POS + 1)) | (tmpreg1);

    return tmpreg;
}

/**
  *   USB ӵλ
  *   SfrAddr: USB ״̬ĴַȡֵΪָ32λRAMַ
  *                ɺUSB_Get_Endpoint_Double_Buffer_Addrȡ
  *       OwnSelect: USB ӵλѡȡֵΪ:
  *                    USB_KERNEL_OWN_BD: ƬںӵBD ӦĻ
  *                    USB_SIE_OWN_BD: SIE ӵBD ӦĻ
  *   ޡ
  */
void
USB_Own_Config (uint32_t SfrAddr, uint32_t OwnSelect)
{
    uint32_t tmpaddr = 0;

    /* У */
    CHECK_RESTRICTION(CHECK_USB_BUFFER_ADDR(SfrAddr));
    CHECK_RESTRICTION(CHECK_USB_OWN_BD(OwnSelect));

    /*---------------- USB_BDnSTATĴUOWNλ ----------------*/
    tmpaddr = SfrAddr;
    if (OwnSelect != USB_KERNEL_OWN_BD)
    {
        /* SIE ӵBD ӦĻ */
        SFR_SET_BIT_ASM(*(volatile uint32_t *) tmpaddr, USB_BDSTAT_UOWN_POS);
    }
    else
    {
        /* ƬںӵBD ӦĻ */
        SFR_CLR_BIT_ASM(*(volatile uint32_t *) tmpaddr, USB_BDSTAT_UOWN_POS);
    }
}

/**
  *   ȡUSB ӵλ
  *   SfrAddr: USB ״̬ĴַȡֵΪָ32λRAMַ
  *                ɺUSB_Get_Endpoint_Double_Buffer_Addrȡ
  *   1: SIE ӵBD ӦĻ
  *       0: ƬںӵBD ӦĻ
  */
FlagStatus
USB_Get_Own_Status (uint32_t SfrAddr)
{
    uint32_t tmpaddr = 0;

    /* У */
    CHECK_RESTRICTION(CHECK_USB_BUFFER_ADDR(SfrAddr));

    /*---------------- ȡUSB_BDnSTATĴUOWNλ ----------------*/
    tmpaddr = SfrAddr;
    if (USB_BDSTAT_UOWN & (*(volatile uint32_t *) tmpaddr))
    {
        /* SIE ӵBD ӦĻ */
        return SET;
    }
    else
    {
        /* ƬںӵBD ӦĻ */
        return RESET;
    }
}

/**
  *   USBݷתͬλֻеƬںӵBDӦĻ
  *       ʹݷתͬʱλЧ
  *   SfrAddr: USB ״̬ĴַȡֵΪָ32λRAMַ
  *                ɺUSB_Get_Endpoint_Double_Buffer_Addrȡ
  *       DataPackage: USB ݷתͬλѡȡֵΪ:
  *                      USB_DATA_0_TOGGLE_SYNC: 0 ݰ
  *                      USB_DATA_1_TOGGLE_SYNC: 1 ݰ
  *   ޡ
  */
void
USB_Data_Toggle_Sync_Config (uint32_t SfrAddr, uint32_t DataPackage)
{
    uint32_t tmpaddr = 0;

    /* У */
    CHECK_RESTRICTION(CHECK_USB_BUFFER_ADDR(SfrAddr));
    CHECK_RESTRICTION(CHECK_USB_DATA_TOGGLE_SYNC(DataPackage));

    /*---------------- USB_BDnSTATĴDTSλ ----------------*/
    tmpaddr = SfrAddr;
    if (DataPackage != USB_DATA_0_TOGGLE_SYNC)
    {
        /* 1 ݰ */
        SFR_SET_BIT_ASM(*(volatile uint32_t *) tmpaddr, USB_BDSTAT_DTS_POS);
    }
    else
    {
        /* 0 ݰ */
        SFR_CLR_BIT_ASM(*(volatile uint32_t *) tmpaddr, USB_BDSTAT_DTS_POS);
    }
}

/**
  *   ȡUSBݷתͬλֻеƬںӵBDӦĻ
  *       ʹݷתͬʱλЧ
  *   SfrAddr: USB ״̬ĴַȡֵΪָ32λRAMַ
  *                ɺUSB_Get_Endpoint_Double_Buffer_Addrȡ
  *   1: 1 ݰ
  *       0: 0 ݰ
  */
FlagStatus
USB_Get_Data_Toggle_Sync_Status (uint32_t SfrAddr)
{
    uint32_t tmpaddr = 0;

    /* У */
    CHECK_RESTRICTION(CHECK_USB_BUFFER_ADDR(SfrAddr));

    /*---------------- ȡUSB_BDnSTATĴDTSλ ----------------*/
    tmpaddr = SfrAddr;
    if (USB_BDSTAT_DTS & (*(volatile uint32_t *) tmpaddr))
    {
        /* 1 ݰ */
        return SET;
    }
    else
    {
        /* 0 ݰ */
        return RESET;
    }
}

/**
  *   USBݷתͬʹܣֻеƬںӵBDӦĻʱ
  *       ùЧ
  *   SfrAddr: USB ״̬ĴַȡֵΪָ32λRAMַ
  *                ɺUSB_Get_Endpoint_Double_Buffer_Addrȡ
  *       NewState: USBݷתͬʹ״̬ȡֵΪTRUE  FALSE
  *   ޡ
  */
void
USB_Data_Toggle_Sync_Enable (uint32_t SfrAddr, FunctionalState NewState)
{
    uint32_t tmpaddr = 0;

    /* У */
    CHECK_RESTRICTION(CHECK_USB_BUFFER_ADDR(SfrAddr));
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

    /*---------------- USB_BDnSTATĴDTSENλ ----------------*/
    tmpaddr = SfrAddr;
    if (NewState != FALSE)
    {
        /* ʹݷתͬ */
        SFR_SET_BIT_ASM(*(volatile uint32_t *) tmpaddr, USB_BDSTAT_DTSEN_POS);
    }
    else
    {
        /* ִݷתͬ */
        SFR_CLR_BIT_ASM(*(volatile uint32_t *) tmpaddr, USB_BDSTAT_DTSEN_POS);
    }
}

/**
  *   USBֹͣʹܣֻеƬںӵBDӦĻʱ
  *       ùЧ
  *   SfrAddr: USB ״̬ĴַȡֵΪָ32λRAMַ
  *                ɺUSB_Get_Endpoint_Double_Buffer_Addrȡ
  *       NewState: USBֹͣʹ״̬ȡֵΪTRUE  FALSE
  *   ޡ
  */
void
USB_Buffer_Stall_Enable (uint32_t SfrAddr, FunctionalState NewState)
{
    uint32_t tmpaddr = 0;

    /* У */
    CHECK_RESTRICTION(CHECK_USB_BUFFER_ADDR(SfrAddr));
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));


    /*---------------- USB_BDnSTATĴBSTALLλ ----------------*/
    tmpaddr = SfrAddr;
    if (NewState != FALSE)
    {
        /* ʹֹܻͣ */
        SFR_SET_BIT_ASM(*(volatile uint32_t *) tmpaddr, USB_BDSTAT_BSTALL_POS);
    }
    else
    {
        /* ֹֹͣ */
        SFR_CLR_BIT_ASM(*(volatile uint32_t *) tmpaddr, USB_BDSTAT_BSTALL_POS);
    }
}

/**
  *   ȡUSBݰʶֻSIEӵBDӦĻʱùЧ
  *   SfrAddr: USB ״̬ĴַȡֵΪָ32λRAMַ
  *                ɺUSB_Get_Endpoint_Double_Buffer_Addrȡ
  *   һδͽյPIDֵ
  */
uint32_t
USB_Get_Last_Receive_PID (uint32_t SfrAddr)
{
    uint32_t tmpreg = 0;
    uint32_t tmpaddr = 0;

    /* У */
    CHECK_RESTRICTION(CHECK_USB_BUFFER_ADDR(SfrAddr));

    /*---------------- ȡUSB_BDnSTATĴPIDλ ----------------*/
    tmpaddr = SfrAddr;
    tmpreg = *(volatile uint32_t *) tmpaddr;
    tmpreg &= USB_BDSTAT_PID;
    tmpreg >>= USB_BDSTAT_PID0_POS;

    return tmpreg;
}

/**
  *   дһUSBݣд볤Ȳ֤WriteAddrΪUSB
  *       ַWriteAddrWriteDataAddrڴڳLengthвص
  *   WriteAddr: дRAMַȡֵΪָ32λRAMַ
  *       WriteDataAddr: дݵַȡֵΪָ32λRAMַ
  *       Length: дݳȣȡֵ10λЧֵ
  *   ޡ
  */
void
USB_Write_Buffer_Data (uint32_t WriteAddr,
                    uint32_t WriteDataAddr, uint32_t Length)
{
    /* У */
    CHECK_RESTRICTION(CHECK_USB_BUFFER_ADDR(WriteAddr));
    CHECK_RESTRICTION(CHECK_USB_DATA_LENGTH(Length));

    memcpy ((void *)WriteAddr, (void *)WriteDataAddr, Length);
}
/**
  *   ##### USBģ(USB) #####
  */


/**
  *   ##### USBģ(USB)жϹ #####
  */
/**
  *   ȡUSBжϱ־
  *   InterruptType: USBжͣȡֵΧΪṩһ:
  *                        USB_INT_ERROR: USB ж
  *                        USB_INT_RESET: USB λж
  *                        USB_INT_TRANSACTION_COMPLETED: ж
  *                        USB_INT_BUS_ACTIVE: ߻ж
  *                        USB_INT_IDLE: мж
  *                        USB_INT_STALL_HANDSHAKE: STALL ж
  *                        USB_INT_SOF_TAKEN: ֡ʼж
  *                        USB_INT_DATE_FIELD_NOT_BYTE: ֶδСж
  *                        USB_INT_CRC5_HOST_ERROR: CRC5 ж
  *                        USB_INT_CRC16_FAILURE: CRC16 ʧж
  *                        USB_INT_PID_CHECK_FAILURE: PID ʧж
  *                        USB_INT_BUS_TURNAROUND_TIMEOUT: תʱж
  *                        USB_INT_BIT_STUFF_ERROR: λж
  *   1:жϣ0:δжϡ
  */
FlagStatus
USB_Get_INT_Flag (uint32_t InterruptType)
{
    /* У */
    CHECK_RESTRICTION(CHECK_USB_INT_ONE_EVENT(InterruptType));

    /*---------------- ȡUSB_UIRĴжϱ־λ ----------------*/
    if (USB_UIR & InterruptType)
    {
        /* ж */
        return SET;
    }
    else
    {
        /* δж */
        return RESET;
    }
}

/**
  *   USBжϱ־
  *   InterruptType: USBжͣȡֵΧΪṩһ:
  *                        USB_INT_ERROR: USB ж
  *                        USB_INT_RESET: USB λж
  *                        USB_INT_TRANSACTION_COMPLETED: ж
  *                        USB_INT_BUS_ACTIVE: ߻ж
  *                        USB_INT_IDLE: мж
  *                        USB_INT_STALL_HANDSHAKE: STALL ж
  *                        USB_INT_SOF_TAKEN: ֡ʼж
  *                        USB_INT_DATE_FIELD_NOT_BYTE: ֶδСж
  *                        USB_INT_CRC5_HOST_ERROR: CRC5 ж
  *                        USB_INT_CRC16_FAILURE: CRC16 ʧж
  *                        USB_INT_PID_CHECK_FAILURE: PID ʧж
  *                        USB_INT_BUS_TURNAROUND_TIMEOUT: תʱж
  *                        USB_INT_BIT_STUFF_ERROR: λж
  *   ޡ
  */
void
USB_Clear_INT_Flag (uint32_t InterruptType)
{
    /* У */
    CHECK_RESTRICTION(CHECK_USB_INT_EVENT(InterruptType));

    /*---------------- USB_UIRĴжϱ־λ ----------------*/
    while(USB_UIR & InterruptType)
    {
    	USB_UIR &= ~InterruptType;
    }
}

/**
  *   USBжʹܡ
  *   InterruptType: USBжͣȡֵΧΪṩһ:
  *                        USB_INT_ERROR: USB ж
  *                        USB_INT_RESET: USB λж
  *                        USB_INT_TRANSACTION_COMPLETED: ж
  *                        USB_INT_BUS_ACTIVE: ߻ж
  *                        USB_INT_IDLE: мж
  *                        USB_INT_STALL_HANDSHAKE: STALL ж
  *                        USB_INT_SOF_TAKEN: ֡ʼж
  *                        USB_INT_DATE_FIELD_NOT_BYTE: ֶδСж
  *                        USB_INT_CRC5_HOST_ERROR: CRC5 ж
  *                        USB_INT_CRC16_FAILURE: CRC16 ʧж
  *                        USB_INT_PID_CHECK_FAILURE: PID ʧж
  *                        USB_INT_BUS_TURNAROUND_TIMEOUT: תʱж
  *                        USB_INT_BIT_STUFF_ERROR: λж
  *       NewState: USBжʹ״̬ȡֵΪTRUE  FALSE
  *   ޡ
  */
void
USB_Set_INT_Enable (uint32_t InterruptType, FunctionalState NewState)
{
    /* У */
    CHECK_RESTRICTION(CHECK_USB_INT_EVENT(InterruptType));
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

    /*---------------- USB_UIEĴжʹλ ----------------*/
    if (NewState != FALSE)
    {
        /* ʹж */
        USB_UIE |= InterruptType;
    }
    else
    {
        /* ֹж */
        USB_UIE &= ~InterruptType;
    }
}

/**
  *   ȡUSBжʹ״̬
  *   InterruptType: USBжͣȡֵΧΪṩһ:
  *                        USB_INT_ERROR: USB ж
  *                        USB_INT_RESET: USB λж
  *                        USB_INT_TRANSACTION_COMPLETED: ж
  *                        USB_INT_BUS_ACTIVE: ߻ж
  *                        USB_INT_IDLE: мж
  *                        USB_INT_STALL_HANDSHAKE: STALL ж
  *                        USB_INT_SOF_TAKEN: ֡ʼж
  *                        USB_INT_DATE_FIELD_NOT_BYTE: ֶδСж
  *                        USB_INT_CRC5_HOST_ERROR: CRC5 ж
  *                        USB_INT_CRC16_FAILURE: CRC16 ʧж
  *                        USB_INT_PID_CHECK_FAILURE: PID ʧж
  *                        USB_INT_BUS_TURNAROUND_TIMEOUT: תʱж
  *                        USB_INT_BIT_STUFF_ERROR: λж
  *   1:жʹܣ0:жδʹܡ
  */
FlagStatus
USB_Get_INT_Enable (uint32_t InterruptType)
{
    /* У */
    CHECK_RESTRICTION(CHECK_USB_INT_ONE_EVENT(InterruptType));

    /*---------------- ȡUSB_UIEĴжϱ־λ ----------------*/
    if (USB_UIE & InterruptType)
    {
        /* жʹ */
        return SET;
    }
    else
    {
        /* жδʹ */
        return RESET;
    }
}
/**
  *   ##### USBģ(USB)жϹ #####
  */
#endif  //KF32A_Periph_usb

