/**
  ******************************************************************************
  * ļ  kf32a_basic_sysctl.c
  *     ChipON_AE/FAE_Group
  *     V2.6.2
  *     2019-11-16
  *     ļṩϵͳصĹܺ
  *          + ϵͳ(SYSCTL)ú
  *          + DOָú
  *
  *********************************************************************
  */

#include "kf32a_basic_sysctl.h"

/* ϵͳ˽ж ----------------------------------------------------*/
/* SYS_ARCTLĴдARKEY */
#define SYS_ARCTL_WRITE_CTL             ((uint32_t)0x05FA \
                                      << SYS_ARCTL_ARKEY_POS)


/**
  *   ##### ϵͳ(SYSCTL)ú #####
  */
/**
  *   ȡ״̬Vλ־
  *   ޡ
  *   1:0:
  */
FlagStatus
SYSCTL_Get_V_Flag (void)
{
    /*---------------- ȡSYS_PSWĴVλ ----------------*/
    if (SYS_PSW & SYS_PSW_V)
    {
        /*  */
        return SET;
    }
    else
    {
        /*  */
        return RESET;
    }
}

/**
  *   ȡ״̬Cλλλ־
  *   ޡ
  *   1:ӷнλ޽λ0:ӷ޽λнλ
  */
FlagStatus
SYSCTL_Get_C_Flag (void)
{
    /*---------------- ȡSYS_PSWĴCλ ----------------*/
    if (SYS_PSW & SYS_PSW_C)
    {
        /* ӷнλ޽λ */
        return SET;
    }
    else
    {
        /* ӷ޽λнλ */
        return RESET;
    }
}

/**
  *   ȡ״̬Zλֵ־
  *   ޡ
  *   1:ֵ0:ֵ
  */
FlagStatus
SYSCTL_Get_Z_Flag (void)
{
    /*---------------- ȡSYS_PSWĴZλ ----------------*/
    if (SYS_PSW & SYS_PSW_Z)
    {
        /* ֵ */
        return SET;
    }
    else
    {
        /* ֵ */
        return RESET;
    }
}

/**
  *   ȡ״̬Nλֵ־
  *   ޡ
  *   1:ֵ0:Ǹֵ
  */
FlagStatus
SYSCTL_Get_N_Flag (void)
{
    /*---------------- ȡSYS_PSWĴNλ ----------------*/
    if (SYS_PSW & SYS_PSW_N)
    {
        /* ֵ */
        return SET;
    }
    else
    {
        /* Ǹֵ */
        return RESET;
    }
}

/**
  *   ״̬Vλ־
  *   NewState: ״̬Vλ־
  *                 ȡֵΧΪTRUE  FALSE
  *   ޡ
  */
void
SYSCTL_Set_V_Flag (FunctionalState NewState)
{
    /* У */
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

    /*---------------- SYS_PSWĴVλ ----------------*/
    if (NewState != FALSE)
    {
        /* ־ */
        SFR_SET_BIT_ASM(SYS_PSW, SYS_PSW_V_POS);
    }
    else
    {
        /* ־ */
        SFR_CLR_BIT_ASM(SYS_PSW, SYS_PSW_V_POS);
    }
}

/**
  *   ״̬Cλ־
  *   NewState: ״̬Cλλλ־
  *                 ȡֵΧΪTRUE  FALSE
  *   ޡ
  */
void
SYSCTL_Set_C_Flag (FunctionalState NewState)
{
    /* У */
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

    /*---------------- SYS_PSWĴCλ ----------------*/
    if (NewState != FALSE)
    {
        /* ýλλ־ */
        SFR_SET_BIT_ASM(SYS_PSW, SYS_PSW_C_POS);
    }
    else
    {
        /* λλ־ */
        SFR_CLR_BIT_ASM(SYS_PSW, SYS_PSW_C_POS);
    }
}

/**
  *   ״̬Zλ־
  *   NewState: ״̬Zλλλ־
  *                 ȡֵΧΪTRUE  FALSE
  *   ޡ
  */
void
SYSCTL_Set_Z_Flag (FunctionalState NewState)
{
    /* У */
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

    /*---------------- SYS_PSWĴZλ ----------------*/
    if (NewState != FALSE)
    {
        /* ýλλ־ */
        SFR_SET_BIT_ASM(SYS_PSW, SYS_PSW_Z_POS);
    }
    else
    {
        /* λλ־ */
        SFR_CLR_BIT_ASM(SYS_PSW, SYS_PSW_Z_POS);
    }
}
/**
  *   ״̬Nλֵ־
  *   NewState: ״̬NλֵǸֵ־
  *                 ȡֵΧΪTRUE  FALSE
  *   ޡ
  */
void
SYSCTL_Set_N_Flag (FunctionalState NewState)
{
    /* У */
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

    /*---------------- SYS_PSWĴZλ ----------------*/
    if (NewState != FALSE)
    {
        /* ýλλ־ */
        SFR_SET_BIT_ASM(SYS_PSW, SYS_PSW_N_POS);
    }
    else
    {
        /* λλ־ */
        SFR_CLR_BIT_ASM(SYS_PSW, SYS_PSW_N_POS);
    }
}

/**
  *   жϴؽģʽʹܡ
  *   NewState: жϴؽģʽʹ״̬ȡֵΪTRUE  FALSE
  *   ޡ
  */
void
SYSCTL_Sleep_On_Exit_Enable (FunctionalState NewState)
{
    /* У */
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

    /*---------------- SYS_MCTLĴSLEEPONEXITλ ----------------*/
    if (NewState != FALSE)
    {
        /* ʹжϷʱģʽ */
        SFR_SET_BIT_ASM(SYS_MCTL, SYS_MCTL_SLEEPONEXIT_POS);
    }
    else
    {
        /* ֹжϷʱģʽ */
        SFR_CLR_BIT_ASM(SYS_MCTL, SYS_MCTL_SLEEPONEXIT_POS);
    }
}

/**
  *   ģʽʹܡ
  *   NewState: ģʽʹ״̬ȡֵΪTRUE  FALSE
  *   ޡ
  */
void
SYSCTL_Deep_Sleep_Enable (FunctionalState NewState)
{
    /* У */
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

    /*---------------- SYS_MCTLĴSLEEPDEEPλ ----------------*/
    if (NewState != FALSE)
    {
        /* ʹģʽ */
        SFR_SET_BIT_ASM(SYS_MCTL, SYS_MCTL_SLEEPDEEP_POS);
    }
    else
    {
        /* ֹģʽ */
        SFR_CLR_BIT_ASM(SYS_MCTL, SYS_MCTL_SLEEPDEEP_POS);
    }
}

/**
  *   ûģʽѡ
  *   NewState: жϻCPUʹ״̬ȡֵΪTRUE  FALSE
  *   ޡ
  */
void
SYSCTL_Interrupt_Awake_Enable (FunctionalState NewState)
{
    /* У */
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

    /*---------------- SYS_MCTLĴSLPONMODλ ----------------*/
    if (NewState != FALSE)
    {
        /* ж϶ܻCPU */
        SFR_SET_BIT_ASM(SYS_MCTL, SYS_MCTL_SLPONMOD_POS);
    }
    else
    {
        /* ֻежȼȵǰȼʱܻCPU */
        SFR_CLR_BIT_ASM(SYS_MCTL, SYS_MCTL_SLPONMOD_POS);
    }
}

/**
  *   ȡǰжԶջĶ뷽ʽ
  *   ޡ
  *   1:˫ֶʹܣ0:˫ֶδʹܡ
  */
FlagStatus
SYSCTL_Stack_Align_State (void)
{
    /*---------------- ȡSYS_MCTLĴSTACKALIGNλ ----------------*/
    if (SYS_MCTL & SYS_MCTL_STACKALIGN)
    {
        /* ˫ֶʹ */
        return SET;
    }
    else
    {
        /* ˫ֶδʹ */
        return RESET;
    }
}

/**
  *   óûơ
  *   NewState: ѡ񳬼û־ȡֵΪTRUE  FALSE
  *   ޡ
  */
void
SYSCTL_Super_User_Config (FunctionalState NewState)
{
    /* У */
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

    /*---------------- SYS_MCTLĴSUSTAλ ----------------*/
    if (NewState != FALSE)
    {
        /* ûģʽ */
        SFR_SET_BIT_ASM(SYS_MCTL, SYS_MCTL_SUSTA_POS);
    }
    else
    {
        /* ûģʽ */
        SFR_CLR_BIT_ASM(SYS_MCTL, SYS_MCTL_SUSTA_POS);
    }
}

/**
  *   ȡǰЧջָ״̬־
  *   ޡ
  *   1:PSPǵǰĶջָ룻0:MSPǵǰĶջָ롣
  */
FlagStatus
SYSCTL_Stack_Pointer_State (void)
{
    /*---------------- ȡSYS_MCTLĴSPSELλ ----------------*/
    if (SYS_MCTL & SYS_MCTL_SPSEL)
    {
        /* PSPǵǰĶջָ */
        return SET;
    }
    else
    {
        /* MSPǵǰĶջָ */
        return RESET;
    }
}

/**
  *   õǰЧջָ롣
  *   PresentSP: ǰЧջָ룬ȡֵΪ
  *                    SYSCTL_SP_IS_MSP: MSPǵǰĶջָ
  *                    SYSCTL_SP_IS_PSP: PSPǵǰĶջָ
  *   ޡ
  */
void
SYSCTL_Stack_Pointer_Config (uint32_t PresentSP)
{
    /* У */
    CHECK_RESTRICTION(CHECK_SYSCTL_SP(PresentSP));

    /*------------------ SYS_MCTLĴSPSELλ -----------------*/
    SYS_MCTL = SFR_Config (SYS_MCTL, ~SYS_MCTL_SPSEL, PresentSP);
}

/**
  *   쳣Ϣλ
  *   NewState: 쳣ϢλȡֵΪTRUE  FALSE
  *   ޡ
  */
void
SYSCTL_Exception_Reset_Enable (FunctionalState NewState)
{
    uint32_t tmpreg = 0;

    /* У */
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

    /*------------------ SYS_ARCTLĴVECTRSTλ -----------------*/
    tmpreg = SYS_ARCTL_WRITE_CTL | \
            ((uint32_t)NewState << SYS_ARCTL_VECTRST_POS);
    SYS_ARCTL = SFR_Config (SYS_ARCTL,
                        ~(SYS_ARCTL_VECTRST | SYS_ARCTL_ARKEY),
                        tmpreg);
}

/**
  *   ϵͳλ
  *   NewState: ϵͳλȡֵΪTRUE  FALSE
  *   ޡ
  */
void
SYSCTL_System_Reset_Enable (FunctionalState NewState)
{
    uint32_t tmpreg = 0;

    /* У */
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

    /*------------------ SYS_ARCTLĴSYSTEMRSTλ -----------------*/
    tmpreg = SYS_ARCTL_WRITE_CTL | \
            ((uint32_t)NewState << SYS_ARCTL_SYSTEMRST_POS);
    SYS_ARCTL = SFR_Config (SYS_ARCTL,
                        ~(SYS_ARCTL_SYSTEMRST | SYS_ARCTL_ARKEY),
                        tmpreg);
}

/**
  *   жӳַá
  *   VectorOffset: жӳַȡֵ32λݣλӲԡ
  *   ޡ
  */
void
SYSCTL_Vector_Offset_Config (uint32_t VectorOffset)
{
	uint32_t tmpreg = 0;
    /*---------------- SYS_VECTOFFĴTBLOFFλ ----------------*/
	tmpreg = VectorOffset << SYS_VECTOFF_TBLOFF0_POS;
    SYS_VECTOFF = SFR_Config (SYS_VECTOFF,
                      ~(SYS_VECTOFF_TBLOFF),
                      tmpreg);
}


/**
  *   RAMռ䳤ȣָʾRAMռַ
  *   RamSpace: RAMռ䳤ȣȡֵΪ26λЧֵ
  *   ޡ
  */
void
SYSCTL_Ram_Space_Config (uint32_t RamSpace)
{
	uint32_t tmpreg = 0;
    /* У */
    CHECK_RESTRICTION(CHECK_RAM_SPACE(RamSpace));

    /*---------------- SYS_RAMSPAĴRAMSPAλ ----------------*/
    tmpreg = RamSpace << SYS_RAMSPA_RAMSPA0_POS;
    SYS_RAMSPA = SFR_Config (SYS_RAMSPA,
                      ~SYS_RAMSPA_RAMSPA,
                      tmpreg);
}

/**
  *   FLASHʼ512ֽڿռӳơ
  *   MemCtl: ӳƣȡֵΧΪ:
  *                 SYSCTL_FLASH_REMAP_FOR_ROM: ΪROMӳ
  *                 SYSCTL_FLASH_REMAP_FOR_RAM: ΪRAMӳ
  *                 SYSCTL_FLASH_REMAP_FOR_FLASH: ΪFLASHӳ
  *                 SYSCTL_FLASH_REMAP_STOP_CPU: ֹͣCPU
  *   ޡ
  */
void
SYSCTL_Flash_Start_Remap_Config (uint32_t MemCtl)
{
    /* У */
    CHECK_RESTRICTION(CHECK_SYSCTL_FLASH_REMAP(MemCtl));

    /*---------------- SYS_MEMCTLĴMEMMλ ----------------*/
    SYS_MEMCTL = SFR_Config (SYS_MEMCTL, ~SYS_MEMCTL_MEMM, MemCtl);
}
/**
  *   ##### ϵͳ(SYSCTL)ú #####
  */


