/**
  ******************************************************************************
  * ļ  kf32a_basic_dac.c
  *     ChipON_AE/FAE_Group
  *     V2.6.21
  *     2020-06-06
  *     ļṩDAC蹦ܺ
  *          + ʼú
  *          + ݶд
  *          + DACУĴú
  *
  *********************************************************************
  */

#include "kf32a_basic_dac.h"
#include "kf32a_basic_rst.h"
#include "kf32a_basic_pclk.h"


/* DAC˽ж ----------------------------------------------------*/
/* DACx_CTLĴ */
#define DAC_CTL_INIT_MASK               (DAC_CTL_TRIGEN \
                                       | DAC_CTL_TREVT \
                                       | DAC_CTL_DE \
                                       | DAC_CTL_WAVE \
                                       | DAC_CTL_MAS)

/* DACx_CTLĴ */
#define DAC_CTL1_INIT_MASK              (DAC_CTL1_CLK \
                                       | DAC_CTL1_RFS \
                                       | DAC_CTL1_BUFEN \
                                       | DAC_CTL1_SEL)

/* DACx_DAHDĴ */
#define DAC_CAL_INIT_MASK               (DAC_CAL_PPOSITRIM \
                                       | DAC_CAL_PNEGATRIM \
                                       | DAC_CAL_NPOSITRIM \
                                       | DAC_CAL_NNEGATRIM \
                                       | DAC_CAL_BUFTRIM)


/**
  *   ##### ʼú #####
  */
/**
  *   DAC踴λʹʱӡ
  *   DACx: ָDACڴṹָ룬ȡֵΪDAC0_SFRDAC1_SFR
  *   ޡ
  */
void
DAC_Reset (DAC_SFRmap* DACx)
{
    /* У */
    CHECK_RESTRICTION(CHECK_DAC_ALL_PERIPH(DACx));

#ifdef KF32A_Periph_dac0
    if (DACx == DAC0_SFR)
    {
        RST_CTL1_Peripheral_Reset_Enable(RST_CTL1_DAC0RST, TRUE);
        RST_CTL1_Peripheral_Reset_Enable(RST_CTL1_DAC0RST, FALSE);
        PCLK_CTL1_Peripheral_Clock_Enable(PCLK_CTL1_DAC0CLKEN, TRUE);
    }
#endif
#ifdef KF32A_Periph_dac1
    if (DACx == DAC1_SFR)
    {
        RST_CTL1_Peripheral_Reset_Enable(RST_CTL1_DAC1RST, TRUE);
        RST_CTL1_Peripheral_Reset_Enable(RST_CTL1_DAC1RST, FALSE);
        PCLK_CTL1_Peripheral_Clock_Enable(PCLK_CTL1_DAC1CLKEN, TRUE);
    }
#endif
}

/**
  *   DACá
  *   DACx: ָDACڴṹָ룬ȡֵΪDAC0_SFRDAC1_SFR
  *       dacInitStruct: DACϢ
  *   ޡ
  */
void
DAC_Configuration (DAC_SFRmap* DACx, DAC_InitTypeDef* dacInitStruct)
{
    uint32_t tmpreg = 0;

    /* У */
    CHECK_RESTRICTION(CHECK_DAC_ALL_PERIPH(DACx));
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(dacInitStruct->m_TriggerEnable));
    CHECK_RESTRICTION(CHECK_DAC_TRIGGER_EVENT(dacInitStruct->m_TriggerEvent));
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(dacInitStruct->m_TriggerDMAEnable));
    CHECK_RESTRICTION(CHECK_DAC_WAVE(dacInitStruct->m_Wave));
    CHECK_RESTRICTION(CHECK_DAC_MAS(dacInitStruct->m_Mas));
    CHECK_RESTRICTION(CHECK_DAC_CLK(dacInitStruct->m_Clock));
    CHECK_RESTRICTION(CHECK_DAC_CLK_DIV(dacInitStruct->m_ClockDiv));
    CHECK_RESTRICTION(CHECK_DAC_RFS(dacInitStruct->m_ReferenceVoltage));
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(dacInitStruct->m_OutputBuffer));
    CHECK_RESTRICTION(CHECK_DAC_OUTPUT_PIN(dacInitStruct->m_OutputPin));
    CHECK_RESTRICTION(CHECK_DAC_OUTPUT(dacInitStruct->m_Output));

    /*---------------------------- DACx_CTLĴ  -----------------*/
    /* ݽṹԱm_TriggerEnableTRIGENλ */
    /* ݽṹԱm_TriggerEventTREVTλ */
    /* ݽṹԱm_TriggerDMAEnableDEλ */
    /* ݽṹԱm_WaveWAVEλ */
    /* ݽṹԱm_MasMASλ */
    tmpreg = ((dacInitStruct->m_TriggerEnable << DAC_CTL_TRIGEN_POS) | \
              (dacInitStruct->m_TriggerEvent) | \
              (dacInitStruct->m_TriggerDMAEnable << DAC_CTL_DE_POS) | \
              (dacInitStruct->m_Wave) | \
              (dacInitStruct->m_Mas));
    DACx->CTL = SFR_Config (DACx->CTL, ~DAC_CTL_INIT_MASK, tmpreg);

    /*---------------------------- DACx_CTL1Ĵ -----------------*/
    /* ݽṹԱm_ClockDivCLKDIVλ */
    /* ݽṹԱm_ClockCLKλ */
    /* ݽṹԱm_ReferenceVoltageRFSλ */
    /* ݽṹԱm_OutputBufferBUFENλ */
    /* ݽṹԱm_OutputPinSELλ */
    tmpreg = (dacInitStruct->m_ClockDiv)\
    	   | (dacInitStruct->m_Clock) \
           | (dacInitStruct->m_ReferenceVoltage) \
           | (dacInitStruct->m_OutputBuffer << DAC_CTL1_BUFEN_POS) \
           | (dacInitStruct->m_OutputPin);
    DACx->CTL1 = SFR_Config (DACx->CTL1, ~DAC_CTL1_INIT_MASK, tmpreg);

    /*---------------------------- DACx_DAHDĴ -----------------*/
    /* ݽṹԱm_OutputDAHDλ */
    tmpreg = dacInitStruct->m_Output;
    DACx->DAHD = SFR_Config (DACx->DAHD, ~DAC_DAHD_DAHD, tmpreg);
}

/**
  *   ʼDACϢṹ塣
  *   dacInitStruct: ָʼĽṹָ롣
  *   ޡ
  */
void
DAC_Struct_Init (DAC_InitTypeDef* dacInitStruct)
{
    /* ʼ DACͨʹ */
    dacInitStruct->m_TriggerEnable = FALSE;
    /* ʼ DACͨ¼ */
    dacInitStruct->m_TriggerEvent = DAC_TRIGGER_T1_TRGO;
    /* ʼ DACDMAʹ */
    dacInitStruct->m_TriggerDMAEnable = FALSE;
    /* ʼ DACηʹ */
    dacInitStruct->m_Wave = DAC_WAVE_NONE;
    /* ʼ DAC/ֵѡ */
    dacInitStruct->m_Mas = DAC_LFSR_UNMASK_BITS0_0;
    /* ʼ DACʱ */
    dacInitStruct->m_Clock = DAC_CLK_SCLK;
    /* ʼ DACʱӷƵ */
    dacInitStruct->m_ClockDiv = DAC_CLK_DIV_1;
    /* ʼ DACοѹѡ */
    dacInitStruct->m_ReferenceVoltage = DAC_RFS_AVDD;
    /* ʼ DACʹ */
    dacInitStruct->m_OutputBuffer = FALSE;
    /* ʼ DAC */
    dacInitStruct->m_OutputPin = DAC_OUTPUT_PIN_0;
    /* ʼ DAC */
    dacInitStruct->m_Output = 0;
}

/**
  *   DACʹλ
  *   DACx: ָDACڴṹָ룬ȡֵΪDAC0_SFRDAC1_SFR
  *       NewState: DACʹλϢ
  *                 ȡֵΪ TRUE  FALSE
  *   ޡ
  */
void
DAC_Cmd (DAC_SFRmap* DACx, FunctionalState NewState)
{
    /* У */
    CHECK_RESTRICTION(CHECK_DAC_ALL_PERIPH(DACx));
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

    if (NewState != FALSE)
    {
        /* ʹDAC */
        SFR_SET_BIT_ASM(DACx->CTL, DAC_CTL_EN_POS);
    }
    else
    {
        /* ֹDAC */
        SFR_CLR_BIT_ASM(DACx->CTL, DAC_CTL_EN_POS);
    }
}

/**
  *   DACʹλ
  *   DACx: ָDACڴṹָ룬ȡֵΪDAC0_SFRDAC1_SFR
  *       NewState: DACʹλϢ
  *                 ȡֵΪ TRUE  FALSE
  *   ޡ
  */
void
DAC_Software_Trigger_Cmd (DAC_SFRmap* DACx, FunctionalState NewState)
{
    /* У */
    CHECK_RESTRICTION(CHECK_DAC_ALL_PERIPH(DACx));
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

    if (NewState != FALSE)
    {
        /* ʹDAC */
        SFR_SET_BIT_ASM(DACx->CTL, DAC_CTL_SWTRIG_POS);
    }
    else
    {
        /* ֹDAC */
        SFR_CLR_BIT_ASM(DACx->CTL, DAC_CTL_SWTRIG_POS);
    }
}

/**
  *   DACͨDMAģʽʹܡ
  *   DACx: ָDACڴṹָ룬ȡֵΪDAC0_SFRDAC1_SFR
  *       NewState: DACʹλϢ
  *                 ȡֵΪ TRUE  FALSE
  *   ޡ
  */
void
DAC_DMA_Cmd (DAC_SFRmap* DACx, FunctionalState NewState)
{
    /* У */
    CHECK_RESTRICTION(CHECK_DAC_ALL_PERIPH(DACx));
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

    if (NewState != FALSE)
    {
        /* ʹDACͨDMAģʽ */
        SFR_SET_BIT_ASM(DACx->CTL, DAC_CTL_DE_POS);
    }
    else
    {
        /* ֹDACͨDMAģʽ */
        SFR_CLR_BIT_ASM(DACx->CTL, DAC_CTL_DE_POS);
    }
}

/**
  *   DACʹܡ
  *   DACx: ָDACڴṹָ룬ȡֵΪDAC0_SFRDAC1_SFR
  *       NewState: DACʹλϢ
  *                 ȡֵΪ TRUE  FALSEֱʾ򲻴塣
  *   ޡ
  */
void
DAC_Output_Buffer_Config (DAC_SFRmap* DACx, FunctionalState NewState)
{
    /* У */
    CHECK_RESTRICTION(CHECK_DAC_ALL_PERIPH(DACx));
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

    if (NewState != FALSE)
    {
        /* ʹDAC */
        SFR_SET_BIT_ASM(DACx->CTL1, DAC_CTL1_BUFEN_POS);
    }
    else
    {
        /* ֹDAC */
        SFR_CLR_BIT_ASM(DACx->CTL1, DAC_CTL1_BUFEN_POS);
    }
}

/**
  *   DACIOѡ
  *   DACx: ָDACڴṹָ룬ȡֵΪDAC0_SFRDAC1_SFR
  *       NewState: DACʹλϢ
  *                 ȡֵΪ TRUE  FALSEֱʾIO1IO0
  *   ޡ
  */
void
DAC_Output_Port_Config (DAC_SFRmap* DACx, FunctionalState NewState)
{
    /* У */
    CHECK_RESTRICTION(CHECK_DAC_ALL_PERIPH(DACx));
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

    if (NewState != FALSE)
    {
        /* DACIO1 */
        SFR_SET_BIT_ASM(DACx->CTL1, DAC_CTL1_SEL_POS);
    }
    else
    {
        /* DACIO0 */
        SFR_CLR_BIT_ASM(DACx->CTL1, DAC_CTL1_SEL_POS);
    }
}

/**
  *   ##### ʼú #####
  */



/**
  *   ##### ݶд #####
  */
/**
  *   дDACݣֻдDACx_DAHDĴ
  *   DACx: ָDACڴṹָ룬ȡֵΪDAC0_SFRDAC1_SFR
  *       Value: дݼĴֵ
  *              ȡֵΪ12λݡ
  *   ޡ
  */
void
DAC_Write_Output_Data (DAC_SFRmap* DACx, uint32_t Value)
{
    /* У */
    CHECK_RESTRICTION(CHECK_DAC_ALL_PERIPH(DACx));
    CHECK_RESTRICTION(CHECK_DAC_OUTPUT(Value));

    DACx->DAHD = Value;
}

/**
  *   DACݡ
  *   DACx: ָDACڴṹָ룬ȡֵΪDAC0_SFRDAC1_SFR
  *   32λݵ12λݡ
  */
uint32_t
DAC_Read_Output_Data (DAC_SFRmap* DACx)
{
    /* У */
    CHECK_RESTRICTION(CHECK_DAC_ALL_PERIPH(DACx));

    return (DAC_DAHD_DAHD & DACx->DATA);
}

/**
  *   ##### ݶд #####
  */



/**
  *   ##### DACУĴú #####
  */
/**
  *   DACУĴú
  *   DACx: ָDACڴṹָ룬ȡֵΪDAC0_SFRDAC1_SFR
  *       dacCalStruct: DACУĴϢ
  *   32λݵ12λݡ
  */
void
DAC_Calibration_Config (DAC_SFRmap* DACx, DAC_CALTypeDef* dacCalStruct)
{
    uint32_t tmpreg = 0;

    /* У */
    CHECK_RESTRICTION(CHECK_DAC_ALL_PERIPH(DACx));
    CHECK_RESTRICTION(CHECK_DAC_CAL(dacCalStruct->m_PPositrim));
    CHECK_RESTRICTION(CHECK_DAC_CAL(dacCalStruct->m_PNegatrim));
    CHECK_RESTRICTION(CHECK_DAC_CAL(dacCalStruct->m_NPositrim));
    CHECK_RESTRICTION(CHECK_DAC_CAL(dacCalStruct->m_NNegatrim));
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(dacCalStruct->m_Buftrim));

    /*---------------------------- DACx_CALĴ  -----------------*/
    /* ݽṹԱm_PPositrimPPOSITRIMλ */
    /* ݽṹԱm_PNegatrimPNEGATRIMλ */
    /* ݽṹԱm_NPositrimNPOSITRIMλ */
    /* ݽṹԱm_NNegatrimNNEGATRIMλ */
    tmpreg = (dacCalStruct->m_PPositrim << DAC_CAL_PPOSITRIM0_POS) | \
             (dacCalStruct->m_PNegatrim << DAC_CAL_PNEGATRIM0_POS) | \
             (dacCalStruct->m_NPositrim << DAC_CAL_NPOSITRIM0_POS) | \
             (dacCalStruct->m_NNegatrim << DAC_CAL_NNEGATRIM0_POS) | \
             (dacCalStruct->m_Buftrim << DAC_CAL_BUFTRIM_POS);
    DACx->CAL = SFR_Config (DACx->CAL, ~DAC_CAL_INIT_MASK, tmpreg);
}

/**
  *   ʼDACϢṹ塣
  *   dacCalStruct: ָʼĽṹָ롣
  *   ޡ
  */
void
DAC_Calibration_Struct_Init (DAC_CALTypeDef* dacCalStruct)
{
    /* ʼ DACģBUFFERPʧУ׼λ */
    dacCalStruct->m_PPositrim = DAC_CAL_0;
    /* ʼ DACģBUFFERPܸʧУ׼λ */
    dacCalStruct->m_PNegatrim = DAC_CAL_0;
    /* ʼ DACģBUFFERNʧУ׼λ */
    dacCalStruct->m_NPositrim = DAC_CAL_0;
    /* ʼ DACģBUFFERNܸʧУ׼λ */
    dacCalStruct->m_NNegatrim = DAC_CAL_0;
    /* ʼ DACģBUFFERʧУ׼ʹλ */
    dacCalStruct->m_Buftrim = FALSE;
}

/**
  *   ##### DACУĴú #####
  */
