/**
  ******************************************************************************
  * ļ  main.c
  *     ChipON_AE/FAE_Group
  *     V2.6.2
  *     2021-06-07
  *     ļṩKF32A152MQVRT-ThraedСʾ
  *
  *********************************************************************
  */
#include "system_init.h"
#include "Usart.h"
#include "rtthread.h"

/* define uart send buffer. */
uint8_t SendDataBuffer[] = "helloworld\r\n";

/* define thread control module. */
static rt_err_t result;
static struct rt_thread led_thread;
static struct rt_thread uart_thread;

/* define led thread stack. */
static rt_uint8_t rt_led_thread_stack[256];
/* define uart thread stack. */
static rt_uint8_t rt_uart_thread_stack[256];


/* create a led thread. */
static void led_thread_entry(void* paremeter)
{
	/* EVB LED config */
	GPIO_Write_Mode_Bits(GPIOB_SFR, GPIO_PIN_MASK_13, GPIO_MODE_OUT);
	while (1)
	{
		GPIO_Toggle_Output_Data_Config(GPIOB_SFR, GPIO_PIN_MASK_13);
		rt_thread_delay(500);
	}
}

/* create a uart thread */
static void uart_thread_entry(void* paremeter)
{
	/* Init & configure UART2 in 115200 at PB14-TX PB15-RX */
	GPIO_USART2();
	USART_Async_config(USART2_SFR);
	while(1)
	{
		USART_Send(USART2_SFR, SendDataBuffer, sizeof(SendDataBuffer));
		rt_thread_delay(300);
	}
}


/**
  *    
  *    
  *    
  */
void main()
{
	result = rt_thread_init(&led_thread,
								"LED1",
								led_thread_entry,
								RT_NULL,
								&rt_led_thread_stack[0],
								sizeof(rt_led_thread_stack),
								2 ,
								30);
	if(result != RT_ERROR)
		rt_thread_startup(&led_thread);

	result = rt_thread_init(&uart_thread,
									"UART2",
									uart_thread_entry,
									RT_NULL,
									&rt_uart_thread_stack[0],
									sizeof(rt_uart_thread_stack),
									1 ,
									30);
	if(result != RT_ERROR)
		rt_thread_startup(&uart_thread);
}

