#ifndef __GNUC__
#define __GNUC__
#endif

#include "system_init.h"
#include <rtthread.h>

extern unsigned char __text_end__;
extern unsigned char __bss_start__;
extern unsigned char __bss_end__;
extern unsigned char __data_start__;
extern void entry();

void startup()
{
	unsigned int *s,*begin,*end;
#ifdef  Project_Type__cplusplus
	void (*pf)(void);
#endif
//############# 		init work for the chip 		    #############//
	*((volatile unsigned int *) 0x40000000) = 0;
//############# init variable who have initialization	#############//
	s = (unsigned int*)&__text_end__;
	begin = (unsigned int*)&__data_start__;
	end = (unsigned int*)&__bss_start__;
	while(begin < end)
		*begin++ = *s++;
//############# init class who have initialization(C++)	#############//
#ifdef Project_Type__cplusplus
	begin = (unsigned int*)&__init_class_start;
	end = (unsigned int*)&__init_class_end;
	while(begin<end)
	{
		pf=(void *)(*begin++);
		pf();
	}
#endif
//############# init variable who have no initialization	#############//
#if 1	 //  0 not init this type variable
	begin = (unsigned int*)&__bss_start__;
	end = (unsigned int*)&__bss_end__;
	while(begin < end)
		*begin++ = 0;
#endif
//############# begin to run main function	#############//
	SystemInit();
	entry();
}
#if 0
void startup()
{
	*((volatile unsigned int *) 0x40000000) = 0;
	unsigned char length;
	unsigned int *s,*begin,*end;
	s = (unsigned int*)&__text_end__;
	begin = (unsigned int*)&__data_start__;
	end = (unsigned int*)&__bss_start__;
	while(begin < end)
		*begin++ = *s++;
	
	begin = (unsigned int*)&__bss_start__;
	end = (unsigned int*)&__bss_end__;
	while(begin < end)
		*begin++ = 0;
	SystemInit();
	entry();
} 
#endif
