/****************************************************************************************
  *
  * ļ  main.c
  *     ChipON_AE/FAE_Group
  *     2019-11-16
  *     ļṩʵִڿŹӦòο̡
  *
 ****************************************************************************************/
#include "system_init.h"

uint32_t WWDGCNT_DATA = 0;

#define WWDT_Threshold      0x1F      //趨ֵȡֵΧ 0~0x3F
#define WWDT_Enable_INT       0       //ǷʹWWDGж   ȡֵΧ 01

#define    UserKEY    GPIO_Read_Input_Data_Bit(GPIOH_SFR,GPIO_PIN_MASK_14)  //ȡPH14ƽ

//ʱ ֲvolatileܻᱻŻ
//Ƶʱ48M 1msʱ
void delay_ms(volatile uint32_t nms)
{
	volatile uint32_t i,j;
	for(i=0;i<nms;i++)
	{
		j=2000;
		while(j--);
	}

}

/**
  *   GPIOx ʼá
  *  : GPIOx: ָGPIOڴṹָ룬ȡֵΪGPIOA_SFR~GPIOH_SFR
  *       GpioPin: ˿룬ȡֵΪGPIO_PIN_MASK_0~GPIO_PIN_MASK_15еһϡ
  *   ޡ
  */
void GPIOInit_Output_Config(GPIO_SFRmap* GPIOx,uint16_t GpioPin)
{
	/*ʼλGPIOx裬ʹGPIOxʱ*/
		GPIO_Reset(GPIOx);

	/*  PxyΪģʽ */
	GPIO_InitTypeDef GPIO_InitStructure;
	GPIO_Struct_Init(&GPIO_InitStructure);
	GPIO_InitStructure.m_Pin = GpioPin;
	GPIO_InitStructure.m_Speed = GPIO_LOW_SPEED;          //ʼ GPIOٶ
	GPIO_InitStructure.m_Mode = GPIO_MODE_OUT;            //ʼ GPIOΪ
	GPIO_InitStructure.m_PullUp = GPIO_NOPULL;            //ʼ GPIOǷ
	GPIO_InitStructure.m_PullDown = GPIO_NOPULL;          //ʼ GPIOǷ
	GPIO_Configuration(GPIOx,&GPIO_InitStructure);

	GPIO_Set_Output_Data_Bits(GPIOx,GpioPin,Bit_SET);	  //Ϊߵƽ

}

/**
  *   GPIOx ʼá
  *  : GPIOx: ָGPIOڴṹָ룬ȡֵΪGPIOA_SFR~GPIOH_SFR
  *       GpioPin: ˿룬ȡֵΪGPIO_PIN_MASK_0~GPIO_PIN_MASK_15еһϡ
  *   ޡ
  */
void GPIOInit_Input_Config(GPIO_SFRmap* GPIOx,uint16_t GpioPin)
{
	/*ʼλGPIOx裬ʹGPIOxʱ*/
		GPIO_Reset(GPIOx);

	/*  PxyΪģʽ */
	GPIO_InitTypeDef GPIO_InitStructure;
	GPIO_Struct_Init(&GPIO_InitStructure);
	GPIO_InitStructure.m_Pin = GpioPin;
	GPIO_InitStructure.m_Speed = GPIO_LOW_SPEED;                   //ʼ GPIOٶ
	GPIO_InitStructure.m_Mode = GPIO_MODE_IN;                      //ʼ GPIOΪ
	GPIO_InitStructure.m_PullUp = GPIO_NOPULL;                     //ʼ GPIOǷ 
	GPIO_InitStructure.m_PullDown = GPIO_PULLUP;                   //ʼ GPIOǷ
	GPIO_Configuration(GPIOx,&GPIO_InitStructure);
}




/**
  *   ڿŹʹôֵá
  *  : ThresholdôڿŹɲֵȡֵΪ0~0x3F
  *
  * ԤƵСΪ64262144Ƶ
  *   ޡ
  */
void WWDT_Config_TH(uint32_t Threshold)
{

	WWDT_Reset();                                  //λڿŹʹܴڿŹʱ
	WWDT_Threshold_Config(Threshold);              //ôڿŹɲֵ
	WWDT_Prescaler_Config(WWDT_PRESCALER_64);      //ԤƵ16432KHZʱԴƵΪ500HZ,2msһε40Hжϣ128msһж
	WWDT_Enable (TRUE);
#if WWDT_Enable_INT
	WWDT_INT_Enable(TRUE);                            //ʹWWDTж
    INT_Interrupt_Enable(INT_WWDT,TRUE);			  //WWDTж
	INT_All_Enable (TRUE);
#endif
}


/**
  *   趨ֵֵǰĴȥι㡣
  *  : 
  *
  *   ޡ
  */
void WWDT_Clear(void)
{
	WWDGCNT_DATA =WWDT_Get_Counter();
	if((WWDGCNT_DATA>WWDT_Threshold)&&(WWDGCNT_DATA<0x3F))
	{
		WWDT_Counter_Config(0);                    //Ĵ
	}
}




//
void main()
{
	/*ûɲοKF32LS200_demoʵʹôڿŹܡ
	 * дڿŹʱԴΪڲ32KHZ ԤƵ164ƵΪ500HZ,
	 * WWDT_Enable_INTǷʹܴڿŹжϺ궨壬1Ϊʹܣ0Ϊֹ
	 * 1ʹܴڿŹж2msһε40Hжϣ128msһжϣҪжι
	 * 2ûʹܴڿŹжʱ趨WT<6:0>ĴֵWWDT_ThresholdڴڿŹֵ 0~WWDT_ThresholdΧι
	 * Լ41HʱιϵͳḴλ
	 * DEMO幦ûUSRKEYʱϵͳ128msλһSTATUS˸USER KEYϵͳSTATUSƳ
	 *
     */

	//ϵͳʱ48M,Ƶʱ16M
	SystemInit(); //ϵͳʱӳʼ

	GPIOInit_Input_Config(GPIOH_SFR,GPIO_PIN_MASK_14);//PH14Ϊģʽ
	GPIOInit_Output_Config(GPIOF_SFR,GPIO_PIN_MASK_0);//PF0ΪΪߵƽ

	//趨WWDGĿɲֵ
	WWDT_Config_TH(WWDT_Threshold);  //趨ֵ0x1F
	while(1)
    {
#if WWDT_Enable_INT
		delay_ms(100);
#else
		delay_ms(100);
		if(UserKEY)
		{
			WWDT_Clear();//ºιϵͳûιϵͳλ
		}
#endif

    }

}



/**
  *    У鷢ļ
  *    file: ָļƵָ
  *      line У
  *   ޡ
  */
void check_failed(uint8_t* file, uint32_t line)
{
	  /* ûԼĴʵֱļк,
	             : printf("Wrong parameters value: file %s on line %d\r\n", file, line) */

	  while(1)
	  {
		  ;
	  }
}

