/****************************************************************************************
  *
  * ļ  main.c
  *     ChipON_AE/FAE_Group
  *     2019-11-16
  *     ļṩʵͨöʱDMAòο̡
  *
 ****************************************************************************************/
#include "system_init.h"

//ʹܴDMA궨
#define   Software_TRIGGER     0       //1ʹܴ    0ʱ


//ڴָ붨
uint32_t *u32_POINT_PAD;
uint32_t *u32_POINT_MAD;


//DMAʹñ
DMA_SFRmap * DMA_CHOOSE;

//ַ
#define   Peripheraladdress  0x40000210    //ָһַ
//ڴַ
#define   Memoryaddress      0X10010000    //ָһڴַ



//ʱ  ֲvolatileܻᱻŻ
void delay_ms(volatile uint32_t nms)
{
	volatile uint32_t i,j;
	for(i=0;i<nms;i++)
	{
		j=2000;
		while(j--);
	}

}






/**
  *   GPIOx ʼá
  *  : GPIOx: ָGPIOڴṹָ룬ȡֵΪGPIOA_SFR~GPIOH_SFR
  *       GpioPin: ˿룬ȡֵΪGPIO_PIN_MASK_0~GPIO_PIN_MASK_15еһϡ
  *   ޡ
  */
void GPIOInit_Output_Config(GPIO_SFRmap* GPIOx,uint16_t GpioPin)
{
		/*ʼλGPIOx裬ʹGPIOxʱ*/
			GPIO_Reset(GPIOx);

		/*  PxyΪģʽ */
		GPIO_InitTypeDef GPIO_InitStructure;
		GPIO_Struct_Init(&GPIO_InitStructure);
		GPIO_InitStructure.m_Pin = GpioPin;
		GPIO_InitStructure.m_Speed = GPIO_LOW_SPEED;          //ʼ GPIOٶ
		GPIO_InitStructure.m_Mode = GPIO_MODE_OUT;            //ʼ GPIOΪ
		GPIO_InitStructure.m_PullUp = GPIO_NOPULL;            //ʼ GPIOǷ
		GPIO_InitStructure.m_PullDown = GPIO_NOPULL;          //ʼ GPIOǷ
		GPIO_Configuration(GPIOx,&GPIO_InitStructure);

		GPIO_Set_Output_Data_Bits(GPIOx,GpioPin,Bit_SET);	  //Ϊߵƽ
}


/**
  *  DMA ʼͨѡá
  *  : DMA_CHOOSE: ָDMAڴṹָ룬ȡֵΪDMA0_SFRDMA1_SFR
  *          Channel: DMAͨѡȡֵΧΪ:
  *                   DMA_CHANNEL_1: ͨ1
  *                   DMA_CHANNEL_2: ͨ2
  *                   DMA_CHANNEL_3: ͨ3
  *                   DMA_CHANNEL_4: ͨ4
  *                   DMA_CHANNEL_5: ͨ5
  *                   DMA_CHANNEL_6: ͨ6
  *                   DMA_CHANNEL_7: ͨ7
  *   ޡ
  */
void DMA_init(DMA_SFRmap * DMA_CHOOSE,uint8_t Channel)
{
	*(uint32_t *)Peripheraladdress =0x00005555;    //ǰʼһ

	/* DMAλDMAʱ */
	DMA_Reset (DMA_CHOOSE);///
	DMA_InitTypeDef dmaNewStruct;

	/* DMAܲ */
	{

		/*  ݸ: 65535 */
		dmaNewStruct.m_Number = 65535;
		/*  DMA䷽赽ڴ */
		dmaNewStruct.m_Direction = DMA_PERIPHERAL_TO_MEMORY;//DMA_MEMORY_TO_PERIPHERAL;//
		/*  DMAͨȼȼ */
		dmaNewStruct.m_Priority = DMA_CHANNEL_LOWER;
		/*  λ32λ */
		dmaNewStruct.m_PeripheralDataSize = DMA_DATA_WIDTH_32_BITS;
		/*  洢λ:32λ */
		dmaNewStruct.m_MemoryDataSize = DMA_DATA_WIDTH_32_BITS;
		/*  ַģʽʹ: ʹ */
		dmaNewStruct.m_PeripheralInc = FALSE;
		/*  洢ַģʽʹ: ʹ */
		dmaNewStruct.m_MemoryInc = FALSE;
		/*  DMAͨѡ:ͨ */
		dmaNewStruct.m_Channel = Channel;
		/*  ݿ鴫ģʽ */
		dmaNewStruct.m_BlockMode = DMA_TRANSFER_BLOCK;
		/*  ѭģʽʹ: ֹ */
		dmaNewStruct.m_LoopMode = FALSE;//FALSE
		/*  ʼַȴ͵ݵʼַ */
		dmaNewStruct.m_PeriphAddr = Peripheraladdress ;         //ַ
		/*  ڴʼַݵڴռʼַ */
		dmaNewStruct.m_MemoryAddr = Memoryaddress;
		/* DMAܺ */
		DMA_Configuration (DMA_CHOOSE, &dmaNewStruct);
	}

	   /*DMAжϱ־λ*/
		DMA_Clear_INT_Flag (DMA_CHOOSE, dmaNewStruct.m_Channel, DMA_INT_FINISH_TRANSFER);

		/* ʹDMAͨ   */
		DMA_Channel_Enable(DMA_CHOOSE,dmaNewStruct.m_Channel,TRUE);
}


/**
  *  ʱӶģʽ ʼá
  *  : Timer_Trigger:  ȡֵT0_SFR/T1_SFR/T2_SFR/T3_SFR/T4_SFR/T18_SFR/
  *               T19_SFR/T20_SFR/T21_SFR/T19_SFR/T22_SFR/T23_SFR
  *      Timer_DMAӶ: ȡֵT0_SFR/T1_SFR/T2_SFR/T3_SFR/T4_SFR/T18_SFR/
  *               T19_SFR/T20_SFR/T21_SFR/T19_SFR/T22_SFR/T23_SFR
  *   ޡ
  * עӶʱѡĴԴ
  */
void DMA_TRIGGER_Timer(GPTIM_SFRmap* Timer_Trigger,GPTIM_SFRmap* Timer_DMA)
{
	//************Timer_TriggerTimer_DMAʱ Timer_DMADMA CH2ͨ************************//////////////////
	//Ƶ48MʱT2 24Ƶ0.5usִмһΣ20001msһж
	//------------------------ʱ Timer_Trigger-----------------------------//
	        TIM_Reset(Timer_Trigger);											//ʱ踴λʹʱ
			GPTIM_Updata_Immediately_Config(Timer_Trigger,TRUE);				//¿ʹ
			GPTIM_Updata_Enable(Timer_Trigger,TRUE);							//øʹ
			GPTIM_Master_Mode_Config(Timer_Trigger,GPTIM_MASTER_TXIF_SIGNAL);	//ģʽ
			GPTIM_Master_Slave_Snyc_Config(Timer_Trigger,TRUE);					//ͬ
			GPTIM_Work_Mode_Config(Timer_Trigger,GPTIM_TIMER_MODE);				//ʱģʽѡ
			GPTIM_Set_Counter(Timer_Trigger,0);									//ʱֵ
			GPTIM_Set_Period(Timer_Trigger,2000);							    //ʱֵ
			GPTIM_Set_Prescaler(Timer_Trigger,23);							    //ʱԤƵֵ
			GPTIM_Counter_Mode_Config(Timer_Trigger,GPTIM_COUNT_UP_DOWN_OUF);   //-¼,жϱ־
			GPTIM_Clock_Config(Timer_Trigger,GPTIM_SCLK);						//ѡSCLKʱ
			GPTIM_Cmd(Timer_Trigger,TRUE);										//ʱʹ


			//------------------------ӶDMAʱ Timer_DMA-----------------------------//
			TIM_Reset(Timer_DMA);												//ʱ踴λʹʱ
			GPTIM_Updata_Immediately_Config(Timer_DMA,TRUE);					//¿
			GPTIM_Updata_Enable(Timer_DMA,TRUE);								//øʹ
			GPTIM_Work_Mode_Config(Timer_DMA,GPTIM_TIMER_MODE);					//ʱģʽѡ

			GPTIM_Trigger_Select_Config(Timer_DMA,GPTIM_TRIGGER_T2);			//ԴѡT2
			GPTIM_Slave_Mode_Config(Timer_DMA,GPTIM_SLAVE_TRIGGER_MODE);		//ѡ񴥷ģʽ
			GPTIM_Master_Slave_Snyc_Config(Timer_DMA,TRUE);						//ͬ

			GPTIM_Set_Counter(Timer_DMA,0);										//ʱֵ
			GPTIM_Set_Period(Timer_DMA,0X7FFF);									//ʱֵ0X7FFF
			GPTIM_Set_Prescaler(Timer_DMA,47);									//ʱԤƵֵ
			GPTIM_Counter_Mode_Config(Timer_DMA,GPTIM_COUNT_UP_OF);			    //ϼ,жϱ־
			GPTIM_Clock_Config(Timer_DMA,GPTIM_SCLK);							//ѡSCLKʱ

			GPTIM_Cmd(Timer_DMA,TRUE);											//ʱʹ
			GPTIM_Trigger_DMA_Enable(Timer_DMA,TRUE);                           //ʹܴDMA

}


/**
  *  ֱӴʱDMAܡ
  *  : Timer_DMA:  ȡֵT0_SFR/T1_SFR/T2_SFR/T3_SFR/T4_SFR.
  *
  *   ޡ
  * עӶʱѡģʽ
  */
void DMA_TRIGGER_Software(GPTIM_SFRmap* Timer_DMA)
{
	//////////////************************ʹܶʱDMA************************************8/////////////

	TIM_Reset(Timer_DMA);											//ʱ踴λʹʱ
	GPTIM_Updata_Immediately_Config(Timer_DMA,TRUE);				//¿
	GPTIM_Updata_Enable(Timer_DMA,TRUE);							//øʹ
	GPTIM_Work_Mode_Config(Timer_DMA,GPTIM_TIMER_MODE);				//ʱģʽѡ
	GPTIM_Set_Counter(Timer_DMA,0);									//ʱֵ
	GPTIM_Set_Period(Timer_DMA,0xFFFF);							   //ʱֵ
	GPTIM_Set_Prescaler(Timer_DMA,0);				    		   //ʱԤƵֵ
	GPTIM_Counter_Mode_Config(Timer_DMA,GPTIM_COUNT_UP_DOWN_OUF);  //-¼,жϱ־
	GPTIM_Clock_Config(Timer_DMA,GPTIM_SCLK);					   //ѡSCLKʱ

	GPTIM_Trigger_DMA_Enable(Timer_DMA,TRUE);                      //ʹܴDMA
	GPTIM_Slave_Mode_Config(Timer_DMA,GPTIM_SLAVE_TRIGGER_MODE);   //ѡ񴥷ģʽ//ģʽģʽ
	GPTIM_Master_Slave_Snyc_Config(Timer_DMA,TRUE);				   //ͬ
	GPTIM_Cmd(Timer_DMA,TRUE);                                     //ʹܶʱ


	/* ʼDMA */
	GPTIM_Generate_Trigger_Config(Timer_DMA,TRUE);                 //TXTRGλ1 DMA
}

/**
  *  DMAǷɣҴǷƥ䡣
  *  : 
  *
  *   ޡ
  * עӶʱѡĴԴ
  */
void DMA_Finsh_Test(void)
{
	volatile uint32_t i, j;
	i = 0;
	j = 0;
	while (0 == DMA_Get_Finish_Transfer_INT_Flag(DMA0_SFR,DMA_CHANNEL_2))//ȴDMA
	{
		;
	}

	/*  ɺļ  */
	u32_POINT_PAD=(uint32_t *)Peripheraladdress;   //ַ
	u32_POINT_MAD=(uint32_t *)Memoryaddress;       //ڴַ


	while(i<30)
	{
		if(*u32_POINT_PAD==*u32_POINT_MAD)  //ڴַ,PF0ת
		{
			while(1)
			{
				GPIO_Toggle_Output_Data_Config(GPIOF_SFR,GPIO_PIN_MASK_0);//PF0
				delay_ms(200);
				delay_ms(200);
				delay_ms(200);
			}

		}
		else   ///ڴַݲ,PF1ת
		{
			while(1)
			{
				GPIO_Toggle_Output_Data_Config(GPIOF_SFR,GPIO_PIN_MASK_4);//PF4
				delay_ms(200);
			}
		}
		i++;
		u32_POINT_PAD++;
		u32_POINT_MAD++;
		delay_ms(2);

	}
}



//
void main()
{
	/*ûɲοKF32LS200_demoʵͨöʱDMAá
	 * жʱT2ΪģʽʱT1T1DMA0 CH2ͨݣݺݶԱȲ
     *          궨 Software_TRIGGERΪ1ʱʹDMAҪʱT2
	 *
     */

	//ϵͳʱ48M,Ƶʱ16M
	SystemInit();//ϵͳʱӳʼ




	//ʼPF0PF4
	GPIOInit_Output_Config(GPIOF_SFR,GPIO_PIN_MASK_0|GPIO_PIN_MASK_4);
	//DMA0
	DMA_init(DMA0_SFR,DMA_CHANNEL_2);//ʼDMA0 ͨ2ڴַȲ
#if Software_TRIGGER
	DMA_TRIGGER_Software(T1_SFR);     //T1ʼѡ
#else
	DMA_TRIGGER_Timer(T2_SFR,T1_SFR); //T1ʼѡT2
#endif

	DMA_Finsh_Test();                 //DMAǷɣ봫ǰǷƥ
    while(1)
    {
    }

}



/**
  *    У鷢ļ
  *    file: ָļƵָ
  *      line У
  *   ޡ
  */
void check_failed(uint8_t* file, uint32_t line)
{
	  /* ûԼĴʵֱļк,
	             : printf("Wrong parameters value: file %s on line %d\r\n", file, line) */

	  while(1)
	  {
		  ;
	  }
}

