/****************************************************************************************
  *
  * ļ  main.c
  *     ChipON_AE/FAE_Group
  *     2019-11-16
  *     ļṩͨöʱӦ̲ο
  *
 ****************************************************************************************/
#include "system_init.h"



/**
  *   ͨöʱGPTIMx ʼá
  *   GPTIMx:ȡֵΪT0_SFR/T1_SFR/T2_SFR/T3_SFR/T4_SFR/ T18_SFR/T19_SFR/T20_SFR/T21_SFR/T22_SFR/T23_SFR
  *  PeripheralȡֵΪINT_T0/INT_T1/INT_T2/INT_T3/INT_T4/INT_T18/INT_T19/INT_T20/INT_T21/INT_T22/INT_T23
  *
  *   ޡ
  */
void GENERAL_TIMER_Tx_Config(GPTIM_SFRmap* GPTIMx,InterruptIndex Peripheral)
{
	//ʱʱԴѡʱ48Mʱ23+1=24Ƶ0.5usִмһΣ20001msһж

	TIM_Reset(GPTIMx);											//ʱ踴λʹʱ
	GPTIM_Updata_Immediately_Config(GPTIMx,TRUE);				//¿
	GPTIM_Updata_Enable(GPTIMx,TRUE);							//øʹ
	GPTIM_Work_Mode_Config(GPTIMx,GPTIM_TIMER_MODE);			//ʱģʽѡ
	GPTIM_Set_Counter(GPTIMx,0);								//ʱֵ
	GPTIM_Set_Period(GPTIMx,2000);								//ʱֵ
	GPTIM_Set_Prescaler(GPTIMx,23);				    	        //ʱԤƵֵ
	GPTIM_Counter_Mode_Config(GPTIMx,GPTIM_COUNT_UP_DOWN_OF);	//-¼,жϱ־
	GPTIM_Clock_Config(GPTIMx,GPTIM_SCLK);						//ѡSCLKʱ
	INT_Interrupt_Priority_Config(Peripheral,4,0);				//ռȼ4,ȼ0
	GPTIM_Overflow_INT_Enable(GPTIMx,TRUE);						//жʹ
	INT_Interrupt_Enable(Peripheral,TRUE);						//жʹ
	INT_Clear_Interrupt_Flag(Peripheral);						//жϱ־
	GPTIM_Cmd(GPTIMx,TRUE);										//ʱʹ

}




/**
  *   GPIOx ʼá
  *  : GPIOx: ָGPIOڴṹָ룬ȡֵΪGPIOA_SFR~GPIOH_SFR
  *       GpioPin: ˿룬ȡֵΪGPIO_PIN_MASK_0~GPIO_PIN_MASK_15еһϡ
  *   ޡ
  */
void GPIOInit_Output_Config(GPIO_SFRmap* GPIOx,uint16_t GpioPin)
{
		/*ʼλGPIOx裬ʹGPIOxʱ*/
			GPIO_Reset(GPIOx);

		/*  PxyΪģʽ */
		GPIO_InitTypeDef GPIO_InitStructure;
		GPIO_Struct_Init(&GPIO_InitStructure);
		GPIO_InitStructure.m_Pin = GpioPin;
		GPIO_InitStructure.m_Speed = GPIO_LOW_SPEED;          //ʼ GPIOٶ
		GPIO_InitStructure.m_Mode = GPIO_MODE_OUT;            //ʼ GPIOΪ
		GPIO_InitStructure.m_PullUp = GPIO_NOPULL;            //ʼ GPIOǷ
		GPIO_InitStructure.m_PullDown = GPIO_NOPULL;          //ʼ GPIOǷ
		GPIO_Configuration(GPIOx,&GPIO_InitStructure);

		GPIO_Set_Output_Data_Bits(GPIOx,GpioPin,Bit_SET);	  //Ϊߵƽ
}



//
void main()
{
	/*ûɲοKF32LS200_demoʵͨʱ
	 *ͨ  ʱT0 T1 T3 T4ʱʱSCLK Ϊ2000 ԤƵֵ23+1=24Ƶ
	 *          ʱT0 T1 T3 T4ʱԴΪ48MƵ ʱ10msһж
	 *
	 *
     */

	//ϵͳʱ48M,Ƶʱ16M
	SystemInit();//ϵͳʱӳʼ

	//ʼPF0
	GPIOInit_Output_Config(GPIOF_SFR,GPIO_PIN_MASK_0);

	//ʱT0
	GENERAL_TIMER_Tx_Config(T0_SFR,INT_T0);
	//ʱT1
	GENERAL_TIMER_Tx_Config(T1_SFR,INT_T1);

	//ʱT3
	GENERAL_TIMER_Tx_Config(T3_SFR,INT_T3);
	//ʱT4
	GENERAL_TIMER_Tx_Config(T4_SFR,INT_T4);
	//ж
	INT_Stack_Align_Config(INT_STACK_SINGLE_ALIGN);				//жԶջʹõֶ
	INT_All_Enable (TRUE);										//ȫֿжʹ,жʹܿƲλ/NMI/Ӳж

    while(1)
    {
    }

}



/**
  *    У鷢ļ
  *    file: ָļƵָ
  *      line У
  *   ޡ
  */
void check_failed(uint8_t* file, uint32_t line)
{
	  /* ûԼĴʵֱļк,
	             : printf("Wrong parameters value: file %s on line %d\r\n", file, line) */

	  while(1)
	  {
		  ;
	  }
}

