/**
  ******************************************************************************
  * ļ  QEI.c
  *     ChipON_AE/FAE_Group
  *     2019-10-19
  *     ļṩSPIFLASHعܣ
  *          + QEI
  *          + T0ãģ룩
  ******************************************************************************/
#include "system_init.h"
#include "QEI.h"

/**
  *     T0ãģ룩
  *    
  *    
  */
void QT0_Configuration()
{
	//öʱT0ʱΪʱģź
	//PE1_IOģAź
	GPIO_Pull_Up_Enable(GPIOE_SFR,GPIO_PIN_MASK_1,FALSE);
	GPIO_Write_Mode_Bits(GPIOE_SFR,GPIO_PIN_MASK_1,GPIO_MODE_OUT);
	GPIO_Speed_Config(GPIOE_SFR,GPIO_PIN_MASK_1, GPIO_LOW_SPEED);
	GPIO_Set_Output_Data_Bits(GPIOE_SFR,GPIO_PIN_MASK_1,Bit_RESET);
	//PE2_IOģBź
	GPIO_Pull_Up_Enable(GPIOE_SFR,GPIO_PIN_MASK_2,FALSE);
	GPIO_Write_Mode_Bits(GPIOE_SFR,GPIO_PIN_MASK_2,GPIO_MODE_OUT);
	GPIO_Speed_Config(GPIOE_SFR,GPIO_PIN_MASK_2,GPIO_LOW_SPEED);
	GPIO_Set_Output_Data_Bits(GPIOE_SFR,GPIO_PIN_MASK_2,Bit_RESET);

	//ʱT0Ϊʱģź
	TIM_Reset(T0_SFR);													//ʱ踴λʹʱ
	GPTIM_Updata_Enable(T0_SFR,TRUE);									//ڡԤƵĴ
	GPTIM_Work_Mode_Config(T0_SFR,GPTIM_TIMER_MODE);					//ʱģʽ

	GPTIM_Set_Counter(T0_SFR,0);										//ֵʼ=0
	GPTIM_Set_Period(T0_SFR,0xFFFF);								    //ʱ=0xFFFF
	GPTIM_Set_Prescaler(T0_SFR,0);										//ʱԤƵֵ

	GPTIM_Counter_Mode_Config(T0_SFR,GPTIM_COUNT_DOWN_UF);				//-¼,жϱ־
	GPTIM_Clock_Config(T0_SFR,GPTIM_SCLK);								//ѡƵʱ
	INT_Interrupt_Priority_Config(INT_T0,4,0);							//ռȼ4,ȼ0
	GPTIM_Overflow_INT_Enable(T0_SFR,TRUE);								//жʹ
	INT_Interrupt_Enable(INT_T0,TRUE);									//жʹ
	INT_Clear_Interrupt_Flag(INT_T0);									//жϱ־
	GPTIM_Cmd (T0_SFR, TRUE);
}


/**
  *     QEI
  *    QEIxָQEIڴṹָ룬ȡֵΪQEI0_SFRQEI1_SFR
  *    
  */
void QEI_Init_Configuration(QEI_SFRmap* QEIx)
{
	QEI_InitTypeDef qeiInitStruct;

    qeiInitStruct.m_IndexReset = FALSE; //λüλ:ֹ, QEI_INDEXλλü
    qeiInitStruct.m_DirectionEn = TRUE; //λü״̬:ʹ
    qeiInitStruct.m_WorkClock = QEI_SOURCE_SCLK;//QEIʱ:ϵͳʱ
    qeiInitStruct.m_DigitalFilterEn = TRUE;     //QEI˲:ʹ
    qeiInitStruct.m_DigitalFilterPrescaler = QEI_DIGITAL_FILTER_CLK_DIV_2;//QEI˲ʱ2Ƶ
    qeiInitStruct.m_SwapABEn = FALSE;    // AB뽻:ֹ
    qeiInitStruct.m_Counter = 0;         //ʱֵ=0
    qeiInitStruct.m_Period = 3;          //ʱֵ=0  Tx==PPxʱ´TxTx
    qeiInitStruct.m_Prescaler = 0;       //ʱԤƵ=0
    QEI_Reset(QEIx);                     //QEIλ
    QEI_Configuration(QEIx,&qeiInitStruct);//д
    QEI_Encoder_Mode_Config(QEIx,QEI_X2_MATCH_RESET);//x2ģʽƥ临λ

    QEI_Clear_Timer_Overflow_INT_Flag(QEIx); //T7־
    QEI_Timer_Overflow_INT_Enable(QEIx,TRUE);//T7жʹ
	INT_Interrupt_Enable(INT_T7,TRUE);       //T7жʹ
	INT_All_Enable (TRUE);                   //жʹ

}
