/****************************************************************************************
  *
  * ļ  main.c
  *     ChipON_AE/FAE_Group
  *     2019-11-16
  *     ļṩʵжȼӦòο̡
  *
 ****************************************************************************************/
#include "system_init.h"


/**
  *   GPIOx ʼá
  *  : GPIOx: ָGPIOڴṹָ룬ȡֵΪGPIOA_SFR~GPIOH_SFR
  *       GpioPin: ˿룬ȡֵΪGPIO_PIN_MASK_0~GPIO_PIN_MASK_15еһϡ
  *   ޡ
  */
void GPIOInit_Output_Config(GPIO_SFRmap* GPIOx,uint16_t GpioPin)
{
	/*ʼλGPIOx裬ʹGPIOxʱ*/
		GPIO_Reset(GPIOx);

	/*  PxyΪģʽ */
	GPIO_InitTypeDef GPIO_InitStructure;
	GPIO_Struct_Init(&GPIO_InitStructure);
	GPIO_InitStructure.m_Pin = GpioPin;
	GPIO_InitStructure.m_Speed = GPIO_LOW_SPEED;          //ʼ GPIOٶ
	GPIO_InitStructure.m_Mode = GPIO_MODE_OUT;            //ʼ GPIOΪ
	GPIO_InitStructure.m_PullUp = GPIO_NOPULL;            //ʼ GPIOǷ
	GPIO_InitStructure.m_PullDown = GPIO_NOPULL;          //ʼ GPIOǷ
	GPIO_Configuration(GPIOx,&GPIO_InitStructure);

	GPIO_Set_Output_Data_Bits(GPIOx,GpioPin,Bit_SET);	  //Ϊߵƽ

}

/**
  *   GPIOx ʼá
  *  : GPIOx: ָGPIOڴṹָ룬ȡֵΪGPIOA_SFR~GPIOH_SFR
  *       GpioPin: ˿룬ȡֵΪGPIO_PIN_MASK_0~GPIO_PIN_MASK_15еһϡ
  *   ޡ
  */
void GPIOInit_Input_Config(GPIO_SFRmap* GPIOx,uint16_t GpioPin)
{
	/*ʼλGPIOx裬ʹGPIOxʱ*/
		GPIO_Reset(GPIOx);

	/*  PxyΪģʽ */
	GPIO_InitTypeDef GPIO_InitStructure;
	GPIO_Struct_Init(&GPIO_InitStructure);
	GPIO_InitStructure.m_Pin = GpioPin;
	GPIO_InitStructure.m_Speed = GPIO_LOW_SPEED;                   //ʼ GPIOٶ
	GPIO_InitStructure.m_Mode = GPIO_MODE_IN;                      //ʼ GPIOΪ
	GPIO_InitStructure.m_PullUp = GPIO_NOPULL;                     //ʼ GPIOǷ 
	GPIO_InitStructure.m_PullDown = GPIO_NOPULL;                   //ʼ GPIOǷ 
	GPIO_Configuration(GPIOx,&GPIO_InitStructure);
}





/**
  *   ͨöʱGPTIMx ʼá
  *   GPTIMx:ȡֵΪT0_SFR/T1_SFR/T2_SFR/T3_SFR/T4_SFR/ T18_SFR/T19_SFR/T20_SFR/T21_SFR/T22_SFR/T23_SFR
  *  PeripheralȡֵΪINT_T0/INT_T1/INT_T2/INT_T3/INT_T4/INT_T18/INT_T19/INT_T20/INT_T21/INT_T22/INT_T23
  *
  *   ޡ
  */
void GENERAL_TIMER_Tx_Config(GPTIM_SFRmap* GPTIMx,InterruptIndex Peripheral)
{
    //ʱʱԴΪƵ48Mʱ24Ƶ0.5usִмһΣ400002msһж
	//ռȼ6,ȼ0
	TIM_Reset(GPTIMx);											//ʱ踴λʹʱ
	GPTIM_Updata_Immediately_Config(GPTIMx,TRUE);				//¿
	GPTIM_Updata_Enable(GPTIMx,TRUE);							//øʹ
	GPTIM_Work_Mode_Config(GPTIMx,GPTIM_TIMER_MODE);			//ʱģʽѡ
	GPTIM_Set_Counter(GPTIMx,0);								//ʱֵ
	GPTIM_Set_Period(GPTIMx,40000);								//ʱֵ
	GPTIM_Set_Prescaler(GPTIMx,23);				    			//ʱԤƵֵ
	GPTIM_Counter_Mode_Config(GPTIMx,GPTIM_COUNT_UP_DOWN_OUF);	//-¼,жϱ־
	GPTIM_Clock_Config(GPTIMx,GPTIM_SCLK);						//ѡSCLKʱ
	INT_Interrupt_Priority_Config(Peripheral,6,0);				//ռȼ6,ȼ0
	GPTIM_Overflow_INT_Enable(GPTIMx,TRUE);						//жʹ
	INT_Interrupt_Enable(Peripheral,TRUE);						//жʹ
	INT_Clear_Interrupt_Flag(Peripheral);						//жϱ־
	GPTIM_Cmd(GPTIMx,TRUE);										//ʱʹ

}



/**
  *   SysTickʱʼؼֵá
  *   ReloadϵͳĶʱؼֵȡֵΪ24λ
  *   ޡ
  */
void SysTick_Configuration(uint32_t Reload)
{

	//ĶʱȼΪ5ȼ0
	SYSTICK_Cmd (FALSE);                                //ȹؽĶʱ
	SYSTICK_Reload_Config(Reload);                      //ϵͳĶʱؼֵȡֵΪ24λ
	SYSTICK_Counter_Updata();                           //ST_CVĴдֵ㵱ǰֵĴ
	SYSTICK_Clock_Config(SYSTICK_SYS_CLOCK_DIV_2);      //ϵͳĶʱʱԴѡSCLK/2ΪʱԴ
	SYSTICK_Systick_INT_Enable(TRUE);                   //Ķʱжʹ
	SYSTICK_Cmd(TRUE);                                  //Ķʱʹ

	INT_Interrupt_Priority_Config(INT_SysTick,5,0);     //жSYSTICKռȼ5,ȼ0
    INT_Interrupt_Enable(INT_SysTick,TRUE);				//ʹжSYSTICK

}


/**
  *   ⲿжINT14ãռȼ4,ȼ0
  *   
  *   ޡ
  */
void EXIT_INT14_Config(void)
{
	EINT_InitTypeDef EXIT_InitStructure;
	INT_External_Struct_Init(&EXIT_InitStructure);
	EXIT_InitStructure.m_Line = INT_EXTERNAL_INTERRUPT_14;  //ⲿжϱ
	EXIT_InitStructure.m_Mask = TRUE;                      //ⲿжʹܿ
	EXIT_InitStructure.m_Rise = TRUE;                     //ⲿжжʹ
	EXIT_InitStructure.m_Fall = FALSE;                       //ⲿж½жʹ
	EXIT_InitStructure.m_Source = INT_EXTERNAL_SOURCE_PH;  //ⲿжϵжԴѡ
	INT_External_Configuration(&EXIT_InitStructure);
	INT_External_Source_Enable(INT_EXTERNAL_INTERRUPT_14,INT_EXTERNAL_SOURCE_PH);//PH14жEINT14жԴ
	INT_Interrupt_Priority_Config(INT_EINT15TO10,4,0);		   //ռȼ4,ȼ0
	INT_Interrupt_Enable(INT_EINT15TO10,TRUE);				   //ʹжEINT14

}


//
void main()
{

	/*ûɲοKF32LS200_demoʵʹжȼӦá
	 * ͨöʱT0жΪжȼĶʱжΪȼⲿжEINT14жȼ
	 * ڽĶʱͨöʱжʱPF0õͣһⲿжEINT15ϽⲿEINT14жӦá
	 * PF0øߣһUSEkey£ STATUSƾͳɿָ STATUSϨ
	 *
	 *ҪжżռȼȼĴСֵԽСȼԽߡ
	 *
	 */
	//ϵͳʱ48M,Ƶʱ16M
	SystemInit();//ϵͳʱӳʼ
	GPIOInit_Input_Config(GPIOH_SFR,GPIO_PIN_MASK_14);  //PH14Ϊģʽ
	GPIOInit_Output_Config(GPIOF_SFR,GPIO_PIN_MASK_0);  //PF0ΪΪߵƽ
	EXIT_INT14_Config();                                //ⲿжEINT14 ռȼ4,ȼ0
	SysTick_Configuration(3000000);                     //Ķʱ50mSһжϣ ռȼ5,ȼ0
	GENERAL_TIMER_Tx_Config(T0_SFR,INT_T0);             //ʱT0 2msһжϣռȼ6,ȼ0
	INT_Stack_Align_Config(INT_STACK_SINGLE_ALIGN);		//жԶջʹõֶ
	INT_All_Enable (TRUE);								//ȫֿжʹ,жʹܿƲλ/NMI/Ӳж

    while(1)
    {
    }

}



/**
  *    У鷢ļ
  *    file: ָļƵָ
  *      line У
  *   ޡ
  */
void check_failed(uint8_t* file, uint32_t line)
{
	  /* ûԼĴʵֱļк,
	             : printf("Wrong parameters value: file %s on line %d\r\n", file, line) */

	  while(1)
	  {
		  ;
	  }
}

