
#include "system_init.h"
#include "I2C_Master_Slave.h"

I2C_SFRmap* I2C_Choose;    //ָI2Cڴṹָ룬ȡֵΪI2C0_SFR~I2C3_SFR




/**
  *    I2C GPIOӳʼ
  *    
  *    
*/
void I2C_GPIO_init(void)
{
	/*I2Cx*/
	/**/
	GPIO_InitTypeDef I2C_GPIO_Init;
	GPIO_Reset(GPIOB_SFR);
	I2C_GPIO_Init.m_Mode = GPIO_MODE_RMP;                           //GPIOӳ书
	I2C_GPIO_Init.m_OpenDrain = GPIO_POD_OD;                        //GPIO©
	I2C_GPIO_Init.m_Pin = GPIO_PIN_MASK_1|GPIO_PIN_MASK_2;          //Px1 Px2
	I2C_GPIO_Init.m_PullUp = GPIO_PULLUP;                           //GPIO
	I2C_GPIO_Init.m_PullDown = GPIO_NOPULL;                         //ʹGPIO
	GPIO_Pin_RMP_Config(GPIOB_SFR,GPIO_Pin_Num_1,GPIO_RMP_AF8_I2C1); //PB1ΪI2C1 SCL
	GPIO_Pin_RMP_Config(GPIOB_SFR,GPIO_Pin_Num_2,GPIO_RMP_AF8_I2C1); //PB2ΪI2C1 SDA
	GPIO_Configuration(GPIOB_SFR,&I2C_GPIO_Init);

}


/**
  *    I2Cx ʼ
  *    I2CxȡֵΧI2C0_SFR~I2C3_SFR   ѡõI2C
  *      I2C_ADDRESS:ȡֵΧ0x0~0x3FF     ӻӦ7λַ10λַ
  *    
*/
void I2C_init_Slave(I2C_SFRmap* I2Cx,uint16_t I2C_ADDRESS)
{
	/*I2CxӦò*/
	I2C_Reset(I2Cx);
	I2C_InitTypeDef newStruct_I2C;                        //
	newStruct_I2C.m_Mode = I2C_MODE_I2C;                  //ΪI2Cģʽ
	newStruct_I2C.m_ClockSource = I2C_CLK_SCLK;           //ʱԴѡSCLK
#if	IIC_10BIT_Address
	newStruct_I2C.m_BADR10 = I2C_BUFRADDRESS_10BIT;       //10λӻַ
#else
	newStruct_I2C.m_BADR10 = I2C_BUFRADDRESS_7BIT;        //7λӻַ
#endif
	newStruct_I2C.m_MasterSlave = I2C_MODE_SMBUSDEVICE;    //SMBusѡӻģʽ
	newStruct_I2C.m_BaudRateL = 12;                       //I2Cʵ͵ƽʱ   ֵ С3
	newStruct_I2C.m_BaudRateH = 12;                       //I2Cʸߵƽʱ   ֵ С3
	newStruct_I2C.m_AckEn = TRUE;                         //ʹӦ
	newStruct_I2C.m_AckData = I2C_ACKDATA_ACK;            //ѡӦźΪACK
	I2C_Configuration(I2Cx, &newStruct_I2C);

	I2C_ADDR_Config(I2Cx,0,I2C_ADDRESS);   //ôӻI2Cַ0
	I2C_ADDR_Config(I2Cx,1,I2C_ADDRESS);   //ôӻI2Cַ1
	I2C_ADDR_Config(I2Cx,2,I2C_ADDRESS);   //ôӻI2Cַ2
	I2C_ADDR_Config(I2Cx,3,I2C_ADDRESS);   //ôӻI2Cַ3
	I2C_MSK_Config (I2Cx,0,0x0000);        //I2Cַλ


//	I2C_Cmd(I2Cx,TRUE);                    //ʹI2Cģ
	I2C_Clear_INTERRUPT_Flag(I2Cx);        //I2Cжϱ־λ

	I2C_MATCH_ADDRESS_Config(I2Cx,TRUE);   //ʹI2Cַƥ
//	I2C_ISIE_INT_Enable(I2Cx, TRUE);       //ʹI2Cж
	I2C_Cmd(I2Cx,TRUE);                    //ʹI2Cģ

}


/**
  *    I2Cx ʼ
  *    I2CxȡֵΧI2C0_SFR~I2C1_SFR   ѡõI2C
  *
  *    
*/
void I2C_init_Master(I2C_SFRmap* I2Cx)
{
	/*I2CxӦò*/
	I2C_Reset(I2Cx);                                      //I2CλʹI2Cʱ
	I2C_InitTypeDef newStruct_I2C;                        //
	newStruct_I2C.m_Mode = I2C_MODE_I2C;                  //ΪI2Cģʽ
	newStruct_I2C.m_ClockSource = I2C_CLK_SCLK;           //ʱԴѡSCLK 48M
#if	IIC_10BIT_Address
	newStruct_I2C.m_BADR10 = I2C_BUFRADDRESS_10BIT;       //10λӻַ
#else
	newStruct_I2C.m_BADR10 = I2C_BUFRADDRESS_7BIT;        //7λӻַ
#endif
	newStruct_I2C.m_MasterSlave = I2C_MODE_SMBUSHOST;     // SMBusѡģʽ
    //ʱԴΪ48MһμʱΪ1/48=0.02084 us ʵĸߵ͵ƽʱ趨ֵ X0.02084usʱ趨ֵҪֵ С
#ifdef IIC_100K
	newStruct_I2C.m_BaudRateL = 226;                       //I2Cʵ͵ƽʱ   ֵ С3
	newStruct_I2C.m_BaudRateH = 226;                       //I2Cʸߵƽʱ   ֵ С3
#elif defined IIC_400K
	newStruct_I2C.m_BaudRateL = 47;                       //I2Cʵ͵ƽʱ   ֵ С3
	newStruct_I2C.m_BaudRateH = 47;                       //I2Cʸߵƽʱ   ֵ С3
#elif defined IIC_1M
	newStruct_I2C.m_BaudRateL = 12;                       //I2Cʵ͵ƽʱ   ֵ С3
	newStruct_I2C.m_BaudRateH = 12;                       //I2Cʸߵƽʱ   ֵ С3
#endif
	newStruct_I2C.m_AckEn = TRUE;                         //ʹӦ
	newStruct_I2C.m_AckData = I2C_ACKDATA_ACK;            //ѡӦźΪACK
	I2C_Configuration(I2Cx, &newStruct_I2C);



	I2C_Cmd(I2Cx,TRUE);                    //ʹI2Cģ
	I2C_Clear_INTERRUPT_Flag(I2Cx);        //I2Cжϱ־λ

	I2C_MATCH_ADDRESS_Config(I2Cx,TRUE);   //ʹI2Cַƥ
	I2C_ISIE_INT_Enable(I2Cx, TRUE);       //ʹI2Cж
	I2C_Cmd(I2Cx,TRUE);                    //ʹI2Cģ                 //ʹI2Cģ


}




/**
  *    I2C дһֽ
  *     Write_addressҪдָļĴַ
  *        I2C_data: дݼĴֵȡֵΪ10λݡ
  *    
*/
void I2C_Byte_Write(uint16_t Write_i2c_Addr,uint32_t I2C_data)
{
	I2C_Choose=I2C1_SFR; //ѡI2C0_SFR I2C1_SFR

	static uint8_t I2C_SLAVE_ADDRESS10BH=0;
	static uint8_t I2C_SLAVE_ADDRESS10BL=0;


	//
	/*ʹģ*/
	I2C_Cmd(I2C_Choose,TRUE);
	I2C_Clear_INTERRUPT_Flag(I2C_Choose);       //I2Cжϱ־λISIFλ


	/*ʼλ*/
	I2C_Generate_START(I2C_Choose,TRUE);          //ʹʼź
	while(!I2C_Get_INTERRUPT_Flag(I2C_Choose));   //ȴʼźȶ

#if IIC_10BIT_Address

	I2C_SLAVE_ADDRESS10BL=Write_i2c_Addr& 0xff;       //8λĴַ
	I2C_SLAVE_ADDRESS10BH=(Write_i2c_Addr>>8)& 0xff;  //8λĴַ
	/*ʹӻ10λλַ*/
	I2C_SendData(I2C_Choose,I2C_SLAVE_ADDRESS10BH); //ʹӻַ  I2C_SLAVE_ADDRESS10BH
	I2C_Clear_INTERRUPT_Flag(I2C_Choose);        //I2Cжϱ־λISIFλ
	while(!I2C_Get_INTERRUPT_Flag(I2C_Choose));  //ȴ

	/*ʹӻ10λλַ*/
	I2C_SendData(I2C_Choose,I2C_SLAVE_ADDRESS10BL); //ʹӻַ  I2C_SLAVE_ADDRESS10BL
	I2C_Clear_INTERRUPT_Flag(I2C_Choose);        //I2Cжϱ־λISIFλ
	while(!I2C_Get_INTERRUPT_Flag(I2C_Choose));  //ȴ
	while(I2C_Get_Ack_Fail_Flag(I2C_Choose));    //жǷACKӦûֹͣ

#else
	/*7λӻַ*/
	I2C_SendData8(I2C_Choose,Write_i2c_Addr); //ʹӻַ  I2C_SLAVE_ADDRESS10BH_W
	I2C_Clear_INTERRUPT_Flag(I2C_Choose);        //I2Cжϱ־λISIFλ
	while(!I2C_Get_INTERRUPT_Flag(I2C_Choose));  //ȴ
	while(I2C_Get_Ack_Fail_Flag(I2C_Choose));    //жǷACKӦûֹͣ
#endif


	/**/
	I2C_SendData(I2C_Choose,I2C_data);           //
	I2C_Clear_INTERRUPT_Flag(I2C_Choose);        //I2Cжϱ־λISIFλ
	while(!I2C_Get_INTERRUPT_Flag(I2C_Choose));  //ȴ


	/*ֹͣλ*/
	I2C_Generate_STOP(I2C_Choose,TRUE);         //ʹֹͣź

	I2C_Clear_INTERRUPT_Flag(I2C_Choose);       //I2Cжϱ־λISIFλ
	while(!I2C_Get_INTERRUPT_Flag(I2C_Choose)); //ȴֹͣ

	I2C_Clear_INTERRUPT_Flag(I2C_Choose);       //I2Cжϱ־λISIFλ
	I2C_Clear_Stop_Flag(I2C_Choose);            //I2Cֹͣ־λPIFλ
	I2C_Cmd(I2C_Choose,FALSE);                  //رI2Cģ

}



/**
  *    I2C дֽ
  *    Write_i2c_AddrҪдָI2Cַ
  *          p_buffer: дݵַָ
  *          number_of_byteдݸ
  *    
*/
void I2C_Buffer_write(uint16_t Write_i2c_Addr,uint8_t *p_buffer,uint16_t number_of_byte)
{

	I2C_Choose=I2C1_SFR;//ѡI2C0_SFR I2C1_SFR


	I2C_Clear_INTERRUPT_Flag(I2C_Choose);   //I2Cжϱ־λISIFλ
	I2C_Cmd(I2C_Choose,TRUE);               //ʹI2Cģ
	/*ʼλ*/
	I2C_Generate_START(I2C_Choose,TRUE);    //ʹʼź
	while(!I2C_Get_INTERRUPT_Flag(I2C_Choose)); //ȴʼźȶ


#if IIC_10BIT_Address
	static uint8_t I2C_SLAVE_ADDRESS10BH=0;
	static uint8_t I2C_SLAVE_ADDRESS10BL=0;
	I2C_SLAVE_ADDRESS10BL=Write_i2c_Addr& 0xff;       //8λI2Cַ
	I2C_SLAVE_ADDRESS10BH=(Write_i2c_Addr>>8)& 0xff;  //8λI2Cַ


	/*ʹӻ10λλַ*/
	I2C_SendData(I2C_Choose,I2C_SLAVE_ADDRESS10BH); //ʹӻַ  I2C_SLAVE_ADDRESS10BH_W
	I2C_Clear_INTERRUPT_Flag(I2C_Choose);        //I2Cжϱ־λISIFλ
	while(!I2C_Get_INTERRUPT_Flag(I2C_Choose));  //ȴ

	/*ʹӻ10λλַ*/
	I2C_SendData(I2C_Choose,I2C_SLAVE_ADDRESS10BL); //ʹӻַ  I2C_SLAVE_ADDRESS10BH_W
	I2C_Clear_INTERRUPT_Flag(I2C_Choose);        //I2Cжϱ־λISIFλ
	while(!I2C_Get_INTERRUPT_Flag(I2C_Choose));  //ȴ
	while(I2C_Get_Ack_Fail_Flag(I2C_Choose));    //жǷACKӦûֹͣ


#else
	/*7λӻַ*/
	I2C_SendData8(I2C_Choose,Write_i2c_Addr); //ʹӻַ  I2C_SLAVE_ADDRESS10BH_W
	I2C_Clear_INTERRUPT_Flag(I2C_Choose);        //I2Cжϱ־λISIFλ
	while(!I2C_Get_INTERRUPT_Flag(I2C_Choose));  //ȴ
	while(I2C_Get_Ack_Fail_Flag(I2C_Choose));    //жǷACKӦûֹͣ
#endif


    /*ѭд */
    while(number_of_byte--){
    	I2C_SendData8(I2C_Choose, *p_buffer);    //
    	I2C_Clear_INTERRUPT_Flag(I2C_Choose);     	//I2Cжϱ־λISIFλ
        /* ָһҪдֽ*/
        p_buffer++;
        while(!I2C_Get_INTERRUPT_Flag(I2C_Choose));//ȴȡBuffISIF1
    }


	/*ֹͣλ*/
	I2C_Generate_STOP(I2C_Choose,TRUE);         //ʹֹͣź

	I2C_Clear_INTERRUPT_Flag(I2C_Choose);       //I2Cжϱ־λISIFλ
	while(!I2C_Get_INTERRUPT_Flag(I2C_Choose)); //ȴֹͣ

	I2C_Clear_INTERRUPT_Flag(I2C_Choose);       //I2Cжϱ־λISIFλ
	I2C_Clear_Stop_Flag(I2C_Choose);            //I2Cֹͣ־λPIFλ
	I2C_Cmd(I2C_Choose,FALSE);                  //رI2Cģ

}

/**
  *    I2C  һֽ
  *     Read_I2C_AddrָҪI2Cַ
  *          p_buffer: ݵַָ
  *          number_of_byteȡݸ
  *    
*/
void I2C_byte_read(uint16_t Read_i2c_Addr,uint32_t I2C_data,uint16_t number_of_byte)
{


	I2C_Choose=I2C1_SFR;  //ѡI2C0_SFR I2C1_SFR
	static uint8_t I2C_SLAVE_ADDRESS10BH=0;
	static uint8_t I2C_SLAVE_ADDRESS10BL=0;

	I2C_Cmd(I2C_Choose,TRUE);               //ʹI2Cģ
	/*ʼλ*/
	I2C_Generate_START(I2C_Choose,TRUE);    //ʹʼź
	while(!I2C_Get_Start_Flag(I2C_Choose)); //ȴʼźȶ


#if IIC_10BIT_Address
	I2C_SLAVE_ADDRESS10BL=Read_i2c_Addr& 0xff;       //8λĴַ
	I2C_SLAVE_ADDRESS10BH=(Read_i2c_Addr>>8)& 0xff;  //8λĴַ
	/*ʹӻ10λλַ*/
	I2C_SendData(I2C_Choose,I2C_SLAVE_ADDRESS10BH|0x01); //ʹӻַ  I2C_SLAVE_ADDRESS10BH_W
	I2C_Clear_INTERRUPT_Flag(I2C_Choose);        //I2Cжϱ־λISIFλ
	while(!I2C_Get_INTERRUPT_Flag(I2C_Choose));  //ȴ

	/*ʹӻ10λλַ*/
	I2C_SendData(I2C_Choose,I2C_SLAVE_ADDRESS10BL); //ʹӻַ  I2C_SLAVE_ADDRESS10BH_W
	I2C_Clear_INTERRUPT_Flag(I2C_Choose);        //I2Cжϱ־λISIFλ
	while(!I2C_Get_INTERRUPT_Flag(I2C_Choose));  //ȴ
	while(I2C_Get_Ack_Fail_Flag(I2C_Choose));    //жǷACKӦûֹͣ

#else
	/*7λӻַ*/
	I2C_SendData(I2C_Choose,Read_i2c_Addr|0x01); //ʹӻַ  Read_i2c_Addr
	I2C_Clear_INTERRUPT_Flag(I2C_Choose);        //I2Cжϱ־λISIFλ
	while(!I2C_Get_INTERRUPT_Flag(I2C_Choose));  //ȴ
	while(I2C_Get_Ack_Fail_Flag(I2C_Choose));    //жǷACKӦûֹͣ
#endif

	I2C_Clear_INTERRUPT_Flag(I2C_Choose);           //Ȼ־λISIFλ

	/* I2Cȡһ*/
	I2C_data = I2C_ReceiveData(I2C_Choose);
	while(!I2C_Get_INTERRUPT_Flag(I2C_Choose));  //ȴȡBuffISIF1
	I2C_Clear_INTERRUPT_Flag(I2C_Choose);        //Ȼ־λISIFλ
	I2C_Ack_DATA_Config(I2C_Choose,I2C_ACKDATA_ACK);//ݺظACK



	/*ֹͣλ*/
	I2C_Generate_STOP(I2C_Choose,TRUE);         //ʹֹͣź

	I2C_Clear_INTERRUPT_Flag(I2C_Choose);       //I2Cжϱ־λISIFλ
	while(!I2C_Get_INTERRUPT_Flag(I2C_Choose)); //ȴֹͣ

	I2C_Clear_INTERRUPT_Flag(I2C_Choose);       //I2Cжϱ־λISIFλ
	I2C_Clear_Stop_Flag(I2C_Choose);            //I2Cֹͣ־λPIFλ
	I2C_Cmd(I2C_Choose,FALSE);                  //رI2Cģ

}
/**
  *    I2C ֽ
  *    Read_I2C_AddrָҪI2Cַ
  *          p_buffer: ݵַָ
  *          number_of_byteȡݸ
  *    
  *
*/
void I2C_Buffer_read(uint16_t Read_I2C_Addr,uint8_t *p_buffer,uint16_t number_of_byte)
{


	I2C_Choose=I2C1_SFR; //ѡI2C0_SFR I2C1_SFR
	static uint8_t I2C_SLAVE_ADDRESS10BH=0;
	static uint8_t I2C_SLAVE_ADDRESS10BL=0;

	I2C_Cmd(I2C_Choose,TRUE);//I2C
	/*ʼλ*/
	I2C_Clear_INTERRUPT_Flag(I2C_Choose);  //־λISIFλ
	I2C_Generate_START(I2C_Choose,TRUE);   //ʼź
	while(!I2C_Get_INTERRUPT_Flag(I2C_Choose));//ȴʼλȶ

#if IIC_10BIT_Address
	I2C_SLAVE_ADDRESS10BL=Read_I2C_Addr& 0xff;       //8λĴַ
	I2C_SLAVE_ADDRESS10BH=(Read_I2C_Addr>>8)& 0xff;  //8λĴַ
	/*ʹӻ10λλַ*/
	I2C_SendData(I2C_Choose,I2C_SLAVE_ADDRESS10BH|0x01); //ʹӻַ  I2C_SLAVE_ADDRESS10BH_W
	I2C_Clear_INTERRUPT_Flag(I2C_Choose);        //I2Cжϱ־λISIFλ
	while(!I2C_Get_INTERRUPT_Flag(I2C_Choose));  //ȴ

	/*ʹӻ10λλַ*/
	I2C_SendData(I2C_Choose,I2C_SLAVE_ADDRESS10BL); //ʹӻַ  I2C_SLAVE_ADDRESS10BH_W
	I2C_Clear_INTERRUPT_Flag(I2C_Choose);        //I2Cжϱ־λISIFλ
	while(!I2C_Get_INTERRUPT_Flag(I2C_Choose));  //ȴ
	while(I2C_Get_Ack_Fail_Flag(I2C_Choose));    //жǷACKӦûֹͣ

#else
	/*7λӻַ*/
	I2C_SendData(I2C_Choose,Read_I2C_Addr|0x01); //ʹӻַ  Read_i2c_Addr
	I2C_Clear_INTERRUPT_Flag(I2C_Choose);        //I2Cжϱ־λISIFλ
	while(!I2C_Get_INTERRUPT_Flag(I2C_Choose));  //ȴ
	while(I2C_Get_Ack_Fail_Flag(I2C_Choose));    //жǷACKӦûֹͣ
#endif



	/*Ͷָ*/
	I2C_SendData8(I2C_Choose,Read_I2C_Addr);//ʹӻַ
	I2C_Clear_INTERRUPT_Flag(I2C_Choose);           //־λISIFλ

	while(!I2C_Get_INTERRUPT_Flag(I2C_Choose));     //ȴISIF1
	I2C_Clear_INTERRUPT_Flag(I2C_Choose);           //Ȼ־λISIFλ

	while(number_of_byte)
	{

		while(!I2C_Get_INTERRUPT_Flag(I2C_Choose));  //ȴȡBuffISIF1
		if(I2C_Get_Receive_Buff_Flag(I2C_Choose))     //жBuffǷΪ
		{
			I2C_Ack_DATA_Config(I2C_Choose,I2C_ACKDATA_ACK);//ظACK
			*p_buffer = I2C_ReceiveData(I2C_Choose);
			 I2C_Clear_INTERRUPT_Flag(I2C_Choose);        //Ȼ־λISIFλ
			 p_buffer++;      /* ָһȡֽڽλ */
		}

            /* ݼȡֽڼ */
           number_of_byte--;

	}


	/*ֹͣλ*/
	I2C_Generate_STOP(I2C_Choose,TRUE);         //ʹֹͣź

	I2C_Clear_INTERRUPT_Flag(I2C_Choose);       //I2Cжϱ־λISIFλ
	while(!I2C_Get_INTERRUPT_Flag(I2C_Choose)); //ȴֹͣ

	I2C_Clear_INTERRUPT_Flag(I2C_Choose);       //I2Cжϱ־λISIFλ
	I2C_Clear_Stop_Flag(I2C_Choose);            //I2Cֹͣ־λPIFλ
	I2C_Cmd(I2C_Choose,FALSE);                  //رI2Cģ

}
