/****************************************************************************************
  *
  * ļ  main.c
  *     ChipON_AE/FAE_Group
  *     2019-11-16
  *     ļṩGPIOӦ̲ο
  *
 ****************************************************************************************/
#include "system_init.h"

#define    USERKEY    GPIO_Read_Input_Data_Bit(GPIOH_SFR,GPIO_PIN_MASK_14)  //ȡPH14ƽ
//ʱ ֲvolatileܻᱻŻ

void delay_ms(volatile uint32_t nms)
{
	volatile uint32_t i,j;
	for(i=0;i<nms;i++)
	{
		j=2000;
		while(j--);
	}

}


/**
  *   GPIOx ʼá
  *  : GPIOx: ָGPIOڴṹָ룬ȡֵΪGPIOA_SFR~GPIOH_SFR
  *       GpioPin: ˿룬ȡֵΪGPIO_PIN_MASK_0~GPIO_PIN_MASK_15еһϡ
  *   ޡ
  */
void GPIOInit_Output_Config(GPIO_SFRmap* GPIOx,uint16_t GpioPin)
{
	/*ʼλGPIOx裬ʹGPIOxʱ*/
		GPIO_Reset(GPIOx);

	/*  PxyΪģʽ */
	GPIO_InitTypeDef GPIO_InitStructure;
	GPIO_Struct_Init(&GPIO_InitStructure);
	GPIO_InitStructure.m_Pin = GpioPin;
	GPIO_InitStructure.m_Speed = GPIO_LOW_SPEED;          //ʼ GPIOٶ
	GPIO_InitStructure.m_Mode = GPIO_MODE_OUT;            //ʼ GPIOΪ
	GPIO_InitStructure.m_PullUp = GPIO_NOPULL;            //ʼ GPIOǷ
	GPIO_InitStructure.m_PullDown = GPIO_NOPULL;          //ʼ GPIOǷ
	GPIO_Configuration(GPIOx,&GPIO_InitStructure);

	GPIO_Set_Output_Data_Bits(GPIOx,GpioPin,Bit_SET);					//Ϊߵƽ

}

/**
  *   GPIOx ʼá
  *  : GPIOx: ָGPIOڴṹָ룬ȡֵΪGPIOA_SFR~GPIOH_SFR
  *       GpioPin: ˿룬ȡֵΪGPIO_PIN_MASK_0~GPIO_PIN_MASK_15еһϡ
  *   ޡ
  */
void GPIOInit_Input_Config(GPIO_SFRmap* GPIOx,uint16_t GpioPin)
{
	/*ʼλGPIOx裬ʹGPIOxʱ*/
		GPIO_Reset(GPIOx);

	/*  PxyΪģʽ */
	GPIO_InitTypeDef GPIO_InitStructure;
	GPIO_Struct_Init(&GPIO_InitStructure);
	GPIO_InitStructure.m_Pin = GpioPin;
	GPIO_InitStructure.m_Speed = GPIO_LOW_SPEED;                   //ʼ GPIOٶ
	GPIO_InitStructure.m_Mode = GPIO_MODE_IN;                      //ʼ GPIOΪ
	GPIO_InitStructure.m_PullUp = GPIO_NOPULL;                     //ʼ GPIOǷ 
	GPIO_InitStructure.m_PullDown = GPIO_PULLUP;                   //ʼ GPIOǷ 
	GPIO_Configuration(GPIOx,&GPIO_InitStructure);
}


/**
  *   GPIOx ʼá
  *  : 
  *   ޡ
  */
void GPIO_Init(void)
{
	GPIOInit_Input_Config(GPIOH_SFR,GPIO_PIN_MASK_14);//PH14Ϊģʽ
	GPIOInit_Output_Config(GPIOF_SFR,GPIO_PIN_MASK_0);  //PF0ʼߵƽ
}

//
void main()
{
	/*ûɲοKF32LS200_demoʵGPIOùܡ
	 * ʹGPIO PH14ΪIO PF0Ϊ
	 * USER KEY£STATUSϨٴΰSTATUSƵ
	 */

	//ϵͳʱ48M,Ƶʱ16M
	SystemInit();//ϵͳʱӳʼ

	//GPIOʼ
	GPIO_Init();   //PH14Ϊģʽ  PF0ʼߵƽ

	while(1)
	{
        if(USERKEY)
        {
        	delay_ms(10);   //ʱ10ms
        	if(USERKEY)        //а
        	{
        		GPIO_Toggle_Output_Data_Config (GPIOF_SFR,GPIO_PIN_MASK_0);//PF0ת,STATUSϨ
        	}

        }

	}
}


/**
  *    У鷢ļ
  *    file: ָļƵָ
  *      line У
  *   ޡ
  */
void check_failed(uint8_t* file, uint32_t line)
{
	  /* ûԼĴʵֱļк,
	             : printf("Wrong parameters value: file %s on line %d\r\n", file, line) */

	  while(1)
	  {
		  ;
	  }
}
