/****************************************************************************************
  *
  * ļ  main.c
  *     ChipON_AE/FAE_Group
  *     2019-11-16
  *     ļṩCCP PWMӦ̲ο
  *
 ****************************************************************************************/
#include "system_init.h"

#define					PWM_Edge_Out				0	//ضPWMź
#define					PWM_Center_Out 			    1	//ĶPWMź

#define					CCP_PWM_WORK			PWM_Edge_Out	//  ѡPWMģʽ  0ضPWMź    1ĶPWMź




/**
  *   CCPx PWMGPIOӳá
  *  : GPIOx: ָGPIOڴṹָ룬ȡֵΪGPIOA_SFR~GPIOH_SFR
  *     GpioPin: ˿룬ȡֵΪGPIO_PIN_MASK_0~GPIO_PIN_MASK_15еһϡ
  *    PinRemap: ӳѡ
  *   ޡ
  */
void CCPx_PWM_GPIO_Init(GPIO_SFRmap* GPIOx,uint16_t GpioPin,uint8_t PinRemap)													//CCP0 PWMģʽ
{
	 static uint16_t GpioPinNum;

	GPIO_Write_Mode_Bits(GPIOx,GpioPin,GPIO_MODE_RMP);

	if(GpioPin==GPIO_PIN_MASK_0)
	{
		GpioPinNum =GPIO_Pin_Num_0;
	}else if(GpioPin==GPIO_PIN_MASK_1)
	{
		GpioPinNum =GPIO_Pin_Num_1;
	}else if(GpioPin==GPIO_PIN_MASK_2)
	{
		GpioPinNum =GPIO_Pin_Num_2;
	}else if(GpioPin==GPIO_PIN_MASK_3)
	{
		GpioPinNum =GPIO_Pin_Num_3;
	}else if(GpioPin==GPIO_PIN_MASK_4)
	{
		GpioPinNum =GPIO_Pin_Num_4;
	}else if(GpioPin==GPIO_PIN_MASK_5)
	{
		GpioPinNum =GPIO_Pin_Num_5;
	}else if(GpioPin==GPIO_PIN_MASK_6)
	{
		GpioPinNum =GPIO_Pin_Num_6;
	}else if(GpioPin==GPIO_PIN_MASK_7)
	{
		GpioPinNum =GPIO_Pin_Num_7;
	}else if(GpioPin==GPIO_PIN_MASK_8)
	{
		GpioPinNum =GPIO_Pin_Num_8;
	}else if(GpioPin==GPIO_PIN_MASK_9)
	{
		GpioPinNum =GPIO_Pin_Num_9;
	}else if(GpioPin==GPIO_PIN_MASK_10)
	{
		GpioPinNum =GPIO_Pin_Num_10;
	}else if(GpioPin==GPIO_PIN_MASK_11)
	{
		GpioPinNum =GPIO_Pin_Num_11;
	}else if(GpioPin==GPIO_PIN_MASK_12)
	{
		GpioPinNum =GPIO_Pin_Num_12;
	}else if(GpioPin==GPIO_PIN_MASK_13)
	{
		GpioPinNum =GPIO_Pin_Num_13;
	}else if(GpioPin==GPIO_PIN_MASK_14)
	{
		GpioPinNum =GPIO_Pin_Num_14;
	}else if(GpioPin==GPIO_PIN_MASK_15)
	{
		GpioPinNum =GPIO_Pin_Num_15;
	}

	GPIO_Pin_RMP_Config(GPIOx,GpioPinNum,PinRemap);     //ӳ书


}




/**
  *   CCPx PWM·ͬڲͬռձȵĹܺ
  *  : CCPx: ָCCPͨöʱڴṹָ룬
  *               ȡֵCCP0_SFR/CCP1_SFR/CCP2_SFR/CCP3_SFR/CCP4_SFR/
  *
  *
  *   ޡ
  */
void CCPx_FOUR_PWM(CCP_SFRmap* CCPx)
{

	TIM_Reset(CCPx);//ʱ踴λʹʱ

	CCP_PWM_Mode_Config(CCPx,CCP_CHANNEL_1,CCP_PWM_MODE);								//CCP PWMͨģʽ
	CCP_PWM_Mode_Config(CCPx,CCP_CHANNEL_2,CCP_PWM_MODE);								//CCP PWMͨģʽ
	CCP_PWM_Mode_Config(CCPx,CCP_CHANNEL_3,CCP_PWM_MODE);								//CCP PWMͨģʽ
	CCP_PWM_Mode_Config(CCPx,CCP_CHANNEL_4,CCP_PWM_MODE);								//CCP PWMͨģʽ
	CCP_Channel_Output_Control(CCPx,CCP_CHANNEL_1,CCP_CHANNEL_OUTPUT_PWM_ACTIVE);		//CCPͨPWMЧ
	CCP_Channel_Output_Control(CCPx,CCP_CHANNEL_2,CCP_CHANNEL_OUTPUT_PWM_ACTIVE);		//CCPͨPWMЧ
	CCP_Channel_Output_Control(CCPx,CCP_CHANNEL_3,CCP_CHANNEL_OUTPUT_PWM_ACTIVE);		//CCPͨPWMЧ
	CCP_Channel_Output_Control(CCPx,CCP_CHANNEL_4,CCP_CHANNEL_OUTPUT_PWM_ACTIVE);		//CCPͨPWMЧ
	CCP_Set_Compare_Result(CCPx,CCP_CHANNEL_1,0x1FFF);									//CHANNEL_1 PWMռձ
	CCP_Set_Compare_Result(CCPx,CCP_CHANNEL_2,0x3FFF);									//CHANNEL_2 PWMռձ
	CCP_Set_Compare_Result(CCPx,CCP_CHANNEL_3,0x7FFF);									//CHANNEL_3 PWMռձ
	CCP_Set_Compare_Result(CCPx,CCP_CHANNEL_4,0xAFFF);									//CHANNEL_4 PWMռձ


	GPTIM_Updata_Immediately_Config(CCPx,TRUE);									//¿
	GPTIM_Updata_Enable(CCPx,TRUE);												//øʹ
	GPTIM_Work_Mode_Config(CCPx,GPTIM_TIMER_MODE);								//ʱģʽѡ
	GPTIM_Set_Counter(CCPx,0);													//ʱֵ
	GPTIM_Set_Period(CCPx,0xFFFF);											    //ʱֵ
	GPTIM_Set_Prescaler(CCPx,47);											   //ʱԤƵֵ
#if		CCP_PWM_WORK==PWM_Edge_Out
	GPTIM_Counter_Mode_Config(CCPx,GPTIM_COUNT_UP_OF);						   //ϼģʽ,ضPWMź
#else
	GPTIM_Counter_Mode_Config(CCPx,GPTIM_COUNT_UP_DOWN_OF);					   //ϡ¼ģʽ,ĶPWMź
#endif

	GPTIM_Clock_Config(CCPx,GPTIM_SCLK);										//ѡSCLKʱ
	GPTIM_Cmd(CCPx,TRUE);                                                       //ʱʹ
}

/**
  *   CCPx PWMܳʼ
  *  : CCPx: ָCCPͨöʱڴṹָ룬
  *               ȡֵCCP0_SFR/CCP1_SFR/CCP2_SFR/CCP3_SFR/CCP4_SFR/
  *
  *    Channel:  CCP_CHANNEL_1: ͨ1
  *              CCP_CHANNEL_2: ͨ2
  *              CCP_CHANNEL_3: ͨ3
  *              CCP_CHANNEL_4: ͨ4
  *      Period ֵ16λ
  *        Duty ռձȣ16λ
  *
  *   ޡ
  */
void CCPx_PWM_PPX_Duty(CCP_SFRmap* CCPx, uint32_t Channel,uint16_t Period,uint16_t Duty)
{

	TIM_Reset(CCPx);//ʱ踴λʹʱ

	CCP_PWM_Mode_Config(CCPx,Channel,CCP_PWM_MODE);								//CCP PWMͨģʽ
	CCP_Channel_Output_Control(CCPx,Channel,CCP_CHANNEL_OUTPUT_PWM_ACTIVE);		//CCPͨPWMЧ
	CCP_Set_Compare_Result(CCPx,Channel,Duty);									//PWMռձ


	GPTIM_Updata_Immediately_Config(CCPx,TRUE);									//¿
	GPTIM_Updata_Enable(CCPx,TRUE);												//øʹ
	GPTIM_Work_Mode_Config(CCPx,GPTIM_TIMER_MODE);								//ʱģʽѡ
	GPTIM_Set_Counter(CCPx,0);													//ʱֵ
	GPTIM_Set_Period(CCPx,Period);											    //ʱֵPeriod
	GPTIM_Set_Prescaler(CCPx,47);											   //ʱԤƵֵ
#if		CCP_PWM_WORK==PWM_Edge_Out
	GPTIM_Counter_Mode_Config(CCPx,GPTIM_COUNT_UP_OF);						   //ϼģʽ,ضPWMź
#else
	GPTIM_Counter_Mode_Config(CCPx,GPTIM_COUNT_UP_DOWN_OF);					   //ϡ¼ģʽ,ĶPWMź
#endif

	GPTIM_Clock_Config(CCPx,GPTIM_SCLK);										//ѡSCLKʱ
	GPTIM_Cmd(CCPx,TRUE);                                                       //ʱʹ
}




//
void main()
{
	/*ûɲοKF32LS200_demoʵPWMģʽùܡ
	    1CCP1  ĸͨ    ͬƵʲͬռձȵPWMPF0 PB1 PB2 PB3, STATUS15HZƵ˸
	    2CCP2  ͨ2 1KHZ ռձΪ50% PWMPH12

	    CCP_PWM_WORK    궨ѡ񣺱ضģʽĶģʽ
	    ʾԲPH12Ϊ1KHZҵPWM,
	                      PF0Ϊ15HZPWM,ռձΪ12.5%
	                      PB1Ϊ15HZPWM,ռձΪ25%
	                      PB2Ϊ15HZPWM,ռձΪ50%
	                      PB3Ϊ15HZPWM,ռձΪ68.7%
	 */

	//ϵͳʱ48M,Ƶʱ16M
	SystemInit();

	CCPx_PWM_GPIO_Init(GPIOF_SFR,GPIO_PIN_MASK_0,GPIO_RMP_AF1_T1); //CCP1   PF0ӳΪPWM
	CCPx_PWM_GPIO_Init(GPIOB_SFR,GPIO_PIN_MASK_1,GPIO_RMP_AF1_T1); //CCP1   PB1ӳΪPWM
	CCPx_PWM_GPIO_Init(GPIOB_SFR,GPIO_PIN_MASK_2,GPIO_RMP_AF1_T1); //CCP1   PB2ӳΪPWM
	CCPx_PWM_GPIO_Init(GPIOB_SFR,GPIO_PIN_MASK_3,GPIO_RMP_AF1_T1); //CCP1   PB3ӳΪPWM
	CCPx_PWM_GPIO_Init(GPIOH_SFR,GPIO_PIN_MASK_12,GPIO_RMP_AF1_T2); //CCP2   PH12ӳΪPWM

	CCPx_FOUR_PWM(CCP1_SFR); //CCP1    ĸͨ    ͬƵʲͬռձȵPWM  15HZ PWM

	CCPx_PWM_PPX_Duty(CCP2_SFR,CCP_CHANNEL_2,1000,500);       //CCP2   ͨ2 1KHZ ռձΪ50% PWM
	while(1)
    {
    }
}



/**
  *    У鷢ļ
  *    file: ָļƵָ
  *      line У
  *   ޡ
  */
void check_failed(uint8_t* file, uint32_t line)
{
	  /* ûԼĴʵֱļк,
	             : printf("Wrong parameters value: file %s on line %d\r\n", file, line) */

	  while(1)
	  {
		  ;
	  }
}

